/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.syncStorage;

import java.util.Optional;
import java.util.UUID;
import okio.ByteString;
import org.asamk.signal.manager.api.PhoneNumberSharingMode;
import org.asamk.signal.manager.api.TrustLevel;
import org.asamk.signal.manager.storage.configuration.ConfigurationStore;
import org.asamk.signal.manager.storage.groups.GroupInfoV1;
import org.asamk.signal.manager.storage.groups.GroupInfoV2;
import org.asamk.signal.manager.storage.identities.IdentityInfo;
import org.asamk.signal.manager.storage.recipients.Recipient;
import org.asamk.signal.manager.storage.recipients.RecipientAddress;
import org.whispersystems.signalservice.api.push.ServiceId;
import org.whispersystems.signalservice.api.push.UsernameLinkComponents;
import org.whispersystems.signalservice.api.storage.SignalAccountRecord;
import org.whispersystems.signalservice.api.storage.SignalContactRecord;
import org.whispersystems.signalservice.api.storage.SignalGroupV1Record;
import org.whispersystems.signalservice.api.storage.SignalGroupV2Record;
import org.whispersystems.signalservice.api.storage.SignalStorageRecord;
import org.whispersystems.signalservice.api.util.UuidUtil;
import org.whispersystems.signalservice.internal.storage.protos.AccountRecord;
import org.whispersystems.signalservice.internal.storage.protos.ContactRecord;

public final class StorageSyncModels {
    private StorageSyncModels() {
    }

    public static AccountRecord.PhoneNumberSharingMode localToRemote(PhoneNumberSharingMode phoneNumberPhoneNumberSharingMode) {
        return switch (phoneNumberPhoneNumberSharingMode) {
            default -> throw new MatchException(null, null);
            case PhoneNumberSharingMode.EVERYBODY -> AccountRecord.PhoneNumberSharingMode.EVERYBODY;
            case PhoneNumberSharingMode.CONTACTS, PhoneNumberSharingMode.NOBODY -> AccountRecord.PhoneNumberSharingMode.NOBODY;
        };
    }

    public static PhoneNumberSharingMode remoteToLocal(AccountRecord.PhoneNumberSharingMode phoneNumberPhoneNumberSharingMode) {
        return switch (phoneNumberPhoneNumberSharingMode) {
            default -> throw new MatchException(null, null);
            case AccountRecord.PhoneNumberSharingMode.EVERYBODY -> PhoneNumberSharingMode.EVERYBODY;
            case AccountRecord.PhoneNumberSharingMode.NOBODY -> PhoneNumberSharingMode.NOBODY;
            case AccountRecord.PhoneNumberSharingMode.UNKNOWN -> null;
        };
    }

    public static SignalStorageRecord localToRemoteRecord(ConfigurationStore configStore, Recipient self, UsernameLinkComponents usernameLinkComponents, byte[] rawStorageId) {
        SignalAccountRecord.Builder builder = new SignalAccountRecord.Builder(rawStorageId, self.getStorageRecord());
        if (self.getProfileKey() != null) {
            builder.setProfileKey(self.getProfileKey().serialize());
        }
        if (self.getProfile() != null) {
            builder.setGivenName(self.getProfile().getGivenName()).setFamilyName(self.getProfile().getFamilyName()).setAvatarUrlPath(self.getProfile().getAvatarUrlPath());
        }
        builder.setTypingIndicatorsEnabled(Optional.ofNullable(configStore.getTypingIndicators()).orElse(true).booleanValue()).setReadReceiptsEnabled(Optional.ofNullable(configStore.getReadReceipts()).orElse(true).booleanValue()).setSealedSenderIndicatorsEnabled(Optional.ofNullable(configStore.getUnidentifiedDeliveryIndicators()).orElse(true).booleanValue()).setLinkPreviewsEnabled(Optional.ofNullable(configStore.getLinkPreviews()).orElse(true).booleanValue()).setUnlistedPhoneNumber(Optional.ofNullable(configStore.getPhoneNumberUnlisted()).orElse(false).booleanValue()).setPhoneNumberSharingMode(Optional.ofNullable(configStore.getPhoneNumberSharingMode()).map(StorageSyncModels::localToRemote).orElse(AccountRecord.PhoneNumberSharingMode.UNKNOWN)).setE164(self.getAddress().number().orElse("")).setUsername((String)self.getAddress().username().orElse(null));
        if (usernameLinkComponents != null) {
            String linkColor = configStore.getUsernameLinkColor();
            builder.setUsernameLink(new AccountRecord.UsernameLink.Builder().entropy(ByteString.of((byte[])usernameLinkComponents.getEntropy())).serverId(UuidUtil.toByteString((UUID)usernameLinkComponents.getServerId())).color(linkColor == null ? AccountRecord.UsernameLink.Color.UNKNOWN : AccountRecord.UsernameLink.Color.valueOf((String)linkColor)).build());
        }
        return SignalStorageRecord.forAccount((SignalAccountRecord)builder.build());
    }

    public static SignalStorageRecord localToRemoteRecord(Recipient recipient, IdentityInfo identity, byte[] rawStorageId) {
        RecipientAddress address = recipient.getAddress();
        SignalContactRecord.Builder builder = new SignalContactRecord.Builder(rawStorageId, (ServiceId.ACI)address.aci().orElse(null), recipient.getStorageRecord()).setE164((String)address.number().orElse(null)).setPni((ServiceId.PNI)address.pni().orElse(null)).setUsername((String)address.username().orElse(null)).setProfileKey(recipient.getProfileKey() == null ? null : recipient.getProfileKey().serialize());
        if (recipient.getProfile() != null) {
            builder.setProfileGivenName(recipient.getProfile().getGivenName()).setProfileFamilyName(recipient.getProfile().getFamilyName());
        }
        if (recipient.getContact() != null) {
            builder.setSystemGivenName(recipient.getContact().givenName()).setSystemFamilyName(recipient.getContact().familyName()).setSystemNickname(recipient.getContact().nickName()).setNicknameGivenName(recipient.getContact().nickNameGivenName() == null ? "" : recipient.getContact().nickNameGivenName()).setNicknameFamilyName(recipient.getContact().nickNameFamilyName() == null ? "" : recipient.getContact().nickNameFamilyName()).setNote(recipient.getContact().note()).setBlocked(recipient.getContact().isBlocked()).setProfileSharingEnabled(recipient.getContact().isProfileSharingEnabled()).setMuteUntil(recipient.getContact().muteUntil()).setHideStory(recipient.getContact().hideStory()).setUnregisteredTimestamp(recipient.getContact().unregisteredTimestamp() == null ? 0L : recipient.getContact().unregisteredTimestamp()).setArchived(recipient.getContact().isArchived()).setHidden(recipient.getContact().isHidden());
        }
        if (identity != null) {
            builder.setIdentityKey(identity.getIdentityKey().serialize()).setIdentityState(StorageSyncModels.localToRemote(identity.getTrustLevel()));
        }
        return SignalStorageRecord.forContact((SignalContactRecord)builder.build());
    }

    public static SignalStorageRecord localToRemoteRecord(GroupInfoV1 group, byte[] rawStorageId) {
        SignalGroupV1Record.Builder builder = new SignalGroupV1Record.Builder(rawStorageId, group.getGroupId().serialize(), group.getStorageRecord());
        builder.setBlocked(group.isBlocked());
        builder.setArchived(group.archived);
        builder.setProfileSharingEnabled(true);
        return SignalStorageRecord.forGroupV1((SignalGroupV1Record)builder.build());
    }

    public static SignalStorageRecord localToRemoteRecord(GroupInfoV2 group, byte[] rawStorageId) {
        SignalGroupV2Record.Builder builder = new SignalGroupV2Record.Builder(rawStorageId, group.getMasterKey(), group.getStorageRecord());
        builder.setBlocked(group.isBlocked());
        builder.setProfileSharingEnabled(group.isProfileSharingEnabled());
        return SignalStorageRecord.forGroupV2((SignalGroupV2Record)builder.build());
    }

    public static TrustLevel remoteToLocal(ContactRecord.IdentityState identityState) {
        return switch (identityState) {
            default -> throw new MatchException(null, null);
            case ContactRecord.IdentityState.DEFAULT -> TrustLevel.TRUSTED_UNVERIFIED;
            case ContactRecord.IdentityState.UNVERIFIED -> TrustLevel.UNTRUSTED;
            case ContactRecord.IdentityState.VERIFIED -> TrustLevel.TRUSTED_VERIFIED;
        };
    }

    private static ContactRecord.IdentityState localToRemote(TrustLevel local) {
        return switch (local) {
            case TrustLevel.TRUSTED_VERIFIED -> ContactRecord.IdentityState.VERIFIED;
            case TrustLevel.UNTRUSTED -> ContactRecord.IdentityState.UNVERIFIED;
            default -> ContactRecord.IdentityState.DEFAULT;
        };
    }
}

