/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.syncStorage;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Optional;
import org.asamk.signal.manager.api.GroupId;
import org.asamk.signal.manager.api.GroupIdV1;
import org.asamk.signal.manager.storage.SignalAccount;
import org.asamk.signal.manager.storage.groups.GroupInfo;
import org.asamk.signal.manager.storage.groups.GroupInfoV1;
import org.asamk.signal.manager.storage.groups.GroupInfoV2;
import org.asamk.signal.manager.syncStorage.DefaultStorageRecordProcessor;
import org.asamk.signal.manager.syncStorage.StorageRecordUpdate;
import org.asamk.signal.manager.syncStorage.StorageSyncModels;
import org.asamk.signal.manager.util.KeyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whispersystems.signalservice.api.storage.SignalGroupV1Record;
import org.whispersystems.signalservice.api.storage.StorageId;

public final class GroupV1RecordProcessor
extends DefaultStorageRecordProcessor<SignalGroupV1Record> {
    private static final Logger logger = LoggerFactory.getLogger(GroupV1RecordProcessor.class);
    private final SignalAccount account;
    private final Connection connection;

    public GroupV1RecordProcessor(SignalAccount account, Connection connection) {
        this.account = account;
        this.connection = connection;
    }

    @Override
    protected boolean isInvalid(SignalGroupV1Record remote) throws SQLException {
        try {
            GroupId id = GroupId.unknownVersion(remote.getGroupId());
            if (!(id instanceof GroupIdV1)) {
                return true;
            }
            GroupInfo group = this.account.getGroupStore().getGroup(this.connection, id);
            if (group instanceof GroupInfoV2) {
                logger.debug("We already have an upgraded V2 group for this V1 group -- marking as invalid.");
                return true;
            }
            return false;
        }
        catch (AssertionError e) {
            logger.debug("Bad Group ID -- marking as invalid.");
            return true;
        }
    }

    @Override
    protected Optional<SignalGroupV1Record> getMatching(SignalGroupV1Record remote) throws SQLException {
        GroupIdV1 id = GroupId.v1(remote.getGroupId());
        GroupInfoV1 group = this.account.getGroupStore().getGroup(this.connection, id);
        if (group == null) {
            return Optional.empty();
        }
        StorageId storageId = this.account.getGroupStore().getGroupStorageId(this.connection, id);
        return Optional.of((SignalGroupV1Record)StorageSyncModels.localToRemoteRecord(group, storageId.getRaw()).getGroupV1().get());
    }

    @Override
    protected SignalGroupV1Record merge(SignalGroupV1Record remote, SignalGroupV1Record local) {
        byte[] unknownFields = remote.serializeUnknownFields();
        boolean blocked = remote.isBlocked();
        boolean profileSharing = remote.isProfileSharingEnabled();
        boolean archived = remote.isArchived();
        boolean forcedUnread = remote.isForcedUnread();
        long muteUntil = remote.getMuteUntil();
        SignalGroupV1Record.Builder mergedBuilder = new SignalGroupV1Record.Builder(remote.getId().getRaw(), remote.getGroupId(), unknownFields).setBlocked(blocked).setProfileSharingEnabled(profileSharing).setForcedUnread(forcedUnread).setMuteUntil(muteUntil).setArchived(archived);
        SignalGroupV1Record merged = mergedBuilder.build();
        boolean matchesRemote = GroupV1RecordProcessor.doProtosMatch(merged, remote);
        if (matchesRemote) {
            return remote;
        }
        boolean matchesLocal = GroupV1RecordProcessor.doProtosMatch(merged, local);
        if (matchesLocal) {
            return local;
        }
        return mergedBuilder.setId(KeyUtils.createRawStorageId()).build();
    }

    @Override
    protected void insertLocal(SignalGroupV1Record record) throws SQLException {
        StorageRecordUpdate<SignalGroupV1Record> update = new StorageRecordUpdate<SignalGroupV1Record>(null, record);
        this.updateLocal(update);
    }

    @Override
    protected void updateLocal(StorageRecordUpdate<SignalGroupV1Record> update) throws SQLException {
        SignalGroupV1Record groupV1Record = update.newRecord();
        GroupIdV1 groupIdV1 = GroupId.v1(groupV1Record.getGroupId());
        GroupInfoV1 group = this.account.getGroupStore().getOrCreateGroupV1(this.connection, groupIdV1);
        if (group != null) {
            group.setBlocked(groupV1Record.isBlocked());
            this.account.getGroupStore().updateGroup(this.connection, group);
            this.account.getGroupStore().storeStorageRecord(this.connection, group.getGroupId(), groupV1Record.getId(), groupV1Record.toProto().encode());
        }
    }

    @Override
    public int compare(SignalGroupV1Record lhs, SignalGroupV1Record rhs) {
        if (Arrays.equals(lhs.getGroupId(), rhs.getGroupId())) {
            return 0;
        }
        return 1;
    }

    private static boolean doProtosMatch(SignalGroupV1Record merged, SignalGroupV1Record other) {
        return Arrays.equals(merged.toProto().encode(), other.toProto().encode());
    }
}

