/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.storage.protocol;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.asamk.signal.manager.api.TrustLevel;
import org.asamk.signal.manager.storage.Utils;
import org.asamk.signal.manager.storage.protocol.LegacyIdentityInfo;
import org.asamk.signal.manager.storage.recipients.RecipientAddress;
import org.signal.libsignal.protocol.IdentityKey;
import org.signal.libsignal.protocol.IdentityKeyPair;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whispersystems.signalservice.api.push.ServiceId;
import org.whispersystems.signalservice.api.util.UuidUtil;

public class LegacyJsonIdentityKeyStore {
    private static final Logger logger = LoggerFactory.getLogger(LegacyJsonIdentityKeyStore.class);
    private final List<LegacyIdentityInfo> identities;
    private final IdentityKeyPair identityKeyPair;
    private final int localRegistrationId;

    private LegacyJsonIdentityKeyStore(List<LegacyIdentityInfo> identities, IdentityKeyPair identityKeyPair, int localRegistrationId) {
        this.identities = identities;
        this.identityKeyPair = identityKeyPair;
        this.localRegistrationId = localRegistrationId;
    }

    public List<LegacyIdentityInfo> getIdentities() {
        return this.identities.stream().map(LegacyIdentityInfo::getAddress).collect(Collectors.toSet()).stream().map(this::getIdentity).toList();
    }

    public IdentityKeyPair getIdentityKeyPair() {
        return this.identityKeyPair;
    }

    public int getLocalRegistrationId() {
        return this.localRegistrationId;
    }

    private LegacyIdentityInfo getIdentity(RecipientAddress address) {
        long maxDate = 0L;
        LegacyIdentityInfo maxIdentity = null;
        for (LegacyIdentityInfo id : this.identities) {
            if (!id.getAddress().matches(address)) continue;
            long time = id.getDateAdded().getTime();
            if (maxIdentity != null && maxDate > time) continue;
            maxDate = time;
            maxIdentity = id;
        }
        return maxIdentity;
    }

    public static class JsonIdentityKeyStoreDeserializer
    extends JsonDeserializer<LegacyJsonIdentityKeyStore> {
        public LegacyJsonIdentityKeyStore deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            int localRegistrationId = node.get("registrationId").asInt();
            IdentityKeyPair identityKeyPair = new IdentityKeyPair(Base64.getDecoder().decode(node.get("identityKey").asText()));
            ArrayList<LegacyIdentityInfo> identities = new ArrayList<LegacyIdentityInfo>();
            JsonNode trustedKeysNode = node.get("trustedKeys");
            if (trustedKeysNode.isArray()) {
                for (JsonNode trustedKey : trustedKeysNode) {
                    String trustedKeyName = trustedKey.hasNonNull("name") ? trustedKey.get("name").asText() : null;
                    if (UuidUtil.isUuid((String)trustedKeyName)) continue;
                    UUID uuid = trustedKey.hasNonNull("uuid") ? UuidUtil.parseOrNull((String)trustedKey.get("uuid").asText()) : null;
                    RecipientAddress address = uuid == null ? Utils.getRecipientAddressFromLegacyIdentifier(trustedKeyName) : new RecipientAddress(ServiceId.ACI.from((UUID)uuid), trustedKeyName);
                    try {
                        IdentityKey id = new IdentityKey(Base64.getDecoder().decode(trustedKey.get("identityKey").asText()), 0);
                        TrustLevel trustLevel = trustedKey.hasNonNull("trustLevel") ? TrustLevel.fromInt(trustedKey.get("trustLevel").asInt()) : TrustLevel.TRUSTED_UNVERIFIED;
                        Date added = trustedKey.hasNonNull("addedTimestamp") ? new Date(trustedKey.get("addedTimestamp").asLong()) : new Date();
                        identities.add(new LegacyIdentityInfo(address, id, trustLevel, added));
                    }
                    catch (InvalidKeyException e) {
                        logger.warn("Error while decoding key for {}: {}", (Object)trustedKeyName, (Object)e.getMessage());
                    }
                }
            }
            return new LegacyJsonIdentityKeyStore(identities, identityKeyPair, localRegistrationId);
        }
    }
}

