/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.storage.messageCache;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import org.asamk.signal.manager.util.MessageCacheUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whispersystems.signalservice.api.messages.SignalServiceEnvelope;

public final class CachedMessage {
    private static final Logger logger = LoggerFactory.getLogger(CachedMessage.class);
    private final File file;
    private SignalServiceEnvelope envelope;

    CachedMessage(File file) {
        this.file = file;
    }

    CachedMessage(File file, SignalServiceEnvelope envelope) {
        this.file = file;
        this.envelope = envelope;
    }

    File getFile() {
        return this.file;
    }

    public SignalServiceEnvelope loadEnvelope() {
        if (this.envelope == null) {
            try {
                this.envelope = MessageCacheUtils.loadEnvelope(this.file);
            }
            catch (Exception e) {
                logger.error("Failed to load cached message envelope \u201c{}\u201d: {}", new Object[]{this.file, e.getMessage(), e});
            }
        }
        return this.envelope;
    }

    public void delete() {
        try {
            Files.delete(this.file.toPath());
        }
        catch (IOException e) {
            logger.warn("Failed to delete cached message file \u201c{}\u201d, ignoring: {}", (Object)this.file, (Object)e.getMessage());
        }
        try {
            Files.delete(this.file.toPath().getParent());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

