/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.internal;

import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.asamk.signal.manager.Manager;
import org.asamk.signal.manager.api.AlreadyReceivingException;
import org.asamk.signal.manager.api.AttachmentInvalidException;
import org.asamk.signal.manager.api.CaptchaRejectedException;
import org.asamk.signal.manager.api.CaptchaRequiredException;
import org.asamk.signal.manager.api.Configuration;
import org.asamk.signal.manager.api.Contact;
import org.asamk.signal.manager.api.Device;
import org.asamk.signal.manager.api.DeviceLimitExceededException;
import org.asamk.signal.manager.api.DeviceLinkUrl;
import org.asamk.signal.manager.api.Group;
import org.asamk.signal.manager.api.GroupId;
import org.asamk.signal.manager.api.GroupInviteLinkUrl;
import org.asamk.signal.manager.api.GroupNotFoundException;
import org.asamk.signal.manager.api.GroupSendingNotAllowedException;
import org.asamk.signal.manager.api.Identity;
import org.asamk.signal.manager.api.IdentityVerificationCode;
import org.asamk.signal.manager.api.InactiveGroupLinkException;
import org.asamk.signal.manager.api.IncorrectPinException;
import org.asamk.signal.manager.api.InvalidDeviceLinkException;
import org.asamk.signal.manager.api.InvalidStickerException;
import org.asamk.signal.manager.api.InvalidUsernameException;
import org.asamk.signal.manager.api.LastGroupAdminException;
import org.asamk.signal.manager.api.Message;
import org.asamk.signal.manager.api.MessageEnvelope;
import org.asamk.signal.manager.api.NonNormalizedPhoneNumberException;
import org.asamk.signal.manager.api.NotAGroupMemberException;
import org.asamk.signal.manager.api.NotPrimaryDeviceException;
import org.asamk.signal.manager.api.Pair;
import org.asamk.signal.manager.api.PendingAdminApprovalException;
import org.asamk.signal.manager.api.PhoneNumberSharingMode;
import org.asamk.signal.manager.api.PinLockedException;
import org.asamk.signal.manager.api.Profile;
import org.asamk.signal.manager.api.RateLimitException;
import org.asamk.signal.manager.api.ReceiveConfig;
import org.asamk.signal.manager.api.Recipient;
import org.asamk.signal.manager.api.RecipientIdentifier;
import org.asamk.signal.manager.api.SendGroupMessageResults;
import org.asamk.signal.manager.api.SendMessageResult;
import org.asamk.signal.manager.api.SendMessageResults;
import org.asamk.signal.manager.api.StickerPack;
import org.asamk.signal.manager.api.StickerPackId;
import org.asamk.signal.manager.api.StickerPackInvalidException;
import org.asamk.signal.manager.api.StickerPackUrl;
import org.asamk.signal.manager.api.TextStyle;
import org.asamk.signal.manager.api.TypingAction;
import org.asamk.signal.manager.api.UnregisteredRecipientException;
import org.asamk.signal.manager.api.UpdateGroup;
import org.asamk.signal.manager.api.UpdateProfile;
import org.asamk.signal.manager.api.UserStatus;
import org.asamk.signal.manager.api.UsernameLinkUrl;
import org.asamk.signal.manager.api.UsernameStatus;
import org.asamk.signal.manager.api.VerificationMethodNotAvailableException;
import org.asamk.signal.manager.config.ServiceEnvironmentConfig;
import org.asamk.signal.manager.helper.AccountFileUpdater;
import org.asamk.signal.manager.helper.Context;
import org.asamk.signal.manager.helper.RecipientHelper;
import org.asamk.signal.manager.internal.PathConfig;
import org.asamk.signal.manager.internal.SignalDependencies;
import org.asamk.signal.manager.jobs.RefreshRecipientsJob;
import org.asamk.signal.manager.jobs.SyncStorageJob;
import org.asamk.signal.manager.storage.AttachmentStore;
import org.asamk.signal.manager.storage.AvatarStore;
import org.asamk.signal.manager.storage.SignalAccount;
import org.asamk.signal.manager.storage.configuration.ConfigurationStore;
import org.asamk.signal.manager.storage.groups.GroupInfo;
import org.asamk.signal.manager.storage.identities.IdentityInfo;
import org.asamk.signal.manager.storage.recipients.RecipientAddress;
import org.asamk.signal.manager.storage.recipients.RecipientId;
import org.asamk.signal.manager.storage.stickerPacks.JsonStickerPack;
import org.asamk.signal.manager.storage.stickerPacks.StickerPackStore;
import org.asamk.signal.manager.util.AttachmentUtils;
import org.asamk.signal.manager.util.KeyUtils;
import org.asamk.signal.manager.util.StickerUtils;
import org.signal.libsignal.protocol.InvalidMessageException;
import org.signal.libsignal.protocol.ecc.ECPrivateKey;
import org.signal.libsignal.protocol.fingerprint.ScannableFingerprint;
import org.signal.libsignal.usernames.BaseUsernameException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whispersystems.signalservice.api.SignalServiceMessageSender;
import org.whispersystems.signalservice.api.SignalSessionLock;
import org.whispersystems.signalservice.api.messages.SignalServiceAttachment;
import org.whispersystems.signalservice.api.messages.SignalServiceAttachmentPointer;
import org.whispersystems.signalservice.api.messages.SignalServiceAttachmentStream;
import org.whispersystems.signalservice.api.messages.SignalServiceDataMessage;
import org.whispersystems.signalservice.api.messages.SignalServicePreview;
import org.whispersystems.signalservice.api.messages.SignalServiceReceiptMessage;
import org.whispersystems.signalservice.api.messages.SignalServiceStickerManifestUpload;
import org.whispersystems.signalservice.api.messages.SignalServiceTypingMessage;
import org.whispersystems.signalservice.api.push.ServiceId;
import org.whispersystems.signalservice.api.push.ServiceIdType;
import org.whispersystems.signalservice.api.push.exceptions.CdsiResourceExhaustedException;
import org.whispersystems.signalservice.api.push.exceptions.UsernameMalformedException;
import org.whispersystems.signalservice.api.push.exceptions.UsernameTakenException;
import org.whispersystems.signalservice.api.util.DeviceNameUtil;
import org.whispersystems.signalservice.api.util.InvalidNumberException;
import org.whispersystems.signalservice.api.util.PhoneNumberFormatter;
import org.whispersystems.signalservice.api.util.StreamDetails;
import org.whispersystems.signalservice.internal.push.http.ResumableUploadSpec;
import org.whispersystems.signalservice.internal.util.Hex;
import org.whispersystems.signalservice.internal.util.Util;

public class ManagerImpl
implements Manager {
    private static final Logger logger = LoggerFactory.getLogger(ManagerImpl.class);
    private SignalAccount account;
    private final SignalDependencies dependencies;
    private final Context context;
    private final ExecutorService executor = Executors.newCachedThreadPool();
    private Thread receiveThread;
    private boolean isReceivingSynchronous;
    private final Set<Manager.ReceiveMessageHandler> weakHandlers = new HashSet<Manager.ReceiveMessageHandler>();
    private final Set<Manager.ReceiveMessageHandler> messageHandlers = new HashSet<Manager.ReceiveMessageHandler>();
    private final List<Runnable> closedListeners = new ArrayList<Runnable>();
    private final List<Runnable> addressChangedListeners = new ArrayList<Runnable>();
    private final CompositeDisposable disposable = new CompositeDisposable();
    private static final AtomicInteger threadNumber = new AtomicInteger(0);

    public ManagerImpl(SignalAccount account, PathConfig pathConfig, final AccountFileUpdater accountFileUpdater, ServiceEnvironmentConfig serviceEnvironmentConfig, String userAgent) {
        this.account = account;
        SignalSessionLock sessionLock = new SignalSessionLock(this){
            private final ReentrantLock LEGACY_LOCK = new ReentrantLock();

            public SignalSessionLock.Lock acquire() {
                this.LEGACY_LOCK.lock();
                return this.LEGACY_LOCK::unlock;
            }
        };
        this.dependencies = new SignalDependencies(serviceEnvironmentConfig, userAgent, account.getCredentialsProvider(), account.getSignalServiceDataStore(), this.executor, sessionLock);
        AvatarStore avatarStore = new AvatarStore(pathConfig.avatarsPath());
        AttachmentStore attachmentStore = new AttachmentStore(pathConfig.attachmentsPath());
        StickerPackStore stickerPackStore = new StickerPackStore(pathConfig.stickerPacksPath());
        this.context = new Context(account, new AccountFileUpdater(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateAccountIdentifiers(String number, ServiceId.ACI aci) {
                accountFileUpdater.updateAccountIdentifiers(number, aci);
                List<Runnable> list = ManagerImpl.this.addressChangedListeners;
                synchronized (list) {
                    ManagerImpl.this.addressChangedListeners.forEach(Runnable::run);
                }
            }

            @Override
            public void removeAccount() {
                accountFileUpdater.removeAccount();
            }
        }, this.dependencies, avatarStore, attachmentStore, stickerPackStore);
        this.context.getAccountHelper().setUnregisteredListener(this::close);
        this.context.getReceiveHelper().setAuthenticationFailureListener(this::close);
        this.context.getReceiveHelper().setCaughtUpWithOldMessagesListener(() -> {
            ManagerImpl managerImpl = this;
            synchronized (managerImpl) {
                this.notifyAll();
            }
        });
        this.disposable.add(account.getIdentityKeyStore().getIdentityChanges().observeOn(Schedulers.from((Executor)this.executor)).subscribe(serviceId -> {
            logger.trace("Archiving old sessions for {}", serviceId);
            account.getAccountData(ServiceIdType.ACI).getSessionStore().archiveSessions((ServiceId)serviceId);
            account.getAccountData(ServiceIdType.PNI).getSessionStore().archiveSessions((ServiceId)serviceId);
            account.getSenderKeyStore().deleteSharedWith((ServiceId)serviceId);
            RecipientId recipientId = account.getRecipientResolver().resolveRecipient((ServiceId)serviceId);
            Profile profile = account.getProfileStore().getProfile(recipientId);
            if (profile != null) {
                account.getProfileStore().storeProfile(recipientId, Profile.newBuilder(profile).withUnidentifiedAccessMode(Profile.UnidentifiedAccessMode.UNKNOWN).withLastUpdateTimestamp(0L).build());
            }
        }));
    }

    @Override
    public String getSelfNumber() {
        return this.account.getNumber();
    }

    public void checkAccountState() throws IOException {
        this.context.getAccountHelper().checkAccountState();
        Long lastRecipientsRefresh = this.account.getLastRecipientsRefresh();
        if (lastRecipientsRefresh == null || lastRecipientsRefresh < System.currentTimeMillis() - TimeUnit.DAYS.toMillis(1L)) {
            this.context.getJobExecutor().enqueueJob(new RefreshRecipientsJob());
            this.context.getAccountHelper().checkWhoAmiI();
        }
    }

    @Override
    public Map<String, UserStatus> getUserStatus(Set<String> numbers) throws IOException, RateLimitException {
        Map<String, RecipientHelper.RegisteredUser> registeredUsers;
        Map<String, String> canonicalizedNumbers = numbers.stream().collect(Collectors.toMap(n -> n, n -> {
            try {
                String canonicalizedNumber = PhoneNumberFormatter.formatNumber((String)n, (String)this.account.getNumber());
                if (!canonicalizedNumber.equals(n)) {
                    logger.debug("Normalized number {} to {}.", n, (Object)canonicalizedNumber);
                }
                return canonicalizedNumber;
            }
            catch (InvalidNumberException e) {
                return "";
            }
        }));
        Set<String> canonicalizedNumbersSet = canonicalizedNumbers.values().stream().filter(s -> !s.isEmpty()).collect(Collectors.toSet());
        try {
            registeredUsers = this.context.getRecipientHelper().getRegisteredUsers(canonicalizedNumbersSet);
        }
        catch (CdsiResourceExhaustedException e) {
            logger.debug("CDSI resource exhausted: {}", (Object)e.getMessage());
            throw new RateLimitException(System.currentTimeMillis() + (long)e.getRetryAfterSeconds() * 1000L);
        }
        return numbers.stream().collect(Collectors.toMap(n -> n, n -> {
            String number = (String)canonicalizedNumbers.get(n);
            RecipientHelper.RegisteredUser user = (RecipientHelper.RegisteredUser)registeredUsers.get(number);
            ServiceId serviceId = user == null ? null : user.getServiceId();
            Profile profile = serviceId == null ? null : this.context.getProfileHelper().getRecipientProfile(this.account.getRecipientResolver().resolveRecipient(serviceId));
            return new UserStatus(number.isEmpty() ? null : number, serviceId == null ? null : serviceId.getRawUuid(), profile != null && profile.getUnidentifiedAccessMode() == Profile.UnidentifiedAccessMode.UNRESTRICTED);
        }));
    }

    @Override
    public Map<String, UsernameStatus> getUsernameStatus(Set<String> usernames) {
        HashMap<String, RecipientAddress> registeredUsers = new HashMap<String, RecipientAddress>();
        for (String username2 : usernames) {
            try {
                RecipientId recipientId = this.context.getRecipientHelper().resolveRecipientByUsernameOrLink(username2, true);
                RecipientAddress address = this.account.getRecipientAddressResolver().resolveRecipientAddress(recipientId);
                registeredUsers.put(username2, address);
            }
            catch (UnregisteredRecipientException unregisteredRecipientException) {}
        }
        return usernames.stream().collect(Collectors.toMap(n -> n, username -> {
            RecipientAddress user = (RecipientAddress)registeredUsers.get(username);
            ServiceId serviceId = user == null ? null : (ServiceId)user.serviceId().orElse(null);
            Profile profile = serviceId == null ? null : this.context.getProfileHelper().getRecipientProfile(this.account.getRecipientResolver().resolveRecipient(serviceId));
            return new UsernameStatus((String)username, serviceId == null ? null : serviceId.getRawUuid(), profile != null && profile.getUnidentifiedAccessMode() == Profile.UnidentifiedAccessMode.UNRESTRICTED);
        }));
    }

    @Override
    public void updateAccountAttributes(String deviceName, Boolean unrestrictedUnidentifiedSender, Boolean discoverableByNumber, Boolean numberSharing) throws IOException {
        if (deviceName != null) {
            this.context.getAccountHelper().setDeviceName(deviceName);
        }
        if (unrestrictedUnidentifiedSender != null) {
            this.account.setUnrestrictedUnidentifiedAccess(unrestrictedUnidentifiedSender);
        }
        if (discoverableByNumber != null) {
            this.account.getConfigurationStore().setPhoneNumberUnlisted(discoverableByNumber == false);
        }
        if (numberSharing != null) {
            this.account.getConfigurationStore().setPhoneNumberSharingMode(numberSharing != false ? PhoneNumberSharingMode.EVERYBODY : PhoneNumberSharingMode.NOBODY);
        }
        this.context.getAccountHelper().updateAccountAttributes();
        this.context.getAccountHelper().checkWhoAmiI();
    }

    @Override
    public Configuration getConfiguration() {
        ConfigurationStore configurationStore = this.account.getConfigurationStore();
        return Configuration.from(configurationStore);
    }

    @Override
    public void updateConfiguration(Configuration configuration) {
        ConfigurationStore configurationStore = this.account.getConfigurationStore();
        if (configuration.readReceipts().isPresent()) {
            configurationStore.setReadReceipts(configuration.readReceipts().get());
        }
        if (configuration.unidentifiedDeliveryIndicators().isPresent()) {
            configurationStore.setUnidentifiedDeliveryIndicators(configuration.unidentifiedDeliveryIndicators().get());
        }
        if (configuration.typingIndicators().isPresent()) {
            configurationStore.setTypingIndicators(configuration.typingIndicators().get());
        }
        if (configuration.linkPreviews().isPresent()) {
            configurationStore.setLinkPreviews(configuration.linkPreviews().get());
        }
        this.context.getSyncHelper().sendConfigurationMessage();
        this.syncRemoteStorage();
    }

    @Override
    public void updateProfile(UpdateProfile updateProfile) throws IOException {
        this.context.getProfileHelper().setProfile(updateProfile.getGivenName(), updateProfile.getFamilyName(), updateProfile.getAbout(), updateProfile.getAboutEmoji(), (Optional<String>)(updateProfile.isDeleteAvatar() ? Optional.empty() : (updateProfile.getAvatar() == null ? null : Optional.of(updateProfile.getAvatar()))), updateProfile.getMobileCoinAddress());
        this.context.getSyncHelper().sendSyncFetchProfileMessage();
    }

    void refreshCurrentUsername() throws IOException, BaseUsernameException {
        this.context.getAccountHelper().refreshCurrentUsername();
    }

    @Override
    public String getUsername() {
        return this.account.getUsername();
    }

    @Override
    public UsernameLinkUrl getUsernameLink() {
        return new UsernameLinkUrl(this.account.getUsernameLink());
    }

    @Override
    public void setUsername(String username) throws IOException, InvalidUsernameException {
        try {
            if (username.contains(".")) {
                this.context.getAccountHelper().reserveExactUsername(username);
            } else {
                this.context.getAccountHelper().reserveUsernameFromNickname(username);
            }
        }
        catch (UsernameMalformedException e) {
            throw new InvalidUsernameException("Username is malformed", e);
        }
        catch (UsernameTakenException e) {
            throw new InvalidUsernameException("Username is already registered", e);
        }
        catch (BaseUsernameException e) {
            throw new InvalidUsernameException(e.getMessage() + " (" + ((Object)((Object)e)).getClass().getSimpleName() + ")", e);
        }
    }

    @Override
    public void deleteUsername() throws IOException {
        this.context.getAccountHelper().deleteUsername();
    }

    @Override
    public void startChangeNumber(String newNumber, boolean voiceVerification, String captcha) throws RateLimitException, IOException, CaptchaRequiredException, NonNormalizedPhoneNumberException, NotPrimaryDeviceException, VerificationMethodNotAvailableException {
        if (!this.account.isPrimaryDevice()) {
            throw new NotPrimaryDeviceException();
        }
        this.context.getAccountHelper().startChangeNumber(newNumber, voiceVerification, captcha);
    }

    @Override
    public void finishChangeNumber(String newNumber, String verificationCode, String pin) throws IncorrectPinException, PinLockedException, IOException, NotPrimaryDeviceException {
        if (!this.account.isPrimaryDevice()) {
            throw new NotPrimaryDeviceException();
        }
        this.context.getAccountHelper().finishChangeNumber(newNumber, verificationCode, pin);
    }

    @Override
    public void unregister() throws IOException {
        this.context.getAccountHelper().unregister();
    }

    @Override
    public void deleteAccount() throws IOException {
        this.context.getAccountHelper().deleteAccount();
    }

    @Override
    public void submitRateLimitRecaptchaChallenge(String challenge, String captcha) throws IOException, CaptchaRejectedException {
        captcha = captcha == null ? null : captcha.replace("signalcaptcha://", "");
        try {
            this.dependencies.getAccountManager().submitRateLimitRecaptchaChallenge(challenge, captcha);
        }
        catch (org.whispersystems.signalservice.internal.push.exceptions.CaptchaRejectedException ignored) {
            throw new CaptchaRejectedException();
        }
    }

    @Override
    public List<Device> getLinkedDevices() throws IOException {
        List devices = this.dependencies.getAccountManager().getDevices();
        this.account.setMultiDevice(devices.size() > 1);
        ECPrivateKey identityKey = this.account.getAciIdentityKeyPair().getPrivateKey();
        return devices.stream().map(d -> {
            String deviceName = d.getName();
            if (deviceName != null) {
                try {
                    deviceName = DeviceNameUtil.decryptDeviceName((String)deviceName, (ECPrivateKey)identityKey);
                }
                catch (IOException e) {
                    logger.debug("Failed to decrypt device name, maybe plain text?", (Throwable)e);
                }
            }
            return new Device(d.getId(), deviceName, d.getCreated(), d.getLastSeen(), d.getId() == this.account.getDeviceId());
        }).toList();
    }

    @Override
    public void removeLinkedDevices(int deviceId) throws IOException, NotPrimaryDeviceException {
        if (!this.account.isPrimaryDevice()) {
            throw new NotPrimaryDeviceException();
        }
        this.context.getAccountHelper().removeLinkedDevices(deviceId);
    }

    @Override
    public void addDeviceLink(DeviceLinkUrl linkUrl) throws IOException, InvalidDeviceLinkException, NotPrimaryDeviceException, DeviceLimitExceededException {
        if (!this.account.isPrimaryDevice()) {
            throw new NotPrimaryDeviceException();
        }
        this.context.getAccountHelper().addDevice(linkUrl);
    }

    @Override
    public void setRegistrationLockPin(Optional<String> pin) throws IOException, NotPrimaryDeviceException {
        if (!this.account.isPrimaryDevice()) {
            throw new NotPrimaryDeviceException();
        }
        if (pin.isPresent()) {
            this.context.getAccountHelper().setRegistrationPin(pin.get());
        } else {
            this.context.getAccountHelper().removeRegistrationPin();
        }
    }

    void refreshPreKeys() throws IOException {
        this.context.getPreKeyHelper().refreshPreKeysIfNecessary();
    }

    @Override
    public List<Group> getGroups() {
        return this.context.getGroupHelper().getGroups().stream().map(this::toGroup).toList();
    }

    private Group toGroup(GroupInfo groupInfo) {
        if (groupInfo == null) {
            return null;
        }
        return Group.from(groupInfo, this.account.getRecipientAddressResolver(), this.account.getSelfRecipientId());
    }

    @Override
    public SendGroupMessageResults quitGroup(GroupId groupId, Set<RecipientIdentifier.Single> groupAdmins) throws GroupNotFoundException, IOException, NotAGroupMemberException, LastGroupAdminException, UnregisteredRecipientException {
        Set<RecipientId> newAdmins = this.context.getRecipientHelper().resolveRecipients(groupAdmins);
        return this.context.getGroupHelper().quitGroup(groupId, newAdmins);
    }

    @Override
    public void deleteGroup(GroupId groupId) throws IOException {
        GroupInfo group = this.context.getGroupHelper().getGroup(groupId);
        if (group.isMember(this.account.getSelfRecipientId())) {
            throw new IOException("The local group information cannot be removed, as the user is still a member of the group");
        }
        this.context.getGroupHelper().deleteGroup(groupId);
    }

    @Override
    public Pair<GroupId, SendGroupMessageResults> createGroup(String name, Set<RecipientIdentifier.Single> members, String avatarFile) throws IOException, AttachmentInvalidException, UnregisteredRecipientException {
        return this.context.getGroupHelper().createGroup(name, members == null ? null : this.context.getRecipientHelper().resolveRecipients(members), avatarFile);
    }

    @Override
    public SendGroupMessageResults updateGroup(GroupId groupId, UpdateGroup updateGroup) throws IOException, GroupNotFoundException, AttachmentInvalidException, NotAGroupMemberException, GroupSendingNotAllowedException, UnregisteredRecipientException {
        return this.context.getGroupHelper().updateGroup(groupId, updateGroup.getName(), updateGroup.getDescription(), updateGroup.getMembers() == null ? null : this.context.getRecipientHelper().resolveRecipients(updateGroup.getMembers()), updateGroup.getRemoveMembers() == null ? null : this.context.getRecipientHelper().resolveRecipients(updateGroup.getRemoveMembers()), updateGroup.getAdmins() == null ? null : this.context.getRecipientHelper().resolveRecipients(updateGroup.getAdmins()), updateGroup.getRemoveAdmins() == null ? null : this.context.getRecipientHelper().resolveRecipients(updateGroup.getRemoveAdmins()), updateGroup.getBanMembers() == null ? null : this.context.getRecipientHelper().resolveRecipients(updateGroup.getBanMembers()), updateGroup.getUnbanMembers() == null ? null : this.context.getRecipientHelper().resolveRecipients(updateGroup.getUnbanMembers()), updateGroup.isResetGroupLink(), updateGroup.getGroupLinkState(), updateGroup.getAddMemberPermission(), updateGroup.getEditDetailsPermission(), updateGroup.getAvatarFile(), updateGroup.getExpirationTimer(), updateGroup.getIsAnnouncementGroup());
    }

    @Override
    public Pair<GroupId, SendGroupMessageResults> joinGroup(GroupInviteLinkUrl inviteLinkUrl) throws IOException, InactiveGroupLinkException, PendingAdminApprovalException {
        return this.context.getGroupHelper().joinGroup(inviteLinkUrl);
    }

    private SendMessageResults sendMessage(SignalServiceDataMessage.Builder messageBuilder, Set<RecipientIdentifier> recipients, boolean notifySelf) throws IOException, NotAGroupMemberException, GroupNotFoundException, GroupSendingNotAllowedException {
        return this.sendMessage(messageBuilder, recipients, notifySelf, Optional.empty());
    }

    private SendMessageResults sendMessage(SignalServiceDataMessage.Builder messageBuilder, Set<RecipientIdentifier> recipients, boolean notifySelf, Optional<Long> editTargetTimestamp) throws IOException, NotAGroupMemberException, GroupNotFoundException, GroupSendingNotAllowedException {
        HashMap<RecipientIdentifier, List<SendMessageResult>> results = new HashMap<RecipientIdentifier, List<SendMessageResult>>();
        long timestamp = System.currentTimeMillis();
        messageBuilder.withTimestamp(timestamp);
        for (RecipientIdentifier recipient : recipients) {
            Object result;
            RecipientIdentifier.Single single;
            if (recipient instanceof RecipientIdentifier.NoteToSelf || recipient instanceof RecipientIdentifier.Single && new RecipientAddress((single = (RecipientIdentifier.Single)recipient).toPartialRecipientAddress()).matches(this.account.getSelfRecipientAddress())) {
                result = notifySelf ? this.context.getSendHelper().sendMessage(messageBuilder, this.account.getSelfRecipientId(), editTargetTimestamp) : this.context.getSendHelper().sendSelfMessage(messageBuilder, editTargetTimestamp);
                results.put(recipient, List.of(this.toSendMessageResult((org.whispersystems.signalservice.api.messages.SendMessageResult)result)));
                continue;
            }
            if (recipient instanceof RecipientIdentifier.Single) {
                RecipientIdentifier.Single single2 = (RecipientIdentifier.Single)recipient;
                try {
                    RecipientId recipientId = this.context.getRecipientHelper().resolveRecipient(single2);
                    org.whispersystems.signalservice.api.messages.SendMessageResult result2 = this.context.getSendHelper().sendMessage(messageBuilder, recipientId, editTargetTimestamp);
                    results.put(recipient, List.of(this.toSendMessageResult(result2)));
                }
                catch (UnregisteredRecipientException e) {
                    results.put(recipient, List.of(SendMessageResult.unregisteredFailure(single2.toPartialRecipientAddress())));
                }
                continue;
            }
            if (!(recipient instanceof RecipientIdentifier.Group)) continue;
            RecipientIdentifier.Group group = (RecipientIdentifier.Group)recipient;
            result = this.context.getSendHelper().sendAsGroupMessage(messageBuilder, group.groupId(), notifySelf, editTargetTimestamp);
            results.put(recipient, result.stream().map(this::toSendMessageResult).toList());
        }
        return new SendMessageResults(timestamp, results);
    }

    private SendMessageResult toSendMessageResult(org.whispersystems.signalservice.api.messages.SendMessageResult result) {
        return SendMessageResult.from(result, this.account.getRecipientResolver(), this.account.getRecipientAddressResolver());
    }

    private SendMessageResults sendTypingMessage(SignalServiceTypingMessage.Action action, Set<RecipientIdentifier> recipients) throws IOException, NotAGroupMemberException, GroupNotFoundException, GroupSendingNotAllowedException {
        HashMap<RecipientIdentifier, List<SendMessageResult>> results = new HashMap<RecipientIdentifier, List<SendMessageResult>>();
        long timestamp = System.currentTimeMillis();
        for (RecipientIdentifier recipient : recipients) {
            org.whispersystems.signalservice.api.messages.SendMessageResult result;
            if (recipient instanceof RecipientIdentifier.Single) {
                RecipientIdentifier.Single single = (RecipientIdentifier.Single)recipient;
                SignalServiceTypingMessage message = new SignalServiceTypingMessage(action, timestamp, Optional.empty());
                try {
                    RecipientId recipientId = this.context.getRecipientHelper().resolveRecipient(single);
                    result = this.context.getSendHelper().sendTypingMessage(message, recipientId);
                    results.put(recipient, List.of(this.toSendMessageResult(result)));
                }
                catch (UnregisteredRecipientException e) {
                    results.put(recipient, List.of(SendMessageResult.unregisteredFailure(single.toPartialRecipientAddress())));
                }
                continue;
            }
            if (!(recipient instanceof RecipientIdentifier.Group)) continue;
            GroupId groupId = ((RecipientIdentifier.Group)recipient).groupId();
            SignalServiceTypingMessage message = new SignalServiceTypingMessage(action, timestamp, Optional.of(groupId.serialize()));
            result = this.context.getSendHelper().sendGroupTypingMessage(message, groupId);
            results.put(recipient, result.stream().map(this::toSendMessageResult).toList());
        }
        return new SendMessageResults(timestamp, results);
    }

    @Override
    public SendMessageResults sendTypingMessage(TypingAction action, Set<RecipientIdentifier> recipients) throws IOException, NotAGroupMemberException, GroupNotFoundException, GroupSendingNotAllowedException {
        return this.sendTypingMessage(action.toSignalService(), recipients);
    }

    @Override
    public SendMessageResults sendReadReceipt(RecipientIdentifier.Single sender, List<Long> messageIds) {
        long timestamp = System.currentTimeMillis();
        SignalServiceReceiptMessage receiptMessage = new SignalServiceReceiptMessage(SignalServiceReceiptMessage.Type.READ, messageIds, timestamp);
        return this.sendReceiptMessage(sender, timestamp, receiptMessage);
    }

    @Override
    public SendMessageResults sendViewedReceipt(RecipientIdentifier.Single sender, List<Long> messageIds) {
        long timestamp = System.currentTimeMillis();
        SignalServiceReceiptMessage receiptMessage = new SignalServiceReceiptMessage(SignalServiceReceiptMessage.Type.VIEWED, messageIds, timestamp);
        return this.sendReceiptMessage(sender, timestamp, receiptMessage);
    }

    private SendMessageResults sendReceiptMessage(RecipientIdentifier.Single sender, long timestamp, SignalServiceReceiptMessage receiptMessage) {
        try {
            RecipientId recipientId = this.context.getRecipientHelper().resolveRecipient(sender);
            org.whispersystems.signalservice.api.messages.SendMessageResult result = this.context.getSendHelper().sendReceiptMessage(receiptMessage, recipientId);
            Optional<ServiceId> serviceId = this.account.getRecipientAddressResolver().resolveRecipientAddress(recipientId).serviceId();
            if (serviceId.isPresent()) {
                this.context.getSyncHelper().sendSyncReceiptMessage(serviceId.get(), receiptMessage);
            }
            return new SendMessageResults(timestamp, Map.of(sender, List.of(this.toSendMessageResult(result))));
        }
        catch (UnregisteredRecipientException e) {
            return new SendMessageResults(timestamp, Map.of(sender, List.of(SendMessageResult.unregisteredFailure(sender.toPartialRecipientAddress()))));
        }
    }

    @Override
    public SendMessageResults sendMessage(Message message, Set<RecipientIdentifier> recipients, boolean notifySelf) throws IOException, AttachmentInvalidException, NotAGroupMemberException, GroupNotFoundException, GroupSendingNotAllowedException, UnregisteredRecipientException, InvalidStickerException {
        Profile selfProfile = this.context.getProfileHelper().getSelfProfile();
        if (selfProfile == null || selfProfile.getDisplayName().isEmpty()) {
            logger.warn("No profile name set. When sending a message it's recommended to set a profile name with the updateProfile command. This may become mandatory in the future.");
        }
        SignalServiceDataMessage.Builder messageBuilder = SignalServiceDataMessage.newBuilder();
        this.applyMessage(messageBuilder, message);
        return this.sendMessage(messageBuilder, recipients, notifySelf);
    }

    @Override
    public SendMessageResults sendEditMessage(Message message, Set<RecipientIdentifier> recipients, long editTargetTimestamp) throws IOException, AttachmentInvalidException, NotAGroupMemberException, GroupNotFoundException, GroupSendingNotAllowedException, UnregisteredRecipientException, InvalidStickerException {
        SignalServiceDataMessage.Builder messageBuilder = SignalServiceDataMessage.newBuilder();
        this.applyMessage(messageBuilder, message);
        return this.sendMessage(messageBuilder, recipients, false, Optional.of(editTargetTimestamp));
    }

    private void applyMessage(SignalServiceDataMessage.Builder messageBuilder, Message message) throws AttachmentInvalidException, IOException, UnregisteredRecipientException, InvalidStickerException {
        ArrayList<Object> additionalAttachments = new ArrayList<Object>();
        if (message.messageText().length() > 2000) {
            byte[] messageBytes = message.messageText().getBytes(StandardCharsets.UTF_8);
            ResumableUploadSpec uploadSpec = this.dependencies.getMessageSender().getResumableUploadSpec();
            StreamDetails streamDetails = new StreamDetails((InputStream)new ByteArrayInputStream(messageBytes), "text/x-signal-plain", (long)messageBytes.length);
            SignalServiceAttachmentStream textAttachment = AttachmentUtils.createAttachmentStream(streamDetails, Optional.empty(), uploadSpec);
            messageBuilder.withBody(message.messageText().substring(0, 2000));
            additionalAttachments.add(this.context.getAttachmentHelper().uploadAttachment(textAttachment));
        } else {
            messageBuilder.withBody(message.messageText());
        }
        if (!message.attachments().isEmpty()) {
            List<SignalServiceAttachment> uploadedAttachments = this.context.getAttachmentHelper().uploadAttachments(message.attachments());
            if (!additionalAttachments.isEmpty()) {
                additionalAttachments.addAll(uploadedAttachments);
                messageBuilder.withAttachments(additionalAttachments);
            } else {
                messageBuilder.withAttachments(uploadedAttachments);
            }
        } else if (!additionalAttachments.isEmpty()) {
            messageBuilder.withAttachments(additionalAttachments);
        }
        if (!message.mentions().isEmpty()) {
            messageBuilder.withMentions(this.resolveMentions(message.mentions()));
        }
        if (!message.textStyles().isEmpty()) {
            messageBuilder.withBodyRanges(message.textStyles().stream().map(TextStyle::toBodyRange).toList());
        }
        if (message.quote().isPresent()) {
            Message.Quote quote = message.quote().get();
            ArrayList<SignalServiceDataMessage.Quote.QuotedAttachment> quotedAttachments = new ArrayList<SignalServiceDataMessage.Quote.QuotedAttachment>();
            for (Message.Quote.Attachment a : quote.attachments()) {
                SignalServiceDataMessage.Quote.QuotedAttachment quotedAttachment = new SignalServiceDataMessage.Quote.QuotedAttachment(a.contentType(), a.filename(), a.preview() == null ? null : this.context.getAttachmentHelper().uploadAttachment(a.preview()));
                quotedAttachments.add(quotedAttachment);
            }
            messageBuilder.withQuote(new SignalServiceDataMessage.Quote(quote.timestamp(), this.context.getRecipientHelper().resolveSignalServiceAddress(this.context.getRecipientHelper().resolveRecipient(quote.author())).getServiceId(), quote.message(), quotedAttachments, this.resolveMentions(quote.mentions()), SignalServiceDataMessage.Quote.Type.NORMAL, quote.textStyles().stream().map(TextStyle::toBodyRange).toList()));
        }
        if (message.sticker().isPresent()) {
            Message.Sticker sticker = message.sticker().get();
            StickerPackId packId = StickerPackId.deserialize(sticker.packId());
            int stickerId = sticker.stickerId();
            org.asamk.signal.manager.storage.stickers.StickerPack stickerPack = this.context.getAccount().getStickerStore().getStickerPack(packId);
            if (stickerPack == null) {
                throw new InvalidStickerException("Sticker pack not found");
            }
            JsonStickerPack manifest = this.context.getStickerHelper().getOrRetrieveStickerPack(packId, stickerPack.packKey());
            if (manifest.stickers().size() <= stickerId) {
                throw new InvalidStickerException("Sticker id not part of this pack");
            }
            JsonStickerPack.JsonSticker manifestSticker = manifest.stickers().get(stickerId);
            StreamDetails streamDetails = this.context.getStickerPackStore().retrieveSticker(packId, stickerId);
            if (streamDetails == null) {
                throw new InvalidStickerException("Missing local sticker file");
            }
            ResumableUploadSpec uploadSpec = this.dependencies.getMessageSender().getResumableUploadSpec();
            SignalServiceAttachmentStream stickerAttachment = AttachmentUtils.createAttachmentStream(streamDetails, Optional.empty(), uploadSpec);
            messageBuilder.withSticker(new SignalServiceDataMessage.Sticker(packId.serialize(), stickerPack.packKey(), stickerId, manifestSticker.emoji(), (SignalServiceAttachment)stickerAttachment));
        }
        if (!message.previews().isEmpty()) {
            ArrayList<SignalServicePreview> previews = new ArrayList<SignalServicePreview>(message.previews().size());
            for (Message.Preview p : message.previews()) {
                SignalServiceAttachmentPointer image = p.image().isPresent() ? this.context.getAttachmentHelper().uploadAttachment(p.image().get()) : null;
                previews.add(new SignalServicePreview(p.url(), p.title(), p.description(), 0L, Optional.ofNullable(image)));
            }
            messageBuilder.withPreviews(previews);
        }
        if (message.storyReply().isPresent()) {
            Message.StoryReply storyReply = message.storyReply().get();
            ServiceId authorServiceId = this.context.getRecipientHelper().resolveSignalServiceAddress(this.context.getRecipientHelper().resolveRecipient(storyReply.author())).getServiceId();
            messageBuilder.withStoryContext(new SignalServiceDataMessage.StoryContext(authorServiceId, storyReply.timestamp()));
        }
    }

    private ArrayList<SignalServiceDataMessage.Mention> resolveMentions(List<Message.Mention> mentionList) throws UnregisteredRecipientException {
        ArrayList<SignalServiceDataMessage.Mention> mentions = new ArrayList<SignalServiceDataMessage.Mention>();
        for (Message.Mention m : mentionList) {
            RecipientId recipientId = this.context.getRecipientHelper().resolveRecipient(m.recipient());
            mentions.add(new SignalServiceDataMessage.Mention(this.context.getRecipientHelper().resolveSignalServiceAddress(recipientId).getServiceId(), m.start(), m.length()));
        }
        return mentions;
    }

    @Override
    public SendMessageResults sendRemoteDeleteMessage(long targetSentTimestamp, Set<RecipientIdentifier> recipients) throws IOException, NotAGroupMemberException, GroupNotFoundException, GroupSendingNotAllowedException {
        SignalServiceDataMessage.RemoteDelete delete = new SignalServiceDataMessage.RemoteDelete(targetSentTimestamp);
        SignalServiceDataMessage.Builder messageBuilder = SignalServiceDataMessage.newBuilder().withRemoteDelete(delete);
        for (RecipientIdentifier recipient : recipients) {
            if (recipient instanceof RecipientIdentifier.Uuid) {
                RecipientIdentifier.Uuid u = (RecipientIdentifier.Uuid)recipient;
                this.account.getMessageSendLogStore().deleteEntryForRecipientNonGroup(targetSentTimestamp, (ServiceId)ServiceId.ACI.from((UUID)u.uuid()));
                continue;
            }
            if (recipient instanceof RecipientIdentifier.Pni) {
                RecipientIdentifier.Pni pni = (RecipientIdentifier.Pni)recipient;
                this.account.getMessageSendLogStore().deleteEntryForRecipientNonGroup(targetSentTimestamp, (ServiceId)ServiceId.PNI.parseOrThrow((String)pni.pni()));
                continue;
            }
            if (recipient instanceof RecipientIdentifier.Single) {
                RecipientIdentifier.Single r = (RecipientIdentifier.Single)recipient;
                try {
                    RecipientId recipientId = this.context.getRecipientHelper().resolveRecipient(r);
                    RecipientAddress address = this.account.getRecipientAddressResolver().resolveRecipientAddress(recipientId);
                    if (!address.serviceId().isPresent()) continue;
                    this.account.getMessageSendLogStore().deleteEntryForRecipientNonGroup(targetSentTimestamp, address.serviceId().get());
                }
                catch (UnregisteredRecipientException unregisteredRecipientException) {}
                continue;
            }
            if (!(recipient instanceof RecipientIdentifier.Group)) continue;
            RecipientIdentifier.Group r = (RecipientIdentifier.Group)recipient;
            this.account.getMessageSendLogStore().deleteEntryForGroup(targetSentTimestamp, r.groupId());
        }
        return this.sendMessage(messageBuilder, recipients, false);
    }

    @Override
    public SendMessageResults sendMessageReaction(String emoji, boolean remove, RecipientIdentifier.Single targetAuthor, long targetSentTimestamp, Set<RecipientIdentifier> recipients, boolean isStory) throws IOException, NotAGroupMemberException, GroupNotFoundException, GroupSendingNotAllowedException, UnregisteredRecipientException {
        RecipientId targetAuthorRecipientId = this.context.getRecipientHelper().resolveRecipient(targetAuthor);
        ServiceId authorServiceId = this.context.getRecipientHelper().resolveSignalServiceAddress(targetAuthorRecipientId).getServiceId();
        SignalServiceDataMessage.Reaction reaction = new SignalServiceDataMessage.Reaction(emoji, remove, authorServiceId, targetSentTimestamp);
        SignalServiceDataMessage.Builder messageBuilder = SignalServiceDataMessage.newBuilder().withReaction(reaction);
        if (isStory) {
            messageBuilder.withStoryContext(new SignalServiceDataMessage.StoryContext(authorServiceId, targetSentTimestamp));
        }
        return this.sendMessage(messageBuilder, recipients, false);
    }

    @Override
    public SendMessageResults sendPaymentNotificationMessage(byte[] receipt, String note, RecipientIdentifier.Single recipient) throws IOException {
        SignalServiceDataMessage.PaymentNotification paymentNotification = new SignalServiceDataMessage.PaymentNotification(receipt, note);
        SignalServiceDataMessage.Payment payment = new SignalServiceDataMessage.Payment(paymentNotification, null);
        SignalServiceDataMessage.Builder messageBuilder = SignalServiceDataMessage.newBuilder().withPayment(payment);
        try {
            return this.sendMessage(messageBuilder, Set.of(recipient), false);
        }
        catch (GroupNotFoundException | GroupSendingNotAllowedException | NotAGroupMemberException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public SendMessageResults sendEndSessionMessage(Set<RecipientIdentifier.Single> recipients) throws IOException {
        SignalServiceDataMessage.Builder messageBuilder = SignalServiceDataMessage.newBuilder().asEndSessionMessage();
        try {
            SendMessageResults sendMessageResults = this.sendMessage(messageBuilder, recipients.stream().map(RecipientIdentifier.class::cast).collect(Collectors.toSet()), false);
            return sendMessageResults;
        }
        catch (GroupNotFoundException | GroupSendingNotAllowedException | NotAGroupMemberException e) {
            throw new AssertionError((Object)e);
        }
        finally {
            for (RecipientIdentifier.Single recipient : recipients) {
                RecipientId recipientId;
                try {
                    recipientId = this.context.getRecipientHelper().resolveRecipient(recipient);
                }
                catch (UnregisteredRecipientException e) {
                    continue;
                }
                Optional<ServiceId> serviceId = this.context.getAccount().getRecipientAddressResolver().resolveRecipientAddress(recipientId).serviceId();
                if (!serviceId.isPresent()) continue;
                this.account.getAccountData(ServiceIdType.ACI).getSessionStore().deleteAllSessions(serviceId.get());
            }
        }
    }

    @Override
    public SendMessageResults sendMessageRequestResponse(MessageEnvelope.Sync.MessageRequestResponse.Type type, Set<RecipientIdentifier> recipients) {
        HashMap<RecipientIdentifier, List<SendMessageResult>> results = new HashMap<RecipientIdentifier, List<SendMessageResult>>();
        for (RecipientIdentifier recipient : recipients) {
            org.whispersystems.signalservice.api.messages.SendMessageResult result;
            RecipientIdentifier.Single single;
            if (recipient instanceof RecipientIdentifier.NoteToSelf || recipient instanceof RecipientIdentifier.Single && new RecipientAddress((single = (RecipientIdentifier.Single)recipient).toPartialRecipientAddress()).matches(this.account.getSelfRecipientAddress())) {
                result = this.context.getSyncHelper().sendMessageRequestResponse(type, this.account.getSelfRecipientId());
                if (result != null) {
                    results.put(recipient, List.of(this.toSendMessageResult(result)));
                }
                results.put(recipient, List.of(this.toSendMessageResult(result)));
                continue;
            }
            if (recipient instanceof RecipientIdentifier.Single) {
                RecipientIdentifier.Single single2 = (RecipientIdentifier.Single)recipient;
                try {
                    RecipientId recipientId = this.context.getRecipientHelper().resolveRecipient(single2);
                    org.whispersystems.signalservice.api.messages.SendMessageResult result2 = this.context.getSyncHelper().sendMessageRequestResponse(type, recipientId);
                    if (result2 == null) continue;
                    results.put(recipient, List.of(this.toSendMessageResult(result2)));
                }
                catch (UnregisteredRecipientException e) {
                    results.put(recipient, List.of(SendMessageResult.unregisteredFailure(single2.toPartialRecipientAddress())));
                }
                continue;
            }
            if (!(recipient instanceof RecipientIdentifier.Group)) continue;
            RecipientIdentifier.Group group = (RecipientIdentifier.Group)recipient;
            result = this.context.getSyncHelper().sendMessageRequestResponse(type, group.groupId());
            results.put(recipient, List.of(this.toSendMessageResult(result)));
        }
        return new SendMessageResults(0L, results);
    }

    @Override
    public void hideRecipient(RecipientIdentifier.Single recipient) {
        Optional<RecipientId> recipientIdOptional = this.context.getRecipientHelper().resolveRecipientOptional(recipient);
        if (recipientIdOptional.isPresent()) {
            this.context.getContactHelper().setContactHidden(recipientIdOptional.get(), true);
            this.account.removeRecipient(recipientIdOptional.get());
            this.syncRemoteStorage();
        }
    }

    @Override
    public void deleteRecipient(RecipientIdentifier.Single recipient) {
        Optional<RecipientId> recipientIdOptional = this.context.getRecipientHelper().resolveRecipientOptional(recipient);
        if (recipientIdOptional.isPresent()) {
            this.account.removeRecipient(recipientIdOptional.get());
            this.syncRemoteStorage();
        }
    }

    @Override
    public void deleteContact(RecipientIdentifier.Single recipient) {
        Optional<RecipientId> recipientIdOptional = this.context.getRecipientHelper().resolveRecipientOptional(recipient);
        if (recipientIdOptional.isPresent()) {
            this.account.getContactStore().deleteContact(recipientIdOptional.get());
            this.syncRemoteStorage();
        }
    }

    @Override
    public void setContactName(RecipientIdentifier.Single recipient, String givenName, String familyName) throws NotPrimaryDeviceException, UnregisteredRecipientException {
        if (!this.account.isPrimaryDevice()) {
            throw new NotPrimaryDeviceException();
        }
        this.context.getContactHelper().setContactName(this.context.getRecipientHelper().resolveRecipient(recipient), givenName, familyName);
        this.syncRemoteStorage();
    }

    @Override
    public void setContactsBlocked(Collection<RecipientIdentifier.Single> recipients, boolean blocked) throws IOException, UnregisteredRecipientException {
        if (recipients.isEmpty()) {
            return;
        }
        Set<RecipientId> recipientIds = this.context.getRecipientHelper().resolveRecipients(recipients);
        RecipientId selfRecipientId = this.account.getSelfRecipientId();
        boolean shouldRotateProfileKey = false;
        for (RecipientId recipientId : recipientIds) {
            if (this.context.getContactHelper().isContactBlocked(recipientId) == blocked) continue;
            this.context.getContactHelper().setContactBlocked(recipientId, blocked);
            this.context.getSyncHelper().sendMessageRequestResponse(blocked ? MessageEnvelope.Sync.MessageRequestResponse.Type.BLOCK : MessageEnvelope.Sync.MessageRequestResponse.Type.UNBLOCK_AND_ACCEPT, recipientId);
            shouldRotateProfileKey = blocked && (shouldRotateProfileKey || this.account.getGroupStore().getGroups().stream().noneMatch(g -> g.isMember(selfRecipientId) && g.isMember(recipientId)));
        }
        if (shouldRotateProfileKey) {
            this.context.getProfileHelper().rotateProfileKey();
        }
        this.context.getSyncHelper().sendBlockedList();
        this.syncRemoteStorage();
    }

    @Override
    public void setGroupsBlocked(Collection<GroupId> groupIds, boolean blocked) throws GroupNotFoundException, IOException {
        if (groupIds.isEmpty()) {
            return;
        }
        boolean shouldRotateProfileKey = false;
        for (GroupId groupId : groupIds) {
            if (this.context.getGroupHelper().isGroupBlocked(groupId) == blocked) continue;
            this.context.getGroupHelper().setGroupBlocked(groupId, blocked);
            this.context.getSyncHelper().sendMessageRequestResponse(blocked ? MessageEnvelope.Sync.MessageRequestResponse.Type.BLOCK : MessageEnvelope.Sync.MessageRequestResponse.Type.UNBLOCK_AND_ACCEPT, groupId);
            shouldRotateProfileKey = blocked;
        }
        if (shouldRotateProfileKey) {
            this.context.getProfileHelper().rotateProfileKey();
        }
        this.context.getSyncHelper().sendBlockedList();
        this.syncRemoteStorage();
    }

    @Override
    public void setExpirationTimer(RecipientIdentifier.Single recipient, int messageExpirationTimer) throws IOException, UnregisteredRecipientException {
        RecipientId recipientId = this.context.getRecipientHelper().resolveRecipient(recipient);
        this.context.getContactHelper().setExpirationTimer(recipientId, messageExpirationTimer);
        SignalServiceDataMessage.Builder messageBuilder = SignalServiceDataMessage.newBuilder().asExpirationUpdate();
        try {
            this.sendMessage(messageBuilder, Set.of(recipient), false);
        }
        catch (GroupNotFoundException | GroupSendingNotAllowedException | NotAGroupMemberException e) {
            throw new AssertionError((Object)e);
        }
        this.syncRemoteStorage();
    }

    @Override
    public StickerPackUrl uploadStickerPack(File path) throws IOException, StickerPackInvalidException {
        SignalServiceStickerManifestUpload manifest = StickerUtils.getSignalServiceStickerManifestUpload(path);
        SignalServiceMessageSender messageSender = this.dependencies.getMessageSender();
        byte[] packKey = KeyUtils.createStickerUploadKey();
        String packIdString = messageSender.uploadStickerManifest(manifest, packKey);
        StickerPackId packId = StickerPackId.deserialize(Hex.fromStringCondensed((String)packIdString));
        org.asamk.signal.manager.storage.stickers.StickerPack sticker = new org.asamk.signal.manager.storage.stickers.StickerPack(packId, packKey);
        this.account.getStickerStore().addStickerPack(sticker);
        this.context.getSyncHelper().sendStickerOperationsMessage(List.of(sticker), List.of());
        return new StickerPackUrl(packId, packKey);
    }

    @Override
    public void installStickerPack(StickerPackUrl url) throws IOException {
        StickerPackId packId = url.packId();
        byte[] packKey = url.packKey();
        try {
            this.context.getStickerHelper().retrieveStickerPack(packId, packKey);
        }
        catch (InvalidMessageException e) {
            throw new IOException(e);
        }
        org.asamk.signal.manager.storage.stickers.StickerPack sticker = this.context.getStickerHelper().addOrUpdateStickerPack(packId, packKey, true);
        this.context.getSyncHelper().sendStickerOperationsMessage(List.of(sticker), List.of());
    }

    @Override
    public List<StickerPack> getStickerPacks() {
        StickerPackStore stickerPackStore = this.context.getStickerPackStore();
        return this.account.getStickerStore().getStickerPacks().stream().map(pack -> {
            if (stickerPackStore.existsStickerPack(pack.packId())) {
                try {
                    JsonStickerPack manifest = stickerPackStore.retrieveManifest(pack.packId());
                    return new StickerPack(pack.packId(), new StickerPackUrl(pack.packId(), pack.packKey()), pack.isInstalled(), manifest.title(), manifest.author(), Optional.ofNullable(manifest.cover() == null ? null : manifest.cover().toApi()), manifest.stickers().stream().map(JsonStickerPack.JsonSticker::toApi).toList());
                }
                catch (Exception e) {
                    logger.warn("Failed to read local sticker pack manifest: {}", (Object)e.getMessage(), (Object)e);
                }
            }
            return new StickerPack(pack.packId(), pack.packKey(), pack.isInstalled());
        }).toList();
    }

    @Override
    public void requestAllSyncData() {
        this.context.getSyncHelper().requestAllSyncData();
        this.syncRemoteStorage();
    }

    void syncRemoteStorage() {
        this.context.getJobExecutor().enqueueJob(new SyncStorageJob());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addReceiveHandler(Manager.ReceiveMessageHandler handler, boolean isWeakListener) {
        Set<Manager.ReceiveMessageHandler> set = this.messageHandlers;
        synchronized (set) {
            if (isWeakListener) {
                this.weakHandlers.add(handler);
            } else {
                this.messageHandlers.add(handler);
                this.startReceiveThreadIfRequired();
            }
        }
    }

    private void startReceiveThreadIfRequired() {
        if (this.receiveThread != null || this.isReceivingSynchronous) {
            return;
        }
        this.receiveThread = Thread.ofPlatform().name("receive-" + threadNumber.getAndIncrement()).start(() -> {
            logger.debug("Starting receiving messages");
            this.context.getReceiveHelper().receiveMessagesContinuously(this::passReceivedMessageToHandlers);
            logger.debug("Finished receiving messages");
            Set<Manager.ReceiveMessageHandler> set = this.messageHandlers;
            synchronized (set) {
                this.receiveThread = null;
                if (!this.messageHandlers.isEmpty()) {
                    logger.debug("Another handler has been registered, starting receive thread again");
                    this.startReceiveThreadIfRequired();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void passReceivedMessageToHandlers(MessageEnvelope envelope, Throwable e) {
        Set<Manager.ReceiveMessageHandler> set = this.messageHandlers;
        synchronized (set) {
            Stream.concat(this.messageHandlers.stream(), this.weakHandlers.stream()).forEach(h -> {
                try {
                    h.handleMessage(envelope, e);
                }
                catch (Throwable ex) {
                    logger.warn("Message handler failed, ignoring", ex);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeReceiveHandler(Manager.ReceiveMessageHandler handler) {
        Thread thread;
        Set<Manager.ReceiveMessageHandler> set = this.messageHandlers;
        synchronized (set) {
            this.weakHandlers.remove(handler);
            this.messageHandlers.remove(handler);
            if (!this.messageHandlers.isEmpty() || this.receiveThread == null || this.isReceivingSynchronous) {
                return;
            }
            thread = this.receiveThread;
            this.receiveThread = null;
        }
        this.stopReceiveThread(thread);
    }

    private void stopReceiveThread(Thread thread) {
        if (this.context.getReceiveHelper().requestStopReceiveMessages()) {
            logger.debug("Receive stop requested, interrupting read from server.");
            thread.interrupt();
        }
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isReceiving() {
        if (this.isReceivingSynchronous) {
            return true;
        }
        Set<Manager.ReceiveMessageHandler> set = this.messageHandlers;
        synchronized (set) {
            return !this.messageHandlers.isEmpty();
        }
    }

    @Override
    public void receiveMessages(Optional<Duration> timeout, Optional<Integer> maxMessages, Manager.ReceiveMessageHandler handler) throws IOException, AlreadyReceivingException {
        this.receiveMessages(timeout.orElse(Duration.ofMinutes(1L)), timeout.isPresent(), maxMessages.orElse(null), handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopReceiveMessages() {
        Thread thread = null;
        Set<Manager.ReceiveMessageHandler> set = this.messageHandlers;
        synchronized (set) {
            if (this.isReceivingSynchronous) {
                thread = this.receiveThread;
                this.receiveThread = null;
            }
        }
        if (thread != null) {
            this.stopReceiveThread(thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveMessages(Duration timeout, boolean returnOnTimeout, Integer maxMessages, Manager.ReceiveMessageHandler handler) throws IOException, AlreadyReceivingException {
        Set<Manager.ReceiveMessageHandler> set = this.messageHandlers;
        synchronized (set) {
            if (this.isReceiving()) {
                throw new AlreadyReceivingException("Already receiving message.");
            }
            this.isReceivingSynchronous = true;
            this.receiveThread = Thread.currentThread();
        }
        try {
            this.context.getReceiveHelper().receiveMessages(timeout, returnOnTimeout, maxMessages, (envelope, e) -> {
                this.passReceivedMessageToHandlers(envelope, e);
                handler.handleMessage(envelope, e);
            });
        }
        finally {
            set = this.messageHandlers;
            synchronized (set) {
                this.receiveThread = null;
                this.isReceivingSynchronous = false;
                if (!this.messageHandlers.isEmpty()) {
                    this.startReceiveThreadIfRequired();
                }
            }
        }
    }

    @Override
    public void setReceiveConfig(ReceiveConfig receiveConfig) {
        this.context.getReceiveHelper().setReceiveConfig(receiveConfig);
    }

    @Override
    public boolean isContactBlocked(RecipientIdentifier.Single recipient) {
        RecipientId recipientId;
        try {
            recipientId = this.context.getRecipientHelper().resolveRecipient(recipient);
        }
        catch (UnregisteredRecipientException e) {
            return false;
        }
        return this.context.getContactHelper().isContactBlocked(recipientId);
    }

    @Override
    public void sendContacts() throws IOException {
        this.context.getSyncHelper().sendContacts();
    }

    @Override
    public List<Recipient> getRecipients(boolean onlyContacts, Optional<Boolean> blocked, Collection<RecipientIdentifier.Single> recipients, Optional<String> name) {
        Set<RecipientId> recipientIds = recipients.stream().map(a -> {
            try {
                return this.context.getRecipientHelper().resolveRecipient((RecipientIdentifier.Single)a);
            }
            catch (UnregisteredRecipientException e) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        if (!recipients.isEmpty() && recipientIds.isEmpty()) {
            return List.of();
        }
        this.context.getProfileHelper().refreshRecipientProfiles(recipientIds);
        return this.account.getRecipientStore().getRecipients(onlyContacts, blocked, recipientIds, name).stream().map(s -> new Recipient(s.getRecipientId(), s.getAddress().toApiRecipientAddress(), s.getContact(), s.getProfileKey(), s.getExpiringProfileKeyCredential(), s.getProfile(), s.getDiscoverable())).toList();
    }

    @Override
    public String getContactOrProfileName(RecipientIdentifier.Single recipient) {
        RecipientId recipientId;
        try {
            recipientId = this.context.getRecipientHelper().resolveRecipient(recipient);
        }
        catch (UnregisteredRecipientException e) {
            return null;
        }
        Contact contact = this.account.getContactStore().getContact(recipientId);
        if (contact != null && !Util.isEmpty((String)contact.getName())) {
            return contact.getName();
        }
        Profile profile = this.context.getProfileHelper().getRecipientProfile(recipientId);
        if (profile != null) {
            return profile.getDisplayName();
        }
        return null;
    }

    @Override
    public Group getGroup(GroupId groupId) {
        return this.toGroup(this.context.getGroupHelper().getGroup(groupId));
    }

    @Override
    public List<Identity> getIdentities() {
        return this.account.getIdentityKeyStore().getIdentities().stream().map(this::toIdentity).filter(Objects::nonNull).toList();
    }

    private Identity toIdentity(IdentityInfo identityInfo) {
        if (identityInfo == null) {
            return null;
        }
        RecipientAddress address = this.account.getRecipientAddressResolver().resolveRecipientAddress(this.account.getRecipientResolver().resolveRecipient(identityInfo.getServiceId()));
        if (address.serviceId().isPresent() && !Objects.equals(address.serviceId().get(), identityInfo.getServiceId())) {
            return null;
        }
        ScannableFingerprint scannableFingerprint = this.context.getIdentityHelper().computeSafetyNumberForScanning(identityInfo.getServiceId(), identityInfo.getIdentityKey());
        return new Identity(address.toApiRecipientAddress(), identityInfo.getIdentityKey().getPublicKey().serialize(), this.context.getIdentityHelper().computeSafetyNumber(identityInfo.getServiceId(), identityInfo.getIdentityKey()), scannableFingerprint == null ? null : scannableFingerprint.getSerialized(), identityInfo.getTrustLevel(), identityInfo.getDateAddedTimestamp());
    }

    @Override
    public List<Identity> getIdentities(RecipientIdentifier.Single recipient) {
        ServiceId serviceId;
        try {
            RecipientAddress address = this.account.getRecipientAddressResolver().resolveRecipientAddress(this.context.getRecipientHelper().resolveRecipient(recipient));
            if (address.serviceId().isEmpty()) {
                return List.of();
            }
            serviceId = address.serviceId().get();
        }
        catch (UnregisteredRecipientException e) {
            return List.of();
        }
        IdentityInfo identity = this.account.getIdentityKeyStore().getIdentityInfo(serviceId);
        return identity == null ? List.of() : List.of(this.toIdentity(identity));
    }

    @Override
    public boolean trustIdentityVerified(RecipientIdentifier.Single recipient, IdentityVerificationCode verificationCode) throws UnregisteredRecipientException {
        IdentityVerificationCode identityVerificationCode = verificationCode;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IdentityVerificationCode.Fingerprint.class, IdentityVerificationCode.SafetyNumber.class, IdentityVerificationCode.ScannableSafetyNumber.class}, (Object)identityVerificationCode, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                IdentityVerificationCode.Fingerprint fingerprint = (IdentityVerificationCode.Fingerprint)identityVerificationCode;
                yield this.trustIdentity(recipient, r -> this.context.getIdentityHelper().trustIdentityVerified((RecipientId)r, fingerprint.fingerprint()));
            }
            case 1 -> {
                IdentityVerificationCode.SafetyNumber safetyNumber = (IdentityVerificationCode.SafetyNumber)identityVerificationCode;
                yield this.trustIdentity(recipient, r -> this.context.getIdentityHelper().trustIdentityVerifiedSafetyNumber((RecipientId)r, safetyNumber.safetyNumber()));
            }
            case 2 -> {
                IdentityVerificationCode.ScannableSafetyNumber safetyNumber = (IdentityVerificationCode.ScannableSafetyNumber)identityVerificationCode;
                yield this.trustIdentity(recipient, r -> this.context.getIdentityHelper().trustIdentityVerifiedSafetyNumber((RecipientId)r, safetyNumber.safetyNumber()));
            }
            case -1 -> throw new AssertionError((Object)"Invalid verification code type");
        };
    }

    @Override
    public boolean trustIdentityAllKeys(RecipientIdentifier.Single recipient) throws UnregisteredRecipientException {
        return this.trustIdentity(recipient, r -> this.context.getIdentityHelper().trustIdentityAllKeys((RecipientId)r));
    }

    private boolean trustIdentity(RecipientIdentifier.Single recipient, Function<RecipientId, Boolean> trustMethod) throws UnregisteredRecipientException {
        RecipientId recipientId = this.context.getRecipientHelper().resolveRecipient(recipient);
        Boolean updated = trustMethod.apply(recipientId);
        if (updated.booleanValue() && this.isReceiving()) {
            this.account.setNeedsToRetryFailedMessages(true);
        }
        return updated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAddressChangedListener(Runnable listener) {
        List<Runnable> list = this.addressChangedListeners;
        synchronized (list) {
            this.addressChangedListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addClosedListener(Runnable listener) {
        List<Runnable> list = this.closedListeners;
        synchronized (list) {
            this.closedListeners.add(listener);
        }
    }

    @Override
    public InputStream retrieveAttachment(String id) throws IOException {
        return this.context.getAttachmentHelper().retrieveAttachment(id).getStream();
    }

    @Override
    public InputStream retrieveContactAvatar(RecipientIdentifier.Single recipient) throws IOException, UnregisteredRecipientException {
        RecipientId recipientId = this.context.getRecipientHelper().resolveRecipient(recipient);
        RecipientAddress address = this.account.getRecipientStore().resolveRecipientAddress(recipientId);
        StreamDetails streamDetails = this.context.getAvatarStore().retrieveContactAvatar(address);
        if (streamDetails == null) {
            throw new FileNotFoundException();
        }
        return streamDetails.getStream();
    }

    @Override
    public InputStream retrieveProfileAvatar(RecipientIdentifier.Single recipient) throws IOException, UnregisteredRecipientException {
        RecipientId recipientId = this.context.getRecipientHelper().resolveRecipient(recipient);
        this.context.getProfileHelper().getRecipientProfile(recipientId);
        RecipientAddress address = this.account.getRecipientStore().resolveRecipientAddress(recipientId);
        StreamDetails streamDetails = this.context.getAvatarStore().retrieveProfileAvatar(address);
        if (streamDetails == null) {
            throw new FileNotFoundException();
        }
        return streamDetails.getStream();
    }

    @Override
    public InputStream retrieveGroupAvatar(GroupId groupId) throws IOException {
        StreamDetails streamDetails = this.context.getAvatarStore().retrieveGroupAvatar(groupId);
        this.context.getGroupHelper().getGroup(groupId);
        if (streamDetails == null) {
            throw new FileNotFoundException();
        }
        return streamDetails.getStream();
    }

    @Override
    public InputStream retrieveSticker(StickerPackId stickerPackId, int stickerId) throws IOException {
        org.asamk.signal.manager.storage.stickers.StickerPack pack;
        StreamDetails streamDetails = this.context.getStickerPackStore().retrieveSticker(stickerPackId, stickerId);
        if (streamDetails == null && (pack = this.account.getStickerStore().getStickerPack(stickerPackId)) != null) {
            try {
                this.context.getStickerHelper().retrieveStickerPack(stickerPackId, pack.packKey());
            }
            catch (InvalidMessageException e) {
                logger.warn("Failed to download sticker pack");
            }
        }
        if (streamDetails == null) {
            throw new FileNotFoundException();
        }
        return streamDetails.getStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Thread thread;
        Collection<Object> collection = this.messageHandlers;
        synchronized (collection) {
            this.weakHandlers.clear();
            this.messageHandlers.clear();
            thread = this.receiveThread;
            this.receiveThread = null;
        }
        if (thread != null) {
            this.stopReceiveThread(thread);
        }
        this.context.close();
        this.executor.close();
        this.dependencies.getSignalWebSocket().disconnect();
        this.dependencies.getPushServiceSocket().close();
        this.disposable.dispose();
        if (this.account != null) {
            this.account.close();
        }
        collection = this.closedListeners;
        synchronized (collection) {
            this.closedListeners.forEach(Runnable::run);
            this.closedListeners.clear();
        }
        this.account = null;
    }
}

