/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.jsonrpc;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import org.asamk.signal.jsonrpc.JsonRpcMessage;

public final class JsonRpcResponse
extends JsonRpcMessage {
    String jsonrpc;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    JsonNode result;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    Error error;
    ValueNode id;

    public static JsonRpcResponse forSuccess(JsonNode result, ValueNode id) {
        return new JsonRpcResponse("2.0", result, null, id);
    }

    public static JsonRpcResponse forError(Error error, ValueNode id) {
        return new JsonRpcResponse("2.0", null, error, id);
    }

    private JsonRpcResponse() {
    }

    private JsonRpcResponse(String jsonrpc, JsonNode result, Error error, ValueNode id) {
        this.jsonrpc = jsonrpc;
        this.result = result;
        this.error = error;
        this.id = id;
    }

    public String getJsonrpc() {
        return this.jsonrpc;
    }

    public JsonNode getResult() {
        return this.result;
    }

    public Error getError() {
        return this.error;
    }

    public ValueNode getId() {
        return this.id;
    }

    public static class Error {
        public static final int PARSE_ERROR = -32700;
        public static final int INVALID_REQUEST = -32600;
        public static final int METHOD_NOT_FOUND = -32601;
        public static final int INVALID_PARAMS = -32602;
        public static final int INTERNAL_ERROR = -32603;
        int code;
        String message;
        JsonNode data;

        public Error(int code, String message, JsonNode data) {
            this.code = code;
            this.message = message;
            this.data = data;
        }

        public int getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }

        public JsonNode getData() {
            return this.data;
        }
    }
}

