/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.jsonrpc;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ContainerNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import java.io.IOException;
import java.io.InputStream;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import org.asamk.signal.jsonrpc.JsonRpcBatchMessage;
import org.asamk.signal.jsonrpc.JsonRpcException;
import org.asamk.signal.jsonrpc.JsonRpcMessage;
import org.asamk.signal.jsonrpc.JsonRpcRequest;
import org.asamk.signal.jsonrpc.JsonRpcResponse;
import org.asamk.signal.jsonrpc.JsonRpcSender;
import org.asamk.signal.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonRpcReader {
    private static final Logger logger = LoggerFactory.getLogger(JsonRpcReader.class);
    private final JsonRpcSender jsonRpcSender;
    private final ObjectMapper objectMapper;
    private final InputStream input;
    private final Supplier<String> lineSupplier;

    public JsonRpcReader(JsonRpcSender jsonRpcSender, Supplier<String> lineSupplier) {
        this.jsonRpcSender = jsonRpcSender;
        this.input = null;
        this.lineSupplier = lineSupplier;
        this.objectMapper = Util.createJsonObjectMapper();
    }

    public JsonRpcReader(JsonRpcSender jsonRpcSender, InputStream input) {
        this.jsonRpcSender = jsonRpcSender;
        this.input = input;
        this.lineSupplier = null;
        this.objectMapper = Util.createJsonObjectMapper();
    }

    public void readMessages(RequestHandler requestHandler, Consumer<JsonRpcResponse> responseHandler) {
        if (this.input != null) {
            JsonRpcMessage message = this.parseJsonRpcMessage(this.input);
            if (message == null) {
                return;
            }
            this.handleMessage(message, requestHandler, responseHandler);
            return;
        }
        try (ExecutorService executor = Executors.newCachedThreadPool();){
            while (!Thread.interrupted()) {
                String input = this.lineSupplier.get();
                if (input == null) {
                    logger.trace("Reached end of JSON-RPC input stream.");
                    break;
                }
                logger.trace("Incoming JSON-RPC message: {}", (Object)input);
                JsonRpcMessage message = this.parseJsonRpcMessage(input);
                if (message == null) continue;
                executor.submit(() -> this.handleMessage(message, requestHandler, responseHandler));
            }
        }
    }

    private void handleMessage(JsonRpcMessage message, RequestHandler requestHandler, Consumer<JsonRpcResponse> responseHandler) {
        JsonRpcMessage jsonRpcMessage = message;
        Objects.requireNonNull(jsonRpcMessage);
        JsonRpcMessage jsonRpcMessage2 = jsonRpcMessage;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JsonRpcRequest.class, JsonRpcResponse.class, JsonRpcBatchMessage.class}, (Object)jsonRpcMessage2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                JsonRpcRequest jsonRpcRequest = (JsonRpcRequest)jsonRpcMessage2;
                logger.debug("Received json rpc request, method: " + jsonRpcRequest.getMethod());
                JsonRpcResponse response = this.handleRequest(requestHandler, jsonRpcRequest);
                if (response == null) break;
                this.jsonRpcSender.sendResponse(response);
                break;
            }
            case 1: {
                JsonRpcResponse jsonRpcResponse = (JsonRpcResponse)jsonRpcMessage2;
                responseHandler.accept(jsonRpcResponse);
                break;
            }
            case 2: {
                JsonRpcBatchMessage jsonRpcBatchMessage = (JsonRpcBatchMessage)jsonRpcMessage2;
                List<JsonNode> messages = jsonRpcBatchMessage.getMessages();
                ArrayList<JsonRpcResponse> responseList = new ArrayList<JsonRpcResponse>(messages.size());
                try (ExecutorService executor = Executors.newCachedThreadPool();){
                    ReentrantLock lock = new ReentrantLock();
                    messages.forEach(jsonNode -> {
                        JsonRpcRequest request;
                        try {
                            request = this.parseJsonRpcRequest((JsonNode)jsonNode);
                        }
                        catch (JsonRpcException e) {
                            JsonRpcResponse response = JsonRpcResponse.forError(e.getError(), this.getId((JsonNode)jsonNode));
                            lock.lock();
                            try {
                                responseList.add(response);
                            }
                            finally {
                                lock.unlock();
                            }
                            return;
                        }
                        executor.submit(() -> {
                            JsonRpcResponse response = this.handleRequest(requestHandler, request);
                            if (response != null) {
                                lock.lock();
                                try {
                                    responseList.add(response);
                                }
                                finally {
                                    lock.unlock();
                                }
                            }
                        });
                    });
                }
                if (responseList.isEmpty()) break;
                this.jsonRpcSender.sendBatchResponses(responseList);
            }
        }
    }

    private JsonRpcResponse handleRequest(RequestHandler requestHandler, JsonRpcRequest request) {
        try {
            JsonNode result = requestHandler.apply(request.getMethod(), request.getParams());
            if (request.getId() != null) {
                return JsonRpcResponse.forSuccess(result, request.getId());
            }
            logger.debug("Command '{}' succeeded but client didn't specify an id, dropping response", (Object)request.getMethod());
        }
        catch (JsonRpcException e) {
            if (request.getId() != null) {
                return JsonRpcResponse.forError(e.getError(), request.getId());
            }
            logger.debug("Command '{}' failed but client didn't specify an id, dropping error: {}", (Object)request.getMethod(), (Object)e.getMessage());
        }
        return null;
    }

    private JsonRpcMessage parseJsonRpcMessage(String input) {
        JsonNode jsonNode;
        try {
            jsonNode = this.objectMapper.readTree(input);
        }
        catch (JsonParseException e) {
            this.jsonRpcSender.sendResponse(JsonRpcResponse.forError(new JsonRpcResponse.Error(-32700, e.getMessage(), null), null));
            return null;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return this.parseJsonRpcMessage(jsonNode);
    }

    private JsonRpcMessage parseJsonRpcMessage(InputStream input) {
        JsonNode jsonNode;
        try {
            jsonNode = this.objectMapper.readTree(input);
        }
        catch (JsonParseException e) {
            this.jsonRpcSender.sendResponse(JsonRpcResponse.forError(new JsonRpcResponse.Error(-32700, e.getMessage(), null), null));
            return null;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return this.parseJsonRpcMessage(jsonNode);
    }

    private JsonRpcMessage parseJsonRpcMessage(JsonNode jsonNode) {
        if (jsonNode == null) {
            this.jsonRpcSender.sendResponse(JsonRpcResponse.forError(new JsonRpcResponse.Error(-32600, "invalid request", null), null));
            return null;
        }
        if (jsonNode.isArray()) {
            if (jsonNode.isEmpty()) {
                this.jsonRpcSender.sendResponse(JsonRpcResponse.forError(new JsonRpcResponse.Error(-32600, "invalid request", null), null));
                return null;
            }
            return new JsonRpcBatchMessage(StreamSupport.stream(jsonNode.spliterator(), false).toList());
        }
        if (jsonNode.isObject()) {
            if (jsonNode.has("result") || jsonNode.has("error")) {
                return this.parseJsonRpcResponse(jsonNode);
            }
            try {
                return this.parseJsonRpcRequest(jsonNode);
            }
            catch (JsonRpcException e) {
                this.jsonRpcSender.sendResponse(JsonRpcResponse.forError(e.getError(), this.getId(jsonNode)));
                return null;
            }
        }
        this.jsonRpcSender.sendResponse(JsonRpcResponse.forError(new JsonRpcResponse.Error(-32600, "unexpected type: " + jsonNode.getNodeType().name(), null), null));
        return null;
    }

    private ValueNode getId(JsonNode jsonNode) {
        ValueNode value;
        JsonNode id = jsonNode.get("id");
        return id instanceof ValueNode ? (value = (ValueNode)id) : null;
    }

    private JsonRpcRequest parseJsonRpcRequest(JsonNode input) throws JsonRpcException {
        JsonRpcRequest request;
        if (input instanceof ObjectNode) {
            ObjectNode i = (ObjectNode)input;
            if (input.has("params") && input.get("params").isNull()) {
                i.remove("params");
            }
        }
        try {
            request = (JsonRpcRequest)this.objectMapper.treeToValue((TreeNode)input, JsonRpcRequest.class);
        }
        catch (JsonMappingException e) {
            throw new JsonRpcException(new JsonRpcResponse.Error(-32600, e.getMessage(), null));
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        if (!"2.0".equals(request.getJsonrpc())) {
            throw new JsonRpcException(new JsonRpcResponse.Error(-32600, "only jsonrpc version 2.0 is supported", null));
        }
        if (request.getMethod() == null) {
            throw new JsonRpcException(new JsonRpcResponse.Error(-32600, "method field must be set", null));
        }
        return request;
    }

    private JsonRpcResponse parseJsonRpcResponse(JsonNode input) {
        JsonRpcResponse response;
        try {
            response = (JsonRpcResponse)this.objectMapper.treeToValue((TreeNode)input, JsonRpcResponse.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            logger.debug("Received invalid jsonrpc response {}", (Object)e.getMessage());
            return null;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        if (!"2.0".equals(response.getJsonrpc())) {
            logger.debug("Received invalid jsonrpc response with invalid version {}", (Object)response.getJsonrpc());
            return null;
        }
        if (response.getResult() != null && response.getError() != null) {
            logger.debug("Received invalid jsonrpc response with both result and error");
            return null;
        }
        if (response.getResult() == null && response.getError() == null) {
            logger.debug("Received invalid jsonrpc response without result and error");
            return null;
        }
        if (response.getId() == null || response.getId().isNull()) {
            logger.debug("Received invalid jsonrpc response without id");
            return null;
        }
        return response;
    }

    public static interface RequestHandler {
        public JsonNode apply(String var1, ContainerNode<?> var2) throws JsonRpcException;
    }
}

