/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.UUID;
import org.asamk.signal.json.JsonMention;
import org.asamk.signal.json.JsonQuotedAttachment;
import org.asamk.signal.json.JsonTextStyle;
import org.asamk.signal.manager.api.MessageEnvelope;
import org.asamk.signal.manager.api.RecipientAddress;

public record JsonQuote(long id, @Deprecated String author, String authorNumber, String authorUuid, String text, @JsonInclude(value=JsonInclude.Include.NON_NULL) List<JsonMention> mentions, List<JsonQuotedAttachment> attachments, @JsonInclude(value=JsonInclude.Include.NON_NULL) List<JsonTextStyle> textStyles) {
    static JsonQuote from(MessageEnvelope.Data.Quote quote) {
        long id = quote.id();
        RecipientAddress address = quote.author();
        String author = address.getLegacyIdentifier();
        String authorNumber = address.number().orElse(null);
        String authorUuid = address.uuid().map(UUID::toString).orElse(null);
        String text = quote.text().orElse(null);
        List<JsonMention> mentions = !quote.mentions().isEmpty() ? quote.mentions().stream().map(JsonMention::from).toList() : null;
        List<JsonQuotedAttachment> attachments = !quote.attachments().isEmpty() ? quote.attachments().stream().map(JsonQuotedAttachment::from).toList() : List.of();
        List<JsonTextStyle> textStyles = !quote.textStyles().isEmpty() ? quote.textStyles().stream().map(JsonTextStyle::from).toList() : null;
        return new JsonQuote(id, author, authorNumber, authorUuid, text, mentions, attachments, textStyles);
    }
}

