/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.commands;

import java.io.IOException;
import java.util.Base64;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.MutuallyExclusiveGroup;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import org.asamk.signal.commands.JsonRpcLocalCommand;
import org.asamk.signal.commands.exceptions.CommandException;
import org.asamk.signal.commands.exceptions.IOErrorException;
import org.asamk.signal.manager.Manager;
import org.asamk.signal.manager.api.UpdateProfile;
import org.asamk.signal.output.OutputWriter;

public class UpdateProfileCommand
implements JsonRpcLocalCommand {
    @Override
    public String getName() {
        return "updateProfile";
    }

    @Override
    public void attachToSubparser(Subparser subparser) {
        subparser.help("Set a name, about and avatar image for the user profile");
        subparser.addArgument(new String[]{"--given-name", "--name"}).help("New profile (given) name");
        subparser.addArgument(new String[]{"--family-name"}).help("New profile family name (optional)");
        subparser.addArgument(new String[]{"--about"}).help("New profile about text");
        subparser.addArgument(new String[]{"--about-emoji"}).help("New profile about emoji");
        subparser.addArgument(new String[]{"--mobile-coin-address"}).help("New MobileCoin address (Base64 encoded public address)");
        MutuallyExclusiveGroup avatarOptions = subparser.addMutuallyExclusiveGroup();
        avatarOptions.addArgument(new String[]{"--avatar"}).help("Path to new profile avatar");
        avatarOptions.addArgument(new String[]{"--remove-avatar"}).action((ArgumentAction)Arguments.storeTrue());
    }

    @Override
    public void handleCommand(Namespace ns, Manager m, OutputWriter outputWriter) throws CommandException {
        String givenName = ns.getString("given-name");
        String familyName = ns.getString("family-name");
        String about = ns.getString("about");
        String aboutEmoji = ns.getString("about-emoji");
        String mobileCoinAddressString = ns.getString("mobile-coin-address");
        byte[] mobileCoinAddress = mobileCoinAddressString == null ? null : Base64.getDecoder().decode(mobileCoinAddressString);
        String avatarPath = ns.getString("avatar");
        boolean removeAvatar = Boolean.TRUE.equals(ns.getBoolean("remove-avatar"));
        String avatarFile = removeAvatar || avatarPath == null ? null : avatarPath;
        try {
            m.updateProfile(UpdateProfile.newBuilder().withGivenName(givenName).withFamilyName(familyName).withAbout(about).withAboutEmoji(aboutEmoji).withMobileCoinAddress(mobileCoinAddress).withAvatar(avatarFile).withDeleteAvatar(removeAvatar).build());
        }
        catch (IOException e) {
            throw new IOErrorException("Update profile error: " + e.getMessage(), e);
        }
    }
}

