#!/usr/bin/perl -w
# remediator.pl version 1.56 3/29/08
# Copyright 2007, Jeffrey J. Headd and Robert Immormino

# revision 1.02 - JJH 070726 - fixed HN2/H2 N-terminus ambiguity
# revision 1.52 - JJH 070727 - added KIN file support
# revision 1.53 - JJH 070731 - updated hash tables to correct conversions
# revision 1.54 - JJH 070731 - fixed KIN file support for new probe dot format
# revision 1.55 - RI  070803 - added support for DU bases
# revision      - JJH 070823 - added support for CNS Xplor and Coot RNA names
# revision	- JJH 070908 - added REMARK   4 comment addition
# revision      - JJH 070913 - added support for left-justified RNA/DNA old names
# revision      - JJH 070913 - added support for all left-justified residue names
# revision 1.56 - JJH 080328 - fixed REMARK   4 comment addition to work w/ PHENIX generated files

if(!$ARGV[0]){
	&help;
	exit(0);
}

#-----------------------------------------------------------------------
sub help{
        print "\n*******************************************************************
remediator.pl: version 1.56 3/28/08\nCopyright 2007, Jeffrey J. Headd and Robert Immormino 
For a log of changes, view remediator.pl in your favorite text editor

LAST CIF DICTIONARY UPDATE:  080507
 

USAGE: remediator.pl [-options] input_file

options:
  -h 		outputs this help message
  -pdb		takes a .pdb formatted file as input (default)
  -kin		takes a .kin kinemage formatted file as input (under development) 
  -oldout 	output file will use the PDBv2.3 naming conventions
  -remediated 	output file will use the remediated naming conventions (default)

remediator.pl is generally inteded to convert from PDBv2.3 to PDBv3.0. 
This changes files from the pre-wwPDB format into the wwPDB remediated format.
Output is directed to standard out.

EXAMPLES:   remediator.pl 404D.pdb > 404Dr.pdb 
            remediator.pl -kin 1BAB.kin > 1BABr.kin \n\n";
        exit(0);
}
#-----------------------------------------------------------------------

$oldout = 0;
$remediated = 0;
$dopdb = 0;
$dokin = 0;
$input_pdb_flag = 0;
$input_kin_flag = 0;
$input=NULL;

for ($i=0; $i < scalar(@ARGV); $i++) {
	if(substr($ARGV[$i],0,1) eq "-"){
		if ($ARGV[$i] eq "-h"){
			&help;
			exit(0);
		}
		elsif ($ARGV[$i] eq "-oldout") { $oldout = 1; } 
		elsif ($ARGV[$i] eq "-remediated") { $remediated = 1; }
		elsif ($ARGV[$i] eq "-pdb") { $dopdb = 1; }
		elsif ($ARGV[$i] eq "-kin") { $dokin = 1; }
		else {	print STDERR "Unrecognized flag ".$ARGV[$i]." IGNORED\n"; }
	}
	elsif ($ARGV[$i] =~ m/.pdb/){
		if($input_pdb_flag==0 && $input_kin_flag==0){
			$input=$ARGV[$i];
			$input_pdb_flag=1;
		}
		else{
			print STDERR "Too many options!!  Exiting...\n";
			&help;
			exit(0);
		}
	}

	elsif ($ARGV[$i] =~ m/.kin/){ 
		if($input_pdb_flag==0 && $input_kin_flag==0){
			$input=$ARGV[$i]; 
			$input_kin_flag=1;
		}
		else{
			print STDERR "Too many options!!  Exiting...\n";
			&help;
			exit(0);
		}
	}
	else{ 
		if($input_pdb_flag==1 || $input_kin_flag==1){
			print STDERR "Too many options!!  Exiting...\n";
			&help;
			exit(0);
		}
		elsif($dokin == 1){
			print STDERR "Unrecognized input file extension!!  Assuming .kin file...\n";
			$input=$ARGV[0];
			$input_kin_flag=1;
		} 
		else{
			print STDERR "Unrecognized input file extension!!  Assuming .pdb file...\n";
			$input=$ARGV[0];
			$input_pdb_flag=1;
		}
	}
}

if($input eq NULL){
	print STDERR "User must specify input file!!  Exiting...\n";
	&help;
	exit(0);
}

if($dopdb == 0 && $dokin == 0){ $dopdb=1; }

if($dopdb == 1 && $input_pdb_flag == 0){
	print STDERR "Wrong file type for PDB mode!!  Exiting...\n";
	&help;
	exit(0);
}
elsif($dokin == 1 && $input_kin_flag == 0){
	print STDERR "Wrong file type for KIN mode!!  Exiting...\n";
	&help;
	exit(0);
}

if (!defined $input){ 
	print "\n Sorry, input file was not found!!  Exiting...\n"; 
	&help;
	exit(0);
}

if($remediated == 0 && $oldout == 0){ $remediated = 1; }

if($remediated == 1){ 
	&build_old2new; 
	$remark4="REMARK   4 REMEDIATOR VALIDATED PDB VERSION 3.0 COMPLIANT";
}
elsif($oldout == 1){ 
	&build_new2old; 
	$remark4="REMARK   4 REMEDIATOR VALIDATED PDB VERSION 2.3 COMPLIANT";
}

open IN, "$input" || die "Could not open input file!!  Exiting...\n";
if($dopdb == 1){ &pdb_mod; }
elsif($dokin == 1){ &kin_mod; }
close IN;

#--pdb_mod sub-routine-------------------------------------------------------------------------------------
sub pdb_mod{

$previous = "NULL";
$current = "NULL";
$print_line = "";
$remark_flag="NULL";
$remark_block="NULL";

while ($line=<IN>){

	chomp($line);
	$line =~ s/\s+$//;
	
	if($remark_flag eq "NULL"){
		if(substr($line,0,6) eq "REMARK"){
			#print "found remark\n";
			if($remark_block eq "NULL"){
				$remark_block = "DONE";
			}
			if($line=~m/$remark4/){
				$remark_flag="DONE";
			}
			elsif(length($line) < 10){
				$print_line .= $line."\n";
				next;
			}
			elsif($line=~m/REMARK...\D/){
				$print_line .= $line."\n";
				next;
			}
			elsif($line=~m/REMARK   4 REMEDIATOR/){
				next;
			}
			elsif(substr($line,6,4) =~m/[0-9]/ && substr($line,6,4)>4){
				$print_line .= "$remark4\n";
				$remark_flag="DONE";
			}
			else{
				$print_line .= $line."\n";
				next;
			}
			#print substr($line,6,4)."\n";
		}
	}

	if (substr($line, 0,6) eq "ATOM  " || substr($line, 0,6) eq "HETATM" ||
            substr($line, 0,6) eq "TER   " || substr($line, 0,6) eq "ANISOU" ||
            substr($line, 0,6) eq "SIGATM" || substr($line, 0,6) eq "SIGUIJ" ||
	    substr($line, 0,6) eq "LINK  "){
		if($remark_flag eq "NULL"){
			$print_line .= "$remark4\n";
			$remark_flag="DONE";
		}	
		#--pre-screen for CNS Xplor RNA base names and Coot RNA base names--------
		if($line=~m/\b.{17}(GUA|ADE|CYT|THY|URI)/){
			$line=~s/\b(.{17})(.)../$1  $2/;
		}
		elsif($line=~m/\b.{17}(OIP| Ar| Gr| Cr| Ur)/){
			$line=~s/\b(.{17}).(.)./$1  $2/;
		}
		#-------------------------------------------------------------------------

		#REMOVED IN FAVOR OF GENERIC SUBSITUTION BELOW
                #--pre-screen for left-justified RNA/DNA base names-----------------------
		#if($line=~m/\b.{17}(G  |A  |C  |T  |U  |I  )/){
		#	$line=~s/\b(.{17})(.)../$1  $2/;
		#}
                #-------------------------------------------------------------------------
		#-pre-screen for all left-justified residue names-------------------------
		if($line=~m/\A.{17}([a-zA-Z])  /){
			$line=~s/\A(.{17})(.)\s\s/$1  $2/;
		}
		elsif($line=~m/\A.{17}([a-zA-Z][a-zA-Z]) /){
			$line=~s/\A(.{17})(..)\s/$1 $2/;
		}
		#-------------------------------------------------------------------------
		$entry=substr($line,12,8);
		$previous=$current;
		$current=substr($line,18,8);
		$clean_entry = substr($entry,0,4)." ".substr($entry,5,3);
		if($resn_exch{$clean_entry}){
			substr($line,12,4) = substr($resn_exch{$clean_entry},0,4);
			substr($line,17,3) = substr($resn_exch{$clean_entry},5,3);
		} 
	}
	
	elsif ($remark_flag ne "DONE" && $remark_block eq "DONE"){
		$print_line .= "$remark4\n";
		$remark_flag = "DONE";
	} 
	if($previous eq "NULL"){ $previous = $current; }
	
	if($current eq $previous){
		$print_line .= $line."\n";
	}
	if($current ne $previous){
		
		if($print_line =~ m/(.\S..)  .[A,C,T,G,I,U] /){
			if($print_line !~ m/O2[\',\*]   ./){
				$DNA_base = substr($previous,1,1);
				if($remediated == 1){
					$print_line =~ s/(.\S..)   $DNA_base /$1  D$DNA_base /g;
					$print_line =~ s/(TER.{15}) $DNA_base /$1D$DNA_base /g;
				}
				elsif($oldout == 1){
					$print_line =~ s/(.\S..)  D$DNA_base /$1   $DNA_base /g;
					$print_line =~ s/(TER.{15})D$DNA_base /$1 $DNA_base /g;
				}
			}
			
		}
		if($oldout == 1){
			if($print_line =~ m/ HN2 (ALA|ARG|ASN|ASP|ASX|CSE|CYS|GLN|GLU|GLX|GLY|HIS|ILE|LEU|LYS|MET|MSE|PHE|PRO|SER|THR|TRP|UNK|TYR|VAL)/g){
				$res=$1;
				if($print_line =~ m/1H   $res/ || $print_line =~ m/3H   $res/){
					$print_line =~ s/ HN2 (ALA|ARG|ASN|ASP|ASX|CSE|CYS|GLN|GLU|GLX|GLY|HIS|ILE|LEU|LYS|MET|MSE|PHE|PRO|SER|THR|TRP|UNK|TYR|VAL)/2H   $1/g;
				}
			}
		}
		print $print_line;
		$print_line=$line."\n";
	} 
}

if($print_line =~ m/(.\S..)   [A,C,T,G,I,U] /){
	if($print_line !~ m/O2[\',\*]   ./){
		$DNA_base = substr($previous,1,1);
		if($remediated == 1){
			$print_line =~ s/(.\S..)   $DNA_base /$1  D$DNA_base /g;
			$print_line =~ s/(TER.{15}) $DNA_base /$1D$DNA_base /g;
		}
		elsif($oldout == 1){
			$print_line =~ s/(.\S..)  D$DNA_base /$1   $DNA_base /g;
			$print_line =~ s/(TER.{15})D$DNA_base /$1 $DNA_base /g;
		}
	}
	if($oldout == 1){
		if($print_line =~ m/ HN2 (ALA|ARG|ASN|ASP|ASX|CSE|CYS|GLN|GLU|GLX|GLY|HIS|ILE|LEU|LYS|MET|MSE|PHE|PRO|SER|THR|TRP|UNK|TYR|VAL)/g){
			$res=$1;
			if($print_line =~ m/1H   $res/ || $print_line =~ m/3H   $res/){
				$print_line =~ s/ HN2 (ALA|ARG|ASN|ASP|ASX|CSE|CYS|GLN|GLU|GLX|GLY|HIS|ILE|LEU|LYS|MET|MSE|PHE|PRO|SER|THR|TRP|UNK|TYR|VAL)/2H   $1/g;
			}
		}
	}
}
print $print_line;

}
#----------------------------------------------------------------------------------------------------------


#--kin_mod sub-routine-------------------------------------------------------------------------------------
sub kin_mod{

%RNA_ID=();

#pre-screen for RNA vs. DNA for -remediated
if($remediated == 1){
	while($line=<IN>){
		chomp($line);
		my(@records) = $line =~ m/\{.{8,}?\}/g;
	
		for($i=0;$i<scalar(@records);$i++){
			
			$atom=substr($records[$i],1,4);
			$chain=substr($records[$i],10,1);
			$atom =~ tr/[a-z]/[A-Z]/;
			$chain=~ tr/[a-z]/[A-Z]/;
			
			if($records[$i] =~ m/O2[\',\*]   ./i){
				
				if($records[$i] =~ m/\{.\S.....\S\s.\s\d+\s\sB\d/){
					my($res,$num) = $records[$i] =~ m/\{.\S...(..\S)\s.\s(\S+)\s/;
					$res .= $num;
					$res =~ tr/[a-z]/[A-Z]/;
					$RNA_ID{$chain." ".$res}="RNA";
				}
			}
		}
	}
	close IN;
	open IN, "$input" || die "Could not open input file!!  Exiting...\n";

}

while($line=<IN>){

	chomp($line);
	my(@records) = $line =~ m/\{.{8,}?\}/g;
	
	
	for($i=0;$i<scalar(@records);$i++){
		$atom=substr($records[$i],1,4); 
		$atom =~ tr/[a-z]/[A-Z]/;
		if($records[$i] =~ m/\{.\S...(..\S)(\S+)\s(\S)\}/){
			$res = $1;
			$num = $2;
			$chain = $3;
			$res =~ tr/[a-z]/[A-Z]/;
			$chain =~ tr/[a-z]/[A-Z]/;
			if($resn_exch{$atom." ".$res}){
				$new_atom=substr($resn_exch{$atom." ".$res},0,4);
				$atom =~ s/(\*)/\\$1/g;
				$line =~ s/$atom(.)$res/$new_atom$1$res/;
				$atom=$new_atom;
			}
			if($remediated == 1){
				if($res =~ m/(  G|  C|  T|  A|  I|  U)/i){
					if(!$RNA_ID{$chain." ".$res.$num}){
						$base = substr($res,2,1);
						$line =~ s/$atom(.)$res/$atom$1 D$base/;
					}
				}
			}
			elsif($oldout == 1){
				if($res =~ m/( DG| DC| DT| DA| DI| DU)/i){
					$base = substr($res,2,1);
					$atom =~ s/(\*)/\\$1/g;
					$line =~ s/($atom)(.)$res/$1$2  $base/;
				}
			}
			
		}
		elsif($records[$i] =~ m/\{.\S...(..\S)\s(.)\s(\d+)\s\sB\d/){
			$res=$1;
			$chain=$2;
			$num=$3;
			$res =~ tr/[a-z]/[A-Z]/;
			$chain =~ tr/[a-z]/[A-Z]/;
			if($resn_exch{$atom." ".$res}){
				$new_atom=substr($resn_exch{$atom." ".$res},0,4);
				$atom =~ tr/[A-Z]/[a-z]/;
				$res =~ tr/[A-Z]/[a-z]/;
				$new_atom =~ tr/[A-Z]/[a-z]/;
				$atom =~ s/(\*)/\\$1/g;
				if(!($line =~ s/$atom(.)$res/$new_atom$1$res/)){
					print STDERR "substitution failed!!!\n";
				}
				$atom=$new_atom;
			}
			if($remediated == 1){
				if($res =~ m/(  G|  C|  T|  A|  I|  U)/i){
					$res .= $num;
					$res =~ tr/[a-z]/[A-Z]/;
					if(!$RNA_ID{$chain." ".$res}){
						$res =~ tr/[A-Z]/[a-z]/;
						$atom =~ tr/[A-Z]/[a-z]/;
						$base = substr($res,2,1);
						$res = substr($res,0,3);
						$line =~ s/$atom(.)$res/$atom$1 d$base/;
					}
				}
			}
			elsif($oldout == 1){
				if($res =~ m/( DG| DC| DT| DA| DI| DU)/i){
					$res =~ tr/[A-Z]/[a-z]/;
					$atom =~ tr/[A-Z]/[a-z]/;
					$atom =~ s/(\*)/\\$1/g;
					$base = substr($res,2,1);
					$line =~ s/($atom)(.)$res/$1$2  $base/;
				}
			}

		}
	}
	
	print $line."\n";

}


}
#----------------------------------------------------------------------------------------------------------


sub build_old2new{

%resn_exch=();

$resn_exch{" C5A  DT"}=" C7   DT"; $resn_exch{"2H2*   A"}="H2''   A"; $resn_exch{"2H2*   C"}="H2''   C";
$resn_exch{"2H2*   T"}="H2''   T"; $resn_exch{"2H2*   G"}="H2''   G"; $resn_exch{"2H2*   I"}="H2''   I";
$resn_exch{"1H2*   A"}=" H2'   A"; $resn_exch{"1H2*   C"}=" H2'   C"; $resn_exch{"1H2*   U"}=" H2'   U";
$resn_exch{"1H2*   G"}=" H2'   G"; $resn_exch{"1H2*   I"}=" H2'   I"; $resn_exch{"5HO*   A"}="HO5'   A";
$resn_exch{"5HO*   C"}="HO5'   C"; $resn_exch{"5HO*   U"}="HO5'   U"; $resn_exch{"5HO*   G"}="HO5'   G";
$resn_exch{"5HO*   I"}="HO5'   I"; $resn_exch{"5HO*  DT"}="HO5'  DT"; $resn_exch{"5HO*  DA"}="HO5'  DA";
$resn_exch{"5HO*  DC"}="HO5'  DC"; $resn_exch{"5HO*  DG"}="HO5'  DG"; $resn_exch{"5HO*  DI"}="HO5'  DI";
$resn_exch{"5HO*  DU"}="HO5'  DU"; $resn_exch{"3HO*   A"}="HO3'   A"; $resn_exch{"3HO*   C"}="HO3'   C";
$resn_exch{"3HO*   U"}="HO3'   U"; $resn_exch{"3HO*   G"}="HO3'   G"; $resn_exch{"3HO*   I"}="HO3'   I";
$resn_exch{"3HO*  DT"}="HO3'  DT"; $resn_exch{"3HO*  DA"}="HO3'  DA"; $resn_exch{"3HO*  DC"}="HO3'  DC";
$resn_exch{"3HO*  DG"}="HO3'  DG"; $resn_exch{"3HO*  DI"}="HO3'  DI"; $resn_exch{"3HO*  DU"}="HO3'  DU";
$resn_exch{"1H   GLY"}=" H1  GLY"; $resn_exch{"2H   GLY"}=" H2  GLY"; $resn_exch{"3H   GLY"}=" H3  GLY";
$resn_exch{"1H   ALA"}=" H1  ALA"; $resn_exch{"2H   ALA"}=" H2  ALA"; $resn_exch{"3H   ALA"}=" H3  ALA";
$resn_exch{"1H   VAL"}=" H1  VAL"; $resn_exch{"2H   VAL"}=" H2  VAL"; $resn_exch{"3H   VAL"}=" H3  VAL";
$resn_exch{"1H   PHE"}=" H1  PHE"; $resn_exch{"2H   PHE"}=" H2  PHE"; $resn_exch{"3H   PHE"}=" H3  PHE";
$resn_exch{"1H   PRO"}=" H1  PRO"; $resn_exch{"2H   PRO"}=" H2  PRO"; $resn_exch{"3H   PRO"}=" H3  PRO";
$resn_exch{"1H   MET"}=" H1  MET"; $resn_exch{"2H   MET"}=" H2  MET"; $resn_exch{"3H   MET"}=" H3  MET";
$resn_exch{"1H   ILE"}=" H1  ILE"; $resn_exch{"2H   ILE"}=" H2  ILE"; $resn_exch{"3H   ILE"}=" H3  ILE";
$resn_exch{"1H   LEU"}=" H1  LEU"; $resn_exch{"2H   LEU"}=" H2  LEU"; $resn_exch{"3H   LEU"}=" H3  LEU";
$resn_exch{"1H   ASP"}=" H1  ASP"; $resn_exch{"2H   ASP"}=" H2  ASP"; $resn_exch{"3H   ASP"}=" H3  ASP";
$resn_exch{"1H   GLU"}=" H1  GLU"; $resn_exch{"2H   GLU"}=" H2  GLU"; $resn_exch{"3H   GLU"}=" H3  GLU";
$resn_exch{"1H   LYS"}=" H1  LYS"; $resn_exch{"2H   LYS"}=" H2  LYS"; $resn_exch{"3H   LYS"}=" H3  LYS";
$resn_exch{"1H   ARG"}=" H1  ARG"; $resn_exch{"2H   ARG"}=" H2  ARG"; $resn_exch{"3H   ARG"}=" H3  ARG";
$resn_exch{"1H   SER"}=" H1  SER"; $resn_exch{"2H   SER"}=" H2  SER"; $resn_exch{"3H   SER"}=" H3  SER";
$resn_exch{"1H   THR"}=" H1  THR"; $resn_exch{"2H   THR"}=" H2  THR"; $resn_exch{"3H   THR"}=" H3  THR";
$resn_exch{"1H   HIS"}=" H1  HIS"; $resn_exch{"2H   HIS"}=" H2  HIS"; $resn_exch{"3H   HIS"}=" H3  HIS";
$resn_exch{"1H   CYS"}=" H1  CYS"; $resn_exch{"2H   CYS"}=" H2  CYS"; $resn_exch{"3H   CYS"}=" H3  CYS";
$resn_exch{"1H   ASN"}=" H1  ASN"; $resn_exch{"2H   ASN"}=" H2  ASN"; $resn_exch{"3H   ASN"}=" H3  ASN";
$resn_exch{"1H   GLN"}=" H1  GLN"; $resn_exch{"2H   GLN"}=" H2  GLN"; $resn_exch{"3H   GLN"}=" H3  GLN";
$resn_exch{"1H   TRP"}=" H1  TRP"; $resn_exch{"2H   TRP"}=" H2  TRP"; $resn_exch{"3H   TRP"}=" H3  TRP";
$resn_exch{"1H   ASX"}=" H1  ASX"; $resn_exch{"2H   ASX"}=" H2  ASX"; $resn_exch{"3H   ASX"}=" H3  ASX";
$resn_exch{"1H   GLX"}=" H1  GLX"; $resn_exch{"2H   GLX"}=" H2  GLX"; $resn_exch{"3H   GLX"}=" H3  GLX";
$resn_exch{"1H   ABU"}=" H1  ABU"; $resn_exch{"2H   ABU"}=" H2  ABU"; $resn_exch{"3H   ABU"}=" H3  ABU";
$resn_exch{"1H   AIB"}=" H1  AIB"; $resn_exch{"2H   AIB"}=" H2  AIB"; $resn_exch{"3H   AIB"}=" H3  AIB";
$resn_exch{"1H   ABU"}=" H1  ABU"; $resn_exch{"2H   ABU"}=" H2  ABU"; $resn_exch{"3H   ABU"}=" H3  ABU";
$resn_exch{"1H   MSE"}=" H1  MSE"; $resn_exch{"2H   MSE"}=" H2  MSE"; $resn_exch{"3H   MSE"}=" H3  MSE";
$resn_exch{"1H   PCA"}=" H1  PCA"; $resn_exch{"2H   PCA"}=" H2  PCA"; $resn_exch{"3H   PCA"}=" H3  PCA";
$resn_exch{"1HN  0AO"}=" HN1 0AO"; $resn_exch{" OD  0AZ"}=" OD1 0AZ"; $resn_exch{" O5* 101"}=" O5' 101";
$resn_exch{" C5* 101"}=" C5' 101"; $resn_exch{" C4* 101"}=" C4' 101"; $resn_exch{" O4* 101"}=" O4' 101";
$resn_exch{" C3* 101"}=" C3' 101"; $resn_exch{" O3* 101"}=" O3' 101"; $resn_exch{" C2* 101"}=" C2' 101";
$resn_exch{" C1* 101"}=" C1' 101"; $resn_exch{" O5* 102"}=" O5' 102"; $resn_exch{" C5* 102"}=" C5' 102";
$resn_exch{" C4* 102"}=" C4' 102"; $resn_exch{" O4* 102"}=" O4' 102"; $resn_exch{" C3* 102"}=" C3' 102";
$resn_exch{" O3* 102"}=" O3' 102"; $resn_exch{" C2* 102"}=" C2' 102"; $resn_exch{" O2* 102"}=" O2' 102";
$resn_exch{" C1* 102"}=" C1' 102"; $resn_exch{" C5* 103"}=" C5' 103"; $resn_exch{" C4* 103"}=" C4' 103";
$resn_exch{" O4* 103"}=" O4' 103"; $resn_exch{" C3* 103"}=" C3' 103"; $resn_exch{" O3* 103"}=" O3' 103";
$resn_exch{" C2* 103"}=" C2' 103"; $resn_exch{" C1* 103"}=" C1' 103"; $resn_exch{" O5* 10C"}=" O5' 10C";
$resn_exch{" C5* 10C"}=" C5' 10C"; $resn_exch{" C4* 10C"}=" C4' 10C"; $resn_exch{" O4* 10C"}=" O4' 10C";
$resn_exch{" C1* 10C"}=" C1' 10C"; $resn_exch{" C3* 10C"}=" C3' 10C"; $resn_exch{" C2* 10C"}=" C2' 10C";
$resn_exch{" O2* 10C"}=" O2' 10C"; $resn_exch{" O3* 10C"}=" O3' 10C"; $resn_exch{" C6* 10C"}=" C6' 10C";
$resn_exch{" O5* 112"}=" O5' 112"; $resn_exch{" C5* 112"}=" C5' 112"; $resn_exch{" C4* 112"}=" C4' 112";
$resn_exch{" O4* 112"}=" O4' 112"; $resn_exch{" C3* 112"}=" C3' 112"; $resn_exch{" O3* 112"}=" O3' 112";
$resn_exch{" C2* 112"}=" C2' 112"; $resn_exch{" O2* 112"}=" O2' 112"; $resn_exch{" C1* 112"}=" C1' 112";
$resn_exch{" O1P 125"}=" OP1 125"; $resn_exch{" O2P 125"}=" OP2 125"; $resn_exch{" O3P 125"}=" OP3 125";
$resn_exch{" O5* 125"}=" O5' 125"; $resn_exch{" C5* 125"}=" C5' 125"; $resn_exch{" C4* 125"}=" C4' 125";
$resn_exch{" O4* 125"}=" O4' 125"; $resn_exch{" C3* 125"}=" C3' 125"; $resn_exch{" O3* 125"}=" O3' 125";
$resn_exch{" C2* 125"}=" C2' 125"; $resn_exch{" O2* 125"}=" O2' 125"; $resn_exch{" C1* 125"}=" C1' 125";
$resn_exch{" CA* 125"}=" CA' 125"; $resn_exch{" CB* 125"}=" CB' 125"; $resn_exch{" FC* 125"}=" FC' 125";
$resn_exch{" O1P 126"}=" OP1 126"; $resn_exch{" O2P 126"}=" OP2 126"; $resn_exch{" O3P 126"}=" OP3 126";
$resn_exch{" O5* 126"}=" O5' 126"; $resn_exch{" C5* 126"}=" C5' 126"; $resn_exch{" C4* 126"}=" C4' 126";
$resn_exch{" O4* 126"}=" O4' 126"; $resn_exch{" C3* 126"}=" C3' 126"; $resn_exch{" O3* 126"}=" O3' 126";
$resn_exch{" C2* 126"}=" C2' 126"; $resn_exch{" O2* 126"}=" O2' 126"; $resn_exch{" C1* 126"}=" C1' 126";
$resn_exch{" CA* 126"}=" CA' 126"; $resn_exch{" CB* 126"}=" CB' 126"; $resn_exch{" OC* 126"}=" OC' 126";
$resn_exch{" CD* 126"}=" CD' 126"; $resn_exch{" CE* 126"}=" CE' 126"; $resn_exch{" OF* 126"}=" OF' 126";
$resn_exch{" CG* 126"}=" CG' 126"; $resn_exch{" CH* 126"}=" CH' 126"; $resn_exch{" OI* 126"}=" OI' 126";
$resn_exch{" CK* 126"}=" CK' 126"; $resn_exch{" O1P 127"}=" OP1 127"; $resn_exch{" O2P 127"}=" OP2 127";
$resn_exch{" O3P 127"}=" OP3 127"; $resn_exch{" O5* 127"}=" O5' 127"; $resn_exch{" C5* 127"}=" C5' 127";
$resn_exch{" C4* 127"}=" C4' 127"; $resn_exch{" O4* 127"}=" O4' 127"; $resn_exch{" C3* 127"}=" C3' 127";
$resn_exch{" O3* 127"}=" O3' 127"; $resn_exch{" C2* 127"}=" C2' 127"; $resn_exch{" O2* 127"}=" O2' 127";
$resn_exch{" C1* 127"}=" C1' 127"; $resn_exch{" CA* 127"}=" CA' 127"; $resn_exch{" CB* 127"}=" CB' 127";
$resn_exch{" OC* 127"}=" OC' 127"; $resn_exch{" ND* 127"}=" ND' 127"; $resn_exch{" O5* 128"}=" O5' 128";
$resn_exch{" C5* 128"}=" C5' 128"; $resn_exch{" C4* 128"}=" C4' 128"; $resn_exch{" O4* 128"}=" O4' 128";
$resn_exch{" C3* 128"}=" C3' 128"; $resn_exch{" O3* 128"}=" O3' 128"; $resn_exch{" C2* 128"}=" C2' 128";
$resn_exch{" O2* 128"}=" O2' 128"; $resn_exch{" C1* 128"}=" C1' 128"; $resn_exch{" O3P 12A"}=" OP3 12A";
$resn_exch{" O1P 12A"}=" OP1 12A"; $resn_exch{" O2P 12A"}=" OP2 12A"; $resn_exch{" O5* 12A"}=" O5' 12A";
$resn_exch{" C5* 12A"}=" C5' 12A"; $resn_exch{" C4* 12A"}=" C4' 12A"; $resn_exch{" O4* 12A"}=" O4' 12A";
$resn_exch{" C3* 12A"}=" C3' 12A"; $resn_exch{" O3* 12A"}=" O3' 12A"; $resn_exch{" C2* 12A"}=" C2' 12A";
$resn_exch{" O2* 12A"}=" O2' 12A"; $resn_exch{" C1* 12A"}=" C1' 12A"; $resn_exch{" C1* 130"}=" C1B 130";
$resn_exch{" C2* 130"}=" C2B 130"; $resn_exch{" C3* 130"}=" C3B 130"; $resn_exch{" C4* 130"}=" C4B 130";
$resn_exch{" C5* 130"}=" C5B 130"; $resn_exch{" C6* 130"}=" C6B 130"; $resn_exch{" C1* 132"}=" C1B 132";
$resn_exch{" C2* 132"}=" C2B 132"; $resn_exch{" C3* 132"}=" C3B 132"; $resn_exch{" C4* 132"}=" C4B 132";
$resn_exch{" C5* 132"}=" C5B 132"; $resn_exch{" C6* 132"}=" C6B 132"; $resn_exch{" C1* 134"}=" C1B 134";
$resn_exch{" C2* 134"}=" C2B 134"; $resn_exch{" C3* 134"}=" C3B 134"; $resn_exch{" C4* 134"}=" C4B 134";
$resn_exch{" C5* 134"}=" C5B 134"; $resn_exch{" C6* 134"}=" C6B 134"; $resn_exch{"O5*A 139"}=" O5D 139";
$resn_exch{"C5*A 139"}=" C5D 139"; $resn_exch{"C4*A 139"}=" C4D 139"; $resn_exch{"O4*A 139"}=" O4D 139";
$resn_exch{"C1*A 139"}=" C1D 139"; $resn_exch{"C2*A 139"}=" C2D 139"; $resn_exch{"O2*A 139"}=" O2D 139";
$resn_exch{"C3*A 139"}=" C3D 139"; $resn_exch{"O3*A 139"}=" O3D 139"; $resn_exch{"O5*U 139"}=" O5B 139";
$resn_exch{"C5*U 139"}=" C5B 139"; $resn_exch{"C4*U 139"}=" C4B 139"; $resn_exch{"O4*U 139"}=" O4B 139";
$resn_exch{"C1*U 139"}=" C1B 139"; $resn_exch{"C2*U 139"}=" C2B 139"; $resn_exch{"C3*U 139"}=" C3B 139";
$resn_exch{"O3*U 139"}=" O3B 139"; $resn_exch{" CD* 176"}=" CDB 176"; $resn_exch{" CG* 176"}=" CGB 176";
$resn_exch{" CD* 177"}=" CDB 177"; $resn_exch{" CG* 177"}=" CGB 177"; $resn_exch{" O5* 191"}=" O5' 191";
$resn_exch{" C5* 191"}=" C5' 191"; $resn_exch{" C4* 191"}=" C4' 191"; $resn_exch{" O4* 191"}=" O4' 191";
$resn_exch{" C3* 191"}=" C3' 191"; $resn_exch{" O3* 191"}=" O3' 191"; $resn_exch{" C2* 191"}=" C2' 191";
$resn_exch{" O2* 191"}=" O2' 191"; $resn_exch{" C1* 191"}=" C1' 191"; $resn_exch{" C9* 1AA"}=" C9' 1AA";
$resn_exch{" C8* 1AA"}=" C8' 1AA"; $resn_exch{" C7* 1AA"}=" C7' 1AA"; $resn_exch{" O2* 1AA"}=" O2' 1AA";
$resn_exch{" O4* 1AA"}=" O4' 1AA"; $resn_exch{" O3* 1AA"}=" O3' 1AA"; $resn_exch{" O1* 1AA"}=" O1' 1AA";
$resn_exch{" C1* 1AA"}=" C1' 1AA"; $resn_exch{" C2* 1AA"}=" C2' 1AA"; $resn_exch{" C3* 1AA"}=" C3' 1AA";
$resn_exch{" C4* 1AA"}=" C4' 1AA"; $resn_exch{" C5* 1AA"}=" C5' 1AA"; $resn_exch{" C6* 1AA"}=" C6' 1AA";
$resn_exch{" O1P 1AP"}=" OP1 1AP"; $resn_exch{" O2P 1AP"}=" OP2 1AP"; $resn_exch{" O3P 1AP"}=" OP3 1AP";
$resn_exch{" O5* 1DA"}=" O5' 1DA"; $resn_exch{" C5* 1DA"}=" C5' 1DA"; $resn_exch{" C4* 1DA"}=" C4' 1DA";
$resn_exch{" O4* 1DA"}=" O4' 1DA"; $resn_exch{" C3* 1DA"}=" C3' 1DA"; $resn_exch{" O3* 1DA"}=" O3' 1DA";
$resn_exch{" C2* 1DA"}=" C2' 1DA"; $resn_exch{" O2* 1DA"}=" O2' 1DA"; $resn_exch{" C1* 1DA"}=" C1' 1DA";
$resn_exch{" C1* 1DG"}=" C1' 1DG"; $resn_exch{" O4* 1DG"}=" O4' 1DG"; $resn_exch{" C2* 1DG"}=" C2' 1DG";
$resn_exch{" O2* 1DG"}=" O2' 1DG"; $resn_exch{" C3* 1DG"}=" C3' 1DG"; $resn_exch{" O3* 1DG"}=" O3' 1DG";
$resn_exch{" C4* 1DG"}=" C4' 1DG"; $resn_exch{" C5* 1DG"}=" C5' 1DG"; $resn_exch{" O5* 1DG"}=" O5' 1DG";
$resn_exch{"C10' 1IQ"}=" CA' 1IQ"; $resn_exch{"C11' 1IQ"}=" CB' 1IQ"; $resn_exch{"O12' 1IQ"}=" OC' 1IQ";
$resn_exch{"O13' 1IQ"}=" OD' 1IQ"; $resn_exch{" O1P 1MA"}=" OP1 1MA"; $resn_exch{" O2P 1MA"}=" OP2 1MA";
$resn_exch{" O3P 1MA"}=" OP3 1MA"; $resn_exch{" O5* 1MA"}=" O5' 1MA"; $resn_exch{" C5* 1MA"}=" C5' 1MA";
$resn_exch{" C4* 1MA"}=" C4' 1MA"; $resn_exch{" O4* 1MA"}=" O4' 1MA"; $resn_exch{" C3* 1MA"}=" C3' 1MA";
$resn_exch{" O3* 1MA"}=" O3' 1MA"; $resn_exch{" C2* 1MA"}=" C2' 1MA"; $resn_exch{" O2* 1MA"}=" O2' 1MA";
$resn_exch{" C1* 1MA"}=" C1' 1MA"; $resn_exch{" O1P 1MG"}=" OP1 1MG"; $resn_exch{" O2P 1MG"}=" OP2 1MG";
$resn_exch{" O3P 1MG"}=" OP3 1MG"; $resn_exch{" O5* 1MG"}=" O5' 1MG"; $resn_exch{" C5* 1MG"}=" C5' 1MG";
$resn_exch{" C4* 1MG"}=" C4' 1MG"; $resn_exch{" O4* 1MG"}=" O4' 1MG"; $resn_exch{" C3* 1MG"}=" C3' 1MG";
$resn_exch{" O3* 1MG"}=" O3' 1MG"; $resn_exch{" C2* 1MG"}=" C2' 1MG"; $resn_exch{" O2* 1MG"}=" O2' 1MG";
$resn_exch{" C1* 1MG"}=" C1' 1MG"; $resn_exch{"1O0' 1PR"}=" O'1 1PR"; $resn_exch{" C1\" 1PR"}=" C1B 1PR";
$resn_exch{" C2\" 1PR"}=" C2B 1PR"; $resn_exch{" C3\" 1PR"}=" C3B 1PR"; $resn_exch{" C4\" 1PR"}=" C4B 1PR";
$resn_exch{" C5\" 1PR"}=" C5B 1PR"; $resn_exch{" O2\" 1PR"}=" O2B 1PR"; $resn_exch{" O3\" 1PR"}=" O3B 1PR";
$resn_exch{" O4\" 1PR"}=" O4B 1PR"; $resn_exch{" O6\" 1PR"}=" O6B 1PR"; $resn_exch{" P7\" 1PR"}=" P7B 1PR";
$resn_exch{"1O2\" 1PR"}=" O'L 1PR"; $resn_exch{" O8\" 1PR"}=" O8B 1PR"; $resn_exch{" O9\" 1PR"}=" O9B 1PR";
$resn_exch{" O5* 1RB"}=" O5' 1RB"; $resn_exch{" C5* 1RB"}=" C5' 1RB"; $resn_exch{" C4* 1RB"}=" C4' 1RB";
$resn_exch{" O4* 1RB"}=" O4' 1RB"; $resn_exch{" C3* 1RB"}=" C3' 1RB"; $resn_exch{" O3* 1RB"}=" O3' 1RB";
$resn_exch{" C2* 1RB"}=" C2' 1RB"; $resn_exch{" O2* 1RB"}=" O2' 1RB"; $resn_exch{" C1* 1RB"}=" C1' 1RB";
$resn_exch{" O5* 1SC"}=" O5' 1SC"; $resn_exch{" C5* 1SC"}=" C5' 1SC"; $resn_exch{" C4* 1SC"}=" C4' 1SC";
$resn_exch{" O4* 1SC"}=" O4' 1SC"; $resn_exch{" C3* 1SC"}=" C3' 1SC"; $resn_exch{" O3* 1SC"}=" O3' 1SC";
$resn_exch{" C2* 1SC"}=" C2' 1SC"; $resn_exch{" O2* 1SC"}=" O2' 1SC"; $resn_exch{" C1* 1SC"}=" C1' 1SC";
$resn_exch{" N1* 1TP"}=" N1' 1TP"; $resn_exch{" C2* 1TP"}=" C2' 1TP"; $resn_exch{" N3* 1TP"}=" N3' 1TP";
$resn_exch{" C4* 1TP"}=" C4' 1TP"; $resn_exch{" N4* 1TP"}=" N4' 1TP"; $resn_exch{" C5* 1TP"}=" C5' 1TP";
$resn_exch{" C6* 1TP"}=" C6' 1TP"; $resn_exch{" C7* 1TP"}=" C7' 1TP"; $resn_exch{" N1* 223"}=" N1' 223";
$resn_exch{" C6* 223"}=" C6' 223"; $resn_exch{" C4* 223"}=" C4' 223"; $resn_exch{" C5* 223"}=" C5' 223";
$resn_exch{" O5* 223"}=" O5' 223"; $resn_exch{" C3* 223"}=" C3' 223"; $resn_exch{" O3* 223"}=" O3' 223";
$resn_exch{" C2* 223"}=" C2' 223"; $resn_exch{"C11' 232"}=" CB' 232"; $resn_exch{"C12' 232"}=" CC' 232";
$resn_exch{"C13' 232"}=" CD' 232"; $resn_exch{"C14' 232"}=" CE' 232"; $resn_exch{"C15' 232"}=" CF' 232";
$resn_exch{"C16' 232"}=" CG' 232"; $resn_exch{"C17' 232"}=" CH' 232"; $resn_exch{"C19' 232"}=" CJ' 232";
$resn_exch{"C10' 232"}=" CA' 232"; $resn_exch{"O10' 232"}=" OA' 232"; $resn_exch{"C18' 232"}=" CI' 232";
$resn_exch{"C20' 232"}=" CK' 232"; $resn_exch{"N21' 232"}=" NL' 232"; $resn_exch{"C22' 232"}=" CM' 232";
$resn_exch{"C23' 232"}=" CN' 232"; $resn_exch{"C24' 232"}=" CO' 232"; $resn_exch{"C25' 232"}=" CP' 232";
$resn_exch{"C26' 232"}=" CQ' 232"; $resn_exch{"C27' 232"}=" CR' 232"; $resn_exch{"CLAR 23D"}="CL1  23D";
$resn_exch{" O   23F"}=" OXT 23F"; $resn_exch{" OXT 23F"}=" O   23F"; $resn_exch{" O5* 23T"}=" O5' 23T";
$resn_exch{" C5* 23T"}=" C5' 23T"; $resn_exch{" C4* 23T"}=" C4' 23T"; $resn_exch{" O4* 23T"}=" O4' 23T";
$resn_exch{" C1* 23T"}=" C1' 23T"; $resn_exch{" C2* 23T"}=" C2' 23T"; $resn_exch{" C3* 23T"}=" C3' 23T";
$resn_exch{" O5* 25A"}=" O5' 25A"; $resn_exch{" C5* 25A"}=" C5' 25A"; $resn_exch{" C4* 25A"}=" C4' 25A";
$resn_exch{" O4* 25A"}=" O4' 25A"; $resn_exch{" C1* 25A"}=" C1' 25A"; $resn_exch{" C2* 25A"}=" C2' 25A";
$resn_exch{" O2* 25A"}=" O2' 25A"; $resn_exch{" C3* 25A"}=" C3' 25A"; $resn_exch{" O3* 25A"}=" O3' 25A";
$resn_exch{"O11P 25A"}=" OBP 25A"; $resn_exch{"O12P 25A"}=" OCP 25A"; $resn_exch{"O15* 25A"}=" OF' 25A";
$resn_exch{"C15* 25A"}=" CF' 25A"; $resn_exch{"C14* 25A"}=" CE' 25A"; $resn_exch{"O14* 25A"}=" OE' 25A";
$resn_exch{"C11* 25A"}=" CB' 25A"; $resn_exch{"C12* 25A"}=" CC' 25A"; $resn_exch{"O12* 25A"}=" OC' 25A";
$resn_exch{"C13* 25A"}=" CD' 25A"; $resn_exch{"O13* 25A"}=" OD' 25A"; $resn_exch{"O21P 25A"}=" OLP 25A";
$resn_exch{"O22P 25A"}=" OMP 25A"; $resn_exch{"O25* 25A"}=" OP' 25A"; $resn_exch{"C25* 25A"}=" CP' 25A";
$resn_exch{"C24* 25A"}=" CO' 25A"; $resn_exch{"O24* 25A"}=" OO' 25A"; $resn_exch{"C21* 25A"}=" CL' 25A";
$resn_exch{"C22* 25A"}=" CM' 25A"; $resn_exch{"O22* 25A"}=" OM' 25A"; $resn_exch{"C23* 25A"}=" CN' 25A";
$resn_exch{"O23* 25A"}=" ON' 25A"; $resn_exch{" C1* 26A"}=" C1' 26A"; $resn_exch{" O4* 26A"}=" O4' 26A";
$resn_exch{" C4* 26A"}=" C4' 26A"; $resn_exch{" C5* 26A"}=" C5' 26A"; $resn_exch{" O5* 26A"}=" O5' 26A";
$resn_exch{" C2* 26A"}=" C2' 26A"; $resn_exch{" O2* 26A"}=" O2' 26A"; $resn_exch{" C3* 26A"}=" C3' 26A";
$resn_exch{" O3* 26A"}=" O3' 26A"; $resn_exch{" C9* 2AA"}=" C9' 2AA"; $resn_exch{" C8* 2AA"}=" C8' 2AA";
$resn_exch{" C7* 2AA"}=" C7' 2AA"; $resn_exch{" C6* 2AA"}=" C6' 2AA"; $resn_exch{" C5* 2AA"}=" C5' 2AA";
$resn_exch{" C4* 2AA"}=" C4' 2AA"; $resn_exch{" C3* 2AA"}=" C3' 2AA"; $resn_exch{" C2* 2AA"}=" C2' 2AA";
$resn_exch{" O3* 2AA"}=" O3' 2AA"; $resn_exch{" O4* 2AA"}=" O4' 2AA"; $resn_exch{" C1* 2AA"}=" C1' 2AA";
$resn_exch{" O2* 2AA"}=" O2' 2AA"; $resn_exch{" O1* 2AA"}=" O1' 2AA"; $resn_exch{" O5* 2AD"}=" O5' 2AD";
$resn_exch{" C5* 2AD"}=" C5' 2AD"; $resn_exch{" C4* 2AD"}=" C4' 2AD"; $resn_exch{" O4* 2AD"}=" O4' 2AD";
$resn_exch{" C3* 2AD"}=" C3' 2AD"; $resn_exch{" O3* 2AD"}=" O3' 2AD"; $resn_exch{" C2* 2AD"}=" C2' 2AD";
$resn_exch{" C1* 2AD"}=" C1' 2AD"; $resn_exch{" C5* 2AM"}=" C5' 2AM"; $resn_exch{" O5* 2AM"}=" O5' 2AM";
$resn_exch{" C4* 2AM"}=" C4' 2AM"; $resn_exch{" O4* 2AM"}=" O4' 2AM"; $resn_exch{" C3* 2AM"}=" C3' 2AM";
$resn_exch{" O3* 2AM"}=" O3' 2AM"; $resn_exch{" C2* 2AM"}=" C2' 2AM"; $resn_exch{" O2* 2AM"}=" O2' 2AM";
$resn_exch{" C1* 2AM"}=" C1' 2AM"; $resn_exch{" O1P 2AR"}=" OP1 2AR"; $resn_exch{" O2P 2AR"}=" OP2 2AR";
$resn_exch{" O3P 2AR"}=" OP3 2AR"; $resn_exch{" O5* 2AR"}=" O5' 2AR"; $resn_exch{" C5* 2AR"}=" C5' 2AR";
$resn_exch{" C4* 2AR"}=" C4' 2AR"; $resn_exch{" CX* 2AR"}=" CX' 2AR"; $resn_exch{" C1* 2AR"}=" C1' 2AR";
$resn_exch{" C2* 2AR"}=" C2' 2AR"; $resn_exch{" C3* 2AR"}=" C3' 2AR"; $resn_exch{" O3* 2AR"}=" O3' 2AR";
$resn_exch{" O1P 2AT"}=" OP1 2AT"; $resn_exch{" O2P 2AT"}=" OP2 2AT"; $resn_exch{" O5* 2AT"}=" O5' 2AT";
$resn_exch{" C5* 2AT"}=" C5' 2AT"; $resn_exch{" C4* 2AT"}=" C4' 2AT"; $resn_exch{" O4* 2AT"}=" O4' 2AT";
$resn_exch{" C1* 2AT"}=" C1' 2AT"; $resn_exch{" C2* 2AT"}=" C2' 2AT"; $resn_exch{" O2* 2AT"}=" O2' 2AT";
$resn_exch{" C3* 2AT"}=" C3' 2AT"; $resn_exch{" O3* 2AT"}=" O3' 2AT"; $resn_exch{" O3P 2AT"}=" OP3 2AT";
$resn_exch{" O3P 2AU"}=" OP3 2AU"; $resn_exch{" O1P 2AU"}=" OP1 2AU"; $resn_exch{" O5* 2AU"}=" O5' 2AU";
$resn_exch{" C5* 2AU"}=" C5' 2AU"; $resn_exch{" C4* 2AU"}=" C4' 2AU"; $resn_exch{" O4* 2AU"}=" O4' 2AU";
$resn_exch{" C3* 2AU"}=" C3' 2AU"; $resn_exch{" O3* 2AU"}=" O3' 2AU"; $resn_exch{" C2* 2AU"}=" C2' 2AU";
$resn_exch{" C1* 2AU"}=" C1' 2AU"; $resn_exch{" N2* 2AU"}=" N2' 2AU"; $resn_exch{"1H1P 2AU"}="H1P1 2AU";
$resn_exch{" O5* 2BA"}=" O5' 2BA"; $resn_exch{" C5* 2BA"}=" C5' 2BA"; $resn_exch{" C4* 2BA"}=" C4' 2BA";
$resn_exch{" O4* 2BA"}=" O4' 2BA"; $resn_exch{" C3* 2BA"}=" C3' 2BA"; $resn_exch{" O3* 2BA"}=" O3' 2BA";
$resn_exch{" C2* 2BA"}=" C2' 2BA"; $resn_exch{" O2* 2BA"}=" O2' 2BA"; $resn_exch{" C1* 2BA"}=" C1' 2BA";
$resn_exch{"1P   2BA"}=" P1  2BA"; $resn_exch{"1O1P 2BA"}="O1P1 2BA"; $resn_exch{"1O2P 2BA"}="O2P1 2BA";
$resn_exch{"1O5* 2BA"}="O5'1 2BA"; $resn_exch{"1C5* 2BA"}="C5'1 2BA"; $resn_exch{"1C4* 2BA"}="C4'1 2BA";
$resn_exch{"1O4* 2BA"}="O4'1 2BA"; $resn_exch{"1C3* 2BA"}="C3'1 2BA"; $resn_exch{"1O3* 2BA"}="O3'1 2BA";
$resn_exch{"1C2* 2BA"}="C2'1 2BA"; $resn_exch{"1O2* 2BA"}="O2'1 2BA"; $resn_exch{"1C1* 2BA"}="C1'1 2BA";
$resn_exch{"1N9  2BA"}=" N91 2BA"; $resn_exch{"1C8  2BA"}=" C81 2BA"; $resn_exch{"1N7  2BA"}=" N71 2BA";
$resn_exch{"1C5  2BA"}=" C51 2BA"; $resn_exch{"1C6  2BA"}=" C61 2BA"; $resn_exch{"1N6  2BA"}=" N61 2BA";
$resn_exch{"1N1  2BA"}=" N11 2BA"; $resn_exch{"1C2  2BA"}=" C21 2BA"; $resn_exch{"1N3  2BA"}=" N31 2BA";
$resn_exch{"1C4  2BA"}=" C41 2BA"; $resn_exch{" O1P 2BD"}=" OP1 2BD"; $resn_exch{" O2P 2BD"}=" OP2 2BD";
$resn_exch{" O3P 2BD"}=" OP3 2BD"; $resn_exch{" O5* 2BD"}=" O5' 2BD"; $resn_exch{" C5* 2BD"}=" C5' 2BD";
$resn_exch{" C4* 2BD"}=" C4' 2BD"; $resn_exch{" O4* 2BD"}=" O4' 2BD"; $resn_exch{" C1* 2BD"}=" C1' 2BD";
$resn_exch{" C2* 2BD"}=" C2' 2BD"; $resn_exch{" C3* 2BD"}=" C3' 2BD"; $resn_exch{" O3* 2BD"}=" O3' 2BD";
$resn_exch{" O3P 2BT"}=" OP3 2BT"; $resn_exch{" O2P 2BT"}=" OP2 2BT"; $resn_exch{" O5* 2BT"}=" O5' 2BT";
$resn_exch{" C5* 2BT"}=" C5' 2BT"; $resn_exch{" C4* 2BT"}=" C4' 2BT"; $resn_exch{" O4* 2BT"}=" O4' 2BT";
$resn_exch{" C1* 2BT"}=" C1' 2BT"; $resn_exch{" C2* 2BT"}=" C2' 2BT"; $resn_exch{" O2* 2BT"}=" O2' 2BT";
$resn_exch{" CA* 2BT"}=" CA' 2BT"; $resn_exch{" CB* 2BT"}=" CB' 2BT"; $resn_exch{" CC* 2BT"}=" CC' 2BT";
$resn_exch{" C3* 2BT"}=" C3' 2BT"; $resn_exch{" O3* 2BT"}=" O3' 2BT"; $resn_exch{" CD* 2BT"}=" CD' 2BT";
$resn_exch{" O1P 2BT"}=" OP1 2BT"; $resn_exch{" O1P 2BU"}=" OP1 2BU"; $resn_exch{" O2P 2BU"}=" OP2 2BU";
$resn_exch{" O3P 2BU"}=" OP3 2BU"; $resn_exch{" O5* 2BU"}=" O5' 2BU"; $resn_exch{" C5* 2BU"}=" C5' 2BU";
$resn_exch{" C4* 2BU"}=" C4' 2BU"; $resn_exch{" O4* 2BU"}=" O4' 2BU"; $resn_exch{" C1* 2BU"}=" C1' 2BU";
$resn_exch{" C2* 2BU"}=" C2' 2BU"; $resn_exch{" C3* 2BU"}=" C3' 2BU"; $resn_exch{" O3* 2BU"}=" O3' 2BU";
$resn_exch{" O1P 2DA"}=" OP1 2DA"; $resn_exch{" O2P 2DA"}=" OP2 2DA"; $resn_exch{" O3P 2DA"}=" OP3 2DA";
$resn_exch{" O5* 2DA"}=" O5' 2DA"; $resn_exch{" C5* 2DA"}=" C5' 2DA"; $resn_exch{" C4* 2DA"}=" C4' 2DA";
$resn_exch{" O4* 2DA"}=" O4' 2DA"; $resn_exch{" C3* 2DA"}=" C3' 2DA"; $resn_exch{" C2* 2DA"}=" C2' 2DA";
$resn_exch{" C1* 2DA"}=" C1' 2DA"; $resn_exch{" O5* 2DF"}=" O5' 2DF"; $resn_exch{" C5* 2DF"}=" C5' 2DF";
$resn_exch{" C4* 2DF"}=" C4' 2DF"; $resn_exch{" O4* 2DF"}=" O4' 2DF"; $resn_exch{" C1* 2DF"}=" C1' 2DF";
$resn_exch{" C3* 2DF"}=" C3' 2DF"; $resn_exch{" C2* 2DF"}=" C2' 2DF"; $resn_exch{" O3* 2DF"}=" O3' 2DF";
$resn_exch{" C5* 2DI"}=" C5' 2DI"; $resn_exch{" O5* 2DI"}=" O5' 2DI"; $resn_exch{" C4* 2DI"}=" C4' 2DI";
$resn_exch{" O4* 2DI"}=" O4' 2DI"; $resn_exch{" C1* 2DI"}=" C1' 2DI"; $resn_exch{" C2* 2DI"}=" C2' 2DI";
$resn_exch{" C3* 2DI"}=" C3' 2DI"; $resn_exch{" O1P 2DM"}=" OP1 2DM"; $resn_exch{" O2P 2DM"}=" OP2 2DM";
$resn_exch{" O3* 2DM"}=" O3' 2DM"; $resn_exch{" O3P 2DM"}=" OP3 2DM"; $resn_exch{" O1P 2DT"}=" OP1 2DT";
$resn_exch{" O2P 2DT"}=" OP2 2DT"; $resn_exch{" O3P 2DT"}=" OP3 2DT"; $resn_exch{" O5* 2DT"}=" O5' 2DT";
$resn_exch{" C2* 2DT"}=" C2' 2DT"; $resn_exch{" C5* 2DT"}=" C5' 2DT"; $resn_exch{" C4* 2DT"}=" C4' 2DT";
$resn_exch{" O4* 2DT"}=" O4' 2DT"; $resn_exch{" C1* 2DT"}=" C1' 2DT"; $resn_exch{" C3* 2DT"}=" C3' 2DT";
$resn_exch{" O3P 2EG"}=" OP3 2EG"; $resn_exch{" O1P 2EG"}=" OP1 2EG"; $resn_exch{" O2P 2EG"}=" OP2 2EG";
$resn_exch{" O5* 2EG"}=" O5' 2EG"; $resn_exch{" C5* 2EG"}=" C5' 2EG"; $resn_exch{" C4* 2EG"}=" C4' 2EG";
$resn_exch{" O4* 2EG"}=" O4' 2EG"; $resn_exch{" C3* 2EG"}=" C3' 2EG"; $resn_exch{" O3* 2EG"}=" O3' 2EG";
$resn_exch{" C2* 2EG"}=" C2' 2EG"; $resn_exch{" C1* 2EG"}=" C1' 2EG"; $resn_exch{" N_A 2FH"}=" NA  2FH";
$resn_exch{" N_B 2FH"}=" NB  2FH"; $resn_exch{" N_C 2FH"}=" NC  2FH"; $resn_exch{" N_D 2FH"}=" ND  2FH";
$resn_exch{" O5* 2GP"}=" O5' 2GP"; $resn_exch{" C5* 2GP"}=" C5' 2GP"; $resn_exch{" C4* 2GP"}=" C4' 2GP";
$resn_exch{" O4* 2GP"}=" O4' 2GP"; $resn_exch{" C3* 2GP"}=" C3' 2GP"; $resn_exch{" O3* 2GP"}=" O3' 2GP";
$resn_exch{" C2* 2GP"}=" C2' 2GP"; $resn_exch{" O2* 2GP"}=" O2' 2GP"; $resn_exch{" C1* 2GP"}=" C1' 2GP";
$resn_exch{" O1P 2GT"}=" OP1 2GT"; $resn_exch{" O2P 2GT"}=" OP2 2GT"; $resn_exch{" O5* 2GT"}=" O5' 2GT";
$resn_exch{" C5* 2GT"}=" C5' 2GT"; $resn_exch{" C4* 2GT"}=" C4' 2GT"; $resn_exch{" O4* 2GT"}=" O4' 2GT";
$resn_exch{" C1* 2GT"}=" C1' 2GT"; $resn_exch{" C2* 2GT"}=" C2' 2GT"; $resn_exch{" O2* 2GT"}=" O2' 2GT";
$resn_exch{" C3* 2GT"}=" C3' 2GT"; $resn_exch{" O3* 2GT"}=" O3' 2GT"; $resn_exch{" O3P 2GT"}=" OP3 2GT";
$resn_exch{" O1P 2MA"}=" OP1 2MA"; $resn_exch{" O2P 2MA"}=" OP2 2MA"; $resn_exch{" O3P 2MA"}=" OP3 2MA";
$resn_exch{" O5* 2MA"}=" O5' 2MA"; $resn_exch{" C5* 2MA"}=" C5' 2MA"; $resn_exch{" C4* 2MA"}=" C4' 2MA";
$resn_exch{" O4* 2MA"}=" O4' 2MA"; $resn_exch{" C3* 2MA"}=" C3' 2MA"; $resn_exch{" O3* 2MA"}=" O3' 2MA";
$resn_exch{" C2* 2MA"}=" C2' 2MA"; $resn_exch{" O2* 2MA"}=" O2' 2MA"; $resn_exch{" C1* 2MA"}=" C1' 2MA";
$resn_exch{" AN1 2MC"}=" N1A 2MC"; $resn_exch{" AC2 2MC"}=" C2A 2MC"; $resn_exch{" AN3 2MC"}=" N3A 2MC";
$resn_exch{" AC4 2MC"}=" C4A 2MC"; $resn_exch{" AC5 2MC"}=" C5A 2MC"; $resn_exch{" AC6 2MC"}=" C6A 2MC";
$resn_exch{" AN6 2MC"}=" N6A 2MC"; $resn_exch{" AN7 2MC"}=" N7A 2MC"; $resn_exch{" AC8 2MC"}=" C8A 2MC";
$resn_exch{" AN9 2MC"}=" N9A 2MC"; $resn_exch{"AC1* 2MC"}=" C1B 2MC"; $resn_exch{"AC2* 2MC"}=" C2B 2MC";
$resn_exch{"AO2* 2MC"}=" O2B 2MC"; $resn_exch{"AC3* 2MC"}=" C3B 2MC"; $resn_exch{"AO3* 2MC"}=" O3B 2MC";
$resn_exch{"AP3* 2MC"}=" P3B 2MC"; $resn_exch{" AO7 2MC"}=" O7A 2MC"; $resn_exch{" AO8 2MC"}=" O8A 2MC";
$resn_exch{" AO9 2MC"}=" O9A 2MC"; $resn_exch{"AC4* 2MC"}=" C4B 2MC"; $resn_exch{"AO4* 2MC"}=" O4B 2MC";
$resn_exch{"AC5* 2MC"}=" C5B 2MC"; $resn_exch{"AO5* 2MC"}=" O5B 2MC"; $resn_exch{" AP1 2MC"}=" P1A 2MC";
$resn_exch{" AO1 2MC"}=" O1A 2MC"; $resn_exch{" AO2 2MC"}=" O2A 2MC"; $resn_exch{" AO3 2MC"}=" O3A 2MC";
$resn_exch{" AP2 2MC"}=" P2A 2MC"; $resn_exch{" AO4 2MC"}=" O4A 2MC"; $resn_exch{" AO5 2MC"}=" O5A 2MC";
$resn_exch{" AO6 2MC"}=" O6A 2MC"; $resn_exch{"PC11 2MC"}=" CBP 2MC"; $resn_exch{"PC12 2MC"}=" CCP 2MC";
$resn_exch{"PC13 2MC"}=" CDP 2MC"; $resn_exch{"PC14 2MC"}=" CEP 2MC"; $resn_exch{"PC10 2MC"}=" CAP 2MC";
$resn_exch{"PO10 2MC"}=" OAP 2MC"; $resn_exch{" PC9 2MC"}=" C9P 2MC"; $resn_exch{" PO9 2MC"}=" O9P 2MC";
$resn_exch{" PN8 2MC"}=" N8P 2MC"; $resn_exch{" PC7 2MC"}=" C7P 2MC"; $resn_exch{" PC6 2MC"}=" C6P 2MC";
$resn_exch{" PC5 2MC"}=" C5P 2MC"; $resn_exch{" PO5 2MC"}=" O5P 2MC"; $resn_exch{" PN4 2MC"}=" N4P 2MC";
$resn_exch{" PC3 2MC"}=" C3P 2MC"; $resn_exch{" PC2 2MC"}=" C2P 2MC"; $resn_exch{" PS1 2MC"}=" S1P 2MC";
$resn_exch{" O5* 2MD"}=" O5' 2MD"; $resn_exch{" C5* 2MD"}=" C5' 2MD"; $resn_exch{" C4* 2MD"}=" C4' 2MD";
$resn_exch{" O4* 2MD"}=" O4' 2MD"; $resn_exch{" C1* 2MD"}=" C1' 2MD"; $resn_exch{" C2* 2MD"}=" C2' 2MD";
$resn_exch{" O2* 2MD"}=" O2' 2MD"; $resn_exch{" C3* 2MD"}=" C3' 2MD"; $resn_exch{" O3* 2MD"}=" O3' 2MD";
$resn_exch{" CA* 2ME"}=" CA' 2ME"; $resn_exch{" CB* 2ME"}=" CB' 2ME"; $resn_exch{" OC* 2ME"}=" OC' 2ME";
$resn_exch{" CD* 2ME"}=" CD' 2ME"; $resn_exch{" O1P 2MG"}=" OP1 2MG"; $resn_exch{" O2P 2MG"}=" OP2 2MG";
$resn_exch{" O3P 2MG"}=" OP3 2MG"; $resn_exch{" O5* 2MG"}=" O5' 2MG"; $resn_exch{" C5* 2MG"}=" C5' 2MG";
$resn_exch{" C4* 2MG"}=" C4' 2MG"; $resn_exch{" O4* 2MG"}=" O4' 2MG"; $resn_exch{" C3* 2MG"}=" C3' 2MG";
$resn_exch{" O3* 2MG"}=" O3' 2MG"; $resn_exch{" C2* 2MG"}=" C2' 2MG"; $resn_exch{" O2* 2MG"}=" O2' 2MG";
$resn_exch{" C1* 2MG"}=" C1' 2MG"; $resn_exch{" C1* 2MU"}=" C1' 2MU"; $resn_exch{" C2* 2MU"}=" C2' 2MU";
$resn_exch{" O2* 2MU"}=" O2' 2MU"; $resn_exch{" C3* 2MU"}=" C3' 2MU"; $resn_exch{" C4* 2MU"}=" C4' 2MU";
$resn_exch{" O3* 2MU"}=" O3' 2MU"; $resn_exch{" O4* 2MU"}=" O4' 2MU"; $resn_exch{" C5* 2MU"}=" C5' 2MU";
$resn_exch{" O5* 2MU"}=" O5' 2MU"; $resn_exch{" C6* 2MU"}=" C6' 2MU"; $resn_exch{" O1P 2MU"}=" OP1 2MU";
$resn_exch{" O2P 2MU"}=" OP2 2MU"; $resn_exch{" O3P 2MU"}=" OP3 2MU"; $resn_exch{" C1* 2ND"}=" C1' 2ND";
$resn_exch{" O4* 2ND"}=" O4' 2ND"; $resn_exch{" C2* 2ND"}=" C2' 2ND"; $resn_exch{" C3* 2ND"}=" C3' 2ND";
$resn_exch{" O3* 2ND"}=" O3' 2ND"; $resn_exch{" C4* 2ND"}=" C4' 2ND"; $resn_exch{" C5* 2ND"}=" C5' 2ND";
$resn_exch{" O5* 2ND"}=" O5' 2ND"; $resn_exch{" O3P 2NT"}=" OP3 2NT"; $resn_exch{" O2P 2NT"}=" OP2 2NT";
$resn_exch{" O5* 2NT"}=" O5' 2NT"; $resn_exch{" C5* 2NT"}=" C5' 2NT"; $resn_exch{" C4* 2NT"}=" C4' 2NT";
$resn_exch{" O4* 2NT"}=" O4' 2NT"; $resn_exch{" C1* 2NT"}=" C1' 2NT"; $resn_exch{" C2* 2NT"}=" C2' 2NT";
$resn_exch{" O2* 2NT"}=" O2' 2NT"; $resn_exch{" C3* 2NT"}=" C3' 2NT"; $resn_exch{" O3* 2NT"}=" O3' 2NT";
$resn_exch{" O1P 2NT"}=" OP1 2NT"; $resn_exch{" O1P 2OT"}=" OP1 2OT"; $resn_exch{" O2P 2OT"}=" OP2 2OT";
$resn_exch{" O5* 2OT"}=" O5' 2OT"; $resn_exch{" C5* 2OT"}=" C5' 2OT"; $resn_exch{" C4* 2OT"}=" C4' 2OT";
$resn_exch{" O4* 2OT"}=" O4' 2OT"; $resn_exch{" C1* 2OT"}=" C1' 2OT"; $resn_exch{" C2* 2OT"}=" C2' 2OT";
$resn_exch{" O2* 2OT"}=" O2' 2OT"; $resn_exch{" C3* 2OT"}=" C3' 2OT"; $resn_exch{" O3* 2OT"}=" O3' 2OT";
$resn_exch{" O3P 2OT"}=" OP3 2OT"; $resn_exch{" O3P 2PR"}=" OP3 2PR"; $resn_exch{" O1P 2PR"}=" OP1 2PR";
$resn_exch{" O2P 2PR"}=" OP2 2PR"; $resn_exch{" O5* 2PR"}=" O5' 2PR"; $resn_exch{" C5* 2PR"}=" C5' 2PR";
$resn_exch{" C4* 2PR"}=" C4' 2PR"; $resn_exch{" O4* 2PR"}=" O4' 2PR"; $resn_exch{" C3* 2PR"}=" C3' 2PR";
$resn_exch{" O3* 2PR"}=" O3' 2PR"; $resn_exch{" C2* 2PR"}=" C2' 2PR"; $resn_exch{" C1* 2PR"}=" C1' 2PR";
$resn_exch{" O3P 2ST"}=" OP3 2ST"; $resn_exch{" O1P 2ST"}=" OP1 2ST"; $resn_exch{" O2P 2ST"}=" OP2 2ST";
$resn_exch{" O5* 2ST"}=" O5' 2ST"; $resn_exch{" C2* 2ST"}=" C2' 2ST"; $resn_exch{" C5* 2ST"}=" C5' 2ST";
$resn_exch{" C4* 2ST"}=" C4' 2ST"; $resn_exch{" O4* 2ST"}=" O4' 2ST"; $resn_exch{" C1* 2ST"}=" C1' 2ST";
$resn_exch{" C3* 2ST"}=" C3' 2ST"; $resn_exch{" CA* 2ST"}=" CA' 2ST"; $resn_exch{" O3* 2ST"}=" O3' 2ST";
$resn_exch{" N1* 2TP"}=" N1' 2TP"; $resn_exch{" C2* 2TP"}=" C2' 2TP"; $resn_exch{" N3* 2TP"}=" N3' 2TP";
$resn_exch{" C4* 2TP"}=" C4' 2TP"; $resn_exch{" N4* 2TP"}=" N4' 2TP"; $resn_exch{" C5* 2TP"}=" C5' 2TP";
$resn_exch{" C6* 2TP"}=" C6' 2TP"; $resn_exch{" C2* 2VA"}=" C2' 2VA"; $resn_exch{" C3* 2VA"}=" C3' 2VA";
$resn_exch{" O3* 2VA"}=" O3' 2VA"; $resn_exch{" C4* 2VA"}=" C4' 2VA"; $resn_exch{" C5* 2VA"}=" C5' 2VA";
$resn_exch{" O5* 2VA"}=" O5' 2VA"; $resn_exch{" O4* 2VA"}=" O4' 2VA"; $resn_exch{" C1* 2VA"}=" C1' 2VA";
$resn_exch{"C31' 312"}=" CVX 312"; $resn_exch{"C32' 312"}=" CWX 312"; $resn_exch{"O33' 312"}=" OXX 312";
$resn_exch{"O34' 312"}=" OYX 312"; $resn_exch{"C42' 312"}=" C6X 312"; $resn_exch{"C43' 312"}=" C7X 312";
$resn_exch{"O44' 312"}=" O8X 312"; $resn_exch{"O45' 312"}=" O9X 312"; $resn_exch{"C1'' 312"}=" C1B 312";
$resn_exch{"C2'' 312"}=" C2B 312"; $resn_exch{"C3'' 312"}=" C3B 312"; $resn_exch{"C4'' 312"}=" C4B 312";
$resn_exch{"C5'' 312"}=" C5B 312"; $resn_exch{"C6'' 312"}=" C6B 312"; $resn_exch{"O2'' 312"}=" O2B 312";
$resn_exch{"C31' 334"}=" CV' 334"; $resn_exch{"1H2' 34B"}="H2'1 34B"; $resn_exch{"2H2' 34B"}="H2'2 34B";
$resn_exch{"1H4' 34B"}="H4'1 34B"; $resn_exch{"2H4' 34B"}="H4'2 34B"; $resn_exch{" C1* 357"}=" C1' 357";
$resn_exch{" C7* 357"}=" C7' 357"; $resn_exch{" N1\" 357"}=" N1' 357"; $resn_exch{" C6\" 357"}=" C6' 357";
$resn_exch{" C2\" 357"}=" C2' 357"; $resn_exch{" C3\" 357"}=" C3' 357"; $resn_exch{" O4\" 357"}=" O4' 357";
$resn_exch{" C5\" 357"}=" C5' 357"; $resn_exch{" C6* 357"}=" C6B 357"; $resn_exch{" C5* 357"}=" C5B 357";
$resn_exch{" C4* 357"}=" C4' 357"; $resn_exch{" C3* 357"}=" C3B 357"; $resn_exch{" C8* 357"}=" C8' 357";
$resn_exch{" C2* 357"}=" C2B 357"; $resn_exch{" O5* 35G"}=" O5' 35G"; $resn_exch{" C5* 35G"}=" C5' 35G";
$resn_exch{" C4* 35G"}=" C4' 35G"; $resn_exch{" O4* 35G"}=" O4' 35G"; $resn_exch{" C3* 35G"}=" C3' 35G";
$resn_exch{" O3* 35G"}=" O3' 35G"; $resn_exch{" C2* 35G"}=" C2' 35G"; $resn_exch{" O2* 35G"}=" O2' 35G";
$resn_exch{" C1* 35G"}=" C1' 35G"; $resn_exch{" AP  3AA"}=" PA  3AA"; $resn_exch{" AO1 3AA"}=" O1A 3AA";
$resn_exch{" AO2 3AA"}=" O2A 3AA"; $resn_exch{"AO5* 3AA"}=" O5B 3AA"; $resn_exch{"AC5* 3AA"}=" C5B 3AA";
$resn_exch{"AC4* 3AA"}=" C4B 3AA"; $resn_exch{"AO4* 3AA"}=" O4B 3AA"; $resn_exch{"AC1* 3AA"}=" C1B 3AA";
$resn_exch{" AN9 3AA"}=" N9A 3AA"; $resn_exch{" AC4 3AA"}=" C4A 3AA"; $resn_exch{" AN3 3AA"}=" N3A 3AA";
$resn_exch{" AC2 3AA"}=" C2A 3AA"; $resn_exch{" AN1 3AA"}=" N1A 3AA"; $resn_exch{" AC6 3AA"}=" C6A 3AA";
$resn_exch{" AN6 3AA"}=" N6A 3AA"; $resn_exch{" AC5 3AA"}=" C5A 3AA"; $resn_exch{" AN7 3AA"}=" N7A 3AA";
$resn_exch{" AC8 3AA"}=" C8A 3AA"; $resn_exch{"AC2* 3AA"}=" C2B 3AA"; $resn_exch{"AO2* 3AA"}=" O2B 3AA";
$resn_exch{"AP2* 3AA"}=" P2B 3AA"; $resn_exch{"AOP1 3AA"}=" O1X 3AA"; $resn_exch{"AOP2 3AA"}=" O2X 3AA";
$resn_exch{"AOP3 3AA"}=" O3X 3AA"; $resn_exch{"AC3* 3AA"}=" C3B 3AA"; $resn_exch{"AO3* 3AA"}=" O3B 3AA";
$resn_exch{" NP  3AA"}=" PN  3AA"; $resn_exch{" NO1 3AA"}=" O1N 3AA"; $resn_exch{" NO2 3AA"}=" O2N 3AA";
$resn_exch{"NO5* 3AA"}=" O5D 3AA"; $resn_exch{"NC5* 3AA"}=" C5D 3AA"; $resn_exch{"NC4* 3AA"}=" C4D 3AA";
$resn_exch{"NO4* 3AA"}=" O4D 3AA"; $resn_exch{"NC3* 3AA"}=" C3D 3AA"; $resn_exch{"NO3* 3AA"}=" O3D 3AA";
$resn_exch{"NC2* 3AA"}=" C2D 3AA"; $resn_exch{"NO2* 3AA"}=" O2D 3AA"; $resn_exch{"NC1* 3AA"}=" C1D 3AA";
$resn_exch{" NN1 3AA"}=" N1N 3AA"; $resn_exch{" NC2 3AA"}=" C2N 3AA"; $resn_exch{" NC4 3AA"}=" C4N 3AA";
$resn_exch{" NC5 3AA"}=" C5N 3AA"; $resn_exch{" NC6 3AA"}=" C6N 3AA"; $resn_exch{" NC3 3AA"}=" C3N 3AA";
$resn_exch{" NN7 3AA"}=" N7N 3AA"; $resn_exch{" O5* 3AD"}=" O5' 3AD"; $resn_exch{" C5* 3AD"}=" C5' 3AD";
$resn_exch{" C4* 3AD"}=" C4' 3AD"; $resn_exch{" O4* 3AD"}=" O4' 3AD"; $resn_exch{" C3* 3AD"}=" C3' 3AD";
$resn_exch{" C2* 3AD"}=" C2' 3AD"; $resn_exch{" O2* 3AD"}=" O2' 3AD"; $resn_exch{" C1* 3AD"}=" C1' 3AD";
$resn_exch{" O2* 3AM"}=" O2' 3AM"; $resn_exch{" C2* 3AM"}=" C2' 3AM"; $resn_exch{" C3* 3AM"}=" C3' 3AM";
$resn_exch{" O3* 3AM"}=" O3' 3AM"; $resn_exch{" C1* 3AM"}=" C1' 3AM"; $resn_exch{" O4* 3AM"}=" O4' 3AM";
$resn_exch{" C4* 3AM"}=" C4' 3AM"; $resn_exch{" C5* 3AM"}=" C5' 3AM"; $resn_exch{" O5* 3AM"}=" O5' 3AM";
$resn_exch{" O5* 3AN"}=" O5' 3AN"; $resn_exch{" C5* 3AN"}=" C5' 3AN"; $resn_exch{" C4* 3AN"}=" C4' 3AN";
$resn_exch{" O4* 3AN"}=" O4' 3AN"; $resn_exch{" C3* 3AN"}=" C3' 3AN"; $resn_exch{" N3* 3AN"}=" N3' 3AN";
$resn_exch{" C2* 3AN"}=" C2' 3AN"; $resn_exch{" O2* 3AN"}=" O2' 3AN"; $resn_exch{" C1* 3AN"}=" C1' 3AN";
$resn_exch{" O5* 3AT"}=" O5' 3AT"; $resn_exch{" C5* 3AT"}=" C5' 3AT"; $resn_exch{" C4* 3AT"}=" C4' 3AT";
$resn_exch{" O4* 3AT"}=" O4' 3AT"; $resn_exch{" C3* 3AT"}=" C3' 3AT"; $resn_exch{" C2* 3AT"}=" C2' 3AT";
$resn_exch{" O2* 3AT"}=" O2' 3AT"; $resn_exch{" C1* 3AT"}=" C1' 3AT"; $resn_exch{" O5* 3DA"}=" O5' 3DA";
$resn_exch{" C5* 3DA"}=" C5' 3DA"; $resn_exch{" C4* 3DA"}=" C4' 3DA"; $resn_exch{" O4* 3DA"}=" O4' 3DA";
$resn_exch{" C1* 3DA"}=" C1' 3DA"; $resn_exch{" C2* 3DA"}=" C2' 3DA"; $resn_exch{" O2* 3DA"}=" O2' 3DA";
$resn_exch{" C3* 3DA"}=" C3' 3DA"; $resn_exch{" O5* 3DR"}=" O5' 3DR"; $resn_exch{" O1P 3DR"}=" OP1 3DR";
$resn_exch{" O2P 3DR"}=" OP2 3DR"; $resn_exch{" O3P 3DR"}=" OP3 3DR"; $resn_exch{" C2* 3DR"}=" C2' 3DR";
$resn_exch{" C5* 3DR"}=" C5' 3DR"; $resn_exch{" C4* 3DR"}=" C4' 3DR"; $resn_exch{" O4* 3DR"}=" O4' 3DR";
$resn_exch{" C1* 3DR"}=" C1' 3DR"; $resn_exch{" C3* 3DR"}=" C3' 3DR"; $resn_exch{" O3* 3DR"}=" O3' 3DR";
$resn_exch{" O5* 3GP"}=" O5' 3GP"; $resn_exch{" C5* 3GP"}=" C5' 3GP"; $resn_exch{" C4* 3GP"}=" C4' 3GP";
$resn_exch{" O4* 3GP"}=" O4' 3GP"; $resn_exch{" C3* 3GP"}=" C3' 3GP"; $resn_exch{" O3* 3GP"}=" O3' 3GP";
$resn_exch{" C2* 3GP"}=" C2' 3GP"; $resn_exch{" O2* 3GP"}=" O2' 3GP"; $resn_exch{" C1* 3GP"}=" C1' 3GP";
$resn_exch{" AN1 3HC"}=" N1A 3HC"; $resn_exch{" AC2 3HC"}=" C2A 3HC"; $resn_exch{" AN3 3HC"}=" N3A 3HC";
$resn_exch{" AC4 3HC"}=" C4A 3HC"; $resn_exch{" AC5 3HC"}=" C5A 3HC"; $resn_exch{" AC6 3HC"}=" C6A 3HC";
$resn_exch{" AN6 3HC"}=" N6A 3HC"; $resn_exch{" AN7 3HC"}=" N7A 3HC"; $resn_exch{" AC8 3HC"}=" C8A 3HC";
$resn_exch{" AN9 3HC"}=" N9A 3HC"; $resn_exch{"AC1* 3HC"}=" C1B 3HC"; $resn_exch{"AC2* 3HC"}=" C2B 3HC";
$resn_exch{"AO2* 3HC"}=" O2B 3HC"; $resn_exch{"AC3* 3HC"}=" C3B 3HC"; $resn_exch{"AO3* 3HC"}=" O3B 3HC";
$resn_exch{"AP3* 3HC"}=" P3B 3HC"; $resn_exch{" AO7 3HC"}=" O7A 3HC"; $resn_exch{" AO8 3HC"}=" O8A 3HC";
$resn_exch{" AO9 3HC"}=" O9A 3HC"; $resn_exch{"AC4* 3HC"}=" C4B 3HC"; $resn_exch{"AO4* 3HC"}=" O4B 3HC";
$resn_exch{"AC5* 3HC"}=" C5B 3HC"; $resn_exch{"AO5* 3HC"}=" O5B 3HC"; $resn_exch{" AP1 3HC"}=" P1A 3HC";
$resn_exch{" AO1 3HC"}=" O1A 3HC"; $resn_exch{" AO2 3HC"}=" O2A 3HC"; $resn_exch{" AO3 3HC"}=" O3A 3HC";
$resn_exch{" AP2 3HC"}=" P2A 3HC"; $resn_exch{" AO4 3HC"}=" O4A 3HC"; $resn_exch{" AO5 3HC"}=" O5A 3HC";
$resn_exch{" AO6 3HC"}=" O6A 3HC"; $resn_exch{"PC11 3HC"}=" CBP 3HC"; $resn_exch{"PC12 3HC"}=" CCP 3HC";
$resn_exch{"PC13 3HC"}=" CDP 3HC"; $resn_exch{"PC14 3HC"}=" CEP 3HC"; $resn_exch{"PC10 3HC"}=" CAP 3HC";
$resn_exch{"PO10 3HC"}=" OAP 3HC"; $resn_exch{" PC9 3HC"}=" C9P 3HC"; $resn_exch{" PO9 3HC"}=" O9P 3HC";
$resn_exch{" PN8 3HC"}=" N8P 3HC"; $resn_exch{" PC7 3HC"}=" C7P 3HC"; $resn_exch{" PC6 3HC"}=" C6P 3HC";
$resn_exch{" PC5 3HC"}=" C5P 3HC"; $resn_exch{" PO5 3HC"}=" O5P 3HC"; $resn_exch{" PN4 3HC"}=" N4P 3HC";
$resn_exch{" PC3 3HC"}=" C3P 3HC"; $resn_exch{" PC2 3HC"}=" C2P 3HC"; $resn_exch{" PS1 3HC"}=" S1P 3HC";
$resn_exch{" O1P 3ME"}=" OP1 3ME"; $resn_exch{" O2P 3ME"}=" OP2 3ME"; $resn_exch{" O5* 3PO"}=" O5' 3PO";
$resn_exch{" C1* 44D"}=" C1B 44D"; $resn_exch{" C2* 44D"}=" C2B 44D"; $resn_exch{" C3* 44D"}=" C3B 44D";
$resn_exch{" C4* 44D"}=" C4B 44D"; $resn_exch{" C5* 44D"}=" C5B 44D"; $resn_exch{" C6* 44D"}=" C6B 44D";
$resn_exch{" O3* 44D"}=" O3' 44D"; $resn_exch{" O4* 44D"}=" O4B 44D"; $resn_exch{" O5* 44D"}=" O5B 44D";
$resn_exch{" O3P 4AC"}=" OP3 4AC"; $resn_exch{" O1P 4AC"}=" OP1 4AC"; $resn_exch{" O2P 4AC"}=" OP2 4AC";
$resn_exch{" O5* 4AC"}=" O5' 4AC"; $resn_exch{" C5* 4AC"}=" C5' 4AC"; $resn_exch{" C4* 4AC"}=" C4' 4AC";
$resn_exch{" O4* 4AC"}=" O4' 4AC"; $resn_exch{" C3* 4AC"}=" C3' 4AC"; $resn_exch{" O3* 4AC"}=" O3' 4AC";
$resn_exch{" C2* 4AC"}=" C2' 4AC"; $resn_exch{" O2* 4AC"}=" O2' 4AC"; $resn_exch{" C1* 4AC"}=" C1' 4AC";
$resn_exch{" O5* 4AD"}=" O5' 4AD"; $resn_exch{" C5* 4AD"}=" C5' 4AD"; $resn_exch{" C4* 4AD"}=" C4' 4AD";
$resn_exch{" C3* 4AD"}=" C3' 4AD"; $resn_exch{" O3* 4AD"}=" O3' 4AD"; $resn_exch{" C2* 4AD"}=" C2' 4AD";
$resn_exch{" O2* 4AD"}=" O2' 4AD"; $resn_exch{" C1* 4AD"}=" C1' 4AD"; $resn_exch{" O4* 4AD"}=" O4' 4AD";
$resn_exch{" OT1 4BF"}=" OXT 4BF"; $resn_exch{" AN1 4CA"}=" N1A 4CA"; $resn_exch{" AC2 4CA"}=" C2A 4CA";
$resn_exch{" AN3 4CA"}=" N3A 4CA"; $resn_exch{" AC4 4CA"}=" C4A 4CA"; $resn_exch{" AC5 4CA"}=" C5A 4CA";
$resn_exch{" AC6 4CA"}=" C6A 4CA"; $resn_exch{" AN6 4CA"}=" N6A 4CA"; $resn_exch{" AN7 4CA"}=" N7A 4CA";
$resn_exch{" AC8 4CA"}=" C8A 4CA"; $resn_exch{" AN9 4CA"}=" N9A 4CA"; $resn_exch{"AC1* 4CA"}=" C1D 4CA";
$resn_exch{"AC2* 4CA"}=" C2D 4CA"; $resn_exch{"AO2* 4CA"}=" O2D 4CA"; $resn_exch{"AC3* 4CA"}=" C3D 4CA";
$resn_exch{"AO3* 4CA"}=" O3D 4CA"; $resn_exch{"AP3* 4CA"}=" P3D 4CA"; $resn_exch{" AO7 4CA"}=" O7A 4CA";
$resn_exch{" AO8 4CA"}=" O8A 4CA"; $resn_exch{" AO9 4CA"}=" O9A 4CA"; $resn_exch{"AC4* 4CA"}=" C4D 4CA";
$resn_exch{"AO4* 4CA"}=" O4D 4CA"; $resn_exch{"AC5* 4CA"}=" C5D 4CA"; $resn_exch{"AO5* 4CA"}=" O5D 4CA";
$resn_exch{" AP1 4CA"}=" P1A 4CA"; $resn_exch{" AO1 4CA"}=" O1A 4CA"; $resn_exch{" AO2 4CA"}=" O2A 4CA";
$resn_exch{" AO3 4CA"}=" O3A 4CA"; $resn_exch{" AP2 4CA"}=" P2A 4CA"; $resn_exch{" AO4 4CA"}=" O4A 4CA";
$resn_exch{" AO5 4CA"}=" O5A 4CA"; $resn_exch{" AO6 4CA"}=" O6A 4CA"; $resn_exch{"PC11 4CA"}=" CBP 4CA";
$resn_exch{"PC12 4CA"}=" CCP 4CA"; $resn_exch{"PC13 4CA"}=" CDP 4CA"; $resn_exch{"PC14 4CA"}=" CEP 4CA";
$resn_exch{"PC10 4CA"}=" CAP 4CA"; $resn_exch{"PO10 4CA"}=" OAP 4CA"; $resn_exch{" PC9 4CA"}=" C9P 4CA";
$resn_exch{" PO9 4CA"}=" O9P 4CA"; $resn_exch{" PN8 4CA"}=" N8P 4CA"; $resn_exch{" PC7 4CA"}=" C7P 4CA";
$resn_exch{" PC6 4CA"}=" C6P 4CA"; $resn_exch{" PC5 4CA"}=" C5P 4CA"; $resn_exch{" PO5 4CA"}=" O5P 4CA";
$resn_exch{" PN4 4CA"}=" N4P 4CA"; $resn_exch{" PC3 4CA"}=" C3P 4CA"; $resn_exch{" PC2 4CA"}=" C2P 4CA";
$resn_exch{" PS1 4CA"}=" S1P 4CA"; $resn_exch{" BC1 4CA"}=" C1B 4CA"; $resn_exch{" BC2 4CA"}=" C2B 4CA";
$resn_exch{" BC3 4CA"}=" C3B 4CA"; $resn_exch{" BC4 4CA"}=" C4B 4CA"; $resn_exch{" BC5 4CA"}=" C5B 4CA";
$resn_exch{" BO2 4CA"}=" O2B 4CA"; $resn_exch{" BC6 4CA"}=" C6B 4CA"; $resn_exch{" BC7 4CA"}=" C7B 4CA";
$resn_exch{" AN1 4CO"}=" N1A 4CO"; $resn_exch{" AC2 4CO"}=" C2A 4CO"; $resn_exch{" AN3 4CO"}=" N3A 4CO";
$resn_exch{" AC4 4CO"}=" C4A 4CO"; $resn_exch{" AC5 4CO"}=" C5A 4CO"; $resn_exch{" AC6 4CO"}=" C6A 4CO";
$resn_exch{" AN6 4CO"}=" N6A 4CO"; $resn_exch{" AN7 4CO"}=" N7A 4CO"; $resn_exch{" AC8 4CO"}=" C8A 4CO";
$resn_exch{" AN9 4CO"}=" N9A 4CO"; $resn_exch{"AC1* 4CO"}=" C1D 4CO"; $resn_exch{"AC2* 4CO"}=" C2D 4CO";
$resn_exch{"AO2* 4CO"}=" O2D 4CO"; $resn_exch{"AC3* 4CO"}=" C3D 4CO"; $resn_exch{"AO3* 4CO"}=" O3D 4CO";
$resn_exch{"AP3* 4CO"}=" P3D 4CO"; $resn_exch{" AO7 4CO"}=" O7A 4CO"; $resn_exch{" AO8 4CO"}=" O8A 4CO";
$resn_exch{" AO9 4CO"}=" O9A 4CO"; $resn_exch{"AC4* 4CO"}=" C4D 4CO"; $resn_exch{"AO4* 4CO"}=" O4D 4CO";
$resn_exch{"AC5* 4CO"}=" C5D 4CO"; $resn_exch{"AO5* 4CO"}=" O5D 4CO"; $resn_exch{" AP1 4CO"}=" P1A 4CO";
$resn_exch{" AO1 4CO"}=" O1A 4CO"; $resn_exch{" AO2 4CO"}=" O2A 4CO"; $resn_exch{" AO3 4CO"}=" O3A 4CO";
$resn_exch{" AP2 4CO"}=" P2A 4CO"; $resn_exch{" AO4 4CO"}=" O4A 4CO"; $resn_exch{" AO5 4CO"}=" O5A 4CO";
$resn_exch{" AO6 4CO"}=" O6A 4CO"; $resn_exch{"PC11 4CO"}=" CBP 4CO"; $resn_exch{"PC12 4CO"}=" CCP 4CO";
$resn_exch{"PC13 4CO"}=" CDP 4CO"; $resn_exch{"PC14 4CO"}=" CEP 4CO"; $resn_exch{"PC10 4CO"}=" CAP 4CO";
$resn_exch{"PO10 4CO"}=" OAP 4CO"; $resn_exch{" PC9 4CO"}=" C9P 4CO"; $resn_exch{" PO9 4CO"}=" O9P 4CO";
$resn_exch{" PN8 4CO"}=" N8P 4CO"; $resn_exch{" PC7 4CO"}=" C7P 4CO"; $resn_exch{" PC6 4CO"}=" C6P 4CO";
$resn_exch{" PC5 4CO"}=" C5P 4CO"; $resn_exch{" PO5 4CO"}=" O5P 4CO"; $resn_exch{" PN4 4CO"}=" N4P 4CO";
$resn_exch{" PC3 4CO"}=" C3P 4CO"; $resn_exch{" PC2 4CO"}=" C2P 4CO"; $resn_exch{" PS1 4CO"}=" S1P 4CO";
$resn_exch{" BO1 4CO"}=" O1B 4CO"; $resn_exch{" BC1 4CO"}=" C1B 4CO"; $resn_exch{" BC2 4CO"}=" C2B 4CO";
$resn_exch{" BC3 4CO"}=" C3B 4CO"; $resn_exch{" BC4 4CO"}=" C4B 4CO"; $resn_exch{" BC5 4CO"}=" C5B 4CO";
$resn_exch{" BO2 4CO"}=" O2B 4CO"; $resn_exch{" BC6 4CO"}=" C6B 4CO"; $resn_exch{" BC7 4CO"}=" C7B 4CO";
$resn_exch{" BC  4CO"}=" CB  4CO"; $resn_exch{" O1  4IN"}=" OXT 4IN"; $resn_exch{"1OP5 4IP"}=" OPF 4IP";
$resn_exch{"2OP5 4IP"}=" OPG 4IP"; $resn_exch{"3OP5 4IP"}=" OPH 4IP"; $resn_exch{" O5* 4MF"}=" O5' 4MF";
$resn_exch{" C5* 4MF"}=" C5' 4MF"; $resn_exch{" C4* 4MF"}=" C4' 4MF"; $resn_exch{" C3* 4MF"}=" C3' 4MF";
$resn_exch{" O3* 4MF"}=" O3' 4MF"; $resn_exch{" C2* 4MF"}=" C2' 4MF"; $resn_exch{" C1* 4MF"}=" C1' 4MF";
$resn_exch{" O4* 4MF"}=" O4' 4MF"; $resn_exch{" O1P 4OC"}=" OP1 4OC"; $resn_exch{" O2P 4OC"}=" OP2 4OC";
$resn_exch{" O5* 4OC"}=" O5' 4OC"; $resn_exch{" C5* 4OC"}=" C5' 4OC"; $resn_exch{" C4* 4OC"}=" C4' 4OC";
$resn_exch{" O4* 4OC"}=" O4' 4OC"; $resn_exch{" C3* 4OC"}=" C3' 4OC"; $resn_exch{" C2* 4OC"}=" C2' 4OC";
$resn_exch{" O2* 4OC"}=" O2' 4OC"; $resn_exch{" C1* 4OC"}=" C1' 4OC"; $resn_exch{" O3* 4OC"}=" O3' 4OC";
$resn_exch{" O3P 4OC"}=" OP3 4OC"; $resn_exch{" O1P 4PC"}=" OP1 4PC"; $resn_exch{" O2P 4PC"}=" OP2 4PC";
$resn_exch{" O5* 4PC"}=" O5' 4PC"; $resn_exch{" C5* 4PC"}=" C5' 4PC"; $resn_exch{" C4* 4PC"}=" C4' 4PC";
$resn_exch{" O4* 4PC"}=" O4' 4PC"; $resn_exch{" C3* 4PC"}=" C3' 4PC"; $resn_exch{" O3* 4PC"}=" O3' 4PC";
$resn_exch{" C2* 4PC"}=" C2' 4PC"; $resn_exch{" C1* 4PC"}=" C1' 4PC"; $resn_exch{" O3P 4PC"}=" OP3 4PC";
$resn_exch{" O1P 4PD"}=" OP1 4PD"; $resn_exch{" O2P 4PD"}=" OP2 4PD"; $resn_exch{" O5* 4PD"}=" O5' 4PD";
$resn_exch{" C5* 4PD"}=" C5' 4PD"; $resn_exch{" C4* 4PD"}=" C4' 4PD"; $resn_exch{" O4* 4PD"}=" O4' 4PD";
$resn_exch{" C3* 4PD"}=" C3' 4PD"; $resn_exch{" O3* 4PD"}=" O3' 4PD"; $resn_exch{" C2* 4PD"}=" C2' 4PD";
$resn_exch{" C1* 4PD"}=" C1' 4PD"; $resn_exch{" O3P 4PD"}=" OP3 4PD"; $resn_exch{" O1P 4PE"}=" OP1 4PE";
$resn_exch{" O2P 4PE"}=" OP2 4PE"; $resn_exch{" O5* 4PE"}=" O5' 4PE"; $resn_exch{" C5* 4PE"}=" C5' 4PE";
$resn_exch{" C4* 4PE"}=" C4' 4PE"; $resn_exch{" O4* 4PE"}=" O4' 4PE"; $resn_exch{" C3* 4PE"}=" C3' 4PE";
$resn_exch{" O3* 4PE"}=" O3' 4PE"; $resn_exch{" C2* 4PE"}=" C2' 4PE"; $resn_exch{" C1* 4PE"}=" C1' 4PE";
$resn_exch{" O3P 4PE"}=" OP3 4PE"; $resn_exch{" O1P 4SC"}=" OP1 4SC"; $resn_exch{" O2P 4SC"}=" OP2 4SC";
$resn_exch{" O5* 4SC"}=" O5' 4SC"; $resn_exch{" C5* 4SC"}=" C5' 4SC"; $resn_exch{" C4* 4SC"}=" C4' 4SC";
$resn_exch{" S4* 4SC"}=" S4' 4SC"; $resn_exch{" C3* 4SC"}=" C3' 4SC"; $resn_exch{" O3* 4SC"}=" O3' 4SC";
$resn_exch{" C2* 4SC"}=" C2' 4SC"; $resn_exch{" C1* 4SC"}=" C1' 4SC"; $resn_exch{" C1* 4SU"}=" C1' 4SU";
$resn_exch{" C2* 4SU"}=" C2' 4SU"; $resn_exch{" O2* 4SU"}=" O2' 4SU"; $resn_exch{" C3* 4SU"}=" C3' 4SU";
$resn_exch{" C4* 4SU"}=" C4' 4SU"; $resn_exch{" O3* 4SU"}=" O3' 4SU"; $resn_exch{" O4* 4SU"}=" O4' 4SU";
$resn_exch{" C5* 4SU"}=" C5' 4SU"; $resn_exch{" O5* 4SU"}=" O5' 4SU"; $resn_exch{" O1P 4SU"}=" OP1 4SU";
$resn_exch{" O2P 4SU"}=" OP2 4SU"; $resn_exch{" O3P 4SU"}=" OP3 4SU"; $resn_exch{" C1* 4TA"}=" C1B 4TA";
$resn_exch{" C2* 4TA"}=" C2B 4TA"; $resn_exch{" C3* 4TA"}=" C3B 4TA"; $resn_exch{" O3* 4TA"}=" O3B 4TA";
$resn_exch{" C4* 4TA"}=" C4B 4TA"; $resn_exch{" C5* 4TA"}=" C5B 4TA"; $resn_exch{" O5* 4TA"}=" O5' 4TA";
$resn_exch{" O4* 4TA"}=" O4' 4TA"; $resn_exch{" O5* 4TC"}=" O5' 4TC"; $resn_exch{" C5* 4TC"}=" C5' 4TC";
$resn_exch{" C4* 4TC"}=" C4' 4TC"; $resn_exch{" C3* 4TC"}=" C3' 4TC"; $resn_exch{" O3* 4TC"}=" O3' 4TC";
$resn_exch{" C2* 4TC"}=" C2' 4TC"; $resn_exch{" O2* 4TC"}=" O2' 4TC"; $resn_exch{" C1* 4TC"}=" C1' 4TC";
$resn_exch{" O4* 4TC"}=" O4' 4TC"; $resn_exch{" C1* 523"}=" C1' 523"; $resn_exch{" C2* 523"}=" C2' 523";
$resn_exch{" C3* 523"}=" C3' 523"; $resn_exch{" C4* 523"}=" C4' 523"; $resn_exch{" O4* 523"}=" O4' 523";
$resn_exch{" O3* 523"}=" O3' 523"; $resn_exch{" C5* 523"}=" C5' 523"; $resn_exch{" O5* 523"}=" O5' 523";
$resn_exch{" O3P 5AA"}=" OP3 5AA"; $resn_exch{" O2P 5AA"}=" OP2 5AA"; $resn_exch{" O5* 5AA"}=" O5' 5AA";
$resn_exch{" C5* 5AA"}=" C5' 5AA"; $resn_exch{" C4* 5AA"}=" C4' 5AA"; $resn_exch{" O4* 5AA"}=" O4' 5AA";
$resn_exch{" C1* 5AA"}=" C1' 5AA"; $resn_exch{" C2* 5AA"}=" C2' 5AA"; $resn_exch{" O2* 5AA"}=" O2' 5AA";
$resn_exch{" C3* 5AA"}=" C3' 5AA"; $resn_exch{" N3* 5AA"}=" N3' 5AA"; $resn_exch{" O1P 5AA"}=" OP1 5AA";
$resn_exch{" O5* 5AS"}=" O5' 5AS"; $resn_exch{" C5* 5AS"}=" C5' 5AS"; $resn_exch{" C4* 5AS"}=" C4' 5AS";
$resn_exch{" O4* 5AS"}=" O4' 5AS"; $resn_exch{" C3* 5AS"}=" C3' 5AS"; $resn_exch{" O3* 5AS"}=" O3' 5AS";
$resn_exch{" C2* 5AS"}=" C2' 5AS"; $resn_exch{" O2* 5AS"}=" O2' 5AS"; $resn_exch{" C1* 5AS"}=" C1' 5AS";
$resn_exch{" N5* 5AT"}=" N5' 5AT"; $resn_exch{" C2* 5AT"}=" C2' 5AT"; $resn_exch{" C5* 5AT"}=" C5' 5AT";
$resn_exch{" C4* 5AT"}=" C4' 5AT"; $resn_exch{" O4* 5AT"}=" O4' 5AT"; $resn_exch{" C1* 5AT"}=" C1' 5AT";
$resn_exch{" C3* 5AT"}=" C3' 5AT"; $resn_exch{" O3* 5AT"}=" O3' 5AT"; $resn_exch{" O1P 5BU"}=" OP1 5BU";
$resn_exch{" O2P 5BU"}=" OP2 5BU"; $resn_exch{" O3P 5BU"}=" OP3 5BU"; $resn_exch{" O5* 5BU"}=" O5' 5BU";
$resn_exch{" C5* 5BU"}=" C5' 5BU"; $resn_exch{" C4* 5BU"}=" C4' 5BU"; $resn_exch{" O4* 5BU"}=" O4' 5BU";
$resn_exch{" C3* 5BU"}=" C3' 5BU"; $resn_exch{" O3* 5BU"}=" O3' 5BU"; $resn_exch{" C2* 5BU"}=" C2' 5BU";
$resn_exch{" O2* 5BU"}=" O2' 5BU"; $resn_exch{" C1* 5BU"}=" C1' 5BU"; $resn_exch{" O5* 5CA"}=" O5' 5CA";
$resn_exch{" C5* 5CA"}=" C5' 5CA"; $resn_exch{" C4* 5CA"}=" C4' 5CA"; $resn_exch{" O4* 5CA"}=" O4' 5CA";
$resn_exch{" C3* 5CA"}=" C3' 5CA"; $resn_exch{" O3* 5CA"}=" O3' 5CA"; $resn_exch{" C2* 5CA"}=" C2' 5CA";
$resn_exch{" O2* 5CA"}=" O2' 5CA"; $resn_exch{" C1* 5CA"}=" C1' 5CA"; $resn_exch{" O2* 5CD"}=" O2' 5CD";
$resn_exch{" C2* 5CD"}=" C2' 5CD"; $resn_exch{" C3* 5CD"}=" C3' 5CD"; $resn_exch{" O3* 5CD"}=" O3' 5CD";
$resn_exch{" C4* 5CD"}=" C4' 5CD"; $resn_exch{" C5* 5CD"}=" C5' 5CD"; $resn_exch{" O4* 5CD"}=" O4' 5CD";
$resn_exch{" C1* 5CD"}=" C1' 5CD"; $resn_exch{"CL5* 5CG"}="CL5' 5CG"; $resn_exch{" C5* 5CG"}=" C5' 5CG";
$resn_exch{" C4* 5CG"}=" C4' 5CG"; $resn_exch{" O4* 5CG"}=" O4' 5CG"; $resn_exch{" C3* 5CG"}=" C3' 5CG";
$resn_exch{" O3* 5CG"}=" O3' 5CG"; $resn_exch{" C2* 5CG"}=" C2' 5CG"; $resn_exch{" O2* 5CG"}=" O2' 5CG";
$resn_exch{" C1* 5CG"}=" C1' 5CG"; $resn_exch{" C1* 5CM"}=" C1' 5CM"; $resn_exch{" C2* 5CM"}=" C2' 5CM";
$resn_exch{" C3* 5CM"}=" C3' 5CM"; $resn_exch{" C4* 5CM"}=" C4' 5CM"; $resn_exch{" O4* 5CM"}=" O4' 5CM";
$resn_exch{" O3* 5CM"}=" O3' 5CM"; $resn_exch{" C5* 5CM"}=" C5' 5CM"; $resn_exch{" O5* 5CM"}=" O5' 5CM";
$resn_exch{" O1P 5CM"}=" OP1 5CM"; $resn_exch{" O2P 5CM"}=" OP2 5CM"; $resn_exch{" O3P 5CM"}=" OP3 5CM";
$resn_exch{" C2* 5F1"}=" C2' 5F1"; $resn_exch{" C3* 5F1"}=" C3' 5F1"; $resn_exch{" O3* 5F1"}=" O3' 5F1";
$resn_exch{" C4* 5F1"}=" C4' 5F1"; $resn_exch{" C5* 5F1"}=" C5' 5F1"; $resn_exch{" O4* 5F1"}=" O4' 5F1";
$resn_exch{" C1* 5F1"}=" C1' 5F1"; $resn_exch{" O5* 5FA"}=" O5' 5FA"; $resn_exch{" C5* 5FA"}=" C5' 5FA";
$resn_exch{" C4* 5FA"}=" C4' 5FA"; $resn_exch{" O4* 5FA"}=" O4' 5FA"; $resn_exch{" C3* 5FA"}=" C3' 5FA";
$resn_exch{" O3* 5FA"}=" O3' 5FA"; $resn_exch{" C2* 5FA"}=" C2' 5FA"; $resn_exch{" O2* 5FA"}=" O2' 5FA";
$resn_exch{" C1* 5FA"}=" C1' 5FA"; $resn_exch{" O2P 5FC"}=" OP2 5FC"; $resn_exch{" O1P 5FC"}=" OP1 5FC";
$resn_exch{" O5* 5FC"}=" O5' 5FC"; $resn_exch{" C2* 5FC"}=" C2' 5FC"; $resn_exch{" C5* 5FC"}=" C5' 5FC";
$resn_exch{" C4* 5FC"}=" C4' 5FC"; $resn_exch{" O4* 5FC"}=" O4' 5FC"; $resn_exch{" C1* 5FC"}=" C1' 5FC";
$resn_exch{" C3* 5FC"}=" C3' 5FC"; $resn_exch{" O3* 5FC"}=" O3' 5FC"; $resn_exch{" O3P 5FC"}=" OP3 5FC";
$resn_exch{" O2* 5FD"}=" O2' 5FD"; $resn_exch{" C2* 5FD"}=" C2' 5FD"; $resn_exch{" C3* 5FD"}=" C3' 5FD";
$resn_exch{" O3* 5FD"}=" O3' 5FD"; $resn_exch{" C4* 5FD"}=" C4' 5FD"; $resn_exch{" C5* 5FD"}=" C5' 5FD";
$resn_exch{" O4* 5FD"}=" O4' 5FD"; $resn_exch{" C1* 5FD"}=" C1' 5FD"; $resn_exch{" C1* 5FU"}=" C1' 5FU";
$resn_exch{" O4* 5FU"}=" O4' 5FU"; $resn_exch{" C2* 5FU"}=" C2' 5FU"; $resn_exch{" O2* 5FU"}=" O2' 5FU";
$resn_exch{" C3* 5FU"}=" C3' 5FU"; $resn_exch{" O3* 5FU"}=" O3' 5FU"; $resn_exch{" C4* 5FU"}=" C4' 5FU";
$resn_exch{" C5* 5FU"}=" C5' 5FU"; $resn_exch{" O5* 5FU"}=" O5' 5FU"; $resn_exch{" O5* 5GP"}=" O5' 5GP";
$resn_exch{" C5* 5GP"}=" C5' 5GP"; $resn_exch{" C4* 5GP"}=" C4' 5GP"; $resn_exch{" O4* 5GP"}=" O4' 5GP";
$resn_exch{" C3* 5GP"}=" C3' 5GP"; $resn_exch{" O3* 5GP"}=" O3' 5GP"; $resn_exch{" C2* 5GP"}=" C2' 5GP";
$resn_exch{" O2* 5GP"}=" O2' 5GP"; $resn_exch{" C1* 5GP"}=" C1' 5GP"; $resn_exch{" O5* 5HT"}=" O5' 5HT";
$resn_exch{" C5* 5HT"}=" C5' 5HT"; $resn_exch{" C4* 5HT"}=" C4' 5HT"; $resn_exch{" O4* 5HT"}=" O4' 5HT";
$resn_exch{" C3* 5HT"}=" C3' 5HT"; $resn_exch{" O3* 5HT"}=" O3' 5HT"; $resn_exch{" C2* 5HT"}=" C2' 5HT";
$resn_exch{" C1* 5HT"}=" C1' 5HT"; $resn_exch{" O1P 5HU"}=" OP1 5HU"; $resn_exch{" O2P 5HU"}=" OP2 5HU";
$resn_exch{" O3P 5HU"}=" OP3 5HU"; $resn_exch{" O5* 5HU"}=" O5' 5HU"; $resn_exch{" C5* 5HU"}=" C5' 5HU";
$resn_exch{" C4* 5HU"}=" C4' 5HU"; $resn_exch{" O4* 5HU"}=" O4' 5HU"; $resn_exch{" C3* 5HU"}=" C3' 5HU";
$resn_exch{" O3* 5HU"}=" O3' 5HU"; $resn_exch{" C2* 5HU"}=" C2' 5HU"; $resn_exch{" C1* 5HU"}=" C1' 5HU";
$resn_exch{" O2* 5IC"}=" O2' 5IC"; $resn_exch{" C2* 5IC"}=" C2' 5IC"; $resn_exch{" C3* 5IC"}=" C3' 5IC";
$resn_exch{" O3* 5IC"}=" O3' 5IC"; $resn_exch{" C4* 5IC"}=" C4' 5IC"; $resn_exch{" O4* 5IC"}=" O4' 5IC";
$resn_exch{" C1* 5IC"}=" C1' 5IC"; $resn_exch{" C5* 5IC"}=" C5' 5IC"; $resn_exch{" O5* 5IC"}=" O5' 5IC";
$resn_exch{" O1P 5IC"}=" OP1 5IC"; $resn_exch{" O3P 5IC"}=" OP3 5IC"; $resn_exch{" O2P 5IC"}=" OP2 5IC";
$resn_exch{" O1P 5IT"}=" OP1 5IT"; $resn_exch{" O2P 5IT"}=" OP2 5IT"; $resn_exch{" O3P 5IT"}=" OP3 5IT";
$resn_exch{" O5* 5IT"}=" O5' 5IT"; $resn_exch{" C5* 5IT"}=" C5' 5IT"; $resn_exch{" C4* 5IT"}=" C4' 5IT";
$resn_exch{" O4* 5IT"}=" O4' 5IT"; $resn_exch{" C3* 5IT"}=" C3' 5IT"; $resn_exch{" O3* 5IT"}=" O3' 5IT";
$resn_exch{" C2* 5IT"}=" C2' 5IT"; $resn_exch{" C1* 5IT"}=" C1' 5IT"; $resn_exch{" C1* 5IU"}=" C1' 5IU";
$resn_exch{" C2* 5IU"}=" C2' 5IU"; $resn_exch{" C3* 5IU"}=" C3' 5IU"; $resn_exch{" C4* 5IU"}=" C4' 5IU";
$resn_exch{" O3* 5IU"}=" O3' 5IU"; $resn_exch{" O4* 5IU"}=" O4' 5IU"; $resn_exch{" C5* 5IU"}=" C5' 5IU";
$resn_exch{" O5* 5IU"}=" O5' 5IU"; $resn_exch{" O1P 5IU"}=" OP1 5IU"; $resn_exch{" O2P 5IU"}=" OP2 5IU";
$resn_exch{" O3P 5IU"}=" OP3 5IU"; $resn_exch{" O1P 5MC"}=" OP1 5MC"; $resn_exch{" O2P 5MC"}=" OP2 5MC";
$resn_exch{" O3P 5MC"}=" OP3 5MC"; $resn_exch{" O5* 5MC"}=" O5' 5MC"; $resn_exch{" C5* 5MC"}=" C5' 5MC";
$resn_exch{" C4* 5MC"}=" C4' 5MC"; $resn_exch{" O4* 5MC"}=" O4' 5MC"; $resn_exch{" C3* 5MC"}=" C3' 5MC";
$resn_exch{" O3* 5MC"}=" O3' 5MC"; $resn_exch{" C2* 5MC"}=" C2' 5MC"; $resn_exch{" O2* 5MC"}=" O2' 5MC";
$resn_exch{" C1* 5MC"}=" C1' 5MC"; $resn_exch{" C1* 5MU"}=" C1' 5MU"; $resn_exch{" C2* 5MU"}=" C2' 5MU";
$resn_exch{" O2* 5MU"}=" O2' 5MU"; $resn_exch{" C3* 5MU"}=" C3' 5MU"; $resn_exch{" C4* 5MU"}=" C4' 5MU";
$resn_exch{" O3* 5MU"}=" O3' 5MU"; $resn_exch{" O4* 5MU"}=" O4' 5MU"; $resn_exch{" C5* 5MU"}=" C5' 5MU";
$resn_exch{" O5* 5MU"}=" O5' 5MU"; $resn_exch{" O1P 5MU"}=" OP1 5MU"; $resn_exch{" O2P 5MU"}=" OP2 5MU";
$resn_exch{" O3P 5MU"}=" OP3 5MU"; $resn_exch{" O1P 5NC"}=" OP1 5NC"; $resn_exch{" O2P 5NC"}=" OP2 5NC";
$resn_exch{" O3P 5NC"}=" OP3 5NC"; $resn_exch{" O5* 5NC"}=" O5' 5NC"; $resn_exch{" C5* 5NC"}=" C5' 5NC";
$resn_exch{" C4* 5NC"}=" C4' 5NC"; $resn_exch{" O4* 5NC"}=" O4' 5NC"; $resn_exch{" C3* 5NC"}=" C3' 5NC";
$resn_exch{" O3* 5NC"}=" O3' 5NC"; $resn_exch{" C2* 5NC"}=" C2' 5NC"; $resn_exch{" C1* 5NC"}=" C1' 5NC";
$resn_exch{" O3P 5PC"}=" OP3 5PC"; $resn_exch{" O1P 5PC"}=" OP1 5PC"; $resn_exch{" O2P 5PC"}=" OP2 5PC";
$resn_exch{" C5* 5PC"}=" C5' 5PC"; $resn_exch{" O5* 5PC"}=" O5' 5PC"; $resn_exch{" C4* 5PC"}=" C4' 5PC";
$resn_exch{" O4* 5PC"}=" O4' 5PC"; $resn_exch{" C3* 5PC"}=" C3' 5PC"; $resn_exch{" O3* 5PC"}=" O3' 5PC";
$resn_exch{" C2* 5PC"}=" C2' 5PC"; $resn_exch{" C1* 5PC"}=" C1' 5PC"; $resn_exch{" O2P 5PY"}=" OP2 5PY";
$resn_exch{" O1P 5PY"}=" OP1 5PY"; $resn_exch{" O5* 5PY"}=" O5' 5PY"; $resn_exch{" C5* 5PY"}=" C5' 5PY";
$resn_exch{" C4* 5PY"}=" C4' 5PY"; $resn_exch{" O4* 5PY"}=" O4' 5PY"; $resn_exch{" C1* 5PY"}=" C1' 5PY";
$resn_exch{" C2* 5PY"}=" C2' 5PY"; $resn_exch{" C3* 5PY"}=" C3' 5PY"; $resn_exch{" O3* 5PY"}=" O3' 5PY";
$resn_exch{" O3P 5PY"}=" OP3 5PY"; $resn_exch{" C1* 5UD"}=" C1' 5UD"; $resn_exch{" C2* 5UD"}=" C2' 5UD";
$resn_exch{" O2* 5UD"}=" O2' 5UD"; $resn_exch{" C3* 5UD"}=" C3' 5UD"; $resn_exch{" O3* 5UD"}=" O3' 5UD";
$resn_exch{" C4* 5UD"}=" C4' 5UD"; $resn_exch{" O4* 5UD"}=" O4' 5UD"; $resn_exch{" C5* 5UD"}=" C5' 5UD";
$resn_exch{" O5* 5UD"}=" O5' 5UD"; $resn_exch{"C31' 607"}=" CVX 607"; $resn_exch{"C32' 607"}=" CWX 607";
$resn_exch{"O33' 607"}=" OXX 607"; $resn_exch{"O34' 607"}=" OYX 607"; $resn_exch{"C42' 607"}=" C6X 607";
$resn_exch{"C43' 607"}=" C7X 607"; $resn_exch{"O44' 607"}=" O8X 607"; $resn_exch{"O45' 607"}=" O9X 607";
$resn_exch{"C1'' 607"}=" C1B 607"; $resn_exch{"C2'' 607"}=" C2B 607"; $resn_exch{"C3'' 607"}=" C3B 607";
$resn_exch{"C4'' 607"}=" C4B 607"; $resn_exch{"C5'' 607"}=" C5B 607"; $resn_exch{"C6'' 607"}=" C6B 607";
$resn_exch{"N2'' 607"}=" N2B 607"; $resn_exch{" O1P 64T"}=" OP1 64T"; $resn_exch{" O2P 64T"}=" OP2 64T";
$resn_exch{" O5* 64T"}=" O5' 64T"; $resn_exch{" C5* 64T"}=" C5' 64T"; $resn_exch{" C4* 64T"}=" C4' 64T";
$resn_exch{" O4* 64T"}=" O4' 64T"; $resn_exch{" C3* 64T"}=" C3' 64T"; $resn_exch{" O3* 64T"}=" O3' 64T";
$resn_exch{" C2* 64T"}=" C2' 64T"; $resn_exch{" C1* 64T"}=" C1' 64T"; $resn_exch{" O3P 64T"}=" OP3 64T";
$resn_exch{"C31' 653"}=" CV' 653"; $resn_exch{"C32' 653"}=" CW' 653"; $resn_exch{"N33' 653"}=" NX' 653";
$resn_exch{"C1'' 653"}=" C1B 653"; $resn_exch{"C2'' 653"}=" C2B 653"; $resn_exch{"C3'' 653"}=" C3B 653";
$resn_exch{"C4'' 653"}=" C4B 653"; $resn_exch{"C5'' 653"}=" C5B 653"; $resn_exch{"C6'' 653"}=" C6B 653";
$resn_exch{"C1'' 655"}=" C1B 655"; $resn_exch{"C2'' 655"}=" C2B 655"; $resn_exch{"C3'' 655"}=" C3B 655";
$resn_exch{"C4'' 655"}=" C4B 655"; $resn_exch{"C5'' 655"}=" C5B 655"; $resn_exch{"C31' 678"}=" CV' 678";
$resn_exch{"C32' 678"}=" CW' 678"; $resn_exch{"O33' 678"}=" OX' 678"; $resn_exch{"O34' 678"}=" OY' 678";
$resn_exch{"C31' 693"}=" CVX 693"; $resn_exch{"C32' 693"}=" CWX 693"; $resn_exch{"O33' 693"}=" OXX 693";
$resn_exch{"O34' 693"}=" OYX 693"; $resn_exch{"C42' 693"}=" C6X 693"; $resn_exch{"C43' 693"}=" C7X 693";
$resn_exch{"O44' 693"}=" O8X 693"; $resn_exch{"O45' 693"}=" O9X 693"; $resn_exch{"C1'' 693"}=" C1B 693";
$resn_exch{"C2'' 693"}=" C2B 693"; $resn_exch{"C3'' 693"}=" C3B 693"; $resn_exch{"C4'' 693"}=" C4B 693";
$resn_exch{"C5'' 693"}=" C5B 693"; $resn_exch{"C6'' 693"}=" C6B 693"; $resn_exch{"F2'' 693"}=" F2B 693";
$resn_exch{"C1'' 696"}=" C1B 696"; $resn_exch{"C2'' 696"}=" C2B 696"; $resn_exch{"C3'' 696"}=" C3B 696";
$resn_exch{"C4'' 696"}=" C4B 696"; $resn_exch{"C5'' 696"}=" C5B 696"; $resn_exch{"C6'' 696"}=" C6B 696";
$resn_exch{" O2P 6CT"}=" OP2 6CT"; $resn_exch{" O1P 6CT"}=" OP1 6CT"; $resn_exch{" O5* 6CT"}=" O5' 6CT";
$resn_exch{" C5* 6CT"}=" C5' 6CT"; $resn_exch{" C4* 6CT"}=" C4' 6CT"; $resn_exch{" C3* 6CT"}=" C3' 6CT";
$resn_exch{" O3* 6CT"}=" O3' 6CT"; $resn_exch{" C2* 6CT"}=" C2' 6CT"; $resn_exch{" C1* 6CT"}=" C1' 6CT";
$resn_exch{" C*  6CT"}=" C'  6CT"; $resn_exch{" CM* 6CT"}=" CM' 6CT"; $resn_exch{"PHO1 6CT"}="HO1P 6CT";
$resn_exch{" C1* 6FA"}=" C1' 6FA"; $resn_exch{" C2* 6FA"}=" C2' 6FA"; $resn_exch{" O2* 6FA"}=" O2' 6FA";
$resn_exch{" C3* 6FA"}=" C3' 6FA"; $resn_exch{" O3* 6FA"}=" O3' 6FA"; $resn_exch{" C4* 6FA"}=" C4' 6FA";
$resn_exch{" O4* 6FA"}=" O4' 6FA"; $resn_exch{" C5* 6FA"}=" C5' 6FA"; $resn_exch{" O5* 6FA"}=" O5' 6FA";
$resn_exch{" AP  6FA"}=" PA  6FA"; $resn_exch{" AO1 6FA"}=" O1A 6FA"; $resn_exch{" AO2 6FA"}=" O2A 6FA";
$resn_exch{"AO5* 6FA"}=" O5B 6FA"; $resn_exch{"AC5* 6FA"}=" C5B 6FA"; $resn_exch{"AC4* 6FA"}=" C4B 6FA";
$resn_exch{"AO4* 6FA"}=" O4B 6FA"; $resn_exch{"AC3* 6FA"}=" C3B 6FA"; $resn_exch{"AO3* 6FA"}=" O3B 6FA";
$resn_exch{"AC2* 6FA"}=" C2B 6FA"; $resn_exch{"AO2* 6FA"}=" O2B 6FA"; $resn_exch{"AC1* 6FA"}=" C1B 6FA";
$resn_exch{" AN9 6FA"}=" N9A 6FA"; $resn_exch{" AC8 6FA"}=" C8A 6FA"; $resn_exch{" AN7 6FA"}=" N7A 6FA";
$resn_exch{" AC5 6FA"}=" C5X 6FA"; $resn_exch{" AC6 6FA"}=" C6A 6FA"; $resn_exch{" AN6 6FA"}=" N6A 6FA";
$resn_exch{" AN1 6FA"}=" N1A 6FA"; $resn_exch{" AC2 6FA"}=" C2A 6FA"; $resn_exch{" AN3 6FA"}=" N3A 6FA";
$resn_exch{" AC4 6FA"}=" C4X 6FA"; $resn_exch{" O1P 6HA"}=" OP1 6HA"; $resn_exch{" O2P 6HA"}=" OP2 6HA";
$resn_exch{" O3P 6HA"}=" OP3 6HA"; $resn_exch{" O5* 6HA"}=" O5' 6HA"; $resn_exch{" C5* 6HA"}=" C5' 6HA";
$resn_exch{" C4* 6HA"}=" C4' 6HA"; $resn_exch{" O4* 6HA"}=" O4' 6HA"; $resn_exch{" C3* 6HA"}=" C3' 6HA";
$resn_exch{" O3* 6HA"}=" O3' 6HA"; $resn_exch{" C2* 6HA"}=" C2' 6HA"; $resn_exch{" C1* 6HA"}=" C1' 6HA";
$resn_exch{" C6* 6HA"}=" C6' 6HA"; $resn_exch{" O1P 6HC"}=" OP1 6HC"; $resn_exch{" O2P 6HC"}=" OP2 6HC";
$resn_exch{" O3P 6HC"}=" OP3 6HC"; $resn_exch{" O5* 6HC"}=" O5' 6HC"; $resn_exch{" C5* 6HC"}=" C5' 6HC";
$resn_exch{" C4* 6HC"}=" C4' 6HC"; $resn_exch{" O4* 6HC"}=" O4' 6HC"; $resn_exch{" C3* 6HC"}=" C3' 6HC";
$resn_exch{" O3* 6HC"}=" O3' 6HC"; $resn_exch{" C2* 6HC"}=" C2' 6HC"; $resn_exch{" C1* 6HC"}=" C1' 6HC";
$resn_exch{" C6* 6HC"}=" C6' 6HC"; $resn_exch{" O1P 6HG"}=" OP1 6HG"; $resn_exch{" O2P 6HG"}=" OP2 6HG";
$resn_exch{" O3P 6HG"}=" OP3 6HG"; $resn_exch{" O5* 6HG"}=" O5' 6HG"; $resn_exch{" C5* 6HG"}=" C5' 6HG";
$resn_exch{" C4* 6HG"}=" C4' 6HG"; $resn_exch{" O4* 6HG"}=" O4' 6HG"; $resn_exch{" C3* 6HG"}=" C3' 6HG";
$resn_exch{" O3* 6HG"}=" O3' 6HG"; $resn_exch{" C2* 6HG"}=" C2' 6HG"; $resn_exch{" C1* 6HG"}=" C1' 6HG";
$resn_exch{" C6* 6HG"}=" C6' 6HG"; $resn_exch{" O1P 6HT"}=" OP1 6HT"; $resn_exch{" O2P 6HT"}=" OP2 6HT";
$resn_exch{" O3P 6HT"}=" OP3 6HT"; $resn_exch{" O5* 6HT"}=" O5' 6HT"; $resn_exch{" C5* 6HT"}=" C5' 6HT";
$resn_exch{" C4* 6HT"}=" C4' 6HT"; $resn_exch{" O4* 6HT"}=" O4' 6HT"; $resn_exch{" C3* 6HT"}=" C3' 6HT";
$resn_exch{" O3* 6HT"}=" O3' 6HT"; $resn_exch{" C2* 6HT"}=" C2' 6HT"; $resn_exch{" C1* 6HT"}=" C1' 6HT";
$resn_exch{" C6* 6HT"}=" C6' 6HT"; $resn_exch{" O3P 6IA"}=" OP3 6IA"; $resn_exch{" O1P 6IA"}=" OP1 6IA";
$resn_exch{" O2P 6IA"}=" OP2 6IA"; $resn_exch{" O5* 6IA"}=" O5' 6IA"; $resn_exch{" C5* 6IA"}=" C5' 6IA";
$resn_exch{" C4* 6IA"}=" C4' 6IA"; $resn_exch{" O4* 6IA"}=" O4' 6IA"; $resn_exch{" C3* 6IA"}=" C3' 6IA";
$resn_exch{" O3* 6IA"}=" O3' 6IA"; $resn_exch{" C2* 6IA"}=" C2' 6IA"; $resn_exch{" O2* 6IA"}=" O2' 6IA";
$resn_exch{" C1* 6IA"}=" C1' 6IA"; $resn_exch{" O3P 6MA"}=" OP3 6MA"; $resn_exch{" O1P 6MA"}=" OP1 6MA";
$resn_exch{" O2P 6MA"}=" OP2 6MA"; $resn_exch{" O5* 6MA"}=" O5' 6MA"; $resn_exch{" C5* 6MA"}=" C5' 6MA";
$resn_exch{" C4* 6MA"}=" C4' 6MA"; $resn_exch{" O4* 6MA"}=" O4' 6MA"; $resn_exch{" C3* 6MA"}=" C3' 6MA";
$resn_exch{" O3* 6MA"}=" O3' 6MA"; $resn_exch{" C2* 6MA"}=" C2' 6MA"; $resn_exch{" C1* 6MA"}=" C1' 6MA";
$resn_exch{" O3P 6MC"}=" OP3 6MC"; $resn_exch{" O1P 6MC"}=" OP1 6MC"; $resn_exch{" O2P 6MC"}=" OP2 6MC";
$resn_exch{" O5* 6MC"}=" O5' 6MC"; $resn_exch{" C5* 6MC"}=" C5' 6MC"; $resn_exch{" C4* 6MC"}=" C4' 6MC";
$resn_exch{" O4* 6MC"}=" O4' 6MC"; $resn_exch{" C3* 6MC"}=" C3' 6MC"; $resn_exch{" O3* 6MC"}=" O3' 6MC";
$resn_exch{" C2* 6MC"}=" C2' 6MC"; $resn_exch{" C1* 6MC"}=" C1' 6MC"; $resn_exch{" O5* 6MI"}=" O5' 6MI";
$resn_exch{" C2* 6MI"}=" C2' 6MI"; $resn_exch{" C5* 6MI"}=" C5' 6MI"; $resn_exch{" C4* 6MI"}=" C4' 6MI";
$resn_exch{" O4* 6MI"}=" O4' 6MI"; $resn_exch{" C1* 6MI"}=" C1' 6MI"; $resn_exch{" C3* 6MI"}=" C3' 6MI";
$resn_exch{" O3* 6MI"}=" O3' 6MI"; $resn_exch{" O3P 6MT"}=" OP3 6MT"; $resn_exch{" O1P 6MT"}=" OP1 6MT";
$resn_exch{" O2P 6MT"}=" OP2 6MT"; $resn_exch{" O5* 6MT"}=" O5' 6MT"; $resn_exch{" C5* 6MT"}=" C5' 6MT";
$resn_exch{" C4* 6MT"}=" C4' 6MT"; $resn_exch{" O4* 6MT"}=" O4' 6MT"; $resn_exch{" C3* 6MT"}=" C3' 6MT";
$resn_exch{" O3* 6MT"}=" O3' 6MT"; $resn_exch{" C2* 6MT"}=" C2' 6MT"; $resn_exch{" C1* 6MT"}=" C1' 6MT";
$resn_exch{" O5* 6MZ"}=" O5' 6MZ"; $resn_exch{" C5* 6MZ"}=" C5' 6MZ"; $resn_exch{" C4* 6MZ"}=" C4' 6MZ";
$resn_exch{" O4* 6MZ"}=" O4' 6MZ"; $resn_exch{" C1* 6MZ"}=" C1' 6MZ"; $resn_exch{" C2* 6MZ"}=" C2' 6MZ";
$resn_exch{" O2* 6MZ"}=" O2' 6MZ"; $resn_exch{" C3* 6MZ"}=" C3' 6MZ"; $resn_exch{" O3* 6MZ"}=" O3' 6MZ";
$resn_exch{"C1'' 6NH"}=" C1B 6NH"; $resn_exch{"C2'' 6NH"}=" C2B 6NH"; $resn_exch{"C3'' 6NH"}=" C3B 6NH";
$resn_exch{"C4'' 6NH"}=" C4B 6NH"; $resn_exch{"C5'' 6NH"}=" C5B 6NH"; $resn_exch{"C6'' 6NH"}=" C6B 6NH";
$resn_exch{" O1P 6OG"}=" OP1 6OG"; $resn_exch{" O2P 6OG"}=" OP2 6OG"; $resn_exch{" O5* 6OG"}=" O5' 6OG";
$resn_exch{" C2* 6OG"}=" C2' 6OG"; $resn_exch{" C5* 6OG"}=" C5' 6OG"; $resn_exch{" C4* 6OG"}=" C4' 6OG";
$resn_exch{" O4* 6OG"}=" O4' 6OG"; $resn_exch{" C1* 6OG"}=" C1' 6OG"; $resn_exch{" C3* 6OG"}=" C3' 6OG";
$resn_exch{" O3* 6OG"}=" O3' 6OG"; $resn_exch{" O3P 6OG"}=" OP3 6OG"; $resn_exch{" C1* 70U"}=" C1' 70U";
$resn_exch{" O2* 70U"}=" O2' 70U"; $resn_exch{" C2* 70U"}=" C2' 70U"; $resn_exch{" O3* 70U"}=" O3' 70U";
$resn_exch{" C3* 70U"}=" C3' 70U"; $resn_exch{" C4* 70U"}=" C4' 70U"; $resn_exch{" O4* 70U"}=" O4' 70U";
$resn_exch{" C5* 70U"}=" C5' 70U"; $resn_exch{" O5* 70U"}=" O5' 70U"; $resn_exch{" O1P 70U"}=" OP1 70U";
$resn_exch{" O2P 70U"}=" OP2 70U"; $resn_exch{" O3P 70U"}=" OP3 70U"; $resn_exch{"C1'' 762"}=" C1B 762";
$resn_exch{"C2'' 762"}=" C2B 762"; $resn_exch{"C3'' 762"}=" C3B 762"; $resn_exch{"C4'' 762"}=" C4B 762";
$resn_exch{"C5'' 762"}=" C5B 762"; $resn_exch{"C6'' 762"}=" C6B 762"; $resn_exch{"C1'' 780"}=" C1B 780";
$resn_exch{"C2'' 780"}=" C2B 780"; $resn_exch{"C3'' 780"}=" C3B 780"; $resn_exch{"C4'' 780"}=" C4B 780";
$resn_exch{"C5'' 780"}=" C5B 780"; $resn_exch{"C6'' 780"}=" C6B 780"; $resn_exch{"CM3' 783"}=" C3X 783";
$resn_exch{"C1'' 783"}=" C1B 783"; $resn_exch{"C2'' 783"}=" C2B 783"; $resn_exch{"C3'' 783"}=" C3B 783";
$resn_exch{"C4'' 783"}=" C4B 783"; $resn_exch{"C5'' 783"}=" C5B 783"; $resn_exch{"C6'' 783"}=" C6B 783";
$resn_exch{"CF3' 785"}=" C3X 785"; $resn_exch{"F31' 785"}=" FV' 785"; $resn_exch{"F32' 785"}=" FW' 785";
$resn_exch{"F33' 785"}=" FX' 785"; $resn_exch{" O1P 7DA"}=" OP1 7DA"; $resn_exch{" O2P 7DA"}=" OP2 7DA";
$resn_exch{" O5* 7DA"}=" O5' 7DA"; $resn_exch{" C2* 7DA"}=" C2' 7DA"; $resn_exch{" C5* 7DA"}=" C5' 7DA";
$resn_exch{" C4* 7DA"}=" C4' 7DA"; $resn_exch{" O4* 7DA"}=" O4' 7DA"; $resn_exch{" C1* 7DA"}=" C1' 7DA";
$resn_exch{" C3* 7DA"}=" C3' 7DA"; $resn_exch{" O3* 7DA"}=" O3' 7DA"; $resn_exch{" O3P 7DA"}=" OP3 7DA";
$resn_exch{" O1P 7GU"}=" OP1 7GU"; $resn_exch{" O2P 7GU"}=" OP2 7GU"; $resn_exch{" O5* 7GU"}=" O5' 7GU";
$resn_exch{" C2* 7GU"}=" C2' 7GU"; $resn_exch{" C5* 7GU"}=" C5' 7GU"; $resn_exch{" C4* 7GU"}=" C4' 7GU";
$resn_exch{" O4* 7GU"}=" O4' 7GU"; $resn_exch{" C1* 7GU"}=" C1' 7GU"; $resn_exch{" C3* 7GU"}=" C3' 7GU";
$resn_exch{" O3* 7GU"}=" O3' 7GU"; $resn_exch{" O3P 7GU"}=" OP3 7GU"; $resn_exch{" O1P 7MG"}=" OP1 7MG";
$resn_exch{" O2P 7MG"}=" OP2 7MG"; $resn_exch{" O3P 7MG"}=" OP3 7MG"; $resn_exch{" O5* 7MG"}=" O5' 7MG";
$resn_exch{" C5* 7MG"}=" C5' 7MG"; $resn_exch{" C4* 7MG"}=" C4' 7MG"; $resn_exch{" O4* 7MG"}=" O4' 7MG";
$resn_exch{" C3* 7MG"}=" C3' 7MG"; $resn_exch{" O3* 7MG"}=" O3' 7MG"; $resn_exch{" C2* 7MG"}=" C2' 7MG";
$resn_exch{" O2* 7MG"}=" O2' 7MG"; $resn_exch{" C1* 7MG"}=" C1' 7MG"; $resn_exch{"C1'' 7NH"}=" C1B 7NH";
$resn_exch{"C2'' 7NH"}=" C2B 7NH"; $resn_exch{"C3'' 7NH"}=" C3B 7NH"; $resn_exch{"C4'' 7NH"}=" C4B 7NH";
$resn_exch{"C5'' 7NH"}=" C5B 7NH"; $resn_exch{"C6'' 7NH"}=" C6B 7NH"; $resn_exch{" O5* 7RA"}=" O5' 7RA";
$resn_exch{" C5* 7RA"}=" C5' 7RA"; $resn_exch{" C4* 7RA"}=" C4' 7RA"; $resn_exch{" O4* 7RA"}=" O4' 7RA";
$resn_exch{" C3* 7RA"}=" C3' 7RA"; $resn_exch{" O3* 7RA"}=" O3' 7RA"; $resn_exch{" C2* 7RA"}=" C2' 7RA";
$resn_exch{" O2* 7RA"}=" O2' 7RA"; $resn_exch{" C1* 7RA"}=" C1' 7RA"; $resn_exch{" O5* 7RP"}=" O5' 7RP";
$resn_exch{" C5* 7RP"}=" C5' 7RP"; $resn_exch{" C4* 7RP"}=" C4' 7RP"; $resn_exch{" O4* 7RP"}=" O4' 7RP";
$resn_exch{" C3* 7RP"}=" C3' 7RP"; $resn_exch{" O3* 7RP"}=" O3' 7RP"; $resn_exch{" C2* 7RP"}=" C2' 7RP";
$resn_exch{" O2* 7RP"}=" O2' 7RP"; $resn_exch{" C1* 7RP"}=" C1' 7RP"; $resn_exch{"C14A 81A"}=" CEA 81A";
$resn_exch{"C14B 81A"}=" CEB 81A"; $resn_exch{"C31' 847"}=" CVX 847"; $resn_exch{"C32' 847"}=" CWX 847";
$resn_exch{"O33' 847"}=" OXX 847"; $resn_exch{"O34' 847"}=" OYX 847"; $resn_exch{"C42' 847"}=" C6X 847";
$resn_exch{"C43' 847"}=" C7X 847"; $resn_exch{"O44' 847"}=" O8X 847"; $resn_exch{"O45' 847"}=" O9X 847";
$resn_exch{" O5* 8BR"}=" O5' 8BR"; $resn_exch{" C5* 8BR"}=" C5' 8BR"; $resn_exch{" C4* 8BR"}=" C4' 8BR";
$resn_exch{" O4* 8BR"}=" O4' 8BR"; $resn_exch{" C3* 8BR"}=" C3' 8BR"; $resn_exch{" O3* 8BR"}=" O3' 8BR";
$resn_exch{" C2* 8BR"}=" C2' 8BR"; $resn_exch{" O2* 8BR"}=" O2' 8BR"; $resn_exch{" C1* 8BR"}=" C1' 8BR";
$resn_exch{" C5* 8DA"}=" C5' 8DA"; $resn_exch{" C4* 8DA"}=" C4' 8DA"; $resn_exch{" C3* 8DA"}=" C3' 8DA";
$resn_exch{" O3* 8DA"}=" O3' 8DA"; $resn_exch{" O4* 8DA"}=" O4' 8DA"; $resn_exch{" C1* 8DA"}=" C1' 8DA";
$resn_exch{" C2* 8DA"}=" C2' 8DA"; $resn_exch{" O5* 8DG"}=" O5' 8DG"; $resn_exch{" C5* 8DG"}=" C5' 8DG";
$resn_exch{" C4* 8DG"}=" C4' 8DG"; $resn_exch{" O4* 8DG"}=" O4' 8DG"; $resn_exch{" C3* 8DG"}=" C3' 8DG";
$resn_exch{" O3* 8DG"}=" O3' 8DG"; $resn_exch{" C2* 8DG"}=" C2' 8DG"; $resn_exch{" C1* 8DG"}=" C1' 8DG";
$resn_exch{" O3P 8FG"}=" OP3 8FG"; $resn_exch{" O1P 8FG"}=" OP1 8FG"; $resn_exch{" O2P 8FG"}=" OP2 8FG";
$resn_exch{" O5* 8FG"}=" O5' 8FG"; $resn_exch{" C2* 8FG"}=" C2' 8FG"; $resn_exch{" C5* 8FG"}=" C5' 8FG";
$resn_exch{" C4* 8FG"}=" C4' 8FG"; $resn_exch{" O4* 8FG"}=" O4' 8FG"; $resn_exch{" C1* 8FG"}=" C1' 8FG";
$resn_exch{" C3* 8FG"}=" C3' 8FG"; $resn_exch{" O3* 8FG"}=" O3' 8FG"; $resn_exch{" O5* 8GT"}=" O5' 8GT";
$resn_exch{" C5* 8GT"}=" C5' 8GT"; $resn_exch{" C4* 8GT"}=" C4' 8GT"; $resn_exch{" O4* 8GT"}=" O4' 8GT";
$resn_exch{" C3* 8GT"}=" C3' 8GT"; $resn_exch{" O3* 8GT"}=" O3' 8GT"; $resn_exch{" C2* 8GT"}=" C2' 8GT";
$resn_exch{" O2* 8GT"}=" O2' 8GT"; $resn_exch{" C1* 8GT"}=" C1' 8GT"; $resn_exch{" C1* 8HG"}=" C1' 8HG";
$resn_exch{" O4* 8HG"}=" O4' 8HG"; $resn_exch{" C2* 8HG"}=" C2' 8HG"; $resn_exch{" C3* 8HG"}=" C3' 8HG";
$resn_exch{" O3* 8HG"}=" O3' 8HG"; $resn_exch{" C4* 8HG"}=" C4' 8HG"; $resn_exch{" C5* 8HG"}=" C5' 8HG";
$resn_exch{" O5* 8HG"}=" O5' 8HG"; $resn_exch{" O5* 8ID"}=" O5B 8ID"; $resn_exch{" C5* 8ID"}=" C5B 8ID";
$resn_exch{" C4* 8ID"}=" C4B 8ID"; $resn_exch{" O4* 8ID"}=" O4B 8ID"; $resn_exch{" C1* 8ID"}=" C1B 8ID";
$resn_exch{" C2* 8ID"}=" C2B 8ID"; $resn_exch{" O2* 8ID"}=" O2B 8ID"; $resn_exch{" C3* 8ID"}=" C3B 8ID";
$resn_exch{" O3* 8ID"}=" O3B 8ID"; $resn_exch{" O3P 8MG"}=" OP3 8MG"; $resn_exch{" O2P 8MG"}=" OP2 8MG";
$resn_exch{" O5* 8MG"}=" O5' 8MG"; $resn_exch{" C2* 8MG"}=" C2' 8MG"; $resn_exch{" C5* 8MG"}=" C5' 8MG";
$resn_exch{" C4* 8MG"}=" C4' 8MG"; $resn_exch{" O4* 8MG"}=" O4' 8MG"; $resn_exch{" C1* 8MG"}=" C1' 8MG";
$resn_exch{" C3* 8MG"}=" C3' 8MG"; $resn_exch{" O3* 8MG"}=" O3' 8MG"; $resn_exch{" O1P 8MG"}=" OP1 8MG";
$resn_exch{" O3P 8OG"}=" OP3 8OG"; $resn_exch{" O1P 8OG"}=" OP1 8OG"; $resn_exch{" O2P 8OG"}=" OP2 8OG";
$resn_exch{" O5* 8OG"}=" O5' 8OG"; $resn_exch{" C5* 8OG"}=" C5' 8OG"; $resn_exch{" C4* 8OG"}=" C4' 8OG";
$resn_exch{" O4* 8OG"}=" O4' 8OG"; $resn_exch{" C3* 8OG"}=" C3' 8OG"; $resn_exch{" O3* 8OG"}=" O3' 8OG";
$resn_exch{" C2* 8OG"}=" C2' 8OG"; $resn_exch{" C1* 8OG"}=" C1' 8OG"; $resn_exch{"C31' 907"}=" CV' 907";
$resn_exch{" C5* 93A"}=" C5' 93A"; $resn_exch{" O5* 93A"}=" O5' 93A"; $resn_exch{"C1'' 991"}=" C1B 991";
$resn_exch{"C2'' 991"}=" C2B 991"; $resn_exch{"C3'' 991"}=" C3B 991"; $resn_exch{"C4'' 991"}=" C4B 991";
$resn_exch{"C5'' 991"}=" C5B 991"; $resn_exch{" O3P   A"}=" OP3   A"; $resn_exch{" O1P   A"}=" OP1   A";
$resn_exch{" O2P   A"}=" OP2   A"; $resn_exch{" O5*   A"}=" O5'   A"; $resn_exch{" C5*   A"}=" C5'   A";
$resn_exch{" C4*   A"}=" C4'   A"; $resn_exch{" O4*   A"}=" O4'   A"; $resn_exch{" C3*   A"}=" C3'   A";
$resn_exch{" O3*   A"}=" O3'   A"; $resn_exch{" C2*   A"}=" C2'   A"; $resn_exch{" O2*   A"}=" O2'   A";
$resn_exch{" C1*   A"}=" C1'   A"; $resn_exch{" O5* A12"}=" O5' A12"; $resn_exch{" C5* A12"}=" C5' A12";
$resn_exch{" C4* A12"}=" C4' A12"; $resn_exch{" O4* A12"}=" O4' A12"; $resn_exch{" C3* A12"}=" C3' A12";
$resn_exch{" O3* A12"}=" O3' A12"; $resn_exch{" C2* A12"}=" C2' A12"; $resn_exch{" O2* A12"}=" O2' A12";
$resn_exch{" C1* A12"}=" C1' A12"; $resn_exch{" O5* A1P"}=" O5' A1P"; $resn_exch{" C2* A1P"}=" C2' A1P";
$resn_exch{" C5* A1P"}=" C5' A1P"; $resn_exch{" C4* A1P"}=" C4' A1P"; $resn_exch{" O4* A1P"}=" O4' A1P";
$resn_exch{" C1* A1P"}=" C1' A1P"; $resn_exch{" C3* A1P"}=" C3' A1P"; $resn_exch{" O3* A1P"}=" O3' A1P";
$resn_exch{" C1* A1R"}=" C1' A1R"; $resn_exch{" C2* A1R"}=" C2' A1R"; $resn_exch{" O2* A1R"}=" O2' A1R";
$resn_exch{" C3* A1R"}=" C3' A1R"; $resn_exch{" O3* A1R"}=" O3' A1R"; $resn_exch{" O4* A1R"}=" O4' A1R";
$resn_exch{" C4* A1R"}=" C4' A1R"; $resn_exch{" C5* A1R"}=" C5' A1R"; $resn_exch{" O5* A1R"}=" O5' A1R";
$resn_exch{"P2*A A22"}=" P2D A22"; $resn_exch{"O1PA A22"}=" O11 A22"; $resn_exch{"O2PA A22"}=" O12 A22";
$resn_exch{"O3PA A22"}=" O13 A22"; $resn_exch{"O5PA A22"}=" O14 A22"; $resn_exch{"O6PA A22"}=" O15 A22";
$resn_exch{"O5*A A22"}=" O5D A22"; $resn_exch{"C5*A A22"}=" C5D A22"; $resn_exch{"C4*A A22"}=" C4D A22";
$resn_exch{"O4*A A22"}=" O4D A22"; $resn_exch{"C3*A A22"}=" C3D A22"; $resn_exch{"O3*A A22"}=" O3D A22";
$resn_exch{"C2*A A22"}=" C2D A22"; $resn_exch{"O2*A A22"}=" O2D A22"; $resn_exch{"C1*A A22"}=" C1D A22";
$resn_exch{"O1PB A22"}=" O16 A22"; $resn_exch{"O2PB A22"}=" O17 A22"; $resn_exch{"O3PB A22"}=" O18 A22";
$resn_exch{"O5*B A22"}=" O5E A22"; $resn_exch{"C5*B A22"}=" C5E A22"; $resn_exch{"C4*B A22"}=" C4E A22";
$resn_exch{"O4*B A22"}=" O4E A22"; $resn_exch{"C3*B A22"}=" C3E A22"; $resn_exch{"O3*B A22"}=" O3E A22";
$resn_exch{"C2*B A22"}=" C2E A22"; $resn_exch{"O2*B A22"}=" O2E A22"; $resn_exch{"C1*B A22"}=" C1E A22";
$resn_exch{" O1P A23"}=" OP1 A23"; $resn_exch{" O2P A23"}=" OP2 A23"; $resn_exch{" O3P A23"}=" OP3 A23";
$resn_exch{" O5* A23"}=" O5' A23"; $resn_exch{" C5* A23"}=" C5' A23"; $resn_exch{" C4* A23"}=" C4' A23";
$resn_exch{" O4* A23"}=" O4' A23"; $resn_exch{" C3* A23"}=" C3' A23"; $resn_exch{" O3* A23"}=" O3' A23";
$resn_exch{" C2* A23"}=" C2' A23"; $resn_exch{" O2* A23"}=" O2' A23"; $resn_exch{" C1* A23"}=" C1' A23";
$resn_exch{" O1* A24"}=" O1B A24"; $resn_exch{" C2* A24"}=" C2B A24"; $resn_exch{" C3* A24"}=" C3B A24";
$resn_exch{" N4* A24"}=" N4' A24"; $resn_exch{" C5* A24"}=" C5B A24"; $resn_exch{" C6* A24"}=" C6B A24";
$resn_exch{" C7* A24"}=" C7B A24"; $resn_exch{" C8* A24"}=" C8' A24"; $resn_exch{"O5*A A2D"}=" O5D A2D";
$resn_exch{"C5*A A2D"}=" C5D A2D"; $resn_exch{"C4*A A2D"}=" C4D A2D"; $resn_exch{"O4*A A2D"}=" O4D A2D";
$resn_exch{"C3*A A2D"}=" C3D A2D"; $resn_exch{"O3*A A2D"}=" O3D A2D"; $resn_exch{"C2*A A2D"}=" C2D A2D";
$resn_exch{"O2*A A2D"}=" O2D A2D"; $resn_exch{"C1*A A2D"}=" C1D A2D"; $resn_exch{"O5*B A2D"}=" O5E A2D";
$resn_exch{"C5*B A2D"}=" C5E A2D"; $resn_exch{"C4*B A2D"}=" C4E A2D"; $resn_exch{"O4*B A2D"}=" O4E A2D";
$resn_exch{"C3*B A2D"}=" C3E A2D"; $resn_exch{"O3*B A2D"}=" O3E A2D"; $resn_exch{"C2*B A2D"}=" C2E A2D";
$resn_exch{"O2*B A2D"}=" O2E A2D"; $resn_exch{"C1*B A2D"}=" C1E A2D"; $resn_exch{" O2* A2L"}=" O2' A2L";
$resn_exch{" C2* A2L"}=" C2' A2L"; $resn_exch{" C1* A2L"}=" C1' A2L"; $resn_exch{" O4* A2L"}=" O4' A2L";
$resn_exch{" C4* A2L"}=" C4' A2L"; $resn_exch{" C5* A2L"}=" C5' A2L"; $resn_exch{" O5* A2L"}=" O5' A2L";
$resn_exch{" O1P A2L"}=" OP1 A2L"; $resn_exch{" O3P A2L"}=" OP3 A2L"; $resn_exch{" O2P A2L"}=" OP2 A2L";
$resn_exch{" C3* A2L"}=" C3' A2L"; $resn_exch{" O3* A2L"}=" O3' A2L"; $resn_exch{" CA* A2L"}=" CA' A2L";
$resn_exch{" CB* A2L"}=" CB' A2L"; $resn_exch{" OC* A2L"}=" OC' A2L"; $resn_exch{" CD* A2L"}=" CD' A2L";
$resn_exch{" O3P A2M"}=" OP3 A2M"; $resn_exch{" O1P A2M"}=" OP1 A2M"; $resn_exch{" O2P A2M"}=" OP2 A2M";
$resn_exch{" O5* A2M"}=" O5' A2M"; $resn_exch{" C5* A2M"}=" C5' A2M"; $resn_exch{" C4* A2M"}=" C4' A2M";
$resn_exch{" O4* A2M"}=" O4' A2M"; $resn_exch{" C3* A2M"}=" C3' A2M"; $resn_exch{" O3* A2M"}=" O3' A2M";
$resn_exch{" C2* A2M"}=" C2' A2M"; $resn_exch{" O2* A2M"}=" O2' A2M"; $resn_exch{" C1* A2M"}=" C1' A2M";
$resn_exch{" CM* A2M"}=" CM' A2M"; $resn_exch{" O5* A2P"}=" O5' A2P"; $resn_exch{" C5* A2P"}=" C5' A2P";
$resn_exch{" C4* A2P"}=" C4' A2P"; $resn_exch{" O4* A2P"}=" O4' A2P"; $resn_exch{" C3* A2P"}=" C3' A2P";
$resn_exch{" O3* A2P"}=" O3' A2P"; $resn_exch{" C2* A2P"}=" C2' A2P"; $resn_exch{" O2* A2P"}=" O2' A2P";
$resn_exch{" C1* A2P"}=" C1' A2P"; $resn_exch{" P2* A2R"}=" P2' A2R"; $resn_exch{" O2* A2R"}=" O2' A2R";
$resn_exch{" C2* A2R"}=" C2' A2R"; $resn_exch{" C1* A2R"}=" C1' A2R"; $resn_exch{" O4* A2R"}=" O4' A2R";
$resn_exch{" C3* A2R"}=" C3' A2R"; $resn_exch{" O3* A2R"}=" O3' A2R"; $resn_exch{" C4* A2R"}=" C4' A2R";
$resn_exch{" C5* A2R"}=" C5' A2R"; $resn_exch{" O5* A2R"}=" O5' A2R"; $resn_exch{"O15* A2R"}="O15' A2R";
$resn_exch{"C15* A2R"}="C15' A2R"; $resn_exch{"C14* A2R"}="C14' A2R"; $resn_exch{"C13* A2R"}="C13' A2R";
$resn_exch{"O13* A2R"}="O13' A2R"; $resn_exch{"C12* A2R"}="C12' A2R"; $resn_exch{"O12* A2R"}="O12' A2R";
$resn_exch{"C11* A2R"}="C11' A2R"; $resn_exch{"O14* A2R"}="O14' A2R"; $resn_exch{"O11* A2R"}="O11' A2R";
$resn_exch{" O1* A32"}=" O1B A32"; $resn_exch{" C2* A32"}=" C2B A32"; $resn_exch{" C3* A32"}=" C3B A32";
$resn_exch{" N4* A32"}=" N4' A32"; $resn_exch{" C5* A32"}=" C5B A32"; $resn_exch{" C6* A32"}=" C6B A32";
$resn_exch{" C7* A32"}=" C7B A32"; $resn_exch{" C8* A32"}=" C8' A32"; $resn_exch{" C9* A32"}=" C9' A32";
$resn_exch{" O5* A34"}=" O5' A34"; $resn_exch{" C2* A34"}=" C2' A34"; $resn_exch{" C5* A34"}=" C5' A34";
$resn_exch{" C4* A34"}=" C4' A34"; $resn_exch{" O4* A34"}=" O4' A34"; $resn_exch{" C1* A34"}=" C1' A34";
$resn_exch{" C3* A34"}=" C3' A34"; $resn_exch{" O3* A34"}=" O3' A34"; $resn_exch{" O5* A35"}=" O5' A35";
$resn_exch{" C5* A35"}=" C5' A35"; $resn_exch{" C4* A35"}=" C4' A35"; $resn_exch{" O4* A35"}=" O4' A35";
$resn_exch{" C1* A35"}=" C1' A35"; $resn_exch{" C2* A35"}=" C2' A35"; $resn_exch{" C3* A35"}=" C3' A35";
$resn_exch{" O3* A35"}=" O3' A35"; $resn_exch{" O5* A38"}=" O5' A38"; $resn_exch{" C5* A38"}=" C5' A38";
$resn_exch{" C4* A38"}=" C4' A38"; $resn_exch{" O4* A38"}=" O4' A38"; $resn_exch{" C3* A38"}=" C3' A38";
$resn_exch{" O3* A38"}=" O3' A38"; $resn_exch{" C2* A38"}=" C2' A38"; $resn_exch{" C1* A38"}=" C1' A38";
$resn_exch{" O5* A39"}=" O5' A39"; $resn_exch{" C5* A39"}=" C5' A39"; $resn_exch{" C4* A39"}=" C4' A39";
$resn_exch{" O4* A39"}=" O4' A39"; $resn_exch{" C3* A39"}=" C3' A39"; $resn_exch{" O3* A39"}=" O3' A39";
$resn_exch{" C2* A39"}=" C2' A39"; $resn_exch{" O2* A39"}=" O2' A39"; $resn_exch{" C1* A39"}=" C1' A39";
$resn_exch{" O1P A3A"}=" OP1 A3A"; $resn_exch{" O2P A3A"}=" OP2 A3A"; $resn_exch{" O6* A3A"}=" O6' A3A";
$resn_exch{" C5* A3A"}=" C5' A3A"; $resn_exch{" C4* A3A"}=" C4' A3A"; $resn_exch{" O5* A3A"}=" O5' A3A";
$resn_exch{" C3* A3A"}=" C3' A3A"; $resn_exch{" O3* A3A"}=" O3' A3A"; $resn_exch{" C2* A3A"}=" C2' A3A";
$resn_exch{" C1* A3A"}=" C1' A3A"; $resn_exch{" AP  A3D"}=" PA  A3D"; $resn_exch{" AO1 A3D"}=" O1A A3D";
$resn_exch{" AO2 A3D"}=" O2A A3D"; $resn_exch{"AO5* A3D"}=" O5B A3D"; $resn_exch{"AC5* A3D"}=" C5B A3D";
$resn_exch{"AC4* A3D"}=" C4B A3D"; $resn_exch{"AO4* A3D"}=" O4B A3D"; $resn_exch{"AC3* A3D"}=" C3B A3D";
$resn_exch{"AO3* A3D"}=" O3B A3D"; $resn_exch{"AC2* A3D"}=" C2B A3D"; $resn_exch{"AO2* A3D"}=" O2B A3D";
$resn_exch{"AC1* A3D"}=" C1B A3D"; $resn_exch{" AN9 A3D"}=" N9A A3D"; $resn_exch{" AC8 A3D"}=" C8A A3D";
$resn_exch{" AN7 A3D"}=" N7A A3D"; $resn_exch{" AC5 A3D"}=" C5A A3D"; $resn_exch{" AC6 A3D"}=" C6A A3D";
$resn_exch{" AN6 A3D"}=" N6A A3D"; $resn_exch{" AN1 A3D"}=" N1A A3D"; $resn_exch{" AC2 A3D"}=" C2A A3D";
$resn_exch{" AN3 A3D"}=" N3A A3D"; $resn_exch{" AC4 A3D"}=" C4A A3D"; $resn_exch{" NP  A3D"}=" PN  A3D";
$resn_exch{" NO1 A3D"}=" O1N A3D"; $resn_exch{" NO2 A3D"}=" O2N A3D"; $resn_exch{"NO5* A3D"}=" O5D A3D";
$resn_exch{"NC5* A3D"}=" C5D A3D"; $resn_exch{"NC4* A3D"}=" C4D A3D"; $resn_exch{"NO4* A3D"}=" O4D A3D";
$resn_exch{"NC3* A3D"}=" C3D A3D"; $resn_exch{"NO3* A3D"}=" O3D A3D"; $resn_exch{"NC2* A3D"}=" C2D A3D";
$resn_exch{"NO2* A3D"}=" O2D A3D"; $resn_exch{"NC1* A3D"}=" C1D A3D"; $resn_exch{" NN1 A3D"}=" N1N A3D";
$resn_exch{" NC2 A3D"}=" C2N A3D"; $resn_exch{" NC3 A3D"}=" C3N A3D"; $resn_exch{" NC7 A3D"}=" C7N A3D";
$resn_exch{" NO7 A3D"}=" O7N A3D"; $resn_exch{" NC8 A3D"}=" C8N A3D"; $resn_exch{" NC4 A3D"}=" C4N A3D";
$resn_exch{" NC5 A3D"}=" C5N A3D"; $resn_exch{" NC6 A3D"}=" C6N A3D"; $resn_exch{" O5* A3P"}=" O5' A3P";
$resn_exch{" C5* A3P"}=" C5' A3P"; $resn_exch{" C4* A3P"}=" C4' A3P"; $resn_exch{" O4* A3P"}=" O4' A3P";
$resn_exch{" C3* A3P"}=" C3' A3P"; $resn_exch{" O3* A3P"}=" O3' A3P"; $resn_exch{" C2* A3P"}=" C2' A3P";
$resn_exch{" O2* A3P"}=" O2' A3P"; $resn_exch{" C1* A3P"}=" C1' A3P"; $resn_exch{" O5* A40"}=" O5' A40";
$resn_exch{" C5* A40"}=" C5' A40"; $resn_exch{" C4* A40"}=" C4' A40"; $resn_exch{" O4* A40"}=" O4' A40";
$resn_exch{" C1* A40"}=" C1' A40"; $resn_exch{" C2* A40"}=" C2' A40"; $resn_exch{" C3* A40"}=" C3' A40";
$resn_exch{" O3* A40"}=" O3' A40"; $resn_exch{" O5* A43"}=" O5' A43"; $resn_exch{" C5* A43"}=" C5' A43";
$resn_exch{" C4* A43"}=" C4' A43"; $resn_exch{" O4* A43"}=" O4' A43"; $resn_exch{" C3* A43"}=" C3' A43";
$resn_exch{" C2* A43"}=" C2' A43"; $resn_exch{" C1* A43"}=" C1' A43"; $resn_exch{" O5* A44"}=" O5' A44";
$resn_exch{" C5* A44"}=" C5' A44"; $resn_exch{" C4* A44"}=" C4' A44"; $resn_exch{" O4* A44"}=" O4' A44";
$resn_exch{" C3* A44"}=" C3' A44"; $resn_exch{" O3* A44"}=" O3' A44"; $resn_exch{" C2* A44"}=" C2' A44";
$resn_exch{" O2* A44"}=" O2' A44"; $resn_exch{" C1* A44"}=" C1' A44"; $resn_exch{" CA* A44"}=" CA' A44";
$resn_exch{" OC* A44"}=" OC' A44"; $resn_exch{" O5* A47"}=" O5' A47"; $resn_exch{" C5* A47"}=" C5' A47";
$resn_exch{" C4* A47"}=" C4' A47"; $resn_exch{" O4* A47"}=" O4' A47"; $resn_exch{" C3* A47"}=" C3' A47";
$resn_exch{" O3* A47"}=" O3' A47"; $resn_exch{" C2* A47"}=" C2' A47"; $resn_exch{" C1* A47"}=" C1' A47";
$resn_exch{" O5* A4P"}=" O5' A4P"; $resn_exch{" C5* A4P"}=" C5' A4P"; $resn_exch{" C4* A4P"}=" C4' A4P";
$resn_exch{" O4* A4P"}=" O4' A4P"; $resn_exch{" C3* A4P"}=" C3' A4P"; $resn_exch{" O3* A4P"}=" O3' A4P";
$resn_exch{" C2* A4P"}=" C2' A4P"; $resn_exch{" O2* A4P"}=" O2' A4P"; $resn_exch{" O5* A5A"}=" O5' A5A";
$resn_exch{" C5* A5A"}=" C5' A5A"; $resn_exch{" C4* A5A"}=" C4' A5A"; $resn_exch{" O4* A5A"}=" O4' A5A";
$resn_exch{" C3* A5A"}=" C3' A5A"; $resn_exch{" O3* A5A"}=" O3' A5A"; $resn_exch{" C2* A5A"}=" C2' A5A";
$resn_exch{" O2* A5A"}=" O2' A5A"; $resn_exch{" C1* A5A"}=" C1' A5A"; $resn_exch{" O1P A5M"}=" OP1 A5M";
$resn_exch{" O2P A5M"}=" OP2 A5M"; $resn_exch{" O5* A5M"}=" O5' A5M"; $resn_exch{" C5* A5M"}=" C5' A5M";
$resn_exch{" C4* A5M"}=" C4' A5M"; $resn_exch{" O4* A5M"}=" O4' A5M"; $resn_exch{" C1* A5M"}=" C1' A5M";
$resn_exch{" C2* A5M"}=" C2' A5M"; $resn_exch{" N2* A5M"}=" N2' A5M"; $resn_exch{" C3* A5M"}=" C3' A5M";
$resn_exch{" O3* A5M"}=" O3' A5M"; $resn_exch{" O3P A5M"}=" OP3 A5M"; $resn_exch{" C4* AAD"}=" C4' AAD";
$resn_exch{" O4* AAD"}=" O4' AAD"; $resn_exch{" C3* AAD"}=" C3' AAD"; $resn_exch{" O3* AAD"}=" O3' AAD";
$resn_exch{" C2* AAD"}=" C2' AAD"; $resn_exch{" O2* AAD"}=" O2' AAD"; $resn_exch{" C1* AAD"}=" C1' AAD";
$resn_exch{" C5* AAD"}=" C5' AAD"; $resn_exch{" O6* AAM"}=" O6' AAM"; $resn_exch{" C5* AAM"}=" C5' AAM";
$resn_exch{" C4* AAM"}=" C4' AAM"; $resn_exch{" O5* AAM"}=" O5' AAM"; $resn_exch{" C3* AAM"}=" C3' AAM";
$resn_exch{" O3* AAM"}=" O3' AAM"; $resn_exch{" C2* AAM"}=" C2' AAM"; $resn_exch{" O2* AAM"}=" O2' AAM";
$resn_exch{" C1* AAM"}=" C1' AAM"; $resn_exch{" C5* AAT"}=" C5' AAT"; $resn_exch{" C4* AAT"}=" C4' AAT";
$resn_exch{" O4* AAT"}=" O4' AAT"; $resn_exch{" C3* AAT"}=" C3' AAT"; $resn_exch{" O3* AAT"}=" O3' AAT";
$resn_exch{" C2* AAT"}=" C2' AAT"; $resn_exch{" O2* AAT"}=" O2' AAT"; $resn_exch{" C1* AAT"}=" C1' AAT";
$resn_exch{"O1P' ABF"}=" O1X ABF"; $resn_exch{"O2P' ABF"}=" O2X ABF"; $resn_exch{"O3P' ABF"}=" O3X ABF";
$resn_exch{" O5* ABM"}=" O5' ABM"; $resn_exch{" C5* ABM"}=" C5' ABM"; $resn_exch{" C4* ABM"}=" C4' ABM";
$resn_exch{" O4* ABM"}=" O4' ABM"; $resn_exch{" C3* ABM"}=" C3' ABM"; $resn_exch{" O3* ABM"}=" O3' ABM";
$resn_exch{" C2* ABM"}=" C2' ABM"; $resn_exch{" O2* ABM"}=" O2' ABM"; $resn_exch{" C1* ABM"}=" C1' ABM";
$resn_exch{" O5* ABP"}=" O5' ABP"; $resn_exch{" C5* ABP"}=" C5' ABP"; $resn_exch{" C4* ABP"}=" C4' ABP";
$resn_exch{" O4* ABP"}=" O4' ABP"; $resn_exch{" C3* ABP"}=" C3' ABP"; $resn_exch{" O3* ABP"}=" O3' ABP";
$resn_exch{" C2* ABP"}=" C2' ABP"; $resn_exch{" O2* ABP"}=" O2' ABP"; $resn_exch{" C1* ABP"}=" C1' ABP";
$resn_exch{" O1P ABR"}=" OP1 ABR"; $resn_exch{" O2P ABR"}=" OP2 ABR"; $resn_exch{" O5* ABR"}=" O5' ABR";
$resn_exch{" C5* ABR"}=" C5' ABR"; $resn_exch{" C4* ABR"}=" C4' ABR"; $resn_exch{" O4* ABR"}=" O4' ABR";
$resn_exch{" C1* ABR"}=" C1' ABR"; $resn_exch{" C2* ABR"}=" C2' ABR"; $resn_exch{" C3* ABR"}=" C3' ABR";
$resn_exch{" O3* ABR"}=" O3' ABR"; $resn_exch{" O3P ABR"}=" OP3 ABR"; $resn_exch{" O1P ABS"}=" OP1 ABS";
$resn_exch{" O2P ABS"}=" OP2 ABS"; $resn_exch{" O5* ABS"}=" O5' ABS"; $resn_exch{" C5* ABS"}=" C5' ABS";
$resn_exch{" C4* ABS"}=" C4' ABS"; $resn_exch{" O4* ABS"}=" O4' ABS"; $resn_exch{" C1* ABS"}=" C1' ABS";
$resn_exch{" C2* ABS"}=" C2' ABS"; $resn_exch{" C3* ABS"}=" C3' ABS"; $resn_exch{" O3* ABS"}=" O3' ABS";
$resn_exch{" O3P ABS"}=" OP3 ABS"; $resn_exch{" O5* ABT"}=" O5' ABT"; $resn_exch{" C5* ABT"}=" C5' ABT";
$resn_exch{" C4* ABT"}=" C4' ABT"; $resn_exch{" O4* ABT"}=" O4' ABT"; $resn_exch{" C1* ABT"}=" C1' ABT";
$resn_exch{" C2* ABT"}=" C2' ABT"; $resn_exch{" C3* ABT"}=" C3' ABT"; $resn_exch{" N3* ABT"}=" N3' ABT";
$resn_exch{" N4* ABT"}=" N4' ABT"; $resn_exch{" N5* ABT"}=" N5' ABT"; $resn_exch{" C3* AC2"}=" C3' AC2";
$resn_exch{" O3* AC2"}=" O3' AC2"; $resn_exch{" C2* AC2"}=" C2' AC2"; $resn_exch{" O1* AC2"}=" O1' AC2";
$resn_exch{" C1* AC2"}=" C1' AC2"; $resn_exch{" O5* ACK"}=" O5' ACK"; $resn_exch{" C5* ACK"}=" C5' ACK";
$resn_exch{" C4* ACK"}=" C4' ACK"; $resn_exch{" O4* ACK"}=" O4' ACK"; $resn_exch{" C3* ACK"}=" C3' ACK";
$resn_exch{" O3* ACK"}=" O3' ACK"; $resn_exch{" C1* ACK"}=" C1' ACK"; $resn_exch{" C2* ACK"}=" C2' ACK";
$resn_exch{" AN1 ACO"}=" N1A ACO"; $resn_exch{" AC2 ACO"}=" C2A ACO"; $resn_exch{" AN3 ACO"}=" N3A ACO";
$resn_exch{" AC4 ACO"}=" C4A ACO"; $resn_exch{" AC5 ACO"}=" C5A ACO"; $resn_exch{" AC6 ACO"}=" C6A ACO";
$resn_exch{" AN6 ACO"}=" N6A ACO"; $resn_exch{" AN7 ACO"}=" N7A ACO"; $resn_exch{" AC8 ACO"}=" C8A ACO";
$resn_exch{" AN9 ACO"}=" N9A ACO"; $resn_exch{"AC1* ACO"}=" C1B ACO"; $resn_exch{"AC2* ACO"}=" C2B ACO";
$resn_exch{"AO2* ACO"}=" O2B ACO"; $resn_exch{"AC3* ACO"}=" C3B ACO"; $resn_exch{"AO3* ACO"}=" O3B ACO";
$resn_exch{"AP3* ACO"}=" P3B ACO"; $resn_exch{" AO7 ACO"}=" O7A ACO"; $resn_exch{" AO8 ACO"}=" O8A ACO";
$resn_exch{" AO9 ACO"}=" O9A ACO"; $resn_exch{"AC4* ACO"}=" C4B ACO"; $resn_exch{"AO4* ACO"}=" O4B ACO";
$resn_exch{"AC5* ACO"}=" C5B ACO"; $resn_exch{"AO5* ACO"}=" O5B ACO"; $resn_exch{" AP1 ACO"}=" P1A ACO";
$resn_exch{" AO1 ACO"}=" O1A ACO"; $resn_exch{" AO2 ACO"}=" O2A ACO"; $resn_exch{" AO3 ACO"}=" O3A ACO";
$resn_exch{" AP2 ACO"}=" P2A ACO"; $resn_exch{" AO4 ACO"}=" O4A ACO"; $resn_exch{" AO5 ACO"}=" O5A ACO";
$resn_exch{" AO6 ACO"}=" O6A ACO"; $resn_exch{"PC11 ACO"}=" CBP ACO"; $resn_exch{"PC12 ACO"}=" CCP ACO";
$resn_exch{"PC13 ACO"}=" CDP ACO"; $resn_exch{"PC14 ACO"}=" CEP ACO"; $resn_exch{"PC10 ACO"}=" CAP ACO";
$resn_exch{"PO10 ACO"}=" OAP ACO"; $resn_exch{" PC9 ACO"}=" C9P ACO"; $resn_exch{" PO9 ACO"}=" O9P ACO";
$resn_exch{" PN8 ACO"}=" N8P ACO"; $resn_exch{" PC7 ACO"}=" C7P ACO"; $resn_exch{" PC6 ACO"}=" C6P ACO";
$resn_exch{" PC5 ACO"}=" C5P ACO"; $resn_exch{" PO5 ACO"}=" O5P ACO"; $resn_exch{" PN4 ACO"}=" N4P ACO";
$resn_exch{" PC3 ACO"}=" C3P ACO"; $resn_exch{" PC2 ACO"}=" C2P ACO"; $resn_exch{" PS1 ACO"}=" S1P ACO";
$resn_exch{" O5* ACP"}=" O5' ACP"; $resn_exch{" C5* ACP"}=" C5' ACP"; $resn_exch{" C4* ACP"}=" C4' ACP";
$resn_exch{" O4* ACP"}=" O4' ACP"; $resn_exch{" C3* ACP"}=" C3' ACP"; $resn_exch{" O3* ACP"}=" O3' ACP";
$resn_exch{" C2* ACP"}=" C2' ACP"; $resn_exch{" O2* ACP"}=" O2' ACP"; $resn_exch{" C1* ACP"}=" C1' ACP";
$resn_exch{" O5* ACQ"}=" O5' ACQ"; $resn_exch{" C5* ACQ"}=" C5' ACQ"; $resn_exch{" C4* ACQ"}=" C4' ACQ";
$resn_exch{" O4* ACQ"}=" O4' ACQ"; $resn_exch{" C3* ACQ"}=" C3' ACQ"; $resn_exch{" O3* ACQ"}=" O3' ACQ";
$resn_exch{" C2* ACQ"}=" C2' ACQ"; $resn_exch{" O2* ACQ"}=" O2' ACQ"; $resn_exch{" C1* ACQ"}=" C1' ACQ";
$resn_exch{" O1P AD2"}=" OP1 AD2"; $resn_exch{" O2P AD2"}=" OP2 AD2"; $resn_exch{" O3P AD2"}=" OP3 AD2";
$resn_exch{" O5* AD3"}=" O5' AD3"; $resn_exch{" C5* AD3"}=" C5' AD3"; $resn_exch{" C4* AD3"}=" C4' AD3";
$resn_exch{" O4* AD3"}=" O4' AD3"; $resn_exch{" C3* AD3"}=" C3' AD3"; $resn_exch{" O3* AD3"}=" O3' AD3";
$resn_exch{" C2* AD3"}=" C2' AD3"; $resn_exch{" O2* AD3"}=" O2' AD3"; $resn_exch{" C1* AD3"}=" C1' AD3";
$resn_exch{" O5* ADI"}=" O5' ADI"; $resn_exch{" C5* ADI"}=" C5' ADI"; $resn_exch{" C4* ADI"}=" C4' ADI";
$resn_exch{" O4* ADI"}=" O4' ADI"; $resn_exch{" C3* ADI"}=" C3' ADI"; $resn_exch{" C2* ADI"}=" C2' ADI";
$resn_exch{" C1* ADI"}=" C1' ADI"; $resn_exch{" O5* ADN"}=" O5' ADN"; $resn_exch{" C5* ADN"}=" C5' ADN";
$resn_exch{" C4* ADN"}=" C4' ADN"; $resn_exch{" O4* ADN"}=" O4' ADN"; $resn_exch{" C3* ADN"}=" C3' ADN";
$resn_exch{" O3* ADN"}=" O3' ADN"; $resn_exch{" C2* ADN"}=" C2' ADN"; $resn_exch{" O2* ADN"}=" O2' ADN";
$resn_exch{" C1* ADN"}=" C1' ADN"; $resn_exch{" O5* ADP"}=" O5' ADP"; $resn_exch{" C5* ADP"}=" C5' ADP";
$resn_exch{" C4* ADP"}=" C4' ADP"; $resn_exch{" O4* ADP"}=" O4' ADP"; $resn_exch{" C3* ADP"}=" C3' ADP";
$resn_exch{" O3* ADP"}=" O3' ADP"; $resn_exch{" C2* ADP"}=" C2' ADP"; $resn_exch{" O2* ADP"}=" O2' ADP";
$resn_exch{" C1* ADP"}=" C1' ADP"; $resn_exch{" O5* ADQ"}=" O5D ADQ"; $resn_exch{" C5* ADQ"}=" C5D ADQ";
$resn_exch{" C4* ADQ"}=" C4D ADQ"; $resn_exch{" O4* ADQ"}=" O4D ADQ"; $resn_exch{" C3* ADQ"}=" C3D ADQ";
$resn_exch{" O3* ADQ"}=" O3D ADQ"; $resn_exch{" C2* ADQ"}=" C2D ADQ"; $resn_exch{" O2* ADQ"}=" O2D ADQ";
$resn_exch{" C1* ADQ"}=" C1D ADQ"; $resn_exch{" O5* ADS"}=" O5' ADS"; $resn_exch{" C5* ADS"}=" C5' ADS";
$resn_exch{" C4* ADS"}=" C4' ADS"; $resn_exch{" O4* ADS"}=" O4' ADS"; $resn_exch{" C3* ADS"}=" C3' ADS";
$resn_exch{" O3* ADS"}=" O3' ADS"; $resn_exch{" C2* ADS"}=" C2' ADS"; $resn_exch{" O2* ADS"}=" O2' ADS";
$resn_exch{" C1* ADS"}=" C1' ADS"; $resn_exch{" C1* ADT"}=" C1' ADT"; $resn_exch{" O4* ADT"}=" O4' ADT";
$resn_exch{" C4* ADT"}=" C4' ADT"; $resn_exch{" C5* ADT"}=" C5' ADT"; $resn_exch{" O5* ADT"}=" O5' ADT";
$resn_exch{" C3* ADT"}=" C3' ADT"; $resn_exch{" N3* ADT"}=" N3' ADT"; $resn_exch{" C8* ADT"}=" C8' ADT";
$resn_exch{" O8* ADT"}=" O8' ADT"; $resn_exch{" C9* ADT"}=" C9' ADT"; $resn_exch{" C2* ADT"}=" C2' ADT";
$resn_exch{" C1* ADU"}=" C1' ADU"; $resn_exch{" O4* ADU"}=" O4' ADU"; $resn_exch{" C4* ADU"}=" C4' ADU";
$resn_exch{" C5* ADU"}=" C5' ADU"; $resn_exch{" O5* ADU"}=" O5' ADU"; $resn_exch{" C3* ADU"}=" C3' ADU";
$resn_exch{" N3* ADU"}=" N3' ADU"; $resn_exch{" C8* ADU"}=" C8' ADU"; $resn_exch{" O8* ADU"}=" O8' ADU";
$resn_exch{" C9* ADU"}=" C9' ADU"; $resn_exch{" C2* ADU"}=" C2' ADU"; $resn_exch{" O2* ADU"}=" O2' ADU";
$resn_exch{" O5* ADV"}=" O5' ADV"; $resn_exch{" C5* ADV"}=" C5' ADV"; $resn_exch{" C4* ADV"}=" C4' ADV";
$resn_exch{" O4* ADV"}=" O4' ADV"; $resn_exch{" C3* ADV"}=" C3' ADV"; $resn_exch{" O3* ADV"}=" O3' ADV";
$resn_exch{" C2* ADV"}=" C2' ADV"; $resn_exch{" O2* ADV"}=" O2' ADV"; $resn_exch{" C1* ADV"}=" C1' ADV";
$resn_exch{" O5* ADW"}=" O5' ADW"; $resn_exch{" C5* ADW"}=" C5' ADW"; $resn_exch{" C4* ADW"}=" C4' ADW";
$resn_exch{" O4* ADW"}=" O4' ADW"; $resn_exch{" C3* ADW"}=" C3' ADW"; $resn_exch{" O3* ADW"}=" O3' ADW";
$resn_exch{" C2* ADW"}=" C2' ADW"; $resn_exch{" O2* ADW"}=" O2' ADW"; $resn_exch{" C1* ADW"}=" C1' ADW";
$resn_exch{" O5* ADX"}=" O5' ADX"; $resn_exch{" C5* ADX"}=" C5' ADX"; $resn_exch{" C4* ADX"}=" C4' ADX";
$resn_exch{" O4* ADX"}=" O4' ADX"; $resn_exch{" C3* ADX"}=" C3' ADX"; $resn_exch{" O3* ADX"}=" O3' ADX";
$resn_exch{" C2* ADX"}=" C2' ADX"; $resn_exch{" O2* ADX"}=" O2' ADX"; $resn_exch{" C1* ADX"}=" C1' ADX";
$resn_exch{" O5* ADY"}=" O5' ADY"; $resn_exch{" C5* ADY"}=" C5' ADY"; $resn_exch{" C4* ADY"}=" C4' ADY";
$resn_exch{" O4* ADY"}=" O4' ADY"; $resn_exch{" C3* ADY"}=" C3' ADY"; $resn_exch{" O3* ADY"}=" O3' ADY";
$resn_exch{" C2* ADY"}=" C2' ADY"; $resn_exch{" O2* ADY"}=" O2' ADY"; $resn_exch{" C1* ADY"}=" C1' ADY";
$resn_exch{" C1* ADZ"}=" C1' ADZ"; $resn_exch{" O1P AET"}=" OP1 AET"; $resn_exch{" O2P AET"}=" OP2 AET";
$resn_exch{" O3P AET"}=" OP3 AET"; $resn_exch{" O5* AET"}=" O5' AET"; $resn_exch{" C5* AET"}=" C5' AET";
$resn_exch{" C4* AET"}=" C4' AET"; $resn_exch{" O4* AET"}=" O4' AET"; $resn_exch{" C3* AET"}=" C3' AET";
$resn_exch{" O3* AET"}=" O3' AET"; $resn_exch{" C2* AET"}=" C2' AET"; $resn_exch{" O2* AET"}=" O2' AET";
$resn_exch{" C1* AET"}=" C1' AET"; $resn_exch{"O13A AET"}=" ODA AET"; $resn_exch{"O13B AET"}=" ODB AET";
$resn_exch{" O3P AFG"}=" OP3 AFG"; $resn_exch{" O1P AFG"}=" OP1 AFG"; $resn_exch{" O2P AFG"}=" OP2 AFG";
$resn_exch{" O5* AFG"}=" O5' AFG"; $resn_exch{" C2* AFG"}=" C2' AFG"; $resn_exch{" C5* AFG"}=" C5' AFG";
$resn_exch{" C4* AFG"}=" C4' AFG"; $resn_exch{" O4* AFG"}=" O4' AFG"; $resn_exch{" C1* AFG"}=" C1' AFG";
$resn_exch{" C3* AFG"}=" C3' AFG"; $resn_exch{" O3* AFG"}=" O3' AFG"; $resn_exch{" C1* AFH"}=" C1D AFH";
$resn_exch{" C2* AFH"}=" C2D AFH"; $resn_exch{" O2* AFH"}=" O2' AFH"; $resn_exch{" C3* AFH"}=" C3D AFH";
$resn_exch{" C4* AFH"}=" C4D AFH"; $resn_exch{" O4* AFH"}=" O4D AFH"; $resn_exch{" O3* AFH"}=" O3D AFH";
$resn_exch{" C5* AFH"}=" C5D AFH"; $resn_exch{" O5* AFH"}=" O5D AFH"; $resn_exch{"1CD1 AGF"}=" CDB AGF";
$resn_exch{"2CD1 AGF"}=" CDL AGF"; $resn_exch{"1CE1 AGF"}=" CEB AGF"; $resn_exch{"2CE1 AGF"}=" CEL AGF";
$resn_exch{"1CD4 AGF"}=" CDE AGF"; $resn_exch{"2CD4 AGF"}=" CDO AGF"; $resn_exch{"1CE4 AGF"}=" CEE AGF";
$resn_exch{"2CE4 AGF"}=" CEO AGF"; $resn_exch{" O5* AGN"}=" O5' AGN"; $resn_exch{" C5* AGN"}=" C5B AGN";
$resn_exch{" C4* AGN"}=" C4B AGN"; $resn_exch{" O4* AGN"}=" O4' AGN"; $resn_exch{" C3* AGN"}=" C3B AGN";
$resn_exch{" O3* AGN"}=" O3' AGN"; $resn_exch{" C2* AGN"}=" C2B AGN"; $resn_exch{" C1* AGN"}=" C1B AGN";
$resn_exch{" O5* AGS"}=" O5' AGS"; $resn_exch{" C5* AGS"}=" C5' AGS"; $resn_exch{" C4* AGS"}=" C4' AGS";
$resn_exch{" O4* AGS"}=" O4' AGS"; $resn_exch{" C3* AGS"}=" C3' AGS"; $resn_exch{" O3* AGS"}=" O3' AGS";
$resn_exch{" C2* AGS"}=" C2' AGS"; $resn_exch{" O2* AGS"}=" O2' AGS"; $resn_exch{" C1* AGS"}=" C1' AGS";
$resn_exch{" O5* AHR"}=" O5' AHR"; $resn_exch{" C5* AHR"}=" C5' AHR"; $resn_exch{" C4* AHR"}=" C4' AHR";
$resn_exch{" O4* AHR"}=" O4' AHR"; $resn_exch{" C3* AHR"}=" C3' AHR"; $resn_exch{" O3* AHR"}=" O3' AHR";
$resn_exch{" C2* AHR"}=" C2' AHR"; $resn_exch{" O2* AHR"}=" O2' AHR"; $resn_exch{" C1* AHR"}=" C1' AHR";
$resn_exch{" O1* AHR"}=" O1' AHR"; $resn_exch{" C4* AHU"}=" C4' AHU"; $resn_exch{" C7* AHU"}=" C7' AHU";
$resn_exch{" O7* AHU"}=" O7' AHU"; $resn_exch{" O5* AHU"}=" O5' AHU"; $resn_exch{" C6* AHU"}=" C6' AHU";
$resn_exch{" C1* AHU"}=" C1' AHU"; $resn_exch{" C2* AHU"}=" C2' AHU"; $resn_exch{" C3* AHU"}=" C3' AHU";
$resn_exch{" O3* AHU"}=" O3' AHU"; $resn_exch{" O5* AHX"}=" O5' AHX"; $resn_exch{" C5* AHX"}=" C5' AHX";
$resn_exch{" C4* AHX"}=" C4' AHX"; $resn_exch{" O4* AHX"}=" O4' AHX"; $resn_exch{" C3* AHX"}=" C3' AHX";
$resn_exch{" O3* AHX"}=" O3' AHX"; $resn_exch{" C2* AHX"}=" C2' AHX"; $resn_exch{" O2* AHX"}=" O2' AHX";
$resn_exch{" C1* AHX"}=" C1' AHX"; $resn_exch{" O2* AHZ"}=" O2' AHZ"; $resn_exch{" C2* AHZ"}=" C2' AHZ";
$resn_exch{" C3* AHZ"}=" C3' AHZ"; $resn_exch{" O3* AHZ"}=" O3' AHZ"; $resn_exch{" C1* AHZ"}=" C1' AHZ";
$resn_exch{" O4* AHZ"}=" O4' AHZ"; $resn_exch{" C4* AHZ"}=" C4' AHZ"; $resn_exch{" C5* AHZ"}=" C5' AHZ";
$resn_exch{" O5* AHZ"}=" O5' AHZ"; $resn_exch{" C1* AI1"}=" C1B AI1"; $resn_exch{" C2* AI1"}=" C2B AI1";
$resn_exch{" C3* AI1"}=" C3B AI1"; $resn_exch{" C4* AI1"}=" C4B AI1"; $resn_exch{" C5* AI1"}=" C5B AI1";
$resn_exch{" C6* AI1"}=" C6B AI1"; $resn_exch{" C7* AI1"}=" C7B AI1"; $resn_exch{" O1  AIB"}=" O   AIB";
$resn_exch{" O2  AIB"}=" OXT AIB"; $resn_exch{" O2* AIS"}=" O2' AIS"; $resn_exch{" C2* AIS"}=" C2' AIS";
$resn_exch{" C3* AIS"}=" C3' AIS"; $resn_exch{" O3* AIS"}=" O3' AIS"; $resn_exch{" C4* AIS"}=" C4' AIS";
$resn_exch{" C5* AIS"}=" C5' AIS"; $resn_exch{" O5* AIS"}=" O5' AIS"; $resn_exch{" O4* AIS"}=" O4' AIS";
$resn_exch{" C1* AIS"}=" C1' AIS"; $resn_exch{"8CL2 AIZ"}="CL28 AIZ"; $resn_exch{" O4* AKA"}=" O4' AKA";
$resn_exch{" C4* AKA"}=" C4' AKA"; $resn_exch{" C5* AKA"}=" C5' AKA"; $resn_exch{" C6* AKA"}=" C6' AKA";
$resn_exch{" O5* AKA"}=" O5' AKA"; $resn_exch{" C3* AKA"}=" C3' AKA"; $resn_exch{" N3* AKA"}=" N3' AKA";
$resn_exch{" C8* AKA"}=" C8' AKA"; $resn_exch{" C7* AKA"}=" C7' AKA"; $resn_exch{" C2* AKA"}=" C2' AKA";
$resn_exch{" C1* AKA"}=" C1' AKA"; $resn_exch{" C1* AKT"}=" C1' AKT"; $resn_exch{" C2* AKT"}=" C2' AKT";
$resn_exch{" C3* AKT"}=" C3' AKT"; $resn_exch{" N3* AKT"}=" N3' AKT"; $resn_exch{" C8* AKT"}=" C8' AKT";
$resn_exch{" C7* AKT"}=" C7' AKT"; $resn_exch{" C4* AKT"}=" C4' AKT"; $resn_exch{" O4* AKT"}=" O4' AKT";
$resn_exch{" C5* AKT"}=" C5' AKT"; $resn_exch{" O5* AKT"}=" O5' AKT"; $resn_exch{" C6* AKT"}=" C6' AKT";
$resn_exch{" C1* ALL"}=" C1' ALL"; $resn_exch{" C2* ALL"}=" C2' ALL"; $resn_exch{" C3* ALL"}=" C3' ALL";
$resn_exch{" C4* ALL"}=" C4' ALL"; $resn_exch{" C5* ALL"}=" C5' ALL"; $resn_exch{" C6* ALL"}=" C6' ALL";
$resn_exch{" O1* ALL"}=" O1' ALL"; $resn_exch{" O2* ALL"}=" O2' ALL"; $resn_exch{" O3* ALL"}=" O3' ALL";
$resn_exch{" O4* ALL"}=" O4' ALL"; $resn_exch{" O5* ALL"}=" O5' ALL"; $resn_exch{" O6* ALL"}=" O6' ALL";
$resn_exch{"3C11 ALW"}=" CX5 ALW"; $resn_exch{" O5* AMD"}=" O5' AMD"; $resn_exch{" C5* AMD"}=" C5' AMD";
$resn_exch{" C4* AMD"}=" C4' AMD"; $resn_exch{" O4* AMD"}=" O4' AMD"; $resn_exch{" C1* AMD"}=" C1' AMD";
$resn_exch{" C2* AMD"}=" C2' AMD"; $resn_exch{" C3* AMD"}=" C3' AMD"; $resn_exch{" O3* AMD"}=" O3' AMD";
$resn_exch{" O5* AMO"}=" O5' AMO"; $resn_exch{" C5* AMO"}=" C5' AMO"; $resn_exch{" C4* AMO"}=" C4' AMO";
$resn_exch{" O4* AMO"}=" O4' AMO"; $resn_exch{" C1* AMO"}=" C1' AMO"; $resn_exch{" C2* AMO"}=" C2' AMO";
$resn_exch{" C3* AMO"}=" C3' AMO"; $resn_exch{" O3* AMO"}=" O3' AMO"; $resn_exch{" O2* AMO"}=" O2' AMO";
$resn_exch{" O5* AMP"}=" O5' AMP"; $resn_exch{" C5* AMP"}=" C5' AMP"; $resn_exch{" C4* AMP"}=" C4' AMP";
$resn_exch{" O4* AMP"}=" O4' AMP"; $resn_exch{" C3* AMP"}=" C3' AMP"; $resn_exch{" O3* AMP"}=" O3' AMP";
$resn_exch{" C2* AMP"}=" C2' AMP"; $resn_exch{" O2* AMP"}=" O2' AMP"; $resn_exch{" C1* AMP"}=" C1' AMP";
$resn_exch{" O5* AMW"}=" O5' AMW"; $resn_exch{" C5* AMW"}=" C5' AMW"; $resn_exch{" C4* AMW"}=" C4' AMW";
$resn_exch{" O4* AMW"}=" O4' AMW"; $resn_exch{" C3* AMW"}=" C3' AMW"; $resn_exch{" O3* AMW"}=" O3' AMW";
$resn_exch{" C2* AMW"}=" C2' AMW"; $resn_exch{" O2* AMW"}=" O2' AMW"; $resn_exch{" C1* AMW"}=" C1' AMW";
$resn_exch{" AN1 AMX"}=" N1A AMX"; $resn_exch{" AC2 AMX"}=" C2A AMX"; $resn_exch{" AN3 AMX"}=" N3A AMX";
$resn_exch{" AC4 AMX"}=" C4A AMX"; $resn_exch{" AC5 AMX"}=" C5A AMX"; $resn_exch{" AC6 AMX"}=" C6A AMX";
$resn_exch{" AN6 AMX"}=" N6A AMX"; $resn_exch{" AN7 AMX"}=" N7A AMX"; $resn_exch{" AC8 AMX"}=" C8A AMX";
$resn_exch{" AN9 AMX"}=" N9A AMX"; $resn_exch{"AC1* AMX"}=" C1B AMX"; $resn_exch{"AC2* AMX"}=" C2B AMX";
$resn_exch{"AO2* AMX"}=" O2B AMX"; $resn_exch{"AC3* AMX"}=" C3B AMX"; $resn_exch{"AO3* AMX"}=" O3B AMX";
$resn_exch{"AP3* AMX"}=" P3B AMX"; $resn_exch{" AO7 AMX"}=" O7A AMX"; $resn_exch{" AO8 AMX"}=" O8A AMX";
$resn_exch{" AO9 AMX"}=" O9A AMX"; $resn_exch{"AC4* AMX"}=" C4B AMX"; $resn_exch{"AO4* AMX"}=" O4B AMX";
$resn_exch{"AC5* AMX"}=" C5B AMX"; $resn_exch{"AO5* AMX"}=" O5B AMX"; $resn_exch{" AP1 AMX"}=" P1A AMX";
$resn_exch{" AO1 AMX"}=" O1A AMX"; $resn_exch{" AO2 AMX"}=" O2A AMX"; $resn_exch{" AO3 AMX"}=" O3A AMX";
$resn_exch{" AP2 AMX"}=" P2A AMX"; $resn_exch{" AO4 AMX"}=" O4A AMX"; $resn_exch{" AO5 AMX"}=" O5A AMX";
$resn_exch{" AO6 AMX"}=" O6A AMX"; $resn_exch{"PC11 AMX"}=" CBP AMX"; $resn_exch{"PC12 AMX"}=" CCP AMX";
$resn_exch{"PC13 AMX"}=" CDP AMX"; $resn_exch{"PC14 AMX"}=" CEP AMX"; $resn_exch{"PC10 AMX"}=" CAP AMX";
$resn_exch{"PO10 AMX"}=" OAP AMX"; $resn_exch{" PC9 AMX"}=" C9P AMX"; $resn_exch{" PO9 AMX"}=" O9P AMX";
$resn_exch{" PN8 AMX"}=" N8P AMX"; $resn_exch{" PC7 AMX"}=" C7P AMX"; $resn_exch{" PC6 AMX"}=" C6P AMX";
$resn_exch{" PC5 AMX"}=" C5P AMX"; $resn_exch{" PO5 AMX"}=" O5P AMX"; $resn_exch{" PN4 AMX"}=" N4P AMX";
$resn_exch{" PC3 AMX"}=" C3P AMX"; $resn_exch{" PC2 AMX"}=" C2P AMX"; $resn_exch{" O5* AN2"}=" O5' AN2";
$resn_exch{" C5* AN2"}=" C5' AN2"; $resn_exch{" C4* AN2"}=" C4' AN2"; $resn_exch{" O4* AN2"}=" O4' AN2";
$resn_exch{" C3* AN2"}=" C3' AN2"; $resn_exch{" O3* AN2"}=" O3' AN2"; $resn_exch{" C2* AN2"}=" C2' AN2";
$resn_exch{" O2* AN2"}=" O2' AN2"; $resn_exch{" C1* AN2"}=" C1' AN2"; $resn_exch{" O5* ANP"}=" O5' ANP";
$resn_exch{" C5* ANP"}=" C5' ANP"; $resn_exch{" C4* ANP"}=" C4' ANP"; $resn_exch{" O4* ANP"}=" O4' ANP";
$resn_exch{" C3* ANP"}=" C3' ANP"; $resn_exch{" O3* ANP"}=" O3' ANP"; $resn_exch{" C2* ANP"}=" C2' ANP";
$resn_exch{" O2* ANP"}=" O2' ANP"; $resn_exch{" C1* ANP"}=" C1' ANP"; $resn_exch{" O3* ANU"}=" O3' ANU";
$resn_exch{" C3* ANU"}=" C3' ANU"; $resn_exch{" C2* ANU"}=" C2' ANU"; $resn_exch{" C1* ANU"}=" C1' ANU";
$resn_exch{" O4* ANU"}=" O4' ANU"; $resn_exch{" C4* ANU"}=" C4' ANU"; $resn_exch{" C5* ANU"}=" C5' ANU";
$resn_exch{" O5* ANU"}=" O5' ANU"; $resn_exch{" O5* ANZ"}=" O5' ANZ"; $resn_exch{" C5* ANZ"}=" C5' ANZ";
$resn_exch{" C4* ANZ"}=" C4' ANZ"; $resn_exch{" O4* ANZ"}=" O4' ANZ"; $resn_exch{" C3* ANZ"}=" C3' ANZ";
$resn_exch{" O3* ANZ"}=" O3' ANZ"; $resn_exch{" C2* ANZ"}=" C2' ANZ"; $resn_exch{" O2* ANZ"}=" O2' ANZ";
$resn_exch{" C1* ANZ"}=" C1' ANZ"; $resn_exch{" NO7 AP0"}=" O7N AP0"; $resn_exch{" NC7 AP0"}=" C7N AP0";
$resn_exch{" NC8 AP0"}=" C8N AP0"; $resn_exch{" NC3 AP0"}=" C3N AP0"; $resn_exch{" NC4 AP0"}=" C4N AP0";
$resn_exch{" NC5 AP0"}=" C5N AP0"; $resn_exch{" NC6 AP0"}=" C6N AP0"; $resn_exch{" NC2 AP0"}=" C2N AP0";
$resn_exch{" NN1 AP0"}=" N1N AP0"; $resn_exch{"NC1* AP0"}=" C1D AP0"; $resn_exch{"NC2* AP0"}=" C2D AP0";
$resn_exch{"NO2* AP0"}=" O2D AP0"; $resn_exch{"NC3* AP0"}=" C3D AP0"; $resn_exch{"NO3* AP0"}=" O3D AP0";
$resn_exch{"NO4* AP0"}=" O4D AP0"; $resn_exch{"NC4* AP0"}=" C4D AP0"; $resn_exch{"NC5* AP0"}=" C5D AP0";
$resn_exch{"NO5* AP0"}=" O5D AP0"; $resn_exch{" NP  AP0"}=" PN  AP0"; $resn_exch{" NO1 AP0"}=" O1N AP0";
$resn_exch{" NO2 AP0"}=" O2N AP0"; $resn_exch{" AP  AP0"}=" PA  AP0"; $resn_exch{" AO1 AP0"}=" O1A AP0";
$resn_exch{" AO2 AP0"}=" O2A AP0"; $resn_exch{"AO5* AP0"}=" O5B AP0"; $resn_exch{"AC5* AP0"}=" C5B AP0";
$resn_exch{"AC4* AP0"}=" C4B AP0"; $resn_exch{"AO4* AP0"}=" O4B AP0"; $resn_exch{"AC1* AP0"}=" C1B AP0";
$resn_exch{"AC2* AP0"}=" C2B AP0"; $resn_exch{"AO2* AP0"}=" O2B AP0"; $resn_exch{"AC3* AP0"}=" C3B AP0";
$resn_exch{"AO3* AP0"}=" O3B AP0"; $resn_exch{" AN9 AP0"}=" N9A AP0"; $resn_exch{" AC8 AP0"}=" C8A AP0";
$resn_exch{" AN7 AP0"}=" N7A AP0"; $resn_exch{" AC5 AP0"}=" C5A AP0"; $resn_exch{" AC6 AP0"}=" C6A AP0";
$resn_exch{" AN6 AP0"}=" N6A AP0"; $resn_exch{" AC4 AP0"}=" C4A AP0"; $resn_exch{" AN3 AP0"}=" N3A AP0";
$resn_exch{" AC2 AP0"}=" C2A AP0"; $resn_exch{" AN1 AP0"}=" N1A AP0"; $resn_exch{" O5* AP2"}=" O5' AP2";
$resn_exch{" C5* AP2"}=" C5' AP2"; $resn_exch{" C4* AP2"}=" C4' AP2"; $resn_exch{" O4* AP2"}=" O4' AP2";
$resn_exch{" C3* AP2"}=" C3' AP2"; $resn_exch{" O3* AP2"}=" O3' AP2"; $resn_exch{" C2* AP2"}=" C2' AP2";
$resn_exch{" O2* AP2"}=" O2' AP2"; $resn_exch{" C1* AP2"}=" C1' AP2"; $resn_exch{"AO5* AP5"}=" O5F AP5";
$resn_exch{"AC5* AP5"}=" C5F AP5"; $resn_exch{"AC4* AP5"}=" C4F AP5"; $resn_exch{"AO4* AP5"}=" O4F AP5";
$resn_exch{"AC3* AP5"}=" C3F AP5"; $resn_exch{"AO3* AP5"}=" O3F AP5"; $resn_exch{"AC2* AP5"}=" C2F AP5";
$resn_exch{"AO2* AP5"}=" O2F AP5"; $resn_exch{"AC1* AP5"}=" C1F AP5"; $resn_exch{" AN9 AP5"}=" N9A AP5";
$resn_exch{" AC8 AP5"}=" C8A AP5"; $resn_exch{" AN7 AP5"}=" N7A AP5"; $resn_exch{" AC5 AP5"}=" C5A AP5";
$resn_exch{" AC6 AP5"}=" C6A AP5"; $resn_exch{" AN6 AP5"}=" N6A AP5"; $resn_exch{" AN1 AP5"}=" N1A AP5";
$resn_exch{" AC2 AP5"}=" C2A AP5"; $resn_exch{" AN3 AP5"}=" N3A AP5"; $resn_exch{" AC4 AP5"}=" C4A AP5";
$resn_exch{"BO5* AP5"}=" O5J AP5"; $resn_exch{"BC5* AP5"}=" C5J AP5"; $resn_exch{"BC4* AP5"}=" C4J AP5";
$resn_exch{"BO4* AP5"}=" O4J AP5"; $resn_exch{"BC3* AP5"}=" C3J AP5"; $resn_exch{"BO3* AP5"}=" O3J AP5";
$resn_exch{"BC2* AP5"}=" C2J AP5"; $resn_exch{"BO2* AP5"}=" O2J AP5"; $resn_exch{"BC1* AP5"}=" C1J AP5";
$resn_exch{" BN9 AP5"}=" N9B AP5"; $resn_exch{" BC8 AP5"}=" C8B AP5"; $resn_exch{" BN7 AP5"}=" N7B AP5";
$resn_exch{" BC5 AP5"}=" C5B AP5"; $resn_exch{" BC6 AP5"}=" C6B AP5"; $resn_exch{" BN6 AP5"}=" N6B AP5";
$resn_exch{" BN1 AP5"}=" N1B AP5"; $resn_exch{" BC2 AP5"}=" C2B AP5"; $resn_exch{" BN3 AP5"}=" N3B AP5";
$resn_exch{" BC4 AP5"}=" C4B AP5"; $resn_exch{" C1* AP7"}=" C1' AP7"; $resn_exch{" C2* AP7"}=" C2' AP7";
$resn_exch{" O2* AP7"}=" O2' AP7"; $resn_exch{" C3* AP7"}=" C3' AP7"; $resn_exch{" O3* AP7"}=" O3' AP7";
$resn_exch{" C4* AP7"}=" C4' AP7"; $resn_exch{" O4* AP7"}=" O4' AP7"; $resn_exch{" C5* AP7"}=" C5' AP7";
$resn_exch{" O5* AP7"}=" O5' AP7"; $resn_exch{" O1P AP7"}=" OP1 AP7"; $resn_exch{" O2P AP7"}=" OP2 AP7";
$resn_exch{" O3P AP7"}=" OP3 AP7"; $resn_exch{" O5* APC"}=" O5' APC"; $resn_exch{" C5* APC"}=" C5' APC";
$resn_exch{" C4* APC"}=" C4' APC"; $resn_exch{" O4* APC"}=" O4' APC"; $resn_exch{" C3* APC"}=" C3' APC";
$resn_exch{" O3* APC"}=" O3' APC"; $resn_exch{" C2* APC"}=" C2' APC"; $resn_exch{" O2* APC"}=" O2' APC";
$resn_exch{" C1* APC"}=" C1' APC"; $resn_exch{" O5* APK"}=" O5' APK"; $resn_exch{" C5* APK"}=" C5' APK";
$resn_exch{" C4* APK"}=" C4' APK"; $resn_exch{" O4* APK"}=" O4' APK"; $resn_exch{" C3* APK"}=" C3' APK";
$resn_exch{" O3* APK"}=" O3' APK"; $resn_exch{" C2* APK"}=" C2' APK"; $resn_exch{" O2* APK"}=" O2' APK";
$resn_exch{" C1* APK"}=" C1' APK"; $resn_exch{" C1* APR"}=" C1' APR"; $resn_exch{" C2* APR"}=" C2' APR";
$resn_exch{" O2* APR"}=" O2' APR"; $resn_exch{" C3* APR"}=" C3' APR"; $resn_exch{" O3* APR"}=" O3' APR";
$resn_exch{" O4* APR"}=" O4' APR"; $resn_exch{" C4* APR"}=" C4' APR"; $resn_exch{" C5* APR"}=" C5' APR";
$resn_exch{" O5* APR"}=" O5' APR"; $resn_exch{"RO5* APR"}=" O5D APR"; $resn_exch{"RC5* APR"}=" C5D APR";
$resn_exch{"RO4* APR"}=" O4D APR"; $resn_exch{"RO1* APR"}=" O1D APR"; $resn_exch{"RC1* APR"}=" C1D APR";
$resn_exch{"RO2* APR"}=" O2D APR"; $resn_exch{"RC2* APR"}=" C2D APR"; $resn_exch{"RO3* APR"}=" O3D APR";
$resn_exch{"RC3* APR"}=" C3D APR"; $resn_exch{"RC4* APR"}=" C4D APR"; $resn_exch{" AP  APU"}=" PA  APU";
$resn_exch{" AO1 APU"}=" O1A APU"; $resn_exch{" AO2 APU"}=" O2A APU"; $resn_exch{"AO5* APU"}=" O5B APU";
$resn_exch{"AC5* APU"}=" C5B APU"; $resn_exch{"AC4* APU"}=" C4B APU"; $resn_exch{"AO4* APU"}=" O4B APU";
$resn_exch{"AC3* APU"}=" C3B APU"; $resn_exch{"AO3* APU"}=" O3B APU"; $resn_exch{"AC2* APU"}=" C2B APU";
$resn_exch{"AO2* APU"}=" O2B APU"; $resn_exch{"AC1* APU"}=" C1B APU"; $resn_exch{" AN9 APU"}=" N9A APU";
$resn_exch{" AC8 APU"}=" C8A APU"; $resn_exch{" AN7 APU"}=" N7A APU"; $resn_exch{" AC5 APU"}=" C5A APU";
$resn_exch{" AC6 APU"}=" C6A APU"; $resn_exch{" AN6 APU"}=" N6A APU"; $resn_exch{" AN1 APU"}=" N1A APU";
$resn_exch{" AC2 APU"}=" C2A APU"; $resn_exch{" AN3 APU"}=" N3A APU"; $resn_exch{" AC4 APU"}=" C4A APU";
$resn_exch{" UN1 APU"}=" N1U APU"; $resn_exch{" UC2 APU"}=" C2U APU"; $resn_exch{" UO2 APU"}=" O2U APU";
$resn_exch{" UN3 APU"}=" N3U APU"; $resn_exch{" UC4 APU"}=" C4U APU"; $resn_exch{" UO4 APU"}=" O4U APU";
$resn_exch{" UC5 APU"}=" C5U APU"; $resn_exch{" UC6 APU"}=" C6U APU"; $resn_exch{"UC1* APU"}=" C1D APU";
$resn_exch{"UC2* APU"}=" C2D APU"; $resn_exch{"UO2* APU"}=" O2D APU"; $resn_exch{"UC3* APU"}=" C3D APU";
$resn_exch{"UO3* APU"}=" O3D APU"; $resn_exch{"UC4* APU"}=" C4D APU"; $resn_exch{"UO4* APU"}=" O4D APU";
$resn_exch{"UO5* APU"}=" O5D APU"; $resn_exch{"UC5* APU"}=" C5D APU"; $resn_exch{" UP  APU"}=" PU  APU";
$resn_exch{"UO1P APU"}=" O1X APU"; $resn_exch{"UO2P APU"}=" O2X APU"; $resn_exch{"UO3P APU"}=" O3X APU";
$resn_exch{" O5* APW"}=" O5' APW"; $resn_exch{" C5* APW"}=" C5' APW"; $resn_exch{" C4* APW"}=" C4' APW";
$resn_exch{" C3* APW"}=" C3' APW"; $resn_exch{" O3* APW"}=" O3' APW"; $resn_exch{" C2* APW"}=" C2' APW";
$resn_exch{" O2* APW"}=" O2' APW"; $resn_exch{" C1* APW"}=" C1' APW"; $resn_exch{" O4* APW"}=" O4' APW";
$resn_exch{" C1* AQP"}=" C1' AQP"; $resn_exch{" O4* AQP"}=" O4' AQP"; $resn_exch{" C4* AQP"}=" C4' AQP";
$resn_exch{" C5* AQP"}=" C5' AQP"; $resn_exch{" O5* AQP"}=" O5' AQP"; $resn_exch{" C3* AQP"}=" C3' AQP";
$resn_exch{" O3* AQP"}=" O3' AQP"; $resn_exch{" C2* AQP"}=" C2' AQP"; $resn_exch{" O2* AQP"}=" O2' AQP";
$resn_exch{" O   AR4"}=" OXT AR4"; $resn_exch{" O5* AR4"}=" O5' AR4"; $resn_exch{" C5* AR4"}=" C5' AR4";
$resn_exch{" C4* AR4"}=" C4' AR4"; $resn_exch{" O4* AR4"}=" O4' AR4"; $resn_exch{" C1* AR4"}=" C1' AR4";
$resn_exch{" C2* AR4"}=" C2' AR4"; $resn_exch{" F2* AR4"}=" F2' AR4"; $resn_exch{" C3* AR4"}=" C3' AR4";
$resn_exch{" O3* AR4"}=" O3' AR4"; $resn_exch{" O1  AR4"}=" O   AR4"; $resn_exch{" O2* AR4"}=" O2' AR4";
$resn_exch{" O1P  AS"}=" OP1  AS"; $resn_exch{" O3P  AS"}=" OP3  AS"; $resn_exch{" O5*  AS"}=" O5'  AS";
$resn_exch{" C5*  AS"}=" C5'  AS"; $resn_exch{" C4*  AS"}=" C4'  AS"; $resn_exch{" O4*  AS"}=" O4'  AS";
$resn_exch{" C3*  AS"}=" C3'  AS"; $resn_exch{" O3*  AS"}=" O3'  AS"; $resn_exch{" C2*  AS"}=" C2'  AS";
$resn_exch{" C1*  AS"}=" C1'  AS"; $resn_exch{" O1P ASU"}=" OP1 ASU"; $resn_exch{" O2P ASU"}=" OP2 ASU";
$resn_exch{" O3P ASU"}=" OP3 ASU"; $resn_exch{" O5* ASU"}=" O5' ASU"; $resn_exch{" S4* ASU"}=" S4' ASU";
$resn_exch{" O1* ASU"}=" O1' ASU"; $resn_exch{" C2* ASU"}=" C2' ASU"; $resn_exch{" C5* ASU"}=" C5' ASU";
$resn_exch{" C4* ASU"}=" C4' ASU"; $resn_exch{" C1* ASU"}=" C1' ASU"; $resn_exch{" C3* ASU"}=" C3' ASU";
$resn_exch{" O3* ASU"}=" O3' ASU"; $resn_exch{" AD1 ASX"}=" XD1 ASX"; $resn_exch{" AD2 ASX"}=" XD2 ASX";
$resn_exch{" O5* AT4"}=" O5' AT4"; $resn_exch{" C5* AT4"}=" C5' AT4"; $resn_exch{" C4* AT4"}=" C4' AT4";
$resn_exch{" O4* AT4"}=" O4' AT4"; $resn_exch{" C3* AT4"}=" C3' AT4"; $resn_exch{" O3* AT4"}=" O3' AT4";
$resn_exch{" C2* AT4"}=" C2' AT4"; $resn_exch{" C1* AT4"}=" C1' AT4"; $resn_exch{" O2* AT4"}=" O2' AT4";
$resn_exch{" N\"  ATA"}=" ND  ATA"; $resn_exch{" CA\" ATA"}=" CAD ATA"; $resn_exch{" C\"  ATA"}=" CD  ATA";
$resn_exch{" O\"  ATA"}=" OD  ATA"; $resn_exch{" OT\" ATA"}=" OT' ATA"; $resn_exch{" O1P ATD"}=" OP1 ATD";
$resn_exch{" O2P ATD"}=" OP2 ATD"; $resn_exch{" O3P ATD"}=" OP3 ATD"; $resn_exch{" O5* ATD"}=" O5' ATD";
$resn_exch{" C5* ATD"}=" C5' ATD"; $resn_exch{" C4* ATD"}=" C4' ATD"; $resn_exch{" O4* ATD"}=" O4' ATD";
$resn_exch{" C3* ATD"}=" C3' ATD"; $resn_exch{" O3* ATD"}=" O3' ATD"; $resn_exch{" C2* ATD"}=" C2' ATD";
$resn_exch{" C1* ATD"}=" C1' ATD"; $resn_exch{" O5* ATF"}=" O5' ATF"; $resn_exch{" C5* ATF"}=" C5' ATF";
$resn_exch{" C4* ATF"}=" C4' ATF"; $resn_exch{" O4* ATF"}=" O4' ATF"; $resn_exch{" C3* ATF"}=" C3' ATF";
$resn_exch{" O3* ATF"}=" O3' ATF"; $resn_exch{" C2* ATF"}=" C2' ATF"; $resn_exch{" O2* ATF"}=" O2' ATF";
$resn_exch{" C1* ATF"}=" C1' ATF"; $resn_exch{" O5* ATG"}=" O5' ATG"; $resn_exch{" C5* ATG"}=" C5' ATG";
$resn_exch{" C4* ATG"}=" C4' ATG"; $resn_exch{" O4* ATG"}=" O4' ATG"; $resn_exch{" C3* ATG"}=" C3' ATG";
$resn_exch{" O3* ATG"}=" O3' ATG"; $resn_exch{" C2* ATG"}=" C2' ATG"; $resn_exch{" O2* ATG"}=" O2' ATG";
$resn_exch{" C1* ATG"}=" C1' ATG"; $resn_exch{" O1P ATL"}=" OP1 ATL"; $resn_exch{" O2P ATL"}=" OP2 ATL";
$resn_exch{" O5* ATL"}=" O5' ATL"; $resn_exch{" C5* ATL"}=" C5' ATL"; $resn_exch{" C4* ATL"}=" C4' ATL";
$resn_exch{" O4* ATL"}=" O4' ATL"; $resn_exch{" C3* ATL"}=" C3' ATL"; $resn_exch{" O3* ATL"}=" O3' ATL";
$resn_exch{" C2* ATL"}=" C2' ATL"; $resn_exch{" O2* ATL"}=" O2' ATL"; $resn_exch{" C1* ATL"}=" C1' ATL";
$resn_exch{" C6* ATL"}=" C6' ATL"; $resn_exch{" O1P ATM"}=" OP1 ATM"; $resn_exch{" O2P ATM"}=" OP2 ATM";
$resn_exch{" O3P ATM"}=" OP3 ATM"; $resn_exch{" O5* ATM"}=" O5' ATM"; $resn_exch{" C5* ATM"}=" C5' ATM";
$resn_exch{" C4* ATM"}=" C4' ATM"; $resn_exch{" O4* ATM"}=" O4' ATM"; $resn_exch{" C3* ATM"}=" C3' ATM";
$resn_exch{" N3* ATM"}=" N3' ATM"; $resn_exch{" N4* ATM"}=" N4' ATM"; $resn_exch{" N5* ATM"}=" N5' ATM";
$resn_exch{" C2* ATM"}=" C2' ATM"; $resn_exch{" C1* ATM"}=" C1' ATM"; $resn_exch{" O5* ATP"}=" O5' ATP";
$resn_exch{" C5* ATP"}=" C5' ATP"; $resn_exch{" C4* ATP"}=" C4' ATP"; $resn_exch{" O4* ATP"}=" O4' ATP";
$resn_exch{" C3* ATP"}=" C3' ATP"; $resn_exch{" O3* ATP"}=" O3' ATP"; $resn_exch{" C2* ATP"}=" C2' ATP";
$resn_exch{" O2* ATP"}=" O2' ATP"; $resn_exch{" C1* ATP"}=" C1' ATP"; $resn_exch{" O5* ATR"}=" O5' ATR";
$resn_exch{" C5* ATR"}=" C5' ATR"; $resn_exch{" C4* ATR"}=" C4' ATR"; $resn_exch{" O4* ATR"}=" O4' ATR";
$resn_exch{" C3* ATR"}=" C3' ATR"; $resn_exch{" O3* ATR"}=" O3' ATR"; $resn_exch{" C2* ATR"}=" C2' ATR";
$resn_exch{" O2* ATR"}=" O2' ATR"; $resn_exch{" P2* ATR"}=" P2' ATR"; $resn_exch{" C1* ATR"}=" C1' ATR";
$resn_exch{" O5* ATY"}=" O5' ATY"; $resn_exch{" C5* ATY"}=" C5' ATY"; $resn_exch{" C4* ATY"}=" C4' ATY";
$resn_exch{" O4* ATY"}=" O4' ATY"; $resn_exch{" C3* ATY"}=" C3' ATY"; $resn_exch{" O3* ATY"}=" O3' ATY";
$resn_exch{" C2* ATY"}=" C2' ATY"; $resn_exch{" C1* ATY"}=" C1' ATY"; $resn_exch{" O5* AV2"}=" O5' AV2";
$resn_exch{" C5* AV2"}=" C5' AV2"; $resn_exch{" C4* AV2"}=" C4' AV2"; $resn_exch{" O4* AV2"}=" O4' AV2";
$resn_exch{" C3* AV2"}=" C3' AV2"; $resn_exch{" O3* AV2"}=" O3' AV2"; $resn_exch{" C2* AV2"}=" C2' AV2";
$resn_exch{" O2* AV2"}=" O2' AV2"; $resn_exch{" C1* AV2"}=" C1' AV2"; $resn_exch{" O3P AVC"}=" OP3 AVC";
$resn_exch{" O1P AVC"}=" OP1 AVC"; $resn_exch{" O2P AVC"}=" OP2 AVC"; $resn_exch{" O5* AVC"}=" O5' AVC";
$resn_exch{" C5* AVC"}=" C5' AVC"; $resn_exch{" C4* AVC"}=" C4' AVC"; $resn_exch{" O4* AVC"}=" O4' AVC";
$resn_exch{" C3* AVC"}=" C3' AVC"; $resn_exch{" O3* AVC"}=" O3' AVC"; $resn_exch{" C2* AVC"}=" C2' AVC";
$resn_exch{" O2* AVC"}=" O2' AVC"; $resn_exch{" C1* AVC"}=" C1' AVC"; $resn_exch{" O5* AZD"}=" O5' AZD";
$resn_exch{" C5* AZD"}=" C5' AZD"; $resn_exch{" C4* AZD"}=" C4' AZD"; $resn_exch{" O4* AZD"}=" O4' AZD";
$resn_exch{" C3* AZD"}=" C3' AZD"; $resn_exch{" N3* AZD"}=" N3' AZD"; $resn_exch{" N4* AZD"}=" N4' AZD";
$resn_exch{" N5* AZD"}=" N5' AZD"; $resn_exch{" C2* AZD"}=" C2' AZD"; $resn_exch{" C1* AZD"}=" C1' AZD";
$resn_exch{" O5* AZT"}=" O5' AZT"; $resn_exch{" C5* AZT"}=" C5' AZT"; $resn_exch{" C4* AZT"}=" C4' AZT";
$resn_exch{" O4* AZT"}=" O4' AZT"; $resn_exch{" C3* AZT"}=" C3' AZT"; $resn_exch{" N3* AZT"}=" N3' AZT";
$resn_exch{" N4* AZT"}=" N4' AZT"; $resn_exch{" N5* AZT"}=" N5' AZT"; $resn_exch{" C2* AZT"}=" C2' AZT";
$resn_exch{" C1* AZT"}=" C1' AZT"; $resn_exch{" O3P B1P"}=" OP3 B1P"; $resn_exch{" O1P B1P"}=" OP1 B1P";
$resn_exch{" O2P B1P"}=" OP2 B1P"; $resn_exch{" O5* B1P"}=" O5' B1P"; $resn_exch{" C5* B1P"}=" C5' B1P";
$resn_exch{" C4* B1P"}=" C4' B1P"; $resn_exch{" O4* B1P"}=" O4' B1P"; $resn_exch{" C1* B1P"}=" C1' B1P";
$resn_exch{" O1* B1P"}=" O1' B1P"; $resn_exch{" C2* B1P"}=" C2' B1P"; $resn_exch{" C3* B1P"}=" C3' B1P";
$resn_exch{" O3* B1P"}=" O3' B1P"; $resn_exch{"AO5* B4P"}=" O5E B4P"; $resn_exch{"AC5* B4P"}=" C5E B4P";
$resn_exch{"AC4* B4P"}=" C4E B4P"; $resn_exch{"AO4* B4P"}=" O4E B4P"; $resn_exch{"AC3* B4P"}=" C3E B4P";
$resn_exch{"AO3* B4P"}=" O3E B4P"; $resn_exch{"AC2* B4P"}=" C2E B4P"; $resn_exch{"AO2* B4P"}=" O2E B4P";
$resn_exch{"AC1* B4P"}=" C1E B4P"; $resn_exch{" AN9 B4P"}=" N9A B4P"; $resn_exch{" AC8 B4P"}=" C8A B4P";
$resn_exch{" AN7 B4P"}=" N7A B4P"; $resn_exch{" AC5 B4P"}=" C5A B4P"; $resn_exch{" AC6 B4P"}=" C6A B4P";
$resn_exch{" AN6 B4P"}=" N6A B4P"; $resn_exch{" AN1 B4P"}=" N1A B4P"; $resn_exch{" AC2 B4P"}=" C2A B4P";
$resn_exch{" AN3 B4P"}=" N3A B4P"; $resn_exch{" AC4 B4P"}=" C4A B4P"; $resn_exch{"BO5* B4P"}=" O5F B4P";
$resn_exch{"BC5* B4P"}=" C5F B4P"; $resn_exch{"BC4* B4P"}=" C4F B4P"; $resn_exch{"BO4* B4P"}=" O4F B4P";
$resn_exch{"BC3* B4P"}=" C3F B4P"; $resn_exch{"BO3* B4P"}=" O3F B4P"; $resn_exch{"BC2* B4P"}=" C2F B4P";
$resn_exch{"BO2* B4P"}=" O2F B4P"; $resn_exch{"BC1* B4P"}=" C1F B4P"; $resn_exch{" BN9 B4P"}=" N9B B4P";
$resn_exch{" BC8 B4P"}=" C8B B4P"; $resn_exch{" BN7 B4P"}=" N7B B4P"; $resn_exch{" BC5 B4P"}=" C5B B4P";
$resn_exch{" BC6 B4P"}=" C6B B4P"; $resn_exch{" BN6 B4P"}=" N6B B4P"; $resn_exch{" BN1 B4P"}=" N1B B4P";
$resn_exch{" BC2 B4P"}=" C2B B4P"; $resn_exch{" BN3 B4P"}=" N3B B4P"; $resn_exch{" BC4 B4P"}=" C4B B4P";
$resn_exch{" AC1 B9A"}=" C1A B9A"; $resn_exch{" AC2 B9A"}=" C2A B9A"; $resn_exch{" AC3 B9A"}=" C3A B9A";
$resn_exch{" AC4 B9A"}=" C4A B9A"; $resn_exch{" AC5 B9A"}=" C5A B9A"; $resn_exch{" AC6 B9A"}=" C6A B9A";
$resn_exch{" AC7 B9A"}=" C7A B9A"; $resn_exch{" AC8 B9A"}=" C8A B9A"; $resn_exch{" AC9 B9A"}=" C9A B9A";
$resn_exch{" AN9 B9A"}=" N9A B9A"; $resn_exch{"AN10 B9A"}=" NAA B9A"; $resn_exch{"AC11 B9A"}=" CBA B9A";
$resn_exch{"AC12 B9A"}=" CCA B9A"; $resn_exch{"AC13 B9A"}=" CDA B9A"; $resn_exch{"AC14 B9A"}=" CEA B9A";
$resn_exch{" BC1 B9A"}=" C1B B9A"; $resn_exch{" BC2 B9A"}=" C2B B9A"; $resn_exch{" BC3 B9A"}=" C3B B9A";
$resn_exch{" BC4 B9A"}=" C4B B9A"; $resn_exch{" BC5 B9A"}=" C5B B9A"; $resn_exch{" BC6 B9A"}=" C6B B9A";
$resn_exch{" BC7 B9A"}=" C7B B9A"; $resn_exch{" BC8 B9A"}=" C8B B9A"; $resn_exch{" BC9 B9A"}=" C9B B9A";
$resn_exch{"BN10 B9A"}=" NAB B9A"; $resn_exch{"BC11 B9A"}=" CBB B9A"; $resn_exch{"BC12 B9A"}=" CCB B9A";
$resn_exch{"BC13 B9A"}=" CDB B9A"; $resn_exch{"BC14 B9A"}=" CEB B9A"; $resn_exch{" BN9 B9A"}=" N9B B9A";
$resn_exch{"2O1A BA1"}=" OAC BA1"; $resn_exch{" C1\" BA1"}=" C1B BA1"; $resn_exch{"2O1B BA1"}=" OBC BA1";
$resn_exch{" C2\" BA1"}=" C2B BA1"; $resn_exch{" C3\" BA1"}=" C3B BA1"; $resn_exch{" C4\" BA1"}=" C4B BA1";
$resn_exch{" O4\" BA1"}=" O4' BA1"; $resn_exch{" C5\" BA1"}=" C5B BA1"; $resn_exch{" C6\" BA1"}=" C6B BA1";
$resn_exch{" O6\" BA1"}=" O6' BA1"; $resn_exch{" C7\" BA1"}=" C7B BA1"; $resn_exch{" C8\" BA1"}=" C8' BA1";
$resn_exch{" O8\" BA1"}=" O8' BA1"; $resn_exch{" C9\" BA1"}=" C9' BA1"; $resn_exch{"2C10 BA1"}=" CXU BA1";
$resn_exch{"2O10 BA1"}=" OXU BA1"; $resn_exch{"2C11 BA1"}=" CX4 BA1"; $resn_exch{"2C12 BA1"}=" CXE BA1";
$resn_exch{"2C13 BA1"}=" CXO BA1"; $resn_exch{"2C14 BA1"}=" CXY BA1"; $resn_exch{"2C15 BA1"}=" CX8 BA1";
$resn_exch{"2O15 BA1"}=" OX8 BA1"; $resn_exch{"2O16 BA1"}=" OXI BA1"; $resn_exch{" C1* BA2"}=" C1' BA2";
$resn_exch{" C2* BA2"}=" C2' BA2"; $resn_exch{" O2* BA2"}=" O2' BA2"; $resn_exch{" C3* BA2"}=" C3' BA2";
$resn_exch{" O3* BA2"}=" O3' BA2"; $resn_exch{" C4* BA2"}=" C4' BA2"; $resn_exch{" O4* BA2"}=" O4' BA2";
$resn_exch{" C5* BA2"}=" C5' BA2"; $resn_exch{"C10A  BC"}=" CAA  BC"; $resn_exch{"C14A  BC"}=" CEA  BC";
$resn_exch{"C14B  BC"}=" CEB  BC"; $resn_exch{"C14C  BC"}=" CEC  BC"; $resn_exch{" AN1 BCA"}=" N1A BCA";
$resn_exch{" AC2 BCA"}=" C2A BCA"; $resn_exch{" AN3 BCA"}=" N3A BCA"; $resn_exch{" AC4 BCA"}=" C4A BCA";
$resn_exch{" AC5 BCA"}=" C5A BCA"; $resn_exch{" AC6 BCA"}=" C6A BCA"; $resn_exch{" AN6 BCA"}=" N6A BCA";
$resn_exch{" AN7 BCA"}=" N7A BCA"; $resn_exch{" AC8 BCA"}=" C8A BCA"; $resn_exch{" AN9 BCA"}=" N9A BCA";
$resn_exch{"AC1* BCA"}=" C1D BCA"; $resn_exch{"AC2* BCA"}=" C2D BCA"; $resn_exch{"AO2* BCA"}=" O2D BCA";
$resn_exch{"AC3* BCA"}=" C3D BCA"; $resn_exch{"AO3* BCA"}=" O3D BCA"; $resn_exch{"AP3* BCA"}=" P3D BCA";
$resn_exch{" AO7 BCA"}=" O7A BCA"; $resn_exch{" AO8 BCA"}=" O8A BCA"; $resn_exch{" AO9 BCA"}=" O9A BCA";
$resn_exch{"AC4* BCA"}=" C4D BCA"; $resn_exch{"AO4* BCA"}=" O4D BCA"; $resn_exch{"AC5* BCA"}=" C5D BCA";
$resn_exch{"AO5* BCA"}=" O5D BCA"; $resn_exch{" AP1 BCA"}=" P1A BCA"; $resn_exch{" AO1 BCA"}=" O1A BCA";
$resn_exch{" AO2 BCA"}=" O2A BCA"; $resn_exch{" AO3 BCA"}=" O3A BCA"; $resn_exch{" AP2 BCA"}=" P2A BCA";
$resn_exch{" AO4 BCA"}=" O4A BCA"; $resn_exch{" AO5 BCA"}=" O5A BCA"; $resn_exch{" AO6 BCA"}=" O6A BCA";
$resn_exch{"PC11 BCA"}=" CBP BCA"; $resn_exch{"PC12 BCA"}=" CCP BCA"; $resn_exch{"PC13 BCA"}=" CDP BCA";
$resn_exch{"PC14 BCA"}=" CEP BCA"; $resn_exch{"PC10 BCA"}=" CAP BCA"; $resn_exch{"PO10 BCA"}=" OAP BCA";
$resn_exch{" PC9 BCA"}=" C9P BCA"; $resn_exch{" PO9 BCA"}=" O9P BCA"; $resn_exch{" PN8 BCA"}=" N8P BCA";
$resn_exch{" PC7 BCA"}=" C7P BCA"; $resn_exch{" PC6 BCA"}=" C6P BCA"; $resn_exch{" PC5 BCA"}=" C5P BCA";
$resn_exch{" PO5 BCA"}=" O5P BCA"; $resn_exch{" PN4 BCA"}=" N4P BCA"; $resn_exch{" PC3 BCA"}=" C3P BCA";
$resn_exch{" PC2 BCA"}=" C2P BCA"; $resn_exch{" PS1 BCA"}=" S1P BCA"; $resn_exch{" BC1 BCA"}=" C1B BCA";
$resn_exch{" BO1 BCA"}=" O1B BCA"; $resn_exch{" BC2 BCA"}=" C2B BCA"; $resn_exch{" BC3 BCA"}=" C3B BCA";
$resn_exch{" BC4 BCA"}=" C4B BCA"; $resn_exch{" BC5 BCA"}=" C5B BCA"; $resn_exch{" BO2 BCA"}=" O2B BCA";
$resn_exch{" BC6 BCA"}=" C6B BCA"; $resn_exch{" BC7 BCA"}=" C7B BCA"; $resn_exch{" N_A BCB"}=" NA  BCB";
$resn_exch{" N_B BCB"}=" NB  BCB"; $resn_exch{" N_C BCB"}=" NC  BCB"; $resn_exch{" N_D BCB"}=" ND  BCB";
$resn_exch{" N_A BCL"}=" NA  BCL"; $resn_exch{" N_B BCL"}=" NB  BCL"; $resn_exch{" N_C BCL"}=" NC  BCL";
$resn_exch{" N_D BCL"}=" ND  BCL"; $resn_exch{" C1* BDA"}=" C1' BDA"; $resn_exch{" C2* BDA"}=" C2' BDA";
$resn_exch{" C3* BDA"}=" C3' BDA"; $resn_exch{" N3* BDA"}=" N3' BDA"; $resn_exch{" C4* BDA"}=" C4' BDA";
$resn_exch{" O4* BDA"}=" O4' BDA"; $resn_exch{" C5* BDA"}=" C5' BDA"; $resn_exch{" O5* BDA"}=" O5' BDA";
$resn_exch{" C6* BDA"}=" C6' BDA"; $resn_exch{" C7* BDA"}=" C7' BDA"; $resn_exch{" C8* BDA"}=" C8' BDA";
$resn_exch{"'C1  BDA"}=" C1B BDA"; $resn_exch{"'C2  BDA"}=" C2B BDA"; $resn_exch{"'C3  BDA"}=" C3B BDA";
$resn_exch{"'C4  BDA"}=" C4B BDA"; $resn_exch{"'O4  BDA"}=" O4B BDA"; $resn_exch{"'C5  BDA"}=" C5B BDA";
$resn_exch{"'C6  BDA"}=" C6B BDA"; $resn_exch{"'O6  BDA"}=" O6' BDA"; $resn_exch{"'C7  BDA"}=" C7B BDA";
$resn_exch{"'C8  BDA"}=" C8B BDA"; $resn_exch{"'O8  BDA"}=" O8' BDA"; $resn_exch{"'C9  BDA"}=" C9' BDA";
$resn_exch{"'C10 BDA"}=" CA' BDA"; $resn_exch{"'O10 BDA"}=" OA' BDA"; $resn_exch{"'C11 BDA"}=" CB' BDA";
$resn_exch{"'C12 BDA"}=" CC' BDA"; $resn_exch{"'O12 BDA"}=" OC' BDA"; $resn_exch{"'C13 BDA"}=" CD' BDA";
$resn_exch{"'O13 BDA"}=" OD' BDA"; $resn_exch{"'C14 BDA"}=" CE' BDA"; $resn_exch{"'C15 BDA"}=" CF' BDA";
$resn_exch{"'C16 BDA"}=" CG' BDA"; $resn_exch{"'C17 BDA"}=" CH' BDA"; $resn_exch{"'O17 BDA"}=" OH' BDA";
$resn_exch{"'C18 BDA"}=" CI' BDA"; $resn_exch{"'C19 BDA"}=" CJ' BDA"; $resn_exch{"'O19 BDA"}=" OJ' BDA";
$resn_exch{"'C20 BDA"}=" CK' BDA"; $resn_exch{"'C21 BDA"}=" CL' BDA"; $resn_exch{"'C1* BDA"}=" C1D BDA";
$resn_exch{"'C2* BDA"}=" C2D BDA"; $resn_exch{"'C3* BDA"}=" C3D BDA"; $resn_exch{"'N3* BDA"}=" N3D BDA";
$resn_exch{"'C4* BDA"}=" C4D BDA"; $resn_exch{"'O4* BDA"}=" O4D BDA"; $resn_exch{"'C5* BDA"}=" C5D BDA";
$resn_exch{"'O5* BDA"}=" O5D BDA"; $resn_exch{"'C6* BDA"}=" C6D BDA"; $resn_exch{"'C7* BDA"}=" C7D BDA";
$resn_exch{"'C8* BDA"}=" C8D BDA"; $resn_exch{"'C9A BDA"}=" C1A BDA"; $resn_exch{"'C9B BDA"}=" C1C BDA";
$resn_exch{"'CE4 BDC"}=" CF4 BDC"; $resn_exch{"'CE3 BDC"}=" CF3 BDC"; $resn_exch{"'CE2 BDC"}=" CF2 BDC";
$resn_exch{"'CE1 BDC"}=" CF1 BDC"; $resn_exch{"'N9  BDC"}=" N9' BDC"; $resn_exch{"'C5  BDC"}=" C5' BDC";
$resn_exch{"'C6  BDC"}=" C6' BDC"; $resn_exch{"'C7  BDC"}=" C7' BDC"; $resn_exch{"'C8  BDC"}=" C8' BDC";
$resn_exch{"'C9  BDC"}=" C9' BDC"; $resn_exch{"'C1  BDC"}=" C1' BDC"; $resn_exch{"'C2  BDC"}=" C2' BDC";
$resn_exch{"'C3  BDC"}=" C3' BDC"; $resn_exch{"'C4  BDC"}=" C4' BDC"; $resn_exch{"'C14 BDC"}=" CE' BDC";
$resn_exch{"'C13 BDC"}=" CD' BDC"; $resn_exch{"'C11 BDC"}=" CB' BDC"; $resn_exch{"'C12 BDC"}=" CC' BDC";
$resn_exch{"'N10 BDC"}=" NA' BDC"; $resn_exch{"'CD1 BDC"}=" CB1 BDC"; $resn_exch{"'OD1 BDC"}=" O1X BDC";
$resn_exch{"'ND1 BDC"}=" NB1 BDC"; $resn_exch{"'CD2 BDC"}=" CB2 BDC"; $resn_exch{"'CD3 BDC"}=" CB3 BDC";
$resn_exch{"'ND2 BDC"}=" NB2 BDC"; $resn_exch{"'CD7 BDC"}=" CB7 BDC"; $resn_exch{"'CD8 BDC"}=" CB8 BDC";
$resn_exch{"1O21 BDM"}=" OXV BDM"; $resn_exch{"2O21 BDM"}=" OXW BDM"; $resn_exch{"1O22 BDM"}=" OX5 BDM";
$resn_exch{"2O22 BDM"}=" OX6 BDM"; $resn_exch{" O1P BGM"}=" OP1 BGM"; $resn_exch{" O2P BGM"}=" OP2 BGM";
$resn_exch{" O5* BGM"}=" O5' BGM"; $resn_exch{" C5* BGM"}=" C5' BGM"; $resn_exch{" C4* BGM"}=" C4' BGM";
$resn_exch{" O4* BGM"}=" O4' BGM"; $resn_exch{" C1* BGM"}=" C1' BGM"; $resn_exch{" C2* BGM"}=" C2' BGM";
$resn_exch{" C3* BGM"}=" C3' BGM"; $resn_exch{" O3* BGM"}=" O3' BGM"; $resn_exch{" O3P BGM"}=" OP3 BGM";
$resn_exch{" C2* BGS"}=" C2' BGS"; $resn_exch{" O2* BGS"}=" O2' BGS"; $resn_exch{" O1* BGS"}=" O1' BGS";
$resn_exch{" O5* BIS"}=" O5' BIS"; $resn_exch{" C5* BIS"}=" C5' BIS"; $resn_exch{" C4* BIS"}=" C4' BIS";
$resn_exch{" O4* BIS"}=" O4' BIS"; $resn_exch{" C3* BIS"}=" C3' BIS"; $resn_exch{" O3* BIS"}=" O3' BIS";
$resn_exch{" C2* BIS"}=" C2' BIS"; $resn_exch{" O2* BIS"}=" O2' BIS"; $resn_exch{" C1* BIS"}=" C1' BIS";
$resn_exch{" *N1 BIZ"}=" N1' BIZ"; $resn_exch{" *C2 BIZ"}=" C2' BIZ"; $resn_exch{" *C3 BIZ"}=" C3' BIZ";
$resn_exch{" *C4 BIZ"}=" C4' BIZ"; $resn_exch{" *C5 BIZ"}=" C5' BIZ"; $resn_exch{" *C6 BIZ"}=" C6' BIZ";
$resn_exch{" *C7 BIZ"}=" C7' BIZ"; $resn_exch{" *N8 BIZ"}=" N8' BIZ"; $resn_exch{" *C9 BIZ"}=" C9' BIZ";
$resn_exch{"*C10 BIZ"}=" CA' BIZ"; $resn_exch{"*C11 BIZ"}=" CB' BIZ"; $resn_exch{"*O12 BIZ"}=" OC' BIZ";
$resn_exch{"*N13 BIZ"}=" ND' BIZ"; $resn_exch{"*C14 BIZ"}=" CE' BIZ"; $resn_exch{"*C15 BIZ"}=" CF' BIZ";
$resn_exch{"*C16 BIZ"}=" CG' BIZ"; $resn_exch{"*C17 BIZ"}=" CH' BIZ"; $resn_exch{"*C18 BIZ"}=" CI' BIZ";
$resn_exch{"*C19 BIZ"}=" CJ' BIZ"; $resn_exch{"*C20 BIZ"}=" CK' BIZ"; $resn_exch{"*O21 BIZ"}=" OL' BIZ";
$resn_exch{"*C22 BIZ"}=" CM' BIZ"; $resn_exch{"*C23 BIZ"}=" CN' BIZ"; $resn_exch{"*C24 BIZ"}=" CO' BIZ";
$resn_exch{"*C25 BIZ"}=" CP' BIZ"; $resn_exch{"*C26 BIZ"}=" CQ' BIZ"; $resn_exch{"*N27 BIZ"}=" NR' BIZ";
$resn_exch{" N_A BLA"}=" NA  BLA"; $resn_exch{" N_B BLA"}=" NB  BLA"; $resn_exch{" O_B BLA"}=" OB  BLA";
$resn_exch{" N_C BLA"}=" NC  BLA"; $resn_exch{" O_C BLA"}=" OC  BLA"; $resn_exch{" N_D BLA"}=" ND  BLA";
$resn_exch{" C6* BLI"}=" C6B BLI"; $resn_exch{" C1* BLI"}=" C1B BLI"; $resn_exch{" C2* BLI"}=" C2B BLI";
$resn_exch{" C3* BLI"}=" C3B BLI"; $resn_exch{" C4* BLI"}=" C4B BLI"; $resn_exch{" C5* BLI"}=" C5B BLI";
$resn_exch{" C1* BLS"}=" C1' BLS"; $resn_exch{" C2* BLS"}=" C2' BLS"; $resn_exch{" C3* BLS"}=" C3' BLS";
$resn_exch{" C4* BLS"}=" C4' BLS"; $resn_exch{" C5* BLS"}=" C5' BLS"; $resn_exch{" O5* BLS"}=" O5' BLS";
$resn_exch{" C6* BLS"}=" C6' BLS"; $resn_exch{" N_A BLV"}=" NA  BLV"; $resn_exch{" O_A BLV"}=" OA  BLV";
$resn_exch{" N_B BLV"}=" NB  BLV"; $resn_exch{" N_C BLV"}=" NC  BLV"; $resn_exch{" N_D BLV"}=" ND  BLV";
$resn_exch{" O_D BLV"}=" OD  BLV"; $resn_exch{" O1P BMP"}=" OP1 BMP"; $resn_exch{" O2P BMP"}=" OP2 BMP";
$resn_exch{" O3P BMP"}=" OP3 BMP"; $resn_exch{" O5* BMP"}=" O5' BMP"; $resn_exch{" C5* BMP"}=" C5' BMP";
$resn_exch{" C4* BMP"}=" C4' BMP"; $resn_exch{" O4* BMP"}=" O4' BMP"; $resn_exch{" C3* BMP"}=" C3' BMP";
$resn_exch{" O3* BMP"}=" O3' BMP"; $resn_exch{" C2* BMP"}=" C2' BMP"; $resn_exch{" O2* BMP"}=" O2' BMP";
$resn_exch{" C1* BMP"}=" C1' BMP"; $resn_exch{" O5* BMQ"}=" O5' BMQ"; $resn_exch{" C5* BMQ"}=" C5' BMQ";
$resn_exch{" C4* BMQ"}=" C4' BMQ"; $resn_exch{" O4* BMQ"}=" O4' BMQ"; $resn_exch{" C3* BMQ"}=" C3' BMQ";
$resn_exch{" O3* BMQ"}=" O3' BMQ"; $resn_exch{" C2* BMQ"}=" C2' BMQ"; $resn_exch{" O2* BMQ"}=" O2' BMQ";
$resn_exch{" C1* BMQ"}=" C1' BMQ"; $resn_exch{" O1\" BMY"}=" O1' BMY"; $resn_exch{" C2\" BMY"}=" C2B BMY";
$resn_exch{" C3\" BMY"}=" C3B BMY"; $resn_exch{" C4\" BMY"}=" C4B BMY"; $resn_exch{" C5\" BMY"}=" C5B BMY";
$resn_exch{" C6\" BMY"}=" C6' BMY"; $resn_exch{" C7\" BMY"}=" C7B BMY"; $resn_exch{" O8\" BMY"}=" O8' BMY";
$resn_exch{" O9\" BMY"}=" O9B BMY"; $resn_exch{"AC4A BNA"}=" C11 BNA"; $resn_exch{"AC8A BNA"}=" C12 BNA";
$resn_exch{"AC4B BNA"}=" C13 BNA"; $resn_exch{"AC8B BNA"}=" C14 BNA"; $resn_exch{" C1* BNR"}=" C1' BNR";
$resn_exch{" C2* BNR"}=" C2' BNR"; $resn_exch{" C3* BNR"}=" C3' BNR"; $resn_exch{" O3* BNR"}=" O3' BNR";
$resn_exch{" C4* BNR"}=" C4' BNR"; $resn_exch{" N4* BNR"}=" N4' BNR"; $resn_exch{" C5* BNR"}=" C5' BNR";
$resn_exch{" O5* BNR"}=" O5' BNR"; $resn_exch{" C6* BNR"}=" C6' BNR"; $resn_exch{" C7* BNR"}=" C7' BNR";
$resn_exch{" C8* BNR"}=" C8' BNR"; $resn_exch{"'C1  BNR"}=" C1B BNR"; $resn_exch{"'C2  BNR"}=" C2B BNR";
$resn_exch{"'C3  BNR"}=" C3B BNR"; $resn_exch{"'C4  BNR"}=" C4B BNR"; $resn_exch{"'O4  BNR"}=" O4' BNR";
$resn_exch{"'C5  BNR"}=" C5B BNR"; $resn_exch{"'C6  BNR"}=" C6B BNR"; $resn_exch{"'O6  BNR"}=" O6' BNR";
$resn_exch{"'C7  BNR"}=" C7B BNR"; $resn_exch{"'C8  BNR"}=" C8B BNR"; $resn_exch{"'O8  BNR"}=" O8' BNR";
$resn_exch{"'C9  BNR"}=" C9' BNR"; $resn_exch{"'C10 BNR"}=" CA' BNR"; $resn_exch{"'O10 BNR"}=" OA' BNR";
$resn_exch{"'C11 BNR"}=" CB' BNR"; $resn_exch{"'C12 BNR"}=" CC' BNR"; $resn_exch{"'O12 BNR"}=" OC' BNR";
$resn_exch{"'C13 BNR"}=" CD' BNR"; $resn_exch{"'O13 BNR"}=" OD' BNR"; $resn_exch{"'C14 BNR"}=" CE' BNR";
$resn_exch{"'C15 BNR"}=" CF' BNR"; $resn_exch{"'C16 BNR"}=" CG' BNR"; $resn_exch{"'C17 BNR"}=" CH' BNR";
$resn_exch{"'O17 BNR"}=" OH' BNR"; $resn_exch{"'C18 BNR"}=" CI' BNR"; $resn_exch{"'C19 BNR"}=" CJ' BNR";
$resn_exch{"'O19 BNR"}=" OJ' BNR"; $resn_exch{"'C20 BNR"}=" CK' BNR"; $resn_exch{"'C21 BNR"}=" CL' BNR";
$resn_exch{"'C1* BNR"}=" C1D BNR"; $resn_exch{"'C2* BNR"}=" C2D BNR"; $resn_exch{"'C3* BNR"}=" C3D BNR";
$resn_exch{"'O3* BNR"}=" O3D BNR"; $resn_exch{"'C4* BNR"}=" C4D BNR"; $resn_exch{"'N4* BNR"}=" N4D BNR";
$resn_exch{"'C5* BNR"}=" C5D BNR"; $resn_exch{"'O5* BNR"}=" O5D BNR"; $resn_exch{"'C6* BNR"}=" C6D BNR";
$resn_exch{"'C7* BNR"}=" C7D BNR"; $resn_exch{"'C8* BNR"}=" C8D BNR"; $resn_exch{"'C9A BNR"}=" C1A BNR";
$resn_exch{"'C9B BNR"}=" C1C BNR"; $resn_exch{" O1P BOE"}=" OP1 BOE"; $resn_exch{" O2P BOE"}=" OP2 BOE";
$resn_exch{" O5* BOE"}=" O5' BOE"; $resn_exch{" C5* BOE"}=" C5' BOE"; $resn_exch{" C4* BOE"}=" C4' BOE";
$resn_exch{" O4* BOE"}=" O4' BOE"; $resn_exch{" C1* BOE"}=" C1' BOE"; $resn_exch{" C2* BOE"}=" C2' BOE";
$resn_exch{" O2* BOE"}=" O2' BOE"; $resn_exch{" C3* BOE"}=" C3' BOE"; $resn_exch{" O3* BOE"}=" O3' BOE";
$resn_exch{" O3P BOE"}=" OP3 BOE"; $resn_exch{" N_A BPB"}=" NA  BPB"; $resn_exch{" N_B BPB"}=" NB  BPB";
$resn_exch{" N_C BPB"}=" NC  BPB"; $resn_exch{" N_D BPB"}=" ND  BPB"; $resn_exch{" C3* BPG"}=" C3' BPG";
$resn_exch{" O3* BPG"}=" O3' BPG"; $resn_exch{" C2* BPG"}=" C2' BPG"; $resn_exch{" C1* BPG"}=" C1' BPG";
$resn_exch{" N_A BPH"}=" NA  BPH"; $resn_exch{" N_B BPH"}=" NB  BPH"; $resn_exch{" N_C BPH"}=" NC  BPH";
$resn_exch{" N_D BPH"}=" ND  BPH"; $resn_exch{"CX10 BPS"}=" CXA BPS"; $resn_exch{"CX11 BPS"}=" CXB BPS";
$resn_exch{"CX12 BPS"}=" CXC BPS"; $resn_exch{"CK10 BPY"}=" CKA BPY"; $resn_exch{"CK11 BPY"}=" CKB BPY";
$resn_exch{"CK12 BPY"}=" CKC BPY"; $resn_exch{" C1* BRU"}=" C1' BRU"; $resn_exch{" C2* BRU"}=" C2' BRU";
$resn_exch{" C3* BRU"}=" C3' BRU"; $resn_exch{" C4* BRU"}=" C4' BRU"; $resn_exch{" O3* BRU"}=" O3' BRU";
$resn_exch{" O4* BRU"}=" O4' BRU"; $resn_exch{" C5* BRU"}=" C5' BRU"; $resn_exch{" O5* BRU"}=" O5' BRU";
$resn_exch{" O1P BRU"}=" OP1 BRU"; $resn_exch{" O2P BRU"}=" OP2 BRU"; $resn_exch{" O3P BRU"}=" OP3 BRU";
$resn_exch{" C1* BSP"}=" C1B BSP"; $resn_exch{" C2* BSP"}=" C2B BSP"; $resn_exch{" C3* BSP"}=" C3B BSP";
$resn_exch{" C4* BSP"}=" C4B BSP"; $resn_exch{" C5* BSP"}=" C5B BSP"; $resn_exch{" C6* BSP"}=" C6B BSP";
$resn_exch{" O4* BSP"}=" O4B BSP"; $resn_exch{" S1* BSP"}=" S1B BSP"; $resn_exch{"C11B BT5"}=" CBB BT5";
$resn_exch{"O11B BT5"}=" OBB BT5"; $resn_exch{"O12B BT5"}=" OCB BT5"; $resn_exch{"C10B BT5"}=" CAB BT5";
$resn_exch{" O1P BT5"}=" OP1 BT5"; $resn_exch{" O2P BT5"}=" OP2 BT5"; $resn_exch{" O5* BT5"}=" O5' BT5";
$resn_exch{" C5* BT5"}=" C5' BT5"; $resn_exch{" C4* BT5"}=" C4' BT5"; $resn_exch{" O4* BT5"}=" O4' BT5";
$resn_exch{" C3* BT5"}=" C3' BT5"; $resn_exch{" O3* BT5"}=" O3' BT5"; $resn_exch{" C2* BT5"}=" C2' BT5";
$resn_exch{" O2* BT5"}=" O2' BT5"; $resn_exch{" C1* BT5"}=" C1' BT5"; $resn_exch{" O5* BTD"}=" O5' BTD";
$resn_exch{" C5* BTD"}=" C5' BTD"; $resn_exch{" C4* BTD"}=" C4' BTD"; $resn_exch{" O4* BTD"}=" O4' BTD";
$resn_exch{" C1* BTD"}=" C1' BTD"; $resn_exch{" C2* BTD"}=" C2' BTD"; $resn_exch{" C3* BTD"}=" C3' BTD";
$resn_exch{" O3* BTD"}=" O3' BTD"; $resn_exch{" C*  BTP"}=" C'  BTP"; $resn_exch{" S*  BTP"}=" S'  BTP";
$resn_exch{" O5* BTX"}=" O5' BTX"; $resn_exch{" C5* BTX"}=" C5' BTX"; $resn_exch{" C4* BTX"}=" C4' BTX";
$resn_exch{" O4* BTX"}=" O4' BTX"; $resn_exch{" C3* BTX"}=" C3' BTX"; $resn_exch{" O3* BTX"}=" O3' BTX";
$resn_exch{" C2* BTX"}=" C2' BTX"; $resn_exch{" O2* BTX"}=" O2' BTX"; $resn_exch{" C1* BTX"}=" C1' BTX";
$resn_exch{"C11B BTX"}=" CBB BTX"; $resn_exch{"O11B BTX"}=" OBB BTX"; $resn_exch{"C10B BTX"}=" CAB BTX";
$resn_exch{" O5* BVD"}=" O5' BVD"; $resn_exch{" C5* BVD"}=" C5' BVD"; $resn_exch{" C4* BVD"}=" C4' BVD";
$resn_exch{" O4* BVD"}=" O4' BVD"; $resn_exch{" C1* BVD"}=" C1' BVD"; $resn_exch{" C2* BVD"}=" C2' BVD";
$resn_exch{" C3* BVD"}=" C3' BVD"; $resn_exch{" O3* BVD"}=" O3' BVD"; $resn_exch{" O3* BVP"}=" O3' BVP";
$resn_exch{" C3* BVP"}=" C3' BVP"; $resn_exch{" C2* BVP"}=" C2' BVP"; $resn_exch{" C1* BVP"}=" C1' BVP";
$resn_exch{" O4* BVP"}=" O4' BVP"; $resn_exch{" C4* BVP"}=" C4' BVP"; $resn_exch{" C5* BVP"}=" C5' BVP";
$resn_exch{" O5* BVP"}=" O5' BVP"; $resn_exch{" O5* BZG"}=" O5' BZG"; $resn_exch{" CT* BZG"}=" CT' BZG";
$resn_exch{" OS* BZG"}=" OS' BZG"; $resn_exch{" CP* BZG"}=" CP' BZG"; $resn_exch{" C5* BZG"}=" C5' BZG";
$resn_exch{" C4* BZG"}=" C4' BZG"; $resn_exch{" C3* BZG"}=" C3' BZG"; $resn_exch{" O3* BZG"}=" O3' BZG";
$resn_exch{" O3P   C"}=" OP3   C"; $resn_exch{" O1P   C"}=" OP1   C"; $resn_exch{" O2P   C"}=" OP2   C";
$resn_exch{" O5*   C"}=" O5'   C"; $resn_exch{" C5*   C"}=" C5'   C"; $resn_exch{" C4*   C"}=" C4'   C";
$resn_exch{" O4*   C"}=" O4'   C"; $resn_exch{" C3*   C"}=" C3'   C"; $resn_exch{" O3*   C"}=" O3'   C";
$resn_exch{" C2*   C"}=" C2'   C"; $resn_exch{" O2*   C"}=" O2'   C"; $resn_exch{" C1*   C"}=" C1'   C";
$resn_exch{"C31' C1B"}=" CVX C1B"; $resn_exch{"C32' C1B"}=" CWX C1B"; $resn_exch{"O33' C1B"}=" OXX C1B";
$resn_exch{"O34' C1B"}=" OYX C1B"; $resn_exch{"C42' C1B"}=" C6X C1B"; $resn_exch{"C43' C1B"}=" C7X C1B";
$resn_exch{"O44' C1B"}=" O8X C1B"; $resn_exch{"O45' C1B"}=" O9X C1B"; $resn_exch{"C1'' C1B"}=" C1B C1B";
$resn_exch{"C2'' C1B"}=" C2B C1B"; $resn_exch{"C3'' C1B"}=" C3B C1B"; $resn_exch{"C4'' C1B"}=" C4B C1B";
$resn_exch{"C5'' C1B"}=" C5B C1B"; $resn_exch{"C6'' C1B"}=" C6B C1B"; $resn_exch{"O2'' C1B"}=" O2B C1B";
$resn_exch{" O3P C25"}=" OP3 C25"; $resn_exch{" O1P C25"}=" OP1 C25"; $resn_exch{" O2P C25"}=" OP2 C25";
$resn_exch{" O5* C25"}=" O5' C25"; $resn_exch{" C5* C25"}=" C5' C25"; $resn_exch{" C4* C25"}=" C4' C25";
$resn_exch{" O4* C25"}=" O4' C25"; $resn_exch{" C3* C25"}=" C3' C25"; $resn_exch{" O3* C25"}=" O3' C25";
$resn_exch{" C2* C25"}=" C2' C25"; $resn_exch{" O2* C25"}=" O2' C25"; $resn_exch{" C1* C25"}=" C1' C25";
$resn_exch{" C1* C2G"}=" C1' C2G"; $resn_exch{" C2* C2G"}=" C2' C2G"; $resn_exch{" O2* C2G"}=" O2' C2G";
$resn_exch{" C3* C2G"}=" C3' C2G"; $resn_exch{" C4* C2G"}=" C4' C2G"; $resn_exch{" O4* C2G"}=" O4' C2G";
$resn_exch{" O3* C2G"}=" O3' C2G"; $resn_exch{" C5* C2G"}=" C5' C2G"; $resn_exch{" O5* C2G"}=" O5' C2G";
$resn_exch{" O3P C2L"}=" OP3 C2L"; $resn_exch{" O1P C2L"}=" OP1 C2L"; $resn_exch{" O2P C2L"}=" OP2 C2L";
$resn_exch{" O5* C2L"}=" O5' C2L"; $resn_exch{" C5* C2L"}=" C5' C2L"; $resn_exch{" C4* C2L"}=" C4' C2L";
$resn_exch{" O4* C2L"}=" O4' C2L"; $resn_exch{" C3* C2L"}=" C3' C2L"; $resn_exch{" O3* C2L"}=" O3' C2L";
$resn_exch{" C2* C2L"}=" C2' C2L"; $resn_exch{" O2* C2L"}=" O2' C2L"; $resn_exch{" C1* C2L"}=" C1' C2L";
$resn_exch{" CA* C2L"}=" CA' C2L"; $resn_exch{" CB* C2L"}=" CB' C2L"; $resn_exch{" OC* C2L"}=" OC' C2L";
$resn_exch{" CD* C2L"}=" CD' C2L"; $resn_exch{" C1* C2P"}=" C1' C2P"; $resn_exch{" C2* C2P"}=" C2' C2P";
$resn_exch{" O2* C2P"}=" O2' C2P"; $resn_exch{" C3* C2P"}=" C3' C2P"; $resn_exch{" C4* C2P"}=" C4' C2P";
$resn_exch{" O4* C2P"}=" O4' C2P"; $resn_exch{" O3* C2P"}=" O3' C2P"; $resn_exch{" C5* C2P"}=" C5' C2P";
$resn_exch{" O5* C2P"}=" O5' C2P"; $resn_exch{" O5* C2R"}=" O5' C2R"; $resn_exch{" C2* C2R"}=" C2' C2R";
$resn_exch{" O2* C2R"}=" O2' C2R"; $resn_exch{" C3* C2R"}=" C3' C2R"; $resn_exch{" O3* C2R"}=" O3' C2R";
$resn_exch{" C5* C2R"}=" C5' C2R"; $resn_exch{" C4* C2R"}=" C4' C2R"; $resn_exch{" O4* C2R"}=" O4' C2R";
$resn_exch{" C1* C2R"}=" C1' C2R"; $resn_exch{" O3P C2S"}=" OP3 C2S"; $resn_exch{" O5* C2S"}=" O5' C2S";
$resn_exch{" C5* C2S"}=" C5' C2S"; $resn_exch{" C4* C2S"}=" C4' C2S"; $resn_exch{" O4* C2S"}=" O4' C2S";
$resn_exch{" C3* C2S"}=" C3' C2S"; $resn_exch{" O3* C2S"}=" O3' C2S"; $resn_exch{" C2* C2S"}=" C2' C2S";
$resn_exch{" C1* C2S"}=" C1' C2S"; $resn_exch{" O5* C31"}=" O5' C31"; $resn_exch{" C5* C31"}=" C5' C31";
$resn_exch{" C4* C31"}=" C4' C31"; $resn_exch{" O4* C31"}=" O4' C31"; $resn_exch{" C3* C31"}=" C3' C31";
$resn_exch{" O3* C31"}=" O3' C31"; $resn_exch{" C2* C31"}=" C2' C31"; $resn_exch{" O2* C31"}=" O2' C31";
$resn_exch{" C1* C31"}=" C1' C31"; $resn_exch{" CA* C31"}=" CA' C31"; $resn_exch{" CB* C31"}=" CB' C31";
$resn_exch{" ND* C31"}=" ND' C31"; $resn_exch{" O5* C32"}=" O5' C32"; $resn_exch{" C5* C32"}=" C5' C32";
$resn_exch{" C4* C32"}=" C4' C32"; $resn_exch{" O4* C32"}=" O4' C32"; $resn_exch{" C3* C32"}=" C3' C32";
$resn_exch{" O3* C32"}=" O3' C32"; $resn_exch{" C2* C32"}=" C2' C32"; $resn_exch{" C1* C32"}=" C1' C32";
$resn_exch{" O1P C34"}=" OP1 C34"; $resn_exch{" O2P C34"}=" OP2 C34"; $resn_exch{" O3P C34"}=" OP3 C34";
$resn_exch{" O5* C34"}=" O5' C34"; $resn_exch{" C5* C34"}=" C5' C34"; $resn_exch{" C4* C34"}=" C4' C34";
$resn_exch{" O4* C34"}=" O4' C34"; $resn_exch{" C1* C34"}=" C1' C34"; $resn_exch{" C2* C34"}=" C2' C34";
$resn_exch{" C3* C34"}=" C3' C34"; $resn_exch{" O3* C34"}=" O3' C34"; $resn_exch{" O5* C36"}=" O5' C36";
$resn_exch{" C5* C36"}=" C5' C36"; $resn_exch{" C4* C36"}=" C4' C36"; $resn_exch{" O4* C36"}=" O4' C36";
$resn_exch{" C3* C36"}=" C3' C36"; $resn_exch{" O3* C36"}=" O3' C36"; $resn_exch{" C2* C36"}=" C2' C36";
$resn_exch{" C1* C36"}=" C1' C36"; $resn_exch{" O5* C37"}=" O5' C37"; $resn_exch{" C5* C37"}=" C5' C37";
$resn_exch{" C4* C37"}=" C4' C37"; $resn_exch{" O4* C37"}=" O4' C37"; $resn_exch{" C3* C37"}=" C3' C37";
$resn_exch{" O3* C37"}=" O3' C37"; $resn_exch{" C2* C37"}=" C2' C37"; $resn_exch{" C1* C37"}=" C1' C37";
$resn_exch{" O5* C38"}=" O5' C38"; $resn_exch{" C5* C38"}=" C5' C38"; $resn_exch{" C4* C38"}=" C4' C38";
$resn_exch{" O4* C38"}=" O4' C38"; $resn_exch{" C3* C38"}=" C3' C38"; $resn_exch{" O3* C38"}=" O3' C38";
$resn_exch{" C2* C38"}=" C2' C38"; $resn_exch{" C1* C38"}=" C1' C38"; $resn_exch{" O5* C3P"}=" O5' C3P";
$resn_exch{" C5* C3P"}=" C5' C3P"; $resn_exch{" C4* C3P"}=" C4' C3P"; $resn_exch{" O4* C3P"}=" O4' C3P";
$resn_exch{" C3* C3P"}=" C3' C3P"; $resn_exch{" O3* C3P"}=" O3' C3P"; $resn_exch{" C2* C3P"}=" C2' C3P";
$resn_exch{" O2* C3P"}=" O2' C3P"; $resn_exch{" C1* C3P"}=" C1' C3P"; $resn_exch{" C1* C42"}=" C1' C42";
$resn_exch{" C2* C42"}=" C2' C42"; $resn_exch{" C3* C42"}=" C3' C42"; $resn_exch{" C4* C42"}=" C4' C42";
$resn_exch{" O4* C42"}=" O4' C42"; $resn_exch{" C5* C42"}=" C5' C42"; $resn_exch{" O5* C42"}=" O5' C42";
$resn_exch{" O5* C43"}=" O5' C43"; $resn_exch{" C5* C43"}=" C5' C43"; $resn_exch{" C4* C43"}=" C4' C43";
$resn_exch{" O4* C43"}=" O4' C43"; $resn_exch{" C3* C43"}=" C3' C43"; $resn_exch{" O3* C43"}=" O3' C43";
$resn_exch{" C2* C43"}=" C2' C43"; $resn_exch{" O2* C43"}=" O2' C43"; $resn_exch{" C1* C43"}=" C1' C43";
$resn_exch{" CA* C43"}=" CA' C43"; $resn_exch{" CB* C43"}=" CB' C43"; $resn_exch{" CD* C43"}=" CD' C43";
$resn_exch{" OC* C43"}=" OC' C43"; $resn_exch{" C1* C45"}=" C1' C45"; $resn_exch{" C2* C45"}=" C2' C45";
$resn_exch{" C3* C45"}=" C3' C45"; $resn_exch{" C4* C45"}=" C4' C45"; $resn_exch{" O4* C45"}=" O4' C45";
$resn_exch{" O3* C45"}=" O3' C45"; $resn_exch{" C5* C45"}=" C5' C45"; $resn_exch{" O5* C45"}=" O5' C45";
$resn_exch{" O5* C46"}=" O5' C46"; $resn_exch{" C5* C46"}=" C5' C46"; $resn_exch{" C4* C46"}=" C4' C46";
$resn_exch{" O4* C46"}=" O4' C46"; $resn_exch{" C3* C46"}=" C3' C46"; $resn_exch{" O3* C46"}=" O3' C46";
$resn_exch{" C2* C46"}=" C2' C46"; $resn_exch{" C1* C46"}=" C1' C46"; $resn_exch{" O5* C49"}=" O5' C49";
$resn_exch{" C5* C49"}=" C5' C49"; $resn_exch{" C4* C49"}=" C4' C49"; $resn_exch{" O4* C49"}=" O4' C49";
$resn_exch{" C3* C49"}=" C3' C49"; $resn_exch{" O3* C49"}=" O3' C49"; $resn_exch{" C2* C49"}=" C2' C49";
$resn_exch{" C1* C49"}=" C1' C49"; $resn_exch{" C1* C5G"}=" C1D C5G"; $resn_exch{" C2* C5G"}=" C2D C5G";
$resn_exch{" O2* C5G"}=" O2D C5G"; $resn_exch{" C3* C5G"}=" C3D C5G"; $resn_exch{" C4* C5G"}=" C4D C5G";
$resn_exch{" O4* C5G"}=" O4D C5G"; $resn_exch{" O3* C5G"}=" O3D C5G"; $resn_exch{" C5* C5G"}=" C5D C5G";
$resn_exch{" O5* C5G"}=" O5D C5G"; $resn_exch{" O5* C5P"}=" O5' C5P"; $resn_exch{" C5* C5P"}=" C5' C5P";
$resn_exch{" C4* C5P"}=" C4' C5P"; $resn_exch{" O4* C5P"}=" O4' C5P"; $resn_exch{" C3* C5P"}=" C3' C5P";
$resn_exch{" O3* C5P"}=" O3' C5P"; $resn_exch{" C2* C5P"}=" C2' C5P"; $resn_exch{" O2* C5P"}=" O2' C5P";
$resn_exch{" C1* C5P"}=" C1' C5P"; $resn_exch{"0CT1 CA3"}=" C11 CA3"; $resn_exch{"0CT1 CA5"}=" C11 CA5";
$resn_exch{" AN1 CAA"}=" N1A CAA"; $resn_exch{" AC2 CAA"}=" C2A CAA"; $resn_exch{" AN3 CAA"}=" N3A CAA";
$resn_exch{" AC4 CAA"}=" C4A CAA"; $resn_exch{" AC5 CAA"}=" C5A CAA"; $resn_exch{" AC6 CAA"}=" C6A CAA";
$resn_exch{" AN6 CAA"}=" N6A CAA"; $resn_exch{" AN7 CAA"}=" N7A CAA"; $resn_exch{" AC8 CAA"}=" C8A CAA";
$resn_exch{" AN9 CAA"}=" N9A CAA"; $resn_exch{"AC1* CAA"}=" C1B CAA"; $resn_exch{"AC2* CAA"}=" C2B CAA";
$resn_exch{"AO2* CAA"}=" O2B CAA"; $resn_exch{"AC3* CAA"}=" C3B CAA"; $resn_exch{"AO3* CAA"}=" O3B CAA";
$resn_exch{"AP3* CAA"}=" P3B CAA"; $resn_exch{" AO7 CAA"}=" O7A CAA"; $resn_exch{" AO8 CAA"}=" O8A CAA";
$resn_exch{" AO9 CAA"}=" O9A CAA"; $resn_exch{"AC4* CAA"}=" C4B CAA"; $resn_exch{"AO4* CAA"}=" O4B CAA";
$resn_exch{"AC5* CAA"}=" C5B CAA"; $resn_exch{"AO5* CAA"}=" O5B CAA"; $resn_exch{" AP1 CAA"}=" P1A CAA";
$resn_exch{" AO1 CAA"}=" O1A CAA"; $resn_exch{" AO2 CAA"}=" O2A CAA"; $resn_exch{" AO3 CAA"}=" O3A CAA";
$resn_exch{" AP2 CAA"}=" P2A CAA"; $resn_exch{" AO4 CAA"}=" O4A CAA"; $resn_exch{" AO5 CAA"}=" O5A CAA";
$resn_exch{" AO6 CAA"}=" O6A CAA"; $resn_exch{"PC11 CAA"}=" CBP CAA"; $resn_exch{"PC12 CAA"}=" CCP CAA";
$resn_exch{"PC13 CAA"}=" CDP CAA"; $resn_exch{"PC14 CAA"}=" CEP CAA"; $resn_exch{"PC10 CAA"}=" CAP CAA";
$resn_exch{"PO10 CAA"}=" OAP CAA"; $resn_exch{" PC9 CAA"}=" C9P CAA"; $resn_exch{" PO9 CAA"}=" O9P CAA";
$resn_exch{" PN8 CAA"}=" N8P CAA"; $resn_exch{" PC7 CAA"}=" C7P CAA"; $resn_exch{" PC6 CAA"}=" C6P CAA";
$resn_exch{" PC5 CAA"}=" C5P CAA"; $resn_exch{" PO5 CAA"}=" O5P CAA"; $resn_exch{" PN4 CAA"}=" N4P CAA";
$resn_exch{" PC3 CAA"}=" C3P CAA"; $resn_exch{" PC2 CAA"}=" C2P CAA"; $resn_exch{" PS1 CAA"}=" S1P CAA";
$resn_exch{" O5* CAG"}=" O5' CAG"; $resn_exch{" C5* CAG"}=" C5B CAG"; $resn_exch{" C4* CAG"}=" C4B CAG";
$resn_exch{" O4* CAG"}=" O4' CAG"; $resn_exch{" C3* CAG"}=" C3B CAG"; $resn_exch{" O3* CAG"}=" O3' CAG";
$resn_exch{" C2* CAG"}=" C2B CAG"; $resn_exch{" O2* CAG"}=" O2' CAG"; $resn_exch{" C1* CAG"}=" C1B CAG";
$resn_exch{"1O2' CAG"}=" O'L CAG"; $resn_exch{"2O2' CAG"}=" O'M CAG"; $resn_exch{" AN1 CAO"}=" N1A CAO";
$resn_exch{" AC2 CAO"}=" C2A CAO"; $resn_exch{" AN3 CAO"}=" N3A CAO"; $resn_exch{" AC4 CAO"}=" C4A CAO";
$resn_exch{" AC5 CAO"}=" C5A CAO"; $resn_exch{" AC6 CAO"}=" C6A CAO"; $resn_exch{" AN6 CAO"}=" N6A CAO";
$resn_exch{" AN7 CAO"}=" N7A CAO"; $resn_exch{" AC8 CAO"}=" C8A CAO"; $resn_exch{" AN9 CAO"}=" N9A CAO";
$resn_exch{"AC1* CAO"}=" C1B CAO"; $resn_exch{"AC2* CAO"}=" C2B CAO"; $resn_exch{"AO2* CAO"}=" O2B CAO";
$resn_exch{"AC3* CAO"}=" C3B CAO"; $resn_exch{"AO3* CAO"}=" O3B CAO"; $resn_exch{"AP3* CAO"}=" P3B CAO";
$resn_exch{" AO7 CAO"}=" O7A CAO"; $resn_exch{" AO8 CAO"}=" O8A CAO"; $resn_exch{" AO9 CAO"}=" O9A CAO";
$resn_exch{"AC4* CAO"}=" C4B CAO"; $resn_exch{"AO4* CAO"}=" O4B CAO"; $resn_exch{"AC5* CAO"}=" C5B CAO";
$resn_exch{"AO5* CAO"}=" O5B CAO"; $resn_exch{" AP1 CAO"}=" P1A CAO"; $resn_exch{" AO1 CAO"}=" O1A CAO";
$resn_exch{" AO2 CAO"}=" O2A CAO"; $resn_exch{" AO3 CAO"}=" O3A CAO"; $resn_exch{" AP2 CAO"}=" P2A CAO";
$resn_exch{" AO4 CAO"}=" O4A CAO"; $resn_exch{" AO5 CAO"}=" O5A CAO"; $resn_exch{" AO6 CAO"}=" O6A CAO";
$resn_exch{"PC11 CAO"}=" CBP CAO"; $resn_exch{"PC12 CAO"}=" CCP CAO"; $resn_exch{"PC13 CAO"}=" CDP CAO";
$resn_exch{"PC14 CAO"}=" CEP CAO"; $resn_exch{"PC10 CAO"}=" CAP CAO"; $resn_exch{"PO10 CAO"}=" OAP CAO";
$resn_exch{" PC9 CAO"}=" C9P CAO"; $resn_exch{" PO9 CAO"}=" O9P CAO"; $resn_exch{" PN8 CAO"}=" N8P CAO";
$resn_exch{" PC7 CAO"}=" C7P CAO"; $resn_exch{" PC6 CAO"}=" C6P CAO"; $resn_exch{" PC5 CAO"}=" C5P CAO";
$resn_exch{" PO5 CAO"}=" O5P CAO"; $resn_exch{" PN4 CAO"}=" N4P CAO"; $resn_exch{" PC3 CAO"}=" C3P CAO";
$resn_exch{" PC2 CAO"}=" C2P CAO"; $resn_exch{" PS1 CAO"}=" S1P CAO"; $resn_exch{" PO1 CAO"}=" O1P CAO";
$resn_exch{" O1P CAR"}=" OP1 CAR"; $resn_exch{" O2P CAR"}=" OP2 CAR"; $resn_exch{" O3P CAR"}=" OP3 CAR";
$resn_exch{" O5* CAR"}=" O5' CAR"; $resn_exch{" C5* CAR"}=" C5' CAR"; $resn_exch{" C4* CAR"}=" C4' CAR";
$resn_exch{" O4* CAR"}=" O4' CAR"; $resn_exch{" C3* CAR"}=" C3' CAR"; $resn_exch{" O3* CAR"}=" O3' CAR";
$resn_exch{" C2* CAR"}=" C2' CAR"; $resn_exch{" O2* CAR"}=" O2' CAR"; $resn_exch{" C1* CAR"}=" C1' CAR";
$resn_exch{" CA* CAV"}=" CA' CAV"; $resn_exch{" CB* CAV"}=" CB' CAV"; $resn_exch{" O3* CB2"}=" O3' CB2";
$resn_exch{" C3* CB2"}=" C3' CB2"; $resn_exch{" C2* CB2"}=" C2' CB2"; $resn_exch{" O2* CB2"}=" O2' CB2";
$resn_exch{" C1* CB2"}=" C1' CB2"; $resn_exch{" O4* CB2"}=" O4' CB2"; $resn_exch{" C4* CB2"}=" C4' CB2";
$resn_exch{" C5* CB2"}=" C5' CB2"; $resn_exch{" O5* CB2"}=" O5' CB2"; $resn_exch{" O1P CB2"}=" OP1 CB2";
$resn_exch{" O2P CB2"}=" OP2 CB2"; $resn_exch{" O3P CB2"}=" OP3 CB2"; $resn_exch{" O1P CBR"}=" OP1 CBR";
$resn_exch{" O2P CBR"}=" OP2 CBR"; $resn_exch{" O5* CBR"}=" O5' CBR"; $resn_exch{" C2* CBR"}=" C2' CBR";
$resn_exch{" C5* CBR"}=" C5' CBR"; $resn_exch{" C4* CBR"}=" C4' CBR"; $resn_exch{" O4* CBR"}=" O4' CBR";
$resn_exch{" C1* CBR"}=" C1' CBR"; $resn_exch{" C3* CBR"}=" C3' CBR"; $resn_exch{" O3* CBR"}=" O3' CBR";
$resn_exch{" O3P CBR"}=" OP3 CBR"; $resn_exch{" AC1 CBS"}=" C1A CBS"; $resn_exch{" AC2 CBS"}=" C2A CBS";
$resn_exch{" AC3 CBS"}=" C3A CBS"; $resn_exch{" AC4 CBS"}=" C4A CBS"; $resn_exch{" AC5 CBS"}=" C5A CBS";
$resn_exch{" AC6 CBS"}=" C6A CBS"; $resn_exch{" AC7 CBS"}=" C7A CBS"; $resn_exch{" AC8 CBS"}=" C8A CBS";
$resn_exch{" AN2 CBS"}=" N2A CBS"; $resn_exch{" AO1 CBS"}=" O1A CBS"; $resn_exch{" AO3 CBS"}=" O3A CBS";
$resn_exch{" AO4 CBS"}=" O4A CBS"; $resn_exch{" AO5 CBS"}=" O5A CBS"; $resn_exch{" AO6 CBS"}=" O6A CBS";
$resn_exch{" AO7 CBS"}=" O7A CBS"; $resn_exch{" BC1 CBS"}=" C1B CBS"; $resn_exch{" BC2 CBS"}=" C2B CBS";
$resn_exch{" BC3 CBS"}=" C3B CBS"; $resn_exch{" BC4 CBS"}=" C4B CBS"; $resn_exch{" BC5 CBS"}=" C5B CBS";
$resn_exch{" BC6 CBS"}=" C6B CBS"; $resn_exch{" BC7 CBS"}=" C7B CBS"; $resn_exch{" BC8 CBS"}=" C8B CBS";
$resn_exch{" BN2 CBS"}=" N2B CBS"; $resn_exch{" BO1 CBS"}=" O1B CBS"; $resn_exch{" BO3 CBS"}=" O3B CBS";
$resn_exch{" BO5 CBS"}=" O5B CBS"; $resn_exch{" BO6 CBS"}=" O6B CBS"; $resn_exch{" BO7 CBS"}=" O7B CBS";
$resn_exch{" O5* CBV"}=" O5' CBV"; $resn_exch{" C5* CBV"}=" C5' CBV"; $resn_exch{" C4* CBV"}=" C4' CBV";
$resn_exch{" O4* CBV"}=" O4' CBV"; $resn_exch{" C3* CBV"}=" C3' CBV"; $resn_exch{" O3* CBV"}=" O3' CBV";
$resn_exch{" C2* CBV"}=" C2' CBV"; $resn_exch{" O2* CBV"}=" O2' CBV"; $resn_exch{" C1* CBV"}=" C1' CBV";
$resn_exch{" O1P CCC"}=" OP1 CCC"; $resn_exch{" O2P CCC"}=" OP2 CCC"; $resn_exch{" O3P CCC"}=" OP3 CCC";
$resn_exch{" O5* CCC"}=" O5' CCC"; $resn_exch{" C5* CCC"}=" C5' CCC"; $resn_exch{" C4* CCC"}=" C4' CCC";
$resn_exch{" O4* CCC"}=" O4' CCC"; $resn_exch{" C3* CCC"}=" C3' CCC"; $resn_exch{" O3* CCC"}=" O3' CCC";
$resn_exch{" C2* CCC"}=" C2' CCC"; $resn_exch{" O2* CCC"}=" O2' CCC"; $resn_exch{" C1* CCC"}=" C1' CCC";
$resn_exch{" N_A CCH"}=" NA  CCH"; $resn_exch{" N_B CCH"}=" NB  CCH"; $resn_exch{" N_C CCH"}=" NC  CCH";
$resn_exch{" N_D CCH"}=" ND  CCH"; $resn_exch{" PS1 CCQ"}=" S1P CCQ"; $resn_exch{" PC2 CCQ"}=" C2P CCQ";
$resn_exch{" PC3 CCQ"}=" C3P CCQ"; $resn_exch{" PN4 CCQ"}=" N4P CCQ"; $resn_exch{" PC5 CCQ"}=" C5P CCQ";
$resn_exch{" PO5 CCQ"}=" O5P CCQ"; $resn_exch{" PC6 CCQ"}=" C6P CCQ"; $resn_exch{" PC7 CCQ"}=" C7P CCQ";
$resn_exch{" PN8 CCQ"}=" N8P CCQ"; $resn_exch{" PC9 CCQ"}=" C9P CCQ"; $resn_exch{" PO9 CCQ"}=" O9P CCQ";
$resn_exch{"PC10 CCQ"}=" CAP CCQ"; $resn_exch{"PO10 CCQ"}=" OAP CCQ"; $resn_exch{"PC11 CCQ"}=" CBP CCQ";
$resn_exch{"PC13 CCQ"}=" CDP CCQ"; $resn_exch{"PC14 CCQ"}=" CEP CCQ"; $resn_exch{"PC12 CCQ"}=" CCP CCQ";
$resn_exch{" AO6 CCQ"}=" O6A CCQ"; $resn_exch{" AP2 CCQ"}=" P2A CCQ"; $resn_exch{" AO4 CCQ"}=" O4A CCQ";
$resn_exch{" AO5 CCQ"}=" O5A CCQ"; $resn_exch{" AO3 CCQ"}=" O3A CCQ"; $resn_exch{" AP1 CCQ"}=" P1A CCQ";
$resn_exch{" AO1 CCQ"}=" O1A CCQ"; $resn_exch{" AO2 CCQ"}=" O2A CCQ"; $resn_exch{"AO5* CCQ"}=" O5D CCQ";
$resn_exch{"AC5* CCQ"}=" C5D CCQ"; $resn_exch{"AC4* CCQ"}=" C4D CCQ"; $resn_exch{"AC3* CCQ"}=" C3D CCQ";
$resn_exch{"AO3* CCQ"}=" O3D CCQ"; $resn_exch{"AP3* CCQ"}=" P3D CCQ"; $resn_exch{" AO7 CCQ"}=" O7A CCQ";
$resn_exch{" AO8 CCQ"}=" O8A CCQ"; $resn_exch{" AO9 CCQ"}=" O9A CCQ"; $resn_exch{"AC2* CCQ"}=" C2D CCQ";
$resn_exch{"AO2* CCQ"}=" O2D CCQ"; $resn_exch{"AC1* CCQ"}=" C1D CCQ"; $resn_exch{"AO4* CCQ"}=" O4D CCQ";
$resn_exch{" AN9 CCQ"}=" N9A CCQ"; $resn_exch{" AC4 CCQ"}=" C4A CCQ"; $resn_exch{" AC5 CCQ"}=" C5X CCQ";
$resn_exch{" AN7 CCQ"}=" N7A CCQ"; $resn_exch{" AC8 CCQ"}=" C8A CCQ"; $resn_exch{" AC6 CCQ"}=" C6A CCQ";
$resn_exch{" AN6 CCQ"}=" N6A CCQ"; $resn_exch{" AN1 CCQ"}=" N1A CCQ"; $resn_exch{" AC2 CCQ"}=" C2A CCQ";
$resn_exch{" AN3 CCQ"}=" N3A CCQ"; $resn_exch{" C1* CDC"}=" C1' CDC"; $resn_exch{" C2* CDC"}=" C2' CDC";
$resn_exch{" O2* CDC"}=" O2' CDC"; $resn_exch{" C3* CDC"}=" C3' CDC"; $resn_exch{" C4* CDC"}=" C4' CDC";
$resn_exch{" O4* CDC"}=" O4' CDC"; $resn_exch{" O3* CDC"}=" O3' CDC"; $resn_exch{" C5* CDC"}=" C5' CDC";
$resn_exch{" O5* CDC"}=" O5' CDC"; $resn_exch{" O5* CDF"}=" O5' CDF"; $resn_exch{" C5* CDF"}=" C5' CDF";
$resn_exch{" C4* CDF"}=" C4' CDF"; $resn_exch{" O4* CDF"}=" O4' CDF"; $resn_exch{" C3* CDF"}=" C3' CDF";
$resn_exch{" O3* CDF"}=" O3' CDF"; $resn_exch{" C2* CDF"}=" C2' CDF"; $resn_exch{" O2* CDF"}=" O2' CDF";
$resn_exch{" C1* CDF"}=" C1' CDF"; $resn_exch{" C1* CDM"}=" C1' CDM"; $resn_exch{" C2* CDM"}=" C2' CDM";
$resn_exch{" O2* CDM"}=" O2' CDM"; $resn_exch{" C3* CDM"}=" C3' CDM"; $resn_exch{" C4* CDM"}=" C4' CDM";
$resn_exch{" O4* CDM"}=" O4' CDM"; $resn_exch{" O3* CDM"}=" O3' CDM"; $resn_exch{" C5* CDM"}=" C5' CDM";
$resn_exch{" O5* CDM"}=" O5' CDM"; $resn_exch{" C1* CDP"}=" C1' CDP"; $resn_exch{" C2* CDP"}=" C2' CDP";
$resn_exch{" O2* CDP"}=" O2' CDP"; $resn_exch{" C3* CDP"}=" C3' CDP"; $resn_exch{" C4* CDP"}=" C4' CDP";
$resn_exch{" O4* CDP"}=" O4' CDP"; $resn_exch{" O3* CDP"}=" O3' CDP"; $resn_exch{" C5* CDP"}=" C5' CDP";
$resn_exch{" O5* CDP"}=" O5' CDP"; $resn_exch{" O5* CDY"}=" O5' CDY"; $resn_exch{" C5* CDY"}=" C5' CDY";
$resn_exch{" C4* CDY"}=" C4' CDY"; $resn_exch{" O4* CDY"}=" O4' CDY"; $resn_exch{" C3* CDY"}=" C3' CDY";
$resn_exch{" C2* CDY"}=" C2' CDY"; $resn_exch{" C1* CDY"}=" C1' CDY"; $resn_exch{" O5* CFL"}=" O5' CFL";
$resn_exch{" C5* CFL"}=" C5' CFL"; $resn_exch{" C4* CFL"}=" C4' CFL"; $resn_exch{" O4* CFL"}=" O4' CFL";
$resn_exch{" C3* CFL"}=" C3' CFL"; $resn_exch{" O3* CFL"}=" O3' CFL"; $resn_exch{" C2* CFL"}=" C2' CFL";
$resn_exch{" C1* CFL"}=" C1' CFL"; $resn_exch{" CA* CG2"}=" CA' CG2"; $resn_exch{" CB* CG2"}=" CB' CG2";
$resn_exch{" OB* CG2"}=" OB' CG2"; $resn_exch{" CC* CG2"}=" CC' CG2"; $resn_exch{" OC* CG2"}=" OC' CG2";
$resn_exch{" CD* CG2"}=" CD' CG2"; $resn_exch{" OD* CG2"}=" OD' CG2"; $resn_exch{" CE* CG2"}=" CE' CG2";
$resn_exch{" OE* CG2"}=" OE' CG2"; $resn_exch{" O5* CG2"}=" O5' CG2"; $resn_exch{" C5* CG2"}=" C5' CG2";
$resn_exch{" C4* CG2"}=" C4' CG2"; $resn_exch{" O4* CG2"}=" O4' CG2"; $resn_exch{" C3* CG2"}=" C3' CG2";
$resn_exch{" O3* CG2"}=" O3' CG2"; $resn_exch{" C2* CG2"}=" C2' CG2"; $resn_exch{" O2* CG2"}=" O2' CG2";
$resn_exch{" C1* CG2"}=" C1' CG2"; $resn_exch{"CO5* CGP"}=" O5B CGP"; $resn_exch{"CC5* CGP"}=" C5X CGP";
$resn_exch{"CC4* CGP"}=" C4X CGP"; $resn_exch{"CO4* CGP"}=" O4B CGP"; $resn_exch{"CC3* CGP"}=" C3X CGP";
$resn_exch{"CO3* CGP"}=" O3B CGP"; $resn_exch{"CC2* CGP"}=" C2X CGP"; $resn_exch{"CC1* CGP"}=" C1X CGP";
$resn_exch{" CN1 CGP"}=" N1C CGP"; $resn_exch{" CN3 CGP"}=" N3C CGP"; $resn_exch{" CO2 CGP"}=" O2C CGP";
$resn_exch{" CN4 CGP"}=" N4C CGP"; $resn_exch{"GO5* CGP"}=" O5D CGP"; $resn_exch{"GC5* CGP"}=" C5D CGP";
$resn_exch{"GC4* CGP"}=" C4D CGP"; $resn_exch{"GO4* CGP"}=" O4D CGP"; $resn_exch{"GC3* CGP"}=" C3D CGP";
$resn_exch{"GO3* CGP"}=" O3D CGP"; $resn_exch{"GC2* CGP"}=" C2D CGP"; $resn_exch{"GC1* CGP"}=" C1D CGP";
$resn_exch{" GN9 CGP"}=" N9G CGP"; $resn_exch{" GC8 CGP"}=" C8G CGP"; $resn_exch{" GN7 CGP"}=" N7G CGP";
$resn_exch{" GC5 CGP"}=" C5G CGP"; $resn_exch{" GC6 CGP"}=" C6G CGP"; $resn_exch{" GO6 CGP"}=" O6G CGP";
$resn_exch{" GN1 CGP"}=" N1G CGP"; $resn_exch{" GC2 CGP"}=" C2G CGP"; $resn_exch{" GN2 CGP"}=" N2G CGP";
$resn_exch{" GN3 CGP"}=" N3G CGP"; $resn_exch{" GC4 CGP"}=" C4G CGP"; $resn_exch{"RO5* CGR"}="O5'R CGR";
$resn_exch{"RC5* CGR"}="C5'R CGR"; $resn_exch{"RC4* CGR"}="C4'R CGR"; $resn_exch{"RO4* CGR"}="O4'R CGR";
$resn_exch{"RC1* CGR"}="C1'R CGR"; $resn_exch{"RC2* CGR"}="C2'R CGR"; $resn_exch{"RO2* CGR"}="O2'R CGR";
$resn_exch{"RC3* CGR"}="C3'R CGR"; $resn_exch{"RO3* CGR"}="O3'R CGR"; $resn_exch{" C1* CGR"}=" C1' CGR";
$resn_exch{" O4* CGR"}=" O4' CGR"; $resn_exch{" C2* CGR"}=" C2' CGR"; $resn_exch{" O2* CGR"}=" O2' CGR";
$resn_exch{" C3* CGR"}=" C3' CGR"; $resn_exch{" O3* CGR"}=" O3' CGR"; $resn_exch{" C4* CGR"}=" C4' CGR";
$resn_exch{" C5* CGR"}=" C5' CGR"; $resn_exch{" O5* CGR"}=" O5' CGR"; $resn_exch{"OE1  CGU"}="OE11 CGU";
$resn_exch{"OE2  CGU"}="OE12 CGU"; $resn_exch{"OE3  CGU"}="OE21 CGU"; $resn_exch{"OE4  CGU"}="OE22 CGU";
$resn_exch{" O3P  CH"}=" OP3  CH"; $resn_exch{" O1P  CH"}=" OP1  CH"; $resn_exch{" O2P  CH"}=" OP2  CH";
$resn_exch{" O5*  CH"}=" O5'  CH"; $resn_exch{" C5*  CH"}=" C5'  CH"; $resn_exch{" C4*  CH"}=" C4'  CH";
$resn_exch{" O4*  CH"}=" O4'  CH"; $resn_exch{" C3*  CH"}=" C3'  CH"; $resn_exch{" O3*  CH"}=" O3'  CH";
$resn_exch{" C2*  CH"}=" C2'  CH"; $resn_exch{" O2*  CH"}=" O2'  CH"; $resn_exch{" C1*  CH"}=" C1'  CH";
$resn_exch{" C1* CH1"}=" C1' CH1"; $resn_exch{" C2* CH1"}=" C2' CH1"; $resn_exch{" O2* CH1"}=" O2' CH1";
$resn_exch{" C3* CH1"}=" C3' CH1"; $resn_exch{" C4* CH1"}=" C4' CH1"; $resn_exch{" O4* CH1"}=" O4' CH1";
$resn_exch{" C5* CH1"}=" C5' CH1"; $resn_exch{" O5* CH1"}=" O5' CH1"; $resn_exch{" N_A CHL"}=" NA  CHL";
$resn_exch{" N_B CHL"}=" NB  CHL"; $resn_exch{" N_C CHL"}=" NC  CHL"; $resn_exch{" N_D CHL"}=" ND  CHL";
$resn_exch{" AN1 CIC"}=" N1A CIC"; $resn_exch{" AC2 CIC"}=" C2A CIC"; $resn_exch{" AN3 CIC"}=" N3A CIC";
$resn_exch{" AC4 CIC"}=" C4A CIC"; $resn_exch{" AC5 CIC"}=" C5A CIC"; $resn_exch{" AC6 CIC"}=" C6A CIC";
$resn_exch{" AN6 CIC"}=" N6A CIC"; $resn_exch{" AN7 CIC"}=" N7A CIC"; $resn_exch{" AC8 CIC"}=" C8A CIC";
$resn_exch{" AN9 CIC"}=" N9A CIC"; $resn_exch{"AC1* CIC"}=" C1B CIC"; $resn_exch{"AC2* CIC"}=" C2B CIC";
$resn_exch{"AO2* CIC"}=" O2B CIC"; $resn_exch{"AC3* CIC"}=" C3B CIC"; $resn_exch{"AO3* CIC"}=" O3B CIC";
$resn_exch{"AP3* CIC"}=" P3B CIC"; $resn_exch{" AO7 CIC"}=" O7A CIC"; $resn_exch{" AO8 CIC"}=" O8A CIC";
$resn_exch{" AO9 CIC"}=" O9A CIC"; $resn_exch{"AC4* CIC"}=" C4B CIC"; $resn_exch{"AO4* CIC"}=" O4B CIC";
$resn_exch{"AC5* CIC"}=" C5B CIC"; $resn_exch{"AO5* CIC"}=" O5B CIC"; $resn_exch{" AP1 CIC"}=" P1A CIC";
$resn_exch{" AO1 CIC"}=" O1A CIC"; $resn_exch{" AO2 CIC"}=" O2A CIC"; $resn_exch{" AO3 CIC"}=" O3A CIC";
$resn_exch{" AP2 CIC"}=" P2A CIC"; $resn_exch{" AO4 CIC"}=" O4A CIC"; $resn_exch{" AO5 CIC"}=" O5A CIC";
$resn_exch{" AO6 CIC"}=" O6A CIC"; $resn_exch{"PC11 CIC"}=" CBP CIC"; $resn_exch{"PC12 CIC"}=" CCP CIC";
$resn_exch{"PC13 CIC"}=" CDP CIC"; $resn_exch{"PC14 CIC"}=" CEP CIC"; $resn_exch{"PC10 CIC"}=" CAP CIC";
$resn_exch{"PO10 CIC"}=" OAP CIC"; $resn_exch{" PC9 CIC"}=" C9P CIC"; $resn_exch{" PO9 CIC"}=" O9P CIC";
$resn_exch{" PN8 CIC"}=" N8P CIC"; $resn_exch{" PC7 CIC"}=" C7P CIC"; $resn_exch{" PC6 CIC"}=" C6P CIC";
$resn_exch{" PC5 CIC"}=" C5P CIC"; $resn_exch{" PO5 CIC"}=" O5P CIC"; $resn_exch{" PN4 CIC"}=" N4P CIC";
$resn_exch{" PC3 CIC"}=" C3P CIC"; $resn_exch{" PC2 CIC"}=" C2P CIC"; $resn_exch{" PS1 CIC"}=" S1P CIC";
$resn_exch{" PC1 CIC"}=" C1P CIC"; $resn_exch{"O11A CIE"}=" OBA CIE"; $resn_exch{"O11B CIE"}=" OBB CIE";
$resn_exch{" N_A CL1"}=" NA  CL1"; $resn_exch{" N_B CL1"}=" NB  CL1"; $resn_exch{" N_C CL1"}=" NC  CL1";
$resn_exch{" N_D CL1"}=" ND  CL1"; $resn_exch{" N_A CL2"}=" NA  CL2"; $resn_exch{" N_B CL2"}=" NB  CL2";
$resn_exch{" N_C CL2"}=" NC  CL2"; $resn_exch{" N_D CL2"}=" ND  CL2"; $resn_exch{" N_A CLA"}=" NA  CLA";
$resn_exch{" N_B CLA"}=" NB  CLA"; $resn_exch{" N_C CLA"}=" NC  CLA"; $resn_exch{" N_D CLA"}=" ND  CLA";
$resn_exch{"CL1A CLM"}="CL1  CLM"; $resn_exch{"CL1B CLM"}="CL2  CLM"; $resn_exch{" N_A CLN"}=" NA  CLN";
$resn_exch{" N_B CLN"}=" NB  CLN"; $resn_exch{" N_C CLN"}=" NC  CLN"; $resn_exch{" N_D CLN"}=" ND  CLN";
$resn_exch{" O5* CM0"}=" O5' CM0"; $resn_exch{" C3* CM0"}=" C3' CM0"; $resn_exch{" C5* CM0"}=" C5' CM0";
$resn_exch{" C4* CM0"}=" C4' CM0"; $resn_exch{" O4* CM0"}=" O4' CM0"; $resn_exch{" C2* CM0"}=" C2' CM0";
$resn_exch{" C1* CM0"}=" C1' CM0"; $resn_exch{" O2* CM0"}=" O2' CM0"; $resn_exch{" O3* CM0"}=" O3' CM0";
$resn_exch{" AN1 CMC"}=" N1A CMC"; $resn_exch{" AC2 CMC"}=" C2A CMC"; $resn_exch{" AN3 CMC"}=" N3A CMC";
$resn_exch{" AC4 CMC"}=" C4A CMC"; $resn_exch{" AC5 CMC"}=" C5A CMC"; $resn_exch{" AC6 CMC"}=" C6A CMC";
$resn_exch{" AN6 CMC"}=" N6A CMC"; $resn_exch{" AN7 CMC"}=" N7A CMC"; $resn_exch{" AC8 CMC"}=" C8A CMC";
$resn_exch{" AN9 CMC"}=" N9A CMC"; $resn_exch{"AC1* CMC"}=" C1B CMC"; $resn_exch{"AC2* CMC"}=" C2B CMC";
$resn_exch{"AO2* CMC"}=" O2B CMC"; $resn_exch{"AC3* CMC"}=" C3B CMC"; $resn_exch{"AO3* CMC"}=" O3B CMC";
$resn_exch{"AP3* CMC"}=" P3B CMC"; $resn_exch{" AO7 CMC"}=" O7A CMC"; $resn_exch{" AO8 CMC"}=" O8A CMC";
$resn_exch{" AO9 CMC"}=" O9A CMC"; $resn_exch{"AC4* CMC"}=" C4B CMC"; $resn_exch{"AO4* CMC"}=" O4B CMC";
$resn_exch{"AC5* CMC"}=" C5B CMC"; $resn_exch{"AO5* CMC"}=" O5B CMC"; $resn_exch{" AP1 CMC"}=" P1A CMC";
$resn_exch{" AO1 CMC"}=" O1A CMC"; $resn_exch{" AO2 CMC"}=" O2A CMC"; $resn_exch{" AO3 CMC"}=" O3A CMC";
$resn_exch{" AP2 CMC"}=" P2A CMC"; $resn_exch{" AO4 CMC"}=" O4A CMC"; $resn_exch{" AO5 CMC"}=" O5A CMC";
$resn_exch{" AO6 CMC"}=" O6A CMC"; $resn_exch{"PC11 CMC"}=" CBP CMC"; $resn_exch{"PC12 CMC"}=" CCP CMC";
$resn_exch{"PC13 CMC"}=" CDP CMC"; $resn_exch{"PC14 CMC"}=" CEP CMC"; $resn_exch{"PC10 CMC"}=" CAP CMC";
$resn_exch{"PO10 CMC"}=" OAP CMC"; $resn_exch{" PC9 CMC"}=" C9P CMC"; $resn_exch{" PO9 CMC"}=" O9P CMC";
$resn_exch{" PN8 CMC"}=" N8P CMC"; $resn_exch{" PC7 CMC"}=" C7P CMC"; $resn_exch{" PC6 CMC"}=" C6P CMC";
$resn_exch{" PC5 CMC"}=" C5P CMC"; $resn_exch{" PO5 CMC"}=" O5P CMC"; $resn_exch{" PN4 CMC"}=" N4P CMC";
$resn_exch{" PC3 CMC"}=" C3P CMC"; $resn_exch{" PC2 CMC"}=" C2P CMC"; $resn_exch{" PS1 CMC"}=" S1P CMC";
$resn_exch{" C1* CMD"}=" C1' CMD"; $resn_exch{" C2* CMD"}=" C2' CMD"; $resn_exch{" C3* CMD"}=" C3' CMD";
$resn_exch{" C4* CMD"}=" C4' CMD"; $resn_exch{" O4* CMD"}=" O4' CMD"; $resn_exch{" C5* CMD"}=" C5' CMD";
$resn_exch{" O5* CMD"}=" O5' CMD"; $resn_exch{" C6* CMD"}=" C6' CMD"; $resn_exch{" N3* CMD"}=" N3' CMD";
$resn_exch{" C1* CMK"}=" C1' CMK"; $resn_exch{" C2* CMK"}=" C2' CMK"; $resn_exch{" O2* CMK"}=" O2' CMK";
$resn_exch{" C3* CMK"}=" C3' CMK"; $resn_exch{" C4* CMK"}=" C4' CMK"; $resn_exch{" O4* CMK"}=" O4' CMK";
$resn_exch{" O3* CMK"}=" O3' CMK"; $resn_exch{" C5* CMK"}=" C5' CMK"; $resn_exch{" O5* CMK"}=" O5' CMK";
$resn_exch{" O5* CMP"}=" O5' CMP"; $resn_exch{" C5* CMP"}=" C5' CMP"; $resn_exch{" C4* CMP"}=" C4' CMP";
$resn_exch{" O4* CMP"}=" O4' CMP"; $resn_exch{" C3* CMP"}=" C3' CMP"; $resn_exch{" O3* CMP"}=" O3' CMP";
$resn_exch{" C2* CMP"}=" C2' CMP"; $resn_exch{" O2* CMP"}=" O2' CMP"; $resn_exch{" C1* CMP"}=" C1' CMP";
$resn_exch{" O1P CMR"}=" OP1 CMR"; $resn_exch{" O5* CMR"}=" O5' CMR"; $resn_exch{" C5* CMR"}=" C5' CMR";
$resn_exch{" C4* CMR"}=" C4' CMR"; $resn_exch{" O4* CMR"}=" O4' CMR"; $resn_exch{" C1* CMR"}=" C1' CMR";
$resn_exch{" C3* CMR"}=" C3' CMR"; $resn_exch{" C2* CMR"}=" C2' CMR"; $resn_exch{" O3* CMR"}=" O3' CMR";
$resn_exch{" O3P CMR"}=" OP3 CMR"; $resn_exch{" AN1 CMX"}=" N1A CMX"; $resn_exch{" AC2 CMX"}=" C2A CMX";
$resn_exch{" AN3 CMX"}=" N3A CMX"; $resn_exch{" AC4 CMX"}=" C4A CMX"; $resn_exch{" AC5 CMX"}=" C5A CMX";
$resn_exch{" AC6 CMX"}=" C6A CMX"; $resn_exch{" AN6 CMX"}=" N6A CMX"; $resn_exch{" AN7 CMX"}=" N7A CMX";
$resn_exch{" AC8 CMX"}=" C8A CMX"; $resn_exch{" AN9 CMX"}=" N9A CMX"; $resn_exch{"AC1* CMX"}=" C1B CMX";
$resn_exch{"AC2* CMX"}=" C2B CMX"; $resn_exch{"AO2* CMX"}=" O2B CMX"; $resn_exch{"AC3* CMX"}=" C3B CMX";
$resn_exch{"AO3* CMX"}=" O3B CMX"; $resn_exch{"AP3* CMX"}=" P3B CMX"; $resn_exch{" AO7 CMX"}=" O7A CMX";
$resn_exch{" AO8 CMX"}=" O8A CMX"; $resn_exch{" AO9 CMX"}=" O9A CMX"; $resn_exch{"AC4* CMX"}=" C4B CMX";
$resn_exch{"AO4* CMX"}=" O4B CMX"; $resn_exch{"AC5* CMX"}=" C5B CMX"; $resn_exch{"AO5* CMX"}=" O5B CMX";
$resn_exch{" AP1 CMX"}=" P1A CMX"; $resn_exch{" AO1 CMX"}=" O1A CMX"; $resn_exch{" AO2 CMX"}=" O2A CMX";
$resn_exch{" AO3 CMX"}=" O3A CMX"; $resn_exch{" AP2 CMX"}=" P2A CMX"; $resn_exch{" AO4 CMX"}=" O4A CMX";
$resn_exch{" AO5 CMX"}=" O5A CMX"; $resn_exch{" AO6 CMX"}=" O6A CMX"; $resn_exch{"PC11 CMX"}=" CBP CMX";
$resn_exch{"PC12 CMX"}=" CCP CMX"; $resn_exch{"PC13 CMX"}=" CDP CMX"; $resn_exch{"PC14 CMX"}=" CEP CMX";
$resn_exch{"PC10 CMX"}=" CAP CMX"; $resn_exch{"PO10 CMX"}=" OAP CMX"; $resn_exch{" PC9 CMX"}=" C9P CMX";
$resn_exch{" PO9 CMX"}=" O9P CMX"; $resn_exch{" PN8 CMX"}=" N8P CMX"; $resn_exch{" PC7 CMX"}=" C7P CMX";
$resn_exch{" PC6 CMX"}=" C6P CMX"; $resn_exch{" PC5 CMX"}=" C5P CMX"; $resn_exch{" PO5 CMX"}=" O5P CMX";
$resn_exch{" PN4 CMX"}=" N4P CMX"; $resn_exch{" PC3 CMX"}=" C3P CMX"; $resn_exch{" PC2 CMX"}=" C2P CMX";
$resn_exch{" AP  CNA"}=" PA  CNA"; $resn_exch{" AO1 CNA"}=" O1A CNA"; $resn_exch{" AO2 CNA"}=" O2A CNA";
$resn_exch{"AO5* CNA"}=" O5B CNA"; $resn_exch{"AC5* CNA"}=" C5B CNA"; $resn_exch{"AC4* CNA"}=" C4B CNA";
$resn_exch{"AO4* CNA"}=" O4B CNA"; $resn_exch{"AC3* CNA"}=" C3B CNA"; $resn_exch{"AO3* CNA"}=" O3B CNA";
$resn_exch{"AC2* CNA"}=" C2B CNA"; $resn_exch{"AO2* CNA"}=" O2B CNA"; $resn_exch{"AC1* CNA"}=" C1B CNA";
$resn_exch{" AN9 CNA"}=" N9A CNA"; $resn_exch{" AC8 CNA"}=" C8A CNA"; $resn_exch{" AN7 CNA"}=" N7A CNA";
$resn_exch{" AC5 CNA"}=" C5A CNA"; $resn_exch{" AC6 CNA"}=" C6A CNA"; $resn_exch{" AN6 CNA"}=" N6A CNA";
$resn_exch{" AN1 CNA"}=" N1A CNA"; $resn_exch{" AC2 CNA"}=" C2A CNA"; $resn_exch{" AN3 CNA"}=" N3A CNA";
$resn_exch{" AC4 CNA"}=" C4A CNA"; $resn_exch{" NP  CNA"}=" PN  CNA"; $resn_exch{" NO1 CNA"}=" O1N CNA";
$resn_exch{" NO2 CNA"}=" O2N CNA"; $resn_exch{"NO5* CNA"}=" O5D CNA"; $resn_exch{"NC5* CNA"}=" C5D CNA";
$resn_exch{"NC4* CNA"}=" C4D CNA"; $resn_exch{" C4* CNA"}=" C4' CNA"; $resn_exch{"NC3* CNA"}=" C3D CNA";
$resn_exch{"NO3* CNA"}=" O3D CNA"; $resn_exch{"NC2* CNA"}=" C2D CNA"; $resn_exch{"NO2* CNA"}=" O2D CNA";
$resn_exch{"NC1* CNA"}=" C1D CNA"; $resn_exch{" NN1 CNA"}=" N1N CNA"; $resn_exch{" NC2 CNA"}=" C2N CNA";
$resn_exch{" NC3 CNA"}=" C3N CNA"; $resn_exch{" NC7 CNA"}=" C7N CNA"; $resn_exch{" NO7 CNA"}=" O7N CNA";
$resn_exch{" NN7 CNA"}=" N7N CNA"; $resn_exch{" NC4 CNA"}=" C4N CNA"; $resn_exch{" NC5 CNA"}=" C5N CNA";
$resn_exch{" NC6 CNA"}=" C6N CNA"; $resn_exch{" AP  CND"}=" PA  CND"; $resn_exch{" AO1 CND"}=" O1A CND";
$resn_exch{" AO2 CND"}=" O2A CND"; $resn_exch{"AO5* CND"}=" O5B CND"; $resn_exch{"AC5* CND"}=" C5B CND";
$resn_exch{"AC4* CND"}=" C4B CND"; $resn_exch{"AO4* CND"}=" O4B CND"; $resn_exch{"AC3* CND"}=" C3B CND";
$resn_exch{"AO3* CND"}=" O3B CND"; $resn_exch{"AC2* CND"}=" C2B CND"; $resn_exch{"AO2* CND"}=" O2B CND";
$resn_exch{"AC1* CND"}=" C1B CND"; $resn_exch{" AN9 CND"}=" N9A CND"; $resn_exch{" AC8 CND"}=" C8A CND";
$resn_exch{" AN7 CND"}=" N7A CND"; $resn_exch{" AC5 CND"}=" C5A CND"; $resn_exch{" AC6 CND"}=" C6A CND";
$resn_exch{" AN6 CND"}=" N6A CND"; $resn_exch{" AN1 CND"}=" N1A CND"; $resn_exch{" AC2 CND"}=" C2A CND";
$resn_exch{" AN3 CND"}=" N3A CND"; $resn_exch{" AC4 CND"}=" C4A CND"; $resn_exch{" NP  CND"}=" PN  CND";
$resn_exch{" NO1 CND"}=" O1N CND"; $resn_exch{" NO2 CND"}=" O2N CND"; $resn_exch{"NO5* CND"}=" O5D CND";
$resn_exch{"NC5* CND"}=" C5D CND"; $resn_exch{"NC4* CND"}=" C4D CND"; $resn_exch{"NO4* CND"}=" O4D CND";
$resn_exch{"NC3* CND"}=" C3D CND"; $resn_exch{"NO3* CND"}=" O3D CND"; $resn_exch{"NC2* CND"}=" C2D CND";
$resn_exch{"NO2* CND"}=" O2D CND"; $resn_exch{"NC1* CND"}=" C1D CND"; $resn_exch{" NC1 CND"}=" C1N CND";
$resn_exch{" NC2 CND"}=" C2N CND"; $resn_exch{" NC3 CND"}=" C3N CND"; $resn_exch{" NC7 CND"}=" C7N CND";
$resn_exch{" NO7 CND"}=" O7N CND"; $resn_exch{" NN7 CND"}=" N7N CND"; $resn_exch{" NC4 CND"}=" C4N CND";
$resn_exch{" NN5 CND"}=" N5N CND"; $resn_exch{" NC6 CND"}=" C6N CND"; $resn_exch{" N2* CO4"}=" N2' CO4";
$resn_exch{" C2* CO4"}=" C2D CO4"; $resn_exch{" N3* CO4"}=" N3' CO4"; $resn_exch{" C4* CO4"}=" C4D CO4";
$resn_exch{" N4* CO4"}=" N4' CO4"; $resn_exch{" C5* CO4"}=" C5D CO4"; $resn_exch{" C6* CO4"}=" C6D CO4";
$resn_exch{" C7* CO4"}=" C7' CO4"; $resn_exch{" N8* CO4"}=" N8' CO4"; $resn_exch{" N1* CO4"}=" N1' CO4";
$resn_exch{" C8* CO4"}=" C8' CO4"; $resn_exch{" N9* CO4"}=" N9' CO4"; $resn_exch{" C9* CO4"}=" C9' CO4";
$resn_exch{" AN1 CO6"}=" N1A CO6"; $resn_exch{" AC2 CO6"}=" C2A CO6"; $resn_exch{" AN3 CO6"}=" N3A CO6";
$resn_exch{" AC4 CO6"}=" C4A CO6"; $resn_exch{" AC5 CO6"}=" C5A CO6"; $resn_exch{" AC6 CO6"}=" C6A CO6";
$resn_exch{" AN6 CO6"}=" N6A CO6"; $resn_exch{" AN7 CO6"}=" N7A CO6"; $resn_exch{" AC8 CO6"}=" C8A CO6";
$resn_exch{" AN9 CO6"}=" N9A CO6"; $resn_exch{"AC1* CO6"}=" C1B CO6"; $resn_exch{"AC2* CO6"}=" C2B CO6";
$resn_exch{"AO2* CO6"}=" O2B CO6"; $resn_exch{"AC3* CO6"}=" C3B CO6"; $resn_exch{"AO3* CO6"}=" O3B CO6";
$resn_exch{"AP3* CO6"}=" P3B CO6"; $resn_exch{" AO7 CO6"}=" O7A CO6"; $resn_exch{" AO8 CO6"}=" O8A CO6";
$resn_exch{" AO9 CO6"}=" O9A CO6"; $resn_exch{"AC4* CO6"}=" C4B CO6"; $resn_exch{"AO4* CO6"}=" O4B CO6";
$resn_exch{"AC5* CO6"}=" C5B CO6"; $resn_exch{"AO5* CO6"}=" O5B CO6"; $resn_exch{" AP1 CO6"}=" P1A CO6";
$resn_exch{" AO1 CO6"}=" O1A CO6"; $resn_exch{" AO2 CO6"}=" O2A CO6"; $resn_exch{" AO3 CO6"}=" O3A CO6";
$resn_exch{" AP2 CO6"}=" P2A CO6"; $resn_exch{" AO4 CO6"}=" O4A CO6"; $resn_exch{" AO5 CO6"}=" O5A CO6";
$resn_exch{" AO6 CO6"}=" O6A CO6"; $resn_exch{"PC11 CO6"}=" CBP CO6"; $resn_exch{"PC12 CO6"}=" CCP CO6";
$resn_exch{"PC13 CO6"}=" CDP CO6"; $resn_exch{"PC14 CO6"}=" CEP CO6"; $resn_exch{"PC10 CO6"}=" CAP CO6";
$resn_exch{"PO10 CO6"}=" OAP CO6"; $resn_exch{" PC9 CO6"}=" C9P CO6"; $resn_exch{" PO9 CO6"}=" O9P CO6";
$resn_exch{" PN8 CO6"}=" N8P CO6"; $resn_exch{" PC7 CO6"}=" C7P CO6"; $resn_exch{" PC6 CO6"}=" C6P CO6";
$resn_exch{" PC5 CO6"}=" C5P CO6"; $resn_exch{" PO5 CO6"}=" O5P CO6"; $resn_exch{" PN4 CO6"}=" N4P CO6";
$resn_exch{" PC3 CO6"}=" C3P CO6"; $resn_exch{" PC2 CO6"}=" C2P CO6"; $resn_exch{" PS1 CO6"}=" S1P CO6";
$resn_exch{" AN1 CO8"}=" N1A CO8"; $resn_exch{" AC2 CO8"}=" C2A CO8"; $resn_exch{" AN3 CO8"}=" N3A CO8";
$resn_exch{" AC4 CO8"}=" C4A CO8"; $resn_exch{" AC5 CO8"}=" C5A CO8"; $resn_exch{" AC6 CO8"}=" C6A CO8";
$resn_exch{" AN6 CO8"}=" N6A CO8"; $resn_exch{" AN7 CO8"}=" N7A CO8"; $resn_exch{" AC8 CO8"}=" C8A CO8";
$resn_exch{" AN9 CO8"}=" N9A CO8"; $resn_exch{"AC1* CO8"}=" C1B CO8"; $resn_exch{"AC2* CO8"}=" C2B CO8";
$resn_exch{"AO2* CO8"}=" O2B CO8"; $resn_exch{"AC3* CO8"}=" C3B CO8"; $resn_exch{"AO3* CO8"}=" O3B CO8";
$resn_exch{"AP3* CO8"}=" P3B CO8"; $resn_exch{" AO7 CO8"}=" O7A CO8"; $resn_exch{" AO8 CO8"}=" O8A CO8";
$resn_exch{" AO9 CO8"}=" O9A CO8"; $resn_exch{"AC4* CO8"}=" C4B CO8"; $resn_exch{"AO4* CO8"}=" O4B CO8";
$resn_exch{"AC5* CO8"}=" C5B CO8"; $resn_exch{"AO5* CO8"}=" O5B CO8"; $resn_exch{" AP1 CO8"}=" P1A CO8";
$resn_exch{" AO1 CO8"}=" O1A CO8"; $resn_exch{" AO2 CO8"}=" O2A CO8"; $resn_exch{" AO3 CO8"}=" O3A CO8";
$resn_exch{" AP2 CO8"}=" P2A CO8"; $resn_exch{" AO4 CO8"}=" O4A CO8"; $resn_exch{" AO5 CO8"}=" O5A CO8";
$resn_exch{" AO6 CO8"}=" O6A CO8"; $resn_exch{"PC11 CO8"}=" CBP CO8"; $resn_exch{"PC12 CO8"}=" CCP CO8";
$resn_exch{"PC13 CO8"}=" CDP CO8"; $resn_exch{"PC14 CO8"}=" CEP CO8"; $resn_exch{"PC10 CO8"}=" CAP CO8";
$resn_exch{"PO10 CO8"}=" OAP CO8"; $resn_exch{" PC9 CO8"}=" C9P CO8"; $resn_exch{" PO9 CO8"}=" O9P CO8";
$resn_exch{" PN8 CO8"}=" N8P CO8"; $resn_exch{" PC7 CO8"}=" C7P CO8"; $resn_exch{" PC6 CO8"}=" C6P CO8";
$resn_exch{" PC5 CO8"}=" C5P CO8"; $resn_exch{" PO5 CO8"}=" O5P CO8"; $resn_exch{" PN4 CO8"}=" N4P CO8";
$resn_exch{" PC3 CO8"}=" C3P CO8"; $resn_exch{" PC2 CO8"}=" C2P CO8"; $resn_exch{" PS1 CO8"}=" S1P CO8";
$resn_exch{" C1* CO8"}=" C1' CO8"; $resn_exch{" O1* CO8"}=" O1' CO8"; $resn_exch{" C2* CO8"}=" C2' CO8";
$resn_exch{" C3* CO8"}=" C3' CO8"; $resn_exch{" C4* CO8"}=" C4' CO8"; $resn_exch{" C5* CO8"}=" C5' CO8";
$resn_exch{" C6* CO8"}=" C6' CO8"; $resn_exch{" C7* CO8"}=" C7' CO8"; $resn_exch{" C8* CO8"}=" C8' CO8";
$resn_exch{" AN1 COA"}=" N1A COA"; $resn_exch{" AC2 COA"}=" C2A COA"; $resn_exch{" AN3 COA"}=" N3A COA";
$resn_exch{" AC4 COA"}=" C4A COA"; $resn_exch{" AC5 COA"}=" C5A COA"; $resn_exch{" AC6 COA"}=" C6A COA";
$resn_exch{" AN6 COA"}=" N6A COA"; $resn_exch{" AN7 COA"}=" N7A COA"; $resn_exch{" AC8 COA"}=" C8A COA";
$resn_exch{" AN9 COA"}=" N9A COA"; $resn_exch{"AC1* COA"}=" C1B COA"; $resn_exch{"AC2* COA"}=" C2B COA";
$resn_exch{"AO2* COA"}=" O2B COA"; $resn_exch{"AC3* COA"}=" C3B COA"; $resn_exch{"AO3* COA"}=" O3B COA";
$resn_exch{"AP3* COA"}=" P3B COA"; $resn_exch{" AO7 COA"}=" O7A COA"; $resn_exch{" AO8 COA"}=" O8A COA";
$resn_exch{" AO9 COA"}=" O9A COA"; $resn_exch{"AC4* COA"}=" C4B COA"; $resn_exch{"AO4* COA"}=" O4B COA";
$resn_exch{"AC5* COA"}=" C5B COA"; $resn_exch{"AO5* COA"}=" O5B COA"; $resn_exch{" AP1 COA"}=" P1A COA";
$resn_exch{" AO1 COA"}=" O1A COA"; $resn_exch{" AO2 COA"}=" O2A COA"; $resn_exch{" AO3 COA"}=" O3A COA";
$resn_exch{" AP2 COA"}=" P2A COA"; $resn_exch{" AO4 COA"}=" O4A COA"; $resn_exch{" AO5 COA"}=" O5A COA";
$resn_exch{" AO6 COA"}=" O6A COA"; $resn_exch{"PC11 COA"}=" CBP COA"; $resn_exch{"PC12 COA"}=" CCP COA";
$resn_exch{"PC13 COA"}=" CDP COA"; $resn_exch{"PC14 COA"}=" CEP COA"; $resn_exch{"PC10 COA"}=" CAP COA";
$resn_exch{"PO10 COA"}=" OAP COA"; $resn_exch{" PC9 COA"}=" C9P COA"; $resn_exch{" PO9 COA"}=" O9P COA";
$resn_exch{" PN8 COA"}=" N8P COA"; $resn_exch{" PC7 COA"}=" C7P COA"; $resn_exch{" PC6 COA"}=" C6P COA";
$resn_exch{" PC5 COA"}=" C5P COA"; $resn_exch{" PO5 COA"}=" O5P COA"; $resn_exch{" PN4 COA"}=" N4P COA";
$resn_exch{" PC3 COA"}=" C3P COA"; $resn_exch{" PC2 COA"}=" C2P COA"; $resn_exch{" PS1 COA"}=" S1P COA";
$resn_exch{" AN1 COF"}=" N1A COF"; $resn_exch{" AC2 COF"}=" C2A COF"; $resn_exch{" AN3 COF"}=" N3A COF";
$resn_exch{" AC4 COF"}=" C4A COF"; $resn_exch{" AC5 COF"}=" C5A COF"; $resn_exch{" AC6 COF"}=" C6A COF";
$resn_exch{" AN6 COF"}=" N6A COF"; $resn_exch{" AN7 COF"}=" N7A COF"; $resn_exch{" AC8 COF"}=" C8A COF";
$resn_exch{" AN9 COF"}=" N9A COF"; $resn_exch{"AC1* COF"}=" C1B COF"; $resn_exch{"AC2* COF"}=" C2B COF";
$resn_exch{"AO2* COF"}=" O2B COF"; $resn_exch{"AC3* COF"}=" C3B COF"; $resn_exch{"AO3* COF"}=" O3B COF";
$resn_exch{"AP3* COF"}=" P3B COF"; $resn_exch{" AO7 COF"}=" O7A COF"; $resn_exch{" AO8 COF"}=" O8A COF";
$resn_exch{" AO9 COF"}=" O9A COF"; $resn_exch{"AC4* COF"}=" C4B COF"; $resn_exch{"AO4* COF"}=" O4B COF";
$resn_exch{"AC5* COF"}=" C5B COF"; $resn_exch{"AO5* COF"}=" O5B COF"; $resn_exch{" AP1 COF"}=" P1A COF";
$resn_exch{" AO1 COF"}=" O1A COF"; $resn_exch{" AO2 COF"}=" O2A COF"; $resn_exch{" AO3 COF"}=" O3A COF";
$resn_exch{" AP2 COF"}=" P2A COF"; $resn_exch{" AO4 COF"}=" O4A COF"; $resn_exch{" AO5 COF"}=" O5A COF";
$resn_exch{" AO6 COF"}=" O6A COF"; $resn_exch{"PC11 COF"}=" CBP COF"; $resn_exch{"PC12 COF"}=" CCP COF";
$resn_exch{"PC13 COF"}=" CDP COF"; $resn_exch{"PC14 COF"}=" CEP COF"; $resn_exch{"PC10 COF"}=" CAP COF";
$resn_exch{"PO10 COF"}=" OAP COF"; $resn_exch{" PC9 COF"}=" C9P COF"; $resn_exch{" PO9 COF"}=" O9P COF";
$resn_exch{" PN8 COF"}=" N8P COF"; $resn_exch{" PC7 COF"}=" C7P COF"; $resn_exch{" PC6 COF"}=" C6P COF";
$resn_exch{" PC5 COF"}=" C5P COF"; $resn_exch{" PO5 COF"}=" O5P COF"; $resn_exch{" PN4 COF"}=" N4P COF";
$resn_exch{" PC3 COF"}=" C3P COF"; $resn_exch{" PC2 COF"}=" C2P COF"; $resn_exch{" PS1 COF"}=" S1P COF";
$resn_exch{" IC1 COF"}=" C1I COF"; $resn_exch{" IC2 COF"}=" C2I COF"; $resn_exch{" IO1 COF"}=" O1I COF";
$resn_exch{" IC3 COF"}=" C3I COF"; $resn_exch{" IF1 COF"}=" F1I COF"; $resn_exch{" IF2 COF"}=" F2I COF";
$resn_exch{" IF3 COF"}=" F3I COF"; $resn_exch{" C2* COG"}=" C2B COG"; $resn_exch{" C4* COG"}=" C4B COG";
$resn_exch{" C5* COG"}=" C5B COG"; $resn_exch{" C6* COG"}=" C6B COG"; $resn_exch{" C7* COG"}=" C7B COG";
$resn_exch{" N1* COG"}=" N1' COG"; $resn_exch{" N2* COG"}=" N2' COG"; $resn_exch{" N3* COG"}=" N3' COG";
$resn_exch{" N4* COG"}=" N4' COG"; $resn_exch{" C8* COG"}=" C8' COG"; $resn_exch{" N6* COG"}=" N6' COG";
$resn_exch{" N_A COH"}=" NA  COH"; $resn_exch{" N_B COH"}=" NB  COH"; $resn_exch{" N_C COH"}=" NC  COH";
$resn_exch{" N_D COH"}=" ND  COH"; $resn_exch{" AN6 COK"}=" N6A COK"; $resn_exch{" AC6 COK"}=" C6A COK";
$resn_exch{" AN1 COK"}=" N1A COK"; $resn_exch{" AC2 COK"}=" C2A COK"; $resn_exch{" AN3 COK"}=" N3A COK";
$resn_exch{" AC4 COK"}=" C4A COK"; $resn_exch{" AC5 COK"}=" C5A COK"; $resn_exch{" AN7 COK"}=" N7A COK";
$resn_exch{" AC8 COK"}=" C8A COK"; $resn_exch{" AN9 COK"}=" N9A COK"; $resn_exch{"AC1* COK"}=" C1B COK";
$resn_exch{"AO4* COK"}=" O4B COK"; $resn_exch{"AC2* COK"}=" C2B COK"; $resn_exch{"AO2* COK"}=" O2B COK";
$resn_exch{"AC3* COK"}=" C3B COK"; $resn_exch{"AO3* COK"}=" O3B COK"; $resn_exch{"AP3* COK"}=" P3B COK";
$resn_exch{" AO8 COK"}=" O8A COK"; $resn_exch{" AO9 COK"}=" O9A COK"; $resn_exch{" AO7 COK"}=" O7A COK";
$resn_exch{"AC4* COK"}=" C4B COK"; $resn_exch{"AC5* COK"}=" C5B COK"; $resn_exch{"AO5* COK"}=" O5B COK";
$resn_exch{" AP1 COK"}=" P1A COK"; $resn_exch{" AO1 COK"}=" O1A COK"; $resn_exch{" AO2 COK"}=" O2A COK";
$resn_exch{" AO3 COK"}=" O3A COK"; $resn_exch{" AP2 COK"}=" P2A COK"; $resn_exch{" AO4 COK"}=" O4A COK";
$resn_exch{" AO5 COK"}=" O5A COK"; $resn_exch{" AO6 COK"}=" O6A COK"; $resn_exch{"PC12 COK"}=" CCP COK";
$resn_exch{"PC11 COK"}=" CBP COK"; $resn_exch{"PC13 COK"}=" CDP COK"; $resn_exch{"PC14 COK"}=" CEP COK";
$resn_exch{"PC10 COK"}=" CAP COK"; $resn_exch{"PO10 COK"}=" OAP COK"; $resn_exch{" PC9 COK"}=" C9P COK";
$resn_exch{" PO9 COK"}=" O9P COK"; $resn_exch{" PN8 COK"}=" N8P COK"; $resn_exch{" PC7 COK"}=" C7P COK";
$resn_exch{" PC6 COK"}=" C6P COK"; $resn_exch{" PC5 COK"}=" C5P COK"; $resn_exch{" PO5 COK"}=" O5P COK";
$resn_exch{" PN4 COK"}=" N4P COK"; $resn_exch{" PC3 COK"}=" C3P COK"; $resn_exch{" PC2 COK"}=" C2P COK";
$resn_exch{" PS1 COK"}=" S1P COK"; $resn_exch{" C2* COQ"}=" C2B COQ"; $resn_exch{" C4* COQ"}=" C4B COQ";
$resn_exch{" C5* COQ"}=" C5B COQ"; $resn_exch{" C6* COQ"}=" C6B COQ"; $resn_exch{" C7* COQ"}=" C7' COQ";
$resn_exch{" C9* COQ"}=" C9' COQ"; $resn_exch{" CN* COQ"}=" CN' COQ"; $resn_exch{" N1* COQ"}=" N1' COQ";
$resn_exch{" N2* COQ"}=" N2' COQ"; $resn_exch{" N3* COQ"}=" N3' COQ"; $resn_exch{" N4* COQ"}=" N4' COQ";
$resn_exch{" N8* COQ"}=" N8' COQ"; $resn_exch{" N9* COQ"}=" N9' COQ"; $resn_exch{" AN1 COS"}=" N1A COS";
$resn_exch{" AC2 COS"}=" C2A COS"; $resn_exch{" AN3 COS"}=" N3A COS"; $resn_exch{" AC4 COS"}=" C4A COS";
$resn_exch{" AC5 COS"}=" C5A COS"; $resn_exch{" AC6 COS"}=" C6A COS"; $resn_exch{" AN6 COS"}=" N6A COS";
$resn_exch{" AN7 COS"}=" N7A COS"; $resn_exch{" AC8 COS"}=" C8A COS"; $resn_exch{" AN9 COS"}=" N9A COS";
$resn_exch{"AC1* COS"}=" C1B COS"; $resn_exch{"AC2* COS"}=" C2B COS"; $resn_exch{"AO2* COS"}=" O2B COS";
$resn_exch{"AC3* COS"}=" C3B COS"; $resn_exch{"AO3* COS"}=" O3B COS"; $resn_exch{"AP3* COS"}=" P3B COS";
$resn_exch{" AO7 COS"}=" O7A COS"; $resn_exch{" AO8 COS"}=" O8A COS"; $resn_exch{" AO9 COS"}=" O9A COS";
$resn_exch{"AC4* COS"}=" C4B COS"; $resn_exch{"AO4* COS"}=" O4B COS"; $resn_exch{"AC5* COS"}=" C5B COS";
$resn_exch{"AO5* COS"}=" O5B COS"; $resn_exch{" AP1 COS"}=" P1A COS"; $resn_exch{" AO1 COS"}=" O1A COS";
$resn_exch{" AO2 COS"}=" O2A COS"; $resn_exch{" AO3 COS"}=" O3A COS"; $resn_exch{" AP2 COS"}=" P2A COS";
$resn_exch{" AO4 COS"}=" O4A COS"; $resn_exch{" AO5 COS"}=" O5A COS"; $resn_exch{" AO6 COS"}=" O6A COS";
$resn_exch{"PC11 COS"}=" CBP COS"; $resn_exch{"PC12 COS"}=" CCP COS"; $resn_exch{"PC13 COS"}=" CDP COS";
$resn_exch{"PC14 COS"}=" CEP COS"; $resn_exch{"PC10 COS"}=" CAP COS"; $resn_exch{"PO10 COS"}=" OAP COS";
$resn_exch{" PC9 COS"}=" C9P COS"; $resn_exch{" PO9 COS"}=" O9P COS"; $resn_exch{" PN8 COS"}=" N8P COS";
$resn_exch{" PC7 COS"}=" C7P COS"; $resn_exch{" PC6 COS"}=" C6P COS"; $resn_exch{" PC5 COS"}=" C5P COS";
$resn_exch{" PO5 COS"}=" O5P COS"; $resn_exch{" PN4 COS"}=" N4P COS"; $resn_exch{" PC3 COS"}=" C3P COS";
$resn_exch{" PC2 COS"}=" C2P COS"; $resn_exch{" PS1 COS"}=" S1P COS"; $resn_exch{" PS' COS"}=" S'P COS";
$resn_exch{"CD2T COT"}=" C11 COT"; $resn_exch{"CE2T COT"}=" C12 COT"; $resn_exch{"CE3T COT"}=" C13 COT";
$resn_exch{"CD1T COT"}=" C14 COT"; $resn_exch{"NE1T COT"}=" N11 COT"; $resn_exch{"CZ2T COT"}=" C15 COT";
$resn_exch{"CZ3T COT"}=" C16 COT"; $resn_exch{"CH2T COT"}=" C17 COT"; $resn_exch{"OPB3 COT"}=" O11 COT";
$resn_exch{"OPB1 COT"}=" O12 COT"; $resn_exch{"OPB2 COT"}=" O13 COT"; $resn_exch{"OPA3 COT"}=" O14 COT";
$resn_exch{"O3*A COT"}=" O3B COT"; $resn_exch{"OPA2 COT"}=" O15 COT"; $resn_exch{"OPA1 COT"}=" O16 COT";
$resn_exch{"O5*A COT"}=" O5B COT"; $resn_exch{"C5*A COT"}=" C5B COT"; $resn_exch{"C4*A COT"}=" C4B COT";
$resn_exch{"C3*A COT"}=" C3B COT"; $resn_exch{"O2*A COT"}=" O2B COT"; $resn_exch{"O4*A COT"}=" O4B COT";
$resn_exch{"OPC1 COT"}=" O17 COT"; $resn_exch{"OPC2 COT"}=" O18 COT"; $resn_exch{"OPC3 COT"}=" O19 COT";
$resn_exch{"C2*A COT"}=" C2B COT"; $resn_exch{"C1*A COT"}=" C1B COT"; $resn_exch{"O10P COT"}=" OAP COT";
$resn_exch{"C11P COT"}=" CBP COT"; $resn_exch{"O12P COT"}=" OCP COT"; $resn_exch{"C13P COT"}=" CDP COT";
$resn_exch{"C16P COT"}=" CGP COT"; $resn_exch{"C14P COT"}=" CEP COT"; $resn_exch{"C15P COT"}=" CFP COT";
$resn_exch{" AN1 COZ"}=" N1A COZ"; $resn_exch{" AC2 COZ"}=" C2A COZ"; $resn_exch{" AN3 COZ"}=" N3A COZ";
$resn_exch{" AC4 COZ"}=" C4A COZ"; $resn_exch{" AC5 COZ"}=" C5A COZ"; $resn_exch{" AC6 COZ"}=" C6A COZ";
$resn_exch{" AN6 COZ"}=" N6A COZ"; $resn_exch{" AN7 COZ"}=" N7A COZ"; $resn_exch{" AC8 COZ"}=" C8A COZ";
$resn_exch{" AN9 COZ"}=" N9A COZ"; $resn_exch{"AC1* COZ"}=" C1B COZ"; $resn_exch{"AC2* COZ"}=" C2B COZ";
$resn_exch{"AO2* COZ"}=" O2B COZ"; $resn_exch{"AC3* COZ"}=" C3B COZ"; $resn_exch{"AO3* COZ"}=" O3B COZ";
$resn_exch{"AP3* COZ"}=" P3B COZ"; $resn_exch{" AO7 COZ"}=" O7A COZ"; $resn_exch{" AO8 COZ"}=" O8A COZ";
$resn_exch{" AO9 COZ"}=" O9A COZ"; $resn_exch{"AC4* COZ"}=" C4B COZ"; $resn_exch{"AO4* COZ"}=" O4B COZ";
$resn_exch{"AC5* COZ"}=" C5B COZ"; $resn_exch{"AO5* COZ"}=" O5B COZ"; $resn_exch{" AP1 COZ"}=" P1A COZ";
$resn_exch{" AO1 COZ"}=" O1A COZ"; $resn_exch{" AO2 COZ"}=" O2A COZ"; $resn_exch{" AO3 COZ"}=" O3A COZ";
$resn_exch{" AP2 COZ"}=" P2A COZ"; $resn_exch{" AO4 COZ"}=" O4A COZ"; $resn_exch{" AO5 COZ"}=" O5A COZ";
$resn_exch{" AO6 COZ"}=" O6A COZ"; $resn_exch{"PC11 COZ"}=" CBP COZ"; $resn_exch{"PC12 COZ"}=" CCP COZ";
$resn_exch{"PC13 COZ"}=" CDP COZ"; $resn_exch{"PC14 COZ"}=" CEP COZ"; $resn_exch{"PC10 COZ"}=" CAP COZ";
$resn_exch{"PO10 COZ"}=" OAP COZ"; $resn_exch{" PC9 COZ"}=" C9P COZ"; $resn_exch{" PO9 COZ"}=" O9P COZ";
$resn_exch{" PN8 COZ"}=" N8P COZ"; $resn_exch{" PC7 COZ"}=" C7P COZ"; $resn_exch{" PC6 COZ"}=" C6P COZ";
$resn_exch{" PC5 COZ"}=" C5P COZ"; $resn_exch{" PO5 COZ"}=" O5P COZ"; $resn_exch{" PN4 COZ"}=" N4P COZ";
$resn_exch{" PC3 COZ"}=" C3P COZ"; $resn_exch{" PC2 COZ"}=" C2P COZ"; $resn_exch{" PS1 COZ"}=" S1P COZ";
$resn_exch{"CO5' CPA"}=" O5D CPA"; $resn_exch{"CC5' CPA"}=" C5X CPA"; $resn_exch{"CC4' CPA"}=" C4X CPA";
$resn_exch{"CO4' CPA"}=" O4D CPA"; $resn_exch{"CC3' CPA"}=" C3X CPA"; $resn_exch{"CO3' CPA"}=" O3D CPA";
$resn_exch{"CC2' CPA"}=" C2X CPA"; $resn_exch{"CC1' CPA"}=" C1X CPA"; $resn_exch{" CN1 CPA"}=" N1C CPA";
$resn_exch{" CN3 CPA"}=" N3C CPA"; $resn_exch{" CO2 CPA"}=" O2C CPA"; $resn_exch{" CN4 CPA"}=" N4C CPA";
$resn_exch{"AO5' CPA"}=" O5B CPA"; $resn_exch{"AC5' CPA"}=" C5B CPA"; $resn_exch{"AC4' CPA"}=" C4B CPA";
$resn_exch{"AO4' CPA"}=" O4B CPA"; $resn_exch{"AC3' CPA"}=" C3B CPA"; $resn_exch{"AO3' CPA"}=" O3B CPA";
$resn_exch{"AC2' CPA"}=" C2B CPA"; $resn_exch{"AC1' CPA"}=" C1B CPA"; $resn_exch{" AN9 CPA"}=" N9A CPA";
$resn_exch{" AC8 CPA"}=" C8A CPA"; $resn_exch{" AN7 CPA"}=" N7A CPA"; $resn_exch{" AC5 CPA"}=" C5A CPA";
$resn_exch{" AC6 CPA"}=" C6A CPA"; $resn_exch{" AN6 CPA"}=" N6A CPA"; $resn_exch{" AN1 CPA"}=" N1A CPA";
$resn_exch{" AC2 CPA"}=" C2A CPA"; $resn_exch{" AN3 CPA"}=" N3A CPA"; $resn_exch{" AC4 CPA"}=" C4A CPA";
$resn_exch{" O5* CPG"}=" O5' CPG"; $resn_exch{" C5* CPG"}=" C5' CPG"; $resn_exch{" C4* CPG"}=" C4' CPG";
$resn_exch{" O4* CPG"}=" O4' CPG"; $resn_exch{" C3* CPG"}=" C3' CPG"; $resn_exch{" O3* CPG"}=" O3' CPG";
$resn_exch{" C2* CPG"}=" C2' CPG"; $resn_exch{" O2* CPG"}=" O2' CPG"; $resn_exch{" C1* CPG"}=" C1' CPG";
$resn_exch{" C1* CPH"}=" C1' CPH"; $resn_exch{" O1* CPH"}=" O1' CPH"; $resn_exch{" C2* CPH"}=" C2' CPH";
$resn_exch{" O2* CPH"}=" O2' CPH"; $resn_exch{" C3* CPH"}=" C3' CPH"; $resn_exch{" O3* CPH"}=" O3' CPH";
$resn_exch{" C4* CPH"}=" C4' CPH"; $resn_exch{" O4* CPH"}=" O4' CPH"; $resn_exch{" C5* CPH"}=" C5' CPH";
$resn_exch{"C19* CPO"}=" CJ' CPO"; $resn_exch{" O5* CPR"}=" O5' CPR"; $resn_exch{" C5* CPR"}=" C5' CPR";
$resn_exch{" C4* CPR"}=" C4' CPR"; $resn_exch{" O4* CPR"}=" O4' CPR"; $resn_exch{" C3* CPR"}=" C3' CPR";
$resn_exch{" O3* CPR"}=" O3' CPR"; $resn_exch{" C2* CPR"}=" C2' CPR"; $resn_exch{" O2* CPR"}=" O2' CPR";
$resn_exch{" C1* CPR"}=" C1' CPR"; $resn_exch{" CA* CPV"}=" CA' CPV"; $resn_exch{" CB* CPV"}=" CB' CPV";
$resn_exch{"C1'' CR3"}=" C1B CR3"; $resn_exch{"C2'' CR3"}=" C2B CR3"; $resn_exch{"C3'' CR3"}=" C3B CR3";
$resn_exch{"C4'' CR3"}=" C4B CR3"; $resn_exch{"C5'' CR3"}=" C5B CR3"; $resn_exch{"C1'' CR9"}=" C1B CR9";
$resn_exch{"C2'' CR9"}=" C2B CR9"; $resn_exch{"C3'' CR9"}=" C3B CR9"; $resn_exch{"C4'' CR9"}=" C4B CR9";
$resn_exch{"C5'' CR9"}=" C5B CR9"; $resn_exch{"C6'' CR9"}=" C6B CR9"; $resn_exch{" C1* CRH"}=" C1' CRH";
$resn_exch{" C2* CRH"}=" C2' CRH"; $resn_exch{" C3* CRH"}=" C3' CRH"; $resn_exch{" C4* CRH"}=" C4' CRH";
$resn_exch{" O1* CRH"}=" O1' CRH"; $resn_exch{" O2* CRH"}=" O2' CRH"; $resn_exch{" O3* CRH"}=" O3' CRH";
$resn_exch{" O4* CRH"}=" O4' CRH"; $resn_exch{" O   CS3"}=" OXT CS3"; $resn_exch{" OXT CS3"}=" O   CS3";
$resn_exch{" O   CS4"}=" OXT CS4"; $resn_exch{" OXT CS4"}=" O   CS4"; $resn_exch{"PO10 CS8"}=" OAP CS8";
$resn_exch{"PC10 CS8"}=" CAP CS8"; $resn_exch{" PC9 CS8"}=" C9P CS8"; $resn_exch{" PO9 CS8"}=" O9P CS8";
$resn_exch{" PN8 CS8"}=" N8P CS8"; $resn_exch{" PC7 CS8"}=" C7P CS8"; $resn_exch{" PC6 CS8"}=" C6P CS8";
$resn_exch{" PC5 CS8"}=" C5P CS8"; $resn_exch{" PO5 CS8"}=" O5P CS8"; $resn_exch{" PN4 CS8"}=" N4P CS8";
$resn_exch{" PC3 CS8"}=" C3P CS8"; $resn_exch{" PC2 CS8"}=" C2P CS8"; $resn_exch{" PS1 CS8"}=" S1P CS8";
$resn_exch{" C1* CS8"}=" C1' CS8"; $resn_exch{" O1* CS8"}=" O1' CS8"; $resn_exch{" C2* CS8"}=" C2' CS8";
$resn_exch{" S3* CS8"}=" S3' CS8"; $resn_exch{" C4* CS8"}=" C4' CS8"; $resn_exch{" C5* CS8"}=" C5' CS8";
$resn_exch{" C6* CS8"}=" C6' CS8"; $resn_exch{" C7* CS8"}=" C7' CS8"; $resn_exch{" C8* CS8"}=" C8' CS8";
$resn_exch{"PC11 CS8"}=" CBP CS8"; $resn_exch{"PC13 CS8"}=" CDP CS8"; $resn_exch{"PC14 CS8"}=" CEP CS8";
$resn_exch{"PC12 CS8"}=" CCP CS8"; $resn_exch{" AO6 CS8"}=" O6A CS8"; $resn_exch{" AP2 CS8"}=" P2A CS8";
$resn_exch{" AO4 CS8"}=" O4A CS8"; $resn_exch{" AO5 CS8"}=" O5A CS8"; $resn_exch{" AO3 CS8"}=" O3A CS8";
$resn_exch{" AP1 CS8"}=" P1A CS8"; $resn_exch{" AO1 CS8"}=" O1A CS8"; $resn_exch{" AO2 CS8"}=" O2A CS8";
$resn_exch{"AO5* CS8"}=" O5B CS8"; $resn_exch{"AC5* CS8"}=" C5B CS8"; $resn_exch{"AC4* CS8"}=" C4B CS8";
$resn_exch{"AO4* CS8"}=" O4B CS8"; $resn_exch{"AC1* CS8"}=" C1B CS8"; $resn_exch{" AN9 CS8"}=" N9A CS8";
$resn_exch{" AC8 CS8"}=" C8A CS8"; $resn_exch{" AN7 CS8"}=" N7A CS8"; $resn_exch{" AC5 CS8"}=" C5A CS8";
$resn_exch{" AC6 CS8"}=" C6A CS8"; $resn_exch{" AN1 CS8"}=" N1A CS8"; $resn_exch{" AC2 CS8"}=" C2A CS8";
$resn_exch{" AN3 CS8"}=" N3A CS8"; $resn_exch{" AC4 CS8"}=" C4A CS8"; $resn_exch{" AN6 CS8"}=" N6A CS8";
$resn_exch{"AC2* CS8"}=" C2B CS8"; $resn_exch{"AO2* CS8"}=" O2B CS8"; $resn_exch{"AC3* CS8"}=" C3B CS8";
$resn_exch{"AO3* CS8"}=" O3B CS8"; $resn_exch{"AP3* CS8"}=" P3B CS8"; $resn_exch{" AO7 CS8"}=" O7A CS8";
$resn_exch{" AO8 CS8"}=" O8A CS8"; $resn_exch{" AO9 CS8"}=" O9A CS8"; $resn_exch{" C3* CSF"}=" C3' CSF";
$resn_exch{" C2* CSF"}=" C2' CSF"; $resn_exch{" C1* CSF"}=" C1' CSF"; $resn_exch{" O4* CSF"}=" O4' CSF";
$resn_exch{" C4* CSF"}=" C4' CSF"; $resn_exch{" O5* CSF"}=" O5' CSF"; $resn_exch{" C5* CSF"}=" C5' CSF";
$resn_exch{" O3* CSF"}=" O3' CSF"; $resn_exch{" O2* CSF"}=" O2' CSF"; $resn_exch{" O5* CSL"}=" O5' CSL";
$resn_exch{" C5* CSL"}=" C5' CSL"; $resn_exch{" C4* CSL"}=" C4' CSL"; $resn_exch{" O4* CSL"}=" O4' CSL";
$resn_exch{" C1* CSL"}=" C1' CSL"; $resn_exch{" C2* CSL"}=" C2' CSL"; $resn_exch{"SE2* CSL"}="SE2' CSL";
$resn_exch{" CA* CSL"}=" CA' CSL"; $resn_exch{" C3* CSL"}=" C3' CSL"; $resn_exch{" O3* CSL"}=" O3' CSL";
$resn_exch{" C4\" CTC"}=" C4D CTC"; $resn_exch{" C1* CTD"}=" C1' CTD"; $resn_exch{" C2* CTD"}=" C2' CTD";
$resn_exch{" O2* CTD"}=" O2' CTD"; $resn_exch{" C3* CTD"}=" C3' CTD"; $resn_exch{" C4* CTD"}=" C4' CTD";
$resn_exch{" O4* CTD"}=" O4' CTD"; $resn_exch{" O3* CTD"}=" O3' CTD"; $resn_exch{" C5* CTD"}=" C5' CTD";
$resn_exch{" O5* CTD"}=" O5' CTD"; $resn_exch{" O1P CTG"}=" OP1 CTG"; $resn_exch{" O2P CTG"}=" OP2 CTG";
$resn_exch{" O5* CTG"}=" O5' CTG"; $resn_exch{" C5* CTG"}=" C5' CTG"; $resn_exch{" C4* CTG"}=" C4' CTG";
$resn_exch{" O4* CTG"}=" O4' CTG"; $resn_exch{" C1* CTG"}=" C1' CTG"; $resn_exch{" C2* CTG"}=" C2' CTG";
$resn_exch{" C3* CTG"}=" C3' CTG"; $resn_exch{" O3* CTG"}=" O3' CTG"; $resn_exch{" O3P CTG"}=" OP3 CTG";
$resn_exch{" O5* CTN"}=" O5' CTN"; $resn_exch{" C5* CTN"}=" C5' CTN"; $resn_exch{" C4* CTN"}=" C4' CTN";
$resn_exch{" O4* CTN"}=" O4' CTN"; $resn_exch{" C1* CTN"}=" C1' CTN"; $resn_exch{" C2* CTN"}=" C2' CTN";
$resn_exch{" O2* CTN"}=" O2' CTN"; $resn_exch{" C3* CTN"}=" C3' CTN"; $resn_exch{" O3* CTN"}=" O3' CTN";
$resn_exch{" C1* CTP"}=" C1' CTP"; $resn_exch{" C2* CTP"}=" C2' CTP"; $resn_exch{" O2* CTP"}=" O2' CTP";
$resn_exch{" C3* CTP"}=" C3' CTP"; $resn_exch{" C4* CTP"}=" C4' CTP"; $resn_exch{" O4* CTP"}=" O4' CTP";
$resn_exch{" O3* CTP"}=" O3' CTP"; $resn_exch{" C5* CTP"}=" C5' CTP"; $resn_exch{" O5* CTP"}=" O5' CTP";
$resn_exch{" O1  CXM"}=" ON1 CXM"; $resn_exch{" O2  CXM"}=" ON2 CXM"; $resn_exch{"RO5* CXR"}=" O5D CXR";
$resn_exch{"RC5* CXR"}=" C5D CXR"; $resn_exch{"RC4* CXR"}=" C4D CXR"; $resn_exch{"RC3* CXR"}=" C3D CXR";
$resn_exch{"RO3* CXR"}=" O3D CXR"; $resn_exch{"RC2* CXR"}=" C2D CXR"; $resn_exch{"RO2* CXR"}=" O2D CXR";
$resn_exch{"RO4* CXR"}=" O4D CXR"; $resn_exch{"RC1* CXR"}=" C1D CXR"; $resn_exch{" C1* CXR"}=" C1' CXR";
$resn_exch{" O4* CXR"}=" O4' CXR"; $resn_exch{" C2* CXR"}=" C2' CXR"; $resn_exch{" O2* CXR"}=" O2' CXR";
$resn_exch{" C3* CXR"}=" C3' CXR"; $resn_exch{" O3* CXR"}=" O3' CXR"; $resn_exch{" C4* CXR"}=" C4' CXR";
$resn_exch{" C5* CXR"}=" C5' CXR"; $resn_exch{" O5* CXR"}=" O5' CXR"; $resn_exch{" O5* CXY"}=" O5D CXY";
$resn_exch{" C5* CXY"}=" C5D CXY"; $resn_exch{" C4* CXY"}=" C4D CXY"; $resn_exch{" O4* CXY"}=" O4D CXY";
$resn_exch{" C3* CXY"}=" C3D CXY"; $resn_exch{" O3* CXY"}=" O3D CXY"; $resn_exch{" C2* CXY"}=" C2D CXY";
$resn_exch{" O2* CXY"}=" O2D CXY"; $resn_exch{" C1* CXY"}=" C1D CXY"; $resn_exch{" N_A CYB"}=" NA  CYB";
$resn_exch{" N_B CYB"}=" NB  CYB"; $resn_exch{" O_B CYB"}=" OB  CYB"; $resn_exch{" N_C CYB"}=" NC  CYB";
$resn_exch{" O_C CYB"}=" OC  CYB"; $resn_exch{" N_D CYB"}=" ND  CYB"; $resn_exch{" N_A CYC"}=" NA  CYC";
$resn_exch{" N_B CYC"}=" NB  CYC"; $resn_exch{" O_B CYC"}=" OB  CYC"; $resn_exch{" N_C CYC"}=" NC  CYC";
$resn_exch{" O_C CYC"}=" OC  CYC"; $resn_exch{" N_D CYC"}=" ND  CYC"; $resn_exch{"4CL1 D05"}="CL14 D05";
$resn_exch{"6CL1 D05"}="CL16 D05"; $resn_exch{"2CL1 D05"}="CL12 D05"; $resn_exch{"'C10 D18"}=" CAX D18";
$resn_exch{"'C10 D19"}=" CAX D19"; $resn_exch{" O3P D1P"}=" OP3 D1P"; $resn_exch{" O1P D1P"}=" OP1 D1P";
$resn_exch{" O2P D1P"}=" OP2 D1P"; $resn_exch{" O5* D1P"}=" O5' D1P"; $resn_exch{" C5* D1P"}=" C5' D1P";
$resn_exch{" C4* D1P"}=" C4' D1P"; $resn_exch{" O4* D1P"}=" O4' D1P"; $resn_exch{" C3* D1P"}=" C3' D1P";
$resn_exch{" O3* D1P"}=" O3' D1P"; $resn_exch{" C2* D1P"}=" C2' D1P"; $resn_exch{" C1* D1P"}=" C1' D1P";
$resn_exch{" O1* D1P"}=" O1' D1P"; $resn_exch{"C10' D24"}=" CAX D24"; $resn_exch{"C11' D24"}=" CBX D24";
$resn_exch{"C12' D24"}=" CCX D24"; $resn_exch{" O1P  D3"}=" OP1  D3"; $resn_exch{" O2P  D3"}=" OP2  D3";
$resn_exch{" O3P  D3"}=" OP3  D3"; $resn_exch{" O5*  D3"}=" O5'  D3"; $resn_exch{" C5*  D3"}=" C5'  D3";
$resn_exch{" C4*  D3"}=" C4'  D3"; $resn_exch{" O4*  D3"}=" O4'  D3"; $resn_exch{" C3*  D3"}=" C3'  D3";
$resn_exch{" O3*  D3"}=" O3'  D3"; $resn_exch{" C2*  D3"}=" C2'  D3"; $resn_exch{" C1*  D3"}=" C1'  D3";
$resn_exch{"C10' D34"}=" CAX D34"; $resn_exch{"C11' D34"}=" CBX D34"; $resn_exch{"C10' D35"}=" CAX D35";
$resn_exch{"C11' D35"}=" CBX D35"; $resn_exch{"C12' D35"}=" CCX D35"; $resn_exch{"C13' D35"}=" CDX D35";
$resn_exch{" O5* D3T"}=" O5' D3T"; $resn_exch{" C5* D3T"}=" C5' D3T"; $resn_exch{" C4* D3T"}=" C4' D3T";
$resn_exch{" O4* D3T"}=" O4' D3T"; $resn_exch{" C1* D3T"}=" C1' D3T"; $resn_exch{" C2* D3T"}=" C2' D3T";
$resn_exch{" C3* D3T"}=" C3' D3T"; $resn_exch{" O2P D4M"}=" OP2 D4M"; $resn_exch{" O1P D4M"}=" OP1 D4M";
$resn_exch{" O3P D4M"}=" OP3 D4M"; $resn_exch{" O5* D4M"}=" O5' D4M"; $resn_exch{" C5* D4M"}=" C5' D4M";
$resn_exch{" C4* D4M"}=" C4' D4M"; $resn_exch{" O4* D4M"}=" O4' D4M"; $resn_exch{" C3* D4M"}=" C3' D4M";
$resn_exch{" C2* D4M"}=" C2' D4M"; $resn_exch{" C1* D4M"}=" C1' D4M"; $resn_exch{" O5* D5M"}=" O5' D5M";
$resn_exch{" C5* D5M"}=" C5' D5M"; $resn_exch{" C4* D5M"}=" C4' D5M"; $resn_exch{" O4* D5M"}=" O4' D5M";
$resn_exch{" C3* D5M"}=" C3' D5M"; $resn_exch{" O3* D5M"}=" O3' D5M"; $resn_exch{" C2* D5M"}=" C2' D5M";
$resn_exch{" C1* D5M"}=" C1' D5M"; $resn_exch{" O3P  DA"}=" OP3  DA"; $resn_exch{" O1P  DA"}=" OP1  DA";
$resn_exch{" O2P  DA"}=" OP2  DA"; $resn_exch{" O5*  DA"}=" O5'  DA"; $resn_exch{" C5*  DA"}=" C5'  DA";
$resn_exch{" C4*  DA"}=" C4'  DA"; $resn_exch{" O4*  DA"}=" O4'  DA"; $resn_exch{" C3*  DA"}=" C3'  DA";
$resn_exch{" O3*  DA"}=" O3'  DA"; $resn_exch{" C2*  DA"}=" C2'  DA"; $resn_exch{" C1*  DA"}=" C1'  DA";
$resn_exch{" O5* DAD"}=" O5' DAD"; $resn_exch{" C5* DAD"}=" C5' DAD"; $resn_exch{" C4* DAD"}=" C4' DAD";
$resn_exch{" O4* DAD"}=" O4' DAD"; $resn_exch{" C3* DAD"}=" C3' DAD"; $resn_exch{" C2* DAD"}=" C2' DAD";
$resn_exch{" C1* DAD"}=" C1' DAD"; $resn_exch{" C1* DAP"}=" C1' DAP"; $resn_exch{" C2* DAP"}=" C2' DAP";
$resn_exch{" C3* DAP"}=" C3' DAP"; $resn_exch{" C4* DAP"}=" C4' DAP"; $resn_exch{" C5* DAP"}=" C5' DAP";
$resn_exch{" C6* DAP"}=" C6' DAP"; $resn_exch{" O5* DAT"}=" O5' DAT"; $resn_exch{" C5* DAT"}=" C5' DAT";
$resn_exch{" C4* DAT"}=" C4' DAT"; $resn_exch{" O4* DAT"}=" O4' DAT"; $resn_exch{" C3* DAT"}=" C3' DAT";
$resn_exch{" O3* DAT"}=" O3' DAT"; $resn_exch{" C2* DAT"}=" C2' DAT"; $resn_exch{" C1* DAT"}=" C1' DAT";
$resn_exch{" O5* DBG"}=" O5' DBG"; $resn_exch{" C5* DBG"}=" C5' DBG"; $resn_exch{" C4* DBG"}=" C4' DBG";
$resn_exch{" O4* DBG"}=" O4' DBG"; $resn_exch{" C2* DBG"}=" C2' DBG"; $resn_exch{" O2* DBG"}=" O2' DBG";
$resn_exch{" C3* DBG"}=" C3' DBG"; $resn_exch{" O3* DBG"}=" O3' DBG"; $resn_exch{" C1* DBG"}=" C1' DBG";
$resn_exch{" O1\" DBL"}=" O1' DBL"; $resn_exch{" C2\" DBL"}=" C2B DBL"; $resn_exch{" O3P  DC"}=" OP3  DC";
$resn_exch{" O1P  DC"}=" OP1  DC"; $resn_exch{" O2P  DC"}=" OP2  DC"; $resn_exch{" O5*  DC"}=" O5'  DC";
$resn_exch{" C5*  DC"}=" C5'  DC"; $resn_exch{" C4*  DC"}=" C4'  DC"; $resn_exch{" O4*  DC"}=" O4'  DC";
$resn_exch{" C3*  DC"}=" C3'  DC"; $resn_exch{" O3*  DC"}=" O3'  DC"; $resn_exch{" C2*  DC"}=" C2'  DC";
$resn_exch{" C1*  DC"}=" C1'  DC"; $resn_exch{" AN1 DCA"}=" N1A DCA"; $resn_exch{" AC2 DCA"}=" C2A DCA";
$resn_exch{" AN3 DCA"}=" N3A DCA"; $resn_exch{" AC4 DCA"}=" C4A DCA"; $resn_exch{" AC5 DCA"}=" C5A DCA";
$resn_exch{" AC6 DCA"}=" C6A DCA"; $resn_exch{" AN6 DCA"}=" N6A DCA"; $resn_exch{" AN7 DCA"}=" N7A DCA";
$resn_exch{" AC8 DCA"}=" C8A DCA"; $resn_exch{" AN9 DCA"}=" N9A DCA"; $resn_exch{"AC1* DCA"}=" C1B DCA";
$resn_exch{"AC2* DCA"}=" C2B DCA"; $resn_exch{"AO2* DCA"}=" O2B DCA"; $resn_exch{"AC3* DCA"}=" C3B DCA";
$resn_exch{"AO3* DCA"}=" O3B DCA"; $resn_exch{"AP3* DCA"}=" P3B DCA"; $resn_exch{" AO7 DCA"}=" O7A DCA";
$resn_exch{" AO8 DCA"}=" O8A DCA"; $resn_exch{" AO9 DCA"}=" O9A DCA"; $resn_exch{"AC4* DCA"}=" C4B DCA";
$resn_exch{"AO4* DCA"}=" O4B DCA"; $resn_exch{"AC5* DCA"}=" C5B DCA"; $resn_exch{"AO5* DCA"}=" O5B DCA";
$resn_exch{" AP1 DCA"}=" P1A DCA"; $resn_exch{" AO1 DCA"}=" O1A DCA"; $resn_exch{" AO2 DCA"}=" O2A DCA";
$resn_exch{" AO3 DCA"}=" O3A DCA"; $resn_exch{" AP2 DCA"}=" P2A DCA"; $resn_exch{" AO4 DCA"}=" O4A DCA";
$resn_exch{" AO5 DCA"}=" O5A DCA"; $resn_exch{" AO6 DCA"}=" O6A DCA"; $resn_exch{"PC11 DCA"}=" CBP DCA";
$resn_exch{"PC12 DCA"}=" CCP DCA"; $resn_exch{"PC13 DCA"}=" CDP DCA"; $resn_exch{"PC14 DCA"}=" CEP DCA";
$resn_exch{"PC10 DCA"}=" CAP DCA"; $resn_exch{"PO10 DCA"}=" OAP DCA"; $resn_exch{" PC9 DCA"}=" C9P DCA";
$resn_exch{" PO9 DCA"}=" O9P DCA"; $resn_exch{" PN8 DCA"}=" N8P DCA"; $resn_exch{" PC7 DCA"}=" C7P DCA";
$resn_exch{" PC6 DCA"}=" C6P DCA"; $resn_exch{" PC5 DCA"}=" C5P DCA"; $resn_exch{" PO5 DCA"}=" O5P DCA";
$resn_exch{" PN4 DCA"}=" N4P DCA"; $resn_exch{" PC3 DCA"}=" C3P DCA"; $resn_exch{" PC2 DCA"}=" C2P DCA";
$resn_exch{" O1P DCG"}=" OP1 DCG"; $resn_exch{" O2P DCG"}=" OP2 DCG"; $resn_exch{" O3P DCG"}=" OP3 DCG";
$resn_exch{" O5* DCG"}=" O5' DCG"; $resn_exch{" C5* DCG"}=" C5' DCG"; $resn_exch{" C4* DCG"}=" C4' DCG";
$resn_exch{" O4* DCG"}=" O4' DCG"; $resn_exch{" C3* DCG"}=" C3' DCG"; $resn_exch{" O3* DCG"}=" O3' DCG";
$resn_exch{" C2* DCG"}=" C2' DCG"; $resn_exch{" C1* DCG"}=" C1' DCG"; $resn_exch{" C1* DCM"}=" C1' DCM";
$resn_exch{" C2* DCM"}=" C2' DCM"; $resn_exch{" C3* DCM"}=" C3' DCM"; $resn_exch{" C4* DCM"}=" C4' DCM";
$resn_exch{" O4* DCM"}=" O4' DCM"; $resn_exch{" O3* DCM"}=" O3' DCM"; $resn_exch{" C5* DCM"}=" C5' DCM";
$resn_exch{" O5* DCM"}=" O5' DCM"; $resn_exch{" C1* DCP"}=" C1' DCP"; $resn_exch{" C2* DCP"}=" C2' DCP";
$resn_exch{" C3* DCP"}=" C3' DCP"; $resn_exch{" C4* DCP"}=" C4' DCP"; $resn_exch{" O4* DCP"}=" O4' DCP";
$resn_exch{" O3* DCP"}=" O3' DCP"; $resn_exch{" C5* DCP"}=" C5' DCP"; $resn_exch{" O5* DCP"}=" O5' DCP";
$resn_exch{" C1* DCT"}=" C1' DCT"; $resn_exch{" C2* DCT"}=" C2' DCT"; $resn_exch{" C3* DCT"}=" C3' DCT";
$resn_exch{" C4* DCT"}=" C4' DCT"; $resn_exch{" O4* DCT"}=" O4' DCT"; $resn_exch{" C5* DCT"}=" C5' DCT";
$resn_exch{" O5* DCT"}=" O5' DCT"; $resn_exch{" C1* DCZ"}=" C1' DCZ"; $resn_exch{" C2* DCZ"}=" C2' DCZ";
$resn_exch{" C3* DCZ"}=" C3' DCZ"; $resn_exch{" C4* DCZ"}=" C4' DCZ"; $resn_exch{" O4* DCZ"}=" O4' DCZ";
$resn_exch{" O3* DCZ"}=" O3' DCZ"; $resn_exch{" C5* DCZ"}=" C5' DCZ"; $resn_exch{" O5* DCZ"}=" O5' DCZ";
$resn_exch{" O3P DDG"}=" OP3 DDG"; $resn_exch{" O1P DDG"}=" OP1 DDG"; $resn_exch{" O2P DDG"}=" OP2 DDG";
$resn_exch{" O5* DDG"}=" O5' DDG"; $resn_exch{" C5* DDG"}=" C5' DDG"; $resn_exch{" C4* DDG"}=" C4' DDG";
$resn_exch{" O4* DDG"}=" O4' DDG"; $resn_exch{" C3* DDG"}=" C3' DDG"; $resn_exch{" C2* DDG"}=" C2' DDG";
$resn_exch{" C1* DDG"}=" C1' DDG"; $resn_exch{" N_A DDH"}=" NA  DDH"; $resn_exch{" N_B DDH"}=" NB  DDH";
$resn_exch{" N_C DDH"}=" NC  DDH"; $resn_exch{" N_D DDH"}=" ND  DDH"; $resn_exch{" O3P DDN"}=" OP3 DDN";
$resn_exch{" O1P DDN"}=" OP1 DDN"; $resn_exch{" O2P DDN"}=" OP2 DDN"; $resn_exch{" O5* DDN"}=" O5' DDN";
$resn_exch{" C5* DDN"}=" C5' DDN"; $resn_exch{" C4* DDN"}=" C4' DDN"; $resn_exch{" O4* DDN"}=" O4' DDN";
$resn_exch{" C3* DDN"}=" C3' DDN"; $resn_exch{" O3* DDN"}=" O3' DDN"; $resn_exch{" C2* DDN"}=" C2' DDN";
$resn_exch{" C1* DDN"}=" C1' DDN"; $resn_exch{" S*  DDT"}=" S'  DDT"; $resn_exch{" O1* DDT"}=" O1' DDT";
$resn_exch{" O2* DDT"}=" O2' DDT"; $resn_exch{" C1* DDT"}=" C1' DDT"; $resn_exch{" C2* DDT"}=" C2' DDT";
$resn_exch{" C3* DDT"}=" C3' DDT"; $resn_exch{" C4* DDT"}=" C4' DDT"; $resn_exch{"C4A* DDT"}=" C4X DDT";
$resn_exch{" C5* DDT"}=" C5' DDT"; $resn_exch{" C6* DDT"}=" C6' DDT"; $resn_exch{" C7* DDT"}=" C7' DDT";
$resn_exch{" C8* DDT"}=" C8' DDT"; $resn_exch{"C8A* DDT"}=" C8X DDT"; $resn_exch{" C9* DDT"}=" C9' DDT";
$resn_exch{"C10* DDT"}=" CA' DDT"; $resn_exch{" N1* DDT"}=" N1' DDT"; $resn_exch{" C1* DDU"}=" C1' DDU";
$resn_exch{" C2* DDU"}=" C2' DDU"; $resn_exch{" C3* DDU"}=" C3' DDU"; $resn_exch{" C4* DDU"}=" C4' DDU";
$resn_exch{" O3* DDU"}=" O3' DDU"; $resn_exch{" O4* DDU"}=" O4' DDU"; $resn_exch{" C5* DDU"}=" C5' DDU";
$resn_exch{" O1P DDX"}=" OP1 DDX"; $resn_exch{" O2P DDX"}=" OP2 DDX"; $resn_exch{" O3P DDX"}=" OP3 DDX";
$resn_exch{" O5* DDX"}=" O5' DDX"; $resn_exch{" C5* DDX"}=" C5' DDX"; $resn_exch{" C4* DDX"}=" C4' DDX";
$resn_exch{" O4* DDX"}=" O4' DDX"; $resn_exch{" C1* DDX"}=" C1' DDX"; $resn_exch{" C3* DDX"}=" C3' DDX";
$resn_exch{" C2* DDX"}=" C2' DDX"; $resn_exch{" O1* DDX"}=" O1' DDX"; $resn_exch{" O5* DDY"}=" O5' DDY";
$resn_exch{" C5* DDY"}=" C5' DDY"; $resn_exch{" C4* DDY"}=" C4' DDY"; $resn_exch{" O4* DDY"}=" O4' DDY";
$resn_exch{" C3* DDY"}=" C3' DDY"; $resn_exch{" C2* DDY"}=" C2' DDY"; $resn_exch{" C1* DDY"}=" C1' DDY";
$resn_exch{" C1* DEA"}=" C1' DEA"; $resn_exch{" C2* DEA"}=" C2' DEA"; $resn_exch{" O2* DEA"}=" O2' DEA";
$resn_exch{" C3* DEA"}=" C3' DEA"; $resn_exch{" O3* DEA"}=" O3' DEA"; $resn_exch{" C4* DEA"}=" C4' DEA";
$resn_exch{" N_A DEU"}=" NA  DEU"; $resn_exch{" N_B DEU"}=" NB  DEU"; $resn_exch{" N_C DEU"}=" NC  DEU";
$resn_exch{" N_D DEU"}=" ND  DEU"; $resn_exch{" O3P DFC"}=" OP3 DFC"; $resn_exch{" O1P DFC"}=" OP1 DFC";
$resn_exch{" O2P DFC"}=" OP2 DFC"; $resn_exch{" O5* DFC"}=" O5' DFC"; $resn_exch{" C5* DFC"}=" C5' DFC";
$resn_exch{" C4* DFC"}=" C4' DFC"; $resn_exch{" O4* DFC"}=" O4' DFC"; $resn_exch{" C3* DFC"}=" C3' DFC";
$resn_exch{" O3* DFC"}=" O3' DFC"; $resn_exch{" C2* DFC"}=" C2' DFC"; $resn_exch{" C1* DFC"}=" C1' DFC";
$resn_exch{" O3P DFG"}=" OP3 DFG"; $resn_exch{" O1P DFG"}=" OP1 DFG"; $resn_exch{" O2P DFG"}=" OP2 DFG";
$resn_exch{" O5* DFG"}=" O5' DFG"; $resn_exch{" C5* DFG"}=" C5' DFG"; $resn_exch{" C4* DFG"}=" C4' DFG";
$resn_exch{" O4* DFG"}=" O4' DFG"; $resn_exch{" C3* DFG"}=" C3' DFG"; $resn_exch{" O3* DFG"}=" O3' DFG";
$resn_exch{" C2* DFG"}=" C2' DFG"; $resn_exch{" C1* DFG"}=" C1' DFG"; $resn_exch{" O1P DFT"}=" OP1 DFT";
$resn_exch{" O2P DFT"}=" OP2 DFT"; $resn_exch{" O3P DFT"}=" OP3 DFT"; $resn_exch{" O5* DFT"}=" O5' DFT";
$resn_exch{" C5* DFT"}=" C5' DFT"; $resn_exch{" C4* DFT"}=" C4' DFT"; $resn_exch{" O4* DFT"}=" O4' DFT";
$resn_exch{" C3* DFT"}=" C3' DFT"; $resn_exch{" O3* DFT"}=" O3' DFT"; $resn_exch{" C2* DFT"}=" C2' DFT";
$resn_exch{" C1* DFT"}=" C1' DFT"; $resn_exch{" O3P  DG"}=" OP3  DG"; $resn_exch{" O1P  DG"}=" OP1  DG";
$resn_exch{" O2P  DG"}=" OP2  DG"; $resn_exch{" O5*  DG"}=" O5'  DG"; $resn_exch{" C5*  DG"}=" C5'  DG";
$resn_exch{" C4*  DG"}=" C4'  DG"; $resn_exch{" O4*  DG"}=" O4'  DG"; $resn_exch{" C3*  DG"}=" C3'  DG";
$resn_exch{" O3*  DG"}=" O3'  DG"; $resn_exch{" C2*  DG"}=" C2'  DG"; $resn_exch{" C1*  DG"}=" C1'  DG";
$resn_exch{" C1* DG1"}=" C1' DG1"; $resn_exch{" O4* DG1"}=" O4' DG1"; $resn_exch{" C2* DG1"}=" C2' DG1";
$resn_exch{" O2* DG1"}=" O2' DG1"; $resn_exch{" C3* DG1"}=" C3' DG1"; $resn_exch{" O3* DG1"}=" O3' DG1";
$resn_exch{" C4* DG1"}=" C4' DG1"; $resn_exch{" C5* DG1"}=" C5' DG1"; $resn_exch{" O5* DG1"}=" O5' DG1";
$resn_exch{" O5* DG3"}=" O5' DG3"; $resn_exch{" C5* DG3"}=" C5' DG3"; $resn_exch{" C4* DG3"}=" C4' DG3";
$resn_exch{" O4* DG3"}=" O4' DG3"; $resn_exch{" C3* DG3"}=" C3' DG3"; $resn_exch{" C2* DG3"}=" C2' DG3";
$resn_exch{" C1* DG3"}=" C1' DG3"; $resn_exch{"AC10 DGA"}=" CAA DGA"; $resn_exch{"AC11 DGA"}=" CBA DGA";
$resn_exch{"AC12 DGA"}=" CCA DGA"; $resn_exch{"AC13 DGA"}=" CDA DGA"; $resn_exch{"AC14 DGA"}=" CEA DGA";
$resn_exch{"AC15 DGA"}=" CFA DGA"; $resn_exch{"AC16 DGA"}=" CGA DGA"; $resn_exch{"AC17 DGA"}=" CHA DGA";
$resn_exch{"AC18 DGA"}=" CIA DGA"; $resn_exch{"BC10 DGA"}=" CAB DGA"; $resn_exch{"BC11 DGA"}=" CBB DGA";
$resn_exch{"BC12 DGA"}=" CCB DGA"; $resn_exch{"BC13 DGA"}=" CDB DGA"; $resn_exch{"BC14 DGA"}=" CEB DGA";
$resn_exch{"BC15 DGA"}=" CFB DGA"; $resn_exch{"BC16 DGA"}=" CGB DGA"; $resn_exch{"BC17 DGA"}=" CHB DGA";
$resn_exch{"BC18 DGA"}=" CIB DGA"; $resn_exch{" AC1 DGD"}=" C1A DGD"; $resn_exch{" AC2 DGD"}=" C2A DGD";
$resn_exch{" AC3 DGD"}=" C3A DGD"; $resn_exch{" AC4 DGD"}=" C4A DGD"; $resn_exch{" AC5 DGD"}=" C5A DGD";
$resn_exch{" AC6 DGD"}=" C6A DGD"; $resn_exch{" AC7 DGD"}=" C7A DGD"; $resn_exch{" AC8 DGD"}=" C8A DGD";
$resn_exch{" AC9 DGD"}=" C9A DGD"; $resn_exch{"AC10 DGD"}=" CAA DGD"; $resn_exch{"AC11 DGD"}=" CBA DGD";
$resn_exch{"AC12 DGD"}=" CCA DGD"; $resn_exch{"AC13 DGD"}=" CDA DGD"; $resn_exch{"AC14 DGD"}=" CEA DGD";
$resn_exch{"AC15 DGD"}=" CFA DGD"; $resn_exch{"AC16 DGD"}=" CGA DGD"; $resn_exch{"AC17 DGD"}=" CHA DGD";
$resn_exch{"AC18 DGD"}=" CIA DGD"; $resn_exch{" AO1 DGD"}=" O1A DGD"; $resn_exch{" BC1 DGD"}=" C1B DGD";
$resn_exch{" BC2 DGD"}=" C2B DGD"; $resn_exch{" BC3 DGD"}=" C3B DGD"; $resn_exch{" BC4 DGD"}=" C4B DGD";
$resn_exch{" BC5 DGD"}=" C5B DGD"; $resn_exch{" BC6 DGD"}=" C6B DGD"; $resn_exch{" BC7 DGD"}=" C7B DGD";
$resn_exch{" BC8 DGD"}=" C8B DGD"; $resn_exch{" BC9 DGD"}=" C9B DGD"; $resn_exch{"BC10 DGD"}=" CAB DGD";
$resn_exch{"BC11 DGD"}=" CBB DGD"; $resn_exch{"BC12 DGD"}=" CCB DGD"; $resn_exch{"BC13 DGD"}=" CDB DGD";
$resn_exch{"BC14 DGD"}=" CEB DGD"; $resn_exch{"BC15 DGD"}=" CFB DGD"; $resn_exch{"BC16 DGD"}=" CGB DGD";
$resn_exch{"BC17 DGD"}=" CHB DGD"; $resn_exch{"BC18 DGD"}=" CIB DGD"; $resn_exch{" BO1 DGD"}=" O1B DGD";
$resn_exch{" GO1 DGD"}=" O1G DGD"; $resn_exch{" GC1 DGD"}=" C1G DGD"; $resn_exch{" GC2 DGD"}=" C2G DGD";
$resn_exch{" GO2 DGD"}=" O2G DGD"; $resn_exch{" GC3 DGD"}=" C3G DGD"; $resn_exch{" GO3 DGD"}=" O3G DGD";
$resn_exch{" DC1 DGD"}=" C1D DGD"; $resn_exch{" DC2 DGD"}=" C2D DGD"; $resn_exch{" DO2 DGD"}=" O2D DGD";
$resn_exch{" DC3 DGD"}=" C3D DGD"; $resn_exch{" DO3 DGD"}=" O3D DGD"; $resn_exch{" DC4 DGD"}=" C4D DGD";
$resn_exch{" DO4 DGD"}=" O4D DGD"; $resn_exch{" DC5 DGD"}=" C5D DGD"; $resn_exch{" DO5 DGD"}=" O5D DGD";
$resn_exch{" DC6 DGD"}=" C6D DGD"; $resn_exch{" DO6 DGD"}=" O6D DGD"; $resn_exch{" EC1 DGD"}=" C1E DGD";
$resn_exch{" EC2 DGD"}=" C2E DGD"; $resn_exch{" EO2 DGD"}=" O2E DGD"; $resn_exch{" EC3 DGD"}=" C3E DGD";
$resn_exch{" EO3 DGD"}=" O3E DGD"; $resn_exch{" EC4 DGD"}=" C4E DGD"; $resn_exch{" EO4 DGD"}=" O4E DGD";
$resn_exch{" EC5 DGD"}=" C5E DGD"; $resn_exch{" EO6 DGD"}=" O6E DGD"; $resn_exch{" EC6 DGD"}=" C6E DGD";
$resn_exch{" EO5 DGD"}=" O5E DGD"; $resn_exch{" O5* DGI"}=" O5' DGI"; $resn_exch{" C5* DGI"}=" C5' DGI";
$resn_exch{" C4* DGI"}=" C4' DGI"; $resn_exch{" O4* DGI"}=" O4' DGI"; $resn_exch{" C3* DGI"}=" C3' DGI";
$resn_exch{" O3* DGI"}=" O3' DGI"; $resn_exch{" C2* DGI"}=" C2' DGI"; $resn_exch{" C1* DGI"}=" C1' DGI";
$resn_exch{" O1P DGP"}=" OP1 DGP"; $resn_exch{" O2P DGP"}=" OP2 DGP"; $resn_exch{" O3P DGP"}=" OP3 DGP";
$resn_exch{" O5* DGP"}=" O5' DGP"; $resn_exch{" C5* DGP"}=" C5' DGP"; $resn_exch{" C4* DGP"}=" C4' DGP";
$resn_exch{" O4* DGP"}=" O4' DGP"; $resn_exch{" C3* DGP"}=" C3' DGP"; $resn_exch{" O3* DGP"}=" O3' DGP";
$resn_exch{" C2* DGP"}=" C2' DGP"; $resn_exch{" C1* DGP"}=" C1' DGP"; $resn_exch{" O5* DGT"}=" O5' DGT";
$resn_exch{" C5* DGT"}=" C5' DGT"; $resn_exch{" C4* DGT"}=" C4' DGT"; $resn_exch{" O4* DGT"}=" O4' DGT";
$resn_exch{" C3* DGT"}=" C3' DGT"; $resn_exch{" O3* DGT"}=" O3' DGT"; $resn_exch{" C2* DGT"}=" C2' DGT";
$resn_exch{" C1* DGT"}=" C1' DGT"; $resn_exch{" C5* DH3"}=" C5' DH3"; $resn_exch{" C4* DH3"}=" C4B DH3";
$resn_exch{" C2* DH9"}=" C2' DH9"; $resn_exch{" C1* DH9"}=" C1' DH9"; $resn_exch{" O1* DH9"}=" O1' DH9";
$resn_exch{" O2* DH9"}=" O2' DH9"; $resn_exch{" C3* DH9"}=" C3' DH9"; $resn_exch{" O3* DH9"}=" O3' DH9";
$resn_exch{" C4* DH9"}=" C4' DH9"; $resn_exch{" C5* DH9"}=" C5' DH9"; $resn_exch{" O4* DH9"}=" O4' DH9";
$resn_exch{" O5* DH9"}=" O5' DH9"; $resn_exch{" N1* DH9"}=" N1' DH9"; $resn_exch{" O6* DH9"}=" O6' DH9";
$resn_exch{" C6* DH9"}=" C6' DH9"; $resn_exch{" C7* DH9"}=" C7' DH9"; $resn_exch{" C8* DH9"}=" C8' DH9";
$resn_exch{" C9* DH9"}=" C9' DH9"; $resn_exch{" N_A DHE"}=" NA  DHE"; $resn_exch{" N_B DHE"}=" NB  DHE";
$resn_exch{" N_C DHE"}=" NC  DHE"; $resn_exch{" N_D DHE"}=" ND  DHE"; $resn_exch{" O1P DHU"}=" OP1 DHU";
$resn_exch{" O2P DHU"}=" OP2 DHU"; $resn_exch{" O3P DHU"}=" OP3 DHU"; $resn_exch{" O5* DHU"}=" O5' DHU";
$resn_exch{" C5* DHU"}=" C5' DHU"; $resn_exch{" C4* DHU"}=" C4' DHU"; $resn_exch{" O4* DHU"}=" O4' DHU";
$resn_exch{" C3* DHU"}=" C3' DHU"; $resn_exch{" O3* DHU"}=" O3' DHU"; $resn_exch{" C2* DHU"}=" C2' DHU";
$resn_exch{" O2* DHU"}=" O2' DHU"; $resn_exch{" C1* DHU"}=" C1' DHU"; $resn_exch{" O3P  DI"}=" OP3  DI";
$resn_exch{" O1P  DI"}=" OP1  DI"; $resn_exch{" O2P  DI"}=" OP2  DI"; $resn_exch{" O5*  DI"}=" O5'  DI";
$resn_exch{" C5*  DI"}=" C5'  DI"; $resn_exch{" C4*  DI"}=" C4'  DI"; $resn_exch{" O4*  DI"}=" O4'  DI";
$resn_exch{" C3*  DI"}=" C3'  DI"; $resn_exch{" O3*  DI"}=" O3'  DI"; $resn_exch{" C2*  DI"}=" C2'  DI";
$resn_exch{" C1*  DI"}=" C1'  DI"; $resn_exch{" O5* DIH"}=" O5' DIH"; $resn_exch{" C5* DIH"}=" C5' DIH";
$resn_exch{" C4* DIH"}=" C4' DIH"; $resn_exch{" C6* DIH"}=" C6' DIH"; $resn_exch{" C3* DIH"}=" C3' DIH";
$resn_exch{" O3* DIH"}=" O3' DIH"; $resn_exch{" C2* DIH"}=" C2' DIH"; $resn_exch{" N1* DIH"}=" N1' DIH";
$resn_exch{" XC1 DIT"}=" C1X DIT"; $resn_exch{" XN2 DIT"}=" N2X DIT"; $resn_exch{" XC3 DIT"}=" C3X DIT";
$resn_exch{" XC4 DIT"}=" C4X DIT"; $resn_exch{" XC5 DIT"}=" C5X DIT"; $resn_exch{" XC6 DIT"}=" C6X DIT";
$resn_exch{" XN7 DIT"}=" N7X DIT"; $resn_exch{" XC8 DIT"}=" C8X DIT"; $resn_exch{" XC9 DIT"}=" C9X DIT";
$resn_exch{"XC10 DIT"}=" CAX DIT"; $resn_exch{"XO10 DIT"}=" OAX DIT"; $resn_exch{"XC11 DIT"}=" CBX DIT";
$resn_exch{"XC12 DIT"}=" CCX DIT"; $resn_exch{"XC13 DIT"}=" CDX DIT"; $resn_exch{"XC14 DIT"}=" CEX DIT";
$resn_exch{"XC15 DIT"}=" CFX DIT"; $resn_exch{"XC16 DIT"}=" CGX DIT"; $resn_exch{"XC17 DIT"}=" CHX DIT";
$resn_exch{"XC18 DIT"}=" CIX DIT"; $resn_exch{"XC19 DIT"}=" CJX DIT"; $resn_exch{"XC20 DIT"}=" CKX DIT";
$resn_exch{"XN21 DIT"}=" NLX DIT"; $resn_exch{"XC22 DIT"}=" CMX DIT"; $resn_exch{"XC23 DIT"}=" CNX DIT";
$resn_exch{"XC24 DIT"}=" COX DIT"; $resn_exch{"XC25 DIT"}=" CPX DIT"; $resn_exch{"XC26 DIT"}=" CQX DIT";
$resn_exch{" C1* DM1"}=" C1' DM1"; $resn_exch{" C2* DM1"}=" C2' DM1"; $resn_exch{" C3* DM1"}=" C3' DM1";
$resn_exch{" N3* DM1"}=" N3' DM1"; $resn_exch{" C4* DM1"}=" C4' DM1"; $resn_exch{" O4* DM1"}=" O4' DM1";
$resn_exch{" C5* DM1"}=" C5' DM1"; $resn_exch{" O5* DM1"}=" O5' DM1"; $resn_exch{" C6* DM1"}=" C6' DM1";
$resn_exch{" C1* DM2"}=" C1' DM2"; $resn_exch{" C2* DM2"}=" C2' DM2"; $resn_exch{" C3* DM2"}=" C3' DM2";
$resn_exch{" N3* DM2"}=" N3' DM2"; $resn_exch{" C4* DM2"}=" C4' DM2"; $resn_exch{" O4* DM2"}=" O4' DM2";
$resn_exch{" C5* DM2"}=" C5' DM2"; $resn_exch{" O5* DM2"}=" O5' DM2"; $resn_exch{" C6* DM2"}=" C6' DM2";
$resn_exch{" C1* DM3"}=" C1' DM3"; $resn_exch{" C2* DM3"}=" C2' DM3"; $resn_exch{" C3* DM3"}=" C3' DM3";
$resn_exch{" N3* DM3"}=" N3' DM3"; $resn_exch{" C4* DM3"}=" C4' DM3"; $resn_exch{" O4* DM3"}=" O4' DM3";
$resn_exch{" C5* DM3"}=" C5' DM3"; $resn_exch{" O5* DM3"}=" O5' DM3"; $resn_exch{" C6* DM3"}=" C6' DM3";
$resn_exch{" C1* DM4"}=" C1' DM4"; $resn_exch{" C2* DM4"}=" C2' DM4"; $resn_exch{" C3* DM4"}=" C3' DM4";
$resn_exch{" N3* DM4"}=" N3' DM4"; $resn_exch{" C4* DM4"}=" C4' DM4"; $resn_exch{" O4* DM4"}=" O4' DM4";
$resn_exch{" C5* DM4"}=" C5' DM4"; $resn_exch{" O5* DM4"}=" O5' DM4"; $resn_exch{" C6* DM4"}=" C6' DM4";
$resn_exch{" C1* DM5"}=" C1' DM5"; $resn_exch{" C2* DM5"}=" C2' DM5"; $resn_exch{" C3* DM5"}=" C3' DM5";
$resn_exch{" N3* DM5"}=" N3' DM5"; $resn_exch{" C4* DM5"}=" C4' DM5"; $resn_exch{" O4* DM5"}=" O4' DM5";
$resn_exch{" C5* DM5"}=" C5' DM5"; $resn_exch{" O5* DM5"}=" O5' DM5"; $resn_exch{" C6* DM5"}=" C6' DM5";
$resn_exch{" C1* DM6"}=" C1' DM6"; $resn_exch{" C2* DM6"}=" C2' DM6"; $resn_exch{" C3* DM6"}=" C3' DM6";
$resn_exch{" C4* DM6"}=" C4' DM6"; $resn_exch{" C5* DM6"}=" C5' DM6"; $resn_exch{" C6* DM6"}=" C6' DM6";
$resn_exch{" O4* DM6"}=" O4' DM6"; $resn_exch{" O5* DM6"}=" O5' DM6"; $resn_exch{" N3* DM6"}=" N3' DM6";
$resn_exch{" C1* DM7"}=" C1' DM7"; $resn_exch{" C2* DM7"}=" C2' DM7"; $resn_exch{" C3* DM7"}=" C3' DM7";
$resn_exch{" C4* DM7"}=" C4' DM7"; $resn_exch{" C5* DM7"}=" C5' DM7"; $resn_exch{" C6* DM7"}=" C6' DM7";
$resn_exch{" O5* DM7"}=" O5' DM7"; $resn_exch{" N3* DM7"}=" N3' DM7"; $resn_exch{" I4* DM7"}=" I4' DM7";
$resn_exch{" C1* DM8"}=" C1' DM8"; $resn_exch{" C2* DM8"}=" C2' DM8"; $resn_exch{" C3* DM8"}=" C3' DM8";
$resn_exch{" C4* DM8"}=" C4' DM8"; $resn_exch{" C5* DM8"}=" C5' DM8"; $resn_exch{" C6* DM8"}=" C6' DM8";
$resn_exch{" O5* DM8"}=" O5' DM8"; $resn_exch{" O4* DM8"}=" O4' DM8"; $resn_exch{" N3* DM8"}=" N3' DM8";
$resn_exch{" C1* DM9"}=" C1' DM9"; $resn_exch{" C2* DM9"}=" C2' DM9"; $resn_exch{" C3* DM9"}=" C3' DM9";
$resn_exch{" C4* DM9"}=" C4' DM9"; $resn_exch{" O4* DM9"}=" O4' DM9"; $resn_exch{" C5* DM9"}=" C5' DM9";
$resn_exch{" O5* DM9"}=" O5' DM9"; $resn_exch{" C6* DM9"}=" C6' DM9"; $resn_exch{" N3* DM9"}=" N3' DM9";
$resn_exch{" O1  DMK"}=" OXT DMK"; $resn_exch{" C1* DMM"}=" C1' DMM"; $resn_exch{" C2* DMM"}=" C2' DMM";
$resn_exch{" C3* DMM"}=" C3' DMM"; $resn_exch{" C4* DMM"}=" C4' DMM"; $resn_exch{" O4* DMM"}=" O4' DMM";
$resn_exch{" C5* DMM"}=" C5' DMM"; $resn_exch{" O5* DMM"}=" O5' DMM"; $resn_exch{" C6* DMM"}=" C6' DMM";
$resn_exch{" N3* DMM"}=" N3' DMM"; $resn_exch{"O1PN DND"}=" O11 DND"; $resn_exch{"O2PN DND"}=" O12 DND";
$resn_exch{"O5'N DND"}=" O5D DND"; $resn_exch{"C5'N DND"}=" C5D DND"; $resn_exch{"C4'N DND"}=" C4D DND";
$resn_exch{"O4'N DND"}=" O4D DND"; $resn_exch{"C3'N DND"}=" C3D DND"; $resn_exch{"O3'N DND"}=" O3D DND";
$resn_exch{"C2'N DND"}=" C2D DND"; $resn_exch{"O2'N DND"}=" O2D DND"; $resn_exch{"C1'N DND"}=" C1D DND";
$resn_exch{"O1PA DND"}=" O13 DND"; $resn_exch{"O2PA DND"}=" O14 DND"; $resn_exch{"O5'A DND"}=" O5B DND";
$resn_exch{"C5'A DND"}=" C5B DND"; $resn_exch{"C4'A DND"}=" C4B DND"; $resn_exch{"O4'A DND"}=" O4B DND";
$resn_exch{"C3'A DND"}=" C3B DND"; $resn_exch{"O3'A DND"}=" O3B DND"; $resn_exch{"C2'A DND"}=" C2B DND";
$resn_exch{"O2'A DND"}=" O2B DND"; $resn_exch{"C1'A DND"}=" C1B DND"; $resn_exch{" O1  DNE"}=" OXT DNE";
$resn_exch{" O1  DNM"}=" OXT DNM"; $resn_exch{" O1P DNR"}=" OP1 DNR"; $resn_exch{" O2P DNR"}=" OP2 DNR";
$resn_exch{" O5* DNR"}=" O5' DNR"; $resn_exch{" C5* DNR"}=" C5' DNR"; $resn_exch{" C4* DNR"}=" C4' DNR";
$resn_exch{" O4* DNR"}=" O4' DNR"; $resn_exch{" C1* DNR"}=" C1' DNR"; $resn_exch{" C2* DNR"}=" C2' DNR";
$resn_exch{" C3* DNR"}=" C3' DNR"; $resn_exch{" O3* DNR"}=" O3' DNR"; $resn_exch{" O3P DNR"}=" OP3 DNR";
$resn_exch{" O   DNS"}=" OXT DNS"; $resn_exch{" OXT DNS"}=" O   DNS"; $resn_exch{" C1* DOC"}=" C1' DOC";
$resn_exch{" C2* DOC"}=" C2' DOC"; $resn_exch{" C3* DOC"}=" C3' DOC"; $resn_exch{" C4* DOC"}=" C4' DOC";
$resn_exch{" O4* DOC"}=" O4' DOC"; $resn_exch{" C5* DOC"}=" C5' DOC"; $resn_exch{" O5* DOC"}=" O5' DOC";
$resn_exch{" O1P DOC"}=" OP1 DOC"; $resn_exch{" O2P DOC"}=" OP2 DOC"; $resn_exch{" O3P DOC"}=" OP3 DOC";
$resn_exch{" O5* DOI"}=" O5' DOI"; $resn_exch{" C5* DOI"}=" C5' DOI"; $resn_exch{" C4* DOI"}=" C4' DOI";
$resn_exch{" O4* DOI"}=" O4' DOI"; $resn_exch{" C1* DOI"}=" C1' DOI"; $resn_exch{" C2* DOI"}=" C2' DOI";
$resn_exch{" C3* DOI"}=" C3' DOI"; $resn_exch{" O3* DOI"}=" O3' DOI"; $resn_exch{" O5* DOT"}=" O5' DOT";
$resn_exch{" C5* DOT"}=" C5B DOT"; $resn_exch{" C4* DOT"}=" C4B DOT"; $resn_exch{" O4* DOT"}=" O4' DOT";
$resn_exch{" C3* DOT"}=" C3B DOT"; $resn_exch{" O3* DOT"}=" O3' DOT"; $resn_exch{" C2* DOT"}=" C2B DOT";
$resn_exch{" C1* DOT"}=" C1B DOT"; $resn_exch{" C1* DPB"}=" C1' DPB"; $resn_exch{" O4* DPB"}=" O4' DPB";
$resn_exch{" C4* DPB"}=" C4' DPB"; $resn_exch{" C3* DPB"}=" C3' DPB"; $resn_exch{" C2* DPB"}=" C2' DPB";
$resn_exch{" C5* DPB"}=" C5' DPB"; $resn_exch{" O5* DPB"}=" O5' DPB"; $resn_exch{" C6* DPB"}=" C6' DPB";
$resn_exch{" O3* DPB"}=" O3' DPB"; $resn_exch{" O2P DPB"}=" OP2 DPB"; $resn_exch{" O1P DPB"}=" OP1 DPB";
$resn_exch{" O3P DPB"}=" OP3 DPB"; $resn_exch{" C1\" DPI"}=" C1D DPI"; $resn_exch{" C2\" DPI"}=" C2D DPI";
$resn_exch{" C3\" DPI"}=" C3D DPI"; $resn_exch{" C4\" DPI"}=" C4D DPI"; $resn_exch{" C5\" DPI"}=" C5D DPI";
$resn_exch{" C6\" DPI"}=" C6' DPI"; $resn_exch{" O7\" DPI"}=" O7' DPI"; $resn_exch{" O8\" DPI"}=" O8' DPI";
$resn_exch{" O9\" DPI"}=" O9D DPI"; $resn_exch{" O5* DPY"}=" O5' DPY"; $resn_exch{" C2* DPY"}=" C2' DPY";
$resn_exch{" C5* DPY"}=" C5' DPY"; $resn_exch{" C4* DPY"}=" C4' DPY"; $resn_exch{" O4* DPY"}=" O4' DPY";
$resn_exch{" C1* DPY"}=" C1' DPY"; $resn_exch{" C3* DPY"}=" C3' DPY"; $resn_exch{" O3* DPY"}=" O3' DPY";
$resn_exch{" O1* DR2"}=" O1' DR2"; $resn_exch{" C1* DR2"}=" C1' DR2"; $resn_exch{" O5* DR2"}=" O5' DR2";
$resn_exch{" C5* DR2"}=" C5' DR2"; $resn_exch{" C6* DR2"}=" C6' DR2"; $resn_exch{" O6* DR2"}=" O6' DR2";
$resn_exch{" C4* DR2"}=" C4' DR2"; $resn_exch{" O4* DR2"}=" O4' DR2"; $resn_exch{" C3* DR2"}=" C3' DR2";
$resn_exch{" O3* DR2"}=" O3' DR2"; $resn_exch{" C2* DR2"}=" C2' DR2"; $resn_exch{" O2* DR2"}=" O2' DR2";
$resn_exch{" O2* DR3"}=" O2' DR3"; $resn_exch{" C2* DR3"}=" C2' DR3"; $resn_exch{" C3* DR3"}=" C3' DR3";
$resn_exch{" O3* DR3"}=" O3' DR3"; $resn_exch{" C4* DR3"}=" C4' DR3"; $resn_exch{" O4* DR3"}=" O4' DR3";
$resn_exch{" C5* DR3"}=" C5' DR3"; $resn_exch{" C6* DR3"}=" C6' DR3"; $resn_exch{" O6* DR3"}=" O6' DR3";
$resn_exch{" O5* DR3"}=" O5' DR3"; $resn_exch{" C1* DR3"}=" C1' DR3"; $resn_exch{" O1* DR3"}=" O1' DR3";
$resn_exch{" C1* DRA"}=" C1' DRA"; $resn_exch{" C2* DRA"}=" C2' DRA"; $resn_exch{" C3* DRA"}=" C3' DRA";
$resn_exch{" N3* DRA"}=" N3' DRA"; $resn_exch{" C7* DRA"}=" C7' DRA"; $resn_exch{" C8* DRA"}=" C8' DRA";
$resn_exch{" O5* DRA"}=" O5' DRA"; $resn_exch{" C5* DRA"}=" C5' DRA"; $resn_exch{" C6* DRA"}=" C6' DRA";
$resn_exch{" C4* DRA"}=" C4' DRA"; $resn_exch{" O4* DRA"}=" O4' DRA"; $resn_exch{" O2P DRM"}=" OP2 DRM";
$resn_exch{" O1P DRM"}=" OP1 DRM"; $resn_exch{" O3P DRM"}=" OP3 DRM"; $resn_exch{" C6* DRM"}=" C6' DRM";
$resn_exch{" O5* DRM"}=" O5' DRM"; $resn_exch{" C5* DRM"}=" C5' DRM"; $resn_exch{" C4* DRM"}=" C4' DRM";
$resn_exch{" C3* DRM"}=" C3' DRM"; $resn_exch{" C2* DRM"}=" C2' DRM"; $resn_exch{" C1* DRM"}=" C1' DRM";
$resn_exch{" O5* DRP"}=" O5' DRP"; $resn_exch{" C2* DRP"}=" C2' DRP"; $resn_exch{" C5* DRP"}=" C5' DRP";
$resn_exch{" C4* DRP"}=" C4' DRP"; $resn_exch{" O4* DRP"}=" O4' DRP"; $resn_exch{" C1* DRP"}=" C1' DRP";
$resn_exch{" C3* DRP"}=" C3' DRP"; $resn_exch{" O3* DRP"}=" O3' DRP"; $resn_exch{" O3P DRT"}=" OP3 DRT";
$resn_exch{" O1P DRT"}=" OP1 DRT"; $resn_exch{" O2P DRT"}=" OP2 DRT"; $resn_exch{" O5* DRT"}=" O5' DRT";
$resn_exch{" C5* DRT"}=" C5' DRT"; $resn_exch{" C4* DRT"}=" C4' DRT"; $resn_exch{" O4* DRT"}=" O4' DRT";
$resn_exch{" C3* DRT"}=" C3' DRT"; $resn_exch{" O3* DRT"}=" O3' DRT"; $resn_exch{" C2* DRT"}=" C2' DRT";
$resn_exch{" C1* DRT"}=" C1' DRT"; $resn_exch{" O1P DRZ"}=" OP1 DRZ"; $resn_exch{" O2P DRZ"}=" OP2 DRZ";
$resn_exch{" O3P DRZ"}=" OP3 DRZ"; $resn_exch{" O5* DRZ"}=" O5' DRZ"; $resn_exch{" C5* DRZ"}=" C5' DRZ";
$resn_exch{" C4* DRZ"}=" C4' DRZ"; $resn_exch{" O4* DRZ"}=" O4' DRZ"; $resn_exch{" C3* DRZ"}=" C3' DRZ";
$resn_exch{" C2* DRZ"}=" C2' DRZ"; $resn_exch{" C1* DRZ"}=" C1' DRZ"; $resn_exch{" O3* DRZ"}=" O3' DRZ";
$resn_exch{" O6* DSU"}=" O6' DSU"; $resn_exch{" C6* DSU"}=" C6' DSU"; $resn_exch{" C5* DSU"}=" C5' DSU";
$resn_exch{" O2* DSU"}=" O2' DSU"; $resn_exch{" C4* DSU"}=" C4' DSU"; $resn_exch{" O4* DSU"}=" O4' DSU";
$resn_exch{" C3* DSU"}=" C3' DSU"; $resn_exch{" O3* DSU"}=" O3' DSU"; $resn_exch{" C2* DSU"}=" C2' DSU";
$resn_exch{" C1* DSU"}=" C1' DSU"; $resn_exch{" O1* DSU"}=" O1' DSU"; $resn_exch{" O3P  DT"}=" OP3  DT";
$resn_exch{" O1P  DT"}=" OP1  DT"; $resn_exch{" O2P  DT"}=" OP2  DT"; $resn_exch{" O5*  DT"}=" O5'  DT";
$resn_exch{" C5*  DT"}=" C5'  DT"; $resn_exch{" C4*  DT"}=" C4'  DT"; $resn_exch{" O4*  DT"}=" O4'  DT";
$resn_exch{" C3*  DT"}=" C3'  DT"; $resn_exch{" O3*  DT"}=" O3'  DT"; $resn_exch{" C2*  DT"}=" C2'  DT";
$resn_exch{" C1*  DT"}=" C1'  DT"; $resn_exch{" C5M  DT"}=" C7   DT"; $resn_exch{" C1* DTA"}=" C1' DTA";
$resn_exch{" O4* DTA"}=" O4' DTA"; $resn_exch{" C2* DTA"}=" C2' DTA"; $resn_exch{" O2* DTA"}=" O2' DTA";
$resn_exch{" C3* DTA"}=" C3' DTA"; $resn_exch{" O3* DTA"}=" O3' DTA"; $resn_exch{" C4* DTA"}=" C4' DTA";
$resn_exch{" C5* DTA"}=" C5' DTA"; $resn_exch{" S5* DTA"}=" S5' DTA"; $resn_exch{" C2* DTM"}=" C2B DTM";
$resn_exch{" C4* DTM"}=" C4B DTM"; $resn_exch{" C5* DTM"}=" C5B DTM"; $resn_exch{" C6* DTM"}=" C6B DTM";
$resn_exch{" C7* DTM"}=" C7' DTM"; $resn_exch{" C9* DTM"}=" C9' DTM"; $resn_exch{" CN* DTM"}=" CN' DTM";
$resn_exch{" N1* DTM"}=" N1' DTM"; $resn_exch{" N2* DTM"}=" N2' DTM"; $resn_exch{" N3* DTM"}=" N3' DTM";
$resn_exch{" N4* DTM"}=" N4' DTM"; $resn_exch{" N8* DTM"}=" N8' DTM"; $resn_exch{" N9* DTM"}=" N9' DTM";
$resn_exch{" O5* DTP"}=" O5' DTP"; $resn_exch{" C5* DTP"}=" C5' DTP"; $resn_exch{" C4* DTP"}=" C4' DTP";
$resn_exch{" O4* DTP"}=" O4' DTP"; $resn_exch{" C3* DTP"}=" C3' DTP"; $resn_exch{" O3* DTP"}=" O3' DTP";
$resn_exch{" C2* DTP"}=" C2' DTP"; $resn_exch{" C1* DTP"}=" C1' DTP"; $resn_exch{" O3P  DU"}=" OP3  DU";
$resn_exch{" O1P  DU"}=" OP1  DU"; $resn_exch{" O2P  DU"}=" OP2  DU"; $resn_exch{" O5*  DU"}=" O5'  DU";
$resn_exch{" C5*  DU"}=" C5'  DU"; $resn_exch{" C4*  DU"}=" C4'  DU"; $resn_exch{" O4*  DU"}=" O4'  DU";
$resn_exch{" C3*  DU"}=" C3'  DU"; $resn_exch{" O3*  DU"}=" O3'  DU"; $resn_exch{" C2*  DU"}=" C2'  DU";
$resn_exch{" C1*  DU"}=" C1'  DU"; $resn_exch{" C1* DUD"}=" C1' DUD"; $resn_exch{" C2* DUD"}=" C2' DUD";
$resn_exch{" C3* DUD"}=" C3' DUD"; $resn_exch{" C4* DUD"}=" C4' DUD"; $resn_exch{" O4* DUD"}=" O4' DUD";
$resn_exch{" O3* DUD"}=" O3' DUD"; $resn_exch{" C5* DUD"}=" C5' DUD"; $resn_exch{" O5* DUD"}=" O5' DUD";
$resn_exch{" C1* DUN"}=" C1' DUN"; $resn_exch{" C2* DUN"}=" C2' DUN"; $resn_exch{" C3* DUN"}=" C3' DUN";
$resn_exch{" C4* DUN"}=" C4' DUN"; $resn_exch{" O4* DUN"}=" O4' DUN"; $resn_exch{" O3* DUN"}=" O3' DUN";
$resn_exch{" C5* DUN"}=" C5' DUN"; $resn_exch{" O5* DUN"}=" O5' DUN"; $resn_exch{" C1* DUP"}=" C1' DUP";
$resn_exch{" C2* DUP"}=" C2' DUP"; $resn_exch{" C3* DUP"}=" C3' DUP"; $resn_exch{" O3* DUP"}=" O3' DUP";
$resn_exch{" O4* DUP"}=" O4' DUP"; $resn_exch{" C4* DUP"}=" C4' DUP"; $resn_exch{" C5* DUP"}=" C5' DUP";
$resn_exch{" O5* DUP"}=" O5' DUP"; $resn_exch{" C1* DUR"}=" C1' DUR"; $resn_exch{" C2* DUR"}=" C2' DUR";
$resn_exch{" C3* DUR"}=" C3' DUR"; $resn_exch{" C4* DUR"}=" C4' DUR"; $resn_exch{" O3* DUR"}=" O3' DUR";
$resn_exch{" O4* DUR"}=" O4' DUR"; $resn_exch{" C5* DUR"}=" C5' DUR"; $resn_exch{" O5* DUR"}=" O5' DUR";
$resn_exch{" C1* DUT"}=" C1' DUT"; $resn_exch{" C2* DUT"}=" C2' DUT"; $resn_exch{" C3* DUT"}=" C3' DUT";
$resn_exch{" C4* DUT"}=" C4' DUT"; $resn_exch{" O4* DUT"}=" O4' DUT"; $resn_exch{" O3* DUT"}=" O3' DUT";
$resn_exch{" C5* DUT"}=" C5' DUT"; $resn_exch{" O5* DUT"}=" O5' DUT"; $resn_exch{" O1P DXD"}=" OP1 DXD";
$resn_exch{" O2P DXD"}=" OP2 DXD"; $resn_exch{" O5* DXD"}=" O5' DXD"; $resn_exch{" C5* DXD"}=" C5' DXD";
$resn_exch{" C4* DXD"}=" C4' DXD"; $resn_exch{" C1* DXD"}=" C1' DXD"; $resn_exch{" C6* DXD"}=" C6' DXD";
$resn_exch{" O6* DXD"}=" O6' DXD"; $resn_exch{" C2* DXD"}=" C2' DXD"; $resn_exch{" C3* DXD"}=" C3' DXD";
$resn_exch{" O3* DXD"}=" O3' DXD"; $resn_exch{" O3P DXD"}=" OP3 DXD"; $resn_exch{" O1P DXN"}=" OP1 DXN";
$resn_exch{" O2P DXN"}=" OP2 DXN"; $resn_exch{" O5* DXN"}=" O5' DXN"; $resn_exch{" C5* DXN"}=" C5' DXN";
$resn_exch{" C4* DXN"}=" C4' DXN"; $resn_exch{" C1* DXN"}=" C1' DXN"; $resn_exch{" C6* DXN"}=" C6' DXN";
$resn_exch{" O6* DXN"}=" O6' DXN"; $resn_exch{" C2* DXN"}=" C2' DXN"; $resn_exch{" C3* DXN"}=" C3' DXN";
$resn_exch{" O3* DXN"}=" O3' DXN"; $resn_exch{" O3P DXN"}=" OP3 DXN"; $resn_exch{" O1P   E"}=" OP1   E";
$resn_exch{" O2P   E"}=" OP2   E"; $resn_exch{" O3P   E"}=" OP3   E"; $resn_exch{" O5*   E"}=" O5'   E";
$resn_exch{" C5*   E"}=" C5'   E"; $resn_exch{" C4*   E"}=" C4'   E"; $resn_exch{" O4*   E"}=" O4'   E";
$resn_exch{" C3*   E"}=" C3'   E"; $resn_exch{" O3*   E"}=" O3'   E"; $resn_exch{" C2*   E"}=" C2'   E";
$resn_exch{" C1*   E"}=" C1'   E"; $resn_exch{" O1P E1X"}=" OP1 E1X"; $resn_exch{" O2P E1X"}=" OP2 E1X";
$resn_exch{" O5* E1X"}=" O5' E1X"; $resn_exch{" C2* E1X"}=" C2' E1X"; $resn_exch{" C5* E1X"}=" C5' E1X";
$resn_exch{" C4* E1X"}=" C4' E1X"; $resn_exch{" O4* E1X"}=" O4' E1X"; $resn_exch{" C1* E1X"}=" C1' E1X";
$resn_exch{" C3* E1X"}=" C3' E1X"; $resn_exch{" O3* E1X"}=" O3' E1X"; $resn_exch{" O3P E1X"}=" OP3 E1X";
$resn_exch{" O1P EDA"}=" OP1 EDA"; $resn_exch{" O2P EDA"}=" OP2 EDA"; $resn_exch{" O3P EDA"}=" OP3 EDA";
$resn_exch{" O5* EDA"}=" O5' EDA"; $resn_exch{" C2* EDA"}=" C2' EDA"; $resn_exch{" C5* EDA"}=" C5' EDA";
$resn_exch{" C4* EDA"}=" C4' EDA"; $resn_exch{" O4* EDA"}=" O4' EDA"; $resn_exch{" C1* EDA"}=" C1' EDA";
$resn_exch{" C3* EDA"}=" C3' EDA"; $resn_exch{" O3* EDA"}=" O3' EDA"; $resn_exch{" O1P EDC"}=" OP1 EDC";
$resn_exch{" O2P EDC"}=" OP2 EDC"; $resn_exch{" O3P EDC"}=" OP3 EDC"; $resn_exch{" O5* EDC"}=" O5' EDC";
$resn_exch{" C5* EDC"}=" C5' EDC"; $resn_exch{" C4* EDC"}=" C4' EDC"; $resn_exch{" O4* EDC"}=" O4' EDC";
$resn_exch{" C1* EDC"}=" C1' EDC"; $resn_exch{" C2* EDC"}=" C2' EDC"; $resn_exch{" C3* EDC"}=" C3' EDC";
$resn_exch{" O3* EDC"}=" O3' EDC"; $resn_exch{" UN1 EEB"}=" N1U EEB"; $resn_exch{" UC2 EEB"}=" C2U EEB";
$resn_exch{" UN3 EEB"}=" N3U EEB"; $resn_exch{" UC4 EEB"}=" C4U EEB"; $resn_exch{" UC5 EEB"}=" C5U EEB";
$resn_exch{" UC6 EEB"}=" C6U EEB"; $resn_exch{" UO2 EEB"}=" O2U EEB"; $resn_exch{" UO4 EEB"}=" O4U EEB";
$resn_exch{"UC1* EEB"}=" C1D EEB"; $resn_exch{"UC2* EEB"}=" C2D EEB"; $resn_exch{"UO2* EEB"}=" O2D EEB";
$resn_exch{"UC3* EEB"}=" C3D EEB"; $resn_exch{"UC4* EEB"}=" C4D EEB"; $resn_exch{"UO4* EEB"}=" O4D EEB";
$resn_exch{"UO3* EEB"}=" O3D EEB"; $resn_exch{"UC5* EEB"}=" C5D EEB"; $resn_exch{"UO5* EEB"}=" O5D EEB";
$resn_exch{" EC1 EEB"}=" C1E EEB"; $resn_exch{" EC2 EEB"}=" C2E EEB"; $resn_exch{" EC3 EEB"}=" C3E EEB";
$resn_exch{" EC4 EEB"}=" C4E EEB"; $resn_exch{" EO1 EEB"}=" O1E EEB"; $resn_exch{" EO2 EEB"}=" O2E EEB";
$resn_exch{" O3P EIT"}=" OP3 EIT"; $resn_exch{" O2P EIT"}=" OP2 EIT"; $resn_exch{" O5* EIT"}=" O5' EIT";
$resn_exch{" C5* EIT"}=" C5' EIT"; $resn_exch{" C4* EIT"}=" C4' EIT"; $resn_exch{" O4* EIT"}=" O4' EIT";
$resn_exch{" C1* EIT"}=" C1' EIT"; $resn_exch{" C2* EIT"}=" C2' EIT"; $resn_exch{" O2* EIT"}=" O2' EIT";
$resn_exch{" C3* EIT"}=" C3' EIT"; $resn_exch{" O3* EIT"}=" O3' EIT"; $resn_exch{" O1P EIT"}=" OP1 EIT";
$resn_exch{" C5* EMA"}=" C5' EMA"; $resn_exch{" O5* EMA"}=" O5' EMA"; $resn_exch{" C4* EMA"}=" C4' EMA";
$resn_exch{" C1* EMA"}=" C1' EMA"; $resn_exch{" C1* ENA"}=" C1' ENA"; $resn_exch{" O2* ENA"}=" O2' ENA";
$resn_exch{" C2* ENA"}=" C2' ENA"; $resn_exch{" C4* ENA"}=" C4' ENA"; $resn_exch{" C3* ENA"}=" C3' ENA";
$resn_exch{" O4* ENA"}=" O4' ENA"; $resn_exch{" C5* ENA"}=" C5' ENA"; $resn_exch{" O3* ENA"}=" O3' ENA";
$resn_exch{" O5* ENA"}=" O5' ENA"; $resn_exch{" C6* ENA"}=" C6' ENA"; $resn_exch{" C7* ENA"}=" C7' ENA";
$resn_exch{" O6* ENA"}=" O6' ENA"; $resn_exch{" C8* ENA"}=" C8' ENA"; $resn_exch{" C9* ENA"}=" C9' ENA";
$resn_exch{" C0* ENA"}=" C0' ENA"; $resn_exch{" O7* ENA"}=" O7' ENA"; $resn_exch{" O8* ENA"}=" O8' ENA";
$resn_exch{" O5* ENP"}=" O5' ENP"; $resn_exch{" C5* ENP"}=" C5' ENP"; $resn_exch{" C4* ENP"}=" C4' ENP";
$resn_exch{" O4* ENP"}=" O4' ENP"; $resn_exch{" C3* ENP"}=" C3' ENP"; $resn_exch{" O3* ENP"}=" O3' ENP";
$resn_exch{" C2* ENP"}=" C2' ENP"; $resn_exch{" O2* ENP"}=" O2' ENP"; $resn_exch{" C1* ENP"}=" C1' ENP";
$resn_exch{" O9* ENP"}=" O9' ENP"; $resn_exch{" C0* ENP"}=" C0' ENP"; $resn_exch{" C9* ENP"}=" C9' ENP";
$resn_exch{" O8* ENP"}=" O8' ENP"; $resn_exch{" C8* ENP"}=" C8' ENP"; $resn_exch{" O7* ENP"}=" O7' ENP";
$resn_exch{" C7* ENP"}=" C7' ENP"; $resn_exch{" O6* ENP"}=" O6' ENP"; $resn_exch{" C6* ENP"}=" C6' ENP";
$resn_exch{" O2* EOM"}=" O2' EOM"; $resn_exch{" CA* EOM"}=" CA' EOM"; $resn_exch{" OB* EOM"}=" OB' EOM";
$resn_exch{" CC* EOM"}=" CC' EOM"; $resn_exch{" CD* EOM"}=" CD' EOM"; $resn_exch{" UN1 EPU"}=" N1U EPU";
$resn_exch{" UC2 EPU"}=" C2U EPU"; $resn_exch{" UN3 EPU"}=" N3U EPU"; $resn_exch{" UC4 EPU"}=" C4U EPU";
$resn_exch{" UC5 EPU"}=" C5U EPU"; $resn_exch{" UC6 EPU"}=" C6U EPU"; $resn_exch{" UO2 EPU"}=" O2U EPU";
$resn_exch{" UO4 EPU"}=" O4U EPU"; $resn_exch{"UC1* EPU"}=" C1D EPU"; $resn_exch{"UC2* EPU"}=" C2D EPU";
$resn_exch{"UO2* EPU"}=" O2D EPU"; $resn_exch{"UC3* EPU"}=" C3D EPU"; $resn_exch{"UC4* EPU"}=" C4D EPU";
$resn_exch{"UO4* EPU"}=" O4D EPU"; $resn_exch{"UO3* EPU"}=" O3D EPU"; $resn_exch{"UC5* EPU"}=" C5D EPU";
$resn_exch{"UO5* EPU"}=" O5D EPU"; $resn_exch{" EC1 EPU"}=" C1E EPU"; $resn_exch{" EO1 EPU"}=" O1E EPU";
$resn_exch{" EO2 EPU"}=" O2E EPU"; $resn_exch{" EC2 EPU"}=" C2E EPU"; $resn_exch{" EC3 EPU"}=" C3E EPU";
$resn_exch{" C1* ERT"}=" C1' ERT"; $resn_exch{" C2* ERT"}=" C2' ERT"; $resn_exch{" C3* ERT"}=" C3' ERT";
$resn_exch{" N3* ERT"}=" N3' ERT"; $resn_exch{" C7* ERT"}=" C7' ERT"; $resn_exch{" C8* ERT"}=" C8' ERT";
$resn_exch{" C4* ERT"}=" C4' ERT"; $resn_exch{" O4* ERT"}=" O4' ERT"; $resn_exch{" C5* ERT"}=" C5' ERT";
$resn_exch{" O5* ERT"}=" O5' ERT"; $resn_exch{" C6* ERT"}=" C6' ERT"; $resn_exch{" O5* F2N"}=" O5' F2N";
$resn_exch{" C5* F2N"}=" C5' F2N"; $resn_exch{" C4* F2N"}=" C4' F2N"; $resn_exch{" O4* F2N"}=" O4' F2N";
$resn_exch{" C3* F2N"}=" C3' F2N"; $resn_exch{" O3* F2N"}=" O3' F2N"; $resn_exch{" C2* F2N"}=" C2' F2N";
$resn_exch{" O2* F2N"}=" O2' F2N"; $resn_exch{" C1* F2N"}=" C1' F2N"; $resn_exch{" C1* F42"}=" C1' F42";
$resn_exch{" C2* F42"}=" C2' F42"; $resn_exch{" O2* F42"}=" O2' F42"; $resn_exch{" C3* F42"}=" C3' F42";
$resn_exch{" O3* F42"}=" O3' F42"; $resn_exch{" C4* F42"}=" C4' F42"; $resn_exch{" O4* F42"}=" O4' F42";
$resn_exch{" C5* F42"}=" C5' F42"; $resn_exch{" O5* F42"}=" O5' F42"; $resn_exch{" N_A F43"}=" NA  F43";
$resn_exch{" N_B F43"}=" NB  F43"; $resn_exch{" N_C F43"}=" NC  F43"; $resn_exch{" N_D F43"}=" ND  F43";
$resn_exch{" O1P FA2"}=" OP1 FA2"; $resn_exch{" O2P FA2"}=" OP2 FA2"; $resn_exch{" O3* FA2"}=" O3' FA2";
$resn_exch{" C2* FA2"}=" C2' FA2"; $resn_exch{" C4* FA2"}=" C4' FA2"; $resn_exch{" O4* FA2"}=" O4' FA2";
$resn_exch{" C1* FA2"}=" C1' FA2"; $resn_exch{" C3* FA2"}=" C3' FA2"; $resn_exch{" O2* FA2"}=" O2' FA2";
$resn_exch{" O3P FA2"}=" OP3 FA2"; $resn_exch{" O1P FA5"}=" OP1 FA5"; $resn_exch{" O2P FA5"}=" OP2 FA5";
$resn_exch{" O3P FA5"}=" OP3 FA5"; $resn_exch{" O5* FA5"}=" O5' FA5"; $resn_exch{" C5* FA5"}=" C5' FA5";
$resn_exch{" C4* FA5"}=" C4' FA5"; $resn_exch{" O4* FA5"}=" O4' FA5"; $resn_exch{" C3* FA5"}=" C3' FA5";
$resn_exch{" O3* FA5"}=" O3' FA5"; $resn_exch{" C2* FA5"}=" C2' FA5"; $resn_exch{" O2* FA5"}=" O2' FA5";
$resn_exch{" C1* FA5"}=" C1' FA5"; $resn_exch{" BC3 FA9"}=" C3B FA9"; $resn_exch{"BC1* FA9"}=" CB1 FA9";
$resn_exch{"BC2* FA9"}=" CB2 FA9"; $resn_exch{"BC3* FA9"}=" CB3 FA9"; $resn_exch{"BC4* FA9"}=" CB4 FA9";
$resn_exch{"BC5* FA9"}=" CB5 FA9"; $resn_exch{"BC6* FA9"}=" CB6 FA9"; $resn_exch{" BC2 FA9"}=" C2B FA9";
$resn_exch{" BC1 FA9"}=" C1B FA9"; $resn_exch{" BO1 FA9"}=" O1B FA9"; $resn_exch{" C1* FA9"}=" C1' FA9";
$resn_exch{" C2* FA9"}=" C2' FA9"; $resn_exch{" O2* FA9"}=" O2' FA9"; $resn_exch{" C3* FA9"}=" C3' FA9";
$resn_exch{" O3* FA9"}=" O3' FA9"; $resn_exch{" C4* FA9"}=" C4' FA9"; $resn_exch{" O4* FA9"}=" O4' FA9";
$resn_exch{" C5* FA9"}=" C5' FA9"; $resn_exch{" O5* FA9"}=" O5' FA9"; $resn_exch{" AP  FA9"}=" PA  FA9";
$resn_exch{" AO1 FA9"}=" O1A FA9"; $resn_exch{" AO2 FA9"}=" O2A FA9"; $resn_exch{"AO5* FA9"}=" OA5 FA9";
$resn_exch{"AC5* FA9"}=" CA5 FA9"; $resn_exch{"AC4* FA9"}=" CA4 FA9"; $resn_exch{"AO4* FA9"}=" OA4 FA9";
$resn_exch{"AC3* FA9"}=" CA3 FA9"; $resn_exch{"AO3* FA9"}=" OA3 FA9"; $resn_exch{"AC2* FA9"}=" CA2 FA9";
$resn_exch{"AO2* FA9"}=" OA2 FA9"; $resn_exch{"AC1* FA9"}=" CA1 FA9"; $resn_exch{" AN9 FA9"}=" N9A FA9";
$resn_exch{" AC8 FA9"}=" C8A FA9"; $resn_exch{" AN7 FA9"}=" N7A FA9"; $resn_exch{" AC5 FA9"}=" C5C FA9";
$resn_exch{" AC4 FA9"}=" C4C FA9"; $resn_exch{" AN3 FA9"}=" N3A FA9"; $resn_exch{" AC2 FA9"}=" C2A FA9";
$resn_exch{" AN1 FA9"}=" N1A FA9"; $resn_exch{" AC6 FA9"}=" C6A FA9"; $resn_exch{" AN6 FA9"}=" N6A FA9";
$resn_exch{" AP  FAA"}=" PA  FAA"; $resn_exch{" AO1 FAA"}=" O1A FAA"; $resn_exch{" AO2 FAA"}=" O2A FAA";
$resn_exch{"AO5* FAA"}=" O5B FAA"; $resn_exch{"AC5* FAA"}=" C5B FAA"; $resn_exch{"AC4* FAA"}=" C4B FAA";
$resn_exch{"AO4* FAA"}=" O4B FAA"; $resn_exch{"AC3* FAA"}=" C3B FAA"; $resn_exch{"AO3* FAA"}=" O3B FAA";
$resn_exch{"AC2* FAA"}=" C2B FAA"; $resn_exch{"AO2* FAA"}=" O2B FAA"; $resn_exch{"AC1* FAA"}=" C1B FAA";
$resn_exch{" AN9 FAA"}=" N9A FAA"; $resn_exch{" AC8 FAA"}=" C8A FAA"; $resn_exch{" AN7 FAA"}=" N7A FAA";
$resn_exch{" AC5 FAA"}=" C5A FAA"; $resn_exch{" AC6 FAA"}=" C6A FAA"; $resn_exch{" AN6 FAA"}=" N6A FAA";
$resn_exch{" AN1 FAA"}=" N1A FAA"; $resn_exch{" AC2 FAA"}=" C2A FAA"; $resn_exch{" AN3 FAA"}=" N3A FAA";
$resn_exch{" AC4 FAA"}=" C4A FAA"; $resn_exch{" C4A FAA"}=" C4X FAA"; $resn_exch{" C5A FAA"}=" C5X FAA";
$resn_exch{" C1* FAA"}=" C1' FAA"; $resn_exch{" C2* FAA"}=" C2' FAA"; $resn_exch{" O2* FAA"}=" O2' FAA";
$resn_exch{" C3* FAA"}=" C3' FAA"; $resn_exch{" O3* FAA"}=" O3' FAA"; $resn_exch{" C4* FAA"}=" C4' FAA";
$resn_exch{" O4* FAA"}=" O4' FAA"; $resn_exch{" C5* FAA"}=" C5' FAA"; $resn_exch{" O5* FAA"}=" O5' FAA";
$resn_exch{" AP  FAB"}=" PA  FAB"; $resn_exch{" AO1 FAB"}=" O1A FAB"; $resn_exch{" AO2 FAB"}=" O2A FAB";
$resn_exch{"AO5* FAB"}=" O5B FAB"; $resn_exch{"AC5* FAB"}=" C5B FAB"; $resn_exch{"AC4* FAB"}=" C4B FAB";
$resn_exch{"AO4* FAB"}=" O4B FAB"; $resn_exch{"AC3* FAB"}=" C3B FAB"; $resn_exch{"AO3* FAB"}=" O3B FAB";
$resn_exch{"AC2* FAB"}=" C2B FAB"; $resn_exch{"AO2* FAB"}=" O2B FAB"; $resn_exch{"AC1* FAB"}=" C1B FAB";
$resn_exch{" AN9 FAB"}=" N9A FAB"; $resn_exch{" AC8 FAB"}=" C8A FAB"; $resn_exch{" AN7 FAB"}=" N7A FAB";
$resn_exch{" AC5 FAB"}=" C5A FAB"; $resn_exch{" AC6 FAB"}=" C6A FAB"; $resn_exch{" AN6 FAB"}=" N6A FAB";
$resn_exch{" AN1 FAB"}=" N1A FAB"; $resn_exch{" AC2 FAB"}=" C2A FAB"; $resn_exch{" AN3 FAB"}=" N3A FAB";
$resn_exch{" AC4 FAB"}=" C4A FAB"; $resn_exch{" C4A FAB"}=" C4X FAB"; $resn_exch{" C5A FAB"}=" C5X FAB";
$resn_exch{" C1* FAB"}=" C1' FAB"; $resn_exch{" C2* FAB"}=" C2D FAB"; $resn_exch{" O2* FAB"}=" O2' FAB";
$resn_exch{" C3* FAB"}=" C3D FAB"; $resn_exch{" O3* FAB"}=" O3D FAB"; $resn_exch{" C4* FAB"}=" C4D FAB";
$resn_exch{" O4* FAB"}=" O4' FAB"; $resn_exch{" C5* FAB"}=" C5D FAB"; $resn_exch{" O5* FAB"}=" O5' FAB";
$resn_exch{" AP  FAD"}=" PA  FAD"; $resn_exch{" AO1 FAD"}=" O1A FAD"; $resn_exch{" AO2 FAD"}=" O2A FAD";
$resn_exch{"AO5* FAD"}=" O5B FAD"; $resn_exch{"AC5* FAD"}=" C5B FAD"; $resn_exch{"AC4* FAD"}=" C4B FAD";
$resn_exch{"AO4* FAD"}=" O4B FAD"; $resn_exch{"AC3* FAD"}=" C3B FAD"; $resn_exch{"AO3* FAD"}=" O3B FAD";
$resn_exch{"AC2* FAD"}=" C2B FAD"; $resn_exch{"AO2* FAD"}=" O2B FAD"; $resn_exch{"AC1* FAD"}=" C1B FAD";
$resn_exch{" AN9 FAD"}=" N9A FAD"; $resn_exch{" AC8 FAD"}=" C8A FAD"; $resn_exch{" AN7 FAD"}=" N7A FAD";
$resn_exch{" AC5 FAD"}=" C5A FAD"; $resn_exch{" AC6 FAD"}=" C6A FAD"; $resn_exch{" AN6 FAD"}=" N6A FAD";
$resn_exch{" AN1 FAD"}=" N1A FAD"; $resn_exch{" AC2 FAD"}=" C2A FAD"; $resn_exch{" AN3 FAD"}=" N3A FAD";
$resn_exch{" AC4 FAD"}=" C4A FAD"; $resn_exch{" C4A FAD"}=" C4X FAD"; $resn_exch{" C5A FAD"}=" C5X FAD";
$resn_exch{" C1* FAD"}=" C1' FAD"; $resn_exch{" C2* FAD"}=" C2' FAD"; $resn_exch{" O2* FAD"}=" O2' FAD";
$resn_exch{" C3* FAD"}=" C3' FAD"; $resn_exch{" O3* FAD"}=" O3' FAD"; $resn_exch{" C4* FAD"}=" C4' FAD";
$resn_exch{" O4* FAD"}=" O4' FAD"; $resn_exch{" C5* FAD"}=" C5' FAD"; $resn_exch{" O5* FAD"}=" O5' FAD";
$resn_exch{" AP  FAE"}=" PA  FAE"; $resn_exch{" AO1 FAE"}=" O1A FAE"; $resn_exch{" AO2 FAE"}=" O2A FAE";
$resn_exch{"AO5* FAE"}=" O5B FAE"; $resn_exch{"AC5* FAE"}=" C5B FAE"; $resn_exch{"AC4* FAE"}=" C4B FAE";
$resn_exch{"AO4* FAE"}=" O4B FAE"; $resn_exch{"AC3* FAE"}=" C3B FAE"; $resn_exch{"AO3* FAE"}=" O3B FAE";
$resn_exch{"AC2* FAE"}=" C2B FAE"; $resn_exch{"AO2* FAE"}=" O2B FAE"; $resn_exch{"AC1* FAE"}=" C1B FAE";
$resn_exch{" AN9 FAE"}=" N9A FAE"; $resn_exch{" AC8 FAE"}=" C8A FAE"; $resn_exch{" AN7 FAE"}=" N7A FAE";
$resn_exch{" AC5 FAE"}=" C5A FAE"; $resn_exch{" AC6 FAE"}=" C6A FAE"; $resn_exch{" AN6 FAE"}=" N6A FAE";
$resn_exch{" AN1 FAE"}=" N1A FAE"; $resn_exch{" AC2 FAE"}=" C2A FAE"; $resn_exch{" AN3 FAE"}=" N3A FAE";
$resn_exch{" AC4 FAE"}=" C4A FAE"; $resn_exch{" C4A FAE"}=" C4X FAE"; $resn_exch{" C5A FAE"}=" C5X FAE";
$resn_exch{" C1* FAE"}=" C1' FAE"; $resn_exch{" C2* FAE"}=" C2' FAE"; $resn_exch{" O2* FAE"}=" O2' FAE";
$resn_exch{" C3* FAE"}=" C3' FAE"; $resn_exch{" O3* FAE"}=" O3' FAE"; $resn_exch{" C4* FAE"}=" C4' FAE";
$resn_exch{" O4* FAE"}=" O4' FAE"; $resn_exch{" C5* FAE"}=" C5' FAE"; $resn_exch{" O5* FAE"}=" O5' FAE";
$resn_exch{" O5* FAG"}=" O5' FAG"; $resn_exch{" C5* FAG"}=" C5' FAG"; $resn_exch{" C4* FAG"}=" C4' FAG";
$resn_exch{" O4* FAG"}=" O4' FAG"; $resn_exch{" C1* FAG"}=" C1' FAG"; $resn_exch{" C2* FAG"}=" C2' FAG";
$resn_exch{" C3* FAG"}=" C3' FAG"; $resn_exch{" O3* FAG"}=" O3' FAG"; $resn_exch{"AC10 FAG"}=" CAA FAG";
$resn_exch{"AC11 FAG"}=" CBA FAG"; $resn_exch{"1H3  FAG"}=" H31 FAG"; $resn_exch{" AN1 FAM"}=" N1A FAM";
$resn_exch{" AC2 FAM"}=" C2A FAM"; $resn_exch{" AN3 FAM"}=" N3A FAM"; $resn_exch{" AC4 FAM"}=" C4A FAM";
$resn_exch{" AC5 FAM"}=" C5A FAM"; $resn_exch{" AC6 FAM"}=" C6A FAM"; $resn_exch{" AN6 FAM"}=" N6A FAM";
$resn_exch{" AN7 FAM"}=" N7A FAM"; $resn_exch{" AC8 FAM"}=" C8A FAM"; $resn_exch{" AN9 FAM"}=" N9A FAM";
$resn_exch{"AC1* FAM"}=" C1B FAM"; $resn_exch{"AC2* FAM"}=" C2B FAM"; $resn_exch{"AO2* FAM"}=" O2B FAM";
$resn_exch{"AC3* FAM"}=" C3B FAM"; $resn_exch{"AO3* FAM"}=" O3B FAM"; $resn_exch{"AP3* FAM"}=" P3B FAM";
$resn_exch{" AO7 FAM"}=" O7A FAM"; $resn_exch{" AO8 FAM"}=" O8A FAM"; $resn_exch{" AO9 FAM"}=" O9A FAM";
$resn_exch{"AC4* FAM"}=" C4B FAM"; $resn_exch{"AO4* FAM"}=" O4B FAM"; $resn_exch{"AC5* FAM"}=" C5B FAM";
$resn_exch{"AO5* FAM"}=" O5B FAM"; $resn_exch{" AP1 FAM"}=" P1A FAM"; $resn_exch{" AO1 FAM"}=" O1A FAM";
$resn_exch{" AO2 FAM"}=" O2A FAM"; $resn_exch{" AO3 FAM"}=" O3A FAM"; $resn_exch{" AP2 FAM"}=" P2A FAM";
$resn_exch{" AO4 FAM"}=" O4A FAM"; $resn_exch{" AO5 FAM"}=" O5A FAM"; $resn_exch{" AO6 FAM"}=" O6A FAM";
$resn_exch{"PC11 FAM"}=" CBP FAM"; $resn_exch{"PC12 FAM"}=" CCP FAM"; $resn_exch{"PC13 FAM"}=" CDP FAM";
$resn_exch{"PC14 FAM"}=" CEP FAM"; $resn_exch{"PC10 FAM"}=" CAP FAM"; $resn_exch{"PO10 FAM"}=" OAP FAM";
$resn_exch{" PC9 FAM"}=" C9P FAM"; $resn_exch{" PO9 FAM"}=" O9P FAM"; $resn_exch{" PN8 FAM"}=" N8P FAM";
$resn_exch{" PC7 FAM"}=" C7P FAM"; $resn_exch{" PC6 FAM"}=" C6P FAM"; $resn_exch{" PC5 FAM"}=" C5P FAM";
$resn_exch{" PO5 FAM"}=" O5P FAM"; $resn_exch{" PN4 FAM"}=" N4P FAM"; $resn_exch{" PC3 FAM"}=" C3P FAM";
$resn_exch{" PC2 FAM"}=" C2P FAM"; $resn_exch{" AP  FAS"}=" PA  FAS"; $resn_exch{" AO1 FAS"}=" O1A FAS";
$resn_exch{" AO2 FAS"}=" O2A FAS"; $resn_exch{"AO5* FAS"}=" O5B FAS"; $resn_exch{"AC5* FAS"}=" C5B FAS";
$resn_exch{"AC4* FAS"}=" C4B FAS"; $resn_exch{"AO4* FAS"}=" O4B FAS"; $resn_exch{"AC3* FAS"}=" C3B FAS";
$resn_exch{"AO3* FAS"}=" O3B FAS"; $resn_exch{"AC2* FAS"}=" C2B FAS"; $resn_exch{"AO2* FAS"}=" O2B FAS";
$resn_exch{"AC1* FAS"}=" C1B FAS"; $resn_exch{" AN9 FAS"}=" N9A FAS"; $resn_exch{" AC8 FAS"}=" C8A FAS";
$resn_exch{" AN7 FAS"}=" N7A FAS"; $resn_exch{" AC5 FAS"}=" C5A FAS"; $resn_exch{" AC6 FAS"}=" C6A FAS";
$resn_exch{" AN6 FAS"}=" N6A FAS"; $resn_exch{" AN1 FAS"}=" N1A FAS"; $resn_exch{" AC2 FAS"}=" C2A FAS";
$resn_exch{" AN3 FAS"}=" N3A FAS"; $resn_exch{" AC4 FAS"}=" C4A FAS"; $resn_exch{" C4A FAS"}=" C4X FAS";
$resn_exch{" C5A FAS"}=" C5X FAS"; $resn_exch{" C1* FAS"}=" C1' FAS"; $resn_exch{" C2* FAS"}=" C2' FAS";
$resn_exch{" O2* FAS"}=" O2' FAS"; $resn_exch{" C3* FAS"}=" C3' FAS"; $resn_exch{" O3* FAS"}=" O3' FAS";
$resn_exch{" C4* FAS"}=" C4' FAS"; $resn_exch{" O4* FAS"}=" O4' FAS"; $resn_exch{" C5* FAS"}=" C5' FAS";
$resn_exch{" O5* FAS"}=" O5' FAS"; $resn_exch{"6OS  FBQ"}=" OS6 FBQ"; $resn_exch{" AP  FCG"}=" PA  FCG";
$resn_exch{" AO1 FCG"}=" O1A FCG"; $resn_exch{" AO2 FCG"}=" O2A FCG"; $resn_exch{"AO5* FCG"}=" O5B FCG";
$resn_exch{"AC5* FCG"}=" C5B FCG"; $resn_exch{"AC4* FCG"}=" C4B FCG"; $resn_exch{"AO4* FCG"}=" O4B FCG";
$resn_exch{"AC1* FCG"}=" C1B FCG"; $resn_exch{" AN9 FCG"}=" N9A FCG"; $resn_exch{" AC4 FCG"}=" C4A FCG";
$resn_exch{" AN3 FCG"}=" N3A FCG"; $resn_exch{" AC2 FCG"}=" C2A FCG"; $resn_exch{" AN1 FCG"}=" N1A FCG";
$resn_exch{" AC6 FCG"}=" C6A FCG"; $resn_exch{" AN6 FCG"}=" N6A FCG"; $resn_exch{" AC5 FCG"}=" C5A FCG";
$resn_exch{" AN7 FCG"}=" N7A FCG"; $resn_exch{" AC8 FCG"}=" C8A FCG"; $resn_exch{"AC2* FCG"}=" C2B FCG";
$resn_exch{"AO2* FCG"}=" O2B FCG"; $resn_exch{"AC3* FCG"}=" C3B FCG"; $resn_exch{"AO3* FCG"}=" O3B FCG";
$resn_exch{" O5* FCG"}=" O5' FCG"; $resn_exch{" C5* FCG"}=" C5' FCG"; $resn_exch{" C4* FCG"}=" C4' FCG";
$resn_exch{" O4* FCG"}=" O4' FCG"; $resn_exch{" C3* FCG"}=" C3' FCG"; $resn_exch{" O3* FCG"}=" O3' FCG";
$resn_exch{" C2* FCG"}=" C2' FCG"; $resn_exch{" O2* FCG"}=" O2' FCG"; $resn_exch{" C1* FCG"}=" C1' FCG";
$resn_exch{" C4A FCG"}=" C4X FCG"; $resn_exch{" C5A FCG"}=" C5X FCG"; $resn_exch{" AN1 FCX"}=" N1A FCX";
$resn_exch{" AC2 FCX"}=" C2A FCX"; $resn_exch{" AN3 FCX"}=" N3A FCX"; $resn_exch{" AC4 FCX"}=" C4A FCX";
$resn_exch{" AC5 FCX"}=" C5A FCX"; $resn_exch{" AC6 FCX"}=" C6A FCX"; $resn_exch{" AN6 FCX"}=" N6A FCX";
$resn_exch{" AN7 FCX"}=" N7A FCX"; $resn_exch{" AC8 FCX"}=" C8A FCX"; $resn_exch{" AN9 FCX"}=" N9A FCX";
$resn_exch{"AC1* FCX"}=" C1B FCX"; $resn_exch{"AC2* FCX"}=" C2B FCX"; $resn_exch{"AO2* FCX"}=" O2B FCX";
$resn_exch{"AC3* FCX"}=" C3B FCX"; $resn_exch{"AO3* FCX"}=" O3B FCX"; $resn_exch{"AP3* FCX"}=" P3B FCX";
$resn_exch{" AO7 FCX"}=" O7A FCX"; $resn_exch{" AO8 FCX"}=" O8A FCX"; $resn_exch{" AO9 FCX"}=" O9A FCX";
$resn_exch{"AC4* FCX"}=" C4B FCX"; $resn_exch{"AO4* FCX"}=" O4B FCX"; $resn_exch{"AC5* FCX"}=" C5B FCX";
$resn_exch{"AO5* FCX"}=" O5B FCX"; $resn_exch{" AP1 FCX"}=" P1A FCX"; $resn_exch{" AO1 FCX"}=" O1A FCX";
$resn_exch{" AO2 FCX"}=" O2A FCX"; $resn_exch{" AO3 FCX"}=" O3A FCX"; $resn_exch{" AP2 FCX"}=" P2A FCX";
$resn_exch{" AO4 FCX"}=" O4A FCX"; $resn_exch{" AO5 FCX"}=" O5A FCX"; $resn_exch{" AO6 FCX"}=" O6A FCX";
$resn_exch{"PC11 FCX"}=" CBP FCX"; $resn_exch{"PC12 FCX"}=" CCP FCX"; $resn_exch{"PC13 FCX"}=" CDP FCX";
$resn_exch{"PC14 FCX"}=" CEP FCX"; $resn_exch{"PC10 FCX"}=" CAP FCX"; $resn_exch{"PO10 FCX"}=" OAP FCX";
$resn_exch{" PC9 FCX"}=" C9P FCX"; $resn_exch{" PO9 FCX"}=" O9P FCX"; $resn_exch{" PN8 FCX"}=" N8P FCX";
$resn_exch{" PC7 FCX"}=" C7P FCX"; $resn_exch{" PC6 FCX"}=" C6P FCX"; $resn_exch{" PC5 FCX"}=" C5P FCX";
$resn_exch{" PO5 FCX"}=" O5P FCX"; $resn_exch{" PN4 FCX"}=" N4P FCX"; $resn_exch{" PC3 FCX"}=" C3P FCX";
$resn_exch{" PC2 FCX"}=" C2P FCX"; $resn_exch{" AP  FDA"}=" PA  FDA"; $resn_exch{" AO1 FDA"}=" O1A FDA";
$resn_exch{" AO2 FDA"}=" O2A FDA"; $resn_exch{"AO5* FDA"}=" O5B FDA"; $resn_exch{"AC5* FDA"}=" C5B FDA";
$resn_exch{"AC4* FDA"}=" C4B FDA"; $resn_exch{"AO4* FDA"}=" O4B FDA"; $resn_exch{"AC3* FDA"}=" C3B FDA";
$resn_exch{"AO3* FDA"}=" O3B FDA"; $resn_exch{"AC2* FDA"}=" C2B FDA"; $resn_exch{"AO2* FDA"}=" O2B FDA";
$resn_exch{"AC1* FDA"}=" C1B FDA"; $resn_exch{" AN9 FDA"}=" N9A FDA"; $resn_exch{" AC8 FDA"}=" C8A FDA";
$resn_exch{" AN7 FDA"}=" N7A FDA"; $resn_exch{" AC5 FDA"}=" C5A FDA"; $resn_exch{" AC6 FDA"}=" C6A FDA";
$resn_exch{" AN6 FDA"}=" N6A FDA"; $resn_exch{" AN1 FDA"}=" N1A FDA"; $resn_exch{" AC2 FDA"}=" C2A FDA";
$resn_exch{" AN3 FDA"}=" N3A FDA"; $resn_exch{" AC4 FDA"}=" C4A FDA"; $resn_exch{" C4A FDA"}=" C4X FDA";
$resn_exch{" C5A FDA"}=" C5X FDA"; $resn_exch{" C1* FDA"}=" C1' FDA"; $resn_exch{" C2* FDA"}=" C2' FDA";
$resn_exch{" O2* FDA"}=" O2' FDA"; $resn_exch{" C3* FDA"}=" C3' FDA"; $resn_exch{" O3* FDA"}=" O3' FDA";
$resn_exch{" C4* FDA"}=" C4' FDA"; $resn_exch{" O4* FDA"}=" O4' FDA"; $resn_exch{" C5* FDA"}=" C5' FDA";
$resn_exch{" O5* FDA"}=" O5' FDA"; $resn_exch{" N_D FDD"}=" ND  FDD"; $resn_exch{" N_A FDD"}=" NA  FDD";
$resn_exch{" N_C FDD"}=" NC  FDD"; $resn_exch{" N_B FDD"}=" NB  FDD"; $resn_exch{" N_A FDE"}=" NA  FDE";
$resn_exch{" N_B FDE"}=" NB  FDE"; $resn_exch{" N_C FDE"}=" NC  FDE"; $resn_exch{" N_D FDE"}=" ND  FDE";
$resn_exch{" O4* FDM"}=" O4' FDM"; $resn_exch{" C1* FDM"}=" C1' FDM"; $resn_exch{" C2* FDM"}=" C2' FDM";
$resn_exch{" C3* FDM"}=" C3' FDM"; $resn_exch{" C4* FDM"}=" C4' FDM"; $resn_exch{" O5* FDM"}=" O5' FDM";
$resn_exch{" C5* FDM"}=" C5' FDM"; $resn_exch{" C1* FFD"}=" C1' FFD"; $resn_exch{" O4* FFD"}=" O4' FFD";
$resn_exch{" C2* FFD"}=" C2' FFD"; $resn_exch{" C3* FFD"}=" C3' FFD"; $resn_exch{" O3* FFD"}=" O3' FFD";
$resn_exch{" C4* FFD"}=" C4' FFD"; $resn_exch{" C5* FFD"}=" C5' FFD"; $resn_exch{" O5* FFD"}=" O5' FFD";
$resn_exch{" C1* FHU"}=" C1' FHU"; $resn_exch{" C2* FHU"}=" C2' FHU"; $resn_exch{" O2* FHU"}=" O2' FHU";
$resn_exch{" C3* FHU"}=" C3' FHU"; $resn_exch{" C4* FHU"}=" C4' FHU"; $resn_exch{" O3* FHU"}=" O3' FHU";
$resn_exch{" O4* FHU"}=" O4' FHU"; $resn_exch{" C5* FHU"}=" C5' FHU"; $resn_exch{" O5* FHU"}=" O5' FHU";
$resn_exch{" O1P FHU"}=" OP1 FHU"; $resn_exch{" O2P FHU"}=" OP2 FHU"; $resn_exch{" O3P FHU"}=" OP3 FHU";
$resn_exch{" C3* FL8"}=" C3B FL8"; $resn_exch{" C1* FL9"}=" C1' FL9"; $resn_exch{" C2* FL9"}=" C2' FL9";
$resn_exch{" C3* FL9"}=" C3' FL9"; $resn_exch{" C4* FL9"}=" C4' FL9"; $resn_exch{" C5* FL9"}=" C5' FL9";
$resn_exch{" C6* FL9"}=" C6' FL9"; $resn_exch{" O2* FL9"}=" O2' FL9"; $resn_exch{" O4* FL9"}=" O4' FL9";
$resn_exch{" XC1 FLD"}=" C1X FLD"; $resn_exch{" XN2 FLD"}=" N2X FLD"; $resn_exch{" XC3 FLD"}=" C3X FLD";
$resn_exch{" XC4 FLD"}=" C4X FLD"; $resn_exch{" XC5 FLD"}=" C5X FLD"; $resn_exch{" XC6 FLD"}=" C6X FLD";
$resn_exch{" XN7 FLD"}=" N7X FLD"; $resn_exch{" XC8 FLD"}=" C8X FLD"; $resn_exch{" XC9 FLD"}=" C9X FLD";
$resn_exch{"XC10 FLD"}=" CAX FLD"; $resn_exch{"XO10 FLD"}=" OAX FLD"; $resn_exch{"XC11 FLD"}=" CBX FLD";
$resn_exch{"XC12 FLD"}=" CCX FLD"; $resn_exch{"XC13 FLD"}=" CDX FLD"; $resn_exch{"XC14 FLD"}=" CEX FLD";
$resn_exch{"XC15 FLD"}=" CFX FLD"; $resn_exch{"XC16 FLD"}=" CGX FLD"; $resn_exch{"XC17 FLD"}=" CHX FLD";
$resn_exch{"XC18 FLD"}=" CIX FLD"; $resn_exch{"XC19 FLD"}=" CJX FLD"; $resn_exch{"XC20 FLD"}=" CKX FLD";
$resn_exch{"XN21 FLD"}=" NLX FLD"; $resn_exch{"XC22 FLD"}=" CMX FLD"; $resn_exch{"XC23 FLD"}=" CNX FLD";
$resn_exch{"XC24 FLD"}=" COX FLD"; $resn_exch{" C1* FLN"}=" C1' FLN"; $resn_exch{" C2* FLN"}=" C2' FLN";
$resn_exch{" C3* FLN"}=" C3' FLN"; $resn_exch{" C4* FLN"}=" C4' FLN"; $resn_exch{" C5* FLN"}=" C5' FLN";
$resn_exch{" C6* FLN"}=" C6' FLN"; $resn_exch{" C1* FLQ"}=" C1' FLQ"; $resn_exch{" C2* FLQ"}=" C2' FLQ";
$resn_exch{" C3* FLQ"}=" C3' FLQ"; $resn_exch{" C4* FLQ"}=" C4' FLQ"; $resn_exch{" C5* FLQ"}=" C5' FLQ";
$resn_exch{" C6* FLQ"}=" C6' FLQ"; $resn_exch{" O8* FLQ"}=" O8' FLQ"; $resn_exch{" C9* FLQ"}=" C9' FLQ";
$resn_exch{" O9* FLQ"}=" O9' FLQ"; $resn_exch{" C1* FMA"}=" C1B FMA"; $resn_exch{" C2* FMA"}=" C2B FMA";
$resn_exch{" O2* FMA"}=" O2B FMA"; $resn_exch{" C3* FMA"}=" C3B FMA"; $resn_exch{" O3* FMA"}=" O3' FMA";
$resn_exch{" C4* FMA"}=" C4B FMA"; $resn_exch{" O4* FMA"}=" O4' FMA"; $resn_exch{" C5* FMA"}=" C5B FMA";
$resn_exch{" O5* FMA"}=" O5' FMA"; $resn_exch{" N_A FMI"}=" NA  FMI"; $resn_exch{" N_B FMI"}=" NB  FMI";
$resn_exch{" N_C FMI"}=" NC  FMI"; $resn_exch{" N_D FMI"}=" ND  FMI"; $resn_exch{" C1* FMN"}=" C1' FMN";
$resn_exch{" C2* FMN"}=" C2' FMN"; $resn_exch{" O2* FMN"}=" O2' FMN"; $resn_exch{" C3* FMN"}=" C3' FMN";
$resn_exch{" O3* FMN"}=" O3' FMN"; $resn_exch{" C4* FMN"}=" C4' FMN"; $resn_exch{" O4* FMN"}=" O4' FMN";
$resn_exch{" C5* FMN"}=" C5' FMN"; $resn_exch{" O5* FMN"}=" O5' FMN"; $resn_exch{" O5* FMP"}=" O5' FMP";
$resn_exch{" C5* FMP"}=" C5' FMP"; $resn_exch{" C4* FMP"}=" C4' FMP"; $resn_exch{" O4* FMP"}=" O4' FMP";
$resn_exch{" C3* FMP"}=" C3' FMP"; $resn_exch{" O3* FMP"}=" O3' FMP"; $resn_exch{" C2* FMP"}=" C2' FMP";
$resn_exch{" O2* FMP"}=" O2' FMP"; $resn_exch{" C1* FMP"}=" C1' FMP"; $resn_exch{" C1* FMU"}=" C1' FMU";
$resn_exch{" C2* FMU"}=" C2' FMU"; $resn_exch{" O2* FMU"}=" O2' FMU"; $resn_exch{" C3* FMU"}=" C3' FMU";
$resn_exch{" C4* FMU"}=" C4' FMU"; $resn_exch{" O3* FMU"}=" O3' FMU"; $resn_exch{" O4* FMU"}=" O4' FMU";
$resn_exch{" C5* FMU"}=" C5' FMU"; $resn_exch{" O5* FMU"}=" O5' FMU"; $resn_exch{"C10A FNR"}=" CAA FNR";
$resn_exch{" C1* FNR"}=" C1' FNR"; $resn_exch{" C2* FNR"}=" C2' FNR"; $resn_exch{" O2* FNR"}=" O2' FNR";
$resn_exch{" C3* FNR"}=" C3' FNR"; $resn_exch{" O3* FNR"}=" O3' FNR"; $resn_exch{" C4* FNR"}=" C4' FNR";
$resn_exch{" O4* FNR"}=" O4' FNR"; $resn_exch{" C5* FNR"}=" C5' FNR"; $resn_exch{" O5* FNR"}=" O5' FNR";
$resn_exch{" C1* FNS"}=" C1' FNS"; $resn_exch{" C2* FNS"}=" C2' FNS"; $resn_exch{" O2* FNS"}=" O2' FNS";
$resn_exch{" C3* FNS"}=" C3' FNS"; $resn_exch{" O3* FNS"}=" O3' FNS"; $resn_exch{" C4* FNS"}=" C4' FNS";
$resn_exch{" O4* FNS"}=" O4' FNS"; $resn_exch{" C5* FNS"}=" C5' FNS"; $resn_exch{" O5* FNS"}=" O5' FNS";
$resn_exch{" O5* FOX"}=" O5' FOX"; $resn_exch{" C5* FOX"}=" C5' FOX"; $resn_exch{" C4* FOX"}=" C4' FOX";
$resn_exch{" C6* FOX"}=" C6' FOX"; $resn_exch{" C3* FOX"}=" C3' FOX"; $resn_exch{" O3* FOX"}=" O3' FOX";
$resn_exch{" C2* FOX"}=" C2' FOX"; $resn_exch{" C1* FOX"}=" C1' FOX"; $resn_exch{" AN1 FRE"}=" N1A FRE";
$resn_exch{" AC2 FRE"}=" C2A FRE"; $resn_exch{" AN3 FRE"}=" N3A FRE"; $resn_exch{" AC4 FRE"}=" C4A FRE";
$resn_exch{" AC5 FRE"}=" C5A FRE"; $resn_exch{" AC6 FRE"}=" C6A FRE"; $resn_exch{" AN6 FRE"}=" N6A FRE";
$resn_exch{" AN7 FRE"}=" N7A FRE"; $resn_exch{" AC8 FRE"}=" C8A FRE"; $resn_exch{" AN9 FRE"}=" N9A FRE";
$resn_exch{"AC1* FRE"}=" C1B FRE"; $resn_exch{"AC2* FRE"}=" C2B FRE"; $resn_exch{"AO2* FRE"}=" O2B FRE";
$resn_exch{"AC3* FRE"}=" C3B FRE"; $resn_exch{"AO3* FRE"}=" O3B FRE"; $resn_exch{"AP3* FRE"}=" P3B FRE";
$resn_exch{" AO7 FRE"}=" O7A FRE"; $resn_exch{" AO8 FRE"}=" O8A FRE"; $resn_exch{" AO9 FRE"}=" O9A FRE";
$resn_exch{"AC4* FRE"}=" C4B FRE"; $resn_exch{"AO4* FRE"}=" O4B FRE"; $resn_exch{"AC5* FRE"}=" C5B FRE";
$resn_exch{"AO5* FRE"}=" O5B FRE"; $resn_exch{" AP1 FRE"}=" P1A FRE"; $resn_exch{" AO1 FRE"}=" O1A FRE";
$resn_exch{" AO2 FRE"}=" O2A FRE"; $resn_exch{" AO3 FRE"}=" O3A FRE"; $resn_exch{" AP2 FRE"}=" P2A FRE";
$resn_exch{" AO4 FRE"}=" O4A FRE"; $resn_exch{" AO5 FRE"}=" O5A FRE"; $resn_exch{" AO6 FRE"}=" O6A FRE";
$resn_exch{"PC11 FRE"}=" CBP FRE"; $resn_exch{"PC12 FRE"}=" CCP FRE"; $resn_exch{"PC13 FRE"}=" CDP FRE";
$resn_exch{"PC14 FRE"}=" CEP FRE"; $resn_exch{"PC10 FRE"}=" CAP FRE"; $resn_exch{"PO10 FRE"}=" OAP FRE";
$resn_exch{" PC9 FRE"}=" C9P FRE"; $resn_exch{" PO9 FRE"}=" O9P FRE"; $resn_exch{" PN8 FRE"}=" N8P FRE";
$resn_exch{" PC7 FRE"}=" C7P FRE"; $resn_exch{" PC6 FRE"}=" C6P FRE"; $resn_exch{" PC5 FRE"}=" C5P FRE";
$resn_exch{" PO5 FRE"}=" O5P FRE"; $resn_exch{" PN4 FRE"}=" N4P FRE"; $resn_exch{" PC3 FRE"}=" C3P FRE";
$resn_exch{" PC2 FRE"}=" C2P FRE"; $resn_exch{" PS1 FRE"}=" S1P FRE"; $resn_exch{"1OCT FRN"}=" O13 FRN";
$resn_exch{" AC2 FSM"}=" C2A FSM"; $resn_exch{" AC3 FSM"}=" C3A FSM"; $resn_exch{" AC4 FSM"}=" C4A FSM";
$resn_exch{" AC5 FSM"}=" C5A FSM"; $resn_exch{" AC6 FSM"}=" C6A FSM"; $resn_exch{" AC7 FSM"}=" C7A FSM";
$resn_exch{" AC8 FSM"}=" C8A FSM"; $resn_exch{" AN2 FSM"}=" N2A FSM"; $resn_exch{" AO1 FSM"}=" O1A FSM";
$resn_exch{" AO3 FSM"}=" O3A FSM"; $resn_exch{" AO4 FSM"}=" O4A FSM"; $resn_exch{" AO5 FSM"}=" O5A FSM";
$resn_exch{" AO6 FSM"}=" O6A FSM"; $resn_exch{" AO7 FSM"}=" O7A FSM"; $resn_exch{" BC1 FSM"}=" C1B FSM";
$resn_exch{" BC2 FSM"}=" C2B FSM"; $resn_exch{" BC3 FSM"}=" C3B FSM"; $resn_exch{" BC4 FSM"}=" C4B FSM";
$resn_exch{" BC5 FSM"}=" C5B FSM"; $resn_exch{" BC6 FSM"}=" C6B FSM"; $resn_exch{" BC7 FSM"}=" C7B FSM";
$resn_exch{" BC8 FSM"}=" C8B FSM"; $resn_exch{" BN2 FSM"}=" N2B FSM"; $resn_exch{" BO1 FSM"}=" O1B FSM";
$resn_exch{" BO3 FSM"}=" O3B FSM"; $resn_exch{" BO5 FSM"}=" O5B FSM"; $resn_exch{" BO6 FSM"}=" O6B FSM";
$resn_exch{" BO7 FSM"}=" O7B FSM"; $resn_exch{" O5* FUP"}=" O5' FUP"; $resn_exch{" C5* FUP"}=" C5' FUP";
$resn_exch{" C4* FUP"}=" C4' FUP"; $resn_exch{" O4* FUP"}=" O4' FUP"; $resn_exch{" C3* FUP"}=" C3' FUP";
$resn_exch{" F3* FUP"}=" F3' FUP"; $resn_exch{" C2* FUP"}=" C2' FUP"; $resn_exch{" C1* FUP"}=" C1' FUP";
$resn_exch{"1C   FVF"}=" C1  FVF"; $resn_exch{"1O   FVF"}=" O1  FVF"; $resn_exch{"1CB  FVF"}=" CB1 FVF";
$resn_exch{"1CG  FVF"}=" CG1 FVF"; $resn_exch{"1CD1 FVF"}=" CDB FVF"; $resn_exch{"1CD2 FVF"}=" CDC FVF";
$resn_exch{"1CE1 FVF"}=" CEB FVF"; $resn_exch{"1CE2 FVF"}=" CEC FVF"; $resn_exch{"1CZ  FVF"}=" CZ1 FVF";
$resn_exch{"2N   FVF"}=" N2  FVF"; $resn_exch{"2C   FVF"}=" C2  FVF"; $resn_exch{"2O   FVF"}=" O2  FVF";
$resn_exch{"2CA  FVF"}=" CA2 FVF"; $resn_exch{"2CB  FVF"}=" CB2 FVF"; $resn_exch{"2CG  FVF"}=" CG2 FVF";
$resn_exch{"2CD1 FVF"}=" CDL FVF"; $resn_exch{"2CD2 FVF"}=" CDM FVF"; $resn_exch{"2CE1 FVF"}=" CEL FVF";
$resn_exch{"2CE2 FVF"}=" CEM FVF"; $resn_exch{"2CZ  FVF"}=" CZ2 FVF"; $resn_exch{"3N   FVF"}=" N3  FVF";
$resn_exch{"3CA  FVF"}=" CA3 FVF"; $resn_exch{"3CB  FVF"}=" CB3 FVF"; $resn_exch{"3CG1 FVF"}=" CGD FVF";
$resn_exch{"3CG2 FVF"}=" CGN FVF"; $resn_exch{"3P   FVF"}=" P3  FVF"; $resn_exch{"1OP3 FVF"}=" OPV FVF";
$resn_exch{"2OP3 FVF"}=" OPW FVF"; $resn_exch{"3OP3 FVF"}=" OPX FVF"; $resn_exch{"4CA  FVF"}=" CA4 FVF";
$resn_exch{"4C   FVF"}=" C4  FVF"; $resn_exch{"4O   FVF"}=" O4  FVF"; $resn_exch{"4OXT FVF"}=" O11 FVF";
$resn_exch{"4CB  FVF"}=" CB4 FVF"; $resn_exch{"4CG  FVF"}=" CG4 FVF"; $resn_exch{"4CD1 FVF"}=" CD5 FVF";
$resn_exch{"4CD2 FVF"}=" CD6 FVF"; $resn_exch{"4CE1 FVF"}=" CE5 FVF"; $resn_exch{"4CE2 FVF"}=" CE6 FVF";
$resn_exch{"4CZ  FVF"}=" CZ4 FVF"; $resn_exch{" O5* FX3"}=" O5' FX3"; $resn_exch{" C5* FX3"}=" C5' FX3";
$resn_exch{" C4* FX3"}=" C4' FX3"; $resn_exch{" O4* FX3"}=" O4' FX3"; $resn_exch{" C3* FX3"}=" C3' FX3";
$resn_exch{" O3* FX3"}=" O3' FX3"; $resn_exch{" C2* FX3"}=" C2' FX3"; $resn_exch{" O2* FX3"}=" O2' FX3";
$resn_exch{" C1* FX3"}=" C1' FX3"; $resn_exch{" O5* FYA"}=" O5' FYA"; $resn_exch{" C5* FYA"}=" C5' FYA";
$resn_exch{" C4* FYA"}=" C4' FYA"; $resn_exch{" O4* FYA"}=" O4' FYA"; $resn_exch{" C3* FYA"}=" C3' FYA";
$resn_exch{" O3* FYA"}=" O3' FYA"; $resn_exch{" C2* FYA"}=" C2' FYA"; $resn_exch{" O2* FYA"}=" O2' FYA";
$resn_exch{" C1* FYA"}=" C1' FYA"; $resn_exch{" O3P   G"}=" OP3   G"; $resn_exch{" O1P   G"}=" OP1   G";
$resn_exch{" O2P   G"}=" OP2   G"; $resn_exch{" O5*   G"}=" O5'   G"; $resn_exch{" C5*   G"}=" C5'   G";
$resn_exch{" C4*   G"}=" C4'   G"; $resn_exch{" O4*   G"}=" O4'   G"; $resn_exch{" C3*   G"}=" C3'   G";
$resn_exch{" O3*   G"}=" O3'   G"; $resn_exch{" C2*   G"}=" C2'   G"; $resn_exch{" O2*   G"}=" O2'   G";
$resn_exch{" C1*   G"}=" C1'   G"; $resn_exch{" P*  G16"}=" P'  G16"; $resn_exch{"O1P* G16"}=" O1X G16";
$resn_exch{"O2P* G16"}=" O2X G16"; $resn_exch{"O3P* G16"}=" O3X G16"; $resn_exch{" C1* G1R"}=" C1' G1R";
$resn_exch{" O4* G1R"}=" O4' G1R"; $resn_exch{" C2* G1R"}=" C2' G1R"; $resn_exch{" O2* G1R"}=" O2' G1R";
$resn_exch{" C3* G1R"}=" C3' G1R"; $resn_exch{" O3* G1R"}=" O3' G1R"; $resn_exch{" C4* G1R"}=" C4' G1R";
$resn_exch{" C5* G1R"}=" C5' G1R"; $resn_exch{" O5* G1R"}=" O5' G1R"; $resn_exch{" O3P G25"}=" OP3 G25";
$resn_exch{" O1P G25"}=" OP1 G25"; $resn_exch{" O2P G25"}=" OP2 G25"; $resn_exch{" O5* G25"}=" O5' G25";
$resn_exch{" C5* G25"}=" C5' G25"; $resn_exch{" C4* G25"}=" C4' G25"; $resn_exch{" O4* G25"}=" O4' G25";
$resn_exch{" C3* G25"}=" C3' G25"; $resn_exch{" O3* G25"}=" O3' G25"; $resn_exch{" C2* G25"}=" C2' G25";
$resn_exch{" O2* G25"}=" O2' G25"; $resn_exch{" C1* G25"}=" C1' G25"; $resn_exch{" O3P G2L"}=" OP3 G2L";
$resn_exch{" O1P G2L"}=" OP1 G2L"; $resn_exch{" O2P G2L"}=" OP2 G2L"; $resn_exch{" O5* G2L"}=" O5' G2L";
$resn_exch{" C5* G2L"}=" C5' G2L"; $resn_exch{" C4* G2L"}=" C4' G2L"; $resn_exch{" O4* G2L"}=" O4' G2L";
$resn_exch{" C3* G2L"}=" C3' G2L"; $resn_exch{" O3* G2L"}=" O3' G2L"; $resn_exch{" C2* G2L"}=" C2' G2L";
$resn_exch{" O2* G2L"}=" O2' G2L"; $resn_exch{" C1* G2L"}=" C1' G2L"; $resn_exch{" CA* G2L"}=" CA' G2L";
$resn_exch{" CB* G2L"}=" CB' G2L"; $resn_exch{" OC* G2L"}=" OC' G2L"; $resn_exch{" CD* G2L"}=" CD' G2L";
$resn_exch{" O5* G2P"}=" O5' G2P"; $resn_exch{" C5* G2P"}=" C5' G2P"; $resn_exch{" C4* G2P"}=" C4' G2P";
$resn_exch{" O4* G2P"}=" O4' G2P"; $resn_exch{" C3* G2P"}=" C3' G2P"; $resn_exch{" O3* G2P"}=" O3' G2P";
$resn_exch{" C2* G2P"}=" C2' G2P"; $resn_exch{" O2* G2P"}=" O2' G2P"; $resn_exch{" C1* G2P"}=" C1' G2P";
$resn_exch{" C1* G2R"}=" C1' G2R"; $resn_exch{" O4* G2R"}=" O4' G2R"; $resn_exch{" C2* G2R"}=" C2' G2R";
$resn_exch{" O2* G2R"}=" O2' G2R"; $resn_exch{" C3* G2R"}=" C3' G2R"; $resn_exch{" O3* G2R"}=" O3' G2R";
$resn_exch{" C4* G2R"}=" C4' G2R"; $resn_exch{" C5* G2R"}=" C5' G2R"; $resn_exch{" O5* G2R"}=" O5' G2R";
$resn_exch{" O3P G2S"}=" OP3 G2S"; $resn_exch{" O5* G2S"}=" O5' G2S"; $resn_exch{" C5* G2S"}=" C5' G2S";
$resn_exch{" C4* G2S"}=" C4' G2S"; $resn_exch{" O4* G2S"}=" O4' G2S"; $resn_exch{" C3* G2S"}=" C3' G2S";
$resn_exch{" O3* G2S"}=" O3' G2S"; $resn_exch{" C2* G2S"}=" C2' G2S"; $resn_exch{" C1* G2S"}=" C1' G2S";
$resn_exch{" O5* G31"}=" O5' G31"; $resn_exch{" C5* G31"}=" C5' G31"; $resn_exch{" C4* G31"}=" C4' G31";
$resn_exch{" O4* G31"}=" O4' G31"; $resn_exch{" C3* G31"}=" C3' G31"; $resn_exch{" C2* G31"}=" C2' G31";
$resn_exch{" C1* G31"}=" C1' G31"; $resn_exch{" O5* G32"}=" O5' G32"; $resn_exch{" C5* G32"}=" C5' G32";
$resn_exch{" C4* G32"}=" C4' G32"; $resn_exch{" O4* G32"}=" O4' G32"; $resn_exch{" C3* G32"}=" C3' G32";
$resn_exch{" O3* G32"}=" O3' G32"; $resn_exch{" C2* G32"}=" C2' G32"; $resn_exch{" C1* G32"}=" C1' G32";
$resn_exch{" O5* G33"}=" O5' G33"; $resn_exch{" C5* G33"}=" C5' G33"; $resn_exch{" C4* G33"}=" C4' G33";
$resn_exch{" O4* G33"}=" O4' G33"; $resn_exch{" C3* G33"}=" C3' G33"; $resn_exch{" O3* G33"}=" O3' G33";
$resn_exch{" C2* G33"}=" C2' G33"; $resn_exch{" C1* G33"}=" C1' G33"; $resn_exch{" O5* G36"}=" O5' G36";
$resn_exch{" C5* G36"}=" C5' G36"; $resn_exch{" C4* G36"}=" C4' G36"; $resn_exch{" O4* G36"}=" O4' G36";
$resn_exch{" C3* G36"}=" C3' G36"; $resn_exch{" O3* G36"}=" O3' G36"; $resn_exch{" C2* G36"}=" C2' G36";
$resn_exch{" C1* G36"}=" C1' G36"; $resn_exch{" O5* G38"}=" O5' G38"; $resn_exch{" C5* G38"}=" C5' G38";
$resn_exch{" C4* G38"}=" C4' G38"; $resn_exch{" O4* G38"}=" O4' G38"; $resn_exch{" C3* G38"}=" C3' G38";
$resn_exch{" C2* G38"}=" C2' G38"; $resn_exch{" C1* G38"}=" C1' G38"; $resn_exch{" O5* G3D"}=" O5' G3D";
$resn_exch{" C5* G3D"}=" C5' G3D"; $resn_exch{" C4* G3D"}=" C4' G3D"; $resn_exch{" O4* G3D"}=" O4' G3D";
$resn_exch{" C3* G3D"}=" C3' G3D"; $resn_exch{" O3* G3D"}=" O3' G3D"; $resn_exch{" C2* G3D"}=" C2' G3D";
$resn_exch{" O2* G3D"}=" O2' G3D"; $resn_exch{" C1* G3D"}=" C1' G3D"; $resn_exch{" O5* G42"}=" O5' G42";
$resn_exch{" C5* G42"}=" C5' G42"; $resn_exch{" C4* G42"}=" C4' G42"; $resn_exch{" O4* G42"}=" O4' G42";
$resn_exch{" C3* G42"}=" C3' G42"; $resn_exch{" O3* G42"}=" O3' G42"; $resn_exch{" C2* G42"}=" C2' G42";
$resn_exch{" C1* G42"}=" C1' G42"; $resn_exch{" O5* G46"}=" O5' G46"; $resn_exch{" C5* G46"}=" C5' G46";
$resn_exch{" C4* G46"}=" C4' G46"; $resn_exch{" O4* G46"}=" O4' G46"; $resn_exch{" C3* G46"}=" C3' G46";
$resn_exch{" O3* G46"}=" O3' G46"; $resn_exch{" C2* G46"}=" C2' G46"; $resn_exch{" C1* G46"}=" C1' G46";
$resn_exch{" O2* G46"}=" O2' G46"; $resn_exch{" O5* G47"}=" O5' G47"; $resn_exch{" C5* G47"}=" C5' G47";
$resn_exch{" C4* G47"}=" C4' G47"; $resn_exch{" O4* G47"}=" O4' G47"; $resn_exch{" C3* G47"}=" C3' G47";
$resn_exch{" O3* G47"}=" O3' G47"; $resn_exch{" C2* G47"}=" C2' G47"; $resn_exch{" C1* G47"}=" C1' G47";
$resn_exch{" O5* G48"}=" O5' G48"; $resn_exch{" C5* G48"}=" C5' G48"; $resn_exch{" C4* G48"}=" C4' G48";
$resn_exch{" O4* G48"}=" O4' G48"; $resn_exch{" C3* G48"}=" C3' G48"; $resn_exch{" O3* G48"}=" O3' G48";
$resn_exch{" C2* G48"}=" C2' G48"; $resn_exch{" O2* G48"}=" O2' G48"; $resn_exch{" C1* G48"}=" C1' G48";
$resn_exch{" CA* G48"}=" CA' G48"; $resn_exch{" CB* G48"}=" CB' G48"; $resn_exch{" OC* G48"}=" OC' G48";
$resn_exch{" CD* G48"}=" CD' G48"; $resn_exch{" O5* G49"}=" O5' G49"; $resn_exch{" C5* G49"}=" C5' G49";
$resn_exch{" C4* G49"}=" C4' G49"; $resn_exch{" O4* G49"}=" O4' G49"; $resn_exch{" C3* G49"}=" C3' G49";
$resn_exch{" O3* G49"}=" O3' G49"; $resn_exch{" C2* G49"}=" C2' G49"; $resn_exch{" C1* G49"}=" C1' G49";
$resn_exch{" O5* G4M"}=" O5' G4M"; $resn_exch{" C5* G4M"}=" C5' G4M"; $resn_exch{" C4* G4M"}=" C4' G4M";
$resn_exch{" O4* G4M"}=" O4' G4M"; $resn_exch{" C3* G4M"}=" C3' G4M"; $resn_exch{" O3* G4M"}=" O3' G4M";
$resn_exch{" C2* G4M"}=" C2' G4M"; $resn_exch{" O2* G4M"}=" O2' G4M"; $resn_exch{" C1* G4M"}=" C1' G4M";
$resn_exch{" O5* G4P"}=" O5' G4P"; $resn_exch{" C5* G4P"}=" C5' G4P"; $resn_exch{" C4* G4P"}=" C4' G4P";
$resn_exch{" O4* G4P"}=" O4' G4P"; $resn_exch{" C3* G4P"}=" C3' G4P"; $resn_exch{" O3* G4P"}=" O3' G4P";
$resn_exch{" C2* G4P"}=" C2' G4P"; $resn_exch{" O2* G4P"}=" O2' G4P"; $resn_exch{" C1* G4P"}=" C1' G4P";
$resn_exch{" O5* G5P"}=" O5' G5P"; $resn_exch{" C5* G5P"}=" C5' G5P"; $resn_exch{" C4* G5P"}=" C4' G5P";
$resn_exch{" O4* G5P"}=" O4' G5P"; $resn_exch{" C3* G5P"}=" C3' G5P"; $resn_exch{" O3* G5P"}=" O3' G5P";
$resn_exch{" C2* G5P"}=" C2' G5P"; $resn_exch{" O2* G5P"}=" O2' G5P"; $resn_exch{" C1* G5P"}=" C1' G5P";
$resn_exch{"AO5* G5P"}=" O5F G5P"; $resn_exch{"AC5* G5P"}=" C5F G5P"; $resn_exch{"AC4* G5P"}=" C4F G5P";
$resn_exch{"AO4* G5P"}=" O4F G5P"; $resn_exch{"AC1* G5P"}=" C1F G5P"; $resn_exch{"AC2* G5P"}=" C2F G5P";
$resn_exch{"AO2* G5P"}=" O2F G5P"; $resn_exch{"AC3* G5P"}=" C3F G5P"; $resn_exch{"AO3* G5P"}=" O3F G5P";
$resn_exch{" AN9 G5P"}=" N9A G5P"; $resn_exch{" AC4 G5P"}=" C4A G5P"; $resn_exch{" AN3 G5P"}=" N3A G5P";
$resn_exch{" AC2 G5P"}=" C2A G5P"; $resn_exch{" AN1 G5P"}=" N1A G5P"; $resn_exch{" AC6 G5P"}=" C6A G5P";
$resn_exch{" AN6 G5P"}=" N6A G5P"; $resn_exch{" AC5 G5P"}=" C5A G5P"; $resn_exch{" AN7 G5P"}=" N7A G5P";
$resn_exch{" AC8 G5P"}=" C8A G5P"; $resn_exch{" O3P G7M"}=" OP3 G7M"; $resn_exch{" O1P G7M"}=" OP1 G7M";
$resn_exch{" O2P G7M"}=" OP2 G7M"; $resn_exch{" O5* G7M"}=" O5' G7M"; $resn_exch{" C5* G7M"}=" C5' G7M";
$resn_exch{" C4* G7M"}=" C4' G7M"; $resn_exch{" O4* G7M"}=" O4' G7M"; $resn_exch{" C3* G7M"}=" C3' G7M";
$resn_exch{" O3* G7M"}=" O3' G7M"; $resn_exch{" C2* G7M"}=" C2' G7M"; $resn_exch{" O2* G7M"}=" O2' G7M";
$resn_exch{" C1* G7M"}=" C1' G7M"; $resn_exch{" C4* GA2"}=" C4' GA2"; $resn_exch{" O4* GA2"}=" O4' GA2";
$resn_exch{" C3* GA2"}=" C3' GA2"; $resn_exch{" O3* GA2"}=" O3' GA2"; $resn_exch{" C2* GA2"}=" C2' GA2";
$resn_exch{" O1* GA2"}=" O1' GA2"; $resn_exch{" C1* GA2"}=" C1' GA2"; $resn_exch{" O3P GAO"}=" OP3 GAO";
$resn_exch{" O1P GAO"}=" OP1 GAO"; $resn_exch{" O2P GAO"}=" OP2 GAO"; $resn_exch{" O5* GAO"}=" O5' GAO";
$resn_exch{" C5* GAO"}=" C5' GAO"; $resn_exch{" C4* GAO"}=" C4' GAO"; $resn_exch{" O4* GAO"}=" O4' GAO";
$resn_exch{" C3* GAO"}=" C3' GAO"; $resn_exch{" O3* GAO"}=" O3' GAO"; $resn_exch{" C2* GAO"}=" C2' GAO";
$resn_exch{" O2* GAO"}=" O2' GAO"; $resn_exch{" C1* GAO"}=" C1' GAO"; $resn_exch{" C5* GAP"}=" C5' GAP";
$resn_exch{" O5* GAP"}=" O5' GAP"; $resn_exch{" C4* GAP"}=" C4' GAP"; $resn_exch{" O4* GAP"}=" O4' GAP";
$resn_exch{" C3* GAP"}=" C3' GAP"; $resn_exch{" O3* GAP"}=" O3' GAP"; $resn_exch{" C2* GAP"}=" C2' GAP";
$resn_exch{" O2* GAP"}=" O2' GAP"; $resn_exch{" C1* GAP"}=" C1' GAP"; $resn_exch{" C1* GAV"}=" C1' GAV";
$resn_exch{" C2* GAV"}=" C2' GAV"; $resn_exch{" O2* GAV"}=" O2' GAV"; $resn_exch{" C3* GAV"}=" C3' GAV";
$resn_exch{" O3* GAV"}=" O3' GAV"; $resn_exch{" O4* GAV"}=" O4' GAV"; $resn_exch{" C4* GAV"}=" C4' GAV";
$resn_exch{" C5* GAV"}=" C5' GAV"; $resn_exch{" O5* GAV"}=" O5' GAV"; $resn_exch{"N10S GCG"}=" N11 GCG";
$resn_exch{" O5* GCK"}=" O5' GCK"; $resn_exch{" C2* GCK"}=" C2' GCK"; $resn_exch{" C5* GCK"}=" C5' GCK";
$resn_exch{" C4* GCK"}=" C4' GCK"; $resn_exch{" O4* GCK"}=" O4' GCK"; $resn_exch{" C1* GCK"}=" C1' GCK";
$resn_exch{" C3* GCK"}=" C3' GCK"; $resn_exch{" O3* GCK"}=" O3' GCK"; $resn_exch{" O5* GCP"}=" O5' GCP";
$resn_exch{" C5* GCP"}=" C5' GCP"; $resn_exch{" C4* GCP"}=" C4' GCP"; $resn_exch{" O4* GCP"}=" O4' GCP";
$resn_exch{" C3* GCP"}=" C3' GCP"; $resn_exch{" O3* GCP"}=" O3' GCP"; $resn_exch{" C2* GCP"}=" C2' GCP";
$resn_exch{" O2* GCP"}=" O2' GCP"; $resn_exch{" C1* GCP"}=" C1' GCP"; $resn_exch{" O5* GCQ"}=" O5' GCQ";
$resn_exch{" C5* GCQ"}=" C5' GCQ"; $resn_exch{" C4* GCQ"}=" C4' GCQ"; $resn_exch{" C3* GCQ"}=" C3' GCQ";
$resn_exch{" O3* GCQ"}=" O3' GCQ"; $resn_exch{" C2* GCQ"}=" C2' GCQ"; $resn_exch{" O4* GCQ"}=" O4' GCQ";
$resn_exch{" C1* GCQ"}=" C1' GCQ"; $resn_exch{" O5* GDC"}=" O5' GDC"; $resn_exch{" C5* GDC"}=" C5' GDC";
$resn_exch{" C4* GDC"}=" C4' GDC"; $resn_exch{" O4* GDC"}=" O4' GDC"; $resn_exch{" C3* GDC"}=" C3' GDC";
$resn_exch{" O3* GDC"}=" O3' GDC"; $resn_exch{" C2* GDC"}=" C2' GDC"; $resn_exch{" O2* GDC"}=" O2' GDC";
$resn_exch{" C1* GDC"}=" C1' GDC"; $resn_exch{"AO1P GDC"}=" O1X GDC"; $resn_exch{"AO2P GDC"}=" O2X GDC";
$resn_exch{" C1* GDD"}=" C1' GDD"; $resn_exch{" C2* GDD"}=" C2' GDD"; $resn_exch{" O2* GDD"}=" O2' GDD";
$resn_exch{" C3* GDD"}=" C3' GDD"; $resn_exch{" O3* GDD"}=" O3' GDD"; $resn_exch{" C4* GDD"}=" C4' GDD";
$resn_exch{" O4* GDD"}=" O4' GDD"; $resn_exch{" C5* GDD"}=" C5' GDD"; $resn_exch{" O5* GDD"}=" O5' GDD";
$resn_exch{" O5* GDP"}=" O5' GDP"; $resn_exch{" C5* GDP"}=" C5' GDP"; $resn_exch{" C4* GDP"}=" C4' GDP";
$resn_exch{" O4* GDP"}=" O4' GDP"; $resn_exch{" C3* GDP"}=" C3' GDP"; $resn_exch{" O3* GDP"}=" O3' GDP";
$resn_exch{" C2* GDP"}=" C2' GDP"; $resn_exch{" O2* GDP"}=" O2' GDP"; $resn_exch{" C1* GDP"}=" C1' GDP";
$resn_exch{" O5* GDR"}=" O5D GDR"; $resn_exch{" C5* GDR"}=" C5D GDR"; $resn_exch{" C4* GDR"}=" C4D GDR";
$resn_exch{" O4* GDR"}=" O4D GDR"; $resn_exch{" C1* GDR"}=" C1D GDR"; $resn_exch{" C2* GDR"}=" C2D GDR";
$resn_exch{" O2* GDR"}=" O2D GDR"; $resn_exch{" C3* GDR"}=" C3D GDR"; $resn_exch{" O3* GDR"}=" O3D GDR";
$resn_exch{" C1* GDU"}=" C1D GDU"; $resn_exch{" C2* GDU"}=" C2D GDU"; $resn_exch{" O2* GDU"}=" O2D GDU";
$resn_exch{" C3* GDU"}=" C3D GDU"; $resn_exch{" C4* GDU"}=" C4D GDU"; $resn_exch{" O4* GDU"}=" O4D GDU";
$resn_exch{" O3* GDU"}=" O3D GDU"; $resn_exch{" C5* GDU"}=" C5D GDU"; $resn_exch{" O5* GDU"}=" O5D GDU";
$resn_exch{" C1* GDX"}=" C1D GDX"; $resn_exch{" C2* GDX"}=" C2D GDX"; $resn_exch{" O2* GDX"}=" O2D GDX";
$resn_exch{" C3* GDX"}=" C3D GDX"; $resn_exch{" O3* GDX"}=" O3D GDX"; $resn_exch{" C4* GDX"}=" C4D GDX";
$resn_exch{" O4* GDX"}=" O4D GDX"; $resn_exch{" C5* GDX"}=" C5D GDX"; $resn_exch{" O5* GDX"}=" O5D GDX";
$resn_exch{" O5* GFL"}=" O5' GFL"; $resn_exch{" C5* GFL"}=" C5' GFL"; $resn_exch{" C4* GFL"}=" C4' GFL";
$resn_exch{" O4* GFL"}=" O4' GFL"; $resn_exch{" C3* GFL"}=" C3' GFL"; $resn_exch{" O3* GFL"}=" O3' GFL";
$resn_exch{" C2* GFL"}=" C2' GFL"; $resn_exch{" C1* GFL"}=" C1' GFL"; $resn_exch{" O2* GGZ"}=" O2' GGZ";
$resn_exch{" O3* GGZ"}=" O3' GGZ"; $resn_exch{" C3* GGZ"}=" C3' GGZ"; $resn_exch{" C4* GGZ"}=" C4' GGZ";
$resn_exch{" C5* GGZ"}=" C5' GGZ"; $resn_exch{" O5* GGZ"}=" O5' GGZ"; $resn_exch{" C2* GGZ"}=" C2' GGZ";
$resn_exch{" C1* GGZ"}=" C1' GGZ"; $resn_exch{" O4* GGZ"}=" O4' GGZ"; $resn_exch{" O5* GH3"}=" O5' GH3";
$resn_exch{" C5* GH3"}=" C5' GH3"; $resn_exch{" C4* GH3"}=" C4' GH3"; $resn_exch{" O4* GH3"}=" O4' GH3";
$resn_exch{" C3* GH3"}=" C3' GH3"; $resn_exch{" C2* GH3"}=" C2' GH3"; $resn_exch{" O2* GH3"}=" O2' GH3";
$resn_exch{" C1* GH3"}=" C1' GH3"; $resn_exch{" C1* GKD"}=" C1' GKD"; $resn_exch{" C2* GKD"}=" C2' GKD";
$resn_exch{" O2* GKD"}=" O2' GKD"; $resn_exch{" C3* GKD"}=" C3' GKD"; $resn_exch{" O3* GKD"}=" O3' GKD";
$resn_exch{" C4* GKD"}=" C4' GKD"; $resn_exch{" O4* GKD"}=" O4' GKD"; $resn_exch{" C5* GKD"}=" C5' GKD";
$resn_exch{" O5* GKD"}=" O5' GKD"; $resn_exch{" C1* GKE"}=" C1' GKE"; $resn_exch{" C2* GKE"}=" C2' GKE";
$resn_exch{" O2* GKE"}=" O2' GKE"; $resn_exch{" C3* GKE"}=" C3' GKE"; $resn_exch{" O3* GKE"}=" O3' GKE";
$resn_exch{" C4* GKE"}=" C4' GKE"; $resn_exch{" O4* GKE"}=" O4' GKE"; $resn_exch{" C5* GKE"}=" C5' GKE";
$resn_exch{" O5* GKE"}=" O5' GKE"; $resn_exch{"CD31 GLI"}=" CDV GLI"; $resn_exch{"CD32 GLI"}=" CDW GLI";
$resn_exch{"CE31 GLI"}=" CEV GLI"; $resn_exch{"CE32 GLI"}=" CEW GLI"; $resn_exch{"CG51 GLI"}=" CGF GLI";
$resn_exch{"CG52 GLI"}=" CGG GLI"; $resn_exch{"CG61 GLI"}=" CGP GLI"; $resn_exch{"CG62 GLI"}=" CGQ GLI";
$resn_exch{" AE1 GLX"}=" XE1 GLX"; $resn_exch{" AE2 GLX"}=" XE2 GLX"; $resn_exch{"CR10 GM2"}=" CRA GM2";
$resn_exch{"CR11 GM2"}=" CRB GM2"; $resn_exch{"CR12 GM2"}=" CRC GM2"; $resn_exch{"CR13 GM2"}=" CRD GM2";
$resn_exch{"CR14 GM2"}=" CRE GM2"; $resn_exch{"CR15 GM2"}=" CRF GM2"; $resn_exch{"CR16 GM2"}=" CRG GM2";
$resn_exch{"CR17 GM2"}=" CRH GM2"; $resn_exch{"CL10 GM2"}=" CLA GM2"; $resn_exch{"CL11 GM2"}=" CLB GM2";
$resn_exch{"CL12 GM2"}=" CLC GM2"; $resn_exch{"CL13 GM2"}=" CLD GM2"; $resn_exch{"CL14 GM2"}=" CLE GM2";
$resn_exch{"CL15 GM2"}=" CLF GM2"; $resn_exch{"CL16 GM2"}=" CLG GM2"; $resn_exch{"CL17 GM2"}=" CLH GM2";
$resn_exch{"CL18 GM2"}=" CLI GM2"; $resn_exch{" C1* GMC"}=" C1' GMC"; $resn_exch{" O4* GMC"}=" O4' GMC";
$resn_exch{" C4* GMC"}=" C4' GMC"; $resn_exch{" C5* GMC"}=" C5' GMC"; $resn_exch{" O5* GMC"}=" O5' GMC";
$resn_exch{" C2* GMC"}=" C2' GMC"; $resn_exch{" O2* GMC"}=" O2' GMC"; $resn_exch{" C3* GMC"}=" C3' GMC";
$resn_exch{" N3* GMC"}=" N3' GMC"; $resn_exch{" O5* GMP"}=" O5' GMP"; $resn_exch{" C5* GMP"}=" C5' GMP";
$resn_exch{" C4* GMP"}=" C4' GMP"; $resn_exch{" O4* GMP"}=" O4' GMP"; $resn_exch{" C3* GMP"}=" C3' GMP";
$resn_exch{" O3* GMP"}=" O3' GMP"; $resn_exch{" C2* GMP"}=" C2' GMP"; $resn_exch{" O2* GMP"}=" O2' GMP";
$resn_exch{" C1* GMP"}=" C1' GMP"; $resn_exch{" O1P GMS"}=" OP1 GMS"; $resn_exch{" O5* GMS"}=" O5' GMS";
$resn_exch{" C2* GMS"}=" C2' GMS"; $resn_exch{" C5* GMS"}=" C5' GMS"; $resn_exch{" C4* GMS"}=" C4' GMS";
$resn_exch{" O4* GMS"}=" O4' GMS"; $resn_exch{" C1* GMS"}=" C1' GMS"; $resn_exch{" C3* GMS"}=" C3' GMS";
$resn_exch{" O3* GMS"}=" O3' GMS"; $resn_exch{" O2P GMS"}=" OP2 GMS"; $resn_exch{" O3P GMU"}=" OP3 GMU";
$resn_exch{" O2P GMU"}=" OP2 GMU"; $resn_exch{" O5* GMU"}=" O5' GMU"; $resn_exch{" C5* GMU"}=" C5' GMU";
$resn_exch{" C4* GMU"}=" C4' GMU"; $resn_exch{" O4* GMU"}=" O4' GMU"; $resn_exch{" C3* GMU"}=" C3' GMU";
$resn_exch{" O3* GMU"}=" O3' GMU"; $resn_exch{" C2* GMU"}=" C2' GMU"; $resn_exch{" C1* GMU"}=" C1' GMU";
$resn_exch{" O2* GMU"}=" O2' GMU"; $resn_exch{" CA* GMU"}=" CA' GMU"; $resn_exch{" CB* GMU"}=" CB' GMU";
$resn_exch{" NC* GMU"}=" NC' GMU"; $resn_exch{" CD* GMU"}=" CD' GMU"; $resn_exch{" NE* GMU"}=" NE' GMU";
$resn_exch{" NF* GMU"}=" NF' GMU"; $resn_exch{" O1P GMU"}=" OP1 GMU"; $resn_exch{" O1P GN7"}=" OP1 GN7";
$resn_exch{" O2P GN7"}=" OP2 GN7"; $resn_exch{" O3P GN7"}=" OP3 GN7"; $resn_exch{" O5* GN7"}=" O5' GN7";
$resn_exch{" C5* GN7"}=" C5' GN7"; $resn_exch{" C4* GN7"}=" C4' GN7"; $resn_exch{" O4* GN7"}=" O4' GN7";
$resn_exch{" C3* GN7"}=" C3' GN7"; $resn_exch{" O3* GN7"}=" O3' GN7"; $resn_exch{" C2* GN7"}=" C2' GN7";
$resn_exch{" C1* GN7"}=" C1' GN7"; $resn_exch{" O1P GNE"}=" OP1 GNE"; $resn_exch{" O2P GNE"}=" OP2 GNE";
$resn_exch{" O3P GNE"}=" OP3 GNE"; $resn_exch{" O5* GNE"}=" O5' GNE"; $resn_exch{" C5* GNE"}=" C5' GNE";
$resn_exch{" C4* GNE"}=" C4' GNE"; $resn_exch{" O4* GNE"}=" O4' GNE"; $resn_exch{" C3* GNE"}=" C3' GNE";
$resn_exch{" O3* GNE"}=" O3' GNE"; $resn_exch{" C2* GNE"}=" C2' GNE"; $resn_exch{" C1* GNE"}=" C1' GNE";
$resn_exch{" O5* GNG"}=" O5' GNG"; $resn_exch{" C5* GNG"}=" C5' GNG"; $resn_exch{" C4* GNG"}=" C4' GNG";
$resn_exch{" O4* GNG"}=" O4' GNG"; $resn_exch{" C1* GNG"}=" C1' GNG"; $resn_exch{" C2* GNG"}=" C2' GNG";
$resn_exch{" C3* GNG"}=" C3' GNG"; $resn_exch{" O3* GNG"}=" O3' GNG"; $resn_exch{" O5* GNH"}=" O5' GNH";
$resn_exch{" C5* GNH"}=" C5' GNH"; $resn_exch{" C4* GNH"}=" C4' GNH"; $resn_exch{" O4* GNH"}=" O4' GNH";
$resn_exch{" C3* GNH"}=" C3' GNH"; $resn_exch{" O3* GNH"}=" O3' GNH"; $resn_exch{" C2* GNH"}=" C2' GNH";
$resn_exch{" O2* GNH"}=" O2' GNH"; $resn_exch{" C1* GNH"}=" C1' GNH"; $resn_exch{" O5* GNP"}=" O5' GNP";
$resn_exch{" C5* GNP"}=" C5' GNP"; $resn_exch{" C4* GNP"}=" C4' GNP"; $resn_exch{" O4* GNP"}=" O4' GNP";
$resn_exch{" C3* GNP"}=" C3' GNP"; $resn_exch{" O3* GNP"}=" O3' GNP"; $resn_exch{" C2* GNP"}=" C2' GNP";
$resn_exch{" O2* GNP"}=" O2' GNP"; $resn_exch{" C1* GNP"}=" C1' GNP"; $resn_exch{" O1P GOM"}=" OP1 GOM";
$resn_exch{" O2P GOM"}=" OP2 GOM"; $resn_exch{" O3P GOM"}=" OP3 GOM"; $resn_exch{" O5* GOM"}=" O5' GOM";
$resn_exch{" C5* GOM"}=" C5' GOM"; $resn_exch{" C4* GOM"}=" C4' GOM"; $resn_exch{" O4* GOM"}=" O4' GOM";
$resn_exch{" C1* GOM"}=" C1' GOM"; $resn_exch{" C2* GOM"}=" C2' GOM"; $resn_exch{" O2* GOM"}=" O2' GOM";
$resn_exch{" C3* GOM"}=" C3' GOM"; $resn_exch{" O3* GOM"}=" O3' GOM"; $resn_exch{" C1* GP2"}=" C1' GP2";
$resn_exch{" C2* GP2"}=" C2' GP2"; $resn_exch{" O2* GP2"}=" O2' GP2"; $resn_exch{" C3* GP2"}=" C3' GP2";
$resn_exch{" O3* GP2"}=" O3' GP2"; $resn_exch{" O4* GP2"}=" O4' GP2"; $resn_exch{" C4* GP2"}=" C4' GP2";
$resn_exch{" C5* GP2"}=" C5' GP2"; $resn_exch{" O5* GP2"}=" O5' GP2"; $resn_exch{" AN9 GP3"}=" N9A GP3";
$resn_exch{" AC8 GP3"}=" C8A GP3"; $resn_exch{" AN7 GP3"}=" N7A GP3"; $resn_exch{" AC5 GP3"}=" C5A GP3";
$resn_exch{" AC6 GP3"}=" C6A GP3"; $resn_exch{" AO6 GP3"}=" O6A GP3"; $resn_exch{" AN1 GP3"}=" N1A GP3";
$resn_exch{" AC2 GP3"}=" C2A GP3"; $resn_exch{" AN2 GP3"}=" N2A GP3"; $resn_exch{" AN3 GP3"}=" N3A GP3";
$resn_exch{" AC4 GP3"}=" C4A GP3"; $resn_exch{"AO5* GP3"}=" O5D GP3"; $resn_exch{"AC5* GP3"}=" C5D GP3";
$resn_exch{"AC4* GP3"}=" C4D GP3"; $resn_exch{"AO4* GP3"}=" O4D GP3"; $resn_exch{"AC3* GP3"}=" C3D GP3";
$resn_exch{"AO3* GP3"}=" O3D GP3"; $resn_exch{"AC2* GP3"}=" C2D GP3"; $resn_exch{"AO2* GP3"}=" O2D GP3";
$resn_exch{"AC1* GP3"}=" C1D GP3"; $resn_exch{"BO5* GP3"}=" O5E GP3"; $resn_exch{"BC5* GP3"}=" C5E GP3";
$resn_exch{"BC4* GP3"}=" C4E GP3"; $resn_exch{"BO4* GP3"}=" O4E GP3"; $resn_exch{"BC3* GP3"}=" C3E GP3";
$resn_exch{"BO3* GP3"}=" O3E GP3"; $resn_exch{"BC2* GP3"}=" C2E GP3"; $resn_exch{"BO2* GP3"}=" O2E GP3";
$resn_exch{"BC1* GP3"}=" C1E GP3"; $resn_exch{" BN9 GP3"}=" N9B GP3"; $resn_exch{" BC8 GP3"}=" C8B GP3";
$resn_exch{" BN7 GP3"}=" N7B GP3"; $resn_exch{" BC5 GP3"}=" C5B GP3"; $resn_exch{" BC6 GP3"}=" C6B GP3";
$resn_exch{" BO6 GP3"}=" O6B GP3"; $resn_exch{" BN1 GP3"}=" N1B GP3"; $resn_exch{" BC2 GP3"}=" C2B GP3";
$resn_exch{" BN2 GP3"}=" N2B GP3"; $resn_exch{" BN3 GP3"}=" N3B GP3"; $resn_exch{" BC4 GP3"}=" C4B GP3";
$resn_exch{" C1* GP5"}=" C1' GP5"; $resn_exch{" O4* GP5"}=" O4' GP5"; $resn_exch{" C2* GP5"}=" C2' GP5";
$resn_exch{" O2* GP5"}=" O2' GP5"; $resn_exch{" C3* GP5"}=" C3' GP5"; $resn_exch{" O3* GP5"}=" O3' GP5";
$resn_exch{" C4* GP5"}=" C4' GP5"; $resn_exch{" C5* GP5"}=" C5' GP5"; $resn_exch{" O5* GP5"}=" O5' GP5";
$resn_exch{" GN1 GPC"}=" N1G GPC"; $resn_exch{" GC2 GPC"}=" C2G GPC"; $resn_exch{" GN2 GPC"}=" N2G GPC";
$resn_exch{" GN3 GPC"}=" N3G GPC"; $resn_exch{" GC4 GPC"}=" C4G GPC"; $resn_exch{" GC5 GPC"}=" C5G GPC";
$resn_exch{" GC6 GPC"}=" C6G GPC"; $resn_exch{" GO6 GPC"}=" O6G GPC"; $resn_exch{" GN7 GPC"}=" N7G GPC";
$resn_exch{" GC8 GPC"}=" C8G GPC"; $resn_exch{" GN9 GPC"}=" N9G GPC"; $resn_exch{"GC1* GPC"}=" C1D GPC";
$resn_exch{"GC2* GPC"}=" C2D GPC"; $resn_exch{"GF2* GPC"}=" F2D GPC"; $resn_exch{"GC3* GPC"}=" C3D GPC";
$resn_exch{"GO3* GPC"}=" O3D GPC"; $resn_exch{"GC4* GPC"}=" C4D GPC"; $resn_exch{"GO4* GPC"}=" O4D GPC";
$resn_exch{"GC5* GPC"}=" C5D GPC"; $resn_exch{"GO5* GPC"}=" O5D GPC"; $resn_exch{" CP  GPC"}=" PC  GPC";
$resn_exch{" CO1 GPC"}=" O1C GPC"; $resn_exch{" CO2 GPC"}=" O2C GPC"; $resn_exch{"CO5* GPC"}=" O5B GPC";
$resn_exch{"CC5* GPC"}=" C5X GPC"; $resn_exch{"CC4* GPC"}=" C4X GPC"; $resn_exch{"CO4* GPC"}=" O4B GPC";
$resn_exch{"CC3* GPC"}=" C3X GPC"; $resn_exch{"CO3* GPC"}=" O3B GPC"; $resn_exch{"CC2* GPC"}=" C2X GPC";
$resn_exch{"CO2* GPC"}=" O2B GPC"; $resn_exch{"CC1* GPC"}=" C1X GPC"; $resn_exch{" CN1 GPC"}=" N1C GPC";
$resn_exch{"CO2' GPC"}=" O2X GPC"; $resn_exch{" CN3 GPC"}=" N3C GPC"; $resn_exch{" CN4 GPC"}=" N4C GPC";
$resn_exch{" AN9 GPG"}=" N9A GPG"; $resn_exch{" AC8 GPG"}=" C8A GPG"; $resn_exch{" AN7 GPG"}=" N7A GPG";
$resn_exch{" AC5 GPG"}=" C5A GPG"; $resn_exch{" AC6 GPG"}=" C6A GPG"; $resn_exch{" AO6 GPG"}=" O6A GPG";
$resn_exch{" AN1 GPG"}=" N1A GPG"; $resn_exch{" AC2 GPG"}=" C2A GPG"; $resn_exch{" AN2 GPG"}=" N2A GPG";
$resn_exch{" AN3 GPG"}=" N3A GPG"; $resn_exch{" AC4 GPG"}=" C4A GPG"; $resn_exch{"AO5* GPG"}=" O5D GPG";
$resn_exch{"AC5* GPG"}=" C5D GPG"; $resn_exch{"AC4* GPG"}=" C4D GPG"; $resn_exch{"AO4* GPG"}=" O4D GPG";
$resn_exch{"AC3* GPG"}=" C3D GPG"; $resn_exch{"AO3* GPG"}=" O3D GPG"; $resn_exch{"AC2* GPG"}=" C2D GPG";
$resn_exch{"AO2* GPG"}=" O2D GPG"; $resn_exch{"AC1* GPG"}=" C1D GPG"; $resn_exch{"BO5* GPG"}=" O5E GPG";
$resn_exch{"BC5* GPG"}=" C5E GPG"; $resn_exch{"BC4* GPG"}=" C4E GPG"; $resn_exch{"BO4* GPG"}=" O4E GPG";
$resn_exch{"BC3* GPG"}=" C3E GPG"; $resn_exch{"BO3* GPG"}=" O3E GPG"; $resn_exch{"BC2* GPG"}=" C2E GPG";
$resn_exch{"BO2* GPG"}=" O2E GPG"; $resn_exch{"BC1* GPG"}=" C1E GPG"; $resn_exch{" BN9 GPG"}=" N9B GPG";
$resn_exch{" BC8 GPG"}=" C8B GPG"; $resn_exch{" BN7 GPG"}=" N7B GPG"; $resn_exch{" BC5 GPG"}=" C5B GPG";
$resn_exch{" BC6 GPG"}=" C6B GPG"; $resn_exch{" BO6 GPG"}=" O6B GPG"; $resn_exch{" BN1 GPG"}=" N1B GPG";
$resn_exch{" BC2 GPG"}=" C2B GPG"; $resn_exch{" BN2 GPG"}=" N2B GPG"; $resn_exch{" BN3 GPG"}=" N3B GPG";
$resn_exch{" BC4 GPG"}=" C4B GPG"; $resn_exch{" O5* GPL"}=" O5' GPL"; $resn_exch{" C5* GPL"}=" C5' GPL";
$resn_exch{" C4* GPL"}=" C4' GPL"; $resn_exch{" O4* GPL"}=" O4' GPL"; $resn_exch{" C3* GPL"}=" C3' GPL";
$resn_exch{" O3* GPL"}=" O3' GPL"; $resn_exch{" C2* GPL"}=" C2' GPL"; $resn_exch{" O2* GPL"}=" O2' GPL";
$resn_exch{" C1* GPL"}=" C1' GPL"; $resn_exch{" O1P  GS"}=" OP1  GS"; $resn_exch{" O3P  GS"}=" OP3  GS";
$resn_exch{" O5*  GS"}=" O5'  GS"; $resn_exch{" C5*  GS"}=" C5'  GS"; $resn_exch{" C4*  GS"}=" C4'  GS";
$resn_exch{" O4*  GS"}=" O4'  GS"; $resn_exch{" C3*  GS"}=" C3'  GS"; $resn_exch{" O3*  GS"}=" O3'  GS";
$resn_exch{" C2*  GS"}=" C2'  GS"; $resn_exch{" C1*  GS"}=" C1'  GS"; $resn_exch{" O5* GSP"}=" O5' GSP";
$resn_exch{" C5* GSP"}=" C5' GSP"; $resn_exch{" C4* GSP"}=" C4' GSP"; $resn_exch{" O4* GSP"}=" O4' GSP";
$resn_exch{" C3* GSP"}=" C3' GSP"; $resn_exch{" O3* GSP"}=" O3' GSP"; $resn_exch{" C2* GSP"}=" C2' GSP";
$resn_exch{" O2* GSP"}=" O2' GSP"; $resn_exch{" C1* GSP"}=" C1' GSP"; $resn_exch{" O1P GSR"}=" OP1 GSR";
$resn_exch{" O2P GSR"}=" OP2 GSR"; $resn_exch{" O3P GSR"}=" OP3 GSR"; $resn_exch{" O5* GSR"}=" O5' GSR";
$resn_exch{" C5* GSR"}=" C5' GSR"; $resn_exch{" C4* GSR"}=" C4' GSR"; $resn_exch{" O4* GSR"}=" O4' GSR";
$resn_exch{" C3* GSR"}=" C3' GSR"; $resn_exch{" O3* GSR"}=" O3' GSR"; $resn_exch{" C2* GSR"}=" C2' GSR";
$resn_exch{" C1* GSR"}=" C1' GSR"; $resn_exch{" O1P GSS"}=" OP1 GSS"; $resn_exch{" O2P GSS"}=" OP2 GSS";
$resn_exch{" O3P GSS"}=" OP3 GSS"; $resn_exch{" O5* GSS"}=" O5' GSS"; $resn_exch{" C5* GSS"}=" C5' GSS";
$resn_exch{" C4* GSS"}=" C4' GSS"; $resn_exch{" O4* GSS"}=" O4' GSS"; $resn_exch{" C3* GSS"}=" C3' GSS";
$resn_exch{" O3* GSS"}=" O3' GSS"; $resn_exch{" C2* GSS"}=" C2' GSS"; $resn_exch{" C1* GSS"}=" C1' GSS";
$resn_exch{" O5* GSU"}=" O5' GSU"; $resn_exch{" C5* GSU"}=" C5' GSU"; $resn_exch{" C4* GSU"}=" C4' GSU";
$resn_exch{" O4* GSU"}=" O4' GSU"; $resn_exch{" C1* GSU"}=" C1' GSU"; $resn_exch{" C2* GSU"}=" C2' GSU";
$resn_exch{" O2* GSU"}=" O2' GSU"; $resn_exch{" C3* GSU"}=" C3' GSU"; $resn_exch{" O3* GSU"}=" O3' GSU";
$resn_exch{"C7MA GTG"}=" C7X GTG"; $resn_exch{"O5*A GTG"}=" O5D GTG"; $resn_exch{"C5*A GTG"}=" C5D GTG";
$resn_exch{"C4*A GTG"}=" C4D GTG"; $resn_exch{"O4*A GTG"}=" O4D GTG"; $resn_exch{"C3*A GTG"}=" C3D GTG";
$resn_exch{"O3*A GTG"}=" O3D GTG"; $resn_exch{"C2*A GTG"}=" C2D GTG"; $resn_exch{"O2*A GTG"}=" O2D GTG";
$resn_exch{"C1*A GTG"}=" C1D GTG"; $resn_exch{"O5*B GTG"}=" O5E GTG"; $resn_exch{"C5*B GTG"}=" C5E GTG";
$resn_exch{"C4*B GTG"}=" C4E GTG"; $resn_exch{"O4*B GTG"}=" O4E GTG"; $resn_exch{"C3*B GTG"}=" C3E GTG";
$resn_exch{"O3*B GTG"}=" O3E GTG"; $resn_exch{"C2*B GTG"}=" C2E GTG"; $resn_exch{"O2*B GTG"}=" O2E GTG";
$resn_exch{"C1*B GTG"}=" C1E GTG"; $resn_exch{" O5* GTN"}=" O5' GTN"; $resn_exch{" C5* GTN"}=" C5' GTN";
$resn_exch{" C4* GTN"}=" C4' GTN"; $resn_exch{" O4* GTN"}=" O4' GTN"; $resn_exch{" C3* GTN"}=" C3' GTN";
$resn_exch{" O3* GTN"}=" O3' GTN"; $resn_exch{" C2* GTN"}=" C2' GTN"; $resn_exch{" O2* GTN"}=" O2' GTN";
$resn_exch{" C1* GTN"}=" C1' GTN"; $resn_exch{" O5* GTO"}=" O5' GTO"; $resn_exch{" C5* GTO"}=" C5' GTO";
$resn_exch{" C4* GTO"}=" C4' GTO"; $resn_exch{" O4* GTO"}=" O4' GTO"; $resn_exch{" C3* GTO"}=" C3' GTO";
$resn_exch{" O3* GTO"}=" O3' GTO"; $resn_exch{" C2* GTO"}=" C2' GTO"; $resn_exch{" O2* GTO"}=" O2' GTO";
$resn_exch{" C1* GTO"}=" C1' GTO"; $resn_exch{" O5* GTP"}=" O5' GTP"; $resn_exch{" C5* GTP"}=" C5' GTP";
$resn_exch{" C4* GTP"}=" C4' GTP"; $resn_exch{" O4* GTP"}=" O4' GTP"; $resn_exch{" C3* GTP"}=" C3' GTP";
$resn_exch{" O3* GTP"}=" O3' GTP"; $resn_exch{" C2* GTP"}=" C2' GTP"; $resn_exch{" O2* GTP"}=" O2' GTP";
$resn_exch{" C1* GTP"}=" C1' GTP"; $resn_exch{" C1* GUD"}=" C1D GUD"; $resn_exch{" C2* GUD"}=" C2D GUD";
$resn_exch{" O2* GUD"}=" O2D GUD"; $resn_exch{" C3* GUD"}=" C3D GUD"; $resn_exch{" C4* GUD"}=" C4D GUD";
$resn_exch{" O4* GUD"}=" O4D GUD"; $resn_exch{" O3* GUD"}=" O3D GUD"; $resn_exch{" C5* GUD"}=" C5D GUD";
$resn_exch{" O5* GUD"}=" O5D GUD"; $resn_exch{" N_A H02"}=" NA  H02"; $resn_exch{" N_B H02"}=" NB  H02";
$resn_exch{" N_C H02"}=" NC  H02"; $resn_exch{" N_D H02"}=" ND  H02"; $resn_exch{" O1P H2U"}=" OP1 H2U";
$resn_exch{" O2P H2U"}=" OP2 H2U"; $resn_exch{" O3P H2U"}=" OP3 H2U"; $resn_exch{" O5* H2U"}=" O5' H2U";
$resn_exch{" C5* H2U"}=" C5' H2U"; $resn_exch{" C4* H2U"}=" C4' H2U"; $resn_exch{" O4* H2U"}=" O4' H2U";
$resn_exch{" C3* H2U"}=" C3' H2U"; $resn_exch{" O3* H2U"}=" O3' H2U"; $resn_exch{" C1* H2U"}=" C1' H2U";
$resn_exch{" C2* H2U"}=" C2' H2U"; $resn_exch{" O2* H2U"}=" O2' H2U"; $resn_exch{" O5* HAM"}=" O5' HAM";
$resn_exch{" C5* HAM"}=" C5' HAM"; $resn_exch{" C4* HAM"}=" C4' HAM"; $resn_exch{" O4* HAM"}=" O4' HAM";
$resn_exch{" C3* HAM"}=" C3' HAM"; $resn_exch{" O3* HAM"}=" O3' HAM"; $resn_exch{" C2* HAM"}=" C2' HAM";
$resn_exch{" O2* HAM"}=" O2' HAM"; $resn_exch{" C1* HAM"}=" C1' HAM"; $resn_exch{" N_A HAS"}=" NA  HAS";
$resn_exch{" N_B HAS"}=" NB  HAS"; $resn_exch{" N_C HAS"}=" NC  HAS"; $resn_exch{" N_D HAS"}=" ND  HAS";
$resn_exch{" AN1 HAX"}=" N1A HAX"; $resn_exch{" AC2 HAX"}=" C2A HAX"; $resn_exch{" AN3 HAX"}=" N3A HAX";
$resn_exch{" AC4 HAX"}=" C4A HAX"; $resn_exch{" AC5 HAX"}=" C5A HAX"; $resn_exch{" AC6 HAX"}=" C6A HAX";
$resn_exch{" AN6 HAX"}=" N6A HAX"; $resn_exch{" AN7 HAX"}=" N7A HAX"; $resn_exch{" AC8 HAX"}=" C8A HAX";
$resn_exch{" AN9 HAX"}=" N9A HAX"; $resn_exch{"AC1* HAX"}=" C1B HAX"; $resn_exch{"AC2* HAX"}=" C2B HAX";
$resn_exch{"AO2* HAX"}=" O2B HAX"; $resn_exch{"AC3* HAX"}=" C3B HAX"; $resn_exch{"AO3* HAX"}=" O3B HAX";
$resn_exch{"AP3* HAX"}=" P3B HAX"; $resn_exch{" AO7 HAX"}=" O7A HAX"; $resn_exch{" AO8 HAX"}=" O8A HAX";
$resn_exch{" AO9 HAX"}=" O9A HAX"; $resn_exch{"AC4* HAX"}=" C4B HAX"; $resn_exch{"AO4* HAX"}=" O4B HAX";
$resn_exch{"AC5* HAX"}=" C5B HAX"; $resn_exch{"AO5* HAX"}=" O5B HAX"; $resn_exch{" AP1 HAX"}=" P1A HAX";
$resn_exch{" AO1 HAX"}=" O1A HAX"; $resn_exch{" AO2 HAX"}=" O2A HAX"; $resn_exch{" AO3 HAX"}=" O3A HAX";
$resn_exch{" AP2 HAX"}=" P2A HAX"; $resn_exch{" AO4 HAX"}=" O4A HAX"; $resn_exch{" AO5 HAX"}=" O5A HAX";
$resn_exch{" AO6 HAX"}=" O6A HAX"; $resn_exch{"PC11 HAX"}=" CBP HAX"; $resn_exch{"PC12 HAX"}=" CCP HAX";
$resn_exch{"PC13 HAX"}=" CDP HAX"; $resn_exch{"PC14 HAX"}=" CEP HAX"; $resn_exch{"PC10 HAX"}=" CAP HAX";
$resn_exch{"PO10 HAX"}=" OAP HAX"; $resn_exch{" PC9 HAX"}=" C9P HAX"; $resn_exch{" PO9 HAX"}=" O9P HAX";
$resn_exch{" PN8 HAX"}=" N8P HAX"; $resn_exch{" PC7 HAX"}=" C7P HAX"; $resn_exch{" PC6 HAX"}=" C6P HAX";
$resn_exch{" PC5 HAX"}=" C5P HAX"; $resn_exch{" PO5 HAX"}=" O5P HAX"; $resn_exch{" PN4 HAX"}=" N4P HAX";
$resn_exch{" PC3 HAX"}=" C3P HAX"; $resn_exch{" PC2 HAX"}=" C2P HAX"; $resn_exch{" N_A HCO"}=" NA  HCO";
$resn_exch{" N_B HCO"}=" NB  HCO"; $resn_exch{" N_C HCO"}=" NC  HCO"; $resn_exch{" N_D HCO"}=" ND  HCO";
$resn_exch{" OT1 HCS"}=" OXT HCS"; $resn_exch{" OXT HCS"}=" O   HCS"; $resn_exch{" O5* HCX"}=" O5' HCX";
$resn_exch{" C2* HCX"}=" C2' HCX"; $resn_exch{" C5* HCX"}=" C5' HCX"; $resn_exch{" C4* HCX"}=" C4' HCX";
$resn_exch{" C1* HCX"}=" C1' HCX"; $resn_exch{" C3* HCX"}=" C3' HCX"; $resn_exch{" O3* HCX"}=" O3' HCX";
$resn_exch{"PO10 HDC"}=" OAP HDC"; $resn_exch{"PC10 HDC"}=" CAP HDC"; $resn_exch{" PC9 HDC"}=" C9P HDC";
$resn_exch{" PO9 HDC"}=" O9P HDC"; $resn_exch{" PN8 HDC"}=" N8P HDC"; $resn_exch{" PC7 HDC"}=" C7P HDC";
$resn_exch{" PC6 HDC"}=" C6P HDC"; $resn_exch{" PC5 HDC"}=" C5P HDC"; $resn_exch{" PO5 HDC"}=" O5P HDC";
$resn_exch{" PN4 HDC"}=" N4P HDC"; $resn_exch{" PC3 HDC"}=" C3P HDC"; $resn_exch{" PC2 HDC"}=" C2P HDC";
$resn_exch{" PS1 HDC"}=" S1P HDC"; $resn_exch{" C1* HDC"}=" C1' HDC"; $resn_exch{" O1* HDC"}=" O1' HDC";
$resn_exch{" C2* HDC"}=" C2' HDC"; $resn_exch{" C3* HDC"}=" C3' HDC"; $resn_exch{" O2* HDC"}=" O2' HDC";
$resn_exch{" C4* HDC"}=" C4' HDC"; $resn_exch{" C5* HDC"}=" C5' HDC"; $resn_exch{" C6* HDC"}=" C6' HDC";
$resn_exch{" C7* HDC"}=" C7' HDC"; $resn_exch{" C8* HDC"}=" C8' HDC"; $resn_exch{" C9* HDC"}=" C9' HDC";
$resn_exch{"PC11 HDC"}=" CBP HDC"; $resn_exch{"PC13 HDC"}=" CDP HDC"; $resn_exch{"PC14 HDC"}=" CEP HDC";
$resn_exch{"PC12 HDC"}=" CCP HDC"; $resn_exch{" AO6 HDC"}=" O6A HDC"; $resn_exch{" AP2 HDC"}=" P2A HDC";
$resn_exch{" AO4 HDC"}=" O4A HDC"; $resn_exch{" AO5 HDC"}=" O5A HDC"; $resn_exch{" AO3 HDC"}=" O3A HDC";
$resn_exch{" AP1 HDC"}=" P1A HDC"; $resn_exch{" AO1 HDC"}=" O1A HDC"; $resn_exch{" AO2 HDC"}=" O2A HDC";
$resn_exch{"AO5* HDC"}=" O5B HDC"; $resn_exch{"AC5* HDC"}=" C5B HDC"; $resn_exch{"AC4* HDC"}=" C4B HDC";
$resn_exch{"AO4* HDC"}=" O4B HDC"; $resn_exch{"AC1* HDC"}=" C1B HDC"; $resn_exch{" AN9 HDC"}=" N9A HDC";
$resn_exch{" AC8 HDC"}=" C8A HDC"; $resn_exch{" AN7 HDC"}=" N7A HDC"; $resn_exch{" AC5 HDC"}=" C5A HDC";
$resn_exch{" AC4 HDC"}=" C4A HDC"; $resn_exch{" AN3 HDC"}=" N3A HDC"; $resn_exch{" AC2 HDC"}=" C2A HDC";
$resn_exch{" AN1 HDC"}=" N1A HDC"; $resn_exch{" AC6 HDC"}=" C6A HDC"; $resn_exch{" AN6 HDC"}=" N6A HDC";
$resn_exch{"AC2* HDC"}=" C2B HDC"; $resn_exch{"AO2* HDC"}=" O2B HDC"; $resn_exch{"AC3* HDC"}=" C3B HDC";
$resn_exch{"AO3* HDC"}=" O3B HDC"; $resn_exch{"AP3* HDC"}=" P3B HDC"; $resn_exch{" AO9 HDC"}=" O9A HDC";
$resn_exch{" AO8 HDC"}=" O8A HDC"; $resn_exch{" AO7 HDC"}=" O7A HDC"; $resn_exch{" N_A HDD"}=" NA  HDD";
$resn_exch{" N_B HDD"}=" NB  HDD"; $resn_exch{" N_C HDD"}=" NC  HDD"; $resn_exch{" N_D HDD"}=" ND  HDD";
$resn_exch{" C1* HDF"}=" C1' HDF"; $resn_exch{" C2* HDF"}=" C2' HDF"; $resn_exch{" O2* HDF"}=" O2' HDF";
$resn_exch{" C3* HDF"}=" C3' HDF"; $resn_exch{" O3* HDF"}=" O3' HDF"; $resn_exch{" C4* HDF"}=" C4' HDF";
$resn_exch{" O4* HDF"}=" O4' HDF"; $resn_exch{" C5* HDF"}=" C5' HDF"; $resn_exch{" O5* HDF"}=" O5' HDF";
$resn_exch{" N_A HDM"}=" NA  HDM"; $resn_exch{" N_B HDM"}=" NB  HDM"; $resn_exch{" N_C HDM"}=" NC  HDM";
$resn_exch{" N_D HDM"}=" ND  HDM"; $resn_exch{" O1P HDP"}=" OP1 HDP"; $resn_exch{" O2P HDP"}=" OP2 HDP";
$resn_exch{" O5* HDP"}=" O5' HDP"; $resn_exch{" C5* HDP"}=" C5B HDP"; $resn_exch{" O3* HDP"}=" O3' HDP";
$resn_exch{" O3P HDP"}=" OP3 HDP"; $resn_exch{" N_A HE6"}=" NA  HE6"; $resn_exch{" N_B HE6"}=" NB  HE6";
$resn_exch{" N_C HE6"}=" NC  HE6"; $resn_exch{" N_D HE6"}=" ND  HE6"; $resn_exch{" N_A HEA"}=" NA  HEA";
$resn_exch{" N_B HEA"}=" NB  HEA"; $resn_exch{" N_C HEA"}=" NC  HEA"; $resn_exch{" N_D HEA"}=" ND  HEA";
$resn_exch{" N_A HEB"}=" NA  HEB"; $resn_exch{" N_B HEB"}=" NB  HEB"; $resn_exch{" N_C HEB"}=" NC  HEB";
$resn_exch{" N_D HEB"}=" ND  HEB"; $resn_exch{" N_A HEC"}=" NA  HEC"; $resn_exch{" N_B HEC"}=" NB  HEC";
$resn_exch{" N_C HEC"}=" NC  HEC"; $resn_exch{" N_D HEC"}=" ND  HEC"; $resn_exch{" N_A HEG"}=" NA  HEG";
$resn_exch{" N_B HEG"}=" NB  HEG"; $resn_exch{" N_C HEG"}=" NC  HEG"; $resn_exch{" N_D HEG"}=" ND  HEG";
$resn_exch{"C12B HEH"}=" CCB HEH"; $resn_exch{"O11D HEH"}=" O11 HEH"; $resn_exch{"C11A HEH"}=" CBA HEH";
$resn_exch{"C12A HEH"}=" CCA HEH"; $resn_exch{"O12C HEH"}=" OCC HEH"; $resn_exch{"1CEM HEH"}=" C1X HEH";
$resn_exch{"2CEG HEH"}=" C2X HEH"; $resn_exch{"3CEG HEH"}=" C3X HEH"; $resn_exch{"CFM7 HEH"}=" C1A HEH";
$resn_exch{"5CFK HEH"}=" C5X HEH"; $resn_exch{"6CKF HEH"}=" C1B HEH"; $resn_exch{"CFM4 HEH"}=" C1C HEH";
$resn_exch{" N_A HEM"}=" NA  HEM"; $resn_exch{" N_B HEM"}=" NB  HEM"; $resn_exch{" N_C HEM"}=" NC  HEM";
$resn_exch{" N_D HEM"}=" ND  HEM"; $resn_exch{" N_A HEO"}=" NA  HEO"; $resn_exch{" N_B HEO"}=" NB  HEO";
$resn_exch{" N_C HEO"}=" NC  HEO"; $resn_exch{" N_D HEO"}=" ND  HEO"; $resn_exch{" N_A HES"}=" NA  HES";
$resn_exch{" N_B HES"}=" NB  HES"; $resn_exch{" N_C HES"}=" NC  HES"; $resn_exch{" N_D HES"}=" ND  HES";
$resn_exch{" O2P HEU"}=" OP2 HEU"; $resn_exch{" O1P HEU"}=" OP1 HEU"; $resn_exch{" O5* HEU"}=" O5' HEU";
$resn_exch{" C5* HEU"}=" C5' HEU"; $resn_exch{" C4* HEU"}=" C4' HEU"; $resn_exch{" O4* HEU"}=" O4' HEU";
$resn_exch{" C1* HEU"}=" C1' HEU"; $resn_exch{" C3* HEU"}=" C3' HEU"; $resn_exch{" C2* HEU"}=" C2' HEU";
$resn_exch{" O3* HEU"}=" O3' HEU"; $resn_exch{" O3P HEU"}=" OP3 HEU"; $resn_exch{" N_A HEV"}=" NA  HEV";
$resn_exch{" N_B HEV"}=" NB  HEV"; $resn_exch{" N_C HEV"}=" NC  HEV"; $resn_exch{" N_D HEV"}=" ND  HEV";
$resn_exch{" N_A HFM"}=" NA  HFM"; $resn_exch{" N_B HFM"}=" NB  HFM"; $resn_exch{" N_C HFM"}=" NC  HFM";
$resn_exch{" N_D HFM"}=" ND  HFM"; $resn_exch{" N_A HIF"}=" NA  HIF"; $resn_exch{" N_B HIF"}=" NB  HIF";
$resn_exch{" N_C HIF"}=" NC  HIF"; $resn_exch{" N_D HIF"}=" ND  HIF"; $resn_exch{" N_C HME"}=" NC  HME";
$resn_exch{" N_B HME"}=" NB  HME"; $resn_exch{" N_A HME"}=" NA  HME"; $resn_exch{" N_D HME"}=" ND  HME";
$resn_exch{"O5*A HMG"}=" O5B HMG"; $resn_exch{"C5*A HMG"}=" C5B HMG"; $resn_exch{"C4*A HMG"}=" C4B HMG";
$resn_exch{"O4*A HMG"}=" O4B HMG"; $resn_exch{"C3*A HMG"}=" C3B HMG"; $resn_exch{"O3*A HMG"}=" O3B HMG";
$resn_exch{"C2*A HMG"}=" C2B HMG"; $resn_exch{"O2*A HMG"}=" O2B HMG"; $resn_exch{"C1*A HMG"}=" C1B HMG";
$resn_exch{"P3*A HMG"}=" P3B HMG"; $resn_exch{"C11P HMG"}=" CBP HMG"; $resn_exch{"C12P HMG"}=" CCP HMG";
$resn_exch{"C13P HMG"}=" CDP HMG"; $resn_exch{"C14P HMG"}=" CEP HMG"; $resn_exch{"C10P HMG"}=" CAP HMG";
$resn_exch{"O10P HMG"}=" OAP HMG"; $resn_exch{" N_A HNI"}=" NA  HNI"; $resn_exch{" N_B HNI"}=" NB  HNI";
$resn_exch{" N_C HNI"}=" NC  HNI"; $resn_exch{" N_D HNI"}=" ND  HNI"; $resn_exch{" O1P HOB"}=" OP1 HOB";
$resn_exch{" O2P HOB"}=" OP2 HOB"; $resn_exch{" O5* HOB"}=" O5' HOB"; $resn_exch{" C5* HOB"}=" C5' HOB";
$resn_exch{" C4* HOB"}=" C4' HOB"; $resn_exch{" C3* HOB"}=" C3' HOB"; $resn_exch{" C2* HOB"}=" C2' HOB";
$resn_exch{" C1* HOB"}=" C1' HOB"; $resn_exch{" O4* HOB"}=" O4' HOB"; $resn_exch{" O3* HOB"}=" O3' HOB";
$resn_exch{" O3P HOB"}=" OP3 HOB"; $resn_exch{" O1P HOL"}=" OP1 HOL"; $resn_exch{" O2P HOL"}=" OP2 HOL";
$resn_exch{" O5* HOL"}=" O5' HOL"; $resn_exch{" C5* HOL"}=" C5' HOL"; $resn_exch{" C4* HOL"}=" C4' HOL";
$resn_exch{" C3* HOL"}=" C3' HOL"; $resn_exch{" C2* HOL"}=" C2' HOL"; $resn_exch{" C1* HOL"}=" C1' HOL";
$resn_exch{" O4* HOL"}=" O4' HOL"; $resn_exch{" O3* HOL"}=" O3' HOL"; $resn_exch{" O3P HOL"}=" OP3 HOL";
$resn_exch{" O5* HPD"}=" O5' HPD"; $resn_exch{" C5* HPD"}=" C5' HPD"; $resn_exch{" O4* HPD"}=" O4' HPD";
$resn_exch{" O3* HPD"}=" O3' HPD"; $resn_exch{" C1* HPD"}=" C1' HPD"; $resn_exch{" O1* HPD"}=" O1' HPD";
$resn_exch{" C3* HPD"}=" C3' HPD"; $resn_exch{" C4* HPD"}=" C4' HPD"; $resn_exch{" C2* HPD"}=" C2' HPD";
$resn_exch{" C1* HPR"}=" C1' HPR"; $resn_exch{" C2* HPR"}=" C2' HPR"; $resn_exch{" O2* HPR"}=" O2' HPR";
$resn_exch{" C3* HPR"}=" C3' HPR"; $resn_exch{" O3* HPR"}=" O3' HPR"; $resn_exch{" C4* HPR"}=" C4' HPR";
$resn_exch{" O4* HPR"}=" O4' HPR"; $resn_exch{" C5* HPR"}=" C5' HPR"; $resn_exch{" O5* HPR"}=" O5' HPR";
$resn_exch{" O5* HSS"}=" O5' HSS"; $resn_exch{" C5* HSS"}=" C5' HSS"; $resn_exch{" C4* HSS"}=" C4' HSS";
$resn_exch{" O4* HSS"}=" O4' HSS"; $resn_exch{" C3* HSS"}=" C3' HSS"; $resn_exch{" O3* HSS"}=" O3' HSS";
$resn_exch{" C2* HSS"}=" C2' HSS"; $resn_exch{" O2* HSS"}=" O2' HSS"; $resn_exch{" C1* HSS"}=" C1' HSS";
$resn_exch{" N1* HTL"}=" N1' HTL"; $resn_exch{" C2* HTL"}=" C2' HTL"; $resn_exch{" N3* HTL"}=" N3' HTL";
$resn_exch{" C4* HTL"}=" C4' HTL"; $resn_exch{" N4* HTL"}=" N4' HTL"; $resn_exch{" C5* HTL"}=" C5' HTL";
$resn_exch{" C6* HTL"}=" C6' HTL"; $resn_exch{" C1* HY1"}=" C1' HY1"; $resn_exch{" C2* HY1"}=" C2' HY1";
$resn_exch{" C3* HY1"}=" C3' HY1"; $resn_exch{" C4* HY1"}=" C4' HY1"; $resn_exch{" C5* HY1"}=" C5' HY1";
$resn_exch{" C6* HY1"}=" C6' HY1"; $resn_exch{" OD  HYP"}=" OD1 HYP"; $resn_exch{" O3P   I"}=" OP3   I";
$resn_exch{" O1P   I"}=" OP1   I"; $resn_exch{" O2P   I"}=" OP2   I"; $resn_exch{" O5*   I"}=" O5'   I";
$resn_exch{" C5*   I"}=" C5'   I"; $resn_exch{" C4*   I"}=" C4'   I"; $resn_exch{" O4*   I"}=" O4'   I";
$resn_exch{" C3*   I"}=" C3'   I"; $resn_exch{" O3*   I"}=" O3'   I"; $resn_exch{" C2*   I"}=" C2'   I";
$resn_exch{" O2*   I"}=" O2'   I"; $resn_exch{" C1*   I"}=" C1'   I"; $resn_exch{" C3* I3A"}=" C3' I3A";
$resn_exch{" O1P I5C"}=" OP1 I5C"; $resn_exch{" O2P I5C"}=" OP2 I5C"; $resn_exch{" O5* I5C"}=" O5' I5C";
$resn_exch{" C2* I5C"}=" C2' I5C"; $resn_exch{" C5* I5C"}=" C5' I5C"; $resn_exch{" C4* I5C"}=" C4' I5C";
$resn_exch{" O4* I5C"}=" O4' I5C"; $resn_exch{" C1* I5C"}=" C1' I5C"; $resn_exch{" C3* I5C"}=" C3' I5C";
$resn_exch{" O3* I5C"}=" O3' I5C"; $resn_exch{" O3P I5C"}=" OP3 I5C"; $resn_exch{" O5* IB2"}=" O5D IB2";
$resn_exch{" C5* IB2"}=" C5D IB2"; $resn_exch{" C4* IB2"}=" C4D IB2"; $resn_exch{" O4* IB2"}=" O4D IB2";
$resn_exch{" C3* IB2"}=" C3D IB2"; $resn_exch{" O3* IB2"}=" O3D IB2"; $resn_exch{" C2* IB2"}=" C2D IB2";
$resn_exch{" O2* IB2"}=" O2D IB2"; $resn_exch{" C1* IB2"}=" C1D IB2"; $resn_exch{" AN9 IB2"}=" N9A IB2";
$resn_exch{" AC8 IB2"}=" C8A IB2"; $resn_exch{" AN7 IB2"}=" N7A IB2"; $resn_exch{" AC5 IB2"}=" C5A IB2";
$resn_exch{" AC6 IB2"}=" C6A IB2"; $resn_exch{" AN6 IB2"}=" N6A IB2"; $resn_exch{" AN1 IB2"}=" N1A IB2";
$resn_exch{" AC2 IB2"}=" C2A IB2"; $resn_exch{" AN3 IB2"}=" N3A IB2"; $resn_exch{" AC4 IB2"}=" C4A IB2";
$resn_exch{" O1P  IC"}=" OP1  IC"; $resn_exch{" O2P  IC"}=" OP2  IC"; $resn_exch{" O3P  IC"}=" OP3  IC";
$resn_exch{" O5*  IC"}=" O5'  IC"; $resn_exch{" O3*  IC"}=" O3'  IC"; $resn_exch{" C1*  IC"}=" C1'  IC";
$resn_exch{" C2*  IC"}=" C2'  IC"; $resn_exch{" C3*  IC"}=" C3'  IC"; $resn_exch{" C4*  IC"}=" C4'  IC";
$resn_exch{" C5*  IC"}=" C5'  IC"; $resn_exch{" O4*  IC"}=" O4'  IC"; $resn_exch{" O2*  IC"}=" O2'  IC";
$resn_exch{" O5* ID2"}=" O5' ID2"; $resn_exch{" C5* ID2"}=" C5' ID2"; $resn_exch{" C4* ID2"}=" C4' ID2";
$resn_exch{" O4* ID2"}=" O4' ID2"; $resn_exch{" C1* ID2"}=" C1' ID2"; $resn_exch{" C2* ID2"}=" C2' ID2";
$resn_exch{" C3* ID2"}=" C3' ID2"; $resn_exch{" O3* ID2"}=" O3' ID2"; $resn_exch{" O5* IDP"}=" O5' IDP";
$resn_exch{" C5* IDP"}=" C5' IDP"; $resn_exch{" C4* IDP"}=" C4' IDP"; $resn_exch{" O4* IDP"}=" O4' IDP";
$resn_exch{" C3* IDP"}=" C3' IDP"; $resn_exch{" O3* IDP"}=" O3' IDP"; $resn_exch{" C2* IDP"}=" C2' IDP";
$resn_exch{" O2* IDP"}=" O2' IDP"; $resn_exch{" C1* IDP"}=" C1' IDP"; $resn_exch{" O1P  IG"}=" OP1  IG";
$resn_exch{" O2P  IG"}=" OP2  IG"; $resn_exch{" O3P  IG"}=" OP3  IG"; $resn_exch{" O5*  IG"}=" O5'  IG";
$resn_exch{" O3*  IG"}=" O3'  IG"; $resn_exch{" C1*  IG"}=" C1'  IG"; $resn_exch{" C2*  IG"}=" C2'  IG";
$resn_exch{" C3*  IG"}=" C3'  IG"; $resn_exch{" C4*  IG"}=" C4'  IG"; $resn_exch{" C5*  IG"}=" C5'  IG";
$resn_exch{" O4*  IG"}=" O4'  IG"; $resn_exch{" O2*  IG"}=" O2'  IG"; $resn_exch{" O1P IGU"}=" OP1 IGU";
$resn_exch{" O2P IGU"}=" OP2 IGU"; $resn_exch{" O3P IGU"}=" OP3 IGU"; $resn_exch{" O5* IGU"}=" O5' IGU";
$resn_exch{" C5* IGU"}=" C5' IGU"; $resn_exch{" C4* IGU"}=" C4' IGU"; $resn_exch{" O4* IGU"}=" O4' IGU";
$resn_exch{" C3* IGU"}=" C3' IGU"; $resn_exch{" O3* IGU"}=" O3' IGU"; $resn_exch{" C2* IGU"}=" C2' IGU";
$resn_exch{" C1* IGU"}=" C1' IGU"; $resn_exch{"2O1  IHS"}=" O12 IHS"; $resn_exch{"2O3  IHS"}=" O32 IHS";
$resn_exch{"2O2  IHS"}=" O22 IHS"; $resn_exch{"2O4  IHS"}=" O42 IHS"; $resn_exch{"3O1  IHS"}=" O13 IHS";
$resn_exch{"3O3  IHS"}=" O33 IHS"; $resn_exch{"3O2  IHS"}=" O23 IHS"; $resn_exch{"3O4  IHS"}=" O43 IHS";
$resn_exch{"4O1  IHS"}=" O14 IHS"; $resn_exch{"4O3  IHS"}=" O34 IHS"; $resn_exch{"4O2  IHS"}=" O24 IHS";
$resn_exch{"4O4  IHS"}=" O44 IHS"; $resn_exch{"5O1  IHS"}=" O15 IHS"; $resn_exch{"5O3  IHS"}=" O35 IHS";
$resn_exch{"5O2  IHS"}=" O25 IHS"; $resn_exch{"5O4  IHS"}=" O45 IHS"; $resn_exch{"6O1  IHS"}=" O16 IHS";
$resn_exch{"6O3  IHS"}=" O36 IHS"; $resn_exch{"6O2  IHS"}=" O26 IHS"; $resn_exch{"6O4  IHS"}=" O46 IHS";
$resn_exch{" O1P IMC"}=" OP1 IMC"; $resn_exch{" O2P IMC"}=" OP2 IMC"; $resn_exch{" O3P IMC"}=" OP3 IMC";
$resn_exch{" O5* IMC"}=" O5' IMC"; $resn_exch{" C5* IMC"}=" C5' IMC"; $resn_exch{" C4* IMC"}=" C4' IMC";
$resn_exch{" O4* IMC"}=" O4' IMC"; $resn_exch{" C1* IMC"}=" C1' IMC"; $resn_exch{" C2* IMC"}=" C2' IMC";
$resn_exch{" C3* IMC"}=" C3' IMC"; $resn_exch{" O3* IMC"}=" O3' IMC"; $resn_exch{"1CG  IME"}=" CG1 IME";
$resn_exch{"1CD2 IME"}=" CDC IME"; $resn_exch{"1ND1 IME"}=" NDB IME"; $resn_exch{"1CE1 IME"}=" CEB IME";
$resn_exch{"1NE2 IME"}=" NEC IME"; $resn_exch{"2CG  IME"}=" CG2 IME"; $resn_exch{"2CD2 IME"}=" CDM IME";
$resn_exch{"2ND1 IME"}=" NDL IME"; $resn_exch{"2CE1 IME"}=" CEL IME"; $resn_exch{"2NE2 IME"}=" NEM IME";
$resn_exch{"3CG  IME"}=" CG3 IME"; $resn_exch{"3CD2 IME"}=" CDW IME"; $resn_exch{"3ND1 IME"}=" NDV IME";
$resn_exch{"3CE1 IME"}=" CEV IME"; $resn_exch{"3NE2 IME"}=" NEW IME"; $resn_exch{"4CG  IME"}=" CG4 IME";
$resn_exch{"4CD2 IME"}=" CD6 IME"; $resn_exch{"4ND1 IME"}=" ND5 IME"; $resn_exch{"4CE1 IME"}=" CE5 IME";
$resn_exch{"4NE2 IME"}=" NE6 IME"; $resn_exch{"1CG  IMF"}=" CG1 IMF"; $resn_exch{"1CD2 IMF"}=" CDC IMF";
$resn_exch{"1ND1 IMF"}=" NDB IMF"; $resn_exch{"1CE1 IMF"}=" CEB IMF"; $resn_exch{"1NE2 IMF"}=" NEC IMF";
$resn_exch{"2CG  IMF"}=" CG2 IMF"; $resn_exch{"2CD2 IMF"}=" CDM IMF"; $resn_exch{"2ND1 IMF"}=" NDL IMF";
$resn_exch{"2CE1 IMF"}=" CEL IMF"; $resn_exch{"2NE2 IMF"}=" NEM IMF"; $resn_exch{"3CG  IMF"}=" CG3 IMF";
$resn_exch{"3CD2 IMF"}=" CDW IMF"; $resn_exch{"3ND1 IMF"}=" NDV IMF"; $resn_exch{"3CE1 IMF"}=" CEV IMF";
$resn_exch{"3NE2 IMF"}=" NEW IMF"; $resn_exch{"4CG  IMF"}=" CG4 IMF"; $resn_exch{"4CD2 IMF"}=" CD6 IMF";
$resn_exch{"4ND1 IMF"}=" ND5 IMF"; $resn_exch{"4CE1 IMF"}=" CE5 IMF"; $resn_exch{"4NE2 IMF"}=" NE6 IMF";
$resn_exch{" O5* IMG"}=" O5' IMG"; $resn_exch{" C5* IMG"}=" C5' IMG"; $resn_exch{" C4* IMG"}=" C4' IMG";
$resn_exch{" N4* IMG"}=" N4' IMG"; $resn_exch{" C3* IMG"}=" C3' IMG"; $resn_exch{" O3* IMG"}=" O3' IMG";
$resn_exch{" C2* IMG"}=" C2' IMG"; $resn_exch{" O2* IMG"}=" O2' IMG"; $resn_exch{" C1* IMG"}=" C1' IMG";
$resn_exch{" O5* IMH"}=" O5' IMH"; $resn_exch{" C5* IMH"}=" C5' IMH"; $resn_exch{" C4* IMH"}=" C4' IMH";
$resn_exch{" N4* IMH"}=" N4' IMH"; $resn_exch{" C3* IMH"}=" C3' IMH"; $resn_exch{" O3* IMH"}=" O3' IMH";
$resn_exch{" C2* IMH"}=" C2' IMH"; $resn_exch{" O2* IMH"}=" O2' IMH"; $resn_exch{" C1* IMH"}=" C1' IMH";
$resn_exch{" O5* IMP"}=" O5' IMP"; $resn_exch{" C5* IMP"}=" C5' IMP"; $resn_exch{" C4* IMP"}=" C4' IMP";
$resn_exch{" O4* IMP"}=" O4' IMP"; $resn_exch{" C3* IMP"}=" C3' IMP"; $resn_exch{" O3* IMP"}=" O3' IMP";
$resn_exch{" C2* IMP"}=" C2' IMP"; $resn_exch{" O2* IMP"}=" O2' IMP"; $resn_exch{" C1* IMP"}=" C1' IMP";
$resn_exch{" O5* IMR"}=" O5' IMR"; $resn_exch{" C5* IMR"}=" C5' IMR"; $resn_exch{" C4* IMR"}=" C4' IMR";
$resn_exch{" N4* IMR"}=" N4' IMR"; $resn_exch{" C3* IMR"}=" C3' IMR"; $resn_exch{" O3* IMR"}=" O3' IMR";
$resn_exch{" C2* IMR"}=" C2' IMR"; $resn_exch{" O2* IMR"}=" O2' IMR"; $resn_exch{" C1* IMR"}=" C1' IMR";
$resn_exch{" O5* IMU"}=" O5' IMU"; $resn_exch{" C5* IMU"}=" C5' IMU"; $resn_exch{" C4* IMU"}=" C4' IMU";
$resn_exch{" N4* IMU"}=" N4' IMU"; $resn_exch{" C3* IMU"}=" C3' IMU"; $resn_exch{" O3* IMU"}=" O3' IMU";
$resn_exch{" C2* IMU"}=" C2' IMU"; $resn_exch{" O2* IMU"}=" O2' IMU"; $resn_exch{" C1* IMU"}=" C1' IMU";
$resn_exch{"'O10 IN3"}=" OA' IN3"; $resn_exch{"'C11 IN3"}=" CB' IN3"; $resn_exch{"'C12 IN3"}=" CC' IN3";
$resn_exch{"'C14 IN3"}=" CE' IN3"; $resn_exch{"'C15 IN3"}=" CF' IN3"; $resn_exch{"'C16 IN3"}=" CG' IN3";
$resn_exch{"'C17 IN3"}=" CH' IN3"; $resn_exch{"'O18 IN3"}=" OI' IN3"; $resn_exch{"'N19 IN3"}=" NJ' IN3";
$resn_exch{"'N20 IN3"}=" NK' IN3"; $resn_exch{"'N24 IN3"}=" NO' IN3"; $resn_exch{"'O10 IN6"}=" OA' IN6";
$resn_exch{"'C11 IN6"}=" CB' IN6"; $resn_exch{"'C12 IN6"}=" CC' IN6"; $resn_exch{"'C14 IN6"}=" CE' IN6";
$resn_exch{"'C15 IN6"}=" CF' IN6"; $resn_exch{"'C16 IN6"}=" CG' IN6"; $resn_exch{"'C17 IN6"}=" CH' IN6";
$resn_exch{"'O18 IN6"}=" OI' IN6"; $resn_exch{"'N19 IN6"}=" NJ' IN6"; $resn_exch{"'N20 IN6"}=" NK' IN6";
$resn_exch{"'N24 IN6"}=" NO' IN6"; $resn_exch{" C1\" INB"}=" C1B INB"; $resn_exch{" C2\" INB"}=" C2B INB";
$resn_exch{" CM\" INB"}=" CMB INB"; $resn_exch{" O5* IOT"}=" O5' IOT"; $resn_exch{" C5* IOT"}=" C5' IOT";
$resn_exch{" C4* IOT"}=" C4' IOT"; $resn_exch{" O4* IOT"}=" O4' IOT"; $resn_exch{" C3* IOT"}=" C3' IOT";
$resn_exch{" O3* IOT"}=" O3' IOT"; $resn_exch{" C2* IOT"}=" C2' IOT"; $resn_exch{" O2* IOT"}=" O2' IOT";
$resn_exch{" C1* IOT"}=" C1' IOT"; $resn_exch{" O   IOY"}=" OXT IOY"; $resn_exch{" OXT IOY"}=" O   IOY";
$resn_exch{" C1* IQB"}=" C1' IQB"; $resn_exch{" C2* IQB"}=" C2B IQB"; $resn_exch{" C3* IQB"}=" C3B IQB";
$resn_exch{" C4* IQB"}=" C4' IQB"; $resn_exch{"BR4* IQB"}="BR4' IQB"; $resn_exch{" C5* IQB"}=" C5B IQB";
$resn_exch{" C6* IQB"}=" C6B IQB"; $resn_exch{" C1* IRF"}=" C1' IRF"; $resn_exch{" C2* IRF"}=" C2' IRF";
$resn_exch{" O2* IRF"}=" O2' IRF"; $resn_exch{" C3* IRF"}=" C3' IRF"; $resn_exch{" O3* IRF"}=" O3' IRF";
$resn_exch{" C4* IRF"}=" C4' IRF"; $resn_exch{" O4* IRF"}=" O4' IRF"; $resn_exch{" C5* IRF"}=" C5' IRF";
$resn_exch{" O5* IRF"}=" O5' IRF"; $resn_exch{" O5* IRP"}=" O5' IRP"; $resn_exch{" C5* IRP"}=" C5' IRP";
$resn_exch{" C4* IRP"}=" C4' IRP"; $resn_exch{" N4* IRP"}=" N4' IRP"; $resn_exch{" C3* IRP"}=" C3' IRP";
$resn_exch{" O3* IRP"}=" O3' IRP"; $resn_exch{" C2* IRP"}=" C2' IRP"; $resn_exch{" O2* IRP"}=" O2' IRP";
$resn_exch{" C1* IRP"}=" C1' IRP"; $resn_exch{" O5* ITT"}=" O5' ITT"; $resn_exch{" C5* ITT"}=" C5' ITT";
$resn_exch{" C4* ITT"}=" C4' ITT"; $resn_exch{" O4* ITT"}=" O4' ITT"; $resn_exch{" C3* ITT"}=" C3' ITT";
$resn_exch{" O3* ITT"}=" O3' ITT"; $resn_exch{" C2* ITT"}=" C2' ITT"; $resn_exch{" O2* ITT"}=" O2' ITT";
$resn_exch{" C1* ITT"}=" C1' ITT"; $resn_exch{" O1P  IU"}=" OP1  IU"; $resn_exch{" O2P  IU"}=" OP2  IU";
$resn_exch{" O3P  IU"}=" OP3  IU"; $resn_exch{" O5*  IU"}=" O5'  IU"; $resn_exch{" C5*  IU"}=" C5'  IU";
$resn_exch{" C4*  IU"}=" C4'  IU"; $resn_exch{" O4*  IU"}=" O4'  IU"; $resn_exch{" C3*  IU"}=" C3'  IU";
$resn_exch{" O3*  IU"}=" O3'  IU"; $resn_exch{" C2*  IU"}=" C2'  IU"; $resn_exch{" O2*  IU"}=" O2'  IU";
$resn_exch{" C1*  IU"}=" C1'  IU"; $resn_exch{" C1* JW5"}=" C1' JW5"; $resn_exch{" O4* JW5"}=" O4' JW5";
$resn_exch{" C2* JW5"}=" C2' JW5"; $resn_exch{" O2* JW5"}=" O2' JW5"; $resn_exch{" C3* JW5"}=" C3' JW5";
$resn_exch{" O3* JW5"}=" O3' JW5"; $resn_exch{" C4* JW5"}=" C4' JW5"; $resn_exch{" C5* JW5"}=" C5' JW5";
$resn_exch{" O5* JW5"}=" O5' JW5"; $resn_exch{" C1* K05"}=" C1' K05"; $resn_exch{" C2* K05"}=" C2' K05";
$resn_exch{" C3* K05"}=" C3' K05"; $resn_exch{" C4* K05"}=" C4' K05"; $resn_exch{" C5* K05"}=" C5' K05";
$resn_exch{" C6* K05"}=" C6' K05"; $resn_exch{" O3P KAG"}=" OP3 KAG"; $resn_exch{" O1P KAG"}=" OP1 KAG";
$resn_exch{" O2P KAG"}=" OP2 KAG"; $resn_exch{" O5* KAG"}=" O5' KAG"; $resn_exch{" C5* KAG"}=" C5' KAG";
$resn_exch{" C4* KAG"}=" C4' KAG"; $resn_exch{" O4* KAG"}=" O4' KAG"; $resn_exch{" C3* KAG"}=" C3' KAG";
$resn_exch{" O3* KAG"}=" O3' KAG"; $resn_exch{" C2* KAG"}=" C2' KAG"; $resn_exch{" C1* KAG"}=" C1' KAG";
$resn_exch{" OX1 KCX"}=" OQ1 KCX"; $resn_exch{" OX2 KCX"}=" OQ2 KCX"; $resn_exch{" O1  KGC"}=" OXT KGC";
$resn_exch{" OXT KGC"}=" O   KGC"; $resn_exch{" O1* KHO"}=" O1' KHO"; $resn_exch{" C1* KHO"}=" C1' KHO";
$resn_exch{" C2* KHO"}=" C2' KHO"; $resn_exch{" C3* KHO"}=" C3' KHO"; $resn_exch{" O3* KHO"}=" O3' KHO";
$resn_exch{" O2* KHO"}=" O2' KHO"; $resn_exch{" O4* KHO"}=" O4' KHO"; $resn_exch{" C4* KHO"}=" C4' KHO";
$resn_exch{" C5* KHO"}=" C5' KHO"; $resn_exch{" O5* KHO"}=" O5' KHO"; $resn_exch{" O5* KHP"}=" O5' KHP";
$resn_exch{" C5* KHP"}=" C5B KHP"; $resn_exch{" C4* KHP"}=" C4B KHP"; $resn_exch{" O4* KHP"}=" O4' KHP";
$resn_exch{" C1* KHP"}=" C1B KHP"; $resn_exch{" C2* KHP"}=" C2B KHP"; $resn_exch{" O2* KHP"}=" O2B KHP";
$resn_exch{" C3* KHP"}=" C3B KHP"; $resn_exch{" O3* KHP"}=" O3B KHP"; $resn_exch{" O1* KHP"}=" O1' KHP";
$resn_exch{"2N   KT3"}=" N2A KT3"; $resn_exch{"1CD  KT3"}=" CD1 KT3"; $resn_exch{"1OE1 KT3"}=" OEB KT3";
$resn_exch{"1CG  KT3"}=" CG1 KT3"; $resn_exch{"1CB  KT3"}=" CB1 KT3"; $resn_exch{"1CA  KT3"}=" CA1 KT3";
$resn_exch{"1C   KT3"}=" C1A KT3"; $resn_exch{"1OXT KT3"}=" O11 KT3"; $resn_exch{"1O   KT3"}=" O1A KT3";
$resn_exch{"1N   KT3"}=" N1A KT3"; $resn_exch{"3OE2 KT3"}=" OEN KT3"; $resn_exch{"3OE1 KT3"}=" OED KT3";
$resn_exch{"3CD  KT3"}=" CD3 KT3"; $resn_exch{"3CG  KT3"}=" CG3 KT3"; $resn_exch{"3CB  KT3"}=" CB3 KT3";
$resn_exch{"3CA  KT3"}=" CA3 KT3"; $resn_exch{"3C   KT3"}=" C3A KT3"; $resn_exch{"3O   KT3"}=" O3  KT3";
$resn_exch{"3OXT KT3"}=" O12 KT3"; $resn_exch{"3N   KT3"}=" N3A KT3"; $resn_exch{"2OE1 KT3"}=" OEC KT3";
$resn_exch{"2CD  KT3"}=" CD2 KT3"; $resn_exch{"2CG  KT3"}=" CG2 KT3"; $resn_exch{"2CB  KT3"}=" CB2 KT3";
$resn_exch{"2CA  KT3"}=" CA2 KT3"; $resn_exch{"2C   KT3"}=" C2A KT3"; $resn_exch{"2O   KT3"}=" O2  KT3";
$resn_exch{"2OXT KT3"}=" O13 KT3"; $resn_exch{"2N   KT5"}=" N2A KT5"; $resn_exch{"1CD  KT5"}=" CD1 KT5";
$resn_exch{"1OE1 KT5"}=" OEB KT5"; $resn_exch{"1CG  KT5"}=" CG1 KT5"; $resn_exch{"1CB  KT5"}=" CB1 KT5";
$resn_exch{"1CA  KT5"}=" CA1 KT5"; $resn_exch{"1C   KT5"}=" C1A KT5"; $resn_exch{"1OXT KT5"}=" O11 KT5";
$resn_exch{"1O   KT5"}=" O1A KT5"; $resn_exch{"1N   KT5"}=" N1A KT5"; $resn_exch{"5OE1 KT5"}=" OEF KT5";
$resn_exch{"5OE2 KT5"}=" OEP KT5"; $resn_exch{"5CD  KT5"}=" CD5 KT5"; $resn_exch{"5CG  KT5"}=" CG5 KT5";
$resn_exch{"5CB  KT5"}=" CB5 KT5"; $resn_exch{"5CA  KT5"}=" CA5 KT5"; $resn_exch{"5C   KT5"}=" C5A KT5";
$resn_exch{"5O   KT5"}=" O5  KT5"; $resn_exch{"5OXT KT5"}=" O12 KT5"; $resn_exch{"5N   KT5"}=" N5  KT5";
$resn_exch{"4OE1 KT5"}=" OEE KT5"; $resn_exch{"4CD  KT5"}=" CD4 KT5"; $resn_exch{"4CG  KT5"}=" CG4 KT5";
$resn_exch{"4CB  KT5"}=" CB4 KT5"; $resn_exch{"4CA  KT5"}=" CA4 KT5"; $resn_exch{"4C   KT5"}=" C4A KT5";
$resn_exch{"4O   KT5"}=" O4  KT5"; $resn_exch{"4OXT KT5"}=" O13 KT5"; $resn_exch{"4N   KT5"}=" N4  KT5";
$resn_exch{"3OE1 KT5"}=" OED KT5"; $resn_exch{"3CD  KT5"}=" CD3 KT5"; $resn_exch{"3CG  KT5"}=" CG3 KT5";
$resn_exch{"3CB  KT5"}=" CB3 KT5"; $resn_exch{"3CA  KT5"}=" CA3 KT5"; $resn_exch{"3C   KT5"}=" C3A KT5";
$resn_exch{"3O   KT5"}=" O3  KT5"; $resn_exch{"3OXT KT5"}=" O14 KT5"; $resn_exch{"3N   KT5"}=" N3A KT5";
$resn_exch{"2OE1 KT5"}=" OEC KT5"; $resn_exch{"2CD  KT5"}=" CD2 KT5"; $resn_exch{"2CG  KT5"}=" CG2 KT5";
$resn_exch{"2CB  KT5"}=" CB2 KT5"; $resn_exch{"2CA  KT5"}=" CA2 KT5"; $resn_exch{"2C   KT5"}=" C2A KT5";
$resn_exch{"2O   KT5"}=" O2  KT5"; $resn_exch{"2OXT KT5"}=" O15 KT5"; $resn_exch{"1O4' LAM"}=" O'5 LAM";
$resn_exch{"2O4' LAM"}=" O'6 LAM"; $resn_exch{" O5* LAQ"}=" O5' LAQ"; $resn_exch{" C5* LAQ"}=" C5' LAQ";
$resn_exch{" C4* LAQ"}=" C4' LAQ"; $resn_exch{" C3* LAQ"}=" C3' LAQ"; $resn_exch{" O3* LAQ"}=" O3' LAQ";
$resn_exch{" C2* LAQ"}=" C2' LAQ"; $resn_exch{" O2* LAQ"}=" O2' LAQ"; $resn_exch{" C1* LAQ"}=" C1' LAQ";
$resn_exch{" O4* LAQ"}=" O4' LAQ"; $resn_exch{" O3P  LC"}=" OP3  LC"; $resn_exch{" O1P  LC"}=" OP1  LC";
$resn_exch{" O2P  LC"}=" OP2  LC"; $resn_exch{" O5*  LC"}=" O5'  LC"; $resn_exch{" C5*  LC"}=" C5'  LC";
$resn_exch{" C4*  LC"}=" C4'  LC"; $resn_exch{" O4*  LC"}=" O4'  LC"; $resn_exch{" C3*  LC"}=" C3'  LC";
$resn_exch{" O3*  LC"}=" O3'  LC"; $resn_exch{" C2*  LC"}=" C2'  LC"; $resn_exch{" O2*  LC"}=" O2'  LC";
$resn_exch{" C1*  LC"}=" C1'  LC"; $resn_exch{" O5* LCA"}=" O5' LCA"; $resn_exch{" C5* LCA"}=" C5' LCA";
$resn_exch{" C3* LCA"}=" C3' LCA"; $resn_exch{" C6* LCA"}=" C6' LCA"; $resn_exch{" C2* LCA"}=" C2' LCA";
$resn_exch{" C4* LCA"}=" C4' LCA"; $resn_exch{" C1* LCA"}=" C1' LCA"; $resn_exch{" O4* LCA"}=" O4' LCA";
$resn_exch{" O3* LCA"}=" O3' LCA"; $resn_exch{" O2* LCA"}=" O2' LCA"; $resn_exch{" O5* LCC"}=" O5' LCC";
$resn_exch{" C5* LCC"}=" C5' LCC"; $resn_exch{" C4* LCC"}=" C4' LCC"; $resn_exch{" O4* LCC"}=" O4' LCC";
$resn_exch{" C1* LCC"}=" C1' LCC"; $resn_exch{" C3* LCC"}=" C3' LCC"; $resn_exch{" C2* LCC"}=" C2' LCC";
$resn_exch{" O2* LCC"}=" O2' LCC"; $resn_exch{" O3* LCC"}=" O3' LCC"; $resn_exch{" C6* LCC"}=" C6' LCC";
$resn_exch{" O1P LCG"}=" OP1 LCG"; $resn_exch{" O5* LCG"}=" O5' LCG"; $resn_exch{" C5* LCG"}=" C5' LCG";
$resn_exch{" C3* LCG"}=" C3' LCG"; $resn_exch{" C6* LCG"}=" C6' LCG"; $resn_exch{" C2* LCG"}=" C2' LCG";
$resn_exch{" C4* LCG"}=" C4' LCG"; $resn_exch{" C1* LCG"}=" C1' LCG"; $resn_exch{" O4* LCG"}=" O4' LCG";
$resn_exch{" O2P LCG"}=" OP2 LCG"; $resn_exch{" O2* LCG"}=" O2' LCG"; $resn_exch{" O3* LCG"}=" O3' LCG";
$resn_exch{" O3P LCG"}=" OP3 LCG"; $resn_exch{" O5* LCH"}=" O5' LCH"; $resn_exch{" C5* LCH"}=" C5' LCH";
$resn_exch{" C4* LCH"}=" C4' LCH"; $resn_exch{" O4* LCH"}=" O4' LCH"; $resn_exch{" C1* LCH"}=" C1' LCH";
$resn_exch{" C3* LCH"}=" C3' LCH"; $resn_exch{" C2* LCH"}=" C2' LCH"; $resn_exch{" O2* LCH"}=" O2' LCH";
$resn_exch{" O3* LCH"}=" O3' LCH"; $resn_exch{" C6* LCH"}=" C6' LCH"; $resn_exch{" C1* LFN"}=" C1' LFN";
$resn_exch{" O3P  LG"}=" OP3  LG"; $resn_exch{" O1P  LG"}=" OP1  LG"; $resn_exch{" O2P  LG"}=" OP2  LG";
$resn_exch{" O5*  LG"}=" O5'  LG"; $resn_exch{" C5*  LG"}=" C5'  LG"; $resn_exch{" C4*  LG"}=" C4'  LG";
$resn_exch{" O4*  LG"}=" O4'  LG"; $resn_exch{" C3*  LG"}=" C3'  LG"; $resn_exch{" O3*  LG"}=" O3'  LG";
$resn_exch{" C2*  LG"}=" C2'  LG"; $resn_exch{" O2*  LG"}=" O2'  LG"; $resn_exch{" C1*  LG"}=" C1'  LG";
$resn_exch{" O1P LGP"}=" OP1 LGP"; $resn_exch{" O2P LGP"}=" OP2 LGP"; $resn_exch{" O3P LGP"}=" OP3 LGP";
$resn_exch{" O5* LGP"}=" O5' LGP"; $resn_exch{" C5* LGP"}=" C5' LGP"; $resn_exch{" C4* LGP"}=" C4' LGP";
$resn_exch{" O4* LGP"}=" O4' LGP"; $resn_exch{" C3* LGP"}=" C3' LGP"; $resn_exch{" O3* LGP"}=" O3' LGP";
$resn_exch{" C1* LGP"}=" C1' LGP"; $resn_exch{" O3P LHU"}=" OP3 LHU"; $resn_exch{" O1P LHU"}=" OP1 LHU";
$resn_exch{" O2P LHU"}=" OP2 LHU"; $resn_exch{" O5* LHU"}=" O5' LHU"; $resn_exch{" C5* LHU"}=" C5' LHU";
$resn_exch{" C4* LHU"}=" C4' LHU"; $resn_exch{" O4* LHU"}=" O4' LHU"; $resn_exch{" C3* LHU"}=" C3' LHU";
$resn_exch{" O3* LHU"}=" O3' LHU"; $resn_exch{" C2* LHU"}=" C2' LHU"; $resn_exch{" O2* LHU"}=" O2' LHU";
$resn_exch{" C1* LHU"}=" C1' LHU"; $resn_exch{"C4A' LIH"}=" C4X LIH"; $resn_exch{"C8A' LIH"}=" C8X LIH";
$resn_exch{"C2A' LII"}=" C2X LII"; $resn_exch{"C5A' LII"}=" C5X LII"; $resn_exch{" C1* LKC"}=" C1' LKC";
$resn_exch{" C2* LKC"}=" C2' LKC"; $resn_exch{" C3* LKC"}=" C3' LKC"; $resn_exch{" C4* LKC"}=" C4' LKC";
$resn_exch{" O4* LKC"}=" O4' LKC"; $resn_exch{" O3* LKC"}=" O3' LKC"; $resn_exch{" C5* LKC"}=" C5' LKC";
$resn_exch{" O5* LKC"}=" O5' LKC"; $resn_exch{" O2* LKC"}=" O2' LKC"; $resn_exch{" C6* LKC"}=" C6' LKC";
$resn_exch{" C2A LLP"}=" C2' LLP"; $resn_exch{" C4A LLP"}=" C4' LLP"; $resn_exch{" C5A LLP"}=" C5' LLP";
$resn_exch{" O4P LLP"}=" OP4 LLP"; $resn_exch{" O1P LLP"}=" OP1 LLP"; $resn_exch{" O2P LLP"}=" OP2 LLP";
$resn_exch{" O3P LLP"}=" OP3 LLP"; $resn_exch{" O5* LMS"}=" O5' LMS"; $resn_exch{" C5* LMS"}=" C5' LMS";
$resn_exch{" C4* LMS"}=" C4' LMS"; $resn_exch{" O4* LMS"}=" O4' LMS"; $resn_exch{" C3* LMS"}=" C3' LMS";
$resn_exch{" C1* LMT"}=" C1B LMT"; $resn_exch{" C2* LMT"}=" C2B LMT"; $resn_exch{" C3* LMT"}=" C3B LMT";
$resn_exch{" C4* LMT"}=" C4B LMT"; $resn_exch{" C5* LMT"}=" C5B LMT"; $resn_exch{" C6* LMT"}=" C6B LMT";
$resn_exch{" O1* LMT"}=" O1B LMT"; $resn_exch{" O2* LMT"}=" O2B LMT"; $resn_exch{" O3* LMT"}=" O3B LMT";
$resn_exch{" O4* LMT"}=" O4' LMT"; $resn_exch{" O5* LMT"}=" O5B LMT"; $resn_exch{" O6* LMT"}=" O6B LMT";
$resn_exch{" C1* LMU"}=" C1B LMU"; $resn_exch{" C2* LMU"}=" C2B LMU"; $resn_exch{" C3* LMU"}=" C3B LMU";
$resn_exch{" C4* LMU"}=" C4B LMU"; $resn_exch{" C5* LMU"}=" C5B LMU"; $resn_exch{" C6* LMU"}=" C6B LMU";
$resn_exch{" O1* LMU"}=" O1B LMU"; $resn_exch{" O2* LMU"}=" O2B LMU"; $resn_exch{" O3* LMU"}=" O3B LMU";
$resn_exch{" O4* LMU"}=" O4' LMU"; $resn_exch{" O5* LMU"}=" O5B LMU"; $resn_exch{" O6* LMU"}=" O6B LMU";
$resn_exch{" NN7 LNC"}=" N7N LNC"; $resn_exch{" NC7 LNC"}=" C7N LNC"; $resn_exch{" NO7 LNC"}=" O7N LNC";
$resn_exch{" NC3 LNC"}=" C3N LNC"; $resn_exch{" NC4 LNC"}=" C4N LNC"; $resn_exch{" NC5 LNC"}=" C5N LNC";
$resn_exch{" C_S LNC"}=" CS  LNC"; $resn_exch{" NC6 LNC"}=" C6N LNC"; $resn_exch{" NN1 LNC"}=" N1N LNC";
$resn_exch{" NC2 LNC"}=" C2N LNC"; $resn_exch{"NC1* LNC"}=" C1D LNC"; $resn_exch{"NO4* LNC"}=" O4D LNC";
$resn_exch{"NC4* LNC"}=" C4D LNC"; $resn_exch{"NC5* LNC"}=" C5D LNC"; $resn_exch{"NO5* LNC"}=" O5D LNC";
$resn_exch{" NP  LNC"}=" PN  LNC"; $resn_exch{" NO1 LNC"}=" O1N LNC"; $resn_exch{" NO2 LNC"}=" O2N LNC";
$resn_exch{" AP  LNC"}=" PA  LNC"; $resn_exch{" AO1 LNC"}=" O1A LNC"; $resn_exch{" AO2 LNC"}=" O2A LNC";
$resn_exch{"AO5* LNC"}=" O5B LNC"; $resn_exch{"AC5* LNC"}=" C5B LNC"; $resn_exch{"AC4* LNC"}=" C4B LNC";
$resn_exch{"AO4* LNC"}=" O4B LNC"; $resn_exch{"AC1* LNC"}=" C1B LNC"; $resn_exch{"AC2* LNC"}=" C2B LNC";
$resn_exch{"AO2* LNC"}=" O2B LNC"; $resn_exch{"AC3* LNC"}=" C3B LNC"; $resn_exch{"AO3* LNC"}=" O3B LNC";
$resn_exch{" AN9 LNC"}=" N9A LNC"; $resn_exch{" AC8 LNC"}=" C8A LNC"; $resn_exch{" AN7 LNC"}=" N7A LNC";
$resn_exch{" AC5 LNC"}=" C5A LNC"; $resn_exch{" AC6 LNC"}=" C6A LNC"; $resn_exch{" AN6 LNC"}=" N6A LNC";
$resn_exch{" AN1 LNC"}=" N1A LNC"; $resn_exch{" AC2 LNC"}=" C2A LNC"; $resn_exch{" AN3 LNC"}=" N3A LNC";
$resn_exch{" AC4 LNC"}=" C4A LNC"; $resn_exch{"NC3* LNC"}=" C3D LNC"; $resn_exch{"NO3* LNC"}=" O3D LNC";
$resn_exch{"NC2* LNC"}=" C2D LNC"; $resn_exch{"NO2* LNC"}=" O2D LNC"; $resn_exch{" C1* LVS"}=" C1' LVS";
$resn_exch{" O1* LVS"}=" O1' LVS"; $resn_exch{" O2* LVS"}=" O2' LVS"; $resn_exch{" C2* LVS"}=" C2' LVS";
$resn_exch{" O1P M1G"}=" OP1 M1G"; $resn_exch{" O2P M1G"}=" OP2 M1G"; $resn_exch{" O3P M1G"}=" OP3 M1G";
$resn_exch{" O5* M1G"}=" O5' M1G"; $resn_exch{" C5* M1G"}=" C5' M1G"; $resn_exch{" C4* M1G"}=" C4' M1G";
$resn_exch{" O4* M1G"}=" O4' M1G"; $resn_exch{" C3* M1G"}=" C3' M1G"; $resn_exch{" O3* M1G"}=" O3' M1G";
$resn_exch{" C2* M1G"}=" C2' M1G"; $resn_exch{" C1* M1G"}=" C1' M1G"; $resn_exch{" O1P M2G"}=" OP1 M2G";
$resn_exch{" O2P M2G"}=" OP2 M2G"; $resn_exch{" O3P M2G"}=" OP3 M2G"; $resn_exch{" O5* M2G"}=" O5' M2G";
$resn_exch{" C5* M2G"}=" C5' M2G"; $resn_exch{" C4* M2G"}=" C4' M2G"; $resn_exch{" O4* M2G"}=" O4' M2G";
$resn_exch{" C3* M2G"}=" C3' M2G"; $resn_exch{" O3* M2G"}=" O3' M2G"; $resn_exch{" C2* M2G"}=" C2' M2G";
$resn_exch{" O2* M2G"}=" O2' M2G"; $resn_exch{" C1* M2G"}=" C1' M2G"; $resn_exch{" N2* M5M"}=" N2' M5M";
$resn_exch{" C6* M5M"}=" C6' M5M"; $resn_exch{" C7* M5M"}=" C7' M5M"; $resn_exch{" O8* M5M"}=" O8' M5M";
$resn_exch{" O1P M5M"}=" OP1 M5M"; $resn_exch{" O2P M5M"}=" OP2 M5M"; $resn_exch{" O5* M5M"}=" O5' M5M";
$resn_exch{" C5* M5M"}=" C5' M5M"; $resn_exch{" C4* M5M"}=" C4' M5M"; $resn_exch{" O4* M5M"}=" O4' M5M";
$resn_exch{" C1* M5M"}=" C1' M5M"; $resn_exch{" C2* M5M"}=" C2' M5M"; $resn_exch{" C3* M5M"}=" C3' M5M";
$resn_exch{" O3* M5M"}=" O3' M5M"; $resn_exch{" O3P M5M"}=" OP3 M5M"; $resn_exch{" O5* M7G"}=" O5' M7G";
$resn_exch{" C5* M7G"}=" C5' M7G"; $resn_exch{" C4* M7G"}=" C4' M7G"; $resn_exch{" O4* M7G"}=" O4' M7G";
$resn_exch{" C3* M7G"}=" C3' M7G"; $resn_exch{" O3* M7G"}=" O3' M7G"; $resn_exch{" C2* M7G"}=" C2' M7G";
$resn_exch{" O2* M7G"}=" O2' M7G"; $resn_exch{" C1* M7G"}=" C1' M7G"; $resn_exch{" O1P MA6"}=" OP1 MA6";
$resn_exch{" O2P MA6"}=" OP2 MA6"; $resn_exch{" O3P MA6"}=" OP3 MA6"; $resn_exch{" O5* MA6"}=" O5' MA6";
$resn_exch{" C5* MA6"}=" C5' MA6"; $resn_exch{" C4* MA6"}=" C4' MA6"; $resn_exch{" O4* MA6"}=" O4' MA6";
$resn_exch{" C1* MA6"}=" C1' MA6"; $resn_exch{" C2* MA6"}=" C2' MA6"; $resn_exch{" O2* MA6"}=" O2' MA6";
$resn_exch{" C3* MA6"}=" C3' MA6"; $resn_exch{" O3* MA6"}=" O3' MA6"; $resn_exch{" O1P MA7"}=" OP1 MA7";
$resn_exch{" O2P MA7"}=" OP2 MA7"; $resn_exch{" O5* MA7"}=" O5' MA7"; $resn_exch{" C2* MA7"}=" C2' MA7";
$resn_exch{" C5* MA7"}=" C5' MA7"; $resn_exch{" C4* MA7"}=" C4' MA7"; $resn_exch{" O4* MA7"}=" O4' MA7";
$resn_exch{" C1* MA7"}=" C1' MA7"; $resn_exch{" C3* MA7"}=" C3' MA7"; $resn_exch{" O3* MA7"}=" O3' MA7";
$resn_exch{" O3P MA7"}=" OP3 MA7"; $resn_exch{" O1P MAD"}=" OP1 MAD"; $resn_exch{" O2P MAD"}=" OP2 MAD";
$resn_exch{" O5* MAD"}=" O5' MAD"; $resn_exch{" C5* MAD"}=" C5' MAD"; $resn_exch{" C4* MAD"}=" C4' MAD";
$resn_exch{" O4* MAD"}=" O4' MAD"; $resn_exch{" C3* MAD"}=" C3' MAD"; $resn_exch{" O3* MAD"}=" O3' MAD";
$resn_exch{" C2* MAD"}=" C2' MAD"; $resn_exch{" O2* MAD"}=" O2' MAD"; $resn_exch{" C1* MAD"}=" C1' MAD";
$resn_exch{" C5* MAO"}=" C5' MAO"; $resn_exch{" C4* MAO"}=" C4' MAO"; $resn_exch{" O4* MAO"}=" O4' MAO";
$resn_exch{" C1* MAO"}=" C1' MAO"; $resn_exch{" C2* MAO"}=" C2' MAO"; $resn_exch{" O2* MAO"}=" O2' MAO";
$resn_exch{" C3* MAO"}=" C3' MAO"; $resn_exch{" O3* MAO"}=" O3' MAO"; $resn_exch{" O5* MAP"}=" O5' MAP";
$resn_exch{" C5* MAP"}=" C5' MAP"; $resn_exch{" C4* MAP"}=" C4' MAP"; $resn_exch{" O4* MAP"}=" O4' MAP";
$resn_exch{" C3* MAP"}=" C3' MAP"; $resn_exch{" O3* MAP"}=" O3' MAP"; $resn_exch{" C2* MAP"}=" C2' MAP";
$resn_exch{" O2* MAP"}=" O2' MAP"; $resn_exch{" C1* MAP"}=" C1' MAP"; $resn_exch{" C1* MAR"}=" C1' MAR";
$resn_exch{" C2* MAR"}=" C2' MAR"; $resn_exch{" C3* MAR"}=" C3' MAR"; $resn_exch{" N3* MAR"}=" N3' MAR";
$resn_exch{" C4* MAR"}=" C4' MAR"; $resn_exch{" O4* MAR"}=" O4' MAR"; $resn_exch{" C5* MAR"}=" C5' MAR";
$resn_exch{" O5* MAR"}=" O5' MAR"; $resn_exch{" C6* MAR"}=" C6' MAR"; $resn_exch{" C4* MBP"}=" C4' MBP";
$resn_exch{" O4* MBP"}=" O4' MBP"; $resn_exch{" C3* MBP"}=" C3' MBP"; $resn_exch{" C2* MBP"}=" C2' MBP";
$resn_exch{" O   MBQ"}=" OXT MBQ"; $resn_exch{" O1  MBQ"}=" O   MBQ"; $resn_exch{" O1P MBZ"}=" OP1 MBZ";
$resn_exch{" O2P MBZ"}=" OP2 MBZ"; $resn_exch{" O3P MBZ"}=" OP3 MBZ"; $resn_exch{" O5* MBZ"}=" O5' MBZ";
$resn_exch{" O3* MBZ"}=" O3' MBZ"; $resn_exch{" C1* MBZ"}=" C1' MBZ"; $resn_exch{" C2* MBZ"}=" C2' MBZ";
$resn_exch{" C3* MBZ"}=" C3' MBZ"; $resn_exch{" C4* MBZ"}=" C4' MBZ"; $resn_exch{" C5* MBZ"}=" C5' MBZ";
$resn_exch{" O4* MBZ"}=" O4' MBZ"; $resn_exch{" O1  MC1"}=" OXT MC1"; $resn_exch{" OT  MCG"}=" OXT MCG";
$resn_exch{" C1* MCN"}=" C1' MCN"; $resn_exch{" C2* MCN"}=" C2D MCN"; $resn_exch{" O2* MCN"}=" O2' MCN";
$resn_exch{" C3* MCN"}=" C3' MCN"; $resn_exch{" C4* MCN"}=" C4D MCN"; $resn_exch{" O4* MCN"}=" O4D MCN";
$resn_exch{" O3* MCN"}=" O3' MCN"; $resn_exch{" C5* MCN"}=" C5' MCN"; $resn_exch{" O5* MCN"}=" O5' MCN";
$resn_exch{" C1* MCY"}=" C1' MCY"; $resn_exch{" C2* MCY"}=" C2' MCY"; $resn_exch{" C3* MCY"}=" C3' MCY";
$resn_exch{" C4* MCY"}=" C4' MCY"; $resn_exch{" O4* MCY"}=" O4' MCY"; $resn_exch{" O3* MCY"}=" O3' MCY";
$resn_exch{" C5* MCY"}=" C5' MCY"; $resn_exch{" O5* MCY"}=" O5' MCY"; $resn_exch{" O5* MD1"}=" O5' MD1";
$resn_exch{" C5* MD1"}=" C5' MD1"; $resn_exch{" C4* MD1"}=" C4' MD1"; $resn_exch{" O4* MD1"}=" O4' MD1";
$resn_exch{" C1* MD1"}=" C1' MD1"; $resn_exch{" C2* MD1"}=" C2' MD1"; $resn_exch{" O2* MD1"}=" O2' MD1";
$resn_exch{" C3* MD1"}=" C3' MD1"; $resn_exch{" O3* MD1"}=" O3' MD1"; $resn_exch{" AP1 MDE"}=" P1A MDE";
$resn_exch{" AO1 MDE"}=" O1A MDE"; $resn_exch{" AO2 MDE"}=" O2A MDE"; $resn_exch{"AO5* MDE"}=" O5B MDE";
$resn_exch{"AC5* MDE"}=" C5B MDE"; $resn_exch{"AC4* MDE"}=" C4B MDE"; $resn_exch{"AO4* MDE"}=" O4B MDE";
$resn_exch{"AC1* MDE"}=" C1B MDE"; $resn_exch{" AN9 MDE"}=" N9A MDE"; $resn_exch{" AC4 MDE"}=" C4A MDE";
$resn_exch{" AN3 MDE"}=" N3A MDE"; $resn_exch{" AC2 MDE"}=" C2A MDE"; $resn_exch{" AN1 MDE"}=" N1A MDE";
$resn_exch{" AC6 MDE"}=" C6A MDE"; $resn_exch{" AN6 MDE"}=" N6A MDE"; $resn_exch{" AC5 MDE"}=" C5A MDE";
$resn_exch{" AN7 MDE"}=" N7A MDE"; $resn_exch{" AC8 MDE"}=" C8A MDE"; $resn_exch{"AC2* MDE"}=" C2B MDE";
$resn_exch{"AO2* MDE"}=" O2B MDE"; $resn_exch{"AC3* MDE"}=" C3B MDE"; $resn_exch{"AO3* MDE"}=" O3B MDE";
$resn_exch{"AP3* MDE"}=" P3B MDE"; $resn_exch{"AO7* MDE"}=" O7B MDE"; $resn_exch{"AO8* MDE"}=" O8B MDE";
$resn_exch{"AO9* MDE"}=" O9B MDE"; $resn_exch{" AO3 MDE"}=" O3A MDE"; $resn_exch{" AP2 MDE"}=" P2A MDE";
$resn_exch{" AO4 MDE"}=" O4A MDE"; $resn_exch{" AO5 MDE"}=" O5A MDE"; $resn_exch{" AO6 MDE"}=" O6A MDE";
$resn_exch{"PC12 MDE"}=" CCP MDE"; $resn_exch{"PC11 MDE"}=" CBP MDE"; $resn_exch{"PC13 MDE"}=" CDP MDE";
$resn_exch{"PC14 MDE"}=" CEP MDE"; $resn_exch{"PC10 MDE"}=" CAP MDE"; $resn_exch{"PO10 MDE"}=" OAP MDE";
$resn_exch{" PC9 MDE"}=" C9P MDE"; $resn_exch{" PO9 MDE"}=" O9P MDE"; $resn_exch{" PN8 MDE"}=" N8P MDE";
$resn_exch{" PC7 MDE"}=" C7P MDE"; $resn_exch{" PC6 MDE"}=" C6P MDE"; $resn_exch{" PC5 MDE"}=" C5P MDE";
$resn_exch{" PO5 MDE"}=" O5P MDE"; $resn_exch{" PN4 MDE"}=" N4P MDE"; $resn_exch{" PC3 MDE"}=" C3P MDE";
$resn_exch{" PC2 MDE"}=" C2P MDE"; $resn_exch{" PS1 MDE"}=" S1P MDE"; $resn_exch{" C1* MDE"}=" C1' MDE";
$resn_exch{" O1* MDE"}=" O1' MDE"; $resn_exch{" C2* MDE"}=" C2' MDE"; $resn_exch{" C3* MDE"}=" C3' MDE";
$resn_exch{" C4* MDE"}=" C4' MDE"; $resn_exch{" C5* MDE"}=" C5' MDE"; $resn_exch{" C6* MDE"}=" C6' MDE";
$resn_exch{" C7* MDE"}=" C7' MDE"; $resn_exch{" C8* MDE"}=" C8' MDE"; $resn_exch{" C9* MDE"}=" C9' MDE";
$resn_exch{" O5* MDG"}=" O5' MDG"; $resn_exch{" C5* MDG"}=" C5' MDG"; $resn_exch{" C4* MDG"}=" C4' MDG";
$resn_exch{" O4* MDG"}=" O4' MDG"; $resn_exch{" C3* MDG"}=" C3' MDG"; $resn_exch{" O3* MDG"}=" O3' MDG";
$resn_exch{" C2* MDG"}=" C2' MDG"; $resn_exch{" O2* MDG"}=" O2' MDG"; $resn_exch{" C1* MDG"}=" C1' MDG";
$resn_exch{" O1P MEP"}=" OP1 MEP"; $resn_exch{" O2P MEP"}=" OP2 MEP"; $resn_exch{" O3P MEP"}=" OP3 MEP";
$resn_exch{" O5* MEP"}=" O5' MEP"; $resn_exch{" C5* MEP"}=" C5' MEP"; $resn_exch{" C4* MEP"}=" C4' MEP";
$resn_exch{" O4* MEP"}=" O4' MEP"; $resn_exch{" C3* MEP"}=" C3' MEP"; $resn_exch{" C2* MEP"}=" C2' MEP";
$resn_exch{" O2* MEP"}=" O2' MEP"; $resn_exch{" C1* MEP"}=" C1' MEP"; $resn_exch{" CA* MEP"}=" CA' MEP";
$resn_exch{" O3P MG1"}=" OP3 MG1"; $resn_exch{" O1P MG1"}=" OP1 MG1"; $resn_exch{" O2P MG1"}=" OP2 MG1";
$resn_exch{" O5* MG1"}=" O5' MG1"; $resn_exch{" C5* MG1"}=" C5' MG1"; $resn_exch{" C4* MG1"}=" C4' MG1";
$resn_exch{" O4* MG1"}=" O4' MG1"; $resn_exch{" C3* MG1"}=" C3' MG1"; $resn_exch{" O3* MG1"}=" O3' MG1";
$resn_exch{" C2* MG1"}=" C2' MG1"; $resn_exch{" C1* MG1"}=" C1' MG1"; $resn_exch{"C10A MGE"}=" CAA MGE";
$resn_exch{"C11A MGE"}=" CBA MGE"; $resn_exch{"C12A MGE"}=" CCA MGE"; $resn_exch{"C13A MGE"}=" CDA MGE";
$resn_exch{"C10B MGE"}=" CAB MGE"; $resn_exch{"C11B MGE"}=" CBB MGE"; $resn_exch{"C12B MGE"}=" CCB MGE";
$resn_exch{"C13B MGE"}=" CDB MGE"; $resn_exch{"C14B MGE"}=" CEB MGE"; $resn_exch{"C15B MGE"}=" CFB MGE";
$resn_exch{"C16B MGE"}=" CGB MGE"; $resn_exch{" O5* MGO"}=" O5' MGO"; $resn_exch{" C5* MGO"}=" C5' MGO";
$resn_exch{" C4* MGO"}=" C4' MGO"; $resn_exch{" O4* MGO"}=" O4' MGO"; $resn_exch{" C3* MGO"}=" C3' MGO";
$resn_exch{" O3* MGO"}=" O3' MGO"; $resn_exch{" C2* MGO"}=" C2' MGO"; $resn_exch{" O2* MGO"}=" O2' MGO";
$resn_exch{" C1* MGO"}=" C1' MGO"; $resn_exch{" O5* MGT"}=" O5' MGT"; $resn_exch{" C5* MGT"}=" C5' MGT";
$resn_exch{" C4* MGT"}=" C4' MGT"; $resn_exch{" O4* MGT"}=" O4' MGT"; $resn_exch{" C3* MGT"}=" C3' MGT";
$resn_exch{" O3* MGT"}=" O3' MGT"; $resn_exch{" C2* MGT"}=" C2' MGT"; $resn_exch{" O2* MGT"}=" O2' MGT";
$resn_exch{" C1* MGT"}=" C1' MGT"; $resn_exch{" N_A MHM"}=" NA  MHM"; $resn_exch{" N_B MHM"}=" NB  MHM";
$resn_exch{" N_C MHM"}=" NC  MHM"; $resn_exch{" N_D MHM"}=" ND  MHM"; $resn_exch{" C5* MHZ"}=" C5' MHZ";
$resn_exch{" C4* MHZ"}=" C4' MHZ"; $resn_exch{" O4* MHZ"}=" O4' MHZ"; $resn_exch{" C1* MHZ"}=" C1' MHZ";
$resn_exch{" C2* MHZ"}=" C2' MHZ"; $resn_exch{" O2* MHZ"}=" O2' MHZ"; $resn_exch{" C3* MHZ"}=" C3' MHZ";
$resn_exch{" O3* MHZ"}=" O3' MHZ"; $resn_exch{" O3P MIA"}=" OP3 MIA"; $resn_exch{" O1P MIA"}=" OP1 MIA";
$resn_exch{" O2P MIA"}=" OP2 MIA"; $resn_exch{" O5* MIA"}=" O5' MIA"; $resn_exch{" C5* MIA"}=" C5' MIA";
$resn_exch{" C4* MIA"}=" C4' MIA"; $resn_exch{" O4* MIA"}=" O4' MIA"; $resn_exch{" C3* MIA"}=" C3' MIA";
$resn_exch{" O3* MIA"}=" O3' MIA"; $resn_exch{" C2* MIA"}=" C2' MIA"; $resn_exch{" O2* MIA"}=" O2' MIA";
$resn_exch{" C1* MIA"}=" C1' MIA"; $resn_exch{"CO3* MMT"}=" C3X MMT"; $resn_exch{" O5* MMT"}=" O5' MMT";
$resn_exch{" C5* MMT"}=" C5' MMT"; $resn_exch{" C4* MMT"}=" C4' MMT"; $resn_exch{" O4* MMT"}=" O4' MMT";
$resn_exch{" C1* MMT"}=" C1' MMT"; $resn_exch{" C2* MMT"}=" C2' MMT"; $resn_exch{" C3* MMT"}=" C3' MMT";
$resn_exch{" O3* MMT"}=" O3' MMT"; $resn_exch{" C1* MNG"}=" C1' MNG"; $resn_exch{" C2* MNG"}=" C2' MNG";
$resn_exch{" C3* MNG"}=" C3' MNG"; $resn_exch{" C4* MNG"}=" C4' MNG"; $resn_exch{" C5* MNG"}=" C5' MNG";
$resn_exch{" O1* MNG"}=" O1' MNG"; $resn_exch{" O2* MNG"}=" O2' MNG"; $resn_exch{" O4* MNG"}=" O4' MNG";
$resn_exch{" N_A MNH"}=" NA  MNH"; $resn_exch{" N_B MNH"}=" NB  MNH"; $resn_exch{" N_C MNH"}=" NC  MNH";
$resn_exch{" N_D MNH"}=" ND  MNH"; $resn_exch{" N_A MNR"}=" NA  MNR"; $resn_exch{" N_B MNR"}=" NB  MNR";
$resn_exch{" N_C MNR"}=" NC  MNR"; $resn_exch{" N_D MNR"}=" ND  MNR"; $resn_exch{" O5* MNT"}=" O5' MNT";
$resn_exch{" C5* MNT"}=" C5B MNT"; $resn_exch{" C4* MNT"}=" C4B MNT"; $resn_exch{" O4* MNT"}=" O4' MNT";
$resn_exch{" C3* MNT"}=" C3B MNT"; $resn_exch{" O3* MNT"}=" O3' MNT"; $resn_exch{" C2* MNT"}=" C2B MNT";
$resn_exch{" C1* MNT"}=" C1B MNT"; $resn_exch{" O2P MNU"}=" OP2 MNU"; $resn_exch{" O1P MNU"}=" OP1 MNU";
$resn_exch{" O5* MNU"}=" O5' MNU"; $resn_exch{" C5* MNU"}=" C5' MNU"; $resn_exch{" C4* MNU"}=" C4' MNU";
$resn_exch{" O4* MNU"}=" O4' MNU"; $resn_exch{" C1* MNU"}=" C1' MNU"; $resn_exch{" C2* MNU"}=" C2' MNU";
$resn_exch{" O2* MNU"}=" O2' MNU"; $resn_exch{" C3* MNU"}=" C3' MNU"; $resn_exch{" O3* MNU"}=" O3' MNU";
$resn_exch{" O3P MNU"}=" OP3 MNU"; $resn_exch{"3CH3 MOB"}=" CHX MOB"; $resn_exch{"5CH3 MOB"}=" CHZ MOB";
$resn_exch{" O5* MOD"}=" O5' MOD"; $resn_exch{" C5* MOD"}=" C5' MOD"; $resn_exch{" C4* MOD"}=" C4' MOD";
$resn_exch{" O4* MOD"}=" O4' MOD"; $resn_exch{" C3* MOD"}=" C3' MOD"; $resn_exch{" O3* MOD"}=" O3' MOD";
$resn_exch{" C2* MOD"}=" C2' MOD"; $resn_exch{" O2* MOD"}=" O2' MOD"; $resn_exch{" C1* MOD"}=" C1' MOD";
$resn_exch{" O2* MOE"}=" O2' MOE"; $resn_exch{" CA* MOE"}=" CA' MOE"; $resn_exch{" CB* MOE"}=" CB' MOE";
$resn_exch{" OC* MOE"}=" OC' MOE"; $resn_exch{" CD* MOE"}=" CD' MOE"; $resn_exch{"3CL3 MON"}="CL33 MON";
$resn_exch{"1H1  MPA"}=" H11 MPA"; $resn_exch{"1H1  MPC"}=" H11 MPC"; $resn_exch{"1C12 MPG"}=" CXD MPG";
$resn_exch{"1C11 MPG"}=" CX3 MPG"; $resn_exch{"1CD1 MQQ"}=" CDB MQQ"; $resn_exch{"1CD2 MQQ"}=" CDC MQQ";
$resn_exch{" C1* MRC"}=" C1' MRC"; $resn_exch{" C2* MRC"}=" C2' MRC"; $resn_exch{" C3* MRC"}=" C3' MRC";
$resn_exch{" C4* MRC"}=" C4' MRC"; $resn_exch{" C5* MRC"}=" C5' MRC"; $resn_exch{" C6* MRC"}=" C6' MRC";
$resn_exch{" C7* MRC"}=" C7' MRC"; $resn_exch{" C8* MRC"}=" C8' MRC"; $resn_exch{" C9* MRC"}=" C9' MRC";
$resn_exch{" O1P MRG"}=" OP1 MRG"; $resn_exch{" O2P MRG"}=" OP2 MRG"; $resn_exch{" O5* MRG"}=" O5' MRG";
$resn_exch{" C2* MRG"}=" C2' MRG"; $resn_exch{" C5* MRG"}=" C5' MRG"; $resn_exch{" C4* MRG"}=" C4' MRG";
$resn_exch{" O4* MRG"}=" O4' MRG"; $resn_exch{" C1* MRG"}=" C1' MRG"; $resn_exch{" C3* MRG"}=" C3' MRG";
$resn_exch{" O3* MRG"}=" O3' MRG"; $resn_exch{" O3P MRG"}=" OP3 MRG"; $resn_exch{" AO7 MRR"}=" O7A MRR";
$resn_exch{"AP3* MRR"}=" P3B MRR"; $resn_exch{" AO8 MRR"}=" O8A MRR"; $resn_exch{" AO9 MRR"}=" O9A MRR";
$resn_exch{"AO3* MRR"}=" O3B MRR"; $resn_exch{"AC3* MRR"}=" C3B MRR"; $resn_exch{"AC2* MRR"}=" C2B MRR";
$resn_exch{"AO2* MRR"}=" O2B MRR"; $resn_exch{"AC1* MRR"}=" C1B MRR"; $resn_exch{" AN9 MRR"}=" N9A MRR";
$resn_exch{" AC4 MRR"}=" C4A MRR"; $resn_exch{" AN3 MRR"}=" N3A MRR"; $resn_exch{" AC2 MRR"}=" C2A MRR";
$resn_exch{" AN1 MRR"}=" N1A MRR"; $resn_exch{" AC6 MRR"}=" C6A MRR"; $resn_exch{" AN6 MRR"}=" N6A MRR";
$resn_exch{" AC5 MRR"}=" C5A MRR"; $resn_exch{" AN7 MRR"}=" N7A MRR"; $resn_exch{" AC8 MRR"}=" C8A MRR";
$resn_exch{"AO4* MRR"}=" O4B MRR"; $resn_exch{"AC4* MRR"}=" C4B MRR"; $resn_exch{"AC5* MRR"}=" C5B MRR";
$resn_exch{"AO5* MRR"}=" O5B MRR"; $resn_exch{" AP1 MRR"}=" P1A MRR"; $resn_exch{" AO1 MRR"}=" O1A MRR";
$resn_exch{" AO2 MRR"}=" O2A MRR"; $resn_exch{" AO3 MRR"}=" O3A MRR"; $resn_exch{" AP2 MRR"}=" P2A MRR";
$resn_exch{" AO4 MRR"}=" O4A MRR"; $resn_exch{" AO5 MRR"}=" O5A MRR"; $resn_exch{" AO6 MRR"}=" O6A MRR";
$resn_exch{"PC12 MRR"}=" CCP MRR"; $resn_exch{"PC11 MRR"}=" CBP MRR"; $resn_exch{"PC13 MRR"}=" CDP MRR";
$resn_exch{"PC14 MRR"}=" CEP MRR"; $resn_exch{"PC10 MRR"}=" CAP MRR"; $resn_exch{"PO10 MRR"}=" OAP MRR";
$resn_exch{" PC9 MRR"}=" C9P MRR"; $resn_exch{" PO9 MRR"}=" O9P MRR"; $resn_exch{" PN8 MRR"}=" N8P MRR";
$resn_exch{" PC7 MRR"}=" C7P MRR"; $resn_exch{" PC6 MRR"}=" C6P MRR"; $resn_exch{" PC5 MRR"}=" C5P MRR";
$resn_exch{" PO5 MRR"}=" O5P MRR"; $resn_exch{" PN4 MRR"}=" N4P MRR"; $resn_exch{" PC3 MRR"}=" C3P MRR";
$resn_exch{" PC2 MRR"}=" C2P MRR"; $resn_exch{" PS1 MRR"}=" S1P MRR"; $resn_exch{" AO7 MRS"}=" O7A MRS";
$resn_exch{"AP3* MRS"}=" P3B MRS"; $resn_exch{" AO8 MRS"}=" O8A MRS"; $resn_exch{" AO9 MRS"}=" O9A MRS";
$resn_exch{"AO3* MRS"}=" O3B MRS"; $resn_exch{"AC3* MRS"}=" C3B MRS"; $resn_exch{"AC2* MRS"}=" C2B MRS";
$resn_exch{"AO2* MRS"}=" O2B MRS"; $resn_exch{"AC1* MRS"}=" C1B MRS"; $resn_exch{" AN9 MRS"}=" N9A MRS";
$resn_exch{" AC4 MRS"}=" C4A MRS"; $resn_exch{" AN3 MRS"}=" N3A MRS"; $resn_exch{" AC2 MRS"}=" C2A MRS";
$resn_exch{" AN1 MRS"}=" N1A MRS"; $resn_exch{" AC6 MRS"}=" C6A MRS"; $resn_exch{" AN6 MRS"}=" N6A MRS";
$resn_exch{" AC5 MRS"}=" C5A MRS"; $resn_exch{" AN7 MRS"}=" N7A MRS"; $resn_exch{" AC8 MRS"}=" C8A MRS";
$resn_exch{"AO4* MRS"}=" O4B MRS"; $resn_exch{"AC4* MRS"}=" C4B MRS"; $resn_exch{"AC5* MRS"}=" C5B MRS";
$resn_exch{"AO5* MRS"}=" O5B MRS"; $resn_exch{" AP1 MRS"}=" P1A MRS"; $resn_exch{" AO1 MRS"}=" O1A MRS";
$resn_exch{" AO2 MRS"}=" O2A MRS"; $resn_exch{" AO3 MRS"}=" O3A MRS"; $resn_exch{" AP2 MRS"}=" P2A MRS";
$resn_exch{" AO4 MRS"}=" O4A MRS"; $resn_exch{" AO5 MRS"}=" O5A MRS"; $resn_exch{" AO6 MRS"}=" O6A MRS";
$resn_exch{"PC12 MRS"}=" CCP MRS"; $resn_exch{"PC11 MRS"}=" CBP MRS"; $resn_exch{"PC13 MRS"}=" CDP MRS";
$resn_exch{"PC14 MRS"}=" CEP MRS"; $resn_exch{"PC10 MRS"}=" CAP MRS"; $resn_exch{"PO10 MRS"}=" OAP MRS";
$resn_exch{" PC9 MRS"}=" C9P MRS"; $resn_exch{" PO9 MRS"}=" O9P MRS"; $resn_exch{" PN8 MRS"}=" N8P MRS";
$resn_exch{" PC7 MRS"}=" C7P MRS"; $resn_exch{" PC6 MRS"}=" C6P MRS"; $resn_exch{" PC5 MRS"}=" C5P MRS";
$resn_exch{" PO5 MRS"}=" O5P MRS"; $resn_exch{" PN4 MRS"}=" N4P MRS"; $resn_exch{" PC3 MRS"}=" C3P MRS";
$resn_exch{" PC2 MRS"}=" C2P MRS"; $resn_exch{" PS1 MRS"}=" S1P MRS"; $resn_exch{" O5* MSG"}=" O5' MSG";
$resn_exch{" C5* MSG"}=" C5' MSG"; $resn_exch{" C4* MSG"}=" C4' MSG"; $resn_exch{" O4* MSG"}=" O4' MSG";
$resn_exch{" C1* MSG"}=" C1' MSG"; $resn_exch{" C2* MSG"}=" C2' MSG"; $resn_exch{" O2* MSG"}=" O2' MSG";
$resn_exch{" C3* MSG"}=" C3' MSG"; $resn_exch{" O3* MSG"}=" O3' MSG"; $resn_exch{" O5* MSP"}=" O5' MSP";
$resn_exch{" C5* MSP"}=" C5' MSP"; $resn_exch{" C4* MSP"}=" C4' MSP"; $resn_exch{" O4* MSP"}=" O4' MSP";
$resn_exch{" C3* MSP"}=" C3' MSP"; $resn_exch{" O3* MSP"}=" O3' MSP"; $resn_exch{" C2* MSP"}=" C2' MSP";
$resn_exch{" O2* MSP"}=" O2' MSP"; $resn_exch{" C1* MSP"}=" C1' MSP"; $resn_exch{" S5* MTA"}=" S5' MTA";
$resn_exch{" C5* MTA"}=" C5' MTA"; $resn_exch{" C4* MTA"}=" C4' MTA"; $resn_exch{" O4* MTA"}=" O4' MTA";
$resn_exch{" C2* MTA"}=" C2' MTA"; $resn_exch{" O2* MTA"}=" O2' MTA"; $resn_exch{" C3* MTA"}=" C3' MTA";
$resn_exch{" O3* MTA"}=" O3' MTA"; $resn_exch{" C1* MTA"}=" C1' MTA"; $resn_exch{"1CH3 MTB"}=" CHV MTB";
$resn_exch{"2CH3 MTB"}=" CHW MTB"; $resn_exch{"3CH3 MTB"}=" CHX MTB"; $resn_exch{" S5* MTH"}=" S5' MTH";
$resn_exch{" C5* MTH"}=" C5' MTH"; $resn_exch{" C4* MTH"}=" C4' MTH"; $resn_exch{" O4* MTH"}=" O4' MTH";
$resn_exch{" C2* MTH"}=" C2' MTH"; $resn_exch{" O2* MTH"}=" O2' MTH"; $resn_exch{" C3* MTH"}=" C3' MTH";
$resn_exch{" O3* MTH"}=" O3' MTH"; $resn_exch{" C1* MTH"}=" C1' MTH"; $resn_exch{" S5* MTI"}=" S5' MTI";
$resn_exch{" C5* MTI"}=" C5' MTI"; $resn_exch{" C4* MTI"}=" C4' MTI"; $resn_exch{" N4* MTI"}=" N4' MTI";
$resn_exch{" C2* MTI"}=" C2' MTI"; $resn_exch{" O2* MTI"}=" O2' MTI"; $resn_exch{" C3* MTI"}=" C3' MTI";
$resn_exch{" O3* MTI"}=" O3' MTI"; $resn_exch{" C1* MTI"}=" C1' MTI"; $resn_exch{" S5* MTM"}=" S5' MTM";
$resn_exch{" C5* MTM"}=" C5' MTM"; $resn_exch{" C4* MTM"}=" C4' MTM"; $resn_exch{" N4* MTM"}=" N4' MTM";
$resn_exch{" C2* MTM"}=" C2' MTM"; $resn_exch{" O2* MTM"}=" O2' MTM"; $resn_exch{" C3* MTM"}=" C3' MTM";
$resn_exch{" O3* MTM"}=" O3' MTM"; $resn_exch{" C1* MTM"}=" C1' MTM"; $resn_exch{" O1P MTR"}=" OP1 MTR";
$resn_exch{" O2P MTR"}=" OP2 MTR"; $resn_exch{" O5* MTR"}=" O5' MTR"; $resn_exch{" C2* MTR"}=" C2' MTR";
$resn_exch{" C5* MTR"}=" C5' MTR"; $resn_exch{" C4* MTR"}=" C4' MTR"; $resn_exch{" O4* MTR"}=" O4' MTR";
$resn_exch{" C1* MTR"}=" C1' MTR"; $resn_exch{" C3* MTR"}=" C3' MTR"; $resn_exch{" O3* MTR"}=" O3' MTR";
$resn_exch{" O3P MTR"}=" OP3 MTR"; $resn_exch{" O1P MTU"}=" OP1 MTU"; $resn_exch{" O2P MTU"}=" OP2 MTU";
$resn_exch{" O5* MTU"}=" O5' MTU"; $resn_exch{" C5* MTU"}=" C5' MTU"; $resn_exch{" C4* MTU"}=" C4' MTU";
$resn_exch{" O4* MTU"}=" O4' MTU"; $resn_exch{" C1* MTU"}=" C1' MTU"; $resn_exch{" C2* MTU"}=" C2' MTU";
$resn_exch{" O2* MTU"}=" O2' MTU"; $resn_exch{" C3* MTU"}=" C3' MTU"; $resn_exch{" O3* MTU"}=" O3' MTU";
$resn_exch{" O5* MZP"}=" O5' MZP"; $resn_exch{" C5* MZP"}=" C5' MZP"; $resn_exch{" C4* MZP"}=" C4' MZP";
$resn_exch{" O4* MZP"}=" O4' MZP"; $resn_exch{" C3* MZP"}=" C3' MZP"; $resn_exch{" O3* MZP"}=" O3' MZP";
$resn_exch{" C2* MZP"}=" C2' MZP"; $resn_exch{" O2* MZP"}=" O2' MZP"; $resn_exch{" C1* MZP"}=" C1' MZP";
$resn_exch{" O3P   N"}=" OP3   N"; $resn_exch{" O1P   N"}=" OP1   N"; $resn_exch{" O2P   N"}=" OP2   N";
$resn_exch{" O5*   N"}=" O5'   N"; $resn_exch{" C5*   N"}=" C5'   N"; $resn_exch{" C4*   N"}=" C4'   N";
$resn_exch{" O4*   N"}=" O4'   N"; $resn_exch{" C3*   N"}=" C3'   N"; $resn_exch{" O3*   N"}=" O3'   N";
$resn_exch{" C2*   N"}=" C2'   N"; $resn_exch{" O2*   N"}=" O2'   N"; $resn_exch{" C1*   N"}=" C1'   N";
$resn_exch{" C1* N1C"}=" C1' N1C"; $resn_exch{" O4* N1C"}=" O4' N1C"; $resn_exch{" C2* N1C"}=" C2' N1C";
$resn_exch{" O2* N1C"}=" O2' N1C"; $resn_exch{" C3* N1C"}=" C3' N1C"; $resn_exch{" O3* N1C"}=" O3' N1C";
$resn_exch{" C4* N1C"}=" C4' N1C"; $resn_exch{" C5* N1C"}=" C5' N1C"; $resn_exch{" O5* N1C"}=" O5' N1C";
$resn_exch{"C31' N1H"}=" CV' N1H"; $resn_exch{"C32' N1H"}=" CW' N1H"; $resn_exch{"O33' N1H"}=" OX' N1H";
$resn_exch{"O34' N1H"}=" OY' N1H"; $resn_exch{"C1'' N1H"}=" C1B N1H"; $resn_exch{"C2'' N1H"}=" C2B N1H";
$resn_exch{"C3'' N1H"}=" C3B N1H"; $resn_exch{"C4'' N1H"}=" C4B N1H"; $resn_exch{"C5'' N1H"}=" C5B N1H";
$resn_exch{"N5'' N1H"}=" N5B N1H"; $resn_exch{"C6'' N1H"}=" C6B N1H"; $resn_exch{" N5* N5A"}=" N5' N5A";
$resn_exch{" C5* N5A"}=" C5' N5A"; $resn_exch{" O5* N5A"}=" O5' N5A"; $resn_exch{" C4* N5A"}=" C4' N5A";
$resn_exch{" O4* N5A"}=" O4' N5A"; $resn_exch{" C3* N5A"}=" C3' N5A"; $resn_exch{" O3* N5A"}=" O3' N5A";
$resn_exch{" C2* N5A"}=" C2' N5A"; $resn_exch{" O2* N5A"}=" O2' N5A"; $resn_exch{" C1* N5A"}=" C1' N5A";
$resn_exch{" C1* N5I"}=" C1' N5I"; $resn_exch{" O4* N5I"}=" O4' N5I"; $resn_exch{" C4* N5I"}=" C4' N5I";
$resn_exch{" C3* N5I"}=" C3' N5I"; $resn_exch{" O3* N5I"}=" O3' N5I"; $resn_exch{" C2* N5I"}=" C2' N5I";
$resn_exch{" C5* N5I"}=" C5' N5I"; $resn_exch{" O5* N5I"}=" O5' N5I"; $resn_exch{" N5* N5O"}=" N5' N5O";
$resn_exch{" C5* N5O"}=" C5' N5O"; $resn_exch{" O5* N5O"}=" O5' N5O"; $resn_exch{" C4* N5O"}=" C4' N5O";
$resn_exch{" O4* N5O"}=" O4' N5O"; $resn_exch{" C3* N5O"}=" C3' N5O"; $resn_exch{" O3* N5O"}=" O3' N5O";
$resn_exch{" C2* N5O"}=" C2' N5O"; $resn_exch{" O2* N5O"}=" O2' N5O"; $resn_exch{" C1* N5O"}=" C1' N5O";
$resn_exch{" C1* N5P"}=" C1' N5P"; $resn_exch{" O4* N5P"}=" O4' N5P"; $resn_exch{" C4* N5P"}=" C4' N5P";
$resn_exch{" C3* N5P"}=" C3' N5P"; $resn_exch{" O3* N5P"}=" O3' N5P"; $resn_exch{" C2* N5P"}=" C2' N5P";
$resn_exch{" C5* N5P"}=" C5' N5P"; $resn_exch{" O5* N5P"}=" O5' N5P"; $resn_exch{" O1P N6G"}=" OP1 N6G";
$resn_exch{" O2P N6G"}=" OP2 N6G"; $resn_exch{" O5* N6G"}=" O5' N6G"; $resn_exch{" C5* N6G"}=" C5' N6G";
$resn_exch{" C4* N6G"}=" C4' N6G"; $resn_exch{" O4* N6G"}=" O4' N6G"; $resn_exch{" C1* N6G"}=" C1' N6G";
$resn_exch{" C2* N6G"}=" C2' N6G"; $resn_exch{" O2* N6G"}=" O2' N6G"; $resn_exch{" C3* N6G"}=" C3' N6G";
$resn_exch{" O3* N6G"}=" O3' N6G"; $resn_exch{" O3P N6G"}=" OP3 N6G"; $resn_exch{" AP  NA7"}=" PA  NA7";
$resn_exch{" AO1 NA7"}=" O1A NA7"; $resn_exch{" AO2 NA7"}=" O2A NA7"; $resn_exch{"AO5* NA7"}=" O5B NA7";
$resn_exch{"AC5* NA7"}=" C5B NA7"; $resn_exch{"AC4* NA7"}=" C4B NA7"; $resn_exch{"AO4* NA7"}=" O4B NA7";
$resn_exch{"AC3* NA7"}=" C3B NA7"; $resn_exch{"AO3* NA7"}=" O3B NA7"; $resn_exch{"AC2* NA7"}=" C2B NA7";
$resn_exch{"AO2* NA7"}=" O2B NA7"; $resn_exch{"AC1* NA7"}=" C1B NA7"; $resn_exch{" AN9 NA7"}=" N9A NA7";
$resn_exch{" AC8 NA7"}=" C8A NA7"; $resn_exch{" AN7 NA7"}=" N7A NA7"; $resn_exch{" AC5 NA7"}=" C5A NA7";
$resn_exch{" AC6 NA7"}=" C6A NA7"; $resn_exch{" AN6 NA7"}=" N6A NA7"; $resn_exch{" AN1 NA7"}=" N1A NA7";
$resn_exch{" AC2 NA7"}=" C2A NA7"; $resn_exch{" AN3 NA7"}=" N3A NA7"; $resn_exch{" AC4 NA7"}=" C4A NA7";
$resn_exch{" NP  NA7"}=" PN  NA7"; $resn_exch{" NO1 NA7"}=" O1N NA7"; $resn_exch{" NO2 NA7"}=" O2N NA7";
$resn_exch{"NO5* NA7"}=" O5D NA7"; $resn_exch{"NC5* NA7"}=" C5D NA7"; $resn_exch{"NC4* NA7"}=" C4D NA7";
$resn_exch{"NO4* NA7"}=" O4D NA7"; $resn_exch{"NC3* NA7"}=" C3D NA7"; $resn_exch{"NO3* NA7"}=" O3D NA7";
$resn_exch{"NC2* NA7"}=" C2D NA7"; $resn_exch{"NO2* NA7"}=" O2D NA7"; $resn_exch{"NC1* NA7"}=" C1D NA7";
$resn_exch{"AP2* NA7"}=" P2B NA7"; $resn_exch{"AOP1 NA7"}=" O1X NA7"; $resn_exch{"AOP2 NA7"}=" O2X NA7";
$resn_exch{"AOP3 NA7"}=" O3X NA7"; $resn_exch{" AP  NAC"}=" PA  NAC"; $resn_exch{" AO1 NAC"}=" O1A NAC";
$resn_exch{" AO2 NAC"}=" O2A NAC"; $resn_exch{"AO5* NAC"}=" O5B NAC"; $resn_exch{"AC5* NAC"}=" C5B NAC";
$resn_exch{"AC4* NAC"}=" C4B NAC"; $resn_exch{"AO4* NAC"}=" O4B NAC"; $resn_exch{"AC3* NAC"}=" C3B NAC";
$resn_exch{"AO3* NAC"}=" O3B NAC"; $resn_exch{"AC2* NAC"}=" C2B NAC"; $resn_exch{"AO2* NAC"}=" O2B NAC";
$resn_exch{"AC1* NAC"}=" C1B NAC"; $resn_exch{" AN9 NAC"}=" N9A NAC"; $resn_exch{" AC8 NAC"}=" C8A NAC";
$resn_exch{" AN7 NAC"}=" N7A NAC"; $resn_exch{" AC5 NAC"}=" C5A NAC"; $resn_exch{" AC6 NAC"}=" C6A NAC";
$resn_exch{" AN6 NAC"}=" N6A NAC"; $resn_exch{" AN1 NAC"}=" N1A NAC"; $resn_exch{" AC2 NAC"}=" C2A NAC";
$resn_exch{" AN3 NAC"}=" N3A NAC"; $resn_exch{" AC4 NAC"}=" C4A NAC"; $resn_exch{" NP  NAC"}=" PN  NAC";
$resn_exch{" NO1 NAC"}=" O1N NAC"; $resn_exch{" NO2 NAC"}=" O2N NAC"; $resn_exch{"NO5* NAC"}=" O5D NAC";
$resn_exch{"NC5* NAC"}=" C5D NAC"; $resn_exch{"NC4* NAC"}=" C4D NAC"; $resn_exch{"NO4* NAC"}=" O4D NAC";
$resn_exch{"NC3* NAC"}=" C3D NAC"; $resn_exch{"NO3* NAC"}=" O3D NAC"; $resn_exch{"NC2* NAC"}=" C2D NAC";
$resn_exch{"NO2* NAC"}=" O2D NAC"; $resn_exch{"NC1* NAC"}=" C1D NAC"; $resn_exch{" NN1 NAC"}=" N1N NAC";
$resn_exch{" NC2 NAC"}=" C2N NAC"; $resn_exch{" NC3 NAC"}=" C3N NAC"; $resn_exch{" NC7 NAC"}=" C7N NAC";
$resn_exch{" NO7 NAC"}=" O7N NAC"; $resn_exch{" NC8 NAC"}=" C8N NAC"; $resn_exch{" NC4 NAC"}=" C4N NAC";
$resn_exch{" NC5 NAC"}=" C5N NAC"; $resn_exch{" NC6 NAC"}=" C6N NAC"; $resn_exch{" AP  NAD"}=" PA  NAD";
$resn_exch{" AO1 NAD"}=" O1A NAD"; $resn_exch{" AO2 NAD"}=" O2A NAD"; $resn_exch{"AO5* NAD"}=" O5B NAD";
$resn_exch{"AC5* NAD"}=" C5B NAD"; $resn_exch{"AC4* NAD"}=" C4B NAD"; $resn_exch{"AO4* NAD"}=" O4B NAD";
$resn_exch{"AC3* NAD"}=" C3B NAD"; $resn_exch{"AO3* NAD"}=" O3B NAD"; $resn_exch{"AC2* NAD"}=" C2B NAD";
$resn_exch{"AO2* NAD"}=" O2B NAD"; $resn_exch{"AC1* NAD"}=" C1B NAD"; $resn_exch{" AN9 NAD"}=" N9A NAD";
$resn_exch{" AC8 NAD"}=" C8A NAD"; $resn_exch{" AN7 NAD"}=" N7A NAD"; $resn_exch{" AC5 NAD"}=" C5A NAD";
$resn_exch{" AC6 NAD"}=" C6A NAD"; $resn_exch{" AN6 NAD"}=" N6A NAD"; $resn_exch{" AN1 NAD"}=" N1A NAD";
$resn_exch{" AC2 NAD"}=" C2A NAD"; $resn_exch{" AN3 NAD"}=" N3A NAD"; $resn_exch{" AC4 NAD"}=" C4A NAD";
$resn_exch{" NP  NAD"}=" PN  NAD"; $resn_exch{" NO1 NAD"}=" O1N NAD"; $resn_exch{" NO2 NAD"}=" O2N NAD";
$resn_exch{"NO5* NAD"}=" O5D NAD"; $resn_exch{"NC5* NAD"}=" C5D NAD"; $resn_exch{"NC4* NAD"}=" C4D NAD";
$resn_exch{"NO4* NAD"}=" O4D NAD"; $resn_exch{"NC3* NAD"}=" C3D NAD"; $resn_exch{"NO3* NAD"}=" O3D NAD";
$resn_exch{"NC2* NAD"}=" C2D NAD"; $resn_exch{"NO2* NAD"}=" O2D NAD"; $resn_exch{"NC1* NAD"}=" C1D NAD";
$resn_exch{" NN1 NAD"}=" N1N NAD"; $resn_exch{" NC2 NAD"}=" C2N NAD"; $resn_exch{" NC3 NAD"}=" C3N NAD";
$resn_exch{" NC7 NAD"}=" C7N NAD"; $resn_exch{" NO7 NAD"}=" O7N NAD"; $resn_exch{" NN7 NAD"}=" N7N NAD";
$resn_exch{" NC4 NAD"}=" C4N NAD"; $resn_exch{" NC5 NAD"}=" C5N NAD"; $resn_exch{" NC6 NAD"}=" C6N NAD";
$resn_exch{" O5* NAE"}=" O5B NAE"; $resn_exch{" C5* NAE"}=" C5B NAE"; $resn_exch{" C4* NAE"}=" C4B NAE";
$resn_exch{" O4* NAE"}=" O4B NAE"; $resn_exch{" C3* NAE"}=" C3B NAE"; $resn_exch{" O3* NAE"}=" O3B NAE";
$resn_exch{" C2* NAE"}=" C2B NAE"; $resn_exch{" O2* NAE"}=" O2B NAE"; $resn_exch{" C1* NAE"}=" C1B NAE";
$resn_exch{" AP  NAH"}=" PA  NAH"; $resn_exch{" AO1 NAH"}=" O1A NAH"; $resn_exch{" AO2 NAH"}=" O2A NAH";
$resn_exch{"AO5* NAH"}=" O5B NAH"; $resn_exch{"AC5* NAH"}=" C5B NAH"; $resn_exch{"AC4* NAH"}=" C4B NAH";
$resn_exch{"AO4* NAH"}=" O4B NAH"; $resn_exch{"AC3* NAH"}=" C3B NAH"; $resn_exch{"AO3* NAH"}=" O3B NAH";
$resn_exch{"AC2* NAH"}=" C2B NAH"; $resn_exch{"AO2* NAH"}=" O2B NAH"; $resn_exch{"AC1* NAH"}=" C1B NAH";
$resn_exch{" AN9 NAH"}=" N9A NAH"; $resn_exch{" AC8 NAH"}=" C8A NAH"; $resn_exch{" AN7 NAH"}=" N7A NAH";
$resn_exch{" AC5 NAH"}=" C5A NAH"; $resn_exch{" AC6 NAH"}=" C6A NAH"; $resn_exch{" AN6 NAH"}=" N6A NAH";
$resn_exch{" AN1 NAH"}=" N1A NAH"; $resn_exch{" AC2 NAH"}=" C2A NAH"; $resn_exch{" AN3 NAH"}=" N3A NAH";
$resn_exch{" AC4 NAH"}=" C4A NAH"; $resn_exch{" NP  NAH"}=" PN  NAH"; $resn_exch{" NO1 NAH"}=" O1N NAH";
$resn_exch{" NO2 NAH"}=" O2N NAH"; $resn_exch{"NO5* NAH"}=" O5D NAH"; $resn_exch{"NC5* NAH"}=" C5D NAH";
$resn_exch{"NC4* NAH"}=" C4D NAH"; $resn_exch{"NO4* NAH"}=" O4D NAH"; $resn_exch{"NC3* NAH"}=" C3D NAH";
$resn_exch{"NO3* NAH"}=" O3D NAH"; $resn_exch{"NC2* NAH"}=" C2D NAH"; $resn_exch{"NO2* NAH"}=" O2D NAH";
$resn_exch{"NC1* NAH"}=" C1D NAH"; $resn_exch{" NN1 NAH"}=" N1N NAH"; $resn_exch{" NC2 NAH"}=" C2N NAH";
$resn_exch{" NC3 NAH"}=" C3N NAH"; $resn_exch{" NC7 NAH"}=" C7N NAH"; $resn_exch{" NO7 NAH"}=" O7N NAH";
$resn_exch{" NN7 NAH"}=" N7N NAH"; $resn_exch{" NC4 NAH"}=" C4N NAH"; $resn_exch{" NC5 NAH"}=" C5N NAH";
$resn_exch{" NC6 NAH"}=" C6N NAH"; $resn_exch{" AP  NAI"}=" PA  NAI"; $resn_exch{" AO1 NAI"}=" O1A NAI";
$resn_exch{" AO2 NAI"}=" O2A NAI"; $resn_exch{"AO5* NAI"}=" O5B NAI"; $resn_exch{"AC5* NAI"}=" C5B NAI";
$resn_exch{"AC4* NAI"}=" C4B NAI"; $resn_exch{"AO4* NAI"}=" O4B NAI"; $resn_exch{"AC3* NAI"}=" C3B NAI";
$resn_exch{"AO3* NAI"}=" O3B NAI"; $resn_exch{"AC2* NAI"}=" C2B NAI"; $resn_exch{"AO2* NAI"}=" O2B NAI";
$resn_exch{"AC1* NAI"}=" C1B NAI"; $resn_exch{" AN9 NAI"}=" N9A NAI"; $resn_exch{" AC8 NAI"}=" C8A NAI";
$resn_exch{" AN7 NAI"}=" N7A NAI"; $resn_exch{" AC5 NAI"}=" C5A NAI"; $resn_exch{" AC6 NAI"}=" C6A NAI";
$resn_exch{" AN6 NAI"}=" N6A NAI"; $resn_exch{" AN1 NAI"}=" N1A NAI"; $resn_exch{" AC2 NAI"}=" C2A NAI";
$resn_exch{" AN3 NAI"}=" N3A NAI"; $resn_exch{" AC4 NAI"}=" C4A NAI"; $resn_exch{" NP  NAI"}=" PN  NAI";
$resn_exch{" NO1 NAI"}=" O1N NAI"; $resn_exch{" NO2 NAI"}=" O2N NAI"; $resn_exch{"NO5* NAI"}=" O5D NAI";
$resn_exch{"NC5* NAI"}=" C5D NAI"; $resn_exch{"NC4* NAI"}=" C4D NAI"; $resn_exch{"NO4* NAI"}=" O4D NAI";
$resn_exch{"NC3* NAI"}=" C3D NAI"; $resn_exch{"NO3* NAI"}=" O3D NAI"; $resn_exch{"NC2* NAI"}=" C2D NAI";
$resn_exch{"NO2* NAI"}=" O2D NAI"; $resn_exch{"NC1* NAI"}=" C1D NAI"; $resn_exch{" NN1 NAI"}=" N1N NAI";
$resn_exch{" NC2 NAI"}=" C2N NAI"; $resn_exch{" NC3 NAI"}=" C3N NAI"; $resn_exch{" NC7 NAI"}=" C7N NAI";
$resn_exch{" NO7 NAI"}=" O7N NAI"; $resn_exch{" NN7 NAI"}=" N7N NAI"; $resn_exch{" NC4 NAI"}=" C4N NAI";
$resn_exch{" NC5 NAI"}=" C5N NAI"; $resn_exch{" NC6 NAI"}=" C6N NAI"; $resn_exch{" AP  NAJ"}=" PA  NAJ";
$resn_exch{" AO1 NAJ"}=" O1A NAJ"; $resn_exch{" AO2 NAJ"}=" O2A NAJ"; $resn_exch{"AO5* NAJ"}=" O5B NAJ";
$resn_exch{"AC5* NAJ"}=" C5B NAJ"; $resn_exch{"AC4* NAJ"}=" C4B NAJ"; $resn_exch{"AO4* NAJ"}=" O4B NAJ";
$resn_exch{"AC3* NAJ"}=" C3B NAJ"; $resn_exch{"AO3* NAJ"}=" O3B NAJ"; $resn_exch{"AC2* NAJ"}=" C2B NAJ";
$resn_exch{"AO2* NAJ"}=" O2B NAJ"; $resn_exch{"AC1* NAJ"}=" C1B NAJ"; $resn_exch{" AN9 NAJ"}=" N9A NAJ";
$resn_exch{" AC8 NAJ"}=" C8A NAJ"; $resn_exch{" AN7 NAJ"}=" N7A NAJ"; $resn_exch{" AC5 NAJ"}=" C5A NAJ";
$resn_exch{" AC6 NAJ"}=" C6A NAJ"; $resn_exch{" AN6 NAJ"}=" N6A NAJ"; $resn_exch{" AN1 NAJ"}=" N1A NAJ";
$resn_exch{" AC2 NAJ"}=" C2A NAJ"; $resn_exch{" AN3 NAJ"}=" N3A NAJ"; $resn_exch{" AC4 NAJ"}=" C4A NAJ";
$resn_exch{" NP  NAJ"}=" PN  NAJ"; $resn_exch{" NO1 NAJ"}=" O1N NAJ"; $resn_exch{" NO2 NAJ"}=" O2N NAJ";
$resn_exch{"NO5* NAJ"}=" O5D NAJ"; $resn_exch{"NC5* NAJ"}=" C5D NAJ"; $resn_exch{"NC4* NAJ"}=" C4D NAJ";
$resn_exch{"NO4* NAJ"}=" O4D NAJ"; $resn_exch{"NC3* NAJ"}=" C3D NAJ"; $resn_exch{"NO3* NAJ"}=" O3D NAJ";
$resn_exch{"NC2* NAJ"}=" C2D NAJ"; $resn_exch{"NO2* NAJ"}=" O2D NAJ"; $resn_exch{"NC1* NAJ"}=" C1D NAJ";
$resn_exch{" NN1 NAJ"}=" N1N NAJ"; $resn_exch{" NC2 NAJ"}=" C2N NAJ"; $resn_exch{" NC3 NAJ"}=" C3N NAJ";
$resn_exch{" NC7 NAJ"}=" C7N NAJ"; $resn_exch{" NO7 NAJ"}=" O7N NAJ"; $resn_exch{" NN7 NAJ"}=" N7N NAJ";
$resn_exch{" NC4 NAJ"}=" C4N NAJ"; $resn_exch{" NC5 NAJ"}=" C5N NAJ"; $resn_exch{" NC6 NAJ"}=" C6N NAJ";
$resn_exch{" AP  NAP"}=" PA  NAP"; $resn_exch{" AO1 NAP"}=" O1A NAP"; $resn_exch{" AO2 NAP"}=" O2A NAP";
$resn_exch{"AO5* NAP"}=" O5B NAP"; $resn_exch{"AC5* NAP"}=" C5B NAP"; $resn_exch{"AC4* NAP"}=" C4B NAP";
$resn_exch{"AO4* NAP"}=" O4B NAP"; $resn_exch{"AC3* NAP"}=" C3B NAP"; $resn_exch{"AO3* NAP"}=" O3B NAP";
$resn_exch{"AC2* NAP"}=" C2B NAP"; $resn_exch{"AO2* NAP"}=" O2B NAP"; $resn_exch{"AC1* NAP"}=" C1B NAP";
$resn_exch{" AN9 NAP"}=" N9A NAP"; $resn_exch{" AC8 NAP"}=" C8A NAP"; $resn_exch{" AN7 NAP"}=" N7A NAP";
$resn_exch{" AC5 NAP"}=" C5A NAP"; $resn_exch{" AC6 NAP"}=" C6A NAP"; $resn_exch{" AN6 NAP"}=" N6A NAP";
$resn_exch{" AN1 NAP"}=" N1A NAP"; $resn_exch{" AC2 NAP"}=" C2A NAP"; $resn_exch{" AN3 NAP"}=" N3A NAP";
$resn_exch{" AC4 NAP"}=" C4A NAP"; $resn_exch{" NP  NAP"}=" PN  NAP"; $resn_exch{" NO1 NAP"}=" O1N NAP";
$resn_exch{" NO2 NAP"}=" O2N NAP"; $resn_exch{"NO5* NAP"}=" O5D NAP"; $resn_exch{"NC5* NAP"}=" C5D NAP";
$resn_exch{"NC4* NAP"}=" C4D NAP"; $resn_exch{"NO4* NAP"}=" O4D NAP"; $resn_exch{"NC3* NAP"}=" C3D NAP";
$resn_exch{"NO3* NAP"}=" O3D NAP"; $resn_exch{"NC2* NAP"}=" C2D NAP"; $resn_exch{"NO2* NAP"}=" O2D NAP";
$resn_exch{"NC1* NAP"}=" C1D NAP"; $resn_exch{" NN1 NAP"}=" N1N NAP"; $resn_exch{" NC2 NAP"}=" C2N NAP";
$resn_exch{" NC3 NAP"}=" C3N NAP"; $resn_exch{" NC7 NAP"}=" C7N NAP"; $resn_exch{" NO7 NAP"}=" O7N NAP";
$resn_exch{" NN7 NAP"}=" N7N NAP"; $resn_exch{" NC4 NAP"}=" C4N NAP"; $resn_exch{" NC5 NAP"}=" C5N NAP";
$resn_exch{" NC6 NAP"}=" C6N NAP"; $resn_exch{"AP2* NAP"}=" P2B NAP"; $resn_exch{"AOP1 NAP"}=" O1X NAP";
$resn_exch{"AOP2 NAP"}=" O2X NAP"; $resn_exch{"AOP3 NAP"}=" O3X NAP"; $resn_exch{" O5* NAQ"}=" O5B NAQ";
$resn_exch{" C5* NAQ"}=" C5B NAQ"; $resn_exch{" C4* NAQ"}=" C4B NAQ"; $resn_exch{" O4* NAQ"}=" O4B NAQ";
$resn_exch{" C3* NAQ"}=" C3B NAQ"; $resn_exch{" O3* NAQ"}=" O3B NAQ"; $resn_exch{" C2* NAQ"}=" C2B NAQ";
$resn_exch{" O2* NAQ"}=" O2B NAQ"; $resn_exch{" C1* NAQ"}=" C1B NAQ"; $resn_exch{" AP  NAX"}=" PA  NAX";
$resn_exch{" AO1 NAX"}=" O1A NAX"; $resn_exch{" AO2 NAX"}=" O2A NAX"; $resn_exch{"AO5* NAX"}=" O5B NAX";
$resn_exch{"AC5* NAX"}=" C5B NAX"; $resn_exch{"AC4* NAX"}=" C4B NAX"; $resn_exch{"AO4* NAX"}=" O4B NAX";
$resn_exch{"AC3* NAX"}=" C3B NAX"; $resn_exch{"AO3* NAX"}=" O3B NAX"; $resn_exch{"AC2* NAX"}=" C2B NAX";
$resn_exch{"AO2* NAX"}=" O2B NAX"; $resn_exch{"AC1* NAX"}=" C1B NAX"; $resn_exch{" AN9 NAX"}=" N9A NAX";
$resn_exch{" AC8 NAX"}=" C8A NAX"; $resn_exch{" AN7 NAX"}=" N7A NAX"; $resn_exch{" AC5 NAX"}=" C5A NAX";
$resn_exch{" AC6 NAX"}=" C6A NAX"; $resn_exch{" AN6 NAX"}=" N6A NAX"; $resn_exch{" AN1 NAX"}=" N1A NAX";
$resn_exch{" AC2 NAX"}=" C2A NAX"; $resn_exch{" AN3 NAX"}=" N3A NAX"; $resn_exch{" AC4 NAX"}=" C4A NAX";
$resn_exch{" NP  NAX"}=" PN  NAX"; $resn_exch{" NO1 NAX"}=" O1N NAX"; $resn_exch{" NO2 NAX"}=" O2N NAX";
$resn_exch{"NO5* NAX"}=" O5D NAX"; $resn_exch{"NC5* NAX"}=" C5D NAX"; $resn_exch{"NC4* NAX"}=" C4D NAX";
$resn_exch{"NO4* NAX"}=" O4D NAX"; $resn_exch{"NC3* NAX"}=" C3D NAX"; $resn_exch{"NO3* NAX"}=" O3D NAX";
$resn_exch{"NC2* NAX"}=" C2D NAX"; $resn_exch{"NO2* NAX"}=" O2D NAX"; $resn_exch{"NC1* NAX"}=" C1D NAX";
$resn_exch{" NN1 NAX"}=" N1N NAX"; $resn_exch{" NC2 NAX"}=" C2N NAX"; $resn_exch{" NC3 NAX"}=" C3N NAX";
$resn_exch{" NC7 NAX"}=" C7N NAX"; $resn_exch{" NO7 NAX"}=" O7N NAX"; $resn_exch{" NN7 NAX"}=" N7N NAX";
$resn_exch{" NC4 NAX"}=" C4N NAX"; $resn_exch{" NC5 NAX"}=" C5N NAX"; $resn_exch{" NC6 NAX"}=" C6N NAX";
$resn_exch{" NO6 NAX"}=" O6N NAX"; $resn_exch{" C1* NBC"}=" C1' NBC"; $resn_exch{" O1* NBC"}=" O1' NBC";
$resn_exch{" C2* NBC"}=" C2' NBC"; $resn_exch{" C3* NBC"}=" C3' NBC"; $resn_exch{" C4* NBC"}=" C4' NBC";
$resn_exch{" N5* NBC"}=" N5' NBC"; $resn_exch{" O2* NBC"}=" O2' NBC"; $resn_exch{" O3* NBC"}=" O3' NBC";
$resn_exch{" AP  NBD"}=" PA  NBD"; $resn_exch{"AO1P NBD"}=" O11 NBD"; $resn_exch{"AO2P NBD"}=" O12 NBD";
$resn_exch{"AO5* NBD"}=" O5B NBD"; $resn_exch{"AC5* NBD"}=" C5B NBD"; $resn_exch{"AC4* NBD"}=" C4B NBD";
$resn_exch{"AO4* NBD"}=" O4B NBD"; $resn_exch{"AC3* NBD"}=" C3B NBD"; $resn_exch{"AO3* NBD"}=" O3B NBD";
$resn_exch{"AC2* NBD"}=" C2B NBD"; $resn_exch{"AO2* NBD"}=" O2B NBD"; $resn_exch{"AC1* NBD"}=" C1B NBD";
$resn_exch{" AN9 NBD"}=" N9A NBD"; $resn_exch{" AC8 NBD"}=" C8A NBD"; $resn_exch{" AN7 NBD"}=" N7A NBD";
$resn_exch{" AC5 NBD"}=" C5A NBD"; $resn_exch{" AC6 NBD"}=" C6A NBD"; $resn_exch{" AN6 NBD"}=" N6A NBD";
$resn_exch{" AN1 NBD"}=" N1A NBD"; $resn_exch{" AC2 NBD"}=" C2A NBD"; $resn_exch{" AN3 NBD"}=" N3A NBD";
$resn_exch{" AC4 NBD"}=" C4A NBD"; $resn_exch{" NP  NBD"}=" PN  NBD"; $resn_exch{"NO1P NBD"}=" O13 NBD";
$resn_exch{"NO2P NBD"}=" O14 NBD"; $resn_exch{"NO5* NBD"}=" O5D NBD"; $resn_exch{"NC5* NBD"}=" C5D NBD";
$resn_exch{"NC4* NBD"}=" C4D NBD"; $resn_exch{"NO4* NBD"}=" O4D NBD"; $resn_exch{"NC3* NBD"}=" C3D NBD";
$resn_exch{"NO3* NBD"}=" O3D NBD"; $resn_exch{"NC2* NBD"}=" C2D NBD"; $resn_exch{"NO2* NBD"}=" O2D NBD";
$resn_exch{"NC1* NBD"}=" C1D NBD"; $resn_exch{" NN1 NBD"}=" N1N NBD"; $resn_exch{" NC2 NBD"}=" C2N NBD";
$resn_exch{" NC3 NBD"}=" C3N NBD"; $resn_exch{" NC7 NBD"}=" C7N NBD"; $resn_exch{" NO7 NBD"}=" O7N NBD";
$resn_exch{" NN7 NBD"}=" N7N NBD"; $resn_exch{" NC4 NBD"}=" C4N NBD"; $resn_exch{" NC5 NBD"}=" C5N NBD";
$resn_exch{" NC6 NBD"}=" C6N NBD"; $resn_exch{" AP  NBP"}=" PA  NBP"; $resn_exch{" AO1 NBP"}=" O1A NBP";
$resn_exch{" AO2 NBP"}=" O2A NBP"; $resn_exch{"AO5* NBP"}=" O5B NBP"; $resn_exch{"AC5* NBP"}=" C5B NBP";
$resn_exch{"AC4* NBP"}=" C4B NBP"; $resn_exch{"AO4* NBP"}=" O4B NBP"; $resn_exch{"AC3* NBP"}=" C3B NBP";
$resn_exch{"AO3* NBP"}=" O3B NBP"; $resn_exch{"AC2* NBP"}=" C2B NBP"; $resn_exch{"AO2* NBP"}=" O2B NBP";
$resn_exch{"AC1* NBP"}=" C1B NBP"; $resn_exch{" AN9 NBP"}=" N9A NBP"; $resn_exch{" AC8 NBP"}=" C8A NBP";
$resn_exch{" AN7 NBP"}=" N7A NBP"; $resn_exch{" AC5 NBP"}=" C5A NBP"; $resn_exch{" AC6 NBP"}=" C6A NBP";
$resn_exch{" AN6 NBP"}=" N6A NBP"; $resn_exch{" AN1 NBP"}=" N1A NBP"; $resn_exch{" AC2 NBP"}=" C2A NBP";
$resn_exch{" AN3 NBP"}=" N3A NBP"; $resn_exch{" AC4 NBP"}=" C4A NBP"; $resn_exch{" NP  NBP"}=" PN  NBP";
$resn_exch{" NO1 NBP"}=" O1N NBP"; $resn_exch{" NO2 NBP"}=" O2N NBP"; $resn_exch{"NO5* NBP"}=" O5D NBP";
$resn_exch{"NC5* NBP"}=" C5D NBP"; $resn_exch{"NC4* NBP"}=" C4D NBP"; $resn_exch{"NO4* NBP"}=" O4D NBP";
$resn_exch{"NC3* NBP"}=" C3D NBP"; $resn_exch{"NO3* NBP"}=" O3D NBP"; $resn_exch{"NC2* NBP"}=" C2D NBP";
$resn_exch{"NO2* NBP"}=" O2D NBP"; $resn_exch{"NC1* NBP"}=" C1D NBP"; $resn_exch{" NN1 NBP"}=" N1N NBP";
$resn_exch{" NC2 NBP"}=" C2N NBP"; $resn_exch{" NC3 NBP"}=" C3N NBP"; $resn_exch{" NC7 NBP"}=" C7N NBP";
$resn_exch{" NO7 NBP"}=" O7N NBP"; $resn_exch{" NN7 NBP"}=" N7N NBP"; $resn_exch{" NC4 NBP"}=" C4N NBP";
$resn_exch{" NC5 NBP"}=" C5N NBP"; $resn_exch{" NC6 NBP"}=" C6N NBP"; $resn_exch{"AP2* NBP"}=" P2B NBP";
$resn_exch{"AOP1 NBP"}=" O1X NBP"; $resn_exch{"AOP2 NBP"}=" O2X NBP"; $resn_exch{"AOP3 NBP"}=" O3X NBP";
$resn_exch{" O   NBQ"}=" OXT NBQ"; $resn_exch{" O1  NBQ"}=" O   NBQ"; $resn_exch{" O5* NBS"}=" O5' NBS";
$resn_exch{" C5* NBS"}=" C5' NBS"; $resn_exch{" C4* NBS"}=" C4' NBS"; $resn_exch{" O4* NBS"}=" O4' NBS";
$resn_exch{" C1* NBS"}=" C1' NBS"; $resn_exch{" C2* NBS"}=" C2' NBS"; $resn_exch{" O2* NBS"}=" O2' NBS";
$resn_exch{" C3* NBS"}=" C3' NBS"; $resn_exch{" O3* NBS"}=" O3' NBS"; $resn_exch{" O1  NC1"}=" OXT NC1";
$resn_exch{"O100 NCG"}=" OXS NCG"; $resn_exch{"C102 NCG"}=" CXU NCG"; $resn_exch{"O105 NCG"}=" OXX NCG";
$resn_exch{"N108 NCG"}=" NX0 NCG"; $resn_exch{"C110 NCG"}=" CX2 NCG"; $resn_exch{"O118 NCG"}=" OXA NCG";
$resn_exch{" O5* NCN"}=" O5' NCN"; $resn_exch{" C5* NCN"}=" C5' NCN"; $resn_exch{" C4* NCN"}=" C4' NCN";
$resn_exch{" O4* NCN"}=" O4' NCN"; $resn_exch{" C3* NCN"}=" C3' NCN"; $resn_exch{" O3* NCN"}=" O3' NCN";
$resn_exch{" C2* NCN"}=" C2' NCN"; $resn_exch{" O2* NCN"}=" O2' NCN"; $resn_exch{" C1* NCN"}=" C1' NCN";
$resn_exch{" O1* NCS"}=" O1' NCS"; $resn_exch{" C1* NCS"}=" C1' NCS"; $resn_exch{" C2* NCS"}=" C2' NCS";
$resn_exch{" N2* NCS"}=" N2' NCS"; $resn_exch{" C3* NCS"}=" C3' NCS"; $resn_exch{" O3* NCS"}=" O3' NCS";
$resn_exch{" C4* NCS"}=" C4' NCS"; $resn_exch{" O4* NCS"}=" O4' NCS"; $resn_exch{" C5* NCS"}=" C5' NCS";
$resn_exch{" O5* NCS"}=" O5' NCS"; $resn_exch{" O1P NCX"}=" OP1 NCX"; $resn_exch{" O2P NCX"}=" OP2 NCX";
$resn_exch{" O3P NCX"}=" OP3 NCX"; $resn_exch{" O5* NCX"}=" O5' NCX"; $resn_exch{" C5* NCX"}=" C5' NCX";
$resn_exch{" C4* NCX"}=" C4' NCX"; $resn_exch{" O4* NCX"}=" O4' NCX"; $resn_exch{" C1* NCX"}=" C1' NCX";
$resn_exch{" C3* NCX"}=" C3' NCX"; $resn_exch{" C2* NCX"}=" C2' NCX"; $resn_exch{" O3* NCX"}=" O3' NCX";
$resn_exch{" AP  NDA"}=" PA  NDA"; $resn_exch{" AO1 NDA"}=" O1A NDA"; $resn_exch{" AO2 NDA"}=" O2A NDA";
$resn_exch{"AO5* NDA"}=" O5B NDA"; $resn_exch{"AC5* NDA"}=" C5B NDA"; $resn_exch{"AC4* NDA"}=" C4B NDA";
$resn_exch{"AO4* NDA"}=" O4B NDA"; $resn_exch{"AC3* NDA"}=" C3B NDA"; $resn_exch{"AO3* NDA"}=" O3B NDA";
$resn_exch{"AC2* NDA"}=" C2B NDA"; $resn_exch{"AO2* NDA"}=" O2B NDA"; $resn_exch{"AC1* NDA"}=" C1B NDA";
$resn_exch{" AN9 NDA"}=" N9A NDA"; $resn_exch{" AC8 NDA"}=" C8A NDA"; $resn_exch{" AN7 NDA"}=" N7A NDA";
$resn_exch{" AC5 NDA"}=" C5A NDA"; $resn_exch{" AC6 NDA"}=" C6A NDA"; $resn_exch{" AN6 NDA"}=" N6A NDA";
$resn_exch{" AN1 NDA"}=" N1A NDA"; $resn_exch{" AC2 NDA"}=" C2A NDA"; $resn_exch{" AN3 NDA"}=" N3A NDA";
$resn_exch{" AC4 NDA"}=" C4A NDA"; $resn_exch{" NP  NDA"}=" PN  NDA"; $resn_exch{" NO1 NDA"}=" O1N NDA";
$resn_exch{" NO2 NDA"}=" O2N NDA"; $resn_exch{"NO5* NDA"}=" O5D NDA"; $resn_exch{"NC5* NDA"}=" C5D NDA";
$resn_exch{"NC4* NDA"}=" C4D NDA"; $resn_exch{"NO4* NDA"}=" O4D NDA"; $resn_exch{"NC3* NDA"}=" C3D NDA";
$resn_exch{"NO3* NDA"}=" O3D NDA"; $resn_exch{"NC2* NDA"}=" C2D NDA"; $resn_exch{"NO2* NDA"}=" O2D NDA";
$resn_exch{"NC1* NDA"}=" C1D NDA"; $resn_exch{" NN1 NDA"}=" N1N NDA"; $resn_exch{" NC2 NDA"}=" C2N NDA";
$resn_exch{" NC3 NDA"}=" C3N NDA"; $resn_exch{" NC7 NDA"}=" C7N NDA"; $resn_exch{" NN7 NDA"}=" N7N NDA";
$resn_exch{" NC4 NDA"}=" C4N NDA"; $resn_exch{" NC5 NDA"}=" C5N NDA"; $resn_exch{" NC6 NDA"}=" C6N NDA";
$resn_exch{" O5* NDC"}=" O5B NDC"; $resn_exch{" C5* NDC"}=" C5B NDC"; $resn_exch{" C4* NDC"}=" C4B NDC";
$resn_exch{" O4* NDC"}=" O4B NDC"; $resn_exch{" C3* NDC"}=" C3B NDC"; $resn_exch{" O3* NDC"}=" O3B NDC";
$resn_exch{" C2* NDC"}=" C2B NDC"; $resn_exch{" O2* NDC"}=" O2B NDC"; $resn_exch{" C1* NDC"}=" C1B NDC";
$resn_exch{" NO7 NDE"}=" O7N NDE"; $resn_exch{" NC7 NDE"}=" C7N NDE"; $resn_exch{" NN7 NDE"}=" N7N NDE";
$resn_exch{" NC3 NDE"}=" C3N NDE"; $resn_exch{" NC4 NDE"}=" C4N NDE"; $resn_exch{" NC5 NDE"}=" C5N NDE";
$resn_exch{" NC6 NDE"}=" C6N NDE"; $resn_exch{" NC2 NDE"}=" C2N NDE"; $resn_exch{" NN1 NDE"}=" N1N NDE";
$resn_exch{"NC1* NDE"}=" C1D NDE"; $resn_exch{"NC2* NDE"}=" C2D NDE"; $resn_exch{"NO2* NDE"}=" O2D NDE";
$resn_exch{"NC3* NDE"}=" C3D NDE"; $resn_exch{"NO3* NDE"}=" O3D NDE"; $resn_exch{"NO4* NDE"}=" O4D NDE";
$resn_exch{"NC4* NDE"}=" C4D NDE"; $resn_exch{"NC5* NDE"}=" C5D NDE"; $resn_exch{"NO5* NDE"}=" O5D NDE";
$resn_exch{" NP  NDE"}=" PN  NDE"; $resn_exch{" NO1 NDE"}=" O1N NDE"; $resn_exch{" NO2 NDE"}=" O2N NDE";
$resn_exch{" AP  NDE"}=" PA  NDE"; $resn_exch{" AO1 NDE"}=" O1A NDE"; $resn_exch{" AO2 NDE"}=" O2A NDE";
$resn_exch{"AO5* NDE"}=" O5B NDE"; $resn_exch{"AC5* NDE"}=" C5B NDE"; $resn_exch{"AC4* NDE"}=" C4B NDE";
$resn_exch{"AO4* NDE"}=" O4B NDE"; $resn_exch{"AC1* NDE"}=" C1B NDE"; $resn_exch{"AC2* NDE"}=" C2B NDE";
$resn_exch{"AO2* NDE"}=" O2B NDE"; $resn_exch{"AC3* NDE"}=" C3B NDE"; $resn_exch{"AO3* NDE"}=" O3B NDE";
$resn_exch{" AN9 NDE"}=" N9A NDE"; $resn_exch{" AC8 NDE"}=" C8A NDE"; $resn_exch{" AN7 NDE"}=" N7A NDE";
$resn_exch{" AC5 NDE"}=" C5A NDE"; $resn_exch{" AC6 NDE"}=" C6A NDE"; $resn_exch{" AN6 NDE"}=" N6A NDE";
$resn_exch{" AC4 NDE"}=" C4A NDE"; $resn_exch{" AN3 NDE"}=" N3A NDE"; $resn_exch{" AC2 NDE"}=" C2A NDE";
$resn_exch{" AN1 NDE"}=" N1A NDE"; $resn_exch{" AP  NDO"}=" PA  NDO"; $resn_exch{" AO1 NDO"}=" O1A NDO";
$resn_exch{" AO2 NDO"}=" O2A NDO"; $resn_exch{"AO5* NDO"}=" O5B NDO"; $resn_exch{"AC5* NDO"}=" C5B NDO";
$resn_exch{"AC4* NDO"}=" C4B NDO"; $resn_exch{"AO4* NDO"}=" O4B NDO"; $resn_exch{"AC3* NDO"}=" C3B NDO";
$resn_exch{"AO3* NDO"}=" O3B NDO"; $resn_exch{"AC2* NDO"}=" C2B NDO"; $resn_exch{"AO2* NDO"}=" O2B NDO";
$resn_exch{"AC1* NDO"}=" C1B NDO"; $resn_exch{" AN9 NDO"}=" N9A NDO"; $resn_exch{" AC8 NDO"}=" C8A NDO";
$resn_exch{" AN7 NDO"}=" N7A NDO"; $resn_exch{" AC5 NDO"}=" C5A NDO"; $resn_exch{" AC6 NDO"}=" C6A NDO";
$resn_exch{" AO6 NDO"}=" O6A NDO"; $resn_exch{" AN1 NDO"}=" N1A NDO"; $resn_exch{" AC2 NDO"}=" C2A NDO";
$resn_exch{" AN3 NDO"}=" N3A NDO"; $resn_exch{" AC4 NDO"}=" C4A NDO"; $resn_exch{" NP  NDO"}=" PN  NDO";
$resn_exch{" NO1 NDO"}=" O1N NDO"; $resn_exch{" NO2 NDO"}=" O2N NDO"; $resn_exch{"NO5* NDO"}=" O5D NDO";
$resn_exch{"NC5* NDO"}=" C5D NDO"; $resn_exch{"NC4* NDO"}=" C4D NDO"; $resn_exch{"NO4* NDO"}=" O4D NDO";
$resn_exch{"NC3* NDO"}=" C3D NDO"; $resn_exch{"NO3* NDO"}=" O3D NDO"; $resn_exch{"NC2* NDO"}=" C2D NDO";
$resn_exch{"NO2* NDO"}=" O2D NDO"; $resn_exch{"NC1* NDO"}=" C1D NDO"; $resn_exch{" NN1 NDO"}=" N1N NDO";
$resn_exch{" NC2 NDO"}=" C2N NDO"; $resn_exch{" NC3 NDO"}=" C3N NDO"; $resn_exch{" NC7 NDO"}=" C7N NDO";
$resn_exch{" NO7 NDO"}=" O7N NDO"; $resn_exch{" NN7 NDO"}=" N7N NDO"; $resn_exch{" NC4 NDO"}=" C4N NDO";
$resn_exch{" NC5 NDO"}=" C5N NDO"; $resn_exch{" NC6 NDO"}=" C6N NDO"; $resn_exch{"AP2* NDO"}=" P2B NDO";
$resn_exch{"AOP1 NDO"}=" O1X NDO"; $resn_exch{"AOP2 NDO"}=" O2X NDO"; $resn_exch{"AOP3 NDO"}=" O3X NDO";
$resn_exch{" AP  NDP"}=" PA  NDP"; $resn_exch{" AO1 NDP"}=" O1A NDP"; $resn_exch{" AO2 NDP"}=" O2A NDP";
$resn_exch{"AO5* NDP"}=" O5B NDP"; $resn_exch{"AC5* NDP"}=" C5B NDP"; $resn_exch{"AC4* NDP"}=" C4B NDP";
$resn_exch{"AO4* NDP"}=" O4B NDP"; $resn_exch{"AC3* NDP"}=" C3B NDP"; $resn_exch{"AO3* NDP"}=" O3B NDP";
$resn_exch{"AC2* NDP"}=" C2B NDP"; $resn_exch{"AO2* NDP"}=" O2B NDP"; $resn_exch{"AC1* NDP"}=" C1B NDP";
$resn_exch{" AN9 NDP"}=" N9A NDP"; $resn_exch{" AC8 NDP"}=" C8A NDP"; $resn_exch{" AN7 NDP"}=" N7A NDP";
$resn_exch{" AC5 NDP"}=" C5A NDP"; $resn_exch{" AC6 NDP"}=" C6A NDP"; $resn_exch{" AN6 NDP"}=" N6A NDP";
$resn_exch{" AN1 NDP"}=" N1A NDP"; $resn_exch{" AC2 NDP"}=" C2A NDP"; $resn_exch{" AN3 NDP"}=" N3A NDP";
$resn_exch{" AC4 NDP"}=" C4A NDP"; $resn_exch{" NP  NDP"}=" PN  NDP"; $resn_exch{" NO1 NDP"}=" O1N NDP";
$resn_exch{" NO2 NDP"}=" O2N NDP"; $resn_exch{"NO5* NDP"}=" O5D NDP"; $resn_exch{"NC5* NDP"}=" C5D NDP";
$resn_exch{"NC4* NDP"}=" C4D NDP"; $resn_exch{"NO4* NDP"}=" O4D NDP"; $resn_exch{"NC3* NDP"}=" C3D NDP";
$resn_exch{"NO3* NDP"}=" O3D NDP"; $resn_exch{"NC2* NDP"}=" C2D NDP"; $resn_exch{"NO2* NDP"}=" O2D NDP";
$resn_exch{"NC1* NDP"}=" C1D NDP"; $resn_exch{" NN1 NDP"}=" N1N NDP"; $resn_exch{" NC2 NDP"}=" C2N NDP";
$resn_exch{" NC3 NDP"}=" C3N NDP"; $resn_exch{" NC7 NDP"}=" C7N NDP"; $resn_exch{" NO7 NDP"}=" O7N NDP";
$resn_exch{" NN7 NDP"}=" N7N NDP"; $resn_exch{" NC4 NDP"}=" C4N NDP"; $resn_exch{" NC5 NDP"}=" C5N NDP";
$resn_exch{" NC6 NDP"}=" C6N NDP"; $resn_exch{"AP2* NDP"}=" P2B NDP"; $resn_exch{"AOP1 NDP"}=" O1X NDP";
$resn_exch{"AOP2 NDP"}=" O2X NDP"; $resn_exch{"AOP3 NDP"}=" O3X NDP"; $resn_exch{" C5* NEA"}=" C5' NEA";
$resn_exch{" C4* NEA"}=" C4' NEA"; $resn_exch{" O4* NEA"}=" O4' NEA"; $resn_exch{" C3* NEA"}=" C3' NEA";
$resn_exch{" O3* NEA"}=" O3' NEA"; $resn_exch{" C2* NEA"}=" C2' NEA"; $resn_exch{" O2* NEA"}=" O2' NEA";
$resn_exch{" C1* NEA"}=" C1' NEA"; $resn_exch{" C5* NEC"}=" C5' NEC"; $resn_exch{" O5* NEC"}=" O5' NEC";
$resn_exch{" N5* NEC"}=" N5' NEC"; $resn_exch{" C4* NEC"}=" C4' NEC"; $resn_exch{" O4* NEC"}=" O4' NEC";
$resn_exch{" C3* NEC"}=" C3' NEC"; $resn_exch{" O3* NEC"}=" O3' NEC"; $resn_exch{" C2* NEC"}=" C2' NEC";
$resn_exch{" O2* NEC"}=" O2' NEC"; $resn_exch{" C1* NEC"}=" C1' NEC"; $resn_exch{" N5* NEI"}=" N5' NEI";
$resn_exch{" C5* NEI"}=" C5' NEI"; $resn_exch{" O5* NEI"}=" O5' NEI"; $resn_exch{" C4* NEI"}=" C4' NEI";
$resn_exch{" O4* NEI"}=" O4' NEI"; $resn_exch{" C3* NEI"}=" C3' NEI"; $resn_exch{" O3* NEI"}=" O3' NEI";
$resn_exch{" C2* NEI"}=" C2' NEI"; $resn_exch{" O2* NEI"}=" O2' NEI"; $resn_exch{" C1* NEI"}=" C1' NEI";
$resn_exch{"1O1   NF"}=" O11  NF"; $resn_exch{"1C1   NF"}=" C11  NF"; $resn_exch{"1N2   NF"}=" N21  NF";
$resn_exch{"2C1   NF"}=" C12  NF"; $resn_exch{"1C3   NF"}=" C31  NF"; $resn_exch{"1O3   NF"}=" O31  NF";
$resn_exch{"1C11  NF"}=" CX3  NF"; $resn_exch{"1C12  NF"}=" CXD  NF"; $resn_exch{"1C10  NF"}=" CXT  NF";
$resn_exch{"1C9   NF"}=" C91  NF"; $resn_exch{"1C8   NF"}=" C81  NF"; $resn_exch{"1C7   NF"}=" C71  NF";
$resn_exch{"1C13  NF"}=" CXN  NF"; $resn_exch{"1C6   NF"}=" C61  NF"; $resn_exch{"1C5   NF"}=" C51  NF";
$resn_exch{"1C4   NF"}=" C41  NF"; $resn_exch{"2C2   NF"}=" C22  NF"; $resn_exch{"2N3   NF"}=" N32  NF";
$resn_exch{"2C4   NF"}=" C42  NF"; $resn_exch{"2C5   NF"}=" C52  NF"; $resn_exch{"2C6   NF"}=" C62  NF";
$resn_exch{"2N7   NF"}=" N72  NF"; $resn_exch{"2C8   NF"}=" C82  NF"; $resn_exch{"3O1   NF"}=" O13  NF";
$resn_exch{"3C1   NF"}=" C13  NF"; $resn_exch{"3N2   NF"}=" N23  NF"; $resn_exch{"2C9   NF"}=" C92  NF";
$resn_exch{"3C3   NF"}=" C33  NF"; $resn_exch{"3O3   NF"}=" O33  NF"; $resn_exch{"3C11  NF"}=" CX5  NF";
$resn_exch{"3C12  NF"}=" CXF  NF"; $resn_exch{"3C10  NF"}=" CXV  NF"; $resn_exch{"3C9   NF"}=" C93  NF";
$resn_exch{"3C8   NF"}=" C83  NF"; $resn_exch{"3C7   NF"}=" C73  NF"; $resn_exch{"3C13  NF"}=" CXP  NF";
$resn_exch{"3C6   NF"}=" C63  NF"; $resn_exch{"3C5   NF"}=" C53  NF"; $resn_exch{"3C4   NF"}=" C43  NF";
$resn_exch{" C1* NF2"}=" C1' NF2"; $resn_exch{" O4* NF2"}=" O4' NF2"; $resn_exch{" C2* NF2"}=" C2' NF2";
$resn_exch{" O2* NF2"}=" O2' NF2"; $resn_exch{" C3* NF2"}=" C3' NF2"; $resn_exch{" O3* NF2"}=" O3' NF2";
$resn_exch{" C4* NF2"}=" C4' NF2"; $resn_exch{" C5* NF2"}=" C5' NF2"; $resn_exch{" O5* NF2"}=" O5' NF2";
$resn_exch{" O1P NF2"}=" OP1 NF2"; $resn_exch{" O2P NF2"}=" OP2 NF2"; $resn_exch{" O3P NF2"}=" OP3 NF2";
$resn_exch{" C1* NGD"}=" C1' NGD"; $resn_exch{" O4* NGD"}=" O4' NGD"; $resn_exch{" C2* NGD"}=" C2' NGD";
$resn_exch{" O2* NGD"}=" O2' NGD"; $resn_exch{" C3* NGD"}=" C3' NGD"; $resn_exch{" O3* NGD"}=" O3' NGD";
$resn_exch{" C4* NGD"}=" C4' NGD"; $resn_exch{" C5* NGD"}=" C5' NGD"; $resn_exch{" O5* NGD"}=" O5' NGD";
$resn_exch{"RO5* NGD"}="O5'R NGD"; $resn_exch{"RC5* NGD"}="C5'R NGD"; $resn_exch{"RC4* NGD"}="C4'R NGD";
$resn_exch{"RC3* NGD"}="C3'R NGD"; $resn_exch{"RO3* NGD"}="O3'R NGD"; $resn_exch{"RC2* NGD"}="C2'R NGD";
$resn_exch{"RO2* NGD"}="O2'R NGD"; $resn_exch{"RO4* NGD"}="O4'R NGD"; $resn_exch{"RC1* NGD"}="C1'R NGD";
$resn_exch{" C1* NGM"}=" C1' NGM"; $resn_exch{" C2* NGM"}=" C2' NGM"; $resn_exch{" C3* NGM"}=" C3' NGM";
$resn_exch{" C4* NGM"}=" C4' NGM"; $resn_exch{" C5* NGM"}=" C5' NGM"; $resn_exch{" O1* NGM"}=" O1' NGM";
$resn_exch{" O2* NGM"}=" O2' NGM"; $resn_exch{" O3* NGM"}=" O3' NGM"; $resn_exch{" O4* NGM"}=" O4' NGM";
$resn_exch{" C1* NGP"}=" C1' NGP"; $resn_exch{" C2* NGP"}=" C2' NGP"; $resn_exch{" C3* NGP"}=" C3' NGP";
$resn_exch{" C4* NGP"}=" C4' NGP"; $resn_exch{" C5* NGP"}=" C5' NGP"; $resn_exch{" O1* NGP"}=" O1' NGP";
$resn_exch{" O2* NGP"}=" O2' NGP"; $resn_exch{" O3* NGP"}=" O3' NGP"; $resn_exch{" O4* NGP"}=" O4' NGP";
$resn_exch{" C1* NGU"}=" C1' NGU"; $resn_exch{" C2* NGU"}=" C2' NGU"; $resn_exch{" C3* NGU"}=" C3' NGU";
$resn_exch{" C4* NGU"}=" C4' NGU"; $resn_exch{" C5* NGU"}=" C5' NGU"; $resn_exch{" O1* NGU"}=" O1' NGU";
$resn_exch{" O2* NGU"}=" O2' NGU"; $resn_exch{" O3* NGU"}=" O3' NGU"; $resn_exch{" O4* NGU"}=" O4' NGU";
$resn_exch{" AP  NHD"}=" PA  NHD"; $resn_exch{" AO1 NHD"}=" O1A NHD"; $resn_exch{" AO2 NHD"}=" O2A NHD";
$resn_exch{"AO5* NHD"}=" O5B NHD"; $resn_exch{"AC5* NHD"}=" C5B NHD"; $resn_exch{"AC4* NHD"}=" C4B NHD";
$resn_exch{"AO4* NHD"}=" O4B NHD"; $resn_exch{"AC3* NHD"}=" C3B NHD"; $resn_exch{"AO3* NHD"}=" O3B NHD";
$resn_exch{"AC2* NHD"}=" C2B NHD"; $resn_exch{"AO2* NHD"}=" O2B NHD"; $resn_exch{"AC1* NHD"}=" C1B NHD";
$resn_exch{" AN9 NHD"}=" N9A NHD"; $resn_exch{" AC8 NHD"}=" C8A NHD"; $resn_exch{" AN7 NHD"}=" N7A NHD";
$resn_exch{" AC5 NHD"}=" C5A NHD"; $resn_exch{" AC6 NHD"}=" C6A NHD"; $resn_exch{" AO6 NHD"}=" O6A NHD";
$resn_exch{" AN1 NHD"}=" N1A NHD"; $resn_exch{" AC2 NHD"}=" C2A NHD"; $resn_exch{" AN3 NHD"}=" N3A NHD";
$resn_exch{" AC4 NHD"}=" C4A NHD"; $resn_exch{" NP  NHD"}=" PN  NHD"; $resn_exch{" NO1 NHD"}=" O1N NHD";
$resn_exch{" NO2 NHD"}=" O2N NHD"; $resn_exch{"NO5* NHD"}=" O5D NHD"; $resn_exch{"NC5* NHD"}=" C5D NHD";
$resn_exch{"NC4* NHD"}=" C4D NHD"; $resn_exch{"NO4* NHD"}=" O4D NHD"; $resn_exch{"NC3* NHD"}=" C3D NHD";
$resn_exch{"NO3* NHD"}=" O3D NHD"; $resn_exch{"NC2* NHD"}=" C2D NHD"; $resn_exch{"NO2* NHD"}=" O2D NHD";
$resn_exch{"NC1* NHD"}=" C1D NHD"; $resn_exch{" NN1 NHD"}=" N1N NHD"; $resn_exch{" NC2 NHD"}=" C2N NHD";
$resn_exch{" NC3 NHD"}=" C3N NHD"; $resn_exch{" NC7 NHD"}=" C7N NHD"; $resn_exch{" NO7 NHD"}=" O7N NHD";
$resn_exch{" NN7 NHD"}=" N7N NHD"; $resn_exch{" NC4 NHD"}=" C4N NHD"; $resn_exch{" NC5 NHD"}=" C5N NHD";
$resn_exch{" NC6 NHD"}=" C6N NHD"; $resn_exch{" O5* NHO"}=" O5B NHO"; $resn_exch{" C5* NHO"}=" C5B NHO";
$resn_exch{" C4* NHO"}=" C4B NHO"; $resn_exch{" O4* NHO"}=" O4B NHO"; $resn_exch{" C3* NHO"}=" C3B NHO";
$resn_exch{" O3* NHO"}=" O3B NHO"; $resn_exch{" C2* NHO"}=" C2B NHO"; $resn_exch{" O2* NHO"}=" O2B NHO";
$resn_exch{" C1* NHO"}=" C1B NHO"; $resn_exch{" C1* NIR"}=" C1' NIR"; $resn_exch{" C2* NIR"}=" C2' NIR";
$resn_exch{" O2* NIR"}=" O2' NIR"; $resn_exch{" C3* NIR"}=" C3' NIR"; $resn_exch{" O3* NIR"}=" O3' NIR";
$resn_exch{" C4* NIR"}=" C4' NIR"; $resn_exch{" O4* NIR"}=" O4' NIR"; $resn_exch{" C5* NIR"}=" C5' NIR";
$resn_exch{" O   NLQ"}=" OXT NLQ"; $resn_exch{" OXT NLQ"}=" O   NLQ"; $resn_exch{" C5* NMD"}=" C5' NMD";
$resn_exch{" C4* NMD"}=" C4' NMD"; $resn_exch{" O4* NMD"}=" O4' NMD"; $resn_exch{" C3* NMD"}=" C3' NMD";
$resn_exch{" O3* NMD"}=" O3' NMD"; $resn_exch{" C2* NMD"}=" C2' NMD"; $resn_exch{" N2* NMD"}=" N2' NMD";
$resn_exch{" C1* NMD"}=" C1' NMD"; $resn_exch{" O5* NMD"}=" O5' NMD"; $resn_exch{" O2P NMS"}=" OP2 NMS";
$resn_exch{" O1P NMS"}=" OP1 NMS"; $resn_exch{" O5* NMS"}=" O5' NMS"; $resn_exch{" C2* NMS"}=" C2' NMS";
$resn_exch{" C5* NMS"}=" C5' NMS"; $resn_exch{" C4* NMS"}=" C4' NMS"; $resn_exch{" O4* NMS"}=" O4' NMS";
$resn_exch{" C1* NMS"}=" C1' NMS"; $resn_exch{" C3* NMS"}=" C3' NMS"; $resn_exch{" O3* NMS"}=" O3' NMS";
$resn_exch{" O3P NMS"}=" OP3 NMS"; $resn_exch{" O3P NMT"}=" OP3 NMT"; $resn_exch{" O2P NMT"}=" OP2 NMT";
$resn_exch{" O5* NMT"}=" O5' NMT"; $resn_exch{" C2* NMT"}=" C2' NMT"; $resn_exch{" C5* NMT"}=" C5' NMT";
$resn_exch{" C4* NMT"}=" C4' NMT"; $resn_exch{" O4* NMT"}=" O4' NMT"; $resn_exch{" C1* NMT"}=" C1' NMT";
$resn_exch{" C3* NMT"}=" C3' NMT"; $resn_exch{" O3* NMT"}=" O3' NMT"; $resn_exch{" O1P NMT"}=" OP1 NMT";
$resn_exch{" AN1 NMX"}=" N1A NMX"; $resn_exch{" AC2 NMX"}=" C2A NMX"; $resn_exch{" AN3 NMX"}=" N3A NMX";
$resn_exch{" AC4 NMX"}=" C4A NMX"; $resn_exch{" AC5 NMX"}=" C5A NMX"; $resn_exch{" AC6 NMX"}=" C6A NMX";
$resn_exch{" AN6 NMX"}=" N6A NMX"; $resn_exch{" AN7 NMX"}=" N7A NMX"; $resn_exch{" AC8 NMX"}=" C8A NMX";
$resn_exch{" AN9 NMX"}=" N9A NMX"; $resn_exch{"AC1* NMX"}=" C1B NMX"; $resn_exch{"AC2* NMX"}=" C2B NMX";
$resn_exch{"AO2* NMX"}=" O2B NMX"; $resn_exch{"AC3* NMX"}=" C3B NMX"; $resn_exch{"AO3* NMX"}=" O3B NMX";
$resn_exch{"AP3* NMX"}=" P3B NMX"; $resn_exch{" AO7 NMX"}=" O7A NMX"; $resn_exch{" AO8 NMX"}=" O8A NMX";
$resn_exch{" AO9 NMX"}=" O9A NMX"; $resn_exch{"AC4* NMX"}=" C4B NMX"; $resn_exch{"AO4* NMX"}=" O4B NMX";
$resn_exch{"AC5* NMX"}=" C5B NMX"; $resn_exch{"AO5* NMX"}=" O5B NMX"; $resn_exch{" AP1 NMX"}=" P1A NMX";
$resn_exch{" AO1 NMX"}=" O1A NMX"; $resn_exch{" AO2 NMX"}=" O2A NMX"; $resn_exch{" AO3 NMX"}=" O3A NMX";
$resn_exch{" AP2 NMX"}=" P2A NMX"; $resn_exch{" AO4 NMX"}=" O4A NMX"; $resn_exch{" AO5 NMX"}=" O5A NMX";
$resn_exch{" AO6 NMX"}=" O6A NMX"; $resn_exch{"PC11 NMX"}=" CBP NMX"; $resn_exch{"PC12 NMX"}=" CCP NMX";
$resn_exch{"PC13 NMX"}=" CDP NMX"; $resn_exch{"PC14 NMX"}=" CEP NMX"; $resn_exch{"PC10 NMX"}=" CAP NMX";
$resn_exch{"PO10 NMX"}=" OAP NMX"; $resn_exch{" PC9 NMX"}=" C9P NMX"; $resn_exch{" PO9 NMX"}=" O9P NMX";
$resn_exch{" PN8 NMX"}=" N8P NMX"; $resn_exch{" PC7 NMX"}=" C7P NMX"; $resn_exch{" PC6 NMX"}=" C6P NMX";
$resn_exch{" PC5 NMX"}=" C5P NMX"; $resn_exch{" PO5 NMX"}=" O5P NMX"; $resn_exch{" PN4 NMX"}=" N4P NMX";
$resn_exch{" PC3 NMX"}=" C3P NMX"; $resn_exch{" PC2 NMX"}=" C2P NMX"; $resn_exch{" IC1 NMX"}=" C1I NMX";
$resn_exch{" IN1 NMX"}=" N1I NMX"; $resn_exch{" IO1 NMX"}=" O1I NMX"; $resn_exch{" IO2 NMX"}=" O2I NMX";
$resn_exch{" C6* NOC"}=" C6' NOC"; $resn_exch{" O6* NOC"}=" O6' NOC"; $resn_exch{" C5* NOC"}=" C5' NOC";
$resn_exch{" C4* NOC"}=" C4' NOC"; $resn_exch{" C3* NOC"}=" C3' NOC"; $resn_exch{" O3* NOC"}=" O3' NOC";
$resn_exch{" C2* NOC"}=" C2' NOC"; $resn_exch{" O2* NOC"}=" O2' NOC"; $resn_exch{" C1* NOC"}=" C1' NOC";
$resn_exch{" C1* NOD"}=" C1' NOD"; $resn_exch{" C2* NOD"}=" C2' NOD"; $resn_exch{" C3* NOD"}=" C3' NOD";
$resn_exch{" C4* NOD"}=" C4' NOD"; $resn_exch{" O4* NOD"}=" O4' NOD"; $resn_exch{" C5* NOD"}=" C5' NOD";
$resn_exch{" O5* NOD"}=" O5' NOD"; $resn_exch{" C6* NOD"}=" C6' NOD"; $resn_exch{" N3* NOD"}=" N3' NOD";
$resn_exch{" C5* NOS"}=" C5' NOS"; $resn_exch{" O5* NOS"}=" O5' NOS"; $resn_exch{" C4* NOS"}=" C4' NOS";
$resn_exch{" O4* NOS"}=" O4' NOS"; $resn_exch{" C1* NOS"}=" C1' NOS"; $resn_exch{" C2* NOS"}=" C2' NOS";
$resn_exch{" O2* NOS"}=" O2' NOS"; $resn_exch{" C3* NOS"}=" C3' NOS"; $resn_exch{" O3* NOS"}=" O3' NOS";
$resn_exch{" O5* NP3"}=" O5' NP3"; $resn_exch{" C5* NP3"}=" C5' NP3"; $resn_exch{" C4* NP3"}=" C4' NP3";
$resn_exch{" O4* NP3"}=" O4' NP3"; $resn_exch{" C1* NP3"}=" C1' NP3"; $resn_exch{" C2* NP3"}=" C2' NP3";
$resn_exch{" C3* NP3"}=" C3' NP3"; $resn_exch{" O3* NP3"}=" O3' NP3"; $resn_exch{" O5* NRI"}=" O5' NRI";
$resn_exch{" C2* NRI"}=" C2' NRI"; $resn_exch{" C5* NRI"}=" C5' NRI"; $resn_exch{" C4* NRI"}=" C4' NRI";
$resn_exch{" C3* NRI"}=" C3' NRI"; $resn_exch{" C6* NRI"}=" C6' NRI"; $resn_exch{" N1* NRI"}=" N1' NRI";
$resn_exch{" O3* NRI"}=" O3' NRI"; $resn_exch{" C4* NRT"}=" C4' NRT"; $resn_exch{" O4* NRT"}=" O4' NRT";
$resn_exch{" C3* NRT"}=" C3' NRT"; $resn_exch{" C2* NRT"}=" C2' NRT"; $resn_exch{" O5* NSS"}=" O5' NSS";
$resn_exch{" C5* NSS"}=" C5' NSS"; $resn_exch{" C4* NSS"}=" C4' NSS"; $resn_exch{" C3* NSS"}=" C3' NSS";
$resn_exch{" O3* NSS"}=" O3' NSS"; $resn_exch{" C2* NSS"}=" C2' NSS"; $resn_exch{" O2* NSS"}=" O2' NSS";
$resn_exch{" C1* NSS"}=" C1' NSS"; $resn_exch{" O4* NSS"}=" O4' NSS"; $resn_exch{" C2* NTU"}=" C2' NTU";
$resn_exch{" S1* NTU"}=" S1' NTU"; $resn_exch{" C1* NTU"}=" C1' NTU"; $resn_exch{" C4* NTU"}=" C4' NTU";
$resn_exch{" S2* NTU"}=" S2' NTU"; $resn_exch{" C3* NTU"}=" C3' NTU"; $resn_exch{" C1* NUP"}=" C1' NUP";
$resn_exch{" O4* NUP"}=" O4' NUP"; $resn_exch{" C2* NUP"}=" C2' NUP"; $resn_exch{" O2* NUP"}=" O2' NUP";
$resn_exch{" C3* NUP"}=" C3' NUP"; $resn_exch{" O3* NUP"}=" O3' NUP"; $resn_exch{" C4* NUP"}=" C4' NUP";
$resn_exch{" C5* NUP"}=" C5' NUP"; $resn_exch{" O5* NUP"}=" O5' NUP"; $resn_exch{" OXT NYC"}=" OXY NYC";
$resn_exch{" O4* NYM"}=" O4' NYM"; $resn_exch{" N3* NYM"}=" N3' NYM"; $resn_exch{" C1* NYM"}=" C1' NYM";
$resn_exch{" C2* NYM"}=" C2' NYM"; $resn_exch{" C3* NYM"}=" C3' NYM"; $resn_exch{" C4* NYM"}=" C4' NYM";
$resn_exch{" O5* NYM"}=" O5' NYM"; $resn_exch{" C5* NYM"}=" C5' NYM"; $resn_exch{"AOP1 NZQ"}=" O1X NZQ";
$resn_exch{"AP2* NZQ"}=" P2B NZQ"; $resn_exch{"AOP2 NZQ"}=" O2X NZQ"; $resn_exch{"AOP3 NZQ"}=" O3X NZQ";
$resn_exch{"AO2* NZQ"}=" O2B NZQ"; $resn_exch{"AC2* NZQ"}=" C2B NZQ"; $resn_exch{"AC3* NZQ"}=" C3B NZQ";
$resn_exch{"AO3* NZQ"}=" O3B NZQ"; $resn_exch{"AC1* NZQ"}=" C1B NZQ"; $resn_exch{" AN9 NZQ"}=" N9A NZQ";
$resn_exch{" AC8 NZQ"}=" C8A NZQ"; $resn_exch{" AN7 NZQ"}=" N7A NZQ"; $resn_exch{" AC5 NZQ"}=" C5A NZQ";
$resn_exch{" AC4 NZQ"}=" C4A NZQ"; $resn_exch{" AN3 NZQ"}=" N3A NZQ"; $resn_exch{" AC2 NZQ"}=" C2A NZQ";
$resn_exch{" AN1 NZQ"}=" N1A NZQ"; $resn_exch{" AC6 NZQ"}=" C6A NZQ"; $resn_exch{" AN6 NZQ"}=" N6A NZQ";
$resn_exch{"AO4* NZQ"}=" O4B NZQ"; $resn_exch{"AC4* NZQ"}=" C4B NZQ"; $resn_exch{"AC5* NZQ"}=" C5B NZQ";
$resn_exch{"AO5* NZQ"}=" O5B NZQ"; $resn_exch{" AP  NZQ"}=" PA  NZQ"; $resn_exch{" AO1 NZQ"}=" O1A NZQ";
$resn_exch{" AO2 NZQ"}=" O2A NZQ"; $resn_exch{" NP  NZQ"}=" PN  NZQ"; $resn_exch{" NO1 NZQ"}=" O1N NZQ";
$resn_exch{" NO2 NZQ"}=" O2N NZQ"; $resn_exch{"NO5* NZQ"}=" O5D NZQ"; $resn_exch{"NC5* NZQ"}=" C5D NZQ";
$resn_exch{"NC4* NZQ"}=" C4D NZQ"; $resn_exch{"NO4* NZQ"}=" O4D NZQ"; $resn_exch{"NC1* NZQ"}=" C1D NZQ";
$resn_exch{"NC2* NZQ"}=" C2D NZQ"; $resn_exch{"NO2* NZQ"}=" O2D NZQ"; $resn_exch{"NC3* NZQ"}=" C3D NZQ";
$resn_exch{"NO3* NZQ"}=" O3D NZQ"; $resn_exch{" NN1 NZQ"}=" N1N NZQ"; $resn_exch{" NC2 NZQ"}=" C2N NZQ";
$resn_exch{" NC3 NZQ"}=" C3N NZQ"; $resn_exch{" NC7 NZQ"}=" C7N NZQ"; $resn_exch{" NN7 NZQ"}=" N7N NZQ";
$resn_exch{" NO7 NZQ"}=" O7N NZQ"; $resn_exch{" NC4 NZQ"}=" C4N NZQ"; $resn_exch{" NC5 NZQ"}=" C5N NZQ";
$resn_exch{" NO5 NZQ"}=" O5N NZQ"; $resn_exch{" NC6 NZQ"}=" C6N NZQ"; $resn_exch{" NO6 NZQ"}=" O6N NZQ";
$resn_exch{" O5* O2C"}=" O5' O2C"; $resn_exch{" C5* O2C"}=" C5' O2C"; $resn_exch{" C4* O2C"}=" C4' O2C";
$resn_exch{" O4* O2C"}=" O4' O2C"; $resn_exch{" C1* O2C"}=" C1' O2C"; $resn_exch{" C2* O2C"}=" C2' O2C";
$resn_exch{" O2* O2C"}=" O2' O2C"; $resn_exch{" C3* O2C"}=" C3' O2C"; $resn_exch{" O5* OAD"}=" O5' OAD";
$resn_exch{" C5* OAD"}=" C5' OAD"; $resn_exch{" C4* OAD"}=" C4' OAD"; $resn_exch{" O4* OAD"}=" O4' OAD";
$resn_exch{" C3* OAD"}=" C3' OAD"; $resn_exch{" O3* OAD"}=" O3' OAD"; $resn_exch{" C2* OAD"}=" C2' OAD";
$resn_exch{" O2* OAD"}=" O2' OAD"; $resn_exch{" C1* OAD"}=" C1' OAD"; $resn_exch{"RO2* OAD"}=" O2D OAD";
$resn_exch{"RO5* OAD"}=" O5D OAD"; $resn_exch{"RC5* OAD"}=" C5D OAD"; $resn_exch{"RC4* OAD"}=" C4D OAD";
$resn_exch{"RO4* OAD"}=" O4D OAD"; $resn_exch{"RC3* OAD"}=" C3D OAD"; $resn_exch{"RO3* OAD"}=" O3D OAD";
$resn_exch{"RC2* OAD"}=" C2D OAD"; $resn_exch{"RC1* OAD"}=" C1D OAD"; $resn_exch{"RO1* OAD"}=" O1D OAD";
$resn_exch{"RC6* OAD"}=" C6D OAD"; $resn_exch{"RO6* OAD"}=" O6D OAD"; $resn_exch{"RC7* OAD"}=" C7D OAD";
$resn_exch{"CX10 OBP"}=" CXA OBP"; $resn_exch{"CX11 OBP"}=" CXB OBP"; $resn_exch{"CX12 OBP"}=" CXC OBP";
$resn_exch{"AOP1 ODP"}=" O1X ODP"; $resn_exch{"AP2* ODP"}=" P2B ODP"; $resn_exch{"AOP2 ODP"}=" O2X ODP";
$resn_exch{"AOP3 ODP"}=" O3X ODP"; $resn_exch{"AO2* ODP"}=" O2B ODP"; $resn_exch{"AC2* ODP"}=" C2B ODP";
$resn_exch{"AC3* ODP"}=" C3B ODP"; $resn_exch{"AO3* ODP"}=" O3B ODP"; $resn_exch{"AC1* ODP"}=" C1B ODP";
$resn_exch{" AN9 ODP"}=" N9A ODP"; $resn_exch{" AC8 ODP"}=" C8A ODP"; $resn_exch{" AN7 ODP"}=" N7A ODP";
$resn_exch{" AC5 ODP"}=" C5A ODP"; $resn_exch{" AC4 ODP"}=" C4A ODP"; $resn_exch{" AN3 ODP"}=" N3A ODP";
$resn_exch{" AC2 ODP"}=" C2A ODP"; $resn_exch{" AN1 ODP"}=" N1A ODP"; $resn_exch{" AC6 ODP"}=" C6A ODP";
$resn_exch{" AN6 ODP"}=" N6A ODP"; $resn_exch{"AO4* ODP"}=" O4B ODP"; $resn_exch{"AC4* ODP"}=" C4B ODP";
$resn_exch{"AC5* ODP"}=" C5B ODP"; $resn_exch{"AO5* ODP"}=" O5B ODP"; $resn_exch{" AP  ODP"}=" PA  ODP";
$resn_exch{" AO1 ODP"}=" O1A ODP"; $resn_exch{" AO2 ODP"}=" O2A ODP"; $resn_exch{" NP  ODP"}=" PN  ODP";
$resn_exch{" NO1 ODP"}=" O1N ODP"; $resn_exch{" NO2 ODP"}=" O2N ODP"; $resn_exch{"NO5* ODP"}=" O5D ODP";
$resn_exch{"NC5* ODP"}=" C5D ODP"; $resn_exch{"NC4* ODP"}=" C4D ODP"; $resn_exch{"NO4* ODP"}=" O4D ODP";
$resn_exch{"NC1* ODP"}=" C1D ODP"; $resn_exch{"NC2* ODP"}=" C2D ODP"; $resn_exch{"NO2* ODP"}=" O2D ODP";
$resn_exch{"NC3* ODP"}=" C3D ODP"; $resn_exch{"NO3* ODP"}=" O3D ODP"; $resn_exch{" NN1 ODP"}=" N1N ODP";
$resn_exch{" NC2 ODP"}=" C2N ODP"; $resn_exch{" NC3 ODP"}=" C3N ODP"; $resn_exch{" NC7 ODP"}=" C7N ODP";
$resn_exch{" NN7 ODP"}=" N7N ODP"; $resn_exch{" NO7 ODP"}=" O7N ODP"; $resn_exch{" NC4 ODP"}=" C4N ODP";
$resn_exch{" NC5 ODP"}=" C5N ODP"; $resn_exch{" NC6 ODP"}=" C6N ODP"; $resn_exch{" O1P OIP"}=" OP1 OIP";
$resn_exch{" O2P OIP"}=" OP2 OIP"; $resn_exch{" O3P OIP"}=" OP3 OIP"; $resn_exch{" O5* OIP"}=" O5' OIP";
$resn_exch{" C5* OIP"}=" C5' OIP"; $resn_exch{" C4* OIP"}=" C4' OIP"; $resn_exch{" O4* OIP"}=" O4' OIP";
$resn_exch{" C3* OIP"}=" C3' OIP"; $resn_exch{" O3* OIP"}=" O3' OIP"; $resn_exch{" C2* OIP"}=" C2' OIP";
$resn_exch{" C1* OIP"}=" C1' OIP"; $resn_exch{" O6* OLU"}=" O6' OLU"; $resn_exch{" C4* OLU"}=" C4' OLU";
$resn_exch{" N3* OLU"}=" N3' OLU"; $resn_exch{" C2* OLU"}=" C2' OLU"; $resn_exch{" S1* OLU"}=" S1' OLU";
$resn_exch{" C5* OLU"}=" C5' OLU"; $resn_exch{" C1* OMC"}=" C1' OMC"; $resn_exch{" C2* OMC"}=" C2' OMC";
$resn_exch{" O2* OMC"}=" O2' OMC"; $resn_exch{" C3* OMC"}=" C3' OMC"; $resn_exch{" C4* OMC"}=" C4' OMC";
$resn_exch{" O4* OMC"}=" O4' OMC"; $resn_exch{" O3* OMC"}=" O3' OMC"; $resn_exch{" C5* OMC"}=" C5' OMC";
$resn_exch{" O5* OMC"}=" O5' OMC"; $resn_exch{" O1P OMC"}=" OP1 OMC"; $resn_exch{" O2P OMC"}=" OP2 OMC";
$resn_exch{" O3P OMC"}=" OP3 OMC"; $resn_exch{" O1P OMG"}=" OP1 OMG"; $resn_exch{" O2P OMG"}=" OP2 OMG";
$resn_exch{" O3P OMG"}=" OP3 OMG"; $resn_exch{" O5* OMG"}=" O5' OMG"; $resn_exch{" C5* OMG"}=" C5' OMG";
$resn_exch{" C4* OMG"}=" C4' OMG"; $resn_exch{" O4* OMG"}=" O4' OMG"; $resn_exch{" C3* OMG"}=" C3' OMG";
$resn_exch{" O3* OMG"}=" O3' OMG"; $resn_exch{" C2* OMG"}=" C2' OMG"; $resn_exch{" O2* OMG"}=" O2' OMG";
$resn_exch{" C1* OMG"}=" C1' OMG"; $resn_exch{" O5* OMP"}=" O5' OMP"; $resn_exch{" C5* OMP"}=" C5' OMP";
$resn_exch{" C4* OMP"}=" C4' OMP"; $resn_exch{" O4* OMP"}=" O4' OMP"; $resn_exch{" C3* OMP"}=" C3' OMP";
$resn_exch{" O3* OMP"}=" O3' OMP"; $resn_exch{" C2* OMP"}=" C2' OMP"; $resn_exch{" O2* OMP"}=" O2' OMP";
$resn_exch{" C1* OMP"}=" C1' OMP"; $resn_exch{" C1* OMU"}=" C1' OMU"; $resn_exch{" C2* OMU"}=" C2' OMU";
$resn_exch{" O2* OMU"}=" O2' OMU"; $resn_exch{" C3* OMU"}=" C3' OMU"; $resn_exch{" C4* OMU"}=" C4' OMU";
$resn_exch{" O3* OMU"}=" O3' OMU"; $resn_exch{" O4* OMU"}=" O4' OMU"; $resn_exch{" C5* OMU"}=" C5' OMU";
$resn_exch{" O5* OMU"}=" O5' OMU"; $resn_exch{" O1P OMU"}=" OP1 OMU"; $resn_exch{" O2P OMU"}=" OP2 OMU";
$resn_exch{" O3P OMU"}=" OP3 OMU"; $resn_exch{" O3* ONA"}=" O3' ONA"; $resn_exch{" C3* ONA"}=" C3' ONA";
$resn_exch{" C2* ONA"}=" C2' ONA"; $resn_exch{" O2* ONA"}=" O2' ONA"; $resn_exch{" C4* ONA"}=" C4' ONA";
$resn_exch{" C5* ONA"}=" C5' ONA"; $resn_exch{" O5* ONA"}=" O5' ONA"; $resn_exch{" O4* ONA"}=" O4' ONA";
$resn_exch{" C1* ONA"}=" C1' ONA"; $resn_exch{" O3P ONE"}=" OP3 ONE"; $resn_exch{" O1P ONE"}=" OP1 ONE";
$resn_exch{" O2P ONE"}=" OP2 ONE"; $resn_exch{" O5* ONE"}=" O5' ONE"; $resn_exch{" C5* ONE"}=" C5' ONE";
$resn_exch{" C4* ONE"}=" C4' ONE"; $resn_exch{" O4* ONE"}=" O4' ONE"; $resn_exch{" C3* ONE"}=" C3' ONE";
$resn_exch{" C2* ONE"}=" C2' ONE"; $resn_exch{" O2* ONE"}=" O2' ONE"; $resn_exch{" O3* ONE"}=" O3' ONE";
$resn_exch{" C1* ONE"}=" C1' ONE"; $resn_exch{" O3* ONM"}=" O3' ONM"; $resn_exch{" C3* ONM"}=" C3' ONM";
$resn_exch{" C2* ONM"}=" C2' ONM"; $resn_exch{" O2* ONM"}=" O2' ONM"; $resn_exch{" C4* ONM"}=" C4' ONM";
$resn_exch{" C5* ONM"}=" C5' ONM"; $resn_exch{" O5* ONM"}=" O5' ONM"; $resn_exch{" O4* ONM"}=" O4' ONM";
$resn_exch{" C1* ONM"}=" C1' ONM"; $resn_exch{" C1* OR5"}=" C1' OR5"; $resn_exch{" O1* OR5"}=" O1' OR5";
$resn_exch{" C2* OR5"}=" C2' OR5"; $resn_exch{" O2* OR5"}=" O2' OR5"; $resn_exch{" C3* OR5"}=" C3' OR5";
$resn_exch{" O3* OR5"}=" O3' OR5"; $resn_exch{" C4* OR5"}=" C4' OR5"; $resn_exch{" O4* OR5"}=" O4' OR5";
$resn_exch{" C5* OR5"}=" C5' OR5"; $resn_exch{" O5* OR5"}=" O5' OR5"; $resn_exch{" C1* OTG"}=" C1' OTG";
$resn_exch{" C2* OTG"}=" C2' OTG"; $resn_exch{" C3* OTG"}=" C3' OTG"; $resn_exch{" C4* OTG"}=" C4' OTG";
$resn_exch{" C5* OTG"}=" C5' OTG"; $resn_exch{" C6* OTG"}=" C6' OTG"; $resn_exch{" C7* OTG"}=" C7' OTG";
$resn_exch{" C8* OTG"}=" C8' OTG"; $resn_exch{" O8* OTG"}=" O8' OTG"; $resn_exch{" P3* OXT"}=" P3' OXT";
$resn_exch{" O3* OXT"}=" O3' OXT"; $resn_exch{" C3* OXT"}=" C3' OXT"; $resn_exch{" C2* OXT"}=" C2' OXT";
$resn_exch{" O2* OXT"}=" O2' OXT"; $resn_exch{" C1* OXT"}=" C1' OXT"; $resn_exch{" O4* OXT"}=" O4' OXT";
$resn_exch{" C4* OXT"}=" C4' OXT"; $resn_exch{" C5* OXT"}=" C5' OXT"; $resn_exch{" O5* OXT"}=" O5' OXT";
$resn_exch{" O4  OXX"}=" OXT OXX"; $resn_exch{" O1P   P"}=" OP1   P"; $resn_exch{" O2P   P"}=" OP2   P";
$resn_exch{" O3P   P"}=" OP3   P"; $resn_exch{" O1P P1P"}=" OP1 P1P"; $resn_exch{" O2P P1P"}=" OP2 P1P";
$resn_exch{" O5* P1P"}=" O5' P1P"; $resn_exch{" C5* P1P"}=" C5' P1P"; $resn_exch{" C4* P1P"}=" C4' P1P";
$resn_exch{" C3* P1P"}=" C3' P1P"; $resn_exch{" O3* P1P"}=" O3' P1P"; $resn_exch{" O6* P2P"}=" O6' P2P";
$resn_exch{" C5* P2P"}=" C5' P2P"; $resn_exch{" C4* P2P"}=" C4' P2P"; $resn_exch{" O5* P2P"}=" O5' P2P";
$resn_exch{" C3* P2P"}=" C3' P2P"; $resn_exch{" O3* P2P"}=" O3' P2P"; $resn_exch{" C2* P2P"}=" C2' P2P";
$resn_exch{" O2* P2P"}=" O2' P2P"; $resn_exch{" C1* P2P"}=" C1' P2P"; $resn_exch{" O1P P2T"}=" OP1 P2T";
$resn_exch{" O2P P2T"}=" OP2 P2T"; $resn_exch{" O5* P2T"}=" O5' P2T"; $resn_exch{" C5* P2T"}=" C5' P2T";
$resn_exch{" C4* P2T"}=" C4' P2T"; $resn_exch{" O4* P2T"}=" O4' P2T"; $resn_exch{" C1* P2T"}=" C1' P2T";
$resn_exch{" C2* P2T"}=" C2' P2T"; $resn_exch{" O2* P2T"}=" O2' P2T"; $resn_exch{" C3* P2T"}=" C3' P2T";
$resn_exch{" O3* P2T"}=" O3' P2T"; $resn_exch{" O3P P2T"}=" OP3 P2T"; $resn_exch{" C1* P2U"}=" C1' P2U";
$resn_exch{" C2* P2U"}=" C2' P2U"; $resn_exch{" C3* P2U"}=" C3' P2U"; $resn_exch{" C4* P2U"}=" C4' P2U";
$resn_exch{" O3* P2U"}=" O3' P2U"; $resn_exch{" O4* P2U"}=" O4' P2U"; $resn_exch{" C5* P2U"}=" C5' P2U";
$resn_exch{" O5* P2U"}=" O5' P2U"; $resn_exch{" O1P P2U"}=" OP1 P2U"; $resn_exch{" O2P P2U"}=" OP2 P2U";
$resn_exch{" O3P P2U"}=" OP3 P2U"; $resn_exch{" O5* P5A"}=" O5' P5A"; $resn_exch{" C5* P5A"}=" C5' P5A";
$resn_exch{" C4* P5A"}=" C4' P5A"; $resn_exch{" O4* P5A"}=" O4' P5A"; $resn_exch{" C1* P5A"}=" C1' P5A";
$resn_exch{" C2* P5A"}=" C2' P5A"; $resn_exch{" O2* P5A"}=" O2' P5A"; $resn_exch{" C3* P5A"}=" C3' P5A";
$resn_exch{" O3* P5A"}=" O3' P5A"; $resn_exch{" O1P P5P"}=" OP1 P5P"; $resn_exch{" O2P P5P"}=" OP2 P5P";
$resn_exch{" O3P P5P"}=" OP3 P5P"; $resn_exch{" C5* PA7"}=" C5' PA7"; $resn_exch{" O5* PA7"}=" O5' PA7";
$resn_exch{" N5* PA7"}=" N5' PA7"; $resn_exch{" C4* PA7"}=" C4' PA7"; $resn_exch{" O4* PA7"}=" O4' PA7";
$resn_exch{" C3* PA7"}=" C3' PA7"; $resn_exch{" O3* PA7"}=" O3' PA7"; $resn_exch{" C2* PA7"}=" C2' PA7";
$resn_exch{" O2* PA7"}=" O2' PA7"; $resn_exch{" C1* PA7"}=" C1' PA7"; $resn_exch{" AP  PAD"}=" PA  PAD";
$resn_exch{" AO1 PAD"}=" O1A PAD"; $resn_exch{" AO2 PAD"}=" O2A PAD"; $resn_exch{"AO5* PAD"}=" O5B PAD";
$resn_exch{"AC5* PAD"}=" C5B PAD"; $resn_exch{"AC4* PAD"}=" C4B PAD"; $resn_exch{"AO4* PAD"}=" O4B PAD";
$resn_exch{"AC3* PAD"}=" C3B PAD"; $resn_exch{"AO3* PAD"}=" O3B PAD"; $resn_exch{"AC2* PAD"}=" C2B PAD";
$resn_exch{"AO2* PAD"}=" O2B PAD"; $resn_exch{"AC1* PAD"}=" C1B PAD"; $resn_exch{" AN9 PAD"}=" N9A PAD";
$resn_exch{" AC8 PAD"}=" C8A PAD"; $resn_exch{" AN7 PAD"}=" N7A PAD"; $resn_exch{" AC5 PAD"}=" C5A PAD";
$resn_exch{" AC6 PAD"}=" C6A PAD"; $resn_exch{" AN6 PAD"}=" N6A PAD"; $resn_exch{" AN1 PAD"}=" N1A PAD";
$resn_exch{" AC2 PAD"}=" C2A PAD"; $resn_exch{" AN3 PAD"}=" N3A PAD"; $resn_exch{" AC4 PAD"}=" C4A PAD";
$resn_exch{" NP  PAD"}=" PN  PAD"; $resn_exch{" NO1 PAD"}=" O1N PAD"; $resn_exch{" NO2 PAD"}=" O2N PAD";
$resn_exch{"NO5* PAD"}=" O5D PAD"; $resn_exch{"NC5* PAD"}=" C5D PAD"; $resn_exch{"NC4* PAD"}=" C4D PAD";
$resn_exch{"NO4* PAD"}=" O4D PAD"; $resn_exch{"NC3* PAD"}=" C3D PAD"; $resn_exch{"NO3* PAD"}=" O3D PAD";
$resn_exch{"NC2* PAD"}=" C2D PAD"; $resn_exch{"NO2* PAD"}=" O2D PAD"; $resn_exch{"NC1* PAD"}=" C1D PAD";
$resn_exch{" NC1 PAD"}=" C1N PAD"; $resn_exch{" NN2 PAD"}=" N2N PAD"; $resn_exch{" NC3 PAD"}=" C3N PAD";
$resn_exch{" NC7 PAD"}=" C7N PAD"; $resn_exch{" NO7 PAD"}=" O7N PAD"; $resn_exch{" NN7 PAD"}=" N7N PAD";
$resn_exch{" NC4 PAD"}=" C4N PAD"; $resn_exch{" NC5 PAD"}=" C5N PAD"; $resn_exch{" NC6 PAD"}=" C6N PAD";
$resn_exch{" O5* PAJ"}=" O5' PAJ"; $resn_exch{" C5* PAJ"}=" C5' PAJ"; $resn_exch{" C4* PAJ"}=" C4' PAJ";
$resn_exch{" O4* PAJ"}=" O4' PAJ"; $resn_exch{" C3* PAJ"}=" C3' PAJ"; $resn_exch{" O3* PAJ"}=" O3' PAJ";
$resn_exch{" C2* PAJ"}=" C2' PAJ"; $resn_exch{" O2* PAJ"}=" O2' PAJ"; $resn_exch{" C1* PAJ"}=" C1' PAJ";
$resn_exch{" O5* PAP"}=" O5' PAP"; $resn_exch{" C5* PAP"}=" C5' PAP"; $resn_exch{" C4* PAP"}=" C4' PAP";
$resn_exch{" O4* PAP"}=" O4' PAP"; $resn_exch{" C3* PAP"}=" C3' PAP"; $resn_exch{" O3* PAP"}=" O3' PAP";
$resn_exch{" C2* PAP"}=" C2' PAP"; $resn_exch{" O2* PAP"}=" O2' PAP"; $resn_exch{" C1* PAP"}=" C1' PAP";
$resn_exch{" O5* PAU"}=" O5' PAU"; $resn_exch{" O6* PAU"}=" O6' PAU"; $resn_exch{" O5* PAX"}=" O5' PAX";
$resn_exch{" C5* PAX"}=" C5' PAX"; $resn_exch{" C4* PAX"}=" C4' PAX"; $resn_exch{" O4* PAX"}=" O4' PAX";
$resn_exch{" C1* PAX"}=" C1' PAX"; $resn_exch{" C2* PAX"}=" C2' PAX"; $resn_exch{" O2* PAX"}=" O2' PAX";
$resn_exch{" C3* PAX"}=" C3' PAX"; $resn_exch{" O3* PAX"}=" O3' PAX"; $resn_exch{" N1* PBO"}=" N1' PBO";
$resn_exch{" O5* PBT"}=" O5' PBT"; $resn_exch{" C5* PBT"}=" C5' PBT"; $resn_exch{" C4* PBT"}=" C4' PBT";
$resn_exch{" O4* PBT"}=" O4' PBT"; $resn_exch{" C3* PBT"}=" C3' PBT"; $resn_exch{" O3* PBT"}=" O3' PBT";
$resn_exch{" C2* PBT"}=" C2' PBT"; $resn_exch{" C1* PBT"}=" C1' PBT"; $resn_exch{"1C22 PC3"}=" CX5 PC3";
$resn_exch{" C1* PCD"}=" C1' PCD"; $resn_exch{" C2* PCD"}=" C2D PCD"; $resn_exch{" O2* PCD"}=" O2' PCD";
$resn_exch{" C3* PCD"}=" C3' PCD"; $resn_exch{" C4* PCD"}=" C4D PCD"; $resn_exch{" O4* PCD"}=" O4D PCD";
$resn_exch{" O3* PCD"}=" O3' PCD"; $resn_exch{" C5* PCD"}=" C5' PCD"; $resn_exch{" O5* PCD"}=" O5' PCD";
$resn_exch{" O5* PCG"}=" O5' PCG"; $resn_exch{" C5* PCG"}=" C5' PCG"; $resn_exch{" C4* PCG"}=" C4' PCG";
$resn_exch{" O4* PCG"}=" O4' PCG"; $resn_exch{" C3* PCG"}=" C3' PCG"; $resn_exch{" O3* PCG"}=" O3' PCG";
$resn_exch{" C2* PCG"}=" C2' PCG"; $resn_exch{" O2* PCG"}=" O2' PCG"; $resn_exch{" C1* PCG"}=" C1' PCG";
$resn_exch{" N_A PCU"}=" NA  PCU"; $resn_exch{" N_B PCU"}=" NB  PCU"; $resn_exch{" N_C PCU"}=" NC  PCU";
$resn_exch{" N_D PCU"}=" ND  PCU"; $resn_exch{" O\"  PD7"}=" O'' PD7"; $resn_exch{" C\"  PD7"}=" C'' PD7";
$resn_exch{"C1\"  PD7"}="C1'' PD7"; $resn_exch{"C2\"  PD7"}="C2'' PD7"; $resn_exch{"C3\"  PD7"}="C3'' PD7";
$resn_exch{"C4\"  PD7"}="C4'' PD7"; $resn_exch{"C5\"  PD7"}="C5'' PD7"; $resn_exch{"C6\"  PD7"}="C6'' PD7";
$resn_exch{" O3P PDU"}=" OP3 PDU"; $resn_exch{" O1P PDU"}=" OP1 PDU"; $resn_exch{" O2P PDU"}=" OP2 PDU";
$resn_exch{" O5* PDU"}=" O5' PDU"; $resn_exch{" C5* PDU"}=" C5' PDU"; $resn_exch{" C4* PDU"}=" C4' PDU";
$resn_exch{" O4* PDU"}=" O4' PDU"; $resn_exch{" C3* PDU"}=" C3' PDU"; $resn_exch{" O3* PDU"}=" O3' PDU";
$resn_exch{" C2* PDU"}=" C2' PDU"; $resn_exch{" C1* PDU"}=" C1' PDU"; $resn_exch{"O1S* PDX"}=" O1X PDX";
$resn_exch{"O2S* PDX"}=" O2X PDX"; $resn_exch{"O3S* PDX"}=" O3X PDX"; $resn_exch{" S*  PDX"}=" S'  PDX";
$resn_exch{" C4* PE2"}=" C4' PE2"; $resn_exch{" O4* PE2"}=" O4' PE2"; $resn_exch{" C3* PE2"}=" C3' PE2";
$resn_exch{" O3* PE2"}=" O3' PE2"; $resn_exch{" C2* PE2"}=" C2' PE2"; $resn_exch{" C1* PE2"}=" C1' PE2";
$resn_exch{"1OP  PE6"}=" OP1 PE6"; $resn_exch{"2OP  PE6"}=" OP2 PE6"; $resn_exch{"3OP  PE6"}=" OP3 PE6";
$resn_exch{" O5* PED"}=" O5' PED"; $resn_exch{" C2* PED"}=" C2' PED"; $resn_exch{" C5* PED"}=" C5' PED";
$resn_exch{" C4* PED"}=" C4' PED"; $resn_exch{" O4* PED"}=" O4' PED"; $resn_exch{" C3* PED"}=" C3' PED";
$resn_exch{" C1* PED"}=" C1' PED"; $resn_exch{" O3* PED"}=" O3' PED"; $resn_exch{" C1* PEL"}=" C1' PEL";
$resn_exch{" C2* PEL"}=" C2' PEL"; $resn_exch{" C3* PEL"}=" C3' PEL"; $resn_exch{" C4* PEL"}=" C4' PEL";
$resn_exch{" C5* PEL"}=" C5' PEL"; $resn_exch{" C6* PEL"}=" C6' PEL"; $resn_exch{" O1  PG1"}=" OXT PG1";
$resn_exch{" O1P PG7"}=" OP1 PG7"; $resn_exch{" O2P PG7"}=" OP2 PG7"; $resn_exch{" O5* PG7"}=" O5' PG7";
$resn_exch{" O3* PG7"}=" O3' PG7"; $resn_exch{" C1* PG7"}=" C1' PG7"; $resn_exch{" C2* PG7"}=" C2' PG7";
$resn_exch{" C3* PG7"}=" C3' PG7"; $resn_exch{" C4* PG7"}=" C4' PG7"; $resn_exch{" C5* PG7"}=" C5' PG7";
$resn_exch{" O4* PG7"}=" O4' PG7"; $resn_exch{" O3P PG7"}=" OP3 PG7"; $resn_exch{" O1P PGN"}=" OP1 PGN";
$resn_exch{" O2P PGN"}=" OP2 PGN"; $resn_exch{" O3P PGN"}=" OP3 PGN"; $resn_exch{" O5* PGN"}=" O5' PGN";
$resn_exch{" C5* PGN"}=" C5' PGN"; $resn_exch{" C4* PGN"}=" C4' PGN"; $resn_exch{" O4* PGN"}=" O4' PGN";
$resn_exch{" C3* PGN"}=" C3' PGN"; $resn_exch{" O3* PGN"}=" O3' PGN"; $resn_exch{" C2* PGN"}=" C2' PGN";
$resn_exch{" C1* PGN"}=" C1' PGN"; $resn_exch{" O1P PGP"}=" OP1 PGP"; $resn_exch{" O2P PGP"}=" OP2 PGP";
$resn_exch{" O3P PGP"}=" OP3 PGP"; $resn_exch{" O5* PGP"}=" O5' PGP"; $resn_exch{" C5* PGP"}=" C5' PGP";
$resn_exch{" C4* PGP"}=" C4' PGP"; $resn_exch{" O4* PGP"}=" O4' PGP"; $resn_exch{" C3* PGP"}=" C3' PGP";
$resn_exch{" O3* PGP"}=" O3' PGP"; $resn_exch{" C2* PGP"}=" C2' PGP"; $resn_exch{" O2* PGP"}=" O2' PGP";
$resn_exch{" C1* PGP"}=" C1' PGP"; $resn_exch{" O5* PGS"}=" O5' PGS"; $resn_exch{" C5* PGS"}=" C5' PGS";
$resn_exch{" C4* PGS"}=" C4' PGS"; $resn_exch{" O4* PGS"}=" O4' PGS"; $resn_exch{" C3* PGS"}=" C3' PGS";
$resn_exch{" O3* PGS"}=" O3' PGS"; $resn_exch{" C2* PGS"}=" C2' PGS"; $resn_exch{" O2* PGS"}=" O2' PGS";
$resn_exch{" C1* PGS"}=" C1' PGS"; $resn_exch{" C1  PGW"}=" CAD PGW"; $resn_exch{" O1  PGW"}=" OAE PGW";
$resn_exch{" O2  PGW"}=" OAF PGW"; $resn_exch{" P1  PGW"}=" P   PGW"; $resn_exch{" C2  PGW"}=" C01 PGW";
$resn_exch{" C3  PGW"}=" C1  PGW"; $resn_exch{" O3  PGW"}=" O01 PGW"; $resn_exch{" C4  PGW"}=" C02 PGW";
$resn_exch{" C5  PGW"}=" C2  PGW"; $resn_exch{" O4  PGW"}=" O02 PGW"; $resn_exch{" C6  PGW"}=" C03 PGW";
$resn_exch{" C7  PGW"}=" C3  PGW"; $resn_exch{" O5  PGW"}=" O03 PGW"; $resn_exch{" C8  PGW"}=" C04 PGW";
$resn_exch{" C9  PGW"}=" C4  PGW"; $resn_exch{" O6  PGW"}=" O04 PGW"; $resn_exch{" C10 PGW"}=" C05 PGW";
$resn_exch{" C11 PGW"}=" C5  PGW"; $resn_exch{" C12 PGW"}=" C06 PGW"; $resn_exch{" C13 PGW"}=" C6  PGW";
$resn_exch{" C14 PGW"}=" C07 PGW"; $resn_exch{" C15 PGW"}=" C7  PGW"; $resn_exch{" C16 PGW"}=" C08 PGW";
$resn_exch{" C17 PGW"}=" C8  PGW"; $resn_exch{" C18 PGW"}=" C09 PGW"; $resn_exch{" C19 PGW"}=" C9  PGW";
$resn_exch{" C20 PGW"}=" C10 PGW"; $resn_exch{" C21 PGW"}=" C11 PGW"; $resn_exch{" O7  PGW"}=" O11 PGW";
$resn_exch{" C22 PGW"}=" C12 PGW"; $resn_exch{" O8  PGW"}=" O12 PGW"; $resn_exch{" C23 PGW"}=" C13 PGW";
$resn_exch{" O9  PGW"}=" O13 PGW"; $resn_exch{" C24 PGW"}=" C14 PGW"; $resn_exch{" O10 PGW"}=" O14 PGW";
$resn_exch{" C25 PGW"}=" C15 PGW"; $resn_exch{" C26 PGW"}=" C16 PGW"; $resn_exch{" C27 PGW"}=" C17 PGW";
$resn_exch{" C28 PGW"}=" C18 PGW"; $resn_exch{" C29 PGW"}=" C19 PGW"; $resn_exch{" C30 PGW"}=" C20 PGW";
$resn_exch{" C31 PGW"}=" C21 PGW"; $resn_exch{" C32 PGW"}=" C22 PGW"; $resn_exch{" C33 PGW"}=" C23 PGW";
$resn_exch{" C34 PGW"}=" C24 PGW"; $resn_exch{" C35 PGW"}=" C25 PGW"; $resn_exch{" C36 PGW"}=" C26 PGW";
$resn_exch{" C37 PGW"}=" C27 PGW"; $resn_exch{" C38 PGW"}=" C28 PGW"; $resn_exch{" C39 PGW"}=" C29 PGW";
$resn_exch{" C40 PGW"}=" C30 PGW"; $resn_exch{" N_A PHO"}=" NA  PHO"; $resn_exch{" N_B PHO"}=" NB  PHO";
$resn_exch{" N_C PHO"}=" NC  PHO"; $resn_exch{" N_D PHO"}=" ND  PHO"; $resn_exch{"1CD1 PHP"}=" CDB PHP";
$resn_exch{"2CD1 PHP"}=" CDL PHP"; $resn_exch{"1CE1 PHP"}=" CEB PHP"; $resn_exch{"2CE1 PHP"}=" CEL PHP";
$resn_exch{"1CG2 PHP"}=" CGL PHP"; $resn_exch{"2CG2 PHP"}=" CGM PHP"; $resn_exch{"1CD3 PHP"}=" CDD PHP";
$resn_exch{"2CD3 PHP"}=" CDN PHP"; $resn_exch{"1CE3 PHP"}=" CED PHP"; $resn_exch{"2CE3 PHP"}=" CEN PHP";
$resn_exch{"1CD4 PHP"}=" CDE PHP"; $resn_exch{"2CD4 PHP"}=" CDO PHP"; $resn_exch{"1CE4 PHP"}=" CEE PHP";
$resn_exch{"2CE4 PHP"}=" CEO PHP"; $resn_exch{"1CG5 PHP"}=" CGF PHP"; $resn_exch{"2CG5 PHP"}=" CGG PHP";
$resn_exch{"1CD6 PHP"}=" CDG PHP"; $resn_exch{"1CE6 PHP"}=" CEG PHP"; $resn_exch{"2CE6 PHP"}=" CEQ PHP";
$resn_exch{"2CD6 PHP"}=" CDQ PHP"; $resn_exch{"CR10 PII"}=" CRA PII"; $resn_exch{"CR11 PII"}=" CRB PII";
$resn_exch{"CR12 PII"}=" CRC PII"; $resn_exch{"CR13 PII"}=" CRD PII"; $resn_exch{"CR14 PII"}=" CRE PII";
$resn_exch{"CR15 PII"}=" CRF PII"; $resn_exch{"CR16 PII"}=" CRG PII"; $resn_exch{"CL10 PII"}=" CLA PII";
$resn_exch{"CL11 PII"}=" CLB PII"; $resn_exch{"CL12 PII"}=" CLC PII"; $resn_exch{"CL13 PII"}=" CLD PII";
$resn_exch{"CL14 PII"}=" CLE PII"; $resn_exch{"CL15 PII"}=" CLF PII"; $resn_exch{"'C10 PLC"}=" CA' PLC";
$resn_exch{"'C11 PLC"}=" CB' PLC"; $resn_exch{" C\"  PLC"}=" CB  PLC"; $resn_exch{" C1\" PLC"}=" C1B PLC";
$resn_exch{" C2\" PLC"}=" C2B PLC"; $resn_exch{" C3\" PLC"}=" C3B PLC"; $resn_exch{" C4\" PLC"}=" C4B PLC";
$resn_exch{" C5\" PLC"}=" C5B PLC"; $resn_exch{" C6\" PLC"}=" C6B PLC"; $resn_exch{" C7\" PLC"}=" C7B PLC";
$resn_exch{" C8\" PLC"}=" C8B PLC"; $resn_exch{" C9\" PLC"}=" C9B PLC"; $resn_exch{"\"C10 PLC"}=" CAA PLC";
$resn_exch{"\"C11 PLC"}=" CBA PLC"; $resn_exch{" O\"  PLC"}=" OB  PLC"; $resn_exch{"'C10 PLD"}=" CA' PLD";
$resn_exch{"'C11 PLD"}=" CB' PLD"; $resn_exch{" C\"  PLD"}=" CB  PLD"; $resn_exch{" C1\" PLD"}=" C1B PLD";
$resn_exch{" C2\" PLD"}=" C2B PLD"; $resn_exch{" C3\" PLD"}=" C3B PLD"; $resn_exch{" C4\" PLD"}=" C4B PLD";
$resn_exch{" C5\" PLD"}=" C5B PLD"; $resn_exch{" C6\" PLD"}=" C6B PLD"; $resn_exch{" C7\" PLD"}=" C7B PLD";
$resn_exch{" C8\" PLD"}=" C8B PLD"; $resn_exch{" C9\" PLD"}=" C9B PLD"; $resn_exch{"\"C10 PLD"}=" CAA PLD";
$resn_exch{"\"C11 PLD"}=" CBA PLD"; $resn_exch{" O\"  PLD"}=" OB  PLD"; $resn_exch{"'C12 PLD"}=" CC' PLD";
$resn_exch{"'C13 PLD"}=" CD' PLD"; $resn_exch{"'C14 PLD"}=" CE' PLD"; $resn_exch{"'C15 PLD"}=" CF' PLD";
$resn_exch{"'C16 PLD"}=" CG' PLD"; $resn_exch{"'C17 PLD"}=" CH' PLD"; $resn_exch{"'C18 PLD"}=" CI' PLD";
$resn_exch{"'C19 PLD"}=" CJ' PLD"; $resn_exch{"'C20 PLD"}=" CK' PLD"; $resn_exch{"\"C12 PLD"}=" CCA PLD";
$resn_exch{"\"C13 PLD"}=" CDA PLD"; $resn_exch{"\"C14 PLD"}=" CEA PLD"; $resn_exch{"\"C15 PLD"}=" CFA PLD";
$resn_exch{"\"C16 PLD"}=" CGA PLD"; $resn_exch{"\"C17 PLD"}=" CHA PLD"; $resn_exch{"\"C18 PLD"}=" CIA PLD";
$resn_exch{"\"C19 PLD"}=" CJA PLD"; $resn_exch{"\"C20 PLD"}=" CKA PLD"; $resn_exch{" O   PM3"}=" OXT PM3";
$resn_exch{" OXT PM3"}=" O   PM3"; $resn_exch{" C2* PMD"}=" C2B PMD"; $resn_exch{" C4* PMD"}=" C4B PMD";
$resn_exch{" C6* PMD"}=" C6B PMD"; $resn_exch{" C7* PMD"}=" C7B PMD"; $resn_exch{" C9* PMD"}=" C9B PMD";
$resn_exch{"'C10 PMD"}=" CA' PMD"; $resn_exch{"'C11 PMD"}=" CB' PMD"; $resn_exch{"'C12 PMD"}=" CC' PMD";
$resn_exch{" N1* PMD"}=" N1' PMD"; $resn_exch{" N2* PMD"}=" N2' PMD"; $resn_exch{" N3* PMD"}=" N3' PMD";
$resn_exch{" N4* PMD"}=" N4' PMD"; $resn_exch{" N5* PMD"}=" N5' PMD"; $resn_exch{" N8* PMD"}=" N8' PMD";
$resn_exch{" O5* PMO"}=" O5' PMO"; $resn_exch{" C5* PMO"}=" C5' PMO"; $resn_exch{" C4* PMO"}=" C4' PMO";
$resn_exch{" O4* PMO"}=" O4' PMO"; $resn_exch{" C3* PMO"}=" C3' PMO"; $resn_exch{" O3* PMO"}=" O3' PMO";
$resn_exch{" C2* PMO"}=" C2' PMO"; $resn_exch{" O2* PMO"}=" O2' PMO"; $resn_exch{" C1* PMO"}=" C1' PMO";
$resn_exch{"1OP' PMT"}=" O11 PMT"; $resn_exch{"3OP' PMT"}=" O12 PMT"; $resn_exch{"2OP' PMT"}=" O13 PMT";
$resn_exch{" O2P PMT"}=" OP2 PMT"; $resn_exch{" O1P PMT"}=" OP1 PMT"; $resn_exch{" O3P PMT"}=" OP3 PMT";
$resn_exch{" O5* PMT"}=" O5B PMT"; $resn_exch{" C5* PMT"}=" C5B PMT"; $resn_exch{" C4* PMT"}=" C4B PMT";
$resn_exch{" O4* PMT"}=" O4B PMT"; $resn_exch{" C3* PMT"}=" C3B PMT"; $resn_exch{" O3* PMT"}=" O3' PMT";
$resn_exch{" C2* PMT"}=" C2B PMT"; $resn_exch{" O2* PMT"}=" O2' PMT"; $resn_exch{" C1* PMT"}=" C1B PMT";
$resn_exch{" N_A PNI"}=" NA  PNI"; $resn_exch{" N_B PNI"}=" NB  PNI"; $resn_exch{" N_C PNI"}=" NC  PNI";
$resn_exch{" N_D PNI"}=" ND  PNI"; $resn_exch{"1C11 POH"}=" CX3 POH"; $resn_exch{"1C7  POH"}=" C71 POH";
$resn_exch{"1C8  POH"}=" C81 POH"; $resn_exch{"1C9  POH"}=" C91 POH"; $resn_exch{"1C13 POH"}=" CXN POH";
$resn_exch{"1C12 POH"}=" CXD POH"; $resn_exch{"1N10 POH"}=" NXT POH"; $resn_exch{" N_A POH"}=" NA  POH";
$resn_exch{" N_B POH"}=" NB  POH"; $resn_exch{" N_C POH"}=" NC  POH"; $resn_exch{" N_D POH"}=" ND  POH";
$resn_exch{"2C11 POH"}=" CX4 POH"; $resn_exch{"2C7  POH"}=" C72 POH"; $resn_exch{"2C8  POH"}=" C82 POH";
$resn_exch{"2C9  POH"}=" C92 POH"; $resn_exch{"2C13 POH"}=" CXO POH"; $resn_exch{"2C12 POH"}=" CXE POH";
$resn_exch{"2N10 POH"}=" NXU POH"; $resn_exch{"3C11 POH"}=" CX5 POH"; $resn_exch{"3C7  POH"}=" C73 POH";
$resn_exch{"3C8  POH"}=" C83 POH"; $resn_exch{"3C9  POH"}=" C93 POH"; $resn_exch{"3C13 POH"}=" CXP POH";
$resn_exch{"3C12 POH"}=" CXF POH"; $resn_exch{"3N10 POH"}=" NXV POH"; $resn_exch{"4C11 POH"}=" CX6 POH";
$resn_exch{"4C7  POH"}=" C74 POH"; $resn_exch{"4C8  POH"}=" C84 POH"; $resn_exch{"4C9  POH"}=" C94 POH";
$resn_exch{"4C13 POH"}=" CXQ POH"; $resn_exch{"4C12 POH"}=" CXG POH"; $resn_exch{"4N10 POH"}=" NXW POH";
$resn_exch{" N_A POR"}=" NA  POR"; $resn_exch{" N_B POR"}=" NB  POR"; $resn_exch{" N_C POR"}=" NC  POR";
$resn_exch{" N_D POR"}=" ND  POR"; $resn_exch{" N_A PP9"}=" NA  PP9"; $resn_exch{" N_B PP9"}=" NB  PP9";
$resn_exch{" N_C PP9"}=" NC  PP9"; $resn_exch{" N_D PP9"}=" ND  PP9"; $resn_exch{" O5* PPS"}=" O5' PPS";
$resn_exch{" C5* PPS"}=" C5' PPS"; $resn_exch{" C4* PPS"}=" C4' PPS"; $resn_exch{" O4* PPS"}=" O4' PPS";
$resn_exch{" C1* PPS"}=" C1' PPS"; $resn_exch{" C2* PPS"}=" C2' PPS"; $resn_exch{" O2* PPS"}=" O2' PPS";
$resn_exch{" C3* PPS"}=" C3' PPS"; $resn_exch{" O3* PPS"}=" O3' PPS"; $resn_exch{" O1P PPU"}=" OP1 PPU";
$resn_exch{" O2P PPU"}=" OP2 PPU"; $resn_exch{" O3P PPU"}=" OP3 PPU"; $resn_exch{" O5* PPU"}=" O5' PPU";
$resn_exch{" C5* PPU"}=" C5' PPU"; $resn_exch{" C4* PPU"}=" C4' PPU"; $resn_exch{" O4* PPU"}=" O4' PPU";
$resn_exch{" C3* PPU"}=" C3' PPU"; $resn_exch{" N3* PPU"}=" N3' PPU"; $resn_exch{" C2* PPU"}=" C2' PPU";
$resn_exch{" O2* PPU"}=" O2' PPU"; $resn_exch{" C1* PPU"}=" C1' PPU"; $resn_exch{" O1P PPW"}=" OP1 PPW";
$resn_exch{" O2P PPW"}=" OP2 PPW"; $resn_exch{" O5* PPW"}=" O5' PPW"; $resn_exch{" C2* PPW"}=" C2' PPW";
$resn_exch{" C5* PPW"}=" C5' PPW"; $resn_exch{" C4* PPW"}=" C4' PPW"; $resn_exch{" O4* PPW"}=" O4' PPW";
$resn_exch{" C1* PPW"}=" C1' PPW"; $resn_exch{" C3* PPW"}=" C3' PPW"; $resn_exch{" O3* PPW"}=" O3' PPW";
$resn_exch{" O3P PPW"}=" OP3 PPW"; $resn_exch{" O3P PQ1"}=" OP3 PQ1"; $resn_exch{" O2P PQ1"}=" OP2 PQ1";
$resn_exch{" O5* PQ1"}=" O5' PQ1"; $resn_exch{" C5* PQ1"}=" C5' PQ1"; $resn_exch{" C4* PQ1"}=" C4' PQ1";
$resn_exch{" O4* PQ1"}=" O4' PQ1"; $resn_exch{" C1* PQ1"}=" C1' PQ1"; $resn_exch{" C2* PQ1"}=" C2' PQ1";
$resn_exch{" O2* PQ1"}=" O2' PQ1"; $resn_exch{" C3* PQ1"}=" C3' PQ1"; $resn_exch{" O3* PQ1"}=" O3' PQ1";
$resn_exch{" O1P PQ1"}=" OP1 PQ1"; $resn_exch{" OR  PR0"}=" OXT PR0"; $resn_exch{" O1P PR5"}=" OP1 PR5";
$resn_exch{" O2P PR5"}=" OP2 PR5"; $resn_exch{" O5* PR5"}=" O5' PR5"; $resn_exch{" C5* PR5"}=" C5' PR5";
$resn_exch{" C4* PR5"}=" C4' PR5"; $resn_exch{" O4* PR5"}=" O4' PR5"; $resn_exch{" C1* PR5"}=" C1' PR5";
$resn_exch{" C3* PR5"}=" C3' PR5"; $resn_exch{" O3* PR5"}=" O3' PR5"; $resn_exch{" C2* PR5"}=" C2' PR5";
$resn_exch{" O2* PR5"}=" O2' PR5"; $resn_exch{" O3P PR5"}=" OP3 PR5"; $resn_exch{" N1* PRD"}=" N1' PRD";
$resn_exch{" N8* PRD"}=" N8' PRD"; $resn_exch{" C7* PRD"}=" C7B PRD"; $resn_exch{" C6* PRD"}=" C6B PRD";
$resn_exch{" N6* PRD"}=" N6' PRD"; $resn_exch{" C5* PRD"}=" C5B PRD"; $resn_exch{" C4* PRD"}=" C4B PRD";
$resn_exch{" N4* PRD"}=" N4' PRD"; $resn_exch{" N3* PRD"}=" N3' PRD"; $resn_exch{" C2* PRD"}=" C2B PRD";
$resn_exch{" N2* PRD"}=" N2' PRD"; $resn_exch{"1O7  PRE"}=" O71 PRE"; $resn_exch{"2O7  PRE"}=" O72 PRE";
$resn_exch{"1O2' PRE"}=" O'L PRE"; $resn_exch{"2O2' PRE"}=" O'M PRE"; $resn_exch{" C1* PRH"}=" C1' PRH";
$resn_exch{" C2* PRH"}=" C2' PRH"; $resn_exch{" O2* PRH"}=" O2' PRH"; $resn_exch{" C3* PRH"}=" C3' PRH";
$resn_exch{" O3* PRH"}=" O3' PRH"; $resn_exch{" C4* PRH"}=" C4' PRH"; $resn_exch{" O4* PRH"}=" O4' PRH";
$resn_exch{" C5* PRH"}=" C5' PRH"; $resn_exch{" O5* PRH"}=" O5' PRH"; $resn_exch{" C1* PRN"}=" C1' PRN";
$resn_exch{" C2* PRN"}=" C2' PRN"; $resn_exch{" C3* PRN"}=" C3' PRN"; $resn_exch{" O3* PRN"}=" O3' PRN";
$resn_exch{" C4* PRN"}=" C4' PRN"; $resn_exch{" O4* PRN"}=" O4' PRN"; $resn_exch{" C5* PRN"}=" C5' PRN";
$resn_exch{" O5* PRN"}=" O5' PRN"; $resn_exch{" O1P PRN"}=" OP1 PRN"; $resn_exch{" O2P PRN"}=" OP2 PRN";
$resn_exch{" O3P PRN"}=" OP3 PRN"; $resn_exch{" O5* PRT"}=" O5' PRT"; $resn_exch{" C5* PRT"}=" C5' PRT";
$resn_exch{" C4* PRT"}=" C4' PRT"; $resn_exch{" O4* PRT"}=" O4' PRT"; $resn_exch{" C3* PRT"}=" C3' PRT";
$resn_exch{" O3* PRT"}=" O3' PRT"; $resn_exch{" C2* PRT"}=" C2' PRT"; $resn_exch{" O2* PRT"}=" O2' PRT";
$resn_exch{" C1* PRT"}=" C1' PRT"; $resn_exch{" O2* PRX"}=" O2' PRX"; $resn_exch{" C2* PRX"}=" C2' PRX";
$resn_exch{" C1* PRX"}=" C1' PRX"; $resn_exch{" O4* PRX"}=" O4' PRX"; $resn_exch{" C4* PRX"}=" C4' PRX";
$resn_exch{" C5* PRX"}=" C5' PRX"; $resn_exch{" O5* PRX"}=" O5' PRX"; $resn_exch{" C3* PRX"}=" C3' PRX";
$resn_exch{" O3* PRX"}=" O3' PRX"; $resn_exch{" O1P PST"}=" OP1 PST"; $resn_exch{" O2P PST"}=" OP2 PST";
$resn_exch{" O5* PST"}=" O5' PST"; $resn_exch{" C5* PST"}=" C5' PST"; $resn_exch{" C4* PST"}=" C4' PST";
$resn_exch{" O4* PST"}=" O4' PST"; $resn_exch{" C3* PST"}=" C3' PST"; $resn_exch{" O3* PST"}=" O3' PST";
$resn_exch{" C2* PST"}=" C2' PST"; $resn_exch{" C1* PST"}=" C1' PST"; $resn_exch{" C1* PSU"}=" C1' PSU";
$resn_exch{" C2* PSU"}=" C2' PSU"; $resn_exch{" O2* PSU"}=" O2' PSU"; $resn_exch{" C3* PSU"}=" C3' PSU";
$resn_exch{" C4* PSU"}=" C4' PSU"; $resn_exch{" O3* PSU"}=" O3' PSU"; $resn_exch{" O4* PSU"}=" O4' PSU";
$resn_exch{" C5* PSU"}=" C5' PSU"; $resn_exch{" O5* PSU"}=" O5' PSU"; $resn_exch{" O1P PSU"}=" OP1 PSU";
$resn_exch{" O2P PSU"}=" OP2 PSU"; $resn_exch{" O3P PSU"}=" OP3 PSU"; $resn_exch{" C1* PTP"}=" C1' PTP";
$resn_exch{" C2* PTP"}=" C2' PTP"; $resn_exch{" C3* PTP"}=" C3' PTP"; $resn_exch{" O3* PTP"}=" O3' PTP";
$resn_exch{" P3* PTP"}=" P3' PTP"; $resn_exch{" C4* PTP"}=" C4' PTP"; $resn_exch{" O4* PTP"}=" O4' PTP";
$resn_exch{" C5* PTP"}=" C5' PTP"; $resn_exch{" O5* PTP"}=" O5' PTP"; $resn_exch{" P5* PTP"}=" P5' PTP";
$resn_exch{" O1P  PU"}=" OP1  PU"; $resn_exch{" O2P  PU"}=" OP2  PU"; $resn_exch{" O3P  PU"}=" OP3  PU";
$resn_exch{" O5*  PU"}=" O5'  PU"; $resn_exch{" C5*  PU"}=" C5'  PU"; $resn_exch{" C4*  PU"}=" C4'  PU";
$resn_exch{" O4*  PU"}=" O4'  PU"; $resn_exch{" C3*  PU"}=" C3'  PU"; $resn_exch{" N3*  PU"}=" N3'  PU";
$resn_exch{" C2*  PU"}=" C2'  PU"; $resn_exch{" O2*  PU"}=" O2'  PU"; $resn_exch{" C1*  PU"}=" C1'  PU";
$resn_exch{" O5* PUA"}=" O5' PUA"; $resn_exch{" C5* PUA"}=" C5' PUA"; $resn_exch{" C4* PUA"}=" C4' PUA";
$resn_exch{" O4* PUA"}=" O4' PUA"; $resn_exch{" C1* PUA"}=" C1' PUA"; $resn_exch{" C2* PUA"}=" C2' PUA";
$resn_exch{" O2* PUA"}=" O2' PUA"; $resn_exch{" C3* PUA"}=" C3' PUA"; $resn_exch{" O3* PUA"}=" O3' PUA";
$resn_exch{" C1* PUR"}=" C1' PUR"; $resn_exch{" C2* PUR"}=" C2' PUR"; $resn_exch{" O2* PUR"}=" O2' PUR";
$resn_exch{" C3* PUR"}=" C3' PUR"; $resn_exch{" O3* PUR"}=" O3' PUR"; $resn_exch{" C4* PUR"}=" C4' PUR";
$resn_exch{" O4* PUR"}=" O4' PUR"; $resn_exch{" C5* PUR"}=" C5' PUR"; $resn_exch{" O5* PUR"}=" O5' PUR";
$resn_exch{" O5* PUY"}=" O5' PUY"; $resn_exch{" C5* PUY"}=" C5' PUY"; $resn_exch{" C4* PUY"}=" C4' PUY";
$resn_exch{" O4* PUY"}=" O4' PUY"; $resn_exch{" C1* PUY"}=" C1' PUY"; $resn_exch{" C2* PUY"}=" C2' PUY";
$resn_exch{" O2* PUY"}=" O2' PUY"; $resn_exch{" C3* PUY"}=" C3' PUY"; $resn_exch{" N3* PUY"}=" N3' PUY";
$resn_exch{" C*  PX1"}=" C'  PX1"; $resn_exch{" O*  PX1"}=" O'  PX1"; $resn_exch{" C*  PXA"}=" C'  PXA";
$resn_exch{" O*  PXA"}=" O'  PXA"; $resn_exch{" C*  PXF"}=" C'  PXF"; $resn_exch{" O*  PXF"}=" O'  PXF";
$resn_exch{" C*  PXZ"}=" C'  PXZ"; $resn_exch{" O*  PXZ"}=" O'  PXZ"; $resn_exch{" O3P PYO"}=" OP3 PYO";
$resn_exch{" O1P PYO"}=" OP1 PYO"; $resn_exch{" O2P PYO"}=" OP2 PYO"; $resn_exch{" O5* PYO"}=" O5' PYO";
$resn_exch{" C5* PYO"}=" C5' PYO"; $resn_exch{" C4* PYO"}=" C4' PYO"; $resn_exch{" O4* PYO"}=" O4' PYO";
$resn_exch{" C3* PYO"}=" C3' PYO"; $resn_exch{" C1* PYO"}=" C1' PYO"; $resn_exch{" O3* PYO"}=" O3' PYO";
$resn_exch{" C2* PYO"}=" C2' PYO"; $resn_exch{" O2* PYO"}=" O2' PYO"; $resn_exch{" O5* PYP"}=" O5' PYP";
$resn_exch{" C5* PYP"}=" C5' PYP"; $resn_exch{" C4* PYP"}=" C4' PYP"; $resn_exch{" O4* PYP"}=" O4' PYP";
$resn_exch{" C1* PYP"}=" C1' PYP"; $resn_exch{" C2* PYP"}=" C2' PYP"; $resn_exch{" C3* PYP"}=" C3' PYP";
$resn_exch{" O3* PYP"}=" O3' PYP"; $resn_exch{" O5* PYY"}=" O5' PYY"; $resn_exch{" C5* PYY"}=" C5' PYY";
$resn_exch{" C4* PYY"}=" C4' PYY"; $resn_exch{" O4* PYY"}=" O4' PYY"; $resn_exch{" C1* PYY"}=" C1' PYY";
$resn_exch{" C2* PYY"}=" C2' PYY"; $resn_exch{" O2* PYY"}=" O2' PYY"; $resn_exch{" C3* PYY"}=" C3' PYY";
$resn_exch{" O3* PYY"}=" O3' PYY"; $resn_exch{" O1P QUO"}=" OP1 QUO"; $resn_exch{" O2P QUO"}=" OP2 QUO";
$resn_exch{" O3P QUO"}=" OP3 QUO"; $resn_exch{" O5* QUO"}=" O5' QUO"; $resn_exch{" C5* QUO"}=" C5' QUO";
$resn_exch{" C4* QUO"}=" C4' QUO"; $resn_exch{" O4* QUO"}=" O4' QUO"; $resn_exch{" C1* QUO"}=" C1' QUO";
$resn_exch{" C2* QUO"}=" C2' QUO"; $resn_exch{" O2* QUO"}=" O2' QUO"; $resn_exch{" C3* QUO"}=" C3' QUO";
$resn_exch{" O3* QUO"}=" O3' QUO"; $resn_exch{" O1P   R"}=" OP1   R"; $resn_exch{" O2P   R"}=" OP2   R";
$resn_exch{" O3P   R"}=" OP3   R"; $resn_exch{" O5*   R"}=" O5'   R"; $resn_exch{" C5*   R"}=" C5'   R";
$resn_exch{" C4*   R"}=" C4'   R"; $resn_exch{" O4*   R"}=" O4'   R"; $resn_exch{" C3*   R"}=" C3'   R";
$resn_exch{" O3*   R"}=" O3'   R"; $resn_exch{" C2*   R"}=" C2'   R"; $resn_exch{" C1*   R"}=" C1'   R";
$resn_exch{" C1* R22"}=" C1' R22"; $resn_exch{" C2* R22"}=" C2' R22"; $resn_exch{" C3* R22"}=" C3' R22";
$resn_exch{" C4* R22"}=" C4' R22"; $resn_exch{" C5* R22"}=" C5' R22"; $resn_exch{" C6* R22"}=" C6' R22";
$resn_exch{" O7* R22"}=" O7' R22"; $resn_exch{" C8* R22"}=" C8' R22"; $resn_exch{" C9* R22"}=" C9' R22";
$resn_exch{" O   R7A"}=" OXT R7A"; $resn_exch{" OXT R7A"}=" O   R7A"; $resn_exch{" C1* RBF"}=" C1' RBF";
$resn_exch{" C2* RBF"}=" C2' RBF"; $resn_exch{" O2* RBF"}=" O2' RBF"; $resn_exch{" C3* RBF"}=" C3' RBF";
$resn_exch{" O3* RBF"}=" O3' RBF"; $resn_exch{" C4* RBF"}=" C4' RBF"; $resn_exch{" O4* RBF"}=" O4' RBF";
$resn_exch{" C5* RBF"}=" C5' RBF"; $resn_exch{" O5* RBF"}=" O5' RBF"; $resn_exch{" O5* RBY"}=" O5' RBY";
$resn_exch{" C5* RBY"}=" C5' RBY"; $resn_exch{" C4* RBY"}=" C4' RBY"; $resn_exch{" O4* RBY"}=" O4' RBY";
$resn_exch{" C3* RBY"}=" C3' RBY"; $resn_exch{" O3* RBY"}=" O3' RBY"; $resn_exch{" C2* RBY"}=" C2' RBY";
$resn_exch{" O2* RBY"}=" O2' RBY"; $resn_exch{" C1* RBY"}=" C1' RBY"; $resn_exch{" O5* RBZ"}=" O5' RBZ";
$resn_exch{" C5* RBZ"}=" C5' RBZ"; $resn_exch{" C4* RBZ"}=" C4' RBZ"; $resn_exch{" O4* RBZ"}=" O4' RBZ";
$resn_exch{" C3* RBZ"}=" C3' RBZ"; $resn_exch{" O3* RBZ"}=" O3' RBZ"; $resn_exch{" C2* RBZ"}=" C2' RBZ";
$resn_exch{" O2* RBZ"}=" O2' RBZ"; $resn_exch{" C1* RBZ"}=" C1' RBZ"; $resn_exch{" O1* RDP"}=" O1' RDP";
$resn_exch{" C1* RDP"}=" C1' RDP"; $resn_exch{" C2* RDP"}=" C2' RDP"; $resn_exch{" O2* RDP"}=" O2' RDP";
$resn_exch{" C3* RDP"}=" C3' RDP"; $resn_exch{" O3* RDP"}=" O3' RDP"; $resn_exch{" C4* RDP"}=" C4' RDP";
$resn_exch{" O4* RDP"}=" O4' RDP"; $resn_exch{" C5* RDP"}=" C5' RDP"; $resn_exch{" O5* RDP"}=" O5' RDP";
$resn_exch{" AO7 RFC"}=" O7A RFC"; $resn_exch{"AP3* RFC"}=" P3B RFC"; $resn_exch{" AO9 RFC"}=" O9A RFC";
$resn_exch{" AO8 RFC"}=" O8A RFC"; $resn_exch{"AO3* RFC"}=" O3B RFC"; $resn_exch{"AC3* RFC"}=" C3B RFC";
$resn_exch{"AC2* RFC"}=" C2B RFC"; $resn_exch{"AO2* RFC"}=" O2B RFC"; $resn_exch{"AC1* RFC"}=" C1B RFC";
$resn_exch{" AN9 RFC"}=" N9A RFC"; $resn_exch{" AC4 RFC"}=" C4A RFC"; $resn_exch{" AC5 RFC"}=" C5A RFC";
$resn_exch{" AC6 RFC"}=" C6A RFC"; $resn_exch{" AN6 RFC"}=" N6A RFC"; $resn_exch{" AN1 RFC"}=" N1A RFC";
$resn_exch{" AC2 RFC"}=" C2A RFC"; $resn_exch{" AN3 RFC"}=" N3A RFC"; $resn_exch{" AN7 RFC"}=" N7A RFC";
$resn_exch{" AC8 RFC"}=" C8A RFC"; $resn_exch{"AO4* RFC"}=" O4B RFC"; $resn_exch{"AC4* RFC"}=" C4B RFC";
$resn_exch{"AC5* RFC"}=" C5B RFC"; $resn_exch{"AO5* RFC"}=" O5B RFC"; $resn_exch{" AP1 RFC"}=" P1A RFC";
$resn_exch{" AO1 RFC"}=" O1A RFC"; $resn_exch{" AO2 RFC"}=" O2A RFC"; $resn_exch{" AO3 RFC"}=" O3A RFC";
$resn_exch{" AP2 RFC"}=" P2A RFC"; $resn_exch{" AO4 RFC"}=" O4A RFC"; $resn_exch{" AO5 RFC"}=" O5A RFC";
$resn_exch{" AO6 RFC"}=" O6A RFC"; $resn_exch{"PC12 RFC"}=" CCP RFC"; $resn_exch{"PC11 RFC"}=" CBP RFC";
$resn_exch{"PC13 RFC"}=" CDP RFC"; $resn_exch{"PC14 RFC"}=" CEP RFC"; $resn_exch{"PC10 RFC"}=" CAP RFC";
$resn_exch{"PO10 RFC"}=" OAP RFC"; $resn_exch{" PC9 RFC"}=" C9P RFC"; $resn_exch{" PO9 RFC"}=" O9P RFC";
$resn_exch{" PN8 RFC"}=" N8P RFC"; $resn_exch{" PC7 RFC"}=" C7P RFC"; $resn_exch{" PC6 RFC"}=" C6P RFC";
$resn_exch{" PC5 RFC"}=" C5P RFC"; $resn_exch{" PO5 RFC"}=" O5P RFC"; $resn_exch{" PN4 RFC"}=" N4P RFC";
$resn_exch{" PC3 RFC"}=" C3P RFC"; $resn_exch{" PC2 RFC"}=" C2P RFC"; $resn_exch{" PS1 RFC"}=" S1P RFC";
$resn_exch{" SG* RGS"}=" SG' RGS"; $resn_exch{" CB* RGS"}=" CB' RGS"; $resn_exch{" CA* RGS"}=" CA' RGS";
$resn_exch{" N*  RGS"}=" N'  RGS"; $resn_exch{" C5* RGS"}=" C5' RGS"; $resn_exch{" O5* RGS"}=" O5' RGS";
$resn_exch{" C6* RGS"}=" C6' RGS"; $resn_exch{" C7* RGS"}=" C7' RGS"; $resn_exch{"*O7A RGS"}=" O11 RGS";
$resn_exch{"*O7B RGS"}=" O12 RGS"; $resn_exch{" C*  RGS"}=" C'  RGS"; $resn_exch{" O*  RGS"}=" O'  RGS";
$resn_exch{" N4* RGS"}=" N4' RGS"; $resn_exch{" C4* RGS"}=" C4' RGS"; $resn_exch{" C3* RGS"}=" C3' RGS";
$resn_exch{" C2* RGS"}=" C2' RGS"; $resn_exch{" N2* RGS"}=" N2' RGS"; $resn_exch{" C1* RGS"}=" C1' RGS";
$resn_exch{"*O1A RGS"}=" O13 RGS"; $resn_exch{"*O1B RGS"}=" O14 RGS"; $resn_exch{" O1P RIA"}=" OP1 RIA";
$resn_exch{" O2P RIA"}=" OP2 RIA"; $resn_exch{" O3P RIA"}=" OP3 RIA"; $resn_exch{" O5* RIA"}=" O5A RIA";
$resn_exch{" C5* RIA"}=" C5A RIA"; $resn_exch{" C4* RIA"}=" C4A RIA"; $resn_exch{" O4* RIA"}=" O4' RIA";
$resn_exch{" C3* RIA"}=" C3A RIA"; $resn_exch{" O3* RIA"}=" O3A RIA"; $resn_exch{" C2* RIA"}=" C2A RIA";
$resn_exch{" O2* RIA"}=" O2A RIA"; $resn_exch{" C1* RIA"}=" C1A RIA"; $resn_exch{"O1P' RIA"}=" O1X RIA";
$resn_exch{"O2P' RIA"}=" O2X RIA"; $resn_exch{"O3P' RIA"}=" O3X RIA"; $resn_exch{" O5* RIB"}=" O5' RIB";
$resn_exch{" C5* RIB"}=" C5' RIB"; $resn_exch{" C4* RIB"}=" C4' RIB"; $resn_exch{" O4* RIB"}=" O4' RIB";
$resn_exch{" C3* RIB"}=" C3' RIB"; $resn_exch{" O3* RIB"}=" O3' RIB"; $resn_exch{" C2* RIB"}=" C2' RIB";
$resn_exch{" O2* RIB"}=" O2' RIB"; $resn_exch{" C1* RIB"}=" C1' RIB"; $resn_exch{" O1* RIB"}=" O1' RIB";
$resn_exch{" O5* RMB"}=" O5' RMB"; $resn_exch{" C5* RMB"}=" C5' RMB"; $resn_exch{" C4* RMB"}=" C4' RMB";
$resn_exch{" O4* RMB"}=" O4' RMB"; $resn_exch{" C3* RMB"}=" C3' RMB"; $resn_exch{" O3* RMB"}=" O3' RMB";
$resn_exch{" C2* RMB"}=" C2' RMB"; $resn_exch{" O2* RMB"}=" O2' RMB"; $resn_exch{" C1* RMB"}=" C1' RMB";
$resn_exch{" O1P RMP"}=" OP1 RMP"; $resn_exch{" O5* RMP"}=" O5' RMP"; $resn_exch{" C5* RMP"}=" C5' RMP";
$resn_exch{" C4* RMP"}=" C4' RMP"; $resn_exch{" O4* RMP"}=" O4' RMP"; $resn_exch{" C1* RMP"}=" C1' RMP";
$resn_exch{" C3* RMP"}=" C3' RMP"; $resn_exch{" C2* RMP"}=" C2' RMP"; $resn_exch{" O3* RMP"}=" O3' RMP";
$resn_exch{" O3P RMP"}=" OP3 RMP"; $resn_exch{"O1P' ROB"}=" O1X ROB"; $resn_exch{"O2P' ROB"}=" O2X ROB";
$resn_exch{"O3P' ROB"}=" O3X ROB"; $resn_exch{"C6'B ROM"}=" C6D ROM"; $resn_exch{"C6'A ROM"}=" C6B ROM";
$resn_exch{"C4'B ROM"}=" C4D ROM"; $resn_exch{"C4'A ROM"}=" C4B ROM"; $resn_exch{"C'10 ROM"}=" C15 ROM";
$resn_exch{"C'12 ROM"}=" C1A ROM"; $resn_exch{"C'11 ROM"}=" C1B ROM"; $resn_exch{"C'7A ROM"}=" C7X ROM";
$resn_exch{"O'12 ROM"}=" O11 ROM"; $resn_exch{" O5* RP1"}=" O5' RP1"; $resn_exch{" C5* RP1"}=" C5' RP1";
$resn_exch{" C4* RP1"}=" C4' RP1"; $resn_exch{" O4* RP1"}=" O4' RP1"; $resn_exch{" C3* RP1"}=" C3' RP1";
$resn_exch{" O3* RP1"}=" O3' RP1"; $resn_exch{" C2* RP1"}=" C2' RP1"; $resn_exch{" O2* RP1"}=" O2' RP1";
$resn_exch{" C1* RP1"}=" C1' RP1"; $resn_exch{"O1P' RP5"}=" O1X RP5"; $resn_exch{"O2P' RP5"}=" O2X RP5";
$resn_exch{"O3P' RP5"}=" O3X RP5"; $resn_exch{"1OM6 RPA"}=" O11 RPA"; $resn_exch{" O5* RPD"}=" O5' RPD";
$resn_exch{" C5* RPD"}=" C5' RPD"; $resn_exch{" C4* RPD"}=" C4' RPD"; $resn_exch{" O4* RPD"}=" O4' RPD";
$resn_exch{" C3* RPD"}=" C3' RPD"; $resn_exch{" O3* RPD"}=" O3' RPD"; $resn_exch{" C2* RPD"}=" C2' RPD";
$resn_exch{" O2* RPD"}=" O2' RPD"; $resn_exch{" C1* RPD"}=" C1' RPD"; $resn_exch{"O91A RPD"}=" OJA RPD";
$resn_exch{"O92A RPD"}=" OKA RPD"; $resn_exch{"N10A RPD"}=" NAA RPD"; $resn_exch{"O10A RPD"}=" OAA RPD";
$resn_exch{"C11A RPD"}=" CBA RPD"; $resn_exch{"O11A RPD"}=" OBA RPD"; $resn_exch{" O5* RPL"}=" O5' RPL";
$resn_exch{" C5* RPL"}=" C5' RPL"; $resn_exch{" C4* RPL"}=" C4' RPL"; $resn_exch{" O4* RPL"}=" O4' RPL";
$resn_exch{" C3* RPL"}=" C3' RPL"; $resn_exch{" O3* RPL"}=" O3' RPL"; $resn_exch{" C2* RPL"}=" C2' RPL";
$resn_exch{" O2* RPL"}=" O2' RPL"; $resn_exch{" C1* RPL"}=" C1' RPL"; $resn_exch{"O91A RPL"}=" OJA RPL";
$resn_exch{"O92A RPL"}=" OKA RPL"; $resn_exch{"N10A RPL"}=" NAA RPL"; $resn_exch{"O10A RPL"}=" OAA RPL";
$resn_exch{"C11A RPL"}=" CBA RPL"; $resn_exch{"O11A RPL"}=" OBA RPL"; $resn_exch{" C1* RPP"}=" C1' RPP";
$resn_exch{" C2* RPP"}=" C2' RPP"; $resn_exch{" C3* RPP"}=" C3' RPP"; $resn_exch{" C4* RPP"}=" C4' RPP";
$resn_exch{" O4* RPP"}=" O4' RPP"; $resn_exch{" O2* RPP"}=" O2' RPP"; $resn_exch{" O3* RPP"}=" O3' RPP";
$resn_exch{" C5* RPP"}=" C5' RPP"; $resn_exch{" O5* RPP"}=" O5' RPP"; $resn_exch{" O3P  RT"}=" OP3  RT";
$resn_exch{" O1P  RT"}=" OP1  RT"; $resn_exch{" O2P  RT"}=" OP2  RT"; $resn_exch{" O5*  RT"}=" O5'  RT";
$resn_exch{" C5*  RT"}=" C5'  RT"; $resn_exch{" C4*  RT"}=" C4'  RT"; $resn_exch{" O4*  RT"}=" O4'  RT";
$resn_exch{" C3*  RT"}=" C3'  RT"; $resn_exch{" O3*  RT"}=" O3'  RT"; $resn_exch{" C2*  RT"}=" C2'  RT";
$resn_exch{" O2*  RT"}=" O2'  RT"; $resn_exch{" C1*  RT"}=" C1'  RT"; $resn_exch{" O5* RTP"}=" O5' RTP";
$resn_exch{" C5* RTP"}=" C5' RTP"; $resn_exch{" C4* RTP"}=" C4' RTP"; $resn_exch{" O4* RTP"}=" O4' RTP";
$resn_exch{" C1* RTP"}=" C1' RTP"; $resn_exch{" C2* RTP"}=" C2' RTP"; $resn_exch{" O2* RTP"}=" O2' RTP";
$resn_exch{" C3* RTP"}=" C3' RTP"; $resn_exch{" O3* RTP"}=" O3' RTP"; $resn_exch{" C1\" RUN"}=" C1' RUN";
$resn_exch{" O1\" RUN"}=" O1' RUN"; $resn_exch{" C2\" RUN"}=" C2D RUN"; $resn_exch{" C3\" RUN"}=" C3' RUN";
$resn_exch{" C4\" RUN"}=" C4D RUN"; $resn_exch{" O5* RVP"}=" O5' RVP"; $resn_exch{" C5* RVP"}=" C5' RVP";
$resn_exch{" C4* RVP"}=" C4' RVP"; $resn_exch{" O4* RVP"}=" O4' RVP"; $resn_exch{" C3* RVP"}=" C3' RVP";
$resn_exch{" O3* RVP"}=" O3' RVP"; $resn_exch{" C2* RVP"}=" C2' RVP"; $resn_exch{" O2* RVP"}=" O2' RVP";
$resn_exch{" C1* RVP"}=" C1' RVP"; $resn_exch{" O5* S02"}=" O5' S02"; $resn_exch{" C5* S02"}=" C5' S02";
$resn_exch{" CA* S02"}=" CA' S02"; $resn_exch{" OB* S02"}=" OB' S02"; $resn_exch{" OC* S02"}=" OC' S02";
$resn_exch{" CD* S02"}=" CD' S02"; $resn_exch{" C3* S02"}=" C3' S02"; $resn_exch{" O3* S02"}=" O3' S02";
$resn_exch{" C5* S2M"}=" C5' S2M"; $resn_exch{" O5* S2M"}=" O5' S2M"; $resn_exch{" O2P S2M"}=" OP2 S2M";
$resn_exch{" O1P S2M"}=" OP1 S2M"; $resn_exch{" C4* S2M"}=" C4' S2M"; $resn_exch{" O4* S2M"}=" O4' S2M";
$resn_exch{" C1* S2M"}=" C1' S2M"; $resn_exch{" C2* S2M"}=" C2' S2M"; $resn_exch{" C3* S2M"}=" C3' S2M";
$resn_exch{" O3* S2M"}=" O3' S2M"; $resn_exch{" O2* S2M"}=" O2' S2M"; $resn_exch{" CA* S2M"}=" CA' S2M";
$resn_exch{" CB* S2M"}=" CB' S2M"; $resn_exch{" OC* S2M"}=" OC' S2M"; $resn_exch{" CD* S2M"}=" CD' S2M";
$resn_exch{" O3P S2M"}=" OP3 S2M"; $resn_exch{" C1* S4C"}=" C1' S4C"; $resn_exch{" C2* S4C"}=" C2' S4C";
$resn_exch{" O2* S4C"}=" O2' S4C"; $resn_exch{" C3* S4C"}=" C3' S4C"; $resn_exch{" O3* S4C"}=" O3' S4C";
$resn_exch{" C4* S4C"}=" C4' S4C"; $resn_exch{" S4* S4C"}=" S4' S4C"; $resn_exch{" O1P S4C"}=" OP1 S4C";
$resn_exch{" C5* S4C"}=" C5' S4C"; $resn_exch{" O5* S4C"}=" O5' S4C"; $resn_exch{" O2P S4C"}=" OP2 S4C";
$resn_exch{" O3P S4C"}=" OP3 S4C"; $resn_exch{" C5* S4M"}=" C5' S4M"; $resn_exch{" C4* S4M"}=" C4' S4M";
$resn_exch{" O4* S4M"}=" O4' S4M"; $resn_exch{" C1* S4M"}=" C1' S4M"; $resn_exch{" C2* S4M"}=" C2' S4M";
$resn_exch{" O2* S4M"}=" O2' S4M"; $resn_exch{" C3* S4M"}=" C3' S4M"; $resn_exch{" O3* S4M"}=" O3' S4M";
$resn_exch{" O1P S4U"}=" OP1 S4U"; $resn_exch{" O2P S4U"}=" OP2 S4U"; $resn_exch{" O3P S4U"}=" OP3 S4U";
$resn_exch{" O1P S6G"}=" OP1 S6G"; $resn_exch{" O2P S6G"}=" OP2 S6G"; $resn_exch{" O3P S6G"}=" OP3 S6G";
$resn_exch{" O5* S6G"}=" O5' S6G"; $resn_exch{" C5* S6G"}=" C5' S6G"; $resn_exch{" C4* S6G"}=" C4' S6G";
$resn_exch{" O4* S6G"}=" O4' S6G"; $resn_exch{" C3* S6G"}=" C3' S6G"; $resn_exch{" O3* S6G"}=" O3' S6G";
$resn_exch{" C2* S6G"}=" C2' S6G"; $resn_exch{" C1* S6G"}=" C1' S6G"; $resn_exch{" O5* S9L"}=" O5' S9L";
$resn_exch{" O3* S9L"}=" O3' S9L"; $resn_exch{" C5* SA8"}=" C5' SA8"; $resn_exch{" C4* SA8"}=" C4' SA8";
$resn_exch{" O4* SA8"}=" O4' SA8"; $resn_exch{" C3* SA8"}=" C3' SA8"; $resn_exch{" O3* SA8"}=" O3' SA8";
$resn_exch{" C2* SA8"}=" C2' SA8"; $resn_exch{" O2* SA8"}=" O2' SA8"; $resn_exch{" C1* SA8"}=" C1' SA8";
$resn_exch{" AP  SAD"}=" PA  SAD"; $resn_exch{" AO1 SAD"}=" O1A SAD"; $resn_exch{" AO2 SAD"}=" O2A SAD";
$resn_exch{"AO5* SAD"}=" O5B SAD"; $resn_exch{"AC5* SAD"}=" C5B SAD"; $resn_exch{"AC4* SAD"}=" C4B SAD";
$resn_exch{"AO4* SAD"}=" O4B SAD"; $resn_exch{"AC3* SAD"}=" C3B SAD"; $resn_exch{"AO3* SAD"}=" O3B SAD";
$resn_exch{"AC2* SAD"}=" C2B SAD"; $resn_exch{"AO2* SAD"}=" O2B SAD"; $resn_exch{"AC1* SAD"}=" C1B SAD";
$resn_exch{" AN9 SAD"}=" N9A SAD"; $resn_exch{" AC8 SAD"}=" C8A SAD"; $resn_exch{" AN7 SAD"}=" N7A SAD";
$resn_exch{" AC5 SAD"}=" C5A SAD"; $resn_exch{" AC6 SAD"}=" C6A SAD"; $resn_exch{" AN6 SAD"}=" N6A SAD";
$resn_exch{" AN1 SAD"}=" N1A SAD"; $resn_exch{" AC2 SAD"}=" C2A SAD"; $resn_exch{" AN3 SAD"}=" N3A SAD";
$resn_exch{" AC4 SAD"}=" C4A SAD"; $resn_exch{" NP  SAD"}=" PN  SAD"; $resn_exch{" NO1 SAD"}=" O1N SAD";
$resn_exch{" NO2 SAD"}=" O2N SAD"; $resn_exch{"NO5* SAD"}=" O5D SAD"; $resn_exch{"NC5* SAD"}=" C5D SAD";
$resn_exch{"NC4* SAD"}=" C4D SAD"; $resn_exch{"NO4* SAD"}=" O4D SAD"; $resn_exch{"NC3* SAD"}=" C3D SAD";
$resn_exch{"NO3* SAD"}=" O3D SAD"; $resn_exch{"NC2* SAD"}=" C2D SAD"; $resn_exch{"NO2* SAD"}=" O2D SAD";
$resn_exch{"NC1* SAD"}=" C1D SAD"; $resn_exch{" NC2 SAD"}=" C2N SAD"; $resn_exch{" NN3 SAD"}=" N3N SAD";
$resn_exch{" NC4 SAD"}=" C4N SAD"; $resn_exch{" NC5 SAD"}=" C5N SAD"; $resn_exch{"NSE1 SAD"}="SE1N SAD";
$resn_exch{" NC6 SAD"}=" C6N SAD"; $resn_exch{" NO6 SAD"}=" O6N SAD"; $resn_exch{" NN6 SAD"}=" N6N SAD";
$resn_exch{" AP  SAE"}=" PA  SAE"; $resn_exch{" AO1 SAE"}=" O1A SAE"; $resn_exch{" AO2 SAE"}=" O2A SAE";
$resn_exch{"AO5* SAE"}=" O5B SAE"; $resn_exch{"AC5* SAE"}=" C5B SAE"; $resn_exch{"AC4* SAE"}=" C4B SAE";
$resn_exch{"AO4* SAE"}=" O4B SAE"; $resn_exch{"AC3* SAE"}=" C3B SAE"; $resn_exch{"AO3* SAE"}=" O3B SAE";
$resn_exch{"AC2* SAE"}=" C2B SAE"; $resn_exch{"AO2* SAE"}=" O2B SAE"; $resn_exch{"AC1* SAE"}=" C1B SAE";
$resn_exch{" AN9 SAE"}=" N9A SAE"; $resn_exch{" AC8 SAE"}=" C8A SAE"; $resn_exch{" AN7 SAE"}=" N7A SAE";
$resn_exch{" AC5 SAE"}=" C5A SAE"; $resn_exch{" AC6 SAE"}=" C6A SAE"; $resn_exch{" AN6 SAE"}=" N6A SAE";
$resn_exch{" AN1 SAE"}=" N1A SAE"; $resn_exch{" AC2 SAE"}=" C2A SAE"; $resn_exch{" AN3 SAE"}=" N3A SAE";
$resn_exch{" AC4 SAE"}=" C4A SAE"; $resn_exch{" NP  SAE"}=" PN  SAE"; $resn_exch{" NO1 SAE"}=" O1N SAE";
$resn_exch{" NO2 SAE"}=" O2N SAE"; $resn_exch{"NO5* SAE"}=" O5D SAE"; $resn_exch{"NC5* SAE"}=" C5D SAE";
$resn_exch{"NC4* SAE"}=" C4D SAE"; $resn_exch{"NO4* SAE"}=" O4D SAE"; $resn_exch{"NC3* SAE"}=" C3D SAE";
$resn_exch{"NO3* SAE"}=" O3D SAE"; $resn_exch{"NC2* SAE"}=" C2D SAE"; $resn_exch{"NO2* SAE"}=" O2D SAE";
$resn_exch{"NC1* SAE"}=" C1D SAE"; $resn_exch{" NC2 SAE"}=" C2N SAE"; $resn_exch{" NN3 SAE"}=" N3N SAE";
$resn_exch{" NC4 SAE"}=" C4N SAE"; $resn_exch{" NC5 SAE"}=" C5N SAE"; $resn_exch{"NSE1 SAE"}="SE1N SAE";
$resn_exch{" NC6 SAE"}=" C6N SAE"; $resn_exch{" NO6 SAE"}=" O6N SAE"; $resn_exch{" NN6 SAE"}=" N6N SAE";
$resn_exch{" C5* SAH"}=" C5' SAH"; $resn_exch{" C4* SAH"}=" C4' SAH"; $resn_exch{" O4* SAH"}=" O4' SAH";
$resn_exch{" C3* SAH"}=" C3' SAH"; $resn_exch{" O3* SAH"}=" O3' SAH"; $resn_exch{" C2* SAH"}=" C2' SAH";
$resn_exch{" O2* SAH"}=" O2' SAH"; $resn_exch{" C1* SAH"}=" C1' SAH"; $resn_exch{" C5* SAI"}=" C5' SAI";
$resn_exch{" C4* SAI"}=" C4' SAI"; $resn_exch{" O4* SAI"}=" O4' SAI"; $resn_exch{" C3* SAI"}=" C3' SAI";
$resn_exch{" O3* SAI"}=" O3' SAI"; $resn_exch{" C2* SAI"}=" C2' SAI"; $resn_exch{" O2* SAI"}=" O2' SAI";
$resn_exch{" C1* SAI"}=" C1' SAI"; $resn_exch{" C5* SAM"}=" C5' SAM"; $resn_exch{" C4* SAM"}=" C4' SAM";
$resn_exch{" O4* SAM"}=" O4' SAM"; $resn_exch{" C3* SAM"}=" C3' SAM"; $resn_exch{" O3* SAM"}=" O3' SAM";
$resn_exch{" C2* SAM"}=" C2' SAM"; $resn_exch{" O2* SAM"}=" O2' SAM"; $resn_exch{" C1* SAM"}=" C1' SAM";
$resn_exch{" O5* SAP"}=" O5' SAP"; $resn_exch{" C5* SAP"}=" C5' SAP"; $resn_exch{" C4* SAP"}=" C4' SAP";
$resn_exch{" O4* SAP"}=" O4' SAP"; $resn_exch{" C3* SAP"}=" C3' SAP"; $resn_exch{" O3* SAP"}=" O3' SAP";
$resn_exch{" C2* SAP"}=" C2' SAP"; $resn_exch{" O2* SAP"}=" O2' SAP"; $resn_exch{" C1* SAP"}=" C1' SAP";
$resn_exch{" C1*  SC"}=" C1'  SC"; $resn_exch{" C2*  SC"}=" C2'  SC"; $resn_exch{" C3*  SC"}=" C3'  SC";
$resn_exch{" C4*  SC"}=" C4'  SC"; $resn_exch{" O4*  SC"}=" O4'  SC"; $resn_exch{" O3*  SC"}=" O3'  SC";
$resn_exch{" C5*  SC"}=" C5'  SC"; $resn_exch{" O5*  SC"}=" O5'  SC"; $resn_exch{" O1P  SC"}=" OP1  SC";
$resn_exch{" O3P  SC"}=" OP3  SC"; $resn_exch{" C1* SCO"}=" C1' SCO"; $resn_exch{" C2* SCO"}=" C2' SCO";
$resn_exch{" C3* SCO"}=" C3' SCO"; $resn_exch{" C4* SCO"}=" C4' SCO"; $resn_exch{" C5* SCO"}=" C5' SCO";
$resn_exch{" O1* SCO"}=" O1' SCO"; $resn_exch{" O2* SCO"}=" O2' SCO"; $resn_exch{" O3* SCO"}=" O3' SCO";
$resn_exch{" O4* SCO"}=" O4' SCO"; $resn_exch{" O5* SCO"}=" O5' SCO"; $resn_exch{" O6* SCO"}=" O6' SCO";
$resn_exch{" AO7 SFC"}=" O7A SFC"; $resn_exch{"AP3* SFC"}=" P3B SFC"; $resn_exch{" AO9 SFC"}=" O9A SFC";
$resn_exch{" AO8 SFC"}=" O8A SFC"; $resn_exch{"AO3* SFC"}=" O3B SFC"; $resn_exch{"AC3* SFC"}=" C3B SFC";
$resn_exch{"AC2* SFC"}=" C2B SFC"; $resn_exch{"AO2* SFC"}=" O2B SFC"; $resn_exch{"AC1* SFC"}=" C1B SFC";
$resn_exch{" AN9 SFC"}=" N9A SFC"; $resn_exch{" AC4 SFC"}=" C4A SFC"; $resn_exch{" AC5 SFC"}=" C5A SFC";
$resn_exch{" AC6 SFC"}=" C6A SFC"; $resn_exch{" AN6 SFC"}=" N6A SFC"; $resn_exch{" AN1 SFC"}=" N1A SFC";
$resn_exch{" AC2 SFC"}=" C2A SFC"; $resn_exch{" AN3 SFC"}=" N3A SFC"; $resn_exch{" AN7 SFC"}=" N7A SFC";
$resn_exch{" AC8 SFC"}=" C8A SFC"; $resn_exch{"AO4* SFC"}=" O4B SFC"; $resn_exch{"AC4* SFC"}=" C4B SFC";
$resn_exch{"AC5* SFC"}=" C5B SFC"; $resn_exch{"AO5* SFC"}=" O5B SFC"; $resn_exch{" AP1 SFC"}=" P1A SFC";
$resn_exch{" AO1 SFC"}=" O1A SFC"; $resn_exch{" AO2 SFC"}=" O2A SFC"; $resn_exch{" AO3 SFC"}=" O3A SFC";
$resn_exch{" AP2 SFC"}=" P2A SFC"; $resn_exch{" AO4 SFC"}=" O4A SFC"; $resn_exch{" AO5 SFC"}=" O5A SFC";
$resn_exch{" AO6 SFC"}=" O6A SFC"; $resn_exch{"PC12 SFC"}=" CCP SFC"; $resn_exch{"PC11 SFC"}=" CBP SFC";
$resn_exch{"PC13 SFC"}=" CDP SFC"; $resn_exch{"PC14 SFC"}=" CEP SFC"; $resn_exch{"PC10 SFC"}=" CAP SFC";
$resn_exch{"PO10 SFC"}=" OAP SFC"; $resn_exch{" PC9 SFC"}=" C9P SFC"; $resn_exch{" PO9 SFC"}=" O9P SFC";
$resn_exch{" PN8 SFC"}=" N8P SFC"; $resn_exch{" PC7 SFC"}=" C7P SFC"; $resn_exch{" PC6 SFC"}=" C6P SFC";
$resn_exch{" PC5 SFC"}=" C5P SFC"; $resn_exch{" PO5 SFC"}=" O5P SFC"; $resn_exch{" PN4 SFC"}=" N4P SFC";
$resn_exch{" PC3 SFC"}=" C3P SFC"; $resn_exch{" PC2 SFC"}=" C2P SFC"; $resn_exch{" PS1 SFC"}=" S1P SFC";
$resn_exch{" C5* SFG"}=" C5' SFG"; $resn_exch{" C4* SFG"}=" C4' SFG"; $resn_exch{" O4* SFG"}=" O4' SFG";
$resn_exch{" C3* SFG"}=" C3' SFG"; $resn_exch{" O3* SFG"}=" O3' SFG"; $resn_exch{" C2* SFG"}=" C2' SFG";
$resn_exch{" O2* SFG"}=" O2' SFG"; $resn_exch{" C1* SFG"}=" C1' SFG"; $resn_exch{"2C4  SFT"}=" C42 SFT";
$resn_exch{"2C3  SFT"}=" C32 SFT"; $resn_exch{"2C2  SFT"}=" C22 SFT"; $resn_exch{"2C1  SFT"}=" CCA SFT";
$resn_exch{"2C0  SFT"}=" C02 SFT"; $resn_exch{"1C9  SFT"}=" C91 SFT"; $resn_exch{"1C8  SFT"}=" C81 SFT";
$resn_exch{"1C7  SFT"}=" C71 SFT"; $resn_exch{"1C6  SFT"}=" C61 SFT"; $resn_exch{"1C5  SFT"}=" C51 SFT";
$resn_exch{"1C4  SFT"}=" C41 SFT"; $resn_exch{"1C3  SFT"}=" C31 SFT"; $resn_exch{"1C2  SFT"}=" C21 SFT";
$resn_exch{"1C1  SFT"}=" CBA SFT"; $resn_exch{"1C0  SFT"}=" C01 SFT"; $resn_exch{" C1* SFT"}=" C1B SFT";
$resn_exch{" C2* SFT"}=" C2B SFT"; $resn_exch{" O2* SFT"}=" O2B SFT"; $resn_exch{" O5* SFT"}=" O5' SFT";
$resn_exch{" C5* SFT"}=" C5B SFT"; $resn_exch{" C6* SFT"}=" C6B SFT"; $resn_exch{" O6* SFT"}=" O6' SFT";
$resn_exch{" C4* SFT"}=" C4B SFT"; $resn_exch{" O4* SFT"}=" O4' SFT"; $resn_exch{" C3* SFT"}=" C3B SFT";
$resn_exch{" O3* SFT"}=" O3' SFT"; $resn_exch{" O5* SGP"}=" O5' SGP"; $resn_exch{" C5* SGP"}=" C5' SGP";
$resn_exch{" C4* SGP"}=" C4' SGP"; $resn_exch{" O4* SGP"}=" O4' SGP"; $resn_exch{" C3* SGP"}=" C3' SGP";
$resn_exch{" O3* SGP"}=" O3' SGP"; $resn_exch{" C2* SGP"}=" C2' SGP"; $resn_exch{" O2* SGP"}=" O2' SGP";
$resn_exch{" C1* SGP"}=" C1' SGP"; $resn_exch{" O1  SHC"}=" O   SHC"; $resn_exch{" C1* SHP"}=" C1B SHP";
$resn_exch{" C2* SHP"}=" C2B SHP"; $resn_exch{" C3* SHP"}=" C3B SHP"; $resn_exch{" C4* SHP"}=" C4B SHP";
$resn_exch{" O4* SHP"}=" O4B SHP"; $resn_exch{" C5* SHP"}=" C5B SHP"; $resn_exch{" C6* SHP"}=" C6B SHP";
$resn_exch{" O   SIB"}=" OXT SIB"; $resn_exch{" OXT SIB"}=" O   SIB"; $resn_exch{" C5* SIB"}=" C5' SIB";
$resn_exch{" C4* SIB"}=" C4' SIB"; $resn_exch{" O4* SIB"}=" O4' SIB"; $resn_exch{" C3* SIB"}=" C3' SIB";
$resn_exch{" O3* SIB"}=" O3' SIB"; $resn_exch{" C2* SIB"}=" C2' SIB"; $resn_exch{" O2* SIB"}=" O2' SIB";
$resn_exch{" C1* SIB"}=" C1' SIB"; $resn_exch{" C5* SMM"}=" C5' SMM"; $resn_exch{" C4* SMM"}=" C4' SMM";
$resn_exch{" O4* SMM"}=" O4' SMM"; $resn_exch{" C1* SMM"}=" C1' SMM"; $resn_exch{" C2* SMM"}=" C2' SMM";
$resn_exch{" O2* SMM"}=" O2' SMM"; $resn_exch{" C3* SMM"}=" C3' SMM"; $resn_exch{" O3* SMM"}=" O3' SMM";
$resn_exch{" O1P SMP"}=" OP1 SMP"; $resn_exch{" O5* SMP"}=" O5' SMP"; $resn_exch{" C5* SMP"}=" C5' SMP";
$resn_exch{" C4* SMP"}=" C4' SMP"; $resn_exch{" O4* SMP"}=" O4' SMP"; $resn_exch{" C1* SMP"}=" C1' SMP";
$resn_exch{" C3* SMP"}=" C3' SMP"; $resn_exch{" C2* SMP"}=" C2' SMP"; $resn_exch{" O3* SMP"}=" O3' SMP";
$resn_exch{" O3P SMP"}=" OP3 SMP"; $resn_exch{" O1P SMT"}=" OP1 SMT"; $resn_exch{" O2P SMT"}=" OP2 SMT";
$resn_exch{" O3P SMT"}=" OP3 SMT"; $resn_exch{" AP  SND"}=" PA  SND"; $resn_exch{" AO1 SND"}=" O1A SND";
$resn_exch{" AO2 SND"}=" O2A SND"; $resn_exch{"AO5* SND"}=" O5B SND"; $resn_exch{"AC5* SND"}=" C5B SND";
$resn_exch{"AC4* SND"}=" C4B SND"; $resn_exch{"AO4* SND"}=" O4B SND"; $resn_exch{"AC3* SND"}=" C3B SND";
$resn_exch{"AO3* SND"}=" O3B SND"; $resn_exch{"AC2* SND"}=" C2B SND"; $resn_exch{"AO2* SND"}=" O2B SND";
$resn_exch{"AC1* SND"}=" C1B SND"; $resn_exch{" AN9 SND"}=" N9A SND"; $resn_exch{" AC8 SND"}=" C8A SND";
$resn_exch{" AN7 SND"}=" N7A SND"; $resn_exch{" AC5 SND"}=" C5A SND"; $resn_exch{" AC6 SND"}=" C6A SND";
$resn_exch{" AN6 SND"}=" N6A SND"; $resn_exch{" AN1 SND"}=" N1A SND"; $resn_exch{" AC2 SND"}=" C2A SND";
$resn_exch{" AN3 SND"}=" N3A SND"; $resn_exch{" AC4 SND"}=" C4A SND"; $resn_exch{" NP  SND"}=" PN  SND";
$resn_exch{" NO1 SND"}=" O1N SND"; $resn_exch{" NO2 SND"}=" O2N SND"; $resn_exch{"NO5* SND"}=" O5D SND";
$resn_exch{"NC5* SND"}=" C5D SND"; $resn_exch{"NC4* SND"}=" C4D SND"; $resn_exch{"NO4* SND"}=" O4D SND";
$resn_exch{"NC3* SND"}=" C3D SND"; $resn_exch{"NO3* SND"}=" O3D SND"; $resn_exch{"NC2* SND"}=" C2D SND";
$resn_exch{"NO2* SND"}=" O2D SND"; $resn_exch{"NC1* SND"}=" C1D SND"; $resn_exch{" NN1 SND"}=" N1N SND";
$resn_exch{" NC2 SND"}=" C2N SND"; $resn_exch{" NC3 SND"}=" C3N SND"; $resn_exch{" NC7 SND"}=" C7N SND";
$resn_exch{" NS7 SND"}=" S7N SND"; $resn_exch{" NN7 SND"}=" N7N SND"; $resn_exch{" NC4 SND"}=" C4N SND";
$resn_exch{" NC5 SND"}=" C5N SND"; $resn_exch{" NC6 SND"}=" C6N SND"; $resn_exch{" O5* SNI"}=" O5' SNI";
$resn_exch{" C5* SNI"}=" C5' SNI"; $resn_exch{" C4* SNI"}=" C4' SNI"; $resn_exch{" O4* SNI"}=" O4' SNI";
$resn_exch{" C1* SNI"}=" C1' SNI"; $resn_exch{" C2* SNI"}=" C2' SNI"; $resn_exch{" O2* SNI"}=" O2' SNI";
$resn_exch{" C3* SNI"}=" C3' SNI"; $resn_exch{" O3* SNI"}=" O3' SNI"; $resn_exch{" C1* SOP"}=" C1' SOP";
$resn_exch{" O4* SOP"}=" O4' SOP"; $resn_exch{" C2* SOP"}=" C2' SOP"; $resn_exch{" O2* SOP"}=" O2' SOP";
$resn_exch{" C3* SOP"}=" C3' SOP"; $resn_exch{" O3* SOP"}=" O3' SOP"; $resn_exch{" C4* SOP"}=" C4' SOP";
$resn_exch{" C5* SOP"}=" C5' SOP"; $resn_exch{" O5* SOP"}=" O5' SOP"; $resn_exch{" O5* SP1"}=" O5' SP1";
$resn_exch{" C5* SP1"}=" C5' SP1"; $resn_exch{" C4* SP1"}=" C4' SP1"; $resn_exch{" O4* SP1"}=" O4' SP1";
$resn_exch{" C3* SP1"}=" C3' SP1"; $resn_exch{" O3* SP1"}=" O3' SP1"; $resn_exch{" C2* SP1"}=" C2' SP1";
$resn_exch{" O2* SP1"}=" O2' SP1"; $resn_exch{" C1* SP1"}=" C1' SP1"; $resn_exch{" AN1 SPF"}=" N1A SPF";
$resn_exch{" AC2 SPF"}=" C2A SPF"; $resn_exch{" AN3 SPF"}=" N3A SPF"; $resn_exch{" AC4 SPF"}=" C4A SPF";
$resn_exch{" AC5 SPF"}=" C5A SPF"; $resn_exch{" AC6 SPF"}=" C6A SPF"; $resn_exch{" AN6 SPF"}=" N6A SPF";
$resn_exch{" AN7 SPF"}=" N7A SPF"; $resn_exch{" AC8 SPF"}=" C8A SPF"; $resn_exch{" AN9 SPF"}=" N9A SPF";
$resn_exch{"AC1* SPF"}=" C1B SPF"; $resn_exch{"AC2* SPF"}=" C2B SPF"; $resn_exch{"AO2* SPF"}=" O2B SPF";
$resn_exch{"AC3* SPF"}=" C3B SPF"; $resn_exch{"AO3* SPF"}=" O3B SPF"; $resn_exch{"AP3* SPF"}=" P3B SPF";
$resn_exch{" AO7 SPF"}=" O7A SPF"; $resn_exch{" AO8 SPF"}=" O8A SPF"; $resn_exch{" AO9 SPF"}=" O9A SPF";
$resn_exch{"AC4* SPF"}=" C4B SPF"; $resn_exch{"AO4* SPF"}=" O4B SPF"; $resn_exch{"AC5* SPF"}=" C5B SPF";
$resn_exch{"AO5* SPF"}=" O5B SPF"; $resn_exch{" AP1 SPF"}=" P1A SPF"; $resn_exch{" AO1 SPF"}=" O1A SPF";
$resn_exch{" AO2 SPF"}=" O2A SPF"; $resn_exch{" AO3 SPF"}=" O3A SPF"; $resn_exch{" AP2 SPF"}=" P2A SPF";
$resn_exch{" AO4 SPF"}=" O4A SPF"; $resn_exch{" AO5 SPF"}=" O5A SPF"; $resn_exch{" AO6 SPF"}=" O6A SPF";
$resn_exch{"PC11 SPF"}=" CBP SPF"; $resn_exch{"PC12 SPF"}=" CCP SPF"; $resn_exch{"PC13 SPF"}=" CDP SPF";
$resn_exch{"PC14 SPF"}=" CEP SPF"; $resn_exch{"PC10 SPF"}=" CAP SPF"; $resn_exch{"PO10 SPF"}=" OAP SPF";
$resn_exch{" PC9 SPF"}=" C9P SPF"; $resn_exch{" PO9 SPF"}=" O9P SPF"; $resn_exch{" PN8 SPF"}=" N8P SPF";
$resn_exch{" PC7 SPF"}=" C7P SPF"; $resn_exch{" PC6 SPF"}=" C6P SPF"; $resn_exch{" PC5 SPF"}=" C5P SPF";
$resn_exch{" PO5 SPF"}=" O5P SPF"; $resn_exch{" PN4 SPF"}=" N4P SPF"; $resn_exch{" PC3 SPF"}=" C3P SPF";
$resn_exch{" PC2 SPF"}=" C2P SPF"; $resn_exch{" PS1 SPF"}=" S1P SPF"; $resn_exch{" O5* SPG"}=" O5' SPG";
$resn_exch{" C5* SPG"}=" C5' SPG"; $resn_exch{" C4* SPG"}=" C4' SPG"; $resn_exch{" O4* SPG"}=" O4' SPG";
$resn_exch{" C3* SPG"}=" C3' SPG"; $resn_exch{" O3* SPG"}=" O3' SPG"; $resn_exch{" C2* SPG"}=" C2' SPG";
$resn_exch{" O2* SPG"}=" O2' SPG"; $resn_exch{" C1* SPG"}=" C1' SPG"; $resn_exch{" S5* SPT"}=" S5' SPT";
$resn_exch{" C2* SPT"}=" C2' SPT"; $resn_exch{" C5* SPT"}=" C5' SPT"; $resn_exch{" C4* SPT"}=" C4' SPT";
$resn_exch{" O4* SPT"}=" O4' SPT"; $resn_exch{" C1* SPT"}=" C1' SPT"; $resn_exch{" C3* SPT"}=" C3' SPT";
$resn_exch{" O3* SPT"}=" O3' SPT"; $resn_exch{" O3P SPT"}=" OP3 SPT"; $resn_exch{" O1P SPT"}=" OP1 SPT";
$resn_exch{" O2P SPT"}=" OP2 SPT"; $resn_exch{" O1P SRA"}=" OP1 SRA"; $resn_exch{" O3P SRA"}=" OP3 SRA";
$resn_exch{" O5* SRA"}=" O5' SRA"; $resn_exch{" C5* SRA"}=" C5' SRA"; $resn_exch{" C4* SRA"}=" C4' SRA";
$resn_exch{" O4* SRA"}=" O4' SRA"; $resn_exch{" C3* SRA"}=" C3' SRA"; $resn_exch{" O3* SRA"}=" O3' SRA";
$resn_exch{" C2* SRA"}=" C2' SRA"; $resn_exch{" C1* SRA"}=" C1' SRA"; $resn_exch{" O2* SRA"}=" O2' SRA";
$resn_exch{" N_A SRM"}=" NA  SRM"; $resn_exch{" N_B SRM"}=" NB  SRM"; $resn_exch{" N_C SRM"}=" NC  SRM";
$resn_exch{" N_D SRM"}=" ND  SRM"; $resn_exch{" O5* SRP"}=" O5' SRP"; $resn_exch{" C5* SRP"}=" C5' SRP";
$resn_exch{" C4* SRP"}=" C4' SRP"; $resn_exch{" O4* SRP"}=" O4' SRP"; $resn_exch{" C3* SRP"}=" C3' SRP";
$resn_exch{" O3* SRP"}=" O3' SRP"; $resn_exch{" C2* SRP"}=" C2' SRP"; $resn_exch{" O2* SRP"}=" O2' SRP";
$resn_exch{" C1* SRP"}=" C1' SRP"; $resn_exch{" O5* SSA"}=" O5' SSA"; $resn_exch{" C5* SSA"}=" C5' SSA";
$resn_exch{" C4* SSA"}=" C4' SSA"; $resn_exch{" O4* SSA"}=" O4' SSA"; $resn_exch{" C3* SSA"}=" C3' SSA";
$resn_exch{" O3* SSA"}=" O3' SSA"; $resn_exch{" C2* SSA"}=" C2' SSA"; $resn_exch{" O2* SSA"}=" O2' SSA";
$resn_exch{" C1* SSA"}=" C1' SSA"; $resn_exch{" O2* SSU"}=" O2' SSU"; $resn_exch{" C2* SSU"}=" C2' SSU";
$resn_exch{" C1* SSU"}=" C1' SSU"; $resn_exch{" O4* SSU"}=" O4' SSU"; $resn_exch{" C4* SSU"}=" C4' SSU";
$resn_exch{" C5* SSU"}=" C5' SSU"; $resn_exch{" O5* SSU"}=" O5' SSU"; $resn_exch{" O2P SSU"}=" OP2 SSU";
$resn_exch{" O3P SSU"}=" OP3 SSU"; $resn_exch{" C3* SSU"}=" C3' SSU"; $resn_exch{" O3* SSU"}=" O3' SSU";
$resn_exch{" O5* STP"}=" O5' STP"; $resn_exch{" C5* STP"}=" C5' STP"; $resn_exch{" C4* STP"}=" C4' STP";
$resn_exch{" O4* STP"}=" O4' STP"; $resn_exch{" C3* STP"}=" C3' STP"; $resn_exch{" O3* STP"}=" O3' STP";
$resn_exch{" C2* STP"}=" C2' STP"; $resn_exch{" C1* STP"}=" C1' STP"; $resn_exch{" N1* SU2"}=" N1' SU2";
$resn_exch{" C2* SU2"}=" C2B SU2"; $resn_exch{" C3* SU2"}=" C3B SU2"; $resn_exch{" N4* SU2"}=" N4' SU2";
$resn_exch{" C5* SU2"}=" C5B SU2"; $resn_exch{" C6* SU2"}=" C6B SU2"; $resn_exch{" C1* SUD"}=" C1' SUD";
$resn_exch{" C2* SUD"}=" C2' SUD"; $resn_exch{" O2* SUD"}=" O2' SUD"; $resn_exch{" C3* SUD"}=" C3' SUD";
$resn_exch{" C4* SUD"}=" C4' SUD"; $resn_exch{" O4* SUD"}=" O4' SUD"; $resn_exch{" O3* SUD"}=" O3' SUD";
$resn_exch{" C5* SUD"}=" C5' SUD"; $resn_exch{" O5* SUD"}=" O5' SUD"; $resn_exch{" O1P SUR"}=" OP1 SUR";
$resn_exch{" O2P SUR"}=" OP2 SUR"; $resn_exch{" O3P SUR"}=" OP3 SUR"; $resn_exch{" O3P   T"}=" OP3   T";
$resn_exch{" O1P   T"}=" OP1   T"; $resn_exch{" O2P   T"}=" OP2   T"; $resn_exch{" O5*   T"}=" O5'   T";
$resn_exch{" C5*   T"}=" C5'   T"; $resn_exch{" C4*   T"}=" C4'   T"; $resn_exch{" O4*   T"}=" O4'   T";
$resn_exch{" C3*   T"}=" C3'   T"; $resn_exch{" O3*   T"}=" O3'   T"; $resn_exch{" C2*   T"}=" C2'   T";
$resn_exch{" C1*   T"}=" C1'   T"; $resn_exch{" C5M   T"}=" C7    T"; $resn_exch{" O1P T23"}=" OP1 T23";
$resn_exch{" O2P T23"}=" OP2 T23"; $resn_exch{" O3P T23"}=" OP3 T23"; $resn_exch{" O5* T23"}=" O5' T23";
$resn_exch{" C2* T23"}=" C2' T23"; $resn_exch{" O2* T23"}=" O2' T23"; $resn_exch{" C5* T23"}=" C5' T23";
$resn_exch{" C4* T23"}=" C4' T23"; $resn_exch{" O4* T23"}=" O4' T23"; $resn_exch{" C1* T23"}=" C1' T23";
$resn_exch{" C3* T23"}=" C3' T23"; $resn_exch{" O3P T2S"}=" OP3 T2S"; $resn_exch{" O5* T2S"}=" O5' T2S";
$resn_exch{" C5* T2S"}=" C5' T2S"; $resn_exch{" C4* T2S"}=" C4' T2S"; $resn_exch{" O4* T2S"}=" O4' T2S";
$resn_exch{" C3* T2S"}=" C3' T2S"; $resn_exch{" O3* T2S"}=" O3' T2S"; $resn_exch{" C2* T2S"}=" C2' T2S";
$resn_exch{" C1* T2S"}=" C1' T2S"; $resn_exch{" O1P T2T"}=" OP1 T2T"; $resn_exch{" O2P T2T"}=" OP2 T2T";
$resn_exch{" O5* T2T"}=" O5' T2T"; $resn_exch{" C5* T2T"}=" C5' T2T"; $resn_exch{" C4* T2T"}=" C4' T2T";
$resn_exch{" O4* T2T"}=" O4' T2T"; $resn_exch{" C1* T2T"}=" C1' T2T"; $resn_exch{" C2* T2T"}=" C2' T2T";
$resn_exch{" O2* T2T"}=" O2' T2T"; $resn_exch{" C3* T2T"}=" C3' T2T"; $resn_exch{" O3* T2T"}=" O3' T2T";
$resn_exch{" O3P T2T"}=" OP3 T2T"; $resn_exch{" O5* T31"}=" O5' T31"; $resn_exch{" C5* T31"}=" C5' T31";
$resn_exch{" C4* T31"}=" C4' T31"; $resn_exch{" O4* T31"}=" O4' T31"; $resn_exch{" C3* T31"}=" C3' T31";
$resn_exch{" O3* T31"}=" O3' T31"; $resn_exch{" C2* T31"}=" C2' T31"; $resn_exch{" O2* T31"}=" O2' T31";
$resn_exch{" C1* T31"}=" C1' T31"; $resn_exch{" O5* T32"}=" O5' T32"; $resn_exch{" C5* T32"}=" C5' T32";
$resn_exch{" C4* T32"}=" C4' T32"; $resn_exch{" C3* T32"}=" C3' T32"; $resn_exch{" O3* T32"}=" O3' T32";
$resn_exch{" C2* T32"}=" C2' T32"; $resn_exch{" C1* T32"}=" C1' T32"; $resn_exch{" C*  T32"}=" C'  T32";
$resn_exch{" CM* T32"}=" CM' T32"; $resn_exch{" O5* T36"}=" O5' T36"; $resn_exch{" C5* T36"}=" C5' T36";
$resn_exch{" C4* T36"}=" C4' T36"; $resn_exch{" O4* T36"}=" O4' T36"; $resn_exch{" C3* T36"}=" C3' T36";
$resn_exch{" O3* T36"}=" O3' T36"; $resn_exch{" C2* T36"}=" C2' T36"; $resn_exch{" C1* T36"}=" C1' T36";
$resn_exch{" O5* T37"}=" O5' T37"; $resn_exch{" C5* T37"}=" C5' T37"; $resn_exch{" C4* T37"}=" C4' T37";
$resn_exch{" O4* T37"}=" O4' T37"; $resn_exch{" C3* T37"}=" C3' T37"; $resn_exch{" N3* T37"}=" N3' T37";
$resn_exch{" C2* T37"}=" C2' T37"; $resn_exch{" C1* T37"}=" C1' T37"; $resn_exch{" O5* T38"}=" O5' T38";
$resn_exch{" C5* T38"}=" C5' T38"; $resn_exch{" C4* T38"}=" C4' T38"; $resn_exch{" O4* T38"}=" O4' T38";
$resn_exch{" C3* T38"}=" C3' T38"; $resn_exch{" O3* T38"}=" O3' T38"; $resn_exch{" C2* T38"}=" C2' T38";
$resn_exch{" O2* T38"}=" O2' T38"; $resn_exch{" C1* T38"}=" C1' T38"; $resn_exch{" CA* T38"}=" CA' T38";
$resn_exch{" CB* T38"}=" CB' T38"; $resn_exch{" OC* T38"}=" OC' T38"; $resn_exch{" CD* T38"}=" CD' T38";
$resn_exch{" O5* T39"}=" O5' T39"; $resn_exch{" C5* T39"}=" C5' T39"; $resn_exch{" C4* T39"}=" C4' T39";
$resn_exch{" O4* T39"}=" O4' T39"; $resn_exch{" C3* T39"}=" C3' T39"; $resn_exch{" O3* T39"}=" O3' T39";
$resn_exch{" C2* T39"}=" C2' T39"; $resn_exch{" O2* T39"}=" O2' T39"; $resn_exch{" C1* T39"}=" C1' T39";
$resn_exch{" CA* T39"}=" CA' T39"; $resn_exch{" CD* T39"}=" CD' T39"; $resn_exch{" CB* T39"}=" CB' T39";
$resn_exch{" OC* T39"}=" OC' T39"; $resn_exch{" O1P T3P"}=" OP1 T3P"; $resn_exch{" O2P T3P"}=" OP2 T3P";
$resn_exch{" O3P T3P"}=" OP3 T3P"; $resn_exch{" O5* T3P"}=" O5' T3P"; $resn_exch{" C5* T3P"}=" C5' T3P";
$resn_exch{" C4* T3P"}=" C4' T3P"; $resn_exch{" O4* T3P"}=" O4' T3P"; $resn_exch{" C3* T3P"}=" C3' T3P";
$resn_exch{" O3* T3P"}=" O3' T3P"; $resn_exch{" C2* T3P"}=" C2' T3P"; $resn_exch{" C1* T3P"}=" C1' T3P";
$resn_exch{" C1* T41"}=" C1' T41"; $resn_exch{" C2* T41"}=" C2' T41"; $resn_exch{" O2* T41"}=" O2' T41";
$resn_exch{" C3* T41"}=" C3' T41"; $resn_exch{" C4* T41"}=" C4' T41"; $resn_exch{" O3* T41"}=" O3' T41";
$resn_exch{" O4* T41"}=" O4' T41"; $resn_exch{" C5* T41"}=" C5' T41"; $resn_exch{" O5* T41"}=" O5' T41";
$resn_exch{" C6* T41"}=" C6' T41"; $resn_exch{" O5* T48"}=" O5' T48"; $resn_exch{" C5* T48"}=" C5' T48";
$resn_exch{" C4* T48"}=" C4' T48"; $resn_exch{" C3* T48"}=" C3' T48"; $resn_exch{" O3* T48"}=" O3' T48";
$resn_exch{" C2* T48"}=" C2' T48"; $resn_exch{" C1* T48"}=" C1' T48"; $resn_exch{" O5* T49"}=" O5' T49";
$resn_exch{" C5* T49"}=" C5' T49"; $resn_exch{" C4* T49"}=" C4' T49"; $resn_exch{" C3* T49"}=" C3' T49";
$resn_exch{" O3* T49"}=" O3' T49"; $resn_exch{" C2* T49"}=" C2' T49"; $resn_exch{" C1* T49"}=" C1' T49";
$resn_exch{" O3P T4S"}=" OP3 T4S"; $resn_exch{" O1P T4S"}=" OP1 T4S"; $resn_exch{" O2P T4S"}=" OP2 T4S";
$resn_exch{" O5* T4S"}=" O5' T4S"; $resn_exch{" C2* T4S"}=" C2' T4S"; $resn_exch{" C5* T4S"}=" C5' T4S";
$resn_exch{" C4* T4S"}=" C4' T4S"; $resn_exch{" O4* T4S"}=" O4' T4S"; $resn_exch{" C1* T4S"}=" C1' T4S";
$resn_exch{" C3* T4S"}=" C3' T4S"; $resn_exch{" O3* T4S"}=" O3' T4S"; $resn_exch{" BN1 T5A"}=" N1B T5A";
$resn_exch{" BC6 T5A"}=" C6B T5A"; $resn_exch{" BC2 T5A"}=" C2B T5A"; $resn_exch{" BO2 T5A"}=" O2B T5A";
$resn_exch{" BN3 T5A"}=" N3B T5A"; $resn_exch{" BC4 T5A"}=" C4B T5A"; $resn_exch{" BO4 T5A"}=" O4B T5A";
$resn_exch{" BC5 T5A"}=" C5B T5A"; $resn_exch{" BC7 T5A"}=" C7B T5A"; $resn_exch{"BC5* T5A"}=" C5E T5A";
$resn_exch{"BC4* T5A"}=" C4E T5A"; $resn_exch{"BO4* T5A"}=" O4E T5A"; $resn_exch{"BC1* T5A"}=" C1E T5A";
$resn_exch{"BC2* T5A"}=" C2E T5A"; $resn_exch{"BC3* T5A"}=" C3E T5A"; $resn_exch{"BO3* T5A"}=" O3E T5A";
$resn_exch{"BO5* T5A"}=" O5E T5A"; $resn_exch{" O2B T5A"}=" O2X T5A"; $resn_exch{"AO5* T5A"}=" O5F T5A";
$resn_exch{"AC5* T5A"}=" C5F T5A"; $resn_exch{"AC4* T5A"}=" C4F T5A"; $resn_exch{"AO4* T5A"}=" O4F T5A";
$resn_exch{"AC1* T5A"}=" C1F T5A"; $resn_exch{"AC2* T5A"}=" C2F T5A"; $resn_exch{"AO2* T5A"}=" O2F T5A";
$resn_exch{"AC3* T5A"}=" C3F T5A"; $resn_exch{"AO3* T5A"}=" O3F T5A"; $resn_exch{" AN9 T5A"}=" N9A T5A";
$resn_exch{" AC4 T5A"}=" C4A T5A"; $resn_exch{" AN3 T5A"}=" N3A T5A"; $resn_exch{" AC2 T5A"}=" C2A T5A";
$resn_exch{" AN1 T5A"}=" N1A T5A"; $resn_exch{" AC6 T5A"}=" C6A T5A"; $resn_exch{" AN6 T5A"}=" N6A T5A";
$resn_exch{" AC5 T5A"}=" C5A T5A"; $resn_exch{" AN7 T5A"}=" N7A T5A"; $resn_exch{" AC8 T5A"}=" C8A T5A";
$resn_exch{" O1P T6A"}=" OP1 T6A"; $resn_exch{" O2P T6A"}=" OP2 T6A"; $resn_exch{" O3P T6A"}=" OP3 T6A";
$resn_exch{" O5* T6A"}=" O5' T6A"; $resn_exch{" C5* T6A"}=" C5' T6A"; $resn_exch{" C4* T6A"}=" C4' T6A";
$resn_exch{" O4* T6A"}=" O4' T6A"; $resn_exch{" C3* T6A"}=" C3' T6A"; $resn_exch{" O3* T6A"}=" O3' T6A";
$resn_exch{" C2* T6A"}=" C2' T6A"; $resn_exch{" O2* T6A"}=" O2' T6A"; $resn_exch{" C1* T6A"}=" C1' T6A";
$resn_exch{"O13A T6A"}=" ODA T6A"; $resn_exch{"O13B T6A"}=" ODB T6A"; $resn_exch{" O3P TA3"}=" OP3 TA3";
$resn_exch{" O1P TA3"}=" OP1 TA3"; $resn_exch{" O2P TA3"}=" OP2 TA3"; $resn_exch{" O5* TA3"}=" O5' TA3";
$resn_exch{" C5* TA3"}=" C5' TA3"; $resn_exch{" C4* TA3"}=" C4' TA3"; $resn_exch{" O4* TA3"}=" O4' TA3";
$resn_exch{" C3* TA3"}=" C3' TA3"; $resn_exch{" O3* TA3"}=" O3' TA3"; $resn_exch{" C2* TA3"}=" C2' TA3";
$resn_exch{" C1* TA3"}=" C1' TA3"; $resn_exch{" AP  TAD"}=" PA  TAD"; $resn_exch{" AO1 TAD"}=" O1A TAD";
$resn_exch{" AO2 TAD"}=" O2A TAD"; $resn_exch{"AO5* TAD"}=" O5B TAD"; $resn_exch{"AC5* TAD"}=" C5B TAD";
$resn_exch{"AC4* TAD"}=" C4B TAD"; $resn_exch{"AO4* TAD"}=" O4B TAD"; $resn_exch{"AC3* TAD"}=" C3B TAD";
$resn_exch{"AO3* TAD"}=" O3B TAD"; $resn_exch{"AC2* TAD"}=" C2B TAD"; $resn_exch{"AO2* TAD"}=" O2B TAD";
$resn_exch{"AC1* TAD"}=" C1B TAD"; $resn_exch{" AN9 TAD"}=" N9A TAD"; $resn_exch{" AC8 TAD"}=" C8A TAD";
$resn_exch{" AN7 TAD"}=" N7A TAD"; $resn_exch{" AC5 TAD"}=" C5A TAD"; $resn_exch{" AC6 TAD"}=" C6A TAD";
$resn_exch{" AN6 TAD"}=" N6A TAD"; $resn_exch{" AN1 TAD"}=" N1A TAD"; $resn_exch{" AC2 TAD"}=" C2A TAD";
$resn_exch{" AN3 TAD"}=" N3A TAD"; $resn_exch{" AC4 TAD"}=" C4A TAD"; $resn_exch{" NP  TAD"}=" PN  TAD";
$resn_exch{" NO1 TAD"}=" O1N TAD"; $resn_exch{" NO2 TAD"}=" O2N TAD"; $resn_exch{"NO5* TAD"}=" O5D TAD";
$resn_exch{"NC5* TAD"}=" C5D TAD"; $resn_exch{"NC4* TAD"}=" C4D TAD"; $resn_exch{"NO4* TAD"}=" O4D TAD";
$resn_exch{"NC3* TAD"}=" C3D TAD"; $resn_exch{"NO3* TAD"}=" O3D TAD"; $resn_exch{"NC2* TAD"}=" C2D TAD";
$resn_exch{"NO2* TAD"}=" O2D TAD"; $resn_exch{"NC1* TAD"}=" C1D TAD"; $resn_exch{" NC2 TAD"}=" C2N TAD";
$resn_exch{" NN3 TAD"}=" N3N TAD"; $resn_exch{" NC4 TAD"}=" C4N TAD"; $resn_exch{" NC5 TAD"}=" C5N TAD";
$resn_exch{" NS1 TAD"}=" S1N TAD"; $resn_exch{" NC6 TAD"}=" C6N TAD"; $resn_exch{" NO6 TAD"}=" O6N TAD";
$resn_exch{" NN6 TAD"}=" N6N TAD"; $resn_exch{" O1P TAF"}=" OP1 TAF"; $resn_exch{" O2P TAF"}=" OP2 TAF";
$resn_exch{" O3P TAF"}=" OP3 TAF"; $resn_exch{" O5* TAF"}=" O5' TAF"; $resn_exch{" F2* TAF"}=" F2' TAF";
$resn_exch{" C2* TAF"}=" C2' TAF"; $resn_exch{" C5* TAF"}=" C5' TAF"; $resn_exch{" C4* TAF"}=" C4' TAF";
$resn_exch{" O4* TAF"}=" O4' TAF"; $resn_exch{" C1* TAF"}=" C1' TAF"; $resn_exch{" C3* TAF"}=" C3' TAF";
$resn_exch{" O3* TAF"}=" O3' TAF"; $resn_exch{" AP  TAP"}=" PA  TAP"; $resn_exch{" AO1 TAP"}=" O1A TAP";
$resn_exch{" AO2 TAP"}=" O2A TAP"; $resn_exch{"AO5* TAP"}=" O5B TAP"; $resn_exch{"AC5* TAP"}=" C5B TAP";
$resn_exch{"AC4* TAP"}=" C4B TAP"; $resn_exch{"AO4* TAP"}=" O4B TAP"; $resn_exch{"AC3* TAP"}=" C3B TAP";
$resn_exch{"AO3* TAP"}=" O3B TAP"; $resn_exch{"AC2* TAP"}=" C2B TAP"; $resn_exch{"AO2* TAP"}=" O2B TAP";
$resn_exch{"AC1* TAP"}=" C1B TAP"; $resn_exch{" AN9 TAP"}=" N9A TAP"; $resn_exch{" AC8 TAP"}=" C8A TAP";
$resn_exch{" AN7 TAP"}=" N7A TAP"; $resn_exch{" AC5 TAP"}=" C5A TAP"; $resn_exch{" AC6 TAP"}=" C6A TAP";
$resn_exch{" AN6 TAP"}=" N6A TAP"; $resn_exch{" AN1 TAP"}=" N1A TAP"; $resn_exch{" AC2 TAP"}=" C2A TAP";
$resn_exch{" AN3 TAP"}=" N3A TAP"; $resn_exch{" AC4 TAP"}=" C4A TAP"; $resn_exch{" NP  TAP"}=" PN  TAP";
$resn_exch{" NO1 TAP"}=" O1N TAP"; $resn_exch{" NO2 TAP"}=" O2N TAP"; $resn_exch{"NO5* TAP"}=" O5D TAP";
$resn_exch{"NC5* TAP"}=" C5D TAP"; $resn_exch{"NC4* TAP"}=" C4D TAP"; $resn_exch{"NO4* TAP"}=" O4D TAP";
$resn_exch{"NC3* TAP"}=" C3D TAP"; $resn_exch{"NO3* TAP"}=" O3D TAP"; $resn_exch{"NC2* TAP"}=" C2D TAP";
$resn_exch{"NO2* TAP"}=" O2D TAP"; $resn_exch{"NC1* TAP"}=" C1D TAP"; $resn_exch{" NN1 TAP"}=" N1N TAP";
$resn_exch{" NC2 TAP"}=" C2N TAP"; $resn_exch{" NC3 TAP"}=" C3N TAP"; $resn_exch{" NC7 TAP"}=" C7N TAP";
$resn_exch{" NS7 TAP"}=" S7N TAP"; $resn_exch{" NN7 TAP"}=" N7N TAP"; $resn_exch{" NC4 TAP"}=" C4N TAP";
$resn_exch{" NC5 TAP"}=" C5N TAP"; $resn_exch{" NC6 TAP"}=" C6N TAP"; $resn_exch{"AP2* TAP"}=" P2B TAP";
$resn_exch{"AOP1 TAP"}=" O1X TAP"; $resn_exch{"AOP2 TAP"}=" O2X TAP"; $resn_exch{"AOP3 TAP"}=" O3X TAP";
$resn_exch{" O5* TAT"}=" O5' TAT"; $resn_exch{" C5* TAT"}=" C5' TAT"; $resn_exch{" C4* TAT"}=" C4' TAT";
$resn_exch{" O4* TAT"}=" O4' TAT"; $resn_exch{" C3* TAT"}=" C3' TAT"; $resn_exch{" O3* TAT"}=" O3' TAT";
$resn_exch{" C2* TAT"}=" C2' TAT"; $resn_exch{" O2* TAT"}=" O2' TAT"; $resn_exch{" C1* TAT"}=" C1' TAT";
$resn_exch{" O5* TBD"}=" O5' TBD"; $resn_exch{" C5* TBD"}=" C5' TBD"; $resn_exch{" C4* TBD"}=" C4' TBD";
$resn_exch{" O4* TBD"}=" O4' TBD"; $resn_exch{" C1* TBD"}=" C1' TBD"; $resn_exch{" C2* TBD"}=" C2' TBD";
$resn_exch{" C3* TBD"}=" C3' TBD"; $resn_exch{" O3* TBD"}=" O3' TBD"; $resn_exch{"1H5  TBS"}=" H51 TBS";
$resn_exch{" O5* TC1"}=" O5' TC1"; $resn_exch{" C5* TC1"}=" C5' TC1"; $resn_exch{" C4* TC1"}=" C4' TC1";
$resn_exch{" C3* TC1"}=" C3' TC1"; $resn_exch{" C2* TC1"}=" C2' TC1"; $resn_exch{" C1* TC1"}=" C1' TC1";
$resn_exch{" O4* TC1"}=" O4' TC1"; $resn_exch{" O3* TC1"}=" O3' TC1"; $resn_exch{" O3P TC1"}=" OP3 TC1";
$resn_exch{" O5* TCP"}=" O5' TCP"; $resn_exch{" C5* TCP"}=" C5' TCP"; $resn_exch{" C4* TCP"}=" C4' TCP";
$resn_exch{" O4* TCP"}=" O4' TCP"; $resn_exch{" C3* TCP"}=" C3' TCP"; $resn_exch{" O3* TCP"}=" O3' TCP";
$resn_exch{" C2* TCP"}=" C2' TCP"; $resn_exch{" C1* TCP"}=" C1' TCP"; $resn_exch{" C5* TDI"}=" C5' TDI";
$resn_exch{" C4* TDI"}=" C4' TDI"; $resn_exch{" C1* TDI"}=" C1' TDI"; $resn_exch{" N1* TDI"}=" N1' TDI";
$resn_exch{" C2* TDI"}=" C2' TDI"; $resn_exch{" C3* TDI"}=" C3' TDI"; $resn_exch{" O3* TDI"}=" O3' TDI";
$resn_exch{" C7* TDK"}=" C7' TDK"; $resn_exch{" C5* TDK"}=" C5' TDK"; $resn_exch{" C6* TDK"}=" C6' TDK";
$resn_exch{" N1* TDK"}=" N1' TDK"; $resn_exch{" C2* TDK"}=" C2' TDK"; $resn_exch{" N3* TDK"}=" N3' TDK";
$resn_exch{" C4* TDK"}=" C4' TDK"; $resn_exch{" N4* TDK"}=" N4' TDK"; $resn_exch{" C7* TDL"}=" C7' TDL";
$resn_exch{" C5* TDL"}=" C5' TDL"; $resn_exch{" C6* TDL"}=" C6' TDL"; $resn_exch{" N1* TDL"}=" N1' TDL";
$resn_exch{" C2* TDL"}=" C2' TDL"; $resn_exch{" N3* TDL"}=" N3' TDL"; $resn_exch{" C4* TDL"}=" C4' TDL";
$resn_exch{" N4* TDL"}=" N4' TDL"; $resn_exch{" C7* TDM"}=" C7' TDM"; $resn_exch{" C5* TDM"}=" C5' TDM";
$resn_exch{" C4* TDM"}=" C4' TDM"; $resn_exch{" N4* TDM"}=" N4' TDM"; $resn_exch{" N3* TDM"}=" N3' TDM";
$resn_exch{" C2* TDM"}=" C2' TDM"; $resn_exch{" N1* TDM"}=" N1' TDM"; $resn_exch{" C6* TDM"}=" C6' TDM";
$resn_exch{" N1* TDP"}=" N1' TDP"; $resn_exch{" C2* TDP"}=" C2' TDP"; $resn_exch{" N3* TDP"}=" N3' TDP";
$resn_exch{" C4* TDP"}=" C4' TDP"; $resn_exch{" N4* TDP"}=" N4' TDP"; $resn_exch{" C5* TDP"}=" C5' TDP";
$resn_exch{" C6* TDP"}=" C6' TDP"; $resn_exch{" C1* TDX"}=" C1B TDX"; $resn_exch{" C2* TDX"}=" C2B TDX";
$resn_exch{" C3* TDX"}=" C3B TDX"; $resn_exch{" O3* TDX"}=" O3B TDX"; $resn_exch{" O4* TDX"}=" O4B TDX";
$resn_exch{" C4* TDX"}=" C4B TDX"; $resn_exch{" C5* TDX"}=" C5B TDX"; $resn_exch{" O5* TDX"}=" O5B TDX";
$resn_exch{" O1P TFE"}=" OP1 TFE"; $resn_exch{" O2P TFE"}=" OP2 TFE"; $resn_exch{" O5* TFE"}=" O5' TFE";
$resn_exch{" C5* TFE"}=" C5' TFE"; $resn_exch{" C4* TFE"}=" C4' TFE"; $resn_exch{" O4* TFE"}=" O4' TFE";
$resn_exch{" C1* TFE"}=" C1' TFE"; $resn_exch{" C2* TFE"}=" C2' TFE"; $resn_exch{" O2* TFE"}=" O2' TFE";
$resn_exch{" C3* TFE"}=" C3' TFE"; $resn_exch{" O3* TFE"}=" O3' TFE"; $resn_exch{" O3P TFE"}=" OP3 TFE";
$resn_exch{" O2P TFO"}=" OP2 TFO"; $resn_exch{" O1P TFO"}=" OP1 TFO"; $resn_exch{" O3P TFO"}=" OP3 TFO";
$resn_exch{" O1P TFT"}=" OP1 TFT"; $resn_exch{" O2P TFT"}=" OP2 TFT"; $resn_exch{" O3P TFT"}=" OP3 TFT";
$resn_exch{"OE11 TGF"}=" OEB TGF"; $resn_exch{"OE12 TGF"}=" OEC TGF"; $resn_exch{"OE13 TGF"}=" OED TGF";
$resn_exch{"OE23 TGF"}=" OEN TGF"; $resn_exch{" S5* TGP"}=" S5' TGP"; $resn_exch{" C2* TGP"}=" C2' TGP";
$resn_exch{" C5* TGP"}=" C5' TGP"; $resn_exch{" C4* TGP"}=" C4' TGP"; $resn_exch{" O4* TGP"}=" O4' TGP";
$resn_exch{" C1* TGP"}=" C1' TGP"; $resn_exch{" C3* TGP"}=" C3' TGP"; $resn_exch{" O3* TGP"}=" O3' TGP";
$resn_exch{" O3P TGP"}=" OP3 TGP"; $resn_exch{" O1P TGP"}=" OP1 TGP"; $resn_exch{" O2P TGP"}=" OP2 TGP";
$resn_exch{" O5* THM"}=" O5' THM"; $resn_exch{" C5* THM"}=" C5' THM"; $resn_exch{" C4* THM"}=" C4' THM";
$resn_exch{" O4* THM"}=" O4' THM"; $resn_exch{" C3* THM"}=" C3' THM"; $resn_exch{" O3* THM"}=" O3' THM";
$resn_exch{" C2* THM"}=" C2' THM"; $resn_exch{" C1* THM"}=" C1' THM"; $resn_exch{" O5* THP"}=" O5' THP";
$resn_exch{" C5* THP"}=" C5' THP"; $resn_exch{" C4* THP"}=" C4' THP"; $resn_exch{" O4* THP"}=" O4' THP";
$resn_exch{" C3* THP"}=" C3' THP"; $resn_exch{" O3* THP"}=" O3' THP"; $resn_exch{" C2* THP"}=" C2' THP";
$resn_exch{" C1* THP"}=" C1' THP"; $resn_exch{" O5* THS"}=" O5' THS"; $resn_exch{" C5* THS"}=" C5' THS";
$resn_exch{" C4* THS"}=" C4' THS"; $resn_exch{" O4* THS"}=" O4' THS"; $resn_exch{" C3* THS"}=" C3' THS";
$resn_exch{" O3* THS"}=" O3' THS"; $resn_exch{" C2* THS"}=" C2' THS"; $resn_exch{" C1* THS"}=" C1' THS";
$resn_exch{" C1* THU"}=" C1' THU"; $resn_exch{" C2* THU"}=" C2' THU"; $resn_exch{" C3* THU"}=" C3' THU";
$resn_exch{" O3* THU"}=" O3' THU"; $resn_exch{" C4* THU"}=" C4' THU"; $resn_exch{" O4* THU"}=" O4' THU";
$resn_exch{" C5* THU"}=" C5' THU"; $resn_exch{" O5* THU"}=" O5' THU"; $resn_exch{" C5* THV"}=" C5' THV";
$resn_exch{" C6* THV"}=" C6' THV"; $resn_exch{" N1* THV"}=" N1' THV"; $resn_exch{" C2* THV"}=" C2' THV";
$resn_exch{" N3* THV"}=" N3' THV"; $resn_exch{" C4* THV"}=" C4' THV"; $resn_exch{" N4* THV"}=" N4' THV";
$resn_exch{" C5* THW"}=" C5' THW"; $resn_exch{" C6* THW"}=" C6' THW"; $resn_exch{" N1* THW"}=" N1' THW";
$resn_exch{" C2* THW"}=" C2' THW"; $resn_exch{" N3* THW"}=" N3' THW"; $resn_exch{" C4* THW"}=" C4' THW";
$resn_exch{" N4* THW"}=" N4' THW"; $resn_exch{" C1* THX"}=" C1' THX"; $resn_exch{" C2* THX"}=" C2' THX";
$resn_exch{" C3* THX"}=" C3' THX"; $resn_exch{" C4* THX"}=" C4' THX"; $resn_exch{" C5* THX"}=" C5' THX";
$resn_exch{" O3* THX"}=" O3' THX"; $resn_exch{" O4* THX"}=" O4' THX"; $resn_exch{" O5* THX"}=" O5' THX";
$resn_exch{" C5* THY"}=" C5' THY"; $resn_exch{" C6* THY"}=" C6' THY"; $resn_exch{" N1* THY"}=" N1' THY";
$resn_exch{" C2* THY"}=" C2' THY"; $resn_exch{" N3* THY"}=" N3' THY"; $resn_exch{" C4* THY"}=" C4' THY";
$resn_exch{" N4* THY"}=" N4' THY"; $resn_exch{" C1* TIA"}=" C1' TIA"; $resn_exch{" C2* TIA"}=" C2' TIA";
$resn_exch{" O2* TIA"}=" O2' TIA"; $resn_exch{" C3* TIA"}=" C3' TIA"; $resn_exch{" O3* TIA"}=" O3' TIA";
$resn_exch{" C4* TIA"}=" C4' TIA"; $resn_exch{" O4* TIA"}=" O4' TIA"; $resn_exch{" C5* TIA"}=" C5' TIA";
$resn_exch{" O2* TIZ"}=" O2' TIZ"; $resn_exch{" C2* TIZ"}=" C2' TIZ"; $resn_exch{" C3* TIZ"}=" C3' TIZ";
$resn_exch{" O3* TIZ"}=" O3' TIZ"; $resn_exch{" C4* TIZ"}=" C4' TIZ"; $resn_exch{" C5* TIZ"}=" C5' TIZ";
$resn_exch{" O5* TIZ"}=" O5' TIZ"; $resn_exch{" O4* TIZ"}=" O4' TIZ"; $resn_exch{" C1* TIZ"}=" C1' TIZ";
$resn_exch{" O5* TLB"}=" O5' TLB"; $resn_exch{" C5* TLB"}=" C5' TLB"; $resn_exch{" C4* TLB"}=" C4' TLB";
$resn_exch{" O4* TLB"}=" O4' TLB"; $resn_exch{" C3* TLB"}=" C3' TLB"; $resn_exch{" O3* TLB"}=" O3' TLB";
$resn_exch{" C2* TLB"}=" C2' TLB"; $resn_exch{" O2* TLB"}=" O2' TLB"; $resn_exch{" C1* TLB"}=" C1' TLB";
$resn_exch{" C9* TLB"}=" C9' TLB"; $resn_exch{" O1P TLC"}=" OP1 TLC"; $resn_exch{" O2P TLC"}=" OP2 TLC";
$resn_exch{" O3P TLC"}=" OP3 TLC"; $resn_exch{" O5* TLC"}=" O5' TLC"; $resn_exch{" C5* TLC"}=" C5' TLC";
$resn_exch{" C4* TLC"}=" C4' TLC"; $resn_exch{" O4* TLC"}=" O4' TLC"; $resn_exch{" C1* TLC"}=" C1' TLC";
$resn_exch{" C2* TLC"}=" C2' TLC"; $resn_exch{" C3* TLC"}=" C3' TLC"; $resn_exch{" O3* TLC"}=" O3' TLC";
$resn_exch{" O1P TLN"}=" OP1 TLN"; $resn_exch{" O2P TLN"}=" OP2 TLN"; $resn_exch{" O3P TLN"}=" OP3 TLN";
$resn_exch{" O5* TLN"}=" O5' TLN"; $resn_exch{" C5* TLN"}=" C5' TLN"; $resn_exch{" C4* TLN"}=" C4' TLN";
$resn_exch{" O4* TLN"}=" O4' TLN"; $resn_exch{" C1* TLN"}=" C1' TLN"; $resn_exch{" C3* TLN"}=" C3' TLN";
$resn_exch{" C2* TLN"}=" C2' TLN"; $resn_exch{" O2* TLN"}=" O2' TLN"; $resn_exch{" O3* TLN"}=" O3' TLN";
$resn_exch{" C6* TLN"}=" C6' TLN"; $resn_exch{" O5* TMP"}=" O5' TMP"; $resn_exch{" C5* TMP"}=" C5' TMP";
$resn_exch{" C4* TMP"}=" C4' TMP"; $resn_exch{" O4* TMP"}=" O4' TMP"; $resn_exch{" C3* TMP"}=" C3' TMP";
$resn_exch{" O3* TMP"}=" O3' TMP"; $resn_exch{" C2* TMP"}=" C2' TMP"; $resn_exch{" C1* TMP"}=" C1' TMP";
$resn_exch{" C5* TND"}=" C5' TND"; $resn_exch{" C4* TND"}=" C4' TND"; $resn_exch{" O4* TND"}=" O4' TND";
$resn_exch{" C3* TND"}=" C3' TND"; $resn_exch{" O3* TND"}=" O3' TND"; $resn_exch{" C2* TND"}=" C2' TND";
$resn_exch{" N2* TND"}=" N2' TND"; $resn_exch{" C1* TND"}=" C1' TND"; $resn_exch{" O5* TND"}=" O5' TND";
$resn_exch{" OB  TNR"}=" OXT TNR"; $resn_exch{" OA  TNR"}=" O   TNR"; $resn_exch{" O2* TOE"}=" O2' TOE";
$resn_exch{" CA* TOE"}=" CA' TOE"; $resn_exch{" CB* TOE"}=" CB' TOE"; $resn_exch{" OC* TOE"}=" OC' TOE";
$resn_exch{" CD* TOE"}=" CD' TOE"; $resn_exch{" CE* TOE"}=" CE' TOE"; $resn_exch{" OF* TOE"}=" OF' TOE";
$resn_exch{" CG* TOE"}=" CG' TOE"; $resn_exch{" CH* TOE"}=" CH' TOE"; $resn_exch{" OI* TOE"}=" OI' TOE";
$resn_exch{" CK* TOE"}=" CK' TOE"; $resn_exch{" O1P TPC"}=" OP1 TPC"; $resn_exch{" O2P TPC"}=" OP2 TPC";
$resn_exch{" O3P TPC"}=" OP3 TPC"; $resn_exch{" O5* TPE"}=" O5' TPE"; $resn_exch{" C5* TPE"}=" C5' TPE";
$resn_exch{" C4* TPE"}=" C4' TPE"; $resn_exch{" O4* TPE"}=" O4' TPE"; $resn_exch{" C3* TPE"}=" C3' TPE";
$resn_exch{" O3* TPE"}=" O3' TPE"; $resn_exch{" C2* TPE"}=" C2' TPE"; $resn_exch{" C1* TPE"}=" C1' TPE";
$resn_exch{" O5* TPG"}=" O5' TPG"; $resn_exch{" C5* TPG"}=" C5' TPG"; $resn_exch{" C4* TPG"}=" C4' TPG";
$resn_exch{" O4* TPG"}=" O4' TPG"; $resn_exch{" C3* TPG"}=" C3' TPG"; $resn_exch{" O3* TPG"}=" O3' TPG";
$resn_exch{" C2* TPG"}=" C2' TPG"; $resn_exch{" O2* TPG"}=" O2' TPG"; $resn_exch{" C1* TPG"}=" C1' TPG";
$resn_exch{" N1* TPW"}=" N1' TPW"; $resn_exch{" C2* TPW"}=" C2' TPW"; $resn_exch{" N3* TPW"}=" N3' TPW";
$resn_exch{" C4* TPW"}=" C4' TPW"; $resn_exch{" N4* TPW"}=" N4' TPW"; $resn_exch{" C5* TPW"}=" C5' TPW";
$resn_exch{" C6* TPW"}=" C6' TPW"; $resn_exch{" C2* TQD"}=" C2D TQD"; $resn_exch{" C4* TQD"}=" C4D TQD";
$resn_exch{" C5* TQD"}=" C5D TQD"; $resn_exch{" C6* TQD"}=" C6D TQD"; $resn_exch{" C7* TQD"}=" C7' TQD";
$resn_exch{" C8* TQD"}=" C8' TQD"; $resn_exch{" N1* TQD"}=" N1' TQD"; $resn_exch{" N2* TQD"}=" N2' TQD";
$resn_exch{" N3* TQD"}=" N3' TQD"; $resn_exch{" N4* TQD"}=" N4' TQD"; $resn_exch{" N9* TQD"}=" N9' TQD";
$resn_exch{" C9* TQD"}=" C9' TQD"; $resn_exch{" C4* TQT"}=" C4B TQT"; $resn_exch{" C8* TQT"}=" C8B TQT";
$resn_exch{" C*0 TQT"}=" C'0 TQT"; $resn_exch{" C*1 TQT"}=" C'1 TQT"; $resn_exch{" C*2 TQT"}=" C'2 TQT";
$resn_exch{" C*3 TQT"}=" C'3 TQT"; $resn_exch{" C*4 TQT"}=" C'4 TQT"; $resn_exch{" C*5 TQT"}=" C'5 TQT";
$resn_exch{" C*6 TQT"}=" C'6 TQT"; $resn_exch{" C*7 TQT"}=" C'7 TQT"; $resn_exch{" N*0 TQT"}=" N'0 TQT";
$resn_exch{" O1P  TS"}=" OP1  TS"; $resn_exch{" O3P  TS"}=" OP3  TS"; $resn_exch{" O5*  TS"}=" O5'  TS";
$resn_exch{" C5*  TS"}=" C5'  TS"; $resn_exch{" C4*  TS"}=" C4'  TS"; $resn_exch{" O4*  TS"}=" O4'  TS";
$resn_exch{" C3*  TS"}=" C3'  TS"; $resn_exch{" O3*  TS"}=" O3'  TS"; $resn_exch{" C2*  TS"}=" C2'  TS";
$resn_exch{" C1*  TS"}=" C1'  TS"; $resn_exch{" O5* TSB"}=" O5' TSB"; $resn_exch{" C5* TSB"}=" C5' TSB";
$resn_exch{" C4* TSB"}=" C4' TSB"; $resn_exch{" O4* TSB"}=" O4' TSB"; $resn_exch{" C3* TSB"}=" C3' TSB";
$resn_exch{" O3* TSB"}=" O3' TSB"; $resn_exch{" C2* TSB"}=" C2' TSB"; $resn_exch{" O2* TSB"}=" O2' TSB";
$resn_exch{" C1* TSB"}=" C1' TSB"; $resn_exch{" O1P TSP"}=" OP1 TSP"; $resn_exch{" O2P TSP"}=" OP2 TSP";
$resn_exch{" O3P TSP"}=" OP3 TSP"; $resn_exch{" O5* TSP"}=" O5' TSP"; $resn_exch{" C5* TSP"}=" C5' TSP";
$resn_exch{" C4* TSP"}=" C4' TSP"; $resn_exch{" O4* TSP"}=" O4' TSP"; $resn_exch{" C3* TSP"}=" C3' TSP";
$resn_exch{" S3* TSP"}=" S3' TSP"; $resn_exch{" C2* TSP"}=" C2' TSP"; $resn_exch{" C1* TSP"}=" C1' TSP";
$resn_exch{" O5*  TT"}=" O5'  TT"; $resn_exch{" C5*  TT"}=" C5'  TT"; $resn_exch{" C4*  TT"}=" C4'  TT";
$resn_exch{" O4*  TT"}=" O4'  TT"; $resn_exch{" C3*  TT"}=" C3'  TT"; $resn_exch{" O3*  TT"}=" O3'  TT";
$resn_exch{" C2*  TT"}=" C2'  TT"; $resn_exch{" C1*  TT"}=" C1'  TT"; $resn_exch{" O1P TTD"}=" OP1 TTD";
$resn_exch{" O2P TTD"}=" OP2 TTD"; $resn_exch{" O3P TTD"}=" OP3 TTD"; $resn_exch{" O5* TTD"}=" O5' TTD";
$resn_exch{" C5* TTD"}=" C5' TTD"; $resn_exch{" O4* TTD"}=" O4' TTD"; $resn_exch{" C2* TTD"}=" C2' TTD";
$resn_exch{" C1* TTD"}=" C1' TTD"; $resn_exch{" C4* TTD"}=" C4' TTD"; $resn_exch{" C3* TTD"}=" C3' TTD";
$resn_exch{" O3* TTD"}=" O3' TTD"; $resn_exch{" C1* TTE"}=" C1' TTE"; $resn_exch{" C2* TTE"}=" C2' TTE";
$resn_exch{" C3* TTE"}=" C3' TTE"; $resn_exch{" O3* TTE"}=" O3' TTE"; $resn_exch{" C4* TTE"}=" C4' TTE";
$resn_exch{" O4* TTE"}=" O4' TTE"; $resn_exch{" C5* TTE"}=" C5' TTE"; $resn_exch{" O5* TTE"}=" O5' TTE";
$resn_exch{" O1P TTM"}=" OP1 TTM"; $resn_exch{" O2P TTM"}=" OP2 TTM"; $resn_exch{" O5* TTM"}=" O5' TTM";
$resn_exch{" C5* TTM"}=" C5' TTM"; $resn_exch{" C4* TTM"}=" C4' TTM"; $resn_exch{" O4* TTM"}=" O4' TTM";
$resn_exch{" C1* TTM"}=" C1' TTM"; $resn_exch{" C2* TTM"}=" C2' TTM"; $resn_exch{" C3* TTM"}=" C3' TTM";
$resn_exch{" O3* TTM"}=" O3' TTM"; $resn_exch{" O3P TTM"}=" OP3 TTM"; $resn_exch{" O5* TTP"}=" O5' TTP";
$resn_exch{" C5* TTP"}=" C5' TTP"; $resn_exch{" C4* TTP"}=" C4' TTP"; $resn_exch{" O4* TTP"}=" O4' TTP";
$resn_exch{" C3* TTP"}=" C3' TTP"; $resn_exch{" O3* TTP"}=" O3' TTP"; $resn_exch{" C2* TTP"}=" C2' TTP";
$resn_exch{" C1* TTP"}=" C1' TTP"; $resn_exch{" C3* TTS"}=" C3' TTS"; $resn_exch{" C2* TTS"}=" C2' TTS";
$resn_exch{" C1* TTS"}=" C1' TTS"; $resn_exch{" C6* TTS"}=" C6' TTS"; $resn_exch{" C5* TTS"}=" C5' TTS";
$resn_exch{" C4* TTS"}=" C4' TTS"; $resn_exch{" C1  TUO"}=" CAE TUO"; $resn_exch{" C2  TUO"}=" CAA TUO";
$resn_exch{" C3  TUO"}=" CAB TUO"; $resn_exch{" C4  TUO"}=" CAC TUO"; $resn_exch{" C5  TUO"}=" CAG TUO";
$resn_exch{" C6  TUO"}=" CAF TUO"; $resn_exch{" C7  TUO"}=" CAN TUO"; $resn_exch{" C8  TUO"}=" CAM TUO";
$resn_exch{" C9  TUO"}=" CAL TUO"; $resn_exch{" C10 TUO"}=" CAK TUO"; $resn_exch{" S1  TUO"}=" SAJ TUO";
$resn_exch{" O1  TUO"}=" OAS TUO"; $resn_exch{" O2  TUO"}=" OAD TUO"; $resn_exch{" N1  TUO"}=" NAI TUO";
$resn_exch{" C11 TUO"}=" CAT TUO"; $resn_exch{" C12 TUO"}=" CAU TUO"; $resn_exch{" C13 TUO"}=" CAV TUO";
$resn_exch{" N2  TUO"}=" NAW TUO"; $resn_exch{" C14 TUO"}=" CAO TUO"; $resn_exch{" C15 TUO"}=" CAP TUO";
$resn_exch{" O3  TUO"}=" OAH TUO"; $resn_exch{" N3  TUO"}=" NAQ TUO"; $resn_exch{" N4  TUO"}=" NAR TUO";
$resn_exch{"C1*  TXD"}="C1'A TXD"; $resn_exch{"O4*  TXD"}="O4'A TXD"; $resn_exch{"C2*  TXD"}="C2'A TXD";
$resn_exch{"O2*  TXD"}="O2'A TXD"; $resn_exch{"C3*  TXD"}="C3'A TXD"; $resn_exch{"O3*  TXD"}="O3'A TXD";
$resn_exch{"C4*  TXD"}="C4'A TXD"; $resn_exch{"C5*  TXD"}="C5'A TXD"; $resn_exch{"O5*  TXD"}="O5'A TXD";
$resn_exch{"O5*  TXP"}="O5'A TXP"; $resn_exch{"C5*  TXP"}="C5'A TXP"; $resn_exch{"C4*  TXP"}="C4'A TXP";
$resn_exch{"C3*  TXP"}="C3'A TXP"; $resn_exch{"O3*  TXP"}="O3'A TXP"; $resn_exch{"C2*  TXP"}="C2'A TXP";
$resn_exch{"O2*  TXP"}="O2'A TXP"; $resn_exch{"C1*  TXP"}="C1'A TXP"; $resn_exch{"O4*  TXP"}="O4'A TXP";
$resn_exch{" O5* TYA"}=" O5' TYA"; $resn_exch{" C5* TYA"}=" C5' TYA"; $resn_exch{" C4* TYA"}=" C4' TYA";
$resn_exch{" O4* TYA"}=" O4' TYA"; $resn_exch{" C3* TYA"}=" C3' TYA"; $resn_exch{" O3* TYA"}=" O3' TYA";
$resn_exch{" C2* TYA"}=" C2' TYA"; $resn_exch{" O2* TYA"}=" O2' TYA"; $resn_exch{" C1* TYA"}=" C1' TYA";
$resn_exch{" O5* TYD"}=" O5' TYD"; $resn_exch{" C5* TYD"}=" C5' TYD"; $resn_exch{" C4* TYD"}=" C4' TYD";
$resn_exch{" O4* TYD"}=" O4' TYD"; $resn_exch{" C3* TYD"}=" C3' TYD"; $resn_exch{" O3* TYD"}=" O3' TYD";
$resn_exch{" C2* TYD"}=" C2' TYD"; $resn_exch{" C1* TYD"}=" C1' TYD"; $resn_exch{" O5* TYU"}=" O5' TYU";
$resn_exch{" C5* TYU"}=" C5' TYU"; $resn_exch{" C4* TYU"}=" C4' TYU"; $resn_exch{" O4* TYU"}=" O4' TYU";
$resn_exch{" C1* TYU"}=" C1' TYU"; $resn_exch{" C2* TYU"}=" C2' TYU"; $resn_exch{" O2* TYU"}=" O2' TYU";
$resn_exch{" C3* TYU"}=" C3' TYU"; $resn_exch{" O3* TYU"}=" O3' TYU"; $resn_exch{" N1* TZD"}=" N1' TZD";
$resn_exch{" C2* TZD"}=" C2' TZD"; $resn_exch{" N3* TZD"}=" N3' TZD"; $resn_exch{" C4* TZD"}=" C4' TZD";
$resn_exch{" N4* TZD"}=" N4' TZD"; $resn_exch{" C5* TZD"}=" C5' TZD"; $resn_exch{" C6* TZD"}=" C6' TZD";
$resn_exch{" C1* TZE"}=" C1' TZE"; $resn_exch{" C2* TZE"}=" C2' TZE"; $resn_exch{" O3P   U"}=" OP3   U";
$resn_exch{" O1P   U"}=" OP1   U"; $resn_exch{" O2P   U"}=" OP2   U"; $resn_exch{" O5*   U"}=" O5'   U";
$resn_exch{" C5*   U"}=" C5'   U"; $resn_exch{" C4*   U"}=" C4'   U"; $resn_exch{" O4*   U"}=" O4'   U";
$resn_exch{" C3*   U"}=" C3'   U"; $resn_exch{" O3*   U"}=" O3'   U"; $resn_exch{" C2*   U"}=" C2'   U";
$resn_exch{" O2*   U"}=" O2'   U"; $resn_exch{" C1*   U"}=" C1'   U"; $resn_exch{" O3P U25"}=" OP3 U25";
$resn_exch{" O1P U25"}=" OP1 U25"; $resn_exch{" O2P U25"}=" OP2 U25"; $resn_exch{" O5* U25"}=" O5' U25";
$resn_exch{" C5* U25"}=" C5' U25"; $resn_exch{" C4* U25"}=" C4' U25"; $resn_exch{" O4* U25"}=" O4' U25";
$resn_exch{" C3* U25"}=" C3' U25"; $resn_exch{" O3* U25"}=" O3' U25"; $resn_exch{" C2* U25"}=" C2' U25";
$resn_exch{" O2* U25"}=" O2' U25"; $resn_exch{" C1* U25"}=" C1' U25"; $resn_exch{"C1*G U2G"}=" C1B U2G";
$resn_exch{"C2*G U2G"}=" C2B U2G"; $resn_exch{"O2*G U2G"}=" O2B U2G"; $resn_exch{"C3*G U2G"}=" C3B U2G";
$resn_exch{"O3*G U2G"}=" O3B U2G"; $resn_exch{"C4*G U2G"}=" C4B U2G"; $resn_exch{"O4*G U2G"}=" O4B U2G";
$resn_exch{"C5*G U2G"}=" C5B U2G"; $resn_exch{"O5*G U2G"}=" O5B U2G"; $resn_exch{"O5*U U2G"}=" O5D U2G";
$resn_exch{"C5*U U2G"}=" C5D U2G"; $resn_exch{"C4*U U2G"}=" C4D U2G"; $resn_exch{"O4*U U2G"}=" O4D U2G";
$resn_exch{"C3*U U2G"}=" C3D U2G"; $resn_exch{"O3*U U2G"}=" O3D U2G"; $resn_exch{"C2*U U2G"}=" C2D U2G";
$resn_exch{"O2*U U2G"}=" O2D U2G"; $resn_exch{"C1*U U2G"}=" C1D U2G"; $resn_exch{" O3P U2L"}=" OP3 U2L";
$resn_exch{" O1P U2L"}=" OP1 U2L"; $resn_exch{" O2P U2L"}=" OP2 U2L"; $resn_exch{" O5* U2L"}=" O5' U2L";
$resn_exch{" C5* U2L"}=" C5' U2L"; $resn_exch{" C4* U2L"}=" C4' U2L"; $resn_exch{" O4* U2L"}=" O4' U2L";
$resn_exch{" C3* U2L"}=" C3' U2L"; $resn_exch{" O3* U2L"}=" O3' U2L"; $resn_exch{" C2* U2L"}=" C2' U2L";
$resn_exch{" O2* U2L"}=" O2' U2L"; $resn_exch{" C1* U2L"}=" C1' U2L"; $resn_exch{" CA* U2L"}=" CA' U2L";
$resn_exch{" CB* U2L"}=" CB' U2L"; $resn_exch{" OC* U2L"}=" OC' U2L"; $resn_exch{" CD* U2L"}=" CD' U2L";
$resn_exch{" O3P U2N"}=" OP3 U2N"; $resn_exch{" O1P U2N"}=" OP1 U2N"; $resn_exch{" O2P U2N"}=" OP2 U2N";
$resn_exch{" O5* U2N"}=" O5' U2N"; $resn_exch{" C5* U2N"}=" C5' U2N"; $resn_exch{" C4* U2N"}=" C4' U2N";
$resn_exch{" O4* U2N"}=" O4' U2N"; $resn_exch{" C1* U2N"}=" C1' U2N"; $resn_exch{" C2* U2N"}=" C2' U2N";
$resn_exch{" N2* U2N"}=" N2' U2N"; $resn_exch{" C3* U2N"}=" C3' U2N"; $resn_exch{" O3* U2N"}=" O3' U2N";
$resn_exch{" O5* U31"}=" O5' U31"; $resn_exch{" C5* U31"}=" C5' U31"; $resn_exch{" C4* U31"}=" C4' U31";
$resn_exch{" O4* U31"}=" O4' U31"; $resn_exch{" C3* U31"}=" C3' U31"; $resn_exch{" O3* U31"}=" O3' U31";
$resn_exch{" C2* U31"}=" C2' U31"; $resn_exch{" O2* U31"}=" O2' U31"; $resn_exch{" C1* U31"}=" C1' U31";
$resn_exch{" CA* U31"}=" CA' U31"; $resn_exch{" CB* U31"}=" CB' U31"; $resn_exch{" ND* U31"}=" ND' U31";
$resn_exch{" C1* U33"}=" C1' U33"; $resn_exch{" C2* U33"}=" C2' U33"; $resn_exch{" C3* U33"}=" C3' U33";
$resn_exch{" C4* U33"}=" C4' U33"; $resn_exch{" O3* U33"}=" O3' U33"; $resn_exch{" O4* U33"}=" O4' U33";
$resn_exch{" C5* U33"}=" C5' U33"; $resn_exch{" O5* U33"}=" O5' U33"; $resn_exch{" C5* U34"}=" C5' U34";
$resn_exch{" C4* U34"}=" C4' U34"; $resn_exch{" O4* U34"}=" O4' U34"; $resn_exch{" C3* U34"}=" C3' U34";
$resn_exch{" O3* U34"}=" O3' U34"; $resn_exch{" C2* U34"}=" C2' U34"; $resn_exch{" O2* U34"}=" O2' U34";
$resn_exch{" C1* U34"}=" C1' U34"; $resn_exch{" O5* U36"}=" O5' U36"; $resn_exch{" C5* U36"}=" C5' U36";
$resn_exch{" C4* U36"}=" C4' U36"; $resn_exch{" O4* U36"}=" O4' U36"; $resn_exch{" C3* U36"}=" C3' U36";
$resn_exch{" O3* U36"}=" O3' U36"; $resn_exch{" C2* U36"}=" C2' U36"; $resn_exch{" O2* U36"}=" O2' U36";
$resn_exch{" C1* U36"}=" C1' U36"; $resn_exch{" CA* U36"}=" CA' U36"; $resn_exch{" CB* U36"}=" CB' U36";
$resn_exch{" CD* U36"}=" CD' U36"; $resn_exch{" OC* U36"}=" OC' U36"; $resn_exch{" O5* U37"}=" O5' U37";
$resn_exch{" C5* U37"}=" C5' U37"; $resn_exch{" C4* U37"}=" C4' U37"; $resn_exch{" O4* U37"}=" O4' U37";
$resn_exch{" C3* U37"}=" C3' U37"; $resn_exch{" O3* U37"}=" O3' U37"; $resn_exch{" C2* U37"}=" C2' U37";
$resn_exch{" O2* U37"}=" O2' U37"; $resn_exch{" C1* U37"}=" C1' U37"; $resn_exch{" C1* U3H"}=" C1' U3H";
$resn_exch{" C2* U3H"}=" C2' U3H"; $resn_exch{" O2* U3H"}=" O2' U3H"; $resn_exch{" C3* U3H"}=" C3' U3H";
$resn_exch{" C4* U3H"}=" C4' U3H"; $resn_exch{" O4* U3H"}=" O4' U3H"; $resn_exch{" C5* U3H"}=" C5' U3H";
$resn_exch{" O5* U3H"}=" O5' U3H"; $resn_exch{" O5* U3P"}=" O5' U3P"; $resn_exch{" C5* U3P"}=" C5' U3P";
$resn_exch{" C4* U3P"}=" C4' U3P"; $resn_exch{" O4* U3P"}=" O4' U3P"; $resn_exch{" C3* U3P"}=" C3' U3P";
$resn_exch{" O3* U3P"}=" O3' U3P"; $resn_exch{" C2* U3P"}=" C2' U3P"; $resn_exch{" O2* U3P"}=" O2' U3P";
$resn_exch{" C1* U3P"}=" C1' U3P"; $resn_exch{" C1* U5P"}=" C1' U5P"; $resn_exch{" C2* U5P"}=" C2' U5P";
$resn_exch{" O2* U5P"}=" O2' U5P"; $resn_exch{" C3* U5P"}=" C3' U5P"; $resn_exch{" C4* U5P"}=" C4' U5P";
$resn_exch{" O3* U5P"}=" O3' U5P"; $resn_exch{" O4* U5P"}=" O4' U5P"; $resn_exch{" C5* U5P"}=" C5' U5P";
$resn_exch{" O5* U5P"}=" O5' U5P"; $resn_exch{" C1* U8U"}=" C1' U8U"; $resn_exch{" O2* U8U"}=" O2' U8U";
$resn_exch{" C2* U8U"}=" C2' U8U"; $resn_exch{" O3* U8U"}=" O3' U8U"; $resn_exch{" C3* U8U"}=" C3' U8U";
$resn_exch{" C4* U8U"}=" C4' U8U"; $resn_exch{" O4* U8U"}=" O4' U8U"; $resn_exch{" C5* U8U"}=" C5' U8U";
$resn_exch{" O5* U8U"}=" O5' U8U"; $resn_exch{" O1P U8U"}=" OP1 U8U"; $resn_exch{" O2P U8U"}=" OP2 U8U";
$resn_exch{" O3P U8U"}=" OP3 U8U"; $resn_exch{" O5* UA2"}=" O5' UA2"; $resn_exch{" C5* UA2"}=" C5' UA2";
$resn_exch{" C4* UA2"}=" C4' UA2"; $resn_exch{" N4* UA2"}=" N4' UA2"; $resn_exch{" C3* UA2"}=" C3' UA2";
$resn_exch{" O3* UA2"}=" O3' UA2"; $resn_exch{" C2* UA2"}=" C2' UA2"; $resn_exch{" O2* UA2"}=" O2' UA2";
$resn_exch{" C1* UA2"}=" C1' UA2"; $resn_exch{" O5* UA3"}=" O5' UA3"; $resn_exch{" C5* UA3"}=" C5' UA3";
$resn_exch{" C4* UA3"}=" C4' UA3"; $resn_exch{" O4* UA3"}=" O4' UA3"; $resn_exch{" C3* UA3"}=" C3' UA3";
$resn_exch{" O3* UA3"}=" O3' UA3"; $resn_exch{" C2* UA3"}=" C2' UA3"; $resn_exch{" O2* UA3"}=" O2' UA3";
$resn_exch{" C1* UA3"}=" C1' UA3"; $resn_exch{" C1* UAG"}=" C1B UAG"; $resn_exch{" C2* UAG"}=" C2B UAG";
$resn_exch{" O2* UAG"}=" O2' UAG"; $resn_exch{" C3* UAG"}=" C3B UAG"; $resn_exch{" O3* UAG"}=" O3B UAG";
$resn_exch{" C4* UAG"}=" C4B UAG"; $resn_exch{" O4* UAG"}=" O4B UAG"; $resn_exch{" C5* UAG"}=" C5B UAG";
$resn_exch{" O5* UAG"}=" O5B UAG"; $resn_exch{" O3P UAR"}=" OP3 UAR"; $resn_exch{" O1P UAR"}=" OP1 UAR";
$resn_exch{" O2P UAR"}=" OP2 UAR"; $resn_exch{" O5* UAR"}=" O5' UAR"; $resn_exch{" C5* UAR"}=" C5' UAR";
$resn_exch{" C4* UAR"}=" C4' UAR"; $resn_exch{" O4* UAR"}=" O4' UAR"; $resn_exch{" C3* UAR"}=" C3' UAR";
$resn_exch{" O3* UAR"}=" O3' UAR"; $resn_exch{" C2* UAR"}=" C2' UAR"; $resn_exch{" O2* UAR"}=" O2' UAR";
$resn_exch{" C1* UAR"}=" C1' UAR"; $resn_exch{" O5* UBB"}=" O5' UBB"; $resn_exch{" C5* UBB"}=" C5' UBB";
$resn_exch{" C4* UBB"}=" C4' UBB"; $resn_exch{" O4* UBB"}=" O4' UBB"; $resn_exch{" C1* UBB"}=" C1' UBB";
$resn_exch{" C2* UBB"}=" C2' UBB"; $resn_exch{" C3* UBB"}=" C3' UBB"; $resn_exch{" C1* UC5"}=" C1' UC5";
$resn_exch{" C2* UC5"}=" C2' UC5"; $resn_exch{" C3* UC5"}=" C3' UC5"; $resn_exch{" O3* UC5"}=" O3' UC5";
$resn_exch{" O4* UC5"}=" O4' UC5"; $resn_exch{" C4* UC5"}=" C4' UC5"; $resn_exch{" C5* UC5"}=" C5' UC5";
$resn_exch{" O5* UC5"}=" O5' UC5"; $resn_exch{" O5* UCL"}=" O5' UCL"; $resn_exch{" C5* UCL"}=" C5' UCL";
$resn_exch{" C4* UCL"}=" C4' UCL"; $resn_exch{" O4* UCL"}=" O4' UCL"; $resn_exch{" C3* UCL"}=" C3' UCL";
$resn_exch{" O3* UCL"}=" O3' UCL"; $resn_exch{" C2* UCL"}=" C2' UCL"; $resn_exch{" C1* UCL"}=" C1' UCL";
$resn_exch{" C1* UCP"}=" C1' UCP"; $resn_exch{" C2* UCP"}=" C2' UCP"; $resn_exch{" C3* UCP"}=" C3' UCP";
$resn_exch{" O3* UCP"}=" O3' UCP"; $resn_exch{" C4* UCP"}=" C4' UCP"; $resn_exch{" O4* UCP"}=" O4' UCP";
$resn_exch{" C5* UCP"}=" C5' UCP"; $resn_exch{" O5* UCP"}=" O5' UCP"; $resn_exch{" C1* UD1"}=" C1B UD1";
$resn_exch{" C2* UD1"}=" C2B UD1"; $resn_exch{" O2* UD1"}=" O2' UD1"; $resn_exch{" C3* UD1"}=" C3B UD1";
$resn_exch{" C4* UD1"}=" C4B UD1"; $resn_exch{" O4* UD1"}=" O4B UD1"; $resn_exch{" O3* UD1"}=" O3B UD1";
$resn_exch{" C5* UD1"}=" C5B UD1"; $resn_exch{" O5* UD1"}=" O5B UD1"; $resn_exch{" C1* UD2"}=" C1B UD2";
$resn_exch{" C2* UD2"}=" C2B UD2"; $resn_exch{" O2* UD2"}=" O2' UD2"; $resn_exch{" C3* UD2"}=" C3B UD2";
$resn_exch{" C4* UD2"}=" C4B UD2"; $resn_exch{" O4* UD2"}=" O4B UD2"; $resn_exch{" O3* UD2"}=" O3B UD2";
$resn_exch{" C5* UD2"}=" C5B UD2"; $resn_exch{" O5* UD2"}=" O5B UD2"; $resn_exch{" O1P UD5"}=" OP1 UD5";
$resn_exch{" O2P UD5"}=" OP2 UD5"; $resn_exch{" O5* UD5"}=" O5' UD5"; $resn_exch{" C5* UD5"}=" C5' UD5";
$resn_exch{" C4* UD5"}=" C4' UD5"; $resn_exch{" O4* UD5"}=" O4' UD5"; $resn_exch{" C3* UD5"}=" C3' UD5";
$resn_exch{" O3* UD5"}=" O3' UD5"; $resn_exch{" C2* UD5"}=" C2' UD5"; $resn_exch{" O2* UD5"}=" O2' UD5";
$resn_exch{" C1* UD5"}=" C1' UD5"; $resn_exch{" C1* UDH"}=" C1B UDH"; $resn_exch{" C2* UDH"}=" C2B UDH";
$resn_exch{" O2* UDH"}=" O2' UDH"; $resn_exch{" C3* UDH"}=" C3B UDH"; $resn_exch{" C4* UDH"}=" C4B UDH";
$resn_exch{" O4* UDH"}=" O4' UDH"; $resn_exch{" O3* UDH"}=" O3' UDH"; $resn_exch{" C5* UDH"}=" C5B UDH";
$resn_exch{" O5* UDH"}=" O5' UDH"; $resn_exch{" C1* UDM"}=" C1D UDM"; $resn_exch{" C2* UDM"}=" C2D UDM";
$resn_exch{" O2* UDM"}=" O2' UDM"; $resn_exch{" C3* UDM"}=" C3D UDM"; $resn_exch{" C4* UDM"}=" C4D UDM";
$resn_exch{" O4* UDM"}=" O4D UDM"; $resn_exch{" O3* UDM"}=" O3D UDM"; $resn_exch{" C5* UDM"}=" C5D UDM";
$resn_exch{" O5* UDM"}=" O5D UDM"; $resn_exch{" C1* UDP"}=" C1' UDP"; $resn_exch{" C2* UDP"}=" C2' UDP";
$resn_exch{" O2* UDP"}=" O2' UDP"; $resn_exch{" C3* UDP"}=" C3' UDP"; $resn_exch{" C4* UDP"}=" C4' UDP";
$resn_exch{" O4* UDP"}=" O4' UDP"; $resn_exch{" O3* UDP"}=" O3' UDP"; $resn_exch{" C5* UDP"}=" C5' UDP";
$resn_exch{" O5* UDP"}=" O5' UDP"; $resn_exch{" O5* UDX"}=" O5D UDX"; $resn_exch{" C5* UDX"}=" C5D UDX";
$resn_exch{" C4* UDX"}=" C4D UDX"; $resn_exch{" O4* UDX"}=" O4D UDX"; $resn_exch{" C3* UDX"}=" C3D UDX";
$resn_exch{" O3* UDX"}=" O3D UDX"; $resn_exch{" C2* UDX"}=" C2D UDX"; $resn_exch{" O2* UDX"}=" O2D UDX";
$resn_exch{" C1* UDX"}=" C1D UDX"; $resn_exch{" C1* UFG"}=" C1D UFG"; $resn_exch{" C2* UFG"}=" C2D UFG";
$resn_exch{" O2* UFG"}=" O2D UFG"; $resn_exch{" C3* UFG"}=" C3D UFG"; $resn_exch{" C4* UFG"}=" C4D UFG";
$resn_exch{" O4* UFG"}=" O4' UFG"; $resn_exch{" O3* UFG"}=" O3D UFG"; $resn_exch{" C5* UFG"}=" C5D UFG";
$resn_exch{" O5* UFG"}=" O5D UFG"; $resn_exch{" C1* UFM"}=" C1D UFM"; $resn_exch{" C2* UFM"}=" C2D UFM";
$resn_exch{" O2* UFM"}=" O2D UFM"; $resn_exch{" C3* UFM"}=" C3D UFM"; $resn_exch{" C4* UFM"}=" C4D UFM";
$resn_exch{" O4* UFM"}=" O4D UFM"; $resn_exch{" O3* UFM"}=" O3D UFM"; $resn_exch{" C5* UFM"}=" C5D UFM";
$resn_exch{" O5* UFM"}=" O5D UFM"; $resn_exch{" C1* UFP"}=" C1' UFP"; $resn_exch{" C2* UFP"}=" C2' UFP";
$resn_exch{" C3* UFP"}=" C3' UFP"; $resn_exch{" C4* UFP"}=" C4' UFP"; $resn_exch{" O3* UFP"}=" O3' UFP";
$resn_exch{" O4* UFP"}=" O4' UFP"; $resn_exch{" C5* UFP"}=" C5' UFP"; $resn_exch{" O5* UFP"}=" O5' UFP";
$resn_exch{" O5* UFR"}=" O5' UFR"; $resn_exch{" C5* UFR"}=" C5' UFR"; $resn_exch{" C4* UFR"}=" C4' UFR";
$resn_exch{" O4* UFR"}=" O4' UFR"; $resn_exch{" C3* UFR"}=" C3' UFR"; $resn_exch{" O3* UFR"}=" O3' UFR";
$resn_exch{" C2* UFR"}=" C2' UFR"; $resn_exch{" C1* UFR"}=" C1' UFR"; $resn_exch{"O6'1 UGA"}=" O'P UGA";
$resn_exch{"O6'2 UGA"}=" O'Q UGA"; $resn_exch{" O5* UGA"}=" O5D UGA"; $resn_exch{" C5* UGA"}=" C5D UGA";
$resn_exch{" C4* UGA"}=" C4D UGA"; $resn_exch{" O4* UGA"}=" O4D UGA"; $resn_exch{" C3* UGA"}=" C3D UGA";
$resn_exch{" O3* UGA"}=" O3D UGA"; $resn_exch{" C2* UGA"}=" C2D UGA"; $resn_exch{" O2* UGA"}=" O2D UGA";
$resn_exch{" C1* UGA"}=" C1D UGA"; $resn_exch{" C1* UM3"}=" C1' UM3"; $resn_exch{" C2* UM3"}=" C2' UM3";
$resn_exch{" C3* UM3"}=" C3' UM3"; $resn_exch{" C4* UM3"}=" C4' UM3"; $resn_exch{" O3* UM3"}=" O3' UM3";
$resn_exch{" O4* UM3"}=" O4' UM3"; $resn_exch{" C5* UM3"}=" C5' UM3"; $resn_exch{" O5* UM3"}=" O5' UM3";
$resn_exch{" C1* UMA"}=" C1B UMA"; $resn_exch{" C2* UMA"}=" C2B UMA"; $resn_exch{" O2* UMA"}=" O2' UMA";
$resn_exch{" C3* UMA"}=" C3B UMA"; $resn_exch{" C4* UMA"}=" C4B UMA"; $resn_exch{" O4* UMA"}=" O4B UMA";
$resn_exch{" O3* UMA"}=" O3B UMA"; $resn_exch{" C5* UMA"}=" C5B UMA"; $resn_exch{" O5* UMA"}=" O5B UMA";
$resn_exch{" O5* UMF"}=" O5' UMF"; $resn_exch{" C5* UMF"}=" C5' UMF"; $resn_exch{" C4* UMF"}=" C4' UMF";
$resn_exch{" O4* UMF"}=" O4' UMF"; $resn_exch{" C3* UMF"}=" C3' UMF"; $resn_exch{" O3* UMF"}=" O3' UMF";
$resn_exch{" C2* UMF"}=" C2' UMF"; $resn_exch{" F2* UMF"}=" F2' UMF"; $resn_exch{" C1* UMF"}=" C1' UMF";
$resn_exch{" C1* UMP"}=" C1' UMP"; $resn_exch{" C2* UMP"}=" C2' UMP"; $resn_exch{" C3* UMP"}=" C3' UMP";
$resn_exch{" C4* UMP"}=" C4' UMP"; $resn_exch{" O3* UMP"}=" O3' UMP"; $resn_exch{" O4* UMP"}=" O4' UMP";
$resn_exch{" C5* UMP"}=" C5' UMP"; $resn_exch{" O5* UMP"}=" O5' UMP"; $resn_exch{" O1P UMP"}=" OP1 UMP";
$resn_exch{" O2P UMP"}=" OP2 UMP"; $resn_exch{" O3P UMP"}=" OP3 UMP"; $resn_exch{" O3P UMS"}=" OP3 UMS";
$resn_exch{" O1P UMS"}=" OP1 UMS"; $resn_exch{" O2P UMS"}=" OP2 UMS"; $resn_exch{" C4* UN4"}=" C4' UN4";
$resn_exch{" C3* UN4"}=" C3' UN4"; $resn_exch{" C2* UN4"}=" C2' UN4"; $resn_exch{" C1* UP1"}=" C1' UP1";
$resn_exch{" C2* UP1"}=" C2' UP1"; $resn_exch{" O2* UP1"}=" O2' UP1"; $resn_exch{" C3* UP1"}=" C3' UP1";
$resn_exch{" C4* UP1"}=" C4' UP1"; $resn_exch{" O4* UP1"}=" O4' UP1"; $resn_exch{" O3* UP1"}=" O3' UP1";
$resn_exch{" C5* UP1"}=" C5' UP1"; $resn_exch{" O5* UP1"}=" O5' UP1"; $resn_exch{" AN9 UP5"}=" N9A UP5";
$resn_exch{" AC8 UP5"}=" C8A UP5"; $resn_exch{" AN7 UP5"}=" N7A UP5"; $resn_exch{" AC5 UP5"}=" C5A UP5";
$resn_exch{" AC6 UP5"}=" C6A UP5"; $resn_exch{" AN6 UP5"}=" N6A UP5"; $resn_exch{" AN1 UP5"}=" N1A UP5";
$resn_exch{" AC2 UP5"}=" C2A UP5"; $resn_exch{" AN3 UP5"}=" N3A UP5"; $resn_exch{" AC4 UP5"}=" C4A UP5";
$resn_exch{"AO5* UP5"}=" O5F UP5"; $resn_exch{"AC5* UP5"}=" C5F UP5"; $resn_exch{"AC4* UP5"}=" C4F UP5";
$resn_exch{"AO4* UP5"}=" O4F UP5"; $resn_exch{"AC3* UP5"}=" C3F UP5"; $resn_exch{"AO3* UP5"}=" O3F UP5";
$resn_exch{"AC2* UP5"}=" C2F UP5"; $resn_exch{"AO2* UP5"}=" O2F UP5"; $resn_exch{"AC1* UP5"}=" C1F UP5";
$resn_exch{"UO5* UP5"}=" O5J UP5"; $resn_exch{"UC5* UP5"}=" C5J UP5"; $resn_exch{"UC4* UP5"}=" C4J UP5";
$resn_exch{"UO4* UP5"}=" O4J UP5"; $resn_exch{"UC3* UP5"}=" C3J UP5"; $resn_exch{"UO3* UP5"}=" O3J UP5";
$resn_exch{"UC2* UP5"}=" C2J UP5"; $resn_exch{"UO2* UP5"}=" O2J UP5"; $resn_exch{"UC1* UP5"}=" C1J UP5";
$resn_exch{" UN1 UP5"}=" N1U UP5"; $resn_exch{" UC2 UP5"}=" C2U UP5"; $resn_exch{"UO2' UP5"}=" O2X UP5";
$resn_exch{" UN3 UP5"}=" N3U UP5"; $resn_exch{" UC4 UP5"}=" C4U UP5"; $resn_exch{" UO4 UP5"}=" O4U UP5";
$resn_exch{" UC5 UP5"}=" C5U UP5"; $resn_exch{" UC6 UP5"}=" C6U UP5"; $resn_exch{" C1* UP6"}=" C1' UP6";
$resn_exch{" C2* UP6"}=" C2' UP6"; $resn_exch{" C3* UP6"}=" C3' UP6"; $resn_exch{" C4* UP6"}=" C4' UP6";
$resn_exch{" O2* UP6"}=" O2' UP6"; $resn_exch{" O3* UP6"}=" O3' UP6"; $resn_exch{" O4* UP6"}=" O4' UP6";
$resn_exch{" C5* UP6"}=" C5' UP6"; $resn_exch{" O5* UP6"}=" O5' UP6"; $resn_exch{"C5*U UPA"}=" C5D UPA";
$resn_exch{"O5*U UPA"}=" O5D UPA"; $resn_exch{"C4*U UPA"}=" C4D UPA"; $resn_exch{"O4*U UPA"}=" O4D UPA";
$resn_exch{"C3*U UPA"}=" C3D UPA"; $resn_exch{"O3*U UPA"}=" O3D UPA"; $resn_exch{"C2*U UPA"}=" C2D UPA";
$resn_exch{"O2*U UPA"}=" O2D UPA"; $resn_exch{"C1*U UPA"}=" C1D UPA"; $resn_exch{"O5*A UPA"}=" O5B UPA";
$resn_exch{"C5*A UPA"}=" C5B UPA"; $resn_exch{"C4*A UPA"}=" C4B UPA"; $resn_exch{"O4*A UPA"}=" O4B UPA";
$resn_exch{"C3*A UPA"}=" C3B UPA"; $resn_exch{"O3*A UPA"}=" O3B UPA"; $resn_exch{"C2*A UPA"}=" C2B UPA";
$resn_exch{"O2*A UPA"}=" O2B UPA"; $resn_exch{"C1*A UPA"}=" C1B UPA"; $resn_exch{" C1* UPF"}=" C1D UPF";
$resn_exch{" C2* UPF"}=" C2D UPF"; $resn_exch{" O2* UPF"}=" O2' UPF"; $resn_exch{" C3* UPF"}=" C3D UPF";
$resn_exch{" C4* UPF"}=" C4D UPF"; $resn_exch{" O4* UPF"}=" O4D UPF"; $resn_exch{" O3* UPF"}=" O3D UPF";
$resn_exch{" C5* UPF"}=" C5D UPF"; $resn_exch{" O5* UPF"}=" O5D UPF"; $resn_exch{" C1* UPG"}=" C1C UPG";
$resn_exch{" C2* UPG"}=" C2C UPG"; $resn_exch{" O2* UPG"}=" O2C UPG"; $resn_exch{" C3* UPG"}=" C3C UPG";
$resn_exch{" C4* UPG"}=" C4C UPG"; $resn_exch{" O4* UPG"}=" O4C UPG"; $resn_exch{" O3* UPG"}=" O3C UPG";
$resn_exch{" C5* UPG"}=" C5C UPG"; $resn_exch{" O5* UPG"}=" O5C UPG"; $resn_exch{" C1* UPM"}=" C1' UPM";
$resn_exch{" C2* UPM"}=" C2' UPM"; $resn_exch{" O2* UPM"}=" O2' UPM"; $resn_exch{" C3* UPM"}=" C3' UPM";
$resn_exch{" O3* UPM"}=" O3' UPM"; $resn_exch{" C4* UPM"}=" C4' UPM"; $resn_exch{" O4* UPM"}=" O4' UPM";
$resn_exch{" C5* UPM"}=" C5' UPM"; $resn_exch{" O5* UPM"}=" O5' UPM"; $resn_exch{" C1* UPP"}=" C1B UPP";
$resn_exch{" C2* UPP"}=" C2B UPP"; $resn_exch{" O2* UPP"}=" O2' UPP"; $resn_exch{" C3* UPP"}=" C3B UPP";
$resn_exch{" C4* UPP"}=" C4B UPP"; $resn_exch{" O4* UPP"}=" O4' UPP"; $resn_exch{" O3* UPP"}=" O3' UPP";
$resn_exch{" C5* UPP"}=" C5B UPP"; $resn_exch{" O5* UPP"}=" O5' UPP"; $resn_exch{" C5* UPR"}=" C5' UPR";
$resn_exch{" O5* UPR"}=" O5' UPR"; $resn_exch{" C4* UPR"}=" C4' UPR"; $resn_exch{" O4* UPR"}=" O4' UPR";
$resn_exch{" C3* UPR"}=" C3' UPR"; $resn_exch{" O3* UPR"}=" O3' UPR"; $resn_exch{" C2* UPR"}=" C2' UPR";
$resn_exch{" C1* UPR"}=" C1' UPR"; $resn_exch{"C1*A UPU"}="C1'A UPU"; $resn_exch{"O4*A UPU"}="O4'A UPU";
$resn_exch{"C2*A UPU"}="C2'A UPU"; $resn_exch{"O2*A UPU"}="O2'A UPU"; $resn_exch{"C3*A UPU"}="C3'A UPU";
$resn_exch{"O3*A UPU"}="O3'A UPU"; $resn_exch{"C4*A UPU"}="C4'A UPU"; $resn_exch{"C5*A UPU"}="C5'A UPU";
$resn_exch{"O5*A UPU"}="O5'A UPU"; $resn_exch{"O3*B UPU"}="O3'B UPU"; $resn_exch{"C3*B UPU"}="C3'B UPU";
$resn_exch{"C4*B UPU"}="C4'B UPU"; $resn_exch{"C5*B UPU"}="C5'B UPU"; $resn_exch{"O5*B UPU"}="O5'B UPU";
$resn_exch{"O4*B UPU"}="O4'B UPU"; $resn_exch{"C2*B UPU"}="C2'B UPU"; $resn_exch{"O2*B UPU"}="O2'B UPU";
$resn_exch{"C1*B UPU"}="C1'B UPU"; $resn_exch{" O1P UR3"}=" OP1 UR3"; $resn_exch{" O2P UR3"}=" OP2 UR3";
$resn_exch{" O5* UR3"}=" O5' UR3"; $resn_exch{" C5* UR3"}=" C5' UR3"; $resn_exch{" C4* UR3"}=" C4' UR3";
$resn_exch{" O4* UR3"}=" O4' UR3"; $resn_exch{" C1* UR3"}=" C1' UR3"; $resn_exch{" C2* UR3"}=" C2' UR3";
$resn_exch{" O2* UR3"}=" O2' UR3"; $resn_exch{" C3* UR3"}=" C3' UR3"; $resn_exch{" O3* UR3"}=" O3' UR3";
$resn_exch{" O3P UR3"}=" OP3 UR3"; $resn_exch{" O5* URD"}=" O5' URD"; $resn_exch{" C5* URD"}=" C5' URD";
$resn_exch{" C4* URD"}=" C4' URD"; $resn_exch{" O4* URD"}=" O4' URD"; $resn_exch{" C1* URD"}=" C1' URD";
$resn_exch{" C2* URD"}=" C2' URD"; $resn_exch{" O2* URD"}=" O2' URD"; $resn_exch{" C3* URD"}=" C3' URD";
$resn_exch{" O3* URD"}=" O3' URD"; $resn_exch{" C1* URI"}=" C1' URI"; $resn_exch{" C2* URI"}=" C2' URI";
$resn_exch{" C3* URI"}=" C3' URI"; $resn_exch{" C4* URI"}=" C4' URI"; $resn_exch{" O2* URI"}=" O2' URI";
$resn_exch{" O3* URI"}=" O3' URI"; $resn_exch{" O4* URI"}=" O4' URI"; $resn_exch{" C5* URI"}=" C5' URI";
$resn_exch{" O5* URI"}=" O5' URI"; $resn_exch{" O5* US1"}=" O5' US1"; $resn_exch{" C5* US1"}=" C5' US1";
$resn_exch{" C4* US1"}=" C4' US1"; $resn_exch{" O4* US1"}=" O4' US1"; $resn_exch{" C3* US1"}=" C3' US1";
$resn_exch{" C2* US1"}=" C2' US1"; $resn_exch{" C1* US1"}=" C1' US1"; $resn_exch{" C1* USQ"}=" C1D USQ";
$resn_exch{" C2* USQ"}=" C2D USQ"; $resn_exch{" O2* USQ"}=" O2D USQ"; $resn_exch{" C3* USQ"}=" C3D USQ";
$resn_exch{" C4* USQ"}=" C4D USQ"; $resn_exch{" O4* USQ"}=" O4D USQ"; $resn_exch{" O3* USQ"}=" O3D USQ";
$resn_exch{" C5* USQ"}=" C5D USQ"; $resn_exch{" O5* USQ"}=" O5D USQ"; $resn_exch{" O5* UTP"}=" O5' UTP";
$resn_exch{" C5* UTP"}=" C5' UTP"; $resn_exch{" C4* UTP"}=" C4' UTP"; $resn_exch{" O4* UTP"}=" O4' UTP";
$resn_exch{" C1* UTP"}=" C1' UTP"; $resn_exch{" C2* UTP"}=" C2' UTP"; $resn_exch{" O2* UTP"}=" O2' UTP";
$resn_exch{" C3* UTP"}=" C3' UTP"; $resn_exch{" O3* UTP"}=" O3' UTP"; $resn_exch{" C1* UVC"}=" C1' UVC";
$resn_exch{" C2* UVC"}=" C2' UVC"; $resn_exch{" O2* UVC"}=" O2' UVC"; $resn_exch{" C3* UVC"}=" C3' UVC";
$resn_exch{" C4* UVC"}=" C4' UVC"; $resn_exch{" O3* UVC"}=" O3' UVC"; $resn_exch{" O4* UVC"}=" O4' UVC";
$resn_exch{" C5* UVC"}=" C5' UVC"; $resn_exch{" O5* UVC"}=" O5' UVC"; $resn_exch{" N5* VAA"}=" N5' VAA";
$resn_exch{" C5* VAA"}=" C5' VAA"; $resn_exch{" C4* VAA"}=" C4' VAA"; $resn_exch{" O4* VAA"}=" O4' VAA";
$resn_exch{" C1* VAA"}=" C1' VAA"; $resn_exch{" C2* VAA"}=" C2' VAA"; $resn_exch{" O2* VAA"}=" O2' VAA";
$resn_exch{" C3* VAA"}=" C3' VAA"; $resn_exch{" O3* VAA"}=" O3' VAA"; $resn_exch{" C1\" VAN"}=" C1B VAN";
$resn_exch{" C2\" VAN"}=" C2B VAN"; $resn_exch{" C3\" VAN"}=" C3B VAN"; $resn_exch{" N3\" VAN"}=" N3' VAN";
$resn_exch{" C4\" VAN"}=" C4B VAN"; $resn_exch{" O4\" VAN"}=" O4B VAN"; $resn_exch{" C5\" VAN"}=" C5B VAN";
$resn_exch{" O5\" VAN"}=" O5B VAN"; $resn_exch{" C1\" VAX"}=" C1B VAX"; $resn_exch{" C2\" VAX"}=" C2B VAX";
$resn_exch{" C3\" VAX"}=" C3B VAX"; $resn_exch{" N3\" VAX"}=" N3' VAX"; $resn_exch{" C4\" VAX"}=" C4B VAX";
$resn_exch{" O4\" VAX"}=" O4B VAX"; $resn_exch{" C5\" VAX"}=" C5B VAX"; $resn_exch{" O5\" VAX"}=" O5B VAX";
$resn_exch{" N1* VDM"}=" N1' VDM"; $resn_exch{" C1* VDM"}=" C1' VDM"; $resn_exch{" C2* VDM"}=" C2' VDM";
$resn_exch{" O2* VDM"}=" O2' VDM"; $resn_exch{" C6* VDM"}=" C6' VDM"; $resn_exch{" C5* VDM"}=" C5' VDM";
$resn_exch{" C7* VDM"}=" C7' VDM"; $resn_exch{" O7* VDM"}=" O7' VDM"; $resn_exch{" C4* VDM"}=" C4' VDM";
$resn_exch{" O4* VDM"}=" O4' VDM"; $resn_exch{" C3* VDM"}=" C3' VDM"; $resn_exch{" O3* VDM"}=" O3' VDM";
$resn_exch{" O5* VMS"}=" O5' VMS"; $resn_exch{" C5* VMS"}=" C5' VMS"; $resn_exch{" C4* VMS"}=" C4' VMS";
$resn_exch{" O4* VMS"}=" O4' VMS"; $resn_exch{" C3* VMS"}=" C3' VMS"; $resn_exch{" O3* VMS"}=" O3' VMS";
$resn_exch{" C2* VMS"}=" C2' VMS"; $resn_exch{" O2* VMS"}=" O2' VMS"; $resn_exch{" C1* VMS"}=" C1' VMS";
$resn_exch{"1H    VX"}=" H1   VX"; $resn_exch{" C5* WWF"}=" C5' WWF"; $resn_exch{" C6* WWF"}=" C6' WWF";
$resn_exch{" N1* WWF"}=" N1' WWF"; $resn_exch{" C2* WWF"}=" C2' WWF"; $resn_exch{" N3* WWF"}=" N3' WWF";
$resn_exch{" C4* WWF"}=" C4' WWF"; $resn_exch{" N4* WWF"}=" N4' WWF"; $resn_exch{" O1P   X"}=" OP1   X";
$resn_exch{" O2P   X"}=" OP2   X"; $resn_exch{" O3P   X"}=" OP3   X"; $resn_exch{" O5*   X"}=" O5'   X";
$resn_exch{" C5*   X"}=" C5'   X"; $resn_exch{" C4*   X"}=" C4'   X"; $resn_exch{" O4*   X"}=" O4'   X";
$resn_exch{" C3*   X"}=" C3'   X"; $resn_exch{" O3*   X"}=" O3'   X"; $resn_exch{" C2*   X"}=" C2'   X";
$resn_exch{" C1*   X"}=" C1'   X"; $resn_exch{" O3P X4A"}=" OP3 X4A"; $resn_exch{" O1P X4A"}=" OP1 X4A";
$resn_exch{" O2P X4A"}=" OP2 X4A"; $resn_exch{" O5* X4A"}=" O5' X4A"; $resn_exch{" C5* X4A"}=" C5' X4A";
$resn_exch{" C4* X4A"}=" C4' X4A"; $resn_exch{" O4* X4A"}=" O4' X4A"; $resn_exch{" C1* X4A"}=" C1' X4A";
$resn_exch{" C3* X4A"}=" C3' X4A"; $resn_exch{" C2* X4A"}=" C2' X4A"; $resn_exch{" O3* X4A"}=" O3' X4A";
$resn_exch{" O3P XAD"}=" OP3 XAD"; $resn_exch{" O1P XAD"}=" OP1 XAD"; $resn_exch{" O2P XAD"}=" OP2 XAD";
$resn_exch{" O1P XAE"}=" OP1 XAE"; $resn_exch{" O2P XAE"}=" OP2 XAE"; $resn_exch{" O3P XAE"}=" OP3 XAE";
$resn_exch{" O1P XAL"}=" OP1 XAL"; $resn_exch{" O2P XAL"}=" OP2 XAL"; $resn_exch{" O5* XAL"}=" O5' XAL";
$resn_exch{" C5* XAL"}=" C5' XAL"; $resn_exch{" C4* XAL"}=" C4' XAL"; $resn_exch{" C6* XAL"}=" C6' XAL";
$resn_exch{" C7* XAL"}=" C7' XAL"; $resn_exch{" C3* XAL"}=" C3' XAL"; $resn_exch{" O3* XAL"}=" O3' XAL";
$resn_exch{" C2* XAL"}=" C2' XAL"; $resn_exch{" C1* XAL"}=" C1' XAL"; $resn_exch{" O3P XAL"}=" OP3 XAL";
$resn_exch{" O5* XAR"}=" O5' XAR"; $resn_exch{" C5* XAR"}=" C5' XAR"; $resn_exch{" C4* XAR"}=" C4' XAR";
$resn_exch{" C3* XAR"}=" C3' XAR"; $resn_exch{" O3* XAR"}=" O3' XAR"; $resn_exch{" C2* XAR"}=" C2' XAR";
$resn_exch{" C1* XAR"}=" C1' XAR"; $resn_exch{" C7* XAR"}=" C7' XAR"; $resn_exch{" C6* XAR"}=" C6' XAR";
$resn_exch{" O1P XCL"}=" OP1 XCL"; $resn_exch{" O2P XCL"}=" OP2 XCL"; $resn_exch{" O5* XCL"}=" O5' XCL";
$resn_exch{" C5* XCL"}=" C5' XCL"; $resn_exch{" C4* XCL"}=" C4' XCL"; $resn_exch{" C6* XCL"}=" C6' XCL";
$resn_exch{" C7* XCL"}=" C7' XCL"; $resn_exch{" C3* XCL"}=" C3' XCL"; $resn_exch{" O3* XCL"}=" O3' XCL";
$resn_exch{" C2* XCL"}=" C2' XCL"; $resn_exch{" C1* XCL"}=" C1' XCL"; $resn_exch{" O3P XCL"}=" OP3 XCL";
$resn_exch{" O2P XCS"}=" OP2 XCS"; $resn_exch{" O1P XCS"}=" OP1 XCS"; $resn_exch{" O3P XCS"}=" OP3 XCS";
$resn_exch{" O3P XCT"}=" OP3 XCT"; $resn_exch{" O1P XCT"}=" OP1 XCT"; $resn_exch{" O2P XCT"}=" OP2 XCT";
$resn_exch{" O3P XCY"}=" OP3 XCY"; $resn_exch{" O2P XCY"}=" OP2 XCY"; $resn_exch{" O5* XCY"}=" O5' XCY";
$resn_exch{" C2* XCY"}=" C2' XCY"; $resn_exch{" C5* XCY"}=" C5' XCY"; $resn_exch{" C4* XCY"}=" C4' XCY";
$resn_exch{" O4* XCY"}=" O4' XCY"; $resn_exch{" C1* XCY"}=" C1' XCY"; $resn_exch{" C3* XCY"}=" C3' XCY";
$resn_exch{" O3* XCY"}=" O3' XCY"; $resn_exch{" O1P XCY"}=" OP1 XCY"; $resn_exch{" O1P XGA"}=" OP1 XGA";
$resn_exch{" O2P XGA"}=" OP2 XGA"; $resn_exch{" O3P XGA"}=" OP3 XGA"; $resn_exch{" O1P XGL"}=" OP1 XGL";
$resn_exch{" O2P XGL"}=" OP2 XGL"; $resn_exch{" O5* XGL"}=" O5' XGL"; $resn_exch{" C5* XGL"}=" C5' XGL";
$resn_exch{" C4* XGL"}=" C4' XGL"; $resn_exch{" C6* XGL"}=" C6' XGL"; $resn_exch{" C7* XGL"}=" C7' XGL";
$resn_exch{" C3* XGL"}=" C3' XGL"; $resn_exch{" O3* XGL"}=" O3' XGL"; $resn_exch{" C2* XGL"}=" C2' XGL";
$resn_exch{" C1* XGL"}=" C1' XGL"; $resn_exch{" O3P XGL"}=" OP3 XGL"; $resn_exch{" O3P XGU"}=" OP3 XGU";
$resn_exch{" O1P XGU"}=" OP1 XGU"; $resn_exch{" O2P XGU"}=" OP2 XGU"; $resn_exch{"C12' XR2"}=" CCX XR2";
$resn_exch{"C13' XR2"}=" CDX XR2"; $resn_exch{"C14' XR2"}=" CEX XR2"; $resn_exch{"N10' XR2"}=" NAX XR2";
$resn_exch{"C11' XR2"}=" CBX XR2"; $resn_exch{"C9A' XR2"}=" C9X XR2"; $resn_exch{" O3P XTH"}=" OP3 XTH";
$resn_exch{" O1P XTH"}=" OP1 XTH"; $resn_exch{" O2P XTH"}=" OP2 XTH"; $resn_exch{" O1P XTL"}=" OP1 XTL";
$resn_exch{" O2P XTL"}=" OP2 XTL"; $resn_exch{" O5* XTL"}=" O5' XTL"; $resn_exch{" C5* XTL"}=" C5' XTL";
$resn_exch{" C4* XTL"}=" C4' XTL"; $resn_exch{" C6* XTL"}=" C6' XTL"; $resn_exch{" C7* XTL"}=" C7' XTL";
$resn_exch{" C3* XTL"}=" C3' XTL"; $resn_exch{" O3* XTL"}=" O3' XTL"; $resn_exch{" C2* XTL"}=" C2' XTL";
$resn_exch{" C1* XTL"}=" C1' XTL"; $resn_exch{" O3P XTL"}=" OP3 XTL"; $resn_exch{" C1* XTS"}=" C1' XTS";
$resn_exch{" O4* XTS"}=" O4' XTS"; $resn_exch{" C4* XTS"}=" C4' XTS"; $resn_exch{" C5* XTS"}=" C5' XTS";
$resn_exch{" O5* XTS"}=" O5' XTS"; $resn_exch{" C3* XTS"}=" C3' XTS"; $resn_exch{" O3* XTS"}=" O3' XTS";
$resn_exch{" C2* XTS"}=" C2' XTS"; $resn_exch{" O2* XTS"}=" O2' XTS"; $resn_exch{" O1P XTY"}=" OP1 XTY";
$resn_exch{" O2P XTY"}=" OP2 XTY"; $resn_exch{" O3P XTY"}=" OP3 XTY"; $resn_exch{" C1* XUG"}=" C1' XUG";
$resn_exch{" O4* XUG"}=" O4' XUG"; $resn_exch{" C2* XUG"}=" C2' XUG"; $resn_exch{"SE2* XUG"}="SE2' XUG";
$resn_exch{" CA* XUG"}=" CA' XUG"; $resn_exch{" C3* XUG"}=" C3' XUG"; $resn_exch{" O3* XUG"}=" O3' XUG";
$resn_exch{" C4* XUG"}=" C4' XUG"; $resn_exch{" C5* XUG"}=" C5' XUG"; $resn_exch{" O5* XUG"}=" O5' XUG";
$resn_exch{" O1P XUG"}=" OP1 XUG"; $resn_exch{" O2P XUG"}=" OP2 XUG"; $resn_exch{" O3P XUG"}=" OP3 XUG";
$resn_exch{" O1P   Y"}=" OP1   Y"; $resn_exch{" O2P   Y"}=" OP2   Y"; $resn_exch{" O3P   Y"}=" OP3   Y";
$resn_exch{" O5*   Y"}=" O5'   Y"; $resn_exch{" C5*   Y"}=" C5'   Y"; $resn_exch{" C4*   Y"}=" C4'   Y";
$resn_exch{" O4*   Y"}=" O4'   Y"; $resn_exch{" C3*   Y"}=" C3'   Y"; $resn_exch{" O3*   Y"}=" O3'   Y";
$resn_exch{" C2*   Y"}=" C2'   Y"; $resn_exch{" C1*   Y"}=" C1'   Y"; $resn_exch{" AN1 YE1"}=" N1A YE1";
$resn_exch{" AC2 YE1"}=" C2A YE1"; $resn_exch{" AN3 YE1"}=" N3A YE1"; $resn_exch{" AC4 YE1"}=" C4A YE1";
$resn_exch{" AC5 YE1"}=" C5A YE1"; $resn_exch{" AC6 YE1"}=" C6A YE1"; $resn_exch{" AN6 YE1"}=" N6A YE1";
$resn_exch{" AN7 YE1"}=" N7A YE1"; $resn_exch{" AC8 YE1"}=" C8A YE1"; $resn_exch{" AN9 YE1"}=" N9A YE1";
$resn_exch{" C1* YE1"}=" C1' YE1"; $resn_exch{" C2* YE1"}=" C2' YE1"; $resn_exch{" O2* YE1"}=" O2' YE1";
$resn_exch{" C3* YE1"}=" C3' YE1"; $resn_exch{" O3* YE1"}=" O3' YE1"; $resn_exch{" P3* YE1"}=" P3' YE1";
$resn_exch{" AO7 YE1"}=" O7A YE1"; $resn_exch{" AO8 YE1"}=" O8A YE1"; $resn_exch{" AO9 YE1"}=" O9A YE1";
$resn_exch{" C4* YE1"}=" C4' YE1"; $resn_exch{" O4* YE1"}=" O4' YE1"; $resn_exch{" C5* YE1"}=" C5' YE1";
$resn_exch{" O5* YE1"}=" O5' YE1"; $resn_exch{" AP1 YE1"}=" P1A YE1"; $resn_exch{" AO1 YE1"}=" O1A YE1";
$resn_exch{" AO2 YE1"}=" O2A YE1"; $resn_exch{" AO3 YE1"}=" O3A YE1"; $resn_exch{" AP2 YE1"}=" P2A YE1";
$resn_exch{" AO4 YE1"}=" O4A YE1"; $resn_exch{" AO5 YE1"}=" O5A YE1"; $resn_exch{" AO6 YE1"}=" O6A YE1";
$resn_exch{" PC9 YE1"}=" C9P YE1"; $resn_exch{" PO9 YE1"}=" O9P YE1"; $resn_exch{" PN8 YE1"}=" N8P YE1";
$resn_exch{" PC7 YE1"}=" C7P YE1"; $resn_exch{" PC6 YE1"}=" C6P YE1"; $resn_exch{" PC5 YE1"}=" C5P YE1";
$resn_exch{" PO5 YE1"}=" O5P YE1"; $resn_exch{" PN4 YE1"}=" N4P YE1"; $resn_exch{" PC3 YE1"}=" C3P YE1";
$resn_exch{" PC2 YE1"}=" C2P YE1"; $resn_exch{" C1*  YG"}=" C1'  YG"; $resn_exch{" C2*  YG"}=" C2'  YG";
$resn_exch{" O2*  YG"}=" O2'  YG"; $resn_exch{" C3*  YG"}=" C3'  YG"; $resn_exch{" O3*  YG"}=" O3'  YG";
$resn_exch{" C4*  YG"}=" C4'  YG"; $resn_exch{" O4*  YG"}=" O4'  YG"; $resn_exch{" C5*  YG"}=" C5'  YG";
$resn_exch{" O5*  YG"}=" O5'  YG"; $resn_exch{" O1P  YG"}=" OP1  YG"; $resn_exch{" O2P  YG"}=" OP2  YG";
$resn_exch{" O3P  YG"}=" OP3  YG"; $resn_exch{" O5* YLY"}=" O5' YLY"; $resn_exch{" C5* YLY"}=" C5' YLY";
$resn_exch{" C4* YLY"}=" C4' YLY"; $resn_exch{" O4* YLY"}=" O4' YLY"; $resn_exch{" C3* YLY"}=" C3' YLY";
$resn_exch{" O3* YLY"}=" O3' YLY"; $resn_exch{" C2* YLY"}=" C2' YLY"; $resn_exch{" O2* YLY"}=" O2' YLY";
$resn_exch{" C1* YLY"}=" C1' YLY"; $resn_exch{" O5* YMP"}=" O5' YMP"; $resn_exch{" C5* YMP"}=" C5' YMP";
$resn_exch{" C4* YMP"}=" C4' YMP"; $resn_exch{" O4* YMP"}=" O4' YMP"; $resn_exch{" C1* YMP"}=" C1' YMP";
$resn_exch{" C2* YMP"}=" C2' YMP"; $resn_exch{" C3* YMP"}=" C3' YMP"; $resn_exch{" O3* YMP"}=" O3' YMP";
$resn_exch{" O2* YMP"}=" O2' YMP"; $resn_exch{" O3P YRR"}=" OP3 YRR"; $resn_exch{" O1P YRR"}=" OP1 YRR";
$resn_exch{" O2P YRR"}=" OP2 YRR"; $resn_exch{" O5* YRR"}=" O5' YRR"; $resn_exch{" C5* YRR"}=" C5' YRR";
$resn_exch{" C4* YRR"}=" C4' YRR"; $resn_exch{" N4* YRR"}=" N4' YRR"; $resn_exch{" C3* YRR"}=" C3' YRR";
$resn_exch{" O3* YRR"}=" O3' YRR"; $resn_exch{" C2* YRR"}=" C2' YRR"; $resn_exch{" C1* YRR"}=" C1' YRR";
$resn_exch{" O5* YSA"}=" O5' YSA"; $resn_exch{" C5* YSA"}=" C5' YSA"; $resn_exch{" C4* YSA"}=" C4' YSA";
$resn_exch{" O4* YSA"}=" O4' YSA"; $resn_exch{" C3* YSA"}=" C3' YSA"; $resn_exch{" O3* YSA"}=" O3' YSA";
$resn_exch{" C2* YSA"}=" C2' YSA"; $resn_exch{" O2* YSA"}=" O2' YSA"; $resn_exch{" C1* YSA"}=" C1' YSA";
$resn_exch{" O1P YYG"}=" OP1 YYG"; $resn_exch{" O2P YYG"}=" OP2 YYG"; $resn_exch{" O3P YYG"}=" OP3 YYG";
$resn_exch{" O5* YYG"}=" O5' YYG"; $resn_exch{" C5* YYG"}=" C5' YYG"; $resn_exch{" C4* YYG"}=" C4' YYG";
$resn_exch{" O4* YYG"}=" O4' YYG"; $resn_exch{" C3* YYG"}=" C3' YYG"; $resn_exch{" O3* YYG"}=" O3' YYG";
$resn_exch{" C2* YYG"}=" C2' YYG"; $resn_exch{" O2* YYG"}=" O2' YYG"; $resn_exch{" C1* YYG"}=" C1' YYG";
$resn_exch{" O5* YYY"}=" O5' YYY"; $resn_exch{" C5* YYY"}=" C5' YYY"; $resn_exch{" C4* YYY"}=" C4' YYY";
$resn_exch{" O4* YYY"}=" O4' YYY"; $resn_exch{" C3* YYY"}=" C3' YYY"; $resn_exch{" O3* YYY"}=" O3' YYY";
$resn_exch{" C2* YYY"}=" C2' YYY"; $resn_exch{" C1* YYY"}=" C1' YYY"; $resn_exch{" O1P   Z"}=" OP1   Z";
$resn_exch{" O2P   Z"}=" OP2   Z"; $resn_exch{" O5*   Z"}=" O5'   Z"; $resn_exch{" C5*   Z"}=" C5'   Z";
$resn_exch{" C4*   Z"}=" C4'   Z"; $resn_exch{" O4*   Z"}=" O4'   Z"; $resn_exch{" C3*   Z"}=" C3'   Z";
$resn_exch{" O3*   Z"}=" O3'   Z"; $resn_exch{" C2*   Z"}=" C2'   Z"; $resn_exch{" C1*   Z"}=" C1'   Z";
$resn_exch{" O3P   Z"}=" OP3   Z"; $resn_exch{" O5* Z5A"}=" O5B Z5A"; $resn_exch{" C5* Z5A"}=" C5B Z5A";
$resn_exch{" C4* Z5A"}=" C4B Z5A"; $resn_exch{" O4* Z5A"}=" O4B Z5A"; $resn_exch{" C3* Z5A"}=" C3B Z5A";
$resn_exch{" O3* Z5A"}=" O3' Z5A"; $resn_exch{" C2* Z5A"}=" C2B Z5A"; $resn_exch{" O2* Z5A"}=" O2' Z5A";
$resn_exch{" C1* Z5A"}=" C1B Z5A"; $resn_exch{"*CP1 ZAF"}=" C1X ZAF"; $resn_exch{"*CP2 ZAF"}=" C2X ZAF";
$resn_exch{"*CP3 ZAF"}=" C3X ZAF"; $resn_exch{"*CP4 ZAF"}=" C4X ZAF"; $resn_exch{"*CP5 ZAF"}=" C5X ZAF";
$resn_exch{"*CP6 ZAF"}=" C6X ZAF"; $resn_exch{" O1P ZDU"}=" OP1 ZDU"; $resn_exch{" O2P ZDU"}=" OP2 ZDU";
$resn_exch{" O5* ZDU"}=" O5' ZDU"; $resn_exch{" C2* ZDU"}=" C2' ZDU"; $resn_exch{" C5* ZDU"}=" C5' ZDU";
$resn_exch{" C4* ZDU"}=" C4' ZDU"; $resn_exch{" O4* ZDU"}=" O4' ZDU"; $resn_exch{" C1* ZDU"}=" C1' ZDU";
$resn_exch{" C3* ZDU"}=" C3' ZDU"; $resn_exch{" O3* ZDU"}=" O3' ZDU"; $resn_exch{" O3P ZDU"}=" OP3 ZDU";
$resn_exch{"CZ10 ZED"}=" CZA ZED"; $resn_exch{"CZ11 ZED"}=" CZB ZED"; $resn_exch{"CZ12 ZED"}=" CZC ZED";
$resn_exch{"CZ13 ZED"}=" CZD ZED"; $resn_exch{"CZ14 ZED"}=" CZE ZED"; $resn_exch{"CZ15 ZED"}=" CZF ZED";
$resn_exch{" N_A ZEM"}=" NA  ZEM"; $resn_exch{" N_B ZEM"}=" NB  ZEM"; $resn_exch{" N_C ZEM"}=" NC  ZEM";
$resn_exch{" N_D ZEM"}=" ND  ZEM"; $resn_exch{" AP  ZID"}=" PA  ZID"; $resn_exch{" AO1 ZID"}=" O1A ZID";
$resn_exch{" AO2 ZID"}=" O2A ZID"; $resn_exch{"AO5* ZID"}=" O5B ZID"; $resn_exch{"AC5* ZID"}=" C5B ZID";
$resn_exch{"AC4* ZID"}=" C4B ZID"; $resn_exch{"AO4* ZID"}=" O4B ZID"; $resn_exch{"AC3* ZID"}=" C3B ZID";
$resn_exch{"AO3* ZID"}=" O3B ZID"; $resn_exch{"AC2* ZID"}=" C2B ZID"; $resn_exch{"AO2* ZID"}=" O2B ZID";
$resn_exch{"AC1* ZID"}=" C1B ZID"; $resn_exch{" AN9 ZID"}=" N9A ZID"; $resn_exch{" AC8 ZID"}=" C8A ZID";
$resn_exch{" AN7 ZID"}=" N7A ZID"; $resn_exch{" AC5 ZID"}=" C5A ZID"; $resn_exch{" AC6 ZID"}=" C6A ZID";
$resn_exch{" AN6 ZID"}=" N6A ZID"; $resn_exch{" AN1 ZID"}=" N1A ZID"; $resn_exch{" AC2 ZID"}=" C2A ZID";
$resn_exch{" AN3 ZID"}=" N3A ZID"; $resn_exch{" AC4 ZID"}=" C4A ZID"; $resn_exch{" NP  ZID"}=" PN  ZID";
$resn_exch{" NO1 ZID"}=" O1N ZID"; $resn_exch{" NO2 ZID"}=" O2N ZID"; $resn_exch{"NO5* ZID"}=" O5D ZID";
$resn_exch{"NC5* ZID"}=" C5D ZID"; $resn_exch{"NC4* ZID"}=" C4D ZID"; $resn_exch{"NO4* ZID"}=" O4D ZID";
$resn_exch{"NC3* ZID"}=" C3D ZID"; $resn_exch{"NO3* ZID"}=" O3D ZID"; $resn_exch{"NC2* ZID"}=" C2D ZID";
$resn_exch{"NO2* ZID"}=" O2D ZID"; $resn_exch{"NC1* ZID"}=" C1D ZID"; $resn_exch{" NN1 ZID"}=" N1N ZID";
$resn_exch{" NC2 ZID"}=" C2N ZID"; $resn_exch{" NC3 ZID"}=" C3N ZID"; $resn_exch{" NC7 ZID"}=" C7N ZID";
$resn_exch{" NO7 ZID"}=" O7N ZID"; $resn_exch{" NN7 ZID"}=" N7N ZID"; $resn_exch{" NC4 ZID"}=" C4N ZID";
$resn_exch{" NC5 ZID"}=" C5N ZID"; $resn_exch{" NC6 ZID"}=" C6N ZID"; $resn_exch{" ZC7 ZID"}=" C7Z ZID";
$resn_exch{" ZO7 ZID"}=" O7Z ZID"; $resn_exch{" ZN1 ZID"}=" N1Z ZID"; $resn_exch{" ZC2 ZID"}=" C2Z ZID";
$resn_exch{" ZC3 ZID"}=" C3Z ZID"; $resn_exch{" ZC4 ZID"}=" C4Z ZID"; $resn_exch{" ZC5 ZID"}=" C5Z ZID";
$resn_exch{" ZC6 ZID"}=" C6Z ZID"; $resn_exch{" N_A ZNH"}=" NA  ZNH"; $resn_exch{" N_B ZNH"}=" NB  ZNH";
$resn_exch{" N_C ZNH"}=" NC  ZNH"; $resn_exch{" N_D ZNH"}=" ND  ZNH"; $resn_exch{"1H02 001"}="H021 001";
$resn_exch{"1H06 001"}="H061 001"; $resn_exch{"1H07 001"}="H071 001"; $resn_exch{"2H07 001"}="H072 001";
$resn_exch{"3H07 001"}="H073 001"; $resn_exch{"1H08 001"}="H081 001"; $resn_exch{"2H08 001"}="H082 001";
$resn_exch{"3H08 001"}="H083 001"; $resn_exch{"1H09 001"}="H091 001"; $resn_exch{"2H09 001"}="H092 001";
$resn_exch{"3H09 001"}="H093 001"; $resn_exch{"1H12 001"}="H121 001"; $resn_exch{"2H12 001"}="H122 001";
$resn_exch{"1H13 001"}="H131 001"; $resn_exch{"2H13 001"}="H132 001"; $resn_exch{"1H14 001"}="H141 001";
$resn_exch{"2H14 001"}="H142 001"; $resn_exch{"1H15 001"}="H151 001"; $resn_exch{"2H15 001"}="H152 001";
$resn_exch{"1H16 001"}="H161 001"; $resn_exch{"1H18 001"}="H181 001"; $resn_exch{"1H19 001"}="H191 001";
$resn_exch{"2H19 001"}="H192 001"; $resn_exch{"1H20 001"}="H201 001"; $resn_exch{"2H20 001"}="H202 001";
$resn_exch{"1H21 001"}="H211 001"; $resn_exch{"2H21 001"}="H212 001"; $resn_exch{"1H23 001"}="H231 001";
$resn_exch{"1H24 001"}="H241 001"; $resn_exch{"1H25 001"}="H251 001"; $resn_exch{"1H26 001"}="H261 001";
$resn_exch{"1H27 001"}="H271 001"; $resn_exch{"2H27 001"}="H272 001"; $resn_exch{"1H28 001"}="H281 001";
$resn_exch{"2H28 001"}="H282 001"; $resn_exch{"1H29 001"}="H291 001"; $resn_exch{"2H29 001"}="H292 001";
$resn_exch{"1H31 001"}="H311 001"; $resn_exch{"1H32 001"}="H321 001"; $resn_exch{"1H33 001"}="H331 001";
$resn_exch{"1H34 001"}="H341 001"; $resn_exch{"1H35 001"}="H351 001"; $resn_exch{"1H3  002"}=" H31 002";
$resn_exch{"2H3  002"}=" H32 002"; $resn_exch{"1H4  002"}=" H41 002"; $resn_exch{"2H4  002"}=" H42 002";
$resn_exch{"3H4  002"}=" H43 002"; $resn_exch{"1H8  002"}=" H81 002"; $resn_exch{"2H8  002"}=" H82 002";
$resn_exch{"1H10 002"}="H101 002"; $resn_exch{"2H10 002"}="H102 002"; $resn_exch{"1H12 002"}="H121 002";
$resn_exch{"2H12 002"}="H122 002"; $resn_exch{"3H12 002"}="H123 002"; $resn_exch{"1H20 002"}="H201 002";
$resn_exch{"2H20 002"}="H202 002"; $resn_exch{"3H20 002"}="H203 002"; $resn_exch{"1H21 002"}="H211 002";
$resn_exch{"2H21 002"}="H212 002"; $resn_exch{"3H21 002"}="H213 002"; $resn_exch{"1H23 002"}="H231 002";
$resn_exch{"2H23 002"}="H232 002"; $resn_exch{"1H7C 003"}="H7C1 003"; $resn_exch{"2H7C 003"}="H7C2 003";
$resn_exch{"1H10 003"}="H101 003"; $resn_exch{"2H10 003"}="H102 003"; $resn_exch{"3H10 003"}="H103 003";
$resn_exch{"1H9C 003"}="H9C1 003"; $resn_exch{"2H9C 003"}="H9C2 003"; $resn_exch{"3H9C 003"}="H9C3 003";
$resn_exch{"1H23 003"}="H231 003"; $resn_exch{"2H23 003"}="H232 003"; $resn_exch{"1H12 003"}="H121 003";
$resn_exch{"2H12 003"}="H122 003"; $resn_exch{"3H12 003"}="H123 003"; $resn_exch{"1H1C 007"}="H1C1 007";
$resn_exch{"2H1C 007"}="H1C2 007"; $resn_exch{"1H2C 007"}="H2C1 007"; $resn_exch{"2H2C 007"}="H2C2 007";
$resn_exch{"1H4C 007"}="H4C1 007"; $resn_exch{"2H4C 007"}="H4C2 007"; $resn_exch{"1H5C 007"}="H5C1 007";
$resn_exch{"2H5C 007"}="H5C2 007"; $resn_exch{"1H12 007"}="H121 007"; $resn_exch{"2H12 007"}="H122 007";
$resn_exch{"1H13 007"}="H131 007"; $resn_exch{"2H13 007"}="H132 007"; $resn_exch{"1H8C 008"}="H8C1 008";
$resn_exch{"2H8C 008"}="H8C2 008"; $resn_exch{"1H10 008"}="H101 008"; $resn_exch{"2H10 008"}="H102 008";
$resn_exch{"1H11 008"}="H111 008"; $resn_exch{"2H11 008"}="H112 008"; $resn_exch{"1H19 008"}="H191 008";
$resn_exch{"2H19 008"}="H192 008"; $resn_exch{"1H16 008"}="H161 008"; $resn_exch{"2H16 008"}="H162 008";
$resn_exch{"1H26 008"}="H261 008"; $resn_exch{"2H26 008"}="H262 008"; $resn_exch{"1H1  017"}=" H11 017";
$resn_exch{"2H1  017"}=" H12 017"; $resn_exch{"1H12 017"}="H121 017"; $resn_exch{"2H12 017"}="H122 017";
$resn_exch{"1H14 017"}="H141 017"; $resn_exch{"2H14 017"}="H142 017"; $resn_exch{"3H14 017"}="H143 017";
$resn_exch{"1H15 017"}="H151 017"; $resn_exch{"2H15 017"}="H152 017"; $resn_exch{"3H15 017"}="H153 017";
$resn_exch{"1H16 017"}="H161 017"; $resn_exch{"2H16 017"}="H162 017"; $resn_exch{"1H25 017"}="H251 017";
$resn_exch{"2H25 017"}="H252 017"; $resn_exch{"1H29 017"}="H291 017"; $resn_exch{"2H29 017"}="H292 017";
$resn_exch{"1H30 017"}="H301 017"; $resn_exch{"2H30 017"}="H302 017"; $resn_exch{"1H32 017"}="H321 017";
$resn_exch{"2H32 017"}="H322 017"; $resn_exch{"1H21 024"}="H211 024"; $resn_exch{"2H21 024"}="H212 024";
$resn_exch{"1H30 024"}="H301 024"; $resn_exch{"2H30 024"}="H302 024"; $resn_exch{"1H31 024"}="H311 024";
$resn_exch{"2H31 024"}="H312 024"; $resn_exch{"1H32 024"}="H321 024"; $resn_exch{"2H32 024"}="H322 024";
$resn_exch{"1H33 024"}="H331 024"; $resn_exch{"2H33 024"}="H332 024"; $resn_exch{"1H34 024"}="H341 024";
$resn_exch{"2H34 024"}="H342 024"; $resn_exch{"1H8  033"}=" H81 033"; $resn_exch{"2H8  033"}=" H82 033";
$resn_exch{"3H8  033"}=" H83 033"; $resn_exch{"1H9  033"}=" H91 033"; $resn_exch{"2H9  033"}=" H92 033";
$resn_exch{"3H9  033"}=" H93 033"; $resn_exch{"1HAU 039"}="HAU1 039"; $resn_exch{"2HAU 039"}="HAU2 039";
$resn_exch{"3HAU 039"}="HAU3 039"; $resn_exch{"1HAS 039"}="HAS1 039"; $resn_exch{"2HAS 039"}="HAS2 039";
$resn_exch{"1H22 03R"}="H221 03R"; $resn_exch{"2H22 03R"}="H222 03R"; $resn_exch{"1H23 03R"}="H231 03R";
$resn_exch{"2H23 03R"}="H232 03R"; $resn_exch{"3H23 03R"}="H233 03R"; $resn_exch{"1H29 03R"}="H291 03R";
$resn_exch{"2H29 03R"}="H292 03R"; $resn_exch{"1H34 03R"}="H341 03R"; $resn_exch{"2H34 03R"}="H342 03R";
$resn_exch{"1H25 041"}="H251 041"; $resn_exch{"2H25 041"}="H252 041"; $resn_exch{"1H10 042"}="H101 042";
$resn_exch{"2H10 042"}="H102 042"; $resn_exch{"1H11 042"}="H111 042"; $resn_exch{"2H11 042"}="H112 042";
$resn_exch{"3H11 042"}="H113 042"; $resn_exch{"1H13 042"}="H131 042"; $resn_exch{"2H13 042"}="H132 042";
$resn_exch{"3H13 042"}="H133 042"; $resn_exch{"1H16 042"}="H161 042"; $resn_exch{"2H16 042"}="H162 042";
$resn_exch{"1H15 042"}="H151 042"; $resn_exch{"2H15 042"}="H152 042"; $resn_exch{"3H15 042"}="H153 042";
$resn_exch{"1H17 042"}="H171 042"; $resn_exch{"2H17 042"}="H172 042"; $resn_exch{"3H17 042"}="H173 042";
$resn_exch{"1H7  047"}=" H71 047"; $resn_exch{"2H7  047"}=" H72 047"; $resn_exch{"1H12 047"}="H121 047";
$resn_exch{"2H12 047"}="H122 047"; $resn_exch{"1H17 047"}="H171 047"; $resn_exch{"2H17 047"}="H172 047";
$resn_exch{"1H20 047"}="H201 047"; $resn_exch{"2H20 047"}="H202 047"; $resn_exch{"1H23 047"}="H231 047";
$resn_exch{"2H23 047"}="H232 047"; $resn_exch{"1H26 047"}="H261 047"; $resn_exch{"2H26 047"}="H262 047";
$resn_exch{"1H29 047"}="H291 047"; $resn_exch{"2H29 047"}="H292 047"; $resn_exch{"1H50 047"}="H501 047";
$resn_exch{"2H50 047"}="H502 047"; $resn_exch{"3H50 047"}="H503 047"; $resn_exch{"1H34 059"}="H341 059";
$resn_exch{"2H34 059"}="H342 059"; $resn_exch{"1H33 059"}="H331 059"; $resn_exch{"2H33 059"}="H332 059";
$resn_exch{"1H30 059"}="H301 059"; $resn_exch{"2H30 059"}="H302 059"; $resn_exch{"3H30 059"}="H303 059";
$resn_exch{"1H29 059"}="H291 059"; $resn_exch{"2H29 059"}="H292 059"; $resn_exch{"3H29 059"}="H293 059";
$resn_exch{"1H15 059"}="H151 059"; $resn_exch{"2H15 059"}="H152 059"; $resn_exch{"1H9  059"}=" H91 059";
$resn_exch{"2H9  059"}=" H92 059"; $resn_exch{"1H10 059"}="H101 059"; $resn_exch{"2H10 059"}="H102 059";
$resn_exch{"1H18 061"}="H181 061"; $resn_exch{"2H18 061"}="H182 061"; $resn_exch{"1H21 061"}="H211 061";
$resn_exch{"2H21 061"}="H212 061"; $resn_exch{"1H22 061"}="H221 061"; $resn_exch{"2H22 061"}="H222 061";
$resn_exch{"1H23 061"}="H231 061"; $resn_exch{"2H23 061"}="H232 061"; $resn_exch{"1H24 061"}="H241 061";
$resn_exch{"2H24 061"}="H242 061"; $resn_exch{"3H24 061"}="H243 061"; $resn_exch{"1H25 062"}="H251 062";
$resn_exch{"2H25 062"}="H252 062"; $resn_exch{"1H26 062"}="H261 062"; $resn_exch{"2H26 062"}="H262 062";
$resn_exch{"1H27 062"}="H271 062"; $resn_exch{"2H27 062"}="H272 062"; $resn_exch{"1H37 062"}="H371 062";
$resn_exch{"2H37 062"}="H372 062"; $resn_exch{"1H53 062"}="H531 062"; $resn_exch{"2H53 062"}="H532 062";
$resn_exch{"1H54 062"}="H541 062"; $resn_exch{"2H54 062"}="H542 062"; $resn_exch{"1H14 065"}="H141 065";
$resn_exch{"2H14 065"}="H142 065"; $resn_exch{"3H14 065"}="H143 065"; $resn_exch{"1H15 065"}="H151 065";
$resn_exch{"2H15 065"}="H152 065"; $resn_exch{"3H15 065"}="H153 065"; $resn_exch{"1H12 065"}="H121 065";
$resn_exch{"2H12 065"}="H122 065"; $resn_exch{"1H16 065"}="H161 065"; $resn_exch{"2H16 065"}="H162 065";
$resn_exch{"1H32 065"}="H321 065"; $resn_exch{"2H32 065"}="H322 065"; $resn_exch{"1H25 065"}="H251 065";
$resn_exch{"2H25 065"}="H252 065"; $resn_exch{"1H29 065"}="H291 065"; $resn_exch{"2H29 065"}="H292 065";
$resn_exch{"1H30 065"}="H301 065"; $resn_exch{"2H30 065"}="H302 065"; $resn_exch{"1H40 065"}="H401 065";
$resn_exch{"2H40 065"}="H402 065"; $resn_exch{"1H1C 072"}="H1C1 072"; $resn_exch{"2H1C 072"}="H1C2 072";
$resn_exch{"1H2B 072"}="H2B1 072"; $resn_exch{"2H2B 072"}="H2B2 072"; $resn_exch{"1H2C 072"}="H2C1 072";
$resn_exch{"2H2C 072"}="H2C2 072"; $resn_exch{"1H2D 072"}="H2D1 072"; $resn_exch{"2H2D 072"}="H2D2 072";
$resn_exch{"1H2E 072"}="H2E1 072"; $resn_exch{"2H2E 072"}="H2E2 072"; $resn_exch{"1H2F 072"}="H2F1 072";
$resn_exch{"2H2F 072"}="H2F2 072"; $resn_exch{"1H2G 072"}="H2G1 072"; $resn_exch{"2H2G 072"}="H2G2 072";
$resn_exch{"1H2H 072"}="H2H1 072"; $resn_exch{"2H2H 072"}="H2H2 072"; $resn_exch{"3H2H 072"}="H2H3 072";
$resn_exch{"1H3B 072"}="H3B1 072"; $resn_exch{"2H3B 072"}="H3B2 072"; $resn_exch{"1H3C 072"}="H3C1 072";
$resn_exch{"2H3C 072"}="H3C2 072"; $resn_exch{"1H3D 072"}="H3D1 072"; $resn_exch{"2H3D 072"}="H3D2 072";
$resn_exch{"1H3E 072"}="H3E1 072"; $resn_exch{"2H3E 072"}="H3E2 072"; $resn_exch{"3HOM 072"}="HOM3 072";
$resn_exch{"1H4B 072"}="H4B1 072"; $resn_exch{"2H4B 072"}="H4B2 072"; $resn_exch{"1H5B 072"}="H5B1 072";
$resn_exch{"2H5B 072"}="H5B2 072"; $resn_exch{"1H67 073"}="H671 073"; $resn_exch{"2H67 073"}="H672 073";
$resn_exch{"3H67 073"}="H673 073"; $resn_exch{"1H13 073"}="H131 073"; $resn_exch{"2H13 073"}="H132 073";
$resn_exch{"1H37 073"}="H371 073"; $resn_exch{"2H37 073"}="H372 073"; $resn_exch{"1H1  074"}=" H11 074";
$resn_exch{"2H1  074"}=" H12 074"; $resn_exch{"3H1  074"}=" H13 074"; $resn_exch{"1H2  074"}=" H21 074";
$resn_exch{"2H2  074"}=" H22 074"; $resn_exch{"1H3  074"}=" H31 074"; $resn_exch{"2H3  074"}=" H32 074";
$resn_exch{"1HN1 074"}="HN11 074"; $resn_exch{"1H5  074"}=" H51 074"; $resn_exch{"1H6  074"}=" H61 074";
$resn_exch{"2H6  074"}=" H62 074"; $resn_exch{"1HO2 074"}="HO21 074"; $resn_exch{"1HN2 074"}="HN21 074";
$resn_exch{"1H8  074"}=" H81 074"; $resn_exch{"1H9  074"}=" H91 074"; $resn_exch{"1H10 074"}="H101 074";
$resn_exch{"2H10 074"}="H102 074"; $resn_exch{"3H10 074"}="H103 074"; $resn_exch{"1H11 074"}="H111 074";
$resn_exch{"2H11 074"}="H112 074"; $resn_exch{"1H12 074"}="H121 074"; $resn_exch{"2H12 074"}="H122 074";
$resn_exch{"3H12 074"}="H123 074"; $resn_exch{"1H14 074"}="H141 074"; $resn_exch{"2H14 074"}="H142 074";
$resn_exch{"1H15 074"}="H151 074"; $resn_exch{"2H15 074"}="H152 074"; $resn_exch{"1H16 074"}="H161 074";
$resn_exch{"2H16 074"}="H162 074"; $resn_exch{"1H17 074"}="H171 074"; $resn_exch{"1H39 075"}="H391 075";
$resn_exch{"2H39 075"}="H392 075"; $resn_exch{"1H29 075"}="H291 075"; $resn_exch{"2H29 075"}="H292 075";
$resn_exch{"3H29 075"}="H293 075"; $resn_exch{"1H30 075"}="H301 075"; $resn_exch{"2H30 075"}="H302 075";
$resn_exch{"3H30 075"}="H303 075"; $resn_exch{"1H19 075"}="H191 075"; $resn_exch{"2H19 075"}="H192 075";
$resn_exch{"1H15 075"}="H151 075"; $resn_exch{"2H15 075"}="H152 075"; $resn_exch{"1H11 075"}="H111 075";
$resn_exch{"2H11 075"}="H112 075"; $resn_exch{"1H28 075"}="H281 075"; $resn_exch{"2H28 075"}="H282 075";
$resn_exch{"3H28 075"}="H283 075"; $resn_exch{"1H9  075"}=" H91 075"; $resn_exch{"2H9  075"}=" H92 075";
$resn_exch{"1H50 084"}="H501 084"; $resn_exch{"2H50 084"}="H502 084"; $resn_exch{"3H50 084"}="H503 084";
$resn_exch{"1H13 084"}="H131 084"; $resn_exch{"2H13 084"}="H132 084"; $resn_exch{"1H14 084"}="H141 084";
$resn_exch{"2H14 084"}="H142 084"; $resn_exch{"1H16 084"}="H161 084"; $resn_exch{"2H16 084"}="H162 084";
$resn_exch{"1H17 084"}="H171 084"; $resn_exch{"2H17 084"}="H172 084"; $resn_exch{"1H6  084"}=" H61 084";
$resn_exch{"2H6  084"}=" H62 084"; $resn_exch{"3H6  084"}=" H63 084"; $resn_exch{"1HAZ 090"}="HAZ1 090";
$resn_exch{"2HAZ 090"}="HAZ2 090"; $resn_exch{"3HAZ 090"}="HAZ3 090"; $resn_exch{"1HAY 090"}="HAY1 090";
$resn_exch{"2HAY 090"}="HAY2 090"; $resn_exch{"3HAY 090"}="HAY3 090"; $resn_exch{"1HAV 093"}="HAV1 093";
$resn_exch{"2HAV 093"}="HAV2 093"; $resn_exch{"1HAW 093"}="HAW1 093"; $resn_exch{"2HAW 093"}="HAW2 093";
$resn_exch{"1HAE 093"}="HAE1 093"; $resn_exch{"2HAE 093"}="HAE2 093"; $resn_exch{"3HAE 093"}="HAE3 093";
$resn_exch{"1HAT 093"}="HAT1 093"; $resn_exch{"2HAT 093"}="HAT2 093"; $resn_exch{"3HAT 093"}="HAT3 093";
$resn_exch{"1H10 094"}="H101 094"; $resn_exch{"2H10 094"}="H102 094"; $resn_exch{"1H20 094"}="H201 094";
$resn_exch{"2H20 094"}="H202 094"; $resn_exch{"1H21 094"}="H211 094"; $resn_exch{"2H21 094"}="H212 094";
$resn_exch{"1H22 094"}="H221 094"; $resn_exch{"2H22 094"}="H222 094"; $resn_exch{"1H2  097"}=" H21 097";
$resn_exch{"2H2  097"}=" H22 097"; $resn_exch{"3H2  097"}=" H23 097"; $resn_exch{"1H8  097"}=" H81 097";
$resn_exch{"2H8  097"}=" H82 097"; $resn_exch{"3H8  097"}=" H83 097"; $resn_exch{"1H9  097"}=" H91 097";
$resn_exch{"2H9  097"}=" H92 097"; $resn_exch{"3H9  097"}=" H93 097"; $resn_exch{"1H11 097"}="H111 097";
$resn_exch{"2H11 097"}="H112 097"; $resn_exch{"3H11 097"}="H113 097"; $resn_exch{"1H15 097"}="H151 097";
$resn_exch{"2H15 097"}="H152 097"; $resn_exch{"1H3  097"}=" H31 097"; $resn_exch{"2H3  097"}=" H32 097";
$resn_exch{"3H3  097"}=" H33 097"; $resn_exch{"1H7  097"}=" H71 097"; $resn_exch{"2H7  097"}=" H72 097";
$resn_exch{"3H7  097"}=" H73 097"; $resn_exch{"1HN  0A0"}=" HN1 0A0"; $resn_exch{"2HN  0A0"}=" HN2 0A0";
$resn_exch{"1HBC 0A0"}="HBC1 0A0"; $resn_exch{"2HBC 0A0"}="HBC2 0A0"; $resn_exch{"1HMC 0A0"}="HMC1 0A0";
$resn_exch{"2HMC 0A0"}="HMC2 0A0"; $resn_exch{"3HMC 0A0"}="HMC3 0A0"; $resn_exch{"1HN  0A1"}=" HN1 0A1";
$resn_exch{"2HN  0A1"}=" HN2 0A1"; $resn_exch{"1HBC 0A1"}="HBC1 0A1"; $resn_exch{"2HBC 0A1"}="HBC2 0A1";
$resn_exch{"1HMC 0A1"}="HMC1 0A1"; $resn_exch{"2HMC 0A1"}="HMC2 0A1"; $resn_exch{"3HMC 0A1"}="HMC3 0A1";
$resn_exch{"1H01 0A2"}="H011 0A2"; $resn_exch{"2H01 0A2"}="H012 0A2"; $resn_exch{"1H02 0A2"}="H021 0A2";
$resn_exch{"2H02 0A2"}="H022 0A2"; $resn_exch{"3H02 0A2"}="H023 0A2"; $resn_exch{"1H03 0A2"}="H031 0A2";
$resn_exch{"2H03 0A2"}="H032 0A2"; $resn_exch{"1H05 0A2"}="H051 0A2"; $resn_exch{"2H05 0A2"}="H052 0A2";
$resn_exch{"1H06 0A2"}="H061 0A2"; $resn_exch{"2H06 0A2"}="H062 0A2"; $resn_exch{"1H07 0A2"}="H071 0A2";
$resn_exch{"2H07 0A2"}="H072 0A2"; $resn_exch{"1H08 0A2"}="H081 0A2"; $resn_exch{"2H08 0A2"}="H082 0A2";
$resn_exch{"1H09 0A2"}="H091 0A2"; $resn_exch{"2H09 0A2"}="H092 0A2"; $resn_exch{"1H18 0A2"}="H181 0A2";
$resn_exch{"2H18 0A2"}="H182 0A2"; $resn_exch{"1H19 0A2"}="H191 0A2"; $resn_exch{"2H19 0A2"}="H192 0A2";
$resn_exch{"3H19 0A2"}="H193 0A2"; $resn_exch{"1H2C 0A3"}="H2C1 0A3"; $resn_exch{"2H2C 0A3"}="H2C2 0A3";
$resn_exch{"1H3' 0A3"}="H3'1 0A3"; $resn_exch{"2H3' 0A3"}="H3'2 0A3"; $resn_exch{"3H3' 0A3"}="H3'3 0A3";
$resn_exch{"1H18 0A3"}="H181 0A3"; $resn_exch{"2H18 0A3"}="H182 0A3"; $resn_exch{"3H18 0A3"}="H183 0A3";
$resn_exch{"1HA  0A3"}=" HA1 0A3"; $resn_exch{"2HB  0A3"}=" HB2 0A3"; $resn_exch{"1H2C 0A4"}="H2C1 0A4";
$resn_exch{"2H2C 0A4"}="H2C2 0A4"; $resn_exch{"1H3' 0A4"}="H3'1 0A4"; $resn_exch{"2H3' 0A4"}="H3'2 0A4";
$resn_exch{"1H13 0A4"}="H131 0A4"; $resn_exch{"2H13 0A4"}="H132 0A4"; $resn_exch{"1H15 0A4"}="H151 0A4";
$resn_exch{"1H2C 0A5"}="H2C1 0A5"; $resn_exch{"2H2C 0A5"}="H2C2 0A5"; $resn_exch{"1H3C 0A5"}="H3C1 0A5";
$resn_exch{"2H3C 0A5"}="H3C2 0A5"; $resn_exch{"3H3C 0A5"}="H3C3 0A5"; $resn_exch{"1HBC 0A5"}="HBC1 0A5";
$resn_exch{"2HBC 0A5"}="HBC2 0A5"; $resn_exch{"1HD2 0A5"}="HD21 0A5"; $resn_exch{"2HD2 0A5"}="HD22 0A5";
$resn_exch{"1H05 0A6"}="H051 0A6"; $resn_exch{"2H05 0A6"}="H052 0A6"; $resn_exch{"1H08 0A6"}="H081 0A6";
$resn_exch{"2H08 0A6"}="H082 0A6"; $resn_exch{"1H09 0A6"}="H091 0A6"; $resn_exch{"2H09 0A6"}="H092 0A6";
$resn_exch{"3H09 0A6"}="H093 0A6"; $resn_exch{"1H10 0A7"}="H101 0A7"; $resn_exch{"2H10 0A7"}="H102 0A7";
$resn_exch{"1HN  0A8"}=" HN1 0A8"; $resn_exch{"2HN  0A8"}=" HN2 0A8"; $resn_exch{"1HBC 0A8"}="HBC1 0A8";
$resn_exch{"2HBC 0A8"}="HBC2 0A8"; $resn_exch{"1H2C 0A8"}="H2C1 0A8"; $resn_exch{"2H2C 0A8"}="H2C2 0A8";
$resn_exch{"1H3C 0A8"}="H3C1 0A8"; $resn_exch{"2H3C 0A8"}="H3C2 0A8"; $resn_exch{"1HN  0A9"}=" HN1 0A9";
$resn_exch{"2HN  0A9"}=" HN2 0A9"; $resn_exch{"1HBC 0A9"}="HBC1 0A9"; $resn_exch{"2HBC 0A9"}="HBC2 0A9";
$resn_exch{"1HMC 0A9"}="HMC1 0A9"; $resn_exch{"2HMC 0A9"}="HMC2 0A9"; $resn_exch{"3HMC 0A9"}="HMC3 0A9";
$resn_exch{"1HN  0AA"}=" HN1 0AA"; $resn_exch{"2HA  0AA"}=" HA2 0AA"; $resn_exch{"1HG1 0AA"}="HG11 0AA";
$resn_exch{"2HG1 0AA"}="HG12 0AA"; $resn_exch{"3HG1 0AA"}="HG13 0AA"; $resn_exch{"1HG2 0AA"}="HG21 0AA";
$resn_exch{"2HG2 0AA"}="HG22 0AA"; $resn_exch{"3HG2 0AA"}="HG23 0AA"; $resn_exch{"1H1C 0AA"}="H1C1 0AA";
$resn_exch{"2H1C 0AA"}="H1C2 0AA"; $resn_exch{"3H1C 0AA"}="H1C3 0AA"; $resn_exch{"1HN  0AB"}=" HN1 0AB";
$resn_exch{"2HA  0AB"}=" HA2 0AB"; $resn_exch{"1HG1 0AB"}="HG11 0AB"; $resn_exch{"2HG1 0AB"}="HG12 0AB";
$resn_exch{"3HG1 0AB"}="HG13 0AB"; $resn_exch{"1HN  0AC"}=" HN1 0AC"; $resn_exch{"2HN  0AC"}=" HN2 0AC";
$resn_exch{"1HBC 0AC"}="HBC1 0AC"; $resn_exch{"2HBC 0AC"}="HBC2 0AC"; $resn_exch{"1H1C 0AC"}="H1C1 0AC";
$resn_exch{"2H1C 0AC"}="H1C2 0AC"; $resn_exch{"1HA1 0AC"}="HA11 0AC"; $resn_exch{"2HA1 0AC"}="HA12 0AC";
$resn_exch{"1H5' 0AD"}="H5'1 0AD"; $resn_exch{"2H5' 0AD"}="H5'2 0AD"; $resn_exch{"1H2' 0AD"}="H2'1 0AD";
$resn_exch{"2H2' 0AD"}="H2'2 0AD"; $resn_exch{"1H4A 0AD"}="H4A1 0AD"; $resn_exch{"2H4A 0AD"}="H4A2 0AD";
$resn_exch{"1H5A 0AD"}="H5A1 0AD"; $resn_exch{"2H5A 0AD"}="H5A2 0AD"; $resn_exch{"1HN  0AF"}=" HN1 0AF";
$resn_exch{"2HN  0AF"}=" HN2 0AF"; $resn_exch{"1HBC 0AF"}="HBC1 0AF"; $resn_exch{"2HBC 0AF"}="HBC2 0AF";
$resn_exch{"1H3  0AG"}=" H31 0AG"; $resn_exch{"2H3  0AG"}=" H32 0AG"; $resn_exch{"3H3  0AG"}=" H33 0AG";
$resn_exch{"1H4  0AG"}=" H41 0AG"; $resn_exch{"2H4  0AG"}=" H42 0AG"; $resn_exch{"1HBC 0AG"}="HBC1 0AG";
$resn_exch{"2HBC 0AG"}="HBC2 0AG"; $resn_exch{"1HD1 0AG"}="HD11 0AG"; $resn_exch{"2HD1 0AG"}="HD12 0AG";
$resn_exch{"3HD1 0AG"}="HD13 0AG"; $resn_exch{"1HD2 0AG"}="HD21 0AG"; $resn_exch{"2HD2 0AG"}="HD22 0AG";
$resn_exch{"3HD2 0AG"}="HD23 0AG"; $resn_exch{"1HN  0AH"}=" HN1 0AH"; $resn_exch{"2HN  0AH"}=" HN2 0AH";
$resn_exch{"1HBC 0AH"}="HBC1 0AH"; $resn_exch{"2HBC 0AH"}="HBC2 0AH"; $resn_exch{"1H2C 0AH"}="H2C1 0AH";
$resn_exch{"2H2C 0AH"}="H2C2 0AH"; $resn_exch{"1H8C 0AI"}="H8C1 0AI"; $resn_exch{"2H8C 0AI"}="H8C2 0AI";
$resn_exch{"3H8C 0AI"}="H8C3 0AI"; $resn_exch{"1HMC 0AI"}="HMC1 0AI"; $resn_exch{"2HMC 0AI"}="HMC2 0AI";
$resn_exch{"3HMC 0AI"}="HMC3 0AI"; $resn_exch{"1HAC 0AJ"}="HAC1 0AJ"; $resn_exch{"2HAC 0AJ"}="HAC2 0AJ";
$resn_exch{"3HAC 0AJ"}="HAC3 0AJ"; $resn_exch{"1HDC 0AJ"}="HDC1 0AJ"; $resn_exch{"2HDC 0AJ"}="HDC2 0AJ";
$resn_exch{"3HDC 0AJ"}="HDC3 0AJ"; $resn_exch{"1H1C 0AJ"}="H1C1 0AJ"; $resn_exch{"2H1C 0AJ"}="H1C2 0AJ";
$resn_exch{"1H2C 0AJ"}="H2C1 0AJ"; $resn_exch{"2H2C 0AJ"}="H2C2 0AJ"; $resn_exch{"3H2C 0AJ"}="H2C3 0AJ";
$resn_exch{"1HN  0AK"}=" HN1 0AK"; $resn_exch{"2HN  0AK"}=" HN2 0AK"; $resn_exch{"1HBC 0AK"}="HBC1 0AK";
$resn_exch{"2HBC 0AK"}="HBC2 0AK"; $resn_exch{"1H1C 0AK"}="H1C1 0AK"; $resn_exch{"2H1C 0AK"}="H1C2 0AK";
$resn_exch{"1H2C 0AK"}="H2C1 0AK"; $resn_exch{"2H2C 0AK"}="H2C2 0AK"; $resn_exch{"1H7C 0AL"}="H7C1 0AL";
$resn_exch{"2H7C 0AL"}="H7C2 0AL"; $resn_exch{"2HN  0AO"}=" HN2 0AO"; $resn_exch{"1H5' 0AP"}="H5'1 0AP";
$resn_exch{"2H5' 0AP"}="H5'2 0AP"; $resn_exch{"1H2' 0AP"}="H2'1 0AP"; $resn_exch{"2H2' 0AP"}="H2'2 0AP";
$resn_exch{"1H4N 0AP"}="H4N1 0AP"; $resn_exch{"2H4N 0AP"}="H4N2 0AP"; $resn_exch{"1H6C 0AT"}="H6C1 0AT";
$resn_exch{"2H6C 0AT"}="H6C2 0AT"; $resn_exch{"1H8C 0AT"}="H8C1 0AT"; $resn_exch{"2H8C 0AT"}="H8C2 0AT";
$resn_exch{"3H8C 0AT"}="H8C3 0AT"; $resn_exch{"1H5' 0AU"}="H5'1 0AU"; $resn_exch{"2H5' 0AU"}="H5'2 0AU";
$resn_exch{"1H5' 0AV"}="H5'1 0AV"; $resn_exch{"2HA  0AV"}=" HA2 0AV"; $resn_exch{"1HMC 0AV"}="HMC1 0AV";
$resn_exch{"2HMC 0AV"}="HMC2 0AV"; $resn_exch{"3HMC 0AV"}="HMC3 0AV"; $resn_exch{"1H6N 0AV"}="H6N1 0AV";
$resn_exch{"2H6N 0AV"}="H6N2 0AV"; $resn_exch{" HB1 0AZ"}=" HB2 0AZ"; $resn_exch{" HB2 0AZ"}=" HB3 0AZ";
$resn_exch{"HD1  0AZ"}="HD22 0AZ"; $resn_exch{"HD2  0AZ"}="HD23 0AZ"; $resn_exch{" HOD 0AZ"}=" HD1 0AZ";
$resn_exch{"1HN  0CS"}=" H   0CS"; $resn_exch{"2HN  0CS"}=" H2  0CS"; $resn_exch{"1HB  0CS"}=" HB2 0CS";
$resn_exch{"2HB  0CS"}=" HB3 0CS"; $resn_exch{"HOD3 0CS"}=" HD3 0CS"; $resn_exch{"2HOP 101"}="HOP2 101";
$resn_exch{"3HOP 101"}="HOP3 101"; $resn_exch{"HO5* 101"}="HO5' 101"; $resn_exch{"1H5* 101"}="H5'1 101";
$resn_exch{"2H5* 101"}="H5'2 101"; $resn_exch{" H4* 101"}=" H4' 101"; $resn_exch{" H3* 101"}=" H3' 101";
$resn_exch{"1H2* 101"}="H2'1 101"; $resn_exch{"2H2* 101"}="H2'2 101"; $resn_exch{" H1* 101"}=" H1' 101";
$resn_exch{"1HN6 101"}="HN61 101"; $resn_exch{"2HN6 101"}="HN62 101"; $resn_exch{"2HOG 102"}="HOG2 102";
$resn_exch{"3HOG 102"}="HOG3 102"; $resn_exch{"2HOB 102"}="HOB2 102"; $resn_exch{"2HOA 102"}="HOA2 102";
$resn_exch{"1H5* 102"}="H5'1 102"; $resn_exch{"2H5* 102"}="H5'2 102"; $resn_exch{" H4* 102"}=" H4' 102";
$resn_exch{" H3* 102"}=" H3' 102"; $resn_exch{"*HO3 102"}="HO3' 102"; $resn_exch{" H2* 102"}=" H2' 102";
$resn_exch{"*HO2 102"}="HO2' 102"; $resn_exch{" H1* 102"}=" H1' 102"; $resn_exch{"1HN2 102"}="HN21 102";
$resn_exch{"2HN2 102"}="HN22 102"; $resn_exch{"2HOP 103"}="HOP2 103"; $resn_exch{"3HOP 103"}="HOP3 103";
$resn_exch{"1H5* 103"}="H5'1 103"; $resn_exch{"2H5* 103"}="H5'2 103"; $resn_exch{"3H5* 103"}="H5'3 103";
$resn_exch{" H4* 103"}=" H4' 103"; $resn_exch{" H3* 103"}=" H3' 103"; $resn_exch{"1H2* 103"}="H2'1 103";
$resn_exch{"2H2* 103"}="H2'2 103"; $resn_exch{" H1* 103"}=" H1' 103"; $resn_exch{"1HN6 103"}="HN61 103";
$resn_exch{"2HN6 103"}="HN62 103"; $resn_exch{"1H1  104"}=" H11 104"; $resn_exch{"2H1  104"}=" H12 104";
$resn_exch{"1H2  104"}=" H21 104"; $resn_exch{"2H2  104"}=" H22 104"; $resn_exch{"1H3  104"}=" H31 104";
$resn_exch{"2H3  104"}=" H32 104"; $resn_exch{"1H5  104"}=" H51 104"; $resn_exch{"2H5  104"}=" H52 104";
$resn_exch{"1H6  104"}=" H61 104"; $resn_exch{"2H6  104"}=" H62 104"; $resn_exch{"1H8  104"}=" H81 104";
$resn_exch{"2H8  104"}=" H82 104"; $resn_exch{"1H9  104"}=" H91 104"; $resn_exch{"2H9  104"}=" H92 104";
$resn_exch{"1H10 104"}="H101 104"; $resn_exch{"2H10 104"}="H102 104"; $resn_exch{"1H3  105"}=" H31 105";
$resn_exch{"2H3  105"}=" H32 105"; $resn_exch{"1H9  105"}=" H91 105"; $resn_exch{"2H9  105"}=" H92 105";
$resn_exch{"3H9  105"}=" H93 105"; $resn_exch{"1H30 106"}="H301 106"; $resn_exch{"2H30 106"}="H302 106";
$resn_exch{"1H14 107"}="H141 107"; $resn_exch{"2H14 107"}="H142 107"; $resn_exch{"1H7  108"}=" H71 108";
$resn_exch{"2H7  108"}=" H72 108"; $resn_exch{"1HN1 108"}="HN11 108"; $resn_exch{"2HN1 108"}="HN12 108";
$resn_exch{"1HB  108"}=" HB1 108"; $resn_exch{"2HB  108"}=" HB2 108"; $resn_exch{"3HB  108"}=" HB3 108";
$resn_exch{"1H7  109"}=" H71 109"; $resn_exch{"2H7  109"}=" H72 109"; $resn_exch{"1HN1 109"}="HN11 109";
$resn_exch{"2HN1 109"}="HN12 109"; $resn_exch{"1HB  109"}=" HB1 109"; $resn_exch{"2HB  109"}=" HB2 109";
$resn_exch{"3HB  109"}=" HB3 109"; $resn_exch{"1H1  10A"}=" H11 10A"; $resn_exch{"2H1  10A"}=" H12 10A";
$resn_exch{"3H1  10A"}=" H13 10A"; $resn_exch{"1H2  10A"}=" H21 10A"; $resn_exch{"2H2  10A"}=" H22 10A";
$resn_exch{"1H3  10A"}=" H31 10A"; $resn_exch{"2H3  10A"}=" H32 10A"; $resn_exch{"1H4  10A"}=" H41 10A";
$resn_exch{"2H4  10A"}=" H42 10A"; $resn_exch{"1H5  10A"}=" H51 10A"; $resn_exch{"2H5  10A"}=" H52 10A";
$resn_exch{"1H6  10A"}=" H61 10A"; $resn_exch{"2H6  10A"}=" H62 10A"; $resn_exch{"1H7  10A"}=" H71 10A";
$resn_exch{"2H7  10A"}=" H72 10A"; $resn_exch{"1H8  10A"}=" H81 10A"; $resn_exch{"2H8  10A"}=" H82 10A";
$resn_exch{"1H9  10A"}=" H91 10A"; $resn_exch{"2H9  10A"}=" H92 10A"; $resn_exch{"1H10 10A"}="H101 10A";
$resn_exch{"2H10 10A"}="H102 10A"; $resn_exch{"1H11 10A"}="H111 10A"; $resn_exch{"2H11 10A"}="H112 10A";
$resn_exch{"3H11 10A"}="H113 10A"; $resn_exch{"1H12 10A"}="H121 10A"; $resn_exch{"2H12 10A"}="H122 10A";
$resn_exch{"3H12 10A"}="H123 10A"; $resn_exch{"1H13 10A"}="H131 10A"; $resn_exch{"2H13 10A"}="H132 10A";
$resn_exch{"1H14 10A"}="H141 10A"; $resn_exch{"2H14 10A"}="H142 10A"; $resn_exch{"1H15 10A"}="H151 10A";
$resn_exch{"2H15 10A"}="H152 10A"; $resn_exch{"1H16 10A"}="H161 10A"; $resn_exch{"2H16 10A"}="H162 10A";
$resn_exch{"1H17 10A"}="H171 10A"; $resn_exch{"2H17 10A"}="H172 10A"; $resn_exch{"1H18 10A"}="H181 10A";
$resn_exch{"2H18 10A"}="H182 10A"; $resn_exch{"1H19 10A"}="H191 10A"; $resn_exch{"2H19 10A"}="H192 10A";
$resn_exch{"1H20 10A"}="H201 10A"; $resn_exch{"2H20 10A"}="H202 10A"; $resn_exch{"1H21 10A"}="H211 10A";
$resn_exch{"2H21 10A"}="H212 10A"; $resn_exch{"1H22 10A"}="H221 10A"; $resn_exch{"2H22 10A"}="H222 10A";
$resn_exch{"3H22 10A"}="H223 10A"; $resn_exch{"1HOP 10C"}="HOP1 10C"; $resn_exch{"2HOP 10C"}="HOP2 10C";
$resn_exch{"1H5* 10C"}="H5'1 10C"; $resn_exch{"2H5* 10C"}="H5'2 10C"; $resn_exch{" H1* 10C"}=" H1' 10C";
$resn_exch{" H3* 10C"}=" H3' 10C"; $resn_exch{"1H6* 10C"}="H6'1 10C"; $resn_exch{"2H6* 10C"}="H6'2 10C";
$resn_exch{"1H4  10C"}=" H41 10C"; $resn_exch{"2H4  10C"}=" H42 10C"; $resn_exch{"1H2* 10C"}="H2'1 10C";
$resn_exch{"1H10 110"}="H101 110"; $resn_exch{"2H10 110"}="H102 110"; $resn_exch{"1H11 110"}="H111 110";
$resn_exch{"2H11 110"}="H112 110"; $resn_exch{"1H21 110"}="H211 110"; $resn_exch{"2H21 110"}="H212 110";
$resn_exch{"1H22 110"}="H221 110"; $resn_exch{"2H22 110"}="H222 110"; $resn_exch{"1H19 110"}="H191 110";
$resn_exch{"2H19 110"}="H192 110"; $resn_exch{"1H12 110"}="H121 110"; $resn_exch{"2H12 110"}="H122 110";
$resn_exch{"1H13 110"}="H131 110"; $resn_exch{"2H13 110"}="H132 110"; $resn_exch{"3H13 110"}="H133 110";
$resn_exch{"1H4  110"}=" H41 110"; $resn_exch{"2H4  110"}=" H42 110"; $resn_exch{"1H5  110"}=" H51 110";
$resn_exch{"2H5  110"}=" H52 110"; $resn_exch{"1HD2 110"}="HD21 110"; $resn_exch{"2HD2 110"}="HD22 110";
$resn_exch{"1H7  110"}=" H71 110"; $resn_exch{"2H7  110"}=" H72 110"; $resn_exch{"1H8  110"}=" H81 110";
$resn_exch{"2H8  110"}=" H82 110"; $resn_exch{"1H13 111"}="H131 111"; $resn_exch{"2H13 111"}="H132 111";
$resn_exch{"3H13 111"}="H133 111"; $resn_exch{"1H11 111"}="H111 111"; $resn_exch{"2H11 111"}="H112 111";
$resn_exch{"1H9  111"}=" H91 111"; $resn_exch{"2H9  111"}=" H92 111"; $resn_exch{"1H7  111"}=" H71 111";
$resn_exch{"2H7  111"}=" H72 111"; $resn_exch{"1H10 111"}="H101 111"; $resn_exch{"2H10 111"}="H102 111";
$resn_exch{"1H12 111"}="H121 111"; $resn_exch{"2H12 111"}="H122 111"; $resn_exch{"1H14 111"}="H141 111";
$resn_exch{"2H14 111"}="H142 111"; $resn_exch{"3H14 111"}="H143 111"; $resn_exch{"1HNS 112"}="HNS1 112";
$resn_exch{"2HNS 112"}="HNS2 112"; $resn_exch{"1H1S 112"}="H1S1 112"; $resn_exch{"2H1S 112"}="H1S2 112";
$resn_exch{"2HOG 112"}="HOG2 112"; $resn_exch{"2HOB 112"}="HOB2 112"; $resn_exch{"2HOA 112"}="HOA2 112";
$resn_exch{"1H5* 112"}="H5'1 112"; $resn_exch{"2H5* 112"}="H5'2 112"; $resn_exch{" H4* 112"}=" H4' 112";
$resn_exch{" H3* 112"}=" H3' 112"; $resn_exch{"*HO3 112"}="HO3' 112"; $resn_exch{" H2* 112"}=" H2' 112";
$resn_exch{"*HO2 112"}="HO2' 112"; $resn_exch{" H1* 112"}=" H1' 112"; $resn_exch{"1HN6 112"}="HN61 112";
$resn_exch{"2HN6 112"}="HN62 112"; $resn_exch{"1H12 113"}="H121 113"; $resn_exch{"2H12 113"}="H122 113";
$resn_exch{"1H22 113"}="H221 113"; $resn_exch{"2H22 113"}="H222 113"; $resn_exch{"3H22 113"}="H223 113";
$resn_exch{"1H26 113"}="H261 113"; $resn_exch{"2H26 113"}="H262 113"; $resn_exch{"3H26 113"}="H263 113";
$resn_exch{"1H2  114"}=" H21 114"; $resn_exch{"2H2  114"}=" H22 114"; $resn_exch{"1H4  114"}=" H41 114";
$resn_exch{"2H4  114"}=" H42 114"; $resn_exch{"1H6  114"}=" H61 114"; $resn_exch{"2H6  114"}=" H62 114";
$resn_exch{"1H7  114"}=" H71 114"; $resn_exch{"2H7  114"}=" H72 114"; $resn_exch{"1H16 114"}="H161 114";
$resn_exch{"2H16 114"}="H162 114"; $resn_exch{"1H15 114"}="H151 114"; $resn_exch{"2H15 114"}="H152 114";
$resn_exch{"1H9A 114"}="H9A1 114"; $resn_exch{"2H9A 114"}="H9A2 114"; $resn_exch{"3H9A 114"}="H9A3 114";
$resn_exch{"1H20 114"}="H201 114"; $resn_exch{"2H20 114"}="H202 114"; $resn_exch{"1H21 114"}="H211 114";
$resn_exch{"2H21 114"}="H212 114"; $resn_exch{"3H21 114"}="H213 114"; $resn_exch{"1H22 114"}="H221 114";
$resn_exch{"2H22 114"}="H222 114"; $resn_exch{"3H22 114"}="H223 114"; $resn_exch{"1H2  115"}=" H21 115";
$resn_exch{"2H2  115"}=" H22 115"; $resn_exch{"1H4  115"}=" H41 115"; $resn_exch{"2H4  115"}=" H42 115";
$resn_exch{"1H6  115"}=" H61 115"; $resn_exch{"2H6  115"}=" H62 115"; $resn_exch{"1H7  115"}=" H71 115";
$resn_exch{"2H7  115"}=" H72 115"; $resn_exch{"1H92 115"}="H921 115"; $resn_exch{"2H92 115"}="H922 115";
$resn_exch{"3H92 115"}="H923 115"; $resn_exch{"1H93 115"}="H931 115"; $resn_exch{"2H93 115"}="H932 115";
$resn_exch{"3H93 115"}="H933 115"; $resn_exch{"1H14 116"}="H141 116"; $resn_exch{"2H14 116"}="H142 116";
$resn_exch{"3H14 116"}="H143 116"; $resn_exch{"1H13 116"}="H131 116"; $resn_exch{"2H13 116"}="H132 116";
$resn_exch{"1H17 116"}="H171 116"; $resn_exch{"2H17 116"}="H172 116"; $resn_exch{"3H17 116"}="H173 116";
$resn_exch{"1H16 116"}="H161 116"; $resn_exch{"2H16 116"}="H162 116"; $resn_exch{"3H16 116"}="H163 116";
$resn_exch{"1H2  116"}=" H21 116"; $resn_exch{"2H2  116"}=" H22 116"; $resn_exch{"1H4  116"}=" H41 116";
$resn_exch{"2H4  116"}=" H42 116"; $resn_exch{"1H6  116"}=" H61 116"; $resn_exch{"2H6  116"}=" H62 116";
$resn_exch{"1H7  116"}=" H71 116"; $resn_exch{"2H7  116"}=" H72 116"; $resn_exch{"1H92 116"}="H921 116";
$resn_exch{"2H92 116"}="H922 116"; $resn_exch{"3H92 116"}="H923 116"; $resn_exch{"1H93 116"}="H931 116";
$resn_exch{"2H93 116"}="H932 116"; $resn_exch{"3H93 116"}="H933 116"; $resn_exch{"1H2  117"}="H21A 117";
$resn_exch{"2H2  117"}="H22A 117"; $resn_exch{"1H4  117"}=" H41 117"; $resn_exch{"2H4  117"}=" H42 117";
$resn_exch{"1H6  117"}=" H61 117"; $resn_exch{"2H6  117"}=" H62 117"; $resn_exch{"1H7  117"}=" H71 117";
$resn_exch{"2H7  117"}=" H72 117"; $resn_exch{"1H93 117"}="H931 117"; $resn_exch{"2H93 117"}="H932 117";
$resn_exch{"3H93 117"}="H933 117"; $resn_exch{"1H92 117"}="H921 117"; $resn_exch{"2H92 117"}="H922 117";
$resn_exch{"3H92 117"}="H923 117"; $resn_exch{"1H35 11B"}="H351 11B"; $resn_exch{"2H35 11B"}="H352 11B";
$resn_exch{"1H26 11B"}="H261 11B"; $resn_exch{"2H26 11B"}="H262 11B"; $resn_exch{"1H27 11B"}="H271 11B";
$resn_exch{"2H27 11B"}="H272 11B"; $resn_exch{"1H28 11B"}="H281 11B"; $resn_exch{"2H28 11B"}="H282 11B";
$resn_exch{"1H29 11B"}="H291 11B"; $resn_exch{"2H29 11B"}="H292 11B"; $resn_exch{"1H30 11B"}="H301 11B";
$resn_exch{"2H30 11B"}="H302 11B"; $resn_exch{"3H30 11B"}="H303 11B"; $resn_exch{"1H11 11B"}="H111 11B";
$resn_exch{"2H11 11B"}="H112 11B"; $resn_exch{"1H2  11O"}=" H21 11O"; $resn_exch{"2H2  11O"}=" H22 11O";
$resn_exch{"1H3  11O"}=" H31 11O"; $resn_exch{"2H3  11O"}=" H32 11O"; $resn_exch{"1H4  11O"}=" H41 11O";
$resn_exch{"2H4  11O"}=" H42 11O"; $resn_exch{"1H5  11O"}=" H51 11O"; $resn_exch{"2H5  11O"}=" H52 11O";
$resn_exch{"1H6  11O"}=" H61 11O"; $resn_exch{"2H6  11O"}=" H62 11O"; $resn_exch{"1H7  11O"}=" H71 11O";
$resn_exch{"2H7  11O"}=" H72 11O"; $resn_exch{"1H8  11O"}=" H81 11O"; $resn_exch{"2H8  11O"}=" H82 11O";
$resn_exch{"1H9  11O"}=" H91 11O"; $resn_exch{"1H10 11O"}="H101 11O"; $resn_exch{"1H11 11O"}="H111 11O";
$resn_exch{"1H12 11O"}="H121 11O"; $resn_exch{"1H13 11O"}="H131 11O"; $resn_exch{"1H14 11O"}="H141 11O";
$resn_exch{"2H14 11O"}="H142 11O"; $resn_exch{"1H15 11O"}="H151 11O"; $resn_exch{"2H15 11O"}="H152 11O";
$resn_exch{"1H16 11O"}="H161 11O"; $resn_exch{"2H16 11O"}="H162 11O"; $resn_exch{"1H17 11O"}="H171 11O";
$resn_exch{"2H17 11O"}="H172 11O"; $resn_exch{"1H18 11O"}="H181 11O"; $resn_exch{"2H18 11O"}="H182 11O";
$resn_exch{"3H18 11O"}="H183 11O"; $resn_exch{"1H2O 11O"}="H2O1 11O"; $resn_exch{"1H21 11O"}="H211 11O";
$resn_exch{"1H16 11P"}="H161 11P"; $resn_exch{"2H16 11P"}="H162 11P"; $resn_exch{"1H17 11P"}="H171 11P";
$resn_exch{"2H17 11P"}="H172 11P"; $resn_exch{"3HM2 11R"}="HM23 11R"; $resn_exch{"2HM2 11R"}="HM22 11R";
$resn_exch{"1HM2 11R"}="HM21 11R"; $resn_exch{"3HM1 11R"}="HM13 11R"; $resn_exch{"2HM1 11R"}="HM12 11R";
$resn_exch{"1HM1 11R"}="HM11 11R"; $resn_exch{"1HX6 11R"}="HX61 11R"; $resn_exch{"2HX6 11R"}="HX62 11R";
$resn_exch{"1HX5 11R"}="HX51 11R"; $resn_exch{"2HX5 11R"}="HX52 11R"; $resn_exch{"1HX4 11R"}="HX41 11R";
$resn_exch{"2HX4 11R"}="HX42 11R"; $resn_exch{"1HX3 11R"}="HX31 11R"; $resn_exch{"2HX3 11R"}="HX32 11R";
$resn_exch{"1HX2 11R"}="HX21 11R"; $resn_exch{"2HX2 11R"}="HX22 11R"; $resn_exch{"1HL6 11R"}="HL61 11R";
$resn_exch{"2HL6 11R"}="HL62 11R"; $resn_exch{"1HL5 11R"}="HL51 11R"; $resn_exch{"2HL5 11R"}="HL52 11R";
$resn_exch{"1HL4 11R"}="HL41 11R"; $resn_exch{"2HL4 11R"}="HL42 11R"; $resn_exch{"1HL3 11R"}="HL31 11R";
$resn_exch{"2HL3 11R"}="HL32 11R"; $resn_exch{"1HL2 11R"}="HL21 11R"; $resn_exch{"2HL2 11R"}="HL22 11R";
$resn_exch{"1HL1 11R"}="HL11 11R"; $resn_exch{"2HL1 11R"}="HL12 11R"; $resn_exch{"1HAN 11R"}="HAN1 11R";
$resn_exch{"1HCK 11R"}="HCK1 11R"; $resn_exch{"1HCJ 11R"}="HCJ1 11R"; $resn_exch{"1HCE 11R"}="HCE1 11R";
$resn_exch{"1HCD 11R"}="HCD1 11R"; $resn_exch{"1HCC 11R"}="HCC1 11R"; $resn_exch{"1HCB 11R"}="HCB1 11R";
$resn_exch{"1HBK 11R"}="HBK1 11R"; $resn_exch{"1HBJ 11R"}="HBJ1 11R"; $resn_exch{"1HBI 11R"}="HBI1 11R";
$resn_exch{"1HBH 11R"}="HBH1 11R"; $resn_exch{"1HBE 11R"}="HBE1 11R"; $resn_exch{"1HBD 11R"}="HBD1 11R";
$resn_exch{"1HBC 11R"}="HBC1 11R"; $resn_exch{"1HBB 11R"}="HBB1 11R"; $resn_exch{"1HH1 120"}="HH11 120";
$resn_exch{"2HH1 120"}="HH12 120"; $resn_exch{"1HH2 120"}="HH21 120"; $resn_exch{"2HH2 120"}="HH22 120";
$resn_exch{"1HH1 121"}="HH11 121"; $resn_exch{"2HH1 121"}="HH12 121"; $resn_exch{"1HH2 121"}="HH21 121";
$resn_exch{"2HH2 121"}="HH22 121"; $resn_exch{"1HH1 122"}="HH11 122"; $resn_exch{"2HH1 122"}="HH12 122";
$resn_exch{"1HH2 122"}="HH21 122"; $resn_exch{"2HH2 122"}="HH22 122"; $resn_exch{"1HH1 123"}="HH11 123";
$resn_exch{"2HH1 123"}="HH12 123"; $resn_exch{"1HH2 123"}="HH21 123"; $resn_exch{"2HH2 123"}="HH22 123";
$resn_exch{"1H3' 123"}="H3'1 123"; $resn_exch{"2H3' 123"}="H3'2 123"; $resn_exch{"3H3' 123"}="H3'3 123";
$resn_exch{"1HH1 124"}="HH11 124"; $resn_exch{"2HH1 124"}="HH12 124"; $resn_exch{"1HH2 124"}="HH21 124";
$resn_exch{"2HH2 124"}="HH22 124"; $resn_exch{"2HOP 125"}="HOP2 125"; $resn_exch{"3HOP 125"}="HOP3 125";
$resn_exch{"1H5* 125"}=" H5' 125"; $resn_exch{"2H5* 125"}="H5'' 125"; $resn_exch{" H4* 125"}=" H4' 125";
$resn_exch{" H3* 125"}=" H3' 125"; $resn_exch{"H3T  125"}="HO3' 125"; $resn_exch{" H2* 125"}=" H2' 125";
$resn_exch{" H1* 125"}=" H1' 125"; $resn_exch{"1H5M 125"}=" H71 125"; $resn_exch{"2H5M 125"}=" H72 125";
$resn_exch{"3H5M 125"}=" H73 125"; $resn_exch{"1HA* 125"}="HA'1 125"; $resn_exch{"2HA* 125"}="HA'2 125";
$resn_exch{"1HB* 125"}="HB'1 125"; $resn_exch{"2HB* 125"}="HB'2 125"; $resn_exch{"2HOP 126"}="HOP2 126";
$resn_exch{"3HOP 126"}="HOP3 126"; $resn_exch{"1H5* 126"}=" H5' 126"; $resn_exch{"2H5* 126"}="H5'' 126";
$resn_exch{" H4* 126"}=" H4' 126"; $resn_exch{" H3* 126"}=" H3' 126"; $resn_exch{"H3T  126"}="HO3' 126";
$resn_exch{" H2* 126"}=" H2' 126"; $resn_exch{" H1* 126"}=" H1' 126"; $resn_exch{"1H5M 126"}=" H71 126";
$resn_exch{"2H5M 126"}=" H72 126"; $resn_exch{"3H5M 126"}=" H73 126"; $resn_exch{"1HA* 126"}="HA'1 126";
$resn_exch{"2HA* 126"}="HA'2 126"; $resn_exch{"1HB* 126"}="HB'1 126"; $resn_exch{"2HB* 126"}="HB'2 126";
$resn_exch{"1HD* 126"}="HD'1 126"; $resn_exch{"2HD* 126"}="HD'2 126"; $resn_exch{"1HE* 126"}="HE'1 126";
$resn_exch{"2HE* 126"}="HE'2 126"; $resn_exch{"1HG* 126"}="HG'1 126"; $resn_exch{"2HG* 126"}="HG'2 126";
$resn_exch{"1HH* 126"}="HH'1 126"; $resn_exch{"2HH* 126"}="HH'2 126"; $resn_exch{"1HK* 126"}="HK'1 126";
$resn_exch{"2HK* 126"}="HK'2 126"; $resn_exch{"3HK* 126"}="HK'3 126"; $resn_exch{"2HOP 127"}="HOP2 127";
$resn_exch{"3HOP 127"}="HOP3 127"; $resn_exch{"1H5* 127"}=" H5' 127"; $resn_exch{"2H5* 127"}="H5'' 127";
$resn_exch{" H4* 127"}=" H4' 127"; $resn_exch{" H3* 127"}=" H3' 127"; $resn_exch{"H3T  127"}="HO3' 127";
$resn_exch{" H2* 127"}=" H2' 127"; $resn_exch{" H1* 127"}=" H1' 127"; $resn_exch{"1H5M 127"}=" H71 127";
$resn_exch{"2H5M 127"}=" H72 127"; $resn_exch{"3H5M 127"}=" H73 127"; $resn_exch{"1HA* 127"}="HA'1 127";
$resn_exch{"2HA* 127"}="HA'2 127"; $resn_exch{"1HB* 127"}="HB'1 127"; $resn_exch{"2HB* 127"}="HB'2 127";
$resn_exch{"1HD* 127"}="HD'1 127"; $resn_exch{"2HD* 127"}="HD'2 127"; $resn_exch{"2HOG 128"}="HOG2 128";
$resn_exch{"3HOG 128"}="HOG3 128"; $resn_exch{"2HOB 128"}="HOB2 128"; $resn_exch{"2HOA 128"}="HOA2 128";
$resn_exch{"1H5* 128"}=" H5' 128"; $resn_exch{"2H5* 128"}="H5'' 128"; $resn_exch{" H4* 128"}=" H4' 128";
$resn_exch{" H3* 128"}=" H3' 128"; $resn_exch{" H2* 128"}=" H2' 128"; $resn_exch{" H1* 128"}=" H1' 128";
$resn_exch{"1HN6 128"}="HN61 128"; $resn_exch{"2HN6 128"}="HN62 128"; $resn_exch{"2HOP 129"}="HOP2 129";
$resn_exch{"3HOP 129"}="HOP3 129"; $resn_exch{"1H4  129"}=" H41 129"; $resn_exch{"2H4  129"}=" H42 129";
$resn_exch{"1H3  129"}=" H31 129"; $resn_exch{"2H3  129"}=" H32 129"; $resn_exch{"3HOP 12A"}="HOP3 12A";
$resn_exch{"2HOP 12A"}="HOP2 12A"; $resn_exch{"1H5* 12A"}=" H5' 12A"; $resn_exch{"2H5* 12A"}="H5'' 12A";
$resn_exch{" H4* 12A"}=" H4' 12A"; $resn_exch{" H3* 12A"}=" H3' 12A"; $resn_exch{"H3T  12A"}="HO3' 12A";
$resn_exch{" H2* 12A"}=" H2' 12A"; $resn_exch{"2HO* 12A"}="HO2' 12A"; $resn_exch{" H1* 12A"}=" H1' 12A";
$resn_exch{"1H2M 12A"}="H2M1 12A"; $resn_exch{"2H2M 12A"}="H2M2 12A"; $resn_exch{"3H2M 12A"}="H2M3 12A";
$resn_exch{"1HG2 12A"}="HG21 12A"; $resn_exch{"2HG2 12A"}="HG22 12A"; $resn_exch{"3HG2 12A"}="HG23 12A";
$resn_exch{"1H18 12C"}="H181 12C"; $resn_exch{"2H18 12C"}="H182 12C"; $resn_exch{"1H19 12C"}="H191 12C";
$resn_exch{"2H19 12C"}="H192 12C"; $resn_exch{"1H20 12C"}="H201 12C"; $resn_exch{"2H20 12C"}="H202 12C";
$resn_exch{"1H21 12C"}="H211 12C"; $resn_exch{"2H21 12C"}="H212 12C"; $resn_exch{"1H22 12C"}="H221 12C";
$resn_exch{"2H22 12C"}="H222 12C"; $resn_exch{"1H1  12H"}=" H11 12H"; $resn_exch{"2H1  12H"}=" H12 12H";
$resn_exch{"1H2  12H"}=" H21 12H"; $resn_exch{"2H2  12H"}=" H22 12H"; $resn_exch{"1H3  12H"}=" H31 12H";
$resn_exch{"2H3  12H"}=" H32 12H"; $resn_exch{"1H4  12H"}=" H41 12H"; $resn_exch{"2H4  12H"}=" H42 12H";
$resn_exch{"1H5  12H"}=" H51 12H"; $resn_exch{"2H5  12H"}=" H52 12H"; $resn_exch{"1H6  12H"}=" H61 12H";
$resn_exch{"2H6  12H"}=" H62 12H"; $resn_exch{"1H7  12H"}=" H71 12H"; $resn_exch{"2H7  12H"}=" H72 12H";
$resn_exch{"1H8  12H"}=" H81 12H"; $resn_exch{"2H8  12H"}=" H82 12H"; $resn_exch{"1H9  12H"}=" H91 12H";
$resn_exch{"2H9  12H"}=" H92 12H"; $resn_exch{"1H10 12H"}="H101 12H"; $resn_exch{"2H10 12H"}="H102 12H";
$resn_exch{"1H11 12H"}="H111 12H"; $resn_exch{"2H11 12H"}="H112 12H"; $resn_exch{"1HAH 12M"}="HAH1 12M";
$resn_exch{"2HAH 12M"}="HAH2 12M"; $resn_exch{"3HAH 12M"}="HAH3 12M"; $resn_exch{"1HAD 12M"}="HAD1 12M";
$resn_exch{"2HAD 12M"}="HAD2 12M"; $resn_exch{"1HAF 12M"}="HAF1 12M"; $resn_exch{"2HAF 12M"}="HAF2 12M";
$resn_exch{"1H36 12P"}="H361 12P"; $resn_exch{"2H36 12P"}="H362 12P"; $resn_exch{"1H35 12P"}="H351 12P";
$resn_exch{"2H35 12P"}="H352 12P"; $resn_exch{"1H33 12P"}="H331 12P"; $resn_exch{"2H33 12P"}="H332 12P";
$resn_exch{"1H32 12P"}="H321 12P"; $resn_exch{"2H32 12P"}="H322 12P"; $resn_exch{"1H30 12P"}="H301 12P";
$resn_exch{"2H30 12P"}="H302 12P"; $resn_exch{"1H29 12P"}="H291 12P"; $resn_exch{"2H29 12P"}="H292 12P";
$resn_exch{"1H27 12P"}="H271 12P"; $resn_exch{"2H27 12P"}="H272 12P"; $resn_exch{"1H26 12P"}="H261 12P";
$resn_exch{"2H26 12P"}="H262 12P"; $resn_exch{"1H24 12P"}="H241 12P"; $resn_exch{"2H24 12P"}="H242 12P";
$resn_exch{"1H23 12P"}="H231 12P"; $resn_exch{"2H23 12P"}="H232 12P"; $resn_exch{"1H21 12P"}="H211 12P";
$resn_exch{"2H21 12P"}="H212 12P"; $resn_exch{"1H20 12P"}="H201 12P"; $resn_exch{"2H20 12P"}="H202 12P";
$resn_exch{"1H18 12P"}="H181 12P"; $resn_exch{"2H18 12P"}="H182 12P"; $resn_exch{"1H17 12P"}="H171 12P";
$resn_exch{"2H17 12P"}="H172 12P"; $resn_exch{"1H15 12P"}="H151 12P"; $resn_exch{"2H15 12P"}="H152 12P";
$resn_exch{"1H14 12P"}="H141 12P"; $resn_exch{"2H14 12P"}="H142 12P"; $resn_exch{"1H12 12P"}="H121 12P";
$resn_exch{"2H12 12P"}="H122 12P"; $resn_exch{"1H11 12P"}="H111 12P"; $resn_exch{"2H11 12P"}="H112 12P";
$resn_exch{"1H9  12P"}=" H91 12P"; $resn_exch{"2H9  12P"}=" H92 12P"; $resn_exch{"1H8  12P"}=" H81 12P";
$resn_exch{"2H8  12P"}=" H82 12P"; $resn_exch{"1H6  12P"}=" H61 12P"; $resn_exch{"2H6  12P"}=" H62 12P";
$resn_exch{"1H5  12P"}=" H51 12P"; $resn_exch{"2H5  12P"}=" H52 12P"; $resn_exch{"1H3  12P"}=" H31 12P";
$resn_exch{"2H3  12P"}=" H32 12P"; $resn_exch{"1H2  12P"}=" H21 12P"; $resn_exch{"2H2  12P"}=" H22 12P";
$resn_exch{"1HAH 12Q"}="HAH1 12Q"; $resn_exch{"2HAH 12Q"}="HAH2 12Q"; $resn_exch{"3HAH 12Q"}="HAH3 12Q";
$resn_exch{"1HH1 130"}="HH11 130"; $resn_exch{"2HH1 130"}="HH12 130"; $resn_exch{"1HH2 130"}="HH21 130";
$resn_exch{"2HC' 130"}="HC'2 130"; $resn_exch{"3HC' 130"}="HC'3 130"; $resn_exch{"4HC' 130"}="HC'4 130";
$resn_exch{" H2* 130"}=" H2' 130"; $resn_exch{" H3* 130"}=" H3' 130"; $resn_exch{" H4* 130"}=" H4' 130";
$resn_exch{" H5* 130"}=" H5' 130"; $resn_exch{" H6* 130"}=" H6' 130"; $resn_exch{"1HH1 132"}="HH11 132";
$resn_exch{"2HH1 132"}="HH12 132"; $resn_exch{"1HH2 132"}="HH21 132"; $resn_exch{"2HH2 132"}="HH22 132";
$resn_exch{"2HC' 132"}="HC'2 132"; $resn_exch{"3HC' 132"}="HC'3 132"; $resn_exch{"4HC' 132"}="HC'4 132";
$resn_exch{" H2* 132"}=" H2' 132"; $resn_exch{" H3* 132"}=" H3' 132"; $resn_exch{" H4* 132"}=" H4' 132";
$resn_exch{" H5* 132"}=" H5' 132"; $resn_exch{" H6* 132"}=" H6' 132"; $resn_exch{"1HH1 133"}="HH11 133";
$resn_exch{"2HH1 133"}="HH12 133"; $resn_exch{"1HH2 133"}="HH21 133"; $resn_exch{"2HC' 133"}="HC'2 133";
$resn_exch{"3HC' 133"}="HC'3 133"; $resn_exch{"4HC' 133"}="HC'4 133"; $resn_exch{"6HO' 133"}="HO'6 133";
$resn_exch{"1H10 133"}="H101 133"; $resn_exch{"2H10 133"}="H102 133"; $resn_exch{"1H30 133"}="H301 133";
$resn_exch{"2H30 133"}="H302 133"; $resn_exch{"3H30 133"}="H303 133"; $resn_exch{"1H40 133"}="H401 133";
$resn_exch{"2H40 133"}="H402 133"; $resn_exch{"3H40 133"}="H403 133"; $resn_exch{"1HH1 134"}="HH11 134";
$resn_exch{"2HH1 134"}="HH12 134"; $resn_exch{"1HH2 134"}="HH21 134"; $resn_exch{"2HC' 134"}="HC'2 134";
$resn_exch{"3HC' 134"}="HC'3 134"; $resn_exch{"4HC' 134"}="HC'4 134"; $resn_exch{"6HO' 134"}="HO'6 134";
$resn_exch{" H1* 134"}=" H1' 134"; $resn_exch{"1H2* 134"}="H2'1 134"; $resn_exch{"2H2* 134"}="H2'2 134";
$resn_exch{"1H3* 134"}="H3'1 134"; $resn_exch{"2H3* 134"}="H3'2 134"; $resn_exch{"1H4* 134"}="H4'1 134";
$resn_exch{"2H4* 134"}="H4'2 134"; $resn_exch{"1H5* 134"}="H5'1 134"; $resn_exch{"2H5* 134"}="H5'2 134";
$resn_exch{" H6* 134"}=" H6' 134"; $resn_exch{"1HM  134"}=" HM1 134"; $resn_exch{"2HM  134"}=" HM2 134";
$resn_exch{"3HM  134"}=" HM3 134"; $resn_exch{"1HH1 135"}="HH11 135"; $resn_exch{"2HH1 135"}="HH12 135";
$resn_exch{"1HH2 135"}="HH21 135"; $resn_exch{"1HH1 136"}="HH11 136"; $resn_exch{"2HH1 136"}="HH12 136";
$resn_exch{"1HH2 136"}="HH21 136"; $resn_exch{"1H21 136"}="H211 136"; $resn_exch{"2H21 136"}="H212 136";
$resn_exch{"3H21 136"}="H213 136"; $resn_exch{"2HOP 137"}="HOP2 137"; $resn_exch{"3HOP 137"}="HOP3 137";
$resn_exch{"1H5' 137"}="H5'1 137"; $resn_exch{"2H5' 137"}="H5'2 137"; $resn_exch{"4HO' 137"}="HO'4 137";
$resn_exch{"3HO' 137"}="HO'3 137"; $resn_exch{"2HO' 137"}="HO'2 137"; $resn_exch{"1H1' 137"}="H1'1 137";
$resn_exch{"2H1' 137"}="H1'2 137"; $resn_exch{"1HA2 138"}="HA21 138"; $resn_exch{"2HA2 138"}="HA22 138";
$resn_exch{"1H9  138"}=" H91 138"; $resn_exch{"2H9  138"}=" H92 138"; $resn_exch{"1HA1 138"}="HA11 138";
$resn_exch{"2HA1 138"}="HA12 138"; $resn_exch{"1HB  138"}=" HB1 138"; $resn_exch{"2HB  138"}=" HB2 138";
$resn_exch{"1HG  138"}=" HG1 138"; $resn_exch{"2HG  138"}=" HG2 138"; $resn_exch{"1H27 138"}="H271 138";
$resn_exch{"2H27 138"}="H272 138"; $resn_exch{"1H19 138"}="H191 138"; $resn_exch{"2H19 138"}="H192 138";
$resn_exch{"2HOA 139"}="HOA2 139"; $resn_exch{"2HOB 139"}="HOB2 139"; $resn_exch{"1H6A 139"}="H6A1 139";
$resn_exch{"2H6A 139"}="H6A2 139"; $resn_exch{"1HA5 139"}="HA51 139"; $resn_exch{"2HA5 139"}="HA52 139";
$resn_exch{"H4*A 139"}=" H4D 139"; $resn_exch{"H1*A 139"}=" H1D 139"; $resn_exch{"H2*A 139"}=" H2D 139";
$resn_exch{"2H*A 139"}=" HD2 139"; $resn_exch{"H3*A 139"}=" H3D 139"; $resn_exch{"3H*A 139"}=" HD3 139";
$resn_exch{"5H*U 139"}=" HB5 139"; $resn_exch{"1HU5 139"}="HU51 139"; $resn_exch{"2HU5 139"}="HU52 139";
$resn_exch{"H4*U 139"}=" H4B 139"; $resn_exch{"H1*U 139"}=" H1B 139"; $resn_exch{"1HU2 139"}="HU21 139";
$resn_exch{"2HU2 139"}="HU22 139"; $resn_exch{"H3*U 139"}=" H3B 139"; $resn_exch{"1H8  13A"}=" H81 13A";
$resn_exch{"2H8  13A"}=" H82 13A"; $resn_exch{"1HAC 13D"}="HAC1 13D"; $resn_exch{"2HAC 13D"}="HAC2 13D";
$resn_exch{"1HBC 13D"}="HBC1 13D"; $resn_exch{"2HBC 13D"}="HBC2 13D"; $resn_exch{"1HCC 13D"}="HCC1 13D";
$resn_exch{"2HCC 13D"}="HCC2 13D"; $resn_exch{"1HDN 13D"}="HDN1 13D"; $resn_exch{"2HDN 13D"}="HDN2 13D";
$resn_exch{"1HAA 13D"}="HAA1 13D"; $resn_exch{"2HAA 13D"}="HAA2 13D"; $resn_exch{"2HOP 13P"}="HOP2 13P";
$resn_exch{"3HOP 13P"}="HOP3 13P"; $resn_exch{"1H1  13P"}=" H11 13P"; $resn_exch{"2H1  13P"}=" H12 13P";
$resn_exch{"1H3  13P"}=" H31 13P"; $resn_exch{"2H3  13P"}=" H32 13P"; $resn_exch{"1H2  13R"}=" H21 13R";
$resn_exch{"2H2  13R"}=" H22 13R"; $resn_exch{"1H3  13R"}=" H31 13R"; $resn_exch{"2H3  13R"}=" H32 13R";
$resn_exch{"1H4  13R"}=" H41 13R"; $resn_exch{"2H4  13R"}=" H42 13R"; $resn_exch{"1H5  13R"}=" H51 13R";
$resn_exch{"2H5  13R"}=" H52 13R"; $resn_exch{"1H6  13R"}=" H61 13R"; $resn_exch{"2H6  13R"}=" H62 13R";
$resn_exch{"1H7  13R"}=" H71 13R"; $resn_exch{"2H7  13R"}=" H72 13R"; $resn_exch{"1H8  13R"}=" H81 13R";
$resn_exch{"2H8  13R"}=" H82 13R"; $resn_exch{"1H9  13R"}=" H91 13R"; $resn_exch{"1H10 13R"}="H101 13R";
$resn_exch{"1H11 13R"}="H111 13R"; $resn_exch{"1H12 13R"}="H121 13R"; $resn_exch{"1H13 13R"}="H131 13R";
$resn_exch{"1H14 13R"}="H141 13R"; $resn_exch{"2H14 13R"}="H142 13R"; $resn_exch{"1H15 13R"}="H151 13R";
$resn_exch{"2H15 13R"}="H152 13R"; $resn_exch{"1H16 13R"}="H161 13R"; $resn_exch{"2H16 13R"}="H162 13R";
$resn_exch{"1H17 13R"}="H171 13R"; $resn_exch{"2H17 13R"}="H172 13R"; $resn_exch{"1H18 13R"}="H181 13R";
$resn_exch{"2H18 13R"}="H182 13R"; $resn_exch{"3H18 13R"}="H183 13R"; $resn_exch{"1H20 13R"}="H201 13R";
$resn_exch{"1H22 13R"}="H221 13R"; $resn_exch{"1H2  13S"}=" H21 13S"; $resn_exch{"2H2  13S"}=" H22 13S";
$resn_exch{"1H3  13S"}=" H31 13S"; $resn_exch{"2H3  13S"}=" H32 13S"; $resn_exch{"1H4  13S"}=" H41 13S";
$resn_exch{"2H4  13S"}=" H42 13S"; $resn_exch{"1H5  13S"}=" H51 13S"; $resn_exch{"2H5  13S"}=" H52 13S";
$resn_exch{"1H6  13S"}=" H61 13S"; $resn_exch{"2H6  13S"}=" H62 13S"; $resn_exch{"1H7  13S"}=" H71 13S";
$resn_exch{"2H7  13S"}=" H72 13S"; $resn_exch{"1H8  13S"}=" H81 13S"; $resn_exch{"2H8  13S"}=" H82 13S";
$resn_exch{"1H9  13S"}=" H91 13S"; $resn_exch{"1H10 13S"}="H101 13S"; $resn_exch{"1H11 13S"}="H111 13S";
$resn_exch{"1H12 13S"}="H121 13S"; $resn_exch{"1H13 13S"}="H131 13S"; $resn_exch{"1H14 13S"}="H141 13S";
$resn_exch{"2H14 13S"}="H142 13S"; $resn_exch{"1H15 13S"}="H151 13S"; $resn_exch{"2H15 13S"}="H152 13S";
$resn_exch{"1H16 13S"}="H161 13S"; $resn_exch{"2H16 13S"}="H162 13S"; $resn_exch{"1H17 13S"}="H171 13S";
$resn_exch{"2H17 13S"}="H172 13S"; $resn_exch{"1H18 13S"}="H181 13S"; $resn_exch{"2H18 13S"}="H182 13S";
$resn_exch{"3H18 13S"}="H183 13S"; $resn_exch{"1H20 13S"}="H201 13S"; $resn_exch{"1H22 13S"}="H221 13S";
$resn_exch{"1H12 13T"}="H121 13T"; $resn_exch{"2H12 13T"}="H122 13T"; $resn_exch{"1H13 13T"}="H131 13T";
$resn_exch{"2H13 13T"}="H132 13T"; $resn_exch{"1H23 13T"}="H231 13T"; $resn_exch{"2H23 13T"}="H232 13T";
$resn_exch{"3H23 13T"}="H233 13T"; $resn_exch{"1H24 13T"}="H241 13T"; $resn_exch{"2H24 13T"}="H242 13T";
$resn_exch{"3H24 13T"}="H243 13T"; $resn_exch{"1H25 13T"}="H251 13T"; $resn_exch{"2H25 13T"}="H252 13T";
$resn_exch{"3H25 13T"}="H253 13T"; $resn_exch{"1H26 13T"}="H261 13T"; $resn_exch{"2H26 13T"}="H262 13T";
$resn_exch{"3H26 13T"}="H263 13T"; $resn_exch{"1H27 13T"}="H271 13T"; $resn_exch{"2H27 13T"}="H272 13T";
$resn_exch{"3H27 13T"}="H273 13T"; $resn_exch{"1H28 13T"}="H281 13T"; $resn_exch{"2H28 13T"}="H282 13T";
$resn_exch{"3H28 13T"}="H283 13T"; $resn_exch{"1H29 13T"}="H291 13T"; $resn_exch{"2H29 13T"}="H292 13T";
$resn_exch{"1H30 13T"}="H301 13T"; $resn_exch{"2H30 13T"}="H302 13T"; $resn_exch{"3H30 13T"}="H303 13T";
$resn_exch{"1H31 13T"}="H311 13T"; $resn_exch{"2H31 13T"}="H312 13T"; $resn_exch{"3H31 13T"}="H313 13T";
$resn_exch{"1H32 13T"}="H321 13T"; $resn_exch{"2H32 13T"}="H322 13T"; $resn_exch{"3H32 13T"}="H323 13T";
$resn_exch{"1H2  140"}=" H21 140"; $resn_exch{"2H2  140"}=" H22 140"; $resn_exch{"1H4  140"}=" H41 140";
$resn_exch{"2H4  140"}=" H42 140"; $resn_exch{"1H5  140"}=" H51 140"; $resn_exch{"2H5  140"}=" H52 140";
$resn_exch{"1H6  140"}=" H61 140"; $resn_exch{"2H6  140"}=" H62 140"; $resn_exch{"1H7  140"}=" H71 140";
$resn_exch{"2H7  140"}=" H72 140"; $resn_exch{"1H8  140"}=" H81 140"; $resn_exch{"2H8  140"}=" H82 140";
$resn_exch{"1H9  140"}=" H91 140"; $resn_exch{"2H9  140"}=" H92 140"; $resn_exch{"1H10 140"}="H101 140";
$resn_exch{"2H10 140"}="H102 140"; $resn_exch{"1H11 140"}="H111 140"; $resn_exch{"2H11 140"}="H112 140";
$resn_exch{"1H12 140"}="H121 140"; $resn_exch{"2H12 140"}="H122 140"; $resn_exch{"1H13 140"}="H131 140";
$resn_exch{"2H13 140"}="H132 140"; $resn_exch{"1H14 140"}="H141 140"; $resn_exch{"2H14 140"}="H142 140";
$resn_exch{"1H15 140"}="H151 140"; $resn_exch{"2H15 140"}="H152 140"; $resn_exch{"1H16 140"}="H161 140";
$resn_exch{"2H16 140"}="H162 140"; $resn_exch{"1H17 140"}="H171 140"; $resn_exch{"2H17 140"}="H172 140";
$resn_exch{"1H18 140"}="H181 140"; $resn_exch{"2H18 140"}="H182 140"; $resn_exch{"3H18 140"}="H183 140";
$resn_exch{"1HN  142"}=" HN1 142"; $resn_exch{"2HN  142"}=" HN2 142"; $resn_exch{"1HB  142"}=" HB1 142";
$resn_exch{"2HB  142"}=" HB2 142"; $resn_exch{"1HB1 142"}="HB11 142"; $resn_exch{"2HB1 142"}="HB12 142";
$resn_exch{"3HB1 142"}="HB13 142"; $resn_exch{" HN2 143"}=" H2  143"; $resn_exch{"1HB  143"}=" HB2 143";
$resn_exch{"2HB  143"}=" HB3 143"; $resn_exch{"1HI  143"}=" HI1 143"; $resn_exch{"2HI  143"}=" HI2 143";
$resn_exch{"1H1  144"}=" H11 144"; $resn_exch{"2H1  144"}=" H12 144"; $resn_exch{"3H1  144"}=" H13 144";
$resn_exch{"1H2  144"}=" H21 144"; $resn_exch{"2H2  144"}=" H22 144"; $resn_exch{"1H3  144"}=" H31 144";
$resn_exch{"2H3  144"}=" H32 144"; $resn_exch{"1H4  144"}=" H41 144"; $resn_exch{"2H4  144"}=" H42 144";
$resn_exch{"1H6  145"}=" H61 145"; $resn_exch{"2H6  145"}=" H62 145"; $resn_exch{"1H2  146"}="H21A 146";
$resn_exch{"2H2  146"}=" H22 146"; $resn_exch{"1H7  146"}="H71A 146"; $resn_exch{"2H7  146"}=" H72 146";
$resn_exch{"1H31 146"}="H311 146"; $resn_exch{"2H31 146"}="H312 146"; $resn_exch{"1H61 146"}="H611 146";
$resn_exch{"2H61 146"}="H612 146"; $resn_exch{"7HN7 146"}="HN77 146"; $resn_exch{"1H6  147"}=" H61 147";
$resn_exch{"2H6  147"}=" H62 147"; $resn_exch{"1H2  148"}=" H21 148"; $resn_exch{"2H2  148"}=" H22 148";
$resn_exch{"1H3  148"}=" H31 148"; $resn_exch{"2H3  148"}=" H32 148"; $resn_exch{"1H4  148"}=" H41 148";
$resn_exch{"2H4  148"}=" H42 148"; $resn_exch{"1H5  148"}=" H51 148"; $resn_exch{"2H5  148"}=" H52 148";
$resn_exch{"1H6  148"}=" H61 148"; $resn_exch{"2H6  148"}=" H62 148"; $resn_exch{"1H7  148"}=" H71 148";
$resn_exch{"2H7  148"}=" H72 148"; $resn_exch{"1H8  148"}=" H81 148"; $resn_exch{"2H8  148"}=" H82 148";
$resn_exch{"1H6  149"}=" H61 149"; $resn_exch{"2H6  149"}=" H62 149"; $resn_exch{"1HN3 14A"}="HN31 14A";
$resn_exch{"2HN3 14A"}="HN32 14A"; $resn_exch{"1H6  14A"}=" H61 14A"; $resn_exch{"2H6  14A"}=" H62 14A";
$resn_exch{"1H7  14A"}=" H71 14A"; $resn_exch{"2H7  14A"}=" H72 14A"; $resn_exch{"1H8  14A"}=" H81 14A";
$resn_exch{"2H8  14A"}=" H82 14A"; $resn_exch{"1H20 14A"}="H201 14A"; $resn_exch{"2H20 14A"}="H202 14A";
$resn_exch{"1H22 14A"}="H221 14A"; $resn_exch{"2H22 14A"}="H222 14A"; $resn_exch{"1H24 14A"}="H241 14A";
$resn_exch{"2H24 14A"}="H242 14A"; $resn_exch{"1H25 14A"}="H251 14A"; $resn_exch{"2H25 14A"}="H252 14A";
$resn_exch{"1H26 14A"}="H261 14A"; $resn_exch{"2H26 14A"}="H262 14A"; $resn_exch{"1H27 14A"}="H271 14A";
$resn_exch{"2H27 14A"}="H272 14A"; $resn_exch{"1H7  14W"}=" H71 14W"; $resn_exch{"2H7  14W"}=" H72 14W";
$resn_exch{"1H10 14W"}="H101 14W"; $resn_exch{"2H10 14W"}="H102 14W"; $resn_exch{"3H10 14W"}="H103 14W";
$resn_exch{"1H12 14W"}="H121 14W"; $resn_exch{"2H12 14W"}="H122 14W"; $resn_exch{"1H13 14W"}="H131 14W";
$resn_exch{"2H13 14W"}="H132 14W"; $resn_exch{"1HN1 150"}="HN11 150"; $resn_exch{"2HN1 150"}="HN12 150";
$resn_exch{"1HN2 150"}="HN21 150"; $resn_exch{"2HN2 150"}="HN22 150"; $resn_exch{"1H7  150"}=" H71 150";
$resn_exch{"2H7  150"}=" H72 150"; $resn_exch{"3H7  150"}=" H73 150"; $resn_exch{"1H8  150"}=" H81 150";
$resn_exch{"2H8  150"}=" H82 150"; $resn_exch{"3H8  150"}=" H83 150"; $resn_exch{"1H26 151"}="H261 151";
$resn_exch{"2H26 151"}="H262 151"; $resn_exch{"1H28 151"}="H281 151"; $resn_exch{"2H28 151"}="H282 151";
$resn_exch{"1H3C 151"}="H3C1 151"; $resn_exch{"2H3C 151"}="H3C2 151"; $resn_exch{"3H3C 151"}="H3C3 151";
$resn_exch{"1H1C 151"}="H1C1 151"; $resn_exch{"2H1C 151"}="H1C2 151"; $resn_exch{"3H1C 151"}="H1C3 151";
$resn_exch{"1H17 151"}="H171 151"; $resn_exch{"2H17 151"}="H172 151"; $resn_exch{"3H17 151"}="H173 151";
$resn_exch{"1H9C 151"}="H9C1 151"; $resn_exch{"2H9C 151"}="H9C2 151"; $resn_exch{"1H11 151"}="H111 151";
$resn_exch{"2H11 151"}="H112 151"; $resn_exch{"1H13 151"}="H131 151"; $resn_exch{"2H13 151"}="H132 151";
$resn_exch{"1H14 151"}="H141 151"; $resn_exch{"2H14 151"}="H142 151"; $resn_exch{"1H12 151"}="H121 151";
$resn_exch{"2H12 151"}="H122 151"; $resn_exch{"1H2  152"}=" H21 152"; $resn_exch{"2H2  152"}=" H22 152";
$resn_exch{"1H4  152"}=" H41 152"; $resn_exch{"2H4  152"}=" H42 152"; $resn_exch{"1H5A 152"}="H5A1 152";
$resn_exch{"2H5A 152"}="H5A2 152"; $resn_exch{"3H5A 152"}="H5A3 152"; $resn_exch{"1H5B 152"}="H5B1 152";
$resn_exch{"2H5B 152"}="H5B2 152"; $resn_exch{"3H5B 152"}="H5B3 152"; $resn_exch{"1H5C 152"}="H5C1 152";
$resn_exch{"2H5C 152"}="H5C2 152"; $resn_exch{"3H5C 152"}="H5C3 152"; $resn_exch{"1H16 153"}="H161 153";
$resn_exch{"2H16 153"}="H162 153"; $resn_exch{"1H23 153"}="H231 153"; $resn_exch{"2H23 153"}="H232 153";
$resn_exch{"1H16 154"}="H161 154"; $resn_exch{"2H16 154"}="H162 154"; $resn_exch{"1H23 154"}="H231 154";
$resn_exch{"2H23 154"}="H232 154"; $resn_exch{"1H19 155"}="H191 155"; $resn_exch{"2H19 155"}="H192 155";
$resn_exch{"1H32 155"}="H321 155"; $resn_exch{"2H32 155"}="H322 155"; $resn_exch{"1H33 155"}="H331 155";
$resn_exch{"2H33 155"}="H332 155"; $resn_exch{"1H41 155"}="H411 155"; $resn_exch{"2H41 155"}="H412 155";
$resn_exch{"3H41 155"}="H413 155"; $resn_exch{"1H45 155"}="H451 155"; $resn_exch{"2H45 155"}="H452 155";
$resn_exch{"3H45 155"}="H453 155"; $resn_exch{"1H15 156"}="H151 156"; $resn_exch{"2H15 156"}="H152 156";
$resn_exch{"1H16 156"}="H161 156"; $resn_exch{"2H16 156"}="H162 156"; $resn_exch{"1H21 156"}="H211 156";
$resn_exch{"2H21 156"}="H212 156"; $resn_exch{"3H21 156"}="H213 156"; $resn_exch{"1H22 156"}="H221 156";
$resn_exch{"2H22 156"}="H222 156"; $resn_exch{"3H22 156"}="H223 156"; $resn_exch{"1H23 156"}="H231 156";
$resn_exch{"2H23 156"}="H232 156"; $resn_exch{"3H23 156"}="H233 156"; $resn_exch{"1H24 156"}="H241 156";
$resn_exch{"2H24 156"}="H242 156"; $resn_exch{"3H24 156"}="H243 156"; $resn_exch{"1H1  157"}=" H11 157";
$resn_exch{"2H1  157"}=" H12 157"; $resn_exch{"1H2  157"}=" H21 157"; $resn_exch{"2H2  157"}=" H22 157";
$resn_exch{"1H3  157"}=" H31 157"; $resn_exch{"2H3  157"}=" H32 157"; $resn_exch{"1H4  157"}=" H41 157";
$resn_exch{"2H4  157"}=" H42 157"; $resn_exch{"1HN6 157"}="HN61 157"; $resn_exch{"2HN6 157"}="HN62 157";
$resn_exch{"1H11 157"}="H111 157"; $resn_exch{"2H11 157"}="H112 157"; $resn_exch{"1H12 157"}="H121 157";
$resn_exch{"2H12 157"}="H122 157"; $resn_exch{"1H14 157"}="H141 157"; $resn_exch{"2H14 157"}="H142 157";
$resn_exch{"1H6  158"}=" H61 158"; $resn_exch{"2H6  158"}=" H62 158"; $resn_exch{"1H1  158"}=" H11 158";
$resn_exch{"2H1  158"}="H12A 158"; $resn_exch{"3H1  158"}=" H13 158"; $resn_exch{"1H9  158"}=" H91 158";
$resn_exch{"2H9  158"}=" H92 158"; $resn_exch{"1H5  159"}=" H51 159"; $resn_exch{"2H5  159"}=" H52 159";
$resn_exch{"1H4  159"}=" H41 159"; $resn_exch{"2H4  159"}=" H42 159"; $resn_exch{"1H6C 15A"}="H6C1 15A";
$resn_exch{"2H6C 15A"}="H6C2 15A"; $resn_exch{"1H7C 15A"}="H7C1 15A"; $resn_exch{"2H7C 15A"}="H7C2 15A";
$resn_exch{"1H8C 15A"}="H8C1 15A"; $resn_exch{"2H8C 15A"}="H8C2 15A"; $resn_exch{"1H2N 15A"}="H2N1 15A";
$resn_exch{"2H2N 15A"}="H2N2 15A"; $resn_exch{"1H6  15B"}=" H61 15B"; $resn_exch{"2H6  15B"}=" H62 15B";
$resn_exch{"1H19 15B"}="H191 15B"; $resn_exch{"2H19 15B"}="H192 15B"; $resn_exch{"1H20 15B"}="H201 15B";
$resn_exch{"2H20 15B"}="H202 15B"; $resn_exch{"1H21 15B"}="H211 15B"; $resn_exch{"2H21 15B"}="H212 15B";
$resn_exch{"1H23 15B"}="H231 15B"; $resn_exch{"2H23 15B"}="H232 15B"; $resn_exch{"1H24 15B"}="H241 15B";
$resn_exch{"2H24 15B"}="H242 15B"; $resn_exch{"1H26 15B"}="H261 15B"; $resn_exch{"2H26 15B"}="H262 15B";
$resn_exch{"1H27 15B"}="H271 15B"; $resn_exch{"2H27 15B"}="H272 15B"; $resn_exch{"1H28 15B"}="H281 15B";
$resn_exch{"2H28 15B"}="H282 15B"; $resn_exch{"1H35 15B"}="H351 15B"; $resn_exch{"2H35 15B"}="H352 15B";
$resn_exch{"1H36 15B"}="H361 15B"; $resn_exch{"2H36 15B"}="H362 15B"; $resn_exch{"1H37 15B"}="H371 15B";
$resn_exch{"2H37 15B"}="H372 15B"; $resn_exch{"1H2  15M"}="H21A 15M"; $resn_exch{"2H2  15M"}="H22A 15M";
$resn_exch{"1H3  15M"}=" H31 15M"; $resn_exch{"2H3  15M"}=" H32 15M"; $resn_exch{"1H4  15M"}=" H41 15M";
$resn_exch{"2H4  15M"}=" H42 15M"; $resn_exch{"1H7  15M"}=" H71 15M"; $resn_exch{"2H7  15M"}=" H72 15M";
$resn_exch{"1H10 15M"}="H101 15M"; $resn_exch{"2H10 15M"}="H102 15M"; $resn_exch{"1H16 15M"}="H161 15M";
$resn_exch{"2H16 15M"}="H162 15M"; $resn_exch{"1H17 15M"}="H171 15M"; $resn_exch{"2H17 15M"}="H172 15M";
$resn_exch{"1H24 15M"}="H241 15M"; $resn_exch{"2H24 15M"}="H242 15M"; $resn_exch{"3H24 15M"}="H243 15M";
$resn_exch{"1H25 15M"}="H251 15M"; $resn_exch{"2H25 15M"}="H252 15M"; $resn_exch{"1H10 15P"}="H101 15P";
$resn_exch{"2H10 15P"}="H102 15P"; $resn_exch{"1H11 15P"}="H111 15P"; $resn_exch{"2H11 15P"}="H112 15P";
$resn_exch{"1H12 15P"}="H121 15P"; $resn_exch{"2H12 15P"}="H122 15P"; $resn_exch{"1H13 15P"}="H131 15P";
$resn_exch{"2H13 15P"}="H132 15P"; $resn_exch{"1H14 15P"}="H141 15P"; $resn_exch{"2H14 15P"}="H142 15P";
$resn_exch{"1H15 15P"}="H151 15P"; $resn_exch{"2H15 15P"}="H152 15P"; $resn_exch{"1H16 15P"}="H161 15P";
$resn_exch{"2H16 15P"}="H162 15P"; $resn_exch{"1H17 15P"}="H171 15P"; $resn_exch{"2H17 15P"}="H172 15P";
$resn_exch{"1H18 15P"}="H181 15P"; $resn_exch{"2H18 15P"}="H182 15P"; $resn_exch{"1H19 15P"}="H191 15P";
$resn_exch{"2H19 15P"}="H192 15P"; $resn_exch{"1H20 15P"}="H201 15P"; $resn_exch{"2H20 15P"}="H202 15P";
$resn_exch{"1H21 15P"}="H211 15P"; $resn_exch{"2H21 15P"}="H212 15P"; $resn_exch{"1H22 15P"}="H221 15P";
$resn_exch{"2H22 15P"}="H222 15P"; $resn_exch{"1H23 15P"}="H231 15P"; $resn_exch{"2H23 15P"}="H232 15P";
$resn_exch{"1H24 15P"}="H241 15P"; $resn_exch{"2H24 15P"}="H242 15P"; $resn_exch{"1H25 15P"}="H251 15P";
$resn_exch{"2H25 15P"}="H252 15P"; $resn_exch{"1H26 15P"}="H261 15P"; $resn_exch{"2H26 15P"}="H262 15P";
$resn_exch{"1H27 15P"}="H271 15P"; $resn_exch{"2H27 15P"}="H272 15P"; $resn_exch{"1H28 15P"}="H281 15P";
$resn_exch{"2H28 15P"}="H282 15P"; $resn_exch{"1H29 15P"}="H291 15P"; $resn_exch{"2H29 15P"}="H292 15P";
$resn_exch{"1H30 15P"}="H301 15P"; $resn_exch{"2H30 15P"}="H302 15P"; $resn_exch{"1H31 15P"}="H311 15P";
$resn_exch{"2H31 15P"}="H312 15P"; $resn_exch{"1H32 15P"}="H321 15P"; $resn_exch{"2H32 15P"}="H322 15P";
$resn_exch{"1H33 15P"}="H331 15P"; $resn_exch{"2H33 15P"}="H332 15P"; $resn_exch{"1H34 15P"}="H341 15P";
$resn_exch{"2H34 15P"}="H342 15P"; $resn_exch{"1H35 15P"}="H351 15P"; $resn_exch{"2H35 15P"}="H352 15P";
$resn_exch{"1H36 15P"}="H361 15P"; $resn_exch{"2H36 15P"}="H362 15P"; $resn_exch{"1H37 15P"}="H371 15P";
$resn_exch{"2H37 15P"}="H372 15P"; $resn_exch{"1H38 15P"}="H381 15P"; $resn_exch{"2H38 15P"}="H382 15P";
$resn_exch{"1H39 15P"}="H391 15P"; $resn_exch{"2H39 15P"}="H392 15P"; $resn_exch{"1H40 15P"}="H401 15P";
$resn_exch{"2H40 15P"}="H402 15P"; $resn_exch{"1H41 15P"}="H411 15P"; $resn_exch{"2H41 15P"}="H412 15P";
$resn_exch{"1H42 15P"}="H421 15P"; $resn_exch{"2H42 15P"}="H422 15P"; $resn_exch{"1H43 15P"}="H431 15P";
$resn_exch{"2H43 15P"}="H432 15P"; $resn_exch{"1H44 15P"}="H441 15P"; $resn_exch{"2H44 15P"}="H442 15P";
$resn_exch{"1H45 15P"}="H451 15P"; $resn_exch{"2H45 15P"}="H452 15P"; $resn_exch{"1H46 15P"}="H461 15P";
$resn_exch{"2H46 15P"}="H462 15P"; $resn_exch{"1H47 15P"}="H471 15P"; $resn_exch{"2H47 15P"}="H472 15P";
$resn_exch{"1H48 15P"}="H481 15P"; $resn_exch{"2H48 15P"}="H482 15P"; $resn_exch{"1H49 15P"}="H491 15P";
$resn_exch{"2H49 15P"}="H492 15P"; $resn_exch{"1H50 15P"}="H501 15P"; $resn_exch{"2H50 15P"}="H502 15P";
$resn_exch{"1H51 15P"}="H511 15P"; $resn_exch{"2H51 15P"}="H512 15P"; $resn_exch{"1H52 15P"}="H521 15P";
$resn_exch{"2H52 15P"}="H522 15P"; $resn_exch{"1H53 15P"}="H531 15P"; $resn_exch{"2H53 15P"}="H532 15P";
$resn_exch{"1H54 15P"}="H541 15P"; $resn_exch{"2H54 15P"}="H542 15P"; $resn_exch{"1H55 15P"}="H551 15P";
$resn_exch{"2H55 15P"}="H552 15P"; $resn_exch{"1H56 15P"}="H561 15P"; $resn_exch{"2H56 15P"}="H562 15P";
$resn_exch{"1H57 15P"}="H571 15P"; $resn_exch{"2H57 15P"}="H572 15P"; $resn_exch{"1H58 15P"}="H581 15P";
$resn_exch{"2H58 15P"}="H582 15P"; $resn_exch{"1H59 15P"}="H591 15P"; $resn_exch{"2H59 15P"}="H592 15P";
$resn_exch{"1H60 15P"}="H601 15P"; $resn_exch{"2H60 15P"}="H602 15P"; $resn_exch{"1H61 15P"}="H611 15P";
$resn_exch{"2H61 15P"}="H612 15P"; $resn_exch{"1H62 15P"}="H621 15P"; $resn_exch{"2H62 15P"}="H622 15P";
$resn_exch{"1H63 15P"}="H631 15P"; $resn_exch{"2H63 15P"}="H632 15P"; $resn_exch{"1H64 15P"}="H641 15P";
$resn_exch{"2H64 15P"}="H642 15P"; $resn_exch{"1H65 15P"}="H651 15P"; $resn_exch{"2H65 15P"}="H652 15P";
$resn_exch{"1H66 15P"}="H661 15P"; $resn_exch{"2H66 15P"}="H662 15P"; $resn_exch{"1H67 15P"}="H671 15P";
$resn_exch{"2H67 15P"}="H672 15P"; $resn_exch{"1H68 15P"}="H681 15P"; $resn_exch{"2H68 15P"}="H682 15P";
$resn_exch{"1HCM 15P"}="HCM1 15P"; $resn_exch{"2HCM 15P"}="HCM2 15P"; $resn_exch{"3HCM 15P"}="HCM3 15P";
$resn_exch{"1H25 160"}="H251 160"; $resn_exch{"2H25 160"}="H252 160"; $resn_exch{"3H25 160"}="H253 160";
$resn_exch{"1H16 160"}="H161 160"; $resn_exch{"2H16 160"}="H162 160"; $resn_exch{"1H15 160"}="H151 160";
$resn_exch{"2H15 160"}="H152 160"; $resn_exch{"1H12 160"}="H121 160"; $resn_exch{"2H12 160"}="H122 160";
$resn_exch{"1H1  160"}="H11A 160"; $resn_exch{"2H1  160"}=" H12 160"; $resn_exch{"3H1  160"}=" H13 160";
$resn_exch{"1H29 160"}="H291 160"; $resn_exch{"2H29 160"}="H292 160"; $resn_exch{"1H1  161"}="H11A 161";
$resn_exch{"2H1  161"}=" H12 161"; $resn_exch{"3H1  161"}="H13A 161"; $resn_exch{"1H25 161"}="H251 161";
$resn_exch{"2H25 161"}="H252 161"; $resn_exch{"1H12 161"}="H121 161"; $resn_exch{"2H12 161"}="H122 161";
$resn_exch{"1H1  162"}="H11A 162"; $resn_exch{"2H1  162"}=" H12 162"; $resn_exch{"1H2  162"}=" H21 162";
$resn_exch{"2H2  162"}=" H22 162"; $resn_exch{"3H2  162"}=" H23 162"; $resn_exch{"1H6  162"}=" H61 162";
$resn_exch{"2H6  162"}=" H62 162"; $resn_exch{"1H14 162"}="H141 162"; $resn_exch{"2H14 162"}="H142 162";
$resn_exch{"1H16 162"}="H161 162"; $resn_exch{"2H16 162"}="H162 162"; $resn_exch{"1H17 162"}="H171 162";
$resn_exch{"2H17 162"}="H172 162"; $resn_exch{"1H18 162"}="H181 162"; $resn_exch{"2H18 162"}="H182 162";
$resn_exch{"1H19 162"}="H191 162"; $resn_exch{"2H19 162"}="H192 162"; $resn_exch{"1H20 162"}="H201 162";
$resn_exch{"2H20 162"}="H202 162"; $resn_exch{"1H21 162"}="H211 162"; $resn_exch{"2H21 162"}="H212 162";
$resn_exch{"1H1  163"}="H11A 163"; $resn_exch{"2H1  163"}=" H12 163"; $resn_exch{"1H2  163"}=" H21 163";
$resn_exch{"2H2  163"}=" H22 163"; $resn_exch{"3H2  163"}=" H23 163"; $resn_exch{"1H6  163"}=" H61 163";
$resn_exch{"2H6  163"}=" H62 163"; $resn_exch{"1H14 163"}="H141 163"; $resn_exch{"2H14 163"}="H142 163";
$resn_exch{"1H16 163"}="H161 163"; $resn_exch{"2H16 163"}="H162 163"; $resn_exch{"1H17 163"}="H171 163";
$resn_exch{"2H17 163"}="H172 163"; $resn_exch{"1H18 163"}="H181 163"; $resn_exch{"2H18 163"}="H182 163";
$resn_exch{"1H19 163"}="H191 163"; $resn_exch{"2H19 163"}="H192 163"; $resn_exch{"1H20 163"}="H201 163";
$resn_exch{"2H20 163"}="H202 163"; $resn_exch{"1H21 163"}="H211 163"; $resn_exch{"2H21 163"}="H212 163";
$resn_exch{"1H9  164"}=" H91 164"; $resn_exch{"2H9  164"}=" H92 164"; $resn_exch{"1H10 164"}="H101 164";
$resn_exch{"2H10 164"}="H102 164"; $resn_exch{"1H22 165"}="H221 165"; $resn_exch{"2H22 165"}="H222 165";
$resn_exch{"1H21 165"}="H211 165"; $resn_exch{"2H21 165"}="H212 165"; $resn_exch{"1H20 165"}="H201 165";
$resn_exch{"2H20 165"}="H202 165"; $resn_exch{"1H35 165"}="H351 165"; $resn_exch{"2H35 165"}="H352 165";
$resn_exch{"1H7  165"}=" H71 165"; $resn_exch{"2H7  165"}=" H72 165"; $resn_exch{"1H11 165"}="H111 165";
$resn_exch{"2H11 165"}="H112 165"; $resn_exch{"1H13 165"}="H131 165"; $resn_exch{"2H13 165"}="H132 165";
$resn_exch{"1H14 165"}="H141 165"; $resn_exch{"2H14 165"}="H142 165"; $resn_exch{"1H15 165"}="H151 165";
$resn_exch{"2H15 165"}="H152 165"; $resn_exch{"1H16 165"}="H161 165"; $resn_exch{"2H16 165"}="H162 165";
$resn_exch{"1H17 165"}="H171 165"; $resn_exch{"2H17 165"}="H172 165"; $resn_exch{"2H1  166"}=" H12 166";
$resn_exch{"1H1  166"}=" H11 166"; $resn_exch{"2H2  166"}=" H22 166"; $resn_exch{"1H2  166"}=" H21 166";
$resn_exch{"2H3  166"}=" H32 166"; $resn_exch{"1H3  166"}=" H31 166"; $resn_exch{"2H4  166"}=" H42 166";
$resn_exch{"1H4  166"}=" H41 166"; $resn_exch{"2H6  166"}=" H62 166"; $resn_exch{"1H6  166"}=" H61 166";
$resn_exch{"2H14 166"}="H142 166"; $resn_exch{"1H14 166"}="H141 166"; $resn_exch{"2H1  167"}=" H12 167";
$resn_exch{"1H1  167"}=" H11 167"; $resn_exch{"2H2  167"}=" H22 167"; $resn_exch{"1H2  167"}=" H21 167";
$resn_exch{"2H3  167"}=" H32 167"; $resn_exch{"1H3  167"}=" H31 167"; $resn_exch{"2H4  167"}=" H42 167";
$resn_exch{"1H4  167"}=" H41 167"; $resn_exch{"2H6  167"}=" H62 167"; $resn_exch{"1H6  167"}=" H61 167";
$resn_exch{"2H14 167"}="H142 167"; $resn_exch{"1H14 167"}="H141 167"; $resn_exch{"3H53 167"}="H533 167";
$resn_exch{"2H53 167"}="H532 167"; $resn_exch{"1H53 167"}="H531 167"; $resn_exch{"1H2  168"}=" H21 168";
$resn_exch{"2H2  168"}=" H22 168"; $resn_exch{"3H2  168"}=" H23 168"; $resn_exch{"1HP2 168"}="HP21 168";
$resn_exch{"2HP2 168"}="HP22 168"; $resn_exch{"1HP3 168"}="HP31 168"; $resn_exch{"2HP3 168"}="HP32 168";
$resn_exch{"1HP6 168"}="HP61 168"; $resn_exch{"2HP6 168"}="HP62 168"; $resn_exch{"1HP7 168"}="HP71 168";
$resn_exch{"2HP7 168"}="HP72 168"; $resn_exch{"0HPA 168"}="HPA0 168"; $resn_exch{"1HPD 168"}="HPD1 168";
$resn_exch{"2HPD 168"}="HPD2 168"; $resn_exch{"3HPD 168"}="HPD3 168"; $resn_exch{"1HPE 168"}="HPE1 168";
$resn_exch{"2HPE 168"}="HPE2 168"; $resn_exch{"3HPE 168"}="HPE3 168"; $resn_exch{"1HPC 168"}="HPC1 168";
$resn_exch{"2HPC 168"}="HPC2 168"; $resn_exch{"1HT3 168"}="HT31 168"; $resn_exch{"2HT3 168"}="HT32 168";
$resn_exch{"3HT3 168"}="HT33 168"; $resn_exch{"1HT4 168"}="HT41 168"; $resn_exch{"2HT4 168"}="HT42 168";
$resn_exch{"3HT4 168"}="HT43 168"; $resn_exch{"1HT5 168"}="HT51 168"; $resn_exch{"2HT5 168"}="HT52 168";
$resn_exch{"3HT5 168"}="HT53 168"; $resn_exch{"1H1  169"}="H11A 169"; $resn_exch{"2H1  169"}="H12A 169";
$resn_exch{"3H1  169"}=" H13 169"; $resn_exch{"1H3  169"}=" H31 169"; $resn_exch{"2H3  169"}=" H32 169";
$resn_exch{"3H3  169"}=" H33 169"; $resn_exch{"1H4  169"}=" H41 169"; $resn_exch{"2H4  169"}=" H42 169";
$resn_exch{"3H4  169"}=" H43 169"; $resn_exch{"1H5  169"}=" H51 169"; $resn_exch{"2H5  169"}=" H52 169";
$resn_exch{"1H6  169"}=" H61 169"; $resn_exch{"2H6  169"}=" H62 169"; $resn_exch{"1H7  169"}=" H71 169";
$resn_exch{"2H7  169"}=" H72 169"; $resn_exch{"1H8  169"}=" H81 169"; $resn_exch{"2H8  169"}=" H82 169";
$resn_exch{"1H13 169"}="H131 169"; $resn_exch{"2H13 169"}="H132 169"; $resn_exch{"1H14 169"}="H141 169";
$resn_exch{"2H14 169"}="H142 169"; $resn_exch{"1H15 169"}="H151 169"; $resn_exch{"2H15 169"}="H152 169";
$resn_exch{"1HN5 169"}="HN51 169"; $resn_exch{"5HN5 169"}="HN55 169"; $resn_exch{"1H1  16A"}=" H11 16A";
$resn_exch{"2H1  16A"}=" H12 16A"; $resn_exch{"3H1  16A"}=" H13 16A"; $resn_exch{"1H2  16A"}=" H21 16A";
$resn_exch{"2H2  16A"}=" H22 16A"; $resn_exch{"1H3  16A"}=" H31 16A"; $resn_exch{"2H3  16A"}=" H32 16A";
$resn_exch{"1H4  16A"}=" H41 16A"; $resn_exch{"2H4  16A"}=" H42 16A"; $resn_exch{"1H5  16A"}=" H51 16A";
$resn_exch{"2H5  16A"}=" H52 16A"; $resn_exch{"1H6  16A"}=" H61 16A"; $resn_exch{"2H6  16A"}=" H62 16A";
$resn_exch{"1H7  16A"}=" H71 16A"; $resn_exch{"2H7  16A"}=" H72 16A"; $resn_exch{"1H8  16A"}=" H81 16A";
$resn_exch{"2H8  16A"}=" H82 16A"; $resn_exch{"1H9  16A"}=" H91 16A"; $resn_exch{"2H9  16A"}=" H92 16A";
$resn_exch{"1H10 16A"}="H101 16A"; $resn_exch{"2H10 16A"}="H102 16A"; $resn_exch{"1H11 16A"}="H111 16A";
$resn_exch{"2H11 16A"}="H112 16A"; $resn_exch{"1H12 16A"}="H121 16A"; $resn_exch{"2H12 16A"}="H122 16A";
$resn_exch{"1H13 16A"}="H131 16A"; $resn_exch{"2H13 16A"}="H132 16A"; $resn_exch{"1H14 16A"}="H141 16A";
$resn_exch{"2H14 16A"}="H142 16A"; $resn_exch{"1H15 16A"}="H151 16A"; $resn_exch{"2H15 16A"}="H152 16A";
$resn_exch{"1H16 16A"}="H161 16A"; $resn_exch{"2H16 16A"}="H162 16A"; $resn_exch{"1H17 16A"}="H171 16A";
$resn_exch{"2H17 16A"}="H172 16A"; $resn_exch{"3H17 16A"}="H173 16A"; $resn_exch{"1H18 16A"}="H181 16A";
$resn_exch{"2H18 16A"}="H182 16A"; $resn_exch{"3H18 16A"}="H183 16A"; $resn_exch{"1H19 16A"}="H191 16A";
$resn_exch{"2H19 16A"}="H192 16A"; $resn_exch{"3H19 16A"}="H193 16A"; $resn_exch{"1H1  16C"}=" H11 16C";
$resn_exch{"2H1  16C"}=" H12 16C"; $resn_exch{"1H6  16C"}=" H61 16C"; $resn_exch{"2H6  16C"}=" H62 16C";
$resn_exch{"1H7  16C"}=" H71 16C"; $resn_exch{"2H7  16C"}=" H72 16C"; $resn_exch{"1H8  16C"}=" H81 16C";
$resn_exch{"2H8  16C"}=" H82 16C"; $resn_exch{"1H9  16C"}=" H91 16C"; $resn_exch{"2H9  16C"}=" H92 16C";
$resn_exch{"1H10 16C"}="H101 16C"; $resn_exch{"2H10 16C"}="H102 16C"; $resn_exch{"1H11 16C"}="H111 16C";
$resn_exch{"2H11 16C"}="H112 16C"; $resn_exch{"1H12 16C"}="H121 16C"; $resn_exch{"2H12 16C"}="H122 16C";
$resn_exch{"1H13 16C"}="H131 16C"; $resn_exch{"2H13 16C"}="H132 16C"; $resn_exch{"1H14 16C"}="H141 16C";
$resn_exch{"2H14 16C"}="H142 16C"; $resn_exch{"1H15 16C"}="H151 16C"; $resn_exch{"2H15 16C"}="H152 16C";
$resn_exch{"1H16 16C"}="H161 16C"; $resn_exch{"2H16 16C"}="H162 16C"; $resn_exch{"1H17 16C"}="H171 16C";
$resn_exch{"2H17 16C"}="H172 16C"; $resn_exch{"1H18 16C"}="H181 16C"; $resn_exch{"2H18 16C"}="H182 16C";
$resn_exch{"3H18 16C"}="H183 16C"; $resn_exch{"1H20 16C"}="H201 16C"; $resn_exch{"2H20 16C"}="H202 16C";
$resn_exch{"1H21 16C"}="H211 16C"; $resn_exch{"2H21 16C"}="H212 16C"; $resn_exch{"1H22 16C"}="H221 16C";
$resn_exch{"2H22 16C"}="H222 16C"; $resn_exch{"1H23 16C"}="H231 16C"; $resn_exch{"2H23 16C"}="H232 16C";
$resn_exch{"1H24 16C"}="H241 16C"; $resn_exch{"2H24 16C"}="H242 16C"; $resn_exch{"1H25 16C"}="H251 16C";
$resn_exch{"2H25 16C"}="H252 16C"; $resn_exch{"1H26 16C"}="H261 16C"; $resn_exch{"2H26 16C"}="H262 16C";
$resn_exch{"1H27 16C"}="H271 16C"; $resn_exch{"2H27 16C"}="H272 16C"; $resn_exch{"1H28 16C"}="H281 16C";
$resn_exch{"2H28 16C"}="H282 16C"; $resn_exch{"1H29 16C"}="H291 16C"; $resn_exch{"2H29 16C"}="H292 16C";
$resn_exch{"1H30 16C"}="H301 16C"; $resn_exch{"2H30 16C"}="H302 16C"; $resn_exch{"1H31 16C"}="H311 16C";
$resn_exch{"2H31 16C"}="H312 16C"; $resn_exch{"1H32 16C"}="H321 16C"; $resn_exch{"2H32 16C"}="H322 16C";
$resn_exch{"1H33 16C"}="H331 16C"; $resn_exch{"2H33 16C"}="H332 16C"; $resn_exch{"1H34 16C"}="H341 16C";
$resn_exch{"2H34 16C"}="H342 16C"; $resn_exch{"3H34 16C"}="H343 16C"; $resn_exch{"1HN1 16D"}="HN11 16D";
$resn_exch{"2HN1 16D"}="HN12 16D"; $resn_exch{"1H1  16D"}=" H11 16D"; $resn_exch{"2H1  16D"}=" H12 16D";
$resn_exch{"1H2  16D"}=" H21 16D"; $resn_exch{"2H2  16D"}=" H22 16D"; $resn_exch{"1H3  16D"}=" H31 16D";
$resn_exch{"2H3  16D"}=" H32 16D"; $resn_exch{"1H4  16D"}=" H41 16D"; $resn_exch{"2H4  16D"}=" H42 16D";
$resn_exch{"1H5  16D"}=" H51 16D"; $resn_exch{"2H5  16D"}=" H52 16D"; $resn_exch{"1H6  16D"}=" H61 16D";
$resn_exch{"2H6  16D"}=" H62 16D"; $resn_exch{"1HN2 16D"}="HN21 16D"; $resn_exch{"2HN2 16D"}="HN22 16D";
$resn_exch{"1H6  16G"}=" H61 16G"; $resn_exch{"2H6  16G"}=" H62 16G"; $resn_exch{"1H8  16G"}=" H81 16G";
$resn_exch{"2H8  16G"}=" H82 16G"; $resn_exch{"3H8  16G"}=" H83 16G"; $resn_exch{"2HOP 16G"}="HOP2 16G";
$resn_exch{"3HOP 16G"}="HOP3 16G"; $resn_exch{"1H1  16P"}=" H11 16P"; $resn_exch{"2H1  16P"}=" H12 16P";
$resn_exch{"3H1  16P"}=" H13 16P"; $resn_exch{"1H2  16P"}=" H21 16P"; $resn_exch{"2H2  16P"}=" H22 16P";
$resn_exch{"1H3  16P"}=" H31 16P"; $resn_exch{"2H3  16P"}=" H32 16P"; $resn_exch{"1H4  16P"}=" H41 16P";
$resn_exch{"2H4  16P"}=" H42 16P"; $resn_exch{"1H5  16P"}=" H51 16P"; $resn_exch{"2H5  16P"}=" H52 16P";
$resn_exch{"1H6  16P"}=" H61 16P"; $resn_exch{"2H6  16P"}=" H62 16P"; $resn_exch{"1H7  16P"}=" H71 16P";
$resn_exch{"2H7  16P"}=" H72 16P"; $resn_exch{"1H8  16P"}=" H81 16P"; $resn_exch{"2H8  16P"}=" H82 16P";
$resn_exch{"1H9  16P"}=" H91 16P"; $resn_exch{"2H9  16P"}=" H92 16P"; $resn_exch{"1H10 16P"}="H101 16P";
$resn_exch{"2H10 16P"}="H102 16P"; $resn_exch{"1H11 16P"}="H111 16P"; $resn_exch{"2H11 16P"}="H112 16P";
$resn_exch{"1H12 16P"}="H121 16P"; $resn_exch{"2H12 16P"}="H122 16P"; $resn_exch{"1H13 16P"}="H131 16P";
$resn_exch{"2H13 16P"}="H132 16P"; $resn_exch{"1H14 16P"}="H141 16P"; $resn_exch{"2H14 16P"}="H142 16P";
$resn_exch{"3H14 16P"}="H143 16P"; $resn_exch{"1H1  170"}=" H11 170"; $resn_exch{"2H1  170"}=" H12 170";
$resn_exch{"1H33 170"}="H331 170"; $resn_exch{"2H33 170"}="H332 170"; $resn_exch{"1H39 170"}="H391 170";
$resn_exch{"2H39 170"}="H392 170"; $resn_exch{"1H1  171"}=" H11 171"; $resn_exch{"2H1  171"}=" H12 171";
$resn_exch{"1H2  171"}=" H21 171"; $resn_exch{"2H2  171"}=" H22 171"; $resn_exch{"1H14 172"}="H141 172";
$resn_exch{"2H14 172"}="H142 172"; $resn_exch{" HN2 175"}=" H2  175"; $resn_exch{" H2  175"}=" HC2 175";
$resn_exch{"1HB  175"}=" HB1 175"; $resn_exch{"2HB  175"}=" HB2 175"; $resn_exch{"3HB  175"}=" HB3 175";
$resn_exch{"2HN  175"}="HN2A 175"; $resn_exch{"1H4  175"}=" H41 175"; $resn_exch{"2H4  175"}=" H42 175";
$resn_exch{"1HA  175"}=" HA1 175"; $resn_exch{"2HA  175"}=" HA2 175"; $resn_exch{"1HN5 175"}="HN51 175";
$resn_exch{"2HN5 175"}="HN52 175"; $resn_exch{"1HN0 176"}="HN01 176"; $resn_exch{"2HN0 176"}="HN02 176";
$resn_exch{"1HD  176"}="HD1A 176"; $resn_exch{"2HD  176"}="HD2A 176"; $resn_exch{"1HB  176"}=" HB1 176";
$resn_exch{"2HB  176"}=" HB2 176"; $resn_exch{"1HG  176"}=" HG1 176"; $resn_exch{"2HG  176"}=" HG2 176";
$resn_exch{"1HA1 176"}="HA11 176"; $resn_exch{"2HA1 176"}="HA12 176"; $resn_exch{" HG* 176"}=" HG' 176";
$resn_exch{"1HG1 177"}="HG11 177"; $resn_exch{"2HG1 177"}="HG12 177"; $resn_exch{"1HG2 177"}="HG21 177";
$resn_exch{"2HG2 177"}="HG22 177"; $resn_exch{"1HD1 177"}="HD11 177"; $resn_exch{"2HD1 177"}="HD12 177";
$resn_exch{"1HD2 177"}="HD21 177"; $resn_exch{"2HD2 177"}="HD22 177"; $resn_exch{"1HE0 177"}="HE01 177";
$resn_exch{"2HE0 177"}="HE02 177"; $resn_exch{"1H0  177"}=" H01 177"; $resn_exch{"2H0  177"}=" H02 177";
$resn_exch{"1HD  177"}=" HD1 177"; $resn_exch{"2HD  177"}=" HD2 177"; $resn_exch{"1HB  177"}=" HB1 177";
$resn_exch{"2HB  177"}=" HB2 177"; $resn_exch{"1HG  177"}=" HG1 177"; $resn_exch{"2HG  177"}=" HG2 177";
$resn_exch{"1HA' 177"}="HA'1 177"; $resn_exch{"2HA' 177"}="HA'2 177"; $resn_exch{" HG* 177"}=" HG' 177";
$resn_exch{"1HF  177"}=" HF1 177"; $resn_exch{"2HF  177"}=" HF2 177"; $resn_exch{"1HM  177"}=" HM1 177";
$resn_exch{"2HM  177"}=" HM2 177"; $resn_exch{"1HN  177"}=" HN1 177"; $resn_exch{"2HN  177"}="HN2A 177";
$resn_exch{"3HN  177"}=" HN3 177"; $resn_exch{"1H2B 178"}="H2B1 178"; $resn_exch{"2H2B 178"}="H2B2 178";
$resn_exch{"3H2B 178"}="H2B3 178"; $resn_exch{"1H2G 178"}="H2G1 178"; $resn_exch{"2H2G 178"}="H2G2 178";
$resn_exch{"3H2G 178"}="H2G3 178"; $resn_exch{"1H2Y 178"}="H2Y1 178"; $resn_exch{"2H2Y 178"}="H2Y2 178";
$resn_exch{"3H2Y 178"}="H2Y3 178"; $resn_exch{"1H2Z 178"}="H2Z1 178"; $resn_exch{"2H2Z 178"}="H2Z2 178";
$resn_exch{"3H2Z 178"}="H2Z3 178"; $resn_exch{"1H30 17A"}="H301 17A"; $resn_exch{"2H30 17A"}="H302 17A";
$resn_exch{"3H30 17A"}="H303 17A"; $resn_exch{"1H29 17A"}="H291 17A"; $resn_exch{"2H29 17A"}="H292 17A";
$resn_exch{"3H29 17A"}="H293 17A"; $resn_exch{"1H15 17A"}="H151 17A"; $resn_exch{"2H15 17A"}="H152 17A";
$resn_exch{"1H9  17A"}=" H91 17A"; $resn_exch{"2H9  17A"}=" H92 17A"; $resn_exch{"1H10 17A"}="H101 17A";
$resn_exch{"2H10 17A"}="H102 17A"; $resn_exch{"1H8C 17B"}="H8C1 17B"; $resn_exch{"2H8C 17B"}="H8C2 17B";
$resn_exch{"1H7C 17B"}="H7C1 17B"; $resn_exch{"2H7C 17B"}="H7C2 17B"; $resn_exch{"1H9C 17B"}="H9C1 17B";
$resn_exch{"2H9C 17B"}="H9C2 17B"; $resn_exch{"1H6C 17B"}="H6C1 17B"; $resn_exch{"2H6C 17B"}="H6C2 17B";
$resn_exch{"1H1N 17B"}="H1N1 17B"; $resn_exch{"2H1N 17B"}="H1N2 17B"; $resn_exch{"1H10 17B"}="H101 17B";
$resn_exch{"2H10 17B"}="H102 17B"; $resn_exch{"3H1N 17B"}="H1N3 17B"; $resn_exch{"1H2  17H"}=" H21 17H";
$resn_exch{"2H2  17H"}=" H22 17H"; $resn_exch{"1H7  17H"}=" H71 17H"; $resn_exch{"2H7  17H"}=" H72 17H";
$resn_exch{"1H6  17H"}=" H61 17H"; $resn_exch{"2H6  17H"}=" H62 17H"; $resn_exch{"1H1  17H"}="H11A 17H";
$resn_exch{"2H1  17H"}="H12A 17H"; $resn_exch{"1H15 17H"}="H151 17H"; $resn_exch{"2H15 17H"}="H152 17H";
$resn_exch{"1H16 17H"}="H161 17H"; $resn_exch{"2H16 17H"}="H162 17H"; $resn_exch{"1H18 17H"}="H181 17H";
$resn_exch{"2H18 17H"}="H182 17H"; $resn_exch{"1H22 17H"}="H221 17H"; $resn_exch{"2H22 17H"}="H222 17H";
$resn_exch{"3H22 17H"}="H223 17H"; $resn_exch{"1H21 17H"}="H211 17H"; $resn_exch{"2H21 17H"}="H212 17H";
$resn_exch{"3H21 17H"}="H213 17H"; $resn_exch{"1H20 17H"}="H201 17H"; $resn_exch{"2H20 17H"}="H202 17H";
$resn_exch{"1HAR 17M"}="HAR1 17M"; $resn_exch{"2HAR 17M"}="HAR2 17M"; $resn_exch{"3HAR 17M"}="HAR3 17M";
$resn_exch{"1HAP 17M"}="HAP1 17M"; $resn_exch{"2HAP 17M"}="HAP2 17M"; $resn_exch{"1HAJ 17M"}="HAJ1 17M";
$resn_exch{"2HAJ 17M"}="HAJ2 17M"; $resn_exch{"1HAQ 17M"}="HAQ1 17M"; $resn_exch{"2HAQ 17M"}="HAQ2 17M";
$resn_exch{"1HAC 17M"}="HAC1 17M"; $resn_exch{"2HAC 17M"}="HAC2 17M"; $resn_exch{"1HAS 17M"}="HAS1 17M";
$resn_exch{"2HAS 17M"}="HAS2 17M"; $resn_exch{"3HAS 17M"}="HAS3 17M"; $resn_exch{"1H3  180"}=" H31 180";
$resn_exch{"2H3  180"}=" H32 180"; $resn_exch{"1H10 180"}="H101 180"; $resn_exch{"2H10 180"}="H102 180";
$resn_exch{"1H11 180"}="H111 180"; $resn_exch{"2H11 180"}="H112 180"; $resn_exch{"1H13 180"}="H131 180";
$resn_exch{"2H13 180"}="H132 180"; $resn_exch{"1H14 180"}="H141 180"; $resn_exch{"2H14 180"}="H142 180";
$resn_exch{"1H15 180"}="H151 180"; $resn_exch{"2H15 180"}="H152 180"; $resn_exch{"1H16 180"}="H161 180";
$resn_exch{"2H16 180"}="H162 180"; $resn_exch{"1HAJ 181"}="HAJ1 181"; $resn_exch{"2HAJ 181"}="HAJ2 181";
$resn_exch{"1HAK 181"}="HAK1 181"; $resn_exch{"2HAK 181"}="HAK2 181"; $resn_exch{"1HAL 181"}="HAL1 181";
$resn_exch{"2HAL 181"}="HAL2 181"; $resn_exch{"1HAJ 182"}="HAJ1 182"; $resn_exch{"2HAJ 182"}="HAJ2 182";
$resn_exch{"1HAK 182"}="HAK1 182"; $resn_exch{"2HAK 182"}="HAK2 182"; $resn_exch{"1HAL 182"}="HAL1 182";
$resn_exch{"2HAL 182"}="HAL2 182"; $resn_exch{"1HAN 183"}="HAN1 183"; $resn_exch{"2HAN 183"}="HAN2 183";
$resn_exch{"1HAO 183"}="HAO1 183"; $resn_exch{"2HAO 183"}="HAO2 183"; $resn_exch{"1HAR 183"}="HAR1 183";
$resn_exch{"2HAR 183"}="HAR2 183"; $resn_exch{"1HAQ 183"}="HAQ1 183"; $resn_exch{"2HAQ 183"}="HAQ2 183";
$resn_exch{"1HAP 183"}="HAP1 183"; $resn_exch{"2HAP 183"}="HAP2 183"; $resn_exch{"1H17 184"}="H171 184";
$resn_exch{"2H17 184"}="H172 184"; $resn_exch{"1H18 184"}="H181 184"; $resn_exch{"2H18 184"}="H182 184";
$resn_exch{"1H23 184"}="H231 184"; $resn_exch{"2H23 184"}="H232 184"; $resn_exch{"3H23 184"}="H233 184";
$resn_exch{"1H24 184"}="H241 184"; $resn_exch{"2H24 184"}="H242 184"; $resn_exch{"3H24 184"}="H243 184";
$resn_exch{"1H25 184"}="H251 184"; $resn_exch{"2H25 184"}="H252 184"; $resn_exch{"3H25 184"}="H253 184";
$resn_exch{"1H26 184"}="H261 184"; $resn_exch{"2H26 184"}="H262 184"; $resn_exch{"3H26 184"}="H263 184";
$resn_exch{"1H2' 185"}="H2'1 185"; $resn_exch{"2H2' 185"}="H2'2 185"; $resn_exch{"3H2' 185"}="H2'3 185";
$resn_exch{"1H6' 185"}="H6'1 185"; $resn_exch{"2H6' 185"}="H6'2 185"; $resn_exch{"3H6' 185"}="H6'3 185";
$resn_exch{"1H18 185"}="H181 185"; $resn_exch{"2H18 185"}="H182 185"; $resn_exch{"1H27 186"}="H271 186";
$resn_exch{"2H27 186"}="H272 186"; $resn_exch{"1H16 186"}="H161 186"; $resn_exch{"2H16 186"}="H162 186";
$resn_exch{"1H14 186"}="H141 186"; $resn_exch{"2H14 186"}="H142 186"; $resn_exch{"3H14 186"}="H143 186";
$resn_exch{"1HN4 187"}="HN41 187"; $resn_exch{"2HN4 187"}="HN42 187"; $resn_exch{"1H13 188"}="H131 188";
$resn_exch{"2H13 188"}="H132 188"; $resn_exch{"1H16 188"}="H161 188"; $resn_exch{"2H16 188"}="H162 188";
$resn_exch{"1H18 188"}="H181 188"; $resn_exch{"2H18 188"}="H182 188"; $resn_exch{"3H18 188"}="H183 188";
$resn_exch{"1H20 189"}="H201 189"; $resn_exch{"2H20 189"}="H202 189"; $resn_exch{"1H26 189"}="H261 189";
$resn_exch{"2H26 189"}="H262 189"; $resn_exch{"1H36 189"}="H361 189"; $resn_exch{"2H36 189"}="H362 189";
$resn_exch{"1H45 189"}="H451 189"; $resn_exch{"2H45 189"}="H452 189"; $resn_exch{"3H45 189"}="H453 189";
$resn_exch{"1H44 189"}="H441 189"; $resn_exch{"2H44 189"}="H442 189"; $resn_exch{"3H44 189"}="H443 189";
$resn_exch{"1H24 189"}="H241 189"; $resn_exch{"2H24 189"}="H242 189"; $resn_exch{"1H22 189"}="H221 189";
$resn_exch{"2H22 189"}="H222 189"; $resn_exch{"1H16 189"}="H161 189"; $resn_exch{"2H16 189"}="H162 189";
$resn_exch{"3H16 189"}="H163 189"; $resn_exch{"1H19 189"}="H191 189"; $resn_exch{"2H19 189"}="H192 189";
$resn_exch{"1H18 189"}="H181 189"; $resn_exch{"2H18 189"}="H182 189"; $resn_exch{"3H18 189"}="H183 189";
$resn_exch{"1H28 189"}="H281 189"; $resn_exch{"2H28 189"}="H282 189"; $resn_exch{"1H36 18C"}="H361 18C";
$resn_exch{"2H36 18C"}="H362 18C"; $resn_exch{"3H36 18C"}="H363 18C"; $resn_exch{"1H35 18C"}="H351 18C";
$resn_exch{"2H35 18C"}="H352 18C"; $resn_exch{"1H34 18C"}="H341 18C"; $resn_exch{"2H34 18C"}="H342 18C";
$resn_exch{"1H33 18C"}="H331 18C"; $resn_exch{"2H33 18C"}="H332 18C"; $resn_exch{"1H32 18C"}="H321 18C";
$resn_exch{"2H32 18C"}="H322 18C"; $resn_exch{"1H31 18C"}="H311 18C"; $resn_exch{"2H31 18C"}="H312 18C";
$resn_exch{"1H30 18C"}="H301 18C"; $resn_exch{"2H30 18C"}="H302 18C"; $resn_exch{"1H29 18C"}="H291 18C";
$resn_exch{"2H29 18C"}="H292 18C"; $resn_exch{"1H28 18C"}="H281 18C"; $resn_exch{"2H28 18C"}="H282 18C";
$resn_exch{"1H27 18C"}="H271 18C"; $resn_exch{"2H27 18C"}="H272 18C"; $resn_exch{"1H26 18C"}="H261 18C";
$resn_exch{"2H26 18C"}="H262 18C"; $resn_exch{"1H25 18C"}="H251 18C"; $resn_exch{"2H25 18C"}="H252 18C";
$resn_exch{"1H24 18C"}="H241 18C"; $resn_exch{"2H24 18C"}="H242 18C"; $resn_exch{"1H23 18C"}="H231 18C";
$resn_exch{"2H23 18C"}="H232 18C"; $resn_exch{"1H22 18C"}="H221 18C"; $resn_exch{"2H22 18C"}="H222 18C";
$resn_exch{"1H21 18C"}="H211 18C"; $resn_exch{"2H21 18C"}="H212 18C"; $resn_exch{"1H20 18C"}="H201 18C";
$resn_exch{"2H20 18C"}="H202 18C"; $resn_exch{"1H1  18C"}=" H11 18C"; $resn_exch{"2H1  18C"}=" H12 18C";
$resn_exch{"1H6  18C"}=" H61 18C"; $resn_exch{"2H6  18C"}=" H62 18C"; $resn_exch{"1H7  18C"}=" H71 18C";
$resn_exch{"2H7  18C"}=" H72 18C"; $resn_exch{"1H8  18C"}=" H81 18C"; $resn_exch{"2H8  18C"}=" H82 18C";
$resn_exch{"1H9  18C"}=" H91 18C"; $resn_exch{"2H9  18C"}=" H92 18C"; $resn_exch{"1H10 18C"}="H101 18C";
$resn_exch{"2H10 18C"}="H102 18C"; $resn_exch{"1H11 18C"}="H111 18C"; $resn_exch{"2H11 18C"}="H112 18C";
$resn_exch{"1H12 18C"}="H121 18C"; $resn_exch{"2H12 18C"}="H122 18C"; $resn_exch{"1H13 18C"}="H131 18C";
$resn_exch{"2H13 18C"}="H132 18C"; $resn_exch{"1H14 18C"}="H141 18C"; $resn_exch{"2H14 18C"}="H142 18C";
$resn_exch{"1H15 18C"}="H151 18C"; $resn_exch{"2H15 18C"}="H152 18C"; $resn_exch{"1H16 18C"}="H161 18C";
$resn_exch{"2H16 18C"}="H162 18C"; $resn_exch{"1H17 18C"}="H171 18C"; $resn_exch{"2H17 18C"}="H172 18C";
$resn_exch{"1H18 18C"}="H181 18C"; $resn_exch{"2H18 18C"}="H182 18C"; $resn_exch{"3H18 18C"}="H183 18C";
$resn_exch{"1H8  190"}=" H81 190"; $resn_exch{"2H8  190"}=" H82 190"; $resn_exch{"3H8  190"}=" H83 190";
$resn_exch{"1H7  190"}=" H71 190"; $resn_exch{"2H7  190"}=" H72 190"; $resn_exch{"3H7  190"}=" H73 190";
$resn_exch{"1H10 190"}="H101 190"; $resn_exch{"2H10 190"}="H102 190"; $resn_exch{"1H16 190"}="H161 190";
$resn_exch{"2H16 190"}="H162 190"; $resn_exch{"1H24 190"}="H241 190"; $resn_exch{"2H24 190"}="H242 190";
$resn_exch{"1H26 190"}="H261 190"; $resn_exch{"2H26 190"}="H262 190"; $resn_exch{"1H28 190"}="H281 190";
$resn_exch{"2H28 190"}="H282 190"; $resn_exch{"3H28 190"}="H283 190"; $resn_exch{"1H29 190"}="H291 190";
$resn_exch{"2H29 190"}="H292 190"; $resn_exch{"3H29 190"}="H293 190"; $resn_exch{"1H3  191"}=" H31 191";
$resn_exch{"2H3  191"}="H32A 191"; $resn_exch{"3H3  191"}="H33A 191"; $resn_exch{"1H2  191"}=" H21 191";
$resn_exch{"2H2  191"}="H22A 191"; $resn_exch{"1H5  191"}=" H51 191"; $resn_exch{"2H5  191"}=" H52 191";
$resn_exch{"1H6  191"}=" H61 191"; $resn_exch{"2H6  191"}=" H62 191"; $resn_exch{"1H9  191"}=" H91 191";
$resn_exch{"2H9  191"}=" H92 191"; $resn_exch{"1H10 191"}="H101 191"; $resn_exch{"2H10 191"}="H102 191";
$resn_exch{"1H17 191"}="H171 191"; $resn_exch{"2H17 191"}="H172 191"; $resn_exch{"3H17 191"}="H173 191";
$resn_exch{"1H18 191"}="H181 191"; $resn_exch{"2H18 191"}="H182 191"; $resn_exch{"3H18 191"}="H183 191";
$resn_exch{"1H19 191"}="H191 191"; $resn_exch{"2H19 191"}="H192 191"; $resn_exch{"1H5* 191"}="H5'1 191";
$resn_exch{"2H5* 191"}="H5'2 191"; $resn_exch{" H4* 191"}=" H4' 191"; $resn_exch{" H3* 191"}=" H3' 191";
$resn_exch{" H2* 191"}=" H2' 191"; $resn_exch{"2HO* 191"}="HO'2 191"; $resn_exch{" H1* 191"}=" H1' 191";
$resn_exch{"1H41 191"}="H411 191"; $resn_exch{"2H41 191"}="H412 191"; $resn_exch{"1HB1 192"}="HB11 192";
$resn_exch{"2HB1 192"}="HB12 192"; $resn_exch{"1HG  192"}=" HG1 192"; $resn_exch{"2HG  192"}=" HG2 192";
$resn_exch{"1HB2 192"}="HB21 192"; $resn_exch{"2HB2 192"}="HB22 192"; $resn_exch{"2HB  193"}=" HB2 193";
$resn_exch{"1HB  193"}=" HB1 193"; $resn_exch{"2HG  193"}=" HG2 193"; $resn_exch{"1HG  193"}=" HG1 193";
$resn_exch{"2HZ  193"}=" HZ2 193"; $resn_exch{"1HZ  193"}=" HZ1 193"; $resn_exch{"2HT  193"}=" HT2 193";
$resn_exch{"1HT  193"}=" HT1 193"; $resn_exch{"1H7  197"}="H71A 197"; $resn_exch{"2H7  197"}=" H72 197";
$resn_exch{"1H13 197"}="H131 197"; $resn_exch{"2H13 197"}="H132 197"; $resn_exch{"3H13 197"}="H133 197";
$resn_exch{"1H17 197"}="H171 197"; $resn_exch{"2H17 197"}="H172 197"; $resn_exch{"1H18 197"}="H181 197";
$resn_exch{"2H18 197"}="H182 197"; $resn_exch{"1H19 197"}="H191 197"; $resn_exch{"2H19 197"}="H192 197";
$resn_exch{"1H20 197"}="H201 197"; $resn_exch{"2H20 197"}="H202 197"; $resn_exch{"1H23 197"}="H231 197";
$resn_exch{"2H23 197"}="H232 197"; $resn_exch{"1H13 198"}="H131 198"; $resn_exch{"2H13 198"}="H132 198";
$resn_exch{"1H12 198"}="H121 198"; $resn_exch{"2H12 198"}="H122 198"; $resn_exch{"3H12 198"}="H123 198";
$resn_exch{"1H25 199"}="H251 199"; $resn_exch{"2H25 199"}="H252 199"; $resn_exch{"1H26 199"}="H261 199";
$resn_exch{"2H26 199"}="H262 199"; $resn_exch{"1H28 199"}="H281 199"; $resn_exch{"2H28 199"}="H282 199";
$resn_exch{"1H29 199"}="H291 199"; $resn_exch{"2H29 199"}="H292 199"; $resn_exch{"1H31 199"}="H311 199";
$resn_exch{"2H31 199"}="H312 199"; $resn_exch{"3H31 199"}="H313 199"; $resn_exch{"1H1  19A"}=" H11 19A";
$resn_exch{"2H1  19A"}=" H12 19A"; $resn_exch{"3H1  19A"}=" H13 19A"; $resn_exch{"1H3  19A"}=" H31 19A";
$resn_exch{"2H3  19A"}=" H32 19A"; $resn_exch{"3H3  19A"}=" H33 19A"; $resn_exch{"1HN3 1AA"}="HN31 1AA";
$resn_exch{"2HN3 1AA"}="HN32 1AA"; $resn_exch{" H8* 1AA"}=" H8' 1AA"; $resn_exch{" H7* 1AA"}=" H7' 1AA";
$resn_exch{" H4* 1AA"}=" H4' 1AA"; $resn_exch{"1H6  1AA"}=" H61 1AA"; $resn_exch{"2H6  1AA"}=" H62 1AA";
$resn_exch{"1H7  1AA"}=" H71 1AA"; $resn_exch{"2H7  1AA"}=" H72 1AA"; $resn_exch{"1H8  1AA"}=" H81 1AA";
$resn_exch{"2H8  1AA"}=" H82 1AA"; $resn_exch{" H2* 1AA"}=" H2' 1AA"; $resn_exch{" H3* 1AA"}=" H3' 1AA";
$resn_exch{" H5* 1AA"}=" H5' 1AA"; $resn_exch{"1HN1 1AA"}="HN11 1AA"; $resn_exch{"2HN1 1AA"}="HN12 1AA";
$resn_exch{"1H2  1AB"}=" H21 1AB"; $resn_exch{"2H2  1AB"}=" H22 1AB"; $resn_exch{"1H6  1AB"}=" H61 1AB";
$resn_exch{"2H6  1AB"}=" H62 1AB"; $resn_exch{"1H3  1AC"}=" H31 1AC"; $resn_exch{"2H3  1AC"}=" H32 1AC";
$resn_exch{"1H4  1AC"}=" H41 1AC"; $resn_exch{"2H4  1AC"}=" H42 1AC"; $resn_exch{"1H1  1AC"}=" H11 1AC";
$resn_exch{"2H1  1AC"}=" H12 1AC"; $resn_exch{"1H5  1AD"}=" H51 1AD"; $resn_exch{"2H5  1AD"}=" H52 1AD";
$resn_exch{"1H7  1AD"}=" H71 1AD"; $resn_exch{"2H7  1AD"}=" H72 1AD"; $resn_exch{"1H8  1AD"}=" H81 1AD";
$resn_exch{"2H8  1AD"}=" H82 1AD"; $resn_exch{"1H12 1AD"}="H121 1AD"; $resn_exch{"2H12 1AD"}="H122 1AD";
$resn_exch{"1H14 1AD"}="H141 1AD"; $resn_exch{"2H14 1AD"}="H142 1AD"; $resn_exch{"1H15 1AD"}="H151 1AD";
$resn_exch{"2H15 1AD"}="H152 1AD"; $resn_exch{"3H15 1AD"}="H153 1AD"; $resn_exch{"1H16 1AD"}="H161 1AD";
$resn_exch{"2H16 1AD"}="H162 1AD"; $resn_exch{"1H17 1AD"}="H171 1AD"; $resn_exch{"2H17 1AD"}="H172 1AD";
$resn_exch{"1H18 1AD"}="H181 1AD"; $resn_exch{"2H18 1AD"}="H182 1AD"; $resn_exch{"1H19 1AD"}="H191 1AD";
$resn_exch{"2H19 1AD"}="H192 1AD"; $resn_exch{"1H1  1AE"}=" H11 1AE"; $resn_exch{"2H1  1AE"}=" H12 1AE";
$resn_exch{"3H1  1AE"}=" H13 1AE"; $resn_exch{"1H2  1AE"}=" H21 1AE"; $resn_exch{"2H2  1AE"}=" H22 1AE";
$resn_exch{"1H3  1AE"}=" H31 1AE"; $resn_exch{"2H3  1AE"}=" H32 1AE"; $resn_exch{"2H6  1AE"}=" H62 1AE";
$resn_exch{"1H4  1AF"}=" H41 1AF"; $resn_exch{"2H4  1AF"}=" H42 1AF"; $resn_exch{"3H4  1AF"}=" H43 1AF";
$resn_exch{"1H5  1AF"}=" H51 1AF"; $resn_exch{"2H5  1AF"}=" H52 1AF"; $resn_exch{"3H5  1AF"}=" H53 1AF";
$resn_exch{"1H6  1AF"}=" H61 1AF"; $resn_exch{"2H6  1AF"}=" H62 1AF"; $resn_exch{"3H6  1AF"}=" H63 1AF";
$resn_exch{"1H32 1AH"}="H321 1AH"; $resn_exch{"2H32 1AH"}="H322 1AH"; $resn_exch{"1H7C 1AH"}="H7C1 1AH";
$resn_exch{"2H7C 1AH"}="H7C2 1AH"; $resn_exch{"3H7C 1AH"}="H7C3 1AH"; $resn_exch{"1H4C 1AH"}="H4C1 1AH";
$resn_exch{"2H4C 1AH"}="H4C2 1AH"; $resn_exch{"1H22 1AH"}="H221 1AH"; $resn_exch{"2H22 1AH"}="H222 1AH";
$resn_exch{"1H58 1AH"}="H581 1AH"; $resn_exch{"2H58 1AH"}="H582 1AH"; $resn_exch{"1H43 1AH"}="H431 1AH";
$resn_exch{"2H43 1AH"}="H432 1AH"; $resn_exch{"3H43 1AH"}="H433 1AH"; $resn_exch{"1H44 1AH"}="H441 1AH";
$resn_exch{"2H44 1AH"}="H442 1AH"; $resn_exch{"3H44 1AH"}="H443 1AH"; $resn_exch{"1H86 1AH"}="H861 1AH";
$resn_exch{"2H86 1AH"}="H862 1AH"; $resn_exch{"3H86 1AH"}="H863 1AH"; $resn_exch{"1HN3 1AL"}="HN31 1AL";
$resn_exch{"2HN3 1AL"}="HN32 1AL"; $resn_exch{"1H11 1AL"}="H111 1AL"; $resn_exch{"2H11 1AL"}="H112 1AL";
$resn_exch{"1HN  1AN"}=" HN1 1AN"; $resn_exch{"2HN  1AN"}=" HN2 1AN"; $resn_exch{"1H8  1AP"}=" H81 1AP";
$resn_exch{"1HN2 1AP"}="HN21 1AP"; $resn_exch{"2HN2 1AP"}="HN22 1AP"; $resn_exch{"1HN6 1AP"}="HN61 1AP";
$resn_exch{"2HN6 1AP"}="HN62 1AP"; $resn_exch{"2H5  1AP"}=" H52 1AP"; $resn_exch{"1H5  1AP"}=" H51 1AP";
$resn_exch{"1H1  1AP"}=" H11 1AP"; $resn_exch{"1H2  1AP"}=" H21 1AP"; $resn_exch{"2H2  1AP"}=" H22 1AP";
$resn_exch{"1H3  1AP"}=" H31 1AP"; $resn_exch{"1HO3 1AP"}="HO31 1AP"; $resn_exch{"1H2  1AR"}=" H21 1AR";
$resn_exch{"2H2  1AR"}=" H22 1AR"; $resn_exch{"1H6  1AR"}=" H61 1AR"; $resn_exch{"2H6  1AR"}=" H62 1AR";
$resn_exch{"3H6  1AR"}=" H63 1AR"; $resn_exch{"1H8  1BA"}=" H81 1BA"; $resn_exch{"2H8  1BA"}=" H82 1BA";
$resn_exch{"1H1  1BA"}="H11A 1BA"; $resn_exch{"2H1  1BA"}="H12A 1BA"; $resn_exch{"3H1  1BA"}=" H13 1BA";
$resn_exch{"1H3  1BA"}=" H31 1BA"; $resn_exch{"2H3  1BA"}=" H32 1BA"; $resn_exch{"3H3  1BA"}=" H33 1BA";
$resn_exch{"1H1  1BH"}=" H11 1BH"; $resn_exch{"2H1  1BH"}=" H12 1BH"; $resn_exch{"1H41 1BH"}="H411 1BH";
$resn_exch{"2H41 1BH"}="H412 1BH"; $resn_exch{"3H41 1BH"}="H413 1BH"; $resn_exch{"1HD  1BH"}=" HD1 1BH";
$resn_exch{"2HD  1BH"}=" HD2 1BH"; $resn_exch{"1H61 1BH"}="H611 1BH"; $resn_exch{"2H61 1BH"}="H612 1BH";
$resn_exch{"1HG  1BH"}=" HG1 1BH"; $resn_exch{"2HG  1BH"}=" HG2 1BH"; $resn_exch{"1H81 1BH"}="H811 1BH";
$resn_exch{"2H81 1BH"}="H812 1BH"; $resn_exch{"1HC  1BH"}=" HC1 1BH"; $resn_exch{"2HC  1BH"}=" HC2 1BH";
$resn_exch{"3HC  1BH"}=" HC3 1BH"; $resn_exch{"1H19 1BM"}="H191 1BM"; $resn_exch{"2H19 1BM"}="H192 1BM";
$resn_exch{"3H19 1BM"}="H193 1BM"; $resn_exch{"1H27 1BM"}="H271 1BM"; $resn_exch{"2H27 1BM"}="H272 1BM";
$resn_exch{"1H30 1BM"}="H301 1BM"; $resn_exch{"2H30 1BM"}="H302 1BM"; $resn_exch{"1H36 1BM"}="H361 1BM";
$resn_exch{"2H36 1BM"}="H362 1BM"; $resn_exch{"1H42 1BM"}="H421 1BM"; $resn_exch{"2H42 1BM"}="H422 1BM";
$resn_exch{"3H42 1BM"}="H423 1BM"; $resn_exch{"1H35 1BM"}="H351 1BM"; $resn_exch{"2H35 1BM"}="H352 1BM";
$resn_exch{"1H38 1BM"}="H381 1BM"; $resn_exch{"2H38 1BM"}="H382 1BM"; $resn_exch{"3H38 1BM"}="H383 1BM";
$resn_exch{"1H4  1BN"}=" H41 1BN"; $resn_exch{"2H4  1BN"}=" H42 1BN"; $resn_exch{"1H1  1BO"}=" H11 1BO";
$resn_exch{"2H1  1BO"}=" H12 1BO"; $resn_exch{"3H1  1BO"}=" H13 1BO"; $resn_exch{"1H2  1BO"}=" H21 1BO";
$resn_exch{"2H2  1BO"}=" H22 1BO"; $resn_exch{"1H3  1BO"}=" H31 1BO"; $resn_exch{"2H3  1BO"}=" H32 1BO";
$resn_exch{"1H4  1BO"}=" H41 1BO"; $resn_exch{"2H4  1BO"}=" H42 1BO"; $resn_exch{"1H1  1BP"}=" H11 1BP";
$resn_exch{"2H1  1BP"}=" H12 1BP"; $resn_exch{"1H2  1BP"}=" H21 1BP"; $resn_exch{"1H3  1BP"}=" H31 1BP";
$resn_exch{"2H3  1BP"}=" H32 1BP"; $resn_exch{"3H3  1BP"}=" H33 1BP"; $resn_exch{"1HO2 1BP"}="HO21 1BP";
$resn_exch{"1H2  1BY"}=" H21 1BY"; $resn_exch{"2H2  1BY"}=" H22 1BY"; $resn_exch{"1H12 1C2"}="H121 1C2";
$resn_exch{"2H12 1C2"}="H122 1C2"; $resn_exch{"1H11 1C2"}="H111 1C2"; $resn_exch{"2H11 1C2"}="H112 1C2";
$resn_exch{"3H11 1C2"}="H113 1C2"; $resn_exch{"1H10 1C2"}="H101 1C2"; $resn_exch{"2H10 1C2"}="H102 1C2";
$resn_exch{"3H10 1C2"}="H103 1C2"; $resn_exch{"1H9  1C2"}=" H91 1C2"; $resn_exch{"2H9  1C2"}=" H92 1C2";
$resn_exch{"3H9  1C2"}=" H93 1C2"; $resn_exch{"1H6  1C2"}=" H61 1C2"; $resn_exch{"2H6  1C2"}=" H62 1C2";
$resn_exch{"3H6  1C2"}=" H63 1C2"; $resn_exch{"1H3  1C2"}=" H31 1C2"; $resn_exch{"2H3  1C2"}=" H32 1C2";
$resn_exch{"1H1  1C5"}=" H11 1C5"; $resn_exch{"2H1  1C5"}="H12A 1C5"; $resn_exch{"1H2  1C5"}="H21A 1C5";
$resn_exch{"2H2  1C5"}=" H22 1C5"; $resn_exch{"1H3  1C5"}=" H31 1C5"; $resn_exch{"2H3  1C5"}=" H32 1C5";
$resn_exch{"1H5  1C5"}=" H51 1C5"; $resn_exch{"2H5  1C5"}=" H52 1C5"; $resn_exch{"1H6  1C5"}=" H61 1C5";
$resn_exch{"2H6  1C5"}=" H62 1C5"; $resn_exch{"1H7  1C5"}=" H71 1C5"; $resn_exch{"2H7  1C5"}=" H72 1C5";
$resn_exch{"1H8  1C5"}=" H81 1C5"; $resn_exch{"2H8  1C5"}=" H82 1C5"; $resn_exch{"1H13 1C5"}="H131 1C5";
$resn_exch{"2H13 1C5"}="H132 1C5"; $resn_exch{"1H14 1C5"}="H141 1C5"; $resn_exch{"2H14 1C5"}="H142 1C5";
$resn_exch{"1H18 1C5"}="H181 1C5"; $resn_exch{"2H18 1C5"}="H182 1C5"; $resn_exch{"1H26 1C5"}="H261 1C5";
$resn_exch{"2H26 1C5"}="H262 1C5"; $resn_exch{"3H26 1C5"}="H263 1C5"; $resn_exch{"1HN1 1C5"}="HN11 1C5";
$resn_exch{"2HN1 1C5"}="HN12 1C5"; $resn_exch{"2HOP 1C5"}="HOP2 1C5"; $resn_exch{"3HOP 1C5"}="HOP3 1C5";
$resn_exch{"1H1  1CA"}=" H11 1CA"; $resn_exch{"2H1  1CA"}=" H12 1CA"; $resn_exch{"1H2  1CA"}=" H21 1CA";
$resn_exch{"2H2  1CA"}=" H22 1CA"; $resn_exch{"1H6  1CA"}=" H61 1CA"; $resn_exch{"2H6  1CA"}=" H62 1CA";
$resn_exch{"1H7  1CA"}=" H71 1CA"; $resn_exch{"2H7  1CA"}=" H72 1CA"; $resn_exch{"1H11 1CA"}="H111 1CA";
$resn_exch{"2H11 1CA"}="H112 1CA"; $resn_exch{"1H12 1CA"}="H121 1CA"; $resn_exch{"2H12 1CA"}="H122 1CA";
$resn_exch{"1H15 1CA"}="H151 1CA"; $resn_exch{"2H15 1CA"}="H152 1CA"; $resn_exch{"1H16 1CA"}="H161 1CA";
$resn_exch{"2H16 1CA"}="H162 1CA"; $resn_exch{"1H18 1CA"}="H181 1CA"; $resn_exch{"2H18 1CA"}="H182 1CA";
$resn_exch{"3H18 1CA"}="H183 1CA"; $resn_exch{"1H19 1CA"}="H191 1CA"; $resn_exch{"2H19 1CA"}="H192 1CA";
$resn_exch{"3H19 1CA"}="H193 1CA"; $resn_exch{"1H21 1CA"}="H211 1CA"; $resn_exch{"2H21 1CA"}="H212 1CA";
$resn_exch{"1H2  1CB"}=" H21 1CB"; $resn_exch{"2H2  1CB"}=" H22 1CB"; $resn_exch{"1H4  1CB"}=" H41 1CB";
$resn_exch{"2H4  1CB"}=" H42 1CB"; $resn_exch{"1H5  1CB"}=" H51 1CB"; $resn_exch{"2H5  1CB"}=" H52 1CB";
$resn_exch{"1H3  1CB"}=" H31 1CB"; $resn_exch{"2H3  1CB"}=" H32 1CB"; $resn_exch{"1HN2 1CB"}="HN21 1CB";
$resn_exch{"2HN2 1CB"}="HN22 1CB"; $resn_exch{"1H1  1CD"}="H11A 1CD"; $resn_exch{"2H1  1CD"}=" H12 1CD";
$resn_exch{"3H1  1CD"}="H13A 1CD"; $resn_exch{"1H3  1CD"}=" H31 1CD"; $resn_exch{"2H3  1CD"}=" H32 1CD";
$resn_exch{"1H5  1CD"}=" H51 1CD"; $resn_exch{"2H5  1CD"}=" H52 1CD"; $resn_exch{"1H28 1CD"}="H281 1CD";
$resn_exch{"2H28 1CD"}="H282 1CD"; $resn_exch{"1H30 1CD"}="H301 1CD"; $resn_exch{"2H30 1CD"}="H302 1CD";
$resn_exch{"1H36 1CM"}="H361 1CM"; $resn_exch{"2H36 1CM"}="H362 1CM"; $resn_exch{"1H35 1CM"}="H351 1CM";
$resn_exch{"2H35 1CM"}="H352 1CM"; $resn_exch{"3H35 1CM"}="H353 1CM"; $resn_exch{"1HN1 1CN"}="HN11 1CN";
$resn_exch{"2HN1 1CN"}="HN12 1CN"; $resn_exch{"1HN5 1CN"}="HN51 1CN"; $resn_exch{"2HN5 1CN"}="HN52 1CN";
$resn_exch{"1H42 1CP"}="H421 1CP"; $resn_exch{"2H42 1CP"}="H422 1CP"; $resn_exch{"1H41 1CP"}="H411 1CP";
$resn_exch{"2H41 1CP"}="H412 1CP"; $resn_exch{"1H7A 1CP"}="H7A1 1CP"; $resn_exch{"2H7A 1CP"}="H7A2 1CP";
$resn_exch{"3H7A 1CP"}="H7A3 1CP"; $resn_exch{"1H10 1CP"}="H101 1CP"; $resn_exch{"2H10 1CP"}="H102 1CP";
$resn_exch{"1H5  1CP"}=" H51 1CP"; $resn_exch{"2H5  1CP"}=" H52 1CP"; $resn_exch{"1H31 1CP"}="H311 1CP";
$resn_exch{"2H31 1CP"}="H312 1CP"; $resn_exch{"1H32 1CP"}="H321 1CP"; $resn_exch{"2H32 1CP"}="H322 1CP";
$resn_exch{"1H2A 1CP"}="H2A1 1CP"; $resn_exch{"2H2A 1CP"}="H2A2 1CP"; $resn_exch{"3H2A 1CP"}="H2A3 1CP";
$resn_exch{"1H20 1CP"}="H201 1CP"; $resn_exch{"2H20 1CP"}="H202 1CP"; $resn_exch{"1H61 1CP"}="H611 1CP";
$resn_exch{"2H61 1CP"}="H612 1CP"; $resn_exch{"1H62 1CP"}="H621 1CP"; $resn_exch{"2H62 1CP"}="H622 1CP";
$resn_exch{"1H86 1CP"}="H861 1CP"; $resn_exch{"2H86 1CP"}="H862 1CP"; $resn_exch{"3H86 1CP"}="H863 1CP";
$resn_exch{"1H15 1CP"}="H151 1CP"; $resn_exch{"2H15 1CP"}="H152 1CP"; $resn_exch{"1H81 1CP"}="H811 1CP";
$resn_exch{"2H81 1CP"}="H812 1CP"; $resn_exch{"3H81 1CP"}="H813 1CP"; $resn_exch{"1H91 1CP"}="H911 1CP";
$resn_exch{"2H91 1CP"}="H912 1CP"; $resn_exch{"1H92 1CP"}="H921 1CP"; $resn_exch{"2H92 1CP"}="H922 1CP";
$resn_exch{"1H5' 1CS"}="H5'1 1CS"; $resn_exch{"2H5' 1CS"}="H5'2 1CS"; $resn_exch{"3H5' 1CS"}="H5'3 1CS";
$resn_exch{"1H7' 1CS"}="H7'1 1CS"; $resn_exch{"2H7' 1CS"}="H7'2 1CS"; $resn_exch{"3H7' 1CS"}="H7'3 1CS";
$resn_exch{"1HO1 1CU"}="HO11 1CU"; $resn_exch{"2HO1 1CU"}="HO12 1CU"; $resn_exch{"*HO5 1DA"}="HO5' 1DA";
$resn_exch{"1H5* 1DA"}="H5'1 1DA"; $resn_exch{"2H5* 1DA"}="H5'2 1DA"; $resn_exch{" H4* 1DA"}=" H4' 1DA";
$resn_exch{" H3* 1DA"}=" H3' 1DA"; $resn_exch{"*HO3 1DA"}="HO3' 1DA"; $resn_exch{" H2* 1DA"}=" H2' 1DA";
$resn_exch{"*HO2 1DA"}="HO2' 1DA"; $resn_exch{" H1* 1DA"}=" H1' 1DA"; $resn_exch{"1HN6 1DA"}="HN61 1DA";
$resn_exch{"2HN6 1DA"}="HN62 1DA"; $resn_exch{"1H1C 1DB"}="H1C1 1DB"; $resn_exch{"2H1C 1DB"}="H1C2 1DB";
$resn_exch{"1H2C 1DB"}="H2C1 1DB"; $resn_exch{"2H2C 1DB"}="H2C2 1DB"; $resn_exch{"1H3C 1DB"}="H3C1 1DB";
$resn_exch{"2H3C 1DB"}="H3C2 1DB"; $resn_exch{"1H4C 1DB"}="H4C1 1DB"; $resn_exch{"2H4C 1DB"}="H4C2 1DB";
$resn_exch{"1H5C 1DB"}="H5C1 1DB"; $resn_exch{"2H5C 1DB"}="H5C2 1DB"; $resn_exch{"1H6C 1DB"}="H6C1 1DB";
$resn_exch{"2H6C 1DB"}="H6C2 1DB"; $resn_exch{"1H7C 1DB"}="H7C1 1DB"; $resn_exch{"2H7C 1DB"}="H7C2 1DB";
$resn_exch{"1H8C 1DB"}="H8C1 1DB"; $resn_exch{"2H8C 1DB"}="H8C2 1DB"; $resn_exch{"1H9C 1DB"}="H9C1 1DB";
$resn_exch{"2H9C 1DB"}="H9C2 1DB"; $resn_exch{"1H10 1DB"}="H101 1DB"; $resn_exch{"2H10 1DB"}="H102 1DB";
$resn_exch{"3H10 1DB"}="H103 1DB"; $resn_exch{"1HAA 1DG"}="HAA1 1DG"; $resn_exch{"2HAA 1DG"}="HAA2 1DG";
$resn_exch{" H1* 1DG"}=" H1' 1DG"; $resn_exch{" H2* 1DG"}=" H2' 1DG"; $resn_exch{" H3* 1DG"}=" H3' 1DG";
$resn_exch{" H4* 1DG"}=" H4' 1DG"; $resn_exch{"1H5* 1DG"}="H5'1 1DG"; $resn_exch{"2H5* 1DG"}="H5'2 1DG";
$resn_exch{"1HAY 1DG"}="HAY1 1DG"; $resn_exch{"2HAY 1DG"}="HAY2 1DG"; $resn_exch{"1H6N 1DG"}="H6N1 1DG";
$resn_exch{"2H6N 1DG"}="H6N2 1DG"; $resn_exch{"1H21 1DM"}="H211 1DM"; $resn_exch{"2H21 1DM"}="H212 1DM";
$resn_exch{"1H22 1DM"}="H221 1DM"; $resn_exch{"2H22 1DM"}="H222 1DM"; $resn_exch{"1H23 1DM"}="H231 1DM";
$resn_exch{"2H23 1DM"}="H232 1DM"; $resn_exch{"1H24 1DM"}="H241 1DM"; $resn_exch{"2H24 1DM"}="H242 1DM";
$resn_exch{"1H20 1DM"}="H201 1DM"; $resn_exch{"2H20 1DM"}="H202 1DM"; $resn_exch{"1H30 1DM"}="H301 1DM";
$resn_exch{"2H30 1DM"}="H302 1DM"; $resn_exch{"1H25 1DM"}="H251 1DM"; $resn_exch{"2H25 1DM"}="H252 1DM";
$resn_exch{"1H26 1DM"}="H261 1DM"; $resn_exch{"2H26 1DM"}="H262 1DM"; $resn_exch{"1H27 1DM"}="H271 1DM";
$resn_exch{"2H27 1DM"}="H272 1DM"; $resn_exch{"1H28 1DM"}="H281 1DM"; $resn_exch{"2H28 1DM"}="H282 1DM";
$resn_exch{"1H6  1DM"}=" H61 1DM"; $resn_exch{"2H6  1DM"}=" H62 1DM"; $resn_exch{"1H1C 1DO"}="H1C1 1DO";
$resn_exch{"2H1C 1DO"}="H1C2 1DO"; $resn_exch{"1H2C 1DO"}="H2C1 1DO"; $resn_exch{"2H2C 1DO"}="H2C2 1DO";
$resn_exch{"1H3C 1DO"}="H3C1 1DO"; $resn_exch{"2H3C 1DO"}="H3C2 1DO"; $resn_exch{"1H4C 1DO"}="H4C1 1DO";
$resn_exch{"2H4C 1DO"}="H4C2 1DO"; $resn_exch{"1H5C 1DO"}="H5C1 1DO"; $resn_exch{"2H5C 1DO"}="H5C2 1DO";
$resn_exch{"1H6C 1DO"}="H6C1 1DO"; $resn_exch{"2H6C 1DO"}="H6C2 1DO"; $resn_exch{"1H7C 1DO"}="H7C1 1DO";
$resn_exch{"2H7C 1DO"}="H7C2 1DO"; $resn_exch{"1H8C 1DO"}="H8C1 1DO"; $resn_exch{"2H8C 1DO"}="H8C2 1DO";
$resn_exch{"1H9C 1DO"}="H9C1 1DO"; $resn_exch{"2H9C 1DO"}="H9C2 1DO"; $resn_exch{"1H10 1DO"}="H101 1DO";
$resn_exch{"2H10 1DO"}="H102 1DO"; $resn_exch{"1H11 1DO"}="H111 1DO"; $resn_exch{"2H11 1DO"}="H112 1DO";
$resn_exch{"1H12 1DO"}="H121 1DO"; $resn_exch{"2H12 1DO"}="H122 1DO"; $resn_exch{"3H12 1DO"}="H123 1DO";
$resn_exch{"1H12 1EM"}="H121 1EM"; $resn_exch{"2H12 1EM"}="H122 1EM"; $resn_exch{"1H13 1EM"}="H131 1EM";
$resn_exch{"2H13 1EM"}="H132 1EM"; $resn_exch{"1H14 1EM"}="H141 1EM"; $resn_exch{"2H14 1EM"}="H142 1EM";
$resn_exch{"1H15 1EM"}="H151 1EM"; $resn_exch{"2H15 1EM"}="H152 1EM"; $resn_exch{"1H16 1EM"}="H161 1EM";
$resn_exch{"2H16 1EM"}="H162 1EM"; $resn_exch{"1H17 1EM"}="H171 1EM"; $resn_exch{"2H17 1EM"}="H172 1EM";
$resn_exch{"1H18 1EM"}="H181 1EM"; $resn_exch{"2H18 1EM"}="H182 1EM"; $resn_exch{"1H19 1EM"}="H191 1EM";
$resn_exch{"2H19 1EM"}="H192 1EM"; $resn_exch{"3H19 1EM"}="H193 1EM"; $resn_exch{"1H22 1EM"}="H221 1EM";
$resn_exch{"2H22 1EM"}="H222 1EM"; $resn_exch{"1H23 1EM"}="H231 1EM"; $resn_exch{"2H23 1EM"}="H232 1EM";
$resn_exch{"1H24 1EM"}="H241 1EM"; $resn_exch{"2H24 1EM"}="H242 1EM"; $resn_exch{"1H25 1EM"}="H251 1EM";
$resn_exch{"2H25 1EM"}="H252 1EM"; $resn_exch{"1H26 1EM"}="H261 1EM"; $resn_exch{"2H26 1EM"}="H262 1EM";
$resn_exch{"1H27 1EM"}="H271 1EM"; $resn_exch{"2H27 1EM"}="H272 1EM"; $resn_exch{"1H28 1EM"}="H281 1EM";
$resn_exch{"2H28 1EM"}="H282 1EM"; $resn_exch{"1H29 1EM"}="H291 1EM"; $resn_exch{"2H29 1EM"}="H292 1EM";
$resn_exch{"1H30 1EM"}="H301 1EM"; $resn_exch{"2H30 1EM"}="H302 1EM"; $resn_exch{"1H31 1EM"}="H311 1EM";
$resn_exch{"2H31 1EM"}="H312 1EM"; $resn_exch{"1H32 1EM"}="H321 1EM"; $resn_exch{"2H32 1EM"}="H322 1EM";
$resn_exch{"1H33 1EM"}="H331 1EM"; $resn_exch{"2H33 1EM"}="H332 1EM"; $resn_exch{"1H34 1EM"}="H341 1EM";
$resn_exch{"2H34 1EM"}="H342 1EM"; $resn_exch{"3H34 1EM"}="H343 1EM"; $resn_exch{"1H41 1EM"}="H411 1EM";
$resn_exch{"2H41 1EM"}="H412 1EM"; $resn_exch{"1H43 1EM"}="H431 1EM"; $resn_exch{"2H43 1EM"}="H432 1EM";
$resn_exch{"1HAA 1FH"}="HAA1 1FH"; $resn_exch{"2HAA 1FH"}="HAA2 1FH"; $resn_exch{"1HMA 1FH"}="HMA1 1FH";
$resn_exch{"2HMA 1FH"}="HMA2 1FH"; $resn_exch{"3HMA 1FH"}="HMA3 1FH"; $resn_exch{"1HBA 1FH"}="HBA1 1FH";
$resn_exch{"2HBA 1FH"}="HBA2 1FH"; $resn_exch{"1HMB 1FH"}="HMB1 1FH"; $resn_exch{"2HMB 1FH"}="HMB2 1FH";
$resn_exch{"3HMB 1FH"}="HMB3 1FH"; $resn_exch{"1HBB 1FH"}="HBB1 1FH"; $resn_exch{"2HBB 1FH"}="HBB2 1FH";
$resn_exch{"1HMC 1FH"}="HMC1 1FH"; $resn_exch{"2HMC 1FH"}="HMC2 1FH"; $resn_exch{"3HMC 1FH"}="HMC3 1FH";
$resn_exch{"1HBC 1FH"}="HBC1 1FH"; $resn_exch{"2HBC 1FH"}="HBC2 1FH"; $resn_exch{"1HMD 1FH"}="HMD1 1FH";
$resn_exch{"2HMD 1FH"}="HMD2 1FH"; $resn_exch{"3HMD 1FH"}="HMD3 1FH"; $resn_exch{"1HAD 1FH"}="HAD1 1FH";
$resn_exch{"2HAD 1FH"}="HAD2 1FH"; $resn_exch{"1HBD 1FH"}="HBD1 1FH"; $resn_exch{"2HBD 1FH"}="HBD2 1FH";
$resn_exch{"1H2  1GL"}=" H21 1GL"; $resn_exch{"2H2  1GL"}=" H22 1GL"; $resn_exch{"1H6  1GL"}=" H61 1GL";
$resn_exch{"2H6  1GL"}=" H62 1GL"; $resn_exch{"3H6  1GL"}=" H63 1GL"; $resn_exch{"1HN2 1GN"}="HN21 1GN";
$resn_exch{"2HN2 1GN"}="HN22 1GN"; $resn_exch{"1H6  1GN"}=" H61 1GN"; $resn_exch{"2H6  1GN"}=" H62 1GN";
$resn_exch{"1H3  1GP"}=" H31 1GP"; $resn_exch{"2H3  1GP"}=" H32 1GP"; $resn_exch{"1H1  1GP"}=" H11 1GP";
$resn_exch{"2H1  1GP"}=" H12 1GP"; $resn_exch{"1HAA 1HP"}="HAA1 1HP"; $resn_exch{"2HAA 1HP"}="HAA2 1HP";
$resn_exch{"3HAA 1HP"}="HAA3 1HP"; $resn_exch{"1HAB 1HP"}="HAB1 1HP"; $resn_exch{"2HAB 1HP"}="HAB2 1HP";
$resn_exch{"1HN3 1IG"}="HN31 1IG"; $resn_exch{"2HN3 1IG"}="HN32 1IG"; $resn_exch{"1HN4 1IG"}="HN41 1IG";
$resn_exch{"2HN4 1IG"}="HN42 1IG"; $resn_exch{"1H5  1IG"}=" H51 1IG"; $resn_exch{"2H5  1IG"}=" H52 1IG";
$resn_exch{"1H6  1IG"}=" H61 1IG"; $resn_exch{"2H6  1IG"}=" H62 1IG"; $resn_exch{"3H6  1IG"}=" H63 1IG";
$resn_exch{"1H16 1IG"}="H161 1IG"; $resn_exch{"2H16 1IG"}="H162 1IG"; $resn_exch{"1H17 1IG"}="H171 1IG";
$resn_exch{"2H17 1IG"}="H172 1IG"; $resn_exch{"1H19 1IG"}="H191 1IG"; $resn_exch{"2H19 1IG"}="H192 1IG";
$resn_exch{"3H19 1IG"}="H193 1IG"; $resn_exch{"1H21 1IG"}="H211 1IG"; $resn_exch{"2H21 1IG"}="H212 1IG";
$resn_exch{"3H21 1IG"}="H213 1IG"; $resn_exch{"1H20 1IG"}="H201 1IG"; $resn_exch{"2H20 1IG"}="H202 1IG";
$resn_exch{"3H20 1IG"}="H203 1IG"; $resn_exch{"1H1  1IN"}="H11A 1IN"; $resn_exch{"2H1  1IN"}=" H12 1IN";
$resn_exch{"1H7  1IN"}=" H71 1IN"; $resn_exch{"2H7  1IN"}=" H72 1IN"; $resn_exch{"3H7  1IN"}=" H73 1IN";
$resn_exch{"1H8  1IN"}=" H81 1IN"; $resn_exch{"2H8  1IN"}=" H82 1IN"; $resn_exch{"1H9  1IN"}=" H91 1IN";
$resn_exch{"2H9  1IN"}=" H92 1IN"; $resn_exch{"1H10 1IN"}="H101 1IN"; $resn_exch{"2H10 1IN"}="H102 1IN";
$resn_exch{"1H12 1IN"}="H121 1IN"; $resn_exch{"2H12 1IN"}="H122 1IN"; $resn_exch{"1H14 1IN"}="H141 1IN";
$resn_exch{"2H14 1IN"}="H142 1IN"; $resn_exch{"1H24 1IN"}="H241 1IN"; $resn_exch{"2H24 1IN"}="H242 1IN";
$resn_exch{"1H27 1IN"}="H271 1IN"; $resn_exch{"2H27 1IN"}="H272 1IN"; $resn_exch{"1H5  1IN"}=" H51 1IN";
$resn_exch{"2H5  1IN"}=" H52 1IN"; $resn_exch{"3H5  1IN"}=" H53 1IN"; $resn_exch{"1H6  1IN"}=" H61 1IN";
$resn_exch{"2H6  1IN"}=" H62 1IN"; $resn_exch{"3H6  1IN"}=" H63 1IN"; $resn_exch{"1H25 1IN"}="H251 1IN";
$resn_exch{"2H25 1IN"}="H252 1IN"; $resn_exch{"1H29 1IN"}="H291 1IN"; $resn_exch{"2H29 1IN"}="H292 1IN";
$resn_exch{"3H29 1IN"}="H293 1IN"; $resn_exch{"1H26 1IN"}="H261 1IN"; $resn_exch{"2H26 1IN"}="H262 1IN";
$resn_exch{"1HAJ 1IP"}="HAJ1 1IP"; $resn_exch{"2HAJ 1IP"}="HAJ2 1IP"; $resn_exch{"1HB  1IP"}=" HB1 1IP";
$resn_exch{"2HB  1IP"}=" HB2 1IP"; $resn_exch{"1HD2 1IP"}="HD21 1IP"; $resn_exch{"2HD2 1IP"}="HD22 1IP";
$resn_exch{"1H7  1IQ"}=" H71 1IQ"; $resn_exch{"2H7  1IQ"}=" H72 1IQ"; $resn_exch{"3H7  1IQ"}=" H73 1IQ";
$resn_exch{"1H10 1IQ"}="H101 1IQ"; $resn_exch{"2H10 1IQ"}="H102 1IQ"; $resn_exch{"3H10 1IQ"}="H103 1IQ";
$resn_exch{"1H9  1IQ"}=" H91 1IQ"; $resn_exch{"2H9  1IQ"}=" H92 1IQ"; $resn_exch{"3H9  1IQ"}=" H93 1IQ";
$resn_exch{"1H4  1LG"}=" H41 1LG"; $resn_exch{"2H4  1LG"}=" H42 1LG"; $resn_exch{"1H8  1LG"}=" H81 1LG";
$resn_exch{"2H8  1LG"}=" H82 1LG"; $resn_exch{"1H28 1LG"}="H281 1LG"; $resn_exch{"2H28 1LG"}="H282 1LG";
$resn_exch{"1H9  1LG"}=" H91 1LG"; $resn_exch{"2H9  1LG"}=" H92 1LG"; $resn_exch{"1H12 1LG"}="H121 1LG";
$resn_exch{"2H12 1LG"}="H122 1LG"; $resn_exch{"1H27 1LG"}="H271 1LG"; $resn_exch{"2H27 1LG"}="H272 1LG";
$resn_exch{"1H29 1LG"}="H291 1LG"; $resn_exch{"2H29 1LG"}="H292 1LG"; $resn_exch{"1H30 1LG"}="H301 1LG";
$resn_exch{"2H30 1LG"}="H302 1LG"; $resn_exch{"1H1C 1LP"}="H1C1 1LP"; $resn_exch{"1H3C 1LP"}="H3C1 1LP";
$resn_exch{"2H3C 1LP"}="H3C2 1LP"; $resn_exch{"3H3C 1LP"}="H3C3 1LP"; $resn_exch{"1HB  1LU"}=" HB1 1LU";
$resn_exch{"2HB  1LU"}=" HB2 1LU"; $resn_exch{"1HD1 1LU"}="HD11 1LU"; $resn_exch{"2HD1 1LU"}="HD12 1LU";
$resn_exch{"3HD1 1LU"}="HD13 1LU"; $resn_exch{"1HD2 1LU"}="HD21 1LU"; $resn_exch{"2HD2 1LU"}="HD22 1LU";
$resn_exch{"3HD2 1LU"}="HD23 1LU"; $resn_exch{"2HOP 1MA"}="HOP2 1MA"; $resn_exch{"3HOP 1MA"}="HOP3 1MA";
$resn_exch{"1H5* 1MA"}=" H5' 1MA"; $resn_exch{"2H5* 1MA"}="H5'' 1MA"; $resn_exch{" H4* 1MA"}=" H4' 1MA";
$resn_exch{" H3* 1MA"}=" H3' 1MA"; $resn_exch{"*HO3 1MA"}="HO3' 1MA"; $resn_exch{" H2* 1MA"}=" H2' 1MA";
$resn_exch{"*HO2 1MA"}="HO2' 1MA"; $resn_exch{" H1* 1MA"}=" H1' 1MA"; $resn_exch{"1HN6 1MA"}="HN61 1MA";
$resn_exch{"2HN6 1MA"}="HN62 1MA"; $resn_exch{"1HM1 1MA"}="HM11 1MA"; $resn_exch{"2HM1 1MA"}="HM12 1MA";
$resn_exch{"3HM1 1MA"}="HM13 1MA"; $resn_exch{"1H1  1MC"}=" H11 1MC"; $resn_exch{"2H1  1MC"}=" H12 1MC";
$resn_exch{"3H1  1MC"}=" H13 1MC"; $resn_exch{"1HN4 1MC"}="HN41 1MC"; $resn_exch{"2HN4 1MC"}="HN42 1MC";
$resn_exch{"2HOP 1MG"}="HOP2 1MG"; $resn_exch{"3HOP 1MG"}="HOP3 1MG"; $resn_exch{"1H5* 1MG"}=" H5' 1MG";
$resn_exch{"2H5* 1MG"}="H5'' 1MG"; $resn_exch{" H4* 1MG"}=" H4' 1MG"; $resn_exch{" H3* 1MG"}=" H3' 1MG";
$resn_exch{"*HO3 1MG"}="HO3' 1MG"; $resn_exch{" H2* 1MG"}=" H2' 1MG"; $resn_exch{"*HO2 1MG"}="HO2' 1MG";
$resn_exch{" H1* 1MG"}=" H1' 1MG"; $resn_exch{"1HM1 1MG"}="HM11 1MG"; $resn_exch{"2HM1 1MG"}="HM12 1MG";
$resn_exch{"3HM1 1MG"}="HM13 1MG"; $resn_exch{"1HN2 1MG"}="HN21 1MG"; $resn_exch{"2HN2 1MG"}="HN22 1MG";
$resn_exch{"1H13 1MM"}="H131 1MM"; $resn_exch{"2H13 1MM"}="H132 1MM"; $resn_exch{"3H13 1MM"}="H133 1MM";
$resn_exch{"1H5' 1MM"}="H5'1 1MM"; $resn_exch{"2H5' 1MM"}="H5'2 1MM"; $resn_exch{"3H5' 1MM"}="H5'3 1MM";
$resn_exch{"1H7' 1MM"}="H7'1 1MM"; $resn_exch{"2H7' 1MM"}="H7'2 1MM"; $resn_exch{"3H7' 1MM"}="H7'3 1MM";
$resn_exch{"1HAA 1MR"}="HAA1 1MR"; $resn_exch{"2HAA 1MR"}="HAA2 1MR"; $resn_exch{"3HAA 1MR"}="HAA3 1MR";
$resn_exch{"1HM1 1MZ"}="HM11 1MZ"; $resn_exch{"2HM1 1MZ"}="HM12 1MZ"; $resn_exch{"3HM1 1MZ"}="HM13 1MZ";
$resn_exch{"1H10 1N1"}="H101 1N1"; $resn_exch{"2H10 1N1"}="H102 1N1"; $resn_exch{"3H10 1N1"}="H103 1N1";
$resn_exch{"1H15 1N1"}="H151 1N1"; $resn_exch{"2H15 1N1"}="H152 1N1"; $resn_exch{"3H15 1N1"}="H153 1N1";
$resn_exch{"1H16 1N1"}="H161 1N1"; $resn_exch{"2H16 1N1"}="H162 1N1"; $resn_exch{"1H19 1N1"}="H191 1N1";
$resn_exch{"2H19 1N1"}="H192 1N1"; $resn_exch{"1H20 1N1"}="H201 1N1"; $resn_exch{"2H20 1N1"}="H202 1N1";
$resn_exch{"1H21 1N1"}="H211 1N1"; $resn_exch{"2H21 1N1"}="H212 1N1"; $resn_exch{"1H17 1N1"}="H171 1N1";
$resn_exch{"2H17 1N1"}="H172 1N1"; $resn_exch{"1H18 1N1"}="H181 1N1"; $resn_exch{"2H18 1N1"}="H182 1N1";
$resn_exch{"1H25 1N8"}="H251 1N8"; $resn_exch{"2H25 1N8"}="H252 1N8"; $resn_exch{"3H25 1N8"}="H253 1N8";
$resn_exch{"1H27 1N8"}="H271 1N8"; $resn_exch{"2H27 1N8"}="H272 1N8"; $resn_exch{"1H28 1N8"}="H281 1N8";
$resn_exch{"2H28 1N8"}="H282 1N8"; $resn_exch{"1H29 1N8"}="H291 1N8"; $resn_exch{"2H29 1N8"}="H292 1N8";
$resn_exch{"1H30 1N8"}="H301 1N8"; $resn_exch{"2H30 1N8"}="H302 1N8"; $resn_exch{"3H30 1N8"}="H303 1N8";
$resn_exch{"1H5  1N8"}=" H51 1N8"; $resn_exch{"2H5  1N8"}=" H52 1N8"; $resn_exch{"3H5  1N8"}=" H53 1N8";
$resn_exch{"1H1  1N8"}=" H11 1N8"; $resn_exch{"2H1  1N8"}="H12A 1N8"; $resn_exch{"3H1  1N8"}=" H13 1N8";
$resn_exch{"1H31 1N9"}="H311 1N9"; $resn_exch{"2H31 1N9"}="H312 1N9"; $resn_exch{"3H31 1N9"}="H313 1N9";
$resn_exch{"1H32 1N9"}="H321 1N9"; $resn_exch{"2H32 1N9"}="H322 1N9"; $resn_exch{"3H32 1N9"}="H323 1N9";
$resn_exch{"1H33 1N9"}="H331 1N9"; $resn_exch{"2H33 1N9"}="H332 1N9"; $resn_exch{"3H33 1N9"}="H333 1N9";
$resn_exch{"1H36 1N9"}="H361 1N9"; $resn_exch{"2H36 1N9"}="H362 1N9"; $resn_exch{"3H36 1N9"}="H363 1N9";
$resn_exch{"1H37 1N9"}="H371 1N9"; $resn_exch{"2H37 1N9"}="H372 1N9"; $resn_exch{"3H37 1N9"}="H373 1N9";
$resn_exch{"1H7  1N9"}=" H71 1N9"; $resn_exch{"2H7  1N9"}=" H72 1N9"; $resn_exch{"1H8  1N9"}=" H81 1N9";
$resn_exch{"2H8  1N9"}=" H82 1N9"; $resn_exch{"1H35 1N9"}="H351 1N9"; $resn_exch{"2H35 1N9"}="H352 1N9";
$resn_exch{"1H34 1N9"}="H341 1N9"; $resn_exch{"2H34 1N9"}="H342 1N9"; $resn_exch{"3H34 1N9"}="H343 1N9";
$resn_exch{"1H1  1N9"}=" H11 1N9"; $resn_exch{"2H1  1N9"}=" H12 1N9"; $resn_exch{"1H3  1N9"}=" H31 1N9";
$resn_exch{"2H3  1N9"}=" H32 1N9"; $resn_exch{"1H4  1N9"}=" H41 1N9"; $resn_exch{"2H4  1N9"}=" H42 1N9";
$resn_exch{"1H6  1N9"}=" H61 1N9"; $resn_exch{"2H6  1N9"}=" H62 1N9"; $resn_exch{"1H2  1N9"}=" H21 1N9";
$resn_exch{"2H2  1N9"}=" H22 1N9"; $resn_exch{"3H2  1N9"}=" H23 1N9"; $resn_exch{"1H6  1NA"}=" H61 1NA";
$resn_exch{"2H6  1NA"}=" H62 1NA"; $resn_exch{"1H8  1NA"}=" H81 1NA"; $resn_exch{"2H8  1NA"}=" H82 1NA";
$resn_exch{"3H8  1NA"}=" H83 1NA"; $resn_exch{"1HM  1NA"}=" HM1 1NA"; $resn_exch{"2HM  1NA"}=" HM2 1NA";
$resn_exch{"3HM  1NA"}=" HM3 1NA"; $resn_exch{"1H9  1NB"}=" H91 1NB"; $resn_exch{"2H9  1NB"}=" H92 1NB";
$resn_exch{"1H26 1NB"}="H261 1NB"; $resn_exch{"2H26 1NB"}="H262 1NB"; $resn_exch{"1H27 1NB"}="H271 1NB";
$resn_exch{"2H27 1NB"}="H272 1NB"; $resn_exch{"1H28 1NB"}="H281 1NB"; $resn_exch{"2H28 1NB"}="H282 1NB";
$resn_exch{"1H19 1NB"}="H191 1NB"; $resn_exch{"2H19 1NB"}="H192 1NB"; $resn_exch{"1H4  1NH"}=" H41 1NH";
$resn_exch{"2H4  1NH"}=" H42 1NH"; $resn_exch{"3H4  1NH"}=" H43 1NH"; $resn_exch{"1H3  1NH"}=" H31 1NH";
$resn_exch{"2H3  1NH"}=" H32 1NH"; $resn_exch{"1H5  1NH"}=" H51 1NH"; $resn_exch{"2H5  1NH"}=" H52 1NH";
$resn_exch{"1H8  1NH"}=" H81 1NH"; $resn_exch{"2H8  1NH"}=" H82 1NH"; $resn_exch{"3H8  1NH"}=" H83 1NH";
$resn_exch{"1H9  1NH"}=" H91 1NH"; $resn_exch{"2H9  1NH"}=" H92 1NH"; $resn_exch{"1H11 1NH"}="H111 1NH";
$resn_exch{"2H11 1NH"}="H112 1NH"; $resn_exch{"1H10 1NH"}="H101 1NH"; $resn_exch{"2H10 1NH"}="H102 1NH";
$resn_exch{"1H1  1NI"}=" H11 1NI"; $resn_exch{"2H1  1NI"}=" H12 1NI"; $resn_exch{"3H1  1NI"}="H13A 1NI";
$resn_exch{"1H24 1NI"}="H241 1NI"; $resn_exch{"2H24 1NI"}="H242 1NI"; $resn_exch{"3H24 1NI"}="H243 1NI";
$resn_exch{"1H30 1NI"}="H301 1NI"; $resn_exch{"2H30 1NI"}="H302 1NI"; $resn_exch{"3H30 1NI"}="H303 1NI";
$resn_exch{"1H31 1NI"}="H311 1NI"; $resn_exch{"2H31 1NI"}="H312 1NI"; $resn_exch{"3H31 1NI"}="H313 1NI";
$resn_exch{"1H33 1NI"}="H331 1NI"; $resn_exch{"2H33 1NI"}="H332 1NI"; $resn_exch{"1H6  1NI"}=" H61 1NI";
$resn_exch{"2H6  1NI"}=" H62 1NI"; $resn_exch{"1H25 1NI"}="H251 1NI"; $resn_exch{"2H25 1NI"}="H252 1NI";
$resn_exch{"3H25 1NI"}="H253 1NI"; $resn_exch{"1H28 1NI"}="H281 1NI"; $resn_exch{"2H28 1NI"}="H282 1NI";
$resn_exch{"1H39 1NI"}="H391 1NI"; $resn_exch{"2H39 1NI"}="H392 1NI"; $resn_exch{"1H40 1NI"}="H401 1NI";
$resn_exch{"2H40 1NI"}="H402 1NI"; $resn_exch{"3H40 1NI"}="H403 1NI"; $resn_exch{"1H45 1NI"}="H451 1NI";
$resn_exch{"2H45 1NI"}="H452 1NI"; $resn_exch{"1HN  1NI"}=" HN1 1NI"; $resn_exch{"2HN  1NI"}=" HN2 1NI";
$resn_exch{"1HI3 1NT"}="HI31 1NT"; $resn_exch{"2HI3 1NT"}="HI32 1NT"; $resn_exch{"1HA5 1NT"}="HA51 1NT";
$resn_exch{"2HA5 1NT"}="HA52 1NT"; $resn_exch{"1H2C 1P3"}="H2C1 1P3"; $resn_exch{"2H2C 1P3"}="H2C2 1P3";
$resn_exch{"3H2C 1P3"}="H2C3 1P3"; $resn_exch{"1H20 1P3"}="H201 1P3"; $resn_exch{"2H20 1P3"}="H202 1P3";
$resn_exch{"1H4C 1P3"}="H4C1 1P3"; $resn_exch{"2H4C 1P3"}="H4C2 1P3"; $resn_exch{"1H5C 1P3"}="H5C1 1P3";
$resn_exch{"2H5C 1P3"}="H5C2 1P3"; $resn_exch{"1H6C 1P3"}="H6C1 1P3"; $resn_exch{"2H6C 1P3"}="H6C2 1P3";
$resn_exch{"1H7C 1P3"}="H7C1 1P3"; $resn_exch{"2H7C 1P3"}="H7C2 1P3"; $resn_exch{"3H7C 1P3"}="H7C3 1P3";
$resn_exch{"1HN  1PA"}=" H   1PA"; $resn_exch{"2HN  1PA"}=" H2  1PA"; $resn_exch{"1HB  1PA"}=" HB2 1PA";
$resn_exch{"2HB  1PA"}=" HB3 1PA"; $resn_exch{"1HH  1PA"}=" HH2 1PA"; $resn_exch{"2HH  1PA"}=" HH3 1PA";
$resn_exch{"1HCC 1PB"}="HCC1 1PB"; $resn_exch{"2HCC 1PB"}="HCC2 1PB"; $resn_exch{"1HDC 1PB"}="HDC1 1PB";
$resn_exch{"2HDC 1PB"}="HDC2 1PB"; $resn_exch{"1HP  1PC"}=" HP1 1PC"; $resn_exch{"2HP  1PC"}=" HP2 1PC";
$resn_exch{"1HH  1PC"}=" HH1 1PC"; $resn_exch{"2HH  1PC"}=" HH2 1PC"; $resn_exch{"1HI  1PC"}=" HI1 1PC";
$resn_exch{"2HI  1PC"}=" HI2 1PC"; $resn_exch{"1HJ  1PC"}=" HJ1 1PC"; $resn_exch{"2HJ  1PC"}=" HJ2 1PC";
$resn_exch{"1HK  1PC"}=" HK1 1PC"; $resn_exch{"2HK  1PC"}=" HK2 1PC"; $resn_exch{"1HL  1PC"}=" HL1 1PC";
$resn_exch{"2HL  1PC"}=" HL2 1PC"; $resn_exch{"1HN  1PC"}=" HN1 1PC"; $resn_exch{"2HN  1PC"}=" HN2 1PC";
$resn_exch{"1HO  1PC"}=" HO1 1PC"; $resn_exch{"2HO  1PC"}=" HO2 1PC"; $resn_exch{"1HQ  1PC"}=" HQ1 1PC";
$resn_exch{"2HQ  1PC"}=" HQ2 1PC"; $resn_exch{"1HR  1PC"}=" HR1 1PC"; $resn_exch{"2HR  1PC"}=" HR2 1PC";
$resn_exch{"1H12 1PE"}="H121 1PE"; $resn_exch{"2H12 1PE"}="H122 1PE"; $resn_exch{"1H22 1PE"}="H221 1PE";
$resn_exch{"2H22 1PE"}="H222 1PE"; $resn_exch{"1H13 1PE"}="H131 1PE"; $resn_exch{"2H13 1PE"}="H132 1PE";
$resn_exch{"1H23 1PE"}="H231 1PE"; $resn_exch{"2H23 1PE"}="H232 1PE"; $resn_exch{"1H14 1PE"}="H141 1PE";
$resn_exch{"2H14 1PE"}="H142 1PE"; $resn_exch{"1H24 1PE"}="H241 1PE"; $resn_exch{"2H24 1PE"}="H242 1PE";
$resn_exch{"1H15 1PE"}="H151 1PE"; $resn_exch{"2H15 1PE"}="H152 1PE"; $resn_exch{"1H25 1PE"}="H251 1PE";
$resn_exch{"2H25 1PE"}="H252 1PE"; $resn_exch{"1H16 1PE"}="H161 1PE"; $resn_exch{"2H16 1PE"}="H162 1PE";
$resn_exch{"1H26 1PE"}="H261 1PE"; $resn_exch{"2H26 1PE"}="H262 1PE"; $resn_exch{"1H2  1PG"}=" H21 1PG";
$resn_exch{"2H2  1PG"}=" H22 1PG"; $resn_exch{"1H1  1PG"}=" H11 1PG"; $resn_exch{"2H1  1PG"}=" H12 1PG";
$resn_exch{"3H1  1PG"}=" H13 1PG"; $resn_exch{"1H3  1PG"}=" H31 1PG"; $resn_exch{"2H3  1PG"}=" H32 1PG";
$resn_exch{"1H4  1PG"}=" H41 1PG"; $resn_exch{"2H4  1PG"}=" H42 1PG"; $resn_exch{"1H5  1PG"}=" H51 1PG";
$resn_exch{"2H5  1PG"}=" H52 1PG"; $resn_exch{"1H6  1PG"}=" H61 1PG"; $resn_exch{"2H6  1PG"}=" H62 1PG";
$resn_exch{"1H7  1PG"}=" H71 1PG"; $resn_exch{"2H7  1PG"}=" H72 1PG"; $resn_exch{"1H8  1PG"}=" H81 1PG";
$resn_exch{"2H8  1PG"}=" H82 1PG"; $resn_exch{"1H9  1PG"}=" H91 1PG"; $resn_exch{"2H9  1PG"}=" H92 1PG";
$resn_exch{"1H10 1PG"}="H101 1PG"; $resn_exch{"2H10 1PG"}="H102 1PG"; $resn_exch{"1H11 1PG"}="H111 1PG";
$resn_exch{"2H11 1PG"}="H112 1PG"; $resn_exch{"1H3  1PI"}=" H31 1PI"; $resn_exch{"2H3  1PI"}=" H32 1PI";
$resn_exch{"1HN  1PI"}="HN1A 1PI"; $resn_exch{"2HN  1PI"}=" HN2 1PI"; $resn_exch{"1H17 1PI"}="H171 1PI";
$resn_exch{"2H17 1PI"}="H172 1PI"; $resn_exch{"1HD  1PI"}=" HD1 1PI"; $resn_exch{"2HD  1PI"}=" HD2 1PI";
$resn_exch{"1HG  1PI"}=" HG1 1PI"; $resn_exch{"2HG  1PI"}=" HG2 1PI"; $resn_exch{"1H1  1PI"}=" H11 1PI";
$resn_exch{"2H1  1PI"}=" H12 1PI"; $resn_exch{"1HN2 1PI"}="HN21 1PI"; $resn_exch{"2HN2 1PI"}="HN22 1PI";
$resn_exch{"1H10 1PL"}="H101 1PL"; $resn_exch{"2H10 1PL"}="H102 1PL"; $resn_exch{"3H10 1PL"}="H103 1PL";
$resn_exch{"1H11 1PL"}="H111 1PL"; $resn_exch{"2H11 1PL"}="H112 1PL"; $resn_exch{"1H12 1PL"}="H121 1PL";
$resn_exch{"2H12 1PL"}="H122 1PL"; $resn_exch{"1H3  1PL"}=" H31 1PL"; $resn_exch{"2H3  1PL"}=" H32 1PL";
$resn_exch{"1H14 1PL"}="H141 1PL"; $resn_exch{"2H14 1PL"}="H142 1PL"; $resn_exch{"3H14 1PL"}="H143 1PL";
$resn_exch{"1H15 1PL"}="H151 1PL"; $resn_exch{"2H15 1PL"}="H152 1PL"; $resn_exch{"3H15 1PL"}="H153 1PL";
$resn_exch{"1H1  1PL"}=" H11 1PL"; $resn_exch{"2H1  1PL"}=" H12 1PL"; $resn_exch{"1H30 1PM"}="H301 1PM";
$resn_exch{"2H30 1PM"}="H302 1PM"; $resn_exch{"3H30 1PM"}="H303 1PM"; $resn_exch{"1H31 1PM"}="H311 1PM";
$resn_exch{"2H31 1PM"}="H312 1PM"; $resn_exch{"1H36 1PM"}="H361 1PM"; $resn_exch{"2H36 1PM"}="H362 1PM";
$resn_exch{"1H48 1PM"}="H481 1PM"; $resn_exch{"2H48 1PM"}="H482 1PM"; $resn_exch{"1H12 1PN"}="H121 1PN";
$resn_exch{"2H12 1PN"}="H122 1PN"; $resn_exch{"1H13 1PN"}="H131 1PN"; $resn_exch{"2H13 1PN"}="H132 1PN";
$resn_exch{"1H14 1PN"}="H141 1PN"; $resn_exch{"2H14 1PN"}="H142 1PN"; $resn_exch{"3H14 1PN"}="H143 1PN";
$resn_exch{"1H16 1PN"}="H161 1PN"; $resn_exch{"2H16 1PN"}="H162 1PN"; $resn_exch{"3H16 1PN"}="H163 1PN";
$resn_exch{"1H20 1PN"}="H201 1PN"; $resn_exch{"2H20 1PN"}="H202 1PN"; $resn_exch{"3H20 1PN"}="H203 1PN";
$resn_exch{"1H15 1PP"}="H151 1PP"; $resn_exch{"2H15 1PP"}="H152 1PP"; $resn_exch{"3H15 1PP"}="H153 1PP";
$resn_exch{"1H14 1PP"}="H141 1PP"; $resn_exch{"2H14 1PP"}="H142 1PP"; $resn_exch{"3H14 1PP"}="H143 1PP";
$resn_exch{"1H13 1PP"}="H131 1PP"; $resn_exch{"2H13 1PP"}="H132 1PP"; $resn_exch{"3H13 1PP"}="H133 1PP";
$resn_exch{"1H5' 1PR"}="H5'1 1PR"; $resn_exch{"2H5' 1PR"}="H5'2 1PR"; $resn_exch{"'HO3 1PR"}="HO3' 1PR";
$resn_exch{"'HO2 1PR"}="HO2' 1PR"; $resn_exch{"1HN9 1PR"}="HN91 1PR"; $resn_exch{"2HN9 1PR"}="HN92 1PR";
$resn_exch{"1H7  1PR"}=" H71 1PR"; $resn_exch{"2H7  1PR"}=" H72 1PR"; $resn_exch{"1H\"  1PR"}=" H'1 1PR";
$resn_exch{"2H\"  1PR"}=" H'2 1PR"; $resn_exch{" H2\" 1PR"}=" H2B 1PR"; $resn_exch{" H3\" 1PR"}=" H3B 1PR";
$resn_exch{" H4\" 1PR"}=" H4B 1PR"; $resn_exch{"1H5\" 1PR"}="H5A1 1PR"; $resn_exch{"2H5\" 1PR"}="H5A2 1PR";
$resn_exch{" H8\" 1PR"}=" H8B 1PR"; $resn_exch{" H9\" 1PR"}=" H9B 1PR"; $resn_exch{"1H6  1PS"}=" H61 1PS";
$resn_exch{"2H6  1PS"}=" H62 1PS"; $resn_exch{"1H7  1PS"}=" H71 1PS"; $resn_exch{"2H7  1PS"}=" H72 1PS";
$resn_exch{"1H8  1PS"}=" H81 1PS"; $resn_exch{"2H8  1PS"}=" H82 1PS"; $resn_exch{"1H1  1PT"}=" H11 1PT";
$resn_exch{"2H1  1PT"}=" H12 1PT"; $resn_exch{"1H2  1PT"}=" H21 1PT"; $resn_exch{"2H2  1PT"}=" H22 1PT";
$resn_exch{"1H3  1PT"}=" H31 1PT"; $resn_exch{"2H3  1PT"}=" H32 1PT"; $resn_exch{"1H4  1PT"}=" H41 1PT";
$resn_exch{"2H4  1PT"}=" H42 1PT"; $resn_exch{"1H5  1PT"}=" H51 1PT"; $resn_exch{"2H5  1PT"}=" H52 1PT";
$resn_exch{"1H6  1PT"}=" H61 1PT"; $resn_exch{"2H6  1PT"}=" H62 1PT"; $resn_exch{"1H6  1PU"}=" H61 1PU";
$resn_exch{"2H6  1PU"}=" H62 1PU"; $resn_exch{"1H11 1PU"}="H111 1PU"; $resn_exch{"2H11 1PU"}="H112 1PU";
$resn_exch{"1H12 1PU"}="H121 1PU"; $resn_exch{"2H12 1PU"}="H122 1PU"; $resn_exch{"1HB  1PY"}=" HB1 1PY";
$resn_exch{"2HB  1PY"}=" HB2 1PY"; $resn_exch{"2HOP 1RB"}="HOP2 1RB"; $resn_exch{"3HOP 1RB"}="HOP3 1RB";
$resn_exch{"1H5* 1RB"}="H5'1 1RB"; $resn_exch{"2H5* 1RB"}="H5'2 1RB"; $resn_exch{" H4* 1RB"}=" H4' 1RB";
$resn_exch{" H3* 1RB"}=" H3' 1RB"; $resn_exch{"3HO2 1RB"}="HO23 1RB"; $resn_exch{" H2* 1RB"}=" H2' 1RB";
$resn_exch{"2HO2 1RB"}="HO22 1RB"; $resn_exch{" H1* 1RB"}=" H1' 1RB"; $resn_exch{"1HN1 1SA"}="HN11 1SA";
$resn_exch{"2HN1 1SA"}="HN12 1SA"; $resn_exch{"1HN4 1SA"}="HN41 1SA"; $resn_exch{"2HN4 1SA"}="HN42 1SA";
$resn_exch{"1H5* 1SC"}="H5'1 1SC"; $resn_exch{"2H5* 1SC"}="H5'2 1SC"; $resn_exch{" H4* 1SC"}=" H4' 1SC";
$resn_exch{" H3* 1SC"}=" H3' 1SC"; $resn_exch{"HO3* 1SC"}="HO3' 1SC"; $resn_exch{" H2* 1SC"}=" H2' 1SC";
$resn_exch{"HO2* 1SC"}="HO2' 1SC"; $resn_exch{" H1* 1SC"}=" H1' 1SC"; $resn_exch{"1HN4 1SC"}="HN41 1SC";
$resn_exch{"2HN4 1SC"}="HN42 1SC"; $resn_exch{"1H13 1SM"}="H131 1SM"; $resn_exch{"2H13 1SM"}="H132 1SM";
$resn_exch{"3H13 1SM"}="H133 1SM"; $resn_exch{"1H8' 1SM"}="H8'1 1SM"; $resn_exch{"2H8' 1SM"}="H8'2 1SM";
$resn_exch{"3H8' 1SM"}="H8'3 1SM"; $resn_exch{"1H7' 1SM"}="H7'1 1SM"; $resn_exch{"2H7' 1SM"}="H7'2 1SM";
$resn_exch{"3H7' 1SM"}="H7'3 1SM"; $resn_exch{"1HN1 1SQ"}="HN11 1SQ"; $resn_exch{"2HN1 1SQ"}="HN12 1SQ";
$resn_exch{"1H27 1ST"}="H271 1ST"; $resn_exch{"2H27 1ST"}="H272 1ST"; $resn_exch{"1H32 1ST"}="H321 1ST";
$resn_exch{"2H32 1ST"}="H322 1ST"; $resn_exch{"3H32 1ST"}="H323 1ST"; $resn_exch{"1H34 1ST"}="H341 1ST";
$resn_exch{"2H34 1ST"}="H342 1ST"; $resn_exch{"3H34 1ST"}="H343 1ST"; $resn_exch{"1H35 1ST"}="H351 1ST";
$resn_exch{"2H35 1ST"}="H352 1ST"; $resn_exch{"3H35 1ST"}="H353 1ST"; $resn_exch{"1H13 1TB"}="H131 1TB";
$resn_exch{"2H13 1TB"}="H132 1TB"; $resn_exch{"3H13 1TB"}="H133 1TB"; $resn_exch{"1H10 1TB"}="H101 1TB";
$resn_exch{"2H10 1TB"}="H102 1TB"; $resn_exch{"3H10 1TB"}="H103 1TB"; $resn_exch{"1H5' 1TB"}="H5'1 1TB";
$resn_exch{"2H5' 1TB"}="H5'2 1TB"; $resn_exch{"3H5' 1TB"}="H5'3 1TB"; $resn_exch{"1H7' 1TB"}="H7'1 1TB";
$resn_exch{"2H7' 1TB"}="H7'2 1TB"; $resn_exch{"3H7' 1TB"}="H7'3 1TB"; $resn_exch{"1H2A 1TP"}="H2A1 1TP";
$resn_exch{"2H2A 1TP"}="H2A2 1TP"; $resn_exch{"3H2A 1TP"}="H2A3 1TP"; $resn_exch{"1H4* 1TP"}="H4'1 1TP";
$resn_exch{"2H4* 1TP"}="H4'2 1TP"; $resn_exch{" H6* 1TP"}=" H6' 1TP"; $resn_exch{"1H7* 1TP"}="H7'1 1TP";
$resn_exch{"2H7* 1TP"}="H7'2 1TP"; $resn_exch{"1H4A 1TP"}="H4A1 1TP"; $resn_exch{"2H4A 1TP"}="H4A2 1TP";
$resn_exch{"3H4A 1TP"}="H4A3 1TP"; $resn_exch{"1H5A 1TP"}="H5A1 1TP"; $resn_exch{"2H5A 1TP"}="H5A2 1TP";
$resn_exch{"1H5B 1TP"}="H5B1 1TP"; $resn_exch{"2H5B 1TP"}="H5B2 1TP"; $resn_exch{"3HO1 1TP"}="HO13 1TP";
$resn_exch{"1H6B 1TP"}="H6B1 1TP"; $resn_exch{"3HO2 1TP"}="HO23 1TP"; $resn_exch{"1H35 1TP"}="H351 1TP";
$resn_exch{"2H35 1TP"}="H352 1TP"; $resn_exch{"3H35 1TP"}="H353 1TP"; $resn_exch{"1HN  1TQ"}=" H   1TQ";
$resn_exch{"2HN  1TQ"}=" H2  1TQ"; $resn_exch{"1HB  1TQ"}=" HB2 1TQ"; $resn_exch{"2HB  1TQ"}=" HB3 1TQ";
$resn_exch{"HNE1 1TQ"}=" HE1 1TQ"; $resn_exch{"HOXT 1TQ"}=" HXT 1TQ"; $resn_exch{"1HN  1TY"}=" H   1TY";
$resn_exch{"2HN  1TY"}=" H2  1TY"; $resn_exch{"1HB  1TY"}=" HB2 1TY"; $resn_exch{"2HB  1TY"}=" HB3 1TY";
$resn_exch{" HOH 1TY"}=" HH  1TY"; $resn_exch{"1H2  1TY"}=" H21 1TY"; $resn_exch{"2H2  1TY"}=" H22 1TY";
$resn_exch{"1H1  1TY"}=" H11 1TY"; $resn_exch{"2H1  1TY"}=" H12 1TY"; $resn_exch{"1H3  1UN"}="H31A 1UN";
$resn_exch{"2H3  1UN"}="H32A 1UN"; $resn_exch{"1H4  1UN"}=" H41 1UN"; $resn_exch{"2H4  1UN"}=" H42 1UN";
$resn_exch{"1H5  1UN"}=" H51 1UN"; $resn_exch{"2H5  1UN"}=" H52 1UN"; $resn_exch{"1H6  1UN"}=" H61 1UN";
$resn_exch{"2H6  1UN"}=" H62 1UN"; $resn_exch{"1H9  1UN"}=" H91 1UN"; $resn_exch{"2H9  1UN"}=" H92 1UN";
$resn_exch{"1H10 1UN"}="H101 1UN"; $resn_exch{"2H10 1UN"}="H102 1UN"; $resn_exch{"1H14 1UN"}="H141 1UN";
$resn_exch{"2H14 1UN"}="H142 1UN"; $resn_exch{"3H14 1UN"}="H143 1UN"; $resn_exch{"1H15 1UN"}="H151 1UN";
$resn_exch{"2H15 1UN"}="H152 1UN"; $resn_exch{"3H15 1UN"}="H153 1UN"; $resn_exch{"1H16 1UN"}="H161 1UN";
$resn_exch{"2H16 1UN"}="H162 1UN"; $resn_exch{"3H16 1UN"}="H163 1UN"; $resn_exch{"1H18 1UN"}="H181 1UN";
$resn_exch{"2H18 1UN"}="H182 1UN"; $resn_exch{"1H23 1UN"}="H231 1UN"; $resn_exch{"2H23 1UN"}="H232 1UN";
$resn_exch{"1H39 1UN"}="H391 1UN"; $resn_exch{"2H39 1UN"}="H392 1UN"; $resn_exch{"3H39 1UN"}="H393 1UN";
$resn_exch{"1HN  200"}=" H2  200"; $resn_exch{"1HB  200"}=" HB2 200"; $resn_exch{"2HB  200"}=" HB3 200";
$resn_exch{"1HD1 200"}=" HD1 200"; $resn_exch{"1HD2 200"}=" HD2 200"; $resn_exch{"1HE1 200"}=" HE1 200";
$resn_exch{"1HE2 200"}=" HE2 200"; $resn_exch{"1HN1 201"}="HN11 201"; $resn_exch{"2HN1 201"}="HN12 201";
$resn_exch{"1H1  204"}=" H11 204"; $resn_exch{"2H1  204"}=" H12 204"; $resn_exch{"3H1  204"}="H13A 204";
$resn_exch{"1H2  204"}=" H21 204"; $resn_exch{"2H2  204"}=" H22 204"; $resn_exch{"1H10 204"}="H101 204";
$resn_exch{"2H10 204"}="H102 204"; $resn_exch{"1H9C 207"}="H9C1 207"; $resn_exch{"2H9C 207"}="H9C2 207";
$resn_exch{"1H2N 207"}="H2N1 207"; $resn_exch{"2H2N 207"}="H2N2 207"; $resn_exch{"1H11 207"}="H111 207";
$resn_exch{"2H11 207"}="H112 207"; $resn_exch{"1H12 207"}="H121 207"; $resn_exch{"2H12 207"}="H122 207";
$resn_exch{"1H13 207"}="H131 207"; $resn_exch{"2H13 207"}="H132 207"; $resn_exch{"1H14 207"}="H141 207";
$resn_exch{"2H14 207"}="H142 207"; $resn_exch{"1H15 207"}="H151 207"; $resn_exch{"2H15 207"}="H152 207";
$resn_exch{"1H30 208"}="H301 208"; $resn_exch{"2H30 208"}="H302 208"; $resn_exch{"3H30 208"}="H303 208";
$resn_exch{"1H28 208"}="H281 208"; $resn_exch{"2H28 208"}="H282 208"; $resn_exch{"1H19 208"}="H191 208";
$resn_exch{"2H19 208"}="H192 208"; $resn_exch{"1H9  208"}=" H91 208"; $resn_exch{"2H9  208"}=" H92 208";
$resn_exch{"1H26 208"}="H261 208"; $resn_exch{"2H26 208"}="H262 208"; $resn_exch{"3H26 208"}="H263 208";
$resn_exch{"1H10 209"}="H101 209"; $resn_exch{"2H10 209"}="H102 209"; $resn_exch{"1H11 209"}="H111 209";
$resn_exch{"2H11 209"}="H112 209"; $resn_exch{"3H11 209"}="H113 209"; $resn_exch{"1H15 209"}="H151 209";
$resn_exch{"2H15 209"}="H152 209"; $resn_exch{"3H15 209"}="H153 209"; $resn_exch{"1H19 20E"}="H191 20E";
$resn_exch{"2H19 20E"}="H192 20E"; $resn_exch{"3H19 20E"}="H193 20E"; $resn_exch{"1H1  20E"}=" H11 20E";
$resn_exch{"2H1  20E"}=" H12 20E"; $resn_exch{"1H4  20E"}=" H41 20E"; $resn_exch{"2H4  20E"}=" H42 20E";
$resn_exch{"1H11 20E"}="H111 20E"; $resn_exch{"2H11 20E"}="H112 20E"; $resn_exch{"1H12 20E"}="H121 20E";
$resn_exch{"2H12 20E"}="H122 20E"; $resn_exch{"1H18 20E"}="H181 20E"; $resn_exch{"2H18 20E"}="H182 20E";
$resn_exch{"3H18 20E"}="H183 20E"; $resn_exch{"1H15 20E"}="H151 20E"; $resn_exch{"2H15 20E"}="H152 20E";
$resn_exch{"1H16 20E"}="H161 20E"; $resn_exch{"2H16 20E"}="H162 20E"; $resn_exch{"1H21 20E"}="H211 20E";
$resn_exch{"2H21 20E"}="H212 20E"; $resn_exch{"3H21 20E"}="H213 20E"; $resn_exch{"1H23 20E"}="H231 20E";
$resn_exch{"2H23 20E"}="H232 20E"; $resn_exch{"1H24 20E"}="H241 20E"; $resn_exch{"2H24 20E"}="H242 20E";
$resn_exch{"1H26 20E"}="H261 20E"; $resn_exch{"2H26 20E"}="H262 20E"; $resn_exch{"3H26 20E"}="H263 20E";
$resn_exch{"1H27 20E"}="H271 20E"; $resn_exch{"2H27 20E"}="H272 20E"; $resn_exch{"3H27 20E"}="H273 20E";
$resn_exch{"1H7  20S"}=" H71 20S"; $resn_exch{"2H7  20S"}=" H72 20S"; $resn_exch{"1H8  20S"}=" H81 20S";
$resn_exch{"2H8  20S"}=" H82 20S"; $resn_exch{"1H9  20S"}=" H91 20S"; $resn_exch{"2H9  20S"}=" H92 20S";
$resn_exch{"1H10 20S"}="H101 20S"; $resn_exch{"2H10 20S"}="H102 20S"; $resn_exch{"1H17 20S"}="H171 20S";
$resn_exch{"2H17 20S"}="H172 20S"; $resn_exch{"1H18 20S"}="H181 20S"; $resn_exch{"2H18 20S"}="H182 20S";
$resn_exch{"1H32 20S"}="H321 20S"; $resn_exch{"2H32 20S"}="H322 20S"; $resn_exch{"1H31 20S"}="H311 20S";
$resn_exch{"2H31 20S"}="H312 20S"; $resn_exch{"3H31 20S"}="H313 20S"; $resn_exch{"1H16 210"}="H161 210";
$resn_exch{"2H16 210"}="H162 210"; $resn_exch{"1H19 210"}="H191 210"; $resn_exch{"2H19 210"}="H192 210";
$resn_exch{"1H22 210"}="H221 210"; $resn_exch{"2H22 210"}="H222 210"; $resn_exch{"1H1  211"}=" H11 211";
$resn_exch{"2H1  211"}=" H12 211"; $resn_exch{"1H2  211"}=" H21 211"; $resn_exch{"2H2  211"}=" H22 211";
$resn_exch{"1H3  211"}=" H31 211"; $resn_exch{"2H3  211"}=" H32 211"; $resn_exch{"1H4  211"}=" H41 211";
$resn_exch{"2H4  211"}=" H42 211"; $resn_exch{"1H5  211"}=" H51 211"; $resn_exch{"2H5  211"}=" H52 211";
$resn_exch{"1H6  211"}=" H61 211"; $resn_exch{"2H6  211"}=" H62 211"; $resn_exch{"1H32 213"}="H321 213";
$resn_exch{"2H32 213"}="H322 213"; $resn_exch{"1H35 213"}="H351 213"; $resn_exch{"2H35 213"}="H352 213";
$resn_exch{"1H32 214"}="H321 214"; $resn_exch{"2H32 214"}="H322 214"; $resn_exch{"1H35 214"}="H351 214";
$resn_exch{"2H35 214"}="H352 214"; $resn_exch{"1H71 214"}="H711 214"; $resn_exch{"2H71 214"}="H712 214";
$resn_exch{"3H71 214"}="H713 214"; $resn_exch{"1H23 215"}="H231 215"; $resn_exch{"2H23 215"}="H232 215";
$resn_exch{"1H31 215"}="H311 215"; $resn_exch{"2H31 215"}="H312 215"; $resn_exch{"1H30 215"}="H301 215";
$resn_exch{"2H30 215"}="H302 215"; $resn_exch{"1H24 215"}="H241 215"; $resn_exch{"2H24 215"}="H242 215";
$resn_exch{"1H27 215"}="H271 215"; $resn_exch{"2H27 215"}="H272 215"; $resn_exch{"3H27 215"}="H273 215";
$resn_exch{"1H26 215"}="H261 215"; $resn_exch{"2H26 215"}="H262 215"; $resn_exch{"3H26 215"}="H263 215";
$resn_exch{"1H21 216"}="H211 216"; $resn_exch{"2H21 216"}="H212 216"; $resn_exch{"1H23 216"}="H231 216";
$resn_exch{"2H23 216"}="H232 216"; $resn_exch{"1H31 216"}="H311 216"; $resn_exch{"2H31 216"}="H312 216";
$resn_exch{"1H61 216"}="H611 216"; $resn_exch{"2H61 216"}="H612 216"; $resn_exch{"1H71 216"}="H711 216";
$resn_exch{"2H71 216"}="H712 216"; $resn_exch{"1H73 216"}="H731 216"; $resn_exch{"2H73 216"}="H732 216";
$resn_exch{"1H1  217"}=" H11 217"; $resn_exch{"2H1  217"}=" H12 217"; $resn_exch{"1H3  217"}=" H31 217";
$resn_exch{"2H3  217"}=" H32 217"; $resn_exch{"1H4  217"}=" H41 217"; $resn_exch{"2H4  217"}=" H42 217";
$resn_exch{"1H6  217"}=" H61 217"; $resn_exch{"2H6  217"}=" H62 217"; $resn_exch{"1HM2 218"}="HM21 218";
$resn_exch{"2HM2 218"}="HM22 218"; $resn_exch{"3HM2 218"}="HM23 218"; $resn_exch{"1H7A 218"}="H7A1 218";
$resn_exch{"2H7A 218"}="H7A2 218"; $resn_exch{"1HM6 218"}="HM61 218"; $resn_exch{"2HM6 218"}="HM62 218";
$resn_exch{"1HM7 218"}="HM71 218"; $resn_exch{"2HM7 218"}="HM72 218"; $resn_exch{"1HM4 218"}="HM41 218";
$resn_exch{"2HM4 218"}="HM42 218"; $resn_exch{"3HM4 218"}="HM43 218"; $resn_exch{"1H4A 218"}="H4A1 218";
$resn_exch{"2H4A 218"}="H4A2 218"; $resn_exch{"1H12 219"}="H121 219"; $resn_exch{"2H12 219"}="H122 219";
$resn_exch{"1H24 219"}="H241 219"; $resn_exch{"2H24 219"}="H242 219"; $resn_exch{"1H25 219"}="H251 219";
$resn_exch{"2H25 219"}="H252 219"; $resn_exch{"1H26 219"}="H261 219"; $resn_exch{"2H26 219"}="H262 219";
$resn_exch{"1H27 219"}="H271 219"; $resn_exch{"2H27 219"}="H272 219"; $resn_exch{"1H28 219"}="H281 219";
$resn_exch{"2H28 219"}="H282 219"; $resn_exch{"1H2  220"}=" H21 220"; $resn_exch{"2H2  220"}=" H22 220";
$resn_exch{"1H3  220"}=" H31 220"; $resn_exch{"2H3  220"}=" H32 220"; $resn_exch{"1H4  220"}=" H41 220";
$resn_exch{"2H4  220"}=" H42 220"; $resn_exch{"1H7  220"}=" H71 220"; $resn_exch{"2H7  220"}=" H72 220";
$resn_exch{"1H8  220"}=" H81 220"; $resn_exch{"2H8  220"}=" H82 220"; $resn_exch{"1H11 220"}="H111 220";
$resn_exch{"2H11 220"}="H112 220"; $resn_exch{"1H12 220"}="H121 220"; $resn_exch{"2H12 220"}="H122 220";
$resn_exch{"1H13 221"}="H131 221"; $resn_exch{"2H13 221"}="H132 221"; $resn_exch{"1H22 222"}="H221 222";
$resn_exch{"2H22 222"}="H222 222"; $resn_exch{"1H24 222"}="H241 222"; $resn_exch{"2H24 222"}="H242 222";
$resn_exch{"1H27 222"}="H271 222"; $resn_exch{"2H27 222"}="H272 222"; $resn_exch{"1HN6 223"}="HN61 223";
$resn_exch{"2HN6 223"}="HN62 223"; $resn_exch{"1H10 223"}="H101 223"; $resn_exch{"2H10 223"}="H102 223";
$resn_exch{"1H6* 223"}="H6'1 223"; $resn_exch{"2H6* 223"}="H6'2 223"; $resn_exch{" H4* 223"}=" H4' 223";
$resn_exch{"1H5* 223"}="H5'1 223"; $resn_exch{"2H5* 223"}="H5'2 223"; $resn_exch{"HO5* 223"}="HO5' 223";
$resn_exch{" H3* 223"}=" H3' 223"; $resn_exch{"HO3* 223"}="HO3' 223"; $resn_exch{"1H2* 223"}="H2'1 223";
$resn_exch{"2H2* 223"}="H2'2 223"; $resn_exch{"1H4  224"}=" H41 224"; $resn_exch{"2H4  224"}=" H42 224";
$resn_exch{"1H6  224"}=" H61 224"; $resn_exch{"2H6  224"}=" H62 224"; $resn_exch{"1H7  224"}=" H71 224";
$resn_exch{"2H7  224"}=" H72 224"; $resn_exch{"1H8  224"}=" H81 224"; $resn_exch{"2H8  224"}=" H82 224";
$resn_exch{"1H9  224"}=" H91 224"; $resn_exch{"2H9  224"}=" H92 224"; $resn_exch{"1H15 225"}="H151 225";
$resn_exch{"2H15 225"}="H152 225"; $resn_exch{"3H15 225"}="H153 225"; $resn_exch{"1H14 225"}="H141 225";
$resn_exch{"2H14 225"}="H142 225"; $resn_exch{"1H12 225"}="H121 225"; $resn_exch{"2H12 225"}="H122 225";
$resn_exch{"3H12 225"}="H123 225"; $resn_exch{"1H18 225"}="H181 225"; $resn_exch{"2H18 225"}="H182 225";
$resn_exch{"3H18 225"}="H183 225"; $resn_exch{"1H17 225"}="H171 225"; $resn_exch{"2H17 225"}="H172 225";
$resn_exch{"3H17 225"}="H173 225"; $resn_exch{"1H34 227"}="H341 227"; $resn_exch{"2H34 227"}="H342 227";
$resn_exch{"3H34 227"}="H343 227"; $resn_exch{"1H32 227"}="H321 227"; $resn_exch{"2H32 227"}="H322 227";
$resn_exch{"1H21 227"}="H211 227"; $resn_exch{"2H21 227"}="H212 227"; $resn_exch{"3H21 227"}="H213 227";
$resn_exch{"1H18 227"}="H181 227"; $resn_exch{"2H18 227"}="H182 227"; $resn_exch{"3H18 227"}="H183 227";
$resn_exch{"1H16 227"}="H161 227"; $resn_exch{"2H16 227"}="H162 227"; $resn_exch{"1H30 227"}="H301 227";
$resn_exch{"2H30 227"}="H302 227"; $resn_exch{"1H31 227"}="H311 227"; $resn_exch{"2H31 227"}="H312 227";
$resn_exch{"1H29 227"}="H291 227"; $resn_exch{"2H29 227"}="H292 227"; $resn_exch{"1H10 227"}="H101 227";
$resn_exch{"2H10 227"}="H102 227"; $resn_exch{"1H11 227"}="H111 227"; $resn_exch{"2H11 227"}="H112 227";
$resn_exch{"1H30 228"}="H301 228"; $resn_exch{"2H30 228"}="H302 228"; $resn_exch{"1H22 228"}="H221 228";
$resn_exch{"2H22 228"}="H222 228"; $resn_exch{"1H21 228"}="H211 228"; $resn_exch{"2H21 228"}="H212 228";
$resn_exch{"1H16 228"}="H161 228"; $resn_exch{"2H16 228"}="H162 228"; $resn_exch{"1H15 228"}="H151 228";
$resn_exch{"2H15 228"}="H152 228"; $resn_exch{"1H14 228"}="H141 228"; $resn_exch{"2H14 228"}="H142 228";
$resn_exch{"1H12 228"}="H121 228"; $resn_exch{"2H12 228"}="H122 228"; $resn_exch{"3H12 228"}="H123 228";
$resn_exch{"1H50 22B"}="H501 22B"; $resn_exch{"2H50 22B"}="H502 22B"; $resn_exch{"3H50 22B"}="H503 22B";
$resn_exch{"1H20 22B"}="H201 22B"; $resn_exch{"2H20 22B"}="H202 22B"; $resn_exch{"3H20 22B"}="H203 22B";
$resn_exch{"1H19 22B"}="H191 22B"; $resn_exch{"2H19 22B"}="H192 22B"; $resn_exch{"3H19 22B"}="H193 22B";
$resn_exch{"1H18 22B"}="H181 22B"; $resn_exch{"2H18 22B"}="H182 22B"; $resn_exch{"3H18 22B"}="H183 22B";
$resn_exch{"1H21 22B"}="H211 22B"; $resn_exch{"2H21 22B"}="H212 22B"; $resn_exch{"1H22 22B"}="H221 22B";
$resn_exch{"2H22 22B"}="H222 22B"; $resn_exch{"1H24 22B"}="H241 22B"; $resn_exch{"2H24 22B"}="H242 22B";
$resn_exch{"3H24 22B"}="H243 22B"; $resn_exch{"1H25 22B"}="H251 22B"; $resn_exch{"2H25 22B"}="H252 22B";
$resn_exch{"3H25 22B"}="H253 22B"; $resn_exch{"1H16 22B"}="H161 22B"; $resn_exch{"2H16 22B"}="H162 22B";
$resn_exch{"3H16 22B"}="H163 22B"; $resn_exch{"1H17 22B"}="H171 22B"; $resn_exch{"2H17 22B"}="H172 22B";
$resn_exch{"3H17 22B"}="H173 22B"; $resn_exch{"1H26 22B"}="H261 22B"; $resn_exch{"2H26 22B"}="H262 22B";
$resn_exch{"3H26 22B"}="H263 22B"; $resn_exch{"1H30 22B"}="H301 22B"; $resn_exch{"2H30 22B"}="H302 22B";
$resn_exch{"3H30 22B"}="H303 22B"; $resn_exch{"1H34 22B"}="H341 22B"; $resn_exch{"2H34 22B"}="H342 22B";
$resn_exch{"1H35 22B"}="H351 22B"; $resn_exch{"2H35 22B"}="H352 22B"; $resn_exch{"1H37 22B"}="H371 22B";
$resn_exch{"2H37 22B"}="H372 22B"; $resn_exch{"3H37 22B"}="H373 22B"; $resn_exch{"1H46 22B"}="H461 22B";
$resn_exch{"2H46 22B"}="H462 22B"; $resn_exch{"3H46 22B"}="H463 22B"; $resn_exch{"1H48 22B"}="H481 22B";
$resn_exch{"2H48 22B"}="H482 22B"; $resn_exch{"3H48 22B"}="H483 22B"; $resn_exch{"1H49 22B"}="H491 22B";
$resn_exch{"2H49 22B"}="H492 22B"; $resn_exch{"3H49 22B"}="H493 22B"; $resn_exch{"1HN5 22M"}="HN51 22M";
$resn_exch{"2HN5 22M"}="HN52 22M"; $resn_exch{"1H18 22M"}="H181 22M"; $resn_exch{"2H18 22M"}="H182 22M";
$resn_exch{"3H18 22M"}="H183 22M"; $resn_exch{"1H20 230"}="H201 230"; $resn_exch{"2H20 230"}="H202 230";
$resn_exch{"1H22 230"}="H221 230"; $resn_exch{"2H22 230"}="H222 230"; $resn_exch{"1H24 230"}="H241 230";
$resn_exch{"2H24 230"}="H242 230"; $resn_exch{"3H24 230"}="H243 230"; $resn_exch{"1H19 232"}="H191 232";
$resn_exch{"2H19 232"}="H192 232"; $resn_exch{"1H18 232"}="H181 232"; $resn_exch{"2H18 232"}="H182 232";
$resn_exch{"3H18 232"}="H183 232"; $resn_exch{"1H20 232"}="H201 232"; $resn_exch{"2H20 232"}="H202 232";
$resn_exch{"1H22 232"}="H221 232"; $resn_exch{"2H22 232"}="H222 232"; $resn_exch{"1H23 232"}="H231 232";
$resn_exch{"2H23 232"}="H232 232"; $resn_exch{"1H25 232"}="H251 232"; $resn_exch{"2H25 232"}="H252 232";
$resn_exch{"1H26 232"}="H261 232"; $resn_exch{"2H26 232"}="H262 232"; $resn_exch{"1H27 232"}="H271 232";
$resn_exch{"2H27 232"}="H272 232"; $resn_exch{"1H28 232"}="H281 232"; $resn_exch{"2H28 232"}="H282 232";
$resn_exch{"3H19 232"}="H193 232"; $resn_exch{"4H19 232"}="H194 232"; $resn_exch{"4H18 232"}="H184 232";
$resn_exch{"5H18 232"}="H185 232"; $resn_exch{"6H18 232"}="H186 232"; $resn_exch{"3H20 232"}="H203 232";
$resn_exch{"4H20 232"}="H204 232"; $resn_exch{"3H22 232"}="H223 232"; $resn_exch{"4H22 232"}="H224 232";
$resn_exch{"3H23 232"}="H233 232"; $resn_exch{"4H23 232"}="H234 232"; $resn_exch{"3H25 232"}="H253 232";
$resn_exch{"4H25 232"}="H254 232"; $resn_exch{"3H26 232"}="H263 232"; $resn_exch{"4H26 232"}="H264 232";
$resn_exch{"3H27 232"}="H273 232"; $resn_exch{"4H27 232"}="H274 232"; $resn_exch{"1H39 234"}="H391 234";
$resn_exch{"2H39 234"}="H392 234"; $resn_exch{"3H39 234"}="H393 234"; $resn_exch{"1H40 234"}="H401 234";
$resn_exch{"2H40 234"}="H402 234"; $resn_exch{"1H30 235"}="H301 235"; $resn_exch{"2H30 235"}="H302 235";
$resn_exch{"3H30 235"}="H303 235"; $resn_exch{"1H29 235"}="H291 235"; $resn_exch{"2H29 235"}="H292 235";
$resn_exch{"3H29 235"}="H293 235"; $resn_exch{"1H15 235"}="H151 235"; $resn_exch{"2H15 235"}="H152 235";
$resn_exch{"1H9  235"}=" H91 235"; $resn_exch{"2H9  235"}=" H92 235"; $resn_exch{"1H10 235"}="H101 235";
$resn_exch{"2H10 235"}="H102 235"; $resn_exch{"1H20 237"}="H201 237"; $resn_exch{"2H20 237"}="H202 237";
$resn_exch{"3H20 237"}="H203 237"; $resn_exch{"1H9  237"}=" H91 237"; $resn_exch{"2H9  237"}=" H92 237";
$resn_exch{"1H11 237"}="H111 237"; $resn_exch{"2H11 237"}="H112 237"; $resn_exch{"1H19 237"}="H191 237";
$resn_exch{"2H19 237"}="H192 237"; $resn_exch{"3H19 237"}="H193 237"; $resn_exch{"1H19 239"}="H191 239";
$resn_exch{"2H19 239"}="H192 239"; $resn_exch{"1H37 239"}="H371 239"; $resn_exch{"2H37 239"}="H372 239";
$resn_exch{"1H38 239"}="H381 239"; $resn_exch{"2H38 239"}="H382 239"; $resn_exch{"1HAZ 23D"}="HAZ1 23D";
$resn_exch{"2HAZ 23D"}="HAZ2 23D"; $resn_exch{"1HBA 23D"}="HBA1 23D"; $resn_exch{"2HBA 23D"}="HBA2 23D";
$resn_exch{"3HBA 23D"}="HBA3 23D"; $resn_exch{"1HAF 23D"}="HAF1 23D"; $resn_exch{"2HAF 23D"}="HAF2 23D";
$resn_exch{"1HAE 23D"}="HAE1 23D"; $resn_exch{"2HAE 23D"}="HAE2 23D"; $resn_exch{"1HAD 23D"}="HAD1 23D";
$resn_exch{"2HAD 23D"}="HAD2 23D"; $resn_exch{"1HAC 23D"}="HAC1 23D"; $resn_exch{"2HAC 23D"}="HAC2 23D";
$resn_exch{"1HAB 23D"}="HAB1 23D"; $resn_exch{"2HAB 23D"}="HAB2 23D"; $resn_exch{" HN  23F"}=" H   23F";
$resn_exch{" HN2 23F"}=" H2  23F"; $resn_exch{"2HB  23F"}=" HB  23F"; $resn_exch{"1H20 23I"}="H201 23I";
$resn_exch{"2H20 23I"}="H202 23I"; $resn_exch{"3H20 23I"}="H203 23I"; $resn_exch{"1H33 23I"}="H331 23I";
$resn_exch{"2H33 23I"}="H332 23I"; $resn_exch{"1H35 23I"}="H351 23I"; $resn_exch{"2H35 23I"}="H352 23I";
$resn_exch{"3H35 23I"}="H353 23I"; $resn_exch{"1H18 23I"}="H181 23I"; $resn_exch{"2H18 23I"}="H182 23I";
$resn_exch{"3H18 23I"}="H183 23I"; $resn_exch{"1H29 23I"}="H291 23I"; $resn_exch{"2H29 23I"}="H292 23I";
$resn_exch{"3H29 23I"}="H293 23I"; $resn_exch{"1H36 23I"}="H361 23I"; $resn_exch{"2H36 23I"}="H362 23I";
$resn_exch{"3H36 23I"}="H363 23I"; $resn_exch{"1H37 23I"}="H371 23I"; $resn_exch{"2H37 23I"}="H372 23I";
$resn_exch{"1H39 23I"}="H391 23I"; $resn_exch{"2H39 23I"}="H392 23I"; $resn_exch{"3H39 23I"}="H393 23I";
$resn_exch{"1H43 23I"}="H431 23I"; $resn_exch{"2H43 23I"}="H432 23I"; $resn_exch{"3H43 23I"}="H433 23I";
$resn_exch{"1H44 23I"}="H441 23I"; $resn_exch{"2H44 23I"}="H442 23I"; $resn_exch{"3H44 23I"}="H443 23I";
$resn_exch{"1H53 23I"}="H531 23I"; $resn_exch{"2H53 23I"}="H532 23I"; $resn_exch{"3H53 23I"}="H533 23I";
$resn_exch{"1H52 23I"}="H521 23I"; $resn_exch{"2H52 23I"}="H522 23I"; $resn_exch{"3H52 23I"}="H523 23I";
$resn_exch{"1H12 23M"}="H121 23M"; $resn_exch{"2H12 23M"}="H122 23M"; $resn_exch{"3H12 23M"}="H123 23M";
$resn_exch{"1H19 23M"}="H191 23M"; $resn_exch{"2H19 23M"}="H192 23M"; $resn_exch{"1HAJ 23N"}="HAJ1 23N";
$resn_exch{"2HAJ 23N"}="HAJ2 23N"; $resn_exch{"1HAK 23N"}="HAK1 23N"; $resn_exch{"2HAK 23N"}="HAK2 23N";
$resn_exch{"1HB  23S"}=" HB1 23S"; $resn_exch{"2HB  23S"}=" HB2 23S"; $resn_exch{"1H5* 23T"}="H5'1 23T";
$resn_exch{"2H5* 23T"}="H5'2 23T"; $resn_exch{" H4* 23T"}=" H4' 23T"; $resn_exch{" H1* 23T"}=" H1' 23T";
$resn_exch{"1H5M 23T"}="H5M1 23T"; $resn_exch{"2H5M 23T"}="H5M2 23T"; $resn_exch{"3H5M 23T"}="H5M3 23T";
$resn_exch{"1H2* 23T"}="H2'1 23T"; $resn_exch{"2H2* 23T"}="H2'2 23T"; $resn_exch{"1H3* 23T"}="H3'1 23T";
$resn_exch{"2H3* 23T"}="H3'2 23T"; $resn_exch{"1HAC 240"}="HAC1 240"; $resn_exch{"2HAC 240"}="HAC2 240";
$resn_exch{"3HAC 240"}="HAC3 240"; $resn_exch{"1HAU 240"}="HAU1 240"; $resn_exch{"2HAU 240"}="HAU2 240";
$resn_exch{"1HAB 240"}="HAB1 240"; $resn_exch{"2HAB 240"}="HAB2 240"; $resn_exch{"3HAB 240"}="HAB3 240";
$resn_exch{"1HAA 240"}="HAA1 240"; $resn_exch{"2HAA 240"}="HAA2 240"; $resn_exch{"3HAA 240"}="HAA3 240";
$resn_exch{"1HAA 241"}="HAA1 241"; $resn_exch{"2HAA 241"}="HAA2 241"; $resn_exch{"3HAA 241"}="HAA3 241";
$resn_exch{"1HAB 241"}="HAB1 241"; $resn_exch{"2HAB 241"}="HAB2 241"; $resn_exch{"3HAB 241"}="HAB3 241";
$resn_exch{"1HAU 241"}="HAU1 241"; $resn_exch{"2HAU 241"}="HAU2 241"; $resn_exch{"1HAC 241"}="HAC1 241";
$resn_exch{"2HAC 241"}="HAC2 241"; $resn_exch{"3HAC 241"}="HAC3 241"; $resn_exch{"1H15 242"}="H151 242";
$resn_exch{"2H15 242"}="H152 242"; $resn_exch{"1H25 242"}="H251 242"; $resn_exch{"2H25 242"}="H252 242";
$resn_exch{"3H25 242"}="H253 242"; $resn_exch{"1H13 244"}="H131 244"; $resn_exch{"2H13 244"}="H132 244";
$resn_exch{"1H0A 24A"}="H0A1 24A"; $resn_exch{"2H0A 24A"}="H0A2 24A"; $resn_exch{"3H0A 24A"}="H0A3 24A";
$resn_exch{"1H1A 24A"}="H1A1 24A"; $resn_exch{"2H1A 24A"}="H1A2 24A"; $resn_exch{"1HAB 24A"}="HAB1 24A";
$resn_exch{"2HAB 24A"}="HAB2 24A"; $resn_exch{"1HS1 24A"}="HS11 24A"; $resn_exch{"2HS1 24A"}="HS12 24A";
$resn_exch{"1HS2 24A"}="HS21 24A"; $resn_exch{"2HS2 24A"}="HS22 24A"; $resn_exch{"1HS3 24A"}="HS31 24A";
$resn_exch{"2HS3 24A"}="HS32 24A"; $resn_exch{"1HS5 24A"}="HS51 24A"; $resn_exch{"2HS5 24A"}="HS52 24A";
$resn_exch{"1HS6 24A"}="HS61 24A"; $resn_exch{"2HS6 24A"}="HS62 24A"; $resn_exch{"1H7  24B"}=" H71 24B";
$resn_exch{"2H7  24B"}=" H72 24B"; $resn_exch{"1H13 24I"}="H131 24I"; $resn_exch{"2H13 24I"}="H132 24I";
$resn_exch{"1H12 24I"}="H121 24I"; $resn_exch{"2H12 24I"}="H122 24I"; $resn_exch{"1H7C 24I"}="H7C1 24I";
$resn_exch{"2H7C 24I"}="H7C2 24I"; $resn_exch{"1H6C 24I"}="H6C1 24I"; $resn_exch{"2H6C 24I"}="H6C2 24I";
$resn_exch{"1HN  24T"}=" HN1 24T"; $resn_exch{"2HN  24T"}=" HN2 24T"; $resn_exch{"1HM  24T"}=" HM1 24T";
$resn_exch{"2HM  24T"}=" HM2 24T"; $resn_exch{"3HM  24T"}=" HM3 24T"; $resn_exch{"1HN4 24X"}="HN41 24X";
$resn_exch{"2HN4 24X"}="HN42 24X"; $resn_exch{"1H7  24X"}=" H71 24X"; $resn_exch{"2H7  24X"}=" H72 24X";
$resn_exch{"1H16 24X"}="H161 24X"; $resn_exch{"2H16 24X"}="H162 24X"; $resn_exch{"1H11 24X"}="H111 24X";
$resn_exch{"2H11 24X"}="H112 24X"; $resn_exch{"1H12 24X"}="H121 24X"; $resn_exch{"2H12 24X"}="H122 24X";
$resn_exch{"3H12 24X"}="H123 24X"; $resn_exch{"1H13 24X"}="H131 24X"; $resn_exch{"2H13 24X"}="H132 24X";
$resn_exch{"3H13 24X"}="H133 24X"; $resn_exch{"1H17 254"}="H171 254"; $resn_exch{"2H17 254"}="H172 254";
$resn_exch{"1H18 254"}="H181 254"; $resn_exch{"2H18 254"}="H182 254"; $resn_exch{"1H23 254"}="H231 254";
$resn_exch{"2H23 254"}="H232 254"; $resn_exch{"3H23 254"}="H233 254"; $resn_exch{"1H24 254"}="H241 254";
$resn_exch{"2H24 254"}="H242 254"; $resn_exch{"3H24 254"}="H243 254"; $resn_exch{"1H25 254"}="H251 254";
$resn_exch{"2H25 254"}="H252 254"; $resn_exch{"3H25 254"}="H253 254"; $resn_exch{"1H26 254"}="H261 254";
$resn_exch{"2H26 254"}="H262 254"; $resn_exch{"3H26 254"}="H263 254"; $resn_exch{"1H01 255"}="H011 255";
$resn_exch{"2H01 255"}="H012 255"; $resn_exch{"3H01 255"}="H013 255"; $resn_exch{"1H02 255"}="H021 255";
$resn_exch{"2H02 255"}="H022 255"; $resn_exch{"3H02 255"}="H023 255"; $resn_exch{"1H03 255"}="H031 255";
$resn_exch{"2H03 255"}="H032 255"; $resn_exch{"3H03 255"}="H033 255"; $resn_exch{"1H5* 25A"}="H5'1 25A";
$resn_exch{"2H5* 25A"}="H5'2 25A"; $resn_exch{" H4* 25A"}=" H4' 25A"; $resn_exch{" H1* 25A"}=" H1' 25A";
$resn_exch{" H2* 25A"}=" H2' 25A"; $resn_exch{" H3* 25A"}=" H3' 25A"; $resn_exch{"1HN6 25A"}="HN61 25A";
$resn_exch{"2HN6 25A"}="HN62 25A"; $resn_exch{"1H15 25A"}="H151 25A"; $resn_exch{"2H15 25A"}="H152 25A";
$resn_exch{"H14* 25A"}="H14' 25A"; $resn_exch{"H11* 25A"}="H11' 25A"; $resn_exch{"1H16 25A"}="H161 25A";
$resn_exch{"2H16 25A"}="H162 25A"; $resn_exch{"H12* 25A"}="H12' 25A"; $resn_exch{"H13* 25A"}="H13' 25A";
$resn_exch{"1H25 25A"}="H251 25A"; $resn_exch{"2H25 25A"}="H252 25A"; $resn_exch{"H24* 25A"}="H24' 25A";
$resn_exch{"H21* 25A"}="H21' 25A"; $resn_exch{"1H26 25A"}="H261 25A"; $resn_exch{"2H26 25A"}="H262 25A";
$resn_exch{"H22* 25A"}="H22' 25A"; $resn_exch{"H23* 25A"}="H23' 25A"; $resn_exch{"1HN  25T"}=" HN1 25T";
$resn_exch{"2HN  25T"}=" HN2 25T"; $resn_exch{"1HM  25T"}=" HM1 25T"; $resn_exch{"2HM  25T"}=" HM2 25T";
$resn_exch{"3HM  25T"}=" HM3 25T"; $resn_exch{"1H10 26A"}="H101 26A"; $resn_exch{"2H10 26A"}="H102 26A";
$resn_exch{"3H10 26A"}="H103 26A"; $resn_exch{"1H9  26A"}=" H91 26A"; $resn_exch{"2H9  26A"}=" H92 26A";
$resn_exch{"3H9  26A"}=" H93 26A"; $resn_exch{" H1* 26A"}=" H1' 26A"; $resn_exch{" H4* 26A"}=" H4' 26A";
$resn_exch{"1H5* 26A"}="H5'1 26A"; $resn_exch{"2H5* 26A"}="H5'2 26A"; $resn_exch{" H5* 26A"}=" H5' 26A";
$resn_exch{" H2* 26A"}=" H2' 26A"; $resn_exch{"2HO* 26A"}="HO'2 26A"; $resn_exch{" H3* 26A"}=" H3' 26A";
$resn_exch{"3HO* 26A"}="HO'3 26A"; $resn_exch{"1HN1 26D"}="HN11 26D"; $resn_exch{"2HN1 26D"}="HN12 26D";
$resn_exch{"1HN2 26D"}="HN21 26D"; $resn_exch{"2HN2 26D"}="HN22 26D"; $resn_exch{"1HN2 26P"}="HN21 26P";
$resn_exch{"2HN2 26P"}="HN22 26P"; $resn_exch{"1H3  26P"}=" H31 26P"; $resn_exch{"2H3  26P"}=" H32 26P";
$resn_exch{"1H4  26P"}=" H41 26P"; $resn_exch{"2H4  26P"}=" H42 26P"; $resn_exch{"1H5  26P"}=" H51 26P";
$resn_exch{"2H5  26P"}=" H52 26P"; $resn_exch{"1H2  270"}=" H21 270"; $resn_exch{"2H2  270"}=" H22 270";
$resn_exch{"1H21 274"}="H211 274"; $resn_exch{"2H21 274"}="H212 274"; $resn_exch{"3H21 274"}="H213 274";
$resn_exch{"1H23 274"}="H231 274"; $resn_exch{"2H23 274"}="H232 274"; $resn_exch{"3H23 274"}="H233 274";
$resn_exch{"1H7C 274"}="H7C1 274"; $resn_exch{"2H7C 274"}="H7C2 274"; $resn_exch{"3H7C 274"}="H7C3 274";
$resn_exch{"1H24 274"}="H241 274"; $resn_exch{"2H24 274"}="H242 274"; $resn_exch{"1H27 274"}="H271 274";
$resn_exch{"2H27 274"}="H272 274"; $resn_exch{"1H28 274"}="H281 274"; $resn_exch{"2H28 274"}="H282 274";
$resn_exch{"3H28 274"}="H283 274"; $resn_exch{"1H26 274"}="H261 274"; $resn_exch{"2H26 274"}="H262 274";
$resn_exch{"1H25 274"}="H251 274"; $resn_exch{"2H25 274"}="H252 274"; $resn_exch{"1H13 276"}="H131 276";
$resn_exch{"2H13 276"}="H132 276"; $resn_exch{"3H13 276"}="H133 276"; $resn_exch{"1H1  277"}=" H11 277";
$resn_exch{"2H1  277"}=" H12 277"; $resn_exch{"1H2  277"}=" H21 277"; $resn_exch{"2H2  277"}=" H22 277";
$resn_exch{"1H4  277"}=" H41 277"; $resn_exch{"2H4  277"}=" H42 277"; $resn_exch{"1H5  277"}=" H51 277";
$resn_exch{"2H5  277"}=" H52 277"; $resn_exch{"1H23 277"}="H231 277"; $resn_exch{"2H23 277"}="H232 277";
$resn_exch{"3H23 277"}="H233 277"; $resn_exch{"1H27 277"}="H271 277"; $resn_exch{"2H27 277"}="H272 277";
$resn_exch{"3H27 277"}="H273 277"; $resn_exch{"1H33 277"}="H331 277"; $resn_exch{"2H33 277"}="H332 277";
$resn_exch{"1H35 277"}="H351 277"; $resn_exch{"2H35 277"}="H352 277"; $resn_exch{"3H35 277"}="H353 277";
$resn_exch{"1H42 277"}="H421 277"; $resn_exch{"2H42 277"}="H422 277"; $resn_exch{"1H44 277"}="H441 277";
$resn_exch{"2H44 277"}="H442 277"; $resn_exch{"1H45 277"}="H451 277"; $resn_exch{"2H45 277"}="H452 277";
$resn_exch{"1H30 281"}="H301 281"; $resn_exch{"2H30 281"}="H302 281"; $resn_exch{"3H30 281"}="H303 281";
$resn_exch{"1H29 281"}="H291 281"; $resn_exch{"2H29 281"}="H292 281"; $resn_exch{"3H29 281"}="H293 281";
$resn_exch{"1H15 281"}="H151 281"; $resn_exch{"2H15 281"}="H152 281"; $resn_exch{"1H9  281"}=" H91 281";
$resn_exch{"2H9  281"}=" H92 281"; $resn_exch{"1H10 281"}="H101 281"; $resn_exch{"2H10 281"}="H102 281";
$resn_exch{"1H5  283"}=" H51 283"; $resn_exch{"2H5  283"}=" H52 283"; $resn_exch{"1H6  283"}=" H61 283";
$resn_exch{"2H6  283"}=" H62 283"; $resn_exch{"3H6  283"}=" H63 283"; $resn_exch{"1H10 283"}="H101 283";
$resn_exch{"2H10 283"}="H102 283"; $resn_exch{"1H11 283"}="H111 283"; $resn_exch{"2H11 283"}="H112 283";
$resn_exch{"1H13 283"}="H131 283"; $resn_exch{"2H13 283"}="H132 283"; $resn_exch{"1H14 288"}="H141 288";
$resn_exch{"2H14 288"}="H142 288"; $resn_exch{"1H19 288"}="H191 288"; $resn_exch{"2H19 288"}="H192 288";
$resn_exch{"1H20 288"}="H201 288"; $resn_exch{"2H20 288"}="H202 288"; $resn_exch{"1H21 288"}="H211 288";
$resn_exch{"2H21 288"}="H212 288"; $resn_exch{"1H22 288"}="H221 288"; $resn_exch{"2H22 288"}="H222 288";
$resn_exch{"1H23 288"}="H231 288"; $resn_exch{"2H23 288"}="H232 288"; $resn_exch{"1H24 288"}="H241 288";
$resn_exch{"2H24 288"}="H242 288"; $resn_exch{"1H1C 292"}="H1C1 292"; $resn_exch{"2H1C 292"}="H1C2 292";
$resn_exch{"1H2C 292"}="H2C1 292"; $resn_exch{"2H2C 292"}="H2C2 292"; $resn_exch{"1H11 292"}="H111 292";
$resn_exch{"2H11 292"}="H112 292"; $resn_exch{"1H7  299"}=" H71 299"; $resn_exch{"2H7  299"}=" H72 299";
$resn_exch{"3H7  299"}=" H73 299"; $resn_exch{"1H10 2A6"}="H101 2A6"; $resn_exch{"2H10 2A6"}="H102 2A6";
$resn_exch{"1H12 2A6"}="H121 2A6"; $resn_exch{"2H12 2A6"}="H122 2A6"; $resn_exch{"1H13 2A6"}="H131 2A6";
$resn_exch{"2H13 2A6"}="H132 2A6"; $resn_exch{"1H14 2A6"}="H141 2A6"; $resn_exch{"2H14 2A6"}="H142 2A6";
$resn_exch{"1H15 2A6"}="H151 2A6"; $resn_exch{"2H15 2A6"}="H152 2A6"; $resn_exch{"1H16 2A6"}="H161 2A6";
$resn_exch{"2H16 2A6"}="H162 2A6"; $resn_exch{"1H13 2AA"}="H131 2AA"; $resn_exch{"2H13 2AA"}="H132 2AA";
$resn_exch{"3H13 2AA"}="H133 2AA"; $resn_exch{"1H12 2AA"}="H121 2AA"; $resn_exch{"2H12 2AA"}="H122 2AA";
$resn_exch{"3H12 2AA"}="H123 2AA"; $resn_exch{" H9* 2AA"}=" H9' 2AA"; $resn_exch{" H8* 2AA"}=" H8' 2AA";
$resn_exch{" H5* 2AA"}=" H5' 2AA"; $resn_exch{" H4* 2AA"}=" H4' 2AA"; $resn_exch{" H3* 2AA"}=" H3' 2AA";
$resn_exch{"1H1* 2AA"}="H1'1 2AA"; $resn_exch{"2H1* 2AA"}="H1'2 2AA"; $resn_exch{"1H9  2AA"}=" H91 2AA";
$resn_exch{"2H9  2AA"}=" H92 2AA"; $resn_exch{"1H14 2AA"}="H141 2AA"; $resn_exch{"2H14 2AA"}="H142 2AA";
$resn_exch{"1HN2 2AA"}="HN21 2AA"; $resn_exch{"2HN2 2AA"}="HN22 2AA"; $resn_exch{"1H1  2AB"}=" H11 2AB";
$resn_exch{"2H1  2AB"}="H12A 2AB"; $resn_exch{"1H2  2AB"}=" H21 2AB"; $resn_exch{"2H2  2AB"}=" H22 2AB";
$resn_exch{"1HN9 2AB"}="HN91 2AB"; $resn_exch{"2HN9 2AB"}="HN92 2AB"; $resn_exch{"1HN  2AC"}=" HN1 2AC";
$resn_exch{"2HN  2AC"}=" HN2 2AC"; $resn_exch{"1H8  2AC"}=" H81 2AC"; $resn_exch{"2H8  2AC"}=" H82 2AC";
$resn_exch{"3H8  2AC"}=" H83 2AC"; $resn_exch{" H5* 2AD"}=" H5' 2AD"; $resn_exch{"1H5* 2AD"}="H5'1 2AD";
$resn_exch{"2H5* 2AD"}="H5'2 2AD"; $resn_exch{" H4* 2AD"}=" H4' 2AD"; $resn_exch{" H3* 2AD"}=" H3' 2AD";
$resn_exch{" H2* 2AD"}=" H2' 2AD"; $resn_exch{" H1* 2AD"}=" H1' 2AD"; $resn_exch{"1H6N 2AD"}="H6N1 2AD";
$resn_exch{"2H6N 2AD"}="H6N2 2AD"; $resn_exch{"1HN  2AD"}=" HN1 2AD"; $resn_exch{"2HN  2AD"}=" HN2 2AD";
$resn_exch{"1HN  2AF"}=" HN1 2AF"; $resn_exch{"2HN  2AF"}=" HN2 2AF"; $resn_exch{"1H12 2AH"}="H121 2AH";
$resn_exch{"2H12 2AH"}="H122 2AH"; $resn_exch{"1H24 2AH"}="H241 2AH"; $resn_exch{"2H24 2AH"}="H242 2AH";
$resn_exch{"1H41 2AH"}="H411 2AH"; $resn_exch{"2H41 2AH"}="H412 2AH"; $resn_exch{"1H44 2AH"}="H441 2AH";
$resn_exch{"2H44 2AH"}="H442 2AH"; $resn_exch{"1H49 2AH"}="H491 2AH"; $resn_exch{"2H49 2AH"}="H492 2AH";
$resn_exch{"3H49 2AH"}="H493 2AH"; $resn_exch{"1H50 2AH"}="H501 2AH"; $resn_exch{"2H50 2AH"}="H502 2AH";
$resn_exch{"3H50 2AH"}="H503 2AH"; $resn_exch{"1H91 2AH"}="H911 2AH"; $resn_exch{"2H91 2AH"}="H912 2AH";
$resn_exch{"3H91 2AH"}="H913 2AH"; $resn_exch{"1H92 2AH"}="H921 2AH"; $resn_exch{"2H92 2AH"}="H922 2AH";
$resn_exch{"3H92 2AH"}="H923 2AH"; $resn_exch{"1HN1 2AL"}="HN11 2AL"; $resn_exch{"2HN1 2AL"}="HN12 2AL";
$resn_exch{"2HOP 2AM"}="HOP2 2AM"; $resn_exch{"3HOP 2AM"}="HOP3 2AM"; $resn_exch{"1H5* 2AM"}="H5'1 2AM";
$resn_exch{"2H5* 2AM"}="H5'2 2AM"; $resn_exch{"*HO5 2AM"}="HO5' 2AM"; $resn_exch{" H4* 2AM"}=" H4' 2AM";
$resn_exch{" H3* 2AM"}=" H3' 2AM"; $resn_exch{"*HO3 2AM"}="HO3' 2AM"; $resn_exch{" H2* 2AM"}=" H2' 2AM";
$resn_exch{" H1* 2AM"}=" H1' 2AM"; $resn_exch{"1HN6 2AM"}="HN61 2AM"; $resn_exch{"2HN6 2AM"}="HN62 2AM";
$resn_exch{" HN1 2AO"}=" H   2AO"; $resn_exch{" HN2 2AO"}=" H2  2AO"; $resn_exch{"HCB1 2AO"}=" HB2 2AO";
$resn_exch{"HCB2 2AO"}=" HB3 2AO"; $resn_exch{"HCG1 2AO"}=" HG2 2AO"; $resn_exch{"HCG2 2AO"}=" HG3 2AO";
$resn_exch{"HCD1 2AO"}=" HD2 2AO"; $resn_exch{"HCD2 2AO"}=" HD3 2AO"; $resn_exch{"HCE1 2AO"}=" HE1 2AO";
$resn_exch{"HCE2 2AO"}=" HE2 2AO"; $resn_exch{"HCE3 2AO"}=" HE3 2AO"; $resn_exch{"1HN  2AP"}="HN1A 2AP";
$resn_exch{"2HN  2AP"}=" HN2 2AP"; $resn_exch{"1HN1 2AQ"}="HN11 2AQ"; $resn_exch{"2HN1 2AQ"}="HN12 2AQ";
$resn_exch{"2HOP 2AR"}="HOP2 2AR"; $resn_exch{"3HOP 2AR"}="HOP3 2AR"; $resn_exch{"1H5* 2AR"}=" H5' 2AR";
$resn_exch{"2H5* 2AR"}="H5'' 2AR"; $resn_exch{" H4* 2AR"}=" H4' 2AR"; $resn_exch{"1HX* 2AR"}="HX'1 2AR";
$resn_exch{"2HX* 2AR"}="HX'2 2AR"; $resn_exch{" H1* 2AR"}=" H1' 2AR"; $resn_exch{"1H6  2AR"}=" H61 2AR";
$resn_exch{"2H6  2AR"}=" H62 2AR"; $resn_exch{"2H2* 2AR"}="H2'' 2AR"; $resn_exch{"1H2* 2AR"}=" H2' 2AR";
$resn_exch{" H3* 2AR"}=" H3' 2AR"; $resn_exch{"H3T  2AR"}="HO3' 2AR"; $resn_exch{"1HBB 2AS"}="HBB1 2AS";
$resn_exch{"2HBB 2AS"}="HBB2 2AS"; $resn_exch{"3HBB 2AS"}="HBB3 2AS"; $resn_exch{"2HOP 2AT"}="HOP2 2AT";
$resn_exch{"1H5* 2AT"}=" H5' 2AT"; $resn_exch{"2H5* 2AT"}="H5'' 2AT"; $resn_exch{" H4* 2AT"}=" H4' 2AT";
$resn_exch{" H1* 2AT"}=" H1' 2AT"; $resn_exch{"1H5M 2AT"}=" H71 2AT"; $resn_exch{"2H5M 2AT"}=" H72 2AT";
$resn_exch{"3H5M 2AT"}=" H73 2AT"; $resn_exch{" H2* 2AT"}=" H2' 2AT"; $resn_exch{"1HB' 2AT"}="HB'1 2AT";
$resn_exch{"2HB' 2AT"}="HB'2 2AT"; $resn_exch{"1HD' 2AT"}="HD'1 2AT"; $resn_exch{"2HD' 2AT"}="HD'2 2AT";
$resn_exch{" H3* 2AT"}=" H3' 2AT"; $resn_exch{"H3T  2AT"}="HO3' 2AT"; $resn_exch{"3HOP 2AT"}="HOP3 2AT";
$resn_exch{"1H5* 2AU"}=" H5' 2AU"; $resn_exch{"2H5* 2AU"}="H5'' 2AU"; $resn_exch{" H4* 2AU"}=" H4' 2AU";
$resn_exch{" H3* 2AU"}=" H3' 2AU"; $resn_exch{"H3T  2AU"}="HO3' 2AU"; $resn_exch{"1H2* 2AU"}=" H2' 2AU";
$resn_exch{" H1* 2AU"}=" H1' 2AU"; $resn_exch{"1HA  2AU"}=" HA1 2AU"; $resn_exch{"2H2* 2AU"}="H2'' 2AU";
$resn_exch{" O2P 2AU"}=" OP2 2AU"; $resn_exch{"2H1P 2AU"}="H2P1 2AU"; $resn_exch{"1H1  2AZ"}=" H11 2AZ";
$resn_exch{"2H1  2AZ"}=" H12 2AZ"; $resn_exch{"1H6  2AZ"}="H61A 2AZ"; $resn_exch{"2H6  2AZ"}=" H62 2AZ";
$resn_exch{"1H23 2AZ"}="H231 2AZ"; $resn_exch{"2H23 2AZ"}="H232 2AZ"; $resn_exch{"1H39 2AZ"}="H391 2AZ";
$resn_exch{"2H39 2AZ"}="H392 2AZ"; $resn_exch{"1H42 2AZ"}="H421 2AZ"; $resn_exch{"2H42 2AZ"}="H422 2AZ";
$resn_exch{"1H45 2AZ"}="H451 2AZ"; $resn_exch{"2H45 2AZ"}="H452 2AZ"; $resn_exch{"1H48 2AZ"}="H481 2AZ";
$resn_exch{"2H48 2AZ"}="H482 2AZ"; $resn_exch{"1H63 2AZ"}="H631 2AZ"; $resn_exch{"2H63 2AZ"}="H632 2AZ";
$resn_exch{"3H63 2AZ"}="H633 2AZ"; $resn_exch{" H5* 2BA"}=" H5' 2BA"; $resn_exch{"H5*A 2BA"}="H5'A 2BA";
$resn_exch{" H4* 2BA"}=" H4' 2BA"; $resn_exch{" H3* 2BA"}=" H3' 2BA"; $resn_exch{" H2* 2BA"}=" H2' 2BA";
$resn_exch{"HO2* 2BA"}="HO2' 2BA"; $resn_exch{" H1* 2BA"}=" H1' 2BA"; $resn_exch{"HC5* 2BA"}="HC5' 2BA";
$resn_exch{"HC4* 2BA"}="HC4' 2BA"; $resn_exch{"HC3* 2BA"}="HC3' 2BA"; $resn_exch{"HC2* 2BA"}="HC2' 2BA";
$resn_exch{"HC1* 2BA"}="HC1' 2BA"; $resn_exch{"2HOP 2BD"}="HOP2 2BD"; $resn_exch{"3HOP 2BD"}="HOP3 2BD";
$resn_exch{"1H5* 2BD"}=" H5' 2BD"; $resn_exch{"2H5* 2BD"}="H5'' 2BD"; $resn_exch{" H4* 2BD"}=" H4' 2BD";
$resn_exch{" H1* 2BD"}=" H1' 2BD"; $resn_exch{"2HAL 2BD"}="HAL2 2BD"; $resn_exch{"1HAM 2BD"}="HAM1 2BD";
$resn_exch{"2HAM 2BD"}="HAM2 2BD"; $resn_exch{"1HAO 2BD"}="HAO1 2BD"; $resn_exch{"2HAO 2BD"}="HAO2 2BD";
$resn_exch{"1H2* 2BD"}=" H2' 2BD"; $resn_exch{"2H2* 2BD"}="H2'' 2BD"; $resn_exch{" H3* 2BD"}=" H3' 2BD";
$resn_exch{"H3T  2BD"}="HO3' 2BD"; $resn_exch{"2HOP 2BF"}="HOP2 2BF"; $resn_exch{"3HOP 2BF"}="HOP3 2BF";
$resn_exch{"1H19 2BF"}="H191 2BF"; $resn_exch{"2H19 2BF"}="H192 2BF"; $resn_exch{"2HP1 2BH"}="HP12 2BH";
$resn_exch{"1HP1 2BH"}="HP11 2BH"; $resn_exch{"1H06 2BH"}="H061 2BH"; $resn_exch{"2H06 2BH"}="H062 2BH";
$resn_exch{"1H07 2BH"}="H071 2BH"; $resn_exch{"2H07 2BH"}="H072 2BH"; $resn_exch{"1HD  2BL"}=" HD1 2BL";
$resn_exch{"2HD  2BL"}=" HD2 2BL"; $resn_exch{"1HE  2BL"}=" HE1 2BL"; $resn_exch{"2HE  2BL"}=" HE2 2BL";
$resn_exch{"3HE  2BL"}=" HE3 2BL"; $resn_exch{"1HJ  2BL"}=" HJ1 2BL"; $resn_exch{"2HJ  2BL"}=" HJ2 2BL";
$resn_exch{"3HJ  2BL"}=" HJ3 2BL"; $resn_exch{"1HC4 2BN"}="HC41 2BN"; $resn_exch{"2HC4 2BN"}="HC42 2BN";
$resn_exch{"1HC6 2BN"}="HC61 2BN"; $resn_exch{"2HC6 2BN"}="HC62 2BN"; $resn_exch{"1HC7 2BN"}="HC71 2BN";
$resn_exch{"2HC7 2BN"}="HC72 2BN"; $resn_exch{"1HC9 2BN"}="HC91 2BN"; $resn_exch{"2HC9 2BN"}="HC92 2BN";
$resn_exch{"3HC9 2BN"}="HC93 2BN"; $resn_exch{"1H10 2BN"}="H101 2BN"; $resn_exch{"2H10 2BN"}="H102 2BN";
$resn_exch{"3H10 2BN"}="H103 2BN"; $resn_exch{"1H11 2BN"}="H111 2BN"; $resn_exch{"2H11 2BN"}="H112 2BN";
$resn_exch{"3H11 2BN"}="H113 2BN"; $resn_exch{"3HOP 2BT"}="HOP3 2BT"; $resn_exch{"2HOP 2BT"}="HOP2 2BT";
$resn_exch{"1H5* 2BT"}=" H5' 2BT"; $resn_exch{"2H5* 2BT"}="H5'' 2BT"; $resn_exch{" H4* 2BT"}=" H4' 2BT";
$resn_exch{" H1* 2BT"}=" H1' 2BT"; $resn_exch{"1H5M 2BT"}=" H71 2BT"; $resn_exch{"2H5M 2BT"}=" H72 2BT";
$resn_exch{"3H5M 2BT"}=" H73 2BT"; $resn_exch{" H2* 2BT"}=" H2' 2BT"; $resn_exch{"1HA* 2BT"}="HA'1 2BT";
$resn_exch{"2HA* 2BT"}="HA'2 2BT"; $resn_exch{"1HB* 2BT"}="HB'1 2BT"; $resn_exch{"2HB* 2BT"}="HB'2 2BT";
$resn_exch{"1HC* 2BT"}="HC'1 2BT"; $resn_exch{"2HC* 2BT"}="HC'2 2BT"; $resn_exch{" H3* 2BT"}=" H3' 2BT";
$resn_exch{"H3T  2BT"}="HO3' 2BT"; $resn_exch{"1HD* 2BT"}="HD'1 2BT"; $resn_exch{"2HD* 2BT"}="HD'2 2BT";
$resn_exch{"3HD* 2BT"}="HD'3 2BT"; $resn_exch{"2HOP 2BU"}="HOP2 2BU"; $resn_exch{"3HOP 2BU"}="HOP3 2BU";
$resn_exch{" H5* 2BU"}=" H5' 2BU"; $resn_exch{"H5** 2BU"}="H5'' 2BU"; $resn_exch{" H4* 2BU"}=" H4' 2BU";
$resn_exch{" H1* 2BU"}=" H1' 2BU"; $resn_exch{" H2* 2BU"}=" H2' 2BU"; $resn_exch{"H2** 2BU"}="H2'' 2BU";
$resn_exch{" H3* 2BU"}=" H3' 2BU"; $resn_exch{"H3T  2BU"}="HO3' 2BU"; $resn_exch{"1HC1 2C5"}="HC11 2C5";
$resn_exch{"2HC1 2C5"}="HC12 2C5"; $resn_exch{"1H15 2C5"}="H151 2C5"; $resn_exch{"2H15 2C5"}="H152 2C5";
$resn_exch{"3H15 2C5"}="H153 2C5"; $resn_exch{"1H10 2CA"}="H101 2CA"; $resn_exch{"2H10 2CA"}="H102 2CA";
$resn_exch{"1H12 2CA"}="H121 2CA"; $resn_exch{"2H12 2CA"}="H122 2CA"; $resn_exch{"3H12 2CA"}="H123 2CA";
$resn_exch{"1H13 2CA"}="H131 2CA"; $resn_exch{"2H13 2CA"}="H132 2CA"; $resn_exch{"3H13 2CA"}="H133 2CA";
$resn_exch{"1H02 2CA"}="H021 2CA"; $resn_exch{"2H02 2CA"}="H022 2CA"; $resn_exch{"1H03 2CA"}="H031 2CA";
$resn_exch{"2H03 2CA"}="H032 2CA"; $resn_exch{"1H04 2CA"}="H041 2CA"; $resn_exch{"2H04 2CA"}="H042 2CA";
$resn_exch{"1H06 2CA"}="H061 2CA"; $resn_exch{"2H06 2CA"}="H062 2CA"; $resn_exch{"1H9C 2CE"}="H9C1 2CE";
$resn_exch{"2H9C 2CE"}="H9C2 2CE"; $resn_exch{"1H14 2CE"}="H141 2CE"; $resn_exch{"2H14 2CE"}="H142 2CE";
$resn_exch{"1H24 2CE"}="H241 2CE"; $resn_exch{"2H24 2CE"}="H242 2CE"; $resn_exch{"1H28 2CE"}="H281 2CE";
$resn_exch{"2H28 2CE"}="H282 2CE"; $resn_exch{"1H29 2CE"}="H291 2CE"; $resn_exch{"2H29 2CE"}="H292 2CE";
$resn_exch{"1H31 2CE"}="H311 2CE"; $resn_exch{"2H31 2CE"}="H312 2CE"; $resn_exch{"1H32 2CE"}="H321 2CE";
$resn_exch{"2H32 2CE"}="H322 2CE"; $resn_exch{"1H34 2CE"}="H341 2CE"; $resn_exch{"2H34 2CE"}="H342 2CE";
$resn_exch{"1H37 2CE"}="H371 2CE"; $resn_exch{"2H37 2CE"}="H372 2CE"; $resn_exch{"1HN  2CG"}=" HN1 2CG";
$resn_exch{"2HN  2CG"}=" HN2 2CG"; $resn_exch{"1H7  2CL"}=" H71 2CL"; $resn_exch{"2H7  2CL"}=" H72 2CL";
$resn_exch{"1HN4 2CM"}="HN41 2CM"; $resn_exch{"2HN4 2CM"}="HN42 2CM"; $resn_exch{"1HC6 2CM"}="HC61 2CM";
$resn_exch{"2HC6 2CM"}="HC62 2CM"; $resn_exch{"3HC6 2CM"}="HC63 2CM"; $resn_exch{"1H6  2CP"}=" H61 2CP";
$resn_exch{"2H6  2CP"}=" H62 2CP"; $resn_exch{"2HO' 2CP"}="HO'2 2CP"; $resn_exch{"1H5' 2CP"}="H5'1 2CP";
$resn_exch{"2H5' 2CP"}="H5'2 2CP"; $resn_exch{"1HB  2CP"}=" HB1 2CP"; $resn_exch{"2HB  2CP"}=" HB2 2CP";
$resn_exch{"1HP9 2CP"}="HP91 2CP"; $resn_exch{"2HP9 2CP"}="HP92 2CP"; $resn_exch{"3HP9 2CP"}="HP93 2CP";
$resn_exch{"1HP8 2CP"}="HP81 2CP"; $resn_exch{"2HP8 2CP"}="HP82 2CP"; $resn_exch{"3HP8 2CP"}="HP83 2CP";
$resn_exch{"3HOP 2CP"}="HOP3 2CP"; $resn_exch{"1HP5 2CP"}="HP51 2CP"; $resn_exch{"2HP5 2CP"}="HP52 2CP";
$resn_exch{"1HP4 2CP"}="HP41 2CP"; $resn_exch{"2HP4 2CP"}="HP42 2CP"; $resn_exch{"1HP2 2CP"}="HP21 2CP";
$resn_exch{"2HP2 2CP"}="HP22 2CP"; $resn_exch{"1HP1 2CP"}="HP11 2CP"; $resn_exch{"2HP1 2CP"}="HP12 2CP";
$resn_exch{"1HS1 2CP"}="HS11 2CP"; $resn_exch{"2HS1 2CP"}="HS12 2CP"; $resn_exch{"1HS3 2CP"}="HS31 2CP";
$resn_exch{"2HS3 2CP"}="HS32 2CP"; $resn_exch{"3HS3 2CP"}="HS33 2CP"; $resn_exch{"5HOS 2CP"}="HOS5 2CP";
$resn_exch{"1H1  2CS"}=" H11 2CS"; $resn_exch{"2H1  2CS"}="H12A 2CS"; $resn_exch{"3H1  2CS"}="H13A 2CS";
$resn_exch{"1H7  2CS"}=" H71 2CS"; $resn_exch{"2H7  2CS"}=" H72 2CS"; $resn_exch{"1H10 2CS"}="H101 2CS";
$resn_exch{"2H10 2CS"}="H102 2CS"; $resn_exch{"1H25 2CS"}="H251 2CS"; $resn_exch{"2H25 2CS"}="H252 2CS";
$resn_exch{"1H41 2CS"}="H411 2CS"; $resn_exch{"2H41 2CS"}="H412 2CS"; $resn_exch{"3H41 2CS"}="H413 2CS";
$resn_exch{"1H39 2CS"}="H391 2CS"; $resn_exch{"2H39 2CS"}="H392 2CS"; $resn_exch{"3H39 2CS"}="H393 2CS";
$resn_exch{"1H40 2CS"}="H401 2CS"; $resn_exch{"2H40 2CS"}="H402 2CS"; $resn_exch{"3H40 2CS"}="H403 2CS";
$resn_exch{"1H6  2CS"}=" H61 2CS"; $resn_exch{"2H6  2CS"}=" H62 2CS"; $resn_exch{"3H6  2CS"}=" H63 2CS";
$resn_exch{"1H18 2D7"}="H181 2D7"; $resn_exch{"2H18 2D7"}="H182 2D7"; $resn_exch{"3H18 2D7"}="H183 2D7";
$resn_exch{"1H31 2D9"}="H311 2D9"; $resn_exch{"2H31 2D9"}="H312 2D9"; $resn_exch{"3H31 2D9"}="H313 2D9";
$resn_exch{"1H18 2D9"}="H181 2D9"; $resn_exch{"2H18 2D9"}="H182 2D9"; $resn_exch{"1H16 2D9"}="H161 2D9";
$resn_exch{"2H16 2D9"}="H162 2D9"; $resn_exch{"1H17 2D9"}="H171 2D9"; $resn_exch{"2H17 2D9"}="H172 2D9";
$resn_exch{"1H14 2D9"}="H141 2D9"; $resn_exch{"2H14 2D9"}="H142 2D9"; $resn_exch{"1H13 2D9"}="H131 2D9";
$resn_exch{"2H13 2D9"}="H132 2D9"; $resn_exch{"2HOP 2DA"}="HOP2 2DA"; $resn_exch{"3HOP 2DA"}="HOP3 2DA";
$resn_exch{"1H5* 2DA"}=" H5' 2DA"; $resn_exch{"2H5* 2DA"}="H5'' 2DA"; $resn_exch{" H4* 2DA"}=" H4' 2DA";
$resn_exch{"1H3* 2DA"}="H3'1 2DA"; $resn_exch{"2H3* 2DA"}="H3'2 2DA"; $resn_exch{"1H2* 2DA"}=" H2' 2DA";
$resn_exch{"2H2* 2DA"}="H2'' 2DA"; $resn_exch{" H1* 2DA"}=" H1' 2DA"; $resn_exch{"1HN6 2DA"}="HN61 2DA";
$resn_exch{"2HN6 2DA"}="HN62 2DA"; $resn_exch{"1H1  2DB"}=" H11 2DB"; $resn_exch{"2H1  2DB"}=" H12 2DB";
$resn_exch{"1H3  2DB"}=" H31 2DB"; $resn_exch{"2H3  2DB"}=" H32 2DB"; $resn_exch{"1H17 2DD"}="H171 2DD";
$resn_exch{"2H17 2DD"}="H172 2DD"; $resn_exch{"1H4N 2DD"}="H4N1 2DD"; $resn_exch{"2H4N 2DD"}="H4N2 2DD";
$resn_exch{"2HOP 2DF"}="HOP2 2DF"; $resn_exch{"3HOP 2DF"}="HOP3 2DF"; $resn_exch{"1H5* 2DF"}="H5'1 2DF";
$resn_exch{"2H5* 2DF"}="H5'2 2DF"; $resn_exch{" H4* 2DF"}=" H4' 2DF"; $resn_exch{" H1* 2DF"}=" H1' 2DF";
$resn_exch{" H3* 2DF"}=" H3' 2DF"; $resn_exch{"1H2* 2DF"}="H2'1 2DF"; $resn_exch{"2H2* 2DF"}="H2'2 2DF";
$resn_exch{"1H2  2DG"}=" H21 2DG"; $resn_exch{"2H2  2DG"}=" H22 2DG"; $resn_exch{"1H6  2DG"}=" H61 2DG";
$resn_exch{"2H6  2DG"}=" H62 2DG"; $resn_exch{"1H5* 2DI"}="H5'1 2DI"; $resn_exch{"2H5* 2DI"}="H5'2 2DI";
$resn_exch{" H5* 2DI"}=" H5' 2DI"; $resn_exch{" H4* 2DI"}=" H4' 2DI"; $resn_exch{" H1* 2DI"}=" H1' 2DI";
$resn_exch{"1H2* 2DI"}="H2'1 2DI"; $resn_exch{"2H2* 2DI"}="H2'2 2DI"; $resn_exch{"1H3* 2DI"}="H3'1 2DI";
$resn_exch{"2H3* 2DI"}="H3'2 2DI"; $resn_exch{"2HOP 2DM"}="HOP2 2DM"; $resn_exch{"H3T  2DM"}="HO3' 2DM";
$resn_exch{"3HOP 2DM"}="HOP3 2DM"; $resn_exch{"1HN  2DO"}=" H   2DO"; $resn_exch{"2HN  2DO"}=" H2  2DO";
$resn_exch{" H   2DO"}=" HC  2DO"; $resn_exch{"1HCB 2DO"}=" HB2 2DO"; $resn_exch{"2HCB 2DO"}=" HB3 2DO";
$resn_exch{"1HCG 2DO"}=" HG2 2DO"; $resn_exch{"2HCG 2DO"}=" HG3 2DO"; $resn_exch{"1HCD 2DO"}=" HD2 2DO";
$resn_exch{"2HCD 2DO"}=" HD3 2DO"; $resn_exch{"1HCE 2DO"}=" HE1 2DO"; $resn_exch{"2HCE 2DO"}=" HE2 2DO";
$resn_exch{"3HCE 2DO"}=" HE3 2DO"; $resn_exch{"1H1  2DP"}=" H11 2DP"; $resn_exch{"2H1  2DP"}=" H12 2DP";
$resn_exch{"1H3  2DP"}=" H31 2DP"; $resn_exch{"2H3  2DP"}=" H32 2DP"; $resn_exch{"1H4  2DP"}=" H41 2DP";
$resn_exch{"2H4  2DP"}=" H42 2DP"; $resn_exch{"1H6  2DP"}=" H61 2DP"; $resn_exch{"2H6  2DP"}=" H62 2DP";
$resn_exch{"1H11 2DP"}="H111 2DP"; $resn_exch{"2H11 2DP"}="H112 2DP"; $resn_exch{"1H12 2DP"}="H121 2DP";
$resn_exch{"2H12 2DP"}="H122 2DP"; $resn_exch{"1H14 2DP"}="H141 2DP"; $resn_exch{"2H14 2DP"}="H142 2DP";
$resn_exch{"3H14 2DP"}="H143 2DP"; $resn_exch{"1H15 2DP"}="H151 2DP"; $resn_exch{"2H15 2DP"}="H152 2DP";
$resn_exch{"1H16 2DP"}="H161 2DP"; $resn_exch{"2H16 2DP"}="H162 2DP"; $resn_exch{"1H17 2DP"}="H171 2DP";
$resn_exch{"2H17 2DP"}="H172 2DP"; $resn_exch{"1H19 2DP"}="H191 2DP"; $resn_exch{"2H19 2DP"}="H192 2DP";
$resn_exch{"3H19 2DP"}="H193 2DP"; $resn_exch{"1H20 2DP"}="H201 2DP"; $resn_exch{"2H20 2DP"}="H202 2DP";
$resn_exch{"1H21 2DP"}="H211 2DP"; $resn_exch{"2H21 2DP"}="H212 2DP"; $resn_exch{"1H22 2DP"}="H221 2DP";
$resn_exch{"2H22 2DP"}="H222 2DP"; $resn_exch{"1H24 2DP"}="H241 2DP"; $resn_exch{"2H24 2DP"}="H242 2DP";
$resn_exch{"3H24 2DP"}="H243 2DP"; $resn_exch{"1H25 2DP"}="H251 2DP"; $resn_exch{"2H25 2DP"}="H252 2DP";
$resn_exch{"1H26 2DP"}="H261 2DP"; $resn_exch{"2H26 2DP"}="H262 2DP"; $resn_exch{"1H27 2DP"}="H271 2DP";
$resn_exch{"2H27 2DP"}="H272 2DP"; $resn_exch{"1H29 2DP"}="H291 2DP"; $resn_exch{"2H29 2DP"}="H292 2DP";
$resn_exch{"3H29 2DP"}="H293 2DP"; $resn_exch{"1H30 2DP"}="H301 2DP"; $resn_exch{"2H30 2DP"}="H302 2DP";
$resn_exch{"3H30 2DP"}="H303 2DP"; $resn_exch{"1H41 2DP"}="H411 2DP"; $resn_exch{"2H41 2DP"}="H412 2DP";
$resn_exch{"1H42 2DP"}="H421 2DP"; $resn_exch{"2H42 2DP"}="H422 2DP"; $resn_exch{"1H44 2DP"}="H441 2DP";
$resn_exch{"2H44 2DP"}="H442 2DP"; $resn_exch{"3H44 2DP"}="H443 2DP"; $resn_exch{"1H45 2DP"}="H451 2DP";
$resn_exch{"2H45 2DP"}="H452 2DP"; $resn_exch{"1H46 2DP"}="H461 2DP"; $resn_exch{"2H46 2DP"}="H462 2DP";
$resn_exch{"1H47 2DP"}="H471 2DP"; $resn_exch{"2H47 2DP"}="H472 2DP"; $resn_exch{"1H49 2DP"}="H491 2DP";
$resn_exch{"2H49 2DP"}="H492 2DP"; $resn_exch{"3H49 2DP"}="H493 2DP"; $resn_exch{"1H50 2DP"}="H501 2DP";
$resn_exch{"2H50 2DP"}="H502 2DP"; $resn_exch{"1H51 2DP"}="H511 2DP"; $resn_exch{"2H51 2DP"}="H512 2DP";
$resn_exch{"1H52 2DP"}="H521 2DP"; $resn_exch{"2H52 2DP"}="H522 2DP"; $resn_exch{"1H54 2DP"}="H541 2DP";
$resn_exch{"2H54 2DP"}="H542 2DP"; $resn_exch{"3H54 2DP"}="H543 2DP"; $resn_exch{"1H55 2DP"}="H551 2DP";
$resn_exch{"2H55 2DP"}="H552 2DP"; $resn_exch{"1H56 2DP"}="H561 2DP"; $resn_exch{"2H56 2DP"}="H562 2DP";
$resn_exch{"1H57 2DP"}="H571 2DP"; $resn_exch{"2H57 2DP"}="H572 2DP"; $resn_exch{"1H59 2DP"}="H591 2DP";
$resn_exch{"2H59 2DP"}="H592 2DP"; $resn_exch{"3H59 2DP"}="H593 2DP"; $resn_exch{"1H60 2DP"}="H601 2DP";
$resn_exch{"2H60 2DP"}="H602 2DP"; $resn_exch{"3H60 2DP"}="H603 2DP"; $resn_exch{"1HM  2DP"}=" HM1 2DP";
$resn_exch{"2HM  2DP"}=" HM2 2DP"; $resn_exch{"3HM  2DP"}=" HM3 2DP"; $resn_exch{"2HOP 2DT"}="HOP2 2DT";
$resn_exch{"3HOP 2DT"}="HOP3 2DT"; $resn_exch{"1H5M 2DT"}=" H71 2DT"; $resn_exch{"2H5M 2DT"}=" H72 2DT";
$resn_exch{"3H5M 2DT"}=" H73 2DT"; $resn_exch{"1H2* 2DT"}=" H2' 2DT"; $resn_exch{"2H2* 2DT"}="H2'' 2DT";
$resn_exch{"1H5* 2DT"}=" H5' 2DT"; $resn_exch{"2H5* 2DT"}="H5'' 2DT"; $resn_exch{" H4* 2DT"}=" H4' 2DT";
$resn_exch{" H1* 2DT"}=" H1' 2DT"; $resn_exch{"1H3* 2DT"}="H3'1 2DT"; $resn_exch{"2H3* 2DT"}="H3'2 2DT";
$resn_exch{"1H19 2E1"}="H191 2E1"; $resn_exch{"2H19 2E1"}="H192 2E1"; $resn_exch{"1H20 2E1"}="H201 2E1";
$resn_exch{"2H20 2E1"}="H202 2E1"; $resn_exch{"1H17 2E1"}="H171 2E1"; $resn_exch{"2H17 2E1"}="H172 2E1";
$resn_exch{"1H16 2E1"}="H161 2E1"; $resn_exch{"2H16 2E1"}="H162 2E1"; $resn_exch{"1H26 2E1"}="H261 2E1";
$resn_exch{"2H26 2E1"}="H262 2E1"; $resn_exch{"1H27 2E1"}="H271 2E1"; $resn_exch{"2H27 2E1"}="H272 2E1";
$resn_exch{"3H27 2E1"}="H273 2E1"; $resn_exch{"1H24 2EA"}="H241 2EA"; $resn_exch{"2H24 2EA"}="H242 2EA";
$resn_exch{"1H25 2EA"}="H251 2EA"; $resn_exch{"2H25 2EA"}="H252 2EA"; $resn_exch{"1HN4 2EA"}="HN41 2EA";
$resn_exch{"2HN4 2EA"}="HN42 2EA"; $resn_exch{"1H5* 2EG"}=" H5' 2EG"; $resn_exch{"2H5* 2EG"}="H5'' 2EG";
$resn_exch{" H4* 2EG"}=" H4' 2EG"; $resn_exch{" H3* 2EG"}=" H3' 2EG"; $resn_exch{"1H2* 2EG"}=" H2' 2EG";
$resn_exch{"2H2* 2EG"}="H2'' 2EG"; $resn_exch{" H1* 2EG"}=" H1' 2EG"; $resn_exch{"1H2  2EG"}=" H21 2EG";
$resn_exch{"1H21 2EG"}="H211 2EG"; $resn_exch{"2H21 2EG"}="H212 2EG"; $resn_exch{"1H22 2EG"}="H221 2EG";
$resn_exch{"2H22 2EG"}="H222 2EG"; $resn_exch{"3H22 2EG"}="H223 2EG"; $resn_exch{"1H3  2EP"}=" H31 2EP";
$resn_exch{"2H3  2EP"}=" H32 2EP"; $resn_exch{"1H4  2EP"}=" H41 2EP"; $resn_exch{"2H4  2EP"}=" H42 2EP";
$resn_exch{"1H5  2EP"}=" H51 2EP"; $resn_exch{"2H5  2EP"}=" H52 2EP"; $resn_exch{"1H6  2EP"}=" H61 2EP";
$resn_exch{"2H6  2EP"}=" H62 2EP"; $resn_exch{"1H1' 2EP"}="H1'1 2EP"; $resn_exch{"2H1' 2EP"}="H1'2 2EP";
$resn_exch{"1H2' 2EP"}="H2'1 2EP"; $resn_exch{"2H2' 2EP"}="H2'2 2EP"; $resn_exch{"3H2' 2EP"}="H2'3 2EP";
$resn_exch{"1H20 2EQ"}="H201 2EQ"; $resn_exch{"2H20 2EQ"}="H202 2EQ"; $resn_exch{"1H21 2EQ"}="H211 2EQ";
$resn_exch{"2H21 2EQ"}="H212 2EQ"; $resn_exch{"1H22 2EQ"}="H221 2EQ"; $resn_exch{"2H22 2EQ"}="H222 2EQ";
$resn_exch{"1H23 2EQ"}="H231 2EQ"; $resn_exch{"2H23 2EQ"}="H232 2EQ"; $resn_exch{"1H19 2EQ"}="H191 2EQ";
$resn_exch{"2H19 2EQ"}="H192 2EQ"; $resn_exch{"1H11 2EQ"}="H111 2EQ"; $resn_exch{"2H11 2EQ"}="H112 2EQ";
$resn_exch{"1H12 2EQ"}="H121 2EQ"; $resn_exch{"2H12 2EQ"}="H122 2EQ"; $resn_exch{"3H12 2EQ"}="H123 2EQ";
$resn_exch{"1H6  2EZ"}=" H61 2EZ"; $resn_exch{"2H6  2EZ"}=" H62 2EZ"; $resn_exch{"1H7  2EZ"}=" H71 2EZ";
$resn_exch{"2H7  2EZ"}=" H72 2EZ"; $resn_exch{"3H7  2EZ"}=" H73 2EZ"; $resn_exch{"1H5' 2FA"}="H5'1 2FA";
$resn_exch{"2H5' 2FA"}="H5'2 2FA"; $resn_exch{"1HN6 2FA"}="HN61 2FA"; $resn_exch{"2HN6 2FA"}="HN62 2FA";
$resn_exch{"1H5' 2FD"}="H5'1 2FD"; $resn_exch{"2H5' 2FD"}="H5'2 2FD"; $resn_exch{"1HN6 2FD"}="HN61 2FD";
$resn_exch{"2HN6 2FD"}="HN62 2FD"; $resn_exch{"1H2' 2FD"}="H2'1 2FD"; $resn_exch{"2H2' 2FD"}="H2'2 2FD";
$resn_exch{"1H6  2FG"}=" H61 2FG"; $resn_exch{"2H6  2FG"}=" H62 2FG"; $resn_exch{"1HAA 2FH"}="HAA1 2FH";
$resn_exch{"2HAA 2FH"}="HAA2 2FH"; $resn_exch{"1HBA 2FH"}="HBA1 2FH"; $resn_exch{"2HBA 2FH"}="HBA2 2FH";
$resn_exch{"1HMA 2FH"}="HMA1 2FH"; $resn_exch{"2HMA 2FH"}="HMA2 2FH"; $resn_exch{"3HMA 2FH"}="HMA3 2FH";
$resn_exch{"1HMB 2FH"}="HMB1 2FH"; $resn_exch{"2HMB 2FH"}="HMB2 2FH"; $resn_exch{"3HMB 2FH"}="HMB3 2FH";
$resn_exch{"1HBB 2FH"}="HBB1 2FH"; $resn_exch{"2HBB 2FH"}="HBB2 2FH"; $resn_exch{"1HMC 2FH"}="HMC1 2FH";
$resn_exch{"2HMC 2FH"}="HMC2 2FH"; $resn_exch{"3HMC 2FH"}="HMC3 2FH"; $resn_exch{"1HBC 2FH"}="HBC1 2FH";
$resn_exch{"2HBC 2FH"}="HBC2 2FH"; $resn_exch{"1HMD 2FH"}="HMD1 2FH"; $resn_exch{"2HMD 2FH"}="HMD2 2FH";
$resn_exch{"3HMD 2FH"}="HMD3 2FH"; $resn_exch{"1HAD 2FH"}="HAD1 2FH"; $resn_exch{"2HAD 2FH"}="HAD2 2FH";
$resn_exch{"1HBD 2FH"}="HBD1 2FH"; $resn_exch{"2HBD 2FH"}="HBD2 2FH"; $resn_exch{"1H6  2FL"}=" H61 2FL";
$resn_exch{"2H6  2FL"}=" H62 2FL"; $resn_exch{"1H6' 2FL"}="H6'1 2FL"; $resn_exch{"2H6' 2FL"}="H6'2 2FL";
$resn_exch{"'HO1 2FL"}="HO1' 2FL"; $resn_exch{"'HO2 2FL"}="HO2' 2FL"; $resn_exch{"'HO3 2FL"}="HO3' 2FL";
$resn_exch{"'HO6 2FL"}="HO6' 2FL"; $resn_exch{"1HN  2FM"}=" HN1 2FM"; $resn_exch{"2HN  2FM"}=" HN2 2FM";
$resn_exch{"1HB  2FM"}=" HB1 2FM"; $resn_exch{"2HB  2FM"}=" HB2 2FM"; $resn_exch{"1HG  2FM"}=" HG1 2FM";
$resn_exch{"2HG  2FM"}=" HG2 2FM"; $resn_exch{"1H1  2FP"}=" H11 2FP"; $resn_exch{"2H1  2FP"}=" H12 2FP";
$resn_exch{"1H6  2FP"}=" H61 2FP"; $resn_exch{"2H6  2FP"}="H62A 2FP"; $resn_exch{"1H22 2GG"}="H221 2GG";
$resn_exch{"2H22 2GG"}="H222 2GG"; $resn_exch{"3H22 2GG"}="H223 2GG"; $resn_exch{"1H26 2GG"}="H261 2GG";
$resn_exch{"2H26 2GG"}="H262 2GG"; $resn_exch{"1H27 2GG"}="H271 2GG"; $resn_exch{"2H27 2GG"}="H272 2GG";
$resn_exch{"3H27 2GG"}="H273 2GG"; $resn_exch{"1H25 2GJ"}="H251 2GJ"; $resn_exch{"2H25 2GJ"}="H252 2GJ";
$resn_exch{"1H26 2GJ"}="H261 2GJ"; $resn_exch{"2H26 2GJ"}="H262 2GJ"; $resn_exch{"1H28 2GJ"}="H281 2GJ";
$resn_exch{"2H28 2GJ"}="H282 2GJ"; $resn_exch{"1H29 2GJ"}="H291 2GJ"; $resn_exch{"2H29 2GJ"}="H292 2GJ";
$resn_exch{"1H23 2GJ"}="H231 2GJ"; $resn_exch{"2H23 2GJ"}="H232 2GJ"; $resn_exch{"1H11 2GJ"}="H111 2GJ";
$resn_exch{"2H11 2GJ"}="H112 2GJ"; $resn_exch{"1H12 2GJ"}="H121 2GJ"; $resn_exch{"2H12 2GJ"}="H122 2GJ";
$resn_exch{"3H12 2GJ"}="H123 2GJ"; $resn_exch{"1H32 2GJ"}="H321 2GJ"; $resn_exch{"2H32 2GJ"}="H322 2GJ";
$resn_exch{"3H32 2GJ"}="H323 2GJ"; $resn_exch{"1H31 2GJ"}="H311 2GJ"; $resn_exch{"2H31 2GJ"}="H312 2GJ";
$resn_exch{"3H31 2GJ"}="H313 2GJ"; $resn_exch{"1H2  2GL"}=" H21 2GL"; $resn_exch{"2H2  2GL"}=" H22 2GL";
$resn_exch{"1H6  2GL"}=" H61 2GL"; $resn_exch{"2H6  2GL"}=" H62 2GL"; $resn_exch{"3H6  2GL"}=" H63 2GL";
$resn_exch{"2HOP 2GP"}="HOP2 2GP"; $resn_exch{"3HOP 2GP"}="HOP3 2GP"; $resn_exch{"*HO5 2GP"}="HO5' 2GP";
$resn_exch{"1H5* 2GP"}="H5'1 2GP"; $resn_exch{"2H5* 2GP"}="H5'2 2GP"; $resn_exch{" H4* 2GP"}=" H4' 2GP";
$resn_exch{" H3* 2GP"}=" H3' 2GP"; $resn_exch{"*HO3 2GP"}="HO3' 2GP"; $resn_exch{" H2* 2GP"}=" H2' 2GP";
$resn_exch{" H1* 2GP"}=" H1' 2GP"; $resn_exch{"1HN2 2GP"}="HN21 2GP"; $resn_exch{"2HN2 2GP"}="HN22 2GP";
$resn_exch{"1H6  2GS"}=" H61 2GS"; $resn_exch{"2H6  2GS"}=" H62 2GS"; $resn_exch{"1H7  2GS"}=" H71 2GS";
$resn_exch{"2H7  2GS"}=" H72 2GS"; $resn_exch{"3H7  2GS"}=" H73 2GS"; $resn_exch{"2HOP 2GT"}="HOP2 2GT";
$resn_exch{"1H5* 2GT"}=" H5' 2GT"; $resn_exch{"2H5* 2GT"}="H5'' 2GT"; $resn_exch{" H4* 2GT"}=" H4' 2GT";
$resn_exch{" H1* 2GT"}=" H1' 2GT"; $resn_exch{"1H5M 2GT"}=" H71 2GT"; $resn_exch{"2H5M 2GT"}=" H72 2GT";
$resn_exch{"3H5M 2GT"}=" H73 2GT"; $resn_exch{" H2* 2GT"}=" H2' 2GT"; $resn_exch{"1HB' 2GT"}="HB'1 2GT";
$resn_exch{"2HB' 2GT"}="HB'2 2GT"; $resn_exch{" H3* 2GT"}=" H3' 2GT"; $resn_exch{"H3T  2GT"}="HO3' 2GT";
$resn_exch{"3HOP 2GT"}="HOP3 2GT"; $resn_exch{"1H1C 2HA"}="H1C1 2HA"; $resn_exch{"2H1C 2HA"}="H1C2 2HA";
$resn_exch{"1H3C 2HA"}="H3C1 2HA"; $resn_exch{"2H3C 2HA"}="H3C2 2HA"; $resn_exch{"1H6  2HR"}=" H61 2HR";
$resn_exch{"2H6  2HR"}=" H62 2HR"; $resn_exch{"3H6  2HR"}=" H63 2HR"; $resn_exch{"1H5  2HR"}=" H51 2HR";
$resn_exch{"2H5  2HR"}=" H52 2HR"; $resn_exch{"1H4  2HR"}=" H41 2HR"; $resn_exch{"2H4  2HR"}=" H42 2HR";
$resn_exch{"1H3  2HR"}=" H31 2HR"; $resn_exch{"2H3  2HR"}=" H32 2HR"; $resn_exch{"1H2  2HR"}=" H21 2HR";
$resn_exch{"2H2  2HR"}=" H22 2HR"; $resn_exch{"1H1  2HR"}=" H11 2HR"; $resn_exch{"2H1  2HR"}="H12A 2HR";
$resn_exch{"1H7  2HR"}=" H71 2HR"; $resn_exch{"2H7  2HR"}=" H72 2HR"; $resn_exch{"1H9  2HR"}=" H91 2HR";
$resn_exch{"2H9  2HR"}=" H92 2HR"; $resn_exch{"3H9  2HR"}=" H93 2HR"; $resn_exch{"1H10 2HR"}="H101 2HR";
$resn_exch{"2H10 2HR"}="H102 2HR"; $resn_exch{"1H6  2HS"}=" H61 2HS"; $resn_exch{"2H6  2HS"}=" H62 2HS";
$resn_exch{"3H6  2HS"}=" H63 2HS"; $resn_exch{"1H5  2HS"}=" H51 2HS"; $resn_exch{"2H5  2HS"}=" H52 2HS";
$resn_exch{"1H4  2HS"}=" H41 2HS"; $resn_exch{"2H4  2HS"}=" H42 2HS"; $resn_exch{"1H3  2HS"}=" H31 2HS";
$resn_exch{"2H3  2HS"}=" H32 2HS"; $resn_exch{"1H2  2HS"}=" H21 2HS"; $resn_exch{"2H2  2HS"}=" H22 2HS";
$resn_exch{"1H1  2HS"}=" H11 2HS"; $resn_exch{"2H1  2HS"}="H12A 2HS"; $resn_exch{"1H7  2HS"}=" H71 2HS";
$resn_exch{"2H7  2HS"}=" H72 2HS"; $resn_exch{"1H9  2HS"}=" H91 2HS"; $resn_exch{"2H9  2HS"}=" H92 2HS";
$resn_exch{"3H9  2HS"}=" H93 2HS"; $resn_exch{"1H10 2HS"}="H101 2HS"; $resn_exch{"2H10 2HS"}="H102 2HS";
$resn_exch{"1H   2IB"}=" H1  2IB"; $resn_exch{"2H   2IB"}=" H2  2IB"; $resn_exch{"3H   2IB"}=" H3A 2IB";
$resn_exch{"1H15 2IC"}="H151 2IC"; $resn_exch{"2H15 2IC"}="H152 2IC"; $resn_exch{"1H19 2IC"}="H191 2IC";
$resn_exch{"2H19 2IC"}="H192 2IC"; $resn_exch{"1H36 2IC"}="H361 2IC"; $resn_exch{"2H36 2IC"}="H362 2IC";
$resn_exch{"1H52 2IC"}="H521 2IC"; $resn_exch{"2H52 2IC"}="H522 2IC"; $resn_exch{"3H52 2IC"}="H523 2IC";
$resn_exch{"1HN3 2IG"}="HN31 2IG"; $resn_exch{"2HN3 2IG"}="HN32 2IG"; $resn_exch{"1HN4 2IG"}="HN41 2IG";
$resn_exch{"2HN4 2IG"}="HN42 2IG"; $resn_exch{"1H5  2IG"}=" H51 2IG"; $resn_exch{"2H5  2IG"}=" H52 2IG";
$resn_exch{"1H6  2IG"}=" H61 2IG"; $resn_exch{"2H6  2IG"}=" H62 2IG"; $resn_exch{"3H6  2IG"}=" H63 2IG";
$resn_exch{"1H13 2IG"}="H131 2IG"; $resn_exch{"2H13 2IG"}="H132 2IG"; $resn_exch{"1H14 2IG"}="H141 2IG";
$resn_exch{"2H14 2IG"}="H142 2IG"; $resn_exch{"1H15 2IG"}="H151 2IG"; $resn_exch{"2H15 2IG"}="H152 2IG";
$resn_exch{"1H16 2IG"}="H161 2IG"; $resn_exch{"2H16 2IG"}="H162 2IG"; $resn_exch{"3H16 2IG"}="H163 2IG";
$resn_exch{"1H6C 2IH"}="H6C1 2IH"; $resn_exch{"2H6C 2IH"}="H6C2 2IH"; $resn_exch{"1H7C 2IH"}="H7C1 2IH";
$resn_exch{"2H7C 2IH"}="H7C2 2IH"; $resn_exch{"1H8C 2IH"}="H8C1 2IH"; $resn_exch{"2H8C 2IH"}="H8C2 2IH";
$resn_exch{"1H9C 2IH"}="H9C1 2IH"; $resn_exch{"2H9C 2IH"}="H9C2 2IH"; $resn_exch{"1H10 2IH"}="H101 2IH";
$resn_exch{"2H10 2IH"}="H102 2IH"; $resn_exch{"1H11 2IH"}="H111 2IH"; $resn_exch{"2H11 2IH"}="H112 2IH";
$resn_exch{"1H4  2IM"}=" H41 2IM"; $resn_exch{"2H4  2IM"}=" H42 2IM"; $resn_exch{"1H5  2IM"}=" H51 2IM";
$resn_exch{"2H5  2IM"}=" H52 2IM"; $resn_exch{"1H3  2IM"}=" H31 2IM"; $resn_exch{"2H3  2IM"}=" H32 2IM";
$resn_exch{"1H2  2IM"}=" H21 2IM"; $resn_exch{"2H2  2IM"}=" H22 2IM"; $resn_exch{"1HN4 2IN"}="HN41 2IN";
$resn_exch{"2HN4 2IN"}="HN42 2IN"; $resn_exch{"1H11 2IN"}="H111 2IN"; $resn_exch{"2H11 2IN"}="H112 2IN";
$resn_exch{"1H8  2IN"}=" H81 2IN"; $resn_exch{"2H8  2IN"}=" H82 2IN"; $resn_exch{"1H6  2IN"}=" H61 2IN";
$resn_exch{"2H6  2IN"}=" H62 2IN"; $resn_exch{"1H1  2IN"}=" H11 2IN"; $resn_exch{"2H1  2IN"}="H12A 2IN";
$resn_exch{"2HO4 2IP"}="HO42 2IP"; $resn_exch{"3HO4 2IP"}="HO43 2IP"; $resn_exch{"2HO1 2IP"}="HO12 2IP";
$resn_exch{"3HO1 2IP"}="HO13 2IP"; $resn_exch{"1H4  2KT"}=" H41 2KT"; $resn_exch{"2H4  2KT"}=" H42 2KT";
$resn_exch{"3H4  2KT"}=" H43 2KT"; $resn_exch{"1H3  2KT"}=" H31 2KT"; $resn_exch{"2H3  2KT"}=" H32 2KT";
$resn_exch{"1H4  2LG"}=" H41 2LG"; $resn_exch{"2H4  2LG"}=" H42 2LG"; $resn_exch{"1H6  2LG"}=" H61 2LG";
$resn_exch{"2H6  2LG"}=" H62 2LG"; $resn_exch{"1H26 2LG"}="H261 2LG"; $resn_exch{"2H26 2LG"}="H262 2LG";
$resn_exch{"1H28 2LG"}="H281 2LG"; $resn_exch{"2H28 2LG"}="H282 2LG"; $resn_exch{"3H28 2LG"}="H283 2LG";
$resn_exch{"1H9  2LG"}=" H91 2LG"; $resn_exch{"2H9  2LG"}=" H92 2LG"; $resn_exch{"1H25 2LG"}="H251 2LG";
$resn_exch{"2H25 2LG"}="H252 2LG"; $resn_exch{"1H27 2LG"}="H271 2LG"; $resn_exch{"2H27 2LG"}="H272 2LG";
$resn_exch{"3H27 2LG"}="H273 2LG"; $resn_exch{"1HC4 2LP"}="HC41 2LP"; $resn_exch{"2HC4 2LP"}="HC42 2LP";
$resn_exch{"1H14 2LP"}="H141 2LP"; $resn_exch{"2H14 2LP"}="H142 2LP"; $resn_exch{" HN2 2LU"}=" H2  2LU";
$resn_exch{"1HB  2LU"}=" HB2 2LU"; $resn_exch{"2HB  2LU"}=" HB3 2LU"; $resn_exch{"1HD1 2LU"}="HD11 2LU";
$resn_exch{"2HD1 2LU"}="HD12 2LU"; $resn_exch{"3HD1 2LU"}="HD13 2LU"; $resn_exch{"1HD2 2LU"}="HD21 2LU";
$resn_exch{"2HD2 2LU"}="HD22 2LU"; $resn_exch{"3HD2 2LU"}="HD23 2LU"; $resn_exch{"2HOP 2MA"}="HOP2 2MA";
$resn_exch{"3HOP 2MA"}="HOP3 2MA"; $resn_exch{"1H5* 2MA"}=" H5' 2MA"; $resn_exch{"2H5* 2MA"}="H5'' 2MA";
$resn_exch{" H4* 2MA"}=" H4' 2MA"; $resn_exch{" H3* 2MA"}=" H3' 2MA"; $resn_exch{"*HO3 2MA"}="HO3' 2MA";
$resn_exch{" H2* 2MA"}=" H2' 2MA"; $resn_exch{"*HO2 2MA"}="HO2' 2MA"; $resn_exch{" H1* 2MA"}=" H1' 2MA";
$resn_exch{"1HM2 2MA"}="HM21 2MA"; $resn_exch{"2HM2 2MA"}="HM22 2MA"; $resn_exch{"3HM2 2MA"}="HM23 2MA";
$resn_exch{"1H4C 2MB"}="H4C1 2MB"; $resn_exch{"2H4C 2MB"}="H4C2 2MB"; $resn_exch{"3H4C 2MB"}="H4C3 2MB";
$resn_exch{"1H1C 2MB"}="H1C1 2MB"; $resn_exch{"2H1C 2MB"}="H1C2 2MB"; $resn_exch{"3H1C 2MB"}="H1C3 2MB";
$resn_exch{"1H2' 2MB"}="H2'1 2MB"; $resn_exch{"2H2' 2MB"}="H2'2 2MB"; $resn_exch{"3H2' 2MB"}="H2'3 2MB";
$resn_exch{"1HN6 2MC"}="HN61 2MC"; $resn_exch{"2HN6 2MC"}="HN62 2MC"; $resn_exch{" H1* 2MC"}=" H1' 2MC";
$resn_exch{" H2* 2MC"}=" H2' 2MC"; $resn_exch{" H3* 2MC"}=" H3' 2MC"; $resn_exch{" H4* 2MC"}=" H4' 2MC";
$resn_exch{"1H5* 2MC"}="H5'1 2MC"; $resn_exch{"2H5* 2MC"}="H5'2 2MC"; $resn_exch{"1H12 2MC"}="H121 2MC";
$resn_exch{"2H12 2MC"}="H122 2MC"; $resn_exch{"1H13 2MC"}="H131 2MC"; $resn_exch{"2H13 2MC"}="H132 2MC";
$resn_exch{"3H13 2MC"}="H133 2MC"; $resn_exch{"1H14 2MC"}="H141 2MC"; $resn_exch{"2H14 2MC"}="H142 2MC";
$resn_exch{"3H14 2MC"}="H143 2MC"; $resn_exch{"1H7  2MC"}=" H71 2MC"; $resn_exch{"2H7  2MC"}=" H72 2MC";
$resn_exch{"1H6  2MC"}=" H61 2MC"; $resn_exch{"2H6  2MC"}=" H62 2MC"; $resn_exch{"1H3  2MC"}=" H31 2MC";
$resn_exch{"2H3  2MC"}=" H32 2MC"; $resn_exch{"1H2  2MC"}=" H21 2MC"; $resn_exch{"2H2  2MC"}=" H22 2MC";
$resn_exch{"1H1  2MC"}=" H11 2MC"; $resn_exch{"2H1  2MC"}=" H12 2MC"; $resn_exch{"1H2M 2MC"}="H2M1 2MC";
$resn_exch{"2H2M 2MC"}="H2M2 2MC"; $resn_exch{"3H2M 2MC"}="H2M3 2MC"; $resn_exch{"BHO2 2MD"}="HO2B 2MD";
$resn_exch{"1H10 2MD"}="H101 2MD"; $resn_exch{"2H10 2MD"}="H102 2MD"; $resn_exch{"1HNG 2MD"}="HNG1 2MD";
$resn_exch{"2HNG 2MD"}="HNG2 2MD"; $resn_exch{"AHO2 2MD"}="HO2A 2MD"; $resn_exch{"1H5* 2MD"}="H5'1 2MD";
$resn_exch{"2H5* 2MD"}="H5'2 2MD"; $resn_exch{" H4* 2MD"}=" H4' 2MD"; $resn_exch{" H1* 2MD"}=" H1' 2MD";
$resn_exch{"1HN2 2MD"}="HN21 2MD"; $resn_exch{"2HN2 2MD"}="HN22 2MD"; $resn_exch{" H2* 2MD"}=" H2' 2MD";
$resn_exch{"*HO2 2MD"}="HO2' 2MD"; $resn_exch{" H3* 2MD"}=" H3' 2MD"; $resn_exch{"*HO3 2MD"}="HO3' 2MD";
$resn_exch{"1HA* 2ME"}="HA'1 2ME"; $resn_exch{"2HA* 2ME"}="HA'2 2ME"; $resn_exch{"3HA* 2ME"}="HA'3 2ME";
$resn_exch{"1HB* 2ME"}="HB'1 2ME"; $resn_exch{"2HB* 2ME"}="HB'2 2ME"; $resn_exch{"1HD* 2ME"}="HD'1 2ME";
$resn_exch{"2HD* 2ME"}="HD'2 2ME"; $resn_exch{"3HD* 2ME"}="HD'3 2ME"; $resn_exch{"2HOP 2MG"}="HOP2 2MG";
$resn_exch{"3HOP 2MG"}="HOP3 2MG"; $resn_exch{"1H5* 2MG"}=" H5' 2MG"; $resn_exch{"2H5* 2MG"}="H5'' 2MG";
$resn_exch{" H4* 2MG"}=" H4' 2MG"; $resn_exch{" H3* 2MG"}=" H3' 2MG"; $resn_exch{"*HO3 2MG"}="HO3' 2MG";
$resn_exch{" H2* 2MG"}=" H2' 2MG"; $resn_exch{"*HO2 2MG"}="HO2' 2MG"; $resn_exch{" H1* 2MG"}=" H1' 2MG";
$resn_exch{"1HM2 2MG"}="HM21 2MG"; $resn_exch{"2HM2 2MG"}="HM22 2MG"; $resn_exch{"3HM2 2MG"}="HM23 2MG";
$resn_exch{"1HN1 2MH"}="HN11 2MH"; $resn_exch{"2HN1 2MH"}="HN12 2MH"; $resn_exch{"1H6  2MH"}=" H61 2MH";
$resn_exch{"2H6  2MH"}=" H62 2MH"; $resn_exch{"1H4  2MH"}=" H41 2MH"; $resn_exch{"2H4  2MH"}=" H42 2MH";
$resn_exch{"1H3  2MH"}=" H31 2MH"; $resn_exch{"2H3  2MH"}=" H32 2MH"; $resn_exch{"1H1  2MH"}=" H11 2MH";
$resn_exch{"2H1  2MH"}=" H12 2MH"; $resn_exch{"3H1  2MH"}=" H13 2MH"; $resn_exch{"1H7  2MH"}=" H71 2MH";
$resn_exch{"2H7  2MH"}=" H72 2MH"; $resn_exch{"1HAJ 2MI"}="HAJ1 2MI"; $resn_exch{"2HAJ 2MI"}="HAJ2 2MI";
$resn_exch{"3HAJ 2MI"}="HAJ3 2MI"; $resn_exch{" HN2 2ML"}=" H2  2ML"; $resn_exch{"1HB1 2ML"}="HB11 2ML";
$resn_exch{"2HB1 2ML"}="HB12 2ML"; $resn_exch{"1HB2 2ML"}="HB21 2ML"; $resn_exch{"2HB2 2ML"}="HB22 2ML";
$resn_exch{"3HB2 2ML"}="HB23 2ML"; $resn_exch{"1HD1 2ML"}="HD11 2ML"; $resn_exch{"2HD1 2ML"}="HD12 2ML";
$resn_exch{"3HD1 2ML"}="HD13 2ML"; $resn_exch{"1HD2 2ML"}="HD21 2ML"; $resn_exch{"2HD2 2ML"}="HD22 2ML";
$resn_exch{"3HD2 2ML"}="HD23 2ML"; $resn_exch{"1HA5 2MN"}="HA51 2MN"; $resn_exch{"2HA5 2MN"}="HA52 2MN";
$resn_exch{"3HA5 2MN"}="HA53 2MN"; $resn_exch{"1H7  2MP"}=" H71 2MP"; $resn_exch{"2H7  2MP"}=" H72 2MP";
$resn_exch{"3H7  2MP"}=" H73 2MP"; $resn_exch{"1H8  2MP"}=" H81 2MP"; $resn_exch{"2H8  2MP"}=" H82 2MP";
$resn_exch{"3H8  2MP"}=" H83 2MP"; $resn_exch{" HN2 2MR"}=" H2  2MR"; $resn_exch{"1HB  2MR"}=" HB2 2MR";
$resn_exch{"2HB  2MR"}=" HB3 2MR"; $resn_exch{"1HG  2MR"}=" HG2 2MR"; $resn_exch{"2HG  2MR"}=" HG3 2MR";
$resn_exch{"1HD  2MR"}=" HD2 2MR"; $resn_exch{"2HD  2MR"}=" HD3 2MR"; $resn_exch{"1HQ1 2MR"}="HQ11 2MR";
$resn_exch{"2HQ1 2MR"}="HQ12 2MR"; $resn_exch{"3HQ1 2MR"}="HQ13 2MR"; $resn_exch{"1HH2 2MR"}=" HH2 2MR";
$resn_exch{"1HQ2 2MR"}="HQ21 2MR"; $resn_exch{"2HQ2 2MR"}="HQ22 2MR"; $resn_exch{"3HQ2 2MR"}="HQ23 2MR";
$resn_exch{" HN  2MT"}=" H   2MT"; $resn_exch{"2HB  2MT"}=" HB2 2MT"; $resn_exch{"1HB  2MT"}=" HB3 2MT";
$resn_exch{"1HD2 2MT"}="HD21 2MT"; $resn_exch{"2HD2 2MT"}="HD22 2MT"; $resn_exch{"3HD2 2MT"}="HD23 2MT";
$resn_exch{"1HD3 2MT"}="HD31 2MT"; $resn_exch{"2HD3 2MT"}="HD32 2MT"; $resn_exch{"3HD3 2MT"}="HD33 2MT";
$resn_exch{"1HM5 2MU"}="HM51 2MU"; $resn_exch{"2HM5 2MU"}="HM52 2MU"; $resn_exch{"3HM5 2MU"}="HM53 2MU";
$resn_exch{" H1* 2MU"}=" H1' 2MU"; $resn_exch{" H2* 2MU"}=" H2' 2MU"; $resn_exch{" H3* 2MU"}=" H3' 2MU";
$resn_exch{" H4* 2MU"}=" H4' 2MU"; $resn_exch{"*HO3 2MU"}="HO3' 2MU"; $resn_exch{"1H5* 2MU"}=" H5' 2MU";
$resn_exch{"2H5* 2MU"}="H5'' 2MU"; $resn_exch{"1H6* 2MU"}="H6'1 2MU"; $resn_exch{"2H6* 2MU"}="H6'2 2MU";
$resn_exch{"3H6* 2MU"}="H6'3 2MU"; $resn_exch{"2HOP 2MU"}="HOP2 2MU"; $resn_exch{"3HOP 2MU"}="HOP3 2MU";
$resn_exch{"1H6  2MZ"}=" H61 2MZ"; $resn_exch{"2H6  2MZ"}=" H62 2MZ"; $resn_exch{"3H6  2MZ"}=" H63 2MZ";
$resn_exch{" H1* 2ND"}=" H1' 2ND"; $resn_exch{"1H2* 2ND"}="H2'1 2ND"; $resn_exch{"2H2* 2ND"}="H2'2 2ND";
$resn_exch{" H3* 2ND"}=" H3' 2ND"; $resn_exch{" H4* 2ND"}=" H4' 2ND"; $resn_exch{"1H5* 2ND"}="H5'1 2ND";
$resn_exch{"2H5* 2ND"}="H5'2 2ND"; $resn_exch{" H5* 2ND"}=" H5' 2ND"; $resn_exch{"1HD1 2NH"}="HD11 2NH";
$resn_exch{"2HD1 2NH"}="HD12 2NH"; $resn_exch{"3HD1 2NH"}="HD13 2NH"; $resn_exch{"1HG4 2NH"}="HG41 2NH";
$resn_exch{"2HG4 2NH"}="HG42 2NH"; $resn_exch{"1HG3 2NH"}="HG31 2NH"; $resn_exch{"2HG3 2NH"}="HG32 2NH";
$resn_exch{"3HG3 2NH"}="HG33 2NH"; $resn_exch{"1HB2 2NH"}="HB21 2NH"; $resn_exch{"2HB2 2NH"}="HB22 2NH";
$resn_exch{"1H   2NH"}=" H1  2NH"; $resn_exch{"2H   2NH"}=" H2A 2NH"; $resn_exch{"1H4  2NH"}=" H41 2NH";
$resn_exch{"2H4  2NH"}=" H42 2NH"; $resn_exch{"3H4  2NH"}=" H43 2NH"; $resn_exch{"1H3  2NH"}=" H31 2NH";
$resn_exch{"2H3  2NH"}=" H32 2NH"; $resn_exch{"1H5  2NH"}=" H51 2NH"; $resn_exch{"2H5  2NH"}=" H52 2NH";
$resn_exch{"1H8  2NH"}=" H81 2NH"; $resn_exch{"2H8  2NH"}=" H82 2NH"; $resn_exch{"3H8  2NH"}=" H83 2NH";
$resn_exch{"1H9  2NH"}=" H91 2NH"; $resn_exch{"2H9  2NH"}=" H92 2NH"; $resn_exch{"1H10 2NH"}="H101 2NH";
$resn_exch{"2H10 2NH"}="H102 2NH"; $resn_exch{"1H13 2NH"}="H131 2NH"; $resn_exch{"2H13 2NH"}="H132 2NH";
$resn_exch{"3H13 2NH"}="H133 2NH"; $resn_exch{"1H14 2NH"}="H141 2NH"; $resn_exch{"2H14 2NH"}="H142 2NH";
$resn_exch{"3H14 2NH"}="H143 2NH"; $resn_exch{"1HA  2NH"}=" HA1 2NH"; $resn_exch{"2HA  2NH"}="HA2A 2NH";
$resn_exch{"3HA  2NH"}="HA3A 2NH"; $resn_exch{"1HG1 2NH"}="HG11 2NH"; $resn_exch{"2HG1 2NH"}="HG12 2NH";
$resn_exch{"3HG1 2NH"}="HG13 2NH"; $resn_exch{"1HG2 2NH"}="HG21 2NH"; $resn_exch{"2HG2 2NH"}="HG22 2NH";
$resn_exch{"3HG2 2NH"}="HG23 2NH"; $resn_exch{"1HB5 2NH"}="HB51 2NH"; $resn_exch{"2HB5 2NH"}="HB52 2NH";
$resn_exch{"1HG  2NH"}=" HG1 2NH"; $resn_exch{"2HG  2NH"}=" HG2 2NH"; $resn_exch{"1HE  2NH"}=" HE1 2NH";
$resn_exch{"2HE  2NH"}=" HE2 2NH"; $resn_exch{"3HE  2NH"}=" HE3 2NH"; $resn_exch{"1H14 2NI"}="H141 2NI";
$resn_exch{"2H14 2NI"}="H142 2NI"; $resn_exch{"1H15 2NI"}="H151 2NI"; $resn_exch{"2H15 2NI"}="H152 2NI";
$resn_exch{"1H16 2NI"}="H161 2NI"; $resn_exch{"2H16 2NI"}="H162 2NI"; $resn_exch{"3H16 2NI"}="H163 2NI";
$resn_exch{"1H2  2NP"}=" H21 2NP"; $resn_exch{"1HN2 2NP"}="HN21 2NP"; $resn_exch{"2HN2 2NP"}="HN22 2NP";
$resn_exch{"1H3  2NP"}=" H31 2NP"; $resn_exch{"2H3  2NP"}=" H32 2NP"; $resn_exch{"1H4  2NP"}=" H41 2NP";
$resn_exch{"2H4  2NP"}=" H42 2NP"; $resn_exch{"1H5  2NP"}=" H51 2NP"; $resn_exch{"2H5  2NP"}=" H52 2NP";
$resn_exch{"1H8  2NP"}=" H81 2NP"; $resn_exch{"2H8  2NP"}=" H82 2NP"; $resn_exch{"3HOP 2NT"}="HOP3 2NT";
$resn_exch{"2HOP 2NT"}="HOP2 2NT"; $resn_exch{"1H5* 2NT"}=" H5' 2NT"; $resn_exch{"2H5* 2NT"}="H5'' 2NT";
$resn_exch{" H4* 2NT"}=" H4' 2NT"; $resn_exch{" H1* 2NT"}=" H1' 2NT"; $resn_exch{"1H5M 2NT"}=" H71 2NT";
$resn_exch{"2H5M 2NT"}=" H72 2NT"; $resn_exch{"3H5M 2NT"}=" H73 2NT"; $resn_exch{" H2* 2NT"}=" H2' 2NT";
$resn_exch{"1HB' 2NT"}="HB'1 2NT"; $resn_exch{"2HB' 2NT"}="HB'2 2NT"; $resn_exch{"1HC' 2NT"}="HC'1 2NT";
$resn_exch{"2HC' 2NT"}="HC'2 2NT"; $resn_exch{"1HF' 2NT"}="HF'1 2NT"; $resn_exch{"2HF' 2NT"}="HF'2 2NT";
$resn_exch{" H3* 2NT"}=" H3' 2NT"; $resn_exch{"H3T  2NT"}="HO3' 2NT"; $resn_exch{"1H3  2O7"}=" H31 2O7";
$resn_exch{"2H3  2O7"}=" H32 2O7"; $resn_exch{"1H9  2O7"}=" H91 2O7"; $resn_exch{"2H9  2O7"}=" H92 2O7";
$resn_exch{"1H6  2O7"}=" H61 2O7"; $resn_exch{"2H6  2O7"}=" H62 2O7"; $resn_exch{"1H29 2O7"}="H291 2O7";
$resn_exch{"2H29 2O7"}="H292 2O7"; $resn_exch{"1H2  2OB"}=" H21 2OB"; $resn_exch{"2H2  2OB"}=" H22 2OB";
$resn_exch{"1H4  2OB"}=" H41 2OB"; $resn_exch{"2H4  2OB"}=" H42 2OB"; $resn_exch{"1H11 2OB"}="H111 2OB";
$resn_exch{"2H11 2OB"}="H112 2OB"; $resn_exch{"1H12 2OB"}="H121 2OB"; $resn_exch{"2H12 2OB"}="H122 2OB";
$resn_exch{"1H18 2OB"}="H181 2OB"; $resn_exch{"2H18 2OB"}="H182 2OB"; $resn_exch{"3H18 2OB"}="H183 2OB";
$resn_exch{"1H22 2OB"}="H221 2OB"; $resn_exch{"2H22 2OB"}="H222 2OB"; $resn_exch{"1H23 2OB"}="H231 2OB";
$resn_exch{"2H23 2OB"}="H232 2OB"; $resn_exch{"1H24 2OB"}="H241 2OB"; $resn_exch{"2H24 2OB"}="H242 2OB";
$resn_exch{"1H27 2OB"}="H271 2OB"; $resn_exch{"2H27 2OB"}="H272 2OB"; $resn_exch{"3H27 2OB"}="H273 2OB";
$resn_exch{"1H26 2OB"}="H261 2OB"; $resn_exch{"2H26 2OB"}="H262 2OB"; $resn_exch{"3H26 2OB"}="H263 2OB";
$resn_exch{"1H21 2OB"}="H211 2OB"; $resn_exch{"2H21 2OB"}="H212 2OB"; $resn_exch{"3H21 2OB"}="H213 2OB";
$resn_exch{"1H16 2OB"}="H161 2OB"; $resn_exch{"2H16 2OB"}="H162 2OB"; $resn_exch{"1H15 2OB"}="H151 2OB";
$resn_exch{"2H15 2OB"}="H152 2OB"; $resn_exch{"1H7  2OB"}=" H71 2OB"; $resn_exch{"2H7  2OB"}=" H72 2OB";
$resn_exch{"1H19 2OB"}="H191 2OB"; $resn_exch{"2H19 2OB"}="H192 2OB"; $resn_exch{"3H19 2OB"}="H193 2OB";
$resn_exch{"1H1  2OB"}=" H11 2OB"; $resn_exch{"2H1  2OB"}=" H12 2OB"; $resn_exch{"1H47 2OB"}="H471 2OB";
$resn_exch{"2H47 2OB"}="H472 2OB"; $resn_exch{"1H46 2OB"}="H461 2OB"; $resn_exch{"2H46 2OB"}="H462 2OB";
$resn_exch{"1H45 2OB"}="H451 2OB"; $resn_exch{"2H45 2OB"}="H452 2OB"; $resn_exch{"1H44 2OB"}="H441 2OB";
$resn_exch{"2H44 2OB"}="H442 2OB"; $resn_exch{"1H43 2OB"}="H431 2OB"; $resn_exch{"2H43 2OB"}="H432 2OB";
$resn_exch{"1H42 2OB"}="H421 2OB"; $resn_exch{"2H42 2OB"}="H422 2OB"; $resn_exch{"1H41 2OB"}="H411 2OB";
$resn_exch{"2H41 2OB"}="H412 2OB"; $resn_exch{"1H38 2OB"}="H381 2OB"; $resn_exch{"2H38 2OB"}="H382 2OB";
$resn_exch{"1H37 2OB"}="H371 2OB"; $resn_exch{"2H37 2OB"}="H372 2OB"; $resn_exch{"1H36 2OB"}="H361 2OB";
$resn_exch{"2H36 2OB"}="H362 2OB"; $resn_exch{"1H35 2OB"}="H351 2OB"; $resn_exch{"2H35 2OB"}="H352 2OB";
$resn_exch{"1H34 2OB"}="H341 2OB"; $resn_exch{"2H34 2OB"}="H342 2OB"; $resn_exch{"1H33 2OB"}="H331 2OB";
$resn_exch{"2H33 2OB"}="H332 2OB"; $resn_exch{"1H32 2OB"}="H321 2OB"; $resn_exch{"2H32 2OB"}="H322 2OB";
$resn_exch{"1H31 2OB"}="H311 2OB"; $resn_exch{"2H31 2OB"}="H312 2OB"; $resn_exch{"3H31 2OB"}="H313 2OB";
$resn_exch{"1HO1 2OF"}="HO11 2OF"; $resn_exch{"2HO1 2OF"}="HO12 2OF"; $resn_exch{"1HO2 2OF"}="HO21 2OF";
$resn_exch{"2HO2 2OF"}="HO22 2OF"; $resn_exch{"1H3  2OG"}=" H31 2OG"; $resn_exch{"2H3  2OG"}=" H32 2OG";
$resn_exch{"1H4  2OG"}=" H41 2OG"; $resn_exch{"2H4  2OG"}=" H42 2OG"; $resn_exch{"1H3  2OH"}=" H31 2OH";
$resn_exch{"2H3  2OH"}=" H32 2OH"; $resn_exch{"3H3  2OH"}=" H33 2OH"; $resn_exch{"1H5  2OH"}=" H51 2OH";
$resn_exch{"2H5  2OH"}=" H52 2OH"; $resn_exch{"3H5  2OH"}=" H53 2OH"; $resn_exch{"1HB  2OP"}=" HB1 2OP";
$resn_exch{"2HB  2OP"}=" HB2 2OP"; $resn_exch{"3HB  2OP"}=" HB3 2OP"; $resn_exch{"1H7  2OS"}=" H71 2OS";
$resn_exch{"2H7  2OS"}=" H72 2OS"; $resn_exch{"1H8  2OS"}=" H81 2OS"; $resn_exch{"2H8  2OS"}=" H82 2OS";
$resn_exch{"1H9  2OS"}=" H91 2OS"; $resn_exch{"2H9  2OS"}=" H92 2OS"; $resn_exch{"1H10 2OS"}="H101 2OS";
$resn_exch{"2H10 2OS"}="H102 2OS"; $resn_exch{"1H11 2OS"}="H111 2OS"; $resn_exch{"2H11 2OS"}="H112 2OS";
$resn_exch{"1H12 2OS"}="H121 2OS"; $resn_exch{"2H12 2OS"}="H122 2OS"; $resn_exch{"1H17 2OS"}="H171 2OS";
$resn_exch{"2H17 2OS"}="H172 2OS"; $resn_exch{"1H18 2OS"}="H181 2OS"; $resn_exch{"2H18 2OS"}="H182 2OS";
$resn_exch{"1H32 2OS"}="H321 2OS"; $resn_exch{"2H32 2OS"}="H322 2OS"; $resn_exch{"1H31 2OS"}="H311 2OS";
$resn_exch{"2H31 2OS"}="H312 2OS"; $resn_exch{"3H31 2OS"}="H313 2OS"; $resn_exch{"2HOP 2OT"}="HOP2 2OT";
$resn_exch{"1H5* 2OT"}=" H5' 2OT"; $resn_exch{"2H5* 2OT"}="H5'' 2OT"; $resn_exch{" H4* 2OT"}=" H4' 2OT";
$resn_exch{" H1* 2OT"}=" H1' 2OT"; $resn_exch{"1H5M 2OT"}=" H71 2OT"; $resn_exch{"2H5M 2OT"}=" H72 2OT";
$resn_exch{"3H5M 2OT"}=" H73 2OT"; $resn_exch{" H2* 2OT"}=" H2' 2OT"; $resn_exch{"1HB' 2OT"}="HB'1 2OT";
$resn_exch{"2HB' 2OT"}="HB'2 2OT"; $resn_exch{"1HC' 2OT"}="HC'1 2OT"; $resn_exch{"2HC' 2OT"}="HC'2 2OT";
$resn_exch{"1HF' 2OT"}="HF'1 2OT"; $resn_exch{"2HF' 2OT"}="HF'2 2OT"; $resn_exch{"3HF' 2OT"}="HF'3 2OT";
$resn_exch{"1HG' 2OT"}="HG'1 2OT"; $resn_exch{"2HG' 2OT"}="HG'2 2OT"; $resn_exch{"3HG' 2OT"}="HG'3 2OT";
$resn_exch{" H3* 2OT"}=" H3' 2OT"; $resn_exch{"H3T  2OT"}="HO3' 2OT"; $resn_exch{"3HOP 2OT"}="HOP3 2OT";
$resn_exch{"1HN4 2PA"}="HN41 2PA"; $resn_exch{"2HN4 2PA"}="HN42 2PA"; $resn_exch{"1HN5 2PA"}="HN51 2PA";
$resn_exch{"2HN5 2PA"}="HN52 2PA"; $resn_exch{"1HO3 2PA"}="HO31 2PA"; $resn_exch{"1H3  2PC"}=" H31 2PC";
$resn_exch{"2H3  2PC"}=" H32 2PC"; $resn_exch{"1H4  2PC"}=" H41 2PC"; $resn_exch{"2H4  2PC"}=" H42 2PC";
$resn_exch{"1H5  2PC"}=" H51 2PC"; $resn_exch{"2H5  2PC"}=" H52 2PC"; $resn_exch{"1HO  2PE"}=" HO1 2PE";
$resn_exch{"1H2  2PE"}=" H21 2PE"; $resn_exch{"2H2  2PE"}=" H22 2PE"; $resn_exch{"1H3  2PE"}=" H31 2PE";
$resn_exch{"2H3  2PE"}=" H32 2PE"; $resn_exch{"1H5  2PE"}=" H51 2PE"; $resn_exch{"2H5  2PE"}=" H52 2PE";
$resn_exch{"1H6  2PE"}=" H61 2PE"; $resn_exch{"2H6  2PE"}=" H62 2PE"; $resn_exch{"1H8  2PE"}=" H81 2PE";
$resn_exch{"2H8  2PE"}=" H82 2PE"; $resn_exch{"1H9  2PE"}=" H91 2PE"; $resn_exch{"2H9  2PE"}=" H92 2PE";
$resn_exch{"1H11 2PE"}="H111 2PE"; $resn_exch{"2H11 2PE"}="H112 2PE"; $resn_exch{"1H12 2PE"}="H121 2PE";
$resn_exch{"2H12 2PE"}="H122 2PE"; $resn_exch{"1H14 2PE"}="H141 2PE"; $resn_exch{"2H14 2PE"}="H142 2PE";
$resn_exch{"1H15 2PE"}="H151 2PE"; $resn_exch{"2H15 2PE"}="H152 2PE"; $resn_exch{"1H17 2PE"}="H171 2PE";
$resn_exch{"2H17 2PE"}="H172 2PE"; $resn_exch{"1H18 2PE"}="H181 2PE"; $resn_exch{"2H18 2PE"}="H182 2PE";
$resn_exch{"1H20 2PE"}="H201 2PE"; $resn_exch{"2H20 2PE"}="H202 2PE"; $resn_exch{"1H21 2PE"}="H211 2PE";
$resn_exch{"2H21 2PE"}="H212 2PE"; $resn_exch{"1H23 2PE"}="H231 2PE"; $resn_exch{"2H23 2PE"}="H232 2PE";
$resn_exch{"1H24 2PE"}="H241 2PE"; $resn_exch{"2H24 2PE"}="H242 2PE"; $resn_exch{"1H26 2PE"}="H261 2PE";
$resn_exch{"2H26 2PE"}="H262 2PE"; $resn_exch{"1H27 2PE"}="H271 2PE"; $resn_exch{"2H27 2PE"}="H272 2PE";
$resn_exch{"2HO  2PE"}=" HO2 2PE"; $resn_exch{"1H3  2PG"}=" H31 2PG"; $resn_exch{"2H3  2PG"}=" H32 2PG";
$resn_exch{"3HOP 2PG"}="HOP3 2PG"; $resn_exch{"4HOP 2PG"}="HOP4 2PG"; $resn_exch{"1H3  2PH"}=" H31 2PH";
$resn_exch{"2H3  2PH"}=" H32 2PH"; $resn_exch{"1HN6 2PH"}="HN61 2PH"; $resn_exch{"2HN6 2PH"}="HN62 2PH";
$resn_exch{"1H11 2PH"}="H111 2PH"; $resn_exch{"2H11 2PH"}="H112 2PH"; $resn_exch{"2HOP 2PH"}="HOP2 2PH";
$resn_exch{"5HOP 2PH"}="HOP5 2PH"; $resn_exch{"6HOP 2PH"}="HOP6 2PH"; $resn_exch{"1HB  2PI"}=" HB1 2PI";
$resn_exch{"2HB  2PI"}=" HB2 2PI"; $resn_exch{"1HG  2PI"}=" HG1 2PI"; $resn_exch{"2HG  2PI"}=" HG2 2PI";
$resn_exch{"1HD  2PI"}=" HD1 2PI"; $resn_exch{"2HD  2PI"}=" HD2 2PI"; $resn_exch{"3HD  2PI"}=" HD3 2PI";
$resn_exch{"1H2  2PL"}=" H21 2PL"; $resn_exch{"2H2  2PL"}=" H22 2PL"; $resn_exch{"3HOP 2PL"}="HOP3 2PL";
$resn_exch{"4HOP 2PL"}="HOP4 2PL"; $resn_exch{"1H14 2PM"}="H141 2PM"; $resn_exch{"2H14 2PM"}="H142 2PM";
$resn_exch{"1H15 2PM"}="H151 2PM"; $resn_exch{"2H15 2PM"}="H152 2PM"; $resn_exch{"1H16 2PM"}="H161 2PM";
$resn_exch{"2H16 2PM"}="H162 2PM"; $resn_exch{"3H16 2PM"}="H163 2PM"; $resn_exch{"1H17 2PM"}="H171 2PM";
$resn_exch{"2H17 2PM"}="H172 2PM"; $resn_exch{"3H17 2PM"}="H173 2PM"; $resn_exch{"1H3  2PP"}=" H31 2PP";
$resn_exch{"2H3  2PP"}=" H32 2PP"; $resn_exch{"1H4  2PP"}=" H41 2PP"; $resn_exch{"2H4  2PP"}=" H42 2PP";
$resn_exch{"1H5  2PP"}=" H51 2PP"; $resn_exch{"2H5  2PP"}=" H52 2PP"; $resn_exch{"3H5  2PP"}=" H53 2PP";
$resn_exch{"1H1' 2PP"}="H1'1 2PP"; $resn_exch{"2H1' 2PP"}="H1'2 2PP"; $resn_exch{"1H2' 2PP"}="H2'1 2PP";
$resn_exch{"2H2' 2PP"}="H2'2 2PP"; $resn_exch{"1H3' 2PP"}="H3'1 2PP"; $resn_exch{"2H3' 2PP"}="H3'2 2PP";
$resn_exch{"3H3' 2PP"}="H3'3 2PP"; $resn_exch{"3HOP 2PR"}="HOP3 2PR"; $resn_exch{"2HOP 2PR"}="HOP2 2PR";
$resn_exch{"1H5* 2PR"}=" H5' 2PR"; $resn_exch{"2H5* 2PR"}="H5'' 2PR"; $resn_exch{" H4* 2PR"}=" H4' 2PR";
$resn_exch{" H3* 2PR"}=" H3' 2PR"; $resn_exch{"H3T  2PR"}="HO3' 2PR"; $resn_exch{"1H2* 2PR"}=" H2' 2PR";
$resn_exch{"2H2* 2PR"}="H2'' 2PR"; $resn_exch{" H1* 2PR"}=" H1' 2PR"; $resn_exch{"1HN2 2PR"}="HN21 2PR";
$resn_exch{"2HN2 2PR"}="HN22 2PR"; $resn_exch{" NH7 2PT"}=" H7N 2PT"; $resn_exch{"1H23 2PT"}="H231 2PT";
$resn_exch{"2H23 2PT"}="H232 2PT"; $resn_exch{"3H23 2PT"}="H233 2PT"; $resn_exch{"1H24 2PT"}="H241 2PT";
$resn_exch{"2H24 2PT"}="H242 2PT"; $resn_exch{"3H24 2PT"}="H243 2PT"; $resn_exch{"1HN5 2PT"}="HN51 2PT";
$resn_exch{"2HN5 2PT"}="HN52 2PT"; $resn_exch{"1H6  2PU"}=" H61 2PU"; $resn_exch{"2H6  2PU"}=" H62 2PU";
$resn_exch{"1H11 2PU"}="H111 2PU"; $resn_exch{"2H11 2PU"}="H112 2PU"; $resn_exch{"1H12 2PU"}="H121 2PU";
$resn_exch{"2H12 2PU"}="H122 2PU"; $resn_exch{"1H24 2PU"}="H241 2PU"; $resn_exch{"2H24 2PU"}="H242 2PU";
$resn_exch{"1H26 2PU"}="H261 2PU"; $resn_exch{"2H26 2PU"}="H262 2PU"; $resn_exch{"1H27 2PU"}="H271 2PU";
$resn_exch{"2H27 2PU"}="H272 2PU"; $resn_exch{"1H24 2PY"}="H241 2PY"; $resn_exch{"2H24 2PY"}="H242 2PY";
$resn_exch{"1H25 2PY"}="H251 2PY"; $resn_exch{"2H25 2PY"}="H252 2PY"; $resn_exch{"1HN4 2PY"}="HN41 2PY";
$resn_exch{"2HN4 2PY"}="HN42 2PY"; $resn_exch{"1HAA 2RD"}="HAA1 2RD"; $resn_exch{"2HAA 2RD"}="HAA2 2RD";
$resn_exch{"3HAA 2RD"}="HAA3 2RD"; $resn_exch{"1HAD 2RD"}="HAD1 2RD"; $resn_exch{"2HAD 2RD"}="HAD2 2RD";
$resn_exch{"1HAE 2RD"}="HAE1 2RD"; $resn_exch{"2HAE 2RD"}="HAE2 2RD"; $resn_exch{"1HAF 2RD"}="HAF1 2RD";
$resn_exch{"2HAF 2RD"}="HAF2 2RD"; $resn_exch{"1HAG 2RD"}="HAG1 2RD"; $resn_exch{"2HAG 2RD"}="HAG2 2RD";
$resn_exch{"1HAH 2RD"}="HAH1 2RD"; $resn_exch{"2HAH 2RD"}="HAH2 2RD"; $resn_exch{"1HAI 2RD"}="HAI1 2RD";
$resn_exch{"2HAI 2RD"}="HAI2 2RD"; $resn_exch{"1HAJ 2RD"}="HAJ1 2RD"; $resn_exch{"2HAJ 2RD"}="HAJ2 2RD";
$resn_exch{"1HAK 2RD"}="HAK1 2RD"; $resn_exch{"2HAK 2RD"}="HAK2 2RD"; $resn_exch{"1HAL 2RD"}="HAL1 2RD";
$resn_exch{"2HAL 2RD"}="HAL2 2RD"; $resn_exch{"1HAM 2RD"}="HAM1 2RD"; $resn_exch{"2HAM 2RD"}="HAM2 2RD";
$resn_exch{"1HAN 2RD"}="HAN1 2RD"; $resn_exch{"2HAN 2RD"}="HAN2 2RD"; $resn_exch{"1HC5 2SA"}="HC51 2SA";
$resn_exch{"2HC5 2SA"}="HC52 2SA"; $resn_exch{"1H63 2SA"}="H631 2SA"; $resn_exch{"2H63 2SA"}="H632 2SA";
$resn_exch{"1H12 2SC"}="H121 2SC"; $resn_exch{"2H12 2SC"}="H122 2SC"; $resn_exch{"1H24 2SC"}="H241 2SC";
$resn_exch{"2H24 2SC"}="H242 2SC"; $resn_exch{"1H1O 2SI"}="H1O1 2SI"; $resn_exch{"1H3O 2SI"}="H3O1 2SI";
$resn_exch{"1HO6 2SI"}="HO61 2SI"; $resn_exch{"3HOS 2SI"}="HOS3 2SI"; $resn_exch{"1H4O 2SI"}="H4O1 2SI";
$resn_exch{"1H7  2SK"}=" H71 2SK"; $resn_exch{"2H7  2SK"}=" H72 2SK"; $resn_exch{"3H7  2SK"}=" H73 2SK";
$resn_exch{"1H8  2SK"}=" H81 2SK"; $resn_exch{"2H8  2SK"}=" H82 2SK"; $resn_exch{"1H1  2SP"}=" H11 2SP";
$resn_exch{"2H1  2SP"}=" H12 2SP"; $resn_exch{"1H32 2SP"}="H321 2SP"; $resn_exch{"2H32 2SP"}="H322 2SP";
$resn_exch{"1H33 2SP"}="H331 2SP"; $resn_exch{"2H33 2SP"}="H332 2SP"; $resn_exch{"1H34 2SP"}="H341 2SP";
$resn_exch{"2H34 2SP"}="H342 2SP"; $resn_exch{"1H35 2SP"}="H351 2SP"; $resn_exch{"2H35 2SP"}="H352 2SP";
$resn_exch{"1H36 2SP"}="H361 2SP"; $resn_exch{"2H36 2SP"}="H362 2SP"; $resn_exch{"1H37 2SP"}="H371 2SP";
$resn_exch{"2H37 2SP"}="H372 2SP"; $resn_exch{"1H38 2SP"}="H381 2SP"; $resn_exch{"2H38 2SP"}="H382 2SP";
$resn_exch{"1H39 2SP"}="H391 2SP"; $resn_exch{"2H39 2SP"}="H392 2SP"; $resn_exch{"1H40 2SP"}="H401 2SP";
$resn_exch{"2H40 2SP"}="H402 2SP"; $resn_exch{"1H41 2SP"}="H411 2SP"; $resn_exch{"2H41 2SP"}="H412 2SP";
$resn_exch{"1H42 2SP"}="H421 2SP"; $resn_exch{"2H42 2SP"}="H422 2SP"; $resn_exch{"1H43 2SP"}="H431 2SP";
$resn_exch{"2H43 2SP"}="H432 2SP"; $resn_exch{"1H44 2SP"}="H441 2SP"; $resn_exch{"2H44 2SP"}="H442 2SP";
$resn_exch{"1H45 2SP"}="H451 2SP"; $resn_exch{"2H45 2SP"}="H452 2SP"; $resn_exch{"1H46 2SP"}="H461 2SP";
$resn_exch{"2H46 2SP"}="H462 2SP"; $resn_exch{"1H47 2SP"}="H471 2SP"; $resn_exch{"2H47 2SP"}="H472 2SP";
$resn_exch{"1H48 2SP"}="H481 2SP"; $resn_exch{"2H48 2SP"}="H482 2SP"; $resn_exch{"3H48 2SP"}="H483 2SP";
$resn_exch{"1H3  2SP"}=" H31 2SP"; $resn_exch{"2H3  2SP"}=" H32 2SP"; $resn_exch{"1H12 2SP"}="H121 2SP";
$resn_exch{"2H12 2SP"}="H122 2SP"; $resn_exch{"1H13 2SP"}="H131 2SP"; $resn_exch{"2H13 2SP"}="H132 2SP";
$resn_exch{"1H14 2SP"}="H141 2SP"; $resn_exch{"2H14 2SP"}="H142 2SP"; $resn_exch{"1H15 2SP"}="H151 2SP";
$resn_exch{"2H15 2SP"}="H152 2SP"; $resn_exch{"1H16 2SP"}="H161 2SP"; $resn_exch{"2H16 2SP"}="H162 2SP";
$resn_exch{"1H17 2SP"}="H171 2SP"; $resn_exch{"2H17 2SP"}="H172 2SP"; $resn_exch{"1H18 2SP"}="H181 2SP";
$resn_exch{"2H18 2SP"}="H182 2SP"; $resn_exch{"1H19 2SP"}="H191 2SP"; $resn_exch{"2H19 2SP"}="H192 2SP";
$resn_exch{"1H20 2SP"}="H201 2SP"; $resn_exch{"2H20 2SP"}="H202 2SP"; $resn_exch{"1H21 2SP"}="H211 2SP";
$resn_exch{"2H21 2SP"}="H212 2SP"; $resn_exch{"1H22 2SP"}="H221 2SP"; $resn_exch{"2H22 2SP"}="H222 2SP";
$resn_exch{"1H23 2SP"}="H231 2SP"; $resn_exch{"2H23 2SP"}="H232 2SP"; $resn_exch{"1H24 2SP"}="H241 2SP";
$resn_exch{"2H24 2SP"}="H242 2SP"; $resn_exch{"1H25 2SP"}="H251 2SP"; $resn_exch{"2H25 2SP"}="H252 2SP";
$resn_exch{"1H26 2SP"}="H261 2SP"; $resn_exch{"2H26 2SP"}="H262 2SP"; $resn_exch{"1H27 2SP"}="H271 2SP";
$resn_exch{"2H27 2SP"}="H272 2SP"; $resn_exch{"1H28 2SP"}="H281 2SP"; $resn_exch{"2H28 2SP"}="H282 2SP";
$resn_exch{"3H28 2SP"}="H283 2SP"; $resn_exch{"3HOP 2ST"}="HOP3 2ST"; $resn_exch{"2HOP 2ST"}="HOP2 2ST";
$resn_exch{"1H5A 2ST"}="H5A1 2ST"; $resn_exch{"2H5A 2ST"}="H5A2 2ST"; $resn_exch{"3H5A 2ST"}="H5A3 2ST";
$resn_exch{" H2* 2ST"}=" H2' 2ST"; $resn_exch{"1H5* 2ST"}=" H5' 2ST"; $resn_exch{"2H5* 2ST"}="H5'' 2ST";
$resn_exch{" H4* 2ST"}=" H4' 2ST"; $resn_exch{" H1* 2ST"}=" H1' 2ST"; $resn_exch{" H3* 2ST"}=" H3' 2ST";
$resn_exch{"1HA* 2ST"}="HA'1 2ST"; $resn_exch{"2HA* 2ST"}="HA'2 2ST"; $resn_exch{"3HA* 2ST"}="HA'3 2ST";
$resn_exch{"H3T  2ST"}="HO3' 2ST"; $resn_exch{"1H2  2TB"}=" H21 2TB"; $resn_exch{"2H2  2TB"}=" H22 2TB";
$resn_exch{"1HN1 2TB"}="HN11 2TB"; $resn_exch{"2HN1 2TB"}="HN12 2TB"; $resn_exch{"3HN1 2TB"}="HN13 2TB";
$resn_exch{"1HN3 2TB"}="HN31 2TB"; $resn_exch{"2HN3 2TB"}="HN32 2TB"; $resn_exch{"3HN3 2TB"}="HN33 2TB";
$resn_exch{"1H8  2TH"}=" H81 2TH"; $resn_exch{"2H8  2TH"}=" H82 2TH"; $resn_exch{"1HN2 2TN"}="HN21 2TN";
$resn_exch{"2HN2 2TN"}="HN22 2TN"; $resn_exch{"1H10 2TN"}="H101 2TN"; $resn_exch{"2H10 2TN"}="H102 2TN";
$resn_exch{"1H1  2TN"}=" H11 2TN"; $resn_exch{"2H1  2TN"}="H12A 2TN"; $resn_exch{"1H3  2TN"}=" H31 2TN";
$resn_exch{"2H3  2TN"}=" H32 2TN"; $resn_exch{"1H14 2TN"}="H141 2TN"; $resn_exch{"2H14 2TN"}="H142 2TN";
$resn_exch{"3H14 2TN"}="H143 2TN"; $resn_exch{"1H13 2TN"}="H131 2TN"; $resn_exch{"2H13 2TN"}="H132 2TN";
$resn_exch{"3H13 2TN"}="H133 2TN"; $resn_exch{"1H2A 2TP"}="H2A1 2TP"; $resn_exch{"2H2A 2TP"}="H2A2 2TP";
$resn_exch{"3H2A 2TP"}="H2A3 2TP"; $resn_exch{" H4* 2TP"}=" H4' 2TP"; $resn_exch{" H6* 2TP"}=" H6' 2TP";
$resn_exch{"1H35 2TP"}="H351 2TP"; $resn_exch{"2H35 2TP"}="H352 2TP"; $resn_exch{"1H4A 2TP"}="H4A1 2TP";
$resn_exch{"2H4A 2TP"}="H4A2 2TP"; $resn_exch{"3H4A 2TP"}="H4A3 2TP"; $resn_exch{"1H5A 2TP"}="H5A1 2TP";
$resn_exch{"2H5A 2TP"}="H5A2 2TP"; $resn_exch{"1H5B 2TP"}="H5B1 2TP"; $resn_exch{"2H5B 2TP"}="H5B2 2TP";
$resn_exch{"1HN  2TY"}=" H   2TY"; $resn_exch{"2HN  2TY"}=" H2  2TY"; $resn_exch{"1HB  2TY"}=" HB2 2TY";
$resn_exch{"2HB  2TY"}=" HB3 2TY"; $resn_exch{" HOH 2TY"}=" HH  2TY"; $resn_exch{"1H2  2TY"}=" H21 2TY";
$resn_exch{"2H2  2TY"}=" H22 2TY"; $resn_exch{"1H19 2UN"}="H191 2UN"; $resn_exch{"2H19 2UN"}="H192 2UN";
$resn_exch{"1H17 2UN"}="H171 2UN"; $resn_exch{"2H17 2UN"}="H172 2UN"; $resn_exch{"3H17 2UN"}="H173 2UN";
$resn_exch{"1H18 2UN"}="H181 2UN"; $resn_exch{"2H18 2UN"}="H182 2UN"; $resn_exch{"3H18 2UN"}="H183 2UN";
$resn_exch{"1H10 2UN"}="H101 2UN"; $resn_exch{"2H10 2UN"}="H102 2UN"; $resn_exch{"1HG2 2VA"}="HG21 2VA";
$resn_exch{"2HG2 2VA"}="HG22 2VA"; $resn_exch{"3HG2 2VA"}="HG23 2VA"; $resn_exch{"1HG1 2VA"}="HG11 2VA";
$resn_exch{"2HG1 2VA"}="HG12 2VA"; $resn_exch{"3HG1 2VA"}="HG13 2VA"; $resn_exch{"1HN  2VA"}=" H   2VA";
$resn_exch{"2HN  2VA"}=" H2  2VA"; $resn_exch{" H2* 2VA"}=" H2' 2VA"; $resn_exch{" H3* 2VA"}=" H3' 2VA";
$resn_exch{" H4* 2VA"}=" H4' 2VA"; $resn_exch{"1H5* 2VA"}="H5'1 2VA"; $resn_exch{"2H5* 2VA"}="H5'2 2VA";
$resn_exch{" H5* 2VA"}=" H5' 2VA"; $resn_exch{" H1* 2VA"}=" H1' 2VA"; $resn_exch{" H2  2VA"}=" HC2 2VA";
$resn_exch{"1HN6 2VA"}="HN61 2VA"; $resn_exch{"2HN6 2VA"}="HN62 2VA"; $resn_exch{"1H13 300"}="H131 300";
$resn_exch{"2H13 300"}="H132 300"; $resn_exch{"3H13 300"}="H133 300"; $resn_exch{"1H13 302"}="H131 302";
$resn_exch{"2H13 302"}="H132 302"; $resn_exch{"1H12 302"}="H121 302"; $resn_exch{"2H12 302"}="H122 302";
$resn_exch{"1H19 303"}="H191 303"; $resn_exch{"2H19 303"}="H192 303"; $resn_exch{"1H32 303"}="H321 303";
$resn_exch{"2H32 303"}="H322 303"; $resn_exch{"1H33 303"}="H331 303"; $resn_exch{"2H33 303"}="H332 303";
$resn_exch{"1H42 303"}="H421 303"; $resn_exch{"2H42 303"}="H422 303"; $resn_exch{"3H42 303"}="H423 303";
$resn_exch{"1H46 303"}="H461 303"; $resn_exch{"2H46 303"}="H462 303"; $resn_exch{"3H46 303"}="H463 303";
$resn_exch{"1H13 306"}="H131 306"; $resn_exch{"2H13 306"}="H132 306"; $resn_exch{"1H25 306"}="H251 306";
$resn_exch{"2H25 306"}="H252 306"; $resn_exch{"1H26 306"}="H261 306"; $resn_exch{"2H26 306"}="H262 306";
$resn_exch{"1H27 306"}="H271 306"; $resn_exch{"2H27 306"}="H272 306"; $resn_exch{"1H28 306"}="H281 306";
$resn_exch{"2H28 306"}="H282 306"; $resn_exch{"1H29 306"}="H291 306"; $resn_exch{"2H29 306"}="H292 306";
$resn_exch{"1H14 307"}="H141 307"; $resn_exch{"2H14 307"}="H142 307"; $resn_exch{"1H22 307"}="H221 307";
$resn_exch{"2H22 307"}="H222 307"; $resn_exch{"3H22 307"}="H223 307"; $resn_exch{"1H23 307"}="H231 307";
$resn_exch{"2H23 307"}="H232 307"; $resn_exch{"1H24 307"}="H241 307"; $resn_exch{"2H24 307"}="H242 307";
$resn_exch{"1H28 307"}="H281 307"; $resn_exch{"2H28 307"}="H282 307"; $resn_exch{"3H28 307"}="H283 307";
$resn_exch{"1H26 307"}="H261 307"; $resn_exch{"2H26 307"}="H262 307"; $resn_exch{"1H39 307"}="H391 307";
$resn_exch{"2H39 307"}="H392 307"; $resn_exch{"3H39 307"}="H393 307"; $resn_exch{"1H37 307"}="H371 307";
$resn_exch{"2H37 307"}="H372 307"; $resn_exch{"3H37 307"}="H373 307"; $resn_exch{"H3'' 312"}=" H3B 312";
$resn_exch{"H4'' 312"}=" H4B 312"; $resn_exch{"H5'' 312"}=" H5B 312"; $resn_exch{"H6'' 312"}=" H6B 312";
$resn_exch{"1H17 326"}="H171 326"; $resn_exch{"2H17 326"}="H172 326"; $resn_exch{"3H17 326"}="H173 326";
$resn_exch{"1H21 326"}="H211 326"; $resn_exch{"2H21 326"}="H212 326"; $resn_exch{"3H21 326"}="H213 326";
$resn_exch{"1H7  32P"}=" H71 32P"; $resn_exch{"2H7  32P"}=" H72 32P"; $resn_exch{"1H15 32P"}="H151 32P";
$resn_exch{"2H15 32P"}="H152 32P"; $resn_exch{"1H18 32P"}="H181 32P"; $resn_exch{"2H18 32P"}="H182 32P";
$resn_exch{"3H18 32P"}="H183 32P"; $resn_exch{"1H19 32P"}="H191 32P"; $resn_exch{"2H19 32P"}="H192 32P";
$resn_exch{"1H20 32P"}="H201 32P"; $resn_exch{"2H20 32P"}="H202 32P"; $resn_exch{"1H21 32P"}="H211 32P";
$resn_exch{"2H21 32P"}="H212 32P"; $resn_exch{"1H22 32P"}="H221 32P"; $resn_exch{"2H22 32P"}="H222 32P";
$resn_exch{"1HN3 32P"}="HN31 32P"; $resn_exch{"2HN3 32P"}="HN32 32P"; $resn_exch{"1H23 32P"}="H231 32P";
$resn_exch{"2H23 32P"}="H232 32P"; $resn_exch{"1HB  32S"}=" HB1 32S"; $resn_exch{"2HB  32S"}=" HB2 32S";
$resn_exch{"1HB  32T"}=" HB1 32T"; $resn_exch{"2HB  32T"}=" HB2 32T"; $resn_exch{"1H21 330"}="H211 330";
$resn_exch{"2H21 330"}="H212 330"; $resn_exch{"1H22 330"}="H221 330"; $resn_exch{"2H22 330"}="H222 330";
$resn_exch{"1H23 330"}="H231 330"; $resn_exch{"2H23 330"}="H232 330"; $resn_exch{"1H24 330"}="H241 330";
$resn_exch{"2H24 330"}="H242 330"; $resn_exch{"3H24 330"}="H243 330"; $resn_exch{"1H38 333"}="H381 333";
$resn_exch{"2H38 333"}="H382 333"; $resn_exch{"1H32 335"}="H321 335"; $resn_exch{"2H32 335"}="H322 335";
$resn_exch{"1H12 335"}="H121 335"; $resn_exch{"2H12 335"}="H122 335"; $resn_exch{"1H1  336"}=" H11 336";
$resn_exch{"2H1  336"}=" H12 336"; $resn_exch{"1H6  336"}=" H61 336"; $resn_exch{"2H6  336"}=" H62 336";
$resn_exch{"1H9  336"}=" H91 336"; $resn_exch{"2H9  336"}=" H92 336"; $resn_exch{"1H13 336"}="H131 336";
$resn_exch{"2H13 336"}="H132 336"; $resn_exch{"1H22 336"}="H221 336"; $resn_exch{"2H22 336"}="H222 336";
$resn_exch{"1H25 336"}="H251 336"; $resn_exch{"2H25 336"}="H252 336"; $resn_exch{"1H43 336"}="H431 336";
$resn_exch{"2H43 336"}="H432 336"; $resn_exch{"1H46 336"}="H461 336"; $resn_exch{"2H46 336"}="H462 336";
$resn_exch{"1H51 336"}="H511 336"; $resn_exch{"2H51 336"}="H512 336"; $resn_exch{"1H56 336"}="H561 336";
$resn_exch{"2H56 336"}="H562 336"; $resn_exch{"1H58 336"}="H581 336"; $resn_exch{"2H58 336"}="H582 336";
$resn_exch{"1H61 336"}="H611 336"; $resn_exch{"2H61 336"}="H612 336"; $resn_exch{"1H2  339"}="H21A 339";
$resn_exch{"2H2  339"}=" H22 339"; $resn_exch{"1H3  339"}=" H31 339"; $resn_exch{"2H3  339"}=" H32 339";
$resn_exch{"1H4  339"}=" H41 339"; $resn_exch{"2H4  339"}=" H42 339"; $resn_exch{"1HN7 339"}="HN71 339";
$resn_exch{"2HN7 339"}="HN72 339"; $resn_exch{"1HN8 339"}="HN81 339"; $resn_exch{"2HN8 339"}="HN82 339";
$resn_exch{"1H18 339"}="H181 339"; $resn_exch{"2H18 339"}="H182 339"; $resn_exch{"3H18 339"}="H183 339";
$resn_exch{"1H19 339"}="H191 339"; $resn_exch{"2H19 339"}="H192 339"; $resn_exch{"3H19 339"}="H193 339";
$resn_exch{"1H24 339"}="H241 339"; $resn_exch{"2H24 339"}="H242 339"; $resn_exch{"1H25 339"}="H251 339";
$resn_exch{"2H25 339"}="H252 339"; $resn_exch{"1H26 339"}="H261 339"; $resn_exch{"2H26 339"}="H262 339";
$resn_exch{"1H29 339"}="H291 339"; $resn_exch{"2H29 339"}="H292 339"; $resn_exch{"1H42 339"}="H421 339";
$resn_exch{"2H42 339"}="H422 339"; $resn_exch{"3H42 339"}="H423 339"; $resn_exch{"1H23 33A"}="H231 33A";
$resn_exch{"2H23 33A"}="H232 33A"; $resn_exch{"1H2A 33P"}="H2A1 33P"; $resn_exch{"2H2A 33P"}="H2A2 33P";
$resn_exch{"3H2A 33P"}="H2A3 33P"; $resn_exch{"1H4A 33P"}="H4A1 33P"; $resn_exch{"2H4A 33P"}="H4A2 33P";
$resn_exch{"1H5A 33P"}="H5A1 33P"; $resn_exch{"2H5A 33P"}="H5A2 33P"; $resn_exch{"2HOA 33P"}="HOA2 33P";
$resn_exch{"3HOA 33P"}="HOA3 33P"; $resn_exch{"2HOB 33P"}="HOB2 33P"; $resn_exch{"3HOB 33P"}="HOB3 33P";
$resn_exch{"1H8  33P"}=" H81 33P"; $resn_exch{"2H8  33P"}=" H82 33P"; $resn_exch{"1H10 33P"}="H101 33P";
$resn_exch{"2H10 33P"}="H102 33P"; $resn_exch{"3H10 33P"}="H103 33P"; $resn_exch{"1H47 33Z"}="H471 33Z";
$resn_exch{"2H47 33Z"}="H472 33Z"; $resn_exch{"1H35 33Z"}="H351 33Z"; $resn_exch{"2H35 33Z"}="H352 33Z";
$resn_exch{"1H30 33Z"}="H301 33Z"; $resn_exch{"2H30 33Z"}="H302 33Z"; $resn_exch{"3H30 33Z"}="H303 33Z";
$resn_exch{"1H29 33Z"}="H291 33Z"; $resn_exch{"2H29 33Z"}="H292 33Z"; $resn_exch{"3H29 33Z"}="H293 33Z";
$resn_exch{"1H23 33Z"}="H231 33Z"; $resn_exch{"2H23 33Z"}="H232 33Z"; $resn_exch{"1H11 33Z"}="H111 33Z";
$resn_exch{"2H11 33Z"}="H112 33Z"; $resn_exch{"1H1  340"}=" H11 340"; $resn_exch{"1H12 340"}="H121 340";
$resn_exch{"2H12 340"}="H122 340"; $resn_exch{"3H12 340"}="H123 340"; $resn_exch{"1H19 340"}="H191 340";
$resn_exch{"2H19 340"}="H192 340"; $resn_exch{"1H25 340"}="H251 340"; $resn_exch{"1H26 340"}="H261 340";
$resn_exch{"1H27 340"}="H271 340"; $resn_exch{"1H28 340"}="H281 340"; $resn_exch{"1H29 340"}="H291 340";
$resn_exch{"1H37 340"}="H371 340"; $resn_exch{"2H37 340"}="H372 340"; $resn_exch{"3H37 340"}="H373 340";
$resn_exch{"1H45 340"}="H451 340"; $resn_exch{"2H45 340"}="H452 340"; $resn_exch{"3H45 340"}="H453 340";
$resn_exch{"1H38 342"}="H381 342"; $resn_exch{"2H38 342"}="H382 342"; $resn_exch{"1H27 342"}="H271 342";
$resn_exch{"2H27 342"}="H272 342"; $resn_exch{"1H22 342"}="H221 342"; $resn_exch{"2H22 342"}="H222 342";
$resn_exch{"1H24 342"}="H241 342"; $resn_exch{"2H24 342"}="H242 342"; $resn_exch{"1H25 342"}="H251 342";
$resn_exch{"2H25 342"}="H252 342"; $resn_exch{"1H26 342"}="H261 342"; $resn_exch{"2H26 342"}="H262 342";
$resn_exch{"1H47 343"}="H471 343"; $resn_exch{"2H47 343"}="H472 343"; $resn_exch{"1H35 343"}="H351 343";
$resn_exch{"2H35 343"}="H352 343"; $resn_exch{"1H30 343"}="H301 343"; $resn_exch{"2H30 343"}="H302 343";
$resn_exch{"3H30 343"}="H303 343"; $resn_exch{"1H29 343"}="H291 343"; $resn_exch{"2H29 343"}="H292 343";
$resn_exch{"3H29 343"}="H293 343"; $resn_exch{"1H11 343"}="H111 343"; $resn_exch{"2H11 343"}="H112 343";
$resn_exch{"1HN2 344"}="HN21 344"; $resn_exch{"2HN2 344"}="HN22 344"; $resn_exch{"1H26 345"}="H261 345";
$resn_exch{"2H26 345"}="H262 345"; $resn_exch{"1H27 345"}="H271 345"; $resn_exch{"2H27 345"}="H272 345";
$resn_exch{"1H29 345"}="H291 345"; $resn_exch{"2H29 345"}="H292 345"; $resn_exch{"1H30 345"}="H301 345";
$resn_exch{"2H30 345"}="H302 345"; $resn_exch{"1H39 345"}="H391 345"; $resn_exch{"2H39 345"}="H392 345";
$resn_exch{"2H27 346"}="H272 346"; $resn_exch{"1H27 346"}="H271 346"; $resn_exch{"2H29 346"}="H292 346";
$resn_exch{"1H29 346"}="H291 346"; $resn_exch{"2H31 346"}="H312 346"; $resn_exch{"1H31 346"}="H311 346";
$resn_exch{"1H24 346"}="H241 346"; $resn_exch{"2H24 346"}="H242 346"; $resn_exch{"3H30 346"}="H303 346";
$resn_exch{"2H30 346"}="H302 346"; $resn_exch{"1H30 346"}="H301 346"; $resn_exch{"1H1  347"}=" H11 347";
$resn_exch{"2H1  347"}=" H12 347"; $resn_exch{"3H1  347"}=" H13 347"; $resn_exch{"1H4  347"}=" H41 347";
$resn_exch{"2H4  347"}=" H42 347"; $resn_exch{"1H11 347"}="H111 347"; $resn_exch{"2H11 347"}="H112 347";
$resn_exch{"1H13 347"}="H131 347"; $resn_exch{"2H13 347"}="H132 347"; $resn_exch{"1H14 347"}="H141 347";
$resn_exch{"2H14 347"}="H142 347"; $resn_exch{"1H15 347"}="H151 347"; $resn_exch{"2H15 347"}="H152 347";
$resn_exch{"1H16 347"}="H161 347"; $resn_exch{"2H16 347"}="H162 347"; $resn_exch{"1H19 347"}="H191 347";
$resn_exch{"2H19 347"}="H192 347"; $resn_exch{"3H19 347"}="H193 347"; $resn_exch{"1H20 347"}="H201 347";
$resn_exch{"2H20 347"}="H202 347"; $resn_exch{"3H20 347"}="H203 347"; $resn_exch{"1H21 347"}="H211 347";
$resn_exch{"2H21 347"}="H212 347"; $resn_exch{"3H21 347"}="H213 347"; $resn_exch{"1H1N 348"}="H1N1 348";
$resn_exch{"2H1N 348"}="H1N2 348"; $resn_exch{"1H12 348"}="H121 348"; $resn_exch{"2H12 348"}="H122 348";
$resn_exch{"1H13 348"}="H131 348"; $resn_exch{"2H13 348"}="H132 348"; $resn_exch{"1H14 348"}="H141 348";
$resn_exch{"2H14 348"}="H142 348"; $resn_exch{"1H23 348"}="H231 348"; $resn_exch{"2H23 348"}="H232 348";
$resn_exch{"1H28 348"}="H281 348"; $resn_exch{"2H28 348"}="H282 348"; $resn_exch{"3H28 348"}="H283 348";
$resn_exch{"1H41 348"}="H411 348"; $resn_exch{"2H41 348"}="H412 348"; $resn_exch{"3H41 348"}="H413 348";
$resn_exch{"1H42 348"}="H421 348"; $resn_exch{"2H42 348"}="H422 348"; $resn_exch{"3H42 348"}="H423 348";
$resn_exch{"1HN1 34A"}="HN11 34A"; $resn_exch{"2HN1 34A"}="HN12 34A"; $resn_exch{"1H7  34A"}=" H71 34A";
$resn_exch{"2H7  34A"}=" H72 34A"; $resn_exch{"3H7  34A"}=" H73 34A"; $resn_exch{"1H8  34A"}=" H81 34A";
$resn_exch{"2H8  34A"}=" H82 34A"; $resn_exch{"3H8  34A"}=" H83 34A"; $resn_exch{"1H5' 34B"}="H5'1 34B";
$resn_exch{"2H5' 34B"}="H5'2 34B"; $resn_exch{"1H6' 34B"}="H6'1 34B"; $resn_exch{"2H6' 34B"}="H6'2 34B";
$resn_exch{"3H6' 34B"}="H6'3 34B"; $resn_exch{"1HC2 34C"}="HC21 34C"; $resn_exch{"1HC4 34C"}="HC41 34C";
$resn_exch{"1HC5 34C"}="HC51 34C"; $resn_exch{"1HC7 34C"}="HC71 34C"; $resn_exch{"2HC7 34C"}="HC72 34C";
$resn_exch{"1HC9 34C"}="HC91 34C"; $resn_exch{"2HC9 34C"}="HC92 34C"; $resn_exch{"1H10 34C"}="H101 34C";
$resn_exch{"2H10 34C"}="H102 34C"; $resn_exch{"1H11 34C"}="H111 34C"; $resn_exch{"2H11 34C"}="H112 34C";
$resn_exch{"3H11 34C"}="H113 34C"; $resn_exch{"1H7  34P"}=" H71 34P"; $resn_exch{"2H7  34P"}=" H72 34P";
$resn_exch{"1H12 34P"}="H121 34P"; $resn_exch{"2H12 34P"}="H122 34P"; $resn_exch{"1H13 34P"}="H131 34P";
$resn_exch{"2H13 34P"}="H132 34P"; $resn_exch{"1H14 34P"}="H141 34P"; $resn_exch{"2H14 34P"}="H142 34P";
$resn_exch{"1H20 34P"}="H201 34P"; $resn_exch{"2H20 34P"}="H202 34P"; $resn_exch{"1H21 34P"}="H211 34P";
$resn_exch{"2H21 34P"}="H212 34P"; $resn_exch{"1H23 34P"}="H231 34P"; $resn_exch{"2H23 34P"}="H232 34P";
$resn_exch{"1H24 34P"}="H241 34P"; $resn_exch{"2H24 34P"}="H242 34P"; $resn_exch{"1H25 34P"}="H251 34P";
$resn_exch{"2H25 34P"}="H252 34P"; $resn_exch{"1H26 34P"}="H261 34P"; $resn_exch{"2H26 34P"}="H262 34P";
$resn_exch{"1H27 34P"}="H271 34P"; $resn_exch{"2H27 34P"}="H272 34P"; $resn_exch{"1H29 34P"}="H291 34P";
$resn_exch{"2H29 34P"}="H292 34P"; $resn_exch{"1HN2 354"}="HN21 354"; $resn_exch{"2HN2 354"}="HN22 354";
$resn_exch{"1HB  354"}=" HB1 354"; $resn_exch{"2HB  354"}=" HB2 354"; $resn_exch{"1HG  354"}=" HG1 354";
$resn_exch{"2HG  354"}=" HG2 354"; $resn_exch{"1H10 357"}="H101 357"; $resn_exch{"2H10 357"}="H102 357";
$resn_exch{"1H11 357"}="H111 357"; $resn_exch{"2H11 357"}="H112 357"; $resn_exch{"3H11 357"}="H113 357";
$resn_exch{"1H7* 357"}="H7'1 357"; $resn_exch{"2H7* 357"}="H7'2 357"; $resn_exch{"1H7  357"}=" H71 357";
$resn_exch{"2H7  357"}=" H72 357"; $resn_exch{"3H7  357"}=" H73 357"; $resn_exch{"1H6\" 357"}="H6'1 357";
$resn_exch{"2H6\" 357"}="H6'2 357"; $resn_exch{"3H6\" 357"}="H6'3 357"; $resn_exch{"1H2\" 357"}="H2'1 357";
$resn_exch{"2H2\" 357"}="H2'2 357"; $resn_exch{"1H3\" 357"}="H3'1 357"; $resn_exch{"2H3\" 357"}="H3'2 357";
$resn_exch{"1H5\" 357"}="H5'1 357"; $resn_exch{"2H5\" 357"}="H5'2 357"; $resn_exch{"3H5\" 357"}="H5'3 357";
$resn_exch{" H6* 357"}=" H6' 357"; $resn_exch{" H5* 357"}=" H5' 357"; $resn_exch{" H4* 357"}=" H4' 357";
$resn_exch{"1H8* 357"}="H8'1 357"; $resn_exch{"2H8* 357"}="H8'2 357"; $resn_exch{"3H8* 357"}="H8'3 357";
$resn_exch{" H2* 357"}=" H2' 357"; $resn_exch{"1H8  358"}=" H81 358"; $resn_exch{"2H8  358"}=" H82 358";
$resn_exch{"1H9  358"}=" H91 358"; $resn_exch{"2H9  358"}=" H92 358"; $resn_exch{"1H23 358"}="H231 358";
$resn_exch{"2H23 358"}="H232 358"; $resn_exch{"1H24 358"}="H241 358"; $resn_exch{"2H24 358"}="H242 358";
$resn_exch{"1H25 358"}="H251 358"; $resn_exch{"2H25 358"}="H252 358"; $resn_exch{"1H26 358"}="H261 358";
$resn_exch{"2H26 358"}="H262 358"; $resn_exch{"1H4  35A"}=" H41 35A"; $resn_exch{"2H4  35A"}=" H42 35A";
$resn_exch{"1H6  35A"}=" H61 35A"; $resn_exch{"2H6  35A"}=" H62 35A"; $resn_exch{"1H11 35A"}="H111 35A";
$resn_exch{"2H11 35A"}="H112 35A"; $resn_exch{"1H13 35A"}="H131 35A"; $resn_exch{"2H13 35A"}="H132 35A";
$resn_exch{"1H14 35A"}="H141 35A"; $resn_exch{"2H14 35A"}="H142 35A"; $resn_exch{"1H16 35A"}="H161 35A";
$resn_exch{"2H16 35A"}="H162 35A"; $resn_exch{"1H20 35A"}="H201 35A"; $resn_exch{"2H20 35A"}="H202 35A";
$resn_exch{"3H20 35A"}="H203 35A"; $resn_exch{"1H23 35A"}="H231 35A"; $resn_exch{"2H23 35A"}="H232 35A";
$resn_exch{"3H23 35A"}="H233 35A"; $resn_exch{"1H24 35A"}="H241 35A"; $resn_exch{"2H24 35A"}="H242 35A";
$resn_exch{"3H24 35A"}="H243 35A"; $resn_exch{"1H27 35A"}="H271 35A"; $resn_exch{"2H27 35A"}="H272 35A";
$resn_exch{"3H27 35A"}="H273 35A"; $resn_exch{"1H28 35A"}="H281 35A"; $resn_exch{"2H28 35A"}="H282 35A";
$resn_exch{"2HOP 35G"}="HOP2 35G"; $resn_exch{"1H5* 35G"}="H5'1 35G"; $resn_exch{"2H5* 35G"}="H5'2 35G";
$resn_exch{" H4* 35G"}=" H4' 35G"; $resn_exch{" H3* 35G"}=" H3' 35G"; $resn_exch{" H2* 35G"}=" H2' 35G";
$resn_exch{"*HO2 35G"}="HO2' 35G"; $resn_exch{" H1* 35G"}=" H1' 35G"; $resn_exch{"1HN2 35G"}="HN21 35G";
$resn_exch{"2HN2 35G"}="HN22 35G"; $resn_exch{"1HAU 364"}="HAU1 364"; $resn_exch{"2HAU 364"}="HAU2 364";
$resn_exch{"1H19 367"}="H191 367"; $resn_exch{"2H19 367"}="H192 367"; $resn_exch{"1H44 367"}="H441 367";
$resn_exch{"2H44 367"}="H442 367"; $resn_exch{"1H45 367"}="H451 367"; $resn_exch{"2H45 367"}="H452 367";
$resn_exch{"1H46 367"}="H461 367"; $resn_exch{"2H46 367"}="H462 367"; $resn_exch{"1H09 368"}="H091 368";
$resn_exch{"2H09 368"}="H092 368"; $resn_exch{"1H13 368"}="H131 368"; $resn_exch{"2H13 368"}="H132 368";
$resn_exch{"1HP6 368"}="HP61 368"; $resn_exch{"2HP6 368"}="HP62 368"; $resn_exch{"1H27 368"}="H271 368";
$resn_exch{"2H27 368"}="H272 368"; $resn_exch{"1H16 371"}="H161 371"; $resn_exch{"2H16 371"}="H162 371";
$resn_exch{"3H16 371"}="H163 371"; $resn_exch{"1H17 371"}="H171 371"; $resn_exch{"2H17 371"}="H172 371";
$resn_exch{"1H18 371"}="H181 371"; $resn_exch{"2H18 371"}="H182 371"; $resn_exch{"1H19 371"}="H191 371";
$resn_exch{"2H19 371"}="H192 371"; $resn_exch{"1H31 373"}="H311 373"; $resn_exch{"2H31 373"}="H312 373";
$resn_exch{"1H35 373"}="H351 373"; $resn_exch{"2H35 373"}="H352 373"; $resn_exch{"1H36 373"}="H361 373";
$resn_exch{"2H36 373"}="H362 373"; $resn_exch{"1H38 373"}="H381 373"; $resn_exch{"2H38 373"}="H382 373";
$resn_exch{"1H39 373"}="H391 373"; $resn_exch{"2H39 373"}="H392 373"; $resn_exch{"1H48 373"}="H481 373";
$resn_exch{"2H48 373"}="H482 373"; $resn_exch{"1H50 373"}="H501 373"; $resn_exch{"2H50 373"}="H502 373";
$resn_exch{"1H7  37A"}=" H71 37A"; $resn_exch{"2H7  37A"}=" H72 37A"; $resn_exch{"1H3  37A"}=" H31 37A";
$resn_exch{"2H3  37A"}=" H32 37A"; $resn_exch{"1H12 37A"}="H121 37A"; $resn_exch{"2H12 37A"}="H122 37A";
$resn_exch{"1H13 37T"}="H131 37T"; $resn_exch{"2H13 37T"}="H132 37T"; $resn_exch{"3H13 37T"}="H133 37T";
$resn_exch{"1H12 37T"}="H121 37T"; $resn_exch{"2H12 37T"}="H122 37T"; $resn_exch{"3H12 37T"}="H123 37T";
$resn_exch{"1H1N 380"}="H1N1 380"; $resn_exch{"2H1N 380"}="H1N2 380"; $resn_exch{"1H25 380"}="H251 380";
$resn_exch{"2H25 380"}="H252 380"; $resn_exch{"1H24 380"}="H241 380"; $resn_exch{"2H24 380"}="H242 380";
$resn_exch{"3H24 380"}="H243 380"; $resn_exch{"1H32 380"}="H321 380"; $resn_exch{"2H32 380"}="H322 380";
$resn_exch{"3H32 380"}="H323 380"; $resn_exch{"1H1  382"}=" H11 382"; $resn_exch{"2H1  382"}=" H12 382";
$resn_exch{"1H2  382"}=" H21 382"; $resn_exch{"2H2  382"}=" H22 382"; $resn_exch{"1H5  382"}=" H51 382";
$resn_exch{"2H5  382"}="H52A 382"; $resn_exch{"1H6  382"}=" H61 382"; $resn_exch{"2H6  382"}=" H62 382";
$resn_exch{"1H19 382"}="H191 382"; $resn_exch{"2H19 382"}="H192 382"; $resn_exch{"1H34 382"}="H341 382";
$resn_exch{"2H34 382"}="H342 382"; $resn_exch{"1H14 383"}="H141 383"; $resn_exch{"2H14 383"}="H142 383";
$resn_exch{"1H16 383"}="H161 383"; $resn_exch{"2H16 383"}="H162 383"; $resn_exch{"1H30 383"}="H301 383";
$resn_exch{"2H30 383"}="H302 383"; $resn_exch{"1H4  385"}=" H41 385"; $resn_exch{"2H4  385"}=" H42 385";
$resn_exch{"1H7  385"}=" H71 385"; $resn_exch{"2H7  385"}=" H72 385"; $resn_exch{"1H9  385"}=" H91 385";
$resn_exch{"2H9  385"}=" H92 385"; $resn_exch{"1H14 385"}="H141 385"; $resn_exch{"2H14 385"}="H142 385";
$resn_exch{"1H17 385"}="H171 385"; $resn_exch{"2H17 385"}="H172 385"; $resn_exch{"1H25 385"}="H251 385";
$resn_exch{"2H25 385"}="H252 385"; $resn_exch{"1H34 385"}="H341 385"; $resn_exch{"2H34 385"}="H342 385";
$resn_exch{"3H34 385"}="H343 385"; $resn_exch{"1H35 385"}="H351 385"; $resn_exch{"2H35 385"}="H352 385";
$resn_exch{"3H35 385"}="H353 385"; $resn_exch{"1H36 385"}="H361 385"; $resn_exch{"2H36 385"}="H362 385";
$resn_exch{"1H45 385"}="H451 385"; $resn_exch{"2H45 385"}="H452 385"; $resn_exch{"1H48 385"}="H481 385";
$resn_exch{"2H48 385"}="H482 385"; $resn_exch{"3H48 385"}="H483 385"; $resn_exch{"1H1  388"}=" H11 388";
$resn_exch{"2H1  388"}=" H12 388"; $resn_exch{"1H21 388"}="H211 388"; $resn_exch{"2H21 388"}="H212 388";
$resn_exch{"1H38 391"}="H381 391"; $resn_exch{"2H38 391"}="H382 391"; $resn_exch{"1H27 391"}="H271 391";
$resn_exch{"2H27 391"}="H272 391"; $resn_exch{"3H27 391"}="H273 391"; $resn_exch{"1H7  393"}=" H71 393";
$resn_exch{"2H7  393"}=" H72 393"; $resn_exch{"1H18 393"}="H181 393"; $resn_exch{"2H18 393"}="H182 393";
$resn_exch{"1H14 394"}="H141 394"; $resn_exch{"2H14 394"}="H142 394"; $resn_exch{"1H15 394"}="H151 394";
$resn_exch{"2H15 394"}="H152 394"; $resn_exch{"1H18 394"}="H181 394"; $resn_exch{"2H18 394"}="H182 394";
$resn_exch{"3H18 394"}="H183 394"; $resn_exch{"1H19 394"}="H191 394"; $resn_exch{"2H19 394"}="H192 394";
$resn_exch{"3H19 394"}="H193 394"; $resn_exch{"1H20 394"}="H201 394"; $resn_exch{"2H20 394"}="H202 394";
$resn_exch{"3H20 394"}="H203 394"; $resn_exch{"1H21 394"}="H211 394"; $resn_exch{"2H21 394"}="H212 394";
$resn_exch{"3H21 394"}="H213 394"; $resn_exch{"2HO2 394"}="HO22 394"; $resn_exch{"7HO2 394"}="HO27 394";
$resn_exch{"1H14 395"}="H141 395"; $resn_exch{"2H14 395"}="H142 395"; $resn_exch{"1H15 395"}="H151 395";
$resn_exch{"2H15 395"}="H152 395"; $resn_exch{"1H18 395"}="H181 395"; $resn_exch{"2H18 395"}="H182 395";
$resn_exch{"3H18 395"}="H183 395"; $resn_exch{"1H19 395"}="H191 395"; $resn_exch{"2H19 395"}="H192 395";
$resn_exch{"3H19 395"}="H193 395"; $resn_exch{"1H20 395"}="H201 395"; $resn_exch{"2H20 395"}="H202 395";
$resn_exch{"3H20 395"}="H203 395"; $resn_exch{"1H21 395"}="H211 395"; $resn_exch{"2H21 395"}="H212 395";
$resn_exch{"3H21 395"}="H213 395"; $resn_exch{"2HO2 395"}="HO22 395"; $resn_exch{"7HO2 395"}="HO27 395";
$resn_exch{"1HN6 39A"}="HN61 39A"; $resn_exch{"2HN6 39A"}="HN62 39A"; $resn_exch{"1H9M 39A"}="H9M1 39A";
$resn_exch{"2H9M 39A"}="H9M2 39A"; $resn_exch{"3H9M 39A"}="H9M3 39A"; $resn_exch{"1H3M 39A"}="H3M1 39A";
$resn_exch{"2H3M 39A"}="H3M2 39A"; $resn_exch{"3H3M 39A"}="H3M3 39A"; $resn_exch{"1H2' 39B"}="H2'1 39B";
$resn_exch{"2H2' 39B"}="H2'2 39B"; $resn_exch{"1H4' 39B"}="H4'1 39B"; $resn_exch{"2H4' 39B"}="H4'2 39B";
$resn_exch{"1H5' 39B"}="H5'1 39B"; $resn_exch{"2H5' 39B"}="H5'2 39B"; $resn_exch{"1H6' 39B"}="H6'1 39B";
$resn_exch{"2H6' 39B"}="H6'2 39B"; $resn_exch{"3H6' 39B"}="H6'3 39B"; $resn_exch{"1H2' 39E"}="H2'1 39E";
$resn_exch{"2HA  39E"}=" HA2 39E"; $resn_exch{"1HA  39E"}=" HA1 39E"; $resn_exch{"2HB  39E"}=" HB2 39E";
$resn_exch{"1HB  39E"}=" HB1 39E"; $resn_exch{"2HC  39E"}=" HC2 39E"; $resn_exch{"1HC  39E"}=" HC1 39E";
$resn_exch{"2HD  39E"}=" HD2 39E"; $resn_exch{"3HE  39E"}=" HE3 39E"; $resn_exch{"1H20 39Z"}="H201 39Z";
$resn_exch{"2H20 39Z"}="H202 39Z"; $resn_exch{"3H20 39Z"}="H203 39Z"; $resn_exch{"1H19 3A3"}="H191 3A3";
$resn_exch{"2H19 3A3"}="H192 3A3"; $resn_exch{"1H20 3A3"}="H201 3A3"; $resn_exch{"2H20 3A3"}="H202 3A3";
$resn_exch{"1H5* 3AA"}="H5'1 3AA"; $resn_exch{"2H5* 3AA"}="H5'2 3AA"; $resn_exch{"4H*  3AA"}=" H'4 3AA";
$resn_exch{"1H*  3AA"}=" H'1 3AA"; $resn_exch{"1HN6 3AA"}="HN61 3AA"; $resn_exch{"2HN6 3AA"}="HN62 3AA";
$resn_exch{"2H*  3AA"}=" H'2 3AA"; $resn_exch{"3H*  3AA"}=" H'3 3AA"; $resn_exch{"HA3* 3AA"}="HA3' 3AA";
$resn_exch{"H15* 3AA"}="H15' 3AA"; $resn_exch{"H25* 3AA"}="H25' 3AA"; $resn_exch{"HC4* 3AA"}="HC4' 3AA";
$resn_exch{" H3* 3AA"}=" H3' 3AA"; $resn_exch{"HO3* 3AA"}="HO3' 3AA"; $resn_exch{" H2* 3AA"}=" H2' 3AA";
$resn_exch{"HO2* 3AA"}="HO2' 3AA"; $resn_exch{" H1* 3AA"}=" H1' 3AA"; $resn_exch{"1HN7 3AA"}="HN71 3AA";
$resn_exch{"2HN7 3AA"}="HN72 3AA"; $resn_exch{"1H51 3AC"}="H511 3AC"; $resn_exch{"2H51 3AC"}="H512 3AC";
$resn_exch{"3H51 3AC"}="H513 3AC"; $resn_exch{"1H61 3AC"}="H611 3AC"; $resn_exch{"2H61 3AC"}="H612 3AC";
$resn_exch{"1H62 3AC"}="H621 3AC"; $resn_exch{"2H62 3AC"}="H622 3AC"; $resn_exch{"3H62 3AC"}="H623 3AC";
$resn_exch{"*HO5 3AD"}="HO5' 3AD"; $resn_exch{"1H5* 3AD"}="H5'1 3AD"; $resn_exch{"2H5* 3AD"}="H5'2 3AD";
$resn_exch{" H4* 3AD"}=" H4' 3AD"; $resn_exch{"1H3* 3AD"}="H3'1 3AD"; $resn_exch{"2H3* 3AD"}="H3'2 3AD";
$resn_exch{" H2* 3AD"}=" H2' 3AD"; $resn_exch{"*HO2 3AD"}="HO2' 3AD"; $resn_exch{" H1* 3AD"}=" H1' 3AD";
$resn_exch{"1HN6 3AD"}="HN61 3AD"; $resn_exch{"2HN6 3AD"}="HN62 3AD"; $resn_exch{"1H4  3AF"}=" H41 3AF";
$resn_exch{"3H4  3AF"}=" H43 3AF"; $resn_exch{"2H4  3AF"}=" H42 3AF"; $resn_exch{"1H5  3AF"}=" H51 3AF";
$resn_exch{"2H5  3AF"}=" H52 3AF"; $resn_exch{"3H5  3AF"}=" H53 3AF"; $resn_exch{"1H6  3AF"}=" H61 3AF";
$resn_exch{"3H6  3AF"}=" H63 3AF"; $resn_exch{"2H6  3AF"}=" H62 3AF"; $resn_exch{"1H7  3AF"}=" H71 3AF";
$resn_exch{"1HC1 3AG"}="HC11 3AG"; $resn_exch{"2HC1 3AG"}="HC12 3AG"; $resn_exch{"3HC1 3AG"}="HC13 3AG";
$resn_exch{"1HC3 3AG"}="HC31 3AG"; $resn_exch{"2HC3 3AG"}="HC32 3AG"; $resn_exch{"3HC3 3AG"}="HC33 3AG";
$resn_exch{"1HC5 3AG"}="HC51 3AG"; $resn_exch{"2HC5 3AG"}="HC52 3AG"; $resn_exch{"1HC6 3AG"}="HC61 3AG";
$resn_exch{"2HC6 3AG"}="HC62 3AG"; $resn_exch{"1HC7 3AG"}="HC71 3AG"; $resn_exch{"2HC7 3AG"}="HC72 3AG";
$resn_exch{"1HC8 3AG"}="HC81 3AG"; $resn_exch{"2HC8 3AG"}="HC82 3AG"; $resn_exch{"1HC9 3AG"}="HC91 3AG";
$resn_exch{"2HC9 3AG"}="HC92 3AG"; $resn_exch{"3HC9 3AG"}="HC93 3AG"; $resn_exch{" HN2 3AH"}=" H2  3AH";
$resn_exch{"1HB  3AH"}=" HB2 3AH"; $resn_exch{"2HB  3AH"}=" HB3 3AH"; $resn_exch{"1HN3 3AH"}="HN31 3AH";
$resn_exch{"2HN3 3AH"}="HN32 3AH"; $resn_exch{"1HN1 3AL"}="HN11 3AL"; $resn_exch{"2HN1 3AL"}="HN12 3AL";
$resn_exch{"HO2* 3AM"}="HO2' 3AM"; $resn_exch{" H2* 3AM"}=" H2' 3AM"; $resn_exch{" H3* 3AM"}=" H3' 3AM";
$resn_exch{" H1* 3AM"}=" H1' 3AM"; $resn_exch{" H4* 3AM"}=" H4' 3AM"; $resn_exch{" H5* 3AM"}=" H5' 3AM";
$resn_exch{"H5*A 3AM"}="H5'A 3AM"; $resn_exch{"HO5* 3AM"}="HO5' 3AM"; $resn_exch{"2HOB 3AN"}="HOB2 3AN";
$resn_exch{"3HOB 3AN"}="HOB3 3AN"; $resn_exch{"1HOA 3AN"}="HOA1 3AN"; $resn_exch{"1H5* 3AN"}="H5'1 3AN";
$resn_exch{"2H5* 3AN"}="H5'2 3AN"; $resn_exch{"4HC* 3AN"}="HC'4 3AN"; $resn_exch{"3HC* 3AN"}="HC'3 3AN";
$resn_exch{"1H3* 3AN"}="H3'1 3AN"; $resn_exch{"2H3* 3AN"}="H3'2 3AN"; $resn_exch{"2HC* 3AN"}="HC'2 3AN";
$resn_exch{"2HO* 3AN"}="HO'2 3AN"; $resn_exch{"1HC* 3AN"}="HC'1 3AN"; $resn_exch{"8HC  3AN"}=" HC8 3AN";
$resn_exch{"1HN6 3AN"}="HN61 3AN"; $resn_exch{"2HN6 3AN"}="HN62 3AN"; $resn_exch{"2HC  3AN"}=" HC2 3AN";
$resn_exch{"1HN3 3AP"}="HN31 3AP"; $resn_exch{"2HN3 3AP"}="HN32 3AP"; $resn_exch{" HN2 3AR"}=" H2  3AR";
$resn_exch{"1HB  3AR"}=" HB2 3AR"; $resn_exch{"2HB  3AR"}=" HB3 3AR"; $resn_exch{"1HG  3AR"}=" HG2 3AR";
$resn_exch{"2HG  3AR"}=" HG3 3AR"; $resn_exch{"1HD  3AR"}=" HD2 3AR"; $resn_exch{"2HD  3AR"}=" HD3 3AR";
$resn_exch{"1HH1 3AR"}=" HH1 3AR"; $resn_exch{"1HH2 3AR"}="HH21 3AR"; $resn_exch{"2HH2 3AR"}="HH22 3AR";
$resn_exch{"1H1  3AR"}=" H11 3AR"; $resn_exch{"2H1  3AR"}=" H12 3AR"; $resn_exch{"1H2  3AR"}=" H21 3AR";
$resn_exch{"2H2  3AR"}=" H22 3AR"; $resn_exch{"1H3  3AR"}=" H31 3AR"; $resn_exch{"2H3  3AR"}=" H32 3AR";
$resn_exch{"3H3  3AR"}=" H33 3AR"; $resn_exch{"2HOG 3AT"}="HOG2 3AT"; $resn_exch{"3HOG 3AT"}="HOG3 3AT";
$resn_exch{"2HOB 3AT"}="HOB2 3AT"; $resn_exch{"2HOA 3AT"}="HOA2 3AT"; $resn_exch{"1H5* 3AT"}="H5'1 3AT";
$resn_exch{"2H5* 3AT"}="H5'2 3AT"; $resn_exch{" H4* 3AT"}=" H4' 3AT"; $resn_exch{"1H3* 3AT"}="H3'1 3AT";
$resn_exch{"2H3* 3AT"}="H3'2 3AT"; $resn_exch{"1H2* 3AT"}="H2'1 3AT"; $resn_exch{"HO2* 3AT"}="HO2' 3AT";
$resn_exch{" H1* 3AT"}=" H1' 3AT"; $resn_exch{"1HN6 3AT"}="HN61 3AT"; $resn_exch{"2HN6 3AT"}="HN62 3AT";
$resn_exch{"1HAA 3AY"}="HAA1 3AY"; $resn_exch{"2HAA 3AY"}="HAA2 3AY"; $resn_exch{"1HAH 3AY"}="HAH1 3AY";
$resn_exch{"2HAH 3AY"}="HAH2 3AY"; $resn_exch{"1HAI 3AY"}="HAI1 3AY"; $resn_exch{"2HAI 3AY"}="HAI2 3AY";
$resn_exch{"1H6C 3B3"}="H6C1 3B3"; $resn_exch{"2H6C 3B3"}="H6C2 3B3"; $resn_exch{"1HAC 3B3"}="HAC1 3B3";
$resn_exch{"2HAC 3B3"}="HAC2 3B3"; $resn_exch{"1HN  3B3"}=" HN1 3B3"; $resn_exch{"2HN  3B3"}=" HN2 3B3";
$resn_exch{"1H1  3BB"}=" H11 3BB"; $resn_exch{"2H1  3BB"}=" H12 3BB"; $resn_exch{"1H3  3BB"}=" H31 3BB";
$resn_exch{"2H3  3BB"}=" H32 3BB"; $resn_exch{"1H4  3BB"}=" H41 3BB"; $resn_exch{"2H4  3BB"}=" H42 3BB";
$resn_exch{"1H5  3BC"}=" H51 3BC"; $resn_exch{"2H5  3BC"}=" H52 3BC"; $resn_exch{"3H5  3BC"}=" H53 3BC";
$resn_exch{"1H6  3BC"}=" H61 3BC"; $resn_exch{"2H6  3BC"}=" H62 3BC"; $resn_exch{"3H6  3BC"}=" H63 3BC";
$resn_exch{"1H7  3BC"}=" H71 3BC"; $resn_exch{"2H7  3BC"}=" H72 3BC"; $resn_exch{"3H7  3BC"}=" H73 3BC";
$resn_exch{"1H11 3BC"}="H111 3BC"; $resn_exch{"2H11 3BC"}="H112 3BC"; $resn_exch{"3H11 3BC"}="H113 3BC";
$resn_exch{"1H12 3BC"}="H121 3BC"; $resn_exch{"2H12 3BC"}="H122 3BC"; $resn_exch{"3H12 3BC"}="H123 3BC";
$resn_exch{"1H13 3BC"}="H131 3BC"; $resn_exch{"2H13 3BC"}="H132 3BC"; $resn_exch{"3H13 3BC"}="H133 3BC";
$resn_exch{"1H17 3BC"}="H171 3BC"; $resn_exch{"2H17 3BC"}="H172 3BC"; $resn_exch{"1H22 3BC"}="H221 3BC";
$resn_exch{"2H22 3BC"}="H222 3BC"; $resn_exch{"3H22 3BC"}="H223 3BC"; $resn_exch{"1H23 3BC"}="H231 3BC";
$resn_exch{"2H23 3BC"}="H232 3BC"; $resn_exch{"3H23 3BC"}="H233 3BC"; $resn_exch{"1H28 3BC"}="H281 3BC";
$resn_exch{"2H28 3BC"}="H282 3BC"; $resn_exch{"1H30 3BC"}="H301 3BC"; $resn_exch{"2H30 3BC"}="H302 3BC";
$resn_exch{"1H31 3BC"}="H311 3BC"; $resn_exch{"2H31 3BC"}="H312 3BC"; $resn_exch{"1H36 3BC"}="H361 3BC";
$resn_exch{"2H36 3BC"}="H362 3BC"; $resn_exch{"1H51 3BC"}="H511 3BC"; $resn_exch{"2H51 3BC"}="H512 3BC";
$resn_exch{"3H51 3BC"}="H513 3BC"; $resn_exch{"1H52 3BC"}="H521 3BC"; $resn_exch{"2H52 3BC"}="H522 3BC";
$resn_exch{"3H52 3BC"}="H523 3BC"; $resn_exch{"1H1  3BN"}=" H11 3BN"; $resn_exch{"2H1  3BN"}="H12A 3BN";
$resn_exch{"1H3  3BN"}=" H31 3BN"; $resn_exch{"2H3  3BN"}=" H32 3BN"; $resn_exch{"1H4  3BN"}=" H41 3BN";
$resn_exch{"2H4  3BN"}=" H42 3BN"; $resn_exch{"1H8  3BN"}=" H81 3BN"; $resn_exch{"2H8  3BN"}=" H82 3BN";
$resn_exch{"1H16 3BN"}="H161 3BN"; $resn_exch{"2H16 3BN"}="H162 3BN"; $resn_exch{"3H16 3BN"}="H163 3BN";
$resn_exch{"1H23 3BN"}="H231 3BN"; $resn_exch{"2H23 3BN"}="H232 3BN"; $resn_exch{"3H23 3BN"}="H233 3BN";
$resn_exch{"1H19 3BP"}="H191 3BP"; $resn_exch{"2H19 3BP"}="H192 3BP"; $resn_exch{"1H20 3BP"}="H201 3BP";
$resn_exch{"2H20 3BP"}="H202 3BP"; $resn_exch{"1H32 3BP"}="H321 3BP"; $resn_exch{"2H32 3BP"}="H322 3BP";
$resn_exch{"1HN3 3BP"}="HN31 3BP"; $resn_exch{"2HN3 3BP"}="HN32 3BP"; $resn_exch{"1H1  3BP"}="H11A 3BP";
$resn_exch{"2H1  3BP"}="H12A 3BP"; $resn_exch{"1H9  3BP"}=" H91 3BP"; $resn_exch{"2H9  3BP"}=" H92 3BP";
$resn_exch{"1H8  3BP"}=" H81 3BP"; $resn_exch{"2H8  3BP"}=" H82 3BP"; $resn_exch{"3H8  3BP"}=" H83 3BP";
$resn_exch{"1HN2 3BP"}="HN21 3BP"; $resn_exch{"2HN2 3BP"}="HN22 3BP"; $resn_exch{"1H1  3BR"}=" H11 3BR";
$resn_exch{"2H1  3BR"}=" H12 3BR"; $resn_exch{"1H2  3BR"}=" H21 3BR"; $resn_exch{"2H2  3BR"}=" H22 3BR";
$resn_exch{"1H3  3BR"}=" H31 3BR"; $resn_exch{"2H3  3BR"}=" H32 3BR"; $resn_exch{"3H3  3BR"}=" H33 3BR";
$resn_exch{"1HCA 3BT"}="HCA1 3BT"; $resn_exch{"2HCA 3BT"}="HCA2 3BT"; $resn_exch{"1HCB 3BT"}="HCB1 3BT";
$resn_exch{"2HCB 3BT"}="HCB2 3BT"; $resn_exch{"1HN1 3BT"}="HN11 3BT"; $resn_exch{"2HN1 3BT"}="HN12 3BT";
$resn_exch{"1HN2 3BT"}="HN21 3BT"; $resn_exch{"1H2  3BT"}=" H21 3BT"; $resn_exch{"1H6  3BT"}=" H61 3BT";
$resn_exch{"1H5  3BT"}=" H51 3BT"; $resn_exch{"1H4  3BT"}=" H41 3BT"; $resn_exch{"1HCC 3BT"}="HCC1 3BT";
$resn_exch{"2HCC 3BT"}="HCC2 3BT"; $resn_exch{"1HCD 3BT"}="HCD1 3BT"; $resn_exch{"2HCD 3BT"}="HCD2 3BT";
$resn_exch{"1H1' 3BT"}="H1'1 3BT"; $resn_exch{"2H1' 3BT"}="H1'2 3BT"; $resn_exch{"'HN2 3BT"}="HN2' 3BT";
$resn_exch{"1H16 3C3"}="H161 3C3"; $resn_exch{"2H16 3C3"}="H162 3C3"; $resn_exch{"1H18 3C3"}="H181 3C3";
$resn_exch{"2H18 3C3"}="H182 3C3"; $resn_exch{"1H19 3C3"}="H191 3C3"; $resn_exch{"2H19 3C3"}="H192 3C3";
$resn_exch{"1H20 3C3"}="H201 3C3"; $resn_exch{"2H20 3C3"}="H202 3C3"; $resn_exch{"3H20 3C3"}="H203 3C3";
$resn_exch{"1H17 3C3"}="H171 3C3"; $resn_exch{"2H17 3C3"}="H172 3C3"; $resn_exch{"1HG  3C4"}=" HG1 3C4";
$resn_exch{"2HG  3C4"}=" HG2 3C4"; $resn_exch{"1H19 3CB"}="H191 3CB"; $resn_exch{"2H19 3CB"}="H192 3CB";
$resn_exch{"1H20 3CB"}="H201 3CB"; $resn_exch{"2H20 3CB"}="H202 3CB"; $resn_exch{"1H32 3CB"}="H321 3CB";
$resn_exch{"2H32 3CB"}="H322 3CB"; $resn_exch{"1HN5 3CB"}="HN51 3CB"; $resn_exch{"2HN5 3CB"}="HN52 3CB";
$resn_exch{"1H4  3CB"}=" H41 3CB"; $resn_exch{"2H4  3CB"}=" H42 3CB"; $resn_exch{"1H3  3CB"}="H31A 3CB";
$resn_exch{"2H3  3CB"}=" H32 3CB"; $resn_exch{"3H3  3CB"}=" H33 3CB"; $resn_exch{"1H9  3CB"}=" H91 3CB";
$resn_exch{"2H9  3CB"}=" H92 3CB"; $resn_exch{"1H6  3CB"}=" H61 3CB"; $resn_exch{"2H6  3CB"}=" H62 3CB";
$resn_exch{"3H6  3CB"}=" H63 3CB"; $resn_exch{"1HN2 3CB"}="HN21 3CB"; $resn_exch{"2HN2 3CB"}="HN22 3CB";
$resn_exch{"1H7  3CC"}=" H71 3CC"; $resn_exch{"2H7  3CC"}=" H72 3CC"; $resn_exch{"1H9  3CC"}=" H91 3CC";
$resn_exch{"2H9  3CC"}=" H92 3CC"; $resn_exch{"1HN1 3CC"}="HN11 3CC"; $resn_exch{"2HN1 3CC"}="HN12 3CC";
$resn_exch{"1H12 3CC"}="H121 3CC"; $resn_exch{"2H12 3CC"}="H122 3CC"; $resn_exch{"1H13 3CC"}="H131 3CC";
$resn_exch{"2H13 3CC"}="H132 3CC"; $resn_exch{"1H14 3CC"}="H141 3CC"; $resn_exch{"2H14 3CC"}="H142 3CC";
$resn_exch{"3H14 3CC"}="H143 3CC"; $resn_exch{"1H15 3CC"}="H151 3CC"; $resn_exch{"2H15 3CC"}="H152 3CC";
$resn_exch{"1H16 3CC"}="H161 3CC"; $resn_exch{"2H16 3CC"}="H162 3CC"; $resn_exch{"1H17 3CC"}="H171 3CC";
$resn_exch{"2H17 3CC"}="H172 3CC"; $resn_exch{"3H17 3CC"}="H173 3CC"; $resn_exch{"1H2  3CL"}=" H21 3CL";
$resn_exch{"2H2  3CL"}=" H22 3CL"; $resn_exch{"1H3  3CL"}=" H31 3CL"; $resn_exch{"2H3  3CL"}=" H32 3CL";
$resn_exch{"1H4  3CL"}=" H41 3CL"; $resn_exch{"2H4  3CL"}=" H42 3CL"; $resn_exch{"1H6  3CM"}=" H61 3CM";
$resn_exch{"2H6  3CM"}="H62A 3CM"; $resn_exch{"1H11 3CM"}="H111 3CM"; $resn_exch{"2H11 3CM"}="H112 3CM";
$resn_exch{"1H21 3CM"}="H211 3CM"; $resn_exch{"2H21 3CM"}="H212 3CM"; $resn_exch{"1H31 3CM"}="H311 3CM";
$resn_exch{"2H31 3CM"}="H312 3CM"; $resn_exch{"1H42 3CM"}="H421 3CM"; $resn_exch{"2H42 3CM"}="H422 3CM";
$resn_exch{"1H60 3CM"}="H601 3CM"; $resn_exch{"2H60 3CM"}="H602 3CM"; $resn_exch{"1HA  3CN"}=" HA1 3CN";
$resn_exch{"2HA  3CN"}=" HA2 3CN"; $resn_exch{"3HA  3CN"}=" HA3 3CN"; $resn_exch{"1HB  3CN"}=" HB1 3CN";
$resn_exch{"2HB  3CN"}=" HB2 3CN"; $resn_exch{"1HC  3CN"}=" HC1 3CN"; $resn_exch{"2HC  3CN"}=" HC2 3CN";
$resn_exch{"1HND 3CN"}="HND1 3CN"; $resn_exch{"2HND 3CN"}="HND2 3CN"; $resn_exch{"1H6  3CP"}=" H61 3CP";
$resn_exch{"2H6  3CP"}=" H62 3CP"; $resn_exch{"2HO' 3CP"}="HO'2 3CP"; $resn_exch{"1H5' 3CP"}="H5'1 3CP";
$resn_exch{"2H5' 3CP"}="H5'2 3CP"; $resn_exch{"1HB  3CP"}=" HB1 3CP"; $resn_exch{"2HB  3CP"}=" HB2 3CP";
$resn_exch{"1HP9 3CP"}="HP91 3CP"; $resn_exch{"2HP9 3CP"}="HP92 3CP"; $resn_exch{"3HP9 3CP"}="HP93 3CP";
$resn_exch{"1HP8 3CP"}="HP81 3CP"; $resn_exch{"2HP8 3CP"}="HP82 3CP"; $resn_exch{"3HP8 3CP"}="HP83 3CP";
$resn_exch{"3HOP 3CP"}="HOP3 3CP"; $resn_exch{"1HP5 3CP"}="HP51 3CP"; $resn_exch{"2HP5 3CP"}="HP52 3CP";
$resn_exch{"1HP4 3CP"}="HP41 3CP"; $resn_exch{"2HP4 3CP"}="HP42 3CP"; $resn_exch{"1HP2 3CP"}="HP21 3CP";
$resn_exch{"2HP2 3CP"}="HP22 3CP"; $resn_exch{"1HP1 3CP"}="HP11 3CP"; $resn_exch{"2HP1 3CP"}="HP12 3CP";
$resn_exch{"1HS1 3CP"}="HS11 3CP"; $resn_exch{"2HS1 3CP"}="HS12 3CP"; $resn_exch{"1HS2 3CP"}="HS21 3CP";
$resn_exch{"2HS2 3CP"}="HS22 3CP"; $resn_exch{"1HS3 3CP"}="HS31 3CP"; $resn_exch{"2HS3 3CP"}="HS32 3CP";
$resn_exch{"5HOS 3CP"}="HOS5 3CP"; $resn_exch{"1H10 3CS"}="H101 3CS"; $resn_exch{"2H10 3CS"}="H102 3CS";
$resn_exch{"1H30 3CS"}="H301 3CS"; $resn_exch{"2H30 3CS"}="H302 3CS"; $resn_exch{"1H31 3CS"}="H311 3CS";
$resn_exch{"2H31 3CS"}="H312 3CS"; $resn_exch{"3H31 3CS"}="H313 3CS"; $resn_exch{"1H32 3CS"}="H321 3CS";
$resn_exch{"2H32 3CS"}="H322 3CS"; $resn_exch{"3H32 3CS"}="H323 3CS"; $resn_exch{"1H34 3CS"}="H341 3CS";
$resn_exch{"2H34 3CS"}="H342 3CS"; $resn_exch{"3H34 3CS"}="H343 3CS"; $resn_exch{"1H18 3CS"}="H181 3CS";
$resn_exch{"2H18 3CS"}="H182 3CS"; $resn_exch{"1H37 3CS"}="H371 3CS"; $resn_exch{"2H37 3CS"}="H372 3CS";
$resn_exch{"1H38 3CS"}="H381 3CS"; $resn_exch{"2H38 3CS"}="H382 3CS"; $resn_exch{"3H38 3CS"}="H383 3CS";
$resn_exch{"1H39 3CS"}="H391 3CS"; $resn_exch{"2H39 3CS"}="H392 3CS"; $resn_exch{"3H39 3CS"}="H393 3CS";
$resn_exch{"1H7  3CY"}=" H71 3CY"; $resn_exch{"2H7  3CY"}=" H72 3CY"; $resn_exch{"1H8  3CY"}=" H81 3CY";
$resn_exch{"2H8  3CY"}=" H82 3CY"; $resn_exch{"1H11 3CY"}="H111 3CY"; $resn_exch{"2H11 3CY"}="H112 3CY";
$resn_exch{"1H15 3CY"}="H151 3CY"; $resn_exch{"2H15 3CY"}="H152 3CY"; $resn_exch{"1H22 3CY"}="H221 3CY";
$resn_exch{"2H22 3CY"}="H222 3CY"; $resn_exch{"1H23 3CY"}="H231 3CY"; $resn_exch{"2H23 3CY"}="H232 3CY";
$resn_exch{"1H31 3CY"}="H311 3CY"; $resn_exch{"2H31 3CY"}="H312 3CY"; $resn_exch{"3H31 3CY"}="H313 3CY";
$resn_exch{"1H28 3CY"}="H281 3CY"; $resn_exch{"2H28 3CY"}="H282 3CY"; $resn_exch{"1H13 3D3"}="H131 3D3";
$resn_exch{"2H13 3D3"}="H132 3D3"; $resn_exch{"1H14 3D3"}="H141 3D3"; $resn_exch{"2H14 3D3"}="H142 3D3";
$resn_exch{"1H15 3D3"}="H151 3D3"; $resn_exch{"2H15 3D3"}="H152 3D3"; $resn_exch{"2HOP 3DA"}="HOP2 3DA";
$resn_exch{"1H5* 3DA"}="H5'1 3DA"; $resn_exch{"2H5* 3DA"}="H5'2 3DA"; $resn_exch{" H4* 3DA"}=" H4' 3DA";
$resn_exch{" H1* 3DA"}=" H1' 3DA"; $resn_exch{"1HN6 3DA"}="HN61 3DA"; $resn_exch{"2HN6 3DA"}="HN62 3DA";
$resn_exch{"1H2* 3DA"}="H2'1 3DA"; $resn_exch{"2HO* 3DA"}="HO'2 3DA"; $resn_exch{"1H3* 3DA"}="H3'1 3DA";
$resn_exch{"2H3* 3DA"}="H3'2 3DA"; $resn_exch{"3HOP 3DA"}="HOP3 3DA"; $resn_exch{"1HN6 3DD"}="HN61 3DD";
$resn_exch{"2HN6 3DD"}="HN62 3DD"; $resn_exch{"1H1' 3DD"}="H1'1 3DD"; $resn_exch{"2H1' 3DD"}="H1'2 3DD";
$resn_exch{"1H16 3DE"}="H161 3DE"; $resn_exch{"2H16 3DE"}="H162 3DE"; $resn_exch{"1H17 3DE"}="H171 3DE";
$resn_exch{"2H17 3DE"}="H172 3DE"; $resn_exch{"3H17 3DE"}="H173 3DE"; $resn_exch{"1H12 3DE"}="H121 3DE";
$resn_exch{"2H12 3DE"}="H122 3DE"; $resn_exch{"3H12 3DE"}="H123 3DE"; $resn_exch{"1H9  3DE"}=" H91 3DE";
$resn_exch{"2H9  3DE"}=" H92 3DE"; $resn_exch{"3H9  3DE"}=" H93 3DE"; $resn_exch{"1H3' 3DG"}="H3'1 3DG";
$resn_exch{"2H3' 3DG"}="H3'2 3DG"; $resn_exch{"1H5' 3DG"}="H5'1 3DG"; $resn_exch{"2H5' 3DG"}="H5'2 3DG";
$resn_exch{"1HN2 3DG"}="HN21 3DG"; $resn_exch{"2HN2 3DG"}="HN22 3DG"; $resn_exch{"1HAA 3DP"}="HAA1 3DP";
$resn_exch{"2HAA 3DP"}="HAA2 3DP"; $resn_exch{"3HAA 3DP"}="HAA3 3DP"; $resn_exch{"1HAG 3DP"}="HAG1 3DP";
$resn_exch{"2HAG 3DP"}="HAG2 3DP"; $resn_exch{"1HAH 3DP"}="HAH1 3DP"; $resn_exch{"2HAH 3DP"}="HAH2 3DP";
$resn_exch{"1HAI 3DP"}="HAI1 3DP"; $resn_exch{"2HAI 3DP"}="HAI2 3DP"; $resn_exch{"1HAJ 3DP"}="HAJ1 3DP";
$resn_exch{"2HAJ 3DP"}="HAJ2 3DP"; $resn_exch{"1HAK 3DP"}="HAK1 3DP"; $resn_exch{"2HAK 3DP"}="HAK2 3DP";
$resn_exch{"1HAL 3DP"}="HAL1 3DP"; $resn_exch{"2HAL 3DP"}="HAL2 3DP"; $resn_exch{"1HAN 3DP"}="HAN1 3DP";
$resn_exch{"2HAN 3DP"}="HAN2 3DP"; $resn_exch{"1HAB 3DP"}="HAB1 3DP"; $resn_exch{"2HAB 3DP"}="HAB2 3DP";
$resn_exch{"3HAB 3DP"}="HAB3 3DP"; $resn_exch{"1HAC 3DP"}="HAC1 3DP"; $resn_exch{"2HAC 3DP"}="HAC2 3DP";
$resn_exch{"3HAC 3DP"}="HAC3 3DP"; $resn_exch{"1HAO 3DP"}="HAO1 3DP"; $resn_exch{"2HAO 3DP"}="HAO2 3DP";
$resn_exch{"1HAM 3DP"}="HAM1 3DP"; $resn_exch{"2HAM 3DP"}="HAM2 3DP"; $resn_exch{"1HAP 3DP"}="HAP1 3DP";
$resn_exch{"2HAP 3DP"}="HAP2 3DP"; $resn_exch{"2HOP 3DR"}="HOP2 3DR"; $resn_exch{"3HOP 3DR"}="HOP3 3DR";
$resn_exch{"1H2* 3DR"}=" H2' 3DR"; $resn_exch{"2H2* 3DR"}="H2'' 3DR"; $resn_exch{"1H5* 3DR"}=" H5' 3DR";
$resn_exch{"2H5* 3DR"}="H5'' 3DR"; $resn_exch{"1H4* 3DR"}="H4'1 3DR"; $resn_exch{"1H1* 3DR"}="H1'1 3DR";
$resn_exch{"2H1* 3DR"}="H1'2 3DR"; $resn_exch{" H3* 3DR"}=" H3' 3DR"; $resn_exch{"HO3* 3DR"}="HO3' 3DR";
$resn_exch{"1H13 3EA"}="H131 3EA"; $resn_exch{"2H13 3EA"}="H132 3EA"; $resn_exch{"3H13 3EA"}="H133 3EA";
$resn_exch{"1H12 3EA"}="H121 3EA"; $resn_exch{"2H12 3EA"}="H122 3EA"; $resn_exch{"1H11 3EA"}="H111 3EA";
$resn_exch{"2H11 3EA"}="H112 3EA"; $resn_exch{"1H15 3EA"}="H151 3EA"; $resn_exch{"2H15 3EA"}="H152 3EA";
$resn_exch{"1H16 3EA"}="H161 3EA"; $resn_exch{"2H16 3EA"}="H162 3EA"; $resn_exch{"1H17 3EA"}="H171 3EA";
$resn_exch{"2H17 3EA"}="H172 3EA"; $resn_exch{"1H28 3EA"}="H281 3EA"; $resn_exch{"2H28 3EA"}="H282 3EA";
$resn_exch{"2H1  3EP"}=" H12 3EP"; $resn_exch{"1H1  3EP"}=" H11 3EP"; $resn_exch{"3H2  3EP"}=" H23 3EP";
$resn_exch{"2H2  3EP"}=" H22 3EP"; $resn_exch{"1H2  3EP"}=" H21 3EP"; $resn_exch{"2H3  3EP"}=" H32 3EP";
$resn_exch{"1H3  3EP"}=" H31 3EP"; $resn_exch{"3H4  3EP"}=" H43 3EP"; $resn_exch{"2H4  3EP"}=" H42 3EP";
$resn_exch{"1H4  3EP"}=" H41 3EP"; $resn_exch{"2H5  3EP"}=" H52 3EP"; $resn_exch{"1H5  3EP"}=" H51 3EP";
$resn_exch{"3H6  3EP"}=" H63 3EP"; $resn_exch{"2H6  3EP"}=" H62 3EP"; $resn_exch{"1H6  3EP"}=" H61 3EP";
$resn_exch{"1H1  3FC"}=" H11 3FC"; $resn_exch{"2H1  3FC"}=" H12 3FC"; $resn_exch{"3H1  3FC"}=" H13 3FC";
$resn_exch{"1H2  3FC"}="H21A 3FC"; $resn_exch{"2H2  3FC"}="H22A 3FC"; $resn_exch{"1H3  3FC"}=" H31 3FC";
$resn_exch{"2H3  3FC"}=" H32 3FC"; $resn_exch{"1H4  3FC"}=" H41 3FC"; $resn_exch{"2H4  3FC"}=" H42 3FC";
$resn_exch{"1H11 3FC"}="H111 3FC"; $resn_exch{"2H11 3FC"}="H112 3FC"; $resn_exch{"1H28 3FC"}="H281 3FC";
$resn_exch{"2H28 3FC"}="H282 3FC"; $resn_exch{"3H28 3FC"}="H283 3FC"; $resn_exch{"1H29 3FC"}="H291 3FC";
$resn_exch{"2H29 3FC"}="H292 3FC"; $resn_exch{"3H29 3FC"}="H293 3FC"; $resn_exch{"1H30 3FC"}="H301 3FC";
$resn_exch{"2H30 3FC"}="H302 3FC"; $resn_exch{"3H30 3FC"}="H303 3FC"; $resn_exch{"1H37 3FC"}="H371 3FC";
$resn_exch{"2H37 3FC"}="H372 3FC"; $resn_exch{"1H38 3FC"}="H381 3FC"; $resn_exch{"2H38 3FC"}="H382 3FC";
$resn_exch{"1HNC 3FM"}="HNC1 3FM"; $resn_exch{"2HNC 3FM"}="HNC2 3FM"; $resn_exch{"1H6  3FM"}=" H61 3FM";
$resn_exch{"2H6  3FM"}=" H62 3FM"; $resn_exch{"1H16 3FP"}="H161 3FP"; $resn_exch{"2H16 3FP"}="H162 3FP";
$resn_exch{"1H18 3FP"}="H181 3FP"; $resn_exch{"2H18 3FP"}="H182 3FP"; $resn_exch{"1H19 3FP"}="H191 3FP";
$resn_exch{"2H19 3FP"}="H192 3FP"; $resn_exch{"3H19 3FP"}="H193 3FP"; $resn_exch{"1H20 3FP"}="H201 3FP";
$resn_exch{"2H20 3FP"}="H202 3FP"; $resn_exch{"3H20 3FP"}="H203 3FP"; $resn_exch{"1H16 3FQ"}="H161 3FQ";
$resn_exch{"2H16 3FQ"}="H162 3FQ"; $resn_exch{"1H18 3FQ"}="H181 3FQ"; $resn_exch{"2H18 3FQ"}="H182 3FQ";
$resn_exch{"1H19 3FQ"}="H191 3FQ"; $resn_exch{"2H19 3FQ"}="H192 3FQ"; $resn_exch{"3H19 3FQ"}="H193 3FQ";
$resn_exch{"1H20 3FQ"}="H201 3FQ"; $resn_exch{"2H20 3FQ"}="H202 3FQ"; $resn_exch{"3H20 3FQ"}="H203 3FQ";
$resn_exch{"1H24 3FT"}="H241 3FT"; $resn_exch{"2H24 3FT"}="H242 3FT"; $resn_exch{"1H25 3FT"}="H251 3FT";
$resn_exch{"2H25 3FT"}="H252 3FT"; $resn_exch{"1H26 3FT"}="H261 3FT"; $resn_exch{"2H26 3FT"}="H262 3FT";
$resn_exch{"1H2  3GA"}=" H21 3GA"; $resn_exch{"2H2  3GA"}=" H22 3GA"; $resn_exch{"1H3  3GA"}=" H31 3GA";
$resn_exch{"2H3  3GA"}=" H32 3GA"; $resn_exch{"1HN  3GA"}="HN1A 3GA"; $resn_exch{"2HN  3GA"}=" HN2 3GA";
$resn_exch{"1HB  3GA"}=" HB1 3GA"; $resn_exch{"2HB  3GA"}=" HB2 3GA"; $resn_exch{"1H1  3GA"}=" H11 3GA";
$resn_exch{"2H1  3GA"}=" H12 3GA"; $resn_exch{"1HD  3GA"}=" HD1 3GA"; $resn_exch{"2HD  3GA"}=" HD2 3GA";
$resn_exch{"1HN2 3GA"}="HN21 3GA"; $resn_exch{"2HN2 3GA"}="HN22 3GA"; $resn_exch{"1H1  3GC"}=" H11 3GC";
$resn_exch{"2H2  3GC"}=" H22 3GC"; $resn_exch{"1HB1 3GC"}="HB11 3GC"; $resn_exch{"2HB1 3GC"}="HB12 3GC";
$resn_exch{"1HG1 3GC"}="HG11 3GC"; $resn_exch{"2HG1 3GC"}="HG12 3GC"; $resn_exch{"1HB2 3GC"}="HB21 3GC";
$resn_exch{"2HB2 3GC"}="HB22 3GC"; $resn_exch{"2HOP 3GP"}="HOP2 3GP"; $resn_exch{"3HOP 3GP"}="HOP3 3GP";
$resn_exch{"*HO5 3GP"}="HO5' 3GP"; $resn_exch{"1H5* 3GP"}="H5'1 3GP"; $resn_exch{"2H5* 3GP"}="H5'2 3GP";
$resn_exch{" H4* 3GP"}=" H4' 3GP"; $resn_exch{" H3* 3GP"}=" H3' 3GP"; $resn_exch{" H2* 3GP"}=" H2' 3GP";
$resn_exch{"*HO2 3GP"}="HO2' 3GP"; $resn_exch{" H1* 3GP"}=" H1' 3GP"; $resn_exch{"1HN2 3GP"}="HN21 3GP";
$resn_exch{"2HN2 3GP"}="HN22 3GP"; $resn_exch{"1H1C 3GR"}="H1C1 3GR"; $resn_exch{"2H1C 3GR"}="H1C2 3GR";
$resn_exch{"1H10 3HA"}="H101 3HA"; $resn_exch{"2H10 3HA"}="H102 3HA"; $resn_exch{"'HO2 3HB"}="HO2' 3HB";
$resn_exch{" AH2 3HC"}=" H2A 3HC"; $resn_exch{"AH61 3HC"}="H61A 3HC"; $resn_exch{"AH62 3HC"}="H62A 3HC";
$resn_exch{" AH8 3HC"}=" H8A 3HC"; $resn_exch{"AH1* 3HC"}=" H1B 3HC"; $resn_exch{"AH2* 3HC"}=" H2B 3HC";
$resn_exch{"AHO2 3HC"}="HO2A 3HC"; $resn_exch{"AH3* 3HC"}=" H3B 3HC"; $resn_exch{"8HOA 3HC"}="HOA8 3HC";
$resn_exch{"9HOA 3HC"}="HOA9 3HC"; $resn_exch{"AH4* 3HC"}=" H4B 3HC"; $resn_exch{"AH51 3HC"}="H51A 3HC";
$resn_exch{"AH52 3HC"}="H52A 3HC"; $resn_exch{"2HOA 3HC"}="HOA2 3HC"; $resn_exch{"5HOA 3HC"}="HOA5 3HC";
$resn_exch{"1H12 3HC"}="H121 3HC"; $resn_exch{"2H12 3HC"}="H122 3HC"; $resn_exch{"1H13 3HC"}="H131 3HC";
$resn_exch{"2H13 3HC"}="H132 3HC"; $resn_exch{"3H13 3HC"}="H133 3HC"; $resn_exch{"1H14 3HC"}="H141 3HC";
$resn_exch{"2H14 3HC"}="H142 3HC"; $resn_exch{"3H14 3HC"}="H143 3HC"; $resn_exch{"1H7  3HC"}=" H71 3HC";
$resn_exch{"2H7  3HC"}=" H72 3HC"; $resn_exch{"1H6  3HC"}=" H61 3HC"; $resn_exch{"2H6  3HC"}=" H62 3HC";
$resn_exch{"1H3  3HC"}=" H31 3HC"; $resn_exch{"2H3  3HC"}=" H32 3HC"; $resn_exch{"1H2  3HC"}=" H21 3HC";
$resn_exch{"2H2  3HC"}=" H22 3HC"; $resn_exch{"1HC2 3HC"}="HC21 3HC"; $resn_exch{"2HC2 3HC"}="HC22 3HC";
$resn_exch{"1HC3 3HC"}="HC31 3HC"; $resn_exch{"1HO3 3HC"}="HO31 3HC"; $resn_exch{"1HC4 3HC"}="HC41 3HC";
$resn_exch{"2HC4 3HC"}="HC42 3HC"; $resn_exch{"3HC4 3HC"}="HC43 3HC"; $resn_exch{"1H   3HD"}=" H1  3HD";
$resn_exch{"2H   3HD"}=" H2  3HD"; $resn_exch{"2HO  3HD"}=" HO2 3HD"; $resn_exch{"3H   3HD"}=" H3  3HD";
$resn_exch{"1H3  3HD"}=" H31 3HD"; $resn_exch{"2H3  3HD"}=" H32 3HD"; $resn_exch{"3H3  3HD"}=" H33 3HD";
$resn_exch{"4H   3HD"}=" H4  3HD"; $resn_exch{"4HO  3HD"}=" HO4 3HD"; $resn_exch{"5H   3HD"}=" H5  3HD";
$resn_exch{"1H6  3HD"}=" H61 3HD"; $resn_exch{"2H6  3HD"}=" H62 3HD"; $resn_exch{"6HO  3HD"}=" HO6 3HD";
$resn_exch{"1H2  3HG"}=" H21 3HG"; $resn_exch{"2H2  3HG"}=" H22 3HG"; $resn_exch{"1H4  3HG"}=" H41 3HG";
$resn_exch{"2H4  3HG"}=" H42 3HG"; $resn_exch{"1HA  3HL"}=" HA1 3HL"; $resn_exch{"2HA  3HL"}=" HA2 3HL";
$resn_exch{"1HG2 3HL"}="HG21 3HL"; $resn_exch{"2HG2 3HL"}="HG22 3HL"; $resn_exch{"3HG2 3HL"}="HG23 3HL";
$resn_exch{"1H7  3HP"}=" H71 3HP"; $resn_exch{"2H7  3HP"}=" H72 3HP"; $resn_exch{"1HN  3HX"}=" HN1 3HX";
$resn_exch{"2HN  3HX"}=" HN2 3HX"; $resn_exch{"1H   3HX"}=" H1  3HX"; $resn_exch{"2H   3HX"}=" H2  3HX";
$resn_exch{"1HB  3HX"}=" HB1 3HX"; $resn_exch{"2HB  3HX"}=" HB2 3HX"; $resn_exch{"1HG  3HX"}=" HG1 3HX";
$resn_exch{"2HG  3HX"}=" HG2 3HX"; $resn_exch{"1HD  3HX"}=" HD1 3HX"; $resn_exch{"2HD  3HX"}=" HD2 3HX";
$resn_exch{"1HNB 3HX"}="HNB1 3HX"; $resn_exch{"2HNB 3HX"}="HNB2 3HX"; $resn_exch{"1H1' 3HX"}="H1'1 3HX";
$resn_exch{"2H1' 3HX"}="H1'2 3HX"; $resn_exch{"1H2' 3HX"}="H2'1 3HX"; $resn_exch{"2H2' 3HX"}="H2'2 3HX";
$resn_exch{"1H10 3IB"}="H101 3IB"; $resn_exch{"2H10 3IB"}="H102 3IB"; $resn_exch{"1H11 3IB"}="H111 3IB";
$resn_exch{"2H11 3IB"}="H112 3IB"; $resn_exch{"1H12 3IB"}="H121 3IB"; $resn_exch{"2H12 3IB"}="H122 3IB";
$resn_exch{"1HN  3ID"}=" HN1 3ID"; $resn_exch{"1OH  3ID"}=" H1O 3ID"; $resn_exch{"2OH  3ID"}=" H2O 3ID";
$resn_exch{"1HN3 3IG"}="HN31 3IG"; $resn_exch{"2HN3 3IG"}="HN32 3IG"; $resn_exch{"1HN4 3IG"}="HN41 3IG";
$resn_exch{"2HN4 3IG"}="HN42 3IG"; $resn_exch{"1H5  3IG"}=" H51 3IG"; $resn_exch{"2H5  3IG"}=" H52 3IG";
$resn_exch{"1H6  3IG"}=" H61 3IG"; $resn_exch{"2H6  3IG"}=" H62 3IG"; $resn_exch{"3H6  3IG"}=" H63 3IG";
$resn_exch{"1H16 3IG"}="H161 3IG"; $resn_exch{"2H16 3IG"}="H162 3IG"; $resn_exch{"1H17 3IG"}="H171 3IG";
$resn_exch{"2H17 3IG"}="H172 3IG"; $resn_exch{"1H19 3IG"}="H191 3IG"; $resn_exch{"2H19 3IG"}="H192 3IG";
$resn_exch{"3H19 3IG"}="H193 3IG"; $resn_exch{"1H21 3IG"}="H211 3IG"; $resn_exch{"2H21 3IG"}="H212 3IG";
$resn_exch{"3H21 3IG"}="H213 3IG"; $resn_exch{"1H20 3IG"}="H201 3IG"; $resn_exch{"2H20 3IG"}="H202 3IG";
$resn_exch{"3H20 3IG"}="H203 3IG"; $resn_exch{"1H6  3IH"}=" H61 3IH"; $resn_exch{"2H6  3IH"}=" H62 3IH";
$resn_exch{"3H6  3IH"}=" H63 3IH"; $resn_exch{"1H10 3IH"}="H101 3IH"; $resn_exch{"2H10 3IH"}="H102 3IH";
$resn_exch{"3H10 3IH"}="H103 3IH"; $resn_exch{"1H11 3IH"}="H111 3IH"; $resn_exch{"2H11 3IH"}="H112 3IH";
$resn_exch{"3H11 3IH"}="H113 3IH"; $resn_exch{"1H14 3IH"}="H141 3IH"; $resn_exch{"2H14 3IH"}="H142 3IH";
$resn_exch{"1H16 3IH"}="H161 3IH"; $resn_exch{"2H16 3IH"}="H162 3IH"; $resn_exch{"3H16 3IH"}="H163 3IH";
$resn_exch{"1H17 3IH"}="H171 3IH"; $resn_exch{"2H17 3IH"}="H172 3IH"; $resn_exch{"3H17 3IH"}="H173 3IH";
$resn_exch{"1H23 3IH"}="H231 3IH"; $resn_exch{"2H23 3IH"}="H232 3IH"; $resn_exch{"1H25 3IH"}="H251 3IH";
$resn_exch{"2H25 3IH"}="H252 3IH"; $resn_exch{"1H27 3IH"}="H271 3IH"; $resn_exch{"2H27 3IH"}="H272 3IH";
$resn_exch{"1H28 3IH"}="H281 3IH"; $resn_exch{"2H28 3IH"}="H282 3IH"; $resn_exch{"1H35 3IH"}="H351 3IH";
$resn_exch{"2H35 3IH"}="H352 3IH"; $resn_exch{"3H35 3IH"}="H353 3IH"; $resn_exch{"1H15 3IL"}="H151 3IL";
$resn_exch{"2H15 3IL"}="H152 3IL"; $resn_exch{"1H1  3IN"}="H11A 3IN"; $resn_exch{"2H1  3IN"}=" H12 3IN";
$resn_exch{"1H7  3IN"}=" H71 3IN"; $resn_exch{"2H7  3IN"}=" H72 3IN"; $resn_exch{"3H7  3IN"}=" H73 3IN";
$resn_exch{"1H8  3IN"}=" H81 3IN"; $resn_exch{"2H8  3IN"}=" H82 3IN"; $resn_exch{"1H9  3IN"}=" H91 3IN";
$resn_exch{"2H9  3IN"}=" H92 3IN"; $resn_exch{"1H10 3IN"}="H101 3IN"; $resn_exch{"2H10 3IN"}="H102 3IN";
$resn_exch{"1H12 3IN"}="H121 3IN"; $resn_exch{"2H12 3IN"}="H122 3IN"; $resn_exch{"1H14 3IN"}="H141 3IN";
$resn_exch{"2H14 3IN"}="H142 3IN"; $resn_exch{"1H24 3IN"}="H241 3IN"; $resn_exch{"2H24 3IN"}="H242 3IN";
$resn_exch{"1H27 3IN"}="H271 3IN"; $resn_exch{"2H27 3IN"}="H272 3IN"; $resn_exch{"1H35 3IN"}="H351 3IN";
$resn_exch{"2H35 3IN"}="H352 3IN"; $resn_exch{"1H5  3IN"}=" H51 3IN"; $resn_exch{"2H5  3IN"}=" H52 3IN";
$resn_exch{"3H5  3IN"}=" H53 3IN"; $resn_exch{"1H6  3IN"}=" H61 3IN"; $resn_exch{"2H6  3IN"}=" H62 3IN";
$resn_exch{"3H6  3IN"}=" H63 3IN"; $resn_exch{"1H25 3IN"}="H251 3IN"; $resn_exch{"2H25 3IN"}="H252 3IN";
$resn_exch{"1H29 3IN"}="H291 3IN"; $resn_exch{"2H29 3IN"}="H292 3IN"; $resn_exch{"3H29 3IN"}="H293 3IN";
$resn_exch{"1H26 3IN"}="H261 3IN"; $resn_exch{"2H26 3IN"}="H262 3IN"; $resn_exch{"1H37 3IN"}="H371 3IN";
$resn_exch{"2H37 3IN"}="H372 3IN"; $resn_exch{"1H28 3IN"}="H281 3IN"; $resn_exch{"2H28 3IN"}="H282 3IN";
$resn_exch{"3H28 3IN"}="H283 3IN"; $resn_exch{"1HAI 3IO"}="HAI1 3IO"; $resn_exch{"2HAI 3IO"}="HAI2 3IO";
$resn_exch{"1H1N 3IP"}="H1N1 3IP"; $resn_exch{"2H1N 3IP"}="H1N2 3IP"; $resn_exch{"1H9C 3IP"}="H9C1 3IP";
$resn_exch{"2H9C 3IP"}="H9C2 3IP"; $resn_exch{"1H1  3LG"}="H11A 3LG"; $resn_exch{"2H1  3LG"}="H12A 3LG";
$resn_exch{"3H1  3LG"}="H13A 3LG"; $resn_exch{"1H4  3LG"}=" H41 3LG"; $resn_exch{"2H4  3LG"}=" H42 3LG";
$resn_exch{"1H21 3LG"}="H211 3LG"; $resn_exch{"2H21 3LG"}="H212 3LG"; $resn_exch{"1H22 3LG"}="H221 3LG";
$resn_exch{"2H22 3LG"}="H222 3LG"; $resn_exch{"1H24 3LG"}="H241 3LG"; $resn_exch{"2H24 3LG"}="H242 3LG";
$resn_exch{"1H31 3LG"}="H311 3LG"; $resn_exch{"2H31 3LG"}="H312 3LG"; $resn_exch{"1H32 3LG"}="H321 3LG";
$resn_exch{"2H32 3LG"}="H322 3LG"; $resn_exch{"1H33 3LG"}="H331 3LG"; $resn_exch{"2H33 3LG"}="H332 3LG";
$resn_exch{"1H17 3LG"}="H171 3LG"; $resn_exch{"2H17 3LG"}="H172 3LG"; $resn_exch{"1HAA 3LP"}="HAA1 3LP";
$resn_exch{"2HAA 3LP"}="HAA2 3LP"; $resn_exch{"3HAA 3LP"}="HAA3 3LP"; $resn_exch{"1HAK 3LP"}="HAK1 3LP";
$resn_exch{"2HAK 3LP"}="HAK2 3LP"; $resn_exch{"1HAG 3LP"}="HAG1 3LP"; $resn_exch{"2HAG 3LP"}="HAG2 3LP";
$resn_exch{"1HAH 3LP"}="HAH1 3LP"; $resn_exch{"2HAH 3LP"}="HAH2 3LP"; $resn_exch{"1HAL 3LP"}="HAL1 3LP";
$resn_exch{"2HAL 3LP"}="HAL2 3LP"; $resn_exch{"1HAP 3LP"}="HAP1 3LP"; $resn_exch{"2HAP 3LP"}="HAP2 3LP";
$resn_exch{"1HAO 3LP"}="HAO1 3LP"; $resn_exch{"2HAO 3LP"}="HAO2 3LP"; $resn_exch{"1HAM 3LP"}="HAM1 3LP";
$resn_exch{"2HAM 3LP"}="HAM2 3LP"; $resn_exch{"1HAI 3LP"}="HAI1 3LP"; $resn_exch{"2HAI 3LP"}="HAI2 3LP";
$resn_exch{"1HAF 3LP"}="HAF1 3LP"; $resn_exch{"2HAF 3LP"}="HAF2 3LP"; $resn_exch{"1HAJ 3LP"}="HAJ1 3LP";
$resn_exch{"2HAJ 3LP"}="HAJ2 3LP"; $resn_exch{"1HAN 3LP"}="HAN1 3LP"; $resn_exch{"2HAN 3LP"}="HAN2 3LP";
$resn_exch{"1H3  3MA"}=" H31 3MA"; $resn_exch{"2H3  3MA"}=" H32 3MA"; $resn_exch{"3H3  3MA"}=" H33 3MA";
$resn_exch{"1HN6 3MA"}="HN61 3MA"; $resn_exch{"2HN6 3MA"}="HN62 3MA"; $resn_exch{"1H7  3MB"}=" H71 3MB";
$resn_exch{"2H7  3MB"}=" H72 3MB"; $resn_exch{"3H7  3MB"}=" H73 3MB"; $resn_exch{"1HN  3MB"}=" HN1 3MB";
$resn_exch{"2HN  3MB"}=" HN2 3MB"; $resn_exch{"1H3  3MC"}=" H31 3MC"; $resn_exch{"2H3  3MC"}=" H32 3MC";
$resn_exch{"3H3  3MC"}=" H33 3MC"; $resn_exch{"1HN4 3MC"}="HN41 3MC"; $resn_exch{"2HN4 3MC"}="HN42 3MC";
$resn_exch{" HN  3MD"}=" H2  3MD"; $resn_exch{"1HB1 3MD"}="HB11 3MD"; $resn_exch{"2HB1 3MD"}="HB12 3MD";
$resn_exch{"3HB1 3MD"}="HB13 3MD"; $resn_exch{"1H5' 3ME"}="H5'1 3ME"; $resn_exch{"2H5' 3ME"}="H5'2 3ME";
$resn_exch{"1H5A 3ME"}="H5A1 3ME"; $resn_exch{"2H5A 3ME"}="H5A2 3ME"; $resn_exch{"3H5A 3ME"}="H5A3 3ME";
$resn_exch{"1HB' 3ME"}="HB'1 3ME"; $resn_exch{"2HB' 3ME"}="HB'2 3ME"; $resn_exch{"1HC' 3ME"}="HC'1 3ME";
$resn_exch{"2HC' 3ME"}="HC'2 3ME"; $resn_exch{"1HE' 3ME"}="HE'1 3ME"; $resn_exch{"2HE' 3ME"}="HE'2 3ME";
$resn_exch{"1HF' 3ME"}="HF'1 3ME"; $resn_exch{"2HF' 3ME"}="HF'2 3ME"; $resn_exch{"1HI' 3ME"}="HI'1 3ME";
$resn_exch{"2HI' 3ME"}="HI'2 3ME"; $resn_exch{"3HI' 3ME"}="HI'3 3ME"; $resn_exch{"1HJ' 3ME"}="HJ'1 3ME";
$resn_exch{"2HJ' 3ME"}="HJ'2 3ME"; $resn_exch{"3HJ' 3ME"}="HJ'3 3ME"; $resn_exch{"1H1  3MF"}=" H11 3MF";
$resn_exch{"2H1  3MF"}=" H12 3MF"; $resn_exch{"1H6  3MF"}=" H61 3MF"; $resn_exch{"2H6  3MF"}=" H62 3MF";
$resn_exch{"1H7  3MF"}=" H71 3MF"; $resn_exch{"2H7  3MF"}=" H72 3MF"; $resn_exch{"3H7  3MF"}=" H73 3MF";
$resn_exch{"1H2  3MN"}="H21A 3MN"; $resn_exch{"2H2  3MN"}=" H22 3MN"; $resn_exch{"1H1  3MN"}=" H11 3MN";
$resn_exch{"2H1  3MN"}="H12A 3MN"; $resn_exch{"1H16 3MN"}="H161 3MN"; $resn_exch{"2H16 3MN"}="H162 3MN";
$resn_exch{"1H11 3MN"}="H111 3MN"; $resn_exch{"2H11 3MN"}="H112 3MN"; $resn_exch{"1H28 3MN"}="H281 3MN";
$resn_exch{"2H28 3MN"}="H282 3MN"; $resn_exch{"3H28 3MN"}="H283 3MN"; $resn_exch{"1H4  3MO"}=" H41 3MO";
$resn_exch{"2H4  3MO"}=" H42 3MO"; $resn_exch{"1H3  3MO"}=" H31 3MO"; $resn_exch{"2H3  3MO"}=" H32 3MO";
$resn_exch{"1H7  3MO"}=" H71 3MO"; $resn_exch{"2H7  3MO"}=" H72 3MO"; $resn_exch{"3H7  3MO"}=" H73 3MO";
$resn_exch{"1HB  3MP"}=" HB1 3MP"; $resn_exch{"2HB  3MP"}=" HB2 3MP"; $resn_exch{"3HB  3MP"}=" HB3 3MP";
$resn_exch{"1H1  3MR"}=" H11 3MR"; $resn_exch{"2H1  3MR"}=" H12 3MR"; $resn_exch{"3H1  3MR"}=" H13 3MR";
$resn_exch{"1H5  3MR"}=" H51 3MR"; $resn_exch{"2H5  3MR"}=" H52 3MR"; $resn_exch{"1H6  3MR"}=" H61 3MR";
$resn_exch{"2H6  3MR"}=" H62 3MR"; $resn_exch{"1H10 3MR"}="H101 3MR"; $resn_exch{"2H10 3MR"}="H102 3MR";
$resn_exch{"1H11 3MR"}="H111 3MR"; $resn_exch{"2H11 3MR"}="H112 3MR"; $resn_exch{"1H12 3MR"}="H121 3MR";
$resn_exch{"2H12 3MR"}="H122 3MR"; $resn_exch{"1H13 3MR"}="H131 3MR"; $resn_exch{"2H13 3MR"}="H132 3MR";
$resn_exch{"1H14 3MR"}="H141 3MR"; $resn_exch{"2H14 3MR"}="H142 3MR"; $resn_exch{"1H16 3MR"}="H161 3MR";
$resn_exch{"2H16 3MR"}="H162 3MR"; $resn_exch{"1H32 3MR"}="H321 3MR"; $resn_exch{"2H32 3MR"}="H322 3MR";
$resn_exch{"1H34 3MR"}="H341 3MR"; $resn_exch{"2H34 3MR"}="H342 3MR"; $resn_exch{"1H35 3MR"}="H351 3MR";
$resn_exch{"2H35 3MR"}="H352 3MR"; $resn_exch{"1H36 3MR"}="H361 3MR"; $resn_exch{"2H36 3MR"}="H362 3MR";
$resn_exch{"1H37 3MR"}="H371 3MR"; $resn_exch{"2H37 3MR"}="H372 3MR"; $resn_exch{"1H38 3MR"}="H381 3MR";
$resn_exch{"2H38 3MR"}="H382 3MR"; $resn_exch{"1H1  3MT"}="H11A 3MT"; $resn_exch{"2H1  3MT"}=" H12 3MT";
$resn_exch{"3H1  3MT"}=" H13 3MT"; $resn_exch{"1H17 3NA"}="H171 3NA"; $resn_exch{"2H17 3NA"}="H172 3NA";
$resn_exch{"1H20 3NA"}="H201 3NA"; $resn_exch{"2H20 3NA"}="H202 3NA"; $resn_exch{"1H22 3NH"}="H221 3NH";
$resn_exch{"2H22 3NH"}="H222 3NH"; $resn_exch{"1H30 3NH"}="H301 3NH"; $resn_exch{"2H30 3NH"}="H302 3NH";
$resn_exch{"1H10 3NH"}="H101 3NH"; $resn_exch{"2H10 3NH"}="H102 3NH"; $resn_exch{"1H08 3NH"}="H081 3NH";
$resn_exch{"2H08 3NH"}="H082 3NH"; $resn_exch{"1H45 3NH"}="H451 3NH"; $resn_exch{"2H45 3NH"}="H452 3NH";
$resn_exch{"1H47 3NH"}="H471 3NH"; $resn_exch{"2H47 3NH"}="H472 3NH"; $resn_exch{"1H48 3NH"}="H481 3NH";
$resn_exch{"2H48 3NH"}="H482 3NH"; $resn_exch{"1H36 3NH"}="H361 3NH"; $resn_exch{"2H36 3NH"}="H362 3NH";
$resn_exch{"1HN1 3NH"}="HN11 3NH"; $resn_exch{"2HN1 3NH"}="HN12 3NH"; $resn_exch{"1H2  3NP"}=" H21 3NP";
$resn_exch{"2H2  3NP"}=" H22 3NP"; $resn_exch{"1H3  3NP"}=" H31 3NP"; $resn_exch{"2H3  3NP"}=" H32 3NP";
$resn_exch{"1H7C 3NT"}="H7C1 3NT"; $resn_exch{"2H7C 3NT"}="H7C2 3NT"; $resn_exch{"3H7C 3NT"}="H7C3 3NT";
$resn_exch{"1H17 3OD"}="H171 3OD"; $resn_exch{"2H17 3OD"}="H172 3OD"; $resn_exch{"3H17 3OD"}="H173 3OD";
$resn_exch{"1H11 3OD"}="H111 3OD"; $resn_exch{"2H11 3OD"}="H112 3OD"; $resn_exch{"1H1  3OD"}=" H11 3OD";
$resn_exch{"2H1  3OD"}="H12A 3OD"; $resn_exch{"1HN3 3OD"}="HN31 3OD"; $resn_exch{"2HN3 3OD"}="HN32 3OD";
$resn_exch{"1HO1 3OF"}="HO11 3OF"; $resn_exch{"2HO1 3OF"}="HO12 3OF"; $resn_exch{"1HO2 3OF"}="HO21 3OF";
$resn_exch{"2HO2 3OF"}="HO22 3OF"; $resn_exch{"1H2  3OH"}=" H21 3OH"; $resn_exch{"2H2  3OH"}=" H22 3OH";
$resn_exch{"1H3  3OH"}=" H31 3OH"; $resn_exch{"2H3  3OH"}=" H32 3OH"; $resn_exch{"1H1  3OL"}=" H11 3OL";
$resn_exch{"2H1  3OL"}=" H12 3OL"; $resn_exch{"1H2  3OL"}=" H21 3OL"; $resn_exch{"1H3  3OL"}=" H31 3OL";
$resn_exch{"1H4  3OL"}=" H41 3OL"; $resn_exch{"2H4  3OL"}=" H42 3OL"; $resn_exch{"1H5  3OL"}=" H51 3OL";
$resn_exch{"2H5  3OL"}=" H52 3OL"; $resn_exch{"1H6  3OL"}=" H61 3OL"; $resn_exch{"2H6  3OL"}=" H62 3OL";
$resn_exch{"1H7  3OL"}=" H71 3OL"; $resn_exch{"2H7  3OL"}=" H72 3OL"; $resn_exch{"1H8  3OL"}=" H81 3OL";
$resn_exch{"2H8  3OL"}=" H82 3OL"; $resn_exch{"3H8  3OL"}=" H83 3OL"; $resn_exch{"1H4C 3ON"}="H4C1 3ON";
$resn_exch{"2H4C 3ON"}="H4C2 3ON"; $resn_exch{"1H11 3ON"}="H111 3ON"; $resn_exch{"2H11 3ON"}="H112 3ON";
$resn_exch{"3H11 3ON"}="H113 3ON"; $resn_exch{"1H6C 3ON"}="H6C1 3ON"; $resn_exch{"2H6C 3ON"}="H6C2 3ON";
$resn_exch{"1H9C 3ON"}="H9C1 3ON"; $resn_exch{"2H9C 3ON"}="H9C2 3ON"; $resn_exch{"3H9C 3ON"}="H9C3 3ON";
$resn_exch{"1H8C 3ON"}="H8C1 3ON"; $resn_exch{"2H8C 3ON"}="H8C2 3ON"; $resn_exch{"3H8C 3ON"}="H8C3 3ON";
$resn_exch{"1H14 3ON"}="H141 3ON"; $resn_exch{"2H14 3ON"}="H142 3ON"; $resn_exch{"3H14 3ON"}="H143 3ON";
$resn_exch{"1H19 3ON"}="H191 3ON"; $resn_exch{"2H19 3ON"}="H192 3ON"; $resn_exch{"3H19 3ON"}="H193 3ON";
$resn_exch{"1H26 3ON"}="H261 3ON"; $resn_exch{"2H26 3ON"}="H262 3ON"; $resn_exch{"3H26 3ON"}="H263 3ON";
$resn_exch{"1H30 3ON"}="H301 3ON"; $resn_exch{"2H30 3ON"}="H302 3ON"; $resn_exch{"3H30 3ON"}="H303 3ON";
$resn_exch{"1H31 3ON"}="H311 3ON"; $resn_exch{"2H31 3ON"}="H312 3ON"; $resn_exch{"1H4C 3P4"}="H4C1 3P4";
$resn_exch{"2H4C 3P4"}="H4C2 3P4"; $resn_exch{"1H8C 3P4"}="H8C1 3P4"; $resn_exch{"2H8C 3P4"}="H8C2 3P4";
$resn_exch{"3H8C 3P4"}="H8C3 3P4"; $resn_exch{"1H10 3P4"}="H101 3P4"; $resn_exch{"2H10 3P4"}="H102 3P4";
$resn_exch{"1H11 3P4"}="H111 3P4"; $resn_exch{"2H11 3P4"}="H112 3P4"; $resn_exch{"1H15 3P4"}="H151 3P4";
$resn_exch{"2H15 3P4"}="H152 3P4"; $resn_exch{"1H17 3P4"}="H171 3P4"; $resn_exch{"2H17 3P4"}="H172 3P4";
$resn_exch{"1H18 3P4"}="H181 3P4"; $resn_exch{"2H18 3P4"}="H182 3P4"; $resn_exch{"3H18 3P4"}="H183 3P4";
$resn_exch{"1H19 3P4"}="H191 3P4"; $resn_exch{"2H19 3P4"}="H192 3P4"; $resn_exch{"1H22 3P4"}="H221 3P4";
$resn_exch{"2H22 3P4"}="H222 3P4"; $resn_exch{"1H23 3P4"}="H231 3P4"; $resn_exch{"2H23 3P4"}="H232 3P4";
$resn_exch{"1H15 3PC"}="H151 3PC"; $resn_exch{"2H15 3PC"}="H152 3PC"; $resn_exch{"3H15 3PC"}="H153 3PC";
$resn_exch{"1H14 3PC"}="H141 3PC"; $resn_exch{"2H14 3PC"}="H142 3PC"; $resn_exch{"1H13 3PC"}="H131 3PC";
$resn_exch{"2H13 3PC"}="H132 3PC"; $resn_exch{"1H12 3PC"}="H121 3PC"; $resn_exch{"2H12 3PC"}="H122 3PC";
$resn_exch{"1H11 3PC"}="H111 3PC"; $resn_exch{"2H11 3PC"}="H112 3PC"; $resn_exch{"1H9  3PC"}=" H91 3PC";
$resn_exch{"2H9  3PC"}=" H92 3PC"; $resn_exch{"1H17 3PC"}="H171 3PC"; $resn_exch{"2H17 3PC"}="H172 3PC";
$resn_exch{"1H18 3PC"}="H181 3PC"; $resn_exch{"2H18 3PC"}="H182 3PC"; $resn_exch{"1H19 3PC"}="H191 3PC";
$resn_exch{"2H19 3PC"}="H192 3PC"; $resn_exch{"1H20 3PC"}="H201 3PC"; $resn_exch{"2H20 3PC"}="H202 3PC";
$resn_exch{"1H21 3PC"}="H211 3PC"; $resn_exch{"2H21 3PC"}="H212 3PC"; $resn_exch{"3H21 3PC"}="H213 3PC";
$resn_exch{"1H7  3PC"}=" H71 3PC"; $resn_exch{"2H7  3PC"}=" H72 3PC"; $resn_exch{"1H6  3PC"}=" H61 3PC";
$resn_exch{"2H6  3PC"}=" H62 3PC"; $resn_exch{"1H5  3PC"}=" H51 3PC"; $resn_exch{"2H5  3PC"}=" H52 3PC";
$resn_exch{"1H4  3PC"}=" H41 3PC"; $resn_exch{"2H4  3PC"}=" H42 3PC"; $resn_exch{"1H1  3PC"}=" H11 3PC";
$resn_exch{"2H1  3PC"}=" H12 3PC"; $resn_exch{"3H1  3PC"}=" H13 3PC"; $resn_exch{"1H2  3PC"}=" H21 3PC";
$resn_exch{"2H2  3PC"}=" H22 3PC"; $resn_exch{"3H2  3PC"}=" H23 3PC"; $resn_exch{"1H3  3PC"}=" H31 3PC";
$resn_exch{"2H3  3PC"}=" H32 3PC"; $resn_exch{"3H3  3PC"}=" H33 3PC"; $resn_exch{"1H5' 3PD"}="H5'1 3PD";
$resn_exch{"2H5' 3PD"}="H5'2 3PD"; $resn_exch{"1H2' 3PD"}="H2'1 3PD"; $resn_exch{"2H2' 3PD"}="H2'2 3PD";
$resn_exch{"1HN2 3PD"}="HN21 3PD"; $resn_exch{"2HN2 3PD"}="HN22 3PD"; $resn_exch{"1HN  3PE"}=" HN1 3PE";
$resn_exch{"2HN  3PE"}=" HN2 3PE"; $resn_exch{"3HN  3PE"}=" HN3 3PE"; $resn_exch{"1H11 3PE"}="H111 3PE";
$resn_exch{"2H11 3PE"}="H112 3PE"; $resn_exch{"1H12 3PE"}="H121 3PE"; $resn_exch{"2H12 3PE"}="H122 3PE";
$resn_exch{"1H1  3PE"}=" H11 3PE"; $resn_exch{"2H1  3PE"}=" H12 3PE"; $resn_exch{"1H3  3PE"}=" H31 3PE";
$resn_exch{"2H3  3PE"}=" H32 3PE"; $resn_exch{"1H32 3PE"}="H321 3PE"; $resn_exch{"2H32 3PE"}="H322 3PE";
$resn_exch{"1H33 3PE"}="H331 3PE"; $resn_exch{"2H33 3PE"}="H332 3PE"; $resn_exch{"1H34 3PE"}="H341 3PE";
$resn_exch{"2H34 3PE"}="H342 3PE"; $resn_exch{"1H35 3PE"}="H351 3PE"; $resn_exch{"2H35 3PE"}="H352 3PE";
$resn_exch{"1H36 3PE"}="H361 3PE"; $resn_exch{"2H36 3PE"}="H362 3PE"; $resn_exch{"1H37 3PE"}="H371 3PE";
$resn_exch{"2H37 3PE"}="H372 3PE"; $resn_exch{"1H38 3PE"}="H381 3PE"; $resn_exch{"2H38 3PE"}="H382 3PE";
$resn_exch{"1H39 3PE"}="H391 3PE"; $resn_exch{"2H39 3PE"}="H392 3PE"; $resn_exch{"1H3A 3PE"}="H3A1 3PE";
$resn_exch{"2H3A 3PE"}="H3A2 3PE"; $resn_exch{"1H3B 3PE"}="H3B1 3PE"; $resn_exch{"2H3B 3PE"}="H3B2 3PE";
$resn_exch{"1H3C 3PE"}="H3C1 3PE"; $resn_exch{"2H3C 3PE"}="H3C2 3PE"; $resn_exch{"1H3D 3PE"}="H3D1 3PE";
$resn_exch{"2H3D 3PE"}="H3D2 3PE"; $resn_exch{"1H3E 3PE"}="H3E1 3PE"; $resn_exch{"2H3E 3PE"}="H3E2 3PE";
$resn_exch{"1H3F 3PE"}="H3F1 3PE"; $resn_exch{"2H3F 3PE"}="H3F2 3PE"; $resn_exch{"1H3G 3PE"}="H3G1 3PE";
$resn_exch{"2H3G 3PE"}="H3G2 3PE"; $resn_exch{"1H3H 3PE"}="H3H1 3PE"; $resn_exch{"2H3H 3PE"}="H3H2 3PE";
$resn_exch{"1H3I 3PE"}="H3I1 3PE"; $resn_exch{"2H3I 3PE"}="H3I2 3PE"; $resn_exch{"3H3I 3PE"}="H3I3 3PE";
$resn_exch{"1H22 3PE"}="H221 3PE"; $resn_exch{"2H22 3PE"}="H222 3PE"; $resn_exch{"1H23 3PE"}="H231 3PE";
$resn_exch{"2H23 3PE"}="H232 3PE"; $resn_exch{"1H24 3PE"}="H241 3PE"; $resn_exch{"2H24 3PE"}="H242 3PE";
$resn_exch{"1H25 3PE"}="H251 3PE"; $resn_exch{"2H25 3PE"}="H252 3PE"; $resn_exch{"1H26 3PE"}="H261 3PE";
$resn_exch{"2H26 3PE"}="H262 3PE"; $resn_exch{"1H27 3PE"}="H271 3PE"; $resn_exch{"2H27 3PE"}="H272 3PE";
$resn_exch{"1H28 3PE"}="H281 3PE"; $resn_exch{"2H28 3PE"}="H282 3PE"; $resn_exch{"1H29 3PE"}="H291 3PE";
$resn_exch{"2H29 3PE"}="H292 3PE"; $resn_exch{"1H2A 3PE"}="H2A1 3PE"; $resn_exch{"2H2A 3PE"}="H2A2 3PE";
$resn_exch{"1H2B 3PE"}="H2B1 3PE"; $resn_exch{"2H2B 3PE"}="H2B2 3PE"; $resn_exch{"1H2C 3PE"}="H2C1 3PE";
$resn_exch{"2H2C 3PE"}="H2C2 3PE"; $resn_exch{"1H2D 3PE"}="H2D1 3PE"; $resn_exch{"2H2D 3PE"}="H2D2 3PE";
$resn_exch{"1H2E 3PE"}="H2E1 3PE"; $resn_exch{"2H2E 3PE"}="H2E2 3PE"; $resn_exch{"1H2F 3PE"}="H2F1 3PE";
$resn_exch{"2H2F 3PE"}="H2F2 3PE"; $resn_exch{"1H2G 3PE"}="H2G1 3PE"; $resn_exch{"2H2G 3PE"}="H2G2 3PE";
$resn_exch{"1H2H 3PE"}="H2H1 3PE"; $resn_exch{"2H2H 3PE"}="H2H2 3PE"; $resn_exch{"1H2I 3PE"}="H2I1 3PE";
$resn_exch{"2H2I 3PE"}="H2I2 3PE"; $resn_exch{"3H2I 3PE"}="H2I3 3PE"; $resn_exch{"1H3  3PG"}=" H31 3PG";
$resn_exch{"2H3  3PG"}=" H32 3PG"; $resn_exch{"3HOP 3PG"}="HOP3 3PG"; $resn_exch{"4HOP 3PG"}="HOP4 3PG";
$resn_exch{"1H7  3PI"}=" H71 3PI"; $resn_exch{"2H7  3PI"}=" H72 3PI"; $resn_exch{"1H9  3PI"}=" H91 3PI";
$resn_exch{"2H9  3PI"}=" H92 3PI"; $resn_exch{"1H11 3PI"}="H111 3PI"; $resn_exch{"2H11 3PI"}="H112 3PI";
$resn_exch{"1H12 3PI"}="H121 3PI"; $resn_exch{"2H12 3PI"}="H122 3PI"; $resn_exch{"1H13 3PI"}="H131 3PI";
$resn_exch{"2H13 3PI"}="H132 3PI"; $resn_exch{"3H13 3PI"}="H133 3PI"; $resn_exch{"1H15 3PI"}="H151 3PI";
$resn_exch{"2H15 3PI"}="H152 3PI"; $resn_exch{"1H16 3PI"}="H161 3PI"; $resn_exch{"2H16 3PI"}="H162 3PI";
$resn_exch{"1H17 3PI"}="H171 3PI"; $resn_exch{"2H17 3PI"}="H172 3PI"; $resn_exch{"3H17 3PI"}="H173 3PI";
$resn_exch{"1HA  3PL"}=" HA1 3PL"; $resn_exch{"2HA  3PL"}=" HA2 3PL"; $resn_exch{"1HB  3PL"}=" HB1 3PL";
$resn_exch{"2HB  3PL"}=" HB2 3PL"; $resn_exch{"2HOG 3PO"}="HOG2 3PO"; $resn_exch{"3HOG 3PO"}="HOG3 3PO";
$resn_exch{"2HOB 3PO"}="HOB2 3PO"; $resn_exch{"2HOA 3PO"}="HOA2 3PO"; $resn_exch{"HO5* 3PO"}="HO5' 3PO";
$resn_exch{"1HCB 3PP"}="HCB1 3PP"; $resn_exch{"2HCB 3PP"}="HCB2 3PP"; $resn_exch{"1HCG 3PP"}="HCG1 3PP";
$resn_exch{"2HCG 3PP"}="HCG2 3PP"; $resn_exch{"1H3  3PY"}=" H31 3PY"; $resn_exch{"2H3  3PY"}=" H32 3PY";
$resn_exch{"1H2  3QC"}="H21A 3QC"; $resn_exch{"2H2  3QC"}="H22A 3QC"; $resn_exch{"1H33 3QC"}="H331 3QC";
$resn_exch{"2H33 3QC"}="H332 3QC"; $resn_exch{"3H33 3QC"}="H333 3QC"; $resn_exch{"1H4  3QC"}=" H41 3QC";
$resn_exch{"2H4  3QC"}=" H42 3QC"; $resn_exch{"1H29 3QC"}="H291 3QC"; $resn_exch{"2H29 3QC"}="H292 3QC";
$resn_exch{"3H29 3QC"}="H293 3QC"; $resn_exch{"1H40 3QC"}="H401 3QC"; $resn_exch{"2H40 3QC"}="H402 3QC";
$resn_exch{"3H40 3QC"}="H403 3QC"; $resn_exch{"1H44 3QC"}="H441 3QC"; $resn_exch{"2H44 3QC"}="H442 3QC";
$resn_exch{"3H44 3QC"}="H443 3QC"; $resn_exch{"1H6X 3SA"}="H6X1 3SA"; $resn_exch{"2H6X 3SA"}="H6X2 3SA";
$resn_exch{"1H6Y 3SA"}="H6Y1 3SA"; $resn_exch{"2H6Y 3SA"}="H6Y2 3SA"; $resn_exch{"3H6Y 3SA"}="H6Y3 3SA";
$resn_exch{"1H7Z 3SA"}="H7Z1 3SA"; $resn_exch{"2H7Z 3SA"}="H7Z2 3SA"; $resn_exch{"1H12 3SC"}="H121 3SC";
$resn_exch{"2H12 3SC"}="H122 3SC"; $resn_exch{"1H3  3SL"}=" H31 3SL"; $resn_exch{"2H3  3SL"}=" H32 3SL";
$resn_exch{"1HN8 3SP"}="HN81 3SP"; $resn_exch{"2HN8 3SP"}="HN82 3SP"; $resn_exch{"1H9  3SP"}=" H91 3SP";
$resn_exch{"2H9  3SP"}=" H92 3SP"; $resn_exch{"1H14 3SP"}="H141 3SP"; $resn_exch{"2H14 3SP"}="H142 3SP";
$resn_exch{"1H15 3SP"}="H151 3SP"; $resn_exch{"2H15 3SP"}="H152 3SP"; $resn_exch{"1H16 3SP"}="H161 3SP";
$resn_exch{"2H16 3SP"}="H162 3SP"; $resn_exch{"1H22 3SP"}="H221 3SP"; $resn_exch{"2H22 3SP"}="H222 3SP";
$resn_exch{"1H24 3SP"}="H241 3SP"; $resn_exch{"2H24 3SP"}="H242 3SP"; $resn_exch{"1H26 3SP"}="H261 3SP";
$resn_exch{"2H26 3SP"}="H262 3SP"; $resn_exch{"1H27 3SP"}="H271 3SP"; $resn_exch{"2H27 3SP"}="H272 3SP";
$resn_exch{"1H28 3SP"}="H281 3SP"; $resn_exch{"2H28 3SP"}="H282 3SP"; $resn_exch{"1H29 3SP"}="H291 3SP";
$resn_exch{"2H29 3SP"}="H292 3SP"; $resn_exch{"1H30 3SP"}="H301 3SP"; $resn_exch{"2H30 3SP"}="H302 3SP";
$resn_exch{"1HN3 3TC"}="HN31 3TC"; $resn_exch{"2HN3 3TC"}="HN32 3TC"; $resn_exch{"1H6  3TC"}=" H61 3TC";
$resn_exch{"2H6  3TC"}=" H62 3TC"; $resn_exch{"1H8  3TC"}=" H81 3TC"; $resn_exch{"2H8  3TC"}=" H82 3TC";
$resn_exch{"1H15 3TH"}="H151 3TH"; $resn_exch{"2H15 3TH"}="H152 3TH"; $resn_exch{"1H3  3TL"}=" H31 3TL";
$resn_exch{"2H3  3TL"}=" H32 3TL"; $resn_exch{"1H20 3TL"}="H201 3TL"; $resn_exch{"2H20 3TL"}="H202 3TL";
$resn_exch{"3H20 3TL"}="H203 3TL"; $resn_exch{"1HA5 3TL"}="HA51 3TL"; $resn_exch{"2HA5 3TL"}="HA52 3TL";
$resn_exch{"1H70 3TL"}="H701 3TL"; $resn_exch{"2H70 3TL"}="H702 3TL"; $resn_exch{"3H70 3TL"}="H703 3TL";
$resn_exch{"1HG6 3TL"}="HG61 3TL"; $resn_exch{"2HG6 3TL"}="HG62 3TL"; $resn_exch{"3HG6 3TL"}="HG63 3TL";
$resn_exch{"1HG5 3TL"}="HG51 3TL"; $resn_exch{"2HG5 3TL"}="HG52 3TL"; $resn_exch{"3HG5 3TL"}="HG53 3TL";
$resn_exch{"1H53 3TL"}="H531 3TL"; $resn_exch{"2H53 3TL"}="H532 3TL"; $resn_exch{"1HG2 3TL"}="HG21 3TL";
$resn_exch{"2HG2 3TL"}="HG22 3TL"; $resn_exch{"3HG2 3TL"}="HG23 3TL"; $resn_exch{"1HG1 3TL"}="HG11 3TL";
$resn_exch{"2HG1 3TL"}="HG12 3TL"; $resn_exch{"3HG1 3TL"}="HG13 3TL"; $resn_exch{"1HA  3TL"}=" HA1 3TL";
$resn_exch{"2HA  3TL"}=" HA2 3TL"; $resn_exch{"1HAA 3TN"}="HAA1 3TN"; $resn_exch{"2HAA 3TN"}="HAA2 3TN";
$resn_exch{"3HAA 3TN"}="HAA3 3TN"; $resn_exch{"1HAB 3TN"}="HAB1 3TN"; $resn_exch{"2HAB 3TN"}="HAB2 3TN";
$resn_exch{"3HAB 3TN"}="HAB3 3TN"; $resn_exch{"1HAC 3TN"}="HAC1 3TN"; $resn_exch{"2HAC 3TN"}="HAC2 3TN";
$resn_exch{"3HAC 3TN"}="HAC3 3TN"; $resn_exch{"1HAP 3TN"}="HAP1 3TN"; $resn_exch{"2HAP 3TN"}="HAP2 3TN";
$resn_exch{"1HAQ 3TN"}="HAQ1 3TN"; $resn_exch{"2HAQ 3TN"}="HAQ2 3TN"; $resn_exch{"1HAD 3TN"}="HAD1 3TN";
$resn_exch{"2HAD 3TN"}="HAD2 3TN"; $resn_exch{"3HAD 3TN"}="HAD3 3TN"; $resn_exch{"1HAE 3TN"}="HAE1 3TN";
$resn_exch{"2HAE 3TN"}="HAE2 3TN"; $resn_exch{"3HAE 3TN"}="HAE3 3TN"; $resn_exch{"1HN6 3TP"}="HN61 3TP";
$resn_exch{"2HN6 3TP"}="HN62 3TP"; $resn_exch{"1H37 3TP"}="H371 3TP"; $resn_exch{"2H37 3TP"}="H372 3TP";
$resn_exch{"3H37 3TP"}="H373 3TP"; $resn_exch{"1H44 3TP"}="H441 3TP"; $resn_exch{"2H44 3TP"}="H442 3TP";
$resn_exch{"3H44 3TP"}="H443 3TP"; $resn_exch{"1H3A 3TR"}="H3A1 3TR"; $resn_exch{"2H3A 3TR"}="H3A2 3TR";
$resn_exch{"1HT3 3TY"}="HT31 3TY"; $resn_exch{"2HT3 3TY"}="HT32 3TY"; $resn_exch{"1H51 3UN"}="H511 3UN";
$resn_exch{"2H51 3UN"}="H512 3UN"; $resn_exch{"1H54 3UN"}="H541 3UN"; $resn_exch{"2H54 3UN"}="H542 3UN";
$resn_exch{"3H54 3UN"}="H543 3UN"; $resn_exch{"1H15 3UN"}="H151 3UN"; $resn_exch{"2H15 3UN"}="H152 3UN";
$resn_exch{"1H44 3UN"}="H441 3UN"; $resn_exch{"2H44 3UN"}="H442 3UN"; $resn_exch{"1H23 3UN"}="H231 3UN";
$resn_exch{"2H23 3UN"}="H232 3UN"; $resn_exch{"3H23 3UN"}="H233 3UN"; $resn_exch{"1H22 3UN"}="H221 3UN";
$resn_exch{"2H22 3UN"}="H222 3UN"; $resn_exch{"3H22 3UN"}="H223 3UN"; $resn_exch{"1H21 3UN"}="H211 3UN";
$resn_exch{"2H21 3UN"}="H212 3UN"; $resn_exch{"3H21 3UN"}="H213 3UN"; $resn_exch{"1H50 3UN"}="H501 3UN";
$resn_exch{"2H50 3UN"}="H502 3UN"; $resn_exch{"1H60 3UN"}="H601 3UN"; $resn_exch{"2H60 3UN"}="H602 3UN";
$resn_exch{"3H60 3UN"}="H603 3UN"; $resn_exch{"1H35 3UN"}="H351 3UN"; $resn_exch{"2H35 3UN"}="H352 3UN";
$resn_exch{"1HAF 3YP"}="HAF1 3YP"; $resn_exch{"2HAF 3YP"}="HAF2 3YP"; $resn_exch{"1HAC 3YP"}="HAC1 3YP";
$resn_exch{"2HAC 3YP"}="HAC2 3YP"; $resn_exch{"1HAD 3YP"}="HAD1 3YP"; $resn_exch{"2HAD 3YP"}="HAD2 3YP";
$resn_exch{"1HAG 3YP"}="HAG1 3YP"; $resn_exch{"2HAG 3YP"}="HAG2 3YP"; $resn_exch{"1HAH 3YP"}="HAH1 3YP";
$resn_exch{"2HAH 3YP"}="HAH2 3YP"; $resn_exch{"1HAE 3YP"}="HAE1 3YP"; $resn_exch{"2HAE 3YP"}="HAE2 3YP";
$resn_exch{"1H39 406"}="H391 406"; $resn_exch{"2H39 406"}="H392 406"; $resn_exch{"3H39 406"}="H393 406";
$resn_exch{"1H11 406"}="H111 406"; $resn_exch{"2H11 406"}="H112 406"; $resn_exch{"1H13 406"}="H131 406";
$resn_exch{"2H13 406"}="H132 406"; $resn_exch{"1H14 406"}="H141 406"; $resn_exch{"2H14 406"}="H142 406";
$resn_exch{"1H16 406"}="H161 406"; $resn_exch{"2H16 406"}="H162 406"; $resn_exch{"1H18 406"}="H181 406";
$resn_exch{"2H18 406"}="H182 406"; $resn_exch{"3H18 406"}="H183 406"; $resn_exch{"1H19 406"}="H191 406";
$resn_exch{"2H19 406"}="H192 406"; $resn_exch{"3H19 406"}="H193 406"; $resn_exch{"1H07 412"}="H071 412";
$resn_exch{"2H07 412"}="H072 412"; $resn_exch{"1H08 412"}="H081 412"; $resn_exch{"2H08 412"}="H082 412";
$resn_exch{"1H12 412"}="H121 412"; $resn_exch{"2H12 412"}="H122 412"; $resn_exch{"1H14 412"}="H141 412";
$resn_exch{"2H14 412"}="H142 412"; $resn_exch{"1H19 412"}="H191 412"; $resn_exch{"2H19 412"}="H192 412";
$resn_exch{"1H1N 413"}="H1N1 413"; $resn_exch{"2H1N 413"}="H1N2 413"; $resn_exch{"1H15 413"}="H151 413";
$resn_exch{"2H15 413"}="H152 413"; $resn_exch{"3H15 413"}="H153 413"; $resn_exch{"1H16 413"}="H161 413";
$resn_exch{"2H16 413"}="H162 413"; $resn_exch{"1H33 414"}="H331 414"; $resn_exch{"2H33 414"}="H332 414";
$resn_exch{"1H51 414"}="H511 414"; $resn_exch{"2H51 414"}="H512 414"; $resn_exch{"1H52 414"}="H521 414";
$resn_exch{"2H52 414"}="H522 414"; $resn_exch{"1H53 414"}="H531 414"; $resn_exch{"2H53 414"}="H532 414";
$resn_exch{"1H54 414"}="H541 414"; $resn_exch{"2H54 414"}="H542 414"; $resn_exch{"1H55 414"}="H551 414";
$resn_exch{"2H55 414"}="H552 414"; $resn_exch{"1H11 414"}="H111 414"; $resn_exch{"2H11 414"}="H112 414";
$resn_exch{"1H10 417"}="H101 417"; $resn_exch{"2H10 417"}="H102 417"; $resn_exch{"1H11 417"}="H111 417";
$resn_exch{"2H11 417"}="H112 417"; $resn_exch{"1H13 417"}="H131 417"; $resn_exch{"2H13 417"}="H132 417";
$resn_exch{"1H22 417"}="H221 417"; $resn_exch{"2H22 417"}="H222 417"; $resn_exch{"1H23 417"}="H231 417";
$resn_exch{"2H23 417"}="H232 417"; $resn_exch{"1H26 417"}="H261 417"; $resn_exch{"2H26 417"}="H262 417";
$resn_exch{"1H38 417"}="H381 417"; $resn_exch{"2H38 417"}="H382 417"; $resn_exch{"1H7  418"}=" H71 418";
$resn_exch{"2H7  418"}=" H72 418"; $resn_exch{"1H40 418"}="H401 418"; $resn_exch{"2H40 418"}="H402 418";
$resn_exch{"1H42 418"}="H421 418"; $resn_exch{"2H42 418"}="H422 418"; $resn_exch{"1H12 418"}="H121 418";
$resn_exch{"2H12 418"}="H122 418"; $resn_exch{"1H13 418"}="H131 418"; $resn_exch{"2H13 418"}="H132 418";
$resn_exch{"1H15 418"}="H151 418"; $resn_exch{"2H15 418"}="H152 418"; $resn_exch{"1H14 418"}="H141 418";
$resn_exch{"2H14 418"}="H142 418"; $resn_exch{"1H39 418"}="H391 418"; $resn_exch{"2H39 418"}="H392 418";
$resn_exch{"3H39 418"}="H393 418"; $resn_exch{"1H12 421"}="H121 421"; $resn_exch{"2H12 421"}="H122 421";
$resn_exch{"1H23 421"}="H231 421"; $resn_exch{"2H23 421"}="H232 421"; $resn_exch{"3H23 421"}="H233 421";
$resn_exch{"1H28 421"}="H281 421"; $resn_exch{"2H28 421"}="H282 421"; $resn_exch{"3H28 421"}="H283 421";
$resn_exch{"1H7  422"}=" H71 422"; $resn_exch{"2H7  422"}=" H72 422"; $resn_exch{"1H8  422"}=" H81 422";
$resn_exch{"2H8  422"}=" H82 422"; $resn_exch{"1H9  422"}=" H91 422"; $resn_exch{"2H9  422"}=" H92 422";
$resn_exch{"1H10 422"}="H101 422"; $resn_exch{"2H10 422"}="H102 422"; $resn_exch{"1H13 422"}="H131 422";
$resn_exch{"2H13 422"}="H132 422"; $resn_exch{"1H18 422"}="H181 422"; $resn_exch{"2H18 422"}="H182 422";
$resn_exch{"1HN3 422"}="HN31 422"; $resn_exch{"2HN3 422"}="HN32 422"; $resn_exch{"1H19 426"}="H191 426";
$resn_exch{"2H19 426"}="H192 426"; $resn_exch{"1H38 426"}="H381 426"; $resn_exch{"2H38 426"}="H382 426";
$resn_exch{"1H37 426"}="H371 426"; $resn_exch{"2H37 426"}="H372 426"; $resn_exch{"1H36 426"}="H361 426";
$resn_exch{"2H36 426"}="H362 426"; $resn_exch{"1H35 426"}="H351 426"; $resn_exch{"2H35 426"}="H352 426";
$resn_exch{"1H12 427"}="H121 427"; $resn_exch{"2H12 427"}="H122 427"; $resn_exch{"1H14 427"}="H141 427";
$resn_exch{"2H14 427"}="H142 427"; $resn_exch{"1H17 427"}="H171 427"; $resn_exch{"2H17 427"}="H172 427";
$resn_exch{"1H12 429"}="H121 429"; $resn_exch{"2H12 429"}="H122 429"; $resn_exch{"1H13 429"}="H131 429";
$resn_exch{"2H13 429"}="H132 429"; $resn_exch{"1H14 429"}="H141 429"; $resn_exch{"2H14 429"}="H142 429";
$resn_exch{"1H15 429"}="H151 429"; $resn_exch{"2H15 429"}="H152 429"; $resn_exch{"1H23 429"}="H231 429";
$resn_exch{"2H23 429"}="H232 429"; $resn_exch{"3H23 429"}="H233 429"; $resn_exch{"1H8  429"}=" H81 429";
$resn_exch{"2H8  429"}=" H82 429"; $resn_exch{"1H7  429"}=" H71 429"; $resn_exch{"2H7  429"}=" H72 429";
$resn_exch{"1H39 429"}="H391 429"; $resn_exch{"2H39 429"}="H392 429"; $resn_exch{"3H39 429"}="H393 429";
$resn_exch{"1H1N 42B"}="H1N1 42B"; $resn_exch{"2H1N 42B"}="H1N2 42B"; $resn_exch{"1H5C 42B"}="H5C1 42B";
$resn_exch{"2H5C 42B"}="H5C2 42B"; $resn_exch{"1H6C 42B"}="H6C1 42B"; $resn_exch{"2H6C 42B"}="H6C2 42B";
$resn_exch{"1HOB 433"}="HOB1 433"; $resn_exch{"1H1X 433"}="H1X1 433"; $resn_exch{"2H1X 433"}="H1X2 433";
$resn_exch{"3H1X 433"}="H1X3 433"; $resn_exch{"1H1Y 433"}="H1Y1 433"; $resn_exch{"2H1Y 433"}="H1Y2 433";
$resn_exch{"3H1Y 433"}="H1Y3 433"; $resn_exch{"1H1G 433"}="H1G1 433"; $resn_exch{"1H1I 433"}="H1I1 433";
$resn_exch{"1H1J 433"}="H1J1 433"; $resn_exch{"1H1H 433"}="H1H1 433"; $resn_exch{"1H1L 433"}="H1L1 433";
$resn_exch{"2H1L 433"}="H1L2 433"; $resn_exch{"1H1M 433"}="H1M1 433"; $resn_exch{"2H1M 433"}="H1M2 433";
$resn_exch{"1H1N 433"}="H1N1 433"; $resn_exch{"2H1N 433"}="H1N2 433"; $resn_exch{"1H2C 433"}="H2C1 433";
$resn_exch{"2H2C 433"}="H2C2 433"; $resn_exch{"1HN3 433"}="HN31 433"; $resn_exch{"1H3C 433"}="H3C1 433";
$resn_exch{"1H3E 433"}="H3E1 433"; $resn_exch{"1H3G 433"}="H3G1 433"; $resn_exch{"1H2D 433"}="H2D1 433";
$resn_exch{"2H2D 433"}="H2D2 433"; $resn_exch{"1H2H 433"}="H2H1 433"; $resn_exch{"1H2J 433"}="H2J1 433";
$resn_exch{"1H2I 433"}="H2I1 433"; $resn_exch{"1H3  434"}=" H31 434"; $resn_exch{"2H3  434"}=" H32 434";
$resn_exch{"3H3  434"}="H33A 434"; $resn_exch{"1H9  43A"}=" H91 43A"; $resn_exch{"2H9  43A"}=" H92 43A";
$resn_exch{"3H9  43A"}=" H93 43A"; $resn_exch{"1H7  43M"}=" H71 43M"; $resn_exch{"2H7  43M"}=" H72 43M";
$resn_exch{"3H7  43M"}=" H73 43M"; $resn_exch{"1HAS 43P"}="HAS1 43P"; $resn_exch{"2HAS 43P"}="HAS2 43P";
$resn_exch{"1HAT 43P"}="HAT1 43P"; $resn_exch{"2HAT 43P"}="HAT2 43P"; $resn_exch{"3HAT 43P"}="HAT3 43P";
$resn_exch{"1H7  442"}=" H71 442"; $resn_exch{"2H7  442"}=" H72 442"; $resn_exch{"1H29 442"}="H291 442";
$resn_exch{"2H29 442"}="H292 442"; $resn_exch{"1H30 442"}="H301 442"; $resn_exch{"2H30 442"}="H302 442";
$resn_exch{"1H16 444"}="H161 444"; $resn_exch{"2H16 444"}="H162 444"; $resn_exch{"1H11 448"}="H111 448";
$resn_exch{"2H11 448"}="H112 448"; $resn_exch{"1H20 448"}="H201 448"; $resn_exch{"2H20 448"}="H202 448";
$resn_exch{"1H15 448"}="H151 448"; $resn_exch{"2H15 448"}="H152 448"; $resn_exch{"1H25 448"}="H251 448";
$resn_exch{"2H25 448"}="H252 448"; $resn_exch{"1H26 448"}="H261 448"; $resn_exch{"2H26 448"}="H262 448";
$resn_exch{"1H34 448"}="H341 448"; $resn_exch{"2H34 448"}="H342 448"; $resn_exch{"3H34 448"}="H343 448";
$resn_exch{"1H16 44B"}="H161 44B"; $resn_exch{"2H16 44B"}="H162 44B"; $resn_exch{"1H17 44C"}="H171 44C";
$resn_exch{"2H17 44C"}="H172 44C"; $resn_exch{"1H18 44C"}="H181 44C"; $resn_exch{"2H18 44C"}="H182 44C";
$resn_exch{"1H19 44C"}="H191 44C"; $resn_exch{"2H19 44C"}="H192 44C"; $resn_exch{"1H20 44C"}="H201 44C";
$resn_exch{"2H20 44C"}="H202 44C"; $resn_exch{"1HC8 44D"}="HC81 44D"; $resn_exch{"2HC8 44D"}="HC82 44D";
$resn_exch{"1H10 44D"}="H101 44D"; $resn_exch{"2H10 44D"}="H102 44D"; $resn_exch{"1H14 44D"}="H141 44D";
$resn_exch{"2H14 44D"}="H142 44D"; $resn_exch{" H1* 44D"}=" H1B 44D"; $resn_exch{"1H2* 44D"}="H2'1 44D";
$resn_exch{"2H2* 44D"}="H2'2 44D"; $resn_exch{" H3* 44D"}=" H3B 44D"; $resn_exch{" H4* 44D"}=" H4B 44D";
$resn_exch{" H5* 44D"}=" H5B 44D"; $resn_exch{"1H6* 44D"}="H6'1 44D"; $resn_exch{"2H6* 44D"}="H6'2 44D";
$resn_exch{"3H6* 44D"}="H6'3 44D"; $resn_exch{"OH3* 44D"}="H3'O 44D"; $resn_exch{"1H2' 44D"}=" H2B 44D";
$resn_exch{"2H2' 44D"}=" H2D 44D"; $resn_exch{"1H6' 44D"}=" H6B 44D"; $resn_exch{"2H6' 44D"}=" H6D 44D";
$resn_exch{"3H6' 44D"}=" H6E 44D"; $resn_exch{"OH4' 44D"}="H4'O 44D"; $resn_exch{"1H3' 44D"}="H3'1 44D";
$resn_exch{"2H3' 44D"}="H3'2 44D"; $resn_exch{"1H2  450"}="H21A 450"; $resn_exch{"2H2  450"}="H22A 450";
$resn_exch{"1H7  450"}="H71A 450"; $resn_exch{"2H7  450"}=" H72 450"; $resn_exch{"1HN2 450"}="HN21 450";
$resn_exch{"2HN2 450"}="HN22 450"; $resn_exch{"1H31 450"}="H311 450"; $resn_exch{"2H31 450"}="H312 450";
$resn_exch{"1H61 450"}="H611 450"; $resn_exch{"2H61 450"}="H612 450"; $resn_exch{"1HN7 450"}="HN71 450";
$resn_exch{"2HN7 450"}="HN72 450"; $resn_exch{"1H1  452"}=" H11 452"; $resn_exch{"2H1  452"}="H12A 452";
$resn_exch{"3H1  452"}="H13A 452"; $resn_exch{"1H9  452"}=" H91 452"; $resn_exch{"2H9  452"}=" H92 452";
$resn_exch{"1HAK 458"}="HAK1 458"; $resn_exch{"2HAK 458"}="HAK2 458"; $resn_exch{"1HAR 458"}="HAR1 458";
$resn_exch{"2HAR 458"}="HAR2 458"; $resn_exch{"3HAR 458"}="HAR3 458"; $resn_exch{"1HAP 458"}="HAP1 458";
$resn_exch{"2HAP 458"}="HAP2 458"; $resn_exch{"1HAT 458"}="HAT1 458"; $resn_exch{"2HAT 458"}="HAT2 458";
$resn_exch{"1HAM 458"}="HAM1 458"; $resn_exch{"2HAM 458"}="HAM2 458"; $resn_exch{"1HAT 459"}="HAT1 459";
$resn_exch{"2HAT 459"}="HAT2 459"; $resn_exch{"3HAT 459"}="HAT3 459"; $resn_exch{"1HAQ 459"}="HAQ1 459";
$resn_exch{"2HAQ 459"}="HAQ2 459"; $resn_exch{"3HAQ 459"}="HAQ3 459"; $resn_exch{"1HAP 459"}="HAP1 459";
$resn_exch{"2HAP 459"}="HAP2 459"; $resn_exch{"1HAO 459"}="HAO1 459"; $resn_exch{"2HAO 459"}="HAO2 459";
$resn_exch{"1HAR 459"}="HAR1 459"; $resn_exch{"2HAR 459"}="HAR2 459"; $resn_exch{"1HAM 459"}="HAM1 459";
$resn_exch{"2HAM 459"}="HAM2 459"; $resn_exch{"1H1  460"}=" H11 460"; $resn_exch{"2H1  460"}=" H12 460";
$resn_exch{"3H1  460"}=" H13 460"; $resn_exch{"1H12 460"}="H121 460"; $resn_exch{"2H12 460"}="H122 460";
$resn_exch{"1H38 464"}="H381 464"; $resn_exch{"2H38 464"}="H382 464"; $resn_exch{"1H39 464"}="H391 464";
$resn_exch{"2H39 464"}="H392 464"; $resn_exch{"1H40 464"}="H401 464"; $resn_exch{"2H40 464"}="H402 464";
$resn_exch{"1H41 464"}="H411 464"; $resn_exch{"2H41 464"}="H412 464"; $resn_exch{"1H42 464"}="H421 464";
$resn_exch{"2H42 464"}="H422 464"; $resn_exch{"1H36 464"}="H361 464"; $resn_exch{"2H36 464"}="H362 464";
$resn_exch{"1H35 464"}="H351 464"; $resn_exch{"2H35 464"}="H352 464"; $resn_exch{"1H18 464"}="H181 464";
$resn_exch{"2H18 464"}="H182 464"; $resn_exch{"1H14 464"}="H141 464"; $resn_exch{"2H14 464"}="H142 464";
$resn_exch{"1H10 468"}="H101 468"; $resn_exch{"2H10 468"}="H102 468"; $resn_exch{"1H8  468"}=" H81 468";
$resn_exch{"2H8  468"}=" H82 468"; $resn_exch{"1H4  468"}=" H41 468"; $resn_exch{"2H4  468"}=" H42 468";
$resn_exch{"1H23 468"}="H231 468"; $resn_exch{"2H23 468"}="H232 468"; $resn_exch{"3H23 468"}="H233 468";
$resn_exch{"1HP6 46D"}="HP61 46D"; $resn_exch{"2HP6 46D"}="HP62 46D"; $resn_exch{"1HP8 46D"}="HP81 46D";
$resn_exch{"2HP8 46D"}="HP82 46D"; $resn_exch{"3HP8 46D"}="HP83 46D"; $resn_exch{"1H8  46M"}=" H81 46M";
$resn_exch{"2H8  46M"}=" H82 46M"; $resn_exch{"3H8  46M"}=" H83 46M"; $resn_exch{"1H6  46M"}=" H61 46M";
$resn_exch{"2H6  46M"}=" H62 46M"; $resn_exch{"1HB  471"}=" HB1 471"; $resn_exch{"2HB  471"}=" HB2 471";
$resn_exch{"1H1B 471"}="H1B1 471"; $resn_exch{"2H1B 471"}="H1B2 471"; $resn_exch{"3HIB 471"}="HIB3 471";
$resn_exch{"1H3E 471"}="H3E1 471"; $resn_exch{"2H3E 471"}="H3E2 471"; $resn_exch{"3H3E 471"}="H3E3 471";
$resn_exch{"1H3A 471"}="H3A1 471"; $resn_exch{"2H3A 471"}="H3A2 471"; $resn_exch{"1H3B 471"}="H3B1 471";
$resn_exch{"2H3B 471"}="H3B2 471"; $resn_exch{"1H4A 471"}="H4A1 471"; $resn_exch{"2H4A 471"}="H4A2 471";
$resn_exch{"1H4D 471"}="H4D1 471"; $resn_exch{"2H4D 471"}="H4D2 471"; $resn_exch{"1H4E 471"}="H4E1 471";
$resn_exch{"2H4E 471"}="H4E2 471"; $resn_exch{"3H4E 471"}="H4E3 471"; $resn_exch{"1HN6 474"}="HN61 474";
$resn_exch{"2HN6 474"}="HN62 474"; $resn_exch{"1H21 474"}="H211 474"; $resn_exch{"2H21 474"}="H212 474";
$resn_exch{"1H20 474"}="H201 474"; $resn_exch{"2H20 474"}="H202 474"; $resn_exch{"1H18 474"}="H181 474";
$resn_exch{"2H18 474"}="H182 474"; $resn_exch{"1H10 474"}="H101 474"; $resn_exch{"2H10 474"}="H102 474";
$resn_exch{"3H10 474"}="H103 474"; $resn_exch{"1H14 474"}="H141 474"; $resn_exch{"2H14 474"}="H142 474";
$resn_exch{"3H14 474"}="H143 474"; $resn_exch{"1H31 474"}="H311 474"; $resn_exch{"2H31 474"}="H312 474";
$resn_exch{"1H30 474"}="H301 474"; $resn_exch{"2H30 474"}="H302 474"; $resn_exch{"1H34 474"}="H341 474";
$resn_exch{"2H34 474"}="H342 474"; $resn_exch{"1H33 474"}="H331 474"; $resn_exch{"2H33 474"}="H332 474";
$resn_exch{"1H1  478"}="H11A 478"; $resn_exch{"2H1  478"}="H12A 478"; $resn_exch{"1H2  478"}="H21A 478";
$resn_exch{"2H2  478"}="H22A 478"; $resn_exch{"1H7  478"}=" H71 478"; $resn_exch{"2H7  478"}=" H72 478";
$resn_exch{"1H14 478"}="H141 478"; $resn_exch{"2H14 478"}="H142 478"; $resn_exch{"1H15 478"}="H151 478";
$resn_exch{"2H15 478"}="H152 478"; $resn_exch{"1H23 478"}="H231 478"; $resn_exch{"2H23 478"}="H232 478";
$resn_exch{"3H23 478"}="H233 478"; $resn_exch{"1H24 478"}="H241 478"; $resn_exch{"2H24 478"}="H242 478";
$resn_exch{"3H24 478"}="H243 478"; $resn_exch{"1H25 478"}="H251 478"; $resn_exch{"2H25 478"}="H252 478";
$resn_exch{"1HN3 478"}="HN31 478"; $resn_exch{"2HN3 478"}="HN32 478"; $resn_exch{"1H3  47D"}=" H31 47D";
$resn_exch{"2H3  47D"}=" H32 47D"; $resn_exch{"1H5  47D"}=" H51 47D"; $resn_exch{"2H5  47D"}=" H52 47D";
$resn_exch{"1H8  485"}=" H81 485"; $resn_exch{"2H8  485"}=" H82 485"; $resn_exch{"1H10 485"}="H101 485";
$resn_exch{"2H10 485"}="H102 485"; $resn_exch{"1H27 485"}="H271 485"; $resn_exch{"2H27 485"}="H272 485";
$resn_exch{"3H27 485"}="H273 485"; $resn_exch{"1HC1 486"}="HC1A 486"; $resn_exch{"2HC1 486"}="HC12 486";
$resn_exch{"1HC7 486"}="HC71 486"; $resn_exch{"2HC7 486"}="HC72 486"; $resn_exch{"1HC6 486"}="HC61 486";
$resn_exch{"2HC6 486"}="HC62 486"; $resn_exch{"1H29 486"}="H291 486"; $resn_exch{"2H29 486"}="H292 486";
$resn_exch{"3H29 486"}="H293 486"; $resn_exch{"1H28 486"}="H281 486"; $resn_exch{"2H28 486"}="H282 486";
$resn_exch{"3H28 486"}="H283 486"; $resn_exch{"1H13 486"}="H131 486"; $resn_exch{"2H13 486"}="H132 486";
$resn_exch{"1H19 486"}="H191 486"; $resn_exch{"2H19 486"}="H192 486"; $resn_exch{"3H19 486"}="H193 486";
$resn_exch{"1H32 486"}="H321 486"; $resn_exch{"2H32 486"}="H322 486"; $resn_exch{"3H32 486"}="H323 486";
$resn_exch{"1H16 486"}="H161 486"; $resn_exch{"2H16 486"}="H162 486"; $resn_exch{"1H15 486"}="H151 486";
$resn_exch{"2H15 486"}="H152 486"; $resn_exch{"1HC8 486"}="HC81 486"; $resn_exch{"2HC8 486"}="HC82 486";
$resn_exch{"1H7  493"}=" H71 493"; $resn_exch{"2H7  493"}="H72A 493"; $resn_exch{"1H9  493"}=" H91 493";
$resn_exch{"2H9  493"}=" H92 493"; $resn_exch{"1H15 493"}="H151 493"; $resn_exch{"2H15 493"}="H152 493";
$resn_exch{"3H15 493"}="H153 493"; $resn_exch{"1H19 493"}="H191 493"; $resn_exch{"2H19 493"}="H192 493";
$resn_exch{"1H20 493"}="H201 493"; $resn_exch{"2H20 493"}="H202 493"; $resn_exch{"1H21 493"}="H211 493";
$resn_exch{"2H21 493"}="H212 493"; $resn_exch{"1H22 493"}="H221 493"; $resn_exch{"2H22 493"}="H222 493";
$resn_exch{"1H25 493"}="H251 493"; $resn_exch{"2H25 493"}="H252 493"; $resn_exch{"1H47 497"}="H471 497";
$resn_exch{"2H47 497"}="H472 497"; $resn_exch{"3H47 497"}="H473 497"; $resn_exch{"1H45 497"}="H451 497";
$resn_exch{"2H45 497"}="H452 497"; $resn_exch{"1H38 497"}="H381 497"; $resn_exch{"2H38 497"}="H382 497";
$resn_exch{"1H36 497"}="H361 497"; $resn_exch{"2H36 497"}="H362 497"; $resn_exch{"1H18 497"}="H181 497";
$resn_exch{"2H18 497"}="H182 497"; $resn_exch{"1H9  49A"}=" H91 49A"; $resn_exch{"2H9  49A"}=" H92 49A";
$resn_exch{"1H11 49A"}="H111 49A"; $resn_exch{"2H11 49A"}="H112 49A"; $resn_exch{"3H11 49A"}="H113 49A";
$resn_exch{"1HOB 49A"}="HOB1 49A"; $resn_exch{"1HN4 49A"}="HN41 49A"; $resn_exch{"2HN4 49A"}="HN42 49A";
$resn_exch{"1HN9 49A"}="HN91 49A"; $resn_exch{"2HN9 49A"}="HN92 49A"; $resn_exch{"1HN1 4A3"}="HN11 4A3";
$resn_exch{"2HN1 4A3"}="HN12 4A3"; $resn_exch{"1HAA 4AA"}="HAA1 4AA"; $resn_exch{"2HAA 4AA"}="HAA2 4AA";
$resn_exch{"2H2  4AB"}=" H22 4AB"; $resn_exch{"1H2  4AB"}=" H21 4AB"; $resn_exch{"1HH4 4AB"}="HH41 4AB";
$resn_exch{"2HH4 4AB"}="HH42 4AB"; $resn_exch{"1H7  4AB"}=" H71 4AB"; $resn_exch{"2H7  4AB"}=" H72 4AB";
$resn_exch{"1H9O 4AB"}="H9O1 4AB"; $resn_exch{"3H11 4AB"}="H113 4AB"; $resn_exch{"2H11 4AB"}="H112 4AB";
$resn_exch{"1H11 4AB"}="H111 4AB"; $resn_exch{"1H1O 4AB"}="H1O1 4AB"; $resn_exch{"3HOP 4AC"}="HOP3 4AC";
$resn_exch{"2HOP 4AC"}="HOP2 4AC"; $resn_exch{"1H5* 4AC"}=" H5' 4AC"; $resn_exch{"2H5* 4AC"}="H5'' 4AC";
$resn_exch{" H4* 4AC"}=" H4' 4AC"; $resn_exch{" H3* 4AC"}=" H3' 4AC"; $resn_exch{"H3T  4AC"}="HO3' 4AC";
$resn_exch{" H2* 4AC"}=" H2' 4AC"; $resn_exch{"2HO* 4AC"}="HO2' 4AC"; $resn_exch{" H1* 4AC"}=" H1' 4AC";
$resn_exch{"1HM7 4AC"}="HM71 4AC"; $resn_exch{"2HM7 4AC"}="HM72 4AC"; $resn_exch{"3HM7 4AC"}="HM73 4AC";
$resn_exch{"1HOP 4AD"}="HOP1 4AD"; $resn_exch{"1HN  4AD"}=" HN1 4AD"; $resn_exch{"2HN  4AD"}=" HN2 4AD";
$resn_exch{"3HN  4AD"}=" HN3 4AD"; $resn_exch{"1HB  4AD"}=" HB1 4AD"; $resn_exch{"2HB  4AD"}=" HB2 4AD";
$resn_exch{"1HD2 4AD"}="HD21 4AD"; $resn_exch{"2HD2 4AD"}="HD22 4AD"; $resn_exch{"1H5* 4AD"}="H5'1 4AD";
$resn_exch{"2H5* 4AD"}="H5'2 4AD"; $resn_exch{" H4* 4AD"}=" H4' 4AD"; $resn_exch{" H3* 4AD"}=" H3' 4AD";
$resn_exch{" H2* 4AD"}=" H2' 4AD"; $resn_exch{" H1* 4AD"}=" H1' 4AD"; $resn_exch{"1HN6 4AD"}="HN61 4AD";
$resn_exch{"2HN6 4AD"}="HN62 4AD"; $resn_exch{"1H11 4AF"}="H111 4AF"; $resn_exch{"2H11 4AF"}="H112 4AF";
$resn_exch{"3H11 4AF"}="H113 4AF"; $resn_exch{"1H3  4AF"}=" H31 4AF"; $resn_exch{"2H3  4AF"}=" H32 4AF";
$resn_exch{"1HN  4AF"}=" HN1 4AF"; $resn_exch{"2HN  4AF"}=" HN2 4AF"; $resn_exch{"1H12 4AH"}="H121 4AH";
$resn_exch{"2H12 4AH"}="H122 4AH"; $resn_exch{"1H24 4AH"}="H241 4AH"; $resn_exch{"2H24 4AH"}="H242 4AH";
$resn_exch{"1H41 4AH"}="H411 4AH"; $resn_exch{"2H41 4AH"}="H412 4AH"; $resn_exch{"1H44 4AH"}="H441 4AH";
$resn_exch{"2H44 4AH"}="H442 4AH"; $resn_exch{"1H49 4AH"}="H491 4AH"; $resn_exch{"2H49 4AH"}="H492 4AH";
$resn_exch{"3H49 4AH"}="H493 4AH"; $resn_exch{"1H50 4AH"}="H501 4AH"; $resn_exch{"2H50 4AH"}="H502 4AH";
$resn_exch{"3H50 4AH"}="H503 4AH"; $resn_exch{"1H91 4AH"}="H911 4AH"; $resn_exch{"2H91 4AH"}="H912 4AH";
$resn_exch{"3H91 4AH"}="H913 4AH"; $resn_exch{"1H92 4AH"}="H921 4AH"; $resn_exch{"2H92 4AH"}="H922 4AH";
$resn_exch{"3H92 4AH"}="H923 4AH"; $resn_exch{"1HOB 4AM"}="HOB1 4AM"; $resn_exch{"1HN4 4AM"}="HN41 4AM";
$resn_exch{"2HN4 4AM"}="HN42 4AM"; $resn_exch{" NH5 4AM"}=" H5N 4AM"; $resn_exch{"1H11 4AM"}="H111 4AM";
$resn_exch{"2H11 4AM"}="H112 4AM"; $resn_exch{"3H11 4AM"}="H113 4AM"; $resn_exch{" OH7 4AM"}=" H7O 4AM";
$resn_exch{" OH8 4AM"}=" H8O 4AM"; $resn_exch{"1H9  4AM"}=" H91 4AM"; $resn_exch{"2H9  4AM"}=" H92 4AM";
$resn_exch{"1HN4 4AN"}="HN41 4AN"; $resn_exch{"2HN4 4AN"}="HN42 4AN"; $resn_exch{"1HN4 4AP"}="HN41 4AP";
$resn_exch{"2HN4 4AP"}="HN42 4AP"; $resn_exch{"1HA  4AT"}=" HA1 4AT"; $resn_exch{"2HA  4AT"}=" HA2 4AT";
$resn_exch{"1HB  4AT"}=" HB1 4AT"; $resn_exch{"2HB  4AT"}=" HB2 4AT"; $resn_exch{"1HG  4AT"}=" HG1 4AT";
$resn_exch{"2HG  4AT"}=" HG2 4AT"; $resn_exch{"1H2A 4AT"}="H2A1 4AT"; $resn_exch{"2H2A 4AT"}="H2A2 4AT";
$resn_exch{"3H2A 4AT"}="H2A3 4AT"; $resn_exch{"1HB  4AX"}=" HB1 4AX"; $resn_exch{"2HB  4AX"}=" HB2 4AX";
$resn_exch{"1H21 4B3"}="H211 4B3"; $resn_exch{"2H21 4B3"}="H212 4B3"; $resn_exch{"1H30 4B3"}="H301 4B3";
$resn_exch{"2H30 4B3"}="H302 4B3"; $resn_exch{"1H32 4B3"}="H321 4B3"; $resn_exch{"2H32 4B3"}="H322 4B3";
$resn_exch{"1H34 4B3"}="H341 4B3"; $resn_exch{"2H34 4B3"}="H342 4B3"; $resn_exch{"1H42 4B3"}="H421 4B3";
$resn_exch{"2H42 4B3"}="H422 4B3"; $resn_exch{"3H42 4B3"}="H423 4B3"; $resn_exch{"1H46 4B3"}="H461 4B3";
$resn_exch{"2H46 4B3"}="H462 4B3"; $resn_exch{"3H46 4B3"}="H463 4B3"; $resn_exch{"1H50 4B3"}="H501 4B3";
$resn_exch{"2H50 4B3"}="H502 4B3"; $resn_exch{"3H50 4B3"}="H503 4B3"; $resn_exch{"1H54 4B3"}="H541 4B3";
$resn_exch{"2H54 4B3"}="H542 4B3"; $resn_exch{"3H54 4B3"}="H543 4B3"; $resn_exch{"1H19 4BC"}="H191 4BC";
$resn_exch{"2H19 4BC"}="H192 4BC"; $resn_exch{"1H26 4BC"}="H261 4BC"; $resn_exch{"2H26 4BC"}="H262 4BC";
$resn_exch{"1H27 4BC"}="H271 4BC"; $resn_exch{"2H27 4BC"}="H272 4BC"; $resn_exch{"3H27 4BC"}="H273 4BC";
$resn_exch{"1HCB 4BF"}=" HB3 4BF"; $resn_exch{"2HCB 4BF"}=" HB2 4BF"; $resn_exch{"1HN  4BF"}=" H   4BF";
$resn_exch{"2HN  4BF"}=" H2  4BF"; $resn_exch{"1H11 4BH"}="H111 4BH"; $resn_exch{"2H11 4BH"}="H112 4BH";
$resn_exch{"1H12 4BH"}="H121 4BH"; $resn_exch{"2H12 4BH"}="H122 4BH"; $resn_exch{"1H15 4BH"}="H151 4BH";
$resn_exch{"2H15 4BH"}="H152 4BH"; $resn_exch{"1H14 4BH"}="H141 4BH"; $resn_exch{"2H14 4BH"}="H142 4BH";
$resn_exch{"1HZ2 4BR"}="HZ21 4BR"; $resn_exch{"2HZ2 4BR"}="HZ22 4BR"; $resn_exch{"1HA2 4BR"}="HA21 4BR";
$resn_exch{"2HA2 4BR"}="HA22 4BR"; $resn_exch{"1HH2 4BR"}="HH21 4BR"; $resn_exch{"2HH2 4BR"}="HH22 4BR";
$resn_exch{"3HH2 4BR"}="HH23 4BR"; $resn_exch{"1HCA 4BT"}="HCA1 4BT"; $resn_exch{"2HCA 4BT"}="HCA2 4BT";
$resn_exch{"1HCB 4BT"}="HCB1 4BT"; $resn_exch{"2HCB 4BT"}="HCB2 4BT"; $resn_exch{"1H5  4BT"}=" H51 4BT";
$resn_exch{"1H6  4BT"}=" H61 4BT"; $resn_exch{"1H2  4BT"}=" H21 4BT"; $resn_exch{"1H3  4BT"}=" H31 4BT";
$resn_exch{"1HCD 4BT"}="HCD1 4BT"; $resn_exch{"2HCD 4BT"}="HCD2 4BT"; $resn_exch{"1HCC 4BT"}="HCC1 4BT";
$resn_exch{"2HCC 4BT"}="HCC2 4BT"; $resn_exch{"1H1' 4BT"}="H1'1 4BT"; $resn_exch{"2H1' 4BT"}="H1'2 4BT";
$resn_exch{"1HN1 4BT"}="HN11 4BT"; $resn_exch{"2HN1 4BT"}="HN12 4BT"; $resn_exch{"1HN2 4BT"}="HN21 4BT";
$resn_exch{"2HB  4BZ"}=" HB2 4BZ"; $resn_exch{"3HB  4BZ"}=" HB3 4BZ"; $resn_exch{"1HQ1 4BZ"}="HQ11 4BZ";
$resn_exch{"2HQ1 4BZ"}="HQ12 4BZ"; $resn_exch{"1HQ2 4BZ"}="HQ21 4BZ"; $resn_exch{" AH2 4CA"}=" H2A 4CA";
$resn_exch{"AH61 4CA"}="H61A 4CA"; $resn_exch{"AH62 4CA"}="H62A 4CA"; $resn_exch{" AH8 4CA"}=" H8A 4CA";
$resn_exch{"AH1* 4CA"}=" H1D 4CA"; $resn_exch{"AH2* 4CA"}=" H2D 4CA"; $resn_exch{"AHO2 4CA"}="HO2A 4CA";
$resn_exch{"AH3* 4CA"}=" H3D 4CA"; $resn_exch{"8HOA 4CA"}="HOA8 4CA"; $resn_exch{"9HOA 4CA"}="HOA9 4CA";
$resn_exch{"AH4* 4CA"}=" H4D 4CA"; $resn_exch{"AH51 4CA"}="H51A 4CA"; $resn_exch{"AH52 4CA"}="H52A 4CA";
$resn_exch{"2HOA 4CA"}="HOA2 4CA"; $resn_exch{"5HOA 4CA"}="HOA5 4CA"; $resn_exch{"1H12 4CA"}="H121 4CA";
$resn_exch{"2H12 4CA"}="H122 4CA"; $resn_exch{"1H13 4CA"}="H131 4CA"; $resn_exch{"2H13 4CA"}="H132 4CA";
$resn_exch{"3H13 4CA"}="H133 4CA"; $resn_exch{"1H14 4CA"}="H141 4CA"; $resn_exch{"2H14 4CA"}="H142 4CA";
$resn_exch{"3H14 4CA"}="H143 4CA"; $resn_exch{"1H7  4CA"}=" H71 4CA"; $resn_exch{"2H7  4CA"}=" H72 4CA";
$resn_exch{"1H6  4CA"}=" H61 4CA"; $resn_exch{"2H6  4CA"}=" H62 4CA"; $resn_exch{"1H3  4CA"}=" H31 4CA";
$resn_exch{"2H3  4CA"}=" H32 4CA"; $resn_exch{"1H2  4CA"}=" H21 4CA"; $resn_exch{"2H2  4CA"}=" H22 4CA";
$resn_exch{"1H1  4CA"}=" H11 4CA"; $resn_exch{"2H1  4CA"}=" H12 4CA"; $resn_exch{" BH3 4CA"}=" H3B 4CA";
$resn_exch{" BH4 4CA"}=" H4B 4CA"; $resn_exch{"BHO2 4CA"}="HO2B 4CA"; $resn_exch{" BH6 4CA"}=" H6B 4CA";
$resn_exch{" BH7 4CA"}=" H7B 4CA"; $resn_exch{"1HO1 4CB"}="HO11 4CB"; $resn_exch{"1HO2 4CB"}="HO21 4CB";
$resn_exch{"1HC2 4CB"}="HC21 4CB"; $resn_exch{"1HC3 4CB"}="HC31 4CB"; $resn_exch{"1HOX 4CB"}="HOX1 4CB";
$resn_exch{"1HC5 4CB"}="HC51 4CB"; $resn_exch{"1HC6 4CB"}="HC61 4CB"; $resn_exch{"1HN1 4CM"}="HN11 4CM";
$resn_exch{"2HN1 4CM"}="HN12 4CM"; $resn_exch{"1H8  4CM"}=" H81 4CM"; $resn_exch{"2H8  4CM"}=" H82 4CM";
$resn_exch{"3H8  4CM"}=" H83 4CM"; $resn_exch{" AH2 4CO"}=" H2A 4CO"; $resn_exch{"AH61 4CO"}="H61A 4CO";
$resn_exch{"AH62 4CO"}="H62A 4CO"; $resn_exch{" AH8 4CO"}=" H8A 4CO"; $resn_exch{"AH1* 4CO"}=" H1D 4CO";
$resn_exch{"AH2* 4CO"}=" H2D 4CO"; $resn_exch{"AHO2 4CO"}="HO2A 4CO"; $resn_exch{"AH3* 4CO"}=" H3D 4CO";
$resn_exch{"8HOA 4CO"}="HOA8 4CO"; $resn_exch{"9HOA 4CO"}="HOA9 4CO"; $resn_exch{"AH4* 4CO"}=" H4D 4CO";
$resn_exch{"AH51 4CO"}="H51A 4CO"; $resn_exch{"AH52 4CO"}="H52A 4CO"; $resn_exch{"2HOA 4CO"}="HOA2 4CO";
$resn_exch{"5HOA 4CO"}="HOA5 4CO"; $resn_exch{"1H12 4CO"}="H121 4CO"; $resn_exch{"2H12 4CO"}="H122 4CO";
$resn_exch{"1H13 4CO"}="H131 4CO"; $resn_exch{"2H13 4CO"}="H132 4CO"; $resn_exch{"3H13 4CO"}="H133 4CO";
$resn_exch{"1H14 4CO"}="H141 4CO"; $resn_exch{"2H14 4CO"}="H142 4CO"; $resn_exch{"3H14 4CO"}="H143 4CO";
$resn_exch{"1H7  4CO"}=" H71 4CO"; $resn_exch{"2H7  4CO"}=" H72 4CO"; $resn_exch{"1H6  4CO"}=" H61 4CO";
$resn_exch{"2H6  4CO"}=" H62 4CO"; $resn_exch{"1H3  4CO"}=" H31 4CO"; $resn_exch{"2H3  4CO"}=" H32 4CO";
$resn_exch{"1H2  4CO"}=" H21 4CO"; $resn_exch{"2H2  4CO"}=" H22 4CO"; $resn_exch{" BH3 4CO"}=" H3B 4CO";
$resn_exch{" BH4 4CO"}=" H4B 4CO"; $resn_exch{" BH2 4CO"}=" H2B 4CO"; $resn_exch{" BH6 4CO"}=" H6B 4CO";
$resn_exch{" BH7 4CO"}=" H7B 4CO"; $resn_exch{"1BH  4CO"}=" H1B 4CO"; $resn_exch{"2BH  4CO"}="H2BX 4CO";
$resn_exch{"1H9C 4CP"}="H9C1 4CP"; $resn_exch{"2H9C 4CP"}="H9C2 4CP"; $resn_exch{"1H14 4CP"}="H141 4CP";
$resn_exch{"2H14 4CP"}="H142 4CP"; $resn_exch{"1H24 4CP"}="H241 4CP"; $resn_exch{"2H24 4CP"}="H242 4CP";
$resn_exch{"1H27 4CP"}="H271 4CP"; $resn_exch{"2H27 4CP"}="H272 4CP"; $resn_exch{"1H4B 4CR"}="H4B1 4CR";
$resn_exch{"2H4B 4CR"}="H4B2 4CR"; $resn_exch{"1H4C 4CR"}="H4C1 4CR"; $resn_exch{"2H4C 4CR"}="H4C2 4CR";
$resn_exch{"3H4C 4CR"}="H4C3 4CR"; $resn_exch{"1HN4 4CR"}="HN41 4CR"; $resn_exch{"2HN4 4CR"}="HN42 4CR";
$resn_exch{"3HN4 4CR"}="HN43 4CR"; $resn_exch{"1H2C 4CR"}="H2C1 4CR"; $resn_exch{"2H2C 4CR"}="H2C2 4CR";
$resn_exch{"1H1C 4CR"}="H1C1 4CR"; $resn_exch{"2H1C 4CR"}="H1C2 4CR"; $resn_exch{"1H10 4CR"}="H101 4CR";
$resn_exch{"2H10 4CR"}="H102 4CR"; $resn_exch{"3H10 4CR"}="H103 4CR"; $resn_exch{"1H13 4CR"}="H131 4CR";
$resn_exch{"2H13 4CR"}="H132 4CR"; $resn_exch{"1HB  4CS"}=" HB1 4CS"; $resn_exch{"2HB  4CS"}=" HB2 4CS";
$resn_exch{"1HAD 4CS"}="HAD1 4CS"; $resn_exch{"2HAD 4CS"}="HAD2 4CS"; $resn_exch{"1HAA 4CS"}="HAA1 4CS";
$resn_exch{"2HAA 4CS"}="HAA2 4CS"; $resn_exch{"3HAA 4CS"}="HAA3 4CS"; $resn_exch{"1H5  4DE"}=" H51 4DE";
$resn_exch{"2H5  4DE"}=" H52 4DE"; $resn_exch{"1H6  4DE"}=" H61 4DE"; $resn_exch{"2H6  4DE"}=" H62 4DE";
$resn_exch{"3H6  4DE"}=" H63 4DE"; $resn_exch{"1H8  4DE"}=" H81 4DE"; $resn_exch{"2H8  4DE"}=" H82 4DE";
$resn_exch{"3H8  4DE"}=" H83 4DE"; $resn_exch{"1H13 4DE"}="H131 4DE"; $resn_exch{"2H13 4DE"}="H132 4DE";
$resn_exch{"3H13 4DE"}="H133 4DE"; $resn_exch{"1H18 4DE"}="H181 4DE"; $resn_exch{"2H18 4DE"}="H182 4DE";
$resn_exch{"3H18 4DE"}="H183 4DE"; $resn_exch{"1H2  4DI"}=" H21 4DI"; $resn_exch{"2H2  4DI"}=" H22 4DI";
$resn_exch{"1H3  4DI"}=" H31 4DI"; $resn_exch{"2H3  4DI"}=" H32 4DI"; $resn_exch{"1H4  4DI"}=" H41 4DI";
$resn_exch{"2H4  4DI"}=" H42 4DI"; $resn_exch{"1H5  4DI"}=" H51 4DI"; $resn_exch{"2H5  4DI"}=" H52 4DI";
$resn_exch{"1H6  4DI"}=" H61 4DI"; $resn_exch{"2H6  4DI"}=" H62 4DI"; $resn_exch{"3H6  4DI"}=" H63 4DI";
$resn_exch{"1H7  4DI"}=" H71 4DI"; $resn_exch{"2H7  4DI"}=" H72 4DI"; $resn_exch{"3H7  4DI"}=" H73 4DI";
$resn_exch{"1HN2 4DI"}="HN21 4DI"; $resn_exch{"2HN2 4DI"}="HN22 4DI"; $resn_exch{"1HAD 4DP"}="HAD1 4DP";
$resn_exch{"2HAD 4DP"}="HAD2 4DP"; $resn_exch{"3HAD 4DP"}="HAD3 4DP"; $resn_exch{"1HAC 4DP"}="HAC1 4DP";
$resn_exch{"2HAC 4DP"}="HAC2 4DP"; $resn_exch{"3HAC 4DP"}="HAC3 4DP"; $resn_exch{"1HB  4DP"}=" HB3 4DP";
$resn_exch{"2HB  4DP"}=" HB2 4DP"; $resn_exch{"1HN  4DP"}=" H   4DP"; $resn_exch{"2HN  4DP"}=" H2  4DP";
$resn_exch{"HOXT 4DP"}=" HXT 4DP"; $resn_exch{"1H24 4EA"}="H241 4EA"; $resn_exch{"2H24 4EA"}="H242 4EA";
$resn_exch{"1H25 4EA"}="H251 4EA"; $resn_exch{"2H25 4EA"}="H252 4EA"; $resn_exch{"1HN4 4EA"}="HN41 4EA";
$resn_exch{"2HN4 4EA"}="HN42 4EA"; $resn_exch{"0H1  4EB"}=" H10 4EB"; $resn_exch{"1H1  4EB"}=" H11 4EB";
$resn_exch{"2H1  4EB"}=" H12 4EB"; $resn_exch{"3H1  4EB"}=" H13 4EB"; $resn_exch{"1H11 4F3"}="H111 4F3";
$resn_exch{"2H11 4F3"}="H112 4F3"; $resn_exch{"1H18 4F3"}="H181 4F3"; $resn_exch{"2H18 4F3"}="H182 4F3";
$resn_exch{"2HO4 4F3"}="HO42 4F3"; $resn_exch{"1H25 4F3"}="H251 4F3"; $resn_exch{"2H25 4F3"}="H252 4F3";
$resn_exch{"3H25 4F3"}="H253 4F3"; $resn_exch{"1HC4 4FA"}="HC41 4FA"; $resn_exch{"2HC4 4FA"}="HC42 4FA";
$resn_exch{"1H13 4FA"}="H131 4FA"; $resn_exch{"2H13 4FA"}="H132 4FA"; $resn_exch{"1HBX 4FB"}="HBX1 4FB";
$resn_exch{"2HBX 4FB"}="HBX2 4FB"; $resn_exch{"1HDX 4FB"}="HDX1 4FB"; $resn_exch{"2HDX 4FB"}="HDX2 4FB";
$resn_exch{"1H6  4FP"}=" H61 4FP"; $resn_exch{"2H6  4FP"}=" H62 4FP"; $resn_exch{"1H8  4FP"}=" H81 4FP";
$resn_exch{"2H8  4FP"}=" H82 4FP"; $resn_exch{"1H9  4FP"}=" H91 4FP"; $resn_exch{"2H9  4FP"}=" H92 4FP";
$resn_exch{"1H11 4FP"}="H111 4FP"; $resn_exch{"2H11 4FP"}="H112 4FP"; $resn_exch{"1H12 4FP"}="H121 4FP";
$resn_exch{"2H12 4FP"}="H122 4FP"; $resn_exch{"1HN  4FW"}=" H   4FW"; $resn_exch{"2HN  4FW"}=" H2  4FW";
$resn_exch{"1HB  4FW"}=" HB2 4FW"; $resn_exch{"2HB  4FW"}=" HB3 4FW"; $resn_exch{" HNE 4FW"}=" HE1 4FW";
$resn_exch{"1H6  4GP"}=" H61 4GP"; $resn_exch{"2H6  4GP"}=" H62 4GP"; $resn_exch{"2HB  4HA"}=" HB2 4HA";
$resn_exch{"3HB  4HA"}=" HB3 4HA"; $resn_exch{"2HG  4HA"}=" HG2 4HA"; $resn_exch{"3HG  4HA"}=" HG3 4HA";
$resn_exch{"2HD  4HA"}=" HD2 4HA"; $resn_exch{"3HD  4HA"}=" HD3 4HA"; $resn_exch{"2HE  4HA"}=" HE2 4HA";
$resn_exch{"3HE  4HA"}=" HE3 4HA"; $resn_exch{"1HZ  4HA"}=" HZ1 4HA"; $resn_exch{"2HZ  4HA"}=" HZ2 4HA";
$resn_exch{"3HZ  4HA"}=" HZ3 4HA"; $resn_exch{"1H5  4HF"}=" H51 4HF"; $resn_exch{"2H5  4HF"}=" H52 4HF";
$resn_exch{"1HN2 4HF"}="HN21 4HF"; $resn_exch{"2HN2 4HF"}="HN22 4HF"; $resn_exch{"1H7  4HF"}=" H71 4HF";
$resn_exch{"2H7  4HF"}=" H72 4HF"; $resn_exch{"1H9  4HF"}=" H91 4HF"; $resn_exch{"2H9  4HF"}=" H92 4HF";
$resn_exch{"1H10 4HF"}="H101 4HF"; $resn_exch{"2H10 4HF"}="H102 4HF"; $resn_exch{"1HB  4HF"}=" HB1 4HF";
$resn_exch{"2HB  4HF"}=" HB2 4HF"; $resn_exch{"1HG  4HF"}=" HG1 4HF"; $resn_exch{"2HG  4HF"}=" HG2 4HF";
$resn_exch{"1H11 4HG"}="H111 4HG"; $resn_exch{"2H11 4HG"}="H112 4HG"; $resn_exch{"1H1  4HL"}=" H11 4HL";
$resn_exch{"2H1  4HL"}=" H12 4HL"; $resn_exch{"1HX2 4HL"}="HX21 4HL"; $resn_exch{"2HX2 4HL"}="HX22 4HL";
$resn_exch{"1H7  4HP"}=" H71 4HP"; $resn_exch{"2H7  4HP"}=" H72 4HP"; $resn_exch{"1HN  4HT"}=" H   4HT";
$resn_exch{"2HN  4HT"}=" H2  4HT"; $resn_exch{"1HB  4HT"}=" HB2 4HT"; $resn_exch{"2HB  4HT"}=" HB3 4HT";
$resn_exch{"1HN  4HX"}=" HN1 4HX"; $resn_exch{"2HN  4HX"}=" HN2 4HX"; $resn_exch{"1HB  4HX"}=" HB1 4HX";
$resn_exch{"2HB  4HX"}=" HB2 4HX"; $resn_exch{"1HG  4HX"}=" HG1 4HX"; $resn_exch{"2HG  4HX"}=" HG2 4HX";
$resn_exch{"1HD  4HX"}=" HD1 4HX"; $resn_exch{"2HD  4HX"}=" HD2 4HX"; $resn_exch{"1H1' 4HX"}="H1'1 4HX";
$resn_exch{"2H1' 4HX"}="H1'2 4HX"; $resn_exch{"1HB' 4HX"}="HB'1 4HX"; $resn_exch{"2HB' 4HX"}="HB'2 4HX";
$resn_exch{"1HD' 4HX"}="HD'1 4HX"; $resn_exch{"2HD' 4HX"}="HD'2 4HX"; $resn_exch{"1HC3 4HY"}="HC31 4HY";
$resn_exch{"1HC4 4HY"}="HC41 4HY"; $resn_exch{"1H10 4HY"}="H101 4HY"; $resn_exch{"1H11 4HY"}="H111 4HY";
$resn_exch{"1H12 4HY"}="H121 4HY"; $resn_exch{"1H13 4HY"}="H131 4HY"; $resn_exch{"2H13 4HY"}="H132 4HY";
$resn_exch{"1HO1 4HY"}="HO11 4HY"; $resn_exch{"1HO4 4HY"}="HO41 4HY"; $resn_exch{"1HN3 4IG"}="HN31 4IG";
$resn_exch{"2HN3 4IG"}="HN32 4IG"; $resn_exch{"1HN4 4IG"}="HN41 4IG"; $resn_exch{"2HN4 4IG"}="HN42 4IG";
$resn_exch{"1H5  4IG"}=" H51 4IG"; $resn_exch{"2H5  4IG"}=" H52 4IG"; $resn_exch{"1H6  4IG"}=" H61 4IG";
$resn_exch{"2H6  4IG"}=" H62 4IG"; $resn_exch{"3H6  4IG"}=" H63 4IG"; $resn_exch{"1H16 4IG"}="H161 4IG";
$resn_exch{"2H16 4IG"}="H162 4IG"; $resn_exch{"1H17 4IG"}="H171 4IG"; $resn_exch{"2H17 4IG"}="H172 4IG";
$resn_exch{"1H18 4IG"}="H181 4IG"; $resn_exch{"2H18 4IG"}="H182 4IG"; $resn_exch{"1H19 4IG"}="H191 4IG";
$resn_exch{"2H19 4IG"}="H192 4IG"; $resn_exch{"3H19 4IG"}="H193 4IG"; $resn_exch{"1HN  4IN"}=" H   4IN";
$resn_exch{"2HN  4IN"}=" H2  4IN"; $resn_exch{"1HB  4IN"}=" HB2 4IN"; $resn_exch{"2HB  4IN"}=" HB3 4IN";
$resn_exch{"1H16 4IN"}="H161 4IN"; $resn_exch{"2H16 4IN"}="H162 4IN"; $resn_exch{"PHO2 4IP"}="HO2P 4IP";
$resn_exch{"PHO3 4IP"}="HO3P 4IP"; $resn_exch{"PHO5 4IP"}="HO5P 4IP"; $resn_exch{"PHO6 4IP"}="HO6P 4IP";
$resn_exch{"PHO7 4IP"}="HO7P 4IP"; $resn_exch{"PHO8 4IP"}="HO8P 4IP"; $resn_exch{"1HOP 4IP"}="HOP1 4IP";
$resn_exch{"3HOP 4IP"}="HOP3 4IP"; $resn_exch{"1H1  4LG"}=" H11 4LG"; $resn_exch{"2H1  4LG"}=" H12 4LG";
$resn_exch{"3H1  4LG"}="H13A 4LG"; $resn_exch{"1H4  4LG"}=" H41 4LG"; $resn_exch{"2H4  4LG"}=" H42 4LG";
$resn_exch{"1H17 4LG"}="H171 4LG"; $resn_exch{"2H17 4LG"}="H172 4LG"; $resn_exch{"1H19 4LG"}="H191 4LG";
$resn_exch{"2H19 4LG"}="H192 4LG"; $resn_exch{"3H19 4LG"}="H193 4LG"; $resn_exch{"1H21 4LG"}="H211 4LG";
$resn_exch{"2H21 4LG"}="H212 4LG"; $resn_exch{"1H22 4LG"}="H221 4LG"; $resn_exch{"2H22 4LG"}="H222 4LG";
$resn_exch{"1H24 4LG"}="H241 4LG"; $resn_exch{"2H24 4LG"}="H242 4LG"; $resn_exch{"1H31 4LG"}="H311 4LG";
$resn_exch{"2H31 4LG"}="H312 4LG"; $resn_exch{"1H32 4LG"}="H321 4LG"; $resn_exch{"2H32 4LG"}="H322 4LG";
$resn_exch{"1H33 4LG"}="H331 4LG"; $resn_exch{"2H33 4LG"}="H332 4LG"; $resn_exch{"1H8  4MA"}=" H81 4MA";
$resn_exch{"2H8  4MA"}=" H82 4MA"; $resn_exch{"3H8  4MA"}=" H83 4MA"; $resn_exch{"1H12 4MB"}="H121 4MB";
$resn_exch{"2H12 4MB"}="H122 4MB"; $resn_exch{"3H12 4MB"}="H123 4MB"; $resn_exch{"1H33 4MC"}="H331 4MC";
$resn_exch{"2H33 4MC"}="H332 4MC"; $resn_exch{"3H33 4MC"}="H333 4MC"; $resn_exch{"1H49 4MC"}="H491 4MC";
$resn_exch{"2H49 4MC"}="H492 4MC"; $resn_exch{"1H48 4MC"}="H481 4MC"; $resn_exch{"2H48 4MC"}="H482 4MC";
$resn_exch{"1H39 4MC"}="H391 4MC"; $resn_exch{"2H39 4MC"}="H392 4MC"; $resn_exch{"1H40 4MC"}="H401 4MC";
$resn_exch{"2H40 4MC"}="H402 4MC"; $resn_exch{"1H10 4MC"}="H101 4MC"; $resn_exch{"2H10 4MC"}="H102 4MC";
$resn_exch{"1H11 4MC"}="H111 4MC"; $resn_exch{"2H11 4MC"}="H112 4MC"; $resn_exch{"1H01 4MC"}="H011 4MC";
$resn_exch{"2H01 4MC"}="H012 4MC"; $resn_exch{"1H02 4MC"}="H021 4MC"; $resn_exch{"2H02 4MC"}="H022 4MC";
$resn_exch{"1H19 4MC"}="H191 4MC"; $resn_exch{"2H19 4MC"}="H192 4MC"; $resn_exch{"1H20 4MC"}="H201 4MC";
$resn_exch{"2H20 4MC"}="H202 4MC"; $resn_exch{"3HOP 4MF"}="HOP3 4MF"; $resn_exch{"2HOP 4MF"}="HOP2 4MF";
$resn_exch{"1H5* 4MF"}="H5'1 4MF"; $resn_exch{"2H5* 4MF"}="H5'2 4MF"; $resn_exch{" H4* 4MF"}=" H4' 4MF";
$resn_exch{" H3* 4MF"}=" H3' 4MF"; $resn_exch{"1H2* 4MF"}="H2'1 4MF"; $resn_exch{"2H2* 4MF"}="H2'2 4MF";
$resn_exch{" H1* 4MF"}=" H1' 4MF"; $resn_exch{"1H4M 4MF"}="H4M1 4MF"; $resn_exch{"2H4M 4MF"}="H4M2 4MF";
$resn_exch{"3H4M 4MF"}="H4M3 4MF"; $resn_exch{"1H2  4MP"}=" H21 4MP"; $resn_exch{"2H2  4MP"}=" H22 4MP";
$resn_exch{"1H3  4MP"}=" H31 4MP"; $resn_exch{"2H3  4MP"}=" H32 4MP"; $resn_exch{"1H4  4MP"}=" H41 4MP";
$resn_exch{"2H4  4MP"}=" H42 4MP"; $resn_exch{"1H12 4MP"}="H121 4MP"; $resn_exch{"2H12 4MP"}="H122 4MP";
$resn_exch{"3H12 4MP"}="H123 4MP"; $resn_exch{"1HAR 4MR"}="HAR1 4MR"; $resn_exch{"2HAR 4MR"}="HAR2 4MR";
$resn_exch{"1HAQ 4MR"}="HAQ1 4MR"; $resn_exch{"2HAQ 4MR"}="HAQ2 4MR"; $resn_exch{"1HBC 4MR"}="HBC1 4MR";
$resn_exch{"2HBC 4MR"}="HBC2 4MR"; $resn_exch{"1HBB 4MR"}="HBB1 4MR"; $resn_exch{"2HBB 4MR"}="HBB2 4MR";
$resn_exch{"1HA  4MV"}=" HA1 4MV"; $resn_exch{"2HA  4MV"}=" HA2 4MV"; $resn_exch{"1HB  4MV"}=" HB1 4MV";
$resn_exch{"2HB  4MV"}=" HB2 4MV"; $resn_exch{"1HD1 4MV"}="HD11 4MV"; $resn_exch{"2HD1 4MV"}="HD12 4MV";
$resn_exch{"3HD1 4MV"}="HD13 4MV"; $resn_exch{"1HD2 4MV"}="HD21 4MV"; $resn_exch{"2HD2 4MV"}="HD22 4MV";
$resn_exch{"3HD2 4MV"}="HD23 4MV"; $resn_exch{"1H4  4MZ"}=" H41 4MZ"; $resn_exch{"2H4  4MZ"}=" H42 4MZ";
$resn_exch{"3H4  4MZ"}=" H43 4MZ"; $resn_exch{"1HC4 4ND"}="HC41 4ND"; $resn_exch{"1HC5 4ND"}="HC51 4ND";
$resn_exch{"1HC6 4ND"}="HC61 4ND"; $resn_exch{"1HC7 4ND"}="HC71 4ND"; $resn_exch{"1HC8 4ND"}="HC81 4ND";
$resn_exch{"1H10 4ND"}="H101 4ND"; $resn_exch{"1H11 4ND"}="H111 4ND"; $resn_exch{"1H12 4ND"}="H121 4ND";
$resn_exch{"1H13 4ND"}="H131 4ND"; $resn_exch{"1H14 4ND"}="H141 4ND"; $resn_exch{"1HN4 4ND"}="HN41 4ND";
$resn_exch{"1HN3 4ND"}="HN31 4ND"; $resn_exch{"1HN2 4ND"}="HN21 4ND"; $resn_exch{"2HN2 4ND"}="HN22 4ND";
$resn_exch{"1HN1 4ND"}="HN11 4ND"; $resn_exch{"1H1  4NH"}="H11A 4NH"; $resn_exch{"2H1  4NH"}=" H12 4NH";
$resn_exch{"3H1  4NH"}=" H13 4NH"; $resn_exch{"1H4  4NH"}=" H41 4NH"; $resn_exch{"2H4  4NH"}=" H42 4NH";
$resn_exch{"1H5  4NH"}=" H51 4NH"; $resn_exch{"2H5  4NH"}=" H52 4NH"; $resn_exch{"1H12 4NH"}="H121 4NH";
$resn_exch{"2H12 4NH"}="H122 4NH"; $resn_exch{"1H15 4NH"}="H151 4NH"; $resn_exch{"2H15 4NH"}="H152 4NH";
$resn_exch{"1HN2 4NH"}="HN21 4NH"; $resn_exch{"2HN2 4NH"}="HN22 4NH"; $resn_exch{"1H17 4NH"}="H171 4NH";
$resn_exch{"2H17 4NH"}="H172 4NH"; $resn_exch{"3H17 4NH"}="H173 4NH"; $resn_exch{"1H2  4NI"}=" H21 4NI";
$resn_exch{"2H2  4NI"}=" H22 4NI"; $resn_exch{"1H3  4NI"}=" H31 4NI"; $resn_exch{"2H3  4NI"}=" H32 4NI";
$resn_exch{"1H4  4NI"}=" H41 4NI"; $resn_exch{"2H4  4NI"}=" H42 4NI"; $resn_exch{"1H2  4NP"}=" H21 4NP";
$resn_exch{"1H3  4NP"}=" H31 4NP"; $resn_exch{"1H5  4NP"}=" H51 4NP"; $resn_exch{"1H6  4NP"}=" H61 4NP";
$resn_exch{"1HM4 4OC"}="HM41 4OC"; $resn_exch{"2HM4 4OC"}="HM42 4OC"; $resn_exch{"3HM4 4OC"}="HM43 4OC";
$resn_exch{" H1* 4OC"}=" H1' 4OC"; $resn_exch{" H4* 4OC"}=" H4' 4OC"; $resn_exch{"1H5* 4OC"}=" H5' 4OC";
$resn_exch{"2H5* 4OC"}="H5'' 4OC"; $resn_exch{"3HOP 4OC"}="HOP3 4OC"; $resn_exch{" H3* 4OC"}=" H3' 4OC";
$resn_exch{"H3T  4OC"}="HO3' 4OC"; $resn_exch{" H2* 4OC"}=" H2' 4OC"; $resn_exch{"1HM2 4OC"}="HM21 4OC";
$resn_exch{"2HM2 4OC"}="HM22 4OC"; $resn_exch{"3HM2 4OC"}="HM23 4OC"; $resn_exch{"2HOP 4OC"}="HOP2 4OC";
$resn_exch{"1HC7 4OX"}="HC71 4OX"; $resn_exch{"2HC7 4OX"}="HC72 4OX"; $resn_exch{"1HC8 4OX"}="HC81 4OX";
$resn_exch{"2HC8 4OX"}="HC82 4OX"; $resn_exch{"1HC9 4OX"}="HC91 4OX"; $resn_exch{"2HC9 4OX"}="HC92 4OX";
$resn_exch{"1HC2 4OX"}="HC21 4OX"; $resn_exch{"2HC2 4OX"}="HC22 4OX"; $resn_exch{"1HC3 4OX"}="HC31 4OX";
$resn_exch{"2HC3 4OX"}="HC32 4OX"; $resn_exch{"1HC5 4OX"}="HC51 4OX"; $resn_exch{"2HC5 4OX"}="HC52 4OX";
$resn_exch{"1HC6 4OX"}="HC61 4OX"; $resn_exch{"2HC6 4OX"}="HC62 4OX"; $resn_exch{"1HAC 4PA"}="HAC1 4PA";
$resn_exch{"2HAC 4PA"}="HAC2 4PA"; $resn_exch{"3HAC 4PA"}="HAC3 4PA"; $resn_exch{"1HAF 4PA"}="HAF1 4PA";
$resn_exch{"2HAF 4PA"}="HAF2 4PA"; $resn_exch{"1HAE 4PA"}="HAE1 4PA"; $resn_exch{"2HAE 4PA"}="HAE2 4PA";
$resn_exch{"1HAA 4PA"}="HAA1 4PA"; $resn_exch{"2HAA 4PA"}="HAA2 4PA"; $resn_exch{"3HAA 4PA"}="HAA3 4PA";
$resn_exch{"1H2  4PB"}=" H21 4PB"; $resn_exch{"2H2  4PB"}=" H22 4PB"; $resn_exch{"1H3  4PB"}=" H31 4PB";
$resn_exch{"2H3  4PB"}=" H32 4PB"; $resn_exch{"1H4  4PB"}=" H41 4PB"; $resn_exch{"2H4  4PB"}=" H42 4PB";
$resn_exch{"2HOP 4PC"}="HOP2 4PC"; $resn_exch{"1H5* 4PC"}=" H5' 4PC"; $resn_exch{"2H5* 4PC"}="H5'' 4PC";
$resn_exch{" H4* 4PC"}=" H4' 4PC"; $resn_exch{" H3* 4PC"}=" H3' 4PC"; $resn_exch{"H3T  4PC"}="HO3' 4PC";
$resn_exch{"1H2* 4PC"}=" H2' 4PC"; $resn_exch{"2H2* 4PC"}="H2'' 4PC"; $resn_exch{" H1* 4PC"}=" H1' 4PC";
$resn_exch{"1H16 4PC"}="H161 4PC"; $resn_exch{"2H16 4PC"}="H162 4PC"; $resn_exch{"3H16 4PC"}="H163 4PC";
$resn_exch{"3HOP 4PC"}="HOP3 4PC"; $resn_exch{"2HOP 4PD"}="HOP2 4PD"; $resn_exch{"1H5* 4PD"}=" H5' 4PD";
$resn_exch{"2H5* 4PD"}="H5'' 4PD"; $resn_exch{" H4* 4PD"}=" H4' 4PD"; $resn_exch{" H3* 4PD"}=" H3' 4PD";
$resn_exch{"H3T  4PD"}="HO3' 4PD"; $resn_exch{"1H2* 4PD"}=" H2' 4PD"; $resn_exch{"2H2* 4PD"}="H2'' 4PD";
$resn_exch{" H1* 4PD"}=" H1' 4PD"; $resn_exch{"1H16 4PD"}="H161 4PD"; $resn_exch{"2H16 4PD"}="H162 4PD";
$resn_exch{"3H16 4PD"}="H163 4PD"; $resn_exch{"3HOP 4PD"}="HOP3 4PD"; $resn_exch{"2HOP 4PE"}="HOP2 4PE";
$resn_exch{"1H5* 4PE"}=" H5' 4PE"; $resn_exch{"2H5* 4PE"}="H5'' 4PE"; $resn_exch{" H4* 4PE"}=" H4' 4PE";
$resn_exch{" H3* 4PE"}=" H3' 4PE"; $resn_exch{"H3T  4PE"}="HO3' 4PE"; $resn_exch{"1H2* 4PE"}=" H2' 4PE";
$resn_exch{"2H2* 4PE"}="H2'' 4PE"; $resn_exch{" H1* 4PE"}=" H1' 4PE"; $resn_exch{"1H16 4PE"}="H161 4PE";
$resn_exch{"2H16 4PE"}="H162 4PE"; $resn_exch{"3H16 4PE"}="H163 4PE"; $resn_exch{"3HOP 4PE"}="HOP3 4PE";
$resn_exch{"1H8  4PG"}=" H81 4PG"; $resn_exch{"2H8  4PG"}=" H82 4PG"; $resn_exch{"1HN2 4PG"}="HN21 4PG";
$resn_exch{"2HN2 4PG"}="HN22 4PG"; $resn_exch{"1H7  4PI"}=" H71 4PI"; $resn_exch{"2H7  4PI"}=" H72 4PI";
$resn_exch{"1H8  4PI"}=" H81 4PI"; $resn_exch{"2H8  4PI"}=" H82 4PI"; $resn_exch{"1H10 4PI"}="H101 4PI";
$resn_exch{"2H10 4PI"}="H102 4PI"; $resn_exch{"1H11 4PI"}="H111 4PI"; $resn_exch{"2H11 4PI"}="H112 4PI";
$resn_exch{"1H27 4PI"}="H271 4PI"; $resn_exch{"2H27 4PI"}="H272 4PI"; $resn_exch{"3H27 4PI"}="H273 4PI";
$resn_exch{"1H37 4PI"}="H371 4PI"; $resn_exch{"2H37 4PI"}="H372 4PI"; $resn_exch{"1H8  4PN"}=" H81 4PN";
$resn_exch{"2H8  4PN"}=" H82 4PN"; $resn_exch{"1H9  4PN"}=" H91 4PN"; $resn_exch{"2H9  4PN"}=" H92 4PN";
$resn_exch{"1H10 4PN"}="H101 4PN"; $resn_exch{"2H10 4PN"}="H102 4PN"; $resn_exch{"1H11 4PN"}="H111 4PN";
$resn_exch{"2H11 4PN"}="H112 4PN"; $resn_exch{"1H12 4PN"}="H121 4PN"; $resn_exch{"2H12 4PN"}="H122 4PN";
$resn_exch{"1H5  4PN"}=" H51 4PN"; $resn_exch{"2H5  4PN"}=" H52 4PN"; $resn_exch{"1H6  4PN"}=" H61 4PN";
$resn_exch{"2H6  4PN"}=" H62 4PN"; $resn_exch{"1H2  4PN"}=" H21 4PN"; $resn_exch{"2H2  4PN"}=" H22 4PN";
$resn_exch{"1H3  4PN"}=" H31 4PN"; $resn_exch{"2H3  4PN"}=" H32 4PN"; $resn_exch{"1H2  4PP"}=" H21 4PP";
$resn_exch{"2H2  4PP"}=" H22 4PP"; $resn_exch{"1H3  4PP"}=" H31 4PP"; $resn_exch{"2H3  4PP"}=" H32 4PP";
$resn_exch{"1H4  4PP"}=" H41 4PP"; $resn_exch{"2H4  4PP"}=" H42 4PP"; $resn_exch{"1HN2 4PP"}="HN21 4PP";
$resn_exch{"2HN2 4PP"}="HN22 4PP"; $resn_exch{"1H1  4PR"}=" H11 4PR"; $resn_exch{"2H1  4PR"}=" H12 4PR";
$resn_exch{"3H1  4PR"}=" H13 4PR"; $resn_exch{"1H2  4PR"}="H21A 4PR"; $resn_exch{"2H2  4PR"}=" H22 4PR";
$resn_exch{"1H3  4PR"}=" H31 4PR"; $resn_exch{"2H3  4PR"}=" H32 4PR"; $resn_exch{"1H4  4PR"}=" H41 4PR";
$resn_exch{"2H4  4PR"}=" H42 4PR"; $resn_exch{"1H8  4PR"}=" H81 4PR"; $resn_exch{"2H8  4PR"}=" H82 4PR";
$resn_exch{"1H9  4PR"}=" H91 4PR"; $resn_exch{"2H9  4PR"}=" H92 4PR"; $resn_exch{"1H11 4PR"}="H111 4PR";
$resn_exch{"2H11 4PR"}="H112 4PR"; $resn_exch{"3H11 4PR"}="H113 4PR"; $resn_exch{"1H12 4PR"}="H121 4PR";
$resn_exch{"2H12 4PR"}="H122 4PR"; $resn_exch{"3H12 4PR"}="H123 4PR"; $resn_exch{"1H16 4PR"}="H161 4PR";
$resn_exch{"2H16 4PR"}="H162 4PR"; $resn_exch{"3H16 4PR"}="H163 4PR"; $resn_exch{"1H18 4PR"}="H181 4PR";
$resn_exch{"2H18 4PR"}="H182 4PR"; $resn_exch{"3H18 4PR"}="H183 4PR"; $resn_exch{"1H22 4PR"}="H221 4PR";
$resn_exch{"2H22 4PR"}="H222 4PR"; $resn_exch{"3H22 4PR"}="H223 4PR"; $resn_exch{"1H0E 4PT"}="H0E1 4PT";
$resn_exch{"2H0E 4PT"}="H0E2 4PT"; $resn_exch{"1H0B 4PT"}="H0B1 4PT"; $resn_exch{"2H0B 4PT"}="H0B2 4PT";
$resn_exch{"1H0N 4PT"}="H0N1 4PT"; $resn_exch{"2H0N 4PT"}="H0N2 4PT"; $resn_exch{"1H0P 4PT"}="H0P1 4PT";
$resn_exch{"2H0P 4PT"}="H0P2 4PT"; $resn_exch{"1H0Q 4PT"}="H0Q1 4PT"; $resn_exch{"2H0Q 4PT"}="H0Q2 4PT";
$resn_exch{"3H0Q 4PT"}="H0Q3 4PT"; $resn_exch{"1H0I 4PT"}="H0I1 4PT"; $resn_exch{"2H0I 4PT"}="H0I2 4PT";
$resn_exch{"1H0J 4PT"}="H0J1 4PT"; $resn_exch{"2H0J 4PT"}="H0J2 4PT"; $resn_exch{"1H0K 4PT"}="H0K1 4PT";
$resn_exch{"2H0K 4PT"}="H0K2 4PT"; $resn_exch{"3H0K 4PT"}="H0K3 4PT"; $resn_exch{"1H6  4PY"}=" H61 4PY";
$resn_exch{"2H6  4PY"}=" H62 4PY"; $resn_exch{"1H11 4PY"}="H111 4PY"; $resn_exch{"2H11 4PY"}="H112 4PY";
$resn_exch{"1H12 4PY"}="H121 4PY"; $resn_exch{"2H12 4PY"}="H122 4PY"; $resn_exch{"1H13 4PY"}="H131 4PY";
$resn_exch{"2H13 4PY"}="H132 4PY"; $resn_exch{"1H25 4PY"}="H251 4PY"; $resn_exch{"2H25 4PY"}="H252 4PY";
$resn_exch{"1H7  4QB"}=" H71 4QB"; $resn_exch{"2H7  4QB"}=" H72 4QB"; $resn_exch{"1H9  4QB"}=" H91 4QB";
$resn_exch{"2H9  4QB"}=" H92 4QB"; $resn_exch{"1H31 4QB"}="H311 4QB"; $resn_exch{"2H31 4QB"}="H312 4QB";
$resn_exch{"3H31 4QB"}="H313 4QB"; $resn_exch{"1H11 4QB"}="H111 4QB"; $resn_exch{"2H11 4QB"}="H112 4QB";
$resn_exch{"1H12 4QB"}="H121 4QB"; $resn_exch{"2H12 4QB"}="H122 4QB"; $resn_exch{"1H13 4QB"}="H131 4QB";
$resn_exch{"2H13 4QB"}="H132 4QB"; $resn_exch{"1H14 4QB"}="H141 4QB"; $resn_exch{"2H14 4QB"}="H142 4QB";
$resn_exch{"1H11 4QC"}="H111 4QC"; $resn_exch{"2H11 4QC"}="H112 4QC"; $resn_exch{"1H12 4QC"}="H121 4QC";
$resn_exch{"2H12 4QC"}="H122 4QC"; $resn_exch{"1H20 4QC"}="H201 4QC"; $resn_exch{"2H20 4QC"}="H202 4QC";
$resn_exch{"3H20 4QC"}="H203 4QC"; $resn_exch{"1H24 4QC"}="H241 4QC"; $resn_exch{"2H24 4QC"}="H242 4QC";
$resn_exch{"1H23 4QC"}="H231 4QC"; $resn_exch{"2H23 4QC"}="H232 4QC"; $resn_exch{"3H23 4QC"}="H233 4QC";
$resn_exch{"1HN1 4QC"}="HN11 4QC"; $resn_exch{"2HN1 4QC"}="HN12 4QC"; $resn_exch{"1H18 4RR"}="H181 4RR";
$resn_exch{"2H18 4RR"}="H182 4RR"; $resn_exch{"3H18 4RR"}="H183 4RR"; $resn_exch{"1H15 4RR"}="H151 4RR";
$resn_exch{"2H15 4RR"}="H152 4RR"; $resn_exch{"1H14 4RR"}="H141 4RR"; $resn_exch{"2H14 4RR"}="H142 4RR";
$resn_exch{"1H13 4RR"}="H131 4RR"; $resn_exch{"2H13 4RR"}="H132 4RR"; $resn_exch{"1H12 4RR"}="H121 4RR";
$resn_exch{"2H12 4RR"}="H122 4RR"; $resn_exch{"1H5  4RR"}=" H51 4RR"; $resn_exch{"2H5  4RR"}=" H52 4RR";
$resn_exch{"1H1  4RR"}="H11A 4RR"; $resn_exch{"2H1  4RR"}=" H12 4RR"; $resn_exch{"1H5* 4SC"}=" H5' 4SC";
$resn_exch{"2H5* 4SC"}="H5'' 4SC"; $resn_exch{" H4* 4SC"}=" H4' 4SC"; $resn_exch{" H3* 4SC"}=" H3' 4SC";
$resn_exch{"*HO3 4SC"}="HO3' 4SC"; $resn_exch{"1H2* 4SC"}=" H2' 4SC"; $resn_exch{"2H2* 4SC"}="H2'' 4SC";
$resn_exch{" H1* 4SC"}=" H1' 4SC"; $resn_exch{"1HN4 4SC"}="HN41 4SC"; $resn_exch{"2HN4 4SC"}="HN42 4SC";
$resn_exch{"1H6  4SC"}=" H61 4SC"; $resn_exch{"2H6  4SC"}=" H62 4SC"; $resn_exch{"1H5M 4SC"}=" H71 4SC";
$resn_exch{"2H5M 4SC"}=" H72 4SC"; $resn_exch{"3H5M 4SC"}=" H73 4SC"; $resn_exch{"1H10 4SP"}="H101 4SP";
$resn_exch{"2H10 4SP"}="H102 4SP"; $resn_exch{"1H12 4SP"}="H121 4SP"; $resn_exch{"2H12 4SP"}="H122 4SP";
$resn_exch{"1H13 4SP"}="H131 4SP"; $resn_exch{"2H13 4SP"}="H132 4SP"; $resn_exch{"1H14 4SP"}="H141 4SP";
$resn_exch{"2H14 4SP"}="H142 4SP"; $resn_exch{"1H15 4SP"}="H151 4SP"; $resn_exch{"2H15 4SP"}="H152 4SP";
$resn_exch{"1H16 4SP"}="H161 4SP"; $resn_exch{"2H16 4SP"}="H162 4SP"; $resn_exch{"1H26 4SP"}="H261 4SP";
$resn_exch{"2H26 4SP"}="H262 4SP"; $resn_exch{"1H16 4SR"}="H161 4SR"; $resn_exch{"2H16 4SR"}="H162 4SR";
$resn_exch{"1H12 4SR"}="H121 4SR"; $resn_exch{"2H12 4SR"}="H122 4SR"; $resn_exch{"1H20 4SR"}="H201 4SR";
$resn_exch{"2H20 4SR"}="H202 4SR"; $resn_exch{"3H20 4SR"}="H203 4SR"; $resn_exch{"1H5  4SR"}=" H51 4SR";
$resn_exch{"2H5  4SR"}=" H52 4SR"; $resn_exch{"1H6  4SR"}=" H61 4SR"; $resn_exch{"2H6  4SR"}=" H62 4SR";
$resn_exch{"1H7  4SR"}=" H71 4SR"; $resn_exch{"2H7  4SR"}=" H72 4SR"; $resn_exch{"1H8  4SR"}=" H81 4SR";
$resn_exch{"2H8  4SR"}=" H82 4SR"; $resn_exch{"1HAB 4ST"}="HAB1 4ST"; $resn_exch{"2HAB 4ST"}="HAB2 4ST";
$resn_exch{"3HAB 4ST"}="HAB3 4ST"; $resn_exch{"1HAA 4ST"}="HAA1 4ST"; $resn_exch{"2HAA 4ST"}="HAA2 4ST";
$resn_exch{"3HAA 4ST"}="HAA3 4ST"; $resn_exch{"1HAN 4ST"}="HAN1 4ST"; $resn_exch{"2HAN 4ST"}="HAN2 4ST";
$resn_exch{"1HAC 4ST"}="HAC1 4ST"; $resn_exch{"2HAC 4ST"}="HAC2 4ST"; $resn_exch{"3HAC 4ST"}="HAC3 4ST";
$resn_exch{"1HAL 4ST"}="HAL1 4ST"; $resn_exch{"2HAL 4ST"}="HAL2 4ST"; $resn_exch{"1HAJ 4ST"}="HAJ1 4ST";
$resn_exch{"2HAJ 4ST"}="HAJ2 4ST"; $resn_exch{"1HAI 4ST"}="HAI1 4ST"; $resn_exch{"2HAI 4ST"}="HAI2 4ST";
$resn_exch{"1HAK 4ST"}="HAK1 4ST"; $resn_exch{"2HAK 4ST"}="HAK2 4ST"; $resn_exch{"1HAM 4ST"}="HAM1 4ST";
$resn_exch{"2HAM 4ST"}="HAM2 4ST"; $resn_exch{" H1* 4SU"}=" H1' 4SU"; $resn_exch{" H2* 4SU"}=" H2' 4SU";
$resn_exch{"*HO2 4SU"}="HO2' 4SU"; $resn_exch{" H3* 4SU"}=" H3' 4SU"; $resn_exch{" H4* 4SU"}=" H4' 4SU";
$resn_exch{"*HO3 4SU"}="HO3' 4SU"; $resn_exch{"1H5* 4SU"}=" H5' 4SU"; $resn_exch{"2H5* 4SU"}="H5'' 4SU";
$resn_exch{"2HOP 4SU"}="HOP2 4SU"; $resn_exch{"3HOP 4SU"}="HOP3 4SU"; $resn_exch{"1H5M 4TA"}="H5M1 4TA";
$resn_exch{"2H5M 4TA"}="H5M2 4TA"; $resn_exch{"3H5M 4TA"}="H5M3 4TA"; $resn_exch{" H1* 4TA"}=" H1B 4TA";
$resn_exch{"1H2* 4TA"}="H2'1 4TA"; $resn_exch{"2H2* 4TA"}="H2'2 4TA"; $resn_exch{" H3* 4TA"}=" H3B 4TA";
$resn_exch{" H4* 4TA"}=" H4B 4TA"; $resn_exch{"1H5* 4TA"}="H5'1 4TA"; $resn_exch{"2H5* 4TA"}="H5'2 4TA";
$resn_exch{"1H5' 4TA"}=" H5B 4TA"; $resn_exch{"2H5' 4TA"}=" H5D 4TA"; $resn_exch{"1H6A 4TA"}="H6A1 4TA";
$resn_exch{"2H6A 4TA"}="H6A2 4TA"; $resn_exch{"1H6  4TB"}=" H61 4TB"; $resn_exch{"2H6  4TB"}=" H62 4TB";
$resn_exch{"1H7  4TB"}=" H71 4TB"; $resn_exch{"2H7  4TB"}=" H72 4TB"; $resn_exch{"1H8  4TB"}=" H81 4TB";
$resn_exch{"2H8  4TB"}=" H82 4TB"; $resn_exch{"1H3B 4TC"}="H3B1 4TC"; $resn_exch{"2H3B 4TC"}="H3B2 4TC";
$resn_exch{"1H5U 4TC"}="H5U1 4TC"; $resn_exch{"2H5U 4TC"}="H5U2 4TC"; $resn_exch{"1H5* 4TC"}="H5'1 4TC";
$resn_exch{"2H5* 4TC"}="H5'2 4TC"; $resn_exch{" H4* 4TC"}=" H4' 4TC"; $resn_exch{" H3* 4TC"}=" H3' 4TC";
$resn_exch{" H2* 4TC"}=" H2' 4TC"; $resn_exch{" H1* 4TC"}=" H1' 4TC"; $resn_exch{"1H6N 4TC"}="H6N1 4TC";
$resn_exch{"2H6N 4TC"}="H6N2 4TC"; $resn_exch{"1HAP 4TN"}="HAP1 4TN"; $resn_exch{"2HAP 4TN"}="HAP2 4TN";
$resn_exch{"1HAA 4TN"}="HAA1 4TN"; $resn_exch{"2HAA 4TN"}="HAA2 4TN"; $resn_exch{"3HAA 4TN"}="HAA3 4TN";
$resn_exch{"1HAB 4TN"}="HAB1 4TN"; $resn_exch{"2HAB 4TN"}="HAB2 4TN"; $resn_exch{"3HAB 4TN"}="HAB3 4TN";
$resn_exch{"1HAC 4TN"}="HAC1 4TN"; $resn_exch{"2HAC 4TN"}="HAC2 4TN"; $resn_exch{"3HAC 4TN"}="HAC3 4TN";
$resn_exch{"1HAQ 4TN"}="HAQ1 4TN"; $resn_exch{"2HAQ 4TN"}="HAQ2 4TN"; $resn_exch{"1HAR 4TN"}="HAR1 4TN";
$resn_exch{"2HAR 4TN"}="HAR2 4TN"; $resn_exch{"1HAD 4TN"}="HAD1 4TN"; $resn_exch{"2HAD 4TN"}="HAD2 4TN";
$resn_exch{"3HAD 4TN"}="HAD3 4TN"; $resn_exch{"1HAE 4TN"}="HAE1 4TN"; $resn_exch{"2HAE 4TN"}="HAE2 4TN";
$resn_exch{"3HAE 4TN"}="HAE3 4TN"; $resn_exch{"2HN  4TP"}=" HN2 4TP"; $resn_exch{"1HG2 4TP"}="HG21 4TP";
$resn_exch{"2HG2 4TP"}="HG22 4TP"; $resn_exch{"2HOP 4TP"}="HOP2 4TP"; $resn_exch{"3HOP 4TP"}="HOP3 4TP";
$resn_exch{"1HN1 4TR"}="HN11 4TR"; $resn_exch{"2HN1 4TR"}="HN12 4TR"; $resn_exch{"1H7  4TR"}=" H71 4TR";
$resn_exch{"2H7  4TR"}=" H72 4TR"; $resn_exch{"1HN1 4TZ"}="HN11 4TZ"; $resn_exch{"2HN1 4TZ"}="HN12 4TZ";
$resn_exch{"1H10 4TZ"}="H101 4TZ"; $resn_exch{"2H10 4TZ"}="H102 4TZ"; $resn_exch{"1H49 4UN"}="H491 4UN";
$resn_exch{"2H49 4UN"}="H492 4UN"; $resn_exch{"1H28 4UN"}="H281 4UN"; $resn_exch{"2H28 4UN"}="H282 4UN";
$resn_exch{"3H28 4UN"}="H283 4UN"; $resn_exch{"1H24 4UN"}="H241 4UN"; $resn_exch{"2H24 4UN"}="H242 4UN";
$resn_exch{"3H24 4UN"}="H243 4UN"; $resn_exch{"1H19 4UN"}="H191 4UN"; $resn_exch{"2H19 4UN"}="H192 4UN";
$resn_exch{"1H22 501"}="H221 501"; $resn_exch{"2H22 501"}="H222 501"; $resn_exch{"1H23 501"}="H231 501";
$resn_exch{"2H23 501"}="H232 501"; $resn_exch{"1H26 501"}="H261 501"; $resn_exch{"2H26 501"}="H262 501";
$resn_exch{"1H29 501"}="H291 501"; $resn_exch{"2H29 501"}="H292 501"; $resn_exch{"3H29 501"}="H293 501";
$resn_exch{"1H37 501"}="H371 501"; $resn_exch{"2H37 501"}="H372 501"; $resn_exch{"3H37 501"}="H373 501";
$resn_exch{"1H42 501"}="H421 501"; $resn_exch{"2H42 501"}="H422 501"; $resn_exch{"3H42 501"}="H423 501";
$resn_exch{"1H1C 505"}="H1C1 505"; $resn_exch{"2H1C 505"}="H1C2 505"; $resn_exch{"3H1C 505"}="H1C3 505";
$resn_exch{"1H3N 505"}="H3N1 505"; $resn_exch{"2H3N 505"}="H3N2 505"; $resn_exch{"1H4C 505"}="H4C1 505";
$resn_exch{"2H4C 505"}="H4C2 505"; $resn_exch{"1H8C 505"}="H8C1 505"; $resn_exch{"2H8C 505"}="H8C2 505";
$resn_exch{"3H8C 505"}="H8C3 505"; $resn_exch{"1H13 505"}="H131 505"; $resn_exch{"2H13 505"}="H132 505";
$resn_exch{"3H13 505"}="H133 505"; $resn_exch{"1H12 509"}="H121 509"; $resn_exch{"2H12 509"}="H122 509";
$resn_exch{"1H9  512"}=" H91 512"; $resn_exch{"2H9  512"}=" H92 512"; $resn_exch{"1H18 514"}="H181 514";
$resn_exch{"2H18 514"}="H182 514"; $resn_exch{"1H20 514"}="H201 514"; $resn_exch{"2H20 514"}="H202 514";
$resn_exch{"3H20 514"}="H203 514"; $resn_exch{"1H3  515"}=" H31 515"; $resn_exch{"1H4  515"}=" H41 515";
$resn_exch{"1H9  515"}=" H91 515"; $resn_exch{"1H12 515"}="H121 515"; $resn_exch{"2H12 515"}="H122 515";
$resn_exch{"1H13 515"}="H131 515"; $resn_exch{"2H13 515"}="H132 515"; $resn_exch{"1H14 515"}="H141 515";
$resn_exch{"2H14 515"}="H142 515"; $resn_exch{"1H15 515"}="H151 515"; $resn_exch{"2H15 515"}="H152 515";
$resn_exch{"1H23 515"}="H231 515"; $resn_exch{"2H23 515"}="H232 515"; $resn_exch{"3H23 515"}="H233 515";
$resn_exch{"1H7  515"}=" H71 515"; $resn_exch{"2H7  515"}=" H72 515"; $resn_exch{"1H27 515"}="H271 515";
$resn_exch{"1H28 515"}="H281 515"; $resn_exch{"1H29 515"}="H291 515"; $resn_exch{"1H30 515"}="H301 515";
$resn_exch{"1H33 515"}="H331 515"; $resn_exch{"1H36 515"}="H361 515"; $resn_exch{"1H16 515"}="H161 515";
$resn_exch{"1H17 515"}="H171 515"; $resn_exch{"1H18 515"}="H181 515"; $resn_exch{"1H19 515"}="H191 515";
$resn_exch{"1H20 515"}="H201 515"; $resn_exch{"2H20 515"}="H202 515"; $resn_exch{"1H2  515"}=" H21 515";
$resn_exch{"1H41 515"}="H411 515"; $resn_exch{"1H42 515"}="H421 515"; $resn_exch{"1H43 515"}="H431 515";
$resn_exch{"1H44 515"}="H441 515"; $resn_exch{"1H20 517"}="H201 517"; $resn_exch{"2H20 517"}="H202 517";
$resn_exch{"3H20 517"}="H203 517"; $resn_exch{"1H16 517"}="H161 517"; $resn_exch{"2H16 517"}="H162 517";
$resn_exch{"1H11 521"}="H111 521"; $resn_exch{"2H11 521"}="H112 521"; $resn_exch{"1H5A 523"}="H5A1 523";
$resn_exch{"2H5A 523"}="H5A2 523"; $resn_exch{"3H5A 523"}="H5A3 523"; $resn_exch{"1HN4 523"}="HN41 523";
$resn_exch{"2HN4 523"}="HN42 523"; $resn_exch{" H1* 523"}=" H1' 523"; $resn_exch{"1H2* 523"}="H2'1 523";
$resn_exch{"2H2* 523"}="H2'2 523"; $resn_exch{" H3* 523"}=" H3' 523"; $resn_exch{" H4* 523"}=" H4' 523";
$resn_exch{"HO3* 523"}="HO3' 523"; $resn_exch{"1H5* 523"}="H5'1 523"; $resn_exch{"2H5* 523"}="H5'2 523";
$resn_exch{"1H19 524"}="H191 524"; $resn_exch{"2H19 524"}="H192 524"; $resn_exch{"1H34 524"}="H341 524";
$resn_exch{"2H34 524"}="H342 524"; $resn_exch{"1H33 524"}="H331 524"; $resn_exch{"2H33 524"}="H332 524";
$resn_exch{"1H31 524"}="H311 524"; $resn_exch{"2H31 524"}="H312 524"; $resn_exch{"1H23 524"}="H231 524";
$resn_exch{"2H23 524"}="H232 524"; $resn_exch{"3H23 524"}="H233 524"; $resn_exch{"1H27 524"}="H271 524";
$resn_exch{"2H27 524"}="H272 524"; $resn_exch{"3H27 524"}="H273 524"; $resn_exch{"1H45 524"}="H451 524";
$resn_exch{"2H45 524"}="H452 524"; $resn_exch{"1H44 524"}="H441 524"; $resn_exch{"2H44 524"}="H442 524";
$resn_exch{"1H48 524"}="H481 524"; $resn_exch{"2H48 524"}="H482 524"; $resn_exch{"1H47 524"}="H471 524";
$resn_exch{"2H47 524"}="H472 524"; $resn_exch{"1H21 527"}="H211 527"; $resn_exch{"2H21 527"}="H212 527";
$resn_exch{"1H31 527"}="H311 527"; $resn_exch{"2H31 527"}="H312 527"; $resn_exch{"1H32 527"}="H321 527";
$resn_exch{"2H32 527"}="H322 527"; $resn_exch{"1H34 527"}="H341 527"; $resn_exch{"2H34 527"}="H342 527";
$resn_exch{"1H35 527"}="H351 527"; $resn_exch{"2H35 527"}="H352 527"; $resn_exch{"1H49 527"}="H491 527";
$resn_exch{"2H49 527"}="H492 527"; $resn_exch{"1H35 528"}="H351 528"; $resn_exch{"2H35 528"}="H352 528";
$resn_exch{"1H34 528"}="H341 528"; $resn_exch{"2H34 528"}="H342 528"; $resn_exch{"1H33 528"}="H331 528";
$resn_exch{"2H33 528"}="H332 528"; $resn_exch{"1H30 528"}="H301 528"; $resn_exch{"2H30 528"}="H302 528";
$resn_exch{"3H30 528"}="H303 528"; $resn_exch{"1H29 528"}="H291 528"; $resn_exch{"2H29 528"}="H292 528";
$resn_exch{"3H29 528"}="H293 528"; $resn_exch{"1H15 528"}="H151 528"; $resn_exch{"2H15 528"}="H152 528";
$resn_exch{"1H9  528"}=" H91 528"; $resn_exch{"2H9  528"}=" H92 528"; $resn_exch{"1H10 528"}="H101 528";
$resn_exch{"2H10 528"}="H102 528"; $resn_exch{"1H12 529"}="H121 529"; $resn_exch{"2H12 529"}="H122 529";
$resn_exch{"1H13 529"}="H131 529"; $resn_exch{"2H13 529"}="H132 529"; $resn_exch{"1H25 529"}="H251 529";
$resn_exch{"2H25 529"}="H252 529"; $resn_exch{"3H25 529"}="H253 529"; $resn_exch{"1HN  52A"}=" HN1 52A";
$resn_exch{"2HN  52A"}=" HN2 52A"; $resn_exch{"1HB1 52A"}="HB11 52A"; $resn_exch{"2HB1 52A"}="HB12 52A";
$resn_exch{"1HB2 52A"}="HB21 52A"; $resn_exch{"2HB2 52A"}="HB22 52A"; $resn_exch{"1H4  541"}=" H41 541";
$resn_exch{"2H4  541"}=" H42 541"; $resn_exch{"3H4  541"}=" H43 541"; $resn_exch{"1H8  541"}=" H81 541";
$resn_exch{"2H8  541"}=" H82 541"; $resn_exch{"1H15 541"}="H151 541"; $resn_exch{"2H15 541"}="H152 541";
$resn_exch{"1H17 541"}="H171 541"; $resn_exch{"2H17 541"}="H172 541"; $resn_exch{"3H17 541"}="H173 541";
$resn_exch{"1H19 541"}="H191 541"; $resn_exch{"2H19 541"}="H192 541"; $resn_exch{"1H25 541"}="H251 541";
$resn_exch{"2H25 541"}="H252 541"; $resn_exch{"3H25 541"}="H253 541"; $resn_exch{"1HO1 543"}="HO11 543";
$resn_exch{"2HO1 543"}="HO12 543"; $resn_exch{"1HO2 543"}="HO21 543"; $resn_exch{"2HO2 543"}="HO22 543";
$resn_exch{"1HO3 543"}="HO31 543"; $resn_exch{"2HO3 543"}="HO32 543"; $resn_exch{"1HO4 543"}="HO41 543";
$resn_exch{"2HO4 543"}="HO42 543"; $resn_exch{"1HO5 543"}="HO51 543"; $resn_exch{"2HO5 543"}="HO52 543";
$resn_exch{"1HO6 543"}="HO61 543"; $resn_exch{"2HO6 543"}="HO62 543"; $resn_exch{"1H1  543"}=" H11 543";
$resn_exch{"2H1  543"}=" H12 543"; $resn_exch{"1H2  543"}=" H21 543"; $resn_exch{"2H2  543"}=" H22 543";
$resn_exch{"3H2  543"}=" H23 543"; $resn_exch{"1HA  544"}=" HA1 544"; $resn_exch{"1HB  544"}=" HB1 544";
$resn_exch{"2HB  544"}=" HB2 544"; $resn_exch{"1HD1 544"}="HD11 544"; $resn_exch{"1HD2 544"}="HD21 544";
$resn_exch{"1HE1 544"}="HE11 544"; $resn_exch{"1HE2 544"}="HE21 544"; $resn_exch{"1H1F 544"}="H1F1 544";
$resn_exch{"1H1B 544"}="H1B1 544"; $resn_exch{"2H1B 544"}="H1B2 544"; $resn_exch{"3H1B 544"}="H1B3 544";
$resn_exch{"1H1I 544"}="H1I1 544"; $resn_exch{"1H1J 544"}="H1J1 544"; $resn_exch{"1H1K 544"}="H1K1 544";
$resn_exch{"1H1L 544"}="H1L1 544"; $resn_exch{"1H1M 544"}="H1M1 544"; $resn_exch{"1H3E 544"}="H3E1 544";
$resn_exch{"2H3E 544"}="H3E2 544"; $resn_exch{"3H3E 544"}="H3E3 544"; $resn_exch{"1H3N 544"}="H3N1 544";
$resn_exch{"1H3M 544"}="H3M1 544"; $resn_exch{"1H3L 544"}="H3L1 544"; $resn_exch{"1H3K 544"}="H3K1 544";
$resn_exch{"1H3J 544"}="H3J1 544"; $resn_exch{"1H3A 544"}="H3A1 544"; $resn_exch{"2H3A 544"}="H3A2 544";
$resn_exch{"1H3B 544"}="H3B1 544"; $resn_exch{"2H3B 544"}="H3B2 544"; $resn_exch{"1HO1 544"}="HO11 544";
$resn_exch{"1H14 545"}="H141 545"; $resn_exch{"2H14 545"}="H142 545"; $resn_exch{"1H24 545"}="H241 545";
$resn_exch{"2H24 545"}="H242 545"; $resn_exch{"1H25 545"}="H251 545"; $resn_exch{"2H25 545"}="H252 545";
$resn_exch{"1H26 545"}="H261 545"; $resn_exch{"2H26 545"}="H262 545"; $resn_exch{"1H27 545"}="H271 545";
$resn_exch{"2H27 545"}="H272 545"; $resn_exch{"3H27 545"}="H273 545"; $resn_exch{"1H16 545"}="H161 545";
$resn_exch{"2H16 545"}="H162 545"; $resn_exch{"1H4  545"}=" H41 545"; $resn_exch{"2H4  545"}=" H42 545";
$resn_exch{"1H30 545"}="H301 545"; $resn_exch{"2H30 545"}="H302 545"; $resn_exch{"1H35 547"}="H351 547";
$resn_exch{"2H35 547"}="H352 547"; $resn_exch{"1H36 547"}="H361 547"; $resn_exch{"2H36 547"}="H362 547";
$resn_exch{"1H42 547"}="H421 547"; $resn_exch{"2H42 547"}="H422 547"; $resn_exch{"1H43 547"}="H431 547";
$resn_exch{"2H43 547"}="H432 547"; $resn_exch{"1H45 547"}="H451 547"; $resn_exch{"2H45 547"}="H452 547";
$resn_exch{"1H46 547"}="H461 547"; $resn_exch{"2H46 547"}="H462 547"; $resn_exch{"1H10 561"}="H101 561";
$resn_exch{"2H10 561"}="H102 561"; $resn_exch{"1H31 561"}="H311 561"; $resn_exch{"2H31 561"}="H312 561";
$resn_exch{"1H32 561"}="H321 561"; $resn_exch{"2H32 561"}="H322 561"; $resn_exch{"1H33 561"}="H331 561";
$resn_exch{"2H33 561"}="H332 561"; $resn_exch{"1H17 564"}="H171 564"; $resn_exch{"2H17 564"}="H172 564";
$resn_exch{"1H18 564"}="H181 564"; $resn_exch{"2H18 564"}="H182 564"; $resn_exch{"1H23 564"}="H231 564";
$resn_exch{"2H23 564"}="H232 564"; $resn_exch{"3H23 564"}="H233 564"; $resn_exch{"1H24 564"}="H241 564";
$resn_exch{"2H24 564"}="H242 564"; $resn_exch{"3H24 564"}="H243 564"; $resn_exch{"1H25 564"}="H251 564";
$resn_exch{"2H25 564"}="H252 564"; $resn_exch{"3H25 564"}="H253 564"; $resn_exch{"1H26 564"}="H261 564";
$resn_exch{"2H26 564"}="H262 564"; $resn_exch{"3H26 564"}="H263 564"; $resn_exch{"1H11 565"}="H111 565";
$resn_exch{"2H11 565"}="H112 565"; $resn_exch{"1H15 565"}="H151 565"; $resn_exch{"2H15 565"}="H152 565";
$resn_exch{"1H20 565"}="H201 565"; $resn_exch{"2H20 565"}="H202 565"; $resn_exch{"1H25 565"}="H251 565";
$resn_exch{"2H25 565"}="H252 565"; $resn_exch{"1H26 565"}="H261 565"; $resn_exch{"2H26 565"}="H262 565";
$resn_exch{"1H27 565"}="H271 565"; $resn_exch{"2H27 565"}="H272 565"; $resn_exch{"1H37 565"}="H371 565";
$resn_exch{"2H37 565"}="H372 565"; $resn_exch{"3H37 565"}="H373 565"; $resn_exch{"1H1  566"}=" H11 566";
$resn_exch{"2H1  566"}=" H12 566"; $resn_exch{"1H2  566"}=" H21 566"; $resn_exch{"2H2  566"}=" H22 566";
$resn_exch{"1H4  566"}=" H41 566"; $resn_exch{"2H4  566"}=" H42 566"; $resn_exch{"1H5  566"}=" H51 566";
$resn_exch{"2H5  566"}=" H52 566"; $resn_exch{"1H6  566"}=" H61 566"; $resn_exch{"2H6  566"}=" H62 566";
$resn_exch{"1H16 566"}="H161 566"; $resn_exch{"2H16 566"}="H162 566"; $resn_exch{"1H18 566"}="H181 566";
$resn_exch{"2H18 566"}="H182 566"; $resn_exch{"1H2C 568"}="H2C1 568"; $resn_exch{"2H2C 568"}="H2C2 568";
$resn_exch{"1H4C 568"}="H4C1 568"; $resn_exch{"2H4C 568"}="H4C2 568"; $resn_exch{"1H6C 568"}="H6C1 568";
$resn_exch{"2H6C 568"}="H6C2 568"; $resn_exch{"1H13 568"}="H131 568"; $resn_exch{"2H13 568"}="H132 568";
$resn_exch{"1H29 568"}="H291 568"; $resn_exch{"2H29 568"}="H292 568"; $resn_exch{"1H39 568"}="H391 568";
$resn_exch{"2H39 568"}="H392 568"; $resn_exch{"1H3E 570"}="H3E1 570"; $resn_exch{"2H3E 570"}="H3E2 570";
$resn_exch{"3H3E 570"}="H3E3 570"; $resn_exch{"1H3A 570"}="H3A1 570"; $resn_exch{"2H3A 570"}="H3A2 570";
$resn_exch{"1H3B 570"}="H3B1 570"; $resn_exch{"2H3B 570"}="H3B2 570"; $resn_exch{"1H14 572"}="H141 572";
$resn_exch{"2H14 572"}="H142 572"; $resn_exch{"1H19 572"}="H191 572"; $resn_exch{"2H19 572"}="H192 572";
$resn_exch{"1H15 572"}="H151 572"; $resn_exch{"2H15 572"}="H152 572"; $resn_exch{"1H13 572"}="H131 572";
$resn_exch{"2H13 572"}="H132 572"; $resn_exch{"3H13 572"}="H133 572"; $resn_exch{"1H11 572"}="H111 572";
$resn_exch{"2H11 572"}="H112 572"; $resn_exch{"3H11 572"}="H113 572"; $resn_exch{"1H16 572"}="H161 572";
$resn_exch{"2H16 572"}="H162 572"; $resn_exch{"1H18 572"}="H181 572"; $resn_exch{"2H18 572"}="H182 572";
$resn_exch{"1H21 577"}="H211 577"; $resn_exch{"2H21 577"}="H212 577"; $resn_exch{"3H21 577"}="H213 577";
$resn_exch{"1H23 578"}="H231 578"; $resn_exch{"2H23 578"}="H232 578"; $resn_exch{"1H18 578"}="H181 578";
$resn_exch{"2H18 578"}="H182 578"; $resn_exch{"3H18 578"}="H183 578"; $resn_exch{"1H17 578"}="H171 578";
$resn_exch{"2H17 578"}="H172 578"; $resn_exch{"3H17 578"}="H173 578"; $resn_exch{"1H9  578"}=" H91 578";
$resn_exch{"2H9  578"}=" H92 578"; $resn_exch{"1H10 578"}="H101 578"; $resn_exch{"2H10 578"}="H102 578";
$resn_exch{"1H6  580"}=" H61 580"; $resn_exch{"2H6  580"}=" H62 580"; $resn_exch{"1H7  580"}=" H71 580";
$resn_exch{"2H7  580"}=" H72 580"; $resn_exch{"1H8  580"}=" H81 580"; $resn_exch{"2H8  580"}=" H82 580";
$resn_exch{"1H35 580"}="H351 580"; $resn_exch{"2H35 580"}="H352 580"; $resn_exch{"3H35 580"}="H353 580";
$resn_exch{"1H18 582"}="H181 582"; $resn_exch{"2H18 582"}="H182 582"; $resn_exch{"1H9  582"}=" H91 582";
$resn_exch{"2H9  582"}=" H92 582"; $resn_exch{"3H9  582"}=" H93 582"; $resn_exch{"1H7  582"}=" H71 582";
$resn_exch{"2H7  582"}=" H72 582"; $resn_exch{"3H7  582"}=" H73 582"; $resn_exch{"1H3  587"}="H31A 587";
$resn_exch{"2H3  587"}="H32A 587"; $resn_exch{"1H4  587"}=" H41 587"; $resn_exch{"2H4  587"}=" H42 587";
$resn_exch{"1H5  587"}=" H51 587"; $resn_exch{"2H5  587"}=" H52 587"; $resn_exch{"1H6  587"}=" H61 587";
$resn_exch{"2H6  587"}="H62A 587"; $resn_exch{"1H12 587"}="H121 587"; $resn_exch{"2H12 587"}="H122 587";
$resn_exch{"1H16 587"}="H161 587"; $resn_exch{"2H16 587"}="H162 587"; $resn_exch{"1H23 587"}="H231 587";
$resn_exch{"2H23 587"}="H232 587"; $resn_exch{"1H30 587"}="H301 587"; $resn_exch{"2H30 587"}="H302 587";
$resn_exch{"1H33 587"}="H331 587"; $resn_exch{"2H33 587"}="H332 587"; $resn_exch{"1H34 587"}="H341 587";
$resn_exch{"2H34 587"}="H342 587"; $resn_exch{"1H35 587"}="H351 587"; $resn_exch{"2H35 587"}="H352 587";
$resn_exch{"3H35 587"}="H353 587"; $resn_exch{"1H36 587"}="H361 587"; $resn_exch{"2H36 587"}="H362 587";
$resn_exch{"3H36 587"}="H363 587"; $resn_exch{"1H37 587"}="H371 587"; $resn_exch{"2H37 587"}="H372 587";
$resn_exch{"3H37 587"}="H373 587"; $resn_exch{"1H38 587"}="H381 587"; $resn_exch{"2H38 587"}="H382 587";
$resn_exch{"1H39 587"}="H391 587"; $resn_exch{"2H39 587"}="H392 587"; $resn_exch{"3H39 587"}="H393 587";
$resn_exch{"1H41 587"}="H411 587"; $resn_exch{"2H41 587"}="H412 587"; $resn_exch{"3H41 587"}="H413 587";
$resn_exch{"1H42 587"}="H421 587"; $resn_exch{"2H42 587"}="H422 587"; $resn_exch{"3H42 587"}="H423 587";
$resn_exch{"1H43 587"}="H431 587"; $resn_exch{"2H43 587"}="H432 587"; $resn_exch{"3H43 587"}="H433 587";
$resn_exch{"1H44 587"}="H441 587"; $resn_exch{"2H44 587"}="H442 587"; $resn_exch{"3H44 587"}="H443 587";
$resn_exch{"1H45 587"}="H451 587"; $resn_exch{"2H45 587"}="H452 587"; $resn_exch{"3H45 587"}="H453 587";
$resn_exch{"1H67 587"}="H671 587"; $resn_exch{"2H67 587"}="H672 587"; $resn_exch{"3H67 587"}="H673 587";
$resn_exch{"0HO1 587"}="HO10 587"; $resn_exch{"3HO1 587"}="HO13 587"; $resn_exch{"1HN3 588"}="HN31 588";
$resn_exch{"2HN3 588"}="HN32 588"; $resn_exch{"1H7  588"}=" H71 588"; $resn_exch{"2H7  588"}=" H72 588";
$resn_exch{"1H20 588"}="H201 588"; $resn_exch{"2H20 588"}="H202 588"; $resn_exch{"3H20 588"}="H203 588";
$resn_exch{"1H12 588"}="H121 588"; $resn_exch{"2H12 588"}="H122 588"; $resn_exch{"1H13 588"}="H131 588";
$resn_exch{"2H13 588"}="H132 588"; $resn_exch{"1H15 588"}="H151 588"; $resn_exch{"2H15 588"}="H152 588";
$resn_exch{"1H14 588"}="H141 588"; $resn_exch{"2H14 588"}="H142 588"; $resn_exch{"1H16 588"}="H161 588";
$resn_exch{"2H16 588"}="H162 588"; $resn_exch{"3H16 588"}="H163 588"; $resn_exch{"1H10 598"}="H101 598";
$resn_exch{"2H10 598"}="H102 598"; $resn_exch{"1H30 598"}="H301 598"; $resn_exch{"2H30 598"}="H302 598";
$resn_exch{"1H31 598"}="H311 598"; $resn_exch{"2H31 598"}="H312 598"; $resn_exch{"1H33 598"}="H331 598";
$resn_exch{"2H33 598"}="H332 598"; $resn_exch{"1H34 598"}="H341 598"; $resn_exch{"2H34 598"}="H342 598";
$resn_exch{"1H45 598"}="H451 598"; $resn_exch{"2H45 598"}="H452 598"; $resn_exch{"1H12 59A"}="H121 59A";
$resn_exch{"2H12 59A"}="H122 59A"; $resn_exch{"1H11 59A"}="H111 59A"; $resn_exch{"2H11 59A"}="H112 59A";
$resn_exch{"3H11 59A"}="H113 59A"; $resn_exch{"1H13 59A"}="H131 59A"; $resn_exch{"2H13 59A"}="H132 59A";
$resn_exch{"3H13 59A"}="H133 59A"; $resn_exch{"1H8  59A"}=" H81 59A"; $resn_exch{"2H8  59A"}=" H82 59A";
$resn_exch{"1H9  59A"}=" H91 59A"; $resn_exch{"2H9  59A"}=" H92 59A"; $resn_exch{"3H9  59A"}=" H93 59A";
$resn_exch{"3HOP 5AA"}="HOP3 5AA"; $resn_exch{"2HOP 5AA"}="HOP2 5AA"; $resn_exch{"1H5* 5AA"}=" H5' 5AA";
$resn_exch{"2H5* 5AA"}="H5'' 5AA"; $resn_exch{" H4* 5AA"}=" H4' 5AA"; $resn_exch{" H1* 5AA"}=" H1' 5AA";
$resn_exch{"1H9  5AA"}=" H91 5AA"; $resn_exch{"2H9  5AA"}=" H92 5AA"; $resn_exch{"3H9  5AA"}=" H93 5AA";
$resn_exch{"1H10 5AA"}="H101 5AA"; $resn_exch{"2H10 5AA"}="H102 5AA"; $resn_exch{"3H10 5AA"}="H103 5AA";
$resn_exch{" H2* 5AA"}=" H2' 5AA"; $resn_exch{" H3* 5AA"}=" H3' 5AA"; $resn_exch{"1H3* 5AA"}="H3'1 5AA";
$resn_exch{"2H3* 5AA"}="H3'2 5AA"; $resn_exch{"1HN6 5AD"}="HN61 5AD"; $resn_exch{"2HN6 5AD"}="HN62 5AD";
$resn_exch{"1H5' 5AD"}="H5'1 5AD"; $resn_exch{"2H5' 5AD"}="H5'2 5AD"; $resn_exch{"3H5' 5AD"}="H5'3 5AD";
$resn_exch{"'HO2 5AD"}="HO2' 5AD"; $resn_exch{"'HO3 5AD"}="HO3' 5AD"; $resn_exch{"1H1  5AF"}=" H11 5AF";
$resn_exch{"3H1  5AF"}=" H13 5AF"; $resn_exch{"2H1  5AF"}=" H12 5AF"; $resn_exch{"1H2  5AF"}=" H21 5AF";
$resn_exch{"2H2  5AF"}=" H22 5AF"; $resn_exch{"1H3  5AF"}=" H31 5AF"; $resn_exch{"2H4  5AF"}=" H42 5AF";
$resn_exch{"2H5  5AF"}=" H52 5AF"; $resn_exch{"3H5  5AF"}=" H53 5AF"; $resn_exch{"1H7  5AF"}=" H71 5AF";
$resn_exch{"2H6  5AF"}=" H62 5AF"; $resn_exch{"3H6  5AF"}=" H63 5AF"; $resn_exch{"1H1  5AM"}="H11A 5AM";
$resn_exch{"2H1  5AM"}="H12A 5AM"; $resn_exch{"1H15 5AM"}="H151 5AM"; $resn_exch{"2H15 5AM"}="H152 5AM";
$resn_exch{"1H16 5AM"}="H161 5AM"; $resn_exch{"2H16 5AM"}="H162 5AM"; $resn_exch{"1H27 5AM"}="H271 5AM";
$resn_exch{"2H27 5AM"}="H272 5AM"; $resn_exch{"1H30 5AM"}="H301 5AM"; $resn_exch{"2H30 5AM"}="H302 5AM";
$resn_exch{"1H31 5AM"}="H311 5AM"; $resn_exch{"2H31 5AM"}="H312 5AM"; $resn_exch{"1H33 5AM"}="H331 5AM";
$resn_exch{"2H33 5AM"}="H332 5AM"; $resn_exch{"1H35 5AM"}="H351 5AM"; $resn_exch{"2H35 5AM"}="H352 5AM";
$resn_exch{"1H17 5AM"}="H171 5AM"; $resn_exch{"2H17 5AM"}="H172 5AM"; $resn_exch{"1H18 5AM"}="H181 5AM";
$resn_exch{"2H18 5AM"}="H182 5AM"; $resn_exch{"1H19 5AM"}="H191 5AM"; $resn_exch{"2H19 5AM"}="H192 5AM";
$resn_exch{"1H25 5AM"}="H251 5AM"; $resn_exch{"2H25 5AM"}="H252 5AM"; $resn_exch{"1H28 5AM"}="H281 5AM";
$resn_exch{"2H28 5AM"}="H282 5AM"; $resn_exch{"1H36 5AM"}="H361 5AM"; $resn_exch{"2H36 5AM"}="H362 5AM";
$resn_exch{"1HN  5AN"}=" HN1 5AN"; $resn_exch{"2HN  5AN"}=" HN2 5AN"; $resn_exch{"1H20 5AP"}="H201 5AP";
$resn_exch{"2H20 5AP"}="H202 5AP"; $resn_exch{"1H21 5AP"}="H211 5AP"; $resn_exch{"2H21 5AP"}="H212 5AP";
$resn_exch{"1H23 5AP"}="H231 5AP"; $resn_exch{"2H23 5AP"}="H232 5AP"; $resn_exch{"1H28 5AP"}="H281 5AP";
$resn_exch{"2H28 5AP"}="H282 5AP"; $resn_exch{"3H28 5AP"}="H283 5AP"; $resn_exch{"1H29 5AP"}="H291 5AP";
$resn_exch{"2H29 5AP"}="H292 5AP"; $resn_exch{"3H29 5AP"}="H293 5AP"; $resn_exch{"1H5* 5AS"}="H5'1 5AS";
$resn_exch{"2H5* 5AS"}="H5'2 5AS"; $resn_exch{" H4* 5AS"}=" H4' 5AS"; $resn_exch{" H3* 5AS"}=" H3' 5AS";
$resn_exch{"3HO* 5AS"}="HO'3 5AS"; $resn_exch{" H2* 5AS"}=" H2' 5AS"; $resn_exch{"2HO* 5AS"}="HO'2 5AS";
$resn_exch{" H1* 5AS"}=" H1' 5AS"; $resn_exch{"1H6  5AS"}=" H61 5AS"; $resn_exch{"2H6  5AS"}=" H62 5AS";
$resn_exch{"1H10 5AS"}="H101 5AS"; $resn_exch{"2H10 5AS"}="H102 5AS"; $resn_exch{"1H11 5AS"}="H111 5AS";
$resn_exch{"2H11 5AS"}="H112 5AS"; $resn_exch{"3H11 5AS"}="H113 5AS"; $resn_exch{"1HN5 5AT"}="HN51 5AT";
$resn_exch{"2HN5 5AT"}="HN52 5AT"; $resn_exch{"1H2* 5AT"}=" H2' 5AT"; $resn_exch{"2H2* 5AT"}="H2'' 5AT";
$resn_exch{"1H5* 5AT"}=" H5' 5AT"; $resn_exch{"2H5* 5AT"}="H5'' 5AT"; $resn_exch{" H4* 5AT"}=" H4' 5AT";
$resn_exch{" H1* 5AT"}=" H1' 5AT"; $resn_exch{" H3* 5AT"}=" H3' 5AT"; $resn_exch{"H3T  5AT"}="HO3' 5AT";
$resn_exch{"1H6  5AX"}=" H61 5AX"; $resn_exch{"2H6  5AX"}=" H62 5AX"; $resn_exch{"1H8  5AX"}=" H81 5AX";
$resn_exch{"2H8  5AX"}=" H82 5AX"; $resn_exch{"3H8  5AX"}=" H83 5AX"; $resn_exch{"1H1  5AX"}=" H11 5AX";
$resn_exch{"2H1  5AX"}=" H12 5AX"; $resn_exch{"1H22 5BN"}="H221 5BN"; $resn_exch{"2H22 5BN"}="H222 5BN";
$resn_exch{"1H21 5BN"}="H211 5BN"; $resn_exch{"2H21 5BN"}="H212 5BN"; $resn_exch{"1H20 5BN"}="H201 5BN";
$resn_exch{"2H20 5BN"}="H202 5BN"; $resn_exch{"1H1  5BR"}=" H11 5BR"; $resn_exch{"2H1  5BR"}=" H12 5BR";
$resn_exch{"1H2  5BR"}=" H21 5BR"; $resn_exch{"2H2  5BR"}=" H22 5BR"; $resn_exch{"1H3  5BR"}=" H31 5BR";
$resn_exch{"2H3  5BR"}=" H32 5BR"; $resn_exch{"1H4  5BR"}=" H41 5BR"; $resn_exch{"2H4  5BR"}=" H42 5BR";
$resn_exch{"1H5  5BR"}=" H51 5BR"; $resn_exch{"2H5  5BR"}=" H52 5BR"; $resn_exch{"3H5  5BR"}=" H53 5BR";
$resn_exch{"2HOP 5BU"}="HOP2 5BU"; $resn_exch{"3HOP 5BU"}="HOP3 5BU"; $resn_exch{"1H5* 5BU"}=" H5' 5BU";
$resn_exch{"2H5* 5BU"}="H5'' 5BU"; $resn_exch{" H4* 5BU"}=" H4' 5BU"; $resn_exch{" H3* 5BU"}=" H3' 5BU";
$resn_exch{"H3T  5BU"}="HO3' 5BU"; $resn_exch{" H2* 5BU"}=" H2' 5BU"; $resn_exch{"2HO* 5BU"}="HO2' 5BU";
$resn_exch{" H1* 5BU"}=" H1' 5BU"; $resn_exch{"1HB  5CA"}=" HB1 5CA"; $resn_exch{"2HB  5CA"}=" HB2 5CA";
$resn_exch{"1H5* 5CA"}="H5'1 5CA"; $resn_exch{"2H5* 5CA"}="H5'2 5CA"; $resn_exch{" H4* 5CA"}=" H4' 5CA";
$resn_exch{" H3* 5CA"}=" H3' 5CA"; $resn_exch{" H2* 5CA"}=" H2' 5CA"; $resn_exch{"2HO* 5CA"}="HO'2 5CA";
$resn_exch{" H1* 5CA"}=" H1' 5CA"; $resn_exch{"1H6  5CA"}=" H61 5CA"; $resn_exch{"2H6  5CA"}=" H62 5CA";
$resn_exch{"1H13 5CB"}="H131 5CB"; $resn_exch{"2H13 5CB"}="H132 5CB"; $resn_exch{"1H16 5CB"}="H161 5CB";
$resn_exch{"2H16 5CB"}="H162 5CB"; $resn_exch{"17H1 5CB"}="H117 5CB"; $resn_exch{"1H19 5CB"}="H191 5CB";
$resn_exch{"20H2 5CB"}="H220 5CB"; $resn_exch{"1H24 5CB"}="H241 5CB"; $resn_exch{"2H24 5CB"}="H242 5CB";
$resn_exch{"1H25 5CB"}="H251 5CB"; $resn_exch{"2H25 5CB"}="H252 5CB"; $resn_exch{"1H6N 5CD"}="H6N1 5CD";
$resn_exch{"2H6N 5CD"}="H6N2 5CD"; $resn_exch{" H2* 5CD"}=" H2' 5CD"; $resn_exch{" H3* 5CD"}=" H3' 5CD";
$resn_exch{" H4* 5CD"}=" H4' 5CD"; $resn_exch{"1H5* 5CD"}="H5'1 5CD"; $resn_exch{"2H5* 5CD"}="H5'2 5CD";
$resn_exch{" H1* 5CD"}=" H1' 5CD"; $resn_exch{"1H5* 5CG"}=" H5' 5CG"; $resn_exch{"2H5* 5CG"}="H5'' 5CG";
$resn_exch{" H4* 5CG"}=" H4' 5CG"; $resn_exch{" H3* 5CG"}=" H3' 5CG"; $resn_exch{"*HO3 5CG"}="HO3' 5CG";
$resn_exch{" H2* 5CG"}=" H2' 5CG"; $resn_exch{"*HO2 5CG"}="HO2' 5CG"; $resn_exch{" H1* 5CG"}=" H1' 5CG";
$resn_exch{"1HN2 5CG"}="HN21 5CG"; $resn_exch{"2HN2 5CG"}="HN22 5CG"; $resn_exch{"1H5A 5CM"}="H5A1 5CM";
$resn_exch{"2H5A 5CM"}="H5A2 5CM"; $resn_exch{"3H5A 5CM"}="H5A3 5CM"; $resn_exch{"1HN4 5CM"}="HN41 5CM";
$resn_exch{"2HN4 5CM"}="HN42 5CM"; $resn_exch{" H1* 5CM"}=" H1' 5CM"; $resn_exch{"1H2* 5CM"}=" H2' 5CM";
$resn_exch{"2H2* 5CM"}="H2'' 5CM"; $resn_exch{" H3* 5CM"}=" H3' 5CM"; $resn_exch{" H4* 5CM"}=" H4' 5CM";
$resn_exch{"*HO3 5CM"}="HO3' 5CM"; $resn_exch{"1H5* 5CM"}=" H5' 5CM"; $resn_exch{"2H5* 5CM"}="H5'' 5CM";
$resn_exch{"2HOP 5CM"}="HOP2 5CM"; $resn_exch{"3HOP 5CM"}="HOP3 5CM"; $resn_exch{"1H7  5CN"}=" H71 5CN";
$resn_exch{"2H7  5CN"}=" H72 5CN"; $resn_exch{"1H8  5CN"}=" H81 5CN"; $resn_exch{"2H8  5CN"}=" H82 5CN";
$resn_exch{"1H9  5CN"}=" H91 5CN"; $resn_exch{"2H9  5CN"}=" H92 5CN"; $resn_exch{"1H10 5CN"}="H101 5CN";
$resn_exch{"2H10 5CN"}="H102 5CN"; $resn_exch{"1H12 5CN"}="H121 5CN"; $resn_exch{"2H12 5CN"}="H122 5CN";
$resn_exch{"3H12 5CN"}="H123 5CN"; $resn_exch{"1H13 5CN"}="H131 5CN"; $resn_exch{"2H13 5CN"}="H132 5CN";
$resn_exch{" HN2 5CS"}=" H2  5CS"; $resn_exch{"1HB  5CS"}=" HB2 5CS"; $resn_exch{"2HB  5CS"}=" HB3 5CS";
$resn_exch{"1HN  5CS"}=" HN1 5CS"; $resn_exch{"2HN  5CS"}="HN2A 5CS"; $resn_exch{"1HE  5CS"}=" HE3 5CS";
$resn_exch{"2HE  5CS"}=" HE2 5CS"; $resn_exch{"1H17 5DE"}="H171 5DE"; $resn_exch{"2H17 5DE"}="H172 5DE";
$resn_exch{"1H18 5DE"}="H181 5DE"; $resn_exch{"2H18 5DE"}="H182 5DE"; $resn_exch{"3H18 5DE"}="H183 5DE";
$resn_exch{"1H9  5DE"}=" H91 5DE"; $resn_exch{"2H9  5DE"}=" H92 5DE"; $resn_exch{"3H9  5DE"}=" H93 5DE";
$resn_exch{"1H6  5DE"}=" H61 5DE"; $resn_exch{"2H6  5DE"}=" H62 5DE"; $resn_exch{"3H6  5DE"}=" H63 5DE";
$resn_exch{"1H14 5DE"}="H141 5DE"; $resn_exch{"2H14 5DE"}="H142 5DE"; $resn_exch{"1H1  5DS"}=" H11 5DS";
$resn_exch{"2H1  5DS"}=" H12 5DS"; $resn_exch{"3H1  5DS"}=" H13 5DS"; $resn_exch{"1H2  5DS"}=" H21 5DS";
$resn_exch{"2H2  5DS"}=" H22 5DS"; $resn_exch{"3H2  5DS"}=" H23 5DS"; $resn_exch{"1HN4 5DS"}="HN41 5DS";
$resn_exch{"2HN4 5DS"}="HN42 5DS"; $resn_exch{"1HN5 5DS"}="HN51 5DS"; $resn_exch{"2HN5 5DS"}="HN52 5DS";
$resn_exch{"1H22 5EA"}="H221 5EA"; $resn_exch{"2H22 5EA"}="H222 5EA"; $resn_exch{"1H24 5EA"}="H241 5EA";
$resn_exch{"2H24 5EA"}="H242 5EA"; $resn_exch{"1H27 5EA"}="H271 5EA"; $resn_exch{"2H27 5EA"}="H272 5EA";
$resn_exch{"1H29 5EA"}="H291 5EA"; $resn_exch{"2H29 5EA"}="H292 5EA"; $resn_exch{"1H30 5EA"}="H301 5EA";
$resn_exch{"2H30 5EA"}="H302 5EA"; $resn_exch{"1H28 5EA"}="H281 5EA"; $resn_exch{"2H28 5EA"}="H282 5EA";
$resn_exch{"1H1  5EE"}=" H11 5EE"; $resn_exch{"2H1  5EE"}=" H12 5EE"; $resn_exch{"1H2* 5F1"}="H2'1 5F1";
$resn_exch{"2H2* 5F1"}="H2'2 5F1"; $resn_exch{" H3* 5F1"}=" H3' 5F1"; $resn_exch{" H4* 5F1"}=" H4' 5F1";
$resn_exch{"1H5* 5F1"}="H5'1 5F1"; $resn_exch{"2H5* 5F1"}="H5'2 5F1"; $resn_exch{" H1* 5F1"}=" H1' 5F1";
$resn_exch{"1H6N 5F1"}="H6N1 5F1"; $resn_exch{"2H6N 5F1"}="H6N2 5F1"; $resn_exch{"1H6  5FA"}=" H61 5FA";
$resn_exch{"2H6  5FA"}=" H62 5FA"; $resn_exch{"1H5* 5FA"}="H5'1 5FA"; $resn_exch{"2H5* 5FA"}="H5'2 5FA";
$resn_exch{" H4* 5FA"}=" H4' 5FA"; $resn_exch{" H3* 5FA"}=" H3' 5FA"; $resn_exch{" H2* 5FA"}=" H2' 5FA";
$resn_exch{"2HO* 5FA"}="HO'2 5FA"; $resn_exch{" H1* 5FA"}=" H1' 5FA"; $resn_exch{"2HOP 5FC"}="HOP2 5FC";
$resn_exch{"1HN4 5FC"}="HN41 5FC"; $resn_exch{"2HN4 5FC"}="HN42 5FC"; $resn_exch{"1H2* 5FC"}=" H2' 5FC";
$resn_exch{"2H2* 5FC"}="H2'' 5FC"; $resn_exch{"1H5* 5FC"}=" H5' 5FC"; $resn_exch{"2H5* 5FC"}="H5'' 5FC";
$resn_exch{" H4* 5FC"}=" H4' 5FC"; $resn_exch{" H1* 5FC"}=" H1' 5FC"; $resn_exch{" H3* 5FC"}=" H3' 5FC";
$resn_exch{"H3T  5FC"}="HO3' 5FC"; $resn_exch{"3HOP 5FC"}="HOP3 5FC"; $resn_exch{" H2* 5FD"}=" H2' 5FD";
$resn_exch{"*H3* 5FD"}="H3'' 5FD"; $resn_exch{" H4* 5FD"}=" H4' 5FD"; $resn_exch{"1H5* 5FD"}="H5'1 5FD";
$resn_exch{"2H5* 5FD"}="H5'2 5FD"; $resn_exch{" H1* 5FD"}=" H1' 5FD"; $resn_exch{"5H5  5FD"}=" H55 5FD";
$resn_exch{"4H4  5FD"}=" H44 5FD"; $resn_exch{"1H2  5FE"}=" H21 5FE"; $resn_exch{"2H2  5FE"}=" H22 5FE";
$resn_exch{"1HA  5FE"}=" HA1 5FE"; $resn_exch{"2HA  5FE"}=" HA2 5FE"; $resn_exch{"3HA  5FE"}=" HA3 5FE";
$resn_exch{"1H29 5FE"}="H291 5FE"; $resn_exch{"2H29 5FE"}="H292 5FE"; $resn_exch{"3H29 5FE"}="H293 5FE";
$resn_exch{"1H10 5FE"}="H101 5FE"; $resn_exch{"2H10 5FE"}="H102 5FE"; $resn_exch{"1H35 5FE"}="H351 5FE";
$resn_exch{"2H35 5FE"}="H352 5FE"; $resn_exch{"3H35 5FE"}="H353 5FE"; $resn_exch{"1H34 5FE"}="H341 5FE";
$resn_exch{"2H34 5FE"}="H342 5FE"; $resn_exch{"3H34 5FE"}="H343 5FE"; $resn_exch{"1H38 5FE"}="H381 5FE";
$resn_exch{"2H38 5FE"}="H382 5FE"; $resn_exch{"3H38 5FE"}="H383 5FE"; $resn_exch{"1H37 5FE"}="H371 5FE";
$resn_exch{"2H37 5FE"}="H372 5FE"; $resn_exch{"3H37 5FE"}="H373 5FE"; $resn_exch{"1H22 5FE"}="H221 5FE";
$resn_exch{"2H22 5FE"}="H222 5FE"; $resn_exch{"1H39 5FE"}="H391 5FE"; $resn_exch{"2H39 5FE"}="H392 5FE";
$resn_exch{"3H39 5FE"}="H393 5FE"; $resn_exch{"1H24 5FE"}="H241 5FE"; $resn_exch{"2H24 5FE"}="H242 5FE";
$resn_exch{"3H24 5FE"}="H243 5FE"; $resn_exch{"1H2  5FP"}=" H21 5FP"; $resn_exch{"2H2  5FP"}=" H22 5FP";
$resn_exch{"1H29 5FP"}="H291 5FP"; $resn_exch{"2H29 5FP"}="H292 5FP"; $resn_exch{"3H29 5FP"}="H293 5FP";
$resn_exch{"1H10 5FP"}="H101 5FP"; $resn_exch{"2H10 5FP"}="H102 5FP"; $resn_exch{"1H35 5FP"}="H351 5FP";
$resn_exch{"2H35 5FP"}="H352 5FP"; $resn_exch{"3H35 5FP"}="H353 5FP"; $resn_exch{"1H34 5FP"}="H341 5FP";
$resn_exch{"2H34 5FP"}="H342 5FP"; $resn_exch{"3H34 5FP"}="H343 5FP"; $resn_exch{"1H38 5FP"}="H381 5FP";
$resn_exch{"2H38 5FP"}="H382 5FP"; $resn_exch{"3H38 5FP"}="H383 5FP"; $resn_exch{"1H37 5FP"}="H371 5FP";
$resn_exch{"2H37 5FP"}="H372 5FP"; $resn_exch{"3H37 5FP"}="H373 5FP"; $resn_exch{"1H22 5FP"}="H221 5FP";
$resn_exch{"2H22 5FP"}="H222 5FP"; $resn_exch{"1H39 5FP"}="H391 5FP"; $resn_exch{"2H39 5FP"}="H392 5FP";
$resn_exch{"3H39 5FP"}="H393 5FP"; $resn_exch{"1H24 5FP"}="H241 5FP"; $resn_exch{"2H24 5FP"}="H242 5FP";
$resn_exch{"3H24 5FP"}="H243 5FP"; $resn_exch{"2HO* 5FU"}="HO'2 5FU"; $resn_exch{" H2* 5FU"}=" H2' 5FU";
$resn_exch{" H1* 5FU"}=" H1' 5FU"; $resn_exch{" H4* 5FU"}=" H4' 5FU"; $resn_exch{"1H5* 5FU"}="H5'1 5FU";
$resn_exch{"2H5* 5FU"}="H5'2 5FU"; $resn_exch{"2HOP 5FU"}="HOP2 5FU"; $resn_exch{"3HOP 5FU"}="HOP3 5FU";
$resn_exch{" H3* 5FU"}=" H3' 5FU"; $resn_exch{"2HOP 5GP"}="HOP2 5GP"; $resn_exch{"3HOP 5GP"}="HOP3 5GP";
$resn_exch{"1H5* 5GP"}="H5'1 5GP"; $resn_exch{"2H5* 5GP"}="H5'2 5GP"; $resn_exch{" H4* 5GP"}=" H4' 5GP";
$resn_exch{" H3* 5GP"}=" H3' 5GP"; $resn_exch{"*HO3 5GP"}="HO3' 5GP"; $resn_exch{" H2* 5GP"}=" H2' 5GP";
$resn_exch{"*HO2 5GP"}="HO2' 5GP"; $resn_exch{" H1* 5GP"}=" H1' 5GP"; $resn_exch{"1HN2 5GP"}="HN21 5GP";
$resn_exch{"2HN2 5GP"}="HN22 5GP"; $resn_exch{"1H1   5H"}=" H11  5H"; $resn_exch{"2H1   5H"}=" H12  5H";
$resn_exch{"1H1  5HA"}=" H11 5HA"; $resn_exch{"2H1  5HA"}="H12A 5HA"; $resn_exch{"1H3  5HA"}="H31A 5HA";
$resn_exch{"2H3  5HA"}="H32A 5HA"; $resn_exch{"1H4  5HA"}=" H41 5HA"; $resn_exch{"2H4  5HA"}=" H42 5HA";
$resn_exch{"1H8  5HA"}=" H81 5HA"; $resn_exch{"2H8  5HA"}=" H82 5HA"; $resn_exch{"1H16 5HA"}="H161 5HA";
$resn_exch{"2H16 5HA"}="H162 5HA"; $resn_exch{"3H16 5HA"}="H163 5HA"; $resn_exch{"1H23 5HA"}="H231 5HA";
$resn_exch{"2H23 5HA"}="H232 5HA"; $resn_exch{"3H23 5HA"}="H233 5HA"; $resn_exch{"1H18 5HA"}="H181 5HA";
$resn_exch{"2H18 5HA"}="H182 5HA"; $resn_exch{"3H18 5HA"}="H183 5HA"; $resn_exch{"1H28 5HG"}="H281 5HG";
$resn_exch{"2H28 5HG"}="H282 5HG"; $resn_exch{"1H24 5HG"}="H241 5HG"; $resn_exch{"2H24 5HG"}="H242 5HG";
$resn_exch{"1H22 5HG"}="H221 5HG"; $resn_exch{"2H22 5HG"}="H222 5HG"; $resn_exch{"1H20 5HG"}="H201 5HG";
$resn_exch{"2H20 5HG"}="H202 5HG"; $resn_exch{"1HB  5HP"}=" HB1 5HP"; $resn_exch{"2HB  5HP"}=" HB2 5HP";
$resn_exch{"1HG  5HP"}=" HG1 5HP"; $resn_exch{"2HG  5HP"}=" HG2 5HP"; $resn_exch{"H5T  5HT"}="HO5' 5HT";
$resn_exch{"1H5* 5HT"}=" H5' 5HT"; $resn_exch{"2H5* 5HT"}="H5'' 5HT"; $resn_exch{" H4* 5HT"}=" H4' 5HT";
$resn_exch{" H3* 5HT"}=" H3' 5HT"; $resn_exch{"H3T  5HT"}="HO3' 5HT"; $resn_exch{"1H2* 5HT"}=" H2' 5HT";
$resn_exch{"2H2* 5HT"}="H2'' 5HT"; $resn_exch{" H1* 5HT"}=" H1' 5HT"; $resn_exch{"1H5M 5HT"}=" H71 5HT";
$resn_exch{"2H5M 5HT"}=" H72 5HT"; $resn_exch{"3H5M 5HT"}=" H73 5HT"; $resn_exch{"1H6  5HT"}=" H61 5HT";
$resn_exch{"2H6  5HT"}=" H62 5HT"; $resn_exch{"1H5* 5HU"}=" H5' 5HU"; $resn_exch{"2H5* 5HU"}="H5'' 5HU";
$resn_exch{"HC4* 5HU"}="HC4' 5HU"; $resn_exch{"HC3* 5HU"}="HC3' 5HU"; $resn_exch{"HO3* 5HU"}="HO3' 5HU";
$resn_exch{"1H2* 5HU"}=" H2' 5HU"; $resn_exch{"2H2* 5HU"}="H2'' 5HU"; $resn_exch{"HC1* 5HU"}="HC1' 5HU";
$resn_exch{"1H5A 5HU"}="H5A1 5HU"; $resn_exch{"2H5A 5HU"}="H5A2 5HU"; $resn_exch{"1HN4 5I5"}="HN41 5I5";
$resn_exch{"2HN4 5I5"}="HN42 5I5"; $resn_exch{"1H11 5I5"}="H111 5I5"; $resn_exch{"2H11 5I5"}="H112 5I5";
$resn_exch{"3H11 5I5"}="H113 5I5"; $resn_exch{"2HO* 5IC"}="HO2' 5IC"; $resn_exch{" H2* 5IC"}=" H2' 5IC";
$resn_exch{" H3* 5IC"}=" H3' 5IC"; $resn_exch{"H3T  5IC"}="HO3' 5IC"; $resn_exch{" H4* 5IC"}=" H4' 5IC";
$resn_exch{" H1* 5IC"}=" H1' 5IC"; $resn_exch{"1H4  5IC"}=" H41 5IC"; $resn_exch{"2H4  5IC"}=" H42 5IC";
$resn_exch{"1H5* 5IC"}=" H5' 5IC"; $resn_exch{"2H5* 5IC"}="H5'' 5IC"; $resn_exch{"3HOP 5IC"}="HOP3 5IC";
$resn_exch{"2HOP 5IC"}="HOP2 5IC"; $resn_exch{"1H5' 5ID"}="H5'1 5ID"; $resn_exch{"2H5' 5ID"}="H5'2 5ID";
$resn_exch{"1H6N 5ID"}="H6N1 5ID"; $resn_exch{"2H6N 5ID"}="H6N2 5ID"; $resn_exch{"1HN3 5IG"}="HN31 5IG";
$resn_exch{"2HN3 5IG"}="HN32 5IG"; $resn_exch{"1HN4 5IG"}="HN41 5IG"; $resn_exch{"2HN4 5IG"}="HN42 5IG";
$resn_exch{"1H6  5IG"}=" H61 5IG"; $resn_exch{"2H6  5IG"}=" H62 5IG"; $resn_exch{"1H16 5IG"}="H161 5IG";
$resn_exch{"2H16 5IG"}="H162 5IG"; $resn_exch{"1H17 5IG"}="H171 5IG"; $resn_exch{"2H17 5IG"}="H172 5IG";
$resn_exch{"1H18 5IG"}="H181 5IG"; $resn_exch{"2H18 5IG"}="H182 5IG"; $resn_exch{"1H19 5IG"}="H191 5IG";
$resn_exch{"2H19 5IG"}="H192 5IG"; $resn_exch{"3H19 5IG"}="H193 5IG"; $resn_exch{"1H21 5IG"}="H211 5IG";
$resn_exch{"2H21 5IG"}="H212 5IG"; $resn_exch{"3H21 5IG"}="H213 5IG"; $resn_exch{"1H20 5IG"}="H201 5IG";
$resn_exch{"2H20 5IG"}="H202 5IG"; $resn_exch{"3H20 5IG"}="H203 5IG"; $resn_exch{"1H5  5IG"}=" H51 5IG";
$resn_exch{"2H5  5IG"}=" H52 5IG"; $resn_exch{"3H5  5IG"}=" H53 5IG"; $resn_exch{"1H1  5IN"}=" H11 5IN";
$resn_exch{"2H1  5IN"}="H12A 5IN"; $resn_exch{"1H3  5IN"}="H31A 5IN"; $resn_exch{"2H3  5IN"}=" H32 5IN";
$resn_exch{"1H10 5IN"}="H101 5IN"; $resn_exch{"2H10 5IN"}="H102 5IN"; $resn_exch{"1H19 5IN"}="H191 5IN";
$resn_exch{"2H19 5IN"}="H192 5IN"; $resn_exch{"1H25 5IN"}="H251 5IN"; $resn_exch{"2H25 5IN"}="H252 5IN";
$resn_exch{"1H34 5IN"}="H341 5IN"; $resn_exch{"2H34 5IN"}="H342 5IN"; $resn_exch{"1HAJ 5IQ"}="HAJ1 5IQ";
$resn_exch{"2HAJ 5IQ"}="HAJ2 5IQ"; $resn_exch{"2HOP 5IT"}="HOP2 5IT"; $resn_exch{"3HOP 5IT"}="HOP3 5IT";
$resn_exch{"1H5* 5IT"}=" H5' 5IT"; $resn_exch{"2H5* 5IT"}="H5'' 5IT"; $resn_exch{" H4* 5IT"}=" H4' 5IT";
$resn_exch{" H3* 5IT"}=" H3' 5IT"; $resn_exch{"*HO3 5IT"}="HO3' 5IT"; $resn_exch{"1H2* 5IT"}=" H2' 5IT";
$resn_exch{"2H2* 5IT"}="H2'' 5IT"; $resn_exch{" H1* 5IT"}=" H1' 5IT"; $resn_exch{" H1* 5IU"}=" H1' 5IU";
$resn_exch{"1H2* 5IU"}=" H2' 5IU"; $resn_exch{"2H2* 5IU"}="H2'' 5IU"; $resn_exch{" H3* 5IU"}=" H3' 5IU";
$resn_exch{" H4* 5IU"}=" H4' 5IU"; $resn_exch{"*HO3 5IU"}="HO3' 5IU"; $resn_exch{"1H5* 5IU"}=" H5' 5IU";
$resn_exch{"2H5* 5IU"}="H5'' 5IU"; $resn_exch{"2HOP 5IU"}="HOP2 5IU"; $resn_exch{"3HOP 5IU"}="HOP3 5IU";
$resn_exch{"1HN3 5MB"}="HN31 5MB"; $resn_exch{"1H2  5MB"}=" H21 5MB"; $resn_exch{"1H4  5MB"}=" H41 5MB";
$resn_exch{"1H6  5MB"}=" H61 5MB"; $resn_exch{"1H7  5MB"}=" H71 5MB"; $resn_exch{"1H8  5MB"}=" H81 5MB";
$resn_exch{"2H8  5MB"}=" H82 5MB"; $resn_exch{"3H8  5MB"}=" H83 5MB"; $resn_exch{"2HOP 5MC"}="HOP2 5MC";
$resn_exch{"3HOP 5MC"}="HOP3 5MC"; $resn_exch{"1H5* 5MC"}=" H5' 5MC"; $resn_exch{"2H5* 5MC"}="H5'' 5MC";
$resn_exch{" H4* 5MC"}=" H4' 5MC"; $resn_exch{" H3* 5MC"}=" H3' 5MC"; $resn_exch{"*HO3 5MC"}="HO3' 5MC";
$resn_exch{" H2* 5MC"}=" H2' 5MC"; $resn_exch{"*HO2 5MC"}="HO2' 5MC"; $resn_exch{" H1* 5MC"}=" H1' 5MC";
$resn_exch{"1HN4 5MC"}="HN41 5MC"; $resn_exch{"2HN4 5MC"}="HN42 5MC"; $resn_exch{"1HM5 5MC"}="HM51 5MC";
$resn_exch{"2HM5 5MC"}="HM52 5MC"; $resn_exch{"3HM5 5MC"}="HM53 5MC"; $resn_exch{" H5* 5MD"}=" H5' 5MD";
$resn_exch{"1H5' 5MD"}="H5'1 5MD"; $resn_exch{"2H5' 5MD"}="H5'2 5MD"; $resn_exch{"1H5  5MD"}=" H51 5MD";
$resn_exch{"2H5  5MD"}=" H52 5MD"; $resn_exch{"3H5  5MD"}=" H53 5MD"; $resn_exch{"H3*  5MD"}="H3'A 5MD";
$resn_exch{"1H2' 5MD"}="H2'1 5MD"; $resn_exch{"2H2' 5MD"}="H2'2 5MD"; $resn_exch{"1HC4 5MP"}="HC41 5MP";
$resn_exch{"2HC4 5MP"}="HC42 5MP"; $resn_exch{"3HC4 5MP"}="HC43 5MP"; $resn_exch{"1HB  5MR"}=" HB1 5MR";
$resn_exch{"2HB  5MR"}=" HB2 5MR"; $resn_exch{"1HAA 5MR"}="HAA1 5MR"; $resn_exch{"2HAA 5MR"}="HAA2 5MR";
$resn_exch{"1HAX 5MR"}="HAX1 5MR"; $resn_exch{"2HAX 5MR"}="HAX2 5MR"; $resn_exch{"1HAV 5MR"}="HAV1 5MR";
$resn_exch{"2HAV 5MR"}="HAV2 5MR"; $resn_exch{"1H5M 5MU"}=" H71 5MU"; $resn_exch{"2H5M 5MU"}=" H72 5MU";
$resn_exch{"3H5M 5MU"}=" H73 5MU"; $resn_exch{" H1* 5MU"}=" H1' 5MU"; $resn_exch{" H2* 5MU"}=" H2' 5MU";
$resn_exch{"*HO2 5MU"}="HO2' 5MU"; $resn_exch{" H3* 5MU"}=" H3' 5MU"; $resn_exch{" H4* 5MU"}=" H4' 5MU";
$resn_exch{"*HO3 5MU"}="HO3' 5MU"; $resn_exch{"1H5* 5MU"}=" H5' 5MU"; $resn_exch{"2H5* 5MU"}="H5'' 5MU";
$resn_exch{"2HOP 5MU"}="HOP2 5MU"; $resn_exch{"3HOP 5MU"}="HOP3 5MU"; $resn_exch{"2HOP 5NC"}="HOP2 5NC";
$resn_exch{"3HOP 5NC"}="HOP3 5NC"; $resn_exch{"1H5* 5NC"}=" H5' 5NC"; $resn_exch{"2H5* 5NC"}="H5'' 5NC";
$resn_exch{" H4* 5NC"}=" H4' 5NC"; $resn_exch{" H3* 5NC"}=" H3' 5NC"; $resn_exch{"3HO* 5NC"}="HO'3 5NC";
$resn_exch{"1H2* 5NC"}=" H2' 5NC"; $resn_exch{"2H2* 5NC"}="H2'' 5NC"; $resn_exch{"1H1* 5NC"}="H1'1 5NC";
$resn_exch{"1HN4 5NC"}="HN41 5NC"; $resn_exch{"2HN4 5NC"}="HN42 5NC"; $resn_exch{"1H5  5NH"}=" H51 5NH";
$resn_exch{"2H5  5NH"}=" H52 5NH"; $resn_exch{"3H5  5NH"}=" H53 5NH"; $resn_exch{"1H6  5NH"}=" H61 5NH";
$resn_exch{"2H6  5NH"}=" H62 5NH"; $resn_exch{"3H6  5NH"}=" H63 5NH"; $resn_exch{"1H7  5NH"}=" H71 5NH";
$resn_exch{"2H7  5NH"}=" H72 5NH"; $resn_exch{"3H7  5NH"}=" H73 5NH"; $resn_exch{"1H11 5NH"}="H111 5NH";
$resn_exch{"2H11 5NH"}="H112 5NH"; $resn_exch{"1H12 5NH"}="H121 5NH"; $resn_exch{"2H12 5NH"}="H122 5NH";
$resn_exch{"1H13 5NH"}="H131 5NH"; $resn_exch{"2H13 5NH"}="H132 5NH"; $resn_exch{"1H14 5NH"}="H141 5NH";
$resn_exch{"2H14 5NH"}="H142 5NH"; $resn_exch{"1H15 5NH"}="H151 5NH"; $resn_exch{"2H15 5NH"}="H152 5NH";
$resn_exch{"1H23 5NH"}="H231 5NH"; $resn_exch{"2H23 5NH"}="H232 5NH"; $resn_exch{"1H24 5NH"}="H241 5NH";
$resn_exch{"2H24 5NH"}="H242 5NH"; $resn_exch{"1H26 5NH"}="H261 5NH"; $resn_exch{"2H26 5NH"}="H262 5NH";
$resn_exch{"1H29 5NH"}="H291 5NH"; $resn_exch{"2H29 5NH"}="H292 5NH"; $resn_exch{"1H30 5NH"}="H301 5NH";
$resn_exch{"2H30 5NH"}="H302 5NH"; $resn_exch{"1H31 5NH"}="H311 5NH"; $resn_exch{"2H31 5NH"}="H312 5NH";
$resn_exch{"1H32 5NH"}="H321 5NH"; $resn_exch{"2H32 5NH"}="H322 5NH"; $resn_exch{"3H32 5NH"}="H323 5NH";
$resn_exch{"1H37 5NH"}="H371 5NH"; $resn_exch{"2H37 5NH"}="H372 5NH"; $resn_exch{"1H52 5NH"}="H521 5NH";
$resn_exch{"2H52 5NH"}="H522 5NH"; $resn_exch{"3H52 5NH"}="H523 5NH"; $resn_exch{"1H53 5NH"}="H531 5NH";
$resn_exch{"2H53 5NH"}="H532 5NH"; $resn_exch{"3H53 5NH"}="H533 5NH"; $resn_exch{"1H6  5NI"}=" H61 5NI";
$resn_exch{"1H7  5NI"}=" H71 5NI"; $resn_exch{"1H4  5NI"}=" H41 5NI"; $resn_exch{"1HN1 5NI"}="HN11 5NI";
$resn_exch{"1H3  5NI"}=" H31 5NI"; $resn_exch{"1NH3 5OB"}="H31N 5OB"; $resn_exch{"1H2  5OB"}=" H21 5OB";
$resn_exch{"1H4  5OB"}=" H41 5OB"; $resn_exch{"1H6  5OB"}=" H61 5OB"; $resn_exch{"1H7  5OB"}=" H71 5OB";
$resn_exch{"1H11 5OB"}="H111 5OB"; $resn_exch{"2H11 5OB"}="H112 5OB"; $resn_exch{"3H11 5OB"}="H113 5OB";
$resn_exch{"1H1  5OP"}=" H11 5OP"; $resn_exch{"2H1  5OP"}=" H12 5OP"; $resn_exch{"3H1  5OP"}="H13A 5OP";
$resn_exch{"1H2  5OP"}=" H21 5OP"; $resn_exch{"2H2  5OP"}=" H22 5OP"; $resn_exch{"1H3  5OP"}=" H31 5OP";
$resn_exch{"2H3  5OP"}=" H32 5OP"; $resn_exch{"1H4  5OP"}=" H41 5OP"; $resn_exch{"2H4  5OP"}=" H42 5OP";
$resn_exch{"1H5  5OP"}=" H51 5OP"; $resn_exch{"2H5  5OP"}=" H52 5OP"; $resn_exch{"1H11 5OP"}="H111 5OP";
$resn_exch{"2H11 5OP"}="H112 5OP"; $resn_exch{"1H14 5OP"}="H141 5OP"; $resn_exch{"2H14 5OP"}="H142 5OP";
$resn_exch{"1H17 5OP"}="H171 5OP"; $resn_exch{"2H17 5OP"}="H172 5OP"; $resn_exch{"1H18 5OP"}="H181 5OP";
$resn_exch{"2H18 5OP"}="H182 5OP"; $resn_exch{"1H19 5OP"}="H191 5OP"; $resn_exch{"2H19 5OP"}="H192 5OP";
$resn_exch{"1H4A 5PA"}="H4A1 5PA"; $resn_exch{"2H4A 5PA"}="H4A2 5PA"; $resn_exch{"2HOP 5PA"}="HOP2 5PA";
$resn_exch{"3HOP 5PA"}="HOP3 5PA"; $resn_exch{"1H5A 5PA"}="H5A1 5PA"; $resn_exch{"2H5A 5PA"}="H5A2 5PA";
$resn_exch{"1H2A 5PA"}="H2A1 5PA"; $resn_exch{"2H2A 5PA"}="H2A2 5PA"; $resn_exch{"3H2A 5PA"}="H2A3 5PA";
$resn_exch{"1H9  5PA"}=" H91 5PA"; $resn_exch{"2H9  5PA"}=" H92 5PA"; $resn_exch{"1H10 5PA"}="H101 5PA";
$resn_exch{"2H10 5PA"}="H102 5PA"; $resn_exch{"3HOP 5PC"}="HOP3 5PC"; $resn_exch{"2HOP 5PC"}="HOP2 5PC";
$resn_exch{"1H5* 5PC"}=" H5' 5PC"; $resn_exch{"2H5* 5PC"}="H5'' 5PC"; $resn_exch{" H4* 5PC"}=" H4' 5PC";
$resn_exch{" H3* 5PC"}=" H3' 5PC"; $resn_exch{"H3T  5PC"}="HO3' 5PC"; $resn_exch{"1H2* 5PC"}=" H2' 5PC";
$resn_exch{"2H2* 5PC"}="H2'' 5PC"; $resn_exch{" H1* 5PC"}=" H1' 5PC"; $resn_exch{"1H25 5PH"}="H251 5PH";
$resn_exch{"2H25 5PH"}="H252 5PH"; $resn_exch{"1H36 5PH"}="H361 5PH"; $resn_exch{"2H36 5PH"}="H362 5PH";
$resn_exch{"3H36 5PH"}="H363 5PH"; $resn_exch{"1H4  5PH"}=" H41 5PH"; $resn_exch{"2H4  5PH"}=" H42 5PH";
$resn_exch{"1H1  5PH"}=" H11 5PH"; $resn_exch{"2H1  5PH"}=" H12 5PH"; $resn_exch{"1H12 5PH"}="H121 5PH";
$resn_exch{"2H12 5PH"}="H122 5PH"; $resn_exch{"1H8  5PH"}=" H81 5PH"; $resn_exch{"2H8  5PH"}=" H82 5PH";
$resn_exch{"1H18 5PI"}="H181 5PI"; $resn_exch{"2H18 5PI"}="H182 5PI"; $resn_exch{"1H19 5PI"}="H191 5PI";
$resn_exch{"2H19 5PI"}="H192 5PI"; $resn_exch{"1H21 5PI"}="H211 5PI"; $resn_exch{"2H21 5PI"}="H212 5PI";
$resn_exch{"1HN1 5PI"}="HN11 5PI"; $resn_exch{"2HN1 5PI"}="HN12 5PI"; $resn_exch{"1HN3 5PI"}="HN31 5PI";
$resn_exch{"2HN3 5PI"}="HN32 5PI"; $resn_exch{"1H1  5PI"}=" H11 5PI"; $resn_exch{"2H1  5PI"}="H12A 5PI";
$resn_exch{"1H9  5PI"}=" H91 5PI"; $resn_exch{"2H9  5PI"}=" H92 5PI"; $resn_exch{"1H8  5PI"}=" H81 5PI";
$resn_exch{"2H8  5PI"}=" H82 5PI"; $resn_exch{"3H8  5PI"}=" H83 5PI"; $resn_exch{"1H7  5PI"}=" H71 5PI";
$resn_exch{"2H7  5PI"}=" H72 5PI"; $resn_exch{"1H10 5PI"}="H101 5PI"; $resn_exch{"2H10 5PI"}="H102 5PI";
$resn_exch{"1H11 5PI"}="H111 5PI"; $resn_exch{"2H11 5PI"}="H112 5PI"; $resn_exch{"3H11 5PI"}="H113 5PI";
$resn_exch{"1H14 5PP"}="H141 5PP"; $resn_exch{"2H14 5PP"}="H142 5PP"; $resn_exch{"1H15 5PP"}="H151 5PP";
$resn_exch{"2H15 5PP"}="H152 5PP"; $resn_exch{"1H16 5PP"}="H161 5PP"; $resn_exch{"2H16 5PP"}="H162 5PP";
$resn_exch{"1H17 5PP"}="H171 5PP"; $resn_exch{"2H17 5PP"}="H172 5PP"; $resn_exch{"1H18 5PP"}="H181 5PP";
$resn_exch{"2H18 5PP"}="H182 5PP"; $resn_exch{"3H18 5PP"}="H183 5PP"; $resn_exch{"1H7  5PV"}=" H71 5PV";
$resn_exch{"2H7  5PV"}=" H72 5PV"; $resn_exch{"1H8  5PV"}=" H81 5PV"; $resn_exch{"2H8  5PV"}=" H82 5PV";
$resn_exch{"1H9  5PV"}=" H91 5PV"; $resn_exch{"2H9  5PV"}=" H92 5PV"; $resn_exch{"1H10 5PV"}="H101 5PV";
$resn_exch{"2H10 5PV"}="H102 5PV"; $resn_exch{"1H5M 5PY"}=" H71 5PY"; $resn_exch{"2H5M 5PY"}=" H72 5PY";
$resn_exch{"3H5M 5PY"}=" H73 5PY"; $resn_exch{" H1* 5PY"}=" H1' 5PY"; $resn_exch{"1H2* 5PY"}=" H2' 5PY";
$resn_exch{"2H2* 5PY"}="H2'' 5PY"; $resn_exch{" H3* 5PY"}=" H3' 5PY"; $resn_exch{"H3T  5PY"}="HO3' 5PY";
$resn_exch{" H4* 5PY"}=" H4' 5PY"; $resn_exch{"1H5* 5PY"}=" H5' 5PY"; $resn_exch{"2H5* 5PY"}="H5'' 5PY";
$resn_exch{"2HOP 5PY"}="HOP2 5PY"; $resn_exch{"3HOP 5PY"}="HOP3 5PY"; $resn_exch{"1HN1 5QC"}="HN11 5QC";
$resn_exch{"2HN1 5QC"}="HN12 5QC"; $resn_exch{"1H11 5QC"}="H111 5QC"; $resn_exch{"2H11 5QC"}="H112 5QC";
$resn_exch{"1H20 5QC"}="H201 5QC"; $resn_exch{"2H20 5QC"}="H202 5QC"; $resn_exch{"1H23 5QC"}="H231 5QC";
$resn_exch{"2H23 5QC"}="H232 5QC"; $resn_exch{"1H28 5QC"}="H281 5QC"; $resn_exch{"2H28 5QC"}="H282 5QC";
$resn_exch{"1H29 5QC"}="H291 5QC"; $resn_exch{"2H29 5QC"}="H292 5QC"; $resn_exch{"1H31 5QC"}="H311 5QC";
$resn_exch{"2H31 5QC"}="H312 5QC"; $resn_exch{"1H18 5RM"}="H181 5RM"; $resn_exch{"2H18 5RM"}="H182 5RM";
$resn_exch{"3H18 5RM"}="H183 5RM"; $resn_exch{"1H11 5RM"}="H111 5RM"; $resn_exch{"2H11 5RM"}="H112 5RM";
$resn_exch{"3H11 5RM"}="H113 5RM"; $resn_exch{"1H14 5RM"}="H141 5RM"; $resn_exch{"2H14 5RM"}="H142 5RM";
$resn_exch{"1H15 5RM"}="H151 5RM"; $resn_exch{"2H15 5RM"}="H152 5RM"; $resn_exch{"1H16 5RM"}="H161 5RM";
$resn_exch{"2H16 5RM"}="H162 5RM"; $resn_exch{"3H16 5RM"}="H163 5RM"; $resn_exch{"1H2  5RP"}=" H21 5RP";
$resn_exch{"2H2  5RP"}=" H22 5RP"; $resn_exch{"1H7  5RP"}=" H71 5RP"; $resn_exch{"2H7  5RP"}=" H72 5RP";
$resn_exch{"1HR6 5SA"}="HR61 5SA"; $resn_exch{"2HR6 5SA"}="HR62 5SA"; $resn_exch{"1HV6 5SA"}="HV61 5SA";
$resn_exch{"2HV6 5SA"}="HV62 5SA"; $resn_exch{"3HV6 5SA"}="HV63 5SA"; $resn_exch{"1HQ6 5SA"}="HQ61 5SA";
$resn_exch{"2HQ6 5SA"}="HQ62 5SA"; $resn_exch{"1HW6 5SA"}="HW61 5SA"; $resn_exch{"2HW6 5SA"}="HW62 5SA";
$resn_exch{"1HY7 5SA"}="HY71 5SA"; $resn_exch{"2HY7 5SA"}="HY72 5SA"; $resn_exch{"1H12 5SC"}="H121 5SC";
$resn_exch{"2H12 5SC"}="H122 5SC"; $resn_exch{"1H25 5SC"}="H251 5SC"; $resn_exch{"2H25 5SC"}="H252 5SC";
$resn_exch{"3H25 5SC"}="H253 5SC"; $resn_exch{"1H1C 5SD"}="H1C1 5SD"; $resn_exch{"2H1C 5SD"}="H1C2 5SD";
$resn_exch{"1H2C 5SD"}="H2C1 5SD"; $resn_exch{"2H2C 5SD"}="H2C2 5SD"; $resn_exch{"1H4C 5SD"}="H4C1 5SD";
$resn_exch{"2H4C 5SD"}="H4C2 5SD"; $resn_exch{"1H6C 5SD"}="H6C1 5SD"; $resn_exch{"2H6C 5SD"}="H6C2 5SD";
$resn_exch{"1H7C 5SD"}="H7C1 5SD"; $resn_exch{"2H7C 5SD"}="H7C2 5SD"; $resn_exch{"1H11 5SD"}="H111 5SD";
$resn_exch{"2H11 5SD"}="H112 5SD"; $resn_exch{"1H12 5SD"}="H121 5SD"; $resn_exch{"2H12 5SD"}="H122 5SD";
$resn_exch{"1H15 5SD"}="H151 5SD"; $resn_exch{"2H15 5SD"}="H152 5SD"; $resn_exch{"1H16 5SD"}="H161 5SD";
$resn_exch{"2H16 5SD"}="H162 5SD"; $resn_exch{"1H18 5SD"}="H181 5SD"; $resn_exch{"2H18 5SD"}="H182 5SD";
$resn_exch{"3H18 5SD"}="H183 5SD"; $resn_exch{"1H19 5SD"}="H191 5SD"; $resn_exch{"2H19 5SD"}="H192 5SD";
$resn_exch{"3H19 5SD"}="H193 5SD"; $resn_exch{"1HAQ 5TN"}="HAQ1 5TN"; $resn_exch{"2HAQ 5TN"}="HAQ2 5TN";
$resn_exch{"1HAP 5TN"}="HAP1 5TN"; $resn_exch{"2HAP 5TN"}="HAP2 5TN"; $resn_exch{"1HAA 5TN"}="HAA1 5TN";
$resn_exch{"2HAA 5TN"}="HAA2 5TN"; $resn_exch{"3HAA 5TN"}="HAA3 5TN"; $resn_exch{"1HAB 5TN"}="HAB1 5TN";
$resn_exch{"2HAB 5TN"}="HAB2 5TN"; $resn_exch{"3HAB 5TN"}="HAB3 5TN"; $resn_exch{"1HAC 5TN"}="HAC1 5TN";
$resn_exch{"2HAC 5TN"}="HAC2 5TN"; $resn_exch{"3HAC 5TN"}="HAC3 5TN"; $resn_exch{"1HAR 5TN"}="HAR1 5TN";
$resn_exch{"2HAR 5TN"}="HAR2 5TN"; $resn_exch{"1HAS 5TN"}="HAS1 5TN"; $resn_exch{"2HAS 5TN"}="HAS2 5TN";
$resn_exch{"1HAD 5TN"}="HAD1 5TN"; $resn_exch{"2HAD 5TN"}="HAD2 5TN"; $resn_exch{"3HAD 5TN"}="HAD3 5TN";
$resn_exch{"1HAE 5TN"}="HAE1 5TN"; $resn_exch{"2HAE 5TN"}="HAE2 5TN"; $resn_exch{"3HAE 5TN"}="HAE3 5TN";
$resn_exch{" H1* 5UD"}=" H1' 5UD"; $resn_exch{" H2* 5UD"}=" H2' 5UD"; $resn_exch{"*HO2 5UD"}="HO2' 5UD";
$resn_exch{" H3* 5UD"}=" H3' 5UD"; $resn_exch{"*HO3 5UD"}="HO3' 5UD"; $resn_exch{" H4* 5UD"}=" H4' 5UD";
$resn_exch{"1H5* 5UD"}="H5'1 5UD"; $resn_exch{"2H5* 5UD"}="H5'2 5UD"; $resn_exch{"*HO5 5UD"}="HO5' 5UD";
$resn_exch{"1H1   5X"}="H11A  5X"; $resn_exch{"2H1   5X"}=" H12  5X"; $resn_exch{"1H4   5X"}=" H41  5X";
$resn_exch{"2H4   5X"}=" H42  5X"; $resn_exch{"3H4   5X"}=" H43  5X"; $resn_exch{"3HOP 5YL"}="HOP3 5YL";
$resn_exch{"2HOP 5YL"}="HOP2 5YL"; $resn_exch{"1H17 5YL"}="H171 5YL"; $resn_exch{"2H17 5YL"}="H172 5YL";
$resn_exch{"1H16 5YL"}="H161 5YL"; $resn_exch{"2H16 5YL"}="H162 5YL"; $resn_exch{"1H15 5YL"}="H151 5YL";
$resn_exch{"2H15 5YL"}="H152 5YL"; $resn_exch{"1H14 5YL"}="H141 5YL"; $resn_exch{"2H14 5YL"}="H142 5YL";
$resn_exch{"1H13 5YL"}="H131 5YL"; $resn_exch{"2H13 5YL"}="H132 5YL"; $resn_exch{"1H8  5YL"}=" H81 5YL";
$resn_exch{"2H8  5YL"}=" H82 5YL"; $resn_exch{"1H9  5YL"}=" H91 5YL"; $resn_exch{"1H10 5YL"}="H101 5YL";
$resn_exch{"OH10 5YL"}="H10O 5YL"; $resn_exch{"1H11 5YL"}="H111 5YL"; $resn_exch{"OH11 5YL"}="H11O 5YL";
$resn_exch{"1H12 5YL"}="H121 5YL"; $resn_exch{"2H12 5YL"}="H122 5YL"; $resn_exch{"OH12 5YL"}="H12O 5YL";
$resn_exch{"1H17 5Z5"}="H171 5Z5"; $resn_exch{"2H17 5Z5"}="H172 5Z5"; $resn_exch{"3H17 5Z5"}="H173 5Z5";
$resn_exch{"1H14 5Z5"}="H141 5Z5"; $resn_exch{"2H14 5Z5"}="H142 5Z5"; $resn_exch{"3H14 5Z5"}="H143 5Z5";
$resn_exch{"1H15 5Z5"}="H151 5Z5"; $resn_exch{"2H15 5Z5"}="H152 5Z5"; $resn_exch{"3H15 5Z5"}="H153 5Z5";
$resn_exch{"1H25 5ZA"}="H251 5ZA"; $resn_exch{"2H25 5ZA"}="H252 5ZA"; $resn_exch{"3H25 5ZA"}="H253 5ZA";
$resn_exch{"1H26 5ZA"}="H261 5ZA"; $resn_exch{"2H26 5ZA"}="H262 5ZA"; $resn_exch{"1H10 5ZA"}="H101 5ZA";
$resn_exch{"2H10 5ZA"}="H102 5ZA"; $resn_exch{"1H18 5ZA"}="H181 5ZA"; $resn_exch{"2H18 5ZA"}="H182 5ZA";
$resn_exch{"1H19 5ZA"}="H191 5ZA"; $resn_exch{"2H19 5ZA"}="H192 5ZA"; $resn_exch{"1H32 600"}="H321 600";
$resn_exch{"2H32 600"}="H322 600"; $resn_exch{"1H35 600"}="H351 600"; $resn_exch{"2H35 600"}="H352 600";
$resn_exch{"1H76 600"}="H761 600"; $resn_exch{"2H76 600"}="H762 600"; $resn_exch{"3H76 600"}="H763 600";
$resn_exch{"1H72 600"}="H721 600"; $resn_exch{"2H72 600"}="H722 600"; $resn_exch{"1H74 600"}="H741 600";
$resn_exch{"2H74 600"}="H742 600"; $resn_exch{"3H74 600"}="H743 600"; $resn_exch{"1H75 600"}="H751 600";
$resn_exch{"2H75 600"}="H752 600"; $resn_exch{"3H75 600"}="H753 600"; $resn_exch{"1H27 606"}="H271 606";
$resn_exch{"2H27 606"}="H272 606"; $resn_exch{"1H26 606"}="H261 606"; $resn_exch{"2H26 606"}="H262 606";
$resn_exch{"1H25 606"}="H251 606"; $resn_exch{"2H25 606"}="H252 606"; $resn_exch{"1H23 606"}="H231 606";
$resn_exch{"2H23 606"}="H232 606"; $resn_exch{"1H12 606"}="H121 606"; $resn_exch{"2H12 606"}="H122 606";
$resn_exch{"H3'' 607"}=" H3B 607"; $resn_exch{"H4'' 607"}=" H4B 607"; $resn_exch{"H5'' 607"}=" H5B 607";
$resn_exch{"H6'' 607"}=" H6B 607"; $resn_exch{"1H7  608"}=" H71 608"; $resn_exch{"2H7  608"}=" H72 608";
$resn_exch{"1H2  612"}=" H21 612"; $resn_exch{"1H3  612"}=" H31 612"; $resn_exch{"1H4  612"}=" H41 612";
$resn_exch{"1H5  612"}=" H51 612"; $resn_exch{"1H6  612"}=" H61 612"; $resn_exch{"1HF  612"}=" HF1 612";
$resn_exch{"1HH  612"}=" HH1 612"; $resn_exch{"2HH  612"}=" HH2 612"; $resn_exch{"3HH  612"}=" HH3 612";
$resn_exch{"1HI  612"}=" HI1 612"; $resn_exch{"2HI  612"}=" HI2 612"; $resn_exch{"3HI  612"}=" HI3 612";
$resn_exch{"1HN  612"}=" HN1 612"; $resn_exch{"1HA  612"}=" HA1 612"; $resn_exch{"2HA  612"}=" HA2 612";
$resn_exch{"1HC  612"}=" HC1 612"; $resn_exch{"2HC  612"}=" HC2 612"; $resn_exch{"1HD  612"}=" HD1 612";
$resn_exch{"2HD  612"}=" HD2 612"; $resn_exch{"3HD  612"}=" HD3 612"; $resn_exch{"CH30 616"}="H30C 616";
$resn_exch{"CH27 616"}="H27C 616"; $resn_exch{"1H17 616"}="H171 616"; $resn_exch{"2H17 616"}="H172 616";
$resn_exch{"3H17 616"}="H173 616"; $resn_exch{"1HC1 616"}="HC11 616"; $resn_exch{"2HC1 616"}="HC12 616";
$resn_exch{"3HC1 616"}="HC13 616"; $resn_exch{"CH29 616"}="H29C 616"; $resn_exch{"1HC3 616"}="HC31 616";
$resn_exch{"2HC3 616"}="HC32 616"; $resn_exch{"3HC3 616"}="HC33 616"; $resn_exch{"1H28 616"}="H281 616";
$resn_exch{"2H28 616"}="H282 616"; $resn_exch{"1H26 616"}="H261 616"; $resn_exch{"2H26 616"}="H262 616";
$resn_exch{"1HC6 616"}="HC61 616"; $resn_exch{"2HC6 616"}="HC62 616"; $resn_exch{"1H50 616"}="H501 616";
$resn_exch{"2H50 616"}="H502 616"; $resn_exch{"1H45 616"}="H451 616"; $resn_exch{"2H45 616"}="H452 616";
$resn_exch{"1H46 616"}="H461 616"; $resn_exch{"2H46 616"}="H462 616"; $resn_exch{"1H47 616"}="H471 616";
$resn_exch{"2H47 616"}="H472 616"; $resn_exch{"1H48 616"}="H481 616"; $resn_exch{"2H48 616"}="H482 616";
$resn_exch{"1H9  617"}=" H91 617"; $resn_exch{"2H9  617"}=" H92 617"; $resn_exch{"1H1  618"}="H11A 618";
$resn_exch{"2H1  618"}=" H12 618"; $resn_exch{"3H1  618"}="H13A 618"; $resn_exch{"1H4  618"}=" H41 618";
$resn_exch{"2H4  618"}=" H42 618"; $resn_exch{"3H4  618"}=" H43 618"; $resn_exch{"1H12 618"}="H121 618";
$resn_exch{"2H12 618"}="H122 618"; $resn_exch{"1H19 618"}="H191 618"; $resn_exch{"2H19 618"}="H192 618";
$resn_exch{"3H19 618"}="H193 618"; $resn_exch{"1H20 618"}="H201 618"; $resn_exch{"2H20 618"}="H202 618";
$resn_exch{"3H20 618"}="H203 618"; $resn_exch{"1H29 618"}="H291 618"; $resn_exch{"2H29 618"}="H292 618";
$resn_exch{"3H29 618"}="H293 618"; $resn_exch{"1H5  623"}=" H51 623"; $resn_exch{"2H5  623"}=" H52 623";
$resn_exch{"3H5  623"}=" H53 623"; $resn_exch{"1H22 623"}="H221 623"; $resn_exch{"2H22 623"}="H222 623";
$resn_exch{"1H12 623"}="H121 623"; $resn_exch{"2H12 623"}="H122 623"; $resn_exch{"1H06 624"}="H061 624";
$resn_exch{"2H06 624"}="H062 624"; $resn_exch{"1H07 624"}="H071 624"; $resn_exch{"2H07 624"}="H072 624";
$resn_exch{"1H08 624"}="H081 624"; $resn_exch{"2H08 624"}="H082 624"; $resn_exch{"1H11 624"}="H111 624";
$resn_exch{"2H11 624"}="H112 624"; $resn_exch{"1H20 624"}="H201 624"; $resn_exch{"2H20 624"}="H202 624";
$resn_exch{"1H31 624"}="H311 624"; $resn_exch{"2H31 624"}="H312 624"; $resn_exch{"3H31 624"}="H313 624";
$resn_exch{"1H32 624"}="H321 624"; $resn_exch{"2H32 624"}="H322 624"; $resn_exch{"3H32 624"}="H323 624";
$resn_exch{"1H32 626"}="H321 626"; $resn_exch{"2H32 626"}="H322 626"; $resn_exch{"1H20 626"}="H201 626";
$resn_exch{"2H20 626"}="H202 626"; $resn_exch{"1H24 626"}="H241 626"; $resn_exch{"2H24 626"}="H242 626";
$resn_exch{"1H21 626"}="H211 626"; $resn_exch{"2H21 626"}="H212 626"; $resn_exch{"1H23 626"}="H231 626";
$resn_exch{"2H23 626"}="H232 626"; $resn_exch{"1H25 626"}="H251 626"; $resn_exch{"2H25 626"}="H252 626";
$resn_exch{"3H25 626"}="H253 626"; $resn_exch{"1H18 627"}="H181 627"; $resn_exch{"2H18 627"}="H182 627";
$resn_exch{"1H22 627"}="H221 627"; $resn_exch{"2H22 627"}="H222 627"; $resn_exch{"1H19 627"}="H191 627";
$resn_exch{"2H19 627"}="H192 627"; $resn_exch{"1H21 627"}="H211 627"; $resn_exch{"2H21 627"}="H212 627";
$resn_exch{"1H23 627"}="H231 627"; $resn_exch{"2H23 627"}="H232 627"; $resn_exch{"3H23 627"}="H233 627";
$resn_exch{"1H36 627"}="H361 627"; $resn_exch{"2H36 627"}="H362 627"; $resn_exch{"3H36 627"}="H363 627";
$resn_exch{"1HN1 628"}="HN11 628"; $resn_exch{"2HN1 628"}="HN12 628"; $resn_exch{"1H14 629"}="H141 629";
$resn_exch{"2H14 629"}="H142 629"; $resn_exch{"1H16 629"}="H161 629"; $resn_exch{"2H16 629"}="H162 629";
$resn_exch{"1H4  629"}=" H41 629"; $resn_exch{"2H4  629"}=" H42 629"; $resn_exch{"1H30 629"}="H301 629";
$resn_exch{"2H30 629"}="H302 629"; $resn_exch{"1H2  62A"}="H21A 62A"; $resn_exch{"2H2  62A"}="H22A 62A";
$resn_exch{"1H3  62A"}=" H31 62A"; $resn_exch{"2H3  62A"}=" H32 62A"; $resn_exch{"1H4  62A"}=" H41 62A";
$resn_exch{"2H4  62A"}=" H42 62A"; $resn_exch{"1HN7 62A"}="HN71 62A"; $resn_exch{"2HN7 62A"}="HN72 62A";
$resn_exch{"1H11 62A"}="H111 62A"; $resn_exch{"2H11 62A"}="H112 62A"; $resn_exch{"1H18 62A"}="H181 62A";
$resn_exch{"2H18 62A"}="H182 62A"; $resn_exch{"1H25 62A"}="H251 62A"; $resn_exch{"2H25 62A"}="H252 62A";
$resn_exch{"3H25 62A"}="H253 62A"; $resn_exch{"1H20 62P"}="H201 62P"; $resn_exch{"2H20 62P"}="H202 62P";
$resn_exch{"3H20 62P"}="H203 62P"; $resn_exch{"1H6  632"}=" H61 632"; $resn_exch{"2H6  632"}=" H62 632";
$resn_exch{"1H7  632"}=" H71 632"; $resn_exch{"2H7  632"}=" H72 632"; $resn_exch{"1H8  632"}=" H81 632";
$resn_exch{"2H8  632"}=" H82 632"; $resn_exch{"1H11 632"}="H111 632"; $resn_exch{"2H11 632"}="H112 632";
$resn_exch{"1H15 632"}="H151 632"; $resn_exch{"2H15 632"}="H152 632"; $resn_exch{"1H22 632"}="H221 632";
$resn_exch{"2H22 632"}="H222 632"; $resn_exch{"1H32 632"}="H321 632"; $resn_exch{"2H32 632"}="H322 632";
$resn_exch{"3H32 632"}="H323 632"; $resn_exch{"1H2  638"}="H21A 638"; $resn_exch{"2H2  638"}=" H22 638";
$resn_exch{"1H7  638"}="H71A 638"; $resn_exch{"2H7  638"}=" H72 638"; $resn_exch{"1H31 638"}="H311 638";
$resn_exch{"2H31 638"}="H312 638"; $resn_exch{"1H61 638"}="H611 638"; $resn_exch{"2H61 638"}="H612 638";
$resn_exch{"1H10 641"}="H101 641"; $resn_exch{"2H10 641"}="H102 641"; $resn_exch{"1H8  641"}=" H81 641";
$resn_exch{"2H8  641"}=" H82 641"; $resn_exch{"1H4  641"}=" H41 641"; $resn_exch{"2H4  641"}=" H42 641";
$resn_exch{"1H5  641"}=" H51 641"; $resn_exch{"2H5  641"}=" H52 641"; $resn_exch{"1H6  641"}=" H61 641";
$resn_exch{"2H6  641"}=" H62 641"; $resn_exch{"1H10 645"}="H101 645"; $resn_exch{"2H10 645"}="H102 645";
$resn_exch{"3H10 645"}="H103 645"; $resn_exch{"1H13 645"}="H131 645"; $resn_exch{"2H13 645"}="H132 645";
$resn_exch{"3H13 645"}="H133 645"; $resn_exch{"1H14 645"}="H141 645"; $resn_exch{"2H14 645"}="H142 645";
$resn_exch{"3H14 645"}="H143 645"; $resn_exch{"1H15 645"}="H151 645"; $resn_exch{"2H15 645"}="H152 645";
$resn_exch{"3H15 645"}="H153 645"; $resn_exch{"2HOP 64T"}="HOP2 64T"; $resn_exch{"1H5* 64T"}=" H5' 64T";
$resn_exch{"2H5* 64T"}="H5'' 64T"; $resn_exch{" H4* 64T"}=" H4' 64T"; $resn_exch{" H3* 64T"}=" H3' 64T";
$resn_exch{"H3T  64T"}="HO3' 64T"; $resn_exch{"1H2* 64T"}=" H2' 64T"; $resn_exch{"2H2* 64T"}="H2'' 64T";
$resn_exch{" H1* 64T"}=" H1' 64T"; $resn_exch{"1H5M 64T"}=" H71 64T"; $resn_exch{"2H5M 64T"}=" H72 64T";
$resn_exch{"3H5M 64T"}=" H73 64T"; $resn_exch{"1H6  64T"}=" H61 64T"; $resn_exch{"2H6  64T"}=" H62 64T";
$resn_exch{"3HOP 64T"}="HOP3 64T"; $resn_exch{"H2'' 653"}=" H2B 653"; $resn_exch{"H3'' 653"}=" H3B 653";
$resn_exch{"H4'' 653"}=" H4B 653"; $resn_exch{"H5'' 653"}=" H5B 653"; $resn_exch{"H6'' 653"}=" H6B 653";
$resn_exch{"CH3T 654"}="H3TC 654"; $resn_exch{"CH4T 654"}="H4TC 654"; $resn_exch{"CH5T 654"}="H5TC 654";
$resn_exch{"CH3I 654"}="H3IC 654"; $resn_exch{"CH5I 654"}="H5IC 654"; $resn_exch{"1HC1 654"}="HC11 654";
$resn_exch{"2HC1 654"}="HC12 654"; $resn_exch{"1HC8 654"}="HC81 654"; $resn_exch{"2HC8 654"}="HC82 654";
$resn_exch{"3HC8 654"}="HC83 654"; $resn_exch{"1H2' 65B"}="H2'1 65B"; $resn_exch{"2H2' 65B"}="H2'2 65B";
$resn_exch{"3H2' 65B"}="H2'3 65B"; $resn_exch{"1H6' 65B"}="H6'1 65B"; $resn_exch{"2H6' 65B"}="H6'2 65B";
$resn_exch{"3H6' 65B"}="H6'3 65B"; $resn_exch{"1H18 65B"}="H181 65B"; $resn_exch{"2H18 65B"}="H182 65B";
$resn_exch{"1H34 663"}="H341 663"; $resn_exch{"2H34 663"}="H342 663"; $resn_exch{"3H34 663"}="H343 663";
$resn_exch{"1H28 663"}="H281 663"; $resn_exch{"2H28 663"}="H282 663"; $resn_exch{"1H18 663"}="H181 663";
$resn_exch{"2H18 663"}="H182 663"; $resn_exch{"3H18 663"}="H183 663"; $resn_exch{"1H4  665"}=" H41 665";
$resn_exch{"2H4  665"}=" H42 665"; $resn_exch{"1H8  665"}=" H81 665"; $resn_exch{"2H8  665"}=" H82 665";
$resn_exch{"1H10 665"}="H101 665"; $resn_exch{"2H10 665"}="H102 665"; $resn_exch{"1H11 666"}="H111 666";
$resn_exch{"2H11 666"}="H112 666"; $resn_exch{"1H16 666"}="H161 666"; $resn_exch{"2H16 666"}="H162 666";
$resn_exch{"1H17 666"}="H171 666"; $resn_exch{"2H17 666"}="H172 666"; $resn_exch{"1H18 666"}="H181 666";
$resn_exch{"2H18 666"}="H182 666"; $resn_exch{"1H41 666"}="H411 666"; $resn_exch{"2H41 666"}="H412 666";
$resn_exch{"1H47 666"}="H471 666"; $resn_exch{"2H47 666"}="H472 666"; $resn_exch{"3H47 666"}="H473 666";
$resn_exch{"1HN1 667"}="HN11 667"; $resn_exch{"2HN1 667"}="HN12 667"; $resn_exch{"1H10 667"}="H101 667";
$resn_exch{"2H10 667"}="H102 667"; $resn_exch{"1H11 667"}="H111 667"; $resn_exch{"2H11 667"}="H112 667";
$resn_exch{"1H12 667"}="H121 667"; $resn_exch{"2H12 667"}="H122 667"; $resn_exch{"1H13 667"}="H131 667";
$resn_exch{"2H13 667"}="H132 667"; $resn_exch{"1H14 667"}="H141 667"; $resn_exch{"2H14 667"}="H142 667";
$resn_exch{"1H04 669"}="H041 669"; $resn_exch{"2H04 669"}="H042 669"; $resn_exch{"1H05 669"}="H051 669";
$resn_exch{"2H05 669"}="H052 669"; $resn_exch{"1H06 669"}="H061 669"; $resn_exch{"2H06 669"}="H062 669";
$resn_exch{"1H07 669"}="H071 669"; $resn_exch{"2H07 669"}="H072 669"; $resn_exch{"1H08 669"}="H081 669";
$resn_exch{"2H08 669"}="H082 669"; $resn_exch{"1H16 669"}="H161 669"; $resn_exch{"2H16 669"}="H162 669";
$resn_exch{"1H4  672"}="H41A 672"; $resn_exch{"2H4  672"}=" H42 672"; $resn_exch{"3H4  672"}=" H43 672";
$resn_exch{"1H15 672"}="H151 672"; $resn_exch{"2H15 672"}="H152 672"; $resn_exch{"3H15 672"}="H153 672";
$resn_exch{"1H14 672"}="H141 672"; $resn_exch{"2H14 672"}="H142 672"; $resn_exch{"3H14 672"}="H143 672";
$resn_exch{"1H23 672"}="H231 672"; $resn_exch{"2H23 672"}="H232 672"; $resn_exch{"1H32 672"}="H321 672";
$resn_exch{"2H32 672"}="H322 672"; $resn_exch{"1H38 672"}="H381 672"; $resn_exch{"2H38 672"}="H382 672";
$resn_exch{"1H37 672"}="H371 672"; $resn_exch{"2H37 672"}="H372 672"; $resn_exch{"1H46 672"}="H461 672";
$resn_exch{"2H46 672"}="H462 672"; $resn_exch{"1H45 672"}="H451 672"; $resn_exch{"2H45 672"}="H452 672";
$resn_exch{"1H49 672"}="H491 672"; $resn_exch{"2H49 672"}="H492 672"; $resn_exch{"1H43 672"}="H431 672";
$resn_exch{"2H43 672"}="H432 672"; $resn_exch{"1H42 672"}="H421 672"; $resn_exch{"2H42 672"}="H422 672";
$resn_exch{"1H35 672"}="H351 672"; $resn_exch{"2H35 672"}="H352 672"; $resn_exch{"1H34 672"}="H341 672";
$resn_exch{"2H34 672"}="H342 672"; $resn_exch{"1H12 672"}="H121 672"; $resn_exch{"2H12 672"}="H122 672";
$resn_exch{"3H12 672"}="H123 672"; $resn_exch{"1H11 672"}="H111 672"; $resn_exch{"2H11 672"}="H112 672";
$resn_exch{"3H11 672"}="H113 672"; $resn_exch{"1H1  672"}=" H11 672"; $resn_exch{"2H1  672"}=" H12 672";
$resn_exch{"3H1  672"}="H13A 672"; $resn_exch{"1H19 675"}="H191 675"; $resn_exch{"2H19 675"}="H192 675";
$resn_exch{"1H5  680"}=" H51 680"; $resn_exch{"2H5  680"}=" H52 680"; $resn_exch{"3H5  680"}=" H53 680";
$resn_exch{"1HN5 680"}="HN51 680"; $resn_exch{"2HN5 680"}="HN52 680"; $resn_exch{"1H1  681"}=" H11 681";
$resn_exch{"1H5  681"}=" H51 681"; $resn_exch{"2H5  681"}=" H52 681"; $resn_exch{"3H5  681"}=" H53 681";
$resn_exch{"1H6  681"}=" H61 681"; $resn_exch{"2H6  681"}=" H62 681"; $resn_exch{"3H6  681"}=" H63 681";
$resn_exch{"1H7  681"}=" H71 681"; $resn_exch{"2H7  681"}=" H72 681"; $resn_exch{"3H7  681"}=" H73 681";
$resn_exch{"1HVA 681"}="HVA1 681"; $resn_exch{"1HVB 681"}="HVB1 681"; $resn_exch{"1HV1 681"}="HV11 681";
$resn_exch{"2HV1 681"}="HV12 681"; $resn_exch{"3HV1 681"}="HV13 681"; $resn_exch{"1HV2 681"}="HV21 681";
$resn_exch{"2HV2 681"}="HV22 681"; $resn_exch{"3HV2 681"}="HV23 681"; $resn_exch{"1HNV 681"}="HNV1 681";
$resn_exch{"1HAG 681"}="HAG1 681"; $resn_exch{"2HAG 681"}="HAG2 681"; $resn_exch{"1H2X 681"}="H2X1 681";
$resn_exch{"1H3X 681"}="H3X1 681"; $resn_exch{"2H3X 681"}="H3X2 681"; $resn_exch{"1H6X 681"}="H6X1 681";
$resn_exch{"1H7X 681"}="H7X1 681"; $resn_exch{"1H8X 681"}="H8X1 681"; $resn_exch{"1H9X 681"}="H9X1 681";
$resn_exch{"1H0X 681"}="H0X1 681"; $resn_exch{"1H6  682"}=" H61 682"; $resn_exch{"2H6  682"}=" H62 682";
$resn_exch{"1H7  682"}=" H71 682"; $resn_exch{"2H7  682"}=" H72 682"; $resn_exch{"1H8  682"}=" H81 682";
$resn_exch{"2H8  682"}=" H82 682"; $resn_exch{"1H12 682"}="H121 682"; $resn_exch{"2H12 682"}="H122 682";
$resn_exch{"1H21 682"}="H211 682"; $resn_exch{"2H21 682"}="H212 682"; $resn_exch{"3H21 682"}="H213 682";
$resn_exch{"1H22 682"}="H221 682"; $resn_exch{"2H22 682"}="H222 682"; $resn_exch{"3H22 682"}="H223 682";
$resn_exch{"1H24 682"}="H241 682"; $resn_exch{"2H24 682"}="H242 682"; $resn_exch{"1H11 687"}="H111 687";
$resn_exch{"2H11 687"}="H112 687"; $resn_exch{"1H17 687"}="H171 687"; $resn_exch{"2H17 687"}="H172 687";
$resn_exch{"3H17 687"}="H173 687"; $resn_exch{"1H21 687"}="H211 687"; $resn_exch{"2H21 687"}="H212 687";
$resn_exch{"1H22 687"}="H221 687"; $resn_exch{"2H22 687"}="H222 687"; $resn_exch{"1H23 687"}="H231 687";
$resn_exch{"2H23 687"}="H232 687"; $resn_exch{"1H24 687"}="H241 687"; $resn_exch{"2H24 687"}="H242 687";
$resn_exch{"1H27 687"}="H271 687"; $resn_exch{"2H27 687"}="H272 687"; $resn_exch{"1H12 688"}="H121 688";
$resn_exch{"2H12 688"}="H122 688"; $resn_exch{"1HAN 689"}="HAN1 689"; $resn_exch{"2HAN 689"}="HAN2 689";
$resn_exch{"3HAN 689"}="HAN3 689"; $resn_exch{"1HAR 689"}="HAR1 689"; $resn_exch{"2HAR 689"}="HAR2 689";
$resn_exch{"3HAR 689"}="HAR3 689"; $resn_exch{"1HAS 689"}="HAS1 689"; $resn_exch{"2HAS 689"}="HAS2 689";
$resn_exch{"3HAS 689"}="HAS3 689"; $resn_exch{"1HAT 689"}="HAT1 689"; $resn_exch{"2HAT 689"}="HAT2 689";
$resn_exch{"1HAM 689"}="HAM1 689"; $resn_exch{"2HAM 689"}="HAM2 689"; $resn_exch{"H3'' 693"}=" H3B 693";
$resn_exch{"H4'' 693"}=" H4B 693"; $resn_exch{"H5'' 693"}=" H5B 693"; $resn_exch{"H6'' 693"}=" H6B 693";
$resn_exch{"1H12 694"}="H121 694"; $resn_exch{"2H12 694"}="H122 694"; $resn_exch{"H2'' 696"}=" H2B 696";
$resn_exch{"H3'' 696"}=" H3B 696"; $resn_exch{"H4'' 696"}=" H4B 696"; $resn_exch{"H5'' 696"}=" H5B 696";
$resn_exch{"H6'' 696"}=" H6B 696"; $resn_exch{"1H16 698"}="H161 698"; $resn_exch{"2H16 698"}="H162 698";
$resn_exch{"1H33 698"}="H331 698"; $resn_exch{"2H33 698"}="H332 698"; $resn_exch{"1H40 698"}="H401 698";
$resn_exch{"2H40 698"}="H402 698"; $resn_exch{"3H40 698"}="H403 698"; $resn_exch{"1H44 698"}="H441 698";
$resn_exch{"2H44 698"}="H442 698"; $resn_exch{"3H44 698"}="H443 698"; $resn_exch{"1H9C 698"}="H9C1 698";
$resn_exch{"2H9C 698"}="H9C2 698"; $resn_exch{"3H9C 698"}="H9C3 698"; $resn_exch{"1H8C 698"}="H8C1 698";
$resn_exch{"2H8C 698"}="H8C2 698"; $resn_exch{"3H8C 698"}="H8C3 698"; $resn_exch{"1H7C 698"}="H7C1 698";
$resn_exch{"2H7C 698"}="H7C2 698"; $resn_exch{"3H7C 698"}="H7C3 698"; $resn_exch{"1H33 699"}="H331 699";
$resn_exch{"2H33 699"}="H332 699"; $resn_exch{"1H16 699"}="H161 699"; $resn_exch{"2H16 699"}="H162 699";
$resn_exch{"1H44 699"}="H441 699"; $resn_exch{"2H44 699"}="H442 699"; $resn_exch{"3H44 699"}="H443 699";
$resn_exch{"1H40 699"}="H401 699"; $resn_exch{"2H40 699"}="H402 699"; $resn_exch{"3H40 699"}="H403 699";
$resn_exch{"'HO2 6AB"}="HO2' 6AB"; $resn_exch{"1HN6 6AB"}="HN61 6AB"; $resn_exch{"2HN6 6AB"}="HN62 6AB";
$resn_exch{"1HN2 6AP"}="HN21 6AP"; $resn_exch{"2HN2 6AP"}="HN22 6AP"; $resn_exch{"1HN6 6AP"}="HN61 6AP";
$resn_exch{"2HN6 6AP"}="HN62 6AP"; $resn_exch{"1H19 6C3"}="H191 6C3"; $resn_exch{"2H19 6C3"}="H192 6C3";
$resn_exch{"3H19 6C3"}="H193 6C3"; $resn_exch{"1H22 6CA"}="H221 6CA"; $resn_exch{"2H22 6CA"}="H222 6CA";
$resn_exch{"1H21 6CA"}="H211 6CA"; $resn_exch{"2H21 6CA"}="H212 6CA"; $resn_exch{"1H20 6CA"}="H201 6CA";
$resn_exch{"2H20 6CA"}="H202 6CA"; $resn_exch{"1H19 6CA"}="H191 6CA"; $resn_exch{"2H19 6CA"}="H192 6CA";
$resn_exch{"1H18 6CA"}="H181 6CA"; $resn_exch{"2H18 6CA"}="H182 6CA"; $resn_exch{"1H17 6CA"}="H171 6CA";
$resn_exch{"2H17 6CA"}="H172 6CA"; $resn_exch{" HN2 6CL"}=" H2  6CL"; $resn_exch{" HB1 6CL"}=" HB2 6CL";
$resn_exch{" HB2 6CL"}=" HB3 6CL"; $resn_exch{" HG1 6CL"}=" HG2 6CL"; $resn_exch{" HG2 6CL"}=" HG3 6CL";
$resn_exch{" HD1 6CL"}=" HD2 6CL"; $resn_exch{" HD2 6CL"}=" HD3 6CL"; $resn_exch{"1H1  6CM"}=" H11 6CM";
$resn_exch{"2H1  6CM"}=" H12 6CM"; $resn_exch{"1H6  6CM"}=" H61 6CM"; $resn_exch{"2H6  6CM"}=" H62 6CM";
$resn_exch{"1H7  6CM"}=" H71 6CM"; $resn_exch{"2H7  6CM"}=" H72 6CM"; $resn_exch{"1H8  6CM"}=" H81 6CM";
$resn_exch{"2H8  6CM"}=" H82 6CM"; $resn_exch{"1H9  6CM"}=" H91 6CM"; $resn_exch{"2H9  6CM"}=" H92 6CM";
$resn_exch{"1H10 6CM"}="H101 6CM"; $resn_exch{"2H10 6CM"}="H102 6CM"; $resn_exch{"1H11 6CM"}="H111 6CM";
$resn_exch{"2H11 6CM"}="H112 6CM"; $resn_exch{"1H12 6CM"}="H121 6CM"; $resn_exch{"2H12 6CM"}="H122 6CM";
$resn_exch{"1H13 6CM"}="H131 6CM"; $resn_exch{"2H13 6CM"}="H132 6CM"; $resn_exch{"1H14 6CM"}="H141 6CM";
$resn_exch{"2H14 6CM"}="H142 6CM"; $resn_exch{"1H15 6CM"}="H151 6CM"; $resn_exch{"2H15 6CM"}="H152 6CM";
$resn_exch{"1H16 6CM"}="H161 6CM"; $resn_exch{"2H16 6CM"}="H162 6CM"; $resn_exch{"1H17 6CM"}="H171 6CM";
$resn_exch{"2H17 6CM"}="H172 6CM"; $resn_exch{"1H18 6CM"}="H181 6CM"; $resn_exch{"2H18 6CM"}="H182 6CM";
$resn_exch{"3H18 6CM"}="H183 6CM"; $resn_exch{"1H20 6CM"}="H201 6CM"; $resn_exch{"2H20 6CM"}="H202 6CM";
$resn_exch{"1H21 6CM"}="H211 6CM"; $resn_exch{"2H21 6CM"}="H212 6CM"; $resn_exch{"1H22 6CM"}="H221 6CM";
$resn_exch{"2H22 6CM"}="H222 6CM"; $resn_exch{"1H23 6CM"}="H231 6CM"; $resn_exch{"2H23 6CM"}="H232 6CM";
$resn_exch{"1H24 6CM"}="H241 6CM"; $resn_exch{"2H24 6CM"}="H242 6CM"; $resn_exch{"3H24 6CM"}="H243 6CM";
$resn_exch{"1H10 6CP"}="H101 6CP"; $resn_exch{"2H10 6CP"}="H102 6CP"; $resn_exch{"1H12 6CP"}="H121 6CP";
$resn_exch{"2H12 6CP"}="H122 6CP"; $resn_exch{"1H13 6CP"}="H131 6CP"; $resn_exch{"2H13 6CP"}="H132 6CP";
$resn_exch{"1H14 6CP"}="H141 6CP"; $resn_exch{"2H14 6CP"}="H142 6CP"; $resn_exch{"1H15 6CP"}="H151 6CP";
$resn_exch{"2H15 6CP"}="H152 6CP"; $resn_exch{"1H16 6CP"}="H161 6CP"; $resn_exch{"2H16 6CP"}="H162 6CP";
$resn_exch{"1HAA 6CS"}="HAA1 6CS"; $resn_exch{"2HAA 6CS"}="HAA2 6CS"; $resn_exch{"3HAA 6CS"}="HAA3 6CS";
$resn_exch{"1HG2 6CS"}="HG21 6CS"; $resn_exch{"2HG2 6CS"}="HG22 6CS"; $resn_exch{"1H5* 6CT"}=" H5' 6CT";
$resn_exch{"2H5* 6CT"}="H5'' 6CT"; $resn_exch{" H4* 6CT"}=" H4' 6CT"; $resn_exch{" H3* 6CT"}=" H3' 6CT";
$resn_exch{"*HO3 6CT"}="HO3' 6CT"; $resn_exch{"1H2* 6CT"}=" H2' 6CT"; $resn_exch{"2H2* 6CT"}="H2'' 6CT";
$resn_exch{" H1* 6CT"}=" H1' 6CT"; $resn_exch{"1H5M 6CT"}=" H71 6CT"; $resn_exch{"2H5M 6CT"}=" H72 6CT";
$resn_exch{"3H5M 6CT"}=" H73 6CT"; $resn_exch{" H*  6CT"}=" H'  6CT"; $resn_exch{"1HM* 6CT"}="HM'1 6CT";
$resn_exch{"2HM* 6CT"}="HM'2 6CT"; $resn_exch{"3HM* 6CT"}="HM'3 6CT"; $resn_exch{" O3P 6CT"}=" OP3 6CT";
$resn_exch{"3HOP 6CT"}="HOP3 6CT"; $resn_exch{"1HN  6CW"}=" H   6CW"; $resn_exch{"2HN  6CW"}=" H2  6CW";
$resn_exch{"1HB  6CW"}=" HB2 6CW"; $resn_exch{"2HB  6CW"}=" HB3 6CW"; $resn_exch{"1H16 6DE"}="H161 6DE";
$resn_exch{"2H16 6DE"}="H162 6DE"; $resn_exch{"1H17 6DE"}="H171 6DE"; $resn_exch{"2H17 6DE"}="H172 6DE";
$resn_exch{"3H17 6DE"}="H173 6DE"; $resn_exch{"1H19 6DE"}="H191 6DE"; $resn_exch{"2H19 6DE"}="H192 6DE";
$resn_exch{"3H19 6DE"}="H193 6DE"; $resn_exch{"1H11 6DE"}="H111 6DE"; $resn_exch{"2H11 6DE"}="H112 6DE";
$resn_exch{"3H11 6DE"}="H113 6DE"; $resn_exch{"1H26 6EA"}="H261 6EA"; $resn_exch{"2H26 6EA"}="H262 6EA";
$resn_exch{"1H30 6EA"}="H301 6EA"; $resn_exch{"2H30 6EA"}="H302 6EA"; $resn_exch{"1H31 6EA"}="H311 6EA";
$resn_exch{"2H31 6EA"}="H312 6EA"; $resn_exch{"1HM7 6FA"}="HM71 6FA"; $resn_exch{"2HM7 6FA"}="HM72 6FA";
$resn_exch{"3HM7 6FA"}="HM73 6FA"; $resn_exch{"1HM8 6FA"}="HM81 6FA"; $resn_exch{"2HM8 6FA"}="HM82 6FA";
$resn_exch{"3HM8 6FA"}="HM83 6FA"; $resn_exch{"1H1* 6FA"}="H1'1 6FA"; $resn_exch{"2H1* 6FA"}="H1'2 6FA";
$resn_exch{" H2* 6FA"}=" H2' 6FA"; $resn_exch{"*HO2 6FA"}="HO2' 6FA"; $resn_exch{" H3* 6FA"}=" H3' 6FA";
$resn_exch{"*HO3 6FA"}="HO3' 6FA"; $resn_exch{" H4* 6FA"}=" H4' 6FA"; $resn_exch{"*HO4 6FA"}="HO4' 6FA";
$resn_exch{"1H5* 6FA"}="H5'1 6FA"; $resn_exch{"2H5* 6FA"}="H5'2 6FA"; $resn_exch{"2HOP 6FA"}="HOP2 6FA";
$resn_exch{"2HOA 6FA"}="HOA2 6FA"; $resn_exch{"AH51 6FA"}="H51A 6FA"; $resn_exch{"AH52 6FA"}="H52A 6FA";
$resn_exch{"AH4* 6FA"}=" H4B 6FA"; $resn_exch{"AH3* 6FA"}=" H3B 6FA"; $resn_exch{"AHO3 6FA"}="HO3A 6FA";
$resn_exch{"AH2* 6FA"}=" H2B 6FA"; $resn_exch{"AHO2 6FA"}="HO2A 6FA"; $resn_exch{"AH1* 6FA"}=" H1B 6FA";
$resn_exch{" AH8 6FA"}=" H8A 6FA"; $resn_exch{"AH61 6FA"}="H61A 6FA"; $resn_exch{"AH62 6FA"}="H62A 6FA";
$resn_exch{" AH2 6FA"}=" H2A 6FA"; $resn_exch{"1H6  6GP"}=" H61 6GP"; $resn_exch{"2H6  6GP"}=" H62 6GP";
$resn_exch{"1H9  6GP"}=" H91 6GP"; $resn_exch{"2H9  6GP"}=" H92 6GP"; $resn_exch{"3H9  6GP"}=" H93 6GP";
$resn_exch{"2HOP 6HA"}="HOP2 6HA"; $resn_exch{"3HOP 6HA"}="HOP3 6HA"; $resn_exch{"1H5* 6HA"}=" H5' 6HA";
$resn_exch{"2H5* 6HA"}="H5'' 6HA"; $resn_exch{" H4* 6HA"}=" H4' 6HA"; $resn_exch{" H3* 6HA"}=" H3' 6HA";
$resn_exch{"HO3* 6HA"}="HO3' 6HA"; $resn_exch{"1H2* 6HA"}=" H2' 6HA"; $resn_exch{"2H2* 6HA"}="H2'' 6HA";
$resn_exch{" H1* 6HA"}=" H1' 6HA"; $resn_exch{"1H6* 6HA"}="H6'1 6HA"; $resn_exch{"2H6* 6HA"}="H6'2 6HA";
$resn_exch{"1H6  6HA"}=" H61 6HA"; $resn_exch{"2H6  6HA"}=" H62 6HA"; $resn_exch{"2HOP 6HC"}="HOP2 6HC";
$resn_exch{"3HOP 6HC"}="HOP3 6HC"; $resn_exch{"1H5* 6HC"}=" H5' 6HC"; $resn_exch{"2H5* 6HC"}="H5'' 6HC";
$resn_exch{" H4* 6HC"}=" H4' 6HC"; $resn_exch{" H3* 6HC"}=" H3' 6HC"; $resn_exch{"HO3* 6HC"}="HO3' 6HC";
$resn_exch{"1H2* 6HC"}=" H2' 6HC"; $resn_exch{"2H2* 6HC"}="H2'' 6HC"; $resn_exch{" H1* 6HC"}=" H1' 6HC";
$resn_exch{"1H6* 6HC"}="H6'1 6HC"; $resn_exch{"2H6* 6HC"}="H6'2 6HC"; $resn_exch{"1H4  6HC"}=" H41 6HC";
$resn_exch{"2H4  6HC"}=" H42 6HC"; $resn_exch{"1HMA 6HE"}="HMA1 6HE"; $resn_exch{"2HMA 6HE"}="HMA2 6HE";
$resn_exch{"3HMA 6HE"}="HMA3 6HE"; $resn_exch{"1HAA 6HE"}="HAA1 6HE"; $resn_exch{"2HAA 6HE"}="HAA2 6HE";
$resn_exch{"1HBA 6HE"}="HBA1 6HE"; $resn_exch{"2HBA 6HE"}="HBA2 6HE"; $resn_exch{"1HMB 6HE"}="HMB1 6HE";
$resn_exch{"2HMB 6HE"}="HMB2 6HE"; $resn_exch{"3HMB 6HE"}="HMB3 6HE"; $resn_exch{"1HBB 6HE"}="HBB1 6HE";
$resn_exch{"2HBB 6HE"}="HBB2 6HE"; $resn_exch{"1HMC 6HE"}="HMC1 6HE"; $resn_exch{"2HMC 6HE"}="HMC2 6HE";
$resn_exch{"3HMC 6HE"}="HMC3 6HE"; $resn_exch{"1HBC 6HE"}="HBC1 6HE"; $resn_exch{"2HBC 6HE"}="HBC2 6HE";
$resn_exch{"1HMD 6HE"}="HMD1 6HE"; $resn_exch{"2HMD 6HE"}="HMD2 6HE"; $resn_exch{"3HMD 6HE"}="HMD3 6HE";
$resn_exch{"1HAD 6HE"}="HAD1 6HE"; $resn_exch{"2HAD 6HE"}="HAD2 6HE"; $resn_exch{"3HAD 6HE"}="HAD3 6HE";
$resn_exch{"2HOP 6HG"}="HOP2 6HG"; $resn_exch{"3HOP 6HG"}="HOP3 6HG"; $resn_exch{"1H5* 6HG"}=" H5' 6HG";
$resn_exch{"2H5* 6HG"}="H5'' 6HG"; $resn_exch{" H4* 6HG"}=" H4' 6HG"; $resn_exch{" H3* 6HG"}=" H3' 6HG";
$resn_exch{"HO3* 6HG"}="HO3' 6HG"; $resn_exch{"1H2* 6HG"}=" H2' 6HG"; $resn_exch{"2H2* 6HG"}="H2'' 6HG";
$resn_exch{" H1* 6HG"}=" H1' 6HG"; $resn_exch{"1H6* 6HG"}="H6'1 6HG"; $resn_exch{"2H6* 6HG"}="H6'2 6HG";
$resn_exch{"1H2  6HG"}=" H21 6HG"; $resn_exch{"2H2  6HG"}=" H22 6HG"; $resn_exch{"2HOP 6HT"}="HOP2 6HT";
$resn_exch{"3HOP 6HT"}="HOP3 6HT"; $resn_exch{"1H5* 6HT"}=" H5' 6HT"; $resn_exch{"2H5* 6HT"}="H5'' 6HT";
$resn_exch{" H4* 6HT"}=" H4' 6HT"; $resn_exch{" H3* 6HT"}=" H3' 6HT"; $resn_exch{"HO3* 6HT"}="HO3' 6HT";
$resn_exch{"1H2* 6HT"}=" H2' 6HT"; $resn_exch{"2H2* 6HT"}="H2'' 6HT"; $resn_exch{" H1* 6HT"}=" H1' 6HT";
$resn_exch{"1H6* 6HT"}="H6'1 6HT"; $resn_exch{"2H6* 6HT"}="H6'2 6HT"; $resn_exch{"1H5M 6HT"}=" H71 6HT";
$resn_exch{"2H5M 6HT"}=" H72 6HT"; $resn_exch{"3H5M 6HT"}=" H73 6HT"; $resn_exch{"3HOP 6IA"}="HOP3 6IA";
$resn_exch{"2HOP 6IA"}="HOP2 6IA"; $resn_exch{"1H5* 6IA"}=" H5' 6IA"; $resn_exch{"2H5* 6IA"}="H5'' 6IA";
$resn_exch{" H4* 6IA"}=" H4' 6IA"; $resn_exch{" H3* 6IA"}=" H3' 6IA"; $resn_exch{"H3T  6IA"}="HO3' 6IA";
$resn_exch{" H2* 6IA"}=" H2' 6IA"; $resn_exch{"2HO* 6IA"}="HO2' 6IA"; $resn_exch{" H1* 6IA"}=" H1' 6IA";
$resn_exch{"1H12 6IA"}="H121 6IA"; $resn_exch{"2H12 6IA"}="H122 6IA"; $resn_exch{"1H13 6IA"}="H131 6IA";
$resn_exch{"2H13 6IA"}="H132 6IA"; $resn_exch{"1H15 6IA"}="H151 6IA"; $resn_exch{"2H15 6IA"}="H152 6IA";
$resn_exch{"3H15 6IA"}="H153 6IA"; $resn_exch{"1H16 6IA"}="H161 6IA"; $resn_exch{"2H16 6IA"}="H162 6IA";
$resn_exch{"3H16 6IA"}="H163 6IA"; $resn_exch{"1HN4 6IG"}="HN41 6IG"; $resn_exch{"2HN4 6IG"}="HN42 6IG";
$resn_exch{"1H5  6IG"}=" H51 6IG"; $resn_exch{"2H5  6IG"}=" H52 6IG"; $resn_exch{"1H6  6IG"}=" H61 6IG";
$resn_exch{"2H6  6IG"}=" H62 6IG"; $resn_exch{"3H6  6IG"}=" H63 6IG"; $resn_exch{"1H13 6IG"}="H131 6IG";
$resn_exch{"2H13 6IG"}="H132 6IG"; $resn_exch{"1H14 6IG"}="H141 6IG"; $resn_exch{"2H14 6IG"}="H142 6IG";
$resn_exch{"1H15 6IG"}="H151 6IG"; $resn_exch{"2H15 6IG"}="H152 6IG"; $resn_exch{"1H16 6IG"}="H161 6IG";
$resn_exch{"2H16 6IG"}="H162 6IG"; $resn_exch{"1H17 6IG"}="H171 6IG"; $resn_exch{"2H17 6IG"}="H172 6IG";
$resn_exch{"1H18 6IG"}="H181 6IG"; $resn_exch{"2H18 6IG"}="H182 6IG"; $resn_exch{"1H19 6IG"}="H191 6IG";
$resn_exch{"2H19 6IG"}="H192 6IG"; $resn_exch{"3H19 6IG"}="H193 6IG"; $resn_exch{"1H20 6IG"}="H201 6IG";
$resn_exch{"2H20 6IG"}="H202 6IG"; $resn_exch{"1H21 6IG"}="H211 6IG"; $resn_exch{"2H21 6IG"}="H212 6IG";
$resn_exch{"1H13 6IN"}="H131 6IN"; $resn_exch{"2H13 6IN"}="H132 6IN"; $resn_exch{"1H27 6IN"}="H271 6IN";
$resn_exch{"2H27 6IN"}="H272 6IN"; $resn_exch{"3H27 6IN"}="H273 6IN"; $resn_exch{"1H32 6IN"}="H321 6IN";
$resn_exch{"2H32 6IN"}="H322 6IN"; $resn_exch{"1H37 6IN"}="H371 6IN"; $resn_exch{"2H37 6IN"}="H372 6IN";
$resn_exch{"1H42 6IN"}="H421 6IN"; $resn_exch{"2H42 6IN"}="H422 6IN"; $resn_exch{"1H43 6IN"}="H431 6IN";
$resn_exch{"2H43 6IN"}="H432 6IN"; $resn_exch{"1H46 6IN"}="H461 6IN"; $resn_exch{"2H46 6IN"}="H462 6IN";
$resn_exch{"1HN1 6IP"}="HN11 6IP"; $resn_exch{"2HN1 6IP"}="HN12 6IP"; $resn_exch{"1H7  6IP"}=" H71 6IP";
$resn_exch{"2H7  6IP"}=" H72 6IP"; $resn_exch{"1H8  6IP"}=" H81 6IP"; $resn_exch{"2H8  6IP"}=" H82 6IP";
$resn_exch{"3HOP 6MA"}="HOP3 6MA"; $resn_exch{"2HOP 6MA"}="HOP2 6MA"; $resn_exch{"1H5* 6MA"}=" H5' 6MA";
$resn_exch{"2H5* 6MA"}="H5'' 6MA"; $resn_exch{" H4* 6MA"}=" H4' 6MA"; $resn_exch{" H3* 6MA"}=" H3' 6MA";
$resn_exch{"H3T  6MA"}="HO3' 6MA"; $resn_exch{"1H2* 6MA"}=" H2' 6MA"; $resn_exch{"2H2* 6MA"}="H2'' 6MA";
$resn_exch{" H1* 6MA"}=" H1' 6MA"; $resn_exch{"1H6  6MA"}=" H61 6MA"; $resn_exch{"1H1  6MA"}=" H11 6MA";
$resn_exch{"2H1  6MA"}=" H12 6MA"; $resn_exch{"3H1  6MA"}=" H13 6MA"; $resn_exch{"3HOP 6MC"}="HOP3 6MC";
$resn_exch{"2HOP 6MC"}="HOP2 6MC"; $resn_exch{"1H5* 6MC"}=" H5' 6MC"; $resn_exch{"2H5* 6MC"}="H5'' 6MC";
$resn_exch{" H4* 6MC"}=" H4' 6MC"; $resn_exch{" H3* 6MC"}=" H3' 6MC"; $resn_exch{"H3T  6MC"}="HO3' 6MC";
$resn_exch{"1H2* 6MC"}=" H2' 6MC"; $resn_exch{"2H2* 6MC"}="H2'' 6MC"; $resn_exch{" H1* 6MC"}=" H1' 6MC";
$resn_exch{"1H6  6MC"}=" H61 6MC"; $resn_exch{"1H1  6MC"}=" H11 6MC"; $resn_exch{"2H1  6MC"}=" H12 6MC";
$resn_exch{"3H1  6MC"}=" H13 6MC"; $resn_exch{"2HOP 6MI"}="HOP2 6MI"; $resn_exch{"3HOP 6MI"}="HOP3 6MI";
$resn_exch{"1H7M 6MI"}="H7M1 6MI"; $resn_exch{"2H7M 6MI"}="H7M2 6MI"; $resn_exch{"1H3I 6MI"}="H3I1 6MI";
$resn_exch{"2H3I 6MI"}="H3I2 6MI"; $resn_exch{"3H3I 6MI"}="H3I3 6MI"; $resn_exch{"1H2* 6MI"}="H2'1 6MI";
$resn_exch{"2H2* 6MI"}="H2'2 6MI"; $resn_exch{"1H5* 6MI"}="H5'1 6MI"; $resn_exch{"2H5* 6MI"}="H5'2 6MI";
$resn_exch{" H4* 6MI"}=" H4' 6MI"; $resn_exch{" H1* 6MI"}=" H1' 6MI"; $resn_exch{" H3* 6MI"}=" H3' 6MI";
$resn_exch{"1H7  6MP"}=" H71 6MP"; $resn_exch{"2H7  6MP"}=" H72 6MP"; $resn_exch{"3H7  6MP"}=" H73 6MP";
$resn_exch{"1HB  6MR"}=" HB1 6MR"; $resn_exch{"2HB  6MR"}=" HB2 6MR"; $resn_exch{"3HOP 6MT"}="HOP3 6MT";
$resn_exch{"2HOP 6MT"}="HOP2 6MT"; $resn_exch{"1H5* 6MT"}=" H5' 6MT"; $resn_exch{"2H5* 6MT"}="H5'' 6MT";
$resn_exch{" H4* 6MT"}=" H4' 6MT"; $resn_exch{" H3* 6MT"}=" H3' 6MT"; $resn_exch{"H3T  6MT"}="HO3' 6MT";
$resn_exch{"1H2* 6MT"}=" H2' 6MT"; $resn_exch{"2H2* 6MT"}="H2'' 6MT"; $resn_exch{" H1* 6MT"}=" H1' 6MT";
$resn_exch{"1H6  6MT"}=" H61 6MT"; $resn_exch{"1H1  6MT"}=" H11 6MT"; $resn_exch{"2H1  6MT"}=" H12 6MT";
$resn_exch{"3H1  6MT"}=" H13 6MT"; $resn_exch{" H1* 6MZ"}=" H1' 6MZ"; $resn_exch{"1H9C 6MZ"}="H9C1 6MZ";
$resn_exch{"2H9C 6MZ"}="H9C2 6MZ"; $resn_exch{"1H5* 6MZ"}="H5'1 6MZ"; $resn_exch{"2H5* 6MZ"}="H5'2 6MZ";
$resn_exch{" H4* 6MZ"}=" H4' 6MZ"; $resn_exch{" H3* 6MZ"}=" H3' 6MZ"; $resn_exch{" H2* 6MZ"}=" H2' 6MZ";
$resn_exch{"1HAC 6NA"}="HAC1 6NA"; $resn_exch{"2HAC 6NA"}="HAC2 6NA"; $resn_exch{"1HBC 6NA"}="HBC1 6NA";
$resn_exch{"2HBC 6NA"}="HBC2 6NA"; $resn_exch{"1HGC 6NA"}="HGC1 6NA"; $resn_exch{"2HGC 6NA"}="HGC2 6NA";
$resn_exch{"1HDC 6NA"}="HDC1 6NA"; $resn_exch{"2HDC 6NA"}="HDC2 6NA"; $resn_exch{"1H6C 6NA"}="H6C1 6NA";
$resn_exch{"2H6C 6NA"}="H6C2 6NA"; $resn_exch{"3H6C 6NA"}="H6C3 6NA"; $resn_exch{"1HN1 6NH"}="HN11 6NH";
$resn_exch{"2HN1 6NH"}="HN12 6NH"; $resn_exch{"H2'' 6NH"}=" H2B 6NH"; $resn_exch{"H3'' 6NH"}=" H3B 6NH";
$resn_exch{"H4'' 6NH"}=" H4B 6NH"; $resn_exch{"H5'' 6NH"}=" H5B 6NH"; $resn_exch{"H6'' 6NH"}=" H6B 6NH";
$resn_exch{"1H7  6NI"}=" H71 6NI"; $resn_exch{"1H4  6NI"}=" H41 6NI"; $resn_exch{"1H5  6NI"}=" H51 6NI";
$resn_exch{"1HN1 6NI"}="HN11 6NI"; $resn_exch{"1H3  6NI"}=" H31 6NI"; $resn_exch{"1H10 6NP"}="H101 6NP";
$resn_exch{"2H10 6NP"}="H102 6NP"; $resn_exch{"1H28 6NP"}="H281 6NP"; $resn_exch{"2H28 6NP"}="H282 6NP";
$resn_exch{"1H29 6NP"}="H291 6NP"; $resn_exch{"2H29 6NP"}="H292 6NP"; $resn_exch{"1H30 6NP"}="H301 6NP";
$resn_exch{"2H30 6NP"}="H302 6NP"; $resn_exch{"2HOP 6OG"}="HOP2 6OG"; $resn_exch{"1HN2 6OG"}="HN21 6OG";
$resn_exch{"2HN2 6OG"}="HN22 6OG"; $resn_exch{"1H2* 6OG"}=" H2' 6OG"; $resn_exch{"2H2* 6OG"}="H2'' 6OG";
$resn_exch{"1H5* 6OG"}=" H5' 6OG"; $resn_exch{"2H5* 6OG"}="H5'' 6OG"; $resn_exch{" H4* 6OG"}=" H4' 6OG";
$resn_exch{" H1* 6OG"}=" H1' 6OG"; $resn_exch{" H3* 6OG"}=" H3' 6OG"; $resn_exch{"H3T  6OG"}="HO3' 6OG";
$resn_exch{"1H   6OG"}=" H1  6OG"; $resn_exch{"2H   6OG"}=" H2  6OG"; $resn_exch{"3H   6OG"}=" H3  6OG";
$resn_exch{"3HOP 6OG"}="HOP3 6OG"; $resn_exch{"1H6  6PG"}=" H61 6PG"; $resn_exch{"2H6  6PG"}=" H62 6PG";
$resn_exch{"2HOP 6PG"}="HOP2 6PG"; $resn_exch{"3HOP 6PG"}="HOP3 6PG"; $resn_exch{"1H26 6PL"}="H261 6PL";
$resn_exch{"2H26 6PL"}="H262 6PL"; $resn_exch{"3H26 6PL"}="H263 6PL"; $resn_exch{"1H25 6PL"}="H251 6PL";
$resn_exch{"2H25 6PL"}="H252 6PL"; $resn_exch{"1H24 6PL"}="H241 6PL"; $resn_exch{"2H24 6PL"}="H242 6PL";
$resn_exch{"1H23 6PL"}="H231 6PL"; $resn_exch{"2H23 6PL"}="H232 6PL"; $resn_exch{"1H22 6PL"}="H221 6PL";
$resn_exch{"2H22 6PL"}="H222 6PL"; $resn_exch{"1H21 6PL"}="H211 6PL"; $resn_exch{"2H21 6PL"}="H212 6PL";
$resn_exch{"1H20 6PL"}="H201 6PL"; $resn_exch{"2H20 6PL"}="H202 6PL"; $resn_exch{"1H19 6PL"}="H191 6PL";
$resn_exch{"2H19 6PL"}="H192 6PL"; $resn_exch{"1H18 6PL"}="H181 6PL"; $resn_exch{"2H18 6PL"}="H182 6PL";
$resn_exch{"1H17 6PL"}="H171 6PL"; $resn_exch{"2H17 6PL"}="H172 6PL"; $resn_exch{"1H16 6PL"}="H161 6PL";
$resn_exch{"2H16 6PL"}="H162 6PL"; $resn_exch{"1H15 6PL"}="H151 6PL"; $resn_exch{"2H15 6PL"}="H152 6PL";
$resn_exch{"1H14 6PL"}="H141 6PL"; $resn_exch{"2H14 6PL"}="H142 6PL"; $resn_exch{"1H13 6PL"}="H131 6PL";
$resn_exch{"2H13 6PL"}="H132 6PL"; $resn_exch{"1H12 6PL"}="H121 6PL"; $resn_exch{"2H12 6PL"}="H122 6PL";
$resn_exch{"1H3  6PL"}=" H31 6PL"; $resn_exch{"2H3  6PL"}=" H32 6PL"; $resn_exch{"1H1  6PL"}=" H11 6PL";
$resn_exch{"2H1  6PL"}=" H12 6PL"; $resn_exch{"1H4  6PL"}=" H41 6PL"; $resn_exch{"2H4  6PL"}=" H42 6PL";
$resn_exch{"1H5  6PL"}=" H51 6PL"; $resn_exch{"2H5  6PL"}=" H52 6PL"; $resn_exch{"1H7  6PL"}=" H71 6PL";
$resn_exch{"2H7  6PL"}=" H72 6PL"; $resn_exch{"3H7  6PL"}=" H73 6PL"; $resn_exch{"1H8  6PL"}=" H81 6PL";
$resn_exch{"2H8  6PL"}=" H82 6PL"; $resn_exch{"3H8  6PL"}=" H83 6PL"; $resn_exch{"1H6  6PL"}=" H61 6PL";
$resn_exch{"2H6  6PL"}=" H62 6PL"; $resn_exch{"3H6  6PL"}=" H63 6PL"; $resn_exch{"1H32 6PL"}="H321 6PL";
$resn_exch{"2H32 6PL"}="H322 6PL"; $resn_exch{"1H33 6PL"}="H331 6PL"; $resn_exch{"2H33 6PL"}="H332 6PL";
$resn_exch{"1H34 6PL"}="H341 6PL"; $resn_exch{"2H34 6PL"}="H342 6PL"; $resn_exch{"1H35 6PL"}="H351 6PL";
$resn_exch{"2H35 6PL"}="H352 6PL"; $resn_exch{"1H36 6PL"}="H361 6PL"; $resn_exch{"2H36 6PL"}="H362 6PL";
$resn_exch{"1H37 6PL"}="H371 6PL"; $resn_exch{"2H37 6PL"}="H372 6PL"; $resn_exch{"1H38 6PL"}="H381 6PL";
$resn_exch{"2H38 6PL"}="H382 6PL"; $resn_exch{"1H39 6PL"}="H391 6PL"; $resn_exch{"2H39 6PL"}="H392 6PL";
$resn_exch{"1H40 6PL"}="H401 6PL"; $resn_exch{"2H40 6PL"}="H402 6PL"; $resn_exch{"1H41 6PL"}="H411 6PL";
$resn_exch{"2H41 6PL"}="H412 6PL"; $resn_exch{"1H42 6PL"}="H421 6PL"; $resn_exch{"2H42 6PL"}="H422 6PL";
$resn_exch{"1H43 6PL"}="H431 6PL"; $resn_exch{"2H43 6PL"}="H432 6PL"; $resn_exch{"1H44 6PL"}="H441 6PL";
$resn_exch{"2H44 6PL"}="H442 6PL"; $resn_exch{"1H45 6PL"}="H451 6PL"; $resn_exch{"2H45 6PL"}="H452 6PL";
$resn_exch{"1H46 6PL"}="H461 6PL"; $resn_exch{"2H46 6PL"}="H462 6PL"; $resn_exch{"1H47 6PL"}="H471 6PL";
$resn_exch{"2H47 6PL"}="H472 6PL"; $resn_exch{"1H48 6PL"}="H481 6PL"; $resn_exch{"2H48 6PL"}="H482 6PL";
$resn_exch{"3H48 6PL"}="H483 6PL"; $resn_exch{"1HAJ 6PR"}="HAJ1 6PR"; $resn_exch{"2HAJ 6PR"}="HAJ2 6PR";
$resn_exch{"1HB  6PR"}=" HB1 6PR"; $resn_exch{"2HB  6PR"}=" HB2 6PR"; $resn_exch{"1HAA 6PR"}="HAA1 6PR";
$resn_exch{"2HAA 6PR"}="HAA2 6PR"; $resn_exch{"1HR6 6SA"}="HR61 6SA"; $resn_exch{"2HR6 6SA"}="HR62 6SA";
$resn_exch{"1HY6 6SA"}="HY61 6SA"; $resn_exch{"2HY6 6SA"}="HY62 6SA"; $resn_exch{"3HY6 6SA"}="HY63 6SA";
$resn_exch{"1HQ7 6SA"}="HQ71 6SA"; $resn_exch{"2HQ7 6SA"}="HQ72 6SA"; $resn_exch{"1HW6 6SA"}="HW61 6SA";
$resn_exch{"2HW6 6SA"}="HW62 6SA"; $resn_exch{"1HP6 6SA"}="HP61 6SA"; $resn_exch{"2HP6 6SA"}="HP62 6SA";
$resn_exch{"1HV6 6SA"}="HV61 6SA"; $resn_exch{"2HV6 6SA"}="HV62 6SA"; $resn_exch{"1H12 6SC"}="H121 6SC";
$resn_exch{"2H12 6SC"}="H122 6SC"; $resn_exch{"1HBP 6UL"}="HBP1 6UL"; $resn_exch{"2HBP 6UL"}="HBP2 6UL";
$resn_exch{"3HBP 6UL"}="HBP3 6UL"; $resn_exch{"1HBN 6UL"}="HBN1 6UL"; $resn_exch{"2HBN 6UL"}="HBN2 6UL";
$resn_exch{"1HAX 6UL"}="HAX1 6UL"; $resn_exch{"2HAX 6UL"}="HAX2 6UL"; $resn_exch{"1HAY 6UL"}="HAY1 6UL";
$resn_exch{"2HAY 6UL"}="HAY2 6UL"; $resn_exch{"1HAZ 6UL"}="HAZ1 6UL"; $resn_exch{"2HAZ 6UL"}="HAZ2 6UL";
$resn_exch{"1HBA 6UL"}="HBA1 6UL"; $resn_exch{"2HBA 6UL"}="HBA2 6UL"; $resn_exch{"1HBB 6UL"}="HBB1 6UL";
$resn_exch{"2HBB 6UL"}="HBB2 6UL"; $resn_exch{"1HBC 6UL"}="HBC1 6UL"; $resn_exch{"2HBC 6UL"}="HBC2 6UL";
$resn_exch{"1HBD 6UL"}="HBD1 6UL"; $resn_exch{"2HBD 6UL"}="HBD2 6UL"; $resn_exch{"1HBE 6UL"}="HBE1 6UL";
$resn_exch{"2HBE 6UL"}="HBE2 6UL"; $resn_exch{"1HBF 6UL"}="HBF1 6UL"; $resn_exch{"2HBF 6UL"}="HBF2 6UL";
$resn_exch{"1HBG 6UL"}="HBG1 6UL"; $resn_exch{"2HBG 6UL"}="HBG2 6UL"; $resn_exch{"1HBH 6UL"}="HBH1 6UL";
$resn_exch{"2HBH 6UL"}="HBH2 6UL"; $resn_exch{"1HBI 6UL"}="HBI1 6UL"; $resn_exch{"2HBI 6UL"}="HBI2 6UL";
$resn_exch{"1HBJ 6UL"}="HBJ1 6UL"; $resn_exch{"2HBJ 6UL"}="HBJ2 6UL"; $resn_exch{"1HBK 6UL"}="HBK1 6UL";
$resn_exch{"2HBK 6UL"}="HBK2 6UL"; $resn_exch{"1HBL 6UL"}="HBL1 6UL"; $resn_exch{"2HBL 6UL"}="HBL2 6UL";
$resn_exch{"1HBM 6UL"}="HBM1 6UL"; $resn_exch{"2HBM 6UL"}="HBM2 6UL"; $resn_exch{"1HAW 6UL"}="HAW1 6UL";
$resn_exch{"2HAW 6UL"}="HAW2 6UL"; $resn_exch{"1HAV 6UL"}="HAV1 6UL"; $resn_exch{"2HAV 6UL"}="HAV2 6UL";
$resn_exch{"1HAU 6UL"}="HAU1 6UL"; $resn_exch{"2HAU 6UL"}="HAU2 6UL"; $resn_exch{"1HAT 6UL"}="HAT1 6UL";
$resn_exch{"2HAT 6UL"}="HAT2 6UL"; $resn_exch{"1HAS 6UL"}="HAS1 6UL"; $resn_exch{"2HAS 6UL"}="HAS2 6UL";
$resn_exch{"1HAR 6UL"}="HAR1 6UL"; $resn_exch{"2HAR 6UL"}="HAR2 6UL"; $resn_exch{"1HAO 6UL"}="HAO1 6UL";
$resn_exch{"2HAO 6UL"}="HAO2 6UL"; $resn_exch{"1HAN 6UL"}="HAN1 6UL"; $resn_exch{"2HAN 6UL"}="HAN2 6UL";
$resn_exch{"1HAM 6UL"}="HAM1 6UL"; $resn_exch{"2HAM 6UL"}="HAM2 6UL"; $resn_exch{"1HAL 6UL"}="HAL1 6UL";
$resn_exch{"2HAL 6UL"}="HAL2 6UL"; $resn_exch{"1HAK 6UL"}="HAK1 6UL"; $resn_exch{"2HAK 6UL"}="HAK2 6UL";
$resn_exch{"1HAJ 6UL"}="HAJ1 6UL"; $resn_exch{"2HAJ 6UL"}="HAJ2 6UL"; $resn_exch{"1HAI 6UL"}="HAI1 6UL";
$resn_exch{"2HAI 6UL"}="HAI2 6UL"; $resn_exch{"1HAH 6UL"}="HAH1 6UL"; $resn_exch{"2HAH 6UL"}="HAH2 6UL";
$resn_exch{"1HAG 6UL"}="HAG1 6UL"; $resn_exch{"2HAG 6UL"}="HAG2 6UL"; $resn_exch{"1HAF 6UL"}="HAF1 6UL";
$resn_exch{"2HAF 6UL"}="HAF2 6UL"; $resn_exch{"1HAE 6UL"}="HAE1 6UL"; $resn_exch{"2HAE 6UL"}="HAE2 6UL";
$resn_exch{"1HAD 6UL"}="HAD1 6UL"; $resn_exch{"2HAD 6UL"}="HAD2 6UL"; $resn_exch{"1HAC 6UL"}="HAC1 6UL";
$resn_exch{"2HAC 6UL"}="HAC2 6UL"; $resn_exch{"1HAB 6UL"}="HAB1 6UL"; $resn_exch{"2HAB 6UL"}="HAB2 6UL";
$resn_exch{"1HAA 6UL"}="HAA1 6UL"; $resn_exch{"2HAA 6UL"}="HAA2 6UL"; $resn_exch{"3HAA 6UL"}="HAA3 6UL";
$resn_exch{"1H10 700"}="H101 700"; $resn_exch{"2H10 700"}="H102 700"; $resn_exch{"1H12 700"}="H121 700";
$resn_exch{"1H13 700"}="H131 700"; $resn_exch{"1H14 700"}="H141 700"; $resn_exch{"1H15 700"}="H151 700";
$resn_exch{"1H16 700"}="H161 700"; $resn_exch{"1H17 700"}="H171 700"; $resn_exch{"1H19 700"}="H191 700";
$resn_exch{"2H19 700"}="H192 700"; $resn_exch{"1H20 700"}="H201 700"; $resn_exch{"1H22 700"}="H221 700";
$resn_exch{"2H22 700"}="H222 700"; $resn_exch{"1H8C 701"}="H8C1 701"; $resn_exch{"2H8C 701"}="H8C2 701";
$resn_exch{"3H8C 701"}="H8C3 701"; $resn_exch{"1H13 701"}="H131 701"; $resn_exch{"2H13 701"}="H132 701";
$resn_exch{"1H14 701"}="H141 701"; $resn_exch{"2H14 701"}="H142 701"; $resn_exch{"1H17 701"}="H171 701";
$resn_exch{"2H17 701"}="H172 701"; $resn_exch{"3H17 701"}="H173 701"; $resn_exch{"1H19 701"}="H191 701";
$resn_exch{"2H19 701"}="H192 701"; $resn_exch{"1H23 701"}="H231 701"; $resn_exch{"2H23 701"}="H232 701";
$resn_exch{"1H20 701"}="H201 701"; $resn_exch{"2H20 701"}="H202 701"; $resn_exch{"1H22 701"}="H221 701";
$resn_exch{"2H22 701"}="H222 701"; $resn_exch{"1H23 703"}="H231 703"; $resn_exch{"2H23 703"}="H232 703";
$resn_exch{"1H24 703"}="H241 703"; $resn_exch{"2H24 703"}="H242 703"; $resn_exch{"1H25 703"}="H251 703";
$resn_exch{"2H25 703"}="H252 703"; $resn_exch{"1H27 703"}="H271 703"; $resn_exch{"2H27 703"}="H272 703";
$resn_exch{"1H28 703"}="H281 703"; $resn_exch{"2H28 703"}="H282 703"; $resn_exch{"1H30 703"}="H301 703";
$resn_exch{"2H30 703"}="H302 703"; $resn_exch{"1H31 703"}="H311 703"; $resn_exch{"2H31 703"}="H312 703";
$resn_exch{"1H12 709"}="H121 709"; $resn_exch{"2H12 709"}="H122 709"; $resn_exch{"1H23 709"}="H231 709";
$resn_exch{"2H23 709"}="H232 709"; $resn_exch{"3H23 709"}="H233 709"; $resn_exch{"1H5M 70U"}=" H71 70U";
$resn_exch{"2H5M 70U"}=" H72 70U"; $resn_exch{"1H9  70U"}=" H91 70U"; $resn_exch{"2H9  70U"}=" H92 70U";
$resn_exch{"3H9  70U"}=" H93 70U"; $resn_exch{" H1* 70U"}=" H1' 70U"; $resn_exch{"2HO* 70U"}="HO2' 70U";
$resn_exch{" H2* 70U"}=" H2' 70U"; $resn_exch{"H3T  70U"}="HO3' 70U"; $resn_exch{" H3* 70U"}=" H3' 70U";
$resn_exch{" H4* 70U"}=" H4' 70U"; $resn_exch{"1H5* 70U"}=" H5' 70U"; $resn_exch{"2H5* 70U"}="H5'' 70U";
$resn_exch{"2HOP 70U"}="HOP2 70U"; $resn_exch{"3HOP 70U"}="HOP3 70U"; $resn_exch{"1H17 710"}="H171 710";
$resn_exch{"2H17 710"}="H172 710"; $resn_exch{"1H19 710"}="H191 710"; $resn_exch{"2H19 710"}="H192 710";
$resn_exch{"1H20 710"}="H201 710"; $resn_exch{"2H20 710"}="H202 710"; $resn_exch{"1H21 710"}="H211 710";
$resn_exch{"2H21 710"}="H212 710"; $resn_exch{"1H22 710"}="H221 710"; $resn_exch{"2H22 710"}="H222 710";
$resn_exch{"1H23 710"}="H231 710"; $resn_exch{"2H23 710"}="H232 710"; $resn_exch{"1H29 710"}="H291 710";
$resn_exch{"2H29 710"}="H292 710"; $resn_exch{"1HN2 711"}="HN21 711"; $resn_exch{"2HN2 711"}="HN2A 711";
$resn_exch{"1H12 711"}="H121 711"; $resn_exch{"2H12 711"}="H122 711"; $resn_exch{"1H22 711"}="H221 711";
$resn_exch{"2H22 711"}="H222 711"; $resn_exch{"3H22 711"}="H223 711"; $resn_exch{"1H32 711"}="H321 711";
$resn_exch{"2H32 711"}="H322 711"; $resn_exch{"1H33 711"}="H331 711"; $resn_exch{"2H33 711"}="H332 711";
$resn_exch{"1H34 711"}="H341 711"; $resn_exch{"2H34 711"}="H342 711"; $resn_exch{"1H35 711"}="H351 711";
$resn_exch{"2H35 711"}="H352 711"; $resn_exch{"1H37 711"}="H371 711"; $resn_exch{"2H37 711"}="H372 711";
$resn_exch{"3H37 711"}="H373 711"; $resn_exch{"1HN  712"}=" HN1 712"; $resn_exch{"2HN  712"}=" HN2 712";
$resn_exch{"1H3  712"}="H31A 712"; $resn_exch{"2H3  712"}=" H32 712"; $resn_exch{"3H3  712"}=" H33 712";
$resn_exch{"1H4  712"}=" H41 712"; $resn_exch{"2H4  712"}=" H42 712"; $resn_exch{"1H21 712"}="H211 712";
$resn_exch{"2H21 712"}="H212 712"; $resn_exch{"3H21 712"}="H213 712"; $resn_exch{"1H24 712"}="H241 712";
$resn_exch{"2H24 712"}="H242 712"; $resn_exch{"3H24 712"}="H243 712"; $resn_exch{"1H32 712"}="H321 712";
$resn_exch{"2H32 712"}="H322 712"; $resn_exch{"3H32 712"}="H323 712"; $resn_exch{"1H33 712"}="H331 712";
$resn_exch{"2H33 712"}="H332 712"; $resn_exch{"1H11 715"}="H111 715"; $resn_exch{"2H11 715"}="H112 715";
$resn_exch{"1H15 715"}="H151 715"; $resn_exch{"2H15 715"}="H152 715"; $resn_exch{"1H20 715"}="H201 715";
$resn_exch{"2H20 715"}="H202 715"; $resn_exch{"1H25 715"}="H251 715"; $resn_exch{"2H25 715"}="H252 715";
$resn_exch{"1H26 715"}="H261 715"; $resn_exch{"2H26 715"}="H262 715"; $resn_exch{"1H29 715"}="H291 715";
$resn_exch{"2H29 715"}="H292 715"; $resn_exch{"1H3  716"}=" H31 716"; $resn_exch{"2H3  716"}=" H32 716";
$resn_exch{"1H4  716"}=" H41 716"; $resn_exch{"2H4  716"}=" H42 716"; $resn_exch{"1H5  716"}=" H51 716";
$resn_exch{"2H5  716"}=" H52 716"; $resn_exch{"1HN8 716"}="HN81 716"; $resn_exch{"2HN8 716"}="HN82 716";
$resn_exch{"1H19 716"}="H191 716"; $resn_exch{"2H19 716"}="H192 716"; $resn_exch{"3H19 716"}="H193 716";
$resn_exch{"1H20 716"}="H201 716"; $resn_exch{"2H20 716"}="H202 716"; $resn_exch{"3H20 716"}="H203 716";
$resn_exch{"1HN  720"}=" HN1 720"; $resn_exch{"2HN  720"}=" HN2 720"; $resn_exch{"1HAC 720"}="HAC1 720";
$resn_exch{"2HAC 720"}="HAC2 720"; $resn_exch{"1HHC 720"}="HHC1 720"; $resn_exch{"2HHC 720"}="HHC2 720";
$resn_exch{"1HE2 720"}="HE21 720"; $resn_exch{"2HE2 720"}="HE22 720"; $resn_exch{"1HZC 720"}="HZC1 720";
$resn_exch{"2HZC 720"}="HZC2 720"; $resn_exch{"1HE1 720"}="HE11 720"; $resn_exch{"2HE1 720"}="HE12 720";
$resn_exch{"3HE1 720"}="HE13 720"; $resn_exch{"1HMC 720"}="HMC1 720"; $resn_exch{"2HMC 720"}="HMC2 720";
$resn_exch{"1HB2 720"}="HB21 720"; $resn_exch{"2HB2 720"}="HB22 720"; $resn_exch{"1H31 730"}="H311 730";
$resn_exch{"2H31 730"}="H312 730"; $resn_exch{"1H30 730"}="H301 730"; $resn_exch{"2H30 730"}="H302 730";
$resn_exch{"1H32 730"}="H321 730"; $resn_exch{"2H32 730"}="H322 730"; $resn_exch{"1H33 730"}="H331 730";
$resn_exch{"2H33 730"}="H332 730"; $resn_exch{"1H36 730"}="H361 730"; $resn_exch{"2H36 730"}="H362 730";
$resn_exch{"1H28 730"}="H281 730"; $resn_exch{"2H28 730"}="H282 730"; $resn_exch{"1H27 730"}="H271 730";
$resn_exch{"2H27 730"}="H272 730"; $resn_exch{"1H14 730"}="H141 730"; $resn_exch{"2H14 730"}="H142 730";
$resn_exch{"1H22 730"}="H221 730"; $resn_exch{"2H22 730"}="H222 730"; $resn_exch{"1H25 736"}="H251 736";
$resn_exch{"2H25 736"}="H252 736"; $resn_exch{"1H26 736"}="H261 736"; $resn_exch{"2H26 736"}="H262 736";
$resn_exch{"1H28 736"}="H281 736"; $resn_exch{"2H28 736"}="H282 736"; $resn_exch{"1H29 736"}="H291 736";
$resn_exch{"2H29 736"}="H292 736"; $resn_exch{"1H2  736"}="H21A 736"; $resn_exch{"2H2  736"}=" H22 736";
$resn_exch{"1H7  736"}=" H71 736"; $resn_exch{"2H7  736"}=" H72 736"; $resn_exch{"1H8  736"}=" H81 736";
$resn_exch{"2H8  736"}=" H82 736"; $resn_exch{"1H14 736"}="H141 736"; $resn_exch{"2H14 736"}="H142 736";
$resn_exch{"1H15 736"}="H151 736"; $resn_exch{"2H15 736"}="H152 736"; $resn_exch{"3H15 736"}="H153 736";
$resn_exch{"1H06 737"}="H061 737"; $resn_exch{"2H06 737"}="H062 737"; $resn_exch{"1H07 737"}="H071 737";
$resn_exch{"2H07 737"}="H072 737"; $resn_exch{"1H08 737"}="H081 737"; $resn_exch{"2H08 737"}="H082 737";
$resn_exch{"1H11 737"}="H111 737"; $resn_exch{"2H11 737"}="H112 737"; $resn_exch{"1H15 737"}="H151 737";
$resn_exch{"2H15 737"}="H152 737"; $resn_exch{"1H29 737"}="H291 737"; $resn_exch{"2H29 737"}="H292 737";
$resn_exch{"3H29 737"}="H293 737"; $resn_exch{"1H35 737"}="H351 737"; $resn_exch{"2H35 737"}="H352 737";
$resn_exch{"1H8  738"}=" H81 738"; $resn_exch{"2H8  738"}=" H82 738"; $resn_exch{"1H12 738"}="H121 738";
$resn_exch{"2H12 738"}="H122 738"; $resn_exch{"1H9  738"}=" H91 738"; $resn_exch{"2H9  738"}=" H92 738";
$resn_exch{"1H4  738"}=" H41 738"; $resn_exch{"2H4  738"}=" H42 738"; $resn_exch{"1HBC 739"}="HBC1 739";
$resn_exch{"2HBC 739"}="HBC2 739"; $resn_exch{"1HCC 739"}="HCC1 739"; $resn_exch{"2HCC 739"}="HCC2 739";
$resn_exch{"1HNC 739"}="HNC1 739"; $resn_exch{"2HNC 739"}="HNC2 739"; $resn_exch{"1HCI 739"}="HCI1 739";
$resn_exch{"2HCI 739"}="HCI2 739"; $resn_exch{"3HCI 739"}="HCI3 739"; $resn_exch{"1HDI 739"}="HDI1 739";
$resn_exch{"2HDI 739"}="HDI2 739"; $resn_exch{"1HEI 739"}="HEI1 739"; $resn_exch{"2HEI 739"}="HEI2 739";
$resn_exch{"3HEI 739"}="HEI3 739"; $resn_exch{"1HI  739"}=" HI1 739"; $resn_exch{"2HI  739"}=" HI2 739";
$resn_exch{"1HBF 739"}="HBF1 739"; $resn_exch{"2HBF 739"}="HBF2 739"; $resn_exch{"1HBM 739"}="HBM1 739";
$resn_exch{"2HBM 739"}="HBM2 739"; $resn_exch{"1HCM 739"}="HCM1 739"; $resn_exch{"2HCM 739"}="HCM2 739";
$resn_exch{"1HEM 739"}="HEM1 739"; $resn_exch{"2HEM 739"}="HEM2 739"; $resn_exch{"3HEM 739"}="HEM3 739";
$resn_exch{"1H1  73Q"}=" H11 73Q"; $resn_exch{"2H1  73Q"}=" H12 73Q"; $resn_exch{"3H1  73Q"}=" H13 73Q";
$resn_exch{"1H3  73Q"}=" H31 73Q"; $resn_exch{"2H3  73Q"}=" H32 73Q"; $resn_exch{"3H3  73Q"}=" H33 73Q";
$resn_exch{"1H19 73V"}="H191 73V"; $resn_exch{"2H19 73V"}="H192 73V"; $resn_exch{"3H19 73V"}="H193 73V";
$resn_exch{"1H18 73V"}="H181 73V"; $resn_exch{"2H18 73V"}="H182 73V"; $resn_exch{"1H17 73V"}="H171 73V";
$resn_exch{"2H17 73V"}="H172 73V"; $resn_exch{"1H9  73V"}=" H91 73V"; $resn_exch{"2H9  73V"}=" H92 73V";
$resn_exch{"1H22 73V"}="H221 73V"; $resn_exch{"2H22 73V"}="H222 73V"; $resn_exch{"1H21 73V"}="H211 73V";
$resn_exch{"2H21 73V"}="H212 73V"; $resn_exch{"3H21 73V"}="H213 73V"; $resn_exch{"1H23 73V"}="H231 73V";
$resn_exch{"2H23 73V"}="H232 73V"; $resn_exch{"3H23 73V"}="H233 73V"; $resn_exch{"1H26 73V"}="H261 73V";
$resn_exch{"2H26 73V"}="H262 73V"; $resn_exch{"1H25 73V"}="H251 73V"; $resn_exch{"2H25 73V"}="H252 73V";
$resn_exch{"1H24 73V"}="H241 73V"; $resn_exch{"2H24 73V"}="H242 73V"; $resn_exch{"1H10 744"}="H101 744";
$resn_exch{"2H10 744"}="H102 744"; $resn_exch{"1H8  744"}=" H81 744"; $resn_exch{"2H8  744"}=" H82 744";
$resn_exch{"1H4  744"}=" H41 744"; $resn_exch{"2H4  744"}=" H42 744"; $resn_exch{"1H23 744"}="H231 744";
$resn_exch{"2H23 744"}="H232 744"; $resn_exch{"3H23 744"}="H233 744"; $resn_exch{"1H19 745"}="H191 745";
$resn_exch{"2H19 745"}="H192 745"; $resn_exch{"1H7  745"}=" H71 745"; $resn_exch{"2H7  745"}=" H72 745";
$resn_exch{"1H16 74M"}="H161 74M"; $resn_exch{"2H16 74M"}="H162 74M"; $resn_exch{"1H15 74M"}="H151 74M";
$resn_exch{"2H15 74M"}="H152 74M"; $resn_exch{"3H15 74M"}="H153 74M"; $resn_exch{"1H17 74M"}="H171 74M";
$resn_exch{"2H17 74M"}="H172 74M"; $resn_exch{"3H17 74M"}="H173 74M"; $resn_exch{"1H20 74M"}="H201 74M";
$resn_exch{"2H20 74M"}="H202 74M"; $resn_exch{"1H19 74M"}="H191 74M"; $resn_exch{"2H19 74M"}="H192 74M";
$resn_exch{"1H18 74M"}="H181 74M"; $resn_exch{"2H18 74M"}="H182 74M"; $resn_exch{"1H9  74M"}=" H91 74M";
$resn_exch{"2H9  74M"}=" H92 74M"; $resn_exch{"3H9  74M"}=" H93 74M"; $resn_exch{"1H11 74M"}="H111 74M";
$resn_exch{"2H11 74M"}="H112 74M"; $resn_exch{"1H12 74M"}="H121 74M"; $resn_exch{"2H12 74M"}="H122 74M";
$resn_exch{"1H13 74M"}="H131 74M"; $resn_exch{"2H13 74M"}="H132 74M"; $resn_exch{"3H13 74M"}="H133 74M";
$resn_exch{"1HC1 750"}="HC11 750"; $resn_exch{"2HC1 750"}="HC12 750"; $resn_exch{"1HC3 750"}="HC31 750";
$resn_exch{"2HC3 750"}="HC32 750"; $resn_exch{"1HC4 750"}="HC41 750"; $resn_exch{"2HC4 750"}="HC42 750";
$resn_exch{"1HC6 750"}="HC61 750"; $resn_exch{"2HC6 750"}="HC62 750"; $resn_exch{"1HC7 750"}="HC71 750";
$resn_exch{"2HC7 750"}="HC72 750"; $resn_exch{"1HC8 750"}="HC81 750"; $resn_exch{"2HC8 750"}="HC82 750";
$resn_exch{"1H23 750"}="H231 750"; $resn_exch{"2H23 750"}="H232 750"; $resn_exch{"1H25 750"}="H251 750";
$resn_exch{"2H25 750"}="H252 750"; $resn_exch{"3H25 750"}="H253 750"; $resn_exch{"1H26 750"}="H261 750";
$resn_exch{"2H26 750"}="H262 750"; $resn_exch{"3H26 750"}="H263 750"; $resn_exch{"1H33 750"}="H331 750";
$resn_exch{"2H33 750"}="H332 750"; $resn_exch{"1H35 750"}="H351 750"; $resn_exch{"2H35 750"}="H352 750";
$resn_exch{"1H36 750"}="H361 750"; $resn_exch{"2H36 750"}="H362 750"; $resn_exch{"1H37 750"}="H371 750";
$resn_exch{"2H37 750"}="H372 750"; $resn_exch{"1H40 750"}="H401 750"; $resn_exch{"2H40 750"}="H402 750";
$resn_exch{"1H10 75V"}="H101 75V"; $resn_exch{"2H10 75V"}="H102 75V"; $resn_exch{"1H11 75V"}="H111 75V";
$resn_exch{"2H11 75V"}="H112 75V"; $resn_exch{"3H11 75V"}="H113 75V"; $resn_exch{"1H14 75V"}="H141 75V";
$resn_exch{"2H14 75V"}="H142 75V"; $resn_exch{"1H13 75V"}="H131 75V"; $resn_exch{"2H13 75V"}="H132 75V";
$resn_exch{"3H13 75V"}="H133 75V"; $resn_exch{"1H15 75V"}="H151 75V"; $resn_exch{"2H15 75V"}="H152 75V";
$resn_exch{"3H15 75V"}="H153 75V"; $resn_exch{"1H16 75V"}="H161 75V"; $resn_exch{"2H16 75V"}="H162 75V";
$resn_exch{"3H16 75V"}="H163 75V"; $resn_exch{"2H1  760"}=" H12 760"; $resn_exch{"1H1  760"}=" H11 760";
$resn_exch{"2H2  760"}="H22A 760"; $resn_exch{"1H2  760"}="H21A 760"; $resn_exch{"2H3  760"}=" H32 760";
$resn_exch{"1H3  760"}=" H31 760"; $resn_exch{"2H4  760"}=" H42 760"; $resn_exch{"1H4  760"}=" H41 760";
$resn_exch{"1H17 760"}="H171 760"; $resn_exch{"2H17 760"}="H172 760"; $resn_exch{"1H1  761"}=" H11 761";
$resn_exch{"1H2  761"}=" H21 761"; $resn_exch{"1H5  761"}=" H51 761"; $resn_exch{"1H6  761"}=" H61 761";
$resn_exch{"1H11 761"}="H111 761"; $resn_exch{"1H14 761"}="H141 761"; $resn_exch{"H2'' 762"}=" H2B 762";
$resn_exch{"H3'' 762"}=" H3B 762"; $resn_exch{"H4'' 762"}=" H4B 762"; $resn_exch{"H5'' 762"}=" H5B 762";
$resn_exch{"H6'' 762"}=" H6B 762"; $resn_exch{"1H33 76A"}="H331 76A"; $resn_exch{"2H33 76A"}="H332 76A";
$resn_exch{"1H34 76A"}="H341 76A"; $resn_exch{"2H34 76A"}="H342 76A"; $resn_exch{"1H30 76A"}="H301 76A";
$resn_exch{"2H30 76A"}="H302 76A"; $resn_exch{"1H31 76A"}="H311 76A"; $resn_exch{"2H31 76A"}="H312 76A";
$resn_exch{"1H21 76A"}="H211 76A"; $resn_exch{"2H21 76A"}="H212 76A"; $resn_exch{"1H10 76V"}="H101 76V";
$resn_exch{"2H10 76V"}="H102 76V"; $resn_exch{"1H11 76V"}="H111 76V"; $resn_exch{"2H11 76V"}="H112 76V";
$resn_exch{"3H11 76V"}="H113 76V"; $resn_exch{"1H14 76V"}="H141 76V"; $resn_exch{"2H14 76V"}="H142 76V";
$resn_exch{"1H13 76V"}="H131 76V"; $resn_exch{"2H13 76V"}="H132 76V"; $resn_exch{"3H13 76V"}="H133 76V";
$resn_exch{"1H15 76V"}="H151 76V"; $resn_exch{"2H15 76V"}="H152 76V"; $resn_exch{"3H15 76V"}="H153 76V";
$resn_exch{"1H18 76V"}="H181 76V"; $resn_exch{"2H18 76V"}="H182 76V"; $resn_exch{"1H17 76V"}="H171 76V";
$resn_exch{"2H17 76V"}="H172 76V"; $resn_exch{"3H17 76V"}="H173 76V"; $resn_exch{"1H19 76V"}="H191 76V";
$resn_exch{"2H19 76V"}="H192 76V"; $resn_exch{"3H19 76V"}="H193 76V"; $resn_exch{"1H2N 771"}="H2N1 771";
$resn_exch{"2H2N 771"}="H2N2 771"; $resn_exch{"1H8C 771"}="H8C1 771"; $resn_exch{"2H8C 771"}="H8C2 771";
$resn_exch{"1H15 771"}="H151 771"; $resn_exch{"2H15 771"}="H152 771"; $resn_exch{"1H22 771"}="H221 771";
$resn_exch{"2H22 771"}="H222 771"; $resn_exch{"3H22 771"}="H223 771"; $resn_exch{"1H23 771"}="H231 771";
$resn_exch{"2H23 771"}="H232 771"; $resn_exch{"3H23 771"}="H233 771"; $resn_exch{"1H13 773"}="H131 773";
$resn_exch{"2H13 773"}="H132 773"; $resn_exch{"3H13 773"}="H133 773"; $resn_exch{"1H11 773"}="H111 773";
$resn_exch{"2H11 773"}="H112 773"; $resn_exch{"1H14 773"}="H141 773"; $resn_exch{"2H14 773"}="H142 773";
$resn_exch{"3H14 773"}="H143 773"; $resn_exch{"1H15 773"}="H151 773"; $resn_exch{"2H15 773"}="H152 773";
$resn_exch{"3H15 773"}="H153 773"; $resn_exch{"1H42 773"}="H421 773"; $resn_exch{"2H42 773"}="H422 773";
$resn_exch{"1H43 773"}="H431 773"; $resn_exch{"2H43 773"}="H432 773"; $resn_exch{"3H43 773"}="H433 773";
$resn_exch{"1H20 773"}="H201 773"; $resn_exch{"2H20 773"}="H202 773"; $resn_exch{"3H20 773"}="H203 773";
$resn_exch{"1H18 773"}="H181 773"; $resn_exch{"2H18 773"}="H182 773"; $resn_exch{"1H28 773"}="H281 773";
$resn_exch{"2H28 773"}="H282 773"; $resn_exch{"1H17 773"}="H171 773"; $resn_exch{"2H17 773"}="H172 773";
$resn_exch{"3H17 773"}="H173 773"; $resn_exch{"1H41 773"}="H411 773"; $resn_exch{"2H41 773"}="H412 773";
$resn_exch{"3H41 773"}="H413 773"; $resn_exch{"1H27 773"}="H271 773"; $resn_exch{"2H27 773"}="H272 773";
$resn_exch{"3H27 773"}="H273 773"; $resn_exch{"1H3  773"}=" H31 773"; $resn_exch{"2H3  773"}="H32A 773";
$resn_exch{"3H3  773"}=" H33 773"; $resn_exch{"1H6  773"}=" H61 773"; $resn_exch{"2H6  773"}=" H62 773";
$resn_exch{"3H6  773"}=" H63 773"; $resn_exch{"1H2  778"}="H21A 778"; $resn_exch{"2H2  778"}=" H22 778";
$resn_exch{"1H3  778"}=" H31 778"; $resn_exch{"2H3  778"}="H32A 778"; $resn_exch{"1H4  778"}=" H41 778";
$resn_exch{"2H4  778"}=" H42 778"; $resn_exch{"1H5  778"}=" H51 778"; $resn_exch{"2H5  778"}=" H52 778";
$resn_exch{"1H16 778"}="H161 778"; $resn_exch{"2H16 778"}="H162 778"; $resn_exch{"1H9  77A"}=" H91 77A";
$resn_exch{"2H9  77A"}=" H92 77A"; $resn_exch{"3H9  77A"}=" H93 77A"; $resn_exch{"1H22 77A"}="H221 77A";
$resn_exch{"2H22 77A"}="H222 77A"; $resn_exch{"1H24 77A"}="H241 77A"; $resn_exch{"2H24 77A"}="H242 77A";
$resn_exch{"3H24 77A"}="H243 77A"; $resn_exch{"1H25 77A"}="H251 77A"; $resn_exch{"2H25 77A"}="H252 77A";
$resn_exch{"3H25 77A"}="H253 77A"; $resn_exch{"1H26 77A"}="H261 77A"; $resn_exch{"2H26 77A"}="H262 77A";
$resn_exch{"3H26 77A"}="H263 77A"; $resn_exch{"1H17 77B"}="H171 77B"; $resn_exch{"2H17 77B"}="H172 77B";
$resn_exch{"1H26 77B"}="H261 77B"; $resn_exch{"2H26 77B"}="H262 77B"; $resn_exch{"1H25 77B"}="H251 77B";
$resn_exch{"2H25 77B"}="H252 77B"; $resn_exch{"3H25 77B"}="H253 77B"; $resn_exch{"1H27 77B"}="H271 77B";
$resn_exch{"2H27 77B"}="H272 77B"; $resn_exch{"3H27 77B"}="H273 77B"; $resn_exch{"1H9  77B"}=" H91 77B";
$resn_exch{"2H9  77B"}=" H92 77B"; $resn_exch{"1H30 77B"}="H301 77B"; $resn_exch{"2H30 77B"}="H302 77B";
$resn_exch{"1H29 77B"}="H291 77B"; $resn_exch{"2H29 77B"}="H292 77B"; $resn_exch{"1H28 77B"}="H281 77B";
$resn_exch{"2H28 77B"}="H282 77B"; $resn_exch{"H2'' 780"}=" H2B 780"; $resn_exch{"H3'' 780"}=" H3B 780";
$resn_exch{"H4'' 780"}=" H4B 780"; $resn_exch{"H5'' 780"}=" H5B 780"; $resn_exch{"H6'' 780"}=" H6B 780";
$resn_exch{"H2'' 783"}=" H2B 783"; $resn_exch{"H3'' 783"}=" H3B 783"; $resn_exch{"H4'' 783"}=" H4B 783";
$resn_exch{"H5'' 783"}=" H5B 783"; $resn_exch{"H6'' 783"}=" H6B 783"; $resn_exch{"1H19 784"}="H191 784";
$resn_exch{"2H19 784"}="H192 784"; $resn_exch{"1H21 784"}="H211 784"; $resn_exch{"2H21 784"}="H212 784";
$resn_exch{"1H23 784"}="H231 784"; $resn_exch{"2H23 784"}="H232 784"; $resn_exch{"1H32 784"}="H321 784";
$resn_exch{"2H32 784"}="H322 784"; $resn_exch{"3H32 784"}="H323 784"; $resn_exch{"1H31 784"}="H311 784";
$resn_exch{"2H31 784"}="H312 784"; $resn_exch{"3H31 784"}="H313 784"; $resn_exch{"1H30 784"}="H301 784";
$resn_exch{"2H30 784"}="H302 784"; $resn_exch{"3H30 784"}="H303 784"; $resn_exch{"1H14 784"}="H141 784";
$resn_exch{"2H14 784"}="H142 784"; $resn_exch{"1H15 784"}="H151 784"; $resn_exch{"2H15 784"}="H152 784";
$resn_exch{"1H8C 784"}="H8C1 784"; $resn_exch{"2H8C 784"}="H8C2 784"; $resn_exch{"1H24 784"}="H241 784";
$resn_exch{"2H24 784"}="H242 784"; $resn_exch{"1H10 78A"}="H101 78A"; $resn_exch{"2H10 78A"}="H102 78A";
$resn_exch{"1H19 78A"}="H191 78A"; $resn_exch{"2H19 78A"}="H192 78A"; $resn_exch{"1H18 78A"}="H181 78A";
$resn_exch{"2H18 78A"}="H182 78A"; $resn_exch{"3H18 78A"}="H183 78A"; $resn_exch{"1H20 78A"}="H201 78A";
$resn_exch{"2H20 78A"}="H202 78A"; $resn_exch{"3H20 78A"}="H203 78A"; $resn_exch{"1H23 78A"}="H231 78A";
$resn_exch{"2H23 78A"}="H232 78A"; $resn_exch{"1H22 78A"}="H221 78A"; $resn_exch{"2H22 78A"}="H222 78A";
$resn_exch{"1H21 78A"}="H211 78A"; $resn_exch{"2H21 78A"}="H212 78A"; $resn_exch{"1H1  790"}=" H11 790";
$resn_exch{"2H1  790"}=" H12 790"; $resn_exch{"1H2  790"}="H21A 790"; $resn_exch{"2H2  790"}=" H22 790";
$resn_exch{"1H6  790"}=" H61 790"; $resn_exch{"2H6  790"}=" H62 790"; $resn_exch{"1H10 796"}="H101 796";
$resn_exch{"2H10 796"}="H102 796"; $resn_exch{"3H10 796"}="H103 796"; $resn_exch{"1H27 796"}="H271 796";
$resn_exch{"2H27 796"}="H272 796"; $resn_exch{"1H43 796"}="H431 796"; $resn_exch{"2H43 796"}="H432 796";
$resn_exch{"1H28 796"}="H281 796"; $resn_exch{"2H28 796"}="H282 796"; $resn_exch{"1H5  7A8"}=" H51 7A8";
$resn_exch{"2H5  7A8"}=" H52 7A8"; $resn_exch{"1H8  7A8"}=" H81 7A8"; $resn_exch{"2H8  7A8"}=" H82 7A8";
$resn_exch{"1H9  7A8"}=" H91 7A8"; $resn_exch{"2H9  7A8"}=" H92 7A8"; $resn_exch{"1H13 7A8"}="H131 7A8";
$resn_exch{"2H13 7A8"}="H132 7A8"; $resn_exch{"3H13 7A8"}="H133 7A8"; $resn_exch{"1H14 7A8"}="H141 7A8";
$resn_exch{"2H14 7A8"}="H142 7A8"; $resn_exch{"3H14 7A8"}="H143 7A8"; $resn_exch{"1H15 7A8"}="H151 7A8";
$resn_exch{"2H15 7A8"}="H152 7A8"; $resn_exch{"3H15 7A8"}="H153 7A8"; $resn_exch{"1HN1 7AD"}="HN11 7AD";
$resn_exch{"2HN1 7AD"}="HN12 7AD"; $resn_exch{"1H15 7AD"}="H151 7AD"; $resn_exch{"2H15 7AD"}="H152 7AD";
$resn_exch{"1H16 7AD"}="H161 7AD"; $resn_exch{"2H16 7AD"}="H162 7AD"; $resn_exch{"1H17 7AD"}="H171 7AD";
$resn_exch{"2H17 7AD"}="H172 7AD"; $resn_exch{"1H18 7AD"}="H181 7AD"; $resn_exch{"2H18 7AD"}="H182 7AD";
$resn_exch{"3H18 7AD"}="H183 7AD"; $resn_exch{"1H19 7AD"}="H191 7AD"; $resn_exch{"2H19 7AD"}="H192 7AD";
$resn_exch{"3H19 7AD"}="H193 7AD"; $resn_exch{"7H7  7AP"}=" H77 7AP"; $resn_exch{"'H1' 7AP"}="H1'' 7AP";
$resn_exch{"'H2' 7AP"}="H2'' 7AP"; $resn_exch{"1H3' 7AP"}="H3'1 7AP"; $resn_exch{"2H3' 7AP"}="H3'2 7AP";
$resn_exch{"3H3' 7AP"}="H3'3 7AP"; $resn_exch{"1H1  7CA"}=" H11 7CA"; $resn_exch{"2H1  7CA"}=" H12 7CA";
$resn_exch{"3H1  7CA"}=" H13 7CA"; $resn_exch{"1H17 7CA"}="H171 7CA"; $resn_exch{"2H17 7CA"}="H172 7CA";
$resn_exch{"1H18 7CA"}="H181 7CA"; $resn_exch{"2H18 7CA"}="H182 7CA"; $resn_exch{"1H20 7CA"}="H201 7CA";
$resn_exch{"2H20 7CA"}="H202 7CA"; $resn_exch{"3H20 7CA"}="H203 7CA"; $resn_exch{"1H21 7CA"}="H211 7CA";
$resn_exch{"2H21 7CA"}="H212 7CA"; $resn_exch{"3H21 7CA"}="H213 7CA"; $resn_exch{"1H27 7CA"}="H271 7CA";
$resn_exch{"2H27 7CA"}="H272 7CA"; $resn_exch{"3H27 7CA"}="H273 7CA"; $resn_exch{"1H8  7CS"}=" H81 7CS";
$resn_exch{"2H8  7CS"}=" H82 7CS"; $resn_exch{"3H8  7CS"}=" H83 7CS"; $resn_exch{"1H7  7CS"}=" H71 7CS";
$resn_exch{"2H7  7CS"}=" H72 7CS"; $resn_exch{"1H6  7CS"}=" H61 7CS"; $resn_exch{"2H6  7CS"}=" H62 7CS";
$resn_exch{"1H4  7CS"}=" H41 7CS"; $resn_exch{"2H4  7CS"}=" H42 7CS"; $resn_exch{"1H2  7CS"}=" H21 7CS";
$resn_exch{"2H2  7CS"}=" H22 7CS"; $resn_exch{"2HOP 7DA"}="HOP2 7DA"; $resn_exch{"1HN6 7DA"}="HN61 7DA";
$resn_exch{"2HN6 7DA"}="HN62 7DA"; $resn_exch{"1H2* 7DA"}=" H2' 7DA"; $resn_exch{"2H2* 7DA"}="H2'' 7DA";
$resn_exch{"1H5* 7DA"}=" H5' 7DA"; $resn_exch{"2H5* 7DA"}="H5'' 7DA"; $resn_exch{" H4* 7DA"}=" H4' 7DA";
$resn_exch{" H1* 7DA"}=" H1' 7DA"; $resn_exch{"H3T  7DA"}="HO3' 7DA"; $resn_exch{"3HOP 7DA"}="HOP3 7DA";
$resn_exch{"1H6  7DE"}=" H61 7DE"; $resn_exch{"2H6  7DE"}=" H62 7DE"; $resn_exch{"3H6  7DE"}=" H63 7DE";
$resn_exch{"1H9  7DE"}=" H91 7DE"; $resn_exch{"2H9  7DE"}=" H92 7DE"; $resn_exch{"3H9  7DE"}=" H93 7DE";
$resn_exch{"1H16 7DE"}="H161 7DE"; $resn_exch{"2H16 7DE"}="H162 7DE"; $resn_exch{"1H17 7DE"}="H171 7DE";
$resn_exch{"2H17 7DE"}="H172 7DE"; $resn_exch{"3H17 7DE"}="H173 7DE"; $resn_exch{"1H7  7DG"}=" H71 7DG";
$resn_exch{"2H7  7DG"}=" H72 7DG"; $resn_exch{"1HN2 7DG"}="HN21 7DG"; $resn_exch{"2HN2 7DG"}="HN22 7DG";
$resn_exch{"1H6  7GP"}=" H61 7GP"; $resn_exch{"2H6  7GP"}=" H62 7GP"; $resn_exch{"1H9  7GP"}=" H91 7GP";
$resn_exch{"2H9  7GP"}=" H92 7GP"; $resn_exch{"1H10 7GP"}="H101 7GP"; $resn_exch{"2H10 7GP"}="H102 7GP";
$resn_exch{"3H10 7GP"}="H103 7GP"; $resn_exch{"2HOP 7GU"}="HOP2 7GU"; $resn_exch{"1HN2 7GU"}="HN21 7GU";
$resn_exch{"2HN2 7GU"}="HN22 7GU"; $resn_exch{"1H2* 7GU"}=" H2' 7GU"; $resn_exch{"2H2* 7GU"}="H2'' 7GU";
$resn_exch{"1H5* 7GU"}=" H5' 7GU"; $resn_exch{"2H5* 7GU"}="H5'' 7GU"; $resn_exch{" H4* 7GU"}=" H4' 7GU";
$resn_exch{" H1* 7GU"}=" H1' 7GU"; $resn_exch{" H3* 7GU"}=" H3' 7GU"; $resn_exch{"H3T  7GU"}="HO3' 7GU";
$resn_exch{"3HOP 7GU"}="HOP3 7GU"; $resn_exch{"1HMA 7HE"}="HMA1 7HE"; $resn_exch{"2HMA 7HE"}="HMA2 7HE";
$resn_exch{"3HMA 7HE"}="HMA3 7HE"; $resn_exch{"1HAA 7HE"}="HAA1 7HE"; $resn_exch{"2HAA 7HE"}="HAA2 7HE";
$resn_exch{"3HAA 7HE"}="HAA3 7HE"; $resn_exch{"1HMB 7HE"}="HMB1 7HE"; $resn_exch{"2HMB 7HE"}="HMB2 7HE";
$resn_exch{"3HMB 7HE"}="HMB3 7HE"; $resn_exch{"1HBB 7HE"}="HBB1 7HE"; $resn_exch{"2HBB 7HE"}="HBB2 7HE";
$resn_exch{"1HMC 7HE"}="HMC1 7HE"; $resn_exch{"2HMC 7HE"}="HMC2 7HE"; $resn_exch{"3HMC 7HE"}="HMC3 7HE";
$resn_exch{"1HBC 7HE"}="HBC1 7HE"; $resn_exch{"2HBC 7HE"}="HBC2 7HE"; $resn_exch{"1HMD 7HE"}="HMD1 7HE";
$resn_exch{"2HMD 7HE"}="HMD2 7HE"; $resn_exch{"3HMD 7HE"}="HMD3 7HE"; $resn_exch{"1HAD 7HE"}="HAD1 7HE";
$resn_exch{"2HAD 7HE"}="HAD2 7HE"; $resn_exch{"1HBD 7HE"}="HBD1 7HE"; $resn_exch{"2HBD 7HE"}="HBD2 7HE";
$resn_exch{"1H3  7I2"}=" H31 7I2"; $resn_exch{"1H4  7I2"}=" H41 7I2"; $resn_exch{"1H5  7I2"}=" H51 7I2";
$resn_exch{"1H6  7I2"}=" H61 7I2"; $resn_exch{"1H15 7I2"}="H151 7I2"; $resn_exch{"2H15 7I2"}="H152 7I2";
$resn_exch{"1HN3 7IG"}="HN31 7IG"; $resn_exch{"2HN3 7IG"}="HN32 7IG"; $resn_exch{"1HN4 7IG"}="HN41 7IG";
$resn_exch{"2HN4 7IG"}="HN42 7IG"; $resn_exch{"1H5  7IG"}=" H51 7IG"; $resn_exch{"2H5  7IG"}=" H52 7IG";
$resn_exch{"1H6  7IG"}=" H61 7IG"; $resn_exch{"2H6  7IG"}=" H62 7IG"; $resn_exch{"3H6  7IG"}=" H63 7IG";
$resn_exch{"1H19 7IG"}="H191 7IG"; $resn_exch{"2H19 7IG"}="H192 7IG"; $resn_exch{"1H3  7IN"}="H31A 7IN";
$resn_exch{"2H3  7IN"}=" H32 7IN"; $resn_exch{"1H10 7IN"}="H101 7IN"; $resn_exch{"2H10 7IN"}="H102 7IN";
$resn_exch{"1H19 7IN"}="H191 7IN"; $resn_exch{"2H19 7IN"}="H192 7IN"; $resn_exch{"1H25 7IN"}="H251 7IN";
$resn_exch{"2H25 7IN"}="H252 7IN"; $resn_exch{"1H34 7IN"}="H341 7IN"; $resn_exch{"2H34 7IN"}="H342 7IN";
$resn_exch{"1H1  7IP"}="H11A 7IP"; $resn_exch{"2H1  7IP"}="H12A 7IP"; $resn_exch{"3H1  7IP"}=" H13 7IP";
$resn_exch{"1H14 7IP"}="H141 7IP"; $resn_exch{"2H14 7IP"}="H142 7IP"; $resn_exch{"1H15 7IP"}="H151 7IP";
$resn_exch{"2H15 7IP"}="H152 7IP"; $resn_exch{"1H21 7IP"}="H211 7IP"; $resn_exch{"2H21 7IP"}="H212 7IP";
$resn_exch{"2HOP 7MG"}="HOP2 7MG"; $resn_exch{"3HOP 7MG"}="HOP3 7MG"; $resn_exch{"1H5* 7MG"}=" H5' 7MG";
$resn_exch{"2H5* 7MG"}="H5'' 7MG"; $resn_exch{" H4* 7MG"}=" H4' 7MG"; $resn_exch{" H3* 7MG"}=" H3' 7MG";
$resn_exch{"*HO3 7MG"}="HO3' 7MG"; $resn_exch{" H2* 7MG"}=" H2' 7MG"; $resn_exch{"*HO2 7MG"}="HO2' 7MG";
$resn_exch{" H1* 7MG"}=" H1' 7MG"; $resn_exch{"1H8  7MG"}=" H81 7MG"; $resn_exch{"2H8  7MG"}=" H82 7MG";
$resn_exch{"1HN2 7MG"}="HN21 7MG"; $resn_exch{"2HN2 7MG"}="HN22 7MG"; $resn_exch{"1HM7 7MG"}="HM71 7MG";
$resn_exch{"2HM7 7MG"}="HM72 7MG"; $resn_exch{"3HM7 7MG"}="HM73 7MG"; $resn_exch{"1HAT 7MP"}="HAT1 7MP";
$resn_exch{"2HAT 7MP"}="HAT2 7MP"; $resn_exch{"3HAT 7MP"}="HAT3 7MP"; $resn_exch{"1HAS 7MP"}="HAS1 7MP";
$resn_exch{"2HAS 7MP"}="HAS2 7MP"; $resn_exch{"1HAR 7MP"}="HAR1 7MP"; $resn_exch{"2HAR 7MP"}="HAR2 7MP";
$resn_exch{"3HAR 7MP"}="HAR3 7MP"; $resn_exch{"1H3M 7MQ"}="H3M1 7MQ"; $resn_exch{"2H3M 7MQ"}="H3M2 7MQ";
$resn_exch{"3H3M 7MQ"}="H3M3 7MQ"; $resn_exch{"1H11 7MQ"}="H111 7MQ"; $resn_exch{"2H11 7MQ"}="H112 7MQ";
$resn_exch{"1H14 7MQ"}="H141 7MQ"; $resn_exch{"2H14 7MQ"}="H142 7MQ"; $resn_exch{"3H14 7MQ"}="H143 7MQ";
$resn_exch{"1H15 7MQ"}="H151 7MQ"; $resn_exch{"2H15 7MQ"}="H152 7MQ"; $resn_exch{"1H16 7MQ"}="H161 7MQ";
$resn_exch{"2H16 7MQ"}="H162 7MQ"; $resn_exch{"1H19 7MQ"}="H191 7MQ"; $resn_exch{"2H19 7MQ"}="H192 7MQ";
$resn_exch{"3H19 7MQ"}="H193 7MQ"; $resn_exch{"1H20 7MQ"}="H201 7MQ"; $resn_exch{"2H20 7MQ"}="H202 7MQ";
$resn_exch{"1H21 7MQ"}="H211 7MQ"; $resn_exch{"2H21 7MQ"}="H212 7MQ"; $resn_exch{"1H24 7MQ"}="H241 7MQ";
$resn_exch{"2H24 7MQ"}="H242 7MQ"; $resn_exch{"3H24 7MQ"}="H243 7MQ"; $resn_exch{"1H25 7MQ"}="H251 7MQ";
$resn_exch{"2H25 7MQ"}="H252 7MQ"; $resn_exch{"1H26 7MQ"}="H261 7MQ"; $resn_exch{"2H26 7MQ"}="H262 7MQ";
$resn_exch{"1H29 7MQ"}="H291 7MQ"; $resn_exch{"2H29 7MQ"}="H292 7MQ"; $resn_exch{"3H29 7MQ"}="H293 7MQ";
$resn_exch{"1H30 7MQ"}="H301 7MQ"; $resn_exch{"2H30 7MQ"}="H302 7MQ"; $resn_exch{"1H31 7MQ"}="H311 7MQ";
$resn_exch{"2H31 7MQ"}="H312 7MQ"; $resn_exch{"1H34 7MQ"}="H341 7MQ"; $resn_exch{"2H34 7MQ"}="H342 7MQ";
$resn_exch{"3H34 7MQ"}="H343 7MQ"; $resn_exch{"1H35 7MQ"}="H351 7MQ"; $resn_exch{"2H35 7MQ"}="H352 7MQ";
$resn_exch{"1H36 7MQ"}="H361 7MQ"; $resn_exch{"2H36 7MQ"}="H362 7MQ"; $resn_exch{"1H39 7MQ"}="H391 7MQ";
$resn_exch{"2H39 7MQ"}="H392 7MQ"; $resn_exch{"3H39 7MQ"}="H393 7MQ"; $resn_exch{"1H40 7MQ"}="H401 7MQ";
$resn_exch{"2H40 7MQ"}="H402 7MQ"; $resn_exch{"1H41 7MQ"}="H411 7MQ"; $resn_exch{"2H41 7MQ"}="H412 7MQ";
$resn_exch{"1H44 7MQ"}="H441 7MQ"; $resn_exch{"2H44 7MQ"}="H442 7MQ"; $resn_exch{"3H44 7MQ"}="H443 7MQ";
$resn_exch{"1H45 7MQ"}="H451 7MQ"; $resn_exch{"2H45 7MQ"}="H452 7MQ"; $resn_exch{"3H45 7MQ"}="H453 7MQ";
$resn_exch{"1HAN 7MR"}="HAN1 7MR"; $resn_exch{"2HAN 7MR"}="HAN2 7MR"; $resn_exch{"1HAZ 7MR"}="HAZ1 7MR";
$resn_exch{"2HAZ 7MR"}="HAZ2 7MR"; $resn_exch{"H2'' 7NH"}=" H2B 7NH"; $resn_exch{"H3'' 7NH"}=" H3B 7NH";
$resn_exch{"H4'' 7NH"}=" H4B 7NH"; $resn_exch{"H6'' 7NH"}=" H6B 7NH"; $resn_exch{"1H51 7NH"}="H511 7NH";
$resn_exch{"2H51 7NH"}="H512 7NH"; $resn_exch{"1H54 7NH"}="H541 7NH"; $resn_exch{"2H54 7NH"}="H542 7NH";
$resn_exch{"1H1  7NI"}=" H11 7NI"; $resn_exch{"1H3  7NI"}=" H31 7NI"; $resn_exch{"1H4  7NI"}=" H41 7NI";
$resn_exch{"1H5  7NI"}=" H51 7NI"; $resn_exch{"1H6  7NI"}=" H61 7NI"; $resn_exch{"1H1  7PA"}=" H11 7PA";
$resn_exch{"2H1  7PA"}=" H12 7PA"; $resn_exch{"1H2  7PA"}=" H21 7PA"; $resn_exch{"2H2  7PA"}=" H22 7PA";
$resn_exch{"1H3  7PA"}=" H31 7PA"; $resn_exch{"2H3  7PA"}=" H32 7PA"; $resn_exch{"1H29 7PC"}="H291 7PC";
$resn_exch{"2H29 7PC"}="H292 7PC"; $resn_exch{"1H30 7PC"}="H301 7PC"; $resn_exch{"2H30 7PC"}="H302 7PC";
$resn_exch{"1H21 7PE"}="H211 7PE"; $resn_exch{"2H21 7PE"}="H212 7PE"; $resn_exch{"3H21 7PE"}="H213 7PE";
$resn_exch{"1H20 7PE"}="H201 7PE"; $resn_exch{"2H20 7PE"}="H202 7PE"; $resn_exch{"1H18 7PE"}="H181 7PE";
$resn_exch{"2H18 7PE"}="H182 7PE"; $resn_exch{"1H17 7PE"}="H171 7PE"; $resn_exch{"2H17 7PE"}="H172 7PE";
$resn_exch{"1H15 7PE"}="H151 7PE"; $resn_exch{"2H15 7PE"}="H152 7PE"; $resn_exch{"1H14 7PE"}="H141 7PE";
$resn_exch{"2H14 7PE"}="H142 7PE"; $resn_exch{"1H12 7PE"}="H121 7PE"; $resn_exch{"2H12 7PE"}="H122 7PE";
$resn_exch{"1H11 7PE"}="H111 7PE"; $resn_exch{"2H11 7PE"}="H112 7PE"; $resn_exch{"1H9  7PE"}=" H91 7PE";
$resn_exch{"2H9  7PE"}=" H92 7PE"; $resn_exch{"1H8  7PE"}=" H81 7PE"; $resn_exch{"2H8  7PE"}=" H82 7PE";
$resn_exch{"1H6  7PE"}=" H61 7PE"; $resn_exch{"2H6  7PE"}=" H62 7PE"; $resn_exch{"1H5  7PE"}=" H51 7PE";
$resn_exch{"2H5  7PE"}=" H52 7PE"; $resn_exch{"1H3  7PE"}=" H31 7PE"; $resn_exch{"2H3  7PE"}=" H32 7PE";
$resn_exch{"1H2  7PE"}=" H21 7PE"; $resn_exch{"2H2  7PE"}=" H22 7PE"; $resn_exch{"1H1  7PG"}=" H11 7PG";
$resn_exch{"2H1  7PG"}=" H12 7PG"; $resn_exch{"1H2  7PG"}=" H21 7PG"; $resn_exch{"2H2  7PG"}=" H22 7PG";
$resn_exch{"1H3  7PG"}=" H31 7PG"; $resn_exch{"2H3  7PG"}=" H32 7PG"; $resn_exch{"1H4  7PG"}=" H41 7PG";
$resn_exch{"2H4  7PG"}=" H42 7PG"; $resn_exch{"1H5  7PG"}=" H51 7PG"; $resn_exch{"2H5  7PG"}=" H52 7PG";
$resn_exch{"1H6  7PG"}=" H61 7PG"; $resn_exch{"2H6  7PG"}=" H62 7PG"; $resn_exch{"1H7  7PG"}=" H71 7PG";
$resn_exch{"2H7  7PG"}=" H72 7PG"; $resn_exch{"1H8  7PG"}=" H81 7PG"; $resn_exch{"2H8  7PG"}=" H82 7PG";
$resn_exch{"1H9  7PG"}=" H91 7PG"; $resn_exch{"2H9  7PG"}=" H92 7PG"; $resn_exch{"1H10 7PG"}="H101 7PG";
$resn_exch{"2H10 7PG"}="H102 7PG"; $resn_exch{"1H11 7PG"}="H111 7PG"; $resn_exch{"2H11 7PG"}="H112 7PG";
$resn_exch{"1H12 7PG"}="H121 7PG"; $resn_exch{"2H12 7PG"}="H122 7PG"; $resn_exch{"1H13 7PG"}="H131 7PG";
$resn_exch{"2H13 7PG"}="H132 7PG"; $resn_exch{"1H14 7PG"}="H141 7PG"; $resn_exch{"2H14 7PG"}="H142 7PG";
$resn_exch{"1H15 7PG"}="H151 7PG"; $resn_exch{"2H15 7PG"}="H152 7PG"; $resn_exch{"1H16 7PG"}="H161 7PG";
$resn_exch{"2H16 7PG"}="H162 7PG"; $resn_exch{"1H17 7PG"}="H171 7PG"; $resn_exch{"2H17 7PG"}="H172 7PG";
$resn_exch{"3H17 7PG"}="H173 7PG"; $resn_exch{"1HAX 7PY"}="HAX1 7PY"; $resn_exch{"2HAX 7PY"}="HAX2 7PY";
$resn_exch{"3HAX 7PY"}="HAX3 7PY"; $resn_exch{"1HAZ 7PY"}="HAZ1 7PY"; $resn_exch{"2HAZ 7PY"}="HAZ2 7PY";
$resn_exch{"3HAZ 7PY"}="HAZ3 7PY"; $resn_exch{"1HBB 7PY"}="HBB1 7PY"; $resn_exch{"2HBB 7PY"}="HBB2 7PY";
$resn_exch{"3HBB 7PY"}="HBB3 7PY"; $resn_exch{"1H10 7RA"}="H101 7RA"; $resn_exch{"2H10 7RA"}="H102 7RA";
$resn_exch{"2HOP 7RA"}="HOP2 7RA"; $resn_exch{"3HOP 7RA"}="HOP3 7RA"; $resn_exch{"1H5* 7RA"}="H5'1 7RA";
$resn_exch{"2H5* 7RA"}="H5'2 7RA"; $resn_exch{" H4* 7RA"}=" H4' 7RA"; $resn_exch{" H3* 7RA"}=" H3' 7RA";
$resn_exch{"3HO* 7RA"}="HO'3 7RA"; $resn_exch{" H2* 7RA"}=" H2' 7RA"; $resn_exch{"2HO* 7RA"}="HO'2 7RA";
$resn_exch{" H1* 7RA"}=" H1' 7RA"; $resn_exch{"2HOP 7RP"}="HOP2 7RP"; $resn_exch{"3HOP 7RP"}="HOP3 7RP";
$resn_exch{"1H5* 7RP"}="H5'1 7RP"; $resn_exch{"2H5* 7RP"}="H5'2 7RP"; $resn_exch{" H4* 7RP"}=" H4' 7RP";
$resn_exch{" H3* 7RP"}=" H3' 7RP"; $resn_exch{"3HO* 7RP"}="HO'3 7RP"; $resn_exch{" H2* 7RP"}=" H2' 7RP";
$resn_exch{"2HO* 7RP"}="HO'2 7RP"; $resn_exch{" H1* 7RP"}=" H1' 7RP"; $resn_exch{"1HAY 7XY"}="HAY1 7XY";
$resn_exch{"2HAY 7XY"}="HAY2 7XY"; $resn_exch{"1HAZ 7XY"}="HAZ1 7XY"; $resn_exch{"2HAZ 7XY"}="HAZ2 7XY";
$resn_exch{"1HAW 7XY"}="HAW1 7XY"; $resn_exch{"2HAW 7XY"}="HAW2 7XY"; $resn_exch{"1HAX 7XY"}="HAX1 7XY";
$resn_exch{"2HAX 7XY"}="HAX2 7XY"; $resn_exch{"1H2  803"}=" H21 803"; $resn_exch{"2H2  803"}=" H22 803";
$resn_exch{"1H21 803"}="H211 803"; $resn_exch{"2H21 803"}="H212 803"; $resn_exch{"3H21 803"}="H213 803";
$resn_exch{"1H20 803"}="H201 803"; $resn_exch{"2H20 803"}="H202 803"; $resn_exch{"3H20 803"}="H203 803";
$resn_exch{"1H10 803"}="H101 803"; $resn_exch{"2H10 803"}="H102 803"; $resn_exch{"1H11 803"}="H111 803";
$resn_exch{"2H11 803"}="H112 803"; $resn_exch{"1H13 803"}="H131 803"; $resn_exch{"2H13 803"}="H132 803";
$resn_exch{"1H15 803"}="H151 803"; $resn_exch{"2H15 803"}="H152 803"; $resn_exch{"1H19 803"}="H191 803";
$resn_exch{"2H19 803"}="H192 803"; $resn_exch{"3H19 803"}="H193 803"; $resn_exch{"1H17 803"}="H171 803";
$resn_exch{"2H17 803"}="H172 803"; $resn_exch{"1H18 803"}="H181 803"; $resn_exch{"2H18 803"}="H182 803";
$resn_exch{"3H18 803"}="H183 803"; $resn_exch{"1HN2 806"}="HN21 806"; $resn_exch{"2HN2 806"}="HN22 806";
$resn_exch{"1H12 806"}="H121 806"; $resn_exch{"2H12 806"}="H122 806"; $resn_exch{"1H42 806"}="H421 806";
$resn_exch{"2H42 806"}="H422 806"; $resn_exch{"1H43 806"}="H431 806"; $resn_exch{"2H43 806"}="H432 806";
$resn_exch{"1H44 806"}="H441 806"; $resn_exch{"2H44 806"}="H442 806"; $resn_exch{"1H45 806"}="H451 806";
$resn_exch{"2H45 806"}="H452 806"; $resn_exch{"1H47 806"}="H471 806"; $resn_exch{"2H47 806"}="H472 806";
$resn_exch{"3H47 806"}="H473 806"; $resn_exch{"1H1  815"}=" H11 815"; $resn_exch{"1H2  815"}=" H21 815";
$resn_exch{"1H5  815"}=" H51 815"; $resn_exch{"1H10 815"}="H101 815"; $resn_exch{"1H11 815"}="H111 815";
$resn_exch{"1H17 815"}="H171 815"; $resn_exch{"1H18 815"}="H181 815"; $resn_exch{"1H19 815"}="H191 815";
$resn_exch{"1H25 815"}="H251 815"; $resn_exch{"1H30 815"}="H301 815"; $resn_exch{"1H31 815"}="H311 815";
$resn_exch{"2H31 815"}="H312 815"; $resn_exch{"1H32 815"}="H321 815"; $resn_exch{"2H32 815"}="H322 815";
$resn_exch{"1H37 815"}="H371 815"; $resn_exch{"1H42 815"}="H421 815"; $resn_exch{"2H42 815"}="H422 815";
$resn_exch{"1H43 815"}="H431 815"; $resn_exch{"2H43 815"}="H432 815"; $resn_exch{"1HN2 817"}="HN21 817";
$resn_exch{"2HN2 817"}="HN22 817"; $resn_exch{"1H3  817"}=" H31 817"; $resn_exch{"2H3  817"}=" H32 817";
$resn_exch{"1H3  818"}="H31A 818"; $resn_exch{"2H3  818"}="H32A 818"; $resn_exch{"1H4  818"}=" H41 818";
$resn_exch{"2H4  818"}=" H42 818"; $resn_exch{"1H5  818"}=" H51 818"; $resn_exch{"2H5  818"}=" H52 818";
$resn_exch{"1H6  818"}=" H61 818"; $resn_exch{"2H6  818"}=" H62 818"; $resn_exch{"1H12 818"}="H121 818";
$resn_exch{"2H12 818"}="H122 818"; $resn_exch{"1H16 818"}="H161 818"; $resn_exch{"2H16 818"}="H162 818";
$resn_exch{"1H23 818"}="H231 818"; $resn_exch{"2H23 818"}="H232 818"; $resn_exch{"1H30 818"}="H301 818";
$resn_exch{"2H30 818"}="H302 818"; $resn_exch{"1H33 818"}="H331 818"; $resn_exch{"2H33 818"}="H332 818";
$resn_exch{"1H34 818"}="H341 818"; $resn_exch{"2H34 818"}="H342 818"; $resn_exch{"1H35 818"}="H351 818";
$resn_exch{"2H35 818"}="H352 818"; $resn_exch{"3H35 818"}="H353 818"; $resn_exch{"1H36 818"}="H361 818";
$resn_exch{"2H36 818"}="H362 818"; $resn_exch{"3H36 818"}="H363 818"; $resn_exch{"1H37 818"}="H371 818";
$resn_exch{"2H37 818"}="H372 818"; $resn_exch{"3H37 818"}="H373 818"; $resn_exch{"1H38 818"}="H381 818";
$resn_exch{"2H38 818"}="H382 818"; $resn_exch{"1H39 818"}="H391 818"; $resn_exch{"2H39 818"}="H392 818";
$resn_exch{"3H39 818"}="H393 818"; $resn_exch{"1H41 818"}="H411 818"; $resn_exch{"2H41 818"}="H412 818";
$resn_exch{"3H41 818"}="H413 818"; $resn_exch{"1H42 818"}="H421 818"; $resn_exch{"2H42 818"}="H422 818";
$resn_exch{"3H42 818"}="H423 818"; $resn_exch{"1H43 818"}="H431 818"; $resn_exch{"2H43 818"}="H432 818";
$resn_exch{"3H43 818"}="H433 818"; $resn_exch{"1H44 818"}="H441 818"; $resn_exch{"2H44 818"}="H442 818";
$resn_exch{"3H44 818"}="H443 818"; $resn_exch{"1H45 818"}="H451 818"; $resn_exch{"2H45 818"}="H452 818";
$resn_exch{"3H45 818"}="H453 818"; $resn_exch{"0HO1 818"}="HO10 818"; $resn_exch{"2HO1 818"}="HO12 818";
$resn_exch{"3HO1 818"}="HO13 818"; $resn_exch{"1H16 81A"}="H161 81A"; $resn_exch{"2H16 81A"}="H162 81A";
$resn_exch{"3H16 81A"}="H163 81A"; $resn_exch{"1H2A 81A"}="H21A 81A"; $resn_exch{"2H2A 81A"}="H22A 81A";
$resn_exch{"3H2A 81A"}="H23A 81A"; $resn_exch{"1H10 81A"}="H101 81A"; $resn_exch{"2H10 81A"}="H102 81A";
$resn_exch{"1H14 81A"}="H141 81A"; $resn_exch{"2H14 81A"}="H142 81A"; $resn_exch{"3H14 81A"}="H143 81A";
$resn_exch{"4H14 81A"}="H144 81A"; $resn_exch{"1H15 81A"}="H151 81A"; $resn_exch{"2H15 81A"}="H152 81A";
$resn_exch{"1H5  821"}=" H51 821"; $resn_exch{"2H5  821"}=" H52 821"; $resn_exch{"3H5  821"}=" H53 821";
$resn_exch{"1H15 821"}="H151 821"; $resn_exch{"2H15 821"}="H152 821"; $resn_exch{"1H16 821"}="H161 821";
$resn_exch{"2H16 821"}="H162 821"; $resn_exch{"1H19 821"}="H191 821"; $resn_exch{"2H19 821"}="H192 821";
$resn_exch{"1H22 821"}="H221 821"; $resn_exch{"2H22 821"}="H222 821"; $resn_exch{"1H30 821"}="H301 821";
$resn_exch{"2H30 821"}="H302 821"; $resn_exch{"1H65 821"}="H651 821"; $resn_exch{"2H65 821"}="H652 821";
$resn_exch{"1H18 822"}="H181 822"; $resn_exch{"2H18 822"}="H182 822"; $resn_exch{"1H28 822"}="H281 822";
$resn_exch{"2H28 822"}="H282 822"; $resn_exch{"3H28 822"}="H283 822"; $resn_exch{"1H38 822"}="H381 822";
$resn_exch{"2H38 822"}="H382 822"; $resn_exch{"1H39 822"}="H391 822"; $resn_exch{"2H39 822"}="H392 822";
$resn_exch{"1H42 822"}="H421 822"; $resn_exch{"2H42 822"}="H422 822"; $resn_exch{"1H46 822"}="H461 822";
$resn_exch{"2H46 822"}="H462 822"; $resn_exch{"1H49 822"}="H491 822"; $resn_exch{"2H49 822"}="H492 822";
$resn_exch{"1H11 826"}="H111 826"; $resn_exch{"2H11 826"}="H112 826"; $resn_exch{"1H12 826"}="H121 826";
$resn_exch{"2H12 826"}="H122 826"; $resn_exch{"1H15 826"}="H151 826"; $resn_exch{"2H15 826"}="H152 826";
$resn_exch{"1H23 826"}="H231 826"; $resn_exch{"2H23 826"}="H232 826"; $resn_exch{"1H2  82A"}="H21A 82A";
$resn_exch{"2H2  82A"}="H22A 82A"; $resn_exch{"1H21 839"}="H211 839"; $resn_exch{"2H21 839"}="H212 839";
$resn_exch{"1H22 839"}="H221 839"; $resn_exch{"2H22 839"}="H222 839"; $resn_exch{"1H11 843"}="H111 843";
$resn_exch{"2H11 843"}="H112 843"; $resn_exch{"1H17 843"}="H171 843"; $resn_exch{"2H17 843"}="H172 843";
$resn_exch{"3H17 843"}="H173 843"; $resn_exch{"1H21 843"}="H211 843"; $resn_exch{"2H21 843"}="H212 843";
$resn_exch{"1H22 843"}="H221 843"; $resn_exch{"2H22 843"}="H222 843"; $resn_exch{"1H23 843"}="H231 843";
$resn_exch{"2H23 843"}="H232 843"; $resn_exch{"1H24 843"}="H241 843"; $resn_exch{"2H24 843"}="H242 843";
$resn_exch{"1H27 843"}="H271 843"; $resn_exch{"2H27 843"}="H272 843"; $resn_exch{"1H2  846"}="H21A 846";
$resn_exch{"2H2  846"}=" H22 846"; $resn_exch{"1H7  846"}=" H71 846"; $resn_exch{"2H7  846"}=" H72 846";
$resn_exch{"1H31 846"}="H311 846"; $resn_exch{"2H31 846"}="H312 846"; $resn_exch{"1H61 846"}="H611 846";
$resn_exch{"2H61 846"}="H612 846"; $resn_exch{"1H71 846"}="H711 846"; $resn_exch{"2H71 846"}="H712 846";
$resn_exch{"1H72 846"}="H721 846"; $resn_exch{"2H72 846"}="H722 846"; $resn_exch{"1H7  852"}=" H71 852";
$resn_exch{"2H7  852"}=" H72 852"; $resn_exch{"1H15 852"}="H151 852"; $resn_exch{"2H15 852"}="H152 852";
$resn_exch{"3H15 852"}="H153 852"; $resn_exch{"1H20 852"}="H201 852"; $resn_exch{"2H20 852"}="H202 852";
$resn_exch{"1H21 852"}="H211 852"; $resn_exch{"2H21 852"}="H212 852"; $resn_exch{"1H22 852"}="H221 852";
$resn_exch{"2H22 852"}="H222 852"; $resn_exch{"1H24 852"}="H241 852"; $resn_exch{"2H24 852"}="H242 852";
$resn_exch{"1H25 852"}="H251 852"; $resn_exch{"2H25 852"}="H252 852"; $resn_exch{"1H10 853"}="H101 853";
$resn_exch{"2H10 853"}="H102 853"; $resn_exch{"1H20 853"}="H201 853"; $resn_exch{"2H20 853"}="H202 853";
$resn_exch{"3H20 853"}="H203 853"; $resn_exch{"1H28 853"}="H281 853"; $resn_exch{"2H28 853"}="H282 853";
$resn_exch{"1H29 853"}="H291 853"; $resn_exch{"2H29 853"}="H292 853"; $resn_exch{"1H32 853"}="H321 853";
$resn_exch{"2H32 853"}="H322 853"; $resn_exch{"1H36 853"}="H361 853"; $resn_exch{"2H36 853"}="H362 853";
$resn_exch{"1H39 853"}="H391 853"; $resn_exch{"2H39 853"}="H392 853"; $resn_exch{"1H71 853"}="H711 853";
$resn_exch{"2H71 853"}="H712 853"; $resn_exch{"1H22 857"}="H221 857"; $resn_exch{"2H22 857"}="H222 857";
$resn_exch{"3H22 857"}="H223 857"; $resn_exch{"1H23 857"}="H231 857"; $resn_exch{"2H23 857"}="H232 857";
$resn_exch{"1H2  857"}="H21A 857"; $resn_exch{"2H2  857"}=" H22 857"; $resn_exch{"1H3  857"}=" H31 857";
$resn_exch{"2H3  857"}=" H32 857"; $resn_exch{"1H4  857"}=" H41 857"; $resn_exch{"2H4  857"}=" H42 857";
$resn_exch{"1H26 857"}="H261 857"; $resn_exch{"2H26 857"}="H262 857"; $resn_exch{"3H26 857"}="H263 857";
$resn_exch{"1H3  858"}="H31A 858"; $resn_exch{"2H3  858"}="H32A 858"; $resn_exch{"1H4  858"}=" H41 858";
$resn_exch{"2H4  858"}=" H42 858"; $resn_exch{"1H5  858"}=" H51 858"; $resn_exch{"2H5  858"}=" H52 858";
$resn_exch{"1H6  858"}=" H61 858"; $resn_exch{"2H6  858"}="H62A 858"; $resn_exch{"1H12 858"}="H121 858";
$resn_exch{"2H12 858"}="H122 858"; $resn_exch{"1H16 858"}="H161 858"; $resn_exch{"2H16 858"}="H162 858";
$resn_exch{"2H18 858"}="H182 858"; $resn_exch{"1H23 858"}="H231 858"; $resn_exch{"2H23 858"}="H232 858";
$resn_exch{"1H30 858"}="H301 858"; $resn_exch{"2H30 858"}="H302 858"; $resn_exch{"1H33 858"}="H331 858";
$resn_exch{"2H33 858"}="H332 858"; $resn_exch{"1H34 858"}="H341 858"; $resn_exch{"2H34 858"}="H342 858";
$resn_exch{"1H35 858"}="H351 858"; $resn_exch{"2H35 858"}="H352 858"; $resn_exch{"3H35 858"}="H353 858";
$resn_exch{"1H36 858"}="H361 858"; $resn_exch{"2H36 858"}="H362 858"; $resn_exch{"3H36 858"}="H363 858";
$resn_exch{"1H37 858"}="H371 858"; $resn_exch{"2H37 858"}="H372 858"; $resn_exch{"3H37 858"}="H373 858";
$resn_exch{"1H38 858"}="H381 858"; $resn_exch{"2H38 858"}="H382 858"; $resn_exch{"1H39 858"}="H391 858";
$resn_exch{"2H39 858"}="H392 858"; $resn_exch{"3H39 858"}="H393 858"; $resn_exch{"1H41 858"}="H411 858";
$resn_exch{"2H41 858"}="H412 858"; $resn_exch{"3H41 858"}="H413 858"; $resn_exch{"1H42 858"}="H421 858";
$resn_exch{"2H42 858"}="H422 858"; $resn_exch{"3H42 858"}="H423 858"; $resn_exch{"1H43 858"}="H431 858";
$resn_exch{"2H43 858"}="H432 858"; $resn_exch{"3H43 858"}="H433 858"; $resn_exch{"1H44 858"}="H441 858";
$resn_exch{"2H44 858"}="H442 858"; $resn_exch{"3H44 858"}="H443 858"; $resn_exch{"1H45 858"}="H451 858";
$resn_exch{"2H45 858"}="H452 858"; $resn_exch{"3H45 858"}="H453 858"; $resn_exch{"1H67 858"}="H671 858";
$resn_exch{"2H67 858"}="H672 858"; $resn_exch{"1H68 858"}="H681 858"; $resn_exch{"2H68 858"}="H682 858";
$resn_exch{"3H68 858"}="H683 858"; $resn_exch{"0HO1 858"}="HO10 858"; $resn_exch{"1H23 859"}="H231 859";
$resn_exch{"2H23 859"}="H232 859"; $resn_exch{"1H22 85A"}="H221 85A"; $resn_exch{"2H22 85A"}="H222 85A";
$resn_exch{"1H26 85A"}="H261 85A"; $resn_exch{"2H26 85A"}="H262 85A"; $resn_exch{"1H27 85A"}="H271 85A";
$resn_exch{"2H27 85A"}="H272 85A"; $resn_exch{"1H23 85A"}="H231 85A"; $resn_exch{"2H23 85A"}="H232 85A";
$resn_exch{"1H24 85A"}="H241 85A"; $resn_exch{"2H24 85A"}="H242 85A"; $resn_exch{"1H28 85A"}="H281 85A";
$resn_exch{"2H28 85A"}="H282 85A"; $resn_exch{"1H9  864"}=" H91 864"; $resn_exch{"2H9  864"}=" H92 864";
$resn_exch{"1H10 864"}="H101 864"; $resn_exch{"2H10 864"}="H102 864"; $resn_exch{"1H15 864"}="H151 864";
$resn_exch{"2H15 864"}="H152 864"; $resn_exch{"1H27 864"}="H271 864"; $resn_exch{"2H27 864"}="H272 864";
$resn_exch{"3H27 864"}="H273 864"; $resn_exch{"1H28 864"}="H281 864"; $resn_exch{"2H28 864"}="H282 864";
$resn_exch{"3H28 864"}="H283 864"; $resn_exch{"1H33 864"}="H331 864"; $resn_exch{"2H33 864"}="H332 864";
$resn_exch{"1H31 869"}="H311 869"; $resn_exch{"2H31 869"}="H312 869"; $resn_exch{"3H31 869"}="H313 869";
$resn_exch{"1H7  869"}=" H71 869"; $resn_exch{"2H7  869"}=" H72 869"; $resn_exch{"3H7  869"}=" H73 869";
$resn_exch{"1H14 869"}="H141 869"; $resn_exch{"2H14 869"}="H142 869"; $resn_exch{"3H14 869"}="H143 869";
$resn_exch{"1H21 869"}="H211 869"; $resn_exch{"2H21 869"}="H212 869"; $resn_exch{"3H21 869"}="H213 869";
$resn_exch{"1H22 869"}="H221 869"; $resn_exch{"2H22 869"}="H222 869"; $resn_exch{"3H22 869"}="H223 869";
$resn_exch{"1H23 869"}="H231 869"; $resn_exch{"2H23 869"}="H232 869"; $resn_exch{"3H23 869"}="H233 869";
$resn_exch{"1H33 86A"}="H331 86A"; $resn_exch{"2H33 86A"}="H332 86A"; $resn_exch{"1H24 86A"}="H241 86A";
$resn_exch{"2H24 86A"}="H242 86A"; $resn_exch{"1H28 86A"}="H281 86A"; $resn_exch{"2H28 86A"}="H282 86A";
$resn_exch{"3H28 86A"}="H283 86A"; $resn_exch{"1H27 86A"}="H271 86A"; $resn_exch{"2H27 86A"}="H272 86A";
$resn_exch{"3H27 86A"}="H273 86A"; $resn_exch{"1H11 86A"}="H111 86A"; $resn_exch{"2H11 86A"}="H112 86A";
$resn_exch{"1H13 870"}="H131 870"; $resn_exch{"2H13 870"}="H132 870"; $resn_exch{"3H13 870"}="H133 870";
$resn_exch{"1HN2 870"}="HN21 870"; $resn_exch{"2HN2 870"}="HN22 870"; $resn_exch{"1H11 872"}="H111 872";
$resn_exch{"2H11 872"}="H112 872"; $resn_exch{"1H15 872"}="H151 872"; $resn_exch{"2H15 872"}="H152 872";
$resn_exch{"1H20 872"}="H201 872"; $resn_exch{"2H20 872"}="H202 872"; $resn_exch{"1H25 872"}="H251 872";
$resn_exch{"2H25 872"}="H252 872"; $resn_exch{"1H26 872"}="H261 872"; $resn_exch{"2H26 872"}="H262 872";
$resn_exch{"1H27 872"}="H271 872"; $resn_exch{"2H27 872"}="H272 872"; $resn_exch{"1H37 872"}="H371 872";
$resn_exch{"2H37 872"}="H372 872"; $resn_exch{"1H7  876"}=" H71 876"; $resn_exch{"2H7  876"}="H72A 876";
$resn_exch{"1H13 876"}="H131 876"; $resn_exch{"2H13 876"}="H132 876"; $resn_exch{"3H13 876"}="H133 876";
$resn_exch{"1H17 876"}="H171 876"; $resn_exch{"2H17 876"}="H172 876"; $resn_exch{"1H18 876"}="H181 876";
$resn_exch{"2H18 876"}="H182 876"; $resn_exch{"1H19 876"}="H191 876"; $resn_exch{"2H19 876"}="H192 876";
$resn_exch{"1H20 876"}="H201 876"; $resn_exch{"2H20 876"}="H202 876"; $resn_exch{"1H23 876"}="H231 876";
$resn_exch{"2H23 876"}="H232 876"; $resn_exch{"1H9  877"}=" H91 877"; $resn_exch{"2H9  877"}=" H92 877";
$resn_exch{"1H23 877"}="H231 877"; $resn_exch{"2H23 877"}="H232 877"; $resn_exch{"3H23 877"}="H233 877";
$resn_exch{"1H28 877"}="H281 877"; $resn_exch{"2H28 877"}="H282 877"; $resn_exch{"3H28 877"}="H283 877";
$resn_exch{"1H33 877"}="H331 877"; $resn_exch{"2H33 877"}="H332 877"; $resn_exch{"1H37 877"}="H371 877";
$resn_exch{"2H37 877"}="H372 877"; $resn_exch{"1H38 877"}="H381 877"; $resn_exch{"2H38 877"}="H382 877";
$resn_exch{"3H38 877"}="H383 877"; $resn_exch{"2H15 87Y"}="H152 87Y"; $resn_exch{"1H15 87Y"}="H151 87Y";
$resn_exch{"2H14 87Y"}="H142 87Y"; $resn_exch{"1H14 87Y"}="H141 87Y"; $resn_exch{"3H13 87Y"}="H133 87Y";
$resn_exch{"2H13 87Y"}="H132 87Y"; $resn_exch{"1H13 87Y"}="H131 87Y"; $resn_exch{"2H5  87Y"}=" H52 87Y";
$resn_exch{"1H5  87Y"}=" H51 87Y"; $resn_exch{"2H17 87Y"}="H172 87Y"; $resn_exch{"1H17 87Y"}="H171 87Y";
$resn_exch{"1H06 880"}="H061 880"; $resn_exch{"2H06 880"}="H062 880"; $resn_exch{"1H07 880"}="H071 880";
$resn_exch{"2H07 880"}="H072 880"; $resn_exch{"1H10 880"}="H101 880"; $resn_exch{"2H10 880"}="H102 880";
$resn_exch{"3H10 880"}="H103 880"; $resn_exch{"1H17 880"}="H171 880"; $resn_exch{"2H17 880"}="H172 880";
$resn_exch{"1H18 880"}="H181 880"; $resn_exch{"2H18 880"}="H182 880"; $resn_exch{"1H20 880"}="H201 880";
$resn_exch{"2H20 880"}="H202 880"; $resn_exch{"1H21 880"}="H211 880"; $resn_exch{"2H21 880"}="H212 880";
$resn_exch{"1H56 880"}="H561 880"; $resn_exch{"2H56 880"}="H562 880"; $resn_exch{"1H57 880"}="H571 880";
$resn_exch{"2H57 880"}="H572 880"; $resn_exch{"1H58 880"}="H581 880"; $resn_exch{"2H58 880"}="H582 880";
$resn_exch{"1H59 880"}="H591 880"; $resn_exch{"2H59 880"}="H592 880"; $resn_exch{"1H60 880"}="H601 880";
$resn_exch{"2H60 880"}="H602 880"; $resn_exch{"1H7  882"}=" H71 882"; $resn_exch{"2H7  882"}=" H72 882";
$resn_exch{"1H8  882"}=" H81 882"; $resn_exch{"2H8  882"}=" H82 882"; $resn_exch{"1H10 882"}="H101 882";
$resn_exch{"2H10 882"}="H102 882"; $resn_exch{"1H13 882"}="H131 882"; $resn_exch{"2H13 882"}="H132 882";
$resn_exch{"3H13 882"}="H133 882"; $resn_exch{"1H35 882"}="H351 882"; $resn_exch{"2H35 882"}="H352 882";
$resn_exch{"1H14 882"}="H141 882"; $resn_exch{"2H14 882"}="H142 882"; $resn_exch{"3H14 882"}="H143 882";
$resn_exch{"1H1  885"}="H11A 885"; $resn_exch{"2H1  885"}=" H12 885"; $resn_exch{"3H1  885"}=" H13 885";
$resn_exch{"1HN1 885"}="HN11 885"; $resn_exch{"2HN1 885"}="HN12 885"; $resn_exch{"1H8  885"}=" H81 885";
$resn_exch{"2H8  885"}=" H82 885"; $resn_exch{"1H9  885"}=" H91 885"; $resn_exch{"2H9  885"}=" H92 885";
$resn_exch{"1H10 885"}="H101 885"; $resn_exch{"2H10 885"}="H102 885"; $resn_exch{"1H31 888"}="H311 888";
$resn_exch{"2H31 888"}="H312 888"; $resn_exch{"1H32 888"}="H321 888"; $resn_exch{"2H32 888"}="H322 888";
$resn_exch{"1H38 888"}="H381 888"; $resn_exch{"2H38 888"}="H382 888"; $resn_exch{"3H38 888"}="H383 888";
$resn_exch{"1H7  888"}=" H71 888"; $resn_exch{"2H7  888"}=" H72 888"; $resn_exch{"3H7  888"}=" H73 888";
$resn_exch{"1H17 892"}="H171 892"; $resn_exch{"2H17 892"}="H172 892"; $resn_exch{"1H18 892"}="H181 892";
$resn_exch{"2H18 892"}="H182 892"; $resn_exch{"3H18 892"}="H183 892"; $resn_exch{"1H02 892"}="H021 892";
$resn_exch{"2H02 892"}="H022 892"; $resn_exch{"1H9  893"}=" H91 893"; $resn_exch{"2H9  893"}=" H92 893";
$resn_exch{"1H23 893"}="H231 893"; $resn_exch{"2H23 893"}="H232 893"; $resn_exch{"3H23 893"}="H233 893";
$resn_exch{"1H28 893"}="H281 893"; $resn_exch{"2H28 893"}="H282 893"; $resn_exch{"3H28 893"}="H283 893";
$resn_exch{"1H37 893"}="H371 893"; $resn_exch{"2H37 893"}="H372 893"; $resn_exch{"1H7  893"}=" H71 893";
$resn_exch{"2H7  893"}=" H72 893"; $resn_exch{"3H7  893"}=" H73 893"; $resn_exch{"1H9C 894"}="H9C1 894";
$resn_exch{"2H9C 894"}="H9C2 894"; $resn_exch{"1H6C 894"}="H6C1 894"; $resn_exch{"2H6C 894"}="H6C2 894";
$resn_exch{"1H13 894"}="H131 894"; $resn_exch{"2H13 894"}="H132 894"; $resn_exch{"1H14 894"}="H141 894";
$resn_exch{"2H14 894"}="H142 894"; $resn_exch{"1H17 894"}="H171 894"; $resn_exch{"2H17 894"}="H172 894";
$resn_exch{"3H17 894"}="H173 894"; $resn_exch{"1H19 894"}="H191 894"; $resn_exch{"2H19 894"}="H192 894";
$resn_exch{"1H23 894"}="H231 894"; $resn_exch{"2H23 894"}="H232 894"; $resn_exch{"1H20 894"}="H201 894";
$resn_exch{"2H20 894"}="H202 894"; $resn_exch{"1H22 894"}="H221 894"; $resn_exch{"2H22 894"}="H222 894";
$resn_exch{"1H13 895"}="H131 895"; $resn_exch{"2H13 895"}="H132 895"; $resn_exch{"1H14 895"}="H141 895";
$resn_exch{"2H14 895"}="H142 895"; $resn_exch{"1H17 895"}="H171 895"; $resn_exch{"2H17 895"}="H172 895";
$resn_exch{"3H17 895"}="H173 895"; $resn_exch{"1H19 895"}="H191 895"; $resn_exch{"2H19 895"}="H192 895";
$resn_exch{"1H23 895"}="H231 895"; $resn_exch{"2H23 895"}="H232 895"; $resn_exch{"1H20 895"}="H201 895";
$resn_exch{"2H20 895"}="H202 895"; $resn_exch{"1H22 895"}="H221 895"; $resn_exch{"2H22 895"}="H222 895";
$resn_exch{"1H6C 896"}="H6C1 896"; $resn_exch{"2H6C 896"}="H6C2 896"; $resn_exch{"1H5C 896"}="H5C1 896";
$resn_exch{"2H5C 896"}="H5C2 896"; $resn_exch{"3H5C 896"}="H5C3 896"; $resn_exch{"1H24 896"}="H241 896";
$resn_exch{"2H24 896"}="H242 896"; $resn_exch{"3H24 896"}="H243 896"; $resn_exch{"1H23 896"}="H231 896";
$resn_exch{"2H23 896"}="H232 896"; $resn_exch{"3H23 896"}="H233 896"; $resn_exch{"1H20 896"}="H201 896";
$resn_exch{"2H20 896"}="H202 896"; $resn_exch{"3H20 896"}="H203 896"; $resn_exch{"1H1C 896"}="H1C1 896";
$resn_exch{"2H1C 896"}="H1C2 896"; $resn_exch{"1H8C 896"}="H8C1 896"; $resn_exch{"2H8C 896"}="H8C2 896";
$resn_exch{"3H8C 896"}="H8C3 896"; $resn_exch{"1H8C 897"}="H8C1 897"; $resn_exch{"2H8C 897"}="H8C2 897";
$resn_exch{"3H8C 897"}="H8C3 897"; $resn_exch{"1H1C 897"}="H1C1 897"; $resn_exch{"2H1C 897"}="H1C2 897";
$resn_exch{"1H20 897"}="H201 897"; $resn_exch{"2H20 897"}="H202 897"; $resn_exch{"3H20 897"}="H203 897";
$resn_exch{"1H6C 897"}="H6C1 897"; $resn_exch{"2H6C 897"}="H6C2 897"; $resn_exch{"1H23 897"}="H231 897";
$resn_exch{"2H23 897"}="H232 897"; $resn_exch{"3H23 897"}="H233 897"; $resn_exch{"1H24 897"}="H241 897";
$resn_exch{"2H24 897"}="H242 897"; $resn_exch{"3H24 897"}="H243 897"; $resn_exch{"1H5C 897"}="H5C1 897";
$resn_exch{"2H5C 897"}="H5C2 897"; $resn_exch{"1H25 897"}="H251 897"; $resn_exch{"2H25 897"}="H252 897";
$resn_exch{"3H25 897"}="H253 897"; $resn_exch{"1H26 897"}="H261 897"; $resn_exch{"2H26 897"}="H262 897";
$resn_exch{"3H26 897"}="H263 897"; $resn_exch{"1H2C 897"}="H2C1 897"; $resn_exch{"2H2C 897"}="H2C2 897";
$resn_exch{"3H2C 897"}="H2C3 897"; $resn_exch{"1H31 89I"}="H311 89I"; $resn_exch{"2H31 89I"}="H312 89I";
$resn_exch{"1H30 89I"}="H301 89I"; $resn_exch{"2H30 89I"}="H302 89I"; $resn_exch{"1H28 89I"}="H281 89I";
$resn_exch{"2H28 89I"}="H282 89I"; $resn_exch{"1H27 89I"}="H271 89I"; $resn_exch{"2H27 89I"}="H272 89I";
$resn_exch{"1H44 89I"}="H441 89I"; $resn_exch{"2H44 89I"}="H442 89I"; $resn_exch{"3H44 89I"}="H443 89I";
$resn_exch{"1H48 89I"}="H481 89I"; $resn_exch{"2H48 89I"}="H482 89I"; $resn_exch{"3H48 89I"}="H483 89I";
$resn_exch{"1H52 89I"}="H521 89I"; $resn_exch{"2H52 89I"}="H522 89I"; $resn_exch{"1HD2 8AD"}="HD21 8AD";
$resn_exch{"2HD2 8AD"}="HD22 8AD"; $resn_exch{"1HD3 8AD"}="HD31 8AD"; $resn_exch{"2HD3 8AD"}="HD32 8AD";
$resn_exch{"1HD4 8AD"}="HD41 8AD"; $resn_exch{"2HD4 8AD"}="HD42 8AD"; $resn_exch{"1HD5 8AD"}="HD51 8AD";
$resn_exch{"2HD5 8AD"}="HD52 8AD"; $resn_exch{"1HD7 8AD"}="HD71 8AD"; $resn_exch{"2HD7 8AD"}="HD72 8AD";
$resn_exch{"3HD7 8AD"}="HD73 8AD"; $resn_exch{"1HD8 8AD"}="HD81 8AD"; $resn_exch{"2HD8 8AD"}="HD82 8AD";
$resn_exch{"3HD8 8AD"}="HD83 8AD"; $resn_exch{"1HN1 8AP"}="HN11 8AP"; $resn_exch{"2HN1 8AP"}="HN12 8AP";
$resn_exch{"1H9  8AP"}=" H91 8AP"; $resn_exch{"2H9  8AP"}=" H92 8AP"; $resn_exch{"2HOP 8BR"}="HOP2 8BR";
$resn_exch{"3HOP 8BR"}="HOP3 8BR"; $resn_exch{"1H5* 8BR"}="H5'1 8BR"; $resn_exch{"2H5* 8BR"}="H5'2 8BR";
$resn_exch{" H4* 8BR"}=" H4' 8BR"; $resn_exch{" H3* 8BR"}=" H3' 8BR"; $resn_exch{"*HO3 8BR"}="HO3' 8BR";
$resn_exch{" H2* 8BR"}=" H2' 8BR"; $resn_exch{"*HO2 8BR"}="HO2' 8BR"; $resn_exch{" H1* 8BR"}=" H1' 8BR";
$resn_exch{"1HN6 8BR"}="HN61 8BR"; $resn_exch{"2HN6 8BR"}="HN62 8BR"; $resn_exch{"1H2' 8CS"}="H2'1 8CS";
$resn_exch{"2H2' 8CS"}="H2'2 8CS"; $resn_exch{"1H10 8CS"}="H101 8CS"; $resn_exch{"2H10 8CS"}="H102 8CS";
$resn_exch{"1H5* 8DA"}="H5'1 8DA"; $resn_exch{"2H5* 8DA"}="H5'2 8DA"; $resn_exch{" H4* 8DA"}=" H4' 8DA";
$resn_exch{" H3* 8DA"}=" H3' 8DA"; $resn_exch{" H1* 8DA"}=" H1' 8DA"; $resn_exch{"1H2* 8DA"}="H2'1 8DA";
$resn_exch{"2H2* 8DA"}="H2'2 8DA"; $resn_exch{"1HN6 8DA"}="HN61 8DA"; $resn_exch{"2HN6 8DA"}="HN62 8DA";
$resn_exch{"1H2  8DA"}=" H21 8DA"; $resn_exch{"2H2  8DA"}=" H22 8DA"; $resn_exch{"2HOG 8DG"}="HOG2 8DG";
$resn_exch{"2HOB 8DG"}="HOB2 8DG"; $resn_exch{"2HOA 8DG"}="HOA2 8DG"; $resn_exch{"1H5* 8DG"}="H5'1 8DG";
$resn_exch{"2H5* 8DG"}="H5'2 8DG"; $resn_exch{" H4* 8DG"}=" H4' 8DG"; $resn_exch{" H3* 8DG"}=" H3' 8DG";
$resn_exch{"1H2* 8DG"}="H2'1 8DG"; $resn_exch{"2H2* 8DG"}="H2'2 8DG"; $resn_exch{" H1* 8DG"}=" H1' 8DG";
$resn_exch{"1HN2 8DG"}="HN21 8DG"; $resn_exch{"2HN2 8DG"}="HN22 8DG"; $resn_exch{"3HOP 8FG"}="HOP3 8FG";
$resn_exch{"2HOP 8FG"}="HOP2 8FG"; $resn_exch{"1HN2 8FG"}="HN21 8FG"; $resn_exch{"2HN2 8FG"}="HN22 8FG";
$resn_exch{"1H37 8FG"}="H371 8FG"; $resn_exch{"2H37 8FG"}="H372 8FG"; $resn_exch{"1H45 8FG"}="H451 8FG";
$resn_exch{"2H45 8FG"}="H452 8FG"; $resn_exch{"3H45 8FG"}="H453 8FG"; $resn_exch{"1H2* 8FG"}=" H2' 8FG";
$resn_exch{"2H2* 8FG"}="H2'' 8FG"; $resn_exch{"1H5* 8FG"}=" H5' 8FG"; $resn_exch{"2H5* 8FG"}="H5'' 8FG";
$resn_exch{" H4* 8FG"}=" H4' 8FG"; $resn_exch{" H1* 8FG"}=" H1' 8FG"; $resn_exch{" H3* 8FG"}=" H3' 8FG";
$resn_exch{"H3T  8FG"}="HO3' 8FG"; $resn_exch{"1H6  8GP"}=" H61 8GP"; $resn_exch{"2H6  8GP"}=" H62 8GP";
$resn_exch{"1H10 8GP"}="H101 8GP"; $resn_exch{"2H10 8GP"}="H102 8GP"; $resn_exch{"1H11 8GP"}="H111 8GP";
$resn_exch{"2H11 8GP"}="H112 8GP"; $resn_exch{"2HOG 8GT"}="HOG2 8GT"; $resn_exch{"2HOB 8GT"}="HOB2 8GT";
$resn_exch{"2HOA 8GT"}="HOA2 8GT"; $resn_exch{"1H5* 8GT"}="H5'1 8GT"; $resn_exch{"2H5* 8GT"}="H5'2 8GT";
$resn_exch{" H4* 8GT"}=" H4' 8GT"; $resn_exch{" H3* 8GT"}=" H3' 8GT"; $resn_exch{" H2* 8GT"}=" H2' 8GT";
$resn_exch{" H1* 8GT"}=" H1' 8GT"; $resn_exch{"1HN2 8GT"}="HN21 8GT"; $resn_exch{"2HN2 8GT"}="HN22 8GT";
$resn_exch{"1HN2 8HG"}="HN21 8HG"; $resn_exch{"2HN2 8HG"}="HN22 8HG"; $resn_exch{" H1* 8HG"}=" H1' 8HG";
$resn_exch{"1H2* 8HG"}="H2'1 8HG"; $resn_exch{"2H2* 8HG"}="H2'2 8HG"; $resn_exch{" H3* 8HG"}=" H3' 8HG";
$resn_exch{" H4* 8HG"}=" H4' 8HG"; $resn_exch{"1H5* 8HG"}="H5'1 8HG"; $resn_exch{"2H5* 8HG"}="H5'2 8HG";
$resn_exch{" H5* 8HG"}=" H5' 8HG"; $resn_exch{"1H7N 8ID"}="H7N1 8ID"; $resn_exch{"2H7N 8ID"}="H7N2 8ID";
$resn_exch{"1H5' 8ID"}="H5'1 8ID"; $resn_exch{"2H5' 8ID"}="H5'2 8ID"; $resn_exch{"1H5* 8ID"}="H5A1 8ID";
$resn_exch{"2H5* 8ID"}="H5A2 8ID"; $resn_exch{" H4* 8ID"}=" H4B 8ID"; $resn_exch{" H1* 8ID"}=" H1B 8ID";
$resn_exch{" H2* 8ID"}=" H2B 8ID"; $resn_exch{"HO2* 8ID"}="HO2A 8ID"; $resn_exch{" H3* 8ID"}=" H3B 8ID";
$resn_exch{"HO3* 8ID"}="HO3A 8ID"; $resn_exch{"1H6A 8ID"}="H6A1 8ID"; $resn_exch{"2H6A 8ID"}="H6A2 8ID";
$resn_exch{"1HN2 8IG"}="HN21 8IG"; $resn_exch{"2HN2 8IG"}="HN22 8IG"; $resn_exch{"1HN1 8IG"}="HN11 8IG";
$resn_exch{"1H10 8IN"}="H101 8IN"; $resn_exch{"2H10 8IN"}="H102 8IN"; $resn_exch{"1H13 8IN"}="H131 8IN";
$resn_exch{"2H13 8IN"}="H132 8IN"; $resn_exch{"1H14 8IN"}="H141 8IN"; $resn_exch{"2H14 8IN"}="H142 8IN";
$resn_exch{"3H14 8IN"}="H143 8IN"; $resn_exch{"1H15 8IN"}="H151 8IN"; $resn_exch{"2H15 8IN"}="H152 8IN";
$resn_exch{"1H23 8IN"}="H231 8IN"; $resn_exch{"2H23 8IN"}="H232 8IN"; $resn_exch{"1H24 8IN"}="H241 8IN";
$resn_exch{"2H24 8IN"}="H242 8IN"; $resn_exch{"1H25 8IN"}="H251 8IN"; $resn_exch{"2H25 8IN"}="H252 8IN";
$resn_exch{"1HN1 8IP"}="HN11 8IP"; $resn_exch{"2HN1 8IP"}="HN12 8IP"; $resn_exch{"1H9  8IP"}=" H91 8IP";
$resn_exch{"2H9  8IP"}=" H92 8IP"; $resn_exch{"1H2  8MG"}=" H21 8MG"; $resn_exch{"2H2  8MG"}=" H22 8MG";
$resn_exch{"1H2* 8MG"}=" H2' 8MG"; $resn_exch{"2H2* 8MG"}="H2'' 8MG"; $resn_exch{"1H5* 8MG"}=" H5' 8MG";
$resn_exch{"2H5* 8MG"}="H5'' 8MG"; $resn_exch{" H4* 8MG"}=" H4' 8MG"; $resn_exch{" H1* 8MG"}=" H1' 8MG";
$resn_exch{" H3* 8MG"}=" H3' 8MG"; $resn_exch{"H3T  8MG"}="HO3' 8MG"; $resn_exch{"1HC  8MG"}=" HC1 8MG";
$resn_exch{"2HC  8MG"}=" HC2 8MG"; $resn_exch{"3HC  8MG"}=" HC3 8MG"; $resn_exch{"1H4  8MO"}=" H41 8MO";
$resn_exch{"2H4  8MO"}=" H42 8MO"; $resn_exch{"3H4  8MO"}=" H43 8MO"; $resn_exch{"1HAI 8MR"}="HAI1 8MR";
$resn_exch{"2HAI 8MR"}="HAI2 8MR"; $resn_exch{"3HAI 8MR"}="HAI3 8MR"; $resn_exch{"1HAL 8MR"}="HAL1 8MR";
$resn_exch{"2HAL 8MR"}="HAL2 8MR"; $resn_exch{"1H19 8NH"}="H191 8NH"; $resn_exch{"2H19 8NH"}="H192 8NH";
$resn_exch{"1H22 8NH"}="H221 8NH"; $resn_exch{"2H22 8NH"}="H222 8NH"; $resn_exch{"1H30 8NH"}="H301 8NH";
$resn_exch{"2H30 8NH"}="H302 8NH"; $resn_exch{"3H30 8NH"}="H303 8NH"; $resn_exch{"3HOP 8OG"}="HOP3 8OG";
$resn_exch{"2HOP 8OG"}="HOP2 8OG"; $resn_exch{"1H5* 8OG"}=" H5' 8OG"; $resn_exch{"2H5* 8OG"}="H5'' 8OG";
$resn_exch{" H4* 8OG"}=" H4' 8OG"; $resn_exch{" H3* 8OG"}=" H3' 8OG"; $resn_exch{"H3T  8OG"}="HO3' 8OG";
$resn_exch{"1H2* 8OG"}=" H2' 8OG"; $resn_exch{"2H2* 8OG"}="H2'' 8OG"; $resn_exch{" H1* 8OG"}=" H1' 8OG";
$resn_exch{"1H2  8OG"}=" H21 8OG"; $resn_exch{"2H2  8OG"}=" H22 8OG"; $resn_exch{"1H7  8PC"}=" H71 8PC";
$resn_exch{"2H7  8PC"}=" H72 8PC"; $resn_exch{"1HAA 8PG"}="HAA1 8PG"; $resn_exch{"2HAA 8PG"}="HAA2 8PG";
$resn_exch{"3HAA 8PG"}="HAA3 8PG"; $resn_exch{"1HAJ 8PG"}="HAJ1 8PG"; $resn_exch{"2HAJ 8PG"}="HAJ2 8PG";
$resn_exch{"1HAK 8PG"}="HAK1 8PG"; $resn_exch{"2HAK 8PG"}="HAK2 8PG"; $resn_exch{"1HAO 8PG"}="HAO1 8PG";
$resn_exch{"2HAO 8PG"}="HAO2 8PG"; $resn_exch{"1HAR 8PG"}="HAR1 8PG"; $resn_exch{"2HAR 8PG"}="HAR2 8PG";
$resn_exch{"1HAS 8PG"}="HAS1 8PG"; $resn_exch{"2HAS 8PG"}="HAS2 8PG"; $resn_exch{"1HAP 8PG"}="HAP1 8PG";
$resn_exch{"2HAP 8PG"}="HAP2 8PG"; $resn_exch{"1HAM 8PG"}="HAM1 8PG"; $resn_exch{"2HAM 8PG"}="HAM2 8PG";
$resn_exch{"1HAL 8PG"}="HAL1 8PG"; $resn_exch{"2HAL 8PG"}="HAL2 8PG"; $resn_exch{"1HAN 8PG"}="HAN1 8PG";
$resn_exch{"2HAN 8PG"}="HAN2 8PG"; $resn_exch{"1HAQ 8PG"}="HAQ1 8PG"; $resn_exch{"2HAQ 8PG"}="HAQ2 8PG";
$resn_exch{"1H7  8PP"}=" H71 8PP"; $resn_exch{"2H7  8PP"}=" H72 8PP"; $resn_exch{"1H10 8PP"}="H101 8PP";
$resn_exch{"2H10 8PP"}="H102 8PP"; $resn_exch{"3H10 8PP"}="H103 8PP"; $resn_exch{"1H11 8PP"}="H111 8PP";
$resn_exch{"2H11 8PP"}="H112 8PP"; $resn_exch{"1H12 8PP"}="H121 8PP"; $resn_exch{"2H12 8PP"}="H122 8PP";
$resn_exch{"1H15 8PP"}="H151 8PP"; $resn_exch{"2H15 8PP"}="H152 8PP"; $resn_exch{"3H15 8PP"}="H153 8PP";
$resn_exch{"1H16 8PP"}="H161 8PP"; $resn_exch{"2H16 8PP"}="H162 8PP"; $resn_exch{"1H17 8PP"}="H171 8PP";
$resn_exch{"2H17 8PP"}="H172 8PP"; $resn_exch{"1H20 8PP"}="H201 8PP"; $resn_exch{"2H20 8PP"}="H202 8PP";
$resn_exch{"3H20 8PP"}="H203 8PP"; $resn_exch{"1H21 8PP"}="H211 8PP"; $resn_exch{"2H21 8PP"}="H212 8PP";
$resn_exch{"1H22 8PP"}="H221 8PP"; $resn_exch{"2H22 8PP"}="H222 8PP"; $resn_exch{"1H25 8PP"}="H251 8PP";
$resn_exch{"2H25 8PP"}="H252 8PP"; $resn_exch{"3H25 8PP"}="H253 8PP"; $resn_exch{"1H26 8PP"}="H261 8PP";
$resn_exch{"2H26 8PP"}="H262 8PP"; $resn_exch{"1H27 8PP"}="H271 8PP"; $resn_exch{"2H27 8PP"}="H272 8PP";
$resn_exch{"1H30 8PP"}="H301 8PP"; $resn_exch{"2H30 8PP"}="H302 8PP"; $resn_exch{"3H30 8PP"}="H303 8PP";
$resn_exch{"1H31 8PP"}="H311 8PP"; $resn_exch{"2H31 8PP"}="H312 8PP"; $resn_exch{"1H32 8PP"}="H321 8PP";
$resn_exch{"2H32 8PP"}="H322 8PP"; $resn_exch{"1H35 8PP"}="H351 8PP"; $resn_exch{"2H35 8PP"}="H352 8PP";
$resn_exch{"3H35 8PP"}="H353 8PP"; $resn_exch{"1H36 8PP"}="H361 8PP"; $resn_exch{"2H36 8PP"}="H362 8PP";
$resn_exch{"1H37 8PP"}="H371 8PP"; $resn_exch{"2H37 8PP"}="H372 8PP"; $resn_exch{"1H40 8PP"}="H401 8PP";
$resn_exch{"2H40 8PP"}="H402 8PP"; $resn_exch{"1H41 8PP"}="H411 8PP"; $resn_exch{"2H41 8PP"}="H412 8PP";
$resn_exch{"3H41 8PP"}="H413 8PP"; $resn_exch{"1H42 8PP"}="H421 8PP"; $resn_exch{"2H42 8PP"}="H422 8PP";
$resn_exch{"1H45 8PP"}="H451 8PP"; $resn_exch{"2H45 8PP"}="H452 8PP"; $resn_exch{"3H45 8PP"}="H453 8PP";
$resn_exch{"1H46 8PP"}="H461 8PP"; $resn_exch{"2H46 8PP"}="H462 8PP"; $resn_exch{"3H46 8PP"}="H463 8PP";
$resn_exch{"1H14 8PS"}="H141 8PS"; $resn_exch{"2H14 8PS"}="H142 8PS"; $resn_exch{"1H15 8PS"}="H151 8PS";
$resn_exch{"2H15 8PS"}="H152 8PS"; $resn_exch{"1H16 8PS"}="H161 8PS"; $resn_exch{"2H16 8PS"}="H162 8PS";
$resn_exch{"1H17 8PS"}="H171 8PS"; $resn_exch{"2H17 8PS"}="H172 8PS"; $resn_exch{"1H18 8PS"}="H181 8PS";
$resn_exch{"2H18 8PS"}="H182 8PS"; $resn_exch{"1H19 8PS"}="H191 8PS"; $resn_exch{"2H19 8PS"}="H192 8PS";
$resn_exch{"1H20 8PS"}="H201 8PS"; $resn_exch{"2H20 8PS"}="H202 8PS"; $resn_exch{"1H21 8PS"}="H211 8PS";
$resn_exch{"2H21 8PS"}="H212 8PS"; $resn_exch{"3H21 8PS"}="H213 8PS"; $resn_exch{"1H32 901"}="H321 901";
$resn_exch{"2H32 901"}="H322 901"; $resn_exch{"1H33 901"}="H331 901"; $resn_exch{"2H33 901"}="H332 901";
$resn_exch{"3H33 901"}="H333 901"; $resn_exch{"1H7  901"}=" H71 901"; $resn_exch{"2H7  901"}=" H72 901";
$resn_exch{"1H23 901"}="H231 901"; $resn_exch{"2H23 901"}="H232 901"; $resn_exch{"3H23 901"}="H233 901";
$resn_exch{"1H12 901"}="H121 901"; $resn_exch{"2H12 901"}="H122 901"; $resn_exch{"1H13 901"}="H131 901";
$resn_exch{"2H13 901"}="H132 901"; $resn_exch{"1H15 901"}="H151 901"; $resn_exch{"2H15 901"}="H152 901";
$resn_exch{"1H14 901"}="H141 901"; $resn_exch{"2H14 901"}="H142 901"; $resn_exch{"1H18 901"}="H181 901";
$resn_exch{"2H18 901"}="H182 901"; $resn_exch{"1H34 901"}="H341 901"; $resn_exch{"2H34 901"}="H342 901";
$resn_exch{"1H35 901"}="H351 901"; $resn_exch{"2H35 901"}="H352 901"; $resn_exch{"3H35 901"}="H353 901";
$resn_exch{"1H21 902"}="H211 902"; $resn_exch{"2H21 902"}="H212 902"; $resn_exch{"1H30 902"}="H301 902";
$resn_exch{"2H30 902"}="H302 902"; $resn_exch{"1H31 902"}="H311 902"; $resn_exch{"2H31 902"}="H312 902";
$resn_exch{"1H33 902"}="H331 902"; $resn_exch{"2H33 902"}="H332 902"; $resn_exch{"1H34 902"}="H341 902";
$resn_exch{"2H34 902"}="H342 902"; $resn_exch{"1H47 902"}="H471 902"; $resn_exch{"2H47 902"}="H472 902";
$resn_exch{"1H7  903"}=" H71 903"; $resn_exch{"2H7  903"}=" H72 903"; $resn_exch{"1H15 903"}="H151 903";
$resn_exch{"2H15 903"}="H152 903"; $resn_exch{"3H15 903"}="H153 903"; $resn_exch{"1H20 903"}="H201 903";
$resn_exch{"2H20 903"}="H202 903"; $resn_exch{"1H21 903"}="H211 903"; $resn_exch{"2H21 903"}="H212 903";
$resn_exch{"1H22 903"}="H221 903"; $resn_exch{"2H22 903"}="H222 903"; $resn_exch{"1H24 903"}="H241 903";
$resn_exch{"2H24 903"}="H242 903"; $resn_exch{"1H25 903"}="H251 903"; $resn_exch{"2H25 903"}="H252 903";
$resn_exch{"1H81 903"}="H811 903"; $resn_exch{"2H81 903"}="H812 903"; $resn_exch{"3H81 903"}="H813 903";
$resn_exch{"1HN3 905"}="HN31 905"; $resn_exch{"2HN3 905"}="HN32 905"; $resn_exch{"1H15 905"}="H151 905";
$resn_exch{"2H15 905"}="H152 905"; $resn_exch{"1H16 905"}="H161 905"; $resn_exch{"2H16 905"}="H162 905";
$resn_exch{"3H16 905"}="H163 905"; $resn_exch{"1H19 905"}="H191 905"; $resn_exch{"2H19 905"}="H192 905";
$resn_exch{"1H20 905"}="H201 905"; $resn_exch{"2H20 905"}="H202 905"; $resn_exch{"3H20 905"}="H203 905";
$resn_exch{"1HN5 905"}="HN51 905"; $resn_exch{"2HN5 905"}="HN52 905"; $resn_exch{"1H21 910"}="H211 910";
$resn_exch{"2H21 910"}="H212 910"; $resn_exch{"1H30 910"}="H301 910"; $resn_exch{"2H30 910"}="H302 910";
$resn_exch{"1H11 915"}="H111 915"; $resn_exch{"2H11 915"}="H112 915"; $resn_exch{"3H11 915"}="H113 915";
$resn_exch{"1H29 915"}="H291 915"; $resn_exch{"2H29 915"}="H292 915"; $resn_exch{"1H30 915"}="H301 915";
$resn_exch{"2H30 915"}="H302 915"; $resn_exch{"1H32 915"}="H321 915"; $resn_exch{"2H32 915"}="H322 915";
$resn_exch{"1H33 915"}="H331 915"; $resn_exch{"2H33 915"}="H332 915"; $resn_exch{"1H33 922"}="H331 922";
$resn_exch{"2H33 922"}="H332 922"; $resn_exch{"1H28 922"}="H281 922"; $resn_exch{"2H28 922"}="H282 922";
$resn_exch{"3H28 922"}="H283 922"; $resn_exch{"1H27 922"}="H271 922"; $resn_exch{"2H27 922"}="H272 922";
$resn_exch{"3H27 922"}="H273 922"; $resn_exch{"1H11 922"}="H111 922"; $resn_exch{"2H11 922"}="H112 922";
$resn_exch{"1H1  936"}=" H11 936"; $resn_exch{"1H12 936"}="H121 936"; $resn_exch{"2H12 936"}="H122 936";
$resn_exch{"3H12 936"}="H123 936"; $resn_exch{"1H19 936"}="H191 936"; $resn_exch{"2H19 936"}="H192 936";
$resn_exch{"1H25 936"}="H251 936"; $resn_exch{"1H26 936"}="H261 936"; $resn_exch{"1H28 936"}="H281 936";
$resn_exch{"1H29 936"}="H291 936"; $resn_exch{"1H37 936"}="H371 936"; $resn_exch{"2H37 936"}="H372 936";
$resn_exch{"3H37 936"}="H373 936"; $resn_exch{"1H45 936"}="H451 936"; $resn_exch{"2H45 936"}="H452 936";
$resn_exch{"3H45 936"}="H453 936"; $resn_exch{"1H5* 93A"}="H5'1 93A"; $resn_exch{"2H5* 93A"}="H5'2 93A";
$resn_exch{"1H12 941"}="H121 941"; $resn_exch{"2H12 941"}="H122 941"; $resn_exch{"1H13 941"}="H131 941";
$resn_exch{"2H13 941"}="H132 941"; $resn_exch{"1H14 941"}="H141 941"; $resn_exch{"2H14 941"}="H142 941";
$resn_exch{"1H15 941"}="H151 941"; $resn_exch{"2H15 941"}="H152 941"; $resn_exch{"1H7  941"}=" H71 941";
$resn_exch{"2H7  941"}=" H72 941"; $resn_exch{"1H39 941"}="H391 941"; $resn_exch{"2H39 941"}="H392 941";
$resn_exch{"3H39 941"}="H393 941"; $resn_exch{"1H42 941"}="H421 941"; $resn_exch{"2H42 941"}="H422 941";
$resn_exch{"3H42 941"}="H423 941"; $resn_exch{"1H43 941"}="H431 941"; $resn_exch{"2H43 941"}="H432 941";
$resn_exch{"3H43 941"}="H433 941"; $resn_exch{"1H44 941"}="H441 941"; $resn_exch{"2H44 941"}="H442 941";
$resn_exch{"3H44 941"}="H443 941"; $resn_exch{"1H14 95A"}="H141 95A"; $resn_exch{"2H14 95A"}="H142 95A";
$resn_exch{"1H48 95A"}="H481 95A"; $resn_exch{"2H48 95A"}="H482 95A"; $resn_exch{"3H48 95A"}="H483 95A";
$resn_exch{"1H47 95A"}="H471 95A"; $resn_exch{"2H47 95A"}="H472 95A"; $resn_exch{"1H49 95A"}="H491 95A";
$resn_exch{"2H49 95A"}="H492 95A"; $resn_exch{"3H49 95A"}="H493 95A"; $resn_exch{"1H38 95A"}="H381 95A";
$resn_exch{"2H38 95A"}="H382 95A"; $resn_exch{"1H39 95A"}="H391 95A"; $resn_exch{"2H39 95A"}="H392 95A";
$resn_exch{"1H40 95A"}="H401 95A"; $resn_exch{"2H40 95A"}="H402 95A"; $resn_exch{"3H40 95A"}="H403 95A";
$resn_exch{"1H20 95A"}="H201 95A"; $resn_exch{"2H20 95A"}="H202 95A"; $resn_exch{"1H23 95A"}="H231 95A";
$resn_exch{"2H23 95A"}="H232 95A"; $resn_exch{"1H14 961"}="H141 961"; $resn_exch{"2H14 961"}="H142 961";
$resn_exch{"1H15 961"}="H151 961"; $resn_exch{"2H15 961"}="H152 961"; $resn_exch{"1H18 961"}="H181 961";
$resn_exch{"2H18 961"}="H182 961"; $resn_exch{"3H18 961"}="H183 961"; $resn_exch{"1H19 961"}="H191 961";
$resn_exch{"2H19 961"}="H192 961"; $resn_exch{"3H19 961"}="H193 961"; $resn_exch{"1H20 961"}="H201 961";
$resn_exch{"2H20 961"}="H202 961"; $resn_exch{"3H20 961"}="H203 961"; $resn_exch{"1H21 961"}="H211 961";
$resn_exch{"2H21 961"}="H212 961"; $resn_exch{"3H21 961"}="H213 961"; $resn_exch{"2HO2 961"}="HO22 961";
$resn_exch{"7HO2 961"}="HO27 961"; $resn_exch{"1H1  964"}="H11A 964"; $resn_exch{"2H1  964"}=" H12 964";
$resn_exch{"3H1  964"}="H13A 964"; $resn_exch{"1H18 964"}="H181 964"; $resn_exch{"2H18 964"}="H182 964";
$resn_exch{"1H19 964"}="H191 964"; $resn_exch{"2H19 964"}="H192 964"; $resn_exch{"1H16 964"}="H161 964";
$resn_exch{"2H16 964"}="H162 964"; $resn_exch{"1H15 964"}="H151 964"; $resn_exch{"2H15 964"}="H152 964";
$resn_exch{"1H10 964"}="H101 964"; $resn_exch{"2H10 964"}="H102 964"; $resn_exch{"1H9  964"}=" H91 964";
$resn_exch{"2H9  964"}=" H92 964"; $resn_exch{"1H5  964"}=" H51 964"; $resn_exch{"2H5  964"}=" H52 964";
$resn_exch{"1H6  964"}=" H61 964"; $resn_exch{"2H6  964"}=" H62 964"; $resn_exch{"1H34 965"}="H341 965";
$resn_exch{"2H34 965"}="H342 965"; $resn_exch{"1H26 965"}="H261 965"; $resn_exch{"2H26 965"}="H262 965";
$resn_exch{"1H25 965"}="H251 965"; $resn_exch{"2H25 965"}="H252 965"; $resn_exch{"1H17 965"}="H171 965";
$resn_exch{"2H17 965"}="H172 965"; $resn_exch{"1H16 965"}="H161 965"; $resn_exch{"2H16 965"}="H162 965";
$resn_exch{"1H08 965"}="H081 965"; $resn_exch{"2H08 965"}="H082 965"; $resn_exch{"1H11 965"}="H111 965";
$resn_exch{"2H11 965"}="H112 965"; $resn_exch{"1H12 974"}="H121 974"; $resn_exch{"2H12 974"}="H122 974";
$resn_exch{"1H32 974"}="H321 974"; $resn_exch{"2H32 974"}="H322 974"; $resn_exch{"1H34 974"}="H341 974";
$resn_exch{"2H34 974"}="H342 974"; $resn_exch{"1H35 974"}="H351 974"; $resn_exch{"2H35 974"}="H352 974";
$resn_exch{"1H36 974"}="H361 974"; $resn_exch{"2H36 974"}="H362 974"; $resn_exch{"1H30 974"}="H301 974";
$resn_exch{"2H30 974"}="H302 974"; $resn_exch{"3H30 974"}="H303 974"; $resn_exch{"1HN1 977"}="HN11 977";
$resn_exch{"2HN1 977"}="HN12 977"; $resn_exch{"1H12 979"}="H121 979"; $resn_exch{"2H12 979"}="H122 979";
$resn_exch{"1H13 979"}="H131 979"; $resn_exch{"2H13 979"}="H132 979"; $resn_exch{"1H2  979"}=" H21 979";
$resn_exch{"2H2  979"}=" H22 979"; $resn_exch{"1H11 979"}="H111 979"; $resn_exch{"2H11 979"}="H112 979";
$resn_exch{"1H16 982"}="H161 982"; $resn_exch{"2H16 982"}="H162 982"; $resn_exch{"1H47 983"}="H471 983";
$resn_exch{"2H47 983"}="H472 983"; $resn_exch{"1H35 983"}="H351 983"; $resn_exch{"2H35 983"}="H352 983";
$resn_exch{"1H33 983"}="H331 983"; $resn_exch{"2H33 983"}="H332 983"; $resn_exch{"1H30 983"}="H301 983";
$resn_exch{"2H30 983"}="H302 983"; $resn_exch{"3H30 983"}="H303 983"; $resn_exch{"1H29 983"}="H291 983";
$resn_exch{"2H29 983"}="H292 983"; $resn_exch{"3H29 983"}="H293 983"; $resn_exch{"1H15 983"}="H151 983";
$resn_exch{"2H15 983"}="H152 983"; $resn_exch{"1H9  983"}=" H91 983"; $resn_exch{"2H9  983"}=" H92 983";
$resn_exch{"1H10 983"}="H101 983"; $resn_exch{"2H10 983"}="H102 983"; $resn_exch{"1HC6 984"}="HC61 984";
$resn_exch{"2HC6 984"}="HC62 984"; $resn_exch{"1HC7 984"}="HC71 984"; $resn_exch{"2HC7 984"}="HC72 984";
$resn_exch{"1H10 984"}="H101 984"; $resn_exch{"2H10 984"}="H102 984"; $resn_exch{"3H10 984"}="H103 984";
$resn_exch{"1H17 984"}="H171 984"; $resn_exch{"2H17 984"}="H172 984"; $resn_exch{"1H18 984"}="H181 984";
$resn_exch{"2H18 984"}="H182 984"; $resn_exch{"1H20 984"}="H201 984"; $resn_exch{"2H20 984"}="H202 984";
$resn_exch{"1H21 984"}="H211 984"; $resn_exch{"2H21 984"}="H212 984"; $resn_exch{"1H31 984"}="H311 984";
$resn_exch{"2H31 984"}="H312 984"; $resn_exch{"3H31 984"}="H313 984"; $resn_exch{"1H56 984"}="H561 984";
$resn_exch{"2H56 984"}="H562 984"; $resn_exch{"1H57 984"}="H571 984"; $resn_exch{"2H57 984"}="H572 984";
$resn_exch{"1H36 989"}="H361 989"; $resn_exch{"2H36 989"}="H362 989"; $resn_exch{"1H62 989"}="H621 989";
$resn_exch{"2H62 989"}="H622 989"; $resn_exch{"3H62 989"}="H623 989"; $resn_exch{"1H45 989"}="H451 989";
$resn_exch{"2H45 989"}="H452 989"; $resn_exch{"1H46 989"}="H461 989"; $resn_exch{"2H46 989"}="H462 989";
$resn_exch{"1H49 989"}="H491 989"; $resn_exch{"2H49 989"}="H492 989"; $resn_exch{"1H52 989"}="H521 989";
$resn_exch{"2H52 989"}="H522 989"; $resn_exch{"1H55 989"}="H551 989"; $resn_exch{"2H55 989"}="H552 989";
$resn_exch{"3H55 989"}="H553 989"; $resn_exch{"1H35 993"}="H351 993"; $resn_exch{"2H35 993"}="H352 993";
$resn_exch{"3H35 993"}="H353 993"; $resn_exch{"1H28 993"}="H281 993"; $resn_exch{"2H28 993"}="H282 993";
$resn_exch{"1H18 993"}="H181 993"; $resn_exch{"2H18 993"}="H182 993"; $resn_exch{"3H18 993"}="H183 993";
$resn_exch{"1H18 994"}="H181 994"; $resn_exch{"2H18 994"}="H182 994"; $resn_exch{"3H18 994"}="H183 994";
$resn_exch{"1H23 994"}="H231 994"; $resn_exch{"2H23 994"}="H232 994"; $resn_exch{"3H23 994"}="H233 994";
$resn_exch{"1H28 994"}="H281 994"; $resn_exch{"2H28 994"}="H282 994"; $resn_exch{"3H28 994"}="H283 994";
$resn_exch{"1H6  995"}=" H61 995"; $resn_exch{"2H6  995"}=" H62 995"; $resn_exch{"1H7  995"}=" H71 995";
$resn_exch{"2H7  995"}=" H72 995"; $resn_exch{"1H11 995"}="H111 995"; $resn_exch{"2H11 995"}="H112 995";
$resn_exch{"3H11 995"}="H113 995"; $resn_exch{"1H12 995"}="H121 995"; $resn_exch{"2H12 995"}="H122 995";
$resn_exch{"3H12 995"}="H123 995"; $resn_exch{"1H14 995"}="H141 995"; $resn_exch{"2H14 995"}="H142 995";
$resn_exch{"1H15 995"}="H151 995"; $resn_exch{"2H15 995"}="H152 995"; $resn_exch{"1H17 995"}="H171 995";
$resn_exch{"2H17 995"}="H172 995"; $resn_exch{"3H17 995"}="H173 995"; $resn_exch{"1H18 995"}="H181 995";
$resn_exch{"2H18 995"}="H182 995"; $resn_exch{"3H18 995"}="H183 995"; $resn_exch{"1H19 995"}="H191 995";
$resn_exch{"2H19 995"}="H192 995"; $resn_exch{"1HN5 995"}="HN51 995"; $resn_exch{"2HN5 995"}="HN52 995";
$resn_exch{"1HN6 995"}="HN61 995"; $resn_exch{"2HN6 995"}="HN62 995"; $resn_exch{"1HD2 9AD"}="HD21 9AD";
$resn_exch{"2HD2 9AD"}="HD22 9AD"; $resn_exch{"1HD3 9AD"}="HD31 9AD"; $resn_exch{"2HD3 9AD"}="HD32 9AD";
$resn_exch{"1HD7 9AD"}="HD71 9AD"; $resn_exch{"2HD7 9AD"}="HD72 9AD"; $resn_exch{"3HD7 9AD"}="HD73 9AD";
$resn_exch{"1HD8 9AD"}="HD81 9AD"; $resn_exch{"2HD8 9AD"}="HD82 9AD"; $resn_exch{"3HD8 9AD"}="HD83 9AD";
$resn_exch{"1H9  9AM"}=" H91 9AM"; $resn_exch{"2H9  9AM"}=" H92 9AM"; $resn_exch{"1H11 9AM"}="H111 9AM";
$resn_exch{"2H11 9AM"}="H112 9AM"; $resn_exch{"3H11 9AM"}="H113 9AM"; $resn_exch{"1HOB 9AM"}="HOB1 9AM";
$resn_exch{"1HN9 9AM"}="HN91 9AM"; $resn_exch{"2HN9 9AM"}="HN92 9AM"; $resn_exch{"1HN1 9AP"}="HN11 9AP";
$resn_exch{"2HN1 9AP"}="HN12 9AP"; $resn_exch{"1H2  9AR"}=" H21 9AR"; $resn_exch{"1H9  9AR"}=" H91 9AR";
$resn_exch{"1H11 9AR"}="H111 9AR"; $resn_exch{"1H12 9AR"}="H121 9AR"; $resn_exch{"1H15 9AR"}="H151 9AR";
$resn_exch{"2H15 9AR"}="H152 9AR"; $resn_exch{"1H17 9AR"}="H171 9AR"; $resn_exch{"2H17 9AR"}="H172 9AR";
$resn_exch{"3H17 9AR"}="H173 9AR"; $resn_exch{"1H5  9AR"}=" H51 9AR"; $resn_exch{"1H6  9AR"}=" H61 9AR";
$resn_exch{"1H6  9CS"}=" H61 9CS"; $resn_exch{"2H6  9CS"}=" H62 9CS"; $resn_exch{"1H12 9CS"}="H121 9CS";
$resn_exch{"2H12 9CS"}="H122 9CS"; $resn_exch{"1H18 9CS"}="H181 9CS"; $resn_exch{"2H18 9CS"}="H182 9CS";
$resn_exch{"1HN1 9CS"}="HN11 9CS"; $resn_exch{"2HN1 9CS"}="HN12 9CS"; $resn_exch{"1HN2 9CS"}="HN21 9CS";
$resn_exch{"2HN2 9CS"}="HN22 9CS"; $resn_exch{"1HN3 9CS"}="HN31 9CS"; $resn_exch{"2HN3 9CS"}="HN32 9CS";
$resn_exch{"1HN4 9CS"}="HN41 9CS"; $resn_exch{"2HN4 9CS"}="HN42 9CS"; $resn_exch{"1HN6 9CS"}="HN61 9CS";
$resn_exch{"2HN6 9CS"}="HN62 9CS"; $resn_exch{"1HN6 9DA"}="HN61 9DA"; $resn_exch{"2HN6 9DA"}="HN62 9DA";
$resn_exch{"1HN2 9DG"}="HN21 9DG"; $resn_exch{"2HN2 9DG"}="HN22 9DG"; $resn_exch{"1H5' 9DI"}="H5'1 9DI";
$resn_exch{"2H5' 9DI"}="H5'2 9DI"; $resn_exch{"'HO5 9DI"}="HO5' 9DI"; $resn_exch{"'HO2 9DI"}="HO2' 9DI";
$resn_exch{"'HO3 9DI"}="HO3' 9DI"; $resn_exch{"1H9  9IN"}=" H91 9IN"; $resn_exch{"2H9  9IN"}=" H92 9IN";
$resn_exch{"3H9  9IN"}=" H93 9IN"; $resn_exch{"1H10 9IN"}="H101 9IN"; $resn_exch{"2H10 9IN"}="H102 9IN";
$resn_exch{"3H10 9IN"}="H103 9IN"; $resn_exch{"1H13 9IN"}="H131 9IN"; $resn_exch{"2H13 9IN"}="H132 9IN";
$resn_exch{"3H13 9IN"}="H133 9IN"; $resn_exch{"1H14 9IN"}="H141 9IN"; $resn_exch{"2H14 9IN"}="H142 9IN";
$resn_exch{"3H14 9IN"}="H143 9IN"; $resn_exch{"1H17 9IN"}="H171 9IN"; $resn_exch{"2H17 9IN"}="H172 9IN";
$resn_exch{"1H19 9IN"}="H191 9IN"; $resn_exch{"2H19 9IN"}="H192 9IN"; $resn_exch{"3H19 9IN"}="H193 9IN";
$resn_exch{"1H20 9IN"}="H201 9IN"; $resn_exch{"2H20 9IN"}="H202 9IN"; $resn_exch{"3H20 9IN"}="H203 9IN";
$resn_exch{"1H28 9IN"}="H281 9IN"; $resn_exch{"2H28 9IN"}="H282 9IN"; $resn_exch{"1H30 9IN"}="H301 9IN";
$resn_exch{"2H30 9IN"}="H302 9IN"; $resn_exch{"1H31 9IN"}="H311 9IN"; $resn_exch{"2H31 9IN"}="H312 9IN";
$resn_exch{"1H26 9IN"}="H261 9IN"; $resn_exch{"2H26 9IN"}="H262 9IN"; $resn_exch{"1H27 9IN"}="H271 9IN";
$resn_exch{"2H27 9IN"}="H272 9IN"; $resn_exch{"3H27 9IN"}="H273 9IN"; $resn_exch{"1H1  9IP"}="H11A 9IP";
$resn_exch{"2H1  9IP"}="H12A 9IP"; $resn_exch{"3H1  9IP"}=" H13 9IP"; $resn_exch{"1H14 9IP"}="H141 9IP";
$resn_exch{"2H14 9IP"}="H142 9IP"; $resn_exch{"1H22 9IP"}="H221 9IP"; $resn_exch{"2H22 9IP"}="H222 9IP";
$resn_exch{"1H1  9MG"}=" H11 9MG"; $resn_exch{"2H1  9MG"}=" H12 9MG"; $resn_exch{"3H1  9MG"}=" H13 9MG";
$resn_exch{"1H10 9MG"}="H101 9MG"; $resn_exch{"2H10 9MG"}="H102 9MG"; $resn_exch{"1H6B 9MR"}="H6B1 9MR";
$resn_exch{"2H6B 9MR"}="H6B2 9MR"; $resn_exch{"1H5M 9MR"}="H5M1 9MR"; $resn_exch{"2H5M 9MR"}="H5M2 9MR";
$resn_exch{"1H1A 9MR"}="H1A1 9MR"; $resn_exch{"2H1A 9MR"}="H1A2 9MR"; $resn_exch{"1H6A 9MR"}="H6A1 9MR";
$resn_exch{"2H6A 9MR"}="H6A2 9MR"; $resn_exch{"1H2  9OH"}=" H21 9OH"; $resn_exch{"2H2  9OH"}=" H22 9OH";
$resn_exch{"1H3  9OH"}=" H31 9OH"; $resn_exch{"2H3  9OH"}=" H32 9OH"; $resn_exch{"1H4  9OH"}=" H41 9OH";
$resn_exch{"2H4  9OH"}=" H42 9OH"; $resn_exch{"1H5  9OH"}=" H51 9OH"; $resn_exch{"2H5  9OH"}=" H52 9OH";
$resn_exch{"1H6  9OH"}=" H61 9OH"; $resn_exch{"2H6  9OH"}=" H62 9OH"; $resn_exch{"1H7  9OH"}=" H71 9OH";
$resn_exch{"2H7  9OH"}=" H72 9OH"; $resn_exch{"1H8  9OH"}=" H81 9OH"; $resn_exch{"2H8  9OH"}=" H82 9OH";
$resn_exch{"1H9  9OH"}=" H91 9OH"; $resn_exch{"1H10 9OH"}="H101 9OH"; $resn_exch{"1H11 9OH"}="H111 9OH";
$resn_exch{"1H12 9OH"}="H121 9OH"; $resn_exch{"1H13 9OH"}="H131 9OH"; $resn_exch{"1H14 9OH"}="H141 9OH";
$resn_exch{"2H14 9OH"}="H142 9OH"; $resn_exch{"1H15 9OH"}="H151 9OH"; $resn_exch{"2H15 9OH"}="H152 9OH";
$resn_exch{"1H16 9OH"}="H161 9OH"; $resn_exch{"2H16 9OH"}="H162 9OH"; $resn_exch{"1H17 9OH"}="H171 9OH";
$resn_exch{"2H17 9OH"}="H172 9OH"; $resn_exch{"1H18 9OH"}="H181 9OH"; $resn_exch{"2H18 9OH"}="H182 9OH";
$resn_exch{"3H18 9OH"}="H183 9OH"; $resn_exch{"1H20 9OH"}="H201 9OH"; $resn_exch{"1H21 9OH"}="H211 9OH";
$resn_exch{"1H8  9PP"}=" H81 9PP"; $resn_exch{"1HN6 9PP"}="HN61 9PP"; $resn_exch{"2HN6 9PP"}="HN62 9PP";
$resn_exch{"1HN2 9PP"}="HN21 9PP"; $resn_exch{"2HN2 9PP"}="HN22 9PP"; $resn_exch{"1H10 9PP"}="H101 9PP";
$resn_exch{"2H10 9PP"}="H102 9PP"; $resn_exch{"1H11 9PP"}="H111 9PP"; $resn_exch{"1H12 9PP"}="H121 9PP";
$resn_exch{"2H12 9PP"}="H122 9PP"; $resn_exch{"3H12 9PP"}="H123 9PP"; $resn_exch{"1H14 9PP"}="H141 9PP";
$resn_exch{"2H14 9PP"}="H142 9PP"; $resn_exch{"3HOP   A"}="HOP3   A"; $resn_exch{"2HOP   A"}="HOP2   A";
$resn_exch{"1H5*   A"}=" H5'   A"; $resn_exch{"2H5*   A"}="H5''   A"; $resn_exch{" H4*   A"}=" H4'   A";
$resn_exch{" H3*   A"}=" H3'   A"; $resn_exch{"H3T    A"}="HO3'   A"; $resn_exch{" H2*   A"}=" H2'   A";
$resn_exch{"2HO*   A"}="HO2'   A"; $resn_exch{" H1*   A"}=" H1'   A"; $resn_exch{"1H6    A"}=" H61   A";
$resn_exch{"2H6    A"}=" H62   A"; $resn_exch{"1HN  A0A"}=" HN1 A0A"; $resn_exch{"2HN  A0A"}=" HN2 A0A";
$resn_exch{"1HBC A0A"}="HBC1 A0A"; $resn_exch{"2HBC A0A"}="HBC2 A0A"; $resn_exch{"2HOB A12"}="HOB2 A12";
$resn_exch{"2HOA A12"}="HOA2 A12"; $resn_exch{"1H3A A12"}="H3A1 A12"; $resn_exch{"2H3A A12"}="H3A2 A12";
$resn_exch{"1H5* A12"}="H5'1 A12"; $resn_exch{"2H5* A12"}="H5'2 A12"; $resn_exch{" H4* A12"}=" H4' A12";
$resn_exch{" H3* A12"}=" H3' A12"; $resn_exch{"*HO3 A12"}="HO3' A12"; $resn_exch{" H2* A12"}=" H2' A12";
$resn_exch{"*HO2 A12"}="HO2' A12"; $resn_exch{" H1* A12"}=" H1' A12"; $resn_exch{"1HN6 A12"}="HN61 A12";
$resn_exch{"2HN6 A12"}="HN62 A12"; $resn_exch{"1H3C A14"}="H3C1 A14"; $resn_exch{"2H3C A14"}="H3C2 A14";
$resn_exch{"1H14 A14"}="H141 A14"; $resn_exch{"2H14 A14"}="H142 A14"; $resn_exch{"1H4C A14"}="H4C1 A14";
$resn_exch{"2H4C A14"}="H4C2 A14"; $resn_exch{"1H7C A14"}="H7C1 A14"; $resn_exch{"2H7C A14"}="H7C2 A14";
$resn_exch{"1H33 A14"}="H331 A14"; $resn_exch{"2H33 A14"}="H332 A14"; $resn_exch{"3H33 A14"}="H333 A14";
$resn_exch{"1H37 A14"}="H371 A14"; $resn_exch{"2H37 A14"}="H372 A14"; $resn_exch{"3H37 A14"}="H373 A14";
$resn_exch{"1HAL A18"}="HAL1 A18"; $resn_exch{"2HAL A18"}="HAL2 A18"; $resn_exch{"1H32 A1A"}="H321 A1A";
$resn_exch{"2H32 A1A"}="H322 A1A"; $resn_exch{"1H7C A1A"}="H7C1 A1A"; $resn_exch{"2H7C A1A"}="H7C2 A1A";
$resn_exch{"3H7C A1A"}="H7C3 A1A"; $resn_exch{"1H4C A1A"}="H4C1 A1A"; $resn_exch{"2H4C A1A"}="H4C2 A1A";
$resn_exch{"1H22 A1A"}="H221 A1A"; $resn_exch{"2H22 A1A"}="H222 A1A"; $resn_exch{"1H58 A1A"}="H581 A1A";
$resn_exch{"2H58 A1A"}="H582 A1A"; $resn_exch{"1H43 A1A"}="H431 A1A"; $resn_exch{"2H43 A1A"}="H432 A1A";
$resn_exch{"3H43 A1A"}="H433 A1A"; $resn_exch{"1H44 A1A"}="H441 A1A"; $resn_exch{"2H44 A1A"}="H442 A1A";
$resn_exch{"3H44 A1A"}="H443 A1A"; $resn_exch{"1H1  A1E"}=" H11 A1E"; $resn_exch{"2H1  A1E"}="H12A A1E";
$resn_exch{"1H2  A1E"}=" H21 A1E"; $resn_exch{"2H2  A1E"}=" H22 A1E"; $resn_exch{"1H6  A1E"}=" H61 A1E";
$resn_exch{"2H6  A1E"}=" H62 A1E"; $resn_exch{"1H13 A1E"}="H131 A1E"; $resn_exch{"2H13 A1E"}="H132 A1E";
$resn_exch{"1H14 A1E"}="H141 A1E"; $resn_exch{"2H14 A1E"}="H142 A1E"; $resn_exch{"1H15 A1E"}="H151 A1E";
$resn_exch{"2H15 A1E"}="H152 A1E"; $resn_exch{"1H16 A1E"}="H161 A1E"; $resn_exch{"2H16 A1E"}="H162 A1E";
$resn_exch{"1H17 A1E"}="H171 A1E"; $resn_exch{"2H17 A1E"}="H172 A1E"; $resn_exch{"1H18 A1E"}="H181 A1E";
$resn_exch{"2H18 A1E"}="H182 A1E"; $resn_exch{"1H19 A1E"}="H191 A1E"; $resn_exch{"2H19 A1E"}="H192 A1E";
$resn_exch{"1H20 A1E"}="H201 A1E"; $resn_exch{"2H20 A1E"}="H202 A1E"; $resn_exch{"1H21 A1E"}="H211 A1E";
$resn_exch{"2H21 A1E"}="H212 A1E"; $resn_exch{"1H22 A1E"}="H221 A1E"; $resn_exch{"2H22 A1E"}="H222 A1E";
$resn_exch{"1H34 A1E"}="H341 A1E"; $resn_exch{"2H34 A1E"}="H342 A1E"; $resn_exch{"1H35 A1E"}="H351 A1E";
$resn_exch{"2H35 A1E"}="H352 A1E"; $resn_exch{"1H36 A1E"}="H361 A1E"; $resn_exch{"2H36 A1E"}="H362 A1E";
$resn_exch{"1H37 A1E"}="H371 A1E"; $resn_exch{"2H37 A1E"}="H372 A1E"; $resn_exch{"1H2N A1P"}="H2N1 A1P";
$resn_exch{"2H2N A1P"}="H2N2 A1P"; $resn_exch{"1H2* A1P"}="H2'1 A1P"; $resn_exch{"2H2* A1P"}="H2'2 A1P";
$resn_exch{"1H5* A1P"}="H5'1 A1P"; $resn_exch{"2H5* A1P"}="H5'2 A1P"; $resn_exch{" H4* A1P"}=" H4' A1P";
$resn_exch{" H1* A1P"}=" H1' A1P"; $resn_exch{" H3* A1P"}=" H3' A1P"; $resn_exch{"1HN6 A1R"}="HN61 A1R";
$resn_exch{"2HN6 A1R"}="HN62 A1R"; $resn_exch{" H1* A1R"}=" H1' A1R"; $resn_exch{" H2* A1R"}=" H2' A1R";
$resn_exch{"HO2* A1R"}="HO2' A1R"; $resn_exch{" H3* A1R"}=" H3' A1R"; $resn_exch{"HO3* A1R"}="HO3' A1R";
$resn_exch{" H4* A1R"}=" H4' A1R"; $resn_exch{"1H5* A1R"}="H5'1 A1R"; $resn_exch{"2H5* A1R"}="H5'2 A1R";
$resn_exch{"1H5N A1R"}="H5N1 A1R"; $resn_exch{"2H5N A1R"}="H5N2 A1R"; $resn_exch{"1H1N A1R"}="H1N1 A1R";
$resn_exch{"2H1N A1R"}="H1N2 A1R"; $resn_exch{"1H38 A1T"}="H381 A1T"; $resn_exch{"2H38 A1T"}="H382 A1T";
$resn_exch{"1H40 A1T"}="H401 A1T"; $resn_exch{"2H40 A1T"}="H402 A1T"; $resn_exch{"1H43 A1T"}="H431 A1T";
$resn_exch{"2H43 A1T"}="H432 A1T"; $resn_exch{"1H46 A1T"}="H461 A1T"; $resn_exch{"2H46 A1T"}="H462 A1T";
$resn_exch{"1H48 A1T"}="H481 A1T"; $resn_exch{"2H48 A1T"}="H482 A1T"; $resn_exch{"3H48 A1T"}="H483 A1T";
$resn_exch{"1H28 A1T"}="H