/*
 * Decompiled with CFR 0.152.
 */
package king;

import driftwood.gui.FatJList;
import driftwood.gui.ReflectiveAction;
import driftwood.gui.TablePane;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.ListIterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import king.KingMain;
import king.core.KView;
import king.core.Kinemage;

public class ViewEditor {
    KingMain kMain;
    JDialog dialog;
    JList list;

    public ViewEditor(KingMain kingMain) {
        this.kMain = kingMain;
        this.dialog = new JDialog(this.kMain.getTopWindow(), "Edit views", true);
        this.dialog.setDefaultCloseOperation(2);
        this.list = new FatJList(0, 20);
        this.list.setSelectionMode(0);
        this.list.setVisibleRowCount(12);
        this.list.setBorder(BorderFactory.createEtchedBorder());
        JScrollPane jScrollPane = new JScrollPane(this.list);
        JButton jButton = new JButton(new ReflectiveAction("Close", null, this, "onClose"));
        JButton jButton2 = new JButton(new ReflectiveAction("Move up", this.kMain.prefs.moveUpIcon, this, "onMoveUp"));
        JButton jButton3 = new JButton(new ReflectiveAction("Move down", this.kMain.prefs.moveDownIcon, this, "onMoveDown"));
        JButton jButton4 = new JButton(new ReflectiveAction("Go to", null, this, "onGoTo"));
        JButton jButton5 = new JButton(new ReflectiveAction("Go Next", this.kMain.prefs.stepForwardIcon, this, "onGoNext"));
        JButton jButton6 = new JButton(new ReflectiveAction("Go Prev", this.kMain.prefs.stepBackIcon, this, "onGoPrev"));
        JButton jButton7 = new JButton(new ReflectiveAction("Rename", null, this, "onRename"));
        JButton jButton8 = new JButton(new ReflectiveAction("Delete", this.kMain.prefs.deleteIcon, this, "onDelete"));
        jButton2.setMnemonic(85);
        jButton3.setMnemonic(68);
        jButton7.setMnemonic(82);
        jButton4.setMnemonic(71);
        jButton.setMnemonic(67);
        TablePane tablePane = new TablePane();
        tablePane.insets(2).hfill(true).weights(0.0, 0.0);
        tablePane.save().weights(1.0, 1.0).vfill(true).hfill(true).addCell(jScrollPane, 1, 9).restore();
        tablePane.addCell(jButton4).newRow();
        tablePane.addCell(jButton5).newRow();
        tablePane.addCell(jButton6).newRow();
        tablePane.save().weights(0.0, 1.0).insets(0).addCell(Box.createVerticalStrut(10)).restore().newRow();
        tablePane.addCell(jButton7).newRow();
        tablePane.addCell(jButton8).newRow();
        tablePane.save().weights(0.0, 1.0).insets(0).addCell(Box.createVerticalStrut(10)).restore().newRow();
        tablePane.addCell(jButton2).newRow();
        tablePane.addCell(jButton3).newRow();
        tablePane.center().hfill(false).addCell(jButton, 2, 1);
        this.dialog.setContentPane(tablePane);
        this.dialog.getRootPane().setDefaultButton(jButton);
    }

    public void onClose(ActionEvent actionEvent) {
        this.dialog.dispose();
    }

    public void onMoveUp(ActionEvent actionEvent) {
        Kinemage kinemage = this.kMain.getKinemage();
        if (kinemage == null) {
            return;
        }
        KView kView = (KView)this.list.getSelectedValue();
        if (kView == null) {
            return;
        }
        List<KView> list = kinemage.getViewList();
        ListIterator<KView> listIterator = list.listIterator();
        KView kView2 = null;
        KView kView3 = null;
        do {
            kView2 = kView3;
        } while (!kView.equals(kView3 = listIterator.next()));
        if (kView2 != null) {
            listIterator.set(kView2);
            listIterator.previous();
            listIterator.previous();
            listIterator.set(kView);
        }
        kinemage.setModified(true);
        kinemage.fireKinChanged(131072);
        this.list.setListData(list.toArray());
        this.list.setSelectedValue(kView, true);
    }

    public void onMoveDown(ActionEvent actionEvent) {
        Kinemage kinemage = this.kMain.getKinemage();
        if (kinemage == null) {
            return;
        }
        KView kView = (KView)this.list.getSelectedValue();
        if (kView == null) {
            return;
        }
        List<KView> list = kinemage.getViewList();
        ListIterator<KView> listIterator = list.listIterator();
        while (!kView.equals(listIterator.next())) {
        }
        if (listIterator.hasNext()) {
            KView kView2 = listIterator.next();
            listIterator.set(kView);
            listIterator.previous();
            listIterator.previous();
            listIterator.set(kView2);
        }
        kinemage.setModified(true);
        kinemage.fireKinChanged(131072);
        this.list.setListData(list.toArray());
        this.list.setSelectedValue(kView, true);
    }

    public void onGoTo(ActionEvent actionEvent) {
        KView kView = (KView)this.list.getSelectedValue();
        if (kView == null) {
            return;
        }
        this.kMain.setView(kView);
    }

    public void onRename(ActionEvent actionEvent) {
        KView kView = (KView)this.list.getSelectedValue();
        if (kView == null) {
            return;
        }
        String string = (String)JOptionPane.showInputDialog(this.kMain.getTopWindow(), "Name for this view:", "Rename view", -1, null, null, kView.getName());
        if (string == null) {
            return;
        }
        kView.setName(string);
        Kinemage kinemage = this.kMain.getKinemage();
        if (kinemage == null) {
            return;
        }
        kinemage.setModified(true);
        kinemage.fireKinChanged(131072);
        this.list.setListData(kinemage.getViewList().toArray());
        this.list.setSelectedValue(kView, true);
    }

    public void onDelete(ActionEvent actionEvent) {
        Kinemage kinemage = this.kMain.getKinemage();
        if (kinemage == null) {
            return;
        }
        KView kView = (KView)this.list.getSelectedValue();
        if (kView == null) {
            return;
        }
        List<KView> list = kinemage.getViewList();
        list.remove(kView);
        kinemage.setModified(true);
        kinemage.fireKinChanged(131072);
        this.list.setListData(list.toArray());
    }

    public void onGoNext(ActionEvent actionEvent) {
        int n = this.list.getSelectedIndex() + 1;
        if (n >= 0 && n < this.list.getModel().getSize()) {
            this.list.setSelectedIndex(n);
            this.onGoTo(null);
        }
    }

    public void onGoPrev(ActionEvent actionEvent) {
        int n = this.list.getSelectedIndex() - 1;
        if (n >= 0 && n < this.list.getModel().getSize()) {
            this.list.setSelectedIndex(n);
            this.onGoTo(null);
        }
    }

    public void editViews() {
        Kinemage kinemage = this.kMain.getKinemage();
        if (kinemage == null) {
            return;
        }
        this.list.setListData(kinemage.getViewList().toArray());
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(this.kMain.getTopWindow());
        this.dialog.setVisible(true);
    }
}

