/*
 * Decompiled with CFR 0.152.
 */
package driftwood.moldb2;

import driftwood.moldb2.Atom;
import driftwood.moldb2.CoordinateFile;
import driftwood.moldb2.Model;
import driftwood.moldb2.PdbReader;
import driftwood.moldb2.Residue;
import driftwood.util.SoftLog;
import java.awt.BorderLayout;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class ModelTreeViewer {
    DefaultMutableTreeNode buildRootNode(CoordinateFile coordinateFile) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("All models", true);
        Iterator iterator = coordinateFile.getModels().iterator();
        while (iterator.hasNext()) {
            Model model = (Model)iterator.next();
            DefaultMutableTreeNode defaultMutableTreeNode2 = this.buildModelNode(model);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
        return defaultMutableTreeNode;
    }

    DefaultMutableTreeNode buildModelNode(Model model) {
        Object object;
        Iterator iterator;
        Object object2;
        Iterator iterator2;
        Object object3;
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Model " + model, true);
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Chains", true);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        Object object4 = model.getChainIDs().iterator();
        while (object4.hasNext()) {
            object3 = (String)object4.next();
            iterator2 = new DefaultMutableTreeNode("Chain '" + (String)object3 + "'", true);
            defaultMutableTreeNode2.add((MutableTreeNode)((Object)iterator2));
            object2 = model.getChain((String)object3).iterator();
            while (object2.hasNext()) {
                iterator = (Residue)object2.next();
                object = this.buildResidueNode((Residue)((Object)iterator));
                ((DefaultMutableTreeNode)((Object)iterator2)).add((MutableTreeNode)object);
            }
        }
        object4 = new DefaultMutableTreeNode("Segments", true);
        defaultMutableTreeNode.add((MutableTreeNode)object4);
        object3 = model.getSegmentIDs().iterator();
        while (object3.hasNext()) {
            iterator2 = (String)object3.next();
            object2 = new DefaultMutableTreeNode("Segment '" + (String)((Object)iterator2) + "'", true);
            ((DefaultMutableTreeNode)object4).add((MutableTreeNode)object2);
            iterator = model.getSegment((String)((Object)iterator2)).iterator();
            while (iterator.hasNext()) {
                object = (Residue)iterator.next();
                DefaultMutableTreeNode defaultMutableTreeNode3 = this.buildResidueNode((Residue)object);
                ((DefaultMutableTreeNode)object2).add(defaultMutableTreeNode3);
            }
        }
        object3 = new DefaultMutableTreeNode("All residues", true);
        defaultMutableTreeNode.add((MutableTreeNode)object3);
        iterator2 = model.getResidues().iterator();
        while (iterator2.hasNext()) {
            object2 = (Residue)iterator2.next();
            iterator = this.buildResidueNode((Residue)object2);
            ((DefaultMutableTreeNode)object3).add((MutableTreeNode)((Object)iterator));
        }
        return defaultMutableTreeNode;
    }

    DefaultMutableTreeNode buildResidueNode(Residue residue) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(residue, true);
        Iterator iterator = residue.getAtoms().iterator();
        while (iterator.hasNext()) {
            Atom atom = (Atom)iterator.next();
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(atom.getName(), false);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
        return defaultMutableTreeNode;
    }

    CoordinateFile loadCoordinateFile() throws IOException {
        PdbReader pdbReader = new PdbReader();
        CoordinateFile coordinateFile = pdbReader.read(System.in);
        return coordinateFile;
    }

    void launchTreeWindow(TreeNode treeNode) {
        JTree jTree = new JTree(treeNode, true);
        JScrollPane jScrollPane = new JScrollPane(jTree);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add(jScrollPane);
        JFrame jFrame = new JFrame("Model Tree Viewer");
        jFrame.setDefaultCloseOperation(3);
        jFrame.setContentPane(jPanel);
        jFrame.setSize(500, 800);
        jFrame.setVisible(true);
    }

    public void Main() {
        try {
            CoordinateFile coordinateFile = this.loadCoordinateFile();
            DefaultMutableTreeNode defaultMutableTreeNode = this.buildRootNode(coordinateFile);
            this.launchTreeWindow(defaultMutableTreeNode);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            SoftLog.err.println("*** Reading PDB file failed on I/O ***");
        }
    }

    public static void main(String[] stringArray) {
        ModelTreeViewer modelTreeViewer = new ModelTreeViewer();
        try {
            modelTreeViewer.parseArguments(stringArray);
            modelTreeViewer.Main();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            SoftLog.err.println();
            modelTreeViewer.showHelp(true);
            SoftLog.err.println();
            SoftLog.err.println("*** Error parsing arguments: " + illegalArgumentException.getMessage());
            System.exit(1);
        }
    }

    void parseArguments(String[] stringArray) {
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            String string2;
            String string3 = stringArray[i];
            if (!string3.startsWith("-") || !bl || string3.equals("-")) {
                this.interpretArg(string3);
                continue;
            }
            if (string3.equals("--")) {
                bl = false;
                continue;
            }
            int n = string3.indexOf(61);
            if (n != -1) {
                string2 = string3.substring(0, n);
                string = string3.substring(n + 1);
            } else {
                string2 = string3;
                string = null;
            }
            try {
                this.interpretFlag(string2, string);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                throw new IllegalArgumentException("'" + string3 + "' expects to be followed by a parameter");
            }
        }
    }

    void showHelp(boolean bl) {
        if (bl) {
            InputStream inputStream = this.getClass().getResourceAsStream("ModelTreeViewer.help");
            if (inputStream == null) {
                SoftLog.err.println("\n*** Unable to locate help information in 'ModelTreeViewer.help' ***\n");
            } else {
                try {
                    this.streamcopy(inputStream, System.out);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        SoftLog.err.println("driftwood.moldb2.ModelTreeViewer");
        SoftLog.err.println("Copyright (C) 2003 by Ian W. Davis. All rights reserved.");
    }

    void streamcopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    void interpretArg(String string) {
    }

    void interpretFlag(String string, String string2) {
        if (string.equals("-help") || string.equals("-h")) {
            this.showHelp(true);
            System.exit(0);
        } else if (!string.equals("-dummy_option")) {
            throw new IllegalArgumentException("'" + string + "' is not recognized as a valid flag");
        }
    }
}

