/*
 * Decompiled with CFR 0.152.
 */
package driftwood.r3;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import driftwood.r3.Transform;
import driftwood.r3.Triple;
import driftwood.r3.Tuple3;
import driftwood.util.Strings;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public class PrincipleAxes {
    Matrix principleComponents;
    double[] pcaEigenvalues;
    Transform pcaTransform;
    Triple boxMin;
    Triple boxMax;

    public PrincipleAxes(Collection collection) {
        Matrix matrix = PrincipleAxes.packTuples(collection);
        Matrix matrix2 = PrincipleAxes.covariance(matrix);
        EigenvalueDecomposition eigenvalueDecomposition = matrix2.eig();
        this.pcaEigenvalues = new double[3];
        this.principleComponents = PrincipleAxes.sortEigenvectors(eigenvalueDecomposition, this.pcaEigenvalues);
        this.pcaTransform = new Transform().likeMatrix(this.principleComponents.get(0, 0), this.principleComponents.get(1, 0), this.principleComponents.get(2, 0), this.principleComponents.get(0, 1), this.principleComponents.get(1, 1), this.principleComponents.get(2, 1), this.principleComponents.get(0, 2), this.principleComponents.get(1, 2), this.principleComponents.get(2, 2));
        this.boxMin = new Triple(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        this.boxMax = new Triple(-1.7976931348623157E308, -1.7976931348623157E308, -1.7976931348623157E308);
        Triple triple = new Triple();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Tuple3 tuple3 = (Tuple3)iterator.next();
            this.pcaTransform.transform(tuple3, triple);
            this.boxMin.setX(Math.min(this.boxMin.getX(), triple.getX()));
            this.boxMin.setY(Math.min(this.boxMin.getY(), triple.getY()));
            this.boxMin.setZ(Math.min(this.boxMin.getZ(), triple.getZ()));
            this.boxMax.setX(Math.max(this.boxMax.getX(), triple.getX()));
            this.boxMax.setY(Math.max(this.boxMax.getY(), triple.getY()));
            this.boxMax.setZ(Math.max(this.boxMax.getZ(), triple.getZ()));
        }
    }

    public Transform getTransform() {
        return new Transform().like(this.pcaTransform);
    }

    public Tuple3[] getAxes() {
        Tuple3[] tuple3Array = new Triple[]{new Triple(this.principleComponents.get(0, 0), this.principleComponents.get(1, 0), this.principleComponents.get(2, 0)), new Triple(this.principleComponents.get(0, 1), this.principleComponents.get(1, 1), this.principleComponents.get(2, 1)), new Triple(this.principleComponents.get(0, 2), this.principleComponents.get(1, 2), this.principleComponents.get(2, 2))};
        return tuple3Array;
    }

    public double[] getLengths() {
        return (double[])this.pcaEigenvalues.clone();
    }

    public Tuple3 getKinCenter() {
        Matrix matrix = new Matrix(3, 1);
        matrix.set(0, 0, (this.boxMax.getX() + this.boxMin.getX()) / 2.0);
        matrix.set(1, 0, (this.boxMax.getY() + this.boxMin.getY()) / 2.0);
        matrix.set(2, 0, (this.boxMax.getZ() + this.boxMin.getZ()) / 2.0);
        matrix = this.principleComponents.times(matrix);
        return new Triple(matrix.get(0, 0), matrix.get(1, 0), matrix.get(2, 0));
    }

    public double getKinSpan() {
        return this.boxMax.getX() - this.boxMin.getX();
    }

    public String getKinView(String string, String string2) {
        DecimalFormat decimalFormat = Strings.usDecimalFormat("0.0###");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("@").append(string).append("viewid {").append(string2).append("}\n");
        double d = 1.05 * this.getKinSpan();
        double d2 = 200.0;
        stringBuffer.append("@").append(string).append("span ").append(decimalFormat.format(d)).append("\n");
        stringBuffer.append("@").append(string).append("zslab ").append(decimalFormat.format(d2)).append("\n");
        Tuple3 tuple3 = this.getKinCenter();
        stringBuffer.append("@").append(string).append("center ").append(decimalFormat.format(tuple3.getX()));
        stringBuffer.append(" ").append(decimalFormat.format(tuple3.getY()));
        stringBuffer.append(" ").append(decimalFormat.format(tuple3.getZ())).append("\n");
        stringBuffer.append("@").append(string).append("matrix");
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                stringBuffer.append(" ").append(decimalFormat.format(this.principleComponents.get(i, j)));
            }
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    static Matrix packTuples(Collection collection) {
        int n = collection.size();
        Matrix matrix = new Matrix(n, 3);
        int n2 = 0;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Tuple3 tuple3 = (Tuple3)iterator.next();
            matrix.set(n2, 0, tuple3.getX());
            matrix.set(n2, 1, tuple3.getY());
            matrix.set(n2, 2, tuple3.getZ());
            ++n2;
        }
        return matrix;
    }

    static Matrix covariance(Matrix matrix) {
        int n;
        int n2;
        int n3 = matrix.getRowDimension();
        int n4 = matrix.getColumnDimension();
        double[] dArray = new double[n4];
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n4; ++n) {
                int n5 = n;
                dArray[n5] = dArray[n5] + matrix.get(n2, n);
            }
        }
        n2 = 0;
        while (n2 < n4) {
            int n6 = n2++;
            dArray[n6] = dArray[n6] / (double)n3;
        }
        Matrix matrix2 = new Matrix(n3, n4);
        for (n = 0; n < n3; ++n) {
            for (int i = 0; i < n4; ++i) {
                matrix2.set(n, i, matrix.get(n, i) - dArray[i]);
            }
        }
        Matrix matrix3 = matrix2.transpose().times(matrix2);
        matrix3.timesEquals(1.0 / (double)n3);
        return matrix3;
    }

    static Matrix sortEigenvectors(EigenvalueDecomposition eigenvalueDecomposition, double[] dArray) {
        Matrix matrix = eigenvalueDecomposition.getD();
        Matrix matrix2 = eigenvalueDecomposition.getV();
        int n = matrix2.getRowDimension();
        int n2 = matrix2.getColumnDimension();
        Object[] objectArray = new Sortable[n2];
        for (int i = 0; i < n2; ++i) {
            objectArray[i] = new Sortable(matrix.get(i, i), i);
        }
        Arrays.sort(objectArray);
        Matrix matrix3 = new Matrix(n, n2);
        for (int i = 0; i < n2; ++i) {
            dArray[i] = ((Sortable)objectArray[i]).value;
            for (int j = 0; j < n; ++j) {
                matrix3.set(j, i, matrix2.get(j, ((Sortable)objectArray[i]).index));
            }
        }
        return matrix3;
    }

    private static class Sortable
    implements Comparable {
        public final double value;
        public final int index;

        public Sortable(double d, int n) {
            this.value = d;
            this.index = n;
        }

        public int compareTo(Object object) {
            Sortable sortable = (Sortable)object;
            if (this.value < sortable.value) {
                return 1;
            }
            if (this.value > sortable.value) {
                return -1;
            }
            return 0;
        }
    }
}

