/*
 * Decompiled with CFR 0.152.
 */
package driftwood.moldb2;

import driftwood.moldb2.Model;
import driftwood.moldb2.SecondaryStructure;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public class CoordinateFile {
    public static final String SECTION_USER_MOD = "USER  MOD";
    ArrayList models;
    Collection unmodModels = null;
    ArrayList headers;
    Collection unmodHeaders = null;
    int pdbv2atoms = 0;
    SecondaryStructure secondaryStructure = new SecondaryStructure.AllCoil();
    File file = null;
    String idCode = null;

    public CoordinateFile() {
        this.models = new ArrayList();
        this.headers = new ArrayList();
    }

    public Collection getModels() {
        if (this.unmodModels == null) {
            this.unmodModels = Collections.unmodifiableCollection(this.models);
        }
        return this.unmodModels;
    }

    public Model getFirstModel() {
        Iterator iterator = this.models.iterator();
        return (Model)iterator.next();
    }

    public void add(Model model) {
        if (model == null) {
            throw new NullPointerException("Cannot add a null model");
        }
        this.models.add(model);
    }

    public void replace(Model model, Model model2) {
        if (model2 == null) {
            throw new NullPointerException("Cannot add a null model");
        }
        int n = this.models.indexOf(model);
        if (n == -1) {
            this.models.add(model2);
        } else {
            this.models.set(n, model2);
        }
    }

    public void addHeader(String string, String string2) {
        if (SECTION_USER_MOD.equals(string)) {
            this.headers.add(0, string2);
        } else {
            this.headers.add(string2);
        }
    }

    public Collection getHeaders() {
        if (this.unmodHeaders == null) {
            this.unmodHeaders = Collections.unmodifiableCollection(this.headers);
        }
        return this.unmodHeaders;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getIdCode() {
        return this.idCode;
    }

    public void setIdCode(String string) {
        this.idCode = string;
    }

    public SecondaryStructure getSecondaryStructure() {
        return this.secondaryStructure;
    }

    public void setSecondaryStructure(SecondaryStructure secondaryStructure) {
        this.secondaryStructure = secondaryStructure;
    }

    public void setPdbv2Count(int n) {
        this.pdbv2atoms = n;
    }

    public int getPdbv2Count() {
        return this.pdbv2atoms;
    }
}

