/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.kingtools;

import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.Residue;
import driftwood.util.Props;
import driftwood.util.SoftLog;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.StringTokenizer;
import king.core.AHE;
import king.core.KGroup;
import king.core.KList;
import king.core.KPaint;
import king.core.KPalette;
import king.points.VectorPoint;

public class ModelPlotter {
    static final DecimalFormat df2 = new DecimalFormat("0.00");
    Props scProps;
    VectorPoint prev = null;
    KList listCa = null;
    KList listMc = null;
    KList listMcH = null;
    KList listSc = null;
    KList listScH = null;
    public KPaint mainColor = KPalette.defaultColor;
    public KPaint sideColor = KPalette.defaultColor;
    public KPaint hyColor = KPalette.defaultColor;
    public int modelWidth = 2;

    public ModelPlotter() {
        this.scProps = new Props();
        try {
            InputStream inputStream = this.getClass().getResourceAsStream("sc-connect.props");
            if (inputStream != null) {
                this.scProps.load(inputStream);
                inputStream.close();
            } else {
                SoftLog.err.println("Couldn't find sc-connect.props");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace(SoftLog.err);
        }
    }

    public void plotAminoAcids(Model model, Collection collection, ModelState modelState) {
        if (this.listCa == null || this.listMc == null || this.listMcH == null || this.listSc == null || this.listScH == null) {
            this.createLists();
        }
        this.clearLists();
        for (Residue residue : collection) {
            Residue residue2 = residue.getNext(model);
            this.plotString(residue, modelState, this.scProps.getString("aminoacid.mc", ""), this.listMc);
            this.plotString(residue, modelState, this.scProps.getString("aminoacid.hy", ""), this.listMcH);
            String string = residue.getName().toLowerCase();
            this.plotString(residue, modelState, this.scProps.getString(string + ".sc", ""), this.listSc);
            this.plotString(residue, modelState, this.scProps.getString(string + ".hy", ""), this.listScH);
            if (residue2 == null || !collection.contains(residue2)) continue;
            Atom atom = residue.getAtom(" C  ");
            Atom atom2 = residue2.getAtom(" N  ");
            if (atom != null && atom2 != null) {
                try {
                    this.plotAtom(modelState.get(atom), false, this.listMc);
                    this.plotAtom(modelState.get(atom2), true, this.listMc);
                }
                catch (AtomException atomException) {
                    SoftLog.err.println(atomException.getMessage());
                }
            }
            Atom atom3 = residue.getAtom(" CA ");
            Atom atom4 = residue2.getAtom(" CA ");
            if (atom3 == null || atom4 == null) continue;
            try {
                this.plotAtom(modelState.get(atom3), false, this.listCa);
                this.plotAtom(modelState.get(atom4), true, this.listCa);
            }
            catch (AtomException atomException) {
                SoftLog.err.println(atomException.getMessage());
            }
        }
        this.prev = null;
    }

    void plotString(Residue residue, ModelState modelState, String string, KList kList) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",;", true);
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals(",")) continue;
            if (string2.equals(";")) {
                bl = false;
                continue;
            }
            Atom atom = residue.getAtom(string2);
            if (atom == null) {
                bl = false;
                continue;
            }
            try {
                this.plotAtom(modelState.get(atom), bl, kList);
                bl = true;
            }
            catch (AtomException atomException) {
                SoftLog.err.println(atomException.getMessage());
                bl = false;
            }
        }
    }

    void plotAtom(AtomState atomState, boolean bl, KList kList) {
        Residue residue = atomState.getResidue();
        String string = (atomState.getName() + atomState.getAltConf() + residue.getName() + " " + residue.getChain() + " " + residue.getSequenceNumber() + residue.getInsertionCode()).toLowerCase() + (atomState.getOccupancy() < 1.0 ? " " + df2.format(atomState.getOccupancy()) : "") + (atomState.getTempFactor() > 1.0 ? " B" + df2.format(atomState.getTempFactor()) : "");
        if (!bl) {
            this.prev = null;
        }
        VectorPoint vectorPoint = new VectorPoint(string, this.prev);
        vectorPoint.setX(atomState.getX());
        vectorPoint.setY(atomState.getY());
        vectorPoint.setZ(atomState.getZ());
        kList.add((AHE)vectorPoint);
        this.prev = vectorPoint;
    }

    public void createLists() {
        if (this.listCa == null) {
            this.listCa = new KList("vector");
            this.listCa.setName("Calphas");
            this.listCa.addMaster("refit Calphas");
            this.listCa.setOn(false);
        }
        if (this.listMc == null) {
            this.listMc = new KList("vector");
            this.listMc.setName("mc");
            this.listMc.addMaster("refit mainchain");
        }
        if (this.listMcH == null) {
            this.listMcH = new KList("vector");
            this.listMcH.setName("mcH");
            this.listMcH.addMaster("refit mainchain");
            this.listMcH.addMaster("refit H's");
        }
        if (this.listSc == null) {
            this.listSc = new KList("vector");
            this.listSc.setName("sc");
            this.listSc.addMaster("refit sidechain");
        }
        if (this.listScH == null) {
            this.listScH = new KList("vector");
            this.listScH.setName("scH");
            this.listScH.addMaster("refit sidechain");
            this.listScH.addMaster("refit H's");
        }
        this.listCa.setWidth(this.modelWidth);
        this.listCa.setColor(this.mainColor);
        this.listMc.setWidth(this.modelWidth);
        this.listMc.setColor(this.mainColor);
        this.listMcH.setWidth(this.modelWidth);
        this.listMcH.setColor(this.hyColor);
        this.listSc.setWidth(this.modelWidth);
        this.listSc.setColor(this.sideColor);
        this.listScH.setWidth(this.modelWidth);
        this.listScH.setColor(this.hyColor);
    }

    public KGroup createGroup(String string) {
        if (this.listCa == null || this.listMc == null || this.listMcH == null || this.listSc == null || this.listScH == null) {
            this.createLists();
        }
        KGroup kGroup = new KGroup();
        kGroup.setName(string);
        kGroup.setDominant(true);
        KGroup kGroup2 = new KGroup("mainchain");
        kGroup.add((AHE)kGroup2);
        KGroup kGroup3 = new KGroup("sidechain");
        kGroup.add((AHE)kGroup3);
        kGroup2.add((AHE)this.listMc);
        kGroup2.add((AHE)this.listMcH);
        kGroup2.add((AHE)this.listCa);
        kGroup3.add((AHE)this.listSc);
        kGroup3.add((AHE)this.listScH);
        return kGroup;
    }

    public KGroup createSubgroup(String string) {
        if (this.listMc == null || this.listMcH == null || this.listSc == null || this.listScH == null) {
            this.createLists();
        }
        KGroup kGroup = new KGroup();
        kGroup.setName(string);
        kGroup.setDominant(true);
        kGroup.add((AHE)this.listMc);
        kGroup.add((AHE)this.listMcH);
        kGroup.add((AHE)this.listCa);
        kGroup.add((AHE)this.listSc);
        kGroup.add((AHE)this.listScH);
        return kGroup;
    }

    public void clearLists() {
        if (this.listCa != null) {
            this.listCa.clear();
        }
        if (this.listMc != null) {
            this.listMc.clear();
        }
        if (this.listMcH != null) {
            this.listMcH.clear();
        }
        if (this.listSc != null) {
            this.listSc.clear();
        }
        if (this.listScH != null) {
            this.listScH.clear();
        }
    }

    public void setHOn(boolean bl) {
        if (this.listMcH != null) {
            this.listMcH.setOn(bl);
        }
        if (this.listScH != null) {
            this.listScH.setOn(bl);
        }
    }
}

