/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.forcefield;

import chiropraxis.forcefield.EnergyTerm;
import java.util.HashMap;

public class NonbondedTerm
implements EnergyTerm {
    int[] atomType;
    final int numTypes;
    double[] Aij;
    double[] Bij;
    double[] Qij;
    final double cutoff;
    final double cutoff_2;
    int initCap;
    HashMap lookup;
    Key tmpkey;

    public NonbondedTerm(int[] nArray, double d, int n) {
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] < 0) {
                throw new IllegalArgumentException("Negative atom types are not allowed!");
            }
            if (nArray[i] <= n2) continue;
            n2 = nArray[i];
        }
        this.numTypes = n2 + 1;
        this.atomType = (int[])nArray.clone();
        this.Aij = new double[this.numTypes * this.numTypes];
        this.Bij = new double[this.numTypes * this.numTypes];
        this.Qij = new double[this.numTypes * this.numTypes];
        this.cutoff = d;
        this.cutoff_2 = d * d;
        this.initCap = n;
        this.lookup = new HashMap();
        this.tmpkey = new Key();
    }

    public void setAB(int n, int n2, double d, double d2) {
        int n3 = n * this.numTypes + n2;
        int n4 = n2 * this.numTypes + n;
        this.Aij[n3] = this.Aij[n4] = d;
        this.Bij[n3] = this.Bij[n4] = d2;
    }

    public void setQ(int n, int n2, double d) {
        int n3 = n * this.numTypes + n2;
        int n4 = n2 * this.numTypes + n;
        this.Qij[n3] = this.Qij[n4] = d;
    }

    void buildLookupTable(double[] dArray) {
        this.lookup.clear();
        int n = 3 * (dArray.length / 3);
        block0: for (int i = n - 3; i >= 0; i -= 3) {
            int n2;
            int n3 = (int)(dArray[i] / this.cutoff);
            int n4 = (int)(dArray[i + 1] / this.cutoff);
            int n5 = (int)(dArray[i + 2] / this.cutoff);
            this.tmpkey.set(n3, n4, n5);
            int[] nArray = (int[])this.lookup.get(this.tmpkey);
            if (nArray == null) {
                nArray = new int[this.initCap];
                nArray[0] = i;
                for (n2 = 1; n2 < nArray.length; ++n2) {
                    nArray[n2] = -1;
                }
                this.lookup.put(this.tmpkey, nArray);
                this.tmpkey = new Key();
                continue;
            }
            if (nArray[nArray.length - 1] != -1) {
                int[] nArray2 = new int[2 * nArray.length];
                for (n2 = 0; n2 < nArray.length; ++n2) {
                    nArray2[n2] = nArray[n2];
                }
                nArray2[n2++] = i;
                while (n2 < nArray2.length) {
                    nArray2[n2] = -1;
                    ++n2;
                }
                this.lookup.put(this.tmpkey, nArray2);
                this.tmpkey = new Key();
                continue;
            }
            for (n2 = 0; n2 < nArray.length; ++n2) {
                if (nArray[n2] != -1) continue;
                nArray[n2] = i;
                continue block0;
            }
        }
    }

    public double eval(double[] dArray) {
        this.buildLookupTable(dArray);
        int n = 0;
        int n2 = dArray.length;
        double d = 0.0;
        for (int i = 0; i < n2; i += 3) {
            double d2 = dArray[i];
            double d3 = dArray[i + 1];
            double d4 = dArray[i + 2];
            int n3 = (int)(d2 / this.cutoff);
            int n4 = (int)(d3 / this.cutoff);
            int n5 = (int)(d4 / this.cutoff);
            int n6 = this.atomType[n];
            d += this.evalCell(dArray, i, n6, d2, d3, d4, n3 + 1, n4 + 1, n5 + 1);
            d += this.evalCell(dArray, i, n6, d2, d3, d4, n3 + 1, n4 + 1, n5);
            d += this.evalCell(dArray, i, n6, d2, d3, d4, n3 + 1, n4 + 1, n5 - 1);
            d += this.evalCell(dArray, i, n6, d2, d3, d4, n3 + 1, n4, n5 + 1);
            d += this.evalCell(dArray, i, n6, d2, d3, d4, n3 + 1, n4, n5);
            d += this.evalCell(dArray, i, n6, d2, d3, d4, n3 + 1, n4, n5 - 1);
            d += this.evalCell(dArray, i, n6, d2, d3, d4, n3 + 1, n4 - 1, n5 + 1);
            d += this.evalCell(dArray, i, n6, d2, d3, d4, n3 + 1, n4 - 1, n5);
            d += this.evalCell(dArray, i, n6, d2, d3, d4, n3 + 1, n4 - 1, n5 - 1);
            d += this.evalCell(dArray, i, n6, d2, d3, d4, n3, n4 + 1, n5 + 1);
            d += this.evalCell(dArray, i, n6, d2, d3, d4, n3, n4 + 1, n5);
            d += this.evalCell(dArray, i, n6, d2, d3, d4, n3, n4 + 1, n5 - 1);
            d += this.evalCell(dArray, i, n6, d2, d3, d4, n3, n4, n5 + 1);
            d += this.evalCell(dArray, i, n6, d2, d3, d4, n3, n4, n5);
            d += this.evalCell(dArray, i, n6, d2, d3, d4, n3, n4, n5 - 1);
            d += this.evalCell(dArray, i, n6, d2, d3, d4, n3, n4 - 1, n5 + 1);
            d += this.evalCell(dArray, i, n6, d2, d3, d4, n3, n4 - 1, n5);
            d += this.evalCell(dArray, i, n6, d2, d3, d4, n3, n4 - 1, n5 - 1);
            d += this.evalCell(dArray, i, n6, d2, d3, d4, n3 - 1, n4 + 1, n5 + 1);
            d += this.evalCell(dArray, i, n6, d2, d3, d4, n3 - 1, n4 + 1, n5);
            d += this.evalCell(dArray, i, n6, d2, d3, d4, n3 - 1, n4 + 1, n5 - 1);
            d += this.evalCell(dArray, i, n6, d2, d3, d4, n3 - 1, n4, n5 + 1);
            d += this.evalCell(dArray, i, n6, d2, d3, d4, n3 - 1, n4, n5);
            d += this.evalCell(dArray, i, n6, d2, d3, d4, n3 - 1, n4, n5 - 1);
            d += this.evalCell(dArray, i, n6, d2, d3, d4, n3 - 1, n4 - 1, n5 + 1);
            d += this.evalCell(dArray, i, n6, d2, d3, d4, n3 - 1, n4 - 1, n5);
            d += this.evalCell(dArray, i, n6, d2, d3, d4, n3 - 1, n4 - 1, n5 - 1);
            ++n;
        }
        return d;
    }

    public double eval(double[] dArray, double[] dArray2) {
        this.buildLookupTable(dArray);
        int n = 0;
        int n2 = dArray.length;
        double d = 0.0;
        for (int i = 0; i < n2; i += 3) {
            double d2 = dArray[i];
            double d3 = dArray[i + 1];
            double d4 = dArray[i + 2];
            int n3 = (int)(d2 / this.cutoff);
            int n4 = (int)(d3 / this.cutoff);
            int n5 = (int)(d4 / this.cutoff);
            int n6 = this.atomType[n];
            d += this.evalCell(dArray, dArray2, i, n6, d2, d3, d4, n3 + 1, n4 + 1, n5 + 1);
            d += this.evalCell(dArray, dArray2, i, n6, d2, d3, d4, n3 + 1, n4 + 1, n5);
            d += this.evalCell(dArray, dArray2, i, n6, d2, d3, d4, n3 + 1, n4 + 1, n5 - 1);
            d += this.evalCell(dArray, dArray2, i, n6, d2, d3, d4, n3 + 1, n4, n5 + 1);
            d += this.evalCell(dArray, dArray2, i, n6, d2, d3, d4, n3 + 1, n4, n5);
            d += this.evalCell(dArray, dArray2, i, n6, d2, d3, d4, n3 + 1, n4, n5 - 1);
            d += this.evalCell(dArray, dArray2, i, n6, d2, d3, d4, n3 + 1, n4 - 1, n5 + 1);
            d += this.evalCell(dArray, dArray2, i, n6, d2, d3, d4, n3 + 1, n4 - 1, n5);
            d += this.evalCell(dArray, dArray2, i, n6, d2, d3, d4, n3 + 1, n4 - 1, n5 - 1);
            d += this.evalCell(dArray, dArray2, i, n6, d2, d3, d4, n3, n4 + 1, n5 + 1);
            d += this.evalCell(dArray, dArray2, i, n6, d2, d3, d4, n3, n4 + 1, n5);
            d += this.evalCell(dArray, dArray2, i, n6, d2, d3, d4, n3, n4 + 1, n5 - 1);
            d += this.evalCell(dArray, dArray2, i, n6, d2, d3, d4, n3, n4, n5 + 1);
            d += this.evalCell(dArray, dArray2, i, n6, d2, d3, d4, n3, n4, n5);
            d += this.evalCell(dArray, dArray2, i, n6, d2, d3, d4, n3, n4, n5 - 1);
            d += this.evalCell(dArray, dArray2, i, n6, d2, d3, d4, n3, n4 - 1, n5 + 1);
            d += this.evalCell(dArray, dArray2, i, n6, d2, d3, d4, n3, n4 - 1, n5);
            d += this.evalCell(dArray, dArray2, i, n6, d2, d3, d4, n3, n4 - 1, n5 - 1);
            d += this.evalCell(dArray, dArray2, i, n6, d2, d3, d4, n3 - 1, n4 + 1, n5 + 1);
            d += this.evalCell(dArray, dArray2, i, n6, d2, d3, d4, n3 - 1, n4 + 1, n5);
            d += this.evalCell(dArray, dArray2, i, n6, d2, d3, d4, n3 - 1, n4 + 1, n5 - 1);
            d += this.evalCell(dArray, dArray2, i, n6, d2, d3, d4, n3 - 1, n4, n5 + 1);
            d += this.evalCell(dArray, dArray2, i, n6, d2, d3, d4, n3 - 1, n4, n5);
            d += this.evalCell(dArray, dArray2, i, n6, d2, d3, d4, n3 - 1, n4, n5 - 1);
            d += this.evalCell(dArray, dArray2, i, n6, d2, d3, d4, n3 - 1, n4 - 1, n5 + 1);
            d += this.evalCell(dArray, dArray2, i, n6, d2, d3, d4, n3 - 1, n4 - 1, n5);
            d += this.evalCell(dArray, dArray2, i, n6, d2, d3, d4, n3 - 1, n4 - 1, n5 - 1);
            ++n;
        }
        return d;
    }

    double evalCell(double[] dArray, int n, int n2, double d, double d2, double d3, int n3, int n4, int n5) {
        int n6;
        this.tmpkey.set(n3, n4, n5);
        int[] nArray = (int[])this.lookup.get(this.tmpkey);
        if (nArray == null) {
            return 0.0;
        }
        double d4 = 0.0;
        for (int i = 0; i < nArray.length && (n6 = nArray[i]) > n; ++i) {
            double d5 = d - dArray[n6];
            double d6 = d2 - dArray[n6 + 1];
            double d7 = d3 - dArray[n6 + 2];
            double d8 = d5 * d5 + d6 * d6 + d7 * d7;
            if (d8 > this.cutoff_2) continue;
            int n7 = n2 * this.numTypes + this.atomType[n6 / 3];
            double d9 = d8 * d8;
            double d10 = d9 * d9;
            d4 += this.Aij[n7] / d10 - this.Bij[n7] / d9;
            double d11 = this.Qij[n7];
            if (d11 == 0.0) continue;
            d4 += d11 / Math.sqrt(d8);
        }
        return d4;
    }

    double evalCell(double[] dArray, double[] dArray2, int n, int n2, double d, double d2, double d3, int n3, int n4, int n5) {
        int n6;
        this.tmpkey.set(n3, n4, n5);
        int[] nArray = (int[])this.lookup.get(this.tmpkey);
        if (nArray == null) {
            return 0.0;
        }
        double d4 = 0.0;
        for (int i = 0; i < nArray.length && (n6 = nArray[i]) > n; ++i) {
            double d5 = d - dArray[n6];
            double d6 = d2 - dArray[n6 + 1];
            double d7 = d3 - dArray[n6 + 2];
            double d8 = d5 * d5 + d6 * d6 + d7 * d7;
            if (d8 > this.cutoff_2) continue;
            int n7 = n2 * this.numTypes + this.atomType[n6 / 3];
            double d9 = Math.sqrt(d8);
            double d10 = d8 * d8;
            double d11 = d10 * d10;
            double d12 = this.Aij[n7] / d11;
            double d13 = -this.Bij[n7] / d10;
            double d14 = this.Qij[n7] / d9;
            d4 += d12 + d13 + d14;
            double d15 = (-8.0 * d12 + -4.0 * d13 - d14) / d8;
            double d16 = d15 * d5;
            double d17 = d15 * d6;
            double d18 = d15 * d7;
            int n8 = n;
            dArray2[n8] = dArray2[n8] + d16;
            int n9 = n + 1;
            dArray2[n9] = dArray2[n9] + d17;
            int n10 = n + 2;
            dArray2[n10] = dArray2[n10] + d18;
            int n11 = n6;
            dArray2[n11] = dArray2[n11] - d16;
            int n12 = n6 + 1;
            dArray2[n12] = dArray2[n12] - d17;
            int n13 = n6 + 2;
            dArray2[n13] = dArray2[n13] - d18;
        }
        return d4;
    }

    static class Key {
        static final int HALF = 0x100000;
        long index = -1L;
        int hashCode = -1;

        public Key() {
        }

        public Key(int n, int n2, int n3) {
            this.set(n, n2, n3);
        }

        public void set(int n, int n2, int n3) {
            this.index = n + 0x100000 | n2 + 0x100000 << 21 | n3 + 0x100000 << 42;
            this.hashCode = (int)(this.index ^ this.index >> 32);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object object) {
            return object == null ? false : ((Key)object).index == this.index;
        }
    }
}

