/*
 * Decompiled with CFR 0.152.
 */
package jiffiloop;

import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.Residue;
import driftwood.r3.Triple;
import driftwood.r3.Tuple3;
import java.text.DecimalFormat;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProteinStem {
    public static final int N_TERM = 1;
    public static final int C_TERM = 2;
    static final DecimalFormat df = new DecimalFormat("0.000");
    Residue zeroRes;
    Residue oneRes;
    Residue twoRes;
    ArrayList<AtomState> states;
    ArrayList<Double> pairStats;
    String sourceModName;
    String sourceChain;
    int stemType;

    public ProteinStem(Model model, String string, Residue residue, Residue residue2, Residue residue3, int n) {
        this.sourceModName = model.getName();
        this.sourceChain = string;
        ModelState modelState = model.getState();
        this.zeroRes = residue;
        this.oneRes = residue2;
        this.twoRes = residue3;
        this.stemType = n;
        try {
            AtomState atomState = modelState.get(this.zeroRes.getAtom(" CA "));
            AtomState atomState2 = modelState.get(this.oneRes.getAtom(" CA "));
            AtomState atomState3 = modelState.get(this.twoRes.getAtom(" CA "));
            AtomState atomState4 = modelState.get(this.zeroRes.getAtom(" O  "));
            AtomState atomState5 = modelState.get(this.oneRes.getAtom(" O  "));
            this.states = new ArrayList();
            this.states.add(atomState);
            this.states.add(atomState2);
            this.states.add(atomState3);
            this.states.add(atomState4);
            this.states.add(atomState5);
            this.pairStats = this.pairAnalyze(atomState4, atomState, atomState2, atomState3, atomState5);
            System.out.print(this.sourceModName + " " + this.sourceChain + " ");
            for (Double d : this.pairStats) {
                double d2 = d;
                System.out.print(df.format(d2) + " ");
            }
            System.out.println();
        }
        catch (AtomException atomException) {
            System.err.println("Problem with atom " + atomException.getMessage());
        }
    }

    public ArrayList<Double> pairAnalyze(Triple triple, Triple triple2, Triple triple3, Triple triple4, Triple triple5) {
        double[] dArray = new double[]{Triple.angle(triple2, triple3, triple4), Triple.dihedral(triple, triple2, triple3, triple4), Triple.dihedral(triple2, triple3, triple4, triple5)};
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (double d : dArray) {
            arrayList.add(new Double(d));
        }
        return arrayList;
    }

    public ArrayList<Double> getParameters() {
        return this.pairStats;
    }

    public ArrayList<AtomState> getAtomStates() {
        return this.states;
    }

    public int getOneNum() {
        return this.oneRes.getSequenceInteger();
    }

    public String getSourceString() {
        return (this.sourceModName + this.sourceChain).trim();
    }

    public int getStemType() {
        return this.stemType;
    }

    public Tuple3[] getTupleArray() {
        Tuple3[] tuple3Array = new Tuple3[]{this.states.get(0), this.states.get(1), this.states.get(2)};
        return tuple3Array;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ProteinStem)) {
            return false;
        }
        ProteinStem proteinStem = (ProteinStem)object;
        return this.pairStats.equals(proteinStem.getParameters()) && this.states.equals(proteinStem.getAtomStates());
    }

    public int hashCode() {
        return this.pairStats.hashCode() ^ this.states.hashCode();
    }
}

