/*
 * Decompiled with CFR 0.152.
 */
package hless;

import hless.Residue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Model {
    public String pdbID = "    ";
    public double resolution = 0.0;
    LinkedHashMap resMap = new LinkedHashMap(1001);
    Residue lastCreated = null;

    public Model() {
    }

    public Model(String string) {
        this.pdbID = string;
    }

    public Residue getResidue(String string) {
        if (this.resMap.containsKey(string)) {
            return (Residue)this.resMap.get(string);
        }
        Residue residue = new Residue(this, string);
        this.resMap.put(residue.name, residue);
        residue.prev = this.lastCreated;
        if (this.lastCreated != null) {
            this.lastCreated.next = residue;
        }
        this.lastCreated = residue;
        return residue;
    }

    public Residue findResidue(String string) {
        return (Residue)this.resMap.get(string);
    }

    public Collection findResidue(Pattern pattern) {
        return this.findResidue(new Pattern[]{pattern});
    }

    public Collection findResidue(Pattern[] patternArray) {
        int n;
        ArrayList<Residue> arrayList = new ArrayList<Residue>();
        Matcher[] matcherArray = new Matcher[patternArray.length];
        for (n = 0; n < patternArray.length; ++n) {
            matcherArray[n] = patternArray[n].matcher("");
        }
        Iterator iterator = this.resMap.values().iterator();
        while (iterator.hasNext()) {
            Residue residue = (Residue)iterator.next();
            boolean bl = true;
            for (n = 0; n < matcherArray.length && bl; ++n) {
                matcherArray[n].reset(residue.name);
                if (matcherArray[n].matches()) continue;
                bl = false;
            }
            if (!bl) continue;
            arrayList.add(residue);
        }
        return arrayList;
    }

    public Collection findResidue(String[] stringArray) {
        ArrayList<Residue> arrayList = new ArrayList<Residue>();
        Iterator iterator = this.resMap.values().iterator();
        while (iterator.hasNext()) {
            Residue residue = (Residue)iterator.next();
            boolean bl = true;
            for (int i = 0; i < stringArray.length && bl; ++i) {
                if (residue.name.indexOf(stringArray[i]) != -1) continue;
                bl = false;
            }
            if (!bl) continue;
            arrayList.add(residue);
        }
        return arrayList;
    }

    public Residue addResidue(Residue residue) {
        if (this.resMap.containsKey(residue.name)) {
            Residue residue2 = (Residue)this.resMap.get(residue.name);
            residue.prev = residue2.prev;
            residue.next = residue2.next;
            if (residue.prev != null) {
                residue.prev.next = residue;
            }
            if (residue.next != null) {
                residue.next.prev = residue;
            }
            this.resMap.put(residue.name, residue);
            return residue2;
        }
        this.resMap.put(residue.name, residue);
        residue.prev = this.lastCreated;
        if (this.lastCreated != null) {
            this.lastCreated.next = residue;
        }
        this.lastCreated = residue;
        return null;
    }

    public Iterator residueIterator() {
        return this.resMap.values().iterator();
    }
}

