
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2025 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQCamera.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QCamera>
#include <QVideoWidget>
#include <QGraphicsVideoItem>
#include <QMediaCaptureSession>
#include "gsiQt.h"
#include "gsiQtMultimediaCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QCamera

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QCamera::staticMetaObject);
}


// QCameraDevice QCamera::cameraDevice()


static void _init_f_cameraDevice_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QCameraDevice > ();
}

static void _call_f_cameraDevice_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QCameraDevice > ((QCameraDevice)((QCamera *)cls)->cameraDevice ());
}


// QCameraFormat QCamera::cameraFormat()


static void _init_f_cameraFormat_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QCameraFormat > ();
}

static void _call_f_cameraFormat_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QCameraFormat > ((QCameraFormat)((QCamera *)cls)->cameraFormat ());
}


// QMediaCaptureSession *QCamera::captureSession()


static void _init_f_captureSession_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMediaCaptureSession * > ();
}

static void _call_f_captureSession_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMediaCaptureSession * > ((QMediaCaptureSession *)((QCamera *)cls)->captureSession ());
}


// int QCamera::colorTemperature()


static void _init_f_colorTemperature_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_colorTemperature_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QCamera *)cls)->colorTemperature ());
}


// QPointF QCamera::customFocusPoint()


static void _init_f_customFocusPoint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPointF > ();
}

static void _call_f_customFocusPoint_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPointF > ((QPointF)((QCamera *)cls)->customFocusPoint ());
}


// QCamera::Error QCamera::error()


static void _init_f_error_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QCamera::Error>::target_type > ();
}

static void _call_f_error_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QCamera::Error>::target_type > ((qt_gsi::Converter<QCamera::Error>::target_type)qt_gsi::CppToQtAdaptor<QCamera::Error>(((QCamera *)cls)->error ()));
}


// QString QCamera::errorString()


static void _init_f_errorString_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_errorString_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QCamera *)cls)->errorString ());
}


// float QCamera::exposureCompensation()


static void _init_f_exposureCompensation_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<float > ();
}

static void _call_f_exposureCompensation_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<float > ((float)((QCamera *)cls)->exposureCompensation ());
}


// QCamera::ExposureMode QCamera::exposureMode()


static void _init_f_exposureMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QCamera::ExposureMode>::target_type > ();
}

static void _call_f_exposureMode_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QCamera::ExposureMode>::target_type > ((qt_gsi::Converter<QCamera::ExposureMode>::target_type)qt_gsi::CppToQtAdaptor<QCamera::ExposureMode>(((QCamera *)cls)->exposureMode ()));
}


// float QCamera::exposureTime()


static void _init_f_exposureTime_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<float > ();
}

static void _call_f_exposureTime_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<float > ((float)((QCamera *)cls)->exposureTime ());
}


// QCamera::FlashMode QCamera::flashMode()


static void _init_f_flashMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QCamera::FlashMode>::target_type > ();
}

static void _call_f_flashMode_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QCamera::FlashMode>::target_type > ((qt_gsi::Converter<QCamera::FlashMode>::target_type)qt_gsi::CppToQtAdaptor<QCamera::FlashMode>(((QCamera *)cls)->flashMode ()));
}


// float QCamera::focusDistance()


static void _init_f_focusDistance_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<float > ();
}

static void _call_f_focusDistance_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<float > ((float)((QCamera *)cls)->focusDistance ());
}


// QCamera::FocusMode QCamera::focusMode()


static void _init_f_focusMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QCamera::FocusMode>::target_type > ();
}

static void _call_f_focusMode_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QCamera::FocusMode>::target_type > ((qt_gsi::Converter<QCamera::FocusMode>::target_type)qt_gsi::CppToQtAdaptor<QCamera::FocusMode>(((QCamera *)cls)->focusMode ()));
}


// QPointF QCamera::focusPoint()


static void _init_f_focusPoint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPointF > ();
}

static void _call_f_focusPoint_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPointF > ((QPointF)((QCamera *)cls)->focusPoint ());
}


// bool QCamera::isActive()


static void _init_f_isActive_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isActive_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QCamera *)cls)->isActive ());
}


// bool QCamera::isAvailable()


static void _init_f_isAvailable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isAvailable_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QCamera *)cls)->isAvailable ());
}


// bool QCamera::isExposureModeSupported(QCamera::ExposureMode mode)


static void _init_f_isExposureModeSupported_c2466 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QCamera::ExposureMode>::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isExposureModeSupported_c2466 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCamera::ExposureMode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QCamera::ExposureMode>::target_type & >() (args, heap);
  ret.write<bool > ((bool)((QCamera *)cls)->isExposureModeSupported (qt_gsi::QtToCppAdaptor<QCamera::ExposureMode>(arg1).cref()));
}


// bool QCamera::isFlashModeSupported(QCamera::FlashMode mode)


static void _init_f_isFlashModeSupported_c2101 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QCamera::FlashMode>::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isFlashModeSupported_c2101 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCamera::FlashMode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QCamera::FlashMode>::target_type & >() (args, heap);
  ret.write<bool > ((bool)((QCamera *)cls)->isFlashModeSupported (qt_gsi::QtToCppAdaptor<QCamera::FlashMode>(arg1).cref()));
}


// bool QCamera::isFlashReady()


static void _init_f_isFlashReady_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isFlashReady_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QCamera *)cls)->isFlashReady ());
}


// bool QCamera::isFocusModeSupported(QCamera::FocusMode mode)


static void _init_f_isFocusModeSupported_c2119 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QCamera::FocusMode>::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isFocusModeSupported_c2119 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCamera::FocusMode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QCamera::FocusMode>::target_type & >() (args, heap);
  ret.write<bool > ((bool)((QCamera *)cls)->isFocusModeSupported (qt_gsi::QtToCppAdaptor<QCamera::FocusMode>(arg1).cref()));
}


// bool QCamera::isTorchModeSupported(QCamera::TorchMode mode)


static void _init_f_isTorchModeSupported_c2119 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QCamera::TorchMode>::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isTorchModeSupported_c2119 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCamera::TorchMode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QCamera::TorchMode>::target_type & >() (args, heap);
  ret.write<bool > ((bool)((QCamera *)cls)->isTorchModeSupported (qt_gsi::QtToCppAdaptor<QCamera::TorchMode>(arg1).cref()));
}


// bool QCamera::isWhiteBalanceModeSupported(QCamera::WhiteBalanceMode mode)


static void _init_f_isWhiteBalanceModeSupported_c2798 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QCamera::WhiteBalanceMode>::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isWhiteBalanceModeSupported_c2798 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCamera::WhiteBalanceMode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QCamera::WhiteBalanceMode>::target_type & >() (args, heap);
  ret.write<bool > ((bool)((QCamera *)cls)->isWhiteBalanceModeSupported (qt_gsi::QtToCppAdaptor<QCamera::WhiteBalanceMode>(arg1).cref()));
}


// int QCamera::isoSensitivity()


static void _init_f_isoSensitivity_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_isoSensitivity_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QCamera *)cls)->isoSensitivity ());
}


// float QCamera::manualExposureTime()


static void _init_f_manualExposureTime_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<float > ();
}

static void _call_f_manualExposureTime_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<float > ((float)((QCamera *)cls)->manualExposureTime ());
}


// int QCamera::manualIsoSensitivity()


static void _init_f_manualIsoSensitivity_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_manualIsoSensitivity_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QCamera *)cls)->manualIsoSensitivity ());
}


// float QCamera::maximumExposureTime()


static void _init_f_maximumExposureTime_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<float > ();
}

static void _call_f_maximumExposureTime_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<float > ((float)((QCamera *)cls)->maximumExposureTime ());
}


// int QCamera::maximumIsoSensitivity()


static void _init_f_maximumIsoSensitivity_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_maximumIsoSensitivity_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QCamera *)cls)->maximumIsoSensitivity ());
}


// float QCamera::maximumZoomFactor()


static void _init_f_maximumZoomFactor_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<float > ();
}

static void _call_f_maximumZoomFactor_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<float > ((float)((QCamera *)cls)->maximumZoomFactor ());
}


// float QCamera::minimumExposureTime()


static void _init_f_minimumExposureTime_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<float > ();
}

static void _call_f_minimumExposureTime_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<float > ((float)((QCamera *)cls)->minimumExposureTime ());
}


// int QCamera::minimumIsoSensitivity()


static void _init_f_minimumIsoSensitivity_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_minimumIsoSensitivity_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QCamera *)cls)->minimumIsoSensitivity ());
}


// float QCamera::minimumZoomFactor()


static void _init_f_minimumZoomFactor_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<float > ();
}

static void _call_f_minimumZoomFactor_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<float > ((float)((QCamera *)cls)->minimumZoomFactor ());
}


// void QCamera::setActive(bool active)


static void _init_f_setActive_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("active");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setActive_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCamera *)cls)->setActive (arg1);
}


// void QCamera::setAutoExposureTime()


static void _init_f_setAutoExposureTime_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_setAutoExposureTime_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCamera *)cls)->setAutoExposureTime ();
}


// void QCamera::setAutoIsoSensitivity()


static void _init_f_setAutoIsoSensitivity_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_setAutoIsoSensitivity_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCamera *)cls)->setAutoIsoSensitivity ();
}


// void QCamera::setCameraDevice(const QCameraDevice &cameraDevice)


static void _init_f_setCameraDevice_2571 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cameraDevice");
  decl->add_arg<const QCameraDevice & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCameraDevice_2571 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QCameraDevice &arg1 = gsi::arg_reader<const QCameraDevice & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCamera *)cls)->setCameraDevice (arg1);
}


// void QCamera::setCameraFormat(const QCameraFormat &format)


static void _init_f_setCameraFormat_2596 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QCameraFormat & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCameraFormat_2596 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QCameraFormat &arg1 = gsi::arg_reader<const QCameraFormat & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCamera *)cls)->setCameraFormat (arg1);
}


// void QCamera::setColorTemperature(int colorTemperature)


static void _init_f_setColorTemperature_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("colorTemperature");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setColorTemperature_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCamera *)cls)->setColorTemperature (arg1);
}


// void QCamera::setCustomFocusPoint(const QPointF &point)


static void _init_f_setCustomFocusPoint_1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("point");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCustomFocusPoint_1986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = gsi::arg_reader<const QPointF & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCamera *)cls)->setCustomFocusPoint (arg1);
}


// void QCamera::setExposureCompensation(float ev)


static void _init_f_setExposureCompensation_970 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ev");
  decl->add_arg<float > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setExposureCompensation_970 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  float arg1 = gsi::arg_reader<float >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCamera *)cls)->setExposureCompensation (arg1);
}


// void QCamera::setExposureMode(QCamera::ExposureMode mode)


static void _init_f_setExposureMode_2466 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QCamera::ExposureMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setExposureMode_2466 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCamera::ExposureMode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QCamera::ExposureMode>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCamera *)cls)->setExposureMode (qt_gsi::QtToCppAdaptor<QCamera::ExposureMode>(arg1).cref());
}


// void QCamera::setFlashMode(QCamera::FlashMode mode)


static void _init_f_setFlashMode_2101 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QCamera::FlashMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFlashMode_2101 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCamera::FlashMode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QCamera::FlashMode>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCamera *)cls)->setFlashMode (qt_gsi::QtToCppAdaptor<QCamera::FlashMode>(arg1).cref());
}


// void QCamera::setFocusDistance(float d)


static void _init_f_setFocusDistance_970 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("d");
  decl->add_arg<float > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFocusDistance_970 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  float arg1 = gsi::arg_reader<float >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCamera *)cls)->setFocusDistance (arg1);
}


// void QCamera::setFocusMode(QCamera::FocusMode mode)


static void _init_f_setFocusMode_2119 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QCamera::FocusMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFocusMode_2119 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCamera::FocusMode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QCamera::FocusMode>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCamera *)cls)->setFocusMode (qt_gsi::QtToCppAdaptor<QCamera::FocusMode>(arg1).cref());
}


// void QCamera::setManualExposureTime(float seconds)


static void _init_f_setManualExposureTime_970 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("seconds");
  decl->add_arg<float > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setManualExposureTime_970 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  float arg1 = gsi::arg_reader<float >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCamera *)cls)->setManualExposureTime (arg1);
}


// void QCamera::setManualIsoSensitivity(int iso)


static void _init_f_setManualIsoSensitivity_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("iso");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setManualIsoSensitivity_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCamera *)cls)->setManualIsoSensitivity (arg1);
}


// void QCamera::setTorchMode(QCamera::TorchMode mode)


static void _init_f_setTorchMode_2119 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QCamera::TorchMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTorchMode_2119 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCamera::TorchMode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QCamera::TorchMode>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCamera *)cls)->setTorchMode (qt_gsi::QtToCppAdaptor<QCamera::TorchMode>(arg1).cref());
}


// void QCamera::setWhiteBalanceMode(QCamera::WhiteBalanceMode mode)


static void _init_f_setWhiteBalanceMode_2798 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QCamera::WhiteBalanceMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWhiteBalanceMode_2798 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCamera::WhiteBalanceMode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QCamera::WhiteBalanceMode>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCamera *)cls)->setWhiteBalanceMode (qt_gsi::QtToCppAdaptor<QCamera::WhiteBalanceMode>(arg1).cref());
}


// void QCamera::setZoomFactor(float factor)


static void _init_f_setZoomFactor_970 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("factor");
  decl->add_arg<float > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setZoomFactor_970 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  float arg1 = gsi::arg_reader<float >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCamera *)cls)->setZoomFactor (arg1);
}


// void QCamera::start()


static void _init_f_start_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_start_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCamera *)cls)->start ();
}


// void QCamera::stop()


static void _init_f_stop_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_stop_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCamera *)cls)->stop ();
}


// QFlags<QCamera::Feature> QCamera::supportedFeatures()


static void _init_f_supportedFeatures_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<QCamera::Feature> > ();
}

static void _call_f_supportedFeatures_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<QCamera::Feature> > ((QFlags<QCamera::Feature>)((QCamera *)cls)->supportedFeatures ());
}


// QCamera::TorchMode QCamera::torchMode()


static void _init_f_torchMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QCamera::TorchMode>::target_type > ();
}

static void _call_f_torchMode_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QCamera::TorchMode>::target_type > ((qt_gsi::Converter<QCamera::TorchMode>::target_type)qt_gsi::CppToQtAdaptor<QCamera::TorchMode>(((QCamera *)cls)->torchMode ()));
}


// QCamera::WhiteBalanceMode QCamera::whiteBalanceMode()


static void _init_f_whiteBalanceMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QCamera::WhiteBalanceMode>::target_type > ();
}

static void _call_f_whiteBalanceMode_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QCamera::WhiteBalanceMode>::target_type > ((qt_gsi::Converter<QCamera::WhiteBalanceMode>::target_type)qt_gsi::CppToQtAdaptor<QCamera::WhiteBalanceMode>(((QCamera *)cls)->whiteBalanceMode ()));
}


// float QCamera::zoomFactor()


static void _init_f_zoomFactor_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<float > ();
}

static void _call_f_zoomFactor_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<float > ((float)((QCamera *)cls)->zoomFactor ());
}


// void QCamera::zoomTo(float zoom, float rate)


static void _init_f_zoomTo_1832 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("zoom");
  decl->add_arg<float > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("rate");
  decl->add_arg<float > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_zoomTo_1832 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  float arg1 = gsi::arg_reader<float >() (args, heap);
  float arg2 = gsi::arg_reader<float >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCamera *)cls)->zoomTo (arg1, arg2);
}


// static QString QCamera::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QCamera::tr (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QCamera () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod (":cameraDevice", "@brief Method QCameraDevice QCamera::cameraDevice()\n", true, &_init_f_cameraDevice_c0, &_call_f_cameraDevice_c0);
  methods += new qt_gsi::GenericMethod (":cameraFormat", "@brief Method QCameraFormat QCamera::cameraFormat()\n", true, &_init_f_cameraFormat_c0, &_call_f_cameraFormat_c0);
  methods += new qt_gsi::GenericMethod ("captureSession", "@brief Method QMediaCaptureSession *QCamera::captureSession()\n", true, &_init_f_captureSession_c0, &_call_f_captureSession_c0);
  methods += new qt_gsi::GenericMethod (":colorTemperature", "@brief Method int QCamera::colorTemperature()\n", true, &_init_f_colorTemperature_c0, &_call_f_colorTemperature_c0);
  methods += new qt_gsi::GenericMethod (":customFocusPoint", "@brief Method QPointF QCamera::customFocusPoint()\n", true, &_init_f_customFocusPoint_c0, &_call_f_customFocusPoint_c0);
  methods += new qt_gsi::GenericMethod (":error", "@brief Method QCamera::Error QCamera::error()\n", true, &_init_f_error_c0, &_call_f_error_c0);
  methods += new qt_gsi::GenericMethod (":errorString", "@brief Method QString QCamera::errorString()\n", true, &_init_f_errorString_c0, &_call_f_errorString_c0);
  methods += new qt_gsi::GenericMethod (":exposureCompensation", "@brief Method float QCamera::exposureCompensation()\n", true, &_init_f_exposureCompensation_c0, &_call_f_exposureCompensation_c0);
  methods += new qt_gsi::GenericMethod (":exposureMode", "@brief Method QCamera::ExposureMode QCamera::exposureMode()\n", true, &_init_f_exposureMode_c0, &_call_f_exposureMode_c0);
  methods += new qt_gsi::GenericMethod (":exposureTime", "@brief Method float QCamera::exposureTime()\n", true, &_init_f_exposureTime_c0, &_call_f_exposureTime_c0);
  methods += new qt_gsi::GenericMethod (":flashMode", "@brief Method QCamera::FlashMode QCamera::flashMode()\n", true, &_init_f_flashMode_c0, &_call_f_flashMode_c0);
  methods += new qt_gsi::GenericMethod (":focusDistance", "@brief Method float QCamera::focusDistance()\n", true, &_init_f_focusDistance_c0, &_call_f_focusDistance_c0);
  methods += new qt_gsi::GenericMethod (":focusMode", "@brief Method QCamera::FocusMode QCamera::focusMode()\n", true, &_init_f_focusMode_c0, &_call_f_focusMode_c0);
  methods += new qt_gsi::GenericMethod (":focusPoint", "@brief Method QPointF QCamera::focusPoint()\n", true, &_init_f_focusPoint_c0, &_call_f_focusPoint_c0);
  methods += new qt_gsi::GenericMethod ("isActive?|:active", "@brief Method bool QCamera::isActive()\n", true, &_init_f_isActive_c0, &_call_f_isActive_c0);
  methods += new qt_gsi::GenericMethod ("isAvailable?", "@brief Method bool QCamera::isAvailable()\n", true, &_init_f_isAvailable_c0, &_call_f_isAvailable_c0);
  methods += new qt_gsi::GenericMethod ("isExposureModeSupported?", "@brief Method bool QCamera::isExposureModeSupported(QCamera::ExposureMode mode)\n", true, &_init_f_isExposureModeSupported_c2466, &_call_f_isExposureModeSupported_c2466);
  methods += new qt_gsi::GenericMethod ("isFlashModeSupported?", "@brief Method bool QCamera::isFlashModeSupported(QCamera::FlashMode mode)\n", true, &_init_f_isFlashModeSupported_c2101, &_call_f_isFlashModeSupported_c2101);
  methods += new qt_gsi::GenericMethod ("isFlashReady?", "@brief Method bool QCamera::isFlashReady()\n", true, &_init_f_isFlashReady_c0, &_call_f_isFlashReady_c0);
  methods += new qt_gsi::GenericMethod ("isFocusModeSupported?", "@brief Method bool QCamera::isFocusModeSupported(QCamera::FocusMode mode)\n", true, &_init_f_isFocusModeSupported_c2119, &_call_f_isFocusModeSupported_c2119);
  methods += new qt_gsi::GenericMethod ("isTorchModeSupported?", "@brief Method bool QCamera::isTorchModeSupported(QCamera::TorchMode mode)\n", true, &_init_f_isTorchModeSupported_c2119, &_call_f_isTorchModeSupported_c2119);
  methods += new qt_gsi::GenericMethod ("isWhiteBalanceModeSupported?", "@brief Method bool QCamera::isWhiteBalanceModeSupported(QCamera::WhiteBalanceMode mode)\n", true, &_init_f_isWhiteBalanceModeSupported_c2798, &_call_f_isWhiteBalanceModeSupported_c2798);
  methods += new qt_gsi::GenericMethod (":isoSensitivity", "@brief Method int QCamera::isoSensitivity()\n", true, &_init_f_isoSensitivity_c0, &_call_f_isoSensitivity_c0);
  methods += new qt_gsi::GenericMethod (":manualExposureTime", "@brief Method float QCamera::manualExposureTime()\n", true, &_init_f_manualExposureTime_c0, &_call_f_manualExposureTime_c0);
  methods += new qt_gsi::GenericMethod (":manualIsoSensitivity", "@brief Method int QCamera::manualIsoSensitivity()\n", true, &_init_f_manualIsoSensitivity_c0, &_call_f_manualIsoSensitivity_c0);
  methods += new qt_gsi::GenericMethod ("maximumExposureTime", "@brief Method float QCamera::maximumExposureTime()\n", true, &_init_f_maximumExposureTime_c0, &_call_f_maximumExposureTime_c0);
  methods += new qt_gsi::GenericMethod ("maximumIsoSensitivity", "@brief Method int QCamera::maximumIsoSensitivity()\n", true, &_init_f_maximumIsoSensitivity_c0, &_call_f_maximumIsoSensitivity_c0);
  methods += new qt_gsi::GenericMethod (":maximumZoomFactor", "@brief Method float QCamera::maximumZoomFactor()\n", true, &_init_f_maximumZoomFactor_c0, &_call_f_maximumZoomFactor_c0);
  methods += new qt_gsi::GenericMethod ("minimumExposureTime", "@brief Method float QCamera::minimumExposureTime()\n", true, &_init_f_minimumExposureTime_c0, &_call_f_minimumExposureTime_c0);
  methods += new qt_gsi::GenericMethod ("minimumIsoSensitivity", "@brief Method int QCamera::minimumIsoSensitivity()\n", true, &_init_f_minimumIsoSensitivity_c0, &_call_f_minimumIsoSensitivity_c0);
  methods += new qt_gsi::GenericMethod (":minimumZoomFactor", "@brief Method float QCamera::minimumZoomFactor()\n", true, &_init_f_minimumZoomFactor_c0, &_call_f_minimumZoomFactor_c0);
  methods += new qt_gsi::GenericMethod ("setActive|active=", "@brief Method void QCamera::setActive(bool active)\n", false, &_init_f_setActive_864, &_call_f_setActive_864);
  methods += new qt_gsi::GenericMethod ("setAutoExposureTime", "@brief Method void QCamera::setAutoExposureTime()\n", false, &_init_f_setAutoExposureTime_0, &_call_f_setAutoExposureTime_0);
  methods += new qt_gsi::GenericMethod ("setAutoIsoSensitivity", "@brief Method void QCamera::setAutoIsoSensitivity()\n", false, &_init_f_setAutoIsoSensitivity_0, &_call_f_setAutoIsoSensitivity_0);
  methods += new qt_gsi::GenericMethod ("setCameraDevice|cameraDevice=", "@brief Method void QCamera::setCameraDevice(const QCameraDevice &cameraDevice)\n", false, &_init_f_setCameraDevice_2571, &_call_f_setCameraDevice_2571);
  methods += new qt_gsi::GenericMethod ("setCameraFormat|cameraFormat=", "@brief Method void QCamera::setCameraFormat(const QCameraFormat &format)\n", false, &_init_f_setCameraFormat_2596, &_call_f_setCameraFormat_2596);
  methods += new qt_gsi::GenericMethod ("setColorTemperature|colorTemperature=", "@brief Method void QCamera::setColorTemperature(int colorTemperature)\n", false, &_init_f_setColorTemperature_767, &_call_f_setColorTemperature_767);
  methods += new qt_gsi::GenericMethod ("setCustomFocusPoint|customFocusPoint=", "@brief Method void QCamera::setCustomFocusPoint(const QPointF &point)\n", false, &_init_f_setCustomFocusPoint_1986, &_call_f_setCustomFocusPoint_1986);
  methods += new qt_gsi::GenericMethod ("setExposureCompensation|exposureCompensation=", "@brief Method void QCamera::setExposureCompensation(float ev)\n", false, &_init_f_setExposureCompensation_970, &_call_f_setExposureCompensation_970);
  methods += new qt_gsi::GenericMethod ("setExposureMode|exposureMode=", "@brief Method void QCamera::setExposureMode(QCamera::ExposureMode mode)\n", false, &_init_f_setExposureMode_2466, &_call_f_setExposureMode_2466);
  methods += new qt_gsi::GenericMethod ("setFlashMode|flashMode=", "@brief Method void QCamera::setFlashMode(QCamera::FlashMode mode)\n", false, &_init_f_setFlashMode_2101, &_call_f_setFlashMode_2101);
  methods += new qt_gsi::GenericMethod ("setFocusDistance|focusDistance=", "@brief Method void QCamera::setFocusDistance(float d)\n", false, &_init_f_setFocusDistance_970, &_call_f_setFocusDistance_970);
  methods += new qt_gsi::GenericMethod ("setFocusMode|focusMode=", "@brief Method void QCamera::setFocusMode(QCamera::FocusMode mode)\n", false, &_init_f_setFocusMode_2119, &_call_f_setFocusMode_2119);
  methods += new qt_gsi::GenericMethod ("setManualExposureTime|manualExposureTime=", "@brief Method void QCamera::setManualExposureTime(float seconds)\n", false, &_init_f_setManualExposureTime_970, &_call_f_setManualExposureTime_970);
  methods += new qt_gsi::GenericMethod ("setManualIsoSensitivity|manualIsoSensitivity=", "@brief Method void QCamera::setManualIsoSensitivity(int iso)\n", false, &_init_f_setManualIsoSensitivity_767, &_call_f_setManualIsoSensitivity_767);
  methods += new qt_gsi::GenericMethod ("setTorchMode|torchMode=", "@brief Method void QCamera::setTorchMode(QCamera::TorchMode mode)\n", false, &_init_f_setTorchMode_2119, &_call_f_setTorchMode_2119);
  methods += new qt_gsi::GenericMethod ("setWhiteBalanceMode|whiteBalanceMode=", "@brief Method void QCamera::setWhiteBalanceMode(QCamera::WhiteBalanceMode mode)\n", false, &_init_f_setWhiteBalanceMode_2798, &_call_f_setWhiteBalanceMode_2798);
  methods += new qt_gsi::GenericMethod ("setZoomFactor|zoomFactor=", "@brief Method void QCamera::setZoomFactor(float factor)\n", false, &_init_f_setZoomFactor_970, &_call_f_setZoomFactor_970);
  methods += new qt_gsi::GenericMethod ("start", "@brief Method void QCamera::start()\n", false, &_init_f_start_0, &_call_f_start_0);
  methods += new qt_gsi::GenericMethod ("stop", "@brief Method void QCamera::stop()\n", false, &_init_f_stop_0, &_call_f_stop_0);
  methods += new qt_gsi::GenericMethod (":supportedFeatures", "@brief Method QFlags<QCamera::Feature> QCamera::supportedFeatures()\n", true, &_init_f_supportedFeatures_c0, &_call_f_supportedFeatures_c0);
  methods += new qt_gsi::GenericMethod (":torchMode", "@brief Method QCamera::TorchMode QCamera::torchMode()\n", true, &_init_f_torchMode_c0, &_call_f_torchMode_c0);
  methods += new qt_gsi::GenericMethod (":whiteBalanceMode", "@brief Method QCamera::WhiteBalanceMode QCamera::whiteBalanceMode()\n", true, &_init_f_whiteBalanceMode_c0, &_call_f_whiteBalanceMode_c0);
  methods += new qt_gsi::GenericMethod (":zoomFactor", "@brief Method float QCamera::zoomFactor()\n", true, &_init_f_zoomFactor_c0, &_call_f_zoomFactor_c0);
  methods += new qt_gsi::GenericMethod ("zoomTo", "@brief Method void QCamera::zoomTo(float zoom, float rate)\n", false, &_init_f_zoomTo_1832, &_call_f_zoomTo_1832);
  methods += gsi::qt_signal<bool > ("activeChanged(bool)", "activeChanged", gsi::arg("arg1"), "@brief Signal declaration for QCamera::activeChanged(bool)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("brightnessChanged()", "brightnessChanged", "@brief Signal declaration for QCamera::brightnessChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("cameraDeviceChanged()", "cameraDeviceChanged", "@brief Signal declaration for QCamera::cameraDeviceChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("cameraFormatChanged()", "cameraFormatChanged", "@brief Signal declaration for QCamera::cameraFormatChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("colorTemperatureChanged()", "colorTemperatureChanged", "@brief Signal declaration for QCamera::colorTemperatureChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("contrastChanged()", "contrastChanged", "@brief Signal declaration for QCamera::contrastChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("customFocusPointChanged()", "customFocusPointChanged", "@brief Signal declaration for QCamera::customFocusPointChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QCamera::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("errorChanged()", "errorChanged", "@brief Signal declaration for QCamera::errorChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<QCamera::Error>::target_type &, const QString & > ("errorOccurred(QCamera::Error, const QString &)", "errorOccurred", gsi::arg("error"), gsi::arg("errorString"), "@brief Signal declaration for QCamera::errorOccurred(QCamera::Error error, const QString &errorString)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<float > ("exposureCompensationChanged(float)", "exposureCompensationChanged", gsi::arg("arg1"), "@brief Signal declaration for QCamera::exposureCompensationChanged(float)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("exposureModeChanged()", "exposureModeChanged", "@brief Signal declaration for QCamera::exposureModeChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<float > ("exposureTimeChanged(float)", "exposureTimeChanged", gsi::arg("speed"), "@brief Signal declaration for QCamera::exposureTimeChanged(float speed)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("flashModeChanged()", "flashModeChanged", "@brief Signal declaration for QCamera::flashModeChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<bool > ("flashReady(bool)", "flashReady", gsi::arg("arg1"), "@brief Signal declaration for QCamera::flashReady(bool)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<float > ("focusDistanceChanged(float)", "focusDistanceChanged", gsi::arg("arg1"), "@brief Signal declaration for QCamera::focusDistanceChanged(float)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("focusModeChanged()", "focusModeChanged", "@brief Signal declaration for QCamera::focusModeChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("focusPointChanged()", "focusPointChanged", "@brief Signal declaration for QCamera::focusPointChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("hueChanged()", "hueChanged", "@brief Signal declaration for QCamera::hueChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("isoSensitivityChanged(int)", "isoSensitivityChanged", gsi::arg("arg1"), "@brief Signal declaration for QCamera::isoSensitivityChanged(int)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<float > ("manualExposureTimeChanged(float)", "manualExposureTimeChanged", gsi::arg("speed"), "@brief Signal declaration for QCamera::manualExposureTimeChanged(float speed)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("manualIsoSensitivityChanged(int)", "manualIsoSensitivityChanged", gsi::arg("arg1"), "@brief Signal declaration for QCamera::manualIsoSensitivityChanged(int)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<float > ("maximumZoomFactorChanged(float)", "maximumZoomFactorChanged", gsi::arg("arg1"), "@brief Signal declaration for QCamera::maximumZoomFactorChanged(float)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<float > ("minimumZoomFactorChanged(float)", "minimumZoomFactorChanged", gsi::arg("arg1"), "@brief Signal declaration for QCamera::minimumZoomFactorChanged(float)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QCamera::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("saturationChanged()", "saturationChanged", "@brief Signal declaration for QCamera::saturationChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("supportedFeaturesChanged()", "supportedFeaturesChanged", "@brief Signal declaration for QCamera::supportedFeaturesChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("torchModeChanged()", "torchModeChanged", "@brief Signal declaration for QCamera::torchModeChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("whiteBalanceModeChanged()", "whiteBalanceModeChanged", "@brief Signal declaration for QCamera::whiteBalanceModeChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<float > ("zoomFactorChanged(float)", "zoomFactorChanged", gsi::arg("arg1"), "@brief Signal declaration for QCamera::zoomFactorChanged(float)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QCamera::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  return methods;
}

gsi::Class<QObject> &qtdecl_QObject ();

qt_gsi::QtNativeClass<QCamera> decl_QCamera (qtdecl_QObject (), "QtMultimedia", "QCamera_Native",
  methods_QCamera (),
  "@hide\n@alias QCamera");

GSI_QTMULTIMEDIA_PUBLIC gsi::Class<QCamera> &qtdecl_QCamera () { return decl_QCamera; }

}


class QCamera_Adaptor : public QCamera, public qt_gsi::QtObjectBase
{
public:

  virtual ~QCamera_Adaptor();

  //  [adaptor ctor] QCamera::QCamera(QObject *parent)
  QCamera_Adaptor() : QCamera()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QCamera::QCamera(QObject *parent)
  QCamera_Adaptor(QObject *parent) : QCamera(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QCamera::QCamera(const QCameraDevice &cameraDevice, QObject *parent)
  QCamera_Adaptor(const QCameraDevice &cameraDevice) : QCamera(cameraDevice)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QCamera::QCamera(const QCameraDevice &cameraDevice, QObject *parent)
  QCamera_Adaptor(const QCameraDevice &cameraDevice, QObject *parent) : QCamera(cameraDevice, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QCamera::QCamera(QCameraDevice::Position position, QObject *parent)
  QCamera_Adaptor(QCameraDevice::Position position) : QCamera(position)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QCamera::QCamera(QCameraDevice::Position position, QObject *parent)
  QCamera_Adaptor(QCameraDevice::Position position, QObject *parent) : QCamera(position, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] bool QCamera::isSignalConnected(const QMetaMethod &signal)
  bool fp_QCamera_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QCamera::isSignalConnected(signal);
  }

  //  [expose] int QCamera::receivers(const char *signal)
  int fp_QCamera_receivers_c1731 (const char *signal) const {
    return QCamera::receivers(signal);
  }

  //  [expose] QObject *QCamera::sender()
  QObject * fp_QCamera_sender_c0 () const {
    return QCamera::sender();
  }

  //  [expose] int QCamera::senderSignalIndex()
  int fp_QCamera_senderSignalIndex_c0 () const {
    return QCamera::senderSignalIndex();
  }

  //  [emitter impl] void QCamera::activeChanged(bool)
  void emitter_QCamera_activeChanged_864(bool arg1)
  {
    emit QCamera::activeChanged(arg1);
  }

  //  [emitter impl] void QCamera::brightnessChanged()
  void emitter_QCamera_brightnessChanged_0()
  {
    emit QCamera::brightnessChanged();
  }

  //  [emitter impl] void QCamera::cameraDeviceChanged()
  void emitter_QCamera_cameraDeviceChanged_0()
  {
    emit QCamera::cameraDeviceChanged();
  }

  //  [emitter impl] void QCamera::cameraFormatChanged()
  void emitter_QCamera_cameraFormatChanged_0()
  {
    emit QCamera::cameraFormatChanged();
  }

  //  [emitter impl] void QCamera::colorTemperatureChanged()
  void emitter_QCamera_colorTemperatureChanged_c0()
  {
    emit QCamera::colorTemperatureChanged();
  }

  //  [emitter impl] void QCamera::contrastChanged()
  void emitter_QCamera_contrastChanged_0()
  {
    emit QCamera::contrastChanged();
  }

  //  [emitter impl] void QCamera::customFocusPointChanged()
  void emitter_QCamera_customFocusPointChanged_0()
  {
    emit QCamera::customFocusPointChanged();
  }

  //  [emitter impl] void QCamera::destroyed(QObject *)
  void emitter_QCamera_destroyed_1302(QObject *arg1)
  {
    emit QCamera::destroyed(arg1);
  }

  //  [emitter impl] void QCamera::errorChanged()
  void emitter_QCamera_errorChanged_0()
  {
    emit QCamera::errorChanged();
  }

  //  [emitter impl] void QCamera::errorOccurred(QCamera::Error error, const QString &errorString)
  void emitter_QCamera_errorOccurred_3657(QCamera::Error error, const QString &errorString)
  {
    emit QCamera::errorOccurred(error, errorString);
  }

  //  [adaptor impl] bool QCamera::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QCamera::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QCamera_Adaptor, bool, QEvent *>(&QCamera_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QCamera::event(_event);
    }
  }

  //  [adaptor impl] bool QCamera::eventFilter(QObject *watched, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *watched, QEvent *event)
  {
    return QCamera::eventFilter(watched, event);
  }

  virtual bool eventFilter(QObject *watched, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QCamera_Adaptor, bool, QObject *, QEvent *>(&QCamera_Adaptor::cbs_eventFilter_2411_0, watched, event);
    } else {
      return QCamera::eventFilter(watched, event);
    }
  }

  //  [emitter impl] void QCamera::exposureCompensationChanged(float)
  void emitter_QCamera_exposureCompensationChanged_970(float arg1)
  {
    emit QCamera::exposureCompensationChanged(arg1);
  }

  //  [emitter impl] void QCamera::exposureModeChanged()
  void emitter_QCamera_exposureModeChanged_0()
  {
    emit QCamera::exposureModeChanged();
  }

  //  [emitter impl] void QCamera::exposureTimeChanged(float speed)
  void emitter_QCamera_exposureTimeChanged_970(float speed)
  {
    emit QCamera::exposureTimeChanged(speed);
  }

  //  [emitter impl] void QCamera::flashModeChanged()
  void emitter_QCamera_flashModeChanged_0()
  {
    emit QCamera::flashModeChanged();
  }

  //  [emitter impl] void QCamera::flashReady(bool)
  void emitter_QCamera_flashReady_864(bool arg1)
  {
    emit QCamera::flashReady(arg1);
  }

  //  [emitter impl] void QCamera::focusDistanceChanged(float)
  void emitter_QCamera_focusDistanceChanged_970(float arg1)
  {
    emit QCamera::focusDistanceChanged(arg1);
  }

  //  [emitter impl] void QCamera::focusModeChanged()
  void emitter_QCamera_focusModeChanged_0()
  {
    emit QCamera::focusModeChanged();
  }

  //  [emitter impl] void QCamera::focusPointChanged()
  void emitter_QCamera_focusPointChanged_0()
  {
    emit QCamera::focusPointChanged();
  }

  //  [emitter impl] void QCamera::hueChanged()
  void emitter_QCamera_hueChanged_0()
  {
    emit QCamera::hueChanged();
  }

  //  [emitter impl] void QCamera::isoSensitivityChanged(int)
  void emitter_QCamera_isoSensitivityChanged_767(int arg1)
  {
    emit QCamera::isoSensitivityChanged(arg1);
  }

  //  [emitter impl] void QCamera::manualExposureTimeChanged(float speed)
  void emitter_QCamera_manualExposureTimeChanged_970(float speed)
  {
    emit QCamera::manualExposureTimeChanged(speed);
  }

  //  [emitter impl] void QCamera::manualIsoSensitivityChanged(int)
  void emitter_QCamera_manualIsoSensitivityChanged_767(int arg1)
  {
    emit QCamera::manualIsoSensitivityChanged(arg1);
  }

  //  [emitter impl] void QCamera::maximumZoomFactorChanged(float)
  void emitter_QCamera_maximumZoomFactorChanged_970(float arg1)
  {
    emit QCamera::maximumZoomFactorChanged(arg1);
  }

  //  [emitter impl] void QCamera::minimumZoomFactorChanged(float)
  void emitter_QCamera_minimumZoomFactorChanged_970(float arg1)
  {
    emit QCamera::minimumZoomFactorChanged(arg1);
  }

  //  [emitter impl] void QCamera::objectNameChanged(const QString &objectName)
  void emitter_QCamera_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QCamera::objectNameChanged(const QString &objectName)'");
  }

  //  [emitter impl] void QCamera::saturationChanged()
  void emitter_QCamera_saturationChanged_0()
  {
    emit QCamera::saturationChanged();
  }

  //  [emitter impl] void QCamera::supportedFeaturesChanged()
  void emitter_QCamera_supportedFeaturesChanged_0()
  {
    emit QCamera::supportedFeaturesChanged();
  }

  //  [emitter impl] void QCamera::torchModeChanged()
  void emitter_QCamera_torchModeChanged_0()
  {
    emit QCamera::torchModeChanged();
  }

  //  [emitter impl] void QCamera::whiteBalanceModeChanged()
  void emitter_QCamera_whiteBalanceModeChanged_c0()
  {
    emit QCamera::whiteBalanceModeChanged();
  }

  //  [emitter impl] void QCamera::zoomFactorChanged(float)
  void emitter_QCamera_zoomFactorChanged_970(float arg1)
  {
    emit QCamera::zoomFactorChanged(arg1);
  }

  //  [adaptor impl] void QCamera::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QCamera::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QCamera_Adaptor, QChildEvent *>(&QCamera_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QCamera::childEvent(event);
    }
  }

  //  [adaptor impl] void QCamera::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QCamera::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QCamera_Adaptor, QEvent *>(&QCamera_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QCamera::customEvent(event);
    }
  }

  //  [adaptor impl] void QCamera::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QCamera::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QCamera_Adaptor, const QMetaMethod &>(&QCamera_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QCamera::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QCamera::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QCamera::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QCamera_Adaptor, QTimerEvent *>(&QCamera_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QCamera::timerEvent(event);
    }
  }

  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QCamera_Adaptor::~QCamera_Adaptor() { }

//  Constructor QCamera::QCamera(QObject *parent) (adaptor class)

static void _init_ctor_QCamera_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QCamera_Adaptor> ();
}

static void _call_ctor_QCamera_Adaptor_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ret.write<QCamera_Adaptor *> (new QCamera_Adaptor (arg1));
}


//  Constructor QCamera::QCamera(const QCameraDevice &cameraDevice, QObject *parent) (adaptor class)

static void _init_ctor_QCamera_Adaptor_3765 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cameraDevice");
  decl->add_arg<const QCameraDevice & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent", true, "nullptr");
  decl->add_arg<QObject * > (argspec_1);
  decl->set_return_new<QCamera_Adaptor> ();
}

static void _call_ctor_QCamera_Adaptor_3765 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QCameraDevice &arg1 = gsi::arg_reader<const QCameraDevice & >() (args, heap);
  QObject *arg2 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ret.write<QCamera_Adaptor *> (new QCamera_Adaptor (arg1, arg2));
}


//  Constructor QCamera::QCamera(QCameraDevice::Position position, QObject *parent) (adaptor class)

static void _init_ctor_QCamera_Adaptor_3857 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("position");
  decl->add_arg<const qt_gsi::Converter<QCameraDevice::Position>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent", true, "nullptr");
  decl->add_arg<QObject * > (argspec_1);
  decl->set_return_new<QCamera_Adaptor> ();
}

static void _call_ctor_QCamera_Adaptor_3857 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCameraDevice::Position>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QCameraDevice::Position>::target_type & >() (args, heap);
  QObject *arg2 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ret.write<QCamera_Adaptor *> (new QCamera_Adaptor (qt_gsi::QtToCppAdaptor<QCameraDevice::Position>(arg1).cref(), arg2));
}


// emitter void QCamera::activeChanged(bool)

static void _init_emitter_activeChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_activeChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  ((QCamera_Adaptor *)cls)->emitter_QCamera_activeChanged_864 (arg1);
}


// emitter void QCamera::brightnessChanged()

static void _init_emitter_brightnessChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_brightnessChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QCamera_Adaptor *)cls)->emitter_QCamera_brightnessChanged_0 ();
}


// emitter void QCamera::cameraDeviceChanged()

static void _init_emitter_cameraDeviceChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_cameraDeviceChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QCamera_Adaptor *)cls)->emitter_QCamera_cameraDeviceChanged_0 ();
}


// emitter void QCamera::cameraFormatChanged()

static void _init_emitter_cameraFormatChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_cameraFormatChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QCamera_Adaptor *)cls)->emitter_QCamera_cameraFormatChanged_0 ();
}


// void QCamera::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCamera_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QCamera_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// emitter void QCamera::colorTemperatureChanged()

static void _init_emitter_colorTemperatureChanged_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_colorTemperatureChanged_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QCamera_Adaptor *)cls)->emitter_QCamera_colorTemperatureChanged_c0 ();
}


// emitter void QCamera::contrastChanged()

static void _init_emitter_contrastChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_contrastChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QCamera_Adaptor *)cls)->emitter_QCamera_contrastChanged_0 ();
}


// void QCamera::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCamera_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QCamera_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QCamera::customFocusPointChanged()

static void _init_emitter_customFocusPointChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_customFocusPointChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QCamera_Adaptor *)cls)->emitter_QCamera_customFocusPointChanged_0 ();
}


// emitter void QCamera::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QCamera_Adaptor *)cls)->emitter_QCamera_destroyed_1302 (arg1);
}


// void QCamera::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCamera_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QCamera_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// emitter void QCamera::errorChanged()

static void _init_emitter_errorChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_errorChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QCamera_Adaptor *)cls)->emitter_QCamera_errorChanged_0 ();
}


// emitter void QCamera::errorOccurred(QCamera::Error error, const QString &errorString)

static void _init_emitter_errorOccurred_3657 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("error");
  decl->add_arg<const qt_gsi::Converter<QCamera::Error>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("errorString");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_emitter_errorOccurred_3657 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCamera::Error>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QCamera::Error>::target_type & >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  ((QCamera_Adaptor *)cls)->emitter_QCamera_errorOccurred_3657 (arg1, arg2);
}


// bool QCamera::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QCamera_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QCamera_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QCamera::eventFilter(QObject *watched, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QCamera_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QCamera_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// emitter void QCamera::exposureCompensationChanged(float)

static void _init_emitter_exposureCompensationChanged_970 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<float > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_exposureCompensationChanged_970 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  float arg1 = gsi::arg_reader<float >() (args, heap);
  ((QCamera_Adaptor *)cls)->emitter_QCamera_exposureCompensationChanged_970 (arg1);
}


// emitter void QCamera::exposureModeChanged()

static void _init_emitter_exposureModeChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_exposureModeChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QCamera_Adaptor *)cls)->emitter_QCamera_exposureModeChanged_0 ();
}


// emitter void QCamera::exposureTimeChanged(float speed)

static void _init_emitter_exposureTimeChanged_970 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("speed");
  decl->add_arg<float > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_exposureTimeChanged_970 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  float arg1 = gsi::arg_reader<float >() (args, heap);
  ((QCamera_Adaptor *)cls)->emitter_QCamera_exposureTimeChanged_970 (arg1);
}


// emitter void QCamera::flashModeChanged()

static void _init_emitter_flashModeChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_flashModeChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QCamera_Adaptor *)cls)->emitter_QCamera_flashModeChanged_0 ();
}


// emitter void QCamera::flashReady(bool)

static void _init_emitter_flashReady_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_flashReady_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  ((QCamera_Adaptor *)cls)->emitter_QCamera_flashReady_864 (arg1);
}


// emitter void QCamera::focusDistanceChanged(float)

static void _init_emitter_focusDistanceChanged_970 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<float > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_focusDistanceChanged_970 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  float arg1 = gsi::arg_reader<float >() (args, heap);
  ((QCamera_Adaptor *)cls)->emitter_QCamera_focusDistanceChanged_970 (arg1);
}


// emitter void QCamera::focusModeChanged()

static void _init_emitter_focusModeChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_focusModeChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QCamera_Adaptor *)cls)->emitter_QCamera_focusModeChanged_0 ();
}


// emitter void QCamera::focusPointChanged()

static void _init_emitter_focusPointChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_focusPointChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QCamera_Adaptor *)cls)->emitter_QCamera_focusPointChanged_0 ();
}


// emitter void QCamera::hueChanged()

static void _init_emitter_hueChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_hueChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QCamera_Adaptor *)cls)->emitter_QCamera_hueChanged_0 ();
}


// exposed bool QCamera::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QCamera_Adaptor *)cls)->fp_QCamera_isSignalConnected_c2394 (arg1));
}


// emitter void QCamera::isoSensitivityChanged(int)

static void _init_emitter_isoSensitivityChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_isoSensitivityChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QCamera_Adaptor *)cls)->emitter_QCamera_isoSensitivityChanged_767 (arg1);
}


// emitter void QCamera::manualExposureTimeChanged(float speed)

static void _init_emitter_manualExposureTimeChanged_970 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("speed");
  decl->add_arg<float > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_manualExposureTimeChanged_970 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  float arg1 = gsi::arg_reader<float >() (args, heap);
  ((QCamera_Adaptor *)cls)->emitter_QCamera_manualExposureTimeChanged_970 (arg1);
}


// emitter void QCamera::manualIsoSensitivityChanged(int)

static void _init_emitter_manualIsoSensitivityChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_manualIsoSensitivityChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QCamera_Adaptor *)cls)->emitter_QCamera_manualIsoSensitivityChanged_767 (arg1);
}


// emitter void QCamera::maximumZoomFactorChanged(float)

static void _init_emitter_maximumZoomFactorChanged_970 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<float > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_maximumZoomFactorChanged_970 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  float arg1 = gsi::arg_reader<float >() (args, heap);
  ((QCamera_Adaptor *)cls)->emitter_QCamera_maximumZoomFactorChanged_970 (arg1);
}


// emitter void QCamera::minimumZoomFactorChanged(float)

static void _init_emitter_minimumZoomFactorChanged_970 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<float > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_minimumZoomFactorChanged_970 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  float arg1 = gsi::arg_reader<float >() (args, heap);
  ((QCamera_Adaptor *)cls)->emitter_QCamera_minimumZoomFactorChanged_970 (arg1);
}


// emitter void QCamera::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QCamera_Adaptor *)cls)->emitter_QCamera_objectNameChanged_4567 (arg1);
}


// exposed int QCamera::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QCamera_Adaptor *)cls)->fp_QCamera_receivers_c1731 (arg1));
}


// emitter void QCamera::saturationChanged()

static void _init_emitter_saturationChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_saturationChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QCamera_Adaptor *)cls)->emitter_QCamera_saturationChanged_0 ();
}


// exposed QObject *QCamera::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QCamera_Adaptor *)cls)->fp_QCamera_sender_c0 ());
}


// exposed int QCamera::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QCamera_Adaptor *)cls)->fp_QCamera_senderSignalIndex_c0 ());
}


// emitter void QCamera::supportedFeaturesChanged()

static void _init_emitter_supportedFeaturesChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_supportedFeaturesChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QCamera_Adaptor *)cls)->emitter_QCamera_supportedFeaturesChanged_0 ();
}


// void QCamera::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCamera_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QCamera_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// emitter void QCamera::torchModeChanged()

static void _init_emitter_torchModeChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_torchModeChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QCamera_Adaptor *)cls)->emitter_QCamera_torchModeChanged_0 ();
}


// emitter void QCamera::whiteBalanceModeChanged()

static void _init_emitter_whiteBalanceModeChanged_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_whiteBalanceModeChanged_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QCamera_Adaptor *)cls)->emitter_QCamera_whiteBalanceModeChanged_c0 ();
}


// emitter void QCamera::zoomFactorChanged(float)

static void _init_emitter_zoomFactorChanged_970 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<float > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_zoomFactorChanged_970 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  float arg1 = gsi::arg_reader<float >() (args, heap);
  ((QCamera_Adaptor *)cls)->emitter_QCamera_zoomFactorChanged_970 (arg1);
}


namespace gsi
{

gsi::Class<QCamera> &qtdecl_QCamera ();

static gsi::Methods methods_QCamera_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QCamera::QCamera(QObject *parent)\nThis method creates an object of class QCamera.", &_init_ctor_QCamera_Adaptor_1302, &_call_ctor_QCamera_Adaptor_1302);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QCamera::QCamera(const QCameraDevice &cameraDevice, QObject *parent)\nThis method creates an object of class QCamera.", &_init_ctor_QCamera_Adaptor_3765, &_call_ctor_QCamera_Adaptor_3765);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QCamera::QCamera(QCameraDevice::Position position, QObject *parent)\nThis method creates an object of class QCamera.", &_init_ctor_QCamera_Adaptor_3857, &_call_ctor_QCamera_Adaptor_3857);
  methods += new qt_gsi::GenericMethod ("emit_activeChanged", "@brief Emitter for signal void QCamera::activeChanged(bool)\nCall this method to emit this signal.", false, &_init_emitter_activeChanged_864, &_call_emitter_activeChanged_864);
  methods += new qt_gsi::GenericMethod ("emit_brightnessChanged", "@brief Emitter for signal void QCamera::brightnessChanged()\nCall this method to emit this signal.", false, &_init_emitter_brightnessChanged_0, &_call_emitter_brightnessChanged_0);
  methods += new qt_gsi::GenericMethod ("emit_cameraDeviceChanged", "@brief Emitter for signal void QCamera::cameraDeviceChanged()\nCall this method to emit this signal.", false, &_init_emitter_cameraDeviceChanged_0, &_call_emitter_cameraDeviceChanged_0);
  methods += new qt_gsi::GenericMethod ("emit_cameraFormatChanged", "@brief Emitter for signal void QCamera::cameraFormatChanged()\nCall this method to emit this signal.", false, &_init_emitter_cameraFormatChanged_0, &_call_emitter_cameraFormatChanged_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QCamera::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("emit_colorTemperatureChanged", "@brief Emitter for signal void QCamera::colorTemperatureChanged()\nCall this method to emit this signal.", true, &_init_emitter_colorTemperatureChanged_c0, &_call_emitter_colorTemperatureChanged_c0);
  methods += new qt_gsi::GenericMethod ("emit_contrastChanged", "@brief Emitter for signal void QCamera::contrastChanged()\nCall this method to emit this signal.", false, &_init_emitter_contrastChanged_0, &_call_emitter_contrastChanged_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QCamera::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_customFocusPointChanged", "@brief Emitter for signal void QCamera::customFocusPointChanged()\nCall this method to emit this signal.", false, &_init_emitter_customFocusPointChanged_0, &_call_emitter_customFocusPointChanged_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QCamera::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QCamera::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("emit_errorChanged", "@brief Emitter for signal void QCamera::errorChanged()\nCall this method to emit this signal.", false, &_init_emitter_errorChanged_0, &_call_emitter_errorChanged_0);
  methods += new qt_gsi::GenericMethod ("emit_errorOccurred", "@brief Emitter for signal void QCamera::errorOccurred(QCamera::Error error, const QString &errorString)\nCall this method to emit this signal.", false, &_init_emitter_errorOccurred_3657, &_call_emitter_errorOccurred_3657);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QCamera::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QCamera::eventFilter(QObject *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("emit_exposureCompensationChanged", "@brief Emitter for signal void QCamera::exposureCompensationChanged(float)\nCall this method to emit this signal.", false, &_init_emitter_exposureCompensationChanged_970, &_call_emitter_exposureCompensationChanged_970);
  methods += new qt_gsi::GenericMethod ("emit_exposureModeChanged", "@brief Emitter for signal void QCamera::exposureModeChanged()\nCall this method to emit this signal.", false, &_init_emitter_exposureModeChanged_0, &_call_emitter_exposureModeChanged_0);
  methods += new qt_gsi::GenericMethod ("emit_exposureTimeChanged", "@brief Emitter for signal void QCamera::exposureTimeChanged(float speed)\nCall this method to emit this signal.", false, &_init_emitter_exposureTimeChanged_970, &_call_emitter_exposureTimeChanged_970);
  methods += new qt_gsi::GenericMethod ("emit_flashModeChanged", "@brief Emitter for signal void QCamera::flashModeChanged()\nCall this method to emit this signal.", false, &_init_emitter_flashModeChanged_0, &_call_emitter_flashModeChanged_0);
  methods += new qt_gsi::GenericMethod ("emit_flashReady", "@brief Emitter for signal void QCamera::flashReady(bool)\nCall this method to emit this signal.", false, &_init_emitter_flashReady_864, &_call_emitter_flashReady_864);
  methods += new qt_gsi::GenericMethod ("emit_focusDistanceChanged", "@brief Emitter for signal void QCamera::focusDistanceChanged(float)\nCall this method to emit this signal.", false, &_init_emitter_focusDistanceChanged_970, &_call_emitter_focusDistanceChanged_970);
  methods += new qt_gsi::GenericMethod ("emit_focusModeChanged", "@brief Emitter for signal void QCamera::focusModeChanged()\nCall this method to emit this signal.", false, &_init_emitter_focusModeChanged_0, &_call_emitter_focusModeChanged_0);
  methods += new qt_gsi::GenericMethod ("emit_focusPointChanged", "@brief Emitter for signal void QCamera::focusPointChanged()\nCall this method to emit this signal.", false, &_init_emitter_focusPointChanged_0, &_call_emitter_focusPointChanged_0);
  methods += new qt_gsi::GenericMethod ("emit_hueChanged", "@brief Emitter for signal void QCamera::hueChanged()\nCall this method to emit this signal.", false, &_init_emitter_hueChanged_0, &_call_emitter_hueChanged_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QCamera::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("emit_isoSensitivityChanged", "@brief Emitter for signal void QCamera::isoSensitivityChanged(int)\nCall this method to emit this signal.", false, &_init_emitter_isoSensitivityChanged_767, &_call_emitter_isoSensitivityChanged_767);
  methods += new qt_gsi::GenericMethod ("emit_manualExposureTimeChanged", "@brief Emitter for signal void QCamera::manualExposureTimeChanged(float speed)\nCall this method to emit this signal.", false, &_init_emitter_manualExposureTimeChanged_970, &_call_emitter_manualExposureTimeChanged_970);
  methods += new qt_gsi::GenericMethod ("emit_manualIsoSensitivityChanged", "@brief Emitter for signal void QCamera::manualIsoSensitivityChanged(int)\nCall this method to emit this signal.", false, &_init_emitter_manualIsoSensitivityChanged_767, &_call_emitter_manualIsoSensitivityChanged_767);
  methods += new qt_gsi::GenericMethod ("emit_maximumZoomFactorChanged", "@brief Emitter for signal void QCamera::maximumZoomFactorChanged(float)\nCall this method to emit this signal.", false, &_init_emitter_maximumZoomFactorChanged_970, &_call_emitter_maximumZoomFactorChanged_970);
  methods += new qt_gsi::GenericMethod ("emit_minimumZoomFactorChanged", "@brief Emitter for signal void QCamera::minimumZoomFactorChanged(float)\nCall this method to emit this signal.", false, &_init_emitter_minimumZoomFactorChanged_970, &_call_emitter_minimumZoomFactorChanged_970);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QCamera::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QCamera::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("emit_saturationChanged", "@brief Emitter for signal void QCamera::saturationChanged()\nCall this method to emit this signal.", false, &_init_emitter_saturationChanged_0, &_call_emitter_saturationChanged_0);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QCamera::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QCamera::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("emit_supportedFeaturesChanged", "@brief Emitter for signal void QCamera::supportedFeaturesChanged()\nCall this method to emit this signal.", false, &_init_emitter_supportedFeaturesChanged_0, &_call_emitter_supportedFeaturesChanged_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QCamera::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("emit_torchModeChanged", "@brief Emitter for signal void QCamera::torchModeChanged()\nCall this method to emit this signal.", false, &_init_emitter_torchModeChanged_0, &_call_emitter_torchModeChanged_0);
  methods += new qt_gsi::GenericMethod ("emit_whiteBalanceModeChanged", "@brief Emitter for signal void QCamera::whiteBalanceModeChanged()\nCall this method to emit this signal.", true, &_init_emitter_whiteBalanceModeChanged_c0, &_call_emitter_whiteBalanceModeChanged_c0);
  methods += new qt_gsi::GenericMethod ("emit_zoomFactorChanged", "@brief Emitter for signal void QCamera::zoomFactorChanged(float)\nCall this method to emit this signal.", false, &_init_emitter_zoomFactorChanged_970, &_call_emitter_zoomFactorChanged_970);
  return methods;
}

gsi::Class<QCamera_Adaptor> decl_QCamera_Adaptor (qtdecl_QCamera (), "QtMultimedia", "QCamera",
  methods_QCamera_Adaptor (),
  "@qt\n@brief Binding of QCamera");

}


//  Implementation of the enum wrapper class for QCamera::Error
namespace qt_gsi
{

static gsi::Enum<QCamera::Error> decl_QCamera_Error_Enum ("QtMultimedia", "QCamera_Error",
    gsi::enum_const ("NoError", QCamera::NoError, "@brief Enum constant QCamera::NoError") +
    gsi::enum_const ("CameraError", QCamera::CameraError, "@brief Enum constant QCamera::CameraError"),
  "@qt\n@brief This class represents the QCamera::Error enum");

static gsi::QFlagsClass<QCamera::Error > decl_QCamera_Error_Enums ("QtMultimedia", "QCamera_QFlags_Error",
  "@qt\n@brief This class represents the QFlags<QCamera::Error> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QCamera> inject_QCamera_Error_Enum_in_parent (decl_QCamera_Error_Enum.defs ());
static gsi::ClassExt<QCamera> decl_QCamera_Error_Enum_as_child (decl_QCamera_Error_Enum, "Error");
static gsi::ClassExt<QCamera> decl_QCamera_Error_Enums_as_child (decl_QCamera_Error_Enums, "QFlags_Error");

}


//  Implementation of the enum wrapper class for QCamera::ExposureMode
namespace qt_gsi
{

static gsi::Enum<QCamera::ExposureMode> decl_QCamera_ExposureMode_Enum ("QtMultimedia", "QCamera_ExposureMode",
    gsi::enum_const ("ExposureAuto", QCamera::ExposureAuto, "@brief Enum constant QCamera::ExposureAuto") +
    gsi::enum_const ("ExposureManual", QCamera::ExposureManual, "@brief Enum constant QCamera::ExposureManual") +
    gsi::enum_const ("ExposurePortrait", QCamera::ExposurePortrait, "@brief Enum constant QCamera::ExposurePortrait") +
    gsi::enum_const ("ExposureNight", QCamera::ExposureNight, "@brief Enum constant QCamera::ExposureNight") +
    gsi::enum_const ("ExposureSports", QCamera::ExposureSports, "@brief Enum constant QCamera::ExposureSports") +
    gsi::enum_const ("ExposureSnow", QCamera::ExposureSnow, "@brief Enum constant QCamera::ExposureSnow") +
    gsi::enum_const ("ExposureBeach", QCamera::ExposureBeach, "@brief Enum constant QCamera::ExposureBeach") +
    gsi::enum_const ("ExposureAction", QCamera::ExposureAction, "@brief Enum constant QCamera::ExposureAction") +
    gsi::enum_const ("ExposureLandscape", QCamera::ExposureLandscape, "@brief Enum constant QCamera::ExposureLandscape") +
    gsi::enum_const ("ExposureNightPortrait", QCamera::ExposureNightPortrait, "@brief Enum constant QCamera::ExposureNightPortrait") +
    gsi::enum_const ("ExposureTheatre", QCamera::ExposureTheatre, "@brief Enum constant QCamera::ExposureTheatre") +
    gsi::enum_const ("ExposureSunset", QCamera::ExposureSunset, "@brief Enum constant QCamera::ExposureSunset") +
    gsi::enum_const ("ExposureSteadyPhoto", QCamera::ExposureSteadyPhoto, "@brief Enum constant QCamera::ExposureSteadyPhoto") +
    gsi::enum_const ("ExposureFireworks", QCamera::ExposureFireworks, "@brief Enum constant QCamera::ExposureFireworks") +
    gsi::enum_const ("ExposureParty", QCamera::ExposureParty, "@brief Enum constant QCamera::ExposureParty") +
    gsi::enum_const ("ExposureCandlelight", QCamera::ExposureCandlelight, "@brief Enum constant QCamera::ExposureCandlelight") +
    gsi::enum_const ("ExposureBarcode", QCamera::ExposureBarcode, "@brief Enum constant QCamera::ExposureBarcode"),
  "@qt\n@brief This class represents the QCamera::ExposureMode enum");

static gsi::QFlagsClass<QCamera::ExposureMode > decl_QCamera_ExposureMode_Enums ("QtMultimedia", "QCamera_QFlags_ExposureMode",
  "@qt\n@brief This class represents the QFlags<QCamera::ExposureMode> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QCamera> inject_QCamera_ExposureMode_Enum_in_parent (decl_QCamera_ExposureMode_Enum.defs ());
static gsi::ClassExt<QCamera> decl_QCamera_ExposureMode_Enum_as_child (decl_QCamera_ExposureMode_Enum, "ExposureMode");
static gsi::ClassExt<QCamera> decl_QCamera_ExposureMode_Enums_as_child (decl_QCamera_ExposureMode_Enums, "QFlags_ExposureMode");

}


//  Implementation of the enum wrapper class for QCamera::Feature
namespace qt_gsi
{

static gsi::Enum<QCamera::Feature> decl_QCamera_Feature_Enum ("QtMultimedia", "QCamera_Feature",
    gsi::enum_const ("ColorTemperature", QCamera::Feature::ColorTemperature, "@brief Enum constant QCamera::Feature::ColorTemperature") +
    gsi::enum_const ("ExposureCompensation", QCamera::Feature::ExposureCompensation, "@brief Enum constant QCamera::Feature::ExposureCompensation") +
    gsi::enum_const ("IsoSensitivity", QCamera::Feature::IsoSensitivity, "@brief Enum constant QCamera::Feature::IsoSensitivity") +
    gsi::enum_const ("ManualExposureTime", QCamera::Feature::ManualExposureTime, "@brief Enum constant QCamera::Feature::ManualExposureTime") +
    gsi::enum_const ("CustomFocusPoint", QCamera::Feature::CustomFocusPoint, "@brief Enum constant QCamera::Feature::CustomFocusPoint") +
    gsi::enum_const ("FocusDistance", QCamera::Feature::FocusDistance, "@brief Enum constant QCamera::Feature::FocusDistance"),
  "@qt\n@brief This class represents the QCamera::Feature enum");

static gsi::QFlagsClass<QCamera::Feature > decl_QCamera_Feature_Enums ("QtMultimedia", "QCamera_QFlags_Feature",
  "@qt\n@brief This class represents the QFlags<QCamera::Feature> flag set");

static gsi::ClassExt<QCamera> decl_QCamera_Feature_Enum_as_child (decl_QCamera_Feature_Enum, "Feature");
static gsi::ClassExt<QCamera> decl_QCamera_Feature_Enums_as_child (decl_QCamera_Feature_Enums, "QFlags_Feature");

}


//  Implementation of the enum wrapper class for QCamera::FlashMode
namespace qt_gsi
{

static gsi::Enum<QCamera::FlashMode> decl_QCamera_FlashMode_Enum ("QtMultimedia", "QCamera_FlashMode",
    gsi::enum_const ("FlashOff", QCamera::FlashOff, "@brief Enum constant QCamera::FlashOff") +
    gsi::enum_const ("FlashOn", QCamera::FlashOn, "@brief Enum constant QCamera::FlashOn") +
    gsi::enum_const ("FlashAuto", QCamera::FlashAuto, "@brief Enum constant QCamera::FlashAuto"),
  "@qt\n@brief This class represents the QCamera::FlashMode enum");

static gsi::QFlagsClass<QCamera::FlashMode > decl_QCamera_FlashMode_Enums ("QtMultimedia", "QCamera_QFlags_FlashMode",
  "@qt\n@brief This class represents the QFlags<QCamera::FlashMode> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QCamera> inject_QCamera_FlashMode_Enum_in_parent (decl_QCamera_FlashMode_Enum.defs ());
static gsi::ClassExt<QCamera> decl_QCamera_FlashMode_Enum_as_child (decl_QCamera_FlashMode_Enum, "FlashMode");
static gsi::ClassExt<QCamera> decl_QCamera_FlashMode_Enums_as_child (decl_QCamera_FlashMode_Enums, "QFlags_FlashMode");

}


//  Implementation of the enum wrapper class for QCamera::FocusMode
namespace qt_gsi
{

static gsi::Enum<QCamera::FocusMode> decl_QCamera_FocusMode_Enum ("QtMultimedia", "QCamera_FocusMode",
    gsi::enum_const ("FocusModeAuto", QCamera::FocusModeAuto, "@brief Enum constant QCamera::FocusModeAuto") +
    gsi::enum_const ("FocusModeAutoNear", QCamera::FocusModeAutoNear, "@brief Enum constant QCamera::FocusModeAutoNear") +
    gsi::enum_const ("FocusModeAutoFar", QCamera::FocusModeAutoFar, "@brief Enum constant QCamera::FocusModeAutoFar") +
    gsi::enum_const ("FocusModeHyperfocal", QCamera::FocusModeHyperfocal, "@brief Enum constant QCamera::FocusModeHyperfocal") +
    gsi::enum_const ("FocusModeInfinity", QCamera::FocusModeInfinity, "@brief Enum constant QCamera::FocusModeInfinity") +
    gsi::enum_const ("FocusModeManual", QCamera::FocusModeManual, "@brief Enum constant QCamera::FocusModeManual"),
  "@qt\n@brief This class represents the QCamera::FocusMode enum");

static gsi::QFlagsClass<QCamera::FocusMode > decl_QCamera_FocusMode_Enums ("QtMultimedia", "QCamera_QFlags_FocusMode",
  "@qt\n@brief This class represents the QFlags<QCamera::FocusMode> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QCamera> inject_QCamera_FocusMode_Enum_in_parent (decl_QCamera_FocusMode_Enum.defs ());
static gsi::ClassExt<QCamera> decl_QCamera_FocusMode_Enum_as_child (decl_QCamera_FocusMode_Enum, "FocusMode");
static gsi::ClassExt<QCamera> decl_QCamera_FocusMode_Enums_as_child (decl_QCamera_FocusMode_Enums, "QFlags_FocusMode");

}


//  Implementation of the enum wrapper class for QCamera::TorchMode
namespace qt_gsi
{

static gsi::Enum<QCamera::TorchMode> decl_QCamera_TorchMode_Enum ("QtMultimedia", "QCamera_TorchMode",
    gsi::enum_const ("TorchOff", QCamera::TorchOff, "@brief Enum constant QCamera::TorchOff") +
    gsi::enum_const ("TorchOn", QCamera::TorchOn, "@brief Enum constant QCamera::TorchOn") +
    gsi::enum_const ("TorchAuto", QCamera::TorchAuto, "@brief Enum constant QCamera::TorchAuto"),
  "@qt\n@brief This class represents the QCamera::TorchMode enum");

static gsi::QFlagsClass<QCamera::TorchMode > decl_QCamera_TorchMode_Enums ("QtMultimedia", "QCamera_QFlags_TorchMode",
  "@qt\n@brief This class represents the QFlags<QCamera::TorchMode> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QCamera> inject_QCamera_TorchMode_Enum_in_parent (decl_QCamera_TorchMode_Enum.defs ());
static gsi::ClassExt<QCamera> decl_QCamera_TorchMode_Enum_as_child (decl_QCamera_TorchMode_Enum, "TorchMode");
static gsi::ClassExt<QCamera> decl_QCamera_TorchMode_Enums_as_child (decl_QCamera_TorchMode_Enums, "QFlags_TorchMode");

}


//  Implementation of the enum wrapper class for QCamera::WhiteBalanceMode
namespace qt_gsi
{

static gsi::Enum<QCamera::WhiteBalanceMode> decl_QCamera_WhiteBalanceMode_Enum ("QtMultimedia", "QCamera_WhiteBalanceMode",
    gsi::enum_const ("WhiteBalanceAuto", QCamera::WhiteBalanceAuto, "@brief Enum constant QCamera::WhiteBalanceAuto") +
    gsi::enum_const ("WhiteBalanceManual", QCamera::WhiteBalanceManual, "@brief Enum constant QCamera::WhiteBalanceManual") +
    gsi::enum_const ("WhiteBalanceSunlight", QCamera::WhiteBalanceSunlight, "@brief Enum constant QCamera::WhiteBalanceSunlight") +
    gsi::enum_const ("WhiteBalanceCloudy", QCamera::WhiteBalanceCloudy, "@brief Enum constant QCamera::WhiteBalanceCloudy") +
    gsi::enum_const ("WhiteBalanceShade", QCamera::WhiteBalanceShade, "@brief Enum constant QCamera::WhiteBalanceShade") +
    gsi::enum_const ("WhiteBalanceTungsten", QCamera::WhiteBalanceTungsten, "@brief Enum constant QCamera::WhiteBalanceTungsten") +
    gsi::enum_const ("WhiteBalanceFluorescent", QCamera::WhiteBalanceFluorescent, "@brief Enum constant QCamera::WhiteBalanceFluorescent") +
    gsi::enum_const ("WhiteBalanceFlash", QCamera::WhiteBalanceFlash, "@brief Enum constant QCamera::WhiteBalanceFlash") +
    gsi::enum_const ("WhiteBalanceSunset", QCamera::WhiteBalanceSunset, "@brief Enum constant QCamera::WhiteBalanceSunset"),
  "@qt\n@brief This class represents the QCamera::WhiteBalanceMode enum");

static gsi::QFlagsClass<QCamera::WhiteBalanceMode > decl_QCamera_WhiteBalanceMode_Enums ("QtMultimedia", "QCamera_QFlags_WhiteBalanceMode",
  "@qt\n@brief This class represents the QFlags<QCamera::WhiteBalanceMode> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QCamera> inject_QCamera_WhiteBalanceMode_Enum_in_parent (decl_QCamera_WhiteBalanceMode_Enum.defs ());
static gsi::ClassExt<QCamera> decl_QCamera_WhiteBalanceMode_Enum_as_child (decl_QCamera_WhiteBalanceMode_Enum, "WhiteBalanceMode");
static gsi::ClassExt<QCamera> decl_QCamera_WhiteBalanceMode_Enums_as_child (decl_QCamera_WhiteBalanceMode_Enums, "QFlags_WhiteBalanceMode");

}

