/**
 * Autogenerated by Thrift Compiler (0.21.0)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
#include "parquet_types.h"

#include <algorithm>
#include <ostream>

#include <thrift/TToString.h>

namespace duckdb_parquet {

int _kTypeValues[] = {
  Type::BOOLEAN,
  Type::INT32,
  Type::INT64,
  Type::INT96,
  Type::FLOAT,
  Type::DOUBLE,
  Type::BYTE_ARRAY,
  Type::FIXED_LEN_BYTE_ARRAY
};
const char* _kTypeNames[] = {
  "BOOLEAN",
  "INT32",
  "INT64",
  "INT96",
  "FLOAT",
  "DOUBLE",
  "BYTE_ARRAY",
  "FIXED_LEN_BYTE_ARRAY"
};
const std::map<int, const char*> _Type_VALUES_TO_NAMES(::apache::thrift::TEnumIterator(8, _kTypeValues, _kTypeNames), ::apache::thrift::TEnumIterator(-1, nullptr, nullptr));

std::ostream& operator<<(std::ostream& out, const Type::type& val) {
  std::map<int, const char*>::const_iterator it = _Type_VALUES_TO_NAMES.find(val);
  if (it != _Type_VALUES_TO_NAMES.end()) {
    out << it->second;
  } else {
    out << static_cast<int>(val);
  }
  return out;
}

std::string to_string(const Type::type& val) {
  std::map<int, const char*>::const_iterator it = _Type_VALUES_TO_NAMES.find(val);
  if (it != _Type_VALUES_TO_NAMES.end()) {
    return std::string(it->second);
  } else {
    return std::to_string(static_cast<int>(val));
  }
}

int _kConvertedTypeValues[] = {
  /**
   * a BYTE_ARRAY actually contains UTF8 encoded chars
   */
  ConvertedType::UTF8,
  /**
   * a map is converted as an optional field containing a repeated key/value pair
   */
  ConvertedType::MAP,
  /**
   * a key/value pair is converted into a group of two fields
   */
  ConvertedType::MAP_KEY_VALUE,
  /**
   * a list is converted into an optional field containing a repeated field for its
   * values
   */
  ConvertedType::LIST,
  /**
   * an enum is converted into a BYTE_ARRAY field
   */
  ConvertedType::ENUM,
  /**
   * A decimal value.
   * 
   * This may be used to annotate BYTE_ARRAY or FIXED_LEN_BYTE_ARRAY primitive
   * types. The underlying byte array stores the unscaled value encoded as two's
   * complement using big-endian byte order (the most significant byte is the
   * zeroth element). The value of the decimal is the value * 10^{-scale}.
   * 
   * This must be accompanied by a (maximum) precision and a scale in the
   * SchemaElement. The precision specifies the number of digits in the decimal
   * and the scale stores the location of the decimal point. For example 1.23
   * would have precision 3 (3 total digits) and scale 2 (the decimal point is
   * 2 digits over).
   */
  ConvertedType::DECIMAL,
  /**
   * A Date
   * 
   * Stored as days since Unix epoch, encoded as the INT32 physical type.
   * 
   */
  ConvertedType::DATE,
  /**
   * A time
   * 
   * The total number of milliseconds since midnight.  The value is stored
   * as an INT32 physical type.
   */
  ConvertedType::TIME_MILLIS,
  /**
   * A time.
   * 
   * The total number of microseconds since midnight.  The value is stored as
   * an INT64 physical type.
   */
  ConvertedType::TIME_MICROS,
  /**
   * A date/time combination
   * 
   * Date and time recorded as milliseconds since the Unix epoch.  Recorded as
   * a physical type of INT64.
   */
  ConvertedType::TIMESTAMP_MILLIS,
  /**
   * A date/time combination
   * 
   * Date and time recorded as microseconds since the Unix epoch.  The value is
   * stored as an INT64 physical type.
   */
  ConvertedType::TIMESTAMP_MICROS,
  /**
   * An unsigned integer value.
   * 
   * The number describes the maximum number of meaningful data bits in
   * the stored value. 8, 16 and 32 bit values are stored using the
   * INT32 physical type.  64 bit values are stored using the INT64
   * physical type.
   * 
   */
  ConvertedType::UINT_8,
  ConvertedType::UINT_16,
  ConvertedType::UINT_32,
  ConvertedType::UINT_64,
  /**
   * A signed integer value.
   * 
   * The number describes the maximum number of meaningful data bits in
   * the stored value. 8, 16 and 32 bit values are stored using the
   * INT32 physical type.  64 bit values are stored using the INT64
   * physical type.
   * 
   */
  ConvertedType::INT_8,
  ConvertedType::INT_16,
  ConvertedType::INT_32,
  ConvertedType::INT_64,
  /**
   * An embedded JSON document
   * 
   * A JSON document embedded within a single UTF8 column.
   */
  ConvertedType::JSON,
  /**
   * An embedded BSON document
   * 
   * A BSON document embedded within a single BYTE_ARRAY column.
   */
  ConvertedType::BSON,
  /**
   * An interval of time
   * 
   * This type annotates data stored as a FIXED_LEN_BYTE_ARRAY of length 12
   * This data is composed of three separate little endian unsigned
   * integers.  Each stores a component of a duration of time.  The first
   * integer identifies the number of months associated with the duration,
   * the second identifies the number of days associated with the duration
   * and the third identifies the number of milliseconds associated with
   * the provided duration.  This duration of time is independent of any
   * particular timezone or date.
   */
  ConvertedType::INTERVAL
};
const char* _kConvertedTypeNames[] = {
  /**
   * a BYTE_ARRAY actually contains UTF8 encoded chars
   */
  "UTF8",
  /**
   * a map is converted as an optional field containing a repeated key/value pair
   */
  "MAP",
  /**
   * a key/value pair is converted into a group of two fields
   */
  "MAP_KEY_VALUE",
  /**
   * a list is converted into an optional field containing a repeated field for its
   * values
   */
  "LIST",
  /**
   * an enum is converted into a BYTE_ARRAY field
   */
  "ENUM",
  /**
   * A decimal value.
   * 
   * This may be used to annotate BYTE_ARRAY or FIXED_LEN_BYTE_ARRAY primitive
   * types. The underlying byte array stores the unscaled value encoded as two's
   * complement using big-endian byte order (the most significant byte is the
   * zeroth element). The value of the decimal is the value * 10^{-scale}.
   * 
   * This must be accompanied by a (maximum) precision and a scale in the
   * SchemaElement. The precision specifies the number of digits in the decimal
   * and the scale stores the location of the decimal point. For example 1.23
   * would have precision 3 (3 total digits) and scale 2 (the decimal point is
   * 2 digits over).
   */
  "DECIMAL",
  /**
   * A Date
   * 
   * Stored as days since Unix epoch, encoded as the INT32 physical type.
   * 
   */
  "DATE",
  /**
   * A time
   * 
   * The total number of milliseconds since midnight.  The value is stored
   * as an INT32 physical type.
   */
  "TIME_MILLIS",
  /**
   * A time.
   * 
   * The total number of microseconds since midnight.  The value is stored as
   * an INT64 physical type.
   */
  "TIME_MICROS",
  /**
   * A date/time combination
   * 
   * Date and time recorded as milliseconds since the Unix epoch.  Recorded as
   * a physical type of INT64.
   */
  "TIMESTAMP_MILLIS",
  /**
   * A date/time combination
   * 
   * Date and time recorded as microseconds since the Unix epoch.  The value is
   * stored as an INT64 physical type.
   */
  "TIMESTAMP_MICROS",
  /**
   * An unsigned integer value.
   * 
   * The number describes the maximum number of meaningful data bits in
   * the stored value. 8, 16 and 32 bit values are stored using the
   * INT32 physical type.  64 bit values are stored using the INT64
   * physical type.
   * 
   */
  "UINT_8",
  "UINT_16",
  "UINT_32",
  "UINT_64",
  /**
   * A signed integer value.
   * 
   * The number describes the maximum number of meaningful data bits in
   * the stored value. 8, 16 and 32 bit values are stored using the
   * INT32 physical type.  64 bit values are stored using the INT64
   * physical type.
   * 
   */
  "INT_8",
  "INT_16",
  "INT_32",
  "INT_64",
  /**
   * An embedded JSON document
   * 
   * A JSON document embedded within a single UTF8 column.
   */
  "JSON",
  /**
   * An embedded BSON document
   * 
   * A BSON document embedded within a single BYTE_ARRAY column.
   */
  "BSON",
  /**
   * An interval of time
   * 
   * This type annotates data stored as a FIXED_LEN_BYTE_ARRAY of length 12
   * This data is composed of three separate little endian unsigned
   * integers.  Each stores a component of a duration of time.  The first
   * integer identifies the number of months associated with the duration,
   * the second identifies the number of days associated with the duration
   * and the third identifies the number of milliseconds associated with
   * the provided duration.  This duration of time is independent of any
   * particular timezone or date.
   */
  "INTERVAL"
};
const std::map<int, const char*> _ConvertedType_VALUES_TO_NAMES(::apache::thrift::TEnumIterator(22, _kConvertedTypeValues, _kConvertedTypeNames), ::apache::thrift::TEnumIterator(-1, nullptr, nullptr));

std::ostream& operator<<(std::ostream& out, const ConvertedType::type& val) {
  std::map<int, const char*>::const_iterator it = _ConvertedType_VALUES_TO_NAMES.find(val);
  if (it != _ConvertedType_VALUES_TO_NAMES.end()) {
    out << it->second;
  } else {
    out << static_cast<int>(val);
  }
  return out;
}

std::string to_string(const ConvertedType::type& val) {
  std::map<int, const char*>::const_iterator it = _ConvertedType_VALUES_TO_NAMES.find(val);
  if (it != _ConvertedType_VALUES_TO_NAMES.end()) {
    return std::string(it->second);
  } else {
    return std::to_string(static_cast<int>(val));
  }
}

int _kFieldRepetitionTypeValues[] = {
  /**
   * This field is required (can not be null) and each row has exactly 1 value.
   */
  FieldRepetitionType::REQUIRED,
  /**
   * The field is optional (can be null) and each row has 0 or 1 values.
   */
  FieldRepetitionType::OPTIONAL,
  /**
   * The field is repeated and can contain 0 or more values
   */
  FieldRepetitionType::REPEATED
};
const char* _kFieldRepetitionTypeNames[] = {
  /**
   * This field is required (can not be null) and each row has exactly 1 value.
   */
  "REQUIRED",
  /**
   * The field is optional (can be null) and each row has 0 or 1 values.
   */
  "OPTIONAL",
  /**
   * The field is repeated and can contain 0 or more values
   */
  "REPEATED"
};
const std::map<int, const char*> _FieldRepetitionType_VALUES_TO_NAMES(::apache::thrift::TEnumIterator(3, _kFieldRepetitionTypeValues, _kFieldRepetitionTypeNames), ::apache::thrift::TEnumIterator(-1, nullptr, nullptr));

std::ostream& operator<<(std::ostream& out, const FieldRepetitionType::type& val) {
  std::map<int, const char*>::const_iterator it = _FieldRepetitionType_VALUES_TO_NAMES.find(val);
  if (it != _FieldRepetitionType_VALUES_TO_NAMES.end()) {
    out << it->second;
  } else {
    out << static_cast<int>(val);
  }
  return out;
}

std::string to_string(const FieldRepetitionType::type& val) {
  std::map<int, const char*>::const_iterator it = _FieldRepetitionType_VALUES_TO_NAMES.find(val);
  if (it != _FieldRepetitionType_VALUES_TO_NAMES.end()) {
    return std::string(it->second);
  } else {
    return std::to_string(static_cast<int>(val));
  }
}

int _kEdgeInterpolationAlgorithmValues[] = {
  EdgeInterpolationAlgorithm::SPHERICAL,
  EdgeInterpolationAlgorithm::VINCENTY,
  EdgeInterpolationAlgorithm::THOMAS,
  EdgeInterpolationAlgorithm::ANDOYER,
  EdgeInterpolationAlgorithm::KARNEY
};
const char* _kEdgeInterpolationAlgorithmNames[] = {
  "SPHERICAL",
  "VINCENTY",
  "THOMAS",
  "ANDOYER",
  "KARNEY"
};
const std::map<int, const char*> _EdgeInterpolationAlgorithm_VALUES_TO_NAMES(::apache::thrift::TEnumIterator(5, _kEdgeInterpolationAlgorithmValues, _kEdgeInterpolationAlgorithmNames), ::apache::thrift::TEnumIterator(-1, nullptr, nullptr));

std::ostream& operator<<(std::ostream& out, const EdgeInterpolationAlgorithm::type& val) {
  std::map<int, const char*>::const_iterator it = _EdgeInterpolationAlgorithm_VALUES_TO_NAMES.find(val);
  if (it != _EdgeInterpolationAlgorithm_VALUES_TO_NAMES.end()) {
    out << it->second;
  } else {
    out << static_cast<int>(val);
  }
  return out;
}

std::string to_string(const EdgeInterpolationAlgorithm::type& val) {
  std::map<int, const char*>::const_iterator it = _EdgeInterpolationAlgorithm_VALUES_TO_NAMES.find(val);
  if (it != _EdgeInterpolationAlgorithm_VALUES_TO_NAMES.end()) {
    return std::string(it->second);
  } else {
    return std::to_string(static_cast<int>(val));
  }
}

int _kEncodingValues[] = {
  /**
   * Default encoding.
   * BOOLEAN - 1 bit per value. 0 is false; 1 is true.
   * INT32 - 4 bytes per value.  Stored as little-endian.
   * INT64 - 8 bytes per value.  Stored as little-endian.
   * FLOAT - 4 bytes per value.  IEEE. Stored as little-endian.
   * DOUBLE - 8 bytes per value.  IEEE. Stored as little-endian.
   * BYTE_ARRAY - 4 byte length stored as little endian, followed by bytes.
   * FIXED_LEN_BYTE_ARRAY - Just the bytes.
   */
  Encoding::PLAIN,
  /**
   * Deprecated: Dictionary encoding. The values in the dictionary are encoded in the
   * plain type.
   * in a data page use RLE_DICTIONARY instead.
   * in a Dictionary page use PLAIN instead
   */
  Encoding::PLAIN_DICTIONARY,
  /**
   * Group packed run length encoding. Usable for definition/repetition levels
   * encoding and Booleans (on one bit: 0 is false; 1 is true.)
   */
  Encoding::RLE,
  /**
   * Bit packed encoding.  This can only be used if the data has a known max
   * width.  Usable for definition/repetition levels encoding.
   */
  Encoding::BIT_PACKED,
  /**
   * Delta encoding for integers. This can be used for int columns and works best
   * on sorted data
   */
  Encoding::DELTA_BINARY_PACKED,
  /**
   * Encoding for byte arrays to separate the length values and the data. The lengths
   * are encoded using DELTA_BINARY_PACKED
   */
  Encoding::DELTA_LENGTH_BYTE_ARRAY,
  /**
   * Incremental-encoded byte array. Prefix lengths are encoded using DELTA_BINARY_PACKED.
   * Suffixes are stored as delta length byte arrays.
   */
  Encoding::DELTA_BYTE_ARRAY,
  /**
   * Dictionary encoding: the ids are encoded using the RLE encoding
   */
  Encoding::RLE_DICTIONARY,
  /**
   * Encoding for fixed-width data (FLOAT, DOUBLE, INT32, INT64, FIXED_LEN_BYTE_ARRAY).
   * K byte-streams are created where K is the size in bytes of the data type.
   * The individual bytes of a value are scattered to the corresponding stream and
   * the streams are concatenated.
   * This itself does not reduce the size of the data but can lead to better compression
   * afterwards.
   * 
   * Added in 2.8 for FLOAT and DOUBLE.
   * Support for INT32, INT64 and FIXED_LEN_BYTE_ARRAY added in 2.11.
   */
  Encoding::BYTE_STREAM_SPLIT
};
const char* _kEncodingNames[] = {
  /**
   * Default encoding.
   * BOOLEAN - 1 bit per value. 0 is false; 1 is true.
   * INT32 - 4 bytes per value.  Stored as little-endian.
   * INT64 - 8 bytes per value.  Stored as little-endian.
   * FLOAT - 4 bytes per value.  IEEE. Stored as little-endian.
   * DOUBLE - 8 bytes per value.  IEEE. Stored as little-endian.
   * BYTE_ARRAY - 4 byte length stored as little endian, followed by bytes.
   * FIXED_LEN_BYTE_ARRAY - Just the bytes.
   */
  "PLAIN",
  /**
   * Deprecated: Dictionary encoding. The values in the dictionary are encoded in the
   * plain type.
   * in a data page use RLE_DICTIONARY instead.
   * in a Dictionary page use PLAIN instead
   */
  "PLAIN_DICTIONARY",
  /**
   * Group packed run length encoding. Usable for definition/repetition levels
   * encoding and Booleans (on one bit: 0 is false; 1 is true.)
   */
  "RLE",
  /**
   * Bit packed encoding.  This can only be used if the data has a known max
   * width.  Usable for definition/repetition levels encoding.
   */
  "BIT_PACKED",
  /**
   * Delta encoding for integers. This can be used for int columns and works best
   * on sorted data
   */
  "DELTA_BINARY_PACKED",
  /**
   * Encoding for byte arrays to separate the length values and the data. The lengths
   * are encoded using DELTA_BINARY_PACKED
   */
  "DELTA_LENGTH_BYTE_ARRAY",
  /**
   * Incremental-encoded byte array. Prefix lengths are encoded using DELTA_BINARY_PACKED.
   * Suffixes are stored as delta length byte arrays.
   */
  "DELTA_BYTE_ARRAY",
  /**
   * Dictionary encoding: the ids are encoded using the RLE encoding
   */
  "RLE_DICTIONARY",
  /**
   * Encoding for fixed-width data (FLOAT, DOUBLE, INT32, INT64, FIXED_LEN_BYTE_ARRAY).
   * K byte-streams are created where K is the size in bytes of the data type.
   * The individual bytes of a value are scattered to the corresponding stream and
   * the streams are concatenated.
   * This itself does not reduce the size of the data but can lead to better compression
   * afterwards.
   * 
   * Added in 2.8 for FLOAT and DOUBLE.
   * Support for INT32, INT64 and FIXED_LEN_BYTE_ARRAY added in 2.11.
   */
  "BYTE_STREAM_SPLIT"
};
const std::map<int, const char*> _Encoding_VALUES_TO_NAMES(::apache::thrift::TEnumIterator(9, _kEncodingValues, _kEncodingNames), ::apache::thrift::TEnumIterator(-1, nullptr, nullptr));

std::ostream& operator<<(std::ostream& out, const Encoding::type& val) {
  std::map<int, const char*>::const_iterator it = _Encoding_VALUES_TO_NAMES.find(val);
  if (it != _Encoding_VALUES_TO_NAMES.end()) {
    out << it->second;
  } else {
    out << static_cast<int>(val);
  }
  return out;
}

std::string to_string(const Encoding::type& val) {
  std::map<int, const char*>::const_iterator it = _Encoding_VALUES_TO_NAMES.find(val);
  if (it != _Encoding_VALUES_TO_NAMES.end()) {
    return std::string(it->second);
  } else {
    return std::to_string(static_cast<int>(val));
  }
}

int _kCompressionCodecValues[] = {
  CompressionCodec::UNCOMPRESSED,
  CompressionCodec::SNAPPY,
  CompressionCodec::GZIP,
  CompressionCodec::LZO,
  CompressionCodec::BROTLI,
  CompressionCodec::LZ4,
  CompressionCodec::ZSTD,
  CompressionCodec::LZ4_RAW
};
const char* _kCompressionCodecNames[] = {
  "UNCOMPRESSED",
  "SNAPPY",
  "GZIP",
  "LZO",
  "BROTLI",
  "LZ4",
  "ZSTD",
  "LZ4_RAW"
};
const std::map<int, const char*> _CompressionCodec_VALUES_TO_NAMES(::apache::thrift::TEnumIterator(8, _kCompressionCodecValues, _kCompressionCodecNames), ::apache::thrift::TEnumIterator(-1, nullptr, nullptr));

std::ostream& operator<<(std::ostream& out, const CompressionCodec::type& val) {
  std::map<int, const char*>::const_iterator it = _CompressionCodec_VALUES_TO_NAMES.find(val);
  if (it != _CompressionCodec_VALUES_TO_NAMES.end()) {
    out << it->second;
  } else {
    out << static_cast<int>(val);
  }
  return out;
}

std::string to_string(const CompressionCodec::type& val) {
  std::map<int, const char*>::const_iterator it = _CompressionCodec_VALUES_TO_NAMES.find(val);
  if (it != _CompressionCodec_VALUES_TO_NAMES.end()) {
    return std::string(it->second);
  } else {
    return std::to_string(static_cast<int>(val));
  }
}

int _kPageTypeValues[] = {
  PageType::DATA_PAGE,
  PageType::INDEX_PAGE,
  PageType::DICTIONARY_PAGE,
  PageType::DATA_PAGE_V2
};
const char* _kPageTypeNames[] = {
  "DATA_PAGE",
  "INDEX_PAGE",
  "DICTIONARY_PAGE",
  "DATA_PAGE_V2"
};
const std::map<int, const char*> _PageType_VALUES_TO_NAMES(::apache::thrift::TEnumIterator(4, _kPageTypeValues, _kPageTypeNames), ::apache::thrift::TEnumIterator(-1, nullptr, nullptr));

std::ostream& operator<<(std::ostream& out, const PageType::type& val) {
  std::map<int, const char*>::const_iterator it = _PageType_VALUES_TO_NAMES.find(val);
  if (it != _PageType_VALUES_TO_NAMES.end()) {
    out << it->second;
  } else {
    out << static_cast<int>(val);
  }
  return out;
}

std::string to_string(const PageType::type& val) {
  std::map<int, const char*>::const_iterator it = _PageType_VALUES_TO_NAMES.find(val);
  if (it != _PageType_VALUES_TO_NAMES.end()) {
    return std::string(it->second);
  } else {
    return std::to_string(static_cast<int>(val));
  }
}

int _kBoundaryOrderValues[] = {
  BoundaryOrder::UNORDERED,
  BoundaryOrder::ASCENDING,
  BoundaryOrder::DESCENDING
};
const char* _kBoundaryOrderNames[] = {
  "UNORDERED",
  "ASCENDING",
  "DESCENDING"
};
const std::map<int, const char*> _BoundaryOrder_VALUES_TO_NAMES(::apache::thrift::TEnumIterator(3, _kBoundaryOrderValues, _kBoundaryOrderNames), ::apache::thrift::TEnumIterator(-1, nullptr, nullptr));

std::ostream& operator<<(std::ostream& out, const BoundaryOrder::type& val) {
  std::map<int, const char*>::const_iterator it = _BoundaryOrder_VALUES_TO_NAMES.find(val);
  if (it != _BoundaryOrder_VALUES_TO_NAMES.end()) {
    out << it->second;
  } else {
    out << static_cast<int>(val);
  }
  return out;
}

std::string to_string(const BoundaryOrder::type& val) {
  std::map<int, const char*>::const_iterator it = _BoundaryOrder_VALUES_TO_NAMES.find(val);
  if (it != _BoundaryOrder_VALUES_TO_NAMES.end()) {
    return std::string(it->second);
  } else {
    return std::to_string(static_cast<int>(val));
  }
}


SizeStatistics::~SizeStatistics() noexcept {
}

SizeStatistics::SizeStatistics() noexcept
   : unencoded_byte_array_data_bytes(0) {
}

void SizeStatistics::__set_unencoded_byte_array_data_bytes(const int64_t val) {
  this->unencoded_byte_array_data_bytes = val;
__isset.unencoded_byte_array_data_bytes = true;
}

void SizeStatistics::__set_repetition_level_histogram(const duckdb::vector<int64_t> & val) {
  this->repetition_level_histogram = val;
__isset.repetition_level_histogram = true;
}

void SizeStatistics::__set_definition_level_histogram(const duckdb::vector<int64_t> & val) {
  this->definition_level_histogram = val;
__isset.definition_level_histogram = true;
}
std::ostream& operator<<(std::ostream& out, const SizeStatistics& obj)
{
  obj.printTo(out);
  return out;
}


uint32_t SizeStatistics::read(::apache::thrift::protocol::TProtocol* iprot) {

  ::apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;


  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_I64) {
          xfer += iprot->readI64(this->unencoded_byte_array_data_bytes);
          this->__isset.unencoded_byte_array_data_bytes = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->repetition_level_histogram.clear();
            uint32_t _size0;
            ::apache::thrift::protocol::TType _etype3;
            xfer += iprot->readListBegin(_etype3, _size0);
            this->repetition_level_histogram.resize(_size0);
            uint32_t _i4;
            for (_i4 = 0; _i4 < _size0; ++_i4)
            {
              xfer += iprot->readI64(this->repetition_level_histogram[_i4]);
            }
            xfer += iprot->readListEnd();
          }
          this->__isset.repetition_level_histogram = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->definition_level_histogram.clear();
            uint32_t _size5;
            ::apache::thrift::protocol::TType _etype8;
            xfer += iprot->readListBegin(_etype8, _size5);
            this->definition_level_histogram.resize(_size5);
            uint32_t _i9;
            for (_i9 = 0; _i9 < _size5; ++_i9)
            {
              xfer += iprot->readI64(this->definition_level_histogram[_i9]);
            }
            xfer += iprot->readListEnd();
          }
          this->__isset.definition_level_histogram = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  return xfer;
}

uint32_t SizeStatistics::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  ::apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("SizeStatistics");

  if (this->__isset.unencoded_byte_array_data_bytes) {
    xfer += oprot->writeFieldBegin("unencoded_byte_array_data_bytes", ::apache::thrift::protocol::T_I64, 1);
    xfer += oprot->writeI64(this->unencoded_byte_array_data_bytes);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.repetition_level_histogram) {
    xfer += oprot->writeFieldBegin("repetition_level_histogram", ::apache::thrift::protocol::T_LIST, 2);
    {
      xfer += oprot->writeListBegin(::apache::thrift::protocol::T_I64, static_cast<uint32_t>(this->repetition_level_histogram.size()));
      duckdb::vector<int64_t> ::const_iterator _iter10;
      for (_iter10 = this->repetition_level_histogram.begin(); _iter10 != this->repetition_level_histogram.end(); ++_iter10)
      {
        xfer += oprot->writeI64((*_iter10));
      }
      xfer += oprot->writeListEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.definition_level_histogram) {
    xfer += oprot->writeFieldBegin("definition_level_histogram", ::apache::thrift::protocol::T_LIST, 3);
    {
      xfer += oprot->writeListBegin(::apache::thrift::protocol::T_I64, static_cast<uint32_t>(this->definition_level_histogram.size()));
      duckdb::vector<int64_t> ::const_iterator _iter11;
      for (_iter11 = this->definition_level_histogram.begin(); _iter11 != this->definition_level_histogram.end(); ++_iter11)
      {
        xfer += oprot->writeI64((*_iter11));
      }
      xfer += oprot->writeListEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(SizeStatistics &a, SizeStatistics &b) {
  using ::std::swap;
  swap(a.unencoded_byte_array_data_bytes, b.unencoded_byte_array_data_bytes);
  swap(a.repetition_level_histogram, b.repetition_level_histogram);
  swap(a.definition_level_histogram, b.definition_level_histogram);
  swap(a.__isset, b.__isset);
}

SizeStatistics::SizeStatistics(const SizeStatistics& other12) {
  unencoded_byte_array_data_bytes = other12.unencoded_byte_array_data_bytes;
  repetition_level_histogram = other12.repetition_level_histogram;
  definition_level_histogram = other12.definition_level_histogram;
  __isset = other12.__isset;
}
SizeStatistics::SizeStatistics(SizeStatistics&& other13) noexcept {
  unencoded_byte_array_data_bytes = other13.unencoded_byte_array_data_bytes;
  repetition_level_histogram = std::move(other13.repetition_level_histogram);
  definition_level_histogram = std::move(other13.definition_level_histogram);
  __isset = other13.__isset;
}
SizeStatistics& SizeStatistics::operator=(const SizeStatistics& other14) {
  unencoded_byte_array_data_bytes = other14.unencoded_byte_array_data_bytes;
  repetition_level_histogram = other14.repetition_level_histogram;
  definition_level_histogram = other14.definition_level_histogram;
  __isset = other14.__isset;
  return *this;
}
SizeStatistics& SizeStatistics::operator=(SizeStatistics&& other15) noexcept {
  unencoded_byte_array_data_bytes = other15.unencoded_byte_array_data_bytes;
  repetition_level_histogram = std::move(other15.repetition_level_histogram);
  definition_level_histogram = std::move(other15.definition_level_histogram);
  __isset = other15.__isset;
  return *this;
}
void SizeStatistics::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "SizeStatistics(";
  out << "unencoded_byte_array_data_bytes="; (__isset.unencoded_byte_array_data_bytes ? (out << to_string(unencoded_byte_array_data_bytes)) : (out << "<null>"));
  out << ", " << "repetition_level_histogram="; (__isset.repetition_level_histogram ? (out << to_string(repetition_level_histogram)) : (out << "<null>"));
  out << ", " << "definition_level_histogram="; (__isset.definition_level_histogram ? (out << to_string(definition_level_histogram)) : (out << "<null>"));
  out << ")";
}


BoundingBox::~BoundingBox() noexcept {
}

BoundingBox::BoundingBox() noexcept
   : xmin(0),
     xmax(0),
     ymin(0),
     ymax(0),
     zmin(0),
     zmax(0),
     mmin(0),
     mmax(0) {
}

void BoundingBox::__set_xmin(const double val) {
  this->xmin = val;
}

void BoundingBox::__set_xmax(const double val) {
  this->xmax = val;
}

void BoundingBox::__set_ymin(const double val) {
  this->ymin = val;
}

void BoundingBox::__set_ymax(const double val) {
  this->ymax = val;
}

void BoundingBox::__set_zmin(const double val) {
  this->zmin = val;
__isset.zmin = true;
}

void BoundingBox::__set_zmax(const double val) {
  this->zmax = val;
__isset.zmax = true;
}

void BoundingBox::__set_mmin(const double val) {
  this->mmin = val;
__isset.mmin = true;
}

void BoundingBox::__set_mmax(const double val) {
  this->mmax = val;
__isset.mmax = true;
}
std::ostream& operator<<(std::ostream& out, const BoundingBox& obj)
{
  obj.printTo(out);
  return out;
}


uint32_t BoundingBox::read(::apache::thrift::protocol::TProtocol* iprot) {

  ::apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_xmin = false;
  bool isset_xmax = false;
  bool isset_ymin = false;
  bool isset_ymax = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_DOUBLE) {
          xfer += iprot->readDouble(this->xmin);
          isset_xmin = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_DOUBLE) {
          xfer += iprot->readDouble(this->xmax);
          isset_xmax = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_DOUBLE) {
          xfer += iprot->readDouble(this->ymin);
          isset_ymin = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 4:
        if (ftype == ::apache::thrift::protocol::T_DOUBLE) {
          xfer += iprot->readDouble(this->ymax);
          isset_ymax = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 5:
        if (ftype == ::apache::thrift::protocol::T_DOUBLE) {
          xfer += iprot->readDouble(this->zmin);
          this->__isset.zmin = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 6:
        if (ftype == ::apache::thrift::protocol::T_DOUBLE) {
          xfer += iprot->readDouble(this->zmax);
          this->__isset.zmax = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 7:
        if (ftype == ::apache::thrift::protocol::T_DOUBLE) {
          xfer += iprot->readDouble(this->mmin);
          this->__isset.mmin = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 8:
        if (ftype == ::apache::thrift::protocol::T_DOUBLE) {
          xfer += iprot->readDouble(this->mmax);
          this->__isset.mmax = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_xmin)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_xmax)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_ymin)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_ymax)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t BoundingBox::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  ::apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("BoundingBox");

  xfer += oprot->writeFieldBegin("xmin", ::apache::thrift::protocol::T_DOUBLE, 1);
  xfer += oprot->writeDouble(this->xmin);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("xmax", ::apache::thrift::protocol::T_DOUBLE, 2);
  xfer += oprot->writeDouble(this->xmax);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("ymin", ::apache::thrift::protocol::T_DOUBLE, 3);
  xfer += oprot->writeDouble(this->ymin);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("ymax", ::apache::thrift::protocol::T_DOUBLE, 4);
  xfer += oprot->writeDouble(this->ymax);
  xfer += oprot->writeFieldEnd();

  if (this->__isset.zmin) {
    xfer += oprot->writeFieldBegin("zmin", ::apache::thrift::protocol::T_DOUBLE, 5);
    xfer += oprot->writeDouble(this->zmin);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.zmax) {
    xfer += oprot->writeFieldBegin("zmax", ::apache::thrift::protocol::T_DOUBLE, 6);
    xfer += oprot->writeDouble(this->zmax);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.mmin) {
    xfer += oprot->writeFieldBegin("mmin", ::apache::thrift::protocol::T_DOUBLE, 7);
    xfer += oprot->writeDouble(this->mmin);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.mmax) {
    xfer += oprot->writeFieldBegin("mmax", ::apache::thrift::protocol::T_DOUBLE, 8);
    xfer += oprot->writeDouble(this->mmax);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(BoundingBox &a, BoundingBox &b) {
  using ::std::swap;
  swap(a.xmin, b.xmin);
  swap(a.xmax, b.xmax);
  swap(a.ymin, b.ymin);
  swap(a.ymax, b.ymax);
  swap(a.zmin, b.zmin);
  swap(a.zmax, b.zmax);
  swap(a.mmin, b.mmin);
  swap(a.mmax, b.mmax);
  swap(a.__isset, b.__isset);
}

BoundingBox::BoundingBox(const BoundingBox& other16) noexcept {
  xmin = other16.xmin;
  xmax = other16.xmax;
  ymin = other16.ymin;
  ymax = other16.ymax;
  zmin = other16.zmin;
  zmax = other16.zmax;
  mmin = other16.mmin;
  mmax = other16.mmax;
  __isset = other16.__isset;
}
BoundingBox::BoundingBox(BoundingBox&& other17) noexcept {
  xmin = other17.xmin;
  xmax = other17.xmax;
  ymin = other17.ymin;
  ymax = other17.ymax;
  zmin = other17.zmin;
  zmax = other17.zmax;
  mmin = other17.mmin;
  mmax = other17.mmax;
  __isset = other17.__isset;
}
BoundingBox& BoundingBox::operator=(const BoundingBox& other18) noexcept {
  xmin = other18.xmin;
  xmax = other18.xmax;
  ymin = other18.ymin;
  ymax = other18.ymax;
  zmin = other18.zmin;
  zmax = other18.zmax;
  mmin = other18.mmin;
  mmax = other18.mmax;
  __isset = other18.__isset;
  return *this;
}
BoundingBox& BoundingBox::operator=(BoundingBox&& other19) noexcept {
  xmin = other19.xmin;
  xmax = other19.xmax;
  ymin = other19.ymin;
  ymax = other19.ymax;
  zmin = other19.zmin;
  zmax = other19.zmax;
  mmin = other19.mmin;
  mmax = other19.mmax;
  __isset = other19.__isset;
  return *this;
}
void BoundingBox::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "BoundingBox(";
  out << "xmin=" << to_string(xmin);
  out << ", " << "xmax=" << to_string(xmax);
  out << ", " << "ymin=" << to_string(ymin);
  out << ", " << "ymax=" << to_string(ymax);
  out << ", " << "zmin="; (__isset.zmin ? (out << to_string(zmin)) : (out << "<null>"));
  out << ", " << "zmax="; (__isset.zmax ? (out << to_string(zmax)) : (out << "<null>"));
  out << ", " << "mmin="; (__isset.mmin ? (out << to_string(mmin)) : (out << "<null>"));
  out << ", " << "mmax="; (__isset.mmax ? (out << to_string(mmax)) : (out << "<null>"));
  out << ")";
}


GeospatialStatistics::~GeospatialStatistics() noexcept {
}

GeospatialStatistics::GeospatialStatistics() noexcept {
}

void GeospatialStatistics::__set_bbox(const BoundingBox& val) {
  this->bbox = val;
__isset.bbox = true;
}

void GeospatialStatistics::__set_geospatial_types(const duckdb::vector<int32_t> & val) {
  this->geospatial_types = val;
__isset.geospatial_types = true;
}
std::ostream& operator<<(std::ostream& out, const GeospatialStatistics& obj)
{
  obj.printTo(out);
  return out;
}


uint32_t GeospatialStatistics::read(::apache::thrift::protocol::TProtocol* iprot) {

  ::apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;


  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->bbox.read(iprot);
          this->__isset.bbox = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->geospatial_types.clear();
            uint32_t _size20;
            ::apache::thrift::protocol::TType _etype23;
            xfer += iprot->readListBegin(_etype23, _size20);
            this->geospatial_types.resize(_size20);
            uint32_t _i24;
            for (_i24 = 0; _i24 < _size20; ++_i24)
            {
              xfer += iprot->readI32(this->geospatial_types[_i24]);
            }
            xfer += iprot->readListEnd();
          }
          this->__isset.geospatial_types = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  return xfer;
}

uint32_t GeospatialStatistics::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  ::apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("GeospatialStatistics");

  if (this->__isset.bbox) {
    xfer += oprot->writeFieldBegin("bbox", ::apache::thrift::protocol::T_STRUCT, 1);
    xfer += this->bbox.write(oprot);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.geospatial_types) {
    xfer += oprot->writeFieldBegin("geospatial_types", ::apache::thrift::protocol::T_LIST, 2);
    {
      xfer += oprot->writeListBegin(::apache::thrift::protocol::T_I32, static_cast<uint32_t>(this->geospatial_types.size()));
      duckdb::vector<int32_t> ::const_iterator _iter25;
      for (_iter25 = this->geospatial_types.begin(); _iter25 != this->geospatial_types.end(); ++_iter25)
      {
        xfer += oprot->writeI32((*_iter25));
      }
      xfer += oprot->writeListEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(GeospatialStatistics &a, GeospatialStatistics &b) {
  using ::std::swap;
  swap(a.bbox, b.bbox);
  swap(a.geospatial_types, b.geospatial_types);
  swap(a.__isset, b.__isset);
}

GeospatialStatistics::GeospatialStatistics(const GeospatialStatistics& other26) {
  bbox = other26.bbox;
  geospatial_types = other26.geospatial_types;
  __isset = other26.__isset;
}
GeospatialStatistics::GeospatialStatistics(GeospatialStatistics&& other27) noexcept {
  bbox = std::move(other27.bbox);
  geospatial_types = std::move(other27.geospatial_types);
  __isset = other27.__isset;
}
GeospatialStatistics& GeospatialStatistics::operator=(const GeospatialStatistics& other28) {
  bbox = other28.bbox;
  geospatial_types = other28.geospatial_types;
  __isset = other28.__isset;
  return *this;
}
GeospatialStatistics& GeospatialStatistics::operator=(GeospatialStatistics&& other29) noexcept {
  bbox = std::move(other29.bbox);
  geospatial_types = std::move(other29.geospatial_types);
  __isset = other29.__isset;
  return *this;
}
void GeospatialStatistics::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "GeospatialStatistics(";
  out << "bbox="; (__isset.bbox ? (out << to_string(bbox)) : (out << "<null>"));
  out << ", " << "geospatial_types="; (__isset.geospatial_types ? (out << to_string(geospatial_types)) : (out << "<null>"));
  out << ")";
}


Statistics::~Statistics() noexcept {
}

Statistics::Statistics() noexcept
   : max(),
     min(),
     null_count(0),
     distinct_count(0),
     max_value(),
     min_value(),
     is_max_value_exact(0),
     is_min_value_exact(0) {
}

void Statistics::__set_max(const std::string& val) {
  this->max = val;
__isset.max = true;
}

void Statistics::__set_min(const std::string& val) {
  this->min = val;
__isset.min = true;
}

void Statistics::__set_null_count(const int64_t val) {
  this->null_count = val;
__isset.null_count = true;
}

void Statistics::__set_distinct_count(const int64_t val) {
  this->distinct_count = val;
__isset.distinct_count = true;
}

void Statistics::__set_max_value(const std::string& val) {
  this->max_value = val;
__isset.max_value = true;
}

void Statistics::__set_min_value(const std::string& val) {
  this->min_value = val;
__isset.min_value = true;
}

void Statistics::__set_is_max_value_exact(const bool val) {
  this->is_max_value_exact = val;
__isset.is_max_value_exact = true;
}

void Statistics::__set_is_min_value_exact(const bool val) {
  this->is_min_value_exact = val;
__isset.is_min_value_exact = true;
}
std::ostream& operator<<(std::ostream& out, const Statistics& obj)
{
  obj.printTo(out);
  return out;
}


uint32_t Statistics::read(::apache::thrift::protocol::TProtocol* iprot) {

  ::apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;


  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readBinary(this->max);
          this->__isset.max = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readBinary(this->min);
          this->__isset.min = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_I64) {
          xfer += iprot->readI64(this->null_count);
          this->__isset.null_count = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 4:
        if (ftype == ::apache::thrift::protocol::T_I64) {
          xfer += iprot->readI64(this->distinct_count);
          this->__isset.distinct_count = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 5:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readBinary(this->max_value);
          this->__isset.max_value = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 6:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readBinary(this->min_value);
          this->__isset.min_value = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 7:
        if (ftype == ::apache::thrift::protocol::T_BOOL) {
          xfer += iprot->readBool(this->is_max_value_exact);
          this->__isset.is_max_value_exact = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 8:
        if (ftype == ::apache::thrift::protocol::T_BOOL) {
          xfer += iprot->readBool(this->is_min_value_exact);
          this->__isset.is_min_value_exact = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  return xfer;
}

uint32_t Statistics::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  ::apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("Statistics");

  if (this->__isset.max) {
    xfer += oprot->writeFieldBegin("max", ::apache::thrift::protocol::T_STRING, 1);
    xfer += oprot->writeBinary(this->max);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.min) {
    xfer += oprot->writeFieldBegin("min", ::apache::thrift::protocol::T_STRING, 2);
    xfer += oprot->writeBinary(this->min);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.null_count) {
    xfer += oprot->writeFieldBegin("null_count", ::apache::thrift::protocol::T_I64, 3);
    xfer += oprot->writeI64(this->null_count);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.distinct_count) {
    xfer += oprot->writeFieldBegin("distinct_count", ::apache::thrift::protocol::T_I64, 4);
    xfer += oprot->writeI64(this->distinct_count);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.max_value) {
    xfer += oprot->writeFieldBegin("max_value", ::apache::thrift::protocol::T_STRING, 5);
    xfer += oprot->writeBinary(this->max_value);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.min_value) {
    xfer += oprot->writeFieldBegin("min_value", ::apache::thrift::protocol::T_STRING, 6);
    xfer += oprot->writeBinary(this->min_value);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.is_max_value_exact) {
    xfer += oprot->writeFieldBegin("is_max_value_exact", ::apache::thrift::protocol::T_BOOL, 7);
    xfer += oprot->writeBool(this->is_max_value_exact);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.is_min_value_exact) {
    xfer += oprot->writeFieldBegin("is_min_value_exact", ::apache::thrift::protocol::T_BOOL, 8);
    xfer += oprot->writeBool(this->is_min_value_exact);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(Statistics &a, Statistics &b) {
  using ::std::swap;
  swap(a.max, b.max);
  swap(a.min, b.min);
  swap(a.null_count, b.null_count);
  swap(a.distinct_count, b.distinct_count);
  swap(a.max_value, b.max_value);
  swap(a.min_value, b.min_value);
  swap(a.is_max_value_exact, b.is_max_value_exact);
  swap(a.is_min_value_exact, b.is_min_value_exact);
  swap(a.__isset, b.__isset);
}

Statistics::Statistics(const Statistics& other30) {
  max = other30.max;
  min = other30.min;
  null_count = other30.null_count;
  distinct_count = other30.distinct_count;
  max_value = other30.max_value;
  min_value = other30.min_value;
  is_max_value_exact = other30.is_max_value_exact;
  is_min_value_exact = other30.is_min_value_exact;
  __isset = other30.__isset;
}
Statistics::Statistics(Statistics&& other31) noexcept {
  max = std::move(other31.max);
  min = std::move(other31.min);
  null_count = other31.null_count;
  distinct_count = other31.distinct_count;
  max_value = std::move(other31.max_value);
  min_value = std::move(other31.min_value);
  is_max_value_exact = other31.is_max_value_exact;
  is_min_value_exact = other31.is_min_value_exact;
  __isset = other31.__isset;
}
Statistics& Statistics::operator=(const Statistics& other32) {
  max = other32.max;
  min = other32.min;
  null_count = other32.null_count;
  distinct_count = other32.distinct_count;
  max_value = other32.max_value;
  min_value = other32.min_value;
  is_max_value_exact = other32.is_max_value_exact;
  is_min_value_exact = other32.is_min_value_exact;
  __isset = other32.__isset;
  return *this;
}
Statistics& Statistics::operator=(Statistics&& other33) noexcept {
  max = std::move(other33.max);
  min = std::move(other33.min);
  null_count = other33.null_count;
  distinct_count = other33.distinct_count;
  max_value = std::move(other33.max_value);
  min_value = std::move(other33.min_value);
  is_max_value_exact = other33.is_max_value_exact;
  is_min_value_exact = other33.is_min_value_exact;
  __isset = other33.__isset;
  return *this;
}
void Statistics::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "Statistics(";
  out << "max="; (__isset.max ? (out << to_string(max)) : (out << "<null>"));
  out << ", " << "min="; (__isset.min ? (out << to_string(min)) : (out << "<null>"));
  out << ", " << "null_count="; (__isset.null_count ? (out << to_string(null_count)) : (out << "<null>"));
  out << ", " << "distinct_count="; (__isset.distinct_count ? (out << to_string(distinct_count)) : (out << "<null>"));
  out << ", " << "max_value="; (__isset.max_value ? (out << to_string(max_value)) : (out << "<null>"));
  out << ", " << "min_value="; (__isset.min_value ? (out << to_string(min_value)) : (out << "<null>"));
  out << ", " << "is_max_value_exact="; (__isset.is_max_value_exact ? (out << to_string(is_max_value_exact)) : (out << "<null>"));
  out << ", " << "is_min_value_exact="; (__isset.is_min_value_exact ? (out << to_string(is_min_value_exact)) : (out << "<null>"));
  out << ")";
}


StringType::~StringType() noexcept {
}

StringType::StringType() noexcept {
}
std::ostream& operator<<(std::ostream& out, const StringType& obj)
{
  obj.printTo(out);
  return out;
}


uint32_t StringType::read(::apache::thrift::protocol::TProtocol* iprot) {

  ::apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;


  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    xfer += iprot->skip(ftype);
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  return xfer;
}

uint32_t StringType::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  ::apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("StringType");

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(StringType &a, StringType &b) {
  using ::std::swap;
  (void) a;
  (void) b;
}

StringType::StringType(const StringType& other34) noexcept {
  (void) other34;
}
StringType::StringType(StringType&& other35) noexcept {
  (void) other35;
}
StringType& StringType::operator=(const StringType& other36) noexcept {
  (void) other36;
  return *this;
}
StringType& StringType::operator=(StringType&& other37) noexcept {
  (void) other37;
  return *this;
}
void StringType::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "StringType(";
  out << ")";
}


UUIDType::~UUIDType() noexcept {
}

UUIDType::UUIDType() noexcept {
}
std::ostream& operator<<(std::ostream& out, const UUIDType& obj)
{
  obj.printTo(out);
  return out;
}


uint32_t UUIDType::read(::apache::thrift::protocol::TProtocol* iprot) {

  ::apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;


  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    xfer += iprot->skip(ftype);
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  return xfer;
}

uint32_t UUIDType::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  ::apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("UUIDType");

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(UUIDType &a, UUIDType &b) {
  using ::std::swap;
  (void) a;
  (void) b;
}

UUIDType::UUIDType(const UUIDType& other38) noexcept {
  (void) other38;
}
UUIDType::UUIDType(UUIDType&& other39) noexcept {
  (void) other39;
}
UUIDType& UUIDType::operator=(const UUIDType& other40) noexcept {
  (void) other40;
  return *this;
}
UUIDType& UUIDType::operator=(UUIDType&& other41) noexcept {
  (void) other41;
  return *this;
}
void UUIDType::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "UUIDType(";
  out << ")";
}


MapType::~MapType() noexcept {
}

MapType::MapType() noexcept {
}
std::ostream& operator<<(std::ostream& out, const MapType& obj)
{
  obj.printTo(out);
  return out;
}


uint32_t MapType::read(::apache::thrift::protocol::TProtocol* iprot) {

  ::apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;


  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    xfer += iprot->skip(ftype);
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  return xfer;
}

uint32_t MapType::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  ::apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("MapType");

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(MapType &a, MapType &b) {
  using ::std::swap;
  (void) a;
  (void) b;
}

MapType::MapType(const MapType& other42) noexcept {
  (void) other42;
}
MapType::MapType(MapType&& other43) noexcept {
  (void) other43;
}
MapType& MapType::operator=(const MapType& other44) noexcept {
  (void) other44;
  return *this;
}
MapType& MapType::operator=(MapType&& other45) noexcept {
  (void) other45;
  return *this;
}
void MapType::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "MapType(";
  out << ")";
}


ListType::~ListType() noexcept {
}

ListType::ListType() noexcept {
}
std::ostream& operator<<(std::ostream& out, const ListType& obj)
{
  obj.printTo(out);
  return out;
}


uint32_t ListType::read(::apache::thrift::protocol::TProtocol* iprot) {

  ::apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;


  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    xfer += iprot->skip(ftype);
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  return xfer;
}

uint32_t ListType::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  ::apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("ListType");

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(ListType &a, ListType &b) {
  using ::std::swap;
  (void) a;
  (void) b;
}

ListType::ListType(const ListType& other46) noexcept {
  (void) other46;
}
ListType::ListType(ListType&& other47) noexcept {
  (void) other47;
}
ListType& ListType::operator=(const ListType& other48) noexcept {
  (void) other48;
  return *this;
}
ListType& ListType::operator=(ListType&& other49) noexcept {
  (void) other49;
  return *this;
}
void ListType::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "ListType(";
  out << ")";
}


EnumType::~EnumType() noexcept {
}

EnumType::EnumType() noexcept {
}
std::ostream& operator<<(std::ostream& out, const EnumType& obj)
{
  obj.printTo(out);
  return out;
}


uint32_t EnumType::read(::apache::thrift::protocol::TProtocol* iprot) {

  ::apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;


  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    xfer += iprot->skip(ftype);
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  return xfer;
}

uint32_t EnumType::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  ::apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("EnumType");

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(EnumType &a, EnumType &b) {
  using ::std::swap;
  (void) a;
  (void) b;
}

EnumType::EnumType(const EnumType& other50) noexcept {
  (void) other50;
}
EnumType::EnumType(EnumType&& other51) noexcept {
  (void) other51;
}
EnumType& EnumType::operator=(const EnumType& other52) noexcept {
  (void) other52;
  return *this;
}
EnumType& EnumType::operator=(EnumType&& other53) noexcept {
  (void) other53;
  return *this;
}
void EnumType::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "EnumType(";
  out << ")";
}


DateType::~DateType() noexcept {
}

DateType::DateType() noexcept {
}
std::ostream& operator<<(std::ostream& out, const DateType& obj)
{
  obj.printTo(out);
  return out;
}


uint32_t DateType::read(::apache::thrift::protocol::TProtocol* iprot) {

  ::apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;


  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    xfer += iprot->skip(ftype);
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  return xfer;
}

uint32_t DateType::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  ::apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("DateType");

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(DateType &a, DateType &b) {
  using ::std::swap;
  (void) a;
  (void) b;
}

DateType::DateType(const DateType& other54) noexcept {
  (void) other54;
}
DateType::DateType(DateType&& other55) noexcept {
  (void) other55;
}
DateType& DateType::operator=(const DateType& other56) noexcept {
  (void) other56;
  return *this;
}
DateType& DateType::operator=(DateType&& other57) noexcept {
  (void) other57;
  return *this;
}
void DateType::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "DateType(";
  out << ")";
}


Float16Type::~Float16Type() noexcept {
}

Float16Type::Float16Type() noexcept {
}
std::ostream& operator<<(std::ostream& out, const Float16Type& obj)
{
  obj.printTo(out);
  return out;
}


uint32_t Float16Type::read(::apache::thrift::protocol::TProtocol* iprot) {

  ::apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;


  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    xfer += iprot->skip(ftype);
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  return xfer;
}

uint32_t Float16Type::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  ::apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("Float16Type");

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(Float16Type &a, Float16Type &b) {
  using ::std::swap;
  (void) a;
  (void) b;
}

Float16Type::Float16Type(const Float16Type& other58) noexcept {
  (void) other58;
}
Float16Type::Float16Type(Float16Type&& other59) noexcept {
  (void) other59;
}
Float16Type& Float16Type::operator=(const Float16Type& other60) noexcept {
  (void) other60;
  return *this;
}
Float16Type& Float16Type::operator=(Float16Type&& other61) noexcept {
  (void) other61;
  return *this;
}
void Float16Type::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "Float16Type(";
  out << ")";
}


NullType::~NullType() noexcept {
}

NullType::NullType() noexcept {
}
std::ostream& operator<<(std::ostream& out, const NullType& obj)
{
  obj.printTo(out);
  return out;
}


uint32_t NullType::read(::apache::thrift::protocol::TProtocol* iprot) {

  ::apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;


  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    xfer += iprot->skip(ftype);
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  return xfer;
}

uint32_t NullType::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  ::apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("NullType");

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(NullType &a, NullType &b) {
  using ::std::swap;
  (void) a;
  (void) b;
}

NullType::NullType(const NullType& other62) noexcept {
  (void) other62;
}
NullType::NullType(NullType&& other63) noexcept {
  (void) other63;
}
NullType& NullType::operator=(const NullType& other64) noexcept {
  (void) other64;
  return *this;
}
NullType& NullType::operator=(NullType&& other65) noexcept {
  (void) other65;
  return *this;
}
void NullType::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "NullType(";
  out << ")";
}


DecimalType::~DecimalType() noexcept {
}

DecimalType::DecimalType() noexcept
   : scale(0),
     precision(0) {
}

void DecimalType::__set_scale(const int32_t val) {
  this->scale = val;
}

void DecimalType::__set_precision(const int32_t val) {
  this->precision = val;
}
std::ostream& operator<<(std::ostream& out, const DecimalType& obj)
{
  obj.printTo(out);
  return out;
}


uint32_t DecimalType::read(::apache::thrift::protocol::TProtocol* iprot) {

  ::apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_scale = false;
  bool isset_precision = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->scale);
          isset_scale = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->precision);
          isset_precision = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_scale)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_precision)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t DecimalType::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  ::apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("DecimalType");

  xfer += oprot->writeFieldBegin("scale", ::apache::thrift::protocol::T_I32, 1);
  xfer += oprot->writeI32(this->scale);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("precision", ::apache::thrift::protocol::T_I32, 2);
  xfer += oprot->writeI32(this->precision);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(DecimalType &a, DecimalType &b) {
  using ::std::swap;
  swap(a.scale, b.scale);
  swap(a.precision, b.precision);
}

DecimalType::DecimalType(const DecimalType& other66) noexcept {
  scale = other66.scale;
  precision = other66.precision;
}
DecimalType::DecimalType(DecimalType&& other67) noexcept {
  scale = other67.scale;
  precision = other67.precision;
}
DecimalType& DecimalType::operator=(const DecimalType& other68) noexcept {
  scale = other68.scale;
  precision = other68.precision;
  return *this;
}
DecimalType& DecimalType::operator=(DecimalType&& other69) noexcept {
  scale = other69.scale;
  precision = other69.precision;
  return *this;
}
void DecimalType::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "DecimalType(";
  out << "scale=" << to_string(scale);
  out << ", " << "precision=" << to_string(precision);
  out << ")";
}


MilliSeconds::~MilliSeconds() noexcept {
}

MilliSeconds::MilliSeconds() noexcept {
}
std::ostream& operator<<(std::ostream& out, const MilliSeconds& obj)
{
  obj.printTo(out);
  return out;
}


uint32_t MilliSeconds::read(::apache::thrift::protocol::TProtocol* iprot) {

  ::apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;


  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    xfer += iprot->skip(ftype);
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  return xfer;
}

uint32_t MilliSeconds::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  ::apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("MilliSeconds");

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(MilliSeconds &a, MilliSeconds &b) {
  using ::std::swap;
  (void) a;
  (void) b;
}

MilliSeconds::MilliSeconds(const MilliSeconds& other70) noexcept {
  (void) other70;
}
MilliSeconds::MilliSeconds(MilliSeconds&& other71) noexcept {
  (void) other71;
}
MilliSeconds& MilliSeconds::operator=(const MilliSeconds& other72) noexcept {
  (void) other72;
  return *this;
}
MilliSeconds& MilliSeconds::operator=(MilliSeconds&& other73) noexcept {
  (void) other73;
  return *this;
}
void MilliSeconds::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "MilliSeconds(";
  out << ")";
}


MicroSeconds::~MicroSeconds() noexcept {
}

MicroSeconds::MicroSeconds() noexcept {
}
std::ostream& operator<<(std::ostream& out, const MicroSeconds& obj)
{
  obj.printTo(out);
  return out;
}


uint32_t MicroSeconds::read(::apache::thrift::protocol::TProtocol* iprot) {

  ::apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;


  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    xfer += iprot->skip(ftype);
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  return xfer;
}

uint32_t MicroSeconds::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  ::apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("MicroSeconds");

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(MicroSeconds &a, MicroSeconds &b) {
  using ::std::swap;
  (void) a;
  (void) b;
}

MicroSeconds::MicroSeconds(const MicroSeconds& other74) noexcept {
  (void) other74;
}
MicroSeconds::MicroSeconds(MicroSeconds&& other75) noexcept {
  (void) other75;
}
MicroSeconds& MicroSeconds::operator=(const MicroSeconds& other76) noexcept {
  (void) other76;
  return *this;
}
MicroSeconds& MicroSeconds::operator=(MicroSeconds&& other77) noexcept {
  (void) other77;
  return *this;
}
void MicroSeconds::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "MicroSeconds(";
  out << ")";
}


NanoSeconds::~NanoSeconds() noexcept {
}

NanoSeconds::NanoSeconds() noexcept {
}
std::ostream& operator<<(std::ostream& out, const NanoSeconds& obj)
{
  obj.printTo(out);
  return out;
}


uint32_t NanoSeconds::read(::apache::thrift::protocol::TProtocol* iprot) {

  ::apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;


  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    xfer += iprot->skip(ftype);
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  return xfer;
}

uint32_t NanoSeconds::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  ::apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("NanoSeconds");

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(NanoSeconds &a, NanoSeconds &b) {
  using ::std::swap;
  (void) a;
  (void) b;
}

NanoSeconds::NanoSeconds(const NanoSeconds& other78) noexcept {
  (void) other78;
}
NanoSeconds::NanoSeconds(NanoSeconds&& other79) noexcept {
  (void) other79;
}
NanoSeconds& NanoSeconds::operator=(const NanoSeconds& other80) noexcept {
  (void) other80;
  return *this;
}
NanoSeconds& NanoSeconds::operator=(NanoSeconds&& other81) noexcept {
  (void) other81;
  return *this;
}
void NanoSeconds::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "NanoSeconds(";
  out << ")";
}


TimeUnit::~TimeUnit() noexcept {
}

TimeUnit::TimeUnit() noexcept {
}

void TimeUnit::__set_MILLIS(const MilliSeconds& val) {
  this->MILLIS = val;
__isset.MILLIS = true;
}

void TimeUnit::__set_MICROS(const MicroSeconds& val) {
  this->MICROS = val;
__isset.MICROS = true;
}

void TimeUnit::__set_NANOS(const NanoSeconds& val) {
  this->NANOS = val;
__isset.NANOS = true;
}
std::ostream& operator<<(std::ostream& out, const TimeUnit& obj)
{
  obj.printTo(out);
  return out;
}


uint32_t TimeUnit::read(::apache::thrift::protocol::TProtocol* iprot) {

  ::apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;


  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->MILLIS.read(iprot);
          this->__isset.MILLIS = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->MICROS.read(iprot);
          this->__isset.MICROS = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->NANOS.read(iprot);
          this->__isset.NANOS = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  return xfer;
}

uint32_t TimeUnit::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  ::apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("TimeUnit");

  if (this->__isset.MILLIS) {
    xfer += oprot->writeFieldBegin("MILLIS", ::apache::thrift::protocol::T_STRUCT, 1);
    xfer += this->MILLIS.write(oprot);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.MICROS) {
    xfer += oprot->writeFieldBegin("MICROS", ::apache::thrift::protocol::T_STRUCT, 2);
    xfer += this->MICROS.write(oprot);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.NANOS) {
    xfer += oprot->writeFieldBegin("NANOS", ::apache::thrift::protocol::T_STRUCT, 3);
    xfer += this->NANOS.write(oprot);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(TimeUnit &a, TimeUnit &b) {
  using ::std::swap;
  swap(a.MILLIS, b.MILLIS);
  swap(a.MICROS, b.MICROS);
  swap(a.NANOS, b.NANOS);
  swap(a.__isset, b.__isset);
}

TimeUnit::TimeUnit(const TimeUnit& other82) noexcept {
  MILLIS = other82.MILLIS;
  MICROS = other82.MICROS;
  NANOS = other82.NANOS;
  __isset = other82.__isset;
}
TimeUnit::TimeUnit(TimeUnit&& other83) noexcept {
  MILLIS = std::move(other83.MILLIS);
  MICROS = std::move(other83.MICROS);
  NANOS = std::move(other83.NANOS);
  __isset = other83.__isset;
}
TimeUnit& TimeUnit::operator=(const TimeUnit& other84) noexcept {
  MILLIS = other84.MILLIS;
  MICROS = other84.MICROS;
  NANOS = other84.NANOS;
  __isset = other84.__isset;
  return *this;
}
TimeUnit& TimeUnit::operator=(TimeUnit&& other85) noexcept {
  MILLIS = std::move(other85.MILLIS);
  MICROS = std::move(other85.MICROS);
  NANOS = std::move(other85.NANOS);
  __isset = other85.__isset;
  return *this;
}
void TimeUnit::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "TimeUnit(";
  out << "MILLIS="; (__isset.MILLIS ? (out << to_string(MILLIS)) : (out << "<null>"));
  out << ", " << "MICROS="; (__isset.MICROS ? (out << to_string(MICROS)) : (out << "<null>"));
  out << ", " << "NANOS="; (__isset.NANOS ? (out << to_string(NANOS)) : (out << "<null>"));
  out << ")";
}


TimestampType::~TimestampType() noexcept {
}

TimestampType::TimestampType() noexcept
   : isAdjustedToUTC(0) {
}

void TimestampType::__set_isAdjustedToUTC(const bool val) {
  this->isAdjustedToUTC = val;
}

void TimestampType::__set_unit(const TimeUnit& val) {
  this->unit = val;
}
std::ostream& operator<<(std::ostream& out, const TimestampType& obj)
{
  obj.printTo(out);
  return out;
}


uint32_t TimestampType::read(::apache::thrift::protocol::TProtocol* iprot) {

  ::apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_isAdjustedToUTC = false;
  bool isset_unit = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_BOOL) {
          xfer += iprot->readBool(this->isAdjustedToUTC);
          isset_isAdjustedToUTC = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->unit.read(iprot);
          isset_unit = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_isAdjustedToUTC)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_unit)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t TimestampType::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  ::apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("TimestampType");

  xfer += oprot->writeFieldBegin("isAdjustedToUTC", ::apache::thrift::protocol::T_BOOL, 1);
  xfer += oprot->writeBool(this->isAdjustedToUTC);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("unit", ::apache::thrift::protocol::T_STRUCT, 2);
  xfer += this->unit.write(oprot);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(TimestampType &a, TimestampType &b) {
  using ::std::swap;
  swap(a.isAdjustedToUTC, b.isAdjustedToUTC);
  swap(a.unit, b.unit);
}

TimestampType::TimestampType(const TimestampType& other86) noexcept {
  isAdjustedToUTC = other86.isAdjustedToUTC;
  unit = other86.unit;
}
TimestampType::TimestampType(TimestampType&& other87) noexcept {
  isAdjustedToUTC = other87.isAdjustedToUTC;
  unit = std::move(other87.unit);
}
TimestampType& TimestampType::operator=(const TimestampType& other88) noexcept {
  isAdjustedToUTC = other88.isAdjustedToUTC;
  unit = other88.unit;
  return *this;
}
TimestampType& TimestampType::operator=(TimestampType&& other89) noexcept {
  isAdjustedToUTC = other89.isAdjustedToUTC;
  unit = std::move(other89.unit);
  return *this;
}
void TimestampType::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "TimestampType(";
  out << "isAdjustedToUTC=" << to_string(isAdjustedToUTC);
  out << ", " << "unit=" << to_string(unit);
  out << ")";
}


TimeType::~TimeType() noexcept {
}

TimeType::TimeType() noexcept
   : isAdjustedToUTC(0) {
}

void TimeType::__set_isAdjustedToUTC(const bool val) {
  this->isAdjustedToUTC = val;
}

void TimeType::__set_unit(const TimeUnit& val) {
  this->unit = val;
}
std::ostream& operator<<(std::ostream& out, const TimeType& obj)
{
  obj.printTo(out);
  return out;
}


uint32_t TimeType::read(::apache::thrift::protocol::TProtocol* iprot) {

  ::apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_isAdjustedToUTC = false;
  bool isset_unit = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_BOOL) {
          xfer += iprot->readBool(this->isAdjustedToUTC);
          isset_isAdjustedToUTC = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->unit.read(iprot);
          isset_unit = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_isAdjustedToUTC)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_unit)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t TimeType::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  ::apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("TimeType");

  xfer += oprot->writeFieldBegin("isAdjustedToUTC", ::apache::thrift::protocol::T_BOOL, 1);
  xfer += oprot->writeBool(this->isAdjustedToUTC);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("unit", ::apache::thrift::protocol::T_STRUCT, 2);
  xfer += this->unit.write(oprot);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(TimeType &a, TimeType &b) {
  using ::std::swap;
  swap(a.isAdjustedToUTC, b.isAdjustedToUTC);
  swap(a.unit, b.unit);
}

TimeType::TimeType(const TimeType& other90) noexcept {
  isAdjustedToUTC = other90.isAdjustedToUTC;
  unit = other90.unit;
}
TimeType::TimeType(TimeType&& other91) noexcept {
  isAdjustedToUTC = other91.isAdjustedToUTC;
  unit = std::move(other91.unit);
}
TimeType& TimeType::operator=(const TimeType& other92) noexcept {
  isAdjustedToUTC = other92.isAdjustedToUTC;
  unit = other92.unit;
  return *this;
}
TimeType& TimeType::operator=(TimeType&& other93) noexcept {
  isAdjustedToUTC = other93.isAdjustedToUTC;
  unit = std::move(other93.unit);
  return *this;
}
void TimeType::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "TimeType(";
  out << "isAdjustedToUTC=" << to_string(isAdjustedToUTC);
  out << ", " << "unit=" << to_string(unit);
  out << ")";
}


IntType::~IntType() noexcept {
}

IntType::IntType() noexcept
   : bitWidth(0),
     isSigned(0) {
}

void IntType::__set_bitWidth(const int8_t val) {
  this->bitWidth = val;
}

void IntType::__set_isSigned(const bool val) {
  this->isSigned = val;
}
std::ostream& operator<<(std::ostream& out, const IntType& obj)
{
  obj.printTo(out);
  return out;
}


uint32_t IntType::read(::apache::thrift::protocol::TProtocol* iprot) {

  ::apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_bitWidth = false;
  bool isset_isSigned = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_BYTE) {
          xfer += iprot->readByte(this->bitWidth);
          isset_bitWidth = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_BOOL) {
          xfer += iprot->readBool(this->isSigned);
          isset_isSigned = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_bitWidth)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_isSigned)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t IntType::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  ::apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("IntType");

  xfer += oprot->writeFieldBegin("bitWidth", ::apache::thrift::protocol::T_BYTE, 1);
  xfer += oprot->writeByte(this->bitWidth);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("isSigned", ::apache::thrift::protocol::T_BOOL, 2);
  xfer += oprot->writeBool(this->isSigned);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(IntType &a, IntType &b) {
  using ::std::swap;
  swap(a.bitWidth, b.bitWidth);
  swap(a.isSigned, b.isSigned);
}

IntType::IntType(const IntType& other94) noexcept {
  bitWidth = other94.bitWidth;
  isSigned = other94.isSigned;
}
IntType::IntType(IntType&& other95) noexcept {
  bitWidth = other95.bitWidth;
  isSigned = other95.isSigned;
}
IntType& IntType::operator=(const IntType& other96) noexcept {
  bitWidth = other96.bitWidth;
  isSigned = other96.isSigned;
  return *this;
}
IntType& IntType::operator=(IntType&& other97) noexcept {
  bitWidth = other97.bitWidth;
  isSigned = other97.isSigned;
  return *this;
}
void IntType::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "IntType(";
  out << "bitWidth=" << to_string(bitWidth);
  out << ", " << "isSigned=" << to_string(isSigned);
  out << ")";
}


JsonType::~JsonType() noexcept {
}

JsonType::JsonType() noexcept {
}
std::ostream& operator<<(std::ostream& out, const JsonType& obj)
{
  obj.printTo(out);
  return out;
}


uint32_t JsonType::read(::apache::thrift::protocol::TProtocol* iprot) {

  ::apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;


  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    xfer += iprot->skip(ftype);
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  return xfer;
}

uint32_t JsonType::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  ::apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("JsonType");

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(JsonType &a, JsonType &b) {
  using ::std::swap;
  (void) a;
  (void) b;
}

JsonType::JsonType(const JsonType& other98) noexcept {
  (void) other98;
}
JsonType::JsonType(JsonType&& other99) noexcept {
  (void) other99;
}
JsonType& JsonType::operator=(const JsonType& other100) noexcept {
  (void) other100;
  return *this;
}
JsonType& JsonType::operator=(JsonType&& other101) noexcept {
  (void) other101;
  return *this;
}
void JsonType::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "JsonType(";
  out << ")";
}


BsonType::~BsonType() noexcept {
}

BsonType::BsonType() noexcept {
}
std::ostream& operator<<(std::ostream& out, const BsonType& obj)
{
  obj.printTo(out);
  return out;
}


uint32_t BsonType::read(::apache::thrift::protocol::TProtocol* iprot) {

  ::apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;


  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    xfer += iprot->skip(ftype);
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  return xfer;
}

uint32_t BsonType::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  ::apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("BsonType");

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(BsonType &a, BsonType &b) {
  using ::std::swap;
  (void) a;
  (void) b;
}

BsonType::BsonType(const BsonType& other102) noexcept {
  (void) other102;
}
BsonType::BsonType(BsonType&& other103) noexcept {
  (void) other103;
}
BsonType& BsonType::operator=(const BsonType& other104) noexcept {
  (void) other104;
  return *this;
}
BsonType& BsonType::operator=(BsonType&& other105) noexcept {
  (void) other105;
  return *this;
}
void BsonType::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "BsonType(";
  out << ")";
}


VariantType::~VariantType() noexcept {
}

VariantType::VariantType() noexcept
   : specification_version(0) {
}

void VariantType::__set_specification_version(const int8_t val) {
  this->specification_version = val;
__isset.specification_version = true;
}
std::ostream& operator<<(std::ostream& out, const VariantType& obj)
{
  obj.printTo(out);
  return out;
}


uint32_t VariantType::read(::apache::thrift::protocol::TProtocol* iprot) {

  ::apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;


  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_BYTE) {
          xfer += iprot->readByte(this->specification_version);
          this->__isset.specification_version = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  return xfer;
}

uint32_t VariantType::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  ::apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("VariantType");

  if (this->__isset.specification_version) {
    xfer += oprot->writeFieldBegin("specification_version", ::apache::thrift::protocol::T_BYTE, 1);
    xfer += oprot->writeByte(this->specification_version);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(VariantType &a, VariantType &b) {
  using ::std::swap;
  swap(a.specification_version, b.specification_version);
  swap(a.__isset, b.__isset);
}

VariantType::VariantType(const VariantType& other106) noexcept {
  specification_version = other106.specification_version;
  __isset = other106.__isset;
}
VariantType::VariantType(VariantType&& other107) noexcept {
  specification_version = other107.specification_version;
  __isset = other107.__isset;
}
VariantType& VariantType::operator=(const VariantType& other108) noexcept {
  specification_version = other108.specification_version;
  __isset = other108.__isset;
  return *this;
}
VariantType& VariantType::operator=(VariantType&& other109) noexcept {
  specification_version = other109.specification_version;
  __isset = other109.__isset;
  return *this;
}
void VariantType::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "VariantType(";
  out << "specification_version="; (__isset.specification_version ? (out << to_string(specification_version)) : (out << "<null>"));
  out << ")";
}


GeometryType::~GeometryType() noexcept {
}

GeometryType::GeometryType() noexcept
   : crs() {
}

void GeometryType::__set_crs(const std::string& val) {
  this->crs = val;
__isset.crs = true;
}
std::ostream& operator<<(std::ostream& out, const GeometryType& obj)
{
  obj.printTo(out);
  return out;
}


uint32_t GeometryType::read(::apache::thrift::protocol::TProtocol* iprot) {

  ::apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;


  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->crs);
          this->__isset.crs = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  return xfer;
}

uint32_t GeometryType::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  ::apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("GeometryType");

  if (this->__isset.crs) {
    xfer += oprot->writeFieldBegin("crs", ::apache::thrift::protocol::T_STRING, 1);
    xfer += oprot->writeString(this->crs);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(GeometryType &a, GeometryType &b) {
  using ::std::swap;
  swap(a.crs, b.crs);
  swap(a.__isset, b.__isset);
}

GeometryType::GeometryType(const GeometryType& other110) {
  crs = other110.crs;
  __isset = other110.__isset;
}
GeometryType::GeometryType(GeometryType&& other111) noexcept {
  crs = std::move(other111.crs);
  __isset = other111.__isset;
}
GeometryType& GeometryType::operator=(const GeometryType& other112) {
  crs = other112.crs;
  __isset = other112.__isset;
  return *this;
}
GeometryType& GeometryType::operator=(GeometryType&& other113) noexcept {
  crs = std::move(other113.crs);
  __isset = other113.__isset;
  return *this;
}
void GeometryType::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "GeometryType(";
  out << "crs="; (__isset.crs ? (out << to_string(crs)) : (out << "<null>"));
  out << ")";
}


GeographyType::~GeographyType() noexcept {
}

GeographyType::GeographyType() noexcept
   : crs(),
     algorithm(static_cast<EdgeInterpolationAlgorithm::type>(0)) {
}

void GeographyType::__set_crs(const std::string& val) {
  this->crs = val;
__isset.crs = true;
}

void GeographyType::__set_algorithm(const EdgeInterpolationAlgorithm::type val) {
  this->algorithm = val;
__isset.algorithm = true;
}
std::ostream& operator<<(std::ostream& out, const GeographyType& obj)
{
  obj.printTo(out);
  return out;
}


uint32_t GeographyType::read(::apache::thrift::protocol::TProtocol* iprot) {

  ::apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;


  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->crs);
          this->__isset.crs = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast114;
          xfer += iprot->readI32(ecast114);
          this->algorithm = static_cast<EdgeInterpolationAlgorithm::type>(ecast114);
          this->__isset.algorithm = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  return xfer;
}

uint32_t GeographyType::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  ::apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("GeographyType");

  if (this->__isset.crs) {
    xfer += oprot->writeFieldBegin("crs", ::apache::thrift::protocol::T_STRING, 1);
    xfer += oprot->writeString(this->crs);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.algorithm) {
    xfer += oprot->writeFieldBegin("algorithm", ::apache::thrift::protocol::T_I32, 2);
    xfer += oprot->writeI32(static_cast<int32_t>(this->algorithm));
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(GeographyType &a, GeographyType &b) {
  using ::std::swap;
  swap(a.crs, b.crs);
  swap(a.algorithm, b.algorithm);
  swap(a.__isset, b.__isset);
}

GeographyType::GeographyType(const GeographyType& other115) {
  crs = other115.crs;
  algorithm = other115.algorithm;
  __isset = other115.__isset;
}
GeographyType::GeographyType(GeographyType&& other116) noexcept {
  crs = std::move(other116.crs);
  algorithm = other116.algorithm;
  __isset = other116.__isset;
}
GeographyType& GeographyType::operator=(const GeographyType& other117) {
  crs = other117.crs;
  algorithm = other117.algorithm;
  __isset = other117.__isset;
  return *this;
}
GeographyType& GeographyType::operator=(GeographyType&& other118) noexcept {
  crs = std::move(other118.crs);
  algorithm = other118.algorithm;
  __isset = other118.__isset;
  return *this;
}
void GeographyType::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "GeographyType(";
  out << "crs="; (__isset.crs ? (out << to_string(crs)) : (out << "<null>"));
  out << ", " << "algorithm="; (__isset.algorithm ? (out << to_string(algorithm)) : (out << "<null>"));
  out << ")";
}


LogicalType::~LogicalType() noexcept {
}

LogicalType::LogicalType() noexcept {
}

void LogicalType::__set_STRING(const StringType& val) {
  this->STRING = val;
__isset.STRING = true;
}

void LogicalType::__set_MAP(const MapType& val) {
  this->MAP = val;
__isset.MAP = true;
}

void LogicalType::__set_LIST(const ListType& val) {
  this->LIST = val;
__isset.LIST = true;
}

void LogicalType::__set_ENUM(const EnumType& val) {
  this->ENUM = val;
__isset.ENUM = true;
}

void LogicalType::__set_DECIMAL(const DecimalType& val) {
  this->DECIMAL = val;
__isset.DECIMAL = true;
}

void LogicalType::__set_DATE(const DateType& val) {
  this->DATE = val;
__isset.DATE = true;
}

void LogicalType::__set_TIME(const TimeType& val) {
  this->TIME = val;
__isset.TIME = true;
}

void LogicalType::__set_TIMESTAMP(const TimestampType& val) {
  this->TIMESTAMP = val;
__isset.TIMESTAMP = true;
}

void LogicalType::__set_INTEGER(const IntType& val) {
  this->INTEGER = val;
__isset.INTEGER = true;
}

void LogicalType::__set_UNKNOWN(const NullType& val) {
  this->UNKNOWN = val;
__isset.UNKNOWN = true;
}

void LogicalType::__set_JSON(const JsonType& val) {
  this->JSON = val;
__isset.JSON = true;
}

void LogicalType::__set_BSON(const BsonType& val) {
  this->BSON = val;
__isset.BSON = true;
}

void LogicalType::__set_UUID(const UUIDType& val) {
  this->UUID = val;
__isset.UUID = true;
}

void LogicalType::__set_FLOAT16(const Float16Type& val) {
  this->FLOAT16 = val;
__isset.FLOAT16 = true;
}

void LogicalType::__set_VARIANT(const VariantType& val) {
  this->VARIANT = val;
__isset.VARIANT = true;
}

void LogicalType::__set_GEOMETRY(const GeometryType& val) {
  this->GEOMETRY = val;
__isset.GEOMETRY = true;
}

void LogicalType::__set_GEOGRAPHY(const GeographyType& val) {
  this->GEOGRAPHY = val;
__isset.GEOGRAPHY = true;
}
std::ostream& operator<<(std::ostream& out, const LogicalType& obj)
{
  obj.printTo(out);
  return out;
}


uint32_t LogicalType::read(::apache::thrift::protocol::TProtocol* iprot) {

  ::apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;


  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->STRING.read(iprot);
          this->__isset.STRING = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->MAP.read(iprot);
          this->__isset.MAP = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->LIST.read(iprot);
          this->__isset.LIST = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 4:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->ENUM.read(iprot);
          this->__isset.ENUM = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 5:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->DECIMAL.read(iprot);
          this->__isset.DECIMAL = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 6:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->DATE.read(iprot);
          this->__isset.DATE = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 7:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->TIME.read(iprot);
          this->__isset.TIME = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 8:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->TIMESTAMP.read(iprot);
          this->__isset.TIMESTAMP = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 10:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->INTEGER.read(iprot);
          this->__isset.INTEGER = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 11:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->UNKNOWN.read(iprot);
          this->__isset.UNKNOWN = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 12:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->JSON.read(iprot);
          this->__isset.JSON = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 13:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->BSON.read(iprot);
          this->__isset.BSON = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 14:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->UUID.read(iprot);
          this->__isset.UUID = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 15:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->FLOAT16.read(iprot);
          this->__isset.FLOAT16 = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 16:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->VARIANT.read(iprot);
          this->__isset.VARIANT = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 17:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->GEOMETRY.read(iprot);
          this->__isset.GEOMETRY = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 18:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->GEOGRAPHY.read(iprot);
          this->__isset.GEOGRAPHY = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  return xfer;
}

uint32_t LogicalType::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  ::apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("LogicalType");

  if (this->__isset.STRING) {
    xfer += oprot->writeFieldBegin("STRING", ::apache::thrift::protocol::T_STRUCT, 1);
    xfer += this->STRING.write(oprot);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.MAP) {
    xfer += oprot->writeFieldBegin("MAP", ::apache::thrift::protocol::T_STRUCT, 2);
    xfer += this->MAP.write(oprot);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.LIST) {
    xfer += oprot->writeFieldBegin("LIST", ::apache::thrift::protocol::T_STRUCT, 3);
    xfer += this->LIST.write(oprot);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.ENUM) {
    xfer += oprot->writeFieldBegin("ENUM", ::apache::thrift::protocol::T_STRUCT, 4);
    xfer += this->ENUM.write(oprot);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.DECIMAL) {
    xfer += oprot->writeFieldBegin("DECIMAL", ::apache::thrift::protocol::T_STRUCT, 5);
    xfer += this->DECIMAL.write(oprot);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.DATE) {
    xfer += oprot->writeFieldBegin("DATE", ::apache::thrift::protocol::T_STRUCT, 6);
    xfer += this->DATE.write(oprot);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.TIME) {
    xfer += oprot->writeFieldBegin("TIME", ::apache::thrift::protocol::T_STRUCT, 7);
    xfer += this->TIME.write(oprot);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.TIMESTAMP) {
    xfer += oprot->writeFieldBegin("TIMESTAMP", ::apache::thrift::protocol::T_STRUCT, 8);
    xfer += this->TIMESTAMP.write(oprot);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.INTEGER) {
    xfer += oprot->writeFieldBegin("INTEGER", ::apache::thrift::protocol::T_STRUCT, 10);
    xfer += this->INTEGER.write(oprot);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.UNKNOWN) {
    xfer += oprot->writeFieldBegin("UNKNOWN", ::apache::thrift::protocol::T_STRUCT, 11);
    xfer += this->UNKNOWN.write(oprot);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.JSON) {
    xfer += oprot->writeFieldBegin("JSON", ::apache::thrift::protocol::T_STRUCT, 12);
    xfer += this->JSON.write(oprot);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.BSON) {
    xfer += oprot->writeFieldBegin("BSON", ::apache::thrift::protocol::T_STRUCT, 13);
    xfer += this->BSON.write(oprot);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.UUID) {
    xfer += oprot->writeFieldBegin("UUID", ::apache::thrift::protocol::T_STRUCT, 14);
    xfer += this->UUID.write(oprot);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.FLOAT16) {
    xfer += oprot->writeFieldBegin("FLOAT16", ::apache::thrift::protocol::T_STRUCT, 15);
    xfer += this->FLOAT16.write(oprot);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.VARIANT) {
    xfer += oprot->writeFieldBegin("VARIANT", ::apache::thrift::protocol::T_STRUCT, 16);
    xfer += this->VARIANT.write(oprot);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.GEOMETRY) {
    xfer += oprot->writeFieldBegin("GEOMETRY", ::apache::thrift::protocol::T_STRUCT, 17);
    xfer += this->GEOMETRY.write(oprot);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.GEOGRAPHY) {
    xfer += oprot->writeFieldBegin("GEOGRAPHY", ::apache::thrift::protocol::T_STRUCT, 18);
    xfer += this->GEOGRAPHY.write(oprot);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(LogicalType &a, LogicalType &b) {
  using ::std::swap;
  swap(a.STRING, b.STRING);
  swap(a.MAP, b.MAP);
  swap(a.LIST, b.LIST);
  swap(a.ENUM, b.ENUM);
  swap(a.DECIMAL, b.DECIMAL);
  swap(a.DATE, b.DATE);
  swap(a.TIME, b.TIME);
  swap(a.TIMESTAMP, b.TIMESTAMP);
  swap(a.INTEGER, b.INTEGER);
  swap(a.UNKNOWN, b.UNKNOWN);
  swap(a.JSON, b.JSON);
  swap(a.BSON, b.BSON);
  swap(a.UUID, b.UUID);
  swap(a.FLOAT16, b.FLOAT16);
  swap(a.VARIANT, b.VARIANT);
  swap(a.GEOMETRY, b.GEOMETRY);
  swap(a.GEOGRAPHY, b.GEOGRAPHY);
  swap(a.__isset, b.__isset);
}

LogicalType::LogicalType(const LogicalType& other119) {
  STRING = other119.STRING;
  MAP = other119.MAP;
  LIST = other119.LIST;
  ENUM = other119.ENUM;
  DECIMAL = other119.DECIMAL;
  DATE = other119.DATE;
  TIME = other119.TIME;
  TIMESTAMP = other119.TIMESTAMP;
  INTEGER = other119.INTEGER;
  UNKNOWN = other119.UNKNOWN;
  JSON = other119.JSON;
  BSON = other119.BSON;
  UUID = other119.UUID;
  FLOAT16 = other119.FLOAT16;
  VARIANT = other119.VARIANT;
  GEOMETRY = other119.GEOMETRY;
  GEOGRAPHY = other119.GEOGRAPHY;
  __isset = other119.__isset;
}
LogicalType::LogicalType(LogicalType&& other120) noexcept {
  STRING = std::move(other120.STRING);
  MAP = std::move(other120.MAP);
  LIST = std::move(other120.LIST);
  ENUM = std::move(other120.ENUM);
  DECIMAL = std::move(other120.DECIMAL);
  DATE = std::move(other120.DATE);
  TIME = std::move(other120.TIME);
  TIMESTAMP = std::move(other120.TIMESTAMP);
  INTEGER = std::move(other120.INTEGER);
  UNKNOWN = std::move(other120.UNKNOWN);
  JSON = std::move(other120.JSON);
  BSON = std::move(other120.BSON);
  UUID = std::move(other120.UUID);
  FLOAT16 = std::move(other120.FLOAT16);
  VARIANT = std::move(other120.VARIANT);
  GEOMETRY = std::move(other120.GEOMETRY);
  GEOGRAPHY = std::move(other120.GEOGRAPHY);
  __isset = other120.__isset;
}
LogicalType& LogicalType::operator=(const LogicalType& other121) {
  STRING = other121.STRING;
  MAP = other121.MAP;
  LIST = other121.LIST;
  ENUM = other121.ENUM;
  DECIMAL = other121.DECIMAL;
  DATE = other121.DATE;
  TIME = other121.TIME;
  TIMESTAMP = other121.TIMESTAMP;
  INTEGER = other121.INTEGER;
  UNKNOWN = other121.UNKNOWN;
  JSON = other121.JSON;
  BSON = other121.BSON;
  UUID = other121.UUID;
  FLOAT16 = other121.FLOAT16;
  VARIANT = other121.VARIANT;
  GEOMETRY = other121.GEOMETRY;
  GEOGRAPHY = other121.GEOGRAPHY;
  __isset = other121.__isset;
  return *this;
}
LogicalType& LogicalType::operator=(LogicalType&& other122) noexcept {
  STRING = std::move(other122.STRING);
  MAP = std::move(other122.MAP);
  LIST = std::move(other122.LIST);
  ENUM = std::move(other122.ENUM);
  DECIMAL = std::move(other122.DECIMAL);
  DATE = std::move(other122.DATE);
  TIME = std::move(other122.TIME);
  TIMESTAMP = std::move(other122.TIMESTAMP);
  INTEGER = std::move(other122.INTEGER);
  UNKNOWN = std::move(other122.UNKNOWN);
  JSON = std::move(other122.JSON);
  BSON = std::move(other122.BSON);
  UUID = std::move(other122.UUID);
  FLOAT16 = std::move(other122.FLOAT16);
  VARIANT = std::move(other122.VARIANT);
  GEOMETRY = std::move(other122.GEOMETRY);
  GEOGRAPHY = std::move(other122.GEOGRAPHY);
  __isset = other122.__isset;
  return *this;
}
void LogicalType::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "LogicalType(";
  out << "STRING="; (__isset.STRING ? (out << to_string(STRING)) : (out << "<null>"));
  out << ", " << "MAP="; (__isset.MAP ? (out << to_string(MAP)) : (out << "<null>"));
  out << ", " << "LIST="; (__isset.LIST ? (out << to_string(LIST)) : (out << "<null>"));
  out << ", " << "ENUM="; (__isset.ENUM ? (out << to_string(ENUM)) : (out << "<null>"));
  out << ", " << "DECIMAL="; (__isset.DECIMAL ? (out << to_string(DECIMAL)) : (out << "<null>"));
  out << ", " << "DATE="; (__isset.DATE ? (out << to_string(DATE)) : (out << "<null>"));
  out << ", " << "TIME="; (__isset.TIME ? (out << to_string(TIME)) : (out << "<null>"));
  out << ", " << "TIMESTAMP="; (__isset.TIMESTAMP ? (out << to_string(TIMESTAMP)) : (out << "<null>"));
  out << ", " << "INTEGER="; (__isset.INTEGER ? (out << to_string(INTEGER)) : (out << "<null>"));
  out << ", " << "UNKNOWN="; (__isset.UNKNOWN ? (out << to_string(UNKNOWN)) : (out << "<null>"));
  out << ", " << "JSON="; (__isset.JSON ? (out << to_string(JSON)) : (out << "<null>"));
  out << ", " << "BSON="; (__isset.BSON ? (out << to_string(BSON)) : (out << "<null>"));
  out << ", " << "UUID="; (__isset.UUID ? (out << to_string(UUID)) : (out << "<null>"));
  out << ", " << "FLOAT16="; (__isset.FLOAT16 ? (out << to_string(FLOAT16)) : (out << "<null>"));
  out << ", " << "VARIANT="; (__isset.VARIANT ? (out << to_string(VARIANT)) : (out << "<null>"));
  out << ", " << "GEOMETRY="; (__isset.GEOMETRY ? (out << to_string(GEOMETRY)) : (out << "<null>"));
  out << ", " << "GEOGRAPHY="; (__isset.GEOGRAPHY ? (out << to_string(GEOGRAPHY)) : (out << "<null>"));
  out << ")";
}


SchemaElement::~SchemaElement() noexcept {
}

SchemaElement::SchemaElement() noexcept
   : type(static_cast<Type::type>(0)),
     type_length(0),
     repetition_type(static_cast<FieldRepetitionType::type>(0)),
     name(),
     num_children(0),
     converted_type(static_cast<ConvertedType::type>(0)),
     scale(0),
     precision(0),
     field_id(0) {
}

void SchemaElement::__set_type(const Type::type val) {
  this->type = val;
__isset.type = true;
}

void SchemaElement::__set_type_length(const int32_t val) {
  this->type_length = val;
__isset.type_length = true;
}

void SchemaElement::__set_repetition_type(const FieldRepetitionType::type val) {
  this->repetition_type = val;
__isset.repetition_type = true;
}

void SchemaElement::__set_name(const std::string& val) {
  this->name = val;
}

void SchemaElement::__set_num_children(const int32_t val) {
  this->num_children = val;
__isset.num_children = true;
}

void SchemaElement::__set_converted_type(const ConvertedType::type val) {
  this->converted_type = val;
__isset.converted_type = true;
}

void SchemaElement::__set_scale(const int32_t val) {
  this->scale = val;
__isset.scale = true;
}

void SchemaElement::__set_precision(const int32_t val) {
  this->precision = val;
__isset.precision = true;
}

void SchemaElement::__set_field_id(const int32_t val) {
  this->field_id = val;
__isset.field_id = true;
}

void SchemaElement::__set_logicalType(const LogicalType& val) {
  this->logicalType = val;
__isset.logicalType = true;
}
std::ostream& operator<<(std::ostream& out, const SchemaElement& obj)
{
  obj.printTo(out);
  return out;
}


uint32_t SchemaElement::read(::apache::thrift::protocol::TProtocol* iprot) {

  ::apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_name = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast123;
          xfer += iprot->readI32(ecast123);
          this->type = static_cast<Type::type>(ecast123);
          this->__isset.type = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->type_length);
          this->__isset.type_length = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast124;
          xfer += iprot->readI32(ecast124);
          this->repetition_type = static_cast<FieldRepetitionType::type>(ecast124);
          this->__isset.repetition_type = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 4:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->name);
          isset_name = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 5:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->num_children);
          this->__isset.num_children = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 6:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast125;
          xfer += iprot->readI32(ecast125);
          this->converted_type = static_cast<ConvertedType::type>(ecast125);
          this->__isset.converted_type = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 7:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->scale);
          this->__isset.scale = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 8:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->precision);
          this->__isset.precision = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 9:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->field_id);
          this->__isset.field_id = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 10:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->logicalType.read(iprot);
          this->__isset.logicalType = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_name)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t SchemaElement::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  ::apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("SchemaElement");

  if (this->__isset.type) {
    xfer += oprot->writeFieldBegin("type", ::apache::thrift::protocol::T_I32, 1);
    xfer += oprot->writeI32(static_cast<int32_t>(this->type));
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.type_length) {
    xfer += oprot->writeFieldBegin("type_length", ::apache::thrift::protocol::T_I32, 2);
    xfer += oprot->writeI32(this->type_length);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.repetition_type) {
    xfer += oprot->writeFieldBegin("repetition_type", ::apache::thrift::protocol::T_I32, 3);
    xfer += oprot->writeI32(static_cast<int32_t>(this->repetition_type));
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldBegin("name", ::apache::thrift::protocol::T_STRING, 4);
  xfer += oprot->writeString(this->name);
  xfer += oprot->writeFieldEnd();

  if (this->__isset.num_children) {
    xfer += oprot->writeFieldBegin("num_children", ::apache::thrift::protocol::T_I32, 5);
    xfer += oprot->writeI32(this->num_children);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.converted_type) {
    xfer += oprot->writeFieldBegin("converted_type", ::apache::thrift::protocol::T_I32, 6);
    xfer += oprot->writeI32(static_cast<int32_t>(this->converted_type));
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.scale) {
    xfer += oprot->writeFieldBegin("scale", ::apache::thrift::protocol::T_I32, 7);
    xfer += oprot->writeI32(this->scale);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.precision) {
    xfer += oprot->writeFieldBegin("precision", ::apache::thrift::protocol::T_I32, 8);
    xfer += oprot->writeI32(this->precision);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.field_id) {
    xfer += oprot->writeFieldBegin("field_id", ::apache::thrift::protocol::T_I32, 9);
    xfer += oprot->writeI32(this->field_id);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.logicalType) {
    xfer += oprot->writeFieldBegin("logicalType", ::apache::thrift::protocol::T_STRUCT, 10);
    xfer += this->logicalType.write(oprot);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(SchemaElement &a, SchemaElement &b) {
  using ::std::swap;
  swap(a.type, b.type);
  swap(a.type_length, b.type_length);
  swap(a.repetition_type, b.repetition_type);
  swap(a.name, b.name);
  swap(a.num_children, b.num_children);
  swap(a.converted_type, b.converted_type);
  swap(a.scale, b.scale);
  swap(a.precision, b.precision);
  swap(a.field_id, b.field_id);
  swap(a.logicalType, b.logicalType);
  swap(a.__isset, b.__isset);
}

SchemaElement::SchemaElement(const SchemaElement& other126) {
  type = other126.type;
  type_length = other126.type_length;
  repetition_type = other126.repetition_type;
  name = other126.name;
  num_children = other126.num_children;
  converted_type = other126.converted_type;
  scale = other126.scale;
  precision = other126.precision;
  field_id = other126.field_id;
  logicalType = other126.logicalType;
  __isset = other126.__isset;
}
SchemaElement::SchemaElement(SchemaElement&& other127) noexcept {
  type = other127.type;
  type_length = other127.type_length;
  repetition_type = other127.repetition_type;
  name = std::move(other127.name);
  num_children = other127.num_children;
  converted_type = other127.converted_type;
  scale = other127.scale;
  precision = other127.precision;
  field_id = other127.field_id;
  logicalType = std::move(other127.logicalType);
  __isset = other127.__isset;
}
SchemaElement& SchemaElement::operator=(const SchemaElement& other128) {
  type = other128.type;
  type_length = other128.type_length;
  repetition_type = other128.repetition_type;
  name = other128.name;
  num_children = other128.num_children;
  converted_type = other128.converted_type;
  scale = other128.scale;
  precision = other128.precision;
  field_id = other128.field_id;
  logicalType = other128.logicalType;
  __isset = other128.__isset;
  return *this;
}
SchemaElement& SchemaElement::operator=(SchemaElement&& other129) noexcept {
  type = other129.type;
  type_length = other129.type_length;
  repetition_type = other129.repetition_type;
  name = std::move(other129.name);
  num_children = other129.num_children;
  converted_type = other129.converted_type;
  scale = other129.scale;
  precision = other129.precision;
  field_id = other129.field_id;
  logicalType = std::move(other129.logicalType);
  __isset = other129.__isset;
  return *this;
}
void SchemaElement::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "SchemaElement(";
  out << "type="; (__isset.type ? (out << to_string(type)) : (out << "<null>"));
  out << ", " << "type_length="; (__isset.type_length ? (out << to_string(type_length)) : (out << "<null>"));
  out << ", " << "repetition_type="; (__isset.repetition_type ? (out << to_string(repetition_type)) : (out << "<null>"));
  out << ", " << "name=" << to_string(name);
  out << ", " << "num_children="; (__isset.num_children ? (out << to_string(num_children)) : (out << "<null>"));
  out << ", " << "converted_type="; (__isset.converted_type ? (out << to_string(converted_type)) : (out << "<null>"));
  out << ", " << "scale="; (__isset.scale ? (out << to_string(scale)) : (out << "<null>"));
  out << ", " << "precision="; (__isset.precision ? (out << to_string(precision)) : (out << "<null>"));
  out << ", " << "field_id="; (__isset.field_id ? (out << to_string(field_id)) : (out << "<null>"));
  out << ", " << "logicalType="; (__isset.logicalType ? (out << to_string(logicalType)) : (out << "<null>"));
  out << ")";
}


DataPageHeader::~DataPageHeader() noexcept {
}

DataPageHeader::DataPageHeader() noexcept
   : num_values(0),
     encoding(static_cast<Encoding::type>(0)),
     definition_level_encoding(static_cast<Encoding::type>(0)),
     repetition_level_encoding(static_cast<Encoding::type>(0)) {
}

void DataPageHeader::__set_num_values(const int32_t val) {
  this->num_values = val;
}

void DataPageHeader::__set_encoding(const Encoding::type val) {
  this->encoding = val;
}

void DataPageHeader::__set_definition_level_encoding(const Encoding::type val) {
  this->definition_level_encoding = val;
}

void DataPageHeader::__set_repetition_level_encoding(const Encoding::type val) {
  this->repetition_level_encoding = val;
}

void DataPageHeader::__set_statistics(const Statistics& val) {
  this->statistics = val;
__isset.statistics = true;
}
std::ostream& operator<<(std::ostream& out, const DataPageHeader& obj)
{
  obj.printTo(out);
  return out;
}


uint32_t DataPageHeader::read(::apache::thrift::protocol::TProtocol* iprot) {

  ::apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_num_values = false;
  bool isset_encoding = false;
  bool isset_definition_level_encoding = false;
  bool isset_repetition_level_encoding = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->num_values);
          isset_num_values = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast130;
          xfer += iprot->readI32(ecast130);
          this->encoding = static_cast<Encoding::type>(ecast130);
          isset_encoding = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast131;
          xfer += iprot->readI32(ecast131);
          this->definition_level_encoding = static_cast<Encoding::type>(ecast131);
          isset_definition_level_encoding = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 4:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast132;
          xfer += iprot->readI32(ecast132);
          this->repetition_level_encoding = static_cast<Encoding::type>(ecast132);
          isset_repetition_level_encoding = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 5:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->statistics.read(iprot);
          this->__isset.statistics = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_num_values)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_encoding)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_definition_level_encoding)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_repetition_level_encoding)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t DataPageHeader::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  ::apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("DataPageHeader");

  xfer += oprot->writeFieldBegin("num_values", ::apache::thrift::protocol::T_I32, 1);
  xfer += oprot->writeI32(this->num_values);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("encoding", ::apache::thrift::protocol::T_I32, 2);
  xfer += oprot->writeI32(static_cast<int32_t>(this->encoding));
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("definition_level_encoding", ::apache::thrift::protocol::T_I32, 3);
  xfer += oprot->writeI32(static_cast<int32_t>(this->definition_level_encoding));
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("repetition_level_encoding", ::apache::thrift::protocol::T_I32, 4);
  xfer += oprot->writeI32(static_cast<int32_t>(this->repetition_level_encoding));
  xfer += oprot->writeFieldEnd();

  if (this->__isset.statistics) {
    xfer += oprot->writeFieldBegin("statistics", ::apache::thrift::protocol::T_STRUCT, 5);
    xfer += this->statistics.write(oprot);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(DataPageHeader &a, DataPageHeader &b) {
  using ::std::swap;
  swap(a.num_values, b.num_values);
  swap(a.encoding, b.encoding);
  swap(a.definition_level_encoding, b.definition_level_encoding);
  swap(a.repetition_level_encoding, b.repetition_level_encoding);
  swap(a.statistics, b.statistics);
  swap(a.__isset, b.__isset);
}

DataPageHeader::DataPageHeader(const DataPageHeader& other133) {
  num_values = other133.num_values;
  encoding = other133.encoding;
  definition_level_encoding = other133.definition_level_encoding;
  repetition_level_encoding = other133.repetition_level_encoding;
  statistics = other133.statistics;
  __isset = other133.__isset;
}
DataPageHeader::DataPageHeader(DataPageHeader&& other134) noexcept {
  num_values = other134.num_values;
  encoding = other134.encoding;
  definition_level_encoding = other134.definition_level_encoding;
  repetition_level_encoding = other134.repetition_level_encoding;
  statistics = std::move(other134.statistics);
  __isset = other134.__isset;
}
DataPageHeader& DataPageHeader::operator=(const DataPageHeader& other135) {
  num_values = other135.num_values;
  encoding = other135.encoding;
  definition_level_encoding = other135.definition_level_encoding;
  repetition_level_encoding = other135.repetition_level_encoding;
  statistics = other135.statistics;
  __isset = other135.__isset;
  return *this;
}
DataPageHeader& DataPageHeader::operator=(DataPageHeader&& other136) noexcept {
  num_values = other136.num_values;
  encoding = other136.encoding;
  definition_level_encoding = other136.definition_level_encoding;
  repetition_level_encoding = other136.repetition_level_encoding;
  statistics = std::move(other136.statistics);
  __isset = other136.__isset;
  return *this;
}
void DataPageHeader::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "DataPageHeader(";
  out << "num_values=" << to_string(num_values);
  out << ", " << "encoding=" << to_string(encoding);
  out << ", " << "definition_level_encoding=" << to_string(definition_level_encoding);
  out << ", " << "repetition_level_encoding=" << to_string(repetition_level_encoding);
  out << ", " << "statistics="; (__isset.statistics ? (out << to_string(statistics)) : (out << "<null>"));
  out << ")";
}


IndexPageHeader::~IndexPageHeader() noexcept {
}

IndexPageHeader::IndexPageHeader() noexcept {
}
std::ostream& operator<<(std::ostream& out, const IndexPageHeader& obj)
{
  obj.printTo(out);
  return out;
}


uint32_t IndexPageHeader::read(::apache::thrift::protocol::TProtocol* iprot) {

  ::apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;


  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    xfer += iprot->skip(ftype);
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  return xfer;
}

uint32_t IndexPageHeader::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  ::apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("IndexPageHeader");

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(IndexPageHeader &a, IndexPageHeader &b) {
  using ::std::swap;
  (void) a;
  (void) b;
}

IndexPageHeader::IndexPageHeader(const IndexPageHeader& other137) noexcept {
  (void) other137;
}
IndexPageHeader::IndexPageHeader(IndexPageHeader&& other138) noexcept {
  (void) other138;
}
IndexPageHeader& IndexPageHeader::operator=(const IndexPageHeader& other139) noexcept {
  (void) other139;
  return *this;
}
IndexPageHeader& IndexPageHeader::operator=(IndexPageHeader&& other140) noexcept {
  (void) other140;
  return *this;
}
void IndexPageHeader::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "IndexPageHeader(";
  out << ")";
}


DictionaryPageHeader::~DictionaryPageHeader() noexcept {
}

DictionaryPageHeader::DictionaryPageHeader() noexcept
   : num_values(0),
     encoding(static_cast<Encoding::type>(0)),
     is_sorted(0) {
}

void DictionaryPageHeader::__set_num_values(const int32_t val) {
  this->num_values = val;
}

void DictionaryPageHeader::__set_encoding(const Encoding::type val) {
  this->encoding = val;
}

void DictionaryPageHeader::__set_is_sorted(const bool val) {
  this->is_sorted = val;
__isset.is_sorted = true;
}
std::ostream& operator<<(std::ostream& out, const DictionaryPageHeader& obj)
{
  obj.printTo(out);
  return out;
}


uint32_t DictionaryPageHeader::read(::apache::thrift::protocol::TProtocol* iprot) {

  ::apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_num_values = false;
  bool isset_encoding = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->num_values);
          isset_num_values = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast141;
          xfer += iprot->readI32(ecast141);
          this->encoding = static_cast<Encoding::type>(ecast141);
          isset_encoding = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_BOOL) {
          xfer += iprot->readBool(this->is_sorted);
          this->__isset.is_sorted = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_num_values)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_encoding)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t DictionaryPageHeader::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  ::apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("DictionaryPageHeader");

  xfer += oprot->writeFieldBegin("num_values", ::apache::thrift::protocol::T_I32, 1);
  xfer += oprot->writeI32(this->num_values);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("encoding", ::apache::thrift::protocol::T_I32, 2);
  xfer += oprot->writeI32(static_cast<int32_t>(this->encoding));
  xfer += oprot->writeFieldEnd();

  if (this->__isset.is_sorted) {
    xfer += oprot->writeFieldBegin("is_sorted", ::apache::thrift::protocol::T_BOOL, 3);
    xfer += oprot->writeBool(this->is_sorted);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(DictionaryPageHeader &a, DictionaryPageHeader &b) {
  using ::std::swap;
  swap(a.num_values, b.num_values);
  swap(a.encoding, b.encoding);
  swap(a.is_sorted, b.is_sorted);
  swap(a.__isset, b.__isset);
}

DictionaryPageHeader::DictionaryPageHeader(const DictionaryPageHeader& other142) noexcept {
  num_values = other142.num_values;
  encoding = other142.encoding;
  is_sorted = other142.is_sorted;
  __isset = other142.__isset;
}
DictionaryPageHeader::DictionaryPageHeader(DictionaryPageHeader&& other143) noexcept {
  num_values = other143.num_values;
  encoding = other143.encoding;
  is_sorted = other143.is_sorted;
  __isset = other143.__isset;
}
DictionaryPageHeader& DictionaryPageHeader::operator=(const DictionaryPageHeader& other144) noexcept {
  num_values = other144.num_values;
  encoding = other144.encoding;
  is_sorted = other144.is_sorted;
  __isset = other144.__isset;
  return *this;
}
DictionaryPageHeader& DictionaryPageHeader::operator=(DictionaryPageHeader&& other145) noexcept {
  num_values = other145.num_values;
  encoding = other145.encoding;
  is_sorted = other145.is_sorted;
  __isset = other145.__isset;
  return *this;
}
void DictionaryPageHeader::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "DictionaryPageHeader(";
  out << "num_values=" << to_string(num_values);
  out << ", " << "encoding=" << to_string(encoding);
  out << ", " << "is_sorted="; (__isset.is_sorted ? (out << to_string(is_sorted)) : (out << "<null>"));
  out << ")";
}


DataPageHeaderV2::~DataPageHeaderV2() noexcept {
}

DataPageHeaderV2::DataPageHeaderV2() noexcept
   : num_values(0),
     num_nulls(0),
     num_rows(0),
     encoding(static_cast<Encoding::type>(0)),
     definition_levels_byte_length(0),
     repetition_levels_byte_length(0),
     is_compressed(true) {
}

void DataPageHeaderV2::__set_num_values(const int32_t val) {
  this->num_values = val;
}

void DataPageHeaderV2::__set_num_nulls(const int32_t val) {
  this->num_nulls = val;
}

void DataPageHeaderV2::__set_num_rows(const int32_t val) {
  this->num_rows = val;
}

void DataPageHeaderV2::__set_encoding(const Encoding::type val) {
  this->encoding = val;
}

void DataPageHeaderV2::__set_definition_levels_byte_length(const int32_t val) {
  this->definition_levels_byte_length = val;
}

void DataPageHeaderV2::__set_repetition_levels_byte_length(const int32_t val) {
  this->repetition_levels_byte_length = val;
}

void DataPageHeaderV2::__set_is_compressed(const bool val) {
  this->is_compressed = val;
__isset.is_compressed = true;
}

void DataPageHeaderV2::__set_statistics(const Statistics& val) {
  this->statistics = val;
__isset.statistics = true;
}
std::ostream& operator<<(std::ostream& out, const DataPageHeaderV2& obj)
{
  obj.printTo(out);
  return out;
}


uint32_t DataPageHeaderV2::read(::apache::thrift::protocol::TProtocol* iprot) {

  ::apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_num_values = false;
  bool isset_num_nulls = false;
  bool isset_num_rows = false;
  bool isset_encoding = false;
  bool isset_definition_levels_byte_length = false;
  bool isset_repetition_levels_byte_length = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->num_values);
          isset_num_values = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->num_nulls);
          isset_num_nulls = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->num_rows);
          isset_num_rows = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 4:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast146;
          xfer += iprot->readI32(ecast146);
          this->encoding = static_cast<Encoding::type>(ecast146);
          isset_encoding = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 5:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->definition_levels_byte_length);
          isset_definition_levels_byte_length = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 6:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->repetition_levels_byte_length);
          isset_repetition_levels_byte_length = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 7:
        if (ftype == ::apache::thrift::protocol::T_BOOL) {
          xfer += iprot->readBool(this->is_compressed);
          this->__isset.is_compressed = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 8:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->statistics.read(iprot);
          this->__isset.statistics = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_num_values)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_num_nulls)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_num_rows)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_encoding)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_definition_levels_byte_length)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_repetition_levels_byte_length)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t DataPageHeaderV2::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  ::apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("DataPageHeaderV2");

  xfer += oprot->writeFieldBegin("num_values", ::apache::thrift::protocol::T_I32, 1);
  xfer += oprot->writeI32(this->num_values);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("num_nulls", ::apache::thrift::protocol::T_I32, 2);
  xfer += oprot->writeI32(this->num_nulls);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("num_rows", ::apache::thrift::protocol::T_I32, 3);
  xfer += oprot->writeI32(this->num_rows);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("encoding", ::apache::thrift::protocol::T_I32, 4);
  xfer += oprot->writeI32(static_cast<int32_t>(this->encoding));
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("definition_levels_byte_length", ::apache::thrift::protocol::T_I32, 5);
  xfer += oprot->writeI32(this->definition_levels_byte_length);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("repetition_levels_byte_length", ::apache::thrift::protocol::T_I32, 6);
  xfer += oprot->writeI32(this->repetition_levels_byte_length);
  xfer += oprot->writeFieldEnd();

  if (this->__isset.is_compressed) {
    xfer += oprot->writeFieldBegin("is_compressed", ::apache::thrift::protocol::T_BOOL, 7);
    xfer += oprot->writeBool(this->is_compressed);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.statistics) {
    xfer += oprot->writeFieldBegin("statistics", ::apache::thrift::protocol::T_STRUCT, 8);
    xfer += this->statistics.write(oprot);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(DataPageHeaderV2 &a, DataPageHeaderV2 &b) {
  using ::std::swap;
  swap(a.num_values, b.num_values);
  swap(a.num_nulls, b.num_nulls);
  swap(a.num_rows, b.num_rows);
  swap(a.encoding, b.encoding);
  swap(a.definition_levels_byte_length, b.definition_levels_byte_length);
  swap(a.repetition_levels_byte_length, b.repetition_levels_byte_length);
  swap(a.is_compressed, b.is_compressed);
  swap(a.statistics, b.statistics);
  swap(a.__isset, b.__isset);
}

DataPageHeaderV2::DataPageHeaderV2(const DataPageHeaderV2& other147) {
  num_values = other147.num_values;
  num_nulls = other147.num_nulls;
  num_rows = other147.num_rows;
  encoding = other147.encoding;
  definition_levels_byte_length = other147.definition_levels_byte_length;
  repetition_levels_byte_length = other147.repetition_levels_byte_length;
  is_compressed = other147.is_compressed;
  statistics = other147.statistics;
  __isset = other147.__isset;
}
DataPageHeaderV2::DataPageHeaderV2(DataPageHeaderV2&& other148) noexcept {
  num_values = other148.num_values;
  num_nulls = other148.num_nulls;
  num_rows = other148.num_rows;
  encoding = other148.encoding;
  definition_levels_byte_length = other148.definition_levels_byte_length;
  repetition_levels_byte_length = other148.repetition_levels_byte_length;
  is_compressed = other148.is_compressed;
  statistics = std::move(other148.statistics);
  __isset = other148.__isset;
}
DataPageHeaderV2& DataPageHeaderV2::operator=(const DataPageHeaderV2& other149) {
  num_values = other149.num_values;
  num_nulls = other149.num_nulls;
  num_rows = other149.num_rows;
  encoding = other149.encoding;
  definition_levels_byte_length = other149.definition_levels_byte_length;
  repetition_levels_byte_length = other149.repetition_levels_byte_length;
  is_compressed = other149.is_compressed;
  statistics = other149.statistics;
  __isset = other149.__isset;
  return *this;
}
DataPageHeaderV2& DataPageHeaderV2::operator=(DataPageHeaderV2&& other150) noexcept {
  num_values = other150.num_values;
  num_nulls = other150.num_nulls;
  num_rows = other150.num_rows;
  encoding = other150.encoding;
  definition_levels_byte_length = other150.definition_levels_byte_length;
  repetition_levels_byte_length = other150.repetition_levels_byte_length;
  is_compressed = other150.is_compressed;
  statistics = std::move(other150.statistics);
  __isset = other150.__isset;
  return *this;
}
void DataPageHeaderV2::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "DataPageHeaderV2(";
  out << "num_values=" << to_string(num_values);
  out << ", " << "num_nulls=" << to_string(num_nulls);
  out << ", " << "num_rows=" << to_string(num_rows);
  out << ", " << "encoding=" << to_string(encoding);
  out << ", " << "definition_levels_byte_length=" << to_string(definition_levels_byte_length);
  out << ", " << "repetition_levels_byte_length=" << to_string(repetition_levels_byte_length);
  out << ", " << "is_compressed="; (__isset.is_compressed ? (out << to_string(is_compressed)) : (out << "<null>"));
  out << ", " << "statistics="; (__isset.statistics ? (out << to_string(statistics)) : (out << "<null>"));
  out << ")";
}


SplitBlockAlgorithm::~SplitBlockAlgorithm() noexcept {
}

SplitBlockAlgorithm::SplitBlockAlgorithm() noexcept {
}
std::ostream& operator<<(std::ostream& out, const SplitBlockAlgorithm& obj)
{
  obj.printTo(out);
  return out;
}


uint32_t SplitBlockAlgorithm::read(::apache::thrift::protocol::TProtocol* iprot) {

  ::apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;


  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    xfer += iprot->skip(ftype);
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  return xfer;
}

uint32_t SplitBlockAlgorithm::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  ::apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("SplitBlockAlgorithm");

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(SplitBlockAlgorithm &a, SplitBlockAlgorithm &b) {
  using ::std::swap;
  (void) a;
  (void) b;
}

SplitBlockAlgorithm::SplitBlockAlgorithm(const SplitBlockAlgorithm& other151) noexcept {
  (void) other151;
}
SplitBlockAlgorithm::SplitBlockAlgorithm(SplitBlockAlgorithm&& other152) noexcept {
  (void) other152;
}
SplitBlockAlgorithm& SplitBlockAlgorithm::operator=(const SplitBlockAlgorithm& other153) noexcept {
  (void) other153;
  return *this;
}
SplitBlockAlgorithm& SplitBlockAlgorithm::operator=(SplitBlockAlgorithm&& other154) noexcept {
  (void) other154;
  return *this;
}
void SplitBlockAlgorithm::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "SplitBlockAlgorithm(";
  out << ")";
}


BloomFilterAlgorithm::~BloomFilterAlgorithm() noexcept {
}

BloomFilterAlgorithm::BloomFilterAlgorithm() noexcept {
}

void BloomFilterAlgorithm::__set_BLOCK(const SplitBlockAlgorithm& val) {
  this->BLOCK = val;
__isset.BLOCK = true;
}
std::ostream& operator<<(std::ostream& out, const BloomFilterAlgorithm& obj)
{
  obj.printTo(out);
  return out;
}


uint32_t BloomFilterAlgorithm::read(::apache::thrift::protocol::TProtocol* iprot) {

  ::apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;


  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->BLOCK.read(iprot);
          this->__isset.BLOCK = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  return xfer;
}

uint32_t BloomFilterAlgorithm::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  ::apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("BloomFilterAlgorithm");

  if (this->__isset.BLOCK) {
    xfer += oprot->writeFieldBegin("BLOCK", ::apache::thrift::protocol::T_STRUCT, 1);
    xfer += this->BLOCK.write(oprot);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(BloomFilterAlgorithm &a, BloomFilterAlgorithm &b) {
  using ::std::swap;
  swap(a.BLOCK, b.BLOCK);
  swap(a.__isset, b.__isset);
}

BloomFilterAlgorithm::BloomFilterAlgorithm(const BloomFilterAlgorithm& other155) noexcept {
  BLOCK = other155.BLOCK;
  __isset = other155.__isset;
}
BloomFilterAlgorithm::BloomFilterAlgorithm(BloomFilterAlgorithm&& other156) noexcept {
  BLOCK = std::move(other156.BLOCK);
  __isset = other156.__isset;
}
BloomFilterAlgorithm& BloomFilterAlgorithm::operator=(const BloomFilterAlgorithm& other157) noexcept {
  BLOCK = other157.BLOCK;
  __isset = other157.__isset;
  return *this;
}
BloomFilterAlgorithm& BloomFilterAlgorithm::operator=(BloomFilterAlgorithm&& other158) noexcept {
  BLOCK = std::move(other158.BLOCK);
  __isset = other158.__isset;
  return *this;
}
void BloomFilterAlgorithm::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "BloomFilterAlgorithm(";
  out << "BLOCK="; (__isset.BLOCK ? (out << to_string(BLOCK)) : (out << "<null>"));
  out << ")";
}


XxHash::~XxHash() noexcept {
}

XxHash::XxHash() noexcept {
}
std::ostream& operator<<(std::ostream& out, const XxHash& obj)
{
  obj.printTo(out);
  return out;
}


uint32_t XxHash::read(::apache::thrift::protocol::TProtocol* iprot) {

  ::apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;


  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    xfer += iprot->skip(ftype);
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  return xfer;
}

uint32_t XxHash::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  ::apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("XxHash");

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(XxHash &a, XxHash &b) {
  using ::std::swap;
  (void) a;
  (void) b;
}

XxHash::XxHash(const XxHash& other159) noexcept {
  (void) other159;
}
XxHash::XxHash(XxHash&& other160) noexcept {
  (void) other160;
}
XxHash& XxHash::operator=(const XxHash& other161) noexcept {
  (void) other161;
  return *this;
}
XxHash& XxHash::operator=(XxHash&& other162) noexcept {
  (void) other162;
  return *this;
}
void XxHash::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "XxHash(";
  out << ")";
}


BloomFilterHash::~BloomFilterHash() noexcept {
}

BloomFilterHash::BloomFilterHash() noexcept {
}

void BloomFilterHash::__set_XXHASH(const XxHash& val) {
  this->XXHASH = val;
__isset.XXHASH = true;
}
std::ostream& operator<<(std::ostream& out, const BloomFilterHash& obj)
{
  obj.printTo(out);
  return out;
}


uint32_t BloomFilterHash::read(::apache::thrift::protocol::TProtocol* iprot) {

  ::apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;


  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->XXHASH.read(iprot);
          this->__isset.XXHASH = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  return xfer;
}

uint32_t BloomFilterHash::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  ::apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("BloomFilterHash");

  if (this->__isset.XXHASH) {
    xfer += oprot->writeFieldBegin("XXHASH", ::apache::thrift::protocol::T_STRUCT, 1);
    xfer += this->XXHASH.write(oprot);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(BloomFilterHash &a, BloomFilterHash &b) {
  using ::std::swap;
  swap(a.XXHASH, b.XXHASH);
  swap(a.__isset, b.__isset);
}

BloomFilterHash::BloomFilterHash(const BloomFilterHash& other163) noexcept {
  XXHASH = other163.XXHASH;
  __isset = other163.__isset;
}
BloomFilterHash::BloomFilterHash(BloomFilterHash&& other164) noexcept {
  XXHASH = std::move(other164.XXHASH);
  __isset = other164.__isset;
}
BloomFilterHash& BloomFilterHash::operator=(const BloomFilterHash& other165) noexcept {
  XXHASH = other165.XXHASH;
  __isset = other165.__isset;
  return *this;
}
BloomFilterHash& BloomFilterHash::operator=(BloomFilterHash&& other166) noexcept {
  XXHASH = std::move(other166.XXHASH);
  __isset = other166.__isset;
  return *this;
}
void BloomFilterHash::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "BloomFilterHash(";
  out << "XXHASH="; (__isset.XXHASH ? (out << to_string(XXHASH)) : (out << "<null>"));
  out << ")";
}


Uncompressed::~Uncompressed() noexcept {
}

Uncompressed::Uncompressed() noexcept {
}
std::ostream& operator<<(std::ostream& out, const Uncompressed& obj)
{
  obj.printTo(out);
  return out;
}


uint32_t Uncompressed::read(::apache::thrift::protocol::TProtocol* iprot) {

  ::apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;


  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    xfer += iprot->skip(ftype);
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  return xfer;
}

uint32_t Uncompressed::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  ::apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("Uncompressed");

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(Uncompressed &a, Uncompressed &b) {
  using ::std::swap;
  (void) a;
  (void) b;
}

Uncompressed::Uncompressed(const Uncompressed& other167) noexcept {
  (void) other167;
}
Uncompressed::Uncompressed(Uncompressed&& other168) noexcept {
  (void) other168;
}
Uncompressed& Uncompressed::operator=(const Uncompressed& other169) noexcept {
  (void) other169;
  return *this;
}
Uncompressed& Uncompressed::operator=(Uncompressed&& other170) noexcept {
  (void) other170;
  return *this;
}
void Uncompressed::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "Uncompressed(";
  out << ")";
}


BloomFilterCompression::~BloomFilterCompression() noexcept {
}

BloomFilterCompression::BloomFilterCompression() noexcept {
}

void BloomFilterCompression::__set_UNCOMPRESSED(const Uncompressed& val) {
  this->UNCOMPRESSED = val;
__isset.UNCOMPRESSED = true;
}
std::ostream& operator<<(std::ostream& out, const BloomFilterCompression& obj)
{
  obj.printTo(out);
  return out;
}


uint32_t BloomFilterCompression::read(::apache::thrift::protocol::TProtocol* iprot) {

  ::apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;


  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->UNCOMPRESSED.read(iprot);
          this->__isset.UNCOMPRESSED = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  return xfer;
}

uint32_t BloomFilterCompression::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  ::apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("BloomFilterCompression");

  if (this->__isset.UNCOMPRESSED) {
    xfer += oprot->writeFieldBegin("UNCOMPRESSED", ::apache::thrift::protocol::T_STRUCT, 1);
    xfer += this->UNCOMPRESSED.write(oprot);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(BloomFilterCompression &a, BloomFilterCompression &b) {
  using ::std::swap;
  swap(a.UNCOMPRESSED, b.UNCOMPRESSED);
  swap(a.__isset, b.__isset);
}

BloomFilterCompression::BloomFilterCompression(const BloomFilterCompression& other171) noexcept {
  UNCOMPRESSED = other171.UNCOMPRESSED;
  __isset = other171.__isset;
}
BloomFilterCompression::BloomFilterCompression(BloomFilterCompression&& other172) noexcept {
  UNCOMPRESSED = std::move(other172.UNCOMPRESSED);
  __isset = other172.__isset;
}
BloomFilterCompression& BloomFilterCompression::operator=(const BloomFilterCompression& other173) noexcept {
  UNCOMPRESSED = other173.UNCOMPRESSED;
  __isset = other173.__isset;
  return *this;
}
BloomFilterCompression& BloomFilterCompression::operator=(BloomFilterCompression&& other174) noexcept {
  UNCOMPRESSED = std::move(other174.UNCOMPRESSED);
  __isset = other174.__isset;
  return *this;
}
void BloomFilterCompression::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "BloomFilterCompression(";
  out << "UNCOMPRESSED="; (__isset.UNCOMPRESSED ? (out << to_string(UNCOMPRESSED)) : (out << "<null>"));
  out << ")";
}


BloomFilterHeader::~BloomFilterHeader() noexcept {
}

BloomFilterHeader::BloomFilterHeader() noexcept
   : numBytes(0) {
}

void BloomFilterHeader::__set_numBytes(const int32_t val) {
  this->numBytes = val;
}

void BloomFilterHeader::__set_algorithm(const BloomFilterAlgorithm& val) {
  this->algorithm = val;
}

void BloomFilterHeader::__set_hash(const BloomFilterHash& val) {
  this->hash = val;
}

void BloomFilterHeader::__set_compression(const BloomFilterCompression& val) {
  this->compression = val;
}
std::ostream& operator<<(std::ostream& out, const BloomFilterHeader& obj)
{
  obj.printTo(out);
  return out;
}


uint32_t BloomFilterHeader::read(::apache::thrift::protocol::TProtocol* iprot) {

  ::apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_numBytes = false;
  bool isset_algorithm = false;
  bool isset_hash = false;
  bool isset_compression = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->numBytes);
          isset_numBytes = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->algorithm.read(iprot);
          isset_algorithm = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->hash.read(iprot);
          isset_hash = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 4:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->compression.read(iprot);
          isset_compression = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_numBytes)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_algorithm)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_hash)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_compression)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t BloomFilterHeader::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  ::apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("BloomFilterHeader");

  xfer += oprot->writeFieldBegin("numBytes", ::apache::thrift::protocol::T_I32, 1);
  xfer += oprot->writeI32(this->numBytes);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("algorithm", ::apache::thrift::protocol::T_STRUCT, 2);
  xfer += this->algorithm.write(oprot);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("hash", ::apache::thrift::protocol::T_STRUCT, 3);
  xfer += this->hash.write(oprot);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("compression", ::apache::thrift::protocol::T_STRUCT, 4);
  xfer += this->compression.write(oprot);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(BloomFilterHeader &a, BloomFilterHeader &b) {
  using ::std::swap;
  swap(a.numBytes, b.numBytes);
  swap(a.algorithm, b.algorithm);
  swap(a.hash, b.hash);
  swap(a.compression, b.compression);
}

BloomFilterHeader::BloomFilterHeader(const BloomFilterHeader& other175) noexcept {
  numBytes = other175.numBytes;
  algorithm = other175.algorithm;
  hash = other175.hash;
  compression = other175.compression;
}
BloomFilterHeader::BloomFilterHeader(BloomFilterHeader&& other176) noexcept {
  numBytes = other176.numBytes;
  algorithm = std::move(other176.algorithm);
  hash = std::move(other176.hash);
  compression = std::move(other176.compression);
}
BloomFilterHeader& BloomFilterHeader::operator=(const BloomFilterHeader& other177) noexcept {
  numBytes = other177.numBytes;
  algorithm = other177.algorithm;
  hash = other177.hash;
  compression = other177.compression;
  return *this;
}
BloomFilterHeader& BloomFilterHeader::operator=(BloomFilterHeader&& other178) noexcept {
  numBytes = other178.numBytes;
  algorithm = std::move(other178.algorithm);
  hash = std::move(other178.hash);
  compression = std::move(other178.compression);
  return *this;
}
void BloomFilterHeader::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "BloomFilterHeader(";
  out << "numBytes=" << to_string(numBytes);
  out << ", " << "algorithm=" << to_string(algorithm);
  out << ", " << "hash=" << to_string(hash);
  out << ", " << "compression=" << to_string(compression);
  out << ")";
}


PageHeader::~PageHeader() noexcept {
}

PageHeader::PageHeader() noexcept
   : type(static_cast<PageType::type>(0)),
     uncompressed_page_size(0),
     compressed_page_size(0),
     crc(0) {
}

void PageHeader::__set_type(const PageType::type val) {
  this->type = val;
}

void PageHeader::__set_uncompressed_page_size(const int32_t val) {
  this->uncompressed_page_size = val;
}

void PageHeader::__set_compressed_page_size(const int32_t val) {
  this->compressed_page_size = val;
}

void PageHeader::__set_crc(const int32_t val) {
  this->crc = val;
__isset.crc = true;
}

void PageHeader::__set_data_page_header(const DataPageHeader& val) {
  this->data_page_header = val;
__isset.data_page_header = true;
}

void PageHeader::__set_index_page_header(const IndexPageHeader& val) {
  this->index_page_header = val;
__isset.index_page_header = true;
}

void PageHeader::__set_dictionary_page_header(const DictionaryPageHeader& val) {
  this->dictionary_page_header = val;
__isset.dictionary_page_header = true;
}

void PageHeader::__set_data_page_header_v2(const DataPageHeaderV2& val) {
  this->data_page_header_v2 = val;
__isset.data_page_header_v2 = true;
}
std::ostream& operator<<(std::ostream& out, const PageHeader& obj)
{
  obj.printTo(out);
  return out;
}


uint32_t PageHeader::read(::apache::thrift::protocol::TProtocol* iprot) {

  ::apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_type = false;
  bool isset_uncompressed_page_size = false;
  bool isset_compressed_page_size = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast179;
          xfer += iprot->readI32(ecast179);
          this->type = static_cast<PageType::type>(ecast179);
          isset_type = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->uncompressed_page_size);
          isset_uncompressed_page_size = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->compressed_page_size);
          isset_compressed_page_size = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 4:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->crc);
          this->__isset.crc = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 5:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->data_page_header.read(iprot);
          this->__isset.data_page_header = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 6:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->index_page_header.read(iprot);
          this->__isset.index_page_header = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 7:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->dictionary_page_header.read(iprot);
          this->__isset.dictionary_page_header = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 8:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->data_page_header_v2.read(iprot);
          this->__isset.data_page_header_v2 = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_type)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_uncompressed_page_size)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_compressed_page_size)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t PageHeader::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  ::apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("PageHeader");

  xfer += oprot->writeFieldBegin("type", ::apache::thrift::protocol::T_I32, 1);
  xfer += oprot->writeI32(static_cast<int32_t>(this->type));
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("uncompressed_page_size", ::apache::thrift::protocol::T_I32, 2);
  xfer += oprot->writeI32(this->uncompressed_page_size);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("compressed_page_size", ::apache::thrift::protocol::T_I32, 3);
  xfer += oprot->writeI32(this->compressed_page_size);
  xfer += oprot->writeFieldEnd();

  if (this->__isset.crc) {
    xfer += oprot->writeFieldBegin("crc", ::apache::thrift::protocol::T_I32, 4);
    xfer += oprot->writeI32(this->crc);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.data_page_header) {
    xfer += oprot->writeFieldBegin("data_page_header", ::apache::thrift::protocol::T_STRUCT, 5);
    xfer += this->data_page_header.write(oprot);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.index_page_header) {
    xfer += oprot->writeFieldBegin("index_page_header", ::apache::thrift::protocol::T_STRUCT, 6);
    xfer += this->index_page_header.write(oprot);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.dictionary_page_header) {
    xfer += oprot->writeFieldBegin("dictionary_page_header", ::apache::thrift::protocol::T_STRUCT, 7);
    xfer += this->dictionary_page_header.write(oprot);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.data_page_header_v2) {
    xfer += oprot->writeFieldBegin("data_page_header_v2", ::apache::thrift::protocol::T_STRUCT, 8);
    xfer += this->data_page_header_v2.write(oprot);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(PageHeader &a, PageHeader &b) {
  using ::std::swap;
  swap(a.type, b.type);
  swap(a.uncompressed_page_size, b.uncompressed_page_size);
  swap(a.compressed_page_size, b.compressed_page_size);
  swap(a.crc, b.crc);
  swap(a.data_page_header, b.data_page_header);
  swap(a.index_page_header, b.index_page_header);
  swap(a.dictionary_page_header, b.dictionary_page_header);
  swap(a.data_page_header_v2, b.data_page_header_v2);
  swap(a.__isset, b.__isset);
}

PageHeader::PageHeader(const PageHeader& other180) {
  type = other180.type;
  uncompressed_page_size = other180.uncompressed_page_size;
  compressed_page_size = other180.compressed_page_size;
  crc = other180.crc;
  data_page_header = other180.data_page_header;
  index_page_header = other180.index_page_header;
  dictionary_page_header = other180.dictionary_page_header;
  data_page_header_v2 = other180.data_page_header_v2;
  __isset = other180.__isset;
}
PageHeader::PageHeader(PageHeader&& other181) noexcept {
  type = other181.type;
  uncompressed_page_size = other181.uncompressed_page_size;
  compressed_page_size = other181.compressed_page_size;
  crc = other181.crc;
  data_page_header = std::move(other181.data_page_header);
  index_page_header = std::move(other181.index_page_header);
  dictionary_page_header = std::move(other181.dictionary_page_header);
  data_page_header_v2 = std::move(other181.data_page_header_v2);
  __isset = other181.__isset;
}
PageHeader& PageHeader::operator=(const PageHeader& other182) {
  type = other182.type;
  uncompressed_page_size = other182.uncompressed_page_size;
  compressed_page_size = other182.compressed_page_size;
  crc = other182.crc;
  data_page_header = other182.data_page_header;
  index_page_header = other182.index_page_header;
  dictionary_page_header = other182.dictionary_page_header;
  data_page_header_v2 = other182.data_page_header_v2;
  __isset = other182.__isset;
  return *this;
}
PageHeader& PageHeader::operator=(PageHeader&& other183) noexcept {
  type = other183.type;
  uncompressed_page_size = other183.uncompressed_page_size;
  compressed_page_size = other183.compressed_page_size;
  crc = other183.crc;
  data_page_header = std::move(other183.data_page_header);
  index_page_header = std::move(other183.index_page_header);
  dictionary_page_header = std::move(other183.dictionary_page_header);
  data_page_header_v2 = std::move(other183.data_page_header_v2);
  __isset = other183.__isset;
  return *this;
}
void PageHeader::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "PageHeader(";
  out << "type=" << to_string(type);
  out << ", " << "uncompressed_page_size=" << to_string(uncompressed_page_size);
  out << ", " << "compressed_page_size=" << to_string(compressed_page_size);
  out << ", " << "crc="; (__isset.crc ? (out << to_string(crc)) : (out << "<null>"));
  out << ", " << "data_page_header="; (__isset.data_page_header ? (out << to_string(data_page_header)) : (out << "<null>"));
  out << ", " << "index_page_header="; (__isset.index_page_header ? (out << to_string(index_page_header)) : (out << "<null>"));
  out << ", " << "dictionary_page_header="; (__isset.dictionary_page_header ? (out << to_string(dictionary_page_header)) : (out << "<null>"));
  out << ", " << "data_page_header_v2="; (__isset.data_page_header_v2 ? (out << to_string(data_page_header_v2)) : (out << "<null>"));
  out << ")";
}


KeyValue::~KeyValue() noexcept {
}

KeyValue::KeyValue() noexcept
   : key(),
     value() {
}

void KeyValue::__set_key(const std::string& val) {
  this->key = val;
}

void KeyValue::__set_value(const std::string& val) {
  this->value = val;
__isset.value = true;
}
std::ostream& operator<<(std::ostream& out, const KeyValue& obj)
{
  obj.printTo(out);
  return out;
}


uint32_t KeyValue::read(::apache::thrift::protocol::TProtocol* iprot) {

  ::apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_key = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->key);
          isset_key = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->value);
          this->__isset.value = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_key)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t KeyValue::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  ::apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("KeyValue");

  xfer += oprot->writeFieldBegin("key", ::apache::thrift::protocol::T_STRING, 1);
  xfer += oprot->writeString(this->key);
  xfer += oprot->writeFieldEnd();

  if (this->__isset.value) {
    xfer += oprot->writeFieldBegin("value", ::apache::thrift::protocol::T_STRING, 2);
    xfer += oprot->writeString(this->value);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(KeyValue &a, KeyValue &b) {
  using ::std::swap;
  swap(a.key, b.key);
  swap(a.value, b.value);
  swap(a.__isset, b.__isset);
}

KeyValue::KeyValue(const KeyValue& other184) {
  key = other184.key;
  value = other184.value;
  __isset = other184.__isset;
}
KeyValue::KeyValue(KeyValue&& other185) noexcept {
  key = std::move(other185.key);
  value = std::move(other185.value);
  __isset = other185.__isset;
}
KeyValue& KeyValue::operator=(const KeyValue& other186) {
  key = other186.key;
  value = other186.value;
  __isset = other186.__isset;
  return *this;
}
KeyValue& KeyValue::operator=(KeyValue&& other187) noexcept {
  key = std::move(other187.key);
  value = std::move(other187.value);
  __isset = other187.__isset;
  return *this;
}
void KeyValue::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "KeyValue(";
  out << "key=" << to_string(key);
  out << ", " << "value="; (__isset.value ? (out << to_string(value)) : (out << "<null>"));
  out << ")";
}


SortingColumn::~SortingColumn() noexcept {
}

SortingColumn::SortingColumn() noexcept
   : column_idx(0),
     descending(0),
     nulls_first(0) {
}

void SortingColumn::__set_column_idx(const int32_t val) {
  this->column_idx = val;
}

void SortingColumn::__set_descending(const bool val) {
  this->descending = val;
}

void SortingColumn::__set_nulls_first(const bool val) {
  this->nulls_first = val;
}
std::ostream& operator<<(std::ostream& out, const SortingColumn& obj)
{
  obj.printTo(out);
  return out;
}


uint32_t SortingColumn::read(::apache::thrift::protocol::TProtocol* iprot) {

  ::apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_column_idx = false;
  bool isset_descending = false;
  bool isset_nulls_first = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->column_idx);
          isset_column_idx = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_BOOL) {
          xfer += iprot->readBool(this->descending);
          isset_descending = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_BOOL) {
          xfer += iprot->readBool(this->nulls_first);
          isset_nulls_first = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_column_idx)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_descending)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_nulls_first)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t SortingColumn::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  ::apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("SortingColumn");

  xfer += oprot->writeFieldBegin("column_idx", ::apache::thrift::protocol::T_I32, 1);
  xfer += oprot->writeI32(this->column_idx);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("descending", ::apache::thrift::protocol::T_BOOL, 2);
  xfer += oprot->writeBool(this->descending);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("nulls_first", ::apache::thrift::protocol::T_BOOL, 3);
  xfer += oprot->writeBool(this->nulls_first);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(SortingColumn &a, SortingColumn &b) {
  using ::std::swap;
  swap(a.column_idx, b.column_idx);
  swap(a.descending, b.descending);
  swap(a.nulls_first, b.nulls_first);
}

SortingColumn::SortingColumn(const SortingColumn& other188) noexcept {
  column_idx = other188.column_idx;
  descending = other188.descending;
  nulls_first = other188.nulls_first;
}
SortingColumn::SortingColumn(SortingColumn&& other189) noexcept {
  column_idx = other189.column_idx;
  descending = other189.descending;
  nulls_first = other189.nulls_first;
}
SortingColumn& SortingColumn::operator=(const SortingColumn& other190) noexcept {
  column_idx = other190.column_idx;
  descending = other190.descending;
  nulls_first = other190.nulls_first;
  return *this;
}
SortingColumn& SortingColumn::operator=(SortingColumn&& other191) noexcept {
  column_idx = other191.column_idx;
  descending = other191.descending;
  nulls_first = other191.nulls_first;
  return *this;
}
void SortingColumn::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "SortingColumn(";
  out << "column_idx=" << to_string(column_idx);
  out << ", " << "descending=" << to_string(descending);
  out << ", " << "nulls_first=" << to_string(nulls_first);
  out << ")";
}


PageEncodingStats::~PageEncodingStats() noexcept {
}

PageEncodingStats::PageEncodingStats() noexcept
   : page_type(static_cast<PageType::type>(0)),
     encoding(static_cast<Encoding::type>(0)),
     count(0) {
}

void PageEncodingStats::__set_page_type(const PageType::type val) {
  this->page_type = val;
}

void PageEncodingStats::__set_encoding(const Encoding::type val) {
  this->encoding = val;
}

void PageEncodingStats::__set_count(const int32_t val) {
  this->count = val;
}
std::ostream& operator<<(std::ostream& out, const PageEncodingStats& obj)
{
  obj.printTo(out);
  return out;
}


uint32_t PageEncodingStats::read(::apache::thrift::protocol::TProtocol* iprot) {

  ::apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_page_type = false;
  bool isset_encoding = false;
  bool isset_count = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast192;
          xfer += iprot->readI32(ecast192);
          this->page_type = static_cast<PageType::type>(ecast192);
          isset_page_type = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast193;
          xfer += iprot->readI32(ecast193);
          this->encoding = static_cast<Encoding::type>(ecast193);
          isset_encoding = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->count);
          isset_count = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_page_type)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_encoding)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_count)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t PageEncodingStats::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  ::apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("PageEncodingStats");

  xfer += oprot->writeFieldBegin("page_type", ::apache::thrift::protocol::T_I32, 1);
  xfer += oprot->writeI32(static_cast<int32_t>(this->page_type));
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("encoding", ::apache::thrift::protocol::T_I32, 2);
  xfer += oprot->writeI32(static_cast<int32_t>(this->encoding));
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("count", ::apache::thrift::protocol::T_I32, 3);
  xfer += oprot->writeI32(this->count);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(PageEncodingStats &a, PageEncodingStats &b) {
  using ::std::swap;
  swap(a.page_type, b.page_type);
  swap(a.encoding, b.encoding);
  swap(a.count, b.count);
}

PageEncodingStats::PageEncodingStats(const PageEncodingStats& other194) noexcept {
  page_type = other194.page_type;
  encoding = other194.encoding;
  count = other194.count;
}
PageEncodingStats::PageEncodingStats(PageEncodingStats&& other195) noexcept {
  page_type = other195.page_type;
  encoding = other195.encoding;
  count = other195.count;
}
PageEncodingStats& PageEncodingStats::operator=(const PageEncodingStats& other196) noexcept {
  page_type = other196.page_type;
  encoding = other196.encoding;
  count = other196.count;
  return *this;
}
PageEncodingStats& PageEncodingStats::operator=(PageEncodingStats&& other197) noexcept {
  page_type = other197.page_type;
  encoding = other197.encoding;
  count = other197.count;
  return *this;
}
void PageEncodingStats::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "PageEncodingStats(";
  out << "page_type=" << to_string(page_type);
  out << ", " << "encoding=" << to_string(encoding);
  out << ", " << "count=" << to_string(count);
  out << ")";
}


ColumnMetaData::~ColumnMetaData() noexcept {
}

ColumnMetaData::ColumnMetaData() noexcept
   : type(static_cast<Type::type>(0)),
     codec(static_cast<CompressionCodec::type>(0)),
     num_values(0),
     total_uncompressed_size(0),
     total_compressed_size(0),
     data_page_offset(0),
     index_page_offset(0),
     dictionary_page_offset(0),
     bloom_filter_offset(0),
     bloom_filter_length(0) {
}

void ColumnMetaData::__set_type(const Type::type val) {
  this->type = val;
}

void ColumnMetaData::__set_encodings(const duckdb::vector<Encoding::type> & val) {
  this->encodings = val;
}

void ColumnMetaData::__set_path_in_schema(const duckdb::vector<std::string> & val) {
  this->path_in_schema = val;
}

void ColumnMetaData::__set_codec(const CompressionCodec::type val) {
  this->codec = val;
}

void ColumnMetaData::__set_num_values(const int64_t val) {
  this->num_values = val;
}

void ColumnMetaData::__set_total_uncompressed_size(const int64_t val) {
  this->total_uncompressed_size = val;
}

void ColumnMetaData::__set_total_compressed_size(const int64_t val) {
  this->total_compressed_size = val;
}

void ColumnMetaData::__set_key_value_metadata(const duckdb::vector<KeyValue> & val) {
  this->key_value_metadata = val;
__isset.key_value_metadata = true;
}

void ColumnMetaData::__set_data_page_offset(const int64_t val) {
  this->data_page_offset = val;
}

void ColumnMetaData::__set_index_page_offset(const int64_t val) {
  this->index_page_offset = val;
__isset.index_page_offset = true;
}

void ColumnMetaData::__set_dictionary_page_offset(const int64_t val) {
  this->dictionary_page_offset = val;
__isset.dictionary_page_offset = true;
}

void ColumnMetaData::__set_statistics(const Statistics& val) {
  this->statistics = val;
__isset.statistics = true;
}

void ColumnMetaData::__set_encoding_stats(const duckdb::vector<PageEncodingStats> & val) {
  this->encoding_stats = val;
__isset.encoding_stats = true;
}

void ColumnMetaData::__set_bloom_filter_offset(const int64_t val) {
  this->bloom_filter_offset = val;
__isset.bloom_filter_offset = true;
}

void ColumnMetaData::__set_bloom_filter_length(const int32_t val) {
  this->bloom_filter_length = val;
__isset.bloom_filter_length = true;
}

void ColumnMetaData::__set_size_statistics(const SizeStatistics& val) {
  this->size_statistics = val;
__isset.size_statistics = true;
}

void ColumnMetaData::__set_geospatial_statistics(const GeospatialStatistics& val) {
  this->geospatial_statistics = val;
__isset.geospatial_statistics = true;
}
std::ostream& operator<<(std::ostream& out, const ColumnMetaData& obj)
{
  obj.printTo(out);
  return out;
}


uint32_t ColumnMetaData::read(::apache::thrift::protocol::TProtocol* iprot) {

  ::apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_type = false;
  bool isset_encodings = false;
  bool isset_path_in_schema = false;
  bool isset_codec = false;
  bool isset_num_values = false;
  bool isset_total_uncompressed_size = false;
  bool isset_total_compressed_size = false;
  bool isset_data_page_offset = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast198;
          xfer += iprot->readI32(ecast198);
          this->type = static_cast<Type::type>(ecast198);
          isset_type = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->encodings.clear();
            uint32_t _size199;
            ::apache::thrift::protocol::TType _etype202;
            xfer += iprot->readListBegin(_etype202, _size199);
            this->encodings.resize(_size199);
            uint32_t _i203;
            for (_i203 = 0; _i203 < _size199; ++_i203)
            {
              int32_t ecast204;
              xfer += iprot->readI32(ecast204);
              this->encodings[_i203] = static_cast<Encoding::type>(ecast204);
            }
            xfer += iprot->readListEnd();
          }
          isset_encodings = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->path_in_schema.clear();
            uint32_t _size205;
            ::apache::thrift::protocol::TType _etype208;
            xfer += iprot->readListBegin(_etype208, _size205);
            this->path_in_schema.resize(_size205);
            uint32_t _i209;
            for (_i209 = 0; _i209 < _size205; ++_i209)
            {
              xfer += iprot->readString(this->path_in_schema[_i209]);
            }
            xfer += iprot->readListEnd();
          }
          isset_path_in_schema = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 4:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast210;
          xfer += iprot->readI32(ecast210);
          this->codec = static_cast<CompressionCodec::type>(ecast210);
          isset_codec = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 5:
        if (ftype == ::apache::thrift::protocol::T_I64) {
          xfer += iprot->readI64(this->num_values);
          isset_num_values = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 6:
        if (ftype == ::apache::thrift::protocol::T_I64) {
          xfer += iprot->readI64(this->total_uncompressed_size);
          isset_total_uncompressed_size = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 7:
        if (ftype == ::apache::thrift::protocol::T_I64) {
          xfer += iprot->readI64(this->total_compressed_size);
          isset_total_compressed_size = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 8:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->key_value_metadata.clear();
            uint32_t _size211;
            ::apache::thrift::protocol::TType _etype214;
            xfer += iprot->readListBegin(_etype214, _size211);
            this->key_value_metadata.resize(_size211);
            uint32_t _i215;
            for (_i215 = 0; _i215 < _size211; ++_i215)
            {
              xfer += this->key_value_metadata[_i215].read(iprot);
            }
            xfer += iprot->readListEnd();
          }
          this->__isset.key_value_metadata = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 9:
        if (ftype == ::apache::thrift::protocol::T_I64) {
          xfer += iprot->readI64(this->data_page_offset);
          isset_data_page_offset = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 10:
        if (ftype == ::apache::thrift::protocol::T_I64) {
          xfer += iprot->readI64(this->index_page_offset);
          this->__isset.index_page_offset = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 11:
        if (ftype == ::apache::thrift::protocol::T_I64) {
          xfer += iprot->readI64(this->dictionary_page_offset);
          this->__isset.dictionary_page_offset = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 12:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->statistics.read(iprot);
          this->__isset.statistics = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 13:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->encoding_stats.clear();
            uint32_t _size216;
            ::apache::thrift::protocol::TType _etype219;
            xfer += iprot->readListBegin(_etype219, _size216);
            this->encoding_stats.resize(_size216);
            uint32_t _i220;
            for (_i220 = 0; _i220 < _size216; ++_i220)
            {
              xfer += this->encoding_stats[_i220].read(iprot);
            }
            xfer += iprot->readListEnd();
          }
          this->__isset.encoding_stats = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 14:
        if (ftype == ::apache::thrift::protocol::T_I64) {
          xfer += iprot->readI64(this->bloom_filter_offset);
          this->__isset.bloom_filter_offset = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 15:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->bloom_filter_length);
          this->__isset.bloom_filter_length = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 16:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->size_statistics.read(iprot);
          this->__isset.size_statistics = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 17:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->geospatial_statistics.read(iprot);
          this->__isset.geospatial_statistics = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_type)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_encodings)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_path_in_schema)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_codec)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_num_values)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_total_uncompressed_size)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_total_compressed_size)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_data_page_offset)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t ColumnMetaData::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  ::apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("ColumnMetaData");

  xfer += oprot->writeFieldBegin("type", ::apache::thrift::protocol::T_I32, 1);
  xfer += oprot->writeI32(static_cast<int32_t>(this->type));
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("encodings", ::apache::thrift::protocol::T_LIST, 2);
  {
    xfer += oprot->writeListBegin(::apache::thrift::protocol::T_I32, static_cast<uint32_t>(this->encodings.size()));
    duckdb::vector<Encoding::type> ::const_iterator _iter221;
    for (_iter221 = this->encodings.begin(); _iter221 != this->encodings.end(); ++_iter221)
    {
      xfer += oprot->writeI32(static_cast<int32_t>((*_iter221)));
    }
    xfer += oprot->writeListEnd();
  }
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("path_in_schema", ::apache::thrift::protocol::T_LIST, 3);
  {
    xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRING, static_cast<uint32_t>(this->path_in_schema.size()));
    duckdb::vector<std::string> ::const_iterator _iter222;
    for (_iter222 = this->path_in_schema.begin(); _iter222 != this->path_in_schema.end(); ++_iter222)
    {
      xfer += oprot->writeString((*_iter222));
    }
    xfer += oprot->writeListEnd();
  }
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("codec", ::apache::thrift::protocol::T_I32, 4);
  xfer += oprot->writeI32(static_cast<int32_t>(this->codec));
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("num_values", ::apache::thrift::protocol::T_I64, 5);
  xfer += oprot->writeI64(this->num_values);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("total_uncompressed_size", ::apache::thrift::protocol::T_I64, 6);
  xfer += oprot->writeI64(this->total_uncompressed_size);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("total_compressed_size", ::apache::thrift::protocol::T_I64, 7);
  xfer += oprot->writeI64(this->total_compressed_size);
  xfer += oprot->writeFieldEnd();

  if (this->__isset.key_value_metadata) {
    xfer += oprot->writeFieldBegin("key_value_metadata", ::apache::thrift::protocol::T_LIST, 8);
    {
      xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRUCT, static_cast<uint32_t>(this->key_value_metadata.size()));
      duckdb::vector<KeyValue> ::const_iterator _iter223;
      for (_iter223 = this->key_value_metadata.begin(); _iter223 != this->key_value_metadata.end(); ++_iter223)
      {
        xfer += (*_iter223).write(oprot);
      }
      xfer += oprot->writeListEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldBegin("data_page_offset", ::apache::thrift::protocol::T_I64, 9);
  xfer += oprot->writeI64(this->data_page_offset);
  xfer += oprot->writeFieldEnd();

  if (this->__isset.index_page_offset) {
    xfer += oprot->writeFieldBegin("index_page_offset", ::apache::thrift::protocol::T_I64, 10);
    xfer += oprot->writeI64(this->index_page_offset);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.dictionary_page_offset) {
    xfer += oprot->writeFieldBegin("dictionary_page_offset", ::apache::thrift::protocol::T_I64, 11);
    xfer += oprot->writeI64(this->dictionary_page_offset);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.statistics) {
    xfer += oprot->writeFieldBegin("statistics", ::apache::thrift::protocol::T_STRUCT, 12);
    xfer += this->statistics.write(oprot);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.encoding_stats) {
    xfer += oprot->writeFieldBegin("encoding_stats", ::apache::thrift::protocol::T_LIST, 13);
    {
      xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRUCT, static_cast<uint32_t>(this->encoding_stats.size()));
      duckdb::vector<PageEncodingStats> ::const_iterator _iter224;
      for (_iter224 = this->encoding_stats.begin(); _iter224 != this->encoding_stats.end(); ++_iter224)
      {
        xfer += (*_iter224).write(oprot);
      }
      xfer += oprot->writeListEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.bloom_filter_offset) {
    xfer += oprot->writeFieldBegin("bloom_filter_offset", ::apache::thrift::protocol::T_I64, 14);
    xfer += oprot->writeI64(this->bloom_filter_offset);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.bloom_filter_length) {
    xfer += oprot->writeFieldBegin("bloom_filter_length", ::apache::thrift::protocol::T_I32, 15);
    xfer += oprot->writeI32(this->bloom_filter_length);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.size_statistics) {
    xfer += oprot->writeFieldBegin("size_statistics", ::apache::thrift::protocol::T_STRUCT, 16);
    xfer += this->size_statistics.write(oprot);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.geospatial_statistics) {
    xfer += oprot->writeFieldBegin("geospatial_statistics", ::apache::thrift::protocol::T_STRUCT, 17);
    xfer += this->geospatial_statistics.write(oprot);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(ColumnMetaData &a, ColumnMetaData &b) {
  using ::std::swap;
  swap(a.type, b.type);
  swap(a.encodings, b.encodings);
  swap(a.path_in_schema, b.path_in_schema);
  swap(a.codec, b.codec);
  swap(a.num_values, b.num_values);
  swap(a.total_uncompressed_size, b.total_uncompressed_size);
  swap(a.total_compressed_size, b.total_compressed_size);
  swap(a.key_value_metadata, b.key_value_metadata);
  swap(a.data_page_offset, b.data_page_offset);
  swap(a.index_page_offset, b.index_page_offset);
  swap(a.dictionary_page_offset, b.dictionary_page_offset);
  swap(a.statistics, b.statistics);
  swap(a.encoding_stats, b.encoding_stats);
  swap(a.bloom_filter_offset, b.bloom_filter_offset);
  swap(a.bloom_filter_length, b.bloom_filter_length);
  swap(a.size_statistics, b.size_statistics);
  swap(a.geospatial_statistics, b.geospatial_statistics);
  swap(a.__isset, b.__isset);
}

ColumnMetaData::ColumnMetaData(const ColumnMetaData& other225) {
  type = other225.type;
  encodings = other225.encodings;
  path_in_schema = other225.path_in_schema;
  codec = other225.codec;
  num_values = other225.num_values;
  total_uncompressed_size = other225.total_uncompressed_size;
  total_compressed_size = other225.total_compressed_size;
  key_value_metadata = other225.key_value_metadata;
  data_page_offset = other225.data_page_offset;
  index_page_offset = other225.index_page_offset;
  dictionary_page_offset = other225.dictionary_page_offset;
  statistics = other225.statistics;
  encoding_stats = other225.encoding_stats;
  bloom_filter_offset = other225.bloom_filter_offset;
  bloom_filter_length = other225.bloom_filter_length;
  size_statistics = other225.size_statistics;
  geospatial_statistics = other225.geospatial_statistics;
  __isset = other225.__isset;
}
ColumnMetaData::ColumnMetaData(ColumnMetaData&& other226) noexcept {
  type = other226.type;
  encodings = std::move(other226.encodings);
  path_in_schema = std::move(other226.path_in_schema);
  codec = other226.codec;
  num_values = other226.num_values;
  total_uncompressed_size = other226.total_uncompressed_size;
  total_compressed_size = other226.total_compressed_size;
  key_value_metadata = std::move(other226.key_value_metadata);
  data_page_offset = other226.data_page_offset;
  index_page_offset = other226.index_page_offset;
  dictionary_page_offset = other226.dictionary_page_offset;
  statistics = std::move(other226.statistics);
  encoding_stats = std::move(other226.encoding_stats);
  bloom_filter_offset = other226.bloom_filter_offset;
  bloom_filter_length = other226.bloom_filter_length;
  size_statistics = std::move(other226.size_statistics);
  geospatial_statistics = std::move(other226.geospatial_statistics);
  __isset = other226.__isset;
}
ColumnMetaData& ColumnMetaData::operator=(const ColumnMetaData& other227) {
  type = other227.type;
  encodings = other227.encodings;
  path_in_schema = other227.path_in_schema;
  codec = other227.codec;
  num_values = other227.num_values;
  total_uncompressed_size = other227.total_uncompressed_size;
  total_compressed_size = other227.total_compressed_size;
  key_value_metadata = other227.key_value_metadata;
  data_page_offset = other227.data_page_offset;
  index_page_offset = other227.index_page_offset;
  dictionary_page_offset = other227.dictionary_page_offset;
  statistics = other227.statistics;
  encoding_stats = other227.encoding_stats;
  bloom_filter_offset = other227.bloom_filter_offset;
  bloom_filter_length = other227.bloom_filter_length;
  size_statistics = other227.size_statistics;
  geospatial_statistics = other227.geospatial_statistics;
  __isset = other227.__isset;
  return *this;
}
ColumnMetaData& ColumnMetaData::operator=(ColumnMetaData&& other228) noexcept {
  type = other228.type;
  encodings = std::move(other228.encodings);
  path_in_schema = std::move(other228.path_in_schema);
  codec = other228.codec;
  num_values = other228.num_values;
  total_uncompressed_size = other228.total_uncompressed_size;
  total_compressed_size = other228.total_compressed_size;
  key_value_metadata = std::move(other228.key_value_metadata);
  data_page_offset = other228.data_page_offset;
  index_page_offset = other228.index_page_offset;
  dictionary_page_offset = other228.dictionary_page_offset;
  statistics = std::move(other228.statistics);
  encoding_stats = std::move(other228.encoding_stats);
  bloom_filter_offset = other228.bloom_filter_offset;
  bloom_filter_length = other228.bloom_filter_length;
  size_statistics = std::move(other228.size_statistics);
  geospatial_statistics = std::move(other228.geospatial_statistics);
  __isset = other228.__isset;
  return *this;
}
void ColumnMetaData::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "ColumnMetaData(";
  out << "type=" << to_string(type);
  out << ", " << "encodings=" << to_string(encodings);
  out << ", " << "path_in_schema=" << to_string(path_in_schema);
  out << ", " << "codec=" << to_string(codec);
  out << ", " << "num_values=" << to_string(num_values);
  out << ", " << "total_uncompressed_size=" << to_string(total_uncompressed_size);
  out << ", " << "total_compressed_size=" << to_string(total_compressed_size);
  out << ", " << "key_value_metadata="; (__isset.key_value_metadata ? (out << to_string(key_value_metadata)) : (out << "<null>"));
  out << ", " << "data_page_offset=" << to_string(data_page_offset);
  out << ", " << "index_page_offset="; (__isset.index_page_offset ? (out << to_string(index_page_offset)) : (out << "<null>"));
  out << ", " << "dictionary_page_offset="; (__isset.dictionary_page_offset ? (out << to_string(dictionary_page_offset)) : (out << "<null>"));
  out << ", " << "statistics="; (__isset.statistics ? (out << to_string(statistics)) : (out << "<null>"));
  out << ", " << "encoding_stats="; (__isset.encoding_stats ? (out << to_string(encoding_stats)) : (out << "<null>"));
  out << ", " << "bloom_filter_offset="; (__isset.bloom_filter_offset ? (out << to_string(bloom_filter_offset)) : (out << "<null>"));
  out << ", " << "bloom_filter_length="; (__isset.bloom_filter_length ? (out << to_string(bloom_filter_length)) : (out << "<null>"));
  out << ", " << "size_statistics="; (__isset.size_statistics ? (out << to_string(size_statistics)) : (out << "<null>"));
  out << ", " << "geospatial_statistics="; (__isset.geospatial_statistics ? (out << to_string(geospatial_statistics)) : (out << "<null>"));
  out << ")";
}


EncryptionWithFooterKey::~EncryptionWithFooterKey() noexcept {
}

EncryptionWithFooterKey::EncryptionWithFooterKey() noexcept {
}
std::ostream& operator<<(std::ostream& out, const EncryptionWithFooterKey& obj)
{
  obj.printTo(out);
  return out;
}


uint32_t EncryptionWithFooterKey::read(::apache::thrift::protocol::TProtocol* iprot) {

  ::apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;


  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    xfer += iprot->skip(ftype);
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  return xfer;
}

uint32_t EncryptionWithFooterKey::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  ::apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("EncryptionWithFooterKey");

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(EncryptionWithFooterKey &a, EncryptionWithFooterKey &b) {
  using ::std::swap;
  (void) a;
  (void) b;
}

EncryptionWithFooterKey::EncryptionWithFooterKey(const EncryptionWithFooterKey& other229) noexcept {
  (void) other229;
}
EncryptionWithFooterKey::EncryptionWithFooterKey(EncryptionWithFooterKey&& other230) noexcept {
  (void) other230;
}
EncryptionWithFooterKey& EncryptionWithFooterKey::operator=(const EncryptionWithFooterKey& other231) noexcept {
  (void) other231;
  return *this;
}
EncryptionWithFooterKey& EncryptionWithFooterKey::operator=(EncryptionWithFooterKey&& other232) noexcept {
  (void) other232;
  return *this;
}
void EncryptionWithFooterKey::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "EncryptionWithFooterKey(";
  out << ")";
}


EncryptionWithColumnKey::~EncryptionWithColumnKey() noexcept {
}

EncryptionWithColumnKey::EncryptionWithColumnKey() noexcept
   : key_metadata() {
}

void EncryptionWithColumnKey::__set_path_in_schema(const duckdb::vector<std::string> & val) {
  this->path_in_schema = val;
}

void EncryptionWithColumnKey::__set_key_metadata(const std::string& val) {
  this->key_metadata = val;
__isset.key_metadata = true;
}
std::ostream& operator<<(std::ostream& out, const EncryptionWithColumnKey& obj)
{
  obj.printTo(out);
  return out;
}


uint32_t EncryptionWithColumnKey::read(::apache::thrift::protocol::TProtocol* iprot) {

  ::apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_path_in_schema = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->path_in_schema.clear();
            uint32_t _size233;
            ::apache::thrift::protocol::TType _etype236;
            xfer += iprot->readListBegin(_etype236, _size233);
            this->path_in_schema.resize(_size233);
            uint32_t _i237;
            for (_i237 = 0; _i237 < _size233; ++_i237)
            {
              xfer += iprot->readString(this->path_in_schema[_i237]);
            }
            xfer += iprot->readListEnd();
          }
          isset_path_in_schema = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readBinary(this->key_metadata);
          this->__isset.key_metadata = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_path_in_schema)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t EncryptionWithColumnKey::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  ::apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("EncryptionWithColumnKey");

  xfer += oprot->writeFieldBegin("path_in_schema", ::apache::thrift::protocol::T_LIST, 1);
  {
    xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRING, static_cast<uint32_t>(this->path_in_schema.size()));
    duckdb::vector<std::string> ::const_iterator _iter238;
    for (_iter238 = this->path_in_schema.begin(); _iter238 != this->path_in_schema.end(); ++_iter238)
    {
      xfer += oprot->writeString((*_iter238));
    }
    xfer += oprot->writeListEnd();
  }
  xfer += oprot->writeFieldEnd();

  if (this->__isset.key_metadata) {
    xfer += oprot->writeFieldBegin("key_metadata", ::apache::thrift::protocol::T_STRING, 2);
    xfer += oprot->writeBinary(this->key_metadata);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(EncryptionWithColumnKey &a, EncryptionWithColumnKey &b) {
  using ::std::swap;
  swap(a.path_in_schema, b.path_in_schema);
  swap(a.key_metadata, b.key_metadata);
  swap(a.__isset, b.__isset);
}

EncryptionWithColumnKey::EncryptionWithColumnKey(const EncryptionWithColumnKey& other239) {
  path_in_schema = other239.path_in_schema;
  key_metadata = other239.key_metadata;
  __isset = other239.__isset;
}
EncryptionWithColumnKey::EncryptionWithColumnKey(EncryptionWithColumnKey&& other240) noexcept {
  path_in_schema = std::move(other240.path_in_schema);
  key_metadata = std::move(other240.key_metadata);
  __isset = other240.__isset;
}
EncryptionWithColumnKey& EncryptionWithColumnKey::operator=(const EncryptionWithColumnKey& other241) {
  path_in_schema = other241.path_in_schema;
  key_metadata = other241.key_metadata;
  __isset = other241.__isset;
  return *this;
}
EncryptionWithColumnKey& EncryptionWithColumnKey::operator=(EncryptionWithColumnKey&& other242) noexcept {
  path_in_schema = std::move(other242.path_in_schema);
  key_metadata = std::move(other242.key_metadata);
  __isset = other242.__isset;
  return *this;
}
void EncryptionWithColumnKey::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "EncryptionWithColumnKey(";
  out << "path_in_schema=" << to_string(path_in_schema);
  out << ", " << "key_metadata="; (__isset.key_metadata ? (out << to_string(key_metadata)) : (out << "<null>"));
  out << ")";
}


ColumnCryptoMetaData::~ColumnCryptoMetaData() noexcept {
}

ColumnCryptoMetaData::ColumnCryptoMetaData() noexcept {
}

void ColumnCryptoMetaData::__set_ENCRYPTION_WITH_FOOTER_KEY(const EncryptionWithFooterKey& val) {
  this->ENCRYPTION_WITH_FOOTER_KEY = val;
__isset.ENCRYPTION_WITH_FOOTER_KEY = true;
}

void ColumnCryptoMetaData::__set_ENCRYPTION_WITH_COLUMN_KEY(const EncryptionWithColumnKey& val) {
  this->ENCRYPTION_WITH_COLUMN_KEY = val;
__isset.ENCRYPTION_WITH_COLUMN_KEY = true;
}
std::ostream& operator<<(std::ostream& out, const ColumnCryptoMetaData& obj)
{
  obj.printTo(out);
  return out;
}


uint32_t ColumnCryptoMetaData::read(::apache::thrift::protocol::TProtocol* iprot) {

  ::apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;


  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->ENCRYPTION_WITH_FOOTER_KEY.read(iprot);
          this->__isset.ENCRYPTION_WITH_FOOTER_KEY = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->ENCRYPTION_WITH_COLUMN_KEY.read(iprot);
          this->__isset.ENCRYPTION_WITH_COLUMN_KEY = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  return xfer;
}

uint32_t ColumnCryptoMetaData::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  ::apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("ColumnCryptoMetaData");

  if (this->__isset.ENCRYPTION_WITH_FOOTER_KEY) {
    xfer += oprot->writeFieldBegin("ENCRYPTION_WITH_FOOTER_KEY", ::apache::thrift::protocol::T_STRUCT, 1);
    xfer += this->ENCRYPTION_WITH_FOOTER_KEY.write(oprot);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.ENCRYPTION_WITH_COLUMN_KEY) {
    xfer += oprot->writeFieldBegin("ENCRYPTION_WITH_COLUMN_KEY", ::apache::thrift::protocol::T_STRUCT, 2);
    xfer += this->ENCRYPTION_WITH_COLUMN_KEY.write(oprot);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(ColumnCryptoMetaData &a, ColumnCryptoMetaData &b) {
  using ::std::swap;
  swap(a.ENCRYPTION_WITH_FOOTER_KEY, b.ENCRYPTION_WITH_FOOTER_KEY);
  swap(a.ENCRYPTION_WITH_COLUMN_KEY, b.ENCRYPTION_WITH_COLUMN_KEY);
  swap(a.__isset, b.__isset);
}

ColumnCryptoMetaData::ColumnCryptoMetaData(const ColumnCryptoMetaData& other243) {
  ENCRYPTION_WITH_FOOTER_KEY = other243.ENCRYPTION_WITH_FOOTER_KEY;
  ENCRYPTION_WITH_COLUMN_KEY = other243.ENCRYPTION_WITH_COLUMN_KEY;
  __isset = other243.__isset;
}
ColumnCryptoMetaData::ColumnCryptoMetaData(ColumnCryptoMetaData&& other244) noexcept {
  ENCRYPTION_WITH_FOOTER_KEY = std::move(other244.ENCRYPTION_WITH_FOOTER_KEY);
  ENCRYPTION_WITH_COLUMN_KEY = std::move(other244.ENCRYPTION_WITH_COLUMN_KEY);
  __isset = other244.__isset;
}
ColumnCryptoMetaData& ColumnCryptoMetaData::operator=(const ColumnCryptoMetaData& other245) {
  ENCRYPTION_WITH_FOOTER_KEY = other245.ENCRYPTION_WITH_FOOTER_KEY;
  ENCRYPTION_WITH_COLUMN_KEY = other245.ENCRYPTION_WITH_COLUMN_KEY;
  __isset = other245.__isset;
  return *this;
}
ColumnCryptoMetaData& ColumnCryptoMetaData::operator=(ColumnCryptoMetaData&& other246) noexcept {
  ENCRYPTION_WITH_FOOTER_KEY = std::move(other246.ENCRYPTION_WITH_FOOTER_KEY);
  ENCRYPTION_WITH_COLUMN_KEY = std::move(other246.ENCRYPTION_WITH_COLUMN_KEY);
  __isset = other246.__isset;
  return *this;
}
void ColumnCryptoMetaData::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "ColumnCryptoMetaData(";
  out << "ENCRYPTION_WITH_FOOTER_KEY="; (__isset.ENCRYPTION_WITH_FOOTER_KEY ? (out << to_string(ENCRYPTION_WITH_FOOTER_KEY)) : (out << "<null>"));
  out << ", " << "ENCRYPTION_WITH_COLUMN_KEY="; (__isset.ENCRYPTION_WITH_COLUMN_KEY ? (out << to_string(ENCRYPTION_WITH_COLUMN_KEY)) : (out << "<null>"));
  out << ")";
}


ColumnChunk::~ColumnChunk() noexcept {
}

ColumnChunk::ColumnChunk() noexcept
   : file_path(),
     file_offset(0LL),
     offset_index_offset(0),
     offset_index_length(0),
     column_index_offset(0),
     column_index_length(0),
     encrypted_column_metadata() {
}

void ColumnChunk::__set_file_path(const std::string& val) {
  this->file_path = val;
__isset.file_path = true;
}

void ColumnChunk::__set_file_offset(const int64_t val) {
  this->file_offset = val;
}

void ColumnChunk::__set_meta_data(const ColumnMetaData& val) {
  this->meta_data = val;
__isset.meta_data = true;
}

void ColumnChunk::__set_offset_index_offset(const int64_t val) {
  this->offset_index_offset = val;
__isset.offset_index_offset = true;
}

void ColumnChunk::__set_offset_index_length(const int32_t val) {
  this->offset_index_length = val;
__isset.offset_index_length = true;
}

void ColumnChunk::__set_column_index_offset(const int64_t val) {
  this->column_index_offset = val;
__isset.column_index_offset = true;
}

void ColumnChunk::__set_column_index_length(const int32_t val) {
  this->column_index_length = val;
__isset.column_index_length = true;
}

void ColumnChunk::__set_crypto_metadata(const ColumnCryptoMetaData& val) {
  this->crypto_metadata = val;
__isset.crypto_metadata = true;
}

void ColumnChunk::__set_encrypted_column_metadata(const std::string& val) {
  this->encrypted_column_metadata = val;
__isset.encrypted_column_metadata = true;
}
std::ostream& operator<<(std::ostream& out, const ColumnChunk& obj)
{
  obj.printTo(out);
  return out;
}


uint32_t ColumnChunk::read(::apache::thrift::protocol::TProtocol* iprot) {

  ::apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_file_offset = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->file_path);
          this->__isset.file_path = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_I64) {
          xfer += iprot->readI64(this->file_offset);
          isset_file_offset = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->meta_data.read(iprot);
          this->__isset.meta_data = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 4:
        if (ftype == ::apache::thrift::protocol::T_I64) {
          xfer += iprot->readI64(this->offset_index_offset);
          this->__isset.offset_index_offset = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 5:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->offset_index_length);
          this->__isset.offset_index_length = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 6:
        if (ftype == ::apache::thrift::protocol::T_I64) {
          xfer += iprot->readI64(this->column_index_offset);
          this->__isset.column_index_offset = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 7:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->column_index_length);
          this->__isset.column_index_length = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 8:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->crypto_metadata.read(iprot);
          this->__isset.crypto_metadata = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 9:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readBinary(this->encrypted_column_metadata);
          this->__isset.encrypted_column_metadata = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_file_offset)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t ColumnChunk::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  ::apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("ColumnChunk");

  if (this->__isset.file_path) {
    xfer += oprot->writeFieldBegin("file_path", ::apache::thrift::protocol::T_STRING, 1);
    xfer += oprot->writeString(this->file_path);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldBegin("file_offset", ::apache::thrift::protocol::T_I64, 2);
  xfer += oprot->writeI64(this->file_offset);
  xfer += oprot->writeFieldEnd();

  if (this->__isset.meta_data) {
    xfer += oprot->writeFieldBegin("meta_data", ::apache::thrift::protocol::T_STRUCT, 3);
    xfer += this->meta_data.write(oprot);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.offset_index_offset) {
    xfer += oprot->writeFieldBegin("offset_index_offset", ::apache::thrift::protocol::T_I64, 4);
    xfer += oprot->writeI64(this->offset_index_offset);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.offset_index_length) {
    xfer += oprot->writeFieldBegin("offset_index_length", ::apache::thrift::protocol::T_I32, 5);
    xfer += oprot->writeI32(this->offset_index_length);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.column_index_offset) {
    xfer += oprot->writeFieldBegin("column_index_offset", ::apache::thrift::protocol::T_I64, 6);
    xfer += oprot->writeI64(this->column_index_offset);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.column_index_length) {
    xfer += oprot->writeFieldBegin("column_index_length", ::apache::thrift::protocol::T_I32, 7);
    xfer += oprot->writeI32(this->column_index_length);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.crypto_metadata) {
    xfer += oprot->writeFieldBegin("crypto_metadata", ::apache::thrift::protocol::T_STRUCT, 8);
    xfer += this->crypto_metadata.write(oprot);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.encrypted_column_metadata) {
    xfer += oprot->writeFieldBegin("encrypted_column_metadata", ::apache::thrift::protocol::T_STRING, 9);
    xfer += oprot->writeBinary(this->encrypted_column_metadata);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(ColumnChunk &a, ColumnChunk &b) {
  using ::std::swap;
  swap(a.file_path, b.file_path);
  swap(a.file_offset, b.file_offset);
  swap(a.meta_data, b.meta_data);
  swap(a.offset_index_offset, b.offset_index_offset);
  swap(a.offset_index_length, b.offset_index_length);
  swap(a.column_index_offset, b.column_index_offset);
  swap(a.column_index_length, b.column_index_length);
  swap(a.crypto_metadata, b.crypto_metadata);
  swap(a.encrypted_column_metadata, b.encrypted_column_metadata);
  swap(a.__isset, b.__isset);
}

ColumnChunk::ColumnChunk(const ColumnChunk& other247) {
  file_path = other247.file_path;
  file_offset = other247.file_offset;
  meta_data = other247.meta_data;
  offset_index_offset = other247.offset_index_offset;
  offset_index_length = other247.offset_index_length;
  column_index_offset = other247.column_index_offset;
  column_index_length = other247.column_index_length;
  crypto_metadata = other247.crypto_metadata;
  encrypted_column_metadata = other247.encrypted_column_metadata;
  __isset = other247.__isset;
}
ColumnChunk::ColumnChunk(ColumnChunk&& other248) noexcept {
  file_path = std::move(other248.file_path);
  file_offset = other248.file_offset;
  meta_data = std::move(other248.meta_data);
  offset_index_offset = other248.offset_index_offset;
  offset_index_length = other248.offset_index_length;
  column_index_offset = other248.column_index_offset;
  column_index_length = other248.column_index_length;
  crypto_metadata = std::move(other248.crypto_metadata);
  encrypted_column_metadata = std::move(other248.encrypted_column_metadata);
  __isset = other248.__isset;
}
ColumnChunk& ColumnChunk::operator=(const ColumnChunk& other249) {
  file_path = other249.file_path;
  file_offset = other249.file_offset;
  meta_data = other249.meta_data;
  offset_index_offset = other249.offset_index_offset;
  offset_index_length = other249.offset_index_length;
  column_index_offset = other249.column_index_offset;
  column_index_length = other249.column_index_length;
  crypto_metadata = other249.crypto_metadata;
  encrypted_column_metadata = other249.encrypted_column_metadata;
  __isset = other249.__isset;
  return *this;
}
ColumnChunk& ColumnChunk::operator=(ColumnChunk&& other250) noexcept {
  file_path = std::move(other250.file_path);
  file_offset = other250.file_offset;
  meta_data = std::move(other250.meta_data);
  offset_index_offset = other250.offset_index_offset;
  offset_index_length = other250.offset_index_length;
  column_index_offset = other250.column_index_offset;
  column_index_length = other250.column_index_length;
  crypto_metadata = std::move(other250.crypto_metadata);
  encrypted_column_metadata = std::move(other250.encrypted_column_metadata);
  __isset = other250.__isset;
  return *this;
}
void ColumnChunk::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "ColumnChunk(";
  out << "file_path="; (__isset.file_path ? (out << to_string(file_path)) : (out << "<null>"));
  out << ", " << "file_offset=" << to_string(file_offset);
  out << ", " << "meta_data="; (__isset.meta_data ? (out << to_string(meta_data)) : (out << "<null>"));
  out << ", " << "offset_index_offset="; (__isset.offset_index_offset ? (out << to_string(offset_index_offset)) : (out << "<null>"));
  out << ", " << "offset_index_length="; (__isset.offset_index_length ? (out << to_string(offset_index_length)) : (out << "<null>"));
  out << ", " << "column_index_offset="; (__isset.column_index_offset ? (out << to_string(column_index_offset)) : (out << "<null>"));
  out << ", " << "column_index_length="; (__isset.column_index_length ? (out << to_string(column_index_length)) : (out << "<null>"));
  out << ", " << "crypto_metadata="; (__isset.crypto_metadata ? (out << to_string(crypto_metadata)) : (out << "<null>"));
  out << ", " << "encrypted_column_metadata="; (__isset.encrypted_column_metadata ? (out << to_string(encrypted_column_metadata)) : (out << "<null>"));
  out << ")";
}


RowGroup::~RowGroup() noexcept {
}

RowGroup::RowGroup() noexcept
   : total_byte_size(0),
     num_rows(0),
     file_offset(0),
     total_compressed_size(0),
     ordinal(0) {
}

void RowGroup::__set_columns(const duckdb::vector<ColumnChunk> & val) {
  this->columns = val;
}

void RowGroup::__set_total_byte_size(const int64_t val) {
  this->total_byte_size = val;
}

void RowGroup::__set_num_rows(const int64_t val) {
  this->num_rows = val;
}

void RowGroup::__set_sorting_columns(const duckdb::vector<SortingColumn> & val) {
  this->sorting_columns = val;
__isset.sorting_columns = true;
}

void RowGroup::__set_file_offset(const int64_t val) {
  this->file_offset = val;
__isset.file_offset = true;
}

void RowGroup::__set_total_compressed_size(const int64_t val) {
  this->total_compressed_size = val;
__isset.total_compressed_size = true;
}

void RowGroup::__set_ordinal(const int16_t val) {
  this->ordinal = val;
__isset.ordinal = true;
}
std::ostream& operator<<(std::ostream& out, const RowGroup& obj)
{
  obj.printTo(out);
  return out;
}


uint32_t RowGroup::read(::apache::thrift::protocol::TProtocol* iprot) {

  ::apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_columns = false;
  bool isset_total_byte_size = false;
  bool isset_num_rows = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->columns.clear();
            uint32_t _size251;
            ::apache::thrift::protocol::TType _etype254;
            xfer += iprot->readListBegin(_etype254, _size251);
            this->columns.resize(_size251);
            uint32_t _i255;
            for (_i255 = 0; _i255 < _size251; ++_i255)
            {
              xfer += this->columns[_i255].read(iprot);
            }
            xfer += iprot->readListEnd();
          }
          isset_columns = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_I64) {
          xfer += iprot->readI64(this->total_byte_size);
          isset_total_byte_size = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_I64) {
          xfer += iprot->readI64(this->num_rows);
          isset_num_rows = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 4:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->sorting_columns.clear();
            uint32_t _size256;
            ::apache::thrift::protocol::TType _etype259;
            xfer += iprot->readListBegin(_etype259, _size256);
            this->sorting_columns.resize(_size256);
            uint32_t _i260;
            for (_i260 = 0; _i260 < _size256; ++_i260)
            {
              xfer += this->sorting_columns[_i260].read(iprot);
            }
            xfer += iprot->readListEnd();
          }
          this->__isset.sorting_columns = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 5:
        if (ftype == ::apache::thrift::protocol::T_I64) {
          xfer += iprot->readI64(this->file_offset);
          this->__isset.file_offset = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 6:
        if (ftype == ::apache::thrift::protocol::T_I64) {
          xfer += iprot->readI64(this->total_compressed_size);
          this->__isset.total_compressed_size = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 7:
        if (ftype == ::apache::thrift::protocol::T_I16) {
          xfer += iprot->readI16(this->ordinal);
          this->__isset.ordinal = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_columns)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_total_byte_size)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_num_rows)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t RowGroup::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  ::apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("RowGroup");

  xfer += oprot->writeFieldBegin("columns", ::apache::thrift::protocol::T_LIST, 1);
  {
    xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRUCT, static_cast<uint32_t>(this->columns.size()));
    duckdb::vector<ColumnChunk> ::const_iterator _iter261;
    for (_iter261 = this->columns.begin(); _iter261 != this->columns.end(); ++_iter261)
    {
      xfer += (*_iter261).write(oprot);
    }
    xfer += oprot->writeListEnd();
  }
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("total_byte_size", ::apache::thrift::protocol::T_I64, 2);
  xfer += oprot->writeI64(this->total_byte_size);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("num_rows", ::apache::thrift::protocol::T_I64, 3);
  xfer += oprot->writeI64(this->num_rows);
  xfer += oprot->writeFieldEnd();

  if (this->__isset.sorting_columns) {
    xfer += oprot->writeFieldBegin("sorting_columns", ::apache::thrift::protocol::T_LIST, 4);
    {
      xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRUCT, static_cast<uint32_t>(this->sorting_columns.size()));
      duckdb::vector<SortingColumn> ::const_iterator _iter262;
      for (_iter262 = this->sorting_columns.begin(); _iter262 != this->sorting_columns.end(); ++_iter262)
      {
        xfer += (*_iter262).write(oprot);
      }
      xfer += oprot->writeListEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.file_offset) {
    xfer += oprot->writeFieldBegin("file_offset", ::apache::thrift::protocol::T_I64, 5);
    xfer += oprot->writeI64(this->file_offset);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.total_compressed_size) {
    xfer += oprot->writeFieldBegin("total_compressed_size", ::apache::thrift::protocol::T_I64, 6);
    xfer += oprot->writeI64(this->total_compressed_size);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.ordinal) {
    xfer += oprot->writeFieldBegin("ordinal", ::apache::thrift::protocol::T_I16, 7);
    xfer += oprot->writeI16(this->ordinal);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(RowGroup &a, RowGroup &b) {
  using ::std::swap;
  swap(a.columns, b.columns);
  swap(a.total_byte_size, b.total_byte_size);
  swap(a.num_rows, b.num_rows);
  swap(a.sorting_columns, b.sorting_columns);
  swap(a.file_offset, b.file_offset);
  swap(a.total_compressed_size, b.total_compressed_size);
  swap(a.ordinal, b.ordinal);
  swap(a.__isset, b.__isset);
}

RowGroup::RowGroup(const RowGroup& other263) {
  columns = other263.columns;
  total_byte_size = other263.total_byte_size;
  num_rows = other263.num_rows;
  sorting_columns = other263.sorting_columns;
  file_offset = other263.file_offset;
  total_compressed_size = other263.total_compressed_size;
  ordinal = other263.ordinal;
  __isset = other263.__isset;
}
RowGroup::RowGroup(RowGroup&& other264) noexcept {
  columns = std::move(other264.columns);
  total_byte_size = other264.total_byte_size;
  num_rows = other264.num_rows;
  sorting_columns = std::move(other264.sorting_columns);
  file_offset = other264.file_offset;
  total_compressed_size = other264.total_compressed_size;
  ordinal = other264.ordinal;
  __isset = other264.__isset;
}
RowGroup& RowGroup::operator=(const RowGroup& other265) {
  columns = other265.columns;
  total_byte_size = other265.total_byte_size;
  num_rows = other265.num_rows;
  sorting_columns = other265.sorting_columns;
  file_offset = other265.file_offset;
  total_compressed_size = other265.total_compressed_size;
  ordinal = other265.ordinal;
  __isset = other265.__isset;
  return *this;
}
RowGroup& RowGroup::operator=(RowGroup&& other266) noexcept {
  columns = std::move(other266.columns);
  total_byte_size = other266.total_byte_size;
  num_rows = other266.num_rows;
  sorting_columns = std::move(other266.sorting_columns);
  file_offset = other266.file_offset;
  total_compressed_size = other266.total_compressed_size;
  ordinal = other266.ordinal;
  __isset = other266.__isset;
  return *this;
}
void RowGroup::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "RowGroup(";
  out << "columns=" << to_string(columns);
  out << ", " << "total_byte_size=" << to_string(total_byte_size);
  out << ", " << "num_rows=" << to_string(num_rows);
  out << ", " << "sorting_columns="; (__isset.sorting_columns ? (out << to_string(sorting_columns)) : (out << "<null>"));
  out << ", " << "file_offset="; (__isset.file_offset ? (out << to_string(file_offset)) : (out << "<null>"));
  out << ", " << "total_compressed_size="; (__isset.total_compressed_size ? (out << to_string(total_compressed_size)) : (out << "<null>"));
  out << ", " << "ordinal="; (__isset.ordinal ? (out << to_string(ordinal)) : (out << "<null>"));
  out << ")";
}


TypeDefinedOrder::~TypeDefinedOrder() noexcept {
}

TypeDefinedOrder::TypeDefinedOrder() noexcept {
}
std::ostream& operator<<(std::ostream& out, const TypeDefinedOrder& obj)
{
  obj.printTo(out);
  return out;
}


uint32_t TypeDefinedOrder::read(::apache::thrift::protocol::TProtocol* iprot) {

  ::apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;


  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    xfer += iprot->skip(ftype);
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  return xfer;
}

uint32_t TypeDefinedOrder::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  ::apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("TypeDefinedOrder");

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(TypeDefinedOrder &a, TypeDefinedOrder &b) {
  using ::std::swap;
  (void) a;
  (void) b;
}

TypeDefinedOrder::TypeDefinedOrder(const TypeDefinedOrder& other267) noexcept {
  (void) other267;
}
TypeDefinedOrder::TypeDefinedOrder(TypeDefinedOrder&& other268) noexcept {
  (void) other268;
}
TypeDefinedOrder& TypeDefinedOrder::operator=(const TypeDefinedOrder& other269) noexcept {
  (void) other269;
  return *this;
}
TypeDefinedOrder& TypeDefinedOrder::operator=(TypeDefinedOrder&& other270) noexcept {
  (void) other270;
  return *this;
}
void TypeDefinedOrder::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "TypeDefinedOrder(";
  out << ")";
}


ColumnOrder::~ColumnOrder() noexcept {
}

ColumnOrder::ColumnOrder() noexcept {
}

void ColumnOrder::__set_TYPE_ORDER(const TypeDefinedOrder& val) {
  this->TYPE_ORDER = val;
__isset.TYPE_ORDER = true;
}
std::ostream& operator<<(std::ostream& out, const ColumnOrder& obj)
{
  obj.printTo(out);
  return out;
}


uint32_t ColumnOrder::read(::apache::thrift::protocol::TProtocol* iprot) {

  ::apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;


  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->TYPE_ORDER.read(iprot);
          this->__isset.TYPE_ORDER = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  return xfer;
}

uint32_t ColumnOrder::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  ::apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("ColumnOrder");

  if (this->__isset.TYPE_ORDER) {
    xfer += oprot->writeFieldBegin("TYPE_ORDER", ::apache::thrift::protocol::T_STRUCT, 1);
    xfer += this->TYPE_ORDER.write(oprot);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(ColumnOrder &a, ColumnOrder &b) {
  using ::std::swap;
  swap(a.TYPE_ORDER, b.TYPE_ORDER);
  swap(a.__isset, b.__isset);
}

ColumnOrder::ColumnOrder(const ColumnOrder& other271) noexcept {
  TYPE_ORDER = other271.TYPE_ORDER;
  __isset = other271.__isset;
}
ColumnOrder::ColumnOrder(ColumnOrder&& other272) noexcept {
  TYPE_ORDER = std::move(other272.TYPE_ORDER);
  __isset = other272.__isset;
}
ColumnOrder& ColumnOrder::operator=(const ColumnOrder& other273) noexcept {
  TYPE_ORDER = other273.TYPE_ORDER;
  __isset = other273.__isset;
  return *this;
}
ColumnOrder& ColumnOrder::operator=(ColumnOrder&& other274) noexcept {
  TYPE_ORDER = std::move(other274.TYPE_ORDER);
  __isset = other274.__isset;
  return *this;
}
void ColumnOrder::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "ColumnOrder(";
  out << "TYPE_ORDER="; (__isset.TYPE_ORDER ? (out << to_string(TYPE_ORDER)) : (out << "<null>"));
  out << ")";
}


PageLocation::~PageLocation() noexcept {
}

PageLocation::PageLocation() noexcept
   : offset(0),
     compressed_page_size(0),
     first_row_index(0) {
}

void PageLocation::__set_offset(const int64_t val) {
  this->offset = val;
}

void PageLocation::__set_compressed_page_size(const int32_t val) {
  this->compressed_page_size = val;
}

void PageLocation::__set_first_row_index(const int64_t val) {
  this->first_row_index = val;
}
std::ostream& operator<<(std::ostream& out, const PageLocation& obj)
{
  obj.printTo(out);
  return out;
}


uint32_t PageLocation::read(::apache::thrift::protocol::TProtocol* iprot) {

  ::apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_offset = false;
  bool isset_compressed_page_size = false;
  bool isset_first_row_index = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_I64) {
          xfer += iprot->readI64(this->offset);
          isset_offset = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->compressed_page_size);
          isset_compressed_page_size = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_I64) {
          xfer += iprot->readI64(this->first_row_index);
          isset_first_row_index = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_offset)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_compressed_page_size)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_first_row_index)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t PageLocation::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  ::apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("PageLocation");

  xfer += oprot->writeFieldBegin("offset", ::apache::thrift::protocol::T_I64, 1);
  xfer += oprot->writeI64(this->offset);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("compressed_page_size", ::apache::thrift::protocol::T_I32, 2);
  xfer += oprot->writeI32(this->compressed_page_size);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("first_row_index", ::apache::thrift::protocol::T_I64, 3);
  xfer += oprot->writeI64(this->first_row_index);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(PageLocation &a, PageLocation &b) {
  using ::std::swap;
  swap(a.offset, b.offset);
  swap(a.compressed_page_size, b.compressed_page_size);
  swap(a.first_row_index, b.first_row_index);
}

PageLocation::PageLocation(const PageLocation& other275) noexcept {
  offset = other275.offset;
  compressed_page_size = other275.compressed_page_size;
  first_row_index = other275.first_row_index;
}
PageLocation::PageLocation(PageLocation&& other276) noexcept {
  offset = other276.offset;
  compressed_page_size = other276.compressed_page_size;
  first_row_index = other276.first_row_index;
}
PageLocation& PageLocation::operator=(const PageLocation& other277) noexcept {
  offset = other277.offset;
  compressed_page_size = other277.compressed_page_size;
  first_row_index = other277.first_row_index;
  return *this;
}
PageLocation& PageLocation::operator=(PageLocation&& other278) noexcept {
  offset = other278.offset;
  compressed_page_size = other278.compressed_page_size;
  first_row_index = other278.first_row_index;
  return *this;
}
void PageLocation::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "PageLocation(";
  out << "offset=" << to_string(offset);
  out << ", " << "compressed_page_size=" << to_string(compressed_page_size);
  out << ", " << "first_row_index=" << to_string(first_row_index);
  out << ")";
}


OffsetIndex::~OffsetIndex() noexcept {
}

OffsetIndex::OffsetIndex() noexcept {
}

void OffsetIndex::__set_page_locations(const duckdb::vector<PageLocation> & val) {
  this->page_locations = val;
}

void OffsetIndex::__set_unencoded_byte_array_data_bytes(const duckdb::vector<int64_t> & val) {
  this->unencoded_byte_array_data_bytes = val;
__isset.unencoded_byte_array_data_bytes = true;
}
std::ostream& operator<<(std::ostream& out, const OffsetIndex& obj)
{
  obj.printTo(out);
  return out;
}


uint32_t OffsetIndex::read(::apache::thrift::protocol::TProtocol* iprot) {

  ::apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_page_locations = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->page_locations.clear();
            uint32_t _size279;
            ::apache::thrift::protocol::TType _etype282;
            xfer += iprot->readListBegin(_etype282, _size279);
            this->page_locations.resize(_size279);
            uint32_t _i283;
            for (_i283 = 0; _i283 < _size279; ++_i283)
            {
              xfer += this->page_locations[_i283].read(iprot);
            }
            xfer += iprot->readListEnd();
          }
          isset_page_locations = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->unencoded_byte_array_data_bytes.clear();
            uint32_t _size284;
            ::apache::thrift::protocol::TType _etype287;
            xfer += iprot->readListBegin(_etype287, _size284);
            this->unencoded_byte_array_data_bytes.resize(_size284);
            uint32_t _i288;
            for (_i288 = 0; _i288 < _size284; ++_i288)
            {
              xfer += iprot->readI64(this->unencoded_byte_array_data_bytes[_i288]);
            }
            xfer += iprot->readListEnd();
          }
          this->__isset.unencoded_byte_array_data_bytes = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_page_locations)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t OffsetIndex::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  ::apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("OffsetIndex");

  xfer += oprot->writeFieldBegin("page_locations", ::apache::thrift::protocol::T_LIST, 1);
  {
    xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRUCT, static_cast<uint32_t>(this->page_locations.size()));
    duckdb::vector<PageLocation> ::const_iterator _iter289;
    for (_iter289 = this->page_locations.begin(); _iter289 != this->page_locations.end(); ++_iter289)
    {
      xfer += (*_iter289).write(oprot);
    }
    xfer += oprot->writeListEnd();
  }
  xfer += oprot->writeFieldEnd();

  if (this->__isset.unencoded_byte_array_data_bytes) {
    xfer += oprot->writeFieldBegin("unencoded_byte_array_data_bytes", ::apache::thrift::protocol::T_LIST, 2);
    {
      xfer += oprot->writeListBegin(::apache::thrift::protocol::T_I64, static_cast<uint32_t>(this->unencoded_byte_array_data_bytes.size()));
      duckdb::vector<int64_t> ::const_iterator _iter290;
      for (_iter290 = this->unencoded_byte_array_data_bytes.begin(); _iter290 != this->unencoded_byte_array_data_bytes.end(); ++_iter290)
      {
        xfer += oprot->writeI64((*_iter290));
      }
      xfer += oprot->writeListEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(OffsetIndex &a, OffsetIndex &b) {
  using ::std::swap;
  swap(a.page_locations, b.page_locations);
  swap(a.unencoded_byte_array_data_bytes, b.unencoded_byte_array_data_bytes);
  swap(a.__isset, b.__isset);
}

OffsetIndex::OffsetIndex(const OffsetIndex& other291) {
  page_locations = other291.page_locations;
  unencoded_byte_array_data_bytes = other291.unencoded_byte_array_data_bytes;
  __isset = other291.__isset;
}
OffsetIndex::OffsetIndex(OffsetIndex&& other292) noexcept {
  page_locations = std::move(other292.page_locations);
  unencoded_byte_array_data_bytes = std::move(other292.unencoded_byte_array_data_bytes);
  __isset = other292.__isset;
}
OffsetIndex& OffsetIndex::operator=(const OffsetIndex& other293) {
  page_locations = other293.page_locations;
  unencoded_byte_array_data_bytes = other293.unencoded_byte_array_data_bytes;
  __isset = other293.__isset;
  return *this;
}
OffsetIndex& OffsetIndex::operator=(OffsetIndex&& other294) noexcept {
  page_locations = std::move(other294.page_locations);
  unencoded_byte_array_data_bytes = std::move(other294.unencoded_byte_array_data_bytes);
  __isset = other294.__isset;
  return *this;
}
void OffsetIndex::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "OffsetIndex(";
  out << "page_locations=" << to_string(page_locations);
  out << ", " << "unencoded_byte_array_data_bytes="; (__isset.unencoded_byte_array_data_bytes ? (out << to_string(unencoded_byte_array_data_bytes)) : (out << "<null>"));
  out << ")";
}


ColumnIndex::~ColumnIndex() noexcept {
}

ColumnIndex::ColumnIndex() noexcept
   : boundary_order(static_cast<BoundaryOrder::type>(0)) {
}

void ColumnIndex::__set_null_pages(const duckdb::vector<bool> & val) {
  this->null_pages = val;
}

void ColumnIndex::__set_min_values(const duckdb::vector<std::string> & val) {
  this->min_values = val;
}

void ColumnIndex::__set_max_values(const duckdb::vector<std::string> & val) {
  this->max_values = val;
}

void ColumnIndex::__set_boundary_order(const BoundaryOrder::type val) {
  this->boundary_order = val;
}

void ColumnIndex::__set_null_counts(const duckdb::vector<int64_t> & val) {
  this->null_counts = val;
__isset.null_counts = true;
}

void ColumnIndex::__set_repetition_level_histograms(const duckdb::vector<int64_t> & val) {
  this->repetition_level_histograms = val;
__isset.repetition_level_histograms = true;
}

void ColumnIndex::__set_definition_level_histograms(const duckdb::vector<int64_t> & val) {
  this->definition_level_histograms = val;
__isset.definition_level_histograms = true;
}
std::ostream& operator<<(std::ostream& out, const ColumnIndex& obj)
{
  obj.printTo(out);
  return out;
}


uint32_t ColumnIndex::read(::apache::thrift::protocol::TProtocol* iprot) {

  ::apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_null_pages = false;
  bool isset_min_values = false;
  bool isset_max_values = false;
  bool isset_boundary_order = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->null_pages.clear();
            uint32_t _size295;
            ::apache::thrift::protocol::TType _etype298;
            xfer += iprot->readListBegin(_etype298, _size295);
            this->null_pages.resize(_size295);
            uint32_t _i299;
            for (_i299 = 0; _i299 < _size295; ++_i299)
            {
              xfer += iprot->readBool(this->null_pages[_i299]);
            }
            xfer += iprot->readListEnd();
          }
          isset_null_pages = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->min_values.clear();
            uint32_t _size300;
            ::apache::thrift::protocol::TType _etype303;
            xfer += iprot->readListBegin(_etype303, _size300);
            this->min_values.resize(_size300);
            uint32_t _i304;
            for (_i304 = 0; _i304 < _size300; ++_i304)
            {
              xfer += iprot->readBinary(this->min_values[_i304]);
            }
            xfer += iprot->readListEnd();
          }
          isset_min_values = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->max_values.clear();
            uint32_t _size305;
            ::apache::thrift::protocol::TType _etype308;
            xfer += iprot->readListBegin(_etype308, _size305);
            this->max_values.resize(_size305);
            uint32_t _i309;
            for (_i309 = 0; _i309 < _size305; ++_i309)
            {
              xfer += iprot->readBinary(this->max_values[_i309]);
            }
            xfer += iprot->readListEnd();
          }
          isset_max_values = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 4:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast310;
          xfer += iprot->readI32(ecast310);
          this->boundary_order = static_cast<BoundaryOrder::type>(ecast310);
          isset_boundary_order = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 5:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->null_counts.clear();
            uint32_t _size311;
            ::apache::thrift::protocol::TType _etype314;
            xfer += iprot->readListBegin(_etype314, _size311);
            this->null_counts.resize(_size311);
            uint32_t _i315;
            for (_i315 = 0; _i315 < _size311; ++_i315)
            {
              xfer += iprot->readI64(this->null_counts[_i315]);
            }
            xfer += iprot->readListEnd();
          }
          this->__isset.null_counts = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 6:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->repetition_level_histograms.clear();
            uint32_t _size316;
            ::apache::thrift::protocol::TType _etype319;
            xfer += iprot->readListBegin(_etype319, _size316);
            this->repetition_level_histograms.resize(_size316);
            uint32_t _i320;
            for (_i320 = 0; _i320 < _size316; ++_i320)
            {
              xfer += iprot->readI64(this->repetition_level_histograms[_i320]);
            }
            xfer += iprot->readListEnd();
          }
          this->__isset.repetition_level_histograms = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 7:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->definition_level_histograms.clear();
            uint32_t _size321;
            ::apache::thrift::protocol::TType _etype324;
            xfer += iprot->readListBegin(_etype324, _size321);
            this->definition_level_histograms.resize(_size321);
            uint32_t _i325;
            for (_i325 = 0; _i325 < _size321; ++_i325)
            {
              xfer += iprot->readI64(this->definition_level_histograms[_i325]);
            }
            xfer += iprot->readListEnd();
          }
          this->__isset.definition_level_histograms = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_null_pages)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_min_values)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_max_values)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_boundary_order)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t ColumnIndex::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  ::apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("ColumnIndex");

  xfer += oprot->writeFieldBegin("null_pages", ::apache::thrift::protocol::T_LIST, 1);
  {
    xfer += oprot->writeListBegin(::apache::thrift::protocol::T_BOOL, static_cast<uint32_t>(this->null_pages.size()));
    duckdb::vector<bool> ::const_iterator _iter326;
    for (_iter326 = this->null_pages.begin(); _iter326 != this->null_pages.end(); ++_iter326)
    {
      xfer += oprot->writeBool((*_iter326));
    }
    xfer += oprot->writeListEnd();
  }
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("min_values", ::apache::thrift::protocol::T_LIST, 2);
  {
    xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRING, static_cast<uint32_t>(this->min_values.size()));
    duckdb::vector<std::string> ::const_iterator _iter327;
    for (_iter327 = this->min_values.begin(); _iter327 != this->min_values.end(); ++_iter327)
    {
      xfer += oprot->writeBinary((*_iter327));
    }
    xfer += oprot->writeListEnd();
  }
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("max_values", ::apache::thrift::protocol::T_LIST, 3);
  {
    xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRING, static_cast<uint32_t>(this->max_values.size()));
    duckdb::vector<std::string> ::const_iterator _iter328;
    for (_iter328 = this->max_values.begin(); _iter328 != this->max_values.end(); ++_iter328)
    {
      xfer += oprot->writeBinary((*_iter328));
    }
    xfer += oprot->writeListEnd();
  }
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("boundary_order", ::apache::thrift::protocol::T_I32, 4);
  xfer += oprot->writeI32(static_cast<int32_t>(this->boundary_order));
  xfer += oprot->writeFieldEnd();

  if (this->__isset.null_counts) {
    xfer += oprot->writeFieldBegin("null_counts", ::apache::thrift::protocol::T_LIST, 5);
    {
      xfer += oprot->writeListBegin(::apache::thrift::protocol::T_I64, static_cast<uint32_t>(this->null_counts.size()));
      duckdb::vector<int64_t> ::const_iterator _iter329;
      for (_iter329 = this->null_counts.begin(); _iter329 != this->null_counts.end(); ++_iter329)
      {
        xfer += oprot->writeI64((*_iter329));
      }
      xfer += oprot->writeListEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.repetition_level_histograms) {
    xfer += oprot->writeFieldBegin("repetition_level_histograms", ::apache::thrift::protocol::T_LIST, 6);
    {
      xfer += oprot->writeListBegin(::apache::thrift::protocol::T_I64, static_cast<uint32_t>(this->repetition_level_histograms.size()));
      duckdb::vector<int64_t> ::const_iterator _iter330;
      for (_iter330 = this->repetition_level_histograms.begin(); _iter330 != this->repetition_level_histograms.end(); ++_iter330)
      {
        xfer += oprot->writeI64((*_iter330));
      }
      xfer += oprot->writeListEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.definition_level_histograms) {
    xfer += oprot->writeFieldBegin("definition_level_histograms", ::apache::thrift::protocol::T_LIST, 7);
    {
      xfer += oprot->writeListBegin(::apache::thrift::protocol::T_I64, static_cast<uint32_t>(this->definition_level_histograms.size()));
      duckdb::vector<int64_t> ::const_iterator _iter331;
      for (_iter331 = this->definition_level_histograms.begin(); _iter331 != this->definition_level_histograms.end(); ++_iter331)
      {
        xfer += oprot->writeI64((*_iter331));
      }
      xfer += oprot->writeListEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(ColumnIndex &a, ColumnIndex &b) {
  using ::std::swap;
  swap(a.null_pages, b.null_pages);
  swap(a.min_values, b.min_values);
  swap(a.max_values, b.max_values);
  swap(a.boundary_order, b.boundary_order);
  swap(a.null_counts, b.null_counts);
  swap(a.repetition_level_histograms, b.repetition_level_histograms);
  swap(a.definition_level_histograms, b.definition_level_histograms);
  swap(a.__isset, b.__isset);
}

ColumnIndex::ColumnIndex(const ColumnIndex& other332) {
  null_pages = other332.null_pages;
  min_values = other332.min_values;
  max_values = other332.max_values;
  boundary_order = other332.boundary_order;
  null_counts = other332.null_counts;
  repetition_level_histograms = other332.repetition_level_histograms;
  definition_level_histograms = other332.definition_level_histograms;
  __isset = other332.__isset;
}
ColumnIndex::ColumnIndex(ColumnIndex&& other333) noexcept {
  null_pages = std::move(other333.null_pages);
  min_values = std::move(other333.min_values);
  max_values = std::move(other333.max_values);
  boundary_order = other333.boundary_order;
  null_counts = std::move(other333.null_counts);
  repetition_level_histograms = std::move(other333.repetition_level_histograms);
  definition_level_histograms = std::move(other333.definition_level_histograms);
  __isset = other333.__isset;
}
ColumnIndex& ColumnIndex::operator=(const ColumnIndex& other334) {
  null_pages = other334.null_pages;
  min_values = other334.min_values;
  max_values = other334.max_values;
  boundary_order = other334.boundary_order;
  null_counts = other334.null_counts;
  repetition_level_histograms = other334.repetition_level_histograms;
  definition_level_histograms = other334.definition_level_histograms;
  __isset = other334.__isset;
  return *this;
}
ColumnIndex& ColumnIndex::operator=(ColumnIndex&& other335) noexcept {
  null_pages = std::move(other335.null_pages);
  min_values = std::move(other335.min_values);
  max_values = std::move(other335.max_values);
  boundary_order = other335.boundary_order;
  null_counts = std::move(other335.null_counts);
  repetition_level_histograms = std::move(other335.repetition_level_histograms);
  definition_level_histograms = std::move(other335.definition_level_histograms);
  __isset = other335.__isset;
  return *this;
}
void ColumnIndex::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "ColumnIndex(";
  out << "null_pages=" << to_string(null_pages);
  out << ", " << "min_values=" << to_string(min_values);
  out << ", " << "max_values=" << to_string(max_values);
  out << ", " << "boundary_order=" << to_string(boundary_order);
  out << ", " << "null_counts="; (__isset.null_counts ? (out << to_string(null_counts)) : (out << "<null>"));
  out << ", " << "repetition_level_histograms="; (__isset.repetition_level_histograms ? (out << to_string(repetition_level_histograms)) : (out << "<null>"));
  out << ", " << "definition_level_histograms="; (__isset.definition_level_histograms ? (out << to_string(definition_level_histograms)) : (out << "<null>"));
  out << ")";
}


AesGcmV1::~AesGcmV1() noexcept {
}

AesGcmV1::AesGcmV1() noexcept
   : aad_prefix(),
     aad_file_unique(),
     supply_aad_prefix(0) {
}

void AesGcmV1::__set_aad_prefix(const std::string& val) {
  this->aad_prefix = val;
__isset.aad_prefix = true;
}

void AesGcmV1::__set_aad_file_unique(const std::string& val) {
  this->aad_file_unique = val;
__isset.aad_file_unique = true;
}

void AesGcmV1::__set_supply_aad_prefix(const bool val) {
  this->supply_aad_prefix = val;
__isset.supply_aad_prefix = true;
}
std::ostream& operator<<(std::ostream& out, const AesGcmV1& obj)
{
  obj.printTo(out);
  return out;
}


uint32_t AesGcmV1::read(::apache::thrift::protocol::TProtocol* iprot) {

  ::apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;


  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readBinary(this->aad_prefix);
          this->__isset.aad_prefix = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readBinary(this->aad_file_unique);
          this->__isset.aad_file_unique = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_BOOL) {
          xfer += iprot->readBool(this->supply_aad_prefix);
          this->__isset.supply_aad_prefix = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  return xfer;
}

uint32_t AesGcmV1::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  ::apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("AesGcmV1");

  if (this->__isset.aad_prefix) {
    xfer += oprot->writeFieldBegin("aad_prefix", ::apache::thrift::protocol::T_STRING, 1);
    xfer += oprot->writeBinary(this->aad_prefix);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.aad_file_unique) {
    xfer += oprot->writeFieldBegin("aad_file_unique", ::apache::thrift::protocol::T_STRING, 2);
    xfer += oprot->writeBinary(this->aad_file_unique);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.supply_aad_prefix) {
    xfer += oprot->writeFieldBegin("supply_aad_prefix", ::apache::thrift::protocol::T_BOOL, 3);
    xfer += oprot->writeBool(this->supply_aad_prefix);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(AesGcmV1 &a, AesGcmV1 &b) {
  using ::std::swap;
  swap(a.aad_prefix, b.aad_prefix);
  swap(a.aad_file_unique, b.aad_file_unique);
  swap(a.supply_aad_prefix, b.supply_aad_prefix);
  swap(a.__isset, b.__isset);
}

AesGcmV1::AesGcmV1(const AesGcmV1& other336) {
  aad_prefix = other336.aad_prefix;
  aad_file_unique = other336.aad_file_unique;
  supply_aad_prefix = other336.supply_aad_prefix;
  __isset = other336.__isset;
}
AesGcmV1::AesGcmV1(AesGcmV1&& other337) noexcept {
  aad_prefix = std::move(other337.aad_prefix);
  aad_file_unique = std::move(other337.aad_file_unique);
  supply_aad_prefix = other337.supply_aad_prefix;
  __isset = other337.__isset;
}
AesGcmV1& AesGcmV1::operator=(const AesGcmV1& other338) {
  aad_prefix = other338.aad_prefix;
  aad_file_unique = other338.aad_file_unique;
  supply_aad_prefix = other338.supply_aad_prefix;
  __isset = other338.__isset;
  return *this;
}
AesGcmV1& AesGcmV1::operator=(AesGcmV1&& other339) noexcept {
  aad_prefix = std::move(other339.aad_prefix);
  aad_file_unique = std::move(other339.aad_file_unique);
  supply_aad_prefix = other339.supply_aad_prefix;
  __isset = other339.__isset;
  return *this;
}
void AesGcmV1::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "AesGcmV1(";
  out << "aad_prefix="; (__isset.aad_prefix ? (out << to_string(aad_prefix)) : (out << "<null>"));
  out << ", " << "aad_file_unique="; (__isset.aad_file_unique ? (out << to_string(aad_file_unique)) : (out << "<null>"));
  out << ", " << "supply_aad_prefix="; (__isset.supply_aad_prefix ? (out << to_string(supply_aad_prefix)) : (out << "<null>"));
  out << ")";
}


AesGcmCtrV1::~AesGcmCtrV1() noexcept {
}

AesGcmCtrV1::AesGcmCtrV1() noexcept
   : aad_prefix(),
     aad_file_unique(),
     supply_aad_prefix(0) {
}

void AesGcmCtrV1::__set_aad_prefix(const std::string& val) {
  this->aad_prefix = val;
__isset.aad_prefix = true;
}

void AesGcmCtrV1::__set_aad_file_unique(const std::string& val) {
  this->aad_file_unique = val;
__isset.aad_file_unique = true;
}

void AesGcmCtrV1::__set_supply_aad_prefix(const bool val) {
  this->supply_aad_prefix = val;
__isset.supply_aad_prefix = true;
}
std::ostream& operator<<(std::ostream& out, const AesGcmCtrV1& obj)
{
  obj.printTo(out);
  return out;
}


uint32_t AesGcmCtrV1::read(::apache::thrift::protocol::TProtocol* iprot) {

  ::apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;


  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readBinary(this->aad_prefix);
          this->__isset.aad_prefix = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readBinary(this->aad_file_unique);
          this->__isset.aad_file_unique = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_BOOL) {
          xfer += iprot->readBool(this->supply_aad_prefix);
          this->__isset.supply_aad_prefix = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  return xfer;
}

uint32_t AesGcmCtrV1::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  ::apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("AesGcmCtrV1");

  if (this->__isset.aad_prefix) {
    xfer += oprot->writeFieldBegin("aad_prefix", ::apache::thrift::protocol::T_STRING, 1);
    xfer += oprot->writeBinary(this->aad_prefix);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.aad_file_unique) {
    xfer += oprot->writeFieldBegin("aad_file_unique", ::apache::thrift::protocol::T_STRING, 2);
    xfer += oprot->writeBinary(this->aad_file_unique);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.supply_aad_prefix) {
    xfer += oprot->writeFieldBegin("supply_aad_prefix", ::apache::thrift::protocol::T_BOOL, 3);
    xfer += oprot->writeBool(this->supply_aad_prefix);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(AesGcmCtrV1 &a, AesGcmCtrV1 &b) {
  using ::std::swap;
  swap(a.aad_prefix, b.aad_prefix);
  swap(a.aad_file_unique, b.aad_file_unique);
  swap(a.supply_aad_prefix, b.supply_aad_prefix);
  swap(a.__isset, b.__isset);
}

AesGcmCtrV1::AesGcmCtrV1(const AesGcmCtrV1& other340) {
  aad_prefix = other340.aad_prefix;
  aad_file_unique = other340.aad_file_unique;
  supply_aad_prefix = other340.supply_aad_prefix;
  __isset = other340.__isset;
}
AesGcmCtrV1::AesGcmCtrV1(AesGcmCtrV1&& other341) noexcept {
  aad_prefix = std::move(other341.aad_prefix);
  aad_file_unique = std::move(other341.aad_file_unique);
  supply_aad_prefix = other341.supply_aad_prefix;
  __isset = other341.__isset;
}
AesGcmCtrV1& AesGcmCtrV1::operator=(const AesGcmCtrV1& other342) {
  aad_prefix = other342.aad_prefix;
  aad_file_unique = other342.aad_file_unique;
  supply_aad_prefix = other342.supply_aad_prefix;
  __isset = other342.__isset;
  return *this;
}
AesGcmCtrV1& AesGcmCtrV1::operator=(AesGcmCtrV1&& other343) noexcept {
  aad_prefix = std::move(other343.aad_prefix);
  aad_file_unique = std::move(other343.aad_file_unique);
  supply_aad_prefix = other343.supply_aad_prefix;
  __isset = other343.__isset;
  return *this;
}
void AesGcmCtrV1::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "AesGcmCtrV1(";
  out << "aad_prefix="; (__isset.aad_prefix ? (out << to_string(aad_prefix)) : (out << "<null>"));
  out << ", " << "aad_file_unique="; (__isset.aad_file_unique ? (out << to_string(aad_file_unique)) : (out << "<null>"));
  out << ", " << "supply_aad_prefix="; (__isset.supply_aad_prefix ? (out << to_string(supply_aad_prefix)) : (out << "<null>"));
  out << ")";
}


EncryptionAlgorithm::~EncryptionAlgorithm() noexcept {
}

EncryptionAlgorithm::EncryptionAlgorithm() noexcept {
}

void EncryptionAlgorithm::__set_AES_GCM_V1(const AesGcmV1& val) {
  this->AES_GCM_V1 = val;
__isset.AES_GCM_V1 = true;
}

void EncryptionAlgorithm::__set_AES_GCM_CTR_V1(const AesGcmCtrV1& val) {
  this->AES_GCM_CTR_V1 = val;
__isset.AES_GCM_CTR_V1 = true;
}
std::ostream& operator<<(std::ostream& out, const EncryptionAlgorithm& obj)
{
  obj.printTo(out);
  return out;
}


uint32_t EncryptionAlgorithm::read(::apache::thrift::protocol::TProtocol* iprot) {

  ::apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;


  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->AES_GCM_V1.read(iprot);
          this->__isset.AES_GCM_V1 = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->AES_GCM_CTR_V1.read(iprot);
          this->__isset.AES_GCM_CTR_V1 = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  return xfer;
}

uint32_t EncryptionAlgorithm::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  ::apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("EncryptionAlgorithm");

  if (this->__isset.AES_GCM_V1) {
    xfer += oprot->writeFieldBegin("AES_GCM_V1", ::apache::thrift::protocol::T_STRUCT, 1);
    xfer += this->AES_GCM_V1.write(oprot);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.AES_GCM_CTR_V1) {
    xfer += oprot->writeFieldBegin("AES_GCM_CTR_V1", ::apache::thrift::protocol::T_STRUCT, 2);
    xfer += this->AES_GCM_CTR_V1.write(oprot);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(EncryptionAlgorithm &a, EncryptionAlgorithm &b) {
  using ::std::swap;
  swap(a.AES_GCM_V1, b.AES_GCM_V1);
  swap(a.AES_GCM_CTR_V1, b.AES_GCM_CTR_V1);
  swap(a.__isset, b.__isset);
}

EncryptionAlgorithm::EncryptionAlgorithm(const EncryptionAlgorithm& other344) {
  AES_GCM_V1 = other344.AES_GCM_V1;
  AES_GCM_CTR_V1 = other344.AES_GCM_CTR_V1;
  __isset = other344.__isset;
}
EncryptionAlgorithm::EncryptionAlgorithm(EncryptionAlgorithm&& other345) noexcept {
  AES_GCM_V1 = std::move(other345.AES_GCM_V1);
  AES_GCM_CTR_V1 = std::move(other345.AES_GCM_CTR_V1);
  __isset = other345.__isset;
}
EncryptionAlgorithm& EncryptionAlgorithm::operator=(const EncryptionAlgorithm& other346) {
  AES_GCM_V1 = other346.AES_GCM_V1;
  AES_GCM_CTR_V1 = other346.AES_GCM_CTR_V1;
  __isset = other346.__isset;
  return *this;
}
EncryptionAlgorithm& EncryptionAlgorithm::operator=(EncryptionAlgorithm&& other347) noexcept {
  AES_GCM_V1 = std::move(other347.AES_GCM_V1);
  AES_GCM_CTR_V1 = std::move(other347.AES_GCM_CTR_V1);
  __isset = other347.__isset;
  return *this;
}
void EncryptionAlgorithm::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "EncryptionAlgorithm(";
  out << "AES_GCM_V1="; (__isset.AES_GCM_V1 ? (out << to_string(AES_GCM_V1)) : (out << "<null>"));
  out << ", " << "AES_GCM_CTR_V1="; (__isset.AES_GCM_CTR_V1 ? (out << to_string(AES_GCM_CTR_V1)) : (out << "<null>"));
  out << ")";
}


FileMetaData::~FileMetaData() noexcept {
}

FileMetaData::FileMetaData() noexcept
   : version(0),
     num_rows(0),
     created_by(),
     footer_signing_key_metadata() {
}

void FileMetaData::__set_version(const int32_t val) {
  this->version = val;
}

void FileMetaData::__set_schema(const duckdb::vector<SchemaElement> & val) {
  this->schema = val;
}

void FileMetaData::__set_num_rows(const int64_t val) {
  this->num_rows = val;
}

void FileMetaData::__set_row_groups(const duckdb::vector<RowGroup> & val) {
  this->row_groups = val;
}

void FileMetaData::__set_key_value_metadata(const duckdb::vector<KeyValue> & val) {
  this->key_value_metadata = val;
__isset.key_value_metadata = true;
}

void FileMetaData::__set_created_by(const std::string& val) {
  this->created_by = val;
__isset.created_by = true;
}

void FileMetaData::__set_column_orders(const duckdb::vector<ColumnOrder> & val) {
  this->column_orders = val;
__isset.column_orders = true;
}

void FileMetaData::__set_encryption_algorithm(const EncryptionAlgorithm& val) {
  this->encryption_algorithm = val;
__isset.encryption_algorithm = true;
}

void FileMetaData::__set_footer_signing_key_metadata(const std::string& val) {
  this->footer_signing_key_metadata = val;
__isset.footer_signing_key_metadata = true;
}
std::ostream& operator<<(std::ostream& out, const FileMetaData& obj)
{
  obj.printTo(out);
  return out;
}


uint32_t FileMetaData::read(::apache::thrift::protocol::TProtocol* iprot) {

  ::apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_version = false;
  bool isset_schema = false;
  bool isset_num_rows = false;
  bool isset_row_groups = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->version);
          isset_version = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->schema.clear();
            uint32_t _size348;
            ::apache::thrift::protocol::TType _etype351;
            xfer += iprot->readListBegin(_etype351, _size348);
            this->schema.resize(_size348);
            uint32_t _i352;
            for (_i352 = 0; _i352 < _size348; ++_i352)
            {
              xfer += this->schema[_i352].read(iprot);
            }
            xfer += iprot->readListEnd();
          }
          isset_schema = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_I64) {
          xfer += iprot->readI64(this->num_rows);
          isset_num_rows = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 4:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->row_groups.clear();
            uint32_t _size353;
            ::apache::thrift::protocol::TType _etype356;
            xfer += iprot->readListBegin(_etype356, _size353);
            this->row_groups.resize(_size353);
            uint32_t _i357;
            for (_i357 = 0; _i357 < _size353; ++_i357)
            {
              xfer += this->row_groups[_i357].read(iprot);
            }
            xfer += iprot->readListEnd();
          }
          isset_row_groups = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 5:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->key_value_metadata.clear();
            uint32_t _size358;
            ::apache::thrift::protocol::TType _etype361;
            xfer += iprot->readListBegin(_etype361, _size358);
            this->key_value_metadata.resize(_size358);
            uint32_t _i362;
            for (_i362 = 0; _i362 < _size358; ++_i362)
            {
              xfer += this->key_value_metadata[_i362].read(iprot);
            }
            xfer += iprot->readListEnd();
          }
          this->__isset.key_value_metadata = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 6:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->created_by);
          this->__isset.created_by = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 7:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->column_orders.clear();
            uint32_t _size363;
            ::apache::thrift::protocol::TType _etype366;
            xfer += iprot->readListBegin(_etype366, _size363);
            this->column_orders.resize(_size363);
            uint32_t _i367;
            for (_i367 = 0; _i367 < _size363; ++_i367)
            {
              xfer += this->column_orders[_i367].read(iprot);
            }
            xfer += iprot->readListEnd();
          }
          this->__isset.column_orders = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 8:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->encryption_algorithm.read(iprot);
          this->__isset.encryption_algorithm = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 9:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readBinary(this->footer_signing_key_metadata);
          this->__isset.footer_signing_key_metadata = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_version)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_schema)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_num_rows)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_row_groups)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t FileMetaData::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  ::apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("FileMetaData");

  xfer += oprot->writeFieldBegin("version", ::apache::thrift::protocol::T_I32, 1);
  xfer += oprot->writeI32(this->version);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("schema", ::apache::thrift::protocol::T_LIST, 2);
  {
    xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRUCT, static_cast<uint32_t>(this->schema.size()));
    duckdb::vector<SchemaElement> ::const_iterator _iter368;
    for (_iter368 = this->schema.begin(); _iter368 != this->schema.end(); ++_iter368)
    {
      xfer += (*_iter368).write(oprot);
    }
    xfer += oprot->writeListEnd();
  }
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("num_rows", ::apache::thrift::protocol::T_I64, 3);
  xfer += oprot->writeI64(this->num_rows);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("row_groups", ::apache::thrift::protocol::T_LIST, 4);
  {
    xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRUCT, static_cast<uint32_t>(this->row_groups.size()));
    duckdb::vector<RowGroup> ::const_iterator _iter369;
    for (_iter369 = this->row_groups.begin(); _iter369 != this->row_groups.end(); ++_iter369)
    {
      xfer += (*_iter369).write(oprot);
    }
    xfer += oprot->writeListEnd();
  }
  xfer += oprot->writeFieldEnd();

  if (this->__isset.key_value_metadata) {
    xfer += oprot->writeFieldBegin("key_value_metadata", ::apache::thrift::protocol::T_LIST, 5);
    {
      xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRUCT, static_cast<uint32_t>(this->key_value_metadata.size()));
      duckdb::vector<KeyValue> ::const_iterator _iter370;
      for (_iter370 = this->key_value_metadata.begin(); _iter370 != this->key_value_metadata.end(); ++_iter370)
      {
        xfer += (*_iter370).write(oprot);
      }
      xfer += oprot->writeListEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.created_by) {
    xfer += oprot->writeFieldBegin("created_by", ::apache::thrift::protocol::T_STRING, 6);
    xfer += oprot->writeString(this->created_by);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.column_orders) {
    xfer += oprot->writeFieldBegin("column_orders", ::apache::thrift::protocol::T_LIST, 7);
    {
      xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRUCT, static_cast<uint32_t>(this->column_orders.size()));
      duckdb::vector<ColumnOrder> ::const_iterator _iter371;
      for (_iter371 = this->column_orders.begin(); _iter371 != this->column_orders.end(); ++_iter371)
      {
        xfer += (*_iter371).write(oprot);
      }
      xfer += oprot->writeListEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.encryption_algorithm) {
    xfer += oprot->writeFieldBegin("encryption_algorithm", ::apache::thrift::protocol::T_STRUCT, 8);
    xfer += this->encryption_algorithm.write(oprot);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.footer_signing_key_metadata) {
    xfer += oprot->writeFieldBegin("footer_signing_key_metadata", ::apache::thrift::protocol::T_STRING, 9);
    xfer += oprot->writeBinary(this->footer_signing_key_metadata);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(FileMetaData &a, FileMetaData &b) {
  using ::std::swap;
  swap(a.version, b.version);
  swap(a.schema, b.schema);
  swap(a.num_rows, b.num_rows);
  swap(a.row_groups, b.row_groups);
  swap(a.key_value_metadata, b.key_value_metadata);
  swap(a.created_by, b.created_by);
  swap(a.column_orders, b.column_orders);
  swap(a.encryption_algorithm, b.encryption_algorithm);
  swap(a.footer_signing_key_metadata, b.footer_signing_key_metadata);
  swap(a.__isset, b.__isset);
}

FileMetaData::FileMetaData(const FileMetaData& other372) {
  version = other372.version;
  schema = other372.schema;
  num_rows = other372.num_rows;
  row_groups = other372.row_groups;
  key_value_metadata = other372.key_value_metadata;
  created_by = other372.created_by;
  column_orders = other372.column_orders;
  encryption_algorithm = other372.encryption_algorithm;
  footer_signing_key_metadata = other372.footer_signing_key_metadata;
  __isset = other372.__isset;
}
FileMetaData::FileMetaData(FileMetaData&& other373) noexcept {
  version = other373.version;
  schema = std::move(other373.schema);
  num_rows = other373.num_rows;
  row_groups = std::move(other373.row_groups);
  key_value_metadata = std::move(other373.key_value_metadata);
  created_by = std::move(other373.created_by);
  column_orders = std::move(other373.column_orders);
  encryption_algorithm = std::move(other373.encryption_algorithm);
  footer_signing_key_metadata = std::move(other373.footer_signing_key_metadata);
  __isset = other373.__isset;
}
FileMetaData& FileMetaData::operator=(const FileMetaData& other374) {
  version = other374.version;
  schema = other374.schema;
  num_rows = other374.num_rows;
  row_groups = other374.row_groups;
  key_value_metadata = other374.key_value_metadata;
  created_by = other374.created_by;
  column_orders = other374.column_orders;
  encryption_algorithm = other374.encryption_algorithm;
  footer_signing_key_metadata = other374.footer_signing_key_metadata;
  __isset = other374.__isset;
  return *this;
}
FileMetaData& FileMetaData::operator=(FileMetaData&& other375) noexcept {
  version = other375.version;
  schema = std::move(other375.schema);
  num_rows = other375.num_rows;
  row_groups = std::move(other375.row_groups);
  key_value_metadata = std::move(other375.key_value_metadata);
  created_by = std::move(other375.created_by);
  column_orders = std::move(other375.column_orders);
  encryption_algorithm = std::move(other375.encryption_algorithm);
  footer_signing_key_metadata = std::move(other375.footer_signing_key_metadata);
  __isset = other375.__isset;
  return *this;
}
void FileMetaData::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "FileMetaData(";
  out << "version=" << to_string(version);
  out << ", " << "schema=" << to_string(schema);
  out << ", " << "num_rows=" << to_string(num_rows);
  out << ", " << "row_groups=" << to_string(row_groups);
  out << ", " << "key_value_metadata="; (__isset.key_value_metadata ? (out << to_string(key_value_metadata)) : (out << "<null>"));
  out << ", " << "created_by="; (__isset.created_by ? (out << to_string(created_by)) : (out << "<null>"));
  out << ", " << "column_orders="; (__isset.column_orders ? (out << to_string(column_orders)) : (out << "<null>"));
  out << ", " << "encryption_algorithm="; (__isset.encryption_algorithm ? (out << to_string(encryption_algorithm)) : (out << "<null>"));
  out << ", " << "footer_signing_key_metadata="; (__isset.footer_signing_key_metadata ? (out << to_string(footer_signing_key_metadata)) : (out << "<null>"));
  out << ")";
}


FileCryptoMetaData::~FileCryptoMetaData() noexcept {
}

FileCryptoMetaData::FileCryptoMetaData() noexcept
   : key_metadata() {
}

void FileCryptoMetaData::__set_encryption_algorithm(const EncryptionAlgorithm& val) {
  this->encryption_algorithm = val;
}

void FileCryptoMetaData::__set_key_metadata(const std::string& val) {
  this->key_metadata = val;
__isset.key_metadata = true;
}
std::ostream& operator<<(std::ostream& out, const FileCryptoMetaData& obj)
{
  obj.printTo(out);
  return out;
}


uint32_t FileCryptoMetaData::read(::apache::thrift::protocol::TProtocol* iprot) {

  ::apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_encryption_algorithm = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->encryption_algorithm.read(iprot);
          isset_encryption_algorithm = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readBinary(this->key_metadata);
          this->__isset.key_metadata = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_encryption_algorithm)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t FileCryptoMetaData::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  ::apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("FileCryptoMetaData");

  xfer += oprot->writeFieldBegin("encryption_algorithm", ::apache::thrift::protocol::T_STRUCT, 1);
  xfer += this->encryption_algorithm.write(oprot);
  xfer += oprot->writeFieldEnd();

  if (this->__isset.key_metadata) {
    xfer += oprot->writeFieldBegin("key_metadata", ::apache::thrift::protocol::T_STRING, 2);
    xfer += oprot->writeBinary(this->key_metadata);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(FileCryptoMetaData &a, FileCryptoMetaData &b) {
  using ::std::swap;
  swap(a.encryption_algorithm, b.encryption_algorithm);
  swap(a.key_metadata, b.key_metadata);
  swap(a.__isset, b.__isset);
}

FileCryptoMetaData::FileCryptoMetaData(const FileCryptoMetaData& other376) {
  encryption_algorithm = other376.encryption_algorithm;
  key_metadata = other376.key_metadata;
  __isset = other376.__isset;
}
FileCryptoMetaData::FileCryptoMetaData(FileCryptoMetaData&& other377) noexcept {
  encryption_algorithm = std::move(other377.encryption_algorithm);
  key_metadata = std::move(other377.key_metadata);
  __isset = other377.__isset;
}
FileCryptoMetaData& FileCryptoMetaData::operator=(const FileCryptoMetaData& other378) {
  encryption_algorithm = other378.encryption_algorithm;
  key_metadata = other378.key_metadata;
  __isset = other378.__isset;
  return *this;
}
FileCryptoMetaData& FileCryptoMetaData::operator=(FileCryptoMetaData&& other379) noexcept {
  encryption_algorithm = std::move(other379.encryption_algorithm);
  key_metadata = std::move(other379.key_metadata);
  __isset = other379.__isset;
  return *this;
}
void FileCryptoMetaData::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "FileCryptoMetaData(";
  out << "encryption_algorithm=" << to_string(encryption_algorithm);
  out << ", " << "key_metadata="; (__isset.key_metadata ? (out << to_string(key_metadata)) : (out << "<null>"));
  out << ")";
}

} // namespace
