/*
 * scdtools - Tools for Scdaemon and OpenPGP smartcards
 * Copyright (C) 2015 Damien Goutte-Gattat
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef ICP20150202_OTPAUTH_H
#define ICP20150202_OTPAUTH_H

#include <stdlib.h>

#define OTP_TYPE_TOTP   0x00
#define OTP_TYPE_HOTP   0x01

#define OTP_ALGO_SHA1   0x00
#define OTP_ALGO_SHA256 0x01
#define OTP_ALGO_SHA512 0x02

typedef struct {
    unsigned        type;
    unsigned        algo;
    unsigned        digits;
    union {
        unsigned    period;
        unsigned    counter;
    };
    const char     *issuer;
    const char     *label;
    const char     *secret;
    size_t          length;
    char           *buffer;
} otp_t;

#ifdef __cpluscplus
extern "C" {
#endif

otp_t *
otp_parse_uri(const char *);

#ifdef __cplusplus
}
#endif

#endif /* !ICP20150202_OTPAUTH_H */
