/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.visitor;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.TypeParameter;
import com.github.javaparser.ast.body.AnnotationDeclaration;
import com.github.javaparser.ast.body.AnnotationMemberDeclaration;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.EmptyMemberDeclaration;
import com.github.javaparser.ast.body.EmptyTypeDeclaration;
import com.github.javaparser.ast.body.EnumConstantDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.InitializerDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.body.VariableDeclaratorId;
import com.github.javaparser.ast.comments.BlockComment;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.comments.JavadocComment;
import com.github.javaparser.ast.comments.LineComment;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.ArrayAccessExpr;
import com.github.javaparser.ast.expr.ArrayCreationExpr;
import com.github.javaparser.ast.expr.ArrayInitializerExpr;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.CastExpr;
import com.github.javaparser.ast.expr.CharLiteralExpr;
import com.github.javaparser.ast.expr.ClassExpr;
import com.github.javaparser.ast.expr.ConditionalExpr;
import com.github.javaparser.ast.expr.DoubleLiteralExpr;
import com.github.javaparser.ast.expr.EnclosedExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.InstanceOfExpr;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import com.github.javaparser.ast.expr.IntegerLiteralMinValueExpr;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.LongLiteralExpr;
import com.github.javaparser.ast.expr.LongLiteralMinValueExpr;
import com.github.javaparser.ast.expr.MarkerAnnotationExpr;
import com.github.javaparser.ast.expr.MemberValuePair;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.MethodReferenceExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NormalAnnotationExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.QualifiedNameExpr;
import com.github.javaparser.ast.expr.SingleMemberAnnotationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.expr.SuperExpr;
import com.github.javaparser.ast.expr.ThisExpr;
import com.github.javaparser.ast.expr.TypeExpr;
import com.github.javaparser.ast.expr.UnaryExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithAnnotations;
import com.github.javaparser.ast.nodeTypes.NodeWithArrays;
import com.github.javaparser.ast.stmt.AssertStmt;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.BreakStmt;
import com.github.javaparser.ast.stmt.CatchClause;
import com.github.javaparser.ast.stmt.ContinueStmt;
import com.github.javaparser.ast.stmt.DoStmt;
import com.github.javaparser.ast.stmt.EmptyStmt;
import com.github.javaparser.ast.stmt.ExplicitConstructorInvocationStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.ForStmt;
import com.github.javaparser.ast.stmt.ForeachStmt;
import com.github.javaparser.ast.stmt.IfStmt;
import com.github.javaparser.ast.stmt.LabeledStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.stmt.SwitchEntryStmt;
import com.github.javaparser.ast.stmt.SwitchStmt;
import com.github.javaparser.ast.stmt.SynchronizedStmt;
import com.github.javaparser.ast.stmt.ThrowStmt;
import com.github.javaparser.ast.stmt.TryStmt;
import com.github.javaparser.ast.stmt.TypeDeclarationStmt;
import com.github.javaparser.ast.stmt.WhileStmt;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.IntersectionType;
import com.github.javaparser.ast.type.PrimitiveType;
import com.github.javaparser.ast.type.ReferenceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.type.UnionType;
import com.github.javaparser.ast.type.UnknownType;
import com.github.javaparser.ast.type.VoidType;
import com.github.javaparser.ast.type.WildcardType;
import com.github.javaparser.ast.visitor.GenericVisitor;
import java.util.ArrayList;
import java.util.List;

public abstract class ModifierVisitorAdapter<A>
implements GenericVisitor<Node, A> {
    private void removeNulls(List<?> list) {
        for (int i = list.size() - 1; i >= 0; --i) {
            if (list.get(i) != null) continue;
            list.remove(i);
        }
    }

    private void visitArraysAnnotations(NodeWithArrays<?> n, A arg) {
        ArrayList<List<AnnotationExpr>> result = new ArrayList<List<AnnotationExpr>>();
        for (List<AnnotationExpr> aux : n.getArraysAnnotations()) {
            if (aux == null) {
                result.add(null);
                continue;
            }
            ArrayList<AnnotationExpr> l = new ArrayList<AnnotationExpr>();
            for (AnnotationExpr annotation : aux) {
                AnnotationExpr newAnnotationExpr = (AnnotationExpr)annotation.accept(this, arg);
                if (newAnnotationExpr == null) continue;
                l.add(newAnnotationExpr);
            }
            result.add(l);
        }
        n.setArraysAnnotations(result);
    }

    @Override
    public Node visit(AnnotationDeclaration n, A arg) {
        this.visitAnnotations(n, arg);
        this.visitComment(n, arg);
        List<BodyDeclaration<?>> members = n.getMembers();
        if (members != null) {
            for (int i = 0; i < members.size(); ++i) {
                members.set(i, (BodyDeclaration)members.get(i).accept(this, arg));
            }
            this.removeNulls(members);
        }
        return n;
    }

    private void visitAnnotations(NodeWithAnnotations<?> n, A arg) {
        List<AnnotationExpr> annotations = n.getAnnotations();
        if (annotations != null) {
            for (int i = 0; i < annotations.size(); ++i) {
                annotations.set(i, (AnnotationExpr)annotations.get(i).accept(this, arg));
            }
            this.removeNulls(annotations);
        }
    }

    @Override
    public Node visit(AnnotationMemberDeclaration n, A arg) {
        this.visitComment(n, arg);
        List<AnnotationExpr> annotations = n.getAnnotations();
        if (annotations != null) {
            for (int i = 0; i < annotations.size(); ++i) {
                annotations.set(i, (AnnotationExpr)annotations.get(i).accept(this, arg));
            }
            this.removeNulls(annotations);
        }
        n.setType((Type)n.getType().accept(this, arg));
        if (n.getDefaultValue() != null) {
            n.setDefaultValue((Expression)n.getDefaultValue().accept(this, arg));
        }
        return n;
    }

    @Override
    public Node visit(ArrayAccessExpr n, A arg) {
        this.visitComment(n, arg);
        n.setName((Expression)n.getName().accept(this, arg));
        n.setIndex((Expression)n.getIndex().accept(this, arg));
        return n;
    }

    @Override
    public Node visit(ArrayCreationExpr n, A arg) {
        List<Expression> dimensions;
        this.visitComment(n, arg);
        n.setType((Type)n.getType().accept(this, arg));
        if (n.getDimensions() != null && (dimensions = n.getDimensions()) != null) {
            for (int i = 0; i < dimensions.size(); ++i) {
                dimensions.set(i, (Expression)dimensions.get(i).accept(this, arg));
            }
            this.removeNulls(dimensions);
        }
        this.visitArraysAnnotations(n, arg);
        if (n.getInitializer() != null) {
            n.setInitializer((ArrayInitializerExpr)n.getInitializer().accept(this, arg));
        }
        return n;
    }

    @Override
    public Node visit(ArrayInitializerExpr n, A arg) {
        List<Expression> values;
        this.visitComment(n, arg);
        if (n.getValues() != null && (values = n.getValues()) != null) {
            for (int i = 0; i < values.size(); ++i) {
                values.set(i, (Expression)values.get(i).accept(this, arg));
            }
            this.removeNulls(values);
        }
        return n;
    }

    @Override
    public Node visit(AssertStmt n, A arg) {
        this.visitComment(n, arg);
        n.setCheck((Expression)n.getCheck().accept(this, arg));
        if (n.getMessage() != null) {
            n.setMessage((Expression)n.getMessage().accept(this, arg));
        }
        return n;
    }

    @Override
    public Node visit(AssignExpr n, A arg) {
        this.visitComment(n, arg);
        Expression target = (Expression)n.getTarget().accept(this, arg);
        if (target == null) {
            return null;
        }
        n.setTarget(target);
        Expression value = (Expression)n.getValue().accept(this, arg);
        if (value == null) {
            return null;
        }
        n.setValue(value);
        return n;
    }

    @Override
    public Node visit(BinaryExpr n, A arg) {
        this.visitComment(n, arg);
        Expression left = (Expression)n.getLeft().accept(this, arg);
        Expression right = (Expression)n.getRight().accept(this, arg);
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        n.setLeft(left);
        n.setRight(right);
        return n;
    }

    @Override
    public Node visit(BlockStmt n, A arg) {
        this.visitComment(n, arg);
        List<Statement> stmts = n.getStmts();
        if (stmts != null) {
            for (int i = 0; i < stmts.size(); ++i) {
                stmts.set(i, (Statement)stmts.get(i).accept(this, arg));
            }
            this.removeNulls(stmts);
        }
        return n;
    }

    @Override
    public Node visit(BooleanLiteralExpr n, A arg) {
        this.visitComment(n, arg);
        return n;
    }

    @Override
    public Node visit(BreakStmt n, A arg) {
        this.visitComment(n, arg);
        return n;
    }

    @Override
    public Node visit(CastExpr n, A arg) {
        this.visitComment(n, arg);
        Type type = (Type)n.getType().accept(this, arg);
        Expression expr = (Expression)n.getExpr().accept(this, arg);
        if (type == null) {
            return expr;
        }
        if (expr == null) {
            return null;
        }
        n.setType(type);
        n.setExpr(expr);
        return n;
    }

    @Override
    public Node visit(CatchClause n, A arg) {
        this.visitComment(n, arg);
        n.setParam((Parameter)n.getParam().accept(this, arg));
        n.setCatchBlock((BlockStmt)n.getCatchBlock().accept(this, arg));
        return n;
    }

    @Override
    public Node visit(CharLiteralExpr n, A arg) {
        this.visitComment(n, arg);
        return n;
    }

    @Override
    public Node visit(ClassExpr n, A arg) {
        this.visitComment(n, arg);
        n.setType((Type)n.getType().accept(this, arg));
        return n;
    }

    @Override
    public Node visit(ClassOrInterfaceDeclaration n, A arg) {
        List<BodyDeclaration<?>> members;
        List<ClassOrInterfaceType> implementz;
        List<ClassOrInterfaceType> extendz;
        this.visitAnnotations(n, arg);
        this.visitComment(n, arg);
        List<TypeParameter> typeParameters = n.getTypeParameters();
        if (typeParameters != null) {
            for (int i = 0; i < typeParameters.size(); ++i) {
                typeParameters.set(i, (TypeParameter)typeParameters.get(i).accept(this, arg));
            }
            this.removeNulls(typeParameters);
        }
        if ((extendz = n.getExtends()) != null) {
            for (int i = 0; i < extendz.size(); ++i) {
                extendz.set(i, (ClassOrInterfaceType)extendz.get(i).accept(this, arg));
            }
            this.removeNulls(extendz);
        }
        if ((implementz = n.getImplements()) != null) {
            for (int i = 0; i < implementz.size(); ++i) {
                implementz.set(i, (ClassOrInterfaceType)implementz.get(i).accept(this, arg));
            }
            this.removeNulls(implementz);
        }
        if ((members = n.getMembers()) != null) {
            for (int i = 0; i < members.size(); ++i) {
                members.set(i, (BodyDeclaration)members.get(i).accept(this, arg));
            }
            this.removeNulls(members);
        }
        return n;
    }

    @Override
    public Node visit(ClassOrInterfaceType n, A arg) {
        List<Type> typeArgs;
        this.visitComment(n, arg);
        this.visitAnnotations(n, arg);
        if (n.getScope() != null) {
            n.setScope((ClassOrInterfaceType)n.getScope().accept(this, arg));
        }
        if ((typeArgs = n.getTypeArgs()) != null) {
            for (int i = 0; i < typeArgs.size(); ++i) {
                typeArgs.set(i, (Type)typeArgs.get(i).accept(this, arg));
            }
            this.removeNulls(typeArgs);
        }
        return n;
    }

    @Override
    public Node visit(CompilationUnit n, A arg) {
        List<TypeDeclaration<?>> types;
        List<ImportDeclaration> imports;
        this.visitComment(n, arg);
        if (n.getPackage() != null) {
            n.setPackage((PackageDeclaration)n.getPackage().accept(this, arg));
        }
        if ((imports = n.getImports()) != null) {
            for (int i = 0; i < imports.size(); ++i) {
                imports.set(i, (ImportDeclaration)imports.get(i).accept(this, arg));
            }
            this.removeNulls(imports);
        }
        if ((types = n.getTypes()) != null) {
            for (int i = 0; i < types.size(); ++i) {
                types.set(i, (TypeDeclaration)types.get(i).accept(this, arg));
            }
            this.removeNulls(types);
        }
        return n;
    }

    @Override
    public Node visit(ConditionalExpr n, A arg) {
        this.visitComment(n, arg);
        n.setCondition((Expression)n.getCondition().accept(this, arg));
        n.setThenExpr((Expression)n.getThenExpr().accept(this, arg));
        n.setElseExpr((Expression)n.getElseExpr().accept(this, arg));
        return n;
    }

    @Override
    public Node visit(ConstructorDeclaration n, A arg) {
        List<ReferenceType> throwz;
        List<Parameter> parameters;
        List<TypeParameter> typeParameters;
        this.visitComment(n, arg);
        List<AnnotationExpr> annotations = n.getAnnotations();
        if (annotations != null) {
            for (int i = 0; i < annotations.size(); ++i) {
                annotations.set(i, (AnnotationExpr)annotations.get(i).accept(this, arg));
            }
            this.removeNulls(annotations);
        }
        if ((typeParameters = n.getTypeParameters()) != null) {
            for (int i = 0; i < typeParameters.size(); ++i) {
                typeParameters.set(i, (TypeParameter)typeParameters.get(i).accept(this, arg));
            }
            this.removeNulls(typeParameters);
        }
        if ((parameters = n.getParameters()) != null) {
            for (int i = 0; i < parameters.size(); ++i) {
                parameters.set(i, (Parameter)parameters.get(i).accept(this, arg));
            }
            this.removeNulls(parameters);
        }
        if ((throwz = n.getThrows()) != null) {
            for (int i = 0; i < throwz.size(); ++i) {
                throwz.set(i, (ReferenceType)throwz.get(i).accept(this, arg));
            }
            this.removeNulls(throwz);
        }
        n.setBody((BlockStmt)n.getBody().accept(this, arg));
        return n;
    }

    @Override
    public Node visit(ContinueStmt n, A arg) {
        this.visitComment(n, arg);
        return n;
    }

    @Override
    public Node visit(DoStmt n, A arg) {
        this.visitComment(n, arg);
        Statement body = (Statement)n.getBody().accept(this, arg);
        if (body == null) {
            return null;
        }
        n.setBody(body);
        Expression condition = (Expression)n.getCondition().accept(this, arg);
        if (condition == null) {
            return null;
        }
        n.setCondition(condition);
        return n;
    }

    @Override
    public Node visit(DoubleLiteralExpr n, A arg) {
        this.visitComment(n, arg);
        return n;
    }

    @Override
    public Node visit(EmptyMemberDeclaration n, A arg) {
        this.visitComment(n, arg);
        return n;
    }

    @Override
    public Node visit(EmptyStmt n, A arg) {
        this.visitComment(n, arg);
        return n;
    }

    @Override
    public Node visit(EmptyTypeDeclaration n, A arg) {
        this.visitComment(n, arg);
        return n;
    }

    @Override
    public Node visit(EnclosedExpr n, A arg) {
        this.visitComment(n, arg);
        n.setInner((Expression)n.getInner().accept(this, arg));
        return n;
    }

    @Override
    public Node visit(EnumConstantDeclaration n, A arg) {
        List<BodyDeclaration<?>> classBody;
        List<Expression> args;
        this.visitComment(n, arg);
        List<AnnotationExpr> annotations = n.getAnnotations();
        if (annotations != null) {
            for (int i = 0; i < annotations.size(); ++i) {
                annotations.set(i, (AnnotationExpr)annotations.get(i).accept(this, arg));
            }
            this.removeNulls(annotations);
        }
        if ((args = n.getArgs()) != null) {
            for (int i = 0; i < args.size(); ++i) {
                args.set(i, (Expression)args.get(i).accept(this, arg));
            }
            this.removeNulls(args);
        }
        if ((classBody = n.getClassBody()) != null) {
            for (int i = 0; i < classBody.size(); ++i) {
                classBody.set(i, (BodyDeclaration)classBody.get(i).accept(this, arg));
            }
            this.removeNulls(classBody);
        }
        return n;
    }

    @Override
    public Node visit(EnumDeclaration n, A arg) {
        List<BodyDeclaration<?>> members;
        List<EnumConstantDeclaration> entries;
        List<ClassOrInterfaceType> implementz;
        this.visitComment(n, arg);
        List<AnnotationExpr> annotations = n.getAnnotations();
        if (annotations != null) {
            for (int i = 0; i < annotations.size(); ++i) {
                annotations.set(i, (AnnotationExpr)annotations.get(i).accept(this, arg));
            }
            this.removeNulls(annotations);
        }
        if ((implementz = n.getImplements()) != null) {
            for (int i = 0; i < implementz.size(); ++i) {
                implementz.set(i, (ClassOrInterfaceType)implementz.get(i).accept(this, arg));
            }
            this.removeNulls(implementz);
        }
        if ((entries = n.getEntries()) != null) {
            for (int i = 0; i < entries.size(); ++i) {
                entries.set(i, (EnumConstantDeclaration)entries.get(i).accept(this, arg));
            }
            this.removeNulls(entries);
        }
        if ((members = n.getMembers()) != null) {
            for (int i = 0; i < members.size(); ++i) {
                members.set(i, (BodyDeclaration)members.get(i).accept(this, arg));
            }
            this.removeNulls(members);
        }
        return n;
    }

    @Override
    public Node visit(ExplicitConstructorInvocationStmt n, A arg) {
        List<Expression> args;
        List<Type> typeArgs;
        this.visitComment(n, arg);
        if (!n.isThis() && n.getExpr() != null) {
            n.setExpr((Expression)n.getExpr().accept(this, arg));
        }
        if ((typeArgs = n.getTypeArgs()) != null) {
            for (int i = 0; i < typeArgs.size(); ++i) {
                typeArgs.set(i, (Type)typeArgs.get(i).accept(this, arg));
            }
            this.removeNulls(typeArgs);
        }
        if ((args = n.getArgs()) != null) {
            for (int i = 0; i < args.size(); ++i) {
                args.set(i, (Expression)args.get(i).accept(this, arg));
            }
            this.removeNulls(args);
        }
        return n;
    }

    @Override
    public Node visit(ExpressionStmt n, A arg) {
        this.visitComment(n, arg);
        Expression expr = (Expression)n.getExpression().accept(this, arg);
        if (expr == null) {
            return null;
        }
        n.setExpression(expr);
        return n;
    }

    @Override
    public Node visit(FieldAccessExpr n, A arg) {
        this.visitComment(n, arg);
        Expression scope = (Expression)n.getScope().accept(this, arg);
        if (scope == null) {
            return null;
        }
        n.setScope(scope);
        return n;
    }

    @Override
    public Node visit(FieldDeclaration n, A arg) {
        this.visitComment(n, arg);
        List<AnnotationExpr> annotations = n.getAnnotations();
        if (annotations != null) {
            for (int i = 0; i < annotations.size(); ++i) {
                annotations.set(i, (AnnotationExpr)annotations.get(i).accept(this, arg));
            }
            this.removeNulls(annotations);
        }
        n.setType((Type)n.getType().accept(this, arg));
        List<VariableDeclarator> variables = n.getVariables();
        for (int i = 0; i < variables.size(); ++i) {
            variables.set(i, (VariableDeclarator)variables.get(i).accept(this, arg));
        }
        this.removeNulls(variables);
        return n;
    }

    @Override
    public Node visit(ForeachStmt n, A arg) {
        this.visitComment(n, arg);
        n.setVariable((VariableDeclarationExpr)n.getVariable().accept(this, arg));
        n.setIterable((Expression)n.getIterable().accept(this, arg));
        n.setBody((Statement)n.getBody().accept(this, arg));
        return n;
    }

    @Override
    public Node visit(ForStmt n, A arg) {
        List<Expression> update;
        this.visitComment(n, arg);
        List<Expression> init = n.getInit();
        if (init != null) {
            for (int i = 0; i < init.size(); ++i) {
                init.set(i, (Expression)init.get(i).accept(this, arg));
            }
            this.removeNulls(init);
        }
        if (n.getCompare() != null) {
            n.setCompare((Expression)n.getCompare().accept(this, arg));
        }
        if ((update = n.getUpdate()) != null) {
            for (int i = 0; i < update.size(); ++i) {
                update.set(i, (Expression)update.get(i).accept(this, arg));
            }
            this.removeNulls(update);
        }
        n.setBody((Statement)n.getBody().accept(this, arg));
        return n;
    }

    @Override
    public Node visit(IfStmt n, A arg) {
        this.visitComment(n, arg);
        Expression condition = (Expression)n.getCondition().accept(this, arg);
        if (condition == null) {
            return null;
        }
        n.setCondition(condition);
        Statement thenStmt = (Statement)n.getThenStmt().accept(this, arg);
        if (thenStmt == null) {
            return null;
        }
        n.setThenStmt(thenStmt);
        if (n.getElseStmt() != null) {
            n.setElseStmt((Statement)n.getElseStmt().accept(this, arg));
        }
        return n;
    }

    @Override
    public Node visit(ImportDeclaration n, A arg) {
        this.visitComment(n, arg);
        n.setName((NameExpr)n.getName().accept(this, arg));
        return n;
    }

    @Override
    public Node visit(InitializerDeclaration n, A arg) {
        this.visitComment(n, arg);
        n.setBlock((BlockStmt)n.getBlock().accept(this, arg));
        return n;
    }

    @Override
    public Node visit(InstanceOfExpr n, A arg) {
        this.visitComment(n, arg);
        n.setExpr((Expression)n.getExpr().accept(this, arg));
        n.setType((Type)n.getType().accept(this, arg));
        return n;
    }

    @Override
    public Node visit(IntegerLiteralExpr n, A arg) {
        this.visitComment(n, arg);
        return n;
    }

    @Override
    public Node visit(IntegerLiteralMinValueExpr n, A arg) {
        this.visitComment(n, arg);
        return n;
    }

    @Override
    public Node visit(JavadocComment n, A arg) {
        return n;
    }

    @Override
    public Node visit(LabeledStmt n, A arg) {
        this.visitComment(n, arg);
        n.setStmt((Statement)n.getStmt().accept(this, arg));
        return n;
    }

    @Override
    public Node visit(LongLiteralExpr n, A arg) {
        this.visitComment(n, arg);
        return n;
    }

    @Override
    public Node visit(LongLiteralMinValueExpr n, A arg) {
        this.visitComment(n, arg);
        return n;
    }

    @Override
    public Node visit(MarkerAnnotationExpr n, A arg) {
        this.visitComment(n, arg);
        n.setName((NameExpr)n.getName().accept(this, arg));
        return n;
    }

    @Override
    public Node visit(MemberValuePair n, A arg) {
        this.visitComment(n, arg);
        n.setValue((Expression)n.getValue().accept(this, arg));
        return n;
    }

    @Override
    public Node visit(MethodCallExpr n, A arg) {
        List<Expression> args;
        List<Type> typeArgs;
        this.visitComment(n, arg);
        if (n.getScope() != null) {
            n.setScope((Expression)n.getScope().accept(this, arg));
        }
        if ((typeArgs = n.getTypeArgs()) != null) {
            for (int i = 0; i < typeArgs.size(); ++i) {
                typeArgs.set(i, (Type)typeArgs.get(i).accept(this, arg));
            }
            this.removeNulls(typeArgs);
        }
        if ((args = n.getArgs()) != null) {
            for (int i = 0; i < args.size(); ++i) {
                args.set(i, (Expression)args.get(i).accept(this, arg));
            }
            this.removeNulls(args);
        }
        return n;
    }

    @Override
    public Node visit(MethodDeclaration n, A arg) {
        List<ReferenceType> throwz;
        List<TypeParameter> typeParameters;
        this.visitComment(n, arg);
        List<AnnotationExpr> annotations = n.getAnnotations();
        if (annotations != null) {
            for (int i = 0; i < annotations.size(); ++i) {
                annotations.set(i, (AnnotationExpr)annotations.get(i).accept(this, arg));
            }
            this.removeNulls(annotations);
        }
        if ((typeParameters = n.getTypeParameters()) != null) {
            for (int i = 0; i < typeParameters.size(); ++i) {
                typeParameters.set(i, (TypeParameter)typeParameters.get(i).accept(this, arg));
            }
            this.removeNulls(typeParameters);
        }
        n.setType((Type)n.getType().accept(this, arg));
        List<Parameter> parameters = n.getParameters();
        if (parameters != null) {
            for (int i = 0; i < parameters.size(); ++i) {
                parameters.set(i, (Parameter)parameters.get(i).accept(this, arg));
            }
            this.removeNulls(parameters);
        }
        if ((throwz = n.getThrows()) != null) {
            for (int i = 0; i < throwz.size(); ++i) {
                throwz.set(i, (ReferenceType)throwz.get(i).accept(this, arg));
            }
            this.removeNulls(throwz);
        }
        if (n.getBody() != null) {
            n.setBody((BlockStmt)n.getBody().accept(this, arg));
        }
        return n;
    }

    @Override
    public Node visit(NameExpr n, A arg) {
        this.visitComment(n, arg);
        return n;
    }

    @Override
    public Node visit(NormalAnnotationExpr n, A arg) {
        this.visitComment(n, arg);
        n.setName((NameExpr)n.getName().accept(this, arg));
        List<MemberValuePair> pairs = n.getPairs();
        if (pairs != null) {
            for (int i = 0; i < pairs.size(); ++i) {
                pairs.set(i, (MemberValuePair)pairs.get(i).accept(this, arg));
            }
            this.removeNulls(pairs);
        }
        return n;
    }

    @Override
    public Node visit(NullLiteralExpr n, A arg) {
        this.visitComment(n, arg);
        return n;
    }

    @Override
    public Node visit(ObjectCreationExpr n, A arg) {
        List<BodyDeclaration<?>> anonymousClassBody;
        List<Type> typeArgs;
        this.visitComment(n, arg);
        if (n.getScope() != null) {
            n.setScope((Expression)n.getScope().accept(this, arg));
        }
        if ((typeArgs = n.getTypeArgs()) != null) {
            for (int i = 0; i < typeArgs.size(); ++i) {
                typeArgs.set(i, (Type)typeArgs.get(i).accept(this, arg));
            }
            this.removeNulls(typeArgs);
        }
        n.setType((ClassOrInterfaceType)n.getType().accept(this, arg));
        List<Expression> args = n.getArgs();
        if (args != null) {
            for (int i = 0; i < args.size(); ++i) {
                args.set(i, (Expression)args.get(i).accept(this, arg));
            }
            this.removeNulls(args);
        }
        if ((anonymousClassBody = n.getAnonymousClassBody()) != null) {
            for (int i = 0; i < anonymousClassBody.size(); ++i) {
                anonymousClassBody.set(i, (BodyDeclaration)anonymousClassBody.get(i).accept(this, arg));
            }
            this.removeNulls(anonymousClassBody);
        }
        return n;
    }

    @Override
    public Node visit(PackageDeclaration n, A arg) {
        this.visitComment(n, arg);
        List<AnnotationExpr> annotations = n.getAnnotations();
        if (annotations != null) {
            for (int i = 0; i < annotations.size(); ++i) {
                annotations.set(i, (AnnotationExpr)annotations.get(i).accept(this, arg));
            }
            this.removeNulls(annotations);
        }
        n.setName((NameExpr)n.getName().accept(this, arg));
        return n;
    }

    @Override
    public Node visit(Parameter n, A arg) {
        this.visitComment(n, arg);
        this.visitAnnotations(n, arg);
        n.setId((VariableDeclaratorId)n.getId().accept(this, arg));
        n.setType((Type)n.getType().accept(this, arg));
        return n;
    }

    @Override
    public Node visit(PrimitiveType n, A arg) {
        this.visitComment(n, arg);
        this.visitAnnotations(n, arg);
        return n;
    }

    @Override
    public Node visit(QualifiedNameExpr n, A arg) {
        this.visitComment(n, arg);
        n.setQualifier((NameExpr)n.getQualifier().accept(this, arg));
        return n;
    }

    @Override
    public Node visit(ReferenceType n, A arg) {
        this.visitComment(n, arg);
        this.visitAnnotations(n, arg);
        this.visitArraysAnnotations(n, arg);
        n.setType((Type)n.getType().accept(this, arg));
        return n;
    }

    @Override
    public Node visit(IntersectionType n, A arg) {
        this.visitComment(n, arg);
        this.visitAnnotations(n, arg);
        List<ReferenceType> elements = n.getElements();
        if (elements != null) {
            for (int i = 0; i < elements.size(); ++i) {
                elements.set(i, (ReferenceType)elements.get(i).accept(this, arg));
            }
            this.removeNulls(elements);
        }
        return n;
    }

    @Override
    public Node visit(UnionType n, A arg) {
        this.visitComment(n, arg);
        this.visitAnnotations(n, arg);
        List<ReferenceType> elements = n.getElements();
        if (elements != null) {
            for (int i = 0; i < elements.size(); ++i) {
                elements.set(i, (ReferenceType)elements.get(i).accept(this, arg));
            }
            this.removeNulls(elements);
        }
        return n;
    }

    @Override
    public Node visit(ReturnStmt n, A arg) {
        this.visitComment(n, arg);
        if (n.getExpr() != null) {
            n.setExpr((Expression)n.getExpr().accept(this, arg));
        }
        return n;
    }

    @Override
    public Node visit(SingleMemberAnnotationExpr n, A arg) {
        this.visitComment(n, arg);
        n.setName((NameExpr)n.getName().accept(this, arg));
        n.setMemberValue((Expression)n.getMemberValue().accept(this, arg));
        return n;
    }

    @Override
    public Node visit(StringLiteralExpr n, A arg) {
        this.visitComment(n, arg);
        return n;
    }

    @Override
    public Node visit(SuperExpr n, A arg) {
        this.visitComment(n, arg);
        if (n.getClassExpr() != null) {
            n.setClassExpr((Expression)n.getClassExpr().accept(this, arg));
        }
        return n;
    }

    @Override
    public Node visit(SwitchEntryStmt n, A arg) {
        List<Statement> stmts;
        this.visitComment(n, arg);
        if (n.getLabel() != null) {
            n.setLabel((Expression)n.getLabel().accept(this, arg));
        }
        if ((stmts = n.getStmts()) != null) {
            for (int i = 0; i < stmts.size(); ++i) {
                stmts.set(i, (Statement)stmts.get(i).accept(this, arg));
            }
            this.removeNulls(stmts);
        }
        return n;
    }

    @Override
    public Node visit(SwitchStmt n, A arg) {
        this.visitComment(n, arg);
        n.setSelector((Expression)n.getSelector().accept(this, arg));
        List<SwitchEntryStmt> entries = n.getEntries();
        if (entries != null) {
            for (int i = 0; i < entries.size(); ++i) {
                entries.set(i, (SwitchEntryStmt)entries.get(i).accept(this, arg));
            }
            this.removeNulls(entries);
        }
        return n;
    }

    @Override
    public Node visit(SynchronizedStmt n, A arg) {
        this.visitComment(n, arg);
        n.setExpr((Expression)n.getExpr().accept(this, arg));
        n.setBlock((BlockStmt)n.getBlock().accept(this, arg));
        return n;
    }

    @Override
    public Node visit(ThisExpr n, A arg) {
        this.visitComment(n, arg);
        if (n.getClassExpr() != null) {
            n.setClassExpr((Expression)n.getClassExpr().accept(this, arg));
        }
        return n;
    }

    @Override
    public Node visit(ThrowStmt n, A arg) {
        this.visitComment(n, arg);
        n.setExpr((Expression)n.getExpr().accept(this, arg));
        return n;
    }

    @Override
    public Node visit(TryStmt n, A arg) {
        this.visitComment(n, arg);
        List<VariableDeclarationExpr> types = n.getResources();
        for (int i = 0; i < types.size(); ++i) {
            n.getResources().set(i, (VariableDeclarationExpr)n.getResources().get(i).accept(this, arg));
        }
        n.setTryBlock((BlockStmt)n.getTryBlock().accept(this, arg));
        List<CatchClause> catchs = n.getCatchs();
        if (catchs != null) {
            for (int i = 0; i < catchs.size(); ++i) {
                catchs.set(i, (CatchClause)catchs.get(i).accept(this, arg));
            }
            this.removeNulls(catchs);
        }
        if (n.getFinallyBlock() != null) {
            n.setFinallyBlock((BlockStmt)n.getFinallyBlock().accept(this, arg));
        }
        return n;
    }

    @Override
    public Node visit(TypeDeclarationStmt n, A arg) {
        this.visitComment(n, arg);
        n.setTypeDeclaration((TypeDeclaration)n.getTypeDeclaration().accept(this, arg));
        return n;
    }

    @Override
    public Node visit(TypeParameter n, A arg) {
        this.visitComment(n, arg);
        List<ClassOrInterfaceType> typeBound = n.getTypeBound();
        if (typeBound != null) {
            for (int i = 0; i < typeBound.size(); ++i) {
                typeBound.set(i, (ClassOrInterfaceType)typeBound.get(i).accept(this, arg));
            }
            this.removeNulls(typeBound);
        }
        return n;
    }

    @Override
    public Node visit(UnaryExpr n, A arg) {
        this.visitComment(n, arg);
        n.setExpr((Expression)n.getExpr().accept(this, arg));
        return n;
    }

    @Override
    public Node visit(UnknownType n, A arg) {
        this.visitComment(n, arg);
        return n;
    }

    @Override
    public Node visit(VariableDeclarationExpr n, A arg) {
        Type type;
        this.visitComment(n, arg);
        List<AnnotationExpr> annotations = n.getAnnotations();
        if (annotations != null) {
            for (int i = 0; i < annotations.size(); ++i) {
                annotations.set(i, (AnnotationExpr)annotations.get(i).accept(this, arg));
            }
            this.removeNulls(annotations);
        }
        if ((type = (Type)n.getType().accept(this, arg)) == null) {
            return null;
        }
        n.setType(type);
        List<VariableDeclarator> vars = n.getVars();
        int i = 0;
        while (i < vars.size()) {
            VariableDeclarator decl = (VariableDeclarator)vars.get(i).accept(this, arg);
            if (decl == null) {
                vars.remove(i);
                continue;
            }
            vars.set(i++, decl);
        }
        if (vars.isEmpty()) {
            return null;
        }
        return n;
    }

    @Override
    public Node visit(VariableDeclarator n, A arg) {
        this.visitComment(n, arg);
        VariableDeclaratorId id = (VariableDeclaratorId)n.getId().accept(this, arg);
        if (id == null) {
            return null;
        }
        n.setId(id);
        if (n.getInit() != null) {
            n.setInit((Expression)n.getInit().accept(this, arg));
        }
        return n;
    }

    @Override
    public Node visit(VariableDeclaratorId n, A arg) {
        this.visitComment(n, arg);
        return n;
    }

    @Override
    public Node visit(VoidType n, A arg) {
        this.visitComment(n, arg);
        this.visitAnnotations(n, arg);
        return n;
    }

    @Override
    public Node visit(WhileStmt n, A arg) {
        this.visitComment(n, arg);
        n.setCondition((Expression)n.getCondition().accept(this, arg));
        n.setBody((Statement)n.getBody().accept(this, arg));
        return n;
    }

    @Override
    public Node visit(WildcardType n, A arg) {
        this.visitComment(n, arg);
        this.visitAnnotations(n, arg);
        if (n.getExtends() != null) {
            n.setExtends((ReferenceType)n.getExtends().accept(this, arg));
        }
        if (n.getSuper() != null) {
            n.setSuper((ReferenceType)n.getSuper().accept(this, arg));
        }
        return n;
    }

    @Override
    public Node visit(LambdaExpr n, A arg) {
        this.visitComment(n, arg);
        List<Parameter> parameters = n.getParameters();
        for (int i = 0; i < parameters.size(); ++i) {
            parameters.set(i, (Parameter)parameters.get(i).accept(this, arg));
        }
        this.removeNulls(parameters);
        if (n.getBody() != null) {
            n.setBody((Statement)n.getBody().accept(this, arg));
        }
        return n;
    }

    @Override
    public Node visit(MethodReferenceExpr n, A arg) {
        this.visitComment(n, arg);
        List<Type> types = n.getTypeArguments().getTypeArguments();
        for (int i = 0; i < types.size(); ++i) {
            n.getTypeArguments().getTypeArguments().set(i, (Type)n.getTypeArguments().getTypeArguments().get(i).accept(this, arg));
        }
        if (n.getScope() != null) {
            n.setScope((Expression)n.getScope().accept(this, arg));
        }
        return n;
    }

    @Override
    public Node visit(TypeExpr n, A arg) {
        this.visitComment(n, arg);
        if (n.getType() != null) {
            n.setType((Type)n.getType().accept(this, arg));
        }
        return n;
    }

    @Override
    public Node visit(BlockComment n, A arg) {
        return n;
    }

    @Override
    public Node visit(LineComment n, A arg) {
        return n;
    }

    private void visitComment(Node n, A arg) {
        if (n != null && n.getComment() != null) {
            n.setComment((Comment)n.getComment().accept(this, arg));
        }
    }
}

