/*
 * Decompiled with CFR 0.152.
 */
package io.spring.githubchangeloggenerator.github.service;

import org.springframework.util.Assert;

public final class Repository {
    private final String owner;
    private final String name;

    private Repository(String owner, String name) {
        this.owner = owner;
        this.name = name;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Repository other = (Repository)obj;
        return this.name.equals(other.name) && this.owner.equals(other.owner);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.owner.hashCode();
        return result;
    }

    public String toString() {
        return this.owner + "/" + this.name;
    }

    public static Repository of(String reference) {
        Assert.hasText((String)reference, (String)"GitHub repository references must not be empty");
        int slashIndex = reference.indexOf(47);
        Assert.isTrue((slashIndex >= 0 ? 1 : 0) != 0, (String)"GitHub repository references must include '/'");
        return new Repository(reference.substring(0, slashIndex), reference.substring(slashIndex + 1));
    }
}

