/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.text.pattern;

import java.io.File;
import java.util.regex.Pattern;

public final class Pattern2 {
    public static final int WILDCARD = 0x20000000;

    private Pattern2() {
    }

    public static Pattern compile(String pattern, int flags) {
        if ((flags & 0x20000010) != 0x20000000) {
            return Pattern.compile(pattern, flags);
        }
        String metaCharacters = "*?./{";
        int idx = Pattern2.findMeta(metaCharacters, pattern, 0);
        while (idx != pattern.length()) {
            switch (pattern.charAt(idx)) {
                case '*': {
                    String s = pattern.substring(idx);
                    if (s.startsWith("***")) {
                        pattern = pattern.substring(0, idx) + ".*" + pattern.substring(idx + 3);
                        idx += 2;
                        break;
                    }
                    if (s.startsWith("**")) {
                        pattern = pattern.substring(0, idx) + "[^!]*" + pattern.substring(idx + 2);
                        idx += 5;
                        break;
                    }
                    if (File.separatorChar != '/') {
                        pattern = pattern.substring(0, idx) + "[^/\\" + File.separatorChar + "!]*" + pattern.substring(idx + 1);
                        idx += 8;
                        break;
                    }
                    pattern = pattern.substring(0, idx) + "[^/!]*" + pattern.substring(idx + 1);
                    idx += 6;
                    break;
                }
                case '?': {
                    if (File.separatorChar != '/') {
                        pattern = pattern.substring(0, idx) + "[^/\\" + File.separatorChar + "!]" + pattern.substring(idx + 1);
                        idx += 7;
                        break;
                    }
                    pattern = pattern.substring(0, idx) + "[^/!]" + pattern.substring(idx + 1);
                    idx += 5;
                    break;
                }
                case '.': {
                    pattern = pattern.substring(0, idx) + "\\." + pattern.substring(idx + 1);
                    idx += 2;
                    break;
                }
                case '/': {
                    if (File.separatorChar != '/') {
                        pattern = pattern.substring(0, idx) + "[/\\" + File.separatorChar + "]" + pattern.substring(idx + 1);
                        idx += 5;
                        break;
                    }
                    ++idx;
                    break;
                }
                case '{': {
                    if (pattern.regionMatches(idx, "{0,1}", 0, 5)) {
                        pattern = pattern.substring(0, idx) + "?" + pattern.substring(idx + 5);
                        ++idx;
                        break;
                    }
                    if (pattern.regionMatches(idx, "{0,}", 0, 4)) {
                        pattern = pattern.substring(0, idx) + "*" + pattern.substring(idx + 4);
                        ++idx;
                        break;
                    }
                    ++idx;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            idx = Pattern2.findMeta(metaCharacters, pattern, idx);
        }
        return Pattern.compile(pattern, flags);
    }

    public static String[] parsePatternAndReplacement(String pattern) {
        String replacement = null;
        int idx = Pattern2.findMeta("=", pattern, 0);
        if (idx != pattern.length()) {
            replacement = pattern.substring(idx + 1);
            pattern = pattern.substring(0, idx);
        }
        return new String[]{pattern, replacement};
    }

    public static int findMeta(String metaCharacters, String subject, int offset) {
        int cc = 0;
        boolean q = false;
        int state = 0;
        while (offset != subject.length()) {
            char c = subject.charAt(offset);
            switch (state) {
                case 0: {
                    if (c == '\\') {
                        state = 1;
                        break;
                    }
                    if (c == '[') {
                        ++cc;
                        break;
                    }
                    if (c == ']' && cc > 0) {
                        --cc;
                        break;
                    }
                    if (cc > 0) break;
                    if (metaCharacters.indexOf(c) != -1 && !q) {
                        return offset;
                    }
                    if (c == '{') {
                        q = true;
                        break;
                    }
                    if (c != '}') break;
                    q = false;
                    break;
                }
                case 1: {
                    state = c == 'Q' ? 2 : 0;
                    break;
                }
                case 2: {
                    if (c != '\\') break;
                    state = 3;
                    break;
                }
                case 3: {
                    if (c == 'E') {
                        state = 0;
                        break;
                    }
                    if (c == '\\') break;
                    state = 2;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            ++offset;
        }
        return offset;
    }
}

