/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.reflect;

import de.unkrig.commons.nullanalysis.Nullable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public final class ReflectUtil {
    private ReflectUtil() {
    }

    public static Class<?>[] getTypes(List<Object> values) {
        Class[] types = new Class[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            Object value = values.get(i);
            if (value == null) continue;
            types[i] = value.getClass();
        }
        return types;
    }

    public static Method getMostSpecificMethod(Class<?> targetType, String methodName, Class<?>[] argumentTypes) throws NoSuchMethodException {
        Method mostSpecificMethod = null;
        for (Method method : ReflectUtil.getMethods(targetType)) {
            Class<?>[] parameterTypes;
            if (!method.getName().equals(methodName) || !Modifier.isPublic(method.getDeclaringClass().getModifiers()) || !ReflectUtil.areApplicable(parameterTypes = method.getParameterTypes(), argumentTypes)) continue;
            if (mostSpecificMethod == null) {
                mostSpecificMethod = method;
                continue;
            }
            if (ReflectUtil.isLessSpecific(mostSpecificMethod, method)) {
                mostSpecificMethod = method;
                continue;
            }
            if (ReflectUtil.isLessSpecific(method, mostSpecificMethod)) continue;
            throw new NoSuchMethodException("Ambiguity between " + method + " and " + mostSpecificMethod);
        }
        if (mostSpecificMethod == null) {
            throw new NoSuchMethodException(targetType + " has no method '" + methodName + "' applicable to argument types " + Arrays.toString(argumentTypes));
        }
        return mostSpecificMethod;
    }

    private static Collection<Method> getMethods(Class<?> type) {
        HashSet<Method> result = new HashSet<Method>();
        ReflectUtil.getMethods(type, result);
        return result;
    }

    private static void getMethods(Class<?> type, Collection<? super Method> result) {
        Class<?> sc = type.getSuperclass();
        if (sc != null) {
            ReflectUtil.getMethods(sc, result);
        }
        for (Class<?> interfacE : type.getInterfaces()) {
            ReflectUtil.getMethods(interfacE, result);
        }
        result.addAll(Arrays.asList(type.getMethods()));
    }

    public static Constructor<?> getMostSpecificConstructor(Class<?> type, Class<?>[] argumentTypes) throws NoSuchMethodException {
        Constructor<?> mostSpecificConstructor = null;
        for (Constructor<?> constructor : type.getConstructors()) {
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            if (!ReflectUtil.areApplicable(parameterTypes, argumentTypes)) continue;
            if (mostSpecificConstructor == null) {
                mostSpecificConstructor = constructor;
                continue;
            }
            if (ReflectUtil.isLessSpecific(mostSpecificConstructor, constructor)) {
                mostSpecificConstructor = constructor;
                continue;
            }
            if (ReflectUtil.isLessSpecific(constructor, mostSpecificConstructor)) continue;
            throw new NoSuchMethodException("Ambiguity between " + constructor + " and " + mostSpecificConstructor);
        }
        if (mostSpecificConstructor == null) {
            throw new NoSuchMethodException(type + " has no constructor that is applicable to " + Arrays.toString(argumentTypes));
        }
        return mostSpecificConstructor;
    }

    private static boolean isLessSpecific(Method method1, Method method2) {
        return !ReflectUtil.isApplicable(method2.getDeclaringClass(), method1.getDeclaringClass()) || !ReflectUtil.areApplicable(method2.getParameterTypes(), method1.getParameterTypes()) || !ReflectUtil.isApplicable(method2.getReturnType(), method1.getReturnType());
    }

    private static boolean isLessSpecific(Constructor<?> constructor1, Constructor<?> constructor2) {
        return !ReflectUtil.areApplicable(constructor2.getParameterTypes(), constructor1.getParameterTypes());
    }

    private static boolean areApplicable(Class<?>[] parameterTypes, Class<?>[] argumentTypes) {
        if (parameterTypes.length != argumentTypes.length) {
            return false;
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (ReflectUtil.isApplicable(parameterTypes[i], argumentTypes[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean isApplicable(Class<?> parameterType, @Nullable Class<?> argumentType) {
        if (argumentType == null) {
            return true;
        }
        if (parameterType.isPrimitive()) {
            if (parameterType == Boolean.TYPE && argumentType == Boolean.class) {
                return true;
            }
            if (parameterType == Byte.TYPE && argumentType == Byte.class) {
                return true;
            }
            if (parameterType == Short.TYPE && (argumentType == Short.class || argumentType == Byte.class)) {
                return true;
            }
            if (parameterType == Integer.TYPE && (argumentType == Integer.class || argumentType == Short.class || argumentType == Byte.class)) {
                return true;
            }
            if (parameterType == Long.TYPE && (argumentType == Long.class || argumentType == Integer.class || argumentType == Short.class || argumentType == Byte.class)) {
                return true;
            }
            if (parameterType == Character.TYPE && argumentType == Character.class) {
                return true;
            }
            if (parameterType == Float.TYPE && (argumentType == Float.class || argumentType == Double.class)) {
                return true;
            }
            if (parameterType == Double.TYPE && argumentType == Double.class) {
                return true;
            }
            return parameterType == argumentType;
        }
        return parameterType.isAssignableFrom(argumentType);
    }
}

