/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.net.tool.httpd;

import de.unkrig.commons.lang.ThreadUtil;
import de.unkrig.commons.net.tool.httpd.Httpd;
import de.unkrig.commons.util.logging.SimpleLogging;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.logging.Level;

public final class Main {
    private Main() {
    }

    public static void main(String[] args) throws IOException {
        String arg;
        int i = 0;
        while (i < args.length && (arg = args[i]).startsWith("-")) {
            ++i;
            if ("-help".equals(arg)) {
                System.out.println("Usage:");
                System.out.println("  java " + Main.class.getName() + " [ <option> ... ] ( <local-port> <document-root> ) ...");
                System.out.println("Valid options are:");
                System.out.println("  -help");
                System.out.println("  -log <level> Log to STDERR");
                return;
            }
            if ("-log".equals(arg)) {
                SimpleLogging.setLevel(Level.parse(args[i++]));
                continue;
            }
            System.err.println("Invalid command line option '" + arg + "' - try '-help'.");
            System.exit(1);
        }
        if (i == args.length || (args.length - i) % 2 != 0) {
            System.err.println("Local port and/or document root missing - try '-help'.");
            System.exit(1);
        }
        while (i + 2 <= args.length) {
            int localPort = Integer.parseInt(args[i++]);
            String fileName = args[i++];
            Httpd httpd = new Httpd(new InetSocketAddress(localPort), fileName);
            ThreadUtil.runInBackground(httpd, "httpd");
        }
        try {
            Thread.sleep(Long.MAX_VALUE);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

