/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.net.http.servlett;

import de.unkrig.commons.lang.protocol.ConsumerWhichThrows;
import de.unkrig.commons.net.http.HttpRequest;
import de.unkrig.commons.net.http.HttpResponse;
import de.unkrig.commons.net.http.servlett.AbstractServlett;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.util.Base64;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;

public class HttpAuthenticationServlett<EX extends Exception>
extends AbstractServlett {
    private final String realm;
    private final UserNamePasswordPredicate<EX> userNamePasswordPredicate;

    public HttpAuthenticationServlett(String realm, UserNamePasswordPredicate<EX> userNamePasswordPredicate) {
        this.realm = realm;
        this.userNamePasswordPredicate = userNamePasswordPredicate;
    }

    @Override
    @Nullable
    public HttpResponse handleRequest(HttpRequest httpRequest, ConsumerWhichThrows<HttpResponse, IOException> sendProvisionalResponse) {
        try {
            return this.handleRequest2(httpRequest, sendProvisionalResponse);
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            return HttpResponse.response(HttpResponse.Status.INTERNAL_SERVER_ERROR, sw.toString());
        }
    }

    @Nullable
    private HttpResponse handleRequest2(HttpRequest httpRequest, ConsumerWhichThrows<HttpResponse, IOException> sendProvisionalResponse) throws EX {
        char[] password;
        String userPass;
        String s = httpRequest.getHeader("Authorization");
        if (s == null) {
            HttpResponse httpResponse = HttpResponse.response(HttpResponse.Status.UNAUTHORIZED);
            httpResponse.addHeader("WWW-Authenticate", "Basic realm=\"" + this.realm + "\"");
            return httpResponse;
        }
        if (!s.startsWith("Basic ")) {
            return HttpResponse.response(HttpResponse.Status.BAD_REQUEST, "Unexpected authentication scheme");
        }
        try {
            userPass = new String(Base64.base64ToByteArray(s.substring(6)));
        }
        catch (Exception e) {
            return HttpResponse.response(HttpResponse.Status.BAD_REQUEST, "BASE64 encoding error: " + e);
        }
        int idx = userPass.indexOf(58);
        if (idx == -1) {
            return HttpResponse.response(HttpResponse.Status.BAD_REQUEST, "Basic-credentials lack a colon");
        }
        String userName = userPass.substring(0, idx);
        boolean authenticated = this.userNamePasswordPredicate.evaluate(httpRequest, userName, password = userPass.substring(idx + 1).toCharArray());
        if (!authenticated) {
            HttpResponse httpResponse = HttpResponse.response(HttpResponse.Status.UNAUTHORIZED, "Invalid user name or password");
            httpResponse.addHeader("WWW-Authenticate", "Basic realm=\"" + this.realm + "\"");
            return httpResponse;
        }
        return null;
    }

    public static interface UserNamePasswordPredicate<EX extends Throwable> {
        public boolean evaluate(HttpRequest var1, String var2, char[] var3) throws EX;
    }
}

