/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.util.pattern;

import de.unkrig.commons.io.charstream.CharSequenceCharStream;
import de.unkrig.commons.io.charstream.UnexpectedCharacterException;
import java.util.ArrayList;

public abstract class IntegerPattern {
    IntegerPattern() {
    }

    public abstract boolean matches(Integer var1);

    public static IntegerPattern newPattern(String pattern) throws UnexpectedCharacterException {
        class Range {
            final int min;
            final int max;

            public Range(int min, int max) {
                this.min = min;
                this.max = max;
            }
        }
        final ArrayList<Range> ranges = new ArrayList<Range>();
        CharSequenceCharStream cs = new CharSequenceCharStream(pattern);
        while (true) {
            Range range;
            if (cs.peekRead('-')) {
                range = new Range(Integer.MIN_VALUE, IntegerPattern.readInt(cs));
            } else {
                int min = IntegerPattern.readInt(cs);
                range = !cs.peekRead('-') ? new Range(min, min) : (cs.peekRead("0123456789") == -1 ? new Range(min, Integer.MAX_VALUE) : new Range(min, IntegerPattern.readInt(cs)));
            }
            ranges.add(range);
            if (cs.isAtEoi()) break;
            cs.read(";, ");
            while (cs.peekRead(";, ") != -1) {
            }
        }
        return new IntegerPattern(){

            public boolean matches(Integer subject) {
                for (Range range : ranges) {
                    if (subject < range.min || subject > range.max) continue;
                    return true;
                }
                return false;
            }
        };
    }

    private static int readInt(CharSequenceCharStream cs) throws UnexpectedCharacterException {
        int res = cs.read("0123456789");
        int x;
        while ((x = cs.peekRead("0123456789")) != -1) {
            res = 10 * res + x;
        }
        return res;
    }
}

