
static const char *ProvidersType[] = {
  "SKYBOX=Sky Italia:11881:V:S13.0E:27500:sky_it.dict:sky_it.themes",
  "SKYBOX=Sky UK:11778:V:S28.2E:27500:sky_uk.dict:sky_uk.themes",
  "MHW_1=Cyfra+:10719:V:S13.0E:27500",
  "MHW_1=Canal+:12363:V:S19.2E:27500",
  "MHW_1=Canal Digitaal:12515:H:S19.2E:22000",
  "MHW_2=Digital+:10847:V:S19.2E:22000",
  "FILE=Load external file:/tmp/epg.data",
  "SCRIPT=Execute external script:/vdr/script/getepg.sh:/tmp/epg.data",
  NULL
};

static const char *FileEquivalences[] = {
  "#",
  "# Simply add a list of the channels in this file with the following format:",
  "#",
  "# <OriginalChannelId> <OtherChannelId> <ChannelName>",
  "#",
  "",
  "S13.0E-64511-6700-11517 S13.0E-318-13000-14601 BBC Prime",
  "S13.0E-318-5200-3401 S19.2E-1-1024-9015 Rai Uno",
  "S13.0E-318-5200-3401 S13.0E-318-12400-8511 Rai Uno",
  "S13.0E-318-5200-3402 S13.0E-318-12400-8512 Rai Due",
  "S13.0E-318-5200-3403 S13.0E-318-12400-8513 Rai Tre",
  "S13.0E-272-6000-3 T-272-905-143 Rete 4",
  "S13.0E-272-6000-2 T-272-905-141 Canale 5",
  "S13.0E-272-6000-1 T-272-905-142 Italia 1",
  "S13.0E-64511-8600-11733 T-29-514-1 La 7",
  "S13.0E-64511-6700-11504 S13.0E-318-200-13831 Eurosport",
  "",
  NULL
};

static const char *SkyItDictionary[] = {
  " =00001011010110001111010101010",
  " =00001011010110001111010101011",
  " =00001011010110001111010101100",
  " =00001011010110001111010101101",
  " =00001011010110001111010101110",
  " =00001011010110001111010101111",
  " =00001011010110001111010110000",
  " =00001011010110001111010110001",
  " =00001011010110001111010110010",
  " =00001011010110001111010110011",
  " =00001011010110001111010110100",
  " =00001011010110001111010110101",
  " =00001011010110001111010110110",
  " =1001110",
  " =00001011010110001111010110111",
  " =00001011010110001111010111000",
  " =00001011010110001111010111001",
  " =00001011010110001111010111010",
  " =00001011010110001111010111011",
  " =00001011010110001111010111100",
  " =00001011010110001111010111101",
  " =00001011010110001111010111110",
  " =00001011010110001111010111111",
  " =00001011010110001111011000000",
  " =00001011010110001111011000001",
  " =00001011010110001111011000010",
  " =00001011010110001111011000011",
  " =00001011010110001111011000100",
  " =00001011010110001111011000101",
  " =00001011010110001111011000110",
  " =00001011010110001111011000111",
  " =00001011010110001111011001000",
  " =01",
  "!=1110000011101",
  "\"=11100010000100011",
  "#=00001011010110001111011001001",
  "$=00001011010110001111011001010",
  "%=00001011010110001111011001011",
  "&=11100010000101",
  "'=0000100",
  "(=0000101101010",
  ")=110100111111",
  "*=00001011010110001111011001100",
  "+=000010110101100011111",
  ",=110000",
  "-=10110011",
  ".=100110",
  "/=111000100001001",
  "0=10010011",
  "1=100100000",
  "2=1111011001",
  "3=1110001110",
  "4=11000100101",
  "5=111101110100",
  "6=101100101111",
  "7=110100011110",
  "8=11010001110",
  "9=1111010111",
  ":=100100011",
  ";=10000111101",
  "<=00001011010110001111011001101",
  "==00001011010110001111011001110",
  ">=00001011010110001111011001111",
  "?=1100110110110",
  "@=1110001000010000",
  "A=00001010",
  "B=111101001",
  "C=10010100",
  "D=100001010",
  "E=111000000",
  "F=1110001100",
  "G=100101100",
  "H=1000011111",
  "I=1111011111",
  "J=1100010110",
  "K=11110100011",
  "L=001111101",
  "M=100001101",
  "N=100001011",
  "O=1100101011",
  "P=110100000",
  "Q=00001011000",
  "R=110010100",
  "S=10110100",
  "T=110101100",
  "U=110100010011",
  "V=1001000011",
  "W=1101000110",
  "X=1110001011001",
  "Y=1100011110011",
  "Z=1100010100110",
  "[=00001011010110001111011010000",
  "\\=00001011010110001111011010001",
  "]=00001011010110001111011010010",
  "^=0000101101011000100",
  "_=00001011010110001111011010011",
  "`=00001011010111",
  "a=11111",
  "b=11100001",
  "c=111001",
  "d=1011000",
  "e=1010",
  "f=0011011",
  "g=000011",
  "h=10110110",
  "i=0001",
  "j=110100010000",
  "k=110001100",
  "l=1111001",
  "m=100010",
  "n=10111",
  "o=0010",
  "p=100011",
  "q=1110001001",
  "r=11011",
  "s=00000",
  "t=11101",
  "u=001110",
  "v=1100111",
  "w=001100110",
  "x=11100011110",
  "y=111101101",
  "z=0011010",
  "{=00001011010110001111011010100",
  "|=00001011010110001111011010101",
  "}=00001011010110001111011010110",
  "~=00001011010110001111011010111",
  " =00001011010110001111011011000",
  " =000010110101100000",
  " =00001011010110001111011011001",
  " =00001011010110001111011011010",
  " =00001011010110001111011011011",
  " =00001011010110001111011011100",
  " =00001011010110001111011011101",
  " =00001011010110001111011011110",
  " =00001011010110001111011011111",
  " =11100010000100010",
  " =000010110101100001",
  " =00001011010110001111011100000",
  " =00001011010110001111011100001",
  " =00001011010110001111011100010",
  " =00001011010110001111011100011",
  " =00001011010110001111011100100",
  " =00001011010110001111011100101",
  " =00001011010110001111011100110",
  " =00001011010110001111011100111",
  " =00001011010110001110",
  " =00001011010110001111011101000",
  " =00001011010110001111011101001",
  " =00001011010110001111011101010",
  " =00001011010110001111011101011",
  " =0000101101011000101",
  " =00001011010110001111011101100",
  " =00001011010110001111011101101",
  " =00001011010110001111011101110",
  " =00001011010110001111011101111",
  " =00001011010110001111011110000",
  " =00001011010110001111011110001",
  " =00001011010110001111011110010",
  " =00001011010110001111011110011",
  "=00001011010110001111011110100",
  "=00001011010110001111011110101",
  "=00001011010110001111011110110",
  "=00001011010110001111011110111",
  "=00001011010110001111011111000",
  "=00001011010110001111011111001",
  "=00001011010110001111011111010",
  "=00001011010110001111011111011",
  "=00001011010110001111011111100",
  "=00001011010110001111011111101",
  "=00001011010110001111011111110",
  "=00001011010110001111011111111",
  "=0000101101011000111100000000",
  "=0000101101011000111100000001",
  "=0000101101011000111100000010",
  "=0000101101011000111100000011",
  "=0000101101011000111100000100",
  "=0000101101011000111100000101",
  "=0000101101011000111100000110",
  "=0000101101011000111100000111",
  "=0000101101011000111100001000",
  "=0000101101011000111100001001",
  "=0000101101011000111100001010",
  "=0000101101011001",
  "=0000101101011000111100001011",
  "=0000101101011000111100001100",
  "=0000101101011000111100001101",
  "=0000101101011000111100001110",
  "=0000101101011000111100001111",
  "=0000101101011000111100010000",
  "=0000101101011000111100010001",
  "=0000101101011000111100010010",
  "=0000101101011000111100010011",
  "=0000101101011000111100010100",
  "=0000101101011000111100010101",
  "=0000101101011000111100010110",
  "=0000101101011000111100010111",
  "=0000101101011000111100011000",
  "=000010110101101",
  "=0000101101011000111100011001",
  "=0000101101011000111100011010",
  "=0000101101011000111100011011",
  "=0000101101011000111100011100",
  "=0000101101011000111100011101",
  "=0000101101011000111100011110",
  "=0000101101011000111100011111",
  "=0000101101011000111100100000",
  "=0000101101011000111100100001",
  "=0000101101011000111100100010",
  "=0000101101011000111100100011",
  "=0000101101011000111100100100",
  "=0000101101011000111100100101",
  "=0000101101011000111100100110",
  "=0000101101011000111100100111",
  "=0000101101011000111100101000",
  "=0000101101011000111100101001",
  "=0000101101011000111100101010",
  "=0000101101011000111100101011",
  "=0000101101011000111100101100",
  "=0000101101011000111100101101",
  "=0000101101011000111100101110",
  "=0000101101011000111100101111",
  "=0000101101011000111100110000",
  "=0000101101011000111100110001",
  "=0000101101011000110",
  "=0000101101011000111100110010",
  "=0000101101011000111100110011",
  "=0000101101011000111100110100",
  "=0000101101011000111100110101",
  "=0000101101011000111100110110",
  "=0000101101011000111100110111",
  "=0000101101011000111100111000",
  "=0000101101011000111100111001",
  "=0000101101011000111100111010",
  "=0000101101011000111100111011",
  "=0000101101011000111100111100",
  "=0000101101011000111100111101",
  "=0000101101011000111100111110",
  "=0000101101011000111100111111",
  "=0000101101011000111101000000",
  "=0000101101011000111101000001",
  "=0000101101011000111101000010",
  "=0000101101011000111101000011",
  "=0000101101011000111101000100",
  "=0000101101011000111101000101",
  "=0000101101011000111101000110",
  "=0000101101011000111101000111",
  "=0000101101011000111101001000",
  "=0000101101011000111101001001",
  "=0000101101011000111101001010",
  "=0000101101011000111101001011",
  "=0000101101011000111101001100",
  "=0000101101011000111101001101",
  "=0000101101011000111101001110",
  "=0000101101011000111101001111",
  "=0000101101011000111101010000",
  "(dur=100001111000",
  "2001=001111100",
  "2002=111000110101",
  "Adulti=100001111001",
  "Alle=1100110111",
  "American=10110101100",
  "Argentina=110010101011",
  "Attualita'=110001000001",
  "Bateman=10010111111",
  "Bechis=1100010111011",
  "Campionato=1101001111000",
  "Carlos=1101000011101",
  "Cartoon=11110111011",
  "Club=10000110010",
  "Commedia=100001100001",
  "Con=10110101101",
  "D'Alo'=1100100011111",
  "Da=1001010111",
  "Dal=1111010100011",
  "Dalle=10010111110",
  "Drammatico=111101111001",
  "Durante=1101000111110",
  "Echeverria=1100011100110",
  "Emmanuelle=1100011100111",
  "Enzo=1101000100010",
  "Fares=00001011011",
  "Figli=1100100011000",
  "Film=1101011010",
  "Fine=100001001100",
  "Fiumi=00001011100",
  "Francia=10000110001",
  "Giallo=110001001000",
  "Giovanni=1100011101000",
  "Harron=10011110000",
  "ITV=1101000100100",
  "Il=0011001110",
  "In=1001011011",
  "Informazione=11110100001",
  "Intrattenimento=1000010000",
  "Italia=11100010001",
  "Javier=1100011101001",
  "Jean=10010101011",
  "John=1111011100101",
  "Kassovitz=00110000101",
  "L'appassionante=00001011101",
  "La=1001010110",
  "Le=11000100111",
  "Ma=1101001110",
  "Magazine=100001110010",
  "Mammuccari=1100011101010",
  "Manhattan=10110010010",
  "Marco=1110001011110",
  "Mary=10011110110",
  "Mathieu=00110000110",
  "Michael=1101001111011",
  "Momo=110010001011",
  "Nadia=00001011110",
  "News=110100111110",
  "Notiziario=101100101110",
  "Orario=1001000100",
  "Patrick=10110010110",
  "Paul=000010110011",
  "Per=11000100110",
  "Peter=1100101010101",
  "Programmazione=1110001101001",
  "Psycho=10011110111",
  "Regia=110010000",
  "Reno=00110000111",
  "Rosa=1100011110101",
  "Rubrica=1111011100100",
  "Sandrelli=1100100010001",
  "Seigner=1100011101011",
  "Servizi=001100000110",
  "Snow=100100001000",
  "Sorvino=1100011110110",
  "Stefania=1101011011010",
  "Stream=111101000100",
  "Street=10110101111",
  "Streghe=1100011101100",
  "TRAMA:=1100010111010",
  "Teo=110001110010",
  "USA=1101000101",
  "Un=11110111101",
  "Una=101100100010",
  "Veronesi=1100011101101",
  "Vincent=00110001001",
  "Wall=11000100001",
  "World=001100010110",
  "XXX=10000110011",
  "ad=1111010110",
  "affidare=00110000100",
  "ai=1001011110",
  "al=0011110",
  "alla=11010110111",
  "alle=111101110101",
  "amici=111000101110",
  "ammazzare=10011110001",
  "and=1111010101",
  "anfiteatro=1100100011001",
  "anni=10010101010",
  "as=110011010",
  "attraverso=1101011011001",
  "aver=000010110100",
  "bambina=1101000100011",
  "banda=1110001011000",
  "bello=10110101000",
  "brani=1100100010010",
  "broker=10011110010",
  "business=000010110010",
  "casa=101100100011",
  "casi=10000111010",
  "cassel=00001011111",
  "cerca=11100010100",
  "che=10010010",
  "chilometri=00110001111",
  "citta'=110001000101",
  "come=110001011100",
  "compagnia=1100110110001",
  "con=11010010",
  "conquista=1101000111111",
  "contro=110001000100",
  "crede=1110001111110",
  "cui=001100111110",
  "cultura=100001110001",
  "curiosita'=001100010111",
  "da=00110010",
  "dai=1101000100101",
  "dal=11110110000",
  "dalla=100101101001",
  "decidG266  :  dedicato=0000101101011000111101010001",
  "degli=110001000000",
  "dei=0011000110",
  "del=111100010",
  "della=1011001010",
  "delle=11000111000",
  "destra=1100101010001",
  "deve=1111010001011",
  "di=100000",
  "diabolici=1100100011010",
  "dice=1100110110000",
  "diretta=100100001011",
  "distanza=00110000000",
  "divide=10110010011",
  "divisi=1100011101110",
  "dolce=1101001111001",
  "domani=1111010100010",
  "due=1100011111",
  "e'=110001101",
  "ed=101101111",
  "essere=1110001000000",
  "esseri=1110001111101",
  "eventiG=0000101101011000111101010010",
  "fatti=001100111111",
  "feste=10110101001",
  "film=10000100011",
  "gemelli=1110001000011",
  "giorno=11110100000",
  "giovane=11100000110",
  "giovani=1111011110001",
  "gli=100101110",
  "grande=1110001011111",
  "grandi=1111010001010",
  "grigi'=1100100011011",
  "ha=1100010101",
  "il=11001011",
  "imbattere=1100100011100",
  "in=1101010",
  "incinta=1100101010000",
  "informazione=110001001001",
  "inizio=1001010100",
  "internazionale=100001110111",
  "interviste=100100001001",
  "la=11001100",
  "lavoro=11010000110",
  "le=11010111",
  "levatrice=1100011101111",
  "libro=1100011110100",
  "lo=111100011",
  "loro=11000101000",
  "ma=10011111",
  "maggiori=100001110110",
  "malcapitati=10110010000",
  "maschietto=1100011110000",
  "mondo=11100010101",
  "musica=111000001111",
  "nato=111101110011",
  "nel=11110111000",
  "nella=1111010100000",
  "nello=10000100100",
  "news=10010110101",
  "non=00110011110",
  "nord=1100100011101",
  "nuovi=001100000111",
  "of=1011010101",
  "ogni=100001110011",
  "ore=1101000010",
  "parte=1101011011011",
  "per=00111111",
  "piccola=1101001111010",
  "piu'=1001111010",
  "poliziotti=00110001110",
  "porpora=00110000001",
  "prima=1110001111100",
  "produttore=1100011110111",
  "programmazione=1110001101000",
  "proprio=1101011011000",
  "prossimo=1001000101",
  "quattro=1111011000110",
  "regime=1100011110001",
  "ricco=10110101110",
  "ricordi=1100101010100",
  "rovine=1110001000001",
  "salvare=1110000011100",
  "scrittore=1100110110111",
  "scrive=1101000011110",
  "serie=1111011000111",
  "servizi=100001110000",
  "settimanale=1100010100111",
  "si=11110000",
  "singolari=00110001000",
  "solo=110010001010",
  "sono=11000100011",
  "stesso=10000100010",
  "storia=11100011011",
  "streghe=1100100010000",
  "su=1110000010",
  "sua=10000100101",
  "successo=100101101000",
  "sui=110011011001",
  "sulle=100100001010",
  "suo=10000100111",
  "suoi=1101000011100",
  "tale=110010101001",
  "tempo=111101100010",
  "the=11110101001",
  "timida=1100100011110",
  "torturare=10011110011",
  "tra=110100110",
  "trasformarlo=1100011110010",
  "trecento=00110000010",
  "trovato=1101000011111",
  "tutto=110011011010",
  "ultimi=1100100010011",
  "un=11001001",
  "una=101101110",
  "uno=111000101101",
  "uomini=1111011110000",
  "vedono=00110001010",
  "vengono=100001001101",
  "verso=100001100000",
  "viaggio=110001010010",
  "viene=1111010100001",
  "vita=11000101111",
  "vuole=1110001111111",
  NULL
};

static const char *SkyUkDictionary[] = {
  " =101010111000110000101001100",
  " =101010111000110000101001101",
  " =101010111000110000101001110",
  " =101010111000110000101001111",
  " =101010111000110000101010000",
  " =101010111000110000101010001",
  " =101010111000110000101010010",
  " =101010111000110000101010011",
  " =101010111000110000101010100",
  " =0001000",
  " =1110111",
  " =101010111000110000101010101",
  " =101010111000110000101010110",
  " =101010111000110000101010111",
  " =101010111000110000101011000",
  " =101010111000110000101011001",
  " =101010111000110000101011010",
  " =101010111000110000101011011",
  " =101010111000110000101011100",
  " =101010111000110000101011101",
  " =101010111000110000101011110",
  " =101010111000110000101011111",
  " =101010111000110000101100000",
  " =101010111000110000101100001",
  " =101010111000110000101100010",
  " =101010111000110000101100011",
  " =101010111000110000101100100",
  " =101010111000110000101100101",
  " =101010111000110000101100110",
  " =101010111000110000101100111",
  " =101010111000110000101101000",
  " =101010111000110000101101001",
  " =110",
  "!=01000011000",
  "\"=101010111000110000101101010",
  "#=101010111000110000101101011",
  "$=1010101110001101",
  "%=101010111000110000101101100",
  "&=10000011101",
  "'=10000010",
  "(=11101000101",
  ")=1010101100",
  "*=100010101110",
  "+=101010111000110000101101101",
  ",=1011000",
  "-=10001011",
  ".=1110110",
  "/=00010100011110",
  "0=111010010",
  "1=101100111",
  "2=1000101000",
  "3=1000001111",
  "4=0001010000",
  "5=1110101000",
  "6=1000101001",
  "7=1000100010",
  "8=10001010110",
  "9=0100001101",
  ":=11101000110",
  ";=00010100010",
  "<=1110100011111",
  "==101010111000110000101101110",
  ">=1110101001100",
  "?=111010100111",
  "@=101010111000110001",
  "A=11100010",
  "B=01000000",
  "C=01000010",
  "D=111000111",
  "E=1110100000",
  "F=101010100",
  "G=100010000",
  "H=101010101",
  "I=1110100001",
  "J=000101001",
  "K=1110100111",
  "L=100000110",
  "M=10001001",
  "N=111010111",
  "O=010000010",
  "P=00010101",
  "Q=1000101010111",
  "R=111010110",
  "S=0001001",
  "T=0001011",
  "U=10101011101",
  "V=11101010101",
  "W=10110010",
  "X=1110001101101111",
  "Y=10101011110",
  "Z=1110101010000",
  "[=10101011100011001",
  "\\=101010111000110000101101111",
  "]=11100011011011100",
  "^=101010111000110000101110000",
  "_=101010111000110000101110001",
  "`=11101010010",
  "a=1001",
  "b=1110000",
  "c=111001",
  "d=01001",
  "e=1111",
  "f=100001",
  "g=100011",
  "h=10111",
  "i=0101",
  "j=11100011010",
  "k=1000000",
  "l=10100",
  "m=101011",
  "n=0111",
  "o=0011",
  "p=000111",
  "q=10101011011",
  "r=0010",
  "s=0000",
  "t=0110",
  "u=101101",
  "v=1010100",
  "w=000110",
  "x=1110101011",
  "y=010001",
  "z=1011001100",
  "{=101010111000110000101110010",
  "|=101010111000110000101110011",
  "}=101010111000110000101110100",
  "~=101010111000110000101110101",
  " =101010111000110000101110110",
  " =101010111000110000101110111",
  " =101010111000110000101111000",
  " =101010111000110000101111001",
  " =101010111000110000101111010",
  " =101010111000110000101111011",
  " =101010111000110000101111100",
  " =101010111000110000101111101",
  " =101010111000110000101111110",
  " =101010111000110000101111111",
  " =101010111000110000110000000",
  " =101010111000110000110000001",
  " =101010111000110000110000010",
  " =101010111000110000110000011",
  " =101010111000110000110000100",
  " =101010111000110000110000101",
  " =101010111000110000110000110",
  " =101010111000110000110000111",
  " =101010111000110000110001000",
  " =101010111000110000110001001",
  " =101010111000110000110001010",
  " =101010111000110000110001011",
  " =101010111000110000110001100",
  " =101010111000110000110001101",
  " =101010111000110000110001110",
  " =101010111000110000110001111",
  " =101010111000110000110010000",
  " =101010111000110000110010001",
  " =101010111000110000110010010",
  " =11100011011011101",
  " =101010111000110000110010011",
  " =101010111000110000110010100",
  " =101010111000110000110010101",
  "=101010111000110000110010110",
  "=101010111000110000110010111",
  "=101010111000110000110011000",
  "=101010111000110000110011001",
  "=101010111000110000110011010",
  "=101010111000110000110011011",
  "=101010111000110000110011100",
  "=101010111000110000110011101",
  "=101010111000110000110011110",
  "=101010111000110000110011111",
  "=101010111000110000110100000",
  "=101010111000110000110100001",
  "=101010111000110000110100010",
  "=101010111000110000110100011",
  "=101010111000110000110100100",
  "=101010111000110000110100101",
  "=101010111000110000110100110",
  "=101010111000110000110100111",
  "=101010111000110000110101000",
  "=101010111000110000110101001",
  "=101010111000110000110101010",
  "=101010111000110000110101011",
  "=101010111000110000110101100",
  "=101010111000110000110101101",
  "=101010111000110000110101110",
  "=101010111000110000110101111",
  "=101010111000110000110110000",
  "=101010111000110000110110001",
  "=101010111000110000110110010",
  "=101010111000110000110110011",
  "=101010111000110000110110100",
  "=101010111000110000110110101",
  "=101010111000110000110110110",
  "=101010111000110000110110111",
  "=101010111000110000110111000",
  "=101010111000110000110111001",
  "=101010111000110000110111010",
  "=101010111000110000110111011",
  "=101010111000110000110111100",
  "=101010111000110000110111101",
  "=101010111000110000110111110",
  "=101010111000110000110111111",
  "=101010111000110000111000000",
  "=101010111000110000111000001",
  "=101010111000110000111000010",
  "=101010111000110000111000011",
  "=101010111000110000111000100",
  "=101010111000110000111000101",
  "=101010111000110000111000110",
  "=101010111000110000111000111",
  "=101010111000110000111001000",
  "=101010111000110000111001001",
  "=101010111000110000111001010",
  "=101010111000110000111001011",
  "=101010111000110000111001100",
  "=101010111000110000111001101",
  "=101010111000110000111001110",
  "=101010111000110000111001111",
  "=101010111000110000111010000",
  "=101010111000110000111010001",
  "=101010111000110000111010010",
  "=101010111000110000111010011",
  "=101010111000110000111010100",
  "=101010111000110000111010101",
  "=101010111000110000111010110",
  "=101010111000110000111010111",
  "=101010111000110000111011000",
  "=101010111000110000111011001",
  "=101010111000110000111011010",
  "=101010111000110000111011011",
  "=101010111000110000111011100",
  "=101010111000110000111011101",
  "=101010111000110000111011110",
  "=101010111000110000111011111",
  "=101010111000110000111100000",
  "=101010111000110000111100001",
  "=101010111000110000111100010",
  "=101010111000110000111100011",
  "=101010111000110000111100100",
  "=101010111000110000111100101",
  "=101010111000110000111100110",
  "=101010111000110000111100111",
  "=101010111000110000111101000",
  "=101010111000110000111101001",
  "=101010111000110000111101010",
  "=101010111000110000111101011",
  "=101010111000110000111101100",
  "=101010111000110000111101101",
  "=101010111000110000111101110",
  "=101010111000110000111101111",
  "=101010111000110000111110000",
  "=101010111000110000111110001",
  "=101010111000110000111110010",
  "=101010111000110000111110011",
  "=101010111000110000111110100",
  "=101010111000110000111110101",
  "(Including =10101011111110",
  "(New Series)=11101000100010",
  "(Part =1110100011101",
  "(Repeat)=1110100110",
  "(Stereo)=010000111",
  "(Stereo) (Teletext)=010000011",
  "(Teletext)=1110001100",
  "(Widescreen)=100000111001110",
  "Action=101010111000111",
  "Adventures=10110011011111",
  "America=0100001100100",
  "Animated=111010100110111",
  "Australia=0100001100101",
  "Away=11101010100010",
  "BBC=10101011111111",
  "Baby=11100011011000",
  "Best=11101010100011",
  "Big=10110011011000",
  "Bill=1000101011111",
  "Black=1000101010000",
  "Blue=1011001101110",
  "Breakfast=000101000110",
  "Britain=1010101111100",
  "British=1110100011100",
  "Business=0100001100110",
  "Call=1010101111101",
  "Cartoon=10101011100000",
  "Channel=10101011100001",
  "Children=11101010100111",
  "Clock=11100011011001",
  "Comedy=11101000100011",
  "Cook=111010101001010",
  "Country=111010100110110",
  "Directed by =101010110100",
  "Drama=0100001100111",
  "East=1000101010001",
  "Education=100000111001111",
  "English=00010100011111",
  "Europe=0001010001110",
  "Extra=10110011011001",
  "Final=10101011100010",
  "Financial=111000110110100",
  "For=111000110111",
  "French=11101000111101",
  "From=1000101010010",
  "George=1010101111110",
  "Get=1000100011010",
  "Girls=10001000110110",
  "Golden=10001000110111",
  "Golf=111010101001011",
  "Good=1010101101010",
  "Great=11101000100100",
  "Hampshire=111010101001100",
  "Headlines=1000101010011",
  "Hear=11101010011010",
  "Hill=1000001110000",
  "Hollywood=111000110110101",
  "Home=1000101010100",
  "Hour=11101000100101",
  "House=1000001110010",
  "How=1010101101011",
  "ITN=11101010100100",
  "Important=111010101001101",
  "Including=1000101011110",
  "International=11101000100110",
  "John=10001000111",
  "Last=11101000100111",
  "Late=10000011100110",
  "Learn=10001010101100",
  "Little=10001010101101",
  "Live=1110100010000",
  "London=11101000111100",
  "Look=10110011011110",
  "Lunch=111000110110110",
  "Man=1000101010101",
  "Mark=1000001110001",
  "Meridian=101010111001",
  "Michael=1011001101101",
  "Minutes=101010111000110000111110110",
  "More=101010111000110000111110111",
  "Morning=101010111000110000111111000",
  "Murder=101010111000110000111111001",
  "Nation=101010111000110000111111010",
  "Neighbours=101010111000110000111111011",
  "New=101010111000110000111111100",
  "News & Weather=101010111000110000111111101",
  "News And Weather=101010111000110000111111110",
  "Paul=101010111000110000111111111",
  "Plus=10101011100011000000000000",
  "Prayer=10101011100011000000000001",
  "Present=10101011100011000000000010",
  "Presented by=10101011100011000000000011",
  "Quiz=10101011100011000000000100",
  "Regional=10101011100011000000000101",
  "Represent=10101011100011000000000110",
  "Resource=10101011100011000000000111",
  "Review=10101011100011000000001000",
  "Richard=10101011100011000000001001",
  "School=10101011100011000000001010",
  "Series=10101011100011000000001011",
  "Service=10101011100011000000001100",
  "Show=10101011100011000000001101",
  "Smith=10101011100011000000001110",
  "South=10101011100011000000001111",
  "Sport=10101011100011000000010000",
  "Star=10101011100011000000010001",
  "Street=10101011100011000000010010",
  "TV=10101011100011000000010011",
  "Teaching=10101011100011000000010100",
  "The=10101011100011000000010101",
  "Today=10101011100011000000010110",
  "Tonight=10101011100011000000010111",
  "Weather=10101011100011000000011000",
  "Western=10101011100011000000011001",
  "Westminster=10101011100011000000011010",
  "William=10101011100011000000011011",
  "With=10101011100011000000011100",
  "World=10101011100011000000011101",
  "about=10101011100011000000011110",
  "action-packed=10101011100011000000011111",
  "adventure=10101011100011000000100000",
  "afternoon=10101011100011000000100001",
  "alert=10101011100011000000100010",
  "all-star cast=10101011100011000000100011",
  "and=10101011100011000000100100",
  "anywhere=10101011100011000000100101",
  "audience=10101011100011000000100110",
  "based=10101011100011000000100111",
  "book=10101011100011000000101000",
  "business=10101011100011000000101001",
  "but=10101011100011000000101010",
  "celebrity=10101011100011000000101011",
  "chance=10101011100011000000101100",
  "chat=10101011100011000000101101",
  "child=10101011100011000000101110",
  "classic=10101011100011000000101111",
  "consumer=10101011100011000000110000",
  "contestants=10101011100011000000110001",
  "continues=10101011100011000000110010",
  "controversial=10101011100011000000110011",
  "dealer=10101011100011000000110100",
  "deliver=10101011100011000000110101",
  "discuss=10101011100011000000110110",
  "document=10101011100011000000110111",
  "drama=10101011100011000000111000",
  "edition=10101011100011000000111001",
  "education=10101011100011000000111010",
  "events=10101011100011000000111011",
  "every=10101011100011000000111100",
  "excellent=10101011100011000000111101",
  "eyed=10101011100011000000111110",
  "family=10101011100011000000111111",
  "famous=10101011100011000001000000",
  "featur=10101011100011000001000001",
  "film=10101011100011000001000010",
  "football=10101011100011000001000011",
  "for=10101011100011000001000100",
  "from=10101011100011000001000101",
  "general knowledge=10101011100011000001000110",
  "get=10101011100011000001000111",
  "guest=10101011100011000001001000",
  "guests=10101011100011000001001001",
  "has=10101011100011000001001010",
  "have=10101011100011000001001011",
  "headline=10101011100011000001001100",
  "her=10101011100011000001001101",
  "his=10101011100011000001001110",
  "home and abroad=10101011100011000001001111",
  "host=10101011100011000001010000",
  "how=10101011100011000001010001",
  "in=10101011100011000001010010",
  "including=10101011100011000001010011",
  "international=10101011100011000001010100",
  "interview=10101011100011000001010101",
  "introduce=10101011100011000001010110",
  "investigat=10101011100011000001010111",
  "invites=10101011100011000001011000",
  "issue=10101011100011000001011001",
  "knowledge=10101011100011000001011010",
  "life=10101011100011000001011011",
  "live=10101011100011000001011100",
  "look=10101011100011000001011101",
  "magazine=10101011100011000001011110",
  "meets =10101011100011000001011111",
  "morning=10101011100011000001100000",
  "morning magazine=10101011100011000001100001",
  "music=10101011100011000001100010",
  "near=10101011100011000001100011",
  "network=10101011100011000001100100",
  "new=10101011100011000001100101",
  "new series=10101011100011000001100110",
  "night=10101011100011000001100111",
  "of=10101011100011000001101000",
  "on=10101011100011000001101001",
  "onight=10101011100011000001101010",
  "out=10101011100011000001101011",
  "over=10101011100011000001101100",
  "part=10101011100011000001101101",
  "people=10101011100011000001101110",
  "phone=10101011100011000001101111",
  "poli=10101011100011000001110000",
  "police=10101011100011000001110001",
  "political chat show=10101011100011000001110010",
  "popular=10101011100011000001110011",
  "presented by =10101011100011000001110100",
  "programm=10101011100011000001110101",
  "quiz=10101011100011000001110110",
  "reconstruction=10101011100011000001110111",
  "report=10101011100011000001111000",
  "review=10101011100011000001111001",
  "school=10101011100011000001111010",
  "series=10101011100011000001111011",
  "short =10101011100011000001111100",
  "show=10101011100011000001111101",
  "some=10101011100011000001111110",
  "starring=10101011100011000001111111",
  "stars=10101011100011000010000000",
  "stories=10101011100011000010000001",
  "story=10101011100011000010000010",
  "studio=10101011100011000010000011",
  "surprise=10101011100011000010000100",
  "teller=10101011100011000010000101",
  "that=10101011100011000010000110",
  "the=10101011100011000010000111",
  "their=10101011100011000010001000",
  "them=10101011100011000010001001",
  "they=10101011100011000010001010",
  "this=10101011100011000010001011",
  "through=10101011100011000010001100",
  "to=10101011100011000010001101",
  "top=10101011100011000010001110",
  "trans=10101011100011000010001111",
  "under=10101011100011000010010000",
  "up=10101011100011000010010001",
  "very=10101011100011000010010010",
  "video=10101011100011000010010011",
  "view=10101011100011000010010100",
  "vintage=10101011100011000010010101",
  "visit=10101011100011000010010110",
  "was=10101011100011000010010111",
  "way=10101011100011000010011000",
  "week=10101011100011000010011001",
  "well=10101011100011000010011010",
  "what=10101011100011000010011011",
  "when=10101011100011000010011100",
  "which=10101011100011000010011101",
  "while=10101011100011000010011110",
  "who=10101011100011000010011111",
  "will=10101011100011000010100000",
  "win=10101011100011000010100001",
  "with=10101011100011000010100010",
  "words=10101011100011000010100011",
  "world=10101011100011000010100100",
  "written=10101011100011000010100101",
  "year=100010001100",
  "you=10110011010",
  NULL
};

static const char *SkyItThemes[] = {
  "Non Definito", // 000 00000
  NULL, // 000 00001
  NULL, // 000 00010
  NULL, // 000 00011
  NULL, // 000 00100
  NULL, // 000 00101
  NULL, // 000 00110
  NULL, // 000 00111
  NULL, // 000 01000
  NULL, // 000 01001
  NULL, // 000 01010
  NULL, // 000 01011
  NULL, // 000 01100
  NULL, // 000 01101
  NULL, // 000 01110
  NULL, // 000 01111
  NULL, // 000 10000
  NULL, // 000 10001
  NULL, // 000 10010
  NULL, // 000 10011
  NULL, // 000 10100
  NULL, // 000 10101
  NULL, // 000 10110
  NULL, // 000 10111
  NULL, // 000 11000
  NULL, // 000 11001
  NULL, // 000 11010
  NULL, // 000 11011
  NULL, // 000 11100
  NULL, // 000 11101
  NULL, // 000 11110
  NULL, // 000 11111
  "Intrattenimento", // 001 00000
  "Intrattenimento - Fiction", // 001 00001
  "Intrattenimento - Sit Com", // 001 00010
  "Intrattenimento - Show", // 001 00011
  "Intrattenimento - Telefilm", // 001 00100
  "Intrattenimento - Soap Opera", // 001 00101
  "Intrattenimento - Telenovela", // 001 00110
  "Intrattenimento - Fantascienza", // 001 00111
  "Intrattenimento - Animazione", // 001 01000
  "Intrattenimento - Giallo", // 001 01001
  "Intrattenimento - Drammatico", // 001 01010
  "Intrattenimento - Romantico", // 001 01011
  "Intrattenimento - Miniserie", // 001 01100
  "Intrattenimento - Spettacolo", // 001 01101
  "Intrattenimento - Quiz", // 001 01110
  "Intrattenimento - Talk Show", // 001 01111
  "Intrattenimento - Variet", // 001 10000
  "Intrattenimento - Festival", // 001 10001
  "Intrattenimento - Teatro", // 001 10010
  "Intrattenimento - Gioco", // 001 10011
  NULL, // 001 10100
  NULL, // 001 10101
  NULL, // 001 10110
  NULL, // 001 10111
  NULL, // 001 11000
  NULL, // 001 11001
  NULL, // 001 11010
  NULL, // 001 11011
  NULL, // 001 11100
  NULL, // 001 11101
  NULL, // 001 11110
  NULL, // 001 11111
  "Sport", // 010 00000
  "Sport - Calcio", // 010 00001
  "Sport - Tennis", // 010 00010
  "Sport - Motori", // 010 00011
  "Sport - Altri", // 010 00100
  "Sport - Baseball", // 010 00101
  "Sport - Ciclismo", // 010 00110
  "Sport - Rugby", // 010 00111
  "Sport - Basket", // 010 01000
  "Sport - Boxe", // 010 01001
  "Sport - Atletica", // 010 01010
  "Sport - Football USA", // 010 01011
  "Sport - Hockey", // 010 01100
  "Sport - Sci", // 010 01101
  "Sport - Equestri", // 010 01110
  "Sport - Golf", // 010 01111
  "Sport - Nuoto", // 010 10000
  "Sport - Wrestling", // 010 10001
  NULL, // 010 10010
  NULL, // 010 10011
  NULL, // 010 10100
  NULL, // 010 10101
  NULL, // 010 10110
  NULL, // 010 10111
  NULL, // 010 11000
  NULL, // 010 11001
  NULL, // 010 11010
  NULL, // 010 11011
  NULL, // 010 11100
  NULL, // 010 11101
  NULL, // 010 11110
  NULL, // 010 11111
  "Film", // 011 00000
  "Film - Drammatico", // 011 00001
  "Film - Commedia", // 011 00010
  "Film - Romantico", // 011 00011
  "Film - Azione", // 011 00100
  "Film - Fantascienza", // 011 00101
  "Film - Western", // 011 00110
  "Film - Comico", // 011 00111
  "Film - Fantastico", // 011 01000
  "Film - Avventura", // 011 01001
  "Film - Poliziesco", // 011 01010
  "Film - Guerra", // 011 01011
  "Film - Horror", // 011 01100
  "Film - Animazione", // 011 01101
  "Film - Thriller", // 011 01110
  "Film - Musicale", // 011 01111
  "Film - Corto", // 011 10000
  "Film - Cortometraggio", // 011 10001
  NULL, // 011 10010
  NULL, // 011 10011
  NULL, // 011 10100
  NULL, // 011 10101
  NULL, // 011 10110
  NULL, // 011 10111
  NULL, // 011 11000
  NULL, // 011 11001
  NULL, // 011 11010
  NULL, // 011 11011
  NULL, // 011 11100
  NULL, // 011 11101
  NULL, // 011 11110
  NULL, // 011 11111
  "Mondo e Tendenze", // 100 00000
  "Mondo e Tendenze - Natura", // 100 00001
  "Mondo e Tendenze - Arte e Cultura", // 100 00010
  "Mondo e Tendenze - Lifestyle", // 100 00011
  "Mondo e Tendenze - Viaggi", // 100 00100
  "Mondo e Tendenze - Documentario", // 100 00101
  "Mondo e Tendenze - Societ", // 100 00110
  "Mondo e Tendenze - Scienza", // 100 00111
  "Mondo e Tendenze - Storia", // 100 01000
  "Mondo e Tendenze - Sport", // 100 01001
  "Mondo e Tendenze - Pesca", // 100 01010
  "Mondo e Tendenze - Popoli", // 100 01011
  "Mondo e Tendenze - Cinema", // 100 01100
  "Mondo e Tendenze - Musica", // 100 01101
  "Mondo e Tendenze - Hobby", // 100 01110
  "Mondo e Tendenze - Caccia", // 100 01111
  "Mondo e Tendenze - Reportage", // 100 10000
  "Mondo e Tendenze - Magazine", // 100 10001
  "Mondo e Tendenze - Magazine Cultura", // 100 10010
  "Mondo e Tendenze - Magazine Scienza", // 100 10011
  "Mondo e Tendenze - Politica", // 100 10100
  "Mondo e Tendenze - Magazine Cinema", // 100 10101
  "Mondo e Tendenze - Magazine Sport", // 100 10110
  "Mondo e Tendenze - Attualit", // 100 10111
  "Mondo e Tendenze - Moda", // 100 11000
  "Mondo e Tendenze - Economia", // 100 11001
  "Mondo e Tendenze - Magazine Caccia e Pesca", // 100 11010
  "Mondo e Tendenze - Magazine Viaggi", // 100 11011
  "Mondo e Tendenze - Magazine Natura", // 100 11100
  "Mondo e Tendenze - Magazine Musica", // 100 11101
  "Mondo e Tendenze - Religione", // 100 11110
  "Mondo e Tendenze - Televendita", // 100 11111
  "Informazione", // 101 00000
  "Informazione - Notiziario", // 101 00001
  "Informazione - Sport", // 101 00010
  "Informazione - Economia", // 101 00011
  NULL, // 101 00100
  NULL, // 101 00101
  NULL, // 101 00110
  NULL, // 101 00111
  NULL, // 101 01000
  NULL, // 101 01001
  NULL, // 101 01010
  NULL, // 101 01011
  NULL, // 101 01100
  NULL, // 101 01101
  NULL, // 101 01110
  NULL, // 101 01111
  NULL, // 101 10000
  NULL, // 101 10001
  NULL, // 101 10010
  NULL, // 101 10011
  NULL, // 101 10100
  NULL, // 101 10101
  NULL, // 101 10110
  NULL, // 101 10111
  NULL, // 101 11000
  NULL, // 101 11001
  NULL, // 101 11010
  NULL, // 101 11011
  NULL, // 101 11100
  NULL, // 101 11101
  NULL, // 101 11110
  NULL, // 101 11111
  "Ragazzi e Musica", // 110 00000
  "Ragazzi e Musica - Bambini", // 110 00001
  "Ragazzi e Musica - Ragazzi", // 110 00010
  "Ragazzi e Musica - Cartoni Animati", // 110 00011
  "Ragazzi e Musica - Musica", // 110 00100
  "Ragazzi e Musica - Film Animazione", // 110 00101
  "Ragazzi e Musica - Film", // 110 00110
  "Ragazzi e Musica - Telefilm", // 110 00111
  "Ragazzi e Musica - Magazine", // 110 01000
  NULL, // 110 01001
  NULL, // 110 01010
  NULL, // 110 01011
  NULL, // 110 01100
  NULL, // 110 01101
  NULL, // 110 01110
  NULL, // 110 01111
  NULL, // 110 10000
  NULL, // 110 10001
  NULL, // 110 10010
  NULL, // 110 10011
  "Ragazzi e Musica - Danza", // 110 10100
  NULL, // 110 10101
  NULL, // 110 10110
  NULL, // 110 10111
  NULL, // 110 11000
  NULL, // 110 11001
  NULL, // 110 11010
  NULL, // 110 11011
  NULL, // 110 11100
  NULL, // 110 11101
  NULL, // 110 11110
  NULL, // 110 11111
  "Altri Programmi", // 111 00000
  "Altri Programmi - Educational", // 111 00001
  "Altri Programmi - Regionale", // 111 00010
  "Altri Programmi - Shopping", // 111 00011
  NULL, // 111 00100
  "Altri Programmi - Inizio e Fine Trasmissioni", // 111 00101
  "Altri Programmi - Eventi Speciali", // 111 00110
  "Altri Programmi - Film per Adulti", // 111 00111
  NULL, // 111 01000
  NULL, // 111 01001
  NULL, // 111 01010
  NULL, // 111 01011
  NULL, // 111 01100
  NULL, // 111 01101
  NULL, // 111 01110
  NULL, // 111 01111
  NULL, // 111 10000
  NULL, // 111 10001
  NULL, // 111 10010
  NULL, // 111 10011
  NULL, // 111 10100
  NULL, // 111 10101
  NULL, // 111 10110
  NULL, // 111 10111
  NULL, // 111 11000
  NULL, // 111 11001
  NULL, // 111 11010
  NULL, // 111 11011
  NULL, // 111 11100
  NULL, // 111 11101
  NULL, // 111 11110
  NULL, // 111 11111
};

static const char *SkyUkThemes[] = {
  "No Category", // 000 00000
  NULL, // 000 00001
  NULL, // 000 00010
  NULL, // 000 00011
  NULL, // 000 00100
  NULL, // 000 00101
  NULL, // 000 00110
  NULL, // 000 00111
  NULL, // 000 01000
  NULL, // 000 01001
  NULL, // 000 01010
  NULL, // 000 01011
  NULL, // 000 01100
  NULL, // 000 01101
  NULL, // 000 01110
  NULL, // 000 01111
  NULL, // 000 10000
  NULL, // 000 10001
  NULL, // 000 10010
  NULL, // 000 10011
  NULL, // 000 10100
  NULL, // 000 10101
  NULL, // 000 10110
  NULL, // 000 10111
  NULL, // 000 11000
  NULL, // 000 11001
  NULL, // 000 11010
  NULL, // 000 11011
  NULL, // 000 11100
  NULL, // 000 11101
  NULL, // 000 11110
  NULL, // 000 11111
  NULL, // 001 00000
  NULL, // 001 00001
  NULL, // 001 00010
  "Shopping", // 001 00011
  NULL, // 001 00100
  NULL, // 001 00101
  NULL, // 001 00110
  NULL, // 001 00111
  NULL, // 001 01000
  NULL, // 001 01001
  NULL, // 001 01010
  NULL, // 001 01011
  NULL, // 001 01100
  NULL, // 001 01101
  NULL, // 001 01110
  NULL, // 001 01111
  NULL, // 001 10000
  NULL, // 001 10001
  NULL, // 001 10010
  NULL, // 001 10011
  NULL, // 001 10100
  NULL, // 001 10101
  NULL, // 001 10110
  NULL, // 001 10111
  NULL, // 001 11000
  NULL, // 001 11001
  NULL, // 001 11010
  NULL, // 001 11011
  NULL, // 001 11100
  NULL, // 001 11101
  NULL, // 001 11110
  NULL, // 001 11111
  "Children", // 010 00000
  "Children - Cartoons", // 010 00001
  "Children - Comedy", // 010 00010
  "Children - Drama", // 010 00011
  "Children - Educational", // 010 00100
  "Children - Under 5", // 010 00101
  "Children - Factual", // 010 00110
  "Children - Magazine", // 010 00111
  NULL, // 010 01000
  NULL, // 010 01001
  NULL, // 010 01010
  NULL, // 010 01011
  NULL, // 010 01100
  NULL, // 010 01101
  NULL, // 010 01110
  NULL, // 010 01111
  NULL, // 010 10000
  NULL, // 010 10001
  NULL, // 010 10010
  NULL, // 010 10011
  NULL, // 010 10100
  NULL, // 010 10101
  NULL, // 010 10110
  NULL, // 010 10111
  NULL, // 010 11000
  NULL, // 010 11001
  NULL, // 010 11010
  NULL, // 010 11011
  NULL, // 010 11100
  NULL, // 010 11101
  NULL, // 010 11110
  NULL, // 010 11111
  "Entertainment", // 011 00000
  "Entertainment - Action", // 011 00001
  "Entertainment - Comedy", // 011 00010
  "Entertainment - Detective", // 011 00011
  "Entertainment - Drama", // 011 00100
  "Entertainment - Game Show", // 011 00101
  "Entertainment - Sci-FI", // 011 00110
  "Entertainment - Soap", // 011 00111
  "Entertainment - Animation", // 011 01000
  "Entertainment - Chat Show", // 011 01001
  "Entertainment - Cooking", // 011 01010
  "Entertainment - Factual", // 011 01011
  "Entertainment - Fashion", // 011 01100
  "Entertainment - Gardening", // 011 01101
  "Entertainment - Travel", // 011 01110
  "Entertainment - Technology", // 011 01111
  "Entertainment - Arts", // 011 10000
  "Entertainment - Lifestyle", // 011 10001
  "Entertainment - Home", // 011 10010
  "Entertainment - Magazine", // 011 10011
  "Entertainment - Medical", // 011 10100
  "Entertainment - Review", // 011 10101
  "Entertainment - Antiques", // 011 10110
  "Entertainment - Motors", // 011 10111
  "Entertainment - Art&Lit", // 011 11000
  "Entertainment - Ballet", // 011 11001
  "Entertainment - Opera", // 011 11010
  NULL, // 011 11011
  NULL, // 011 11100
  NULL, // 011 11101
  NULL, // 011 11110
  NULL, // 011 11111
  "Music", // 100 00000
  "Music - Classical ", // 100 00001
  "Music - Folk and Country", // 100 00010
  "Music - National Music", // 100 00011
  "Music - Jazz", // 100 00100
  "Music - Opera", // 100 00101
  "Music - Rock&Pop", // 100 00110
  "Music - Alternative Music", // 100 00111
  "Music - Events", // 100 01000
  "Music - Club and Dance", // 100 01001
  "Music - Hip Hop", // 100 01010
  "Music - Soul/R&B", // 100 01011
  "Music - Dance", // 100 01100
  NULL, // 100 01101
  NULL, // 100 01110
  NULL, // 100 01111
  "Music - Features", // 100 10000
  NULL, // 100 10001
  NULL, // 100 10010
  NULL, // 100 10011
  NULL, // 100 10100
  "Music - Lifestyle", // 100 10101
  "Music - News and Weather", // 100 10110
  "Music - Easy Listening", // 100 10111
  "Music - Discussion", // 100 11000
  "Music - Entertainment", // 100 11001
  "Music - Religious", // 100 11010
  NULL, // 100 11011
  NULL, // 100 11100
  NULL, // 100 11101
  NULL, // 100 11110
  NULL, // 100 11111
  "News & Documentaries", // 101 00000
  "News & Documentaries - Business", // 101 00001
  "News & Documentaries - World Cultures", // 101 00010
  "News & Documentaries - Adventure", // 101 00011
  "News & Documentaries - Biography", // 101 00100
  "News & Documentaries - Educational", // 101 00101
  "News & Documentaries - Feature", // 101 00110
  "News & Documentaries - Politics", // 101 00111
  "News & Documentaries - News", // 101 01000
  "News & Documentaries - Nature", // 101 01001
  "News & Documentaries - Religious", // 101 01010
  "News & Documentaries - Science", // 101 01011
  "News & Documentaries - Showbiz", // 101 01100
  "News & Documentaries - War Documentary", // 101 01101
  "News & Documentaries - Historical", // 101 01110
  "News & Documentaries - Ancient", // 101 01111
  "News & Documentaries - Transport", // 101 10000
  "News & Documentaries - Docudrama", // 101 10001
  "News & Documentaries - World Affairs", // 101 10010
  NULL, // 101 10011
  NULL, // 101 10100
  NULL, // 101 10101
  NULL, // 101 10110
  NULL, // 101 10111
  NULL, // 101 11000
  NULL, // 101 11001
  NULL, // 101 11010
  NULL, // 101 11011
  NULL, // 101 11100
  NULL, // 101 11101
  NULL, // 101 11110
  NULL, // 101 11111
  "Movie", // 110 00000
  "Movie - Action", // 110 00001
  "Movie - Animation", // 110 00010
  NULL, // 110 00011
  "Movie - Comedy", // 110 00100
  "Movie - Family", // 110 00101
  "Movie - Drama", // 110 00110
  NULL, // 110 00111
  "Movie - Sci-Fi", // 110 01000
  "Movie - Thriller", // 110 01001
  "Movie - Horror", // 110 01010
  "Movie - Romance", // 110 01011
  "Movie - Musical", // 110 01100
  "Movie - Mystery", // 110 01101
  "Movie - Western", // 110 01110
  "Movie - Factual", // 110 01111
  "Movie - Fantasy", // 110 10000
  "Movie - Erotic", // 110 10001
  "Movie - Adventure", // 110 10010
  NULL, // 110 10011
  NULL, // 110 10100
  NULL, // 110 10101
  NULL, // 110 10110
  NULL, // 110 10111
  NULL, // 110 11000
  NULL, // 110 11001
  NULL, // 110 11010
  NULL, // 110 11011
  NULL, // 110 11100
  NULL, // 110 11101
  NULL, // 110 11110
  NULL, // 110 11111
  "Sports - Other", // 111 00000
  "Sports - American Football", // 111 00001
  "Sports - Athletics", // 111 00010
  "Sports - Baseball", // 111 00011
  "Sports - Basketball", // 111 00100
  "Sports - Boxing", // 111 00101
  "Sports - Cricket", // 111 00110
  "Sports - Fishing", // 111 00111
  "Sports - Football", // 111 01000
  "Sports - Golf", // 111 01001
  "Sports - Ice Hockey", // 111 01010
  "Sports - Motor Sport", // 111 01011
  "Sports - Racing", // 111 01100
  "Sports - Rugby", // 111 01101
  "Sports - Equestrian", // 111 01110
  "Sports - Winter Sports", // 111 01111
  "Sports - Snooker / Pool", // 111 10000
  "Sports - Tennis", // 111 10001
  "Sports - Wrestling", // 111 10010
  "Sports - Darts", // 111 10011
  "Sports - Watersports", // 111 10100
  "Sports - Extreme", // 111 10101
  NULL, // 111 10110
  NULL, // 111 10111
  NULL, // 111 11000
  NULL, // 111 11001
  NULL, // 111 11010
  NULL, // 111 11011
  NULL, // 111 11100
  NULL, // 111 11101
  NULL, // 111 11110
  NULL, // 111 11111
};

// MediaHighWay Ver. 1

typedef struct
{
  u_char Name                   [15];
} sThemeMHW1;

typedef struct
{
  u_char NetworkIdHigh            :8;
  u_char NetworkIdLow             :8;
  u_char TransportIdHigh          :8;
  u_char TransportIdLow           :8;
  u_char ServiceIdHigh            :8;
  u_char ServiceIdLow             :8;
  u_char Name                   [16];
} sChannelMHW1;

typedef struct
{
  u_char TableId                  :8;
#if BYTE_ORDER == BIG_ENDIAN
  u_char SectionSyntaxIndicator   :1;
  u_char                          :1;
  u_char                          :2;
  u_char SectionLengthHigh        :4;
#else
  u_char SectionLengthHigh        :4;
  u_char                          :2;
  u_char                          :1;
  u_char SectionSyntaxIndicator   :1;
#endif
  u_char SectionLengthLow         :8;
  u_char ChannelId                :8;
  u_char ThemeId                  :8;
#if BYTE_ORDER == BIG_ENDIAN
  u_char Day                      :3;
  u_char Hours                    :5;
#else
  u_char Hours                    :5;
  u_char Day                      :3;
#endif
#if BYTE_ORDER == BIG_ENDIAN
  u_char Minutes                  :6;
  u_char                          :1;
  u_char SummaryAvailable         :1;
#else
  u_char SummaryAvailable         :1;
  u_char                          :1;
  u_char Minutes                  :6;
#endif
  u_char                          :8;
  u_char                          :8;
  u_char DurationHigh             :8;
  u_char DurationLow              :8;
  u_char Title                  [23];
  u_char PpvIdHigh                :8;
  u_char PpvIdMediumHigh          :8;
  u_char PpvIdMediumLow           :8;
  u_char PpvIdLow                 :8;
  u_char ProgramIdHigh            :8;
  u_char ProgramIdMediumHigh      :8;
  u_char ProgramIdMediumLow       :8;
  u_char ProgramIdLow             :8;
  u_char                          :8;
  u_char                          :8;
  u_char                          :8;
  u_char                          :8;
} sTitleMHW1;

typedef struct {
  u_char TableId                  :8;
#if BYTE_ORDER == BIG_ENDIAN
  u_char SectionSyntaxIndicator   :1;
  u_char                          :1;
  u_char                          :2;
  u_char SectionLengthHigh        :4;
#else
  u_char SectionLengthHigh        :4;
  u_char                          :2;
  u_char                          :1;
  u_char SectionSyntaxIndicator   :1;
#endif
  u_char SectionLengthLow         :8;
  u_char ProgramIdHigh            :8;
  u_char ProgramIdMediumHigh      :8;
  u_char ProgramIdMediumLow       :8;
  u_char ProgramIdLow             :8;
  u_char Byte7                    :8;
  u_char Byte8                    :8;
  u_char Byte9                    :8;
  u_char NumReplays               :8;
} sSummaryMHW1;


// MediaHighWay Ver. 2

typedef struct
{
  u_char NetworkIdHigh            :8;
  u_char NetworkIdLow             :8;
  u_char TransportIdHigh          :8;
  u_char TransportIdLow           :8;
  u_char ServiceIdHigh            :8;
  u_char ServiceIdLow             :8;
  u_char                          :8;
  u_char                          :8;
} sChannelMHW2;

#define HILO16( x ) ( ( ( x##High << 8 ) | x##Low ) & 0xffff )
#define HILO32( x ) ( ( ( ( ( x##High << 24 ) | ( x##MediumHigh << 16 ) ) | ( x##MediumLow << 8 ) ) | x##Low ) & 0xffffffff )
