// $Id$

// Fish Supper
// Copyright 2006, 2007, 2009, 2010 Matthew Clarke <mafferyew@googlemail.com>
//
// This file is part of Fish Supper.
//
// Fish Supper is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Fish Supper is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Fish Supper.  If not, see <http://www.gnu.org/licenses/>.




#ifndef Settings_screen_h
#define Settings_screen_h




#include "Settings.h"
#include "User_input.h"
#include "FS_gfx.h"
#include <tr1/memory>
#include <vector>




extern std::tr1::shared_ptr<FS::FS_gfx> gfx_ptr;
extern std::tr1::shared_ptr<FS::User_input> input_ptr;




namespace FS
{
    
class Settings_screen
{

    public:
        
        Settings_screen(Settings* sp);
        ~Settings_screen();
        
        void reset();
        void draw();
        // Returns true when user presses [ESC].
        bool update();

    private:
        
        static const int num_options = 2;
        enum { control, sound };
        
        static const int sprite0_x = 93;
        static const int sprite1_x = 236;
        static const int sprite_y_start = 194;    // y-coord for top sprite
        static const int sprite_y_gap = 115;
        static const int tick0_x = 210;
        static const int tick1_x = 252;
        static const int tick_y_offset = 33;
        static const int sprite_texture_start = FS_gfx::JOYSTICK;
        static const float bold = 1.0;
        static const float faded = 0.2;

        Settings* settings_ptr;
        int current_option;
            
        struct Option
        {
            FS_gfx::Image_name sprite0;
            FS_gfx::Image_name sprite1;
            int sprite_y;
            int tick_y;
            bool value;
            bool available;

            void swap_value() 
            { 
                if ( available )
                {
                    value = !value; 
                } // if
            } // swap_value
        }; // struct Option
             
        std::vector<Option> my_options;
        void draw_option(int i);
        void save();
        
}; // class Settings_screen

} // namespace FS




#endif
            
