// $Id$

// Fish Supper
// Copyright 2006, 2007, 2009, 2010 Matthew Clarke <mafferyew@googlemail.com>
//
// This file is part of Fish Supper.
//
// Fish Supper is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Fish Supper is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Fish Supper.  If not, see <http://www.gnu.org/licenses/>.




#ifndef Pause_menu_h
#define Pause_menu_h




#include "User_input.h"
#include "FS_gfx.h"
#include <tr1/memory>




extern std::tr1::shared_ptr<FS::FS_gfx> gfx_ptr;
extern std::tr1::shared_ptr<FS::User_input> input_ptr;




namespace FS
{
    
class Pause_menu
{
    public:
            
        enum Pause_menu_selection { PMS_NONE, PMS_CONTINUE, PMS_QUIT };
    
        Pause_menu();
        ~Pause_menu();
        
        void reset();
        Pause_menu_selection update();
        void draw();
        
        // FIXME: this is a hack - we're just getting PauseMenu to
        // do PlayModel's dirty work for it. When pause type is
        // PAUSE_AUTO (see PlayModel), call this function to see if
        // 'jump' has been pressed (and gobble up any other events).
        bool has_pressed_jump() const;
        
    private:
            
        static const int Menu_x = 295;
        static const int Menu_y = 236;

        Pause_menu_selection current_selection;
        
}; // class Pause_menu
    
} // namespace FS




#endif

