// $Id$

// Fish Supper
// Copyright 2006, 2007, 2009, 2010 Matthew Clarke <mafferyew@googlemail.com>
//
// This file is part of Fish Supper.
//
// Fish Supper is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Fish Supper is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Fish Supper.  If not, see <http://www.gnu.org/licenses/>.




#ifndef Gfx_engine_h
#define Gfx_engine_h

#include <SDL/SDL.h>
#include <SDL/SDL_image.h>
#include <SDL/SDL_opengl.h>
#include <vector>
#include <string>
#include "Useful_gl.h"
#include "Background_image.h"
#include "SFont_gl.h"




namespace Mafferyew
{
    
class Gfx_engine
{
    
    public:
            
        Gfx_engine();
        virtual ~Gfx_engine();

        // N.B. If you only want to fade texture, as long as 'rotate_me' is false,
        // 'rotation' value will be ignored.
        void draw_texture( int id,
                           int x,
                           int y,
                           bool rotate_me = false,
                           float rotation = 0.0,
                           bool fade_me = false,
                           float fade = 1.0 ) const;
                            
        void draw_background(int id) const;
        
        void draw_text(int id,  // id for font
                       int x,   // this value ignored if center is true
                       int y,
                       const std::string& text,
                       bool center = false,
                       int screen_width = 0) const;
        
        void draw_text_faded(int id,
                             int x,
                             int y,
                             const std::string& text,
                             float fade,
                             bool center = false,
                             int screen_width = 0) const;

        int get_text_width(int id, const std::string& text) const;
        int get_text_height(int id) const;

    protected:
    
        // Marks this class as being abstract - i.e. objects of this class
        // can't be instantiated.  Derived classes must provide a definition
        // for this function (- load in all graphics and initialize texture,
        // background and font objects).  Must also provide clean-up code in
        // derived class's destructor.    
        virtual void init() = 0;
            
        struct Texture
        {
            GLuint tex_handle;
            int width;
            int height;
        }; // struct Texture
        
        std::vector<Texture> my_textures;
        std::vector<Background_image*> my_backgrounds;
        std::vector<SFont_gl*> my_fonts;
        
}; // class Gfx_engine

} // namespace Mafferyew




#endif
    
