// $Id$

/*
Copyright (C) 2004 Lion Vollnhals
Copyright (C) 2003 Matthias Braun

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

Note: THIS IS NOT THE ORIGINAL FILE. It was changed by Matthew Clarke in 2005.
*/
#ifndef __LIB_2D_FONT_HPP__
#define __LIB_2D_FONT_HPP__

#include <string>
#include <stdexcept>
#include "SFont.h"
#include <iostream>

/** A thin c++ wrapper around my custom SFont version */
class SFont
{
    private:
        SFont_Font * font;
        bool initialized;
        
    public:
	int getHeight() const
	{ return SFont_TextHeight(font); }

	int getTextWidth(const char* text) const
	{ return SFont_TextWidth(font, text); }
	int getTextWidth(const std::string& text) const
	{ return getTextWidth(text.c_str()); }

	void write(SDL_Surface* surface, const char* text, int x, int y) const
	{ SFont_Write(surface, font, x, y, text); }
	
	void write(SDL_Surface* surface, const std::string& text, int x, int y) const
	{ SFont_Write(surface, font, x, y, text.c_str()); }

        void writeCenter(SDL_Surface * surface, const char * text, int y) const
        {
            SFont_WriteCenter(surface, font, y, text);
        } // writeCenter()
        
        void init(SDL_Surface * surface)
        {
            if (!initialized)
            {
                font = SFont_InitFont(surface);
                if (!font)
                {
                    throw std::runtime_error("Couldn't initialize font.");
                } 
                else
                {
                    initialized = true;
                } // if ... else
            } // if 
            
        } // init()
        
        // constructors
        SFont() 
        {
            initialized = false;
            
        } // SFont()
        
	SFont(SDL_Surface* surface)
        {
            initialized = false;
            font = SFont_InitFont(surface);
            if(!font)
            {
                throw std::runtime_error("Couldn't initialize font.");
            }
            else
            {
                initialized = true;
            }
	}
        
	~SFont()
	{
            if (initialized)
            {
                SFont_FreeFont(font);
            }
        }

};     	

#endif


