
/*************************************************************

  Linux Bandwidth Monitor by Kimmo Nupponen
  $Revision: 1.3 $
  $Date: 2002/05/08 06:36:47 $

  $Log: bwmon.h,v $
  Revision 1.3  2002/05/08 06:36:47  kimmo
  Fixed some bugs with signal handling when handling threads. Previous version suffered
  some problems with linux thread -library.

  Revision 1.2  2001/06/13 17:41:37  nupponen
  Added simply Revision tag to SIGWINCH signal handler

  Revision 1.1  2001/06/13 14:57:53  nupponen
  Initial version of Linux Bandwidth Monitor by Kimmo Nupponen

 *************************************************************/

#ifndef _BWMON_H_
#define _BWMON_H_

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/time.h>
#include <signal.h>
#include <errno.h>
#include <termios.h>
#ifndef TIOSCGWINSZ
#include <sys/ioctl.h>
#endif

/*
 * 2.2 kernel supports only 16 network cards, and since there are not
 * that many 2.4 linuxes running more than 16 interfaces..
 */
#define MAX_INTERFACES 16
#define INTERFACE_NAME 16

#define DEVFILE "/proc/net/dev"
#define UPTIME  "/proc/uptime"

typedef enum { 
    TRUE  = 1, 
    FALSE = 0 
} bool_t;

typedef struct interface {
    char name[16];
    ulong tx_rate_whole, rx_rate_whole, tot_rate_whole;
    ulong tx_bytes_old, rx_bytes_old, tx_bytes_new;
    ulong rx_bytes_new, tx_kbytes_dif, rx_kbytes_dif;
    ulong time_diff_ms;
    unsigned tx_rate_part, rx_rate_part, tot_rate_part;
    struct timeval time_old, time_new;
    float rx_average, tx_average, total_average;
    ulong rx_max_whole, rx_max_part, tx_max_whole, tx_max_part;
} * interface_t;

typedef struct total_interface {
    ulong rx_bw_total_whole, tx_bw_total_whole, tot_bw_total_whole;
    unsigned rx_bw_total_part, tx_bw_total_part, tot_bw_total_part;
} total_interface_t;


void   initialize_total(total_interface_t *);
bool_t do_total(total_interface_t *, interface_t *, int);

bool_t do_interface(char *, interface_t *, int);
bool_t count_average(interface_t *, float *);
ulong bwm_calc_remainder(ulong, ulong);

bool_t print_interface(interface_t *);
bool_t print_ut_ave(interface_t *);
bool_t print_max(interface_t *);
bool_t print_total(char *, total_interface_t *);
bool_t print_uptime(float *);
void  print_help(char *);

#ifdef __THREADS
void * wait_for_exit(void *);
#endif

void  exit_handler(int);
void  sigalrm_handler(int);

void  sigwinch_handler(int);


#ifdef __GNUC__
#define fatal(...)\
{\
    fprintf(stderr, "FATAL ERROR OCCURED: ");\
    fprintf(stderr, __VA_ARGS__);\
    fprintf(stderr, ": %s\n", strerror(errno));\
    exit(-1);\
}

#else /* __GNUC__ */
void
fatal(const char * fmt, ...)
{
    va_list list;

    fprintf(stderr, "FATAL ERROR OCCURED: ");
    va_start(list, fmt);
    vfprintf(stderr, fmt, list);
    va_end(list);
    fprintf(stderr, ": %s\n", strerror(errno));
    exit(-1);
}

#endif /* __GNUC__ */

#endif  /* _BWMON_H_ */
