---
title: How to docfy
order: 1
---

# How to docfy

http://localhost:4200/ui/docs (navigate to directly or click the present icon in the bottom right of the app footer).

## `docs/` markdown files

Side nav links correspond to the file + directory structure within the `docs/` directory. These top-level markdown files **can** be edited directly and any updates should be saved and pushed to main. (Component docs are generated by the `yarn docs` command, see below.)

## generating component docs

The `docs/components` directory is where _generated_ component markdown files are located after running `yarn docs`. **Do not edit component markdown files directly**. Instead, update markdown by making changes to the `jsdoc` and then re-running the generate command. The `docs/components/*` files are included in `.gitignore` so they are not pushed to main. `jsdoc-to-markdown` errors log in the console.

> _If you have never run the `yarn docs` command before, you need to create the `docs/components` directory locally before running `yarn docfy-md` so the markdown has a place to go. `mkdir docs/components`_

```
yarn docfy-md <component name> <addon or engine> <full filepath>
```

> _Note: the above command takes three args, if passing the full filepath for a component then the second arg is unnecessary_

| Command                                                                   | Description                                                                                  |
| ------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- |
| `yarn docs`                                                               | generate markdown file for every\* component in the `addon/core` directory                   |
| `yarn docfy-md some-component-name`                                       | generate markdown file for **specific** component                                            |
| `yarn docfy-md read-more core`                                            | generate markdown for `read-more` component in the `core` addon                              |
| `yarn docfy-md pki-test null ./lib/pki/addon/components/pki-key-usage.ts` | optional third arg is the full component filepath (first arg will become markdown file name) |
| `mkdir docs/components`                                                   | create directory where the generated component markdown files will go                        |
| `rm -f ./docs/components/*`                                               | cleanup and delete generated component markdown files                                        |

> _\*replication and `shamir/*` components are skipped as these are not reused and should eventually be moved outside the `addon/core` directory_

## Writing documentation for a component

Component docs are generated by the script `yarn docs`. Accurate `jsdoc` syntax is important so `jsdoc-to-markdown` properly generates the markdown file for that component. **Do not edit component markdown files directly**.

| jsdoc examples                           |                                                                                                            |                                                               |
| ---------------------------------------- | ---------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------- |
| form-field (`@description` example)      | [github ](https://github.com/hashicorp/vault/blob/main/ui/lib/core/addon/components/form-field.js)         | [vscode ](../lib/core/addon/components/form-field.js)         |
| confirmation-modal                       | [github ](https://github.com/hashicorp/vault/blob/main/ui/lib/core/addon/components/confirmation-modal.js) | [vscode ](../lib/core/addon/components/confirmation-modal.js) |
| certificate-card                         | [github ](https://github.com/hashicorp/vault/blob/main/ui/lib/core/addon/components/certificate-card.js)   | [vscode ](../lib/core/addon/components/certificate-card.js)   |
| alert-inline (`@deprecated` example)     | [github](https://github.com/hashicorp/vault/blob/main/ui/lib/core/addon/components/alert-inline.js)        | [vscode ](../lib/core/addon/components/alert-inline.js)       |
| secret-list-header (code snippet only\*) | [github](https://github.com/hashicorp/vault/blob/main/ui/lib/core/addon/components/secret-list-header.js)  | [vscode ](../lib/core/addon/components/secret-list-header.js) |

> _\*renders a template code snippet and not instantiated component because it relies on too many args that cannot be set up for component instance_

### Syntax tips

Docfy renders an actual instance of the component beneath `@example` as a sample. Make sure the component uses proper hbs syntax and all args are on a single line.

> - Check the generated markdown file for syntax errors or typos. To update the markdown, first edit the jsdoc then re-run the generator. _Do not edit component markdown files directly_
> - Param types: `object`, `string`, `function`, `array`
> - Do not include `null` for empty default values
> - Wrap optional params in brackets `[]`
> - To include a codeblock in your module's description use `@description`

```
❌ multi-line jsdoc will not render a component example
* @example
* <Block
*  @title="Example"
*  @description="My component"
* />
```

```
✅ this will render
* @example
* <Block @title="Example" description="My component" />
```

**Template**

```
/**
 * @module ComponentName
 * @description
 * Description of the component
 *
 * @example
 * <ComponentName @param={{}} optionalParam={{}} />
 *
 * @param {object} paramName - description
 * @param {array} requiredParam=foo - foo is the default value here
 * @param {function} [optionalParamName] - An optional parameter is wrapped in brackets
 * @param {string} [param="some default value"] - An optional parameter with a default value
 */
```

> ### Config
>
> - [docfy-md.js](../scripts/docfy-md.js): script that generates component markdown and passes options to `jsdoc2md` command
> - [generate-docs.sh](../scripts/docfy-md.js): batch command that iterates over desired javascript and typescript file in the `core` addon engine
> - [jsdoc2md.json](../jsdoc2md.json): `jsdoc-to-markdown` config file, necessary so typescript files can be passed to `docfy-md` script

### More info

- [Building and consuming components](./building-components.md)
