use crate::data::caniuse::region::RegionData;
const KEYS: &[&str] = &[
    "AD", "AE", "AF", "AG", "AI", "AL", "AM", "AO", "AR", "AS", "AT", "AU", "AW", "AX", "AZ", "BA",
    "BB", "BD", "BE", "BF", "BG", "BH", "BI", "BJ", "BM", "BN", "BO", "BR", "BS", "BT", "BW", "BY",
    "BZ", "CA", "CD", "CF", "CG", "CH", "CI", "CK", "CL", "CM", "CN", "CO", "CR", "CU", "CV", "CX",
    "CY", "CZ", "DE", "DJ", "DK", "DM", "DO", "DZ", "EC", "EE", "EG", "ER", "ES", "ET", "FI", "FJ",
    "FK", "FM", "FO", "FR", "GA", "GB", "GD", "GE", "GF", "GG", "GH", "GI", "GL", "GM", "GN", "GP",
    "GQ", "GR", "GT", "GU", "GW", "GY", "HK", "HN", "HR", "HT", "HU", "ID", "IE", "IL", "IM", "IN",
    "IQ", "IR", "IS", "IT", "JE", "JM", "JO", "JP", "KE", "KG", "KH", "KI", "KM", "KN", "KP", "KR",
    "KW", "KY", "KZ", "LA", "LB", "LC", "LI", "LK", "LR", "LS", "LT", "LU", "LV", "LY", "MA", "MC",
    "MD", "ME", "MG", "MH", "MK", "ML", "MM", "MN", "MO", "MP", "MQ", "MR", "MS", "MT", "MU", "MV",
    "MW", "MX", "MY", "MZ", "NA", "NC", "NE", "NF", "NG", "NI", "NL", "NO", "NP", "NR", "NU", "NZ",
    "OM", "PA", "PE", "PF", "PG", "PH", "PK", "PL", "PM", "PN", "PR", "PS", "PT", "PW", "PY", "QA",
    "RE", "RO", "RS", "RU", "RW", "SA", "SB", "SC", "SD", "SE", "SG", "SH", "SI", "SK", "SL", "SM",
    "SN", "SO", "SR", "ST", "SV", "SY", "SZ", "TC", "TD", "TG", "TH", "TJ", "TL", "TM", "TN", "TO",
    "TR", "TT", "TV", "TW", "TZ", "UA", "UG", "US", "UY", "UZ", "VA", "VC", "VE", "VG", "VI", "VN",
    "VU", "WF", "WS", "YE", "YT", "ZA", "ZM", "ZW", "alt-af", "alt-an", "alt-as", "alt-eu",
    "alt-na", "alt-oc", "alt-sa", "alt-ww",
];
const BROWSER_RANGES: &[u32] = &[
    0u32, 185u32, 419u32, 699u32, 897u32, 1058u32, 1300u32, 1498u32, 1781u32, 2028u32, 2143u32,
    2382u32, 2640u32, 2849u32, 2996u32, 3266u32, 3507u32, 3725u32, 3964u32, 4189u32, 4439u32,
    4679u32, 4898u32, 5128u32, 5410u32, 5513u32, 5728u32, 5974u32, 6198u32, 6368u32, 6577u32,
    6840u32, 7100u32, 7310u32, 7580u32, 7880u32, 8025u32, 8277u32, 8489u32, 8751u32, 8885u32,
    9121u32, 9438u32, 9704u32, 9928u32, 10171u32, 10514u32, 10725u32, 10788u32, 11004u32, 11248u32,
    11542u32, 11736u32, 11931u32, 12126u32, 12386u32, 12670u32, 12909u32, 13090u32, 13368u32,
    13500u32, 13755u32, 14057u32, 14276u32, 14497u32, 14595u32, 14737u32, 14920u32, 15209u32,
    15448u32, 15704u32, 15890u32, 16149u32, 16369u32, 16527u32, 16822u32, 16984u32, 17139u32,
    17389u32, 17671u32, 17900u32, 18099u32, 18331u32, 18568u32, 18759u32, 18939u32, 19161u32,
    19393u32, 19649u32, 19885u32, 20150u32, 20379u32, 20607u32, 20821u32, 21080u32, 21263u32,
    21487u32, 21702u32, 21967u32, 22170u32, 22445u32, 22622u32, 22868u32, 23107u32, 23370u32,
    23632u32, 23838u32, 24058u32, 24179u32, 24343u32, 24569u32, 24640u32, 24837u32, 25067u32,
    25279u32, 25519u32, 25739u32, 25984u32, 26193u32, 26380u32, 26561u32, 26811u32, 27035u32,
    27285u32, 27517u32, 27779u32, 28039u32, 28336u32, 28529u32, 28764u32, 28979u32, 29259u32,
    29380u32, 29617u32, 29875u32, 30139u32, 30379u32, 30590u32, 30747u32, 30948u32, 31185u32,
    31284u32, 31496u32, 31752u32, 31942u32, 32210u32, 32479u32, 32708u32, 32991u32, 33239u32,
    33440u32, 33691u32, 33762u32, 34029u32, 34273u32, 34518u32, 34732u32, 34937u32, 35029u32,
    35092u32, 35336u32, 35569u32, 35813u32, 36049u32, 36233u32, 36468u32, 36694u32, 36946u32,
    37191u32, 37299u32, 37362u32, 37590u32, 37813u32, 38045u32, 38158u32, 38389u32, 38610u32,
    38822u32, 39028u32, 39320u32, 39630u32, 39877u32, 40115u32, 40295u32, 40594u32, 40822u32,
    41038u32, 41293u32, 41366u32, 41590u32, 41822u32, 42091u32, 42228u32, 42468u32, 42706u32,
    42908u32, 43050u32, 43310u32, 43573u32, 43808u32, 43983u32, 44206u32, 44478u32, 44724u32,
    44968u32, 45230u32, 45367u32, 45646u32, 45781u32, 46063u32, 46303u32, 46383u32, 46624u32,
    46894u32, 47170u32, 47457u32, 47755u32, 47987u32, 48215u32, 48299u32, 48488u32, 48761u32,
    48951u32, 49143u32, 49341u32, 49496u32, 49588u32, 49746u32, 49948u32, 50125u32, 50379u32,
    50619u32, 50909u32, 51178u32, 51284u32, 51529u32, 51787u32, 52032u32, 52258u32, 52451u32,
    52702u32,
];
const VERSION_RANGES: &[u32] = &[
    0u32, 894u32, 1951u32, 3184u32, 4107u32, 4892u32, 5984u32, 6900u32, 8125u32, 9217u32, 9859u32,
    10959u32, 12116u32, 13083u32, 13817u32, 14987u32, 16075u32, 17061u32, 18112u32, 19158u32,
    20253u32, 21348u32, 22339u32, 23377u32, 24605u32, 25200u32, 26180u32, 27268u32, 28259u32,
    29098u32, 30051u32, 31211u32, 32346u32, 33310u32, 34495u32, 35771u32, 36491u32, 37593u32,
    38597u32, 39737u32, 40431u32, 41493u32, 42848u32, 44024u32, 45051u32, 46128u32, 47568u32,
    48538u32, 48937u32, 49935u32, 51030u32, 52318u32, 53220u32, 54153u32, 55068u32, 56199u32,
    57414u32, 58470u32, 59350u32, 60555u32, 61212u32, 62350u32, 63614u32, 64631u32, 65644u32,
    66192u32, 66908u32, 67785u32, 69046u32, 70099u32, 71240u32, 72116u32, 73283u32, 74280u32,
    75076u32, 76353u32, 77145u32, 77919u32, 79012u32, 80224u32, 81258u32, 82166u32, 83218u32,
    84286u32, 85192u32, 86029u32, 87039u32, 88092u32, 89220u32, 90295u32, 91472u32, 92514u32,
    93564u32, 94555u32, 95710u32, 96579u32, 97585u32, 98576u32, 99755u32, 100720u32, 101924u32,
    102777u32, 103869u32, 104928u32, 106108u32, 107255u32, 108213u32, 109232u32, 109867u32,
    110671u32, 111676u32, 112104u32, 113042u32, 114107u32, 115082u32, 116160u32, 117165u32,
    118270u32, 119222u32, 120109u32, 120994u32, 122103u32, 123111u32, 124233u32, 125311u32,
    126455u32, 127600u32, 128895u32, 129793u32, 130841u32, 131849u32, 133059u32, 133697u32,
    134766u32, 135883u32, 137042u32, 138119u32, 139115u32, 139887u32, 140830u32, 141879u32,
    142424u32, 143413u32, 144553u32, 145449u32, 146611u32, 147782u32, 148828u32, 150052u32,
    151162u32, 152107u32, 153191u32, 153628u32, 154799u32, 155876u32, 156970u32, 157967u32,
    158919u32, 159437u32, 159837u32, 160937u32, 162002u32, 163077u32, 164138u32, 165021u32,
    166093u32, 167126u32, 168220u32, 169314u32, 169915u32, 170314u32, 171351u32, 172384u32,
    173447u32, 174065u32, 175068u32, 176087u32, 177073u32, 178044u32, 179313u32, 180620u32,
    181717u32, 182791u32, 183654u32, 184965u32, 185970u32, 186986u32, 188121u32, 188559u32,
    189591u32, 190661u32, 191838u32, 192534u32, 193603u32, 194681u32, 195608u32, 196306u32,
    197452u32, 198613u32, 199670u32, 200508u32, 201504u32, 202669u32, 203774u32, 204868u32,
    206026u32, 206715u32, 207929u32, 208626u32, 209846u32, 210913u32, 211386u32, 212490u32,
    213668u32, 214857u32, 216105u32, 217385u32, 218420u32, 219453u32, 219942u32, 220817u32,
    221995u32, 222881u32, 223780u32, 224715u32, 225479u32, 226012u32, 226797u32, 227730u32,
    228567u32, 229706u32, 230769u32, 232009u32, 233182u32, 233782u32, 234874u32, 236014u32,
    237107u32, 238144u32, 239030u32, 240149u32,
];
const PERCENT_RANGES: &[u32] = &[
    0u32, 741u32, 1678u32, 2801u32, 3594u32, 4239u32, 5208u32, 6001u32, 7136u32, 8125u32, 8586u32,
    9543u32, 10578u32, 11415u32, 12004u32, 13087u32, 14052u32, 14925u32, 15882u32, 16783u32,
    17784u32, 18745u32, 19622u32, 20543u32, 21674u32, 22087u32, 22948u32, 23933u32, 24830u32,
    25511u32, 26348u32, 27403u32, 28446u32, 29287u32, 30370u32, 31573u32, 32154u32, 33165u32,
    34014u32, 35065u32, 35602u32, 36547u32, 37818u32, 38885u32, 39782u32, 40755u32, 42130u32,
    42975u32, 43228u32, 44093u32, 45070u32, 46249u32, 47026u32, 47807u32, 48588u32, 49631u32,
    50770u32, 51727u32, 52452u32, 53567u32, 54096u32, 55119u32, 56330u32, 57207u32, 58092u32,
    58485u32, 59054u32, 59787u32, 60946u32, 61903u32, 62930u32, 63675u32, 64714u32, 65595u32,
    66228u32, 67411u32, 68060u32, 68681u32, 69682u32, 70813u32, 71730u32, 72527u32, 73456u32,
    74405u32, 75170u32, 75891u32, 76780u32, 77709u32, 78736u32, 79681u32, 80744u32, 81661u32,
    82574u32, 83431u32, 84470u32, 85203u32, 86100u32, 86961u32, 88024u32, 88837u32, 89940u32,
    90649u32, 91634u32, 92591u32, 93646u32, 94697u32, 95522u32, 96403u32, 96888u32, 97545u32,
    98450u32, 98735u32, 99524u32, 100445u32, 101294u32, 102255u32, 103136u32, 104117u32, 104954u32,
    105703u32, 106428u32, 107429u32, 108326u32, 109327u32, 110256u32, 111307u32, 112350u32,
    113541u32, 114314u32, 115255u32, 116116u32, 117239u32, 117724u32, 118673u32, 119708u32,
    120767u32, 121728u32, 122573u32, 123202u32, 124007u32, 124956u32, 125353u32, 126202u32,
    127229u32, 127990u32, 129065u32, 130144u32, 131061u32, 132196u32, 133189u32, 133994u32,
    135001u32, 135286u32, 136357u32, 137334u32, 138315u32, 139172u32, 139993u32, 140362u32,
    140615u32, 141592u32, 142525u32, 143502u32, 144447u32, 145184u32, 146125u32, 147030u32,
    148041u32, 149022u32, 149455u32, 149708u32, 150621u32, 151514u32, 152443u32, 152896u32,
    153821u32, 154706u32, 155555u32, 156380u32, 157551u32, 158794u32, 159783u32, 160736u32,
    161457u32, 162656u32, 163569u32, 164434u32, 165457u32, 165750u32, 166647u32, 167576u32,
    168655u32, 169204u32, 170165u32, 171118u32, 171927u32, 172496u32, 173539u32, 174594u32,
    175535u32, 176236u32, 177129u32, 178220u32, 179205u32, 180182u32, 181233u32, 181782u32,
    182901u32, 183442u32, 184573u32, 185534u32, 185855u32, 186820u32, 187903u32, 189010u32,
    190161u32, 191356u32, 192285u32, 193198u32, 193535u32, 194292u32, 195387u32, 196148u32,
    196917u32, 197710u32, 198331u32, 198700u32, 199333u32, 200142u32, 200851u32, 201870u32,
    202831u32, 203994u32, 205073u32, 205498u32, 206479u32, 207514u32, 208495u32, 209400u32,
    210173u32, 211180u32,
];
pub fn get_usage_by_region(region: &str) -> Option<RegionData> {
    let index = KEYS.binary_search(&region).ok()?;
    let browser_start = BROWSER_RANGES[index];
    let browser_end = BROWSER_RANGES[index + 1];
    let version_start = VERSION_RANGES[index];
    let version_end = VERSION_RANGES[index + 1];
    let percent_start = PERCENT_RANGES[index];
    let percent_end = PERCENT_RANGES[index + 1];
    Some(RegionData::new(
        browser_start,
        browser_end,
        version_start,
        version_end,
        percent_start,
        percent_end,
    ))
}
