// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package log_target

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// DeleteLogTargetBackendAcceptedCode is the HTTP code returned for type DeleteLogTargetBackendAccepted
const DeleteLogTargetBackendAcceptedCode int = 202

/*
DeleteLogTargetBackendAccepted Configuration change accepted and reload requested

swagger:response deleteLogTargetBackendAccepted
*/
type DeleteLogTargetBackendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`
}

// NewDeleteLogTargetBackendAccepted creates DeleteLogTargetBackendAccepted with default headers values
func NewDeleteLogTargetBackendAccepted() *DeleteLogTargetBackendAccepted {

	return &DeleteLogTargetBackendAccepted{}
}

// WithReloadID adds the reloadId to the delete log target backend accepted response
func (o *DeleteLogTargetBackendAccepted) WithReloadID(reloadID string) *DeleteLogTargetBackendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the delete log target backend accepted response
func (o *DeleteLogTargetBackendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WriteResponse to the client
func (o *DeleteLogTargetBackendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(202)
}

// DeleteLogTargetBackendNoContentCode is the HTTP code returned for type DeleteLogTargetBackendNoContent
const DeleteLogTargetBackendNoContentCode int = 204

/*
DeleteLogTargetBackendNoContent Log Target deleted

swagger:response deleteLogTargetBackendNoContent
*/
type DeleteLogTargetBackendNoContent struct {
}

// NewDeleteLogTargetBackendNoContent creates DeleteLogTargetBackendNoContent with default headers values
func NewDeleteLogTargetBackendNoContent() *DeleteLogTargetBackendNoContent {

	return &DeleteLogTargetBackendNoContent{}
}

// WriteResponse to the client
func (o *DeleteLogTargetBackendNoContent) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(204)
}

// DeleteLogTargetBackendNotFoundCode is the HTTP code returned for type DeleteLogTargetBackendNotFound
const DeleteLogTargetBackendNotFoundCode int = 404

/*
DeleteLogTargetBackendNotFound The specified resource was not found

swagger:response deleteLogTargetBackendNotFound
*/
type DeleteLogTargetBackendNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteLogTargetBackendNotFound creates DeleteLogTargetBackendNotFound with default headers values
func NewDeleteLogTargetBackendNotFound() *DeleteLogTargetBackendNotFound {

	return &DeleteLogTargetBackendNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the delete log target backend not found response
func (o *DeleteLogTargetBackendNotFound) WithConfigurationVersion(configurationVersion string) *DeleteLogTargetBackendNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete log target backend not found response
func (o *DeleteLogTargetBackendNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete log target backend not found response
func (o *DeleteLogTargetBackendNotFound) WithPayload(payload *models.Error) *DeleteLogTargetBackendNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete log target backend not found response
func (o *DeleteLogTargetBackendNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteLogTargetBackendNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
DeleteLogTargetBackendDefault General Error

swagger:response deleteLogTargetBackendDefault
*/
type DeleteLogTargetBackendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteLogTargetBackendDefault creates DeleteLogTargetBackendDefault with default headers values
func NewDeleteLogTargetBackendDefault(code int) *DeleteLogTargetBackendDefault {
	if code <= 0 {
		code = 500
	}

	return &DeleteLogTargetBackendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the delete log target backend default response
func (o *DeleteLogTargetBackendDefault) WithStatusCode(code int) *DeleteLogTargetBackendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the delete log target backend default response
func (o *DeleteLogTargetBackendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the delete log target backend default response
func (o *DeleteLogTargetBackendDefault) WithConfigurationVersion(configurationVersion string) *DeleteLogTargetBackendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete log target backend default response
func (o *DeleteLogTargetBackendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete log target backend default response
func (o *DeleteLogTargetBackendDefault) WithPayload(payload *models.Error) *DeleteLogTargetBackendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete log target backend default response
func (o *DeleteLogTargetBackendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteLogTargetBackendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
