// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package http_errors

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// CreateHTTPErrorsSectionCreatedCode is the HTTP code returned for type CreateHTTPErrorsSectionCreated
const CreateHTTPErrorsSectionCreatedCode int = 201

/*
CreateHTTPErrorsSectionCreated http-error section created

swagger:response createHttpErrorsSectionCreated
*/
type CreateHTTPErrorsSectionCreated struct {

	/*
	  In: Body
	*/
	Payload *models.HTTPErrorsSection `json:"body,omitempty"`
}

// NewCreateHTTPErrorsSectionCreated creates CreateHTTPErrorsSectionCreated with default headers values
func NewCreateHTTPErrorsSectionCreated() *CreateHTTPErrorsSectionCreated {

	return &CreateHTTPErrorsSectionCreated{}
}

// WithPayload adds the payload to the create Http errors section created response
func (o *CreateHTTPErrorsSectionCreated) WithPayload(payload *models.HTTPErrorsSection) *CreateHTTPErrorsSectionCreated {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Http errors section created response
func (o *CreateHTTPErrorsSectionCreated) SetPayload(payload *models.HTTPErrorsSection) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateHTTPErrorsSectionCreated) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(201)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateHTTPErrorsSectionAcceptedCode is the HTTP code returned for type CreateHTTPErrorsSectionAccepted
const CreateHTTPErrorsSectionAcceptedCode int = 202

/*
CreateHTTPErrorsSectionAccepted Configuration change accepted and reload requested

swagger:response createHttpErrorsSectionAccepted
*/
type CreateHTTPErrorsSectionAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.HTTPErrorsSection `json:"body,omitempty"`
}

// NewCreateHTTPErrorsSectionAccepted creates CreateHTTPErrorsSectionAccepted with default headers values
func NewCreateHTTPErrorsSectionAccepted() *CreateHTTPErrorsSectionAccepted {

	return &CreateHTTPErrorsSectionAccepted{}
}

// WithReloadID adds the reloadId to the create Http errors section accepted response
func (o *CreateHTTPErrorsSectionAccepted) WithReloadID(reloadID string) *CreateHTTPErrorsSectionAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the create Http errors section accepted response
func (o *CreateHTTPErrorsSectionAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the create Http errors section accepted response
func (o *CreateHTTPErrorsSectionAccepted) WithPayload(payload *models.HTTPErrorsSection) *CreateHTTPErrorsSectionAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Http errors section accepted response
func (o *CreateHTTPErrorsSectionAccepted) SetPayload(payload *models.HTTPErrorsSection) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateHTTPErrorsSectionAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateHTTPErrorsSectionBadRequestCode is the HTTP code returned for type CreateHTTPErrorsSectionBadRequest
const CreateHTTPErrorsSectionBadRequestCode int = 400

/*
CreateHTTPErrorsSectionBadRequest Bad request

swagger:response createHttpErrorsSectionBadRequest
*/
type CreateHTTPErrorsSectionBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateHTTPErrorsSectionBadRequest creates CreateHTTPErrorsSectionBadRequest with default headers values
func NewCreateHTTPErrorsSectionBadRequest() *CreateHTTPErrorsSectionBadRequest {

	return &CreateHTTPErrorsSectionBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the create Http errors section bad request response
func (o *CreateHTTPErrorsSectionBadRequest) WithConfigurationVersion(configurationVersion string) *CreateHTTPErrorsSectionBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create Http errors section bad request response
func (o *CreateHTTPErrorsSectionBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create Http errors section bad request response
func (o *CreateHTTPErrorsSectionBadRequest) WithPayload(payload *models.Error) *CreateHTTPErrorsSectionBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Http errors section bad request response
func (o *CreateHTTPErrorsSectionBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateHTTPErrorsSectionBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateHTTPErrorsSectionConflictCode is the HTTP code returned for type CreateHTTPErrorsSectionConflict
const CreateHTTPErrorsSectionConflictCode int = 409

/*
CreateHTTPErrorsSectionConflict The specified resource already exists

swagger:response createHttpErrorsSectionConflict
*/
type CreateHTTPErrorsSectionConflict struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateHTTPErrorsSectionConflict creates CreateHTTPErrorsSectionConflict with default headers values
func NewCreateHTTPErrorsSectionConflict() *CreateHTTPErrorsSectionConflict {

	return &CreateHTTPErrorsSectionConflict{}
}

// WithConfigurationVersion adds the configurationVersion to the create Http errors section conflict response
func (o *CreateHTTPErrorsSectionConflict) WithConfigurationVersion(configurationVersion string) *CreateHTTPErrorsSectionConflict {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create Http errors section conflict response
func (o *CreateHTTPErrorsSectionConflict) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create Http errors section conflict response
func (o *CreateHTTPErrorsSectionConflict) WithPayload(payload *models.Error) *CreateHTTPErrorsSectionConflict {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Http errors section conflict response
func (o *CreateHTTPErrorsSectionConflict) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateHTTPErrorsSectionConflict) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(409)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
CreateHTTPErrorsSectionDefault General Error

swagger:response createHttpErrorsSectionDefault
*/
type CreateHTTPErrorsSectionDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateHTTPErrorsSectionDefault creates CreateHTTPErrorsSectionDefault with default headers values
func NewCreateHTTPErrorsSectionDefault(code int) *CreateHTTPErrorsSectionDefault {
	if code <= 0 {
		code = 500
	}

	return &CreateHTTPErrorsSectionDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the create HTTP errors section default response
func (o *CreateHTTPErrorsSectionDefault) WithStatusCode(code int) *CreateHTTPErrorsSectionDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the create HTTP errors section default response
func (o *CreateHTTPErrorsSectionDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the create HTTP errors section default response
func (o *CreateHTTPErrorsSectionDefault) WithConfigurationVersion(configurationVersion string) *CreateHTTPErrorsSectionDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create HTTP errors section default response
func (o *CreateHTTPErrorsSectionDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create HTTP errors section default response
func (o *CreateHTTPErrorsSectionDefault) WithPayload(payload *models.Error) *CreateHTTPErrorsSectionDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create HTTP errors section default response
func (o *CreateHTTPErrorsSectionDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateHTTPErrorsSectionDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
