// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package http_error_rule

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetHTTPErrorRuleDefaultsOKCode is the HTTP code returned for type GetHTTPErrorRuleDefaultsOK
const GetHTTPErrorRuleDefaultsOKCode int = 200

/*
GetHTTPErrorRuleDefaultsOK Successful operation

swagger:response getHttpErrorRuleDefaultsOK
*/
type GetHTTPErrorRuleDefaultsOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.HTTPErrorRule `json:"body,omitempty"`
}

// NewGetHTTPErrorRuleDefaultsOK creates GetHTTPErrorRuleDefaultsOK with default headers values
func NewGetHTTPErrorRuleDefaultsOK() *GetHTTPErrorRuleDefaultsOK {

	return &GetHTTPErrorRuleDefaultsOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get Http error rule defaults o k response
func (o *GetHTTPErrorRuleDefaultsOK) WithConfigurationVersion(configurationVersion string) *GetHTTPErrorRuleDefaultsOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get Http error rule defaults o k response
func (o *GetHTTPErrorRuleDefaultsOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get Http error rule defaults o k response
func (o *GetHTTPErrorRuleDefaultsOK) WithPayload(payload *models.HTTPErrorRule) *GetHTTPErrorRuleDefaultsOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get Http error rule defaults o k response
func (o *GetHTTPErrorRuleDefaultsOK) SetPayload(payload *models.HTTPErrorRule) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetHTTPErrorRuleDefaultsOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetHTTPErrorRuleDefaultsNotFoundCode is the HTTP code returned for type GetHTTPErrorRuleDefaultsNotFound
const GetHTTPErrorRuleDefaultsNotFoundCode int = 404

/*
GetHTTPErrorRuleDefaultsNotFound The specified resource was not found

swagger:response getHttpErrorRuleDefaultsNotFound
*/
type GetHTTPErrorRuleDefaultsNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetHTTPErrorRuleDefaultsNotFound creates GetHTTPErrorRuleDefaultsNotFound with default headers values
func NewGetHTTPErrorRuleDefaultsNotFound() *GetHTTPErrorRuleDefaultsNotFound {

	return &GetHTTPErrorRuleDefaultsNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the get Http error rule defaults not found response
func (o *GetHTTPErrorRuleDefaultsNotFound) WithConfigurationVersion(configurationVersion string) *GetHTTPErrorRuleDefaultsNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get Http error rule defaults not found response
func (o *GetHTTPErrorRuleDefaultsNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get Http error rule defaults not found response
func (o *GetHTTPErrorRuleDefaultsNotFound) WithPayload(payload *models.Error) *GetHTTPErrorRuleDefaultsNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get Http error rule defaults not found response
func (o *GetHTTPErrorRuleDefaultsNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetHTTPErrorRuleDefaultsNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
GetHTTPErrorRuleDefaultsDefault General Error

swagger:response getHttpErrorRuleDefaultsDefault
*/
type GetHTTPErrorRuleDefaultsDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetHTTPErrorRuleDefaultsDefault creates GetHTTPErrorRuleDefaultsDefault with default headers values
func NewGetHTTPErrorRuleDefaultsDefault(code int) *GetHTTPErrorRuleDefaultsDefault {
	if code <= 0 {
		code = 500
	}

	return &GetHTTPErrorRuleDefaultsDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get HTTP error rule defaults default response
func (o *GetHTTPErrorRuleDefaultsDefault) WithStatusCode(code int) *GetHTTPErrorRuleDefaultsDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get HTTP error rule defaults default response
func (o *GetHTTPErrorRuleDefaultsDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get HTTP error rule defaults default response
func (o *GetHTTPErrorRuleDefaultsDefault) WithConfigurationVersion(configurationVersion string) *GetHTTPErrorRuleDefaultsDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get HTTP error rule defaults default response
func (o *GetHTTPErrorRuleDefaultsDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get HTTP error rule defaults default response
func (o *GetHTTPErrorRuleDefaultsDefault) WithPayload(payload *models.Error) *GetHTTPErrorRuleDefaultsDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get HTTP error rule defaults default response
func (o *GetHTTPErrorRuleDefaultsDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetHTTPErrorRuleDefaultsDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
