// +build go1.6
// +build codecgen generated

// Code generated by codecgen - DO NOT EDIT.

package codec

import (
	"errors"
	"runtime"
	"strconv"
	"time"
)

const (
	// ----- content types ----
	codecSelferCcUTF819780 = 1
	codecSelferCcRAW19780  = 255
	// ----- value types used ----
	codecSelferValueTypeArray19780     = 10
	codecSelferValueTypeMap19780       = 9
	codecSelferValueTypeString19780    = 6
	codecSelferValueTypeInt19780       = 2
	codecSelferValueTypeUint19780      = 3
	codecSelferValueTypeFloat19780     = 4
	codecSelferValueTypeNil19780       = 1
	codecSelferBitsize19780            = uint8(32 << (^uint(0) >> 63))
	codecSelferDecContainerLenNil19780 = -2147483648
)

var (
	errCodecSelferOnlyMapOrArrayEncodeToStruct19780 = errors.New(`only encoded map or array can be decoded into a struct`)
)

type codecSelfer19780 struct{}

func codecSelfer19780False() bool { return false }

func init() {
	if GenVersion != 16 {
		_, file, _, _ := runtime.Caller(0)
		ver := strconv.FormatInt(int64(GenVersion), 10)
		panic("codecgen version mismatch: current: 16, need " + ver + ". Re-generate file: " + file)
	}
	if false { // reference the types, but skip this branch at build/run time
		var _ time.Time
	}
}

func (x wrapSliceUint64) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		h.encwrapSliceUint64((wrapSliceUint64)(x), e)
	} // end block: if x slice == nil
}

func (x *wrapSliceUint64) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	h.decwrapSliceUint64((*wrapSliceUint64)(x), d)
}

func (x wrapSliceString) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		h.encwrapSliceString((wrapSliceString)(x), e)
	} // end block: if x slice == nil
}

func (x *wrapSliceString) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	h.decwrapSliceString((*wrapSliceString)(x), d)
}

func (x wrapUint64) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeUint(uint64(x))
}

func (x *wrapUint64) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	*x = (wrapUint64)(r.DecodeUint64())
}

func (x wrapString) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeString(string(x))
}

func (x *wrapString) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	*x = (wrapString)(string(r.DecodeStringAsBytes()))
}

func (x wrapUint64Slice) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		h.encwrapUint64Slice((wrapUint64Slice)(x), e)
	} // end block: if x slice == nil
}

func (x *wrapUint64Slice) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	h.decwrapUint64Slice((*wrapUint64Slice)(x), d)
}

func (x wrapStringSlice) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		h.encwrapStringSlice((wrapStringSlice)(x), e)
	} // end block: if x slice == nil
}

func (x *wrapStringSlice) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	h.decwrapStringSlice((*wrapStringSlice)(x), d)
}

func (x *stringUint64T) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yysep2 := !z.EncBinary()
		yy2arr2 := z.EncBasicHandle().StructToArray
		_, _ = yysep2, yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(2)
			z.EncWriteArrayElem()
			r.EncodeString(string(x.S))
			z.EncWriteArrayElem()
			r.EncodeUint(uint64(x.U))
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(2)
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"S\"")
			} else {
				r.EncodeString(`S`)
			}
			z.EncWriteMapElemValue()
			r.EncodeString(string(x.S))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"U\"")
			} else {
				r.EncodeString(`U`)
			}
			z.EncWriteMapElemValue()
			r.EncodeUint(uint64(x.U))
			z.EncWriteMapEnd()
		}
	}
}

func (x *stringUint64T) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil19780 {
		*(x) = stringUint64T{}
	} else if yyct2 == codecSelferValueTypeMap19780 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray19780 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct19780)
	}
}

func (x *stringUint64T) codecDecodeSelfFromMap(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if z.DecCheckBreak() {
				break
			}
		}
		z.DecReadMapElemKey()
		yys3 := z.StringView(r.DecodeStringAsBytes())
		z.DecReadMapElemValue()
		switch yys3 {
		case "S":
			x.S = (string)(string(r.DecodeStringAsBytes()))
		case "U":
			x.U = (uint64)(r.DecodeUint64())
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
}

func (x *stringUint64T) codecDecodeSelfFromArray(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj6 int
	var yyb6 bool
	var yyhl6 bool = l >= 0
	yyj6++
	if yyhl6 {
		yyb6 = yyj6 > l
	} else {
		yyb6 = z.DecCheckBreak()
	}
	if yyb6 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.S = (string)(string(r.DecodeStringAsBytes()))
	yyj6++
	if yyhl6 {
		yyb6 = yyj6 > l
	} else {
		yyb6 = z.DecCheckBreak()
	}
	if yyb6 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.U = (uint64)(r.DecodeUint64())
	for {
		yyj6++
		if yyhl6 {
			yyb6 = yyj6 > l
		} else {
			yyb6 = z.DecCheckBreak()
		}
		if yyb6 {
			break
		}
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj6-1, "")
	}
}

func (x *AnonInTestStruc) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yysep2 := !z.EncBinary()
		yy2arr2 := z.EncBasicHandle().StructToArray
		_, _ = yysep2, yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(15)
			z.EncWriteArrayElem()
			r.EncodeString(string(x.AS))
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.AI64))
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.AI16))
			z.EncWriteArrayElem()
			r.EncodeUint(uint64(x.AUi64))
			z.EncWriteArrayElem()
			if x.ASslice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceStringV(x.ASslice, e)
			} // end block: if x.ASslice slice == nil
			z.EncWriteArrayElem()
			if x.AI64slice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceInt64V(x.AI64slice, e)
			} // end block: if x.AI64slice slice == nil
			z.EncWriteArrayElem()
			if x.AUi64slice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceUint64V(x.AUi64slice, e)
			} // end block: if x.AUi64slice slice == nil
			z.EncWriteArrayElem()
			if x.AF64slice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceFloat64V(x.AF64slice, e)
			} // end block: if x.AF64slice slice == nil
			z.EncWriteArrayElem()
			if x.AF32slice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceFloat32V(x.AF32slice, e)
			} // end block: if x.AF32slice slice == nil
			z.EncWriteArrayElem()
			if x.AMSU16 == nil {
				r.EncodeNil()
			} else {
				h.encMapstringuint16((map[string]uint16)(x.AMSU16), e)
			} // end block: if x.AMSU16 map == nil
			z.EncWriteArrayElem()
			yy28 := &x.AI64arr0
			h.encArray0int64((*[0]int64)(yy28), e)
			z.EncWriteArrayElem()
			if x.AI64slice0 == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceInt64V(x.AI64slice0, e)
			} // end block: if x.AI64slice0 slice == nil
			z.EncWriteArrayElem()
			if x.AUi64sliceN == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceUint64V(x.AUi64sliceN, e)
			} // end block: if x.AUi64sliceN slice == nil
			z.EncWriteArrayElem()
			if x.AMSU16N == nil {
				r.EncodeNil()
			} else {
				h.encMapstringuint16((map[string]uint16)(x.AMSU16N), e)
			} // end block: if x.AMSU16N map == nil
			z.EncWriteArrayElem()
			if x.AMSU16E == nil {
				r.EncodeNil()
			} else {
				h.encMapstringuint16((map[string]uint16)(x.AMSU16E), e)
			} // end block: if x.AMSU16E map == nil
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(15)
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"AS\"")
			} else {
				r.EncodeString(`AS`)
			}
			z.EncWriteMapElemValue()
			r.EncodeString(string(x.AS))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"AI64\"")
			} else {
				r.EncodeString(`AI64`)
			}
			z.EncWriteMapElemValue()
			r.EncodeInt(int64(x.AI64))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"AI16\"")
			} else {
				r.EncodeString(`AI16`)
			}
			z.EncWriteMapElemValue()
			r.EncodeInt(int64(x.AI16))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"AUi64\"")
			} else {
				r.EncodeString(`AUi64`)
			}
			z.EncWriteMapElemValue()
			r.EncodeUint(uint64(x.AUi64))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"ASslice\"")
			} else {
				r.EncodeString(`ASslice`)
			}
			z.EncWriteMapElemValue()
			if x.ASslice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceStringV(x.ASslice, e)
			} // end block: if x.ASslice slice == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"AI64slice\"")
			} else {
				r.EncodeString(`AI64slice`)
			}
			z.EncWriteMapElemValue()
			if x.AI64slice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceInt64V(x.AI64slice, e)
			} // end block: if x.AI64slice slice == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"AUi64slice\"")
			} else {
				r.EncodeString(`AUi64slice`)
			}
			z.EncWriteMapElemValue()
			if x.AUi64slice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceUint64V(x.AUi64slice, e)
			} // end block: if x.AUi64slice slice == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"AF64slice\"")
			} else {
				r.EncodeString(`AF64slice`)
			}
			z.EncWriteMapElemValue()
			if x.AF64slice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceFloat64V(x.AF64slice, e)
			} // end block: if x.AF64slice slice == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"AF32slice\"")
			} else {
				r.EncodeString(`AF32slice`)
			}
			z.EncWriteMapElemValue()
			if x.AF32slice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceFloat32V(x.AF32slice, e)
			} // end block: if x.AF32slice slice == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"AMSU16\"")
			} else {
				r.EncodeString(`AMSU16`)
			}
			z.EncWriteMapElemValue()
			if x.AMSU16 == nil {
				r.EncodeNil()
			} else {
				h.encMapstringuint16((map[string]uint16)(x.AMSU16), e)
			} // end block: if x.AMSU16 map == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"AI64arr0\"")
			} else {
				r.EncodeString(`AI64arr0`)
			}
			z.EncWriteMapElemValue()
			yy44 := &x.AI64arr0
			h.encArray0int64((*[0]int64)(yy44), e)
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"AI64slice0\"")
			} else {
				r.EncodeString(`AI64slice0`)
			}
			z.EncWriteMapElemValue()
			if x.AI64slice0 == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceInt64V(x.AI64slice0, e)
			} // end block: if x.AI64slice0 slice == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"AUi64sliceN\"")
			} else {
				r.EncodeString(`AUi64sliceN`)
			}
			z.EncWriteMapElemValue()
			if x.AUi64sliceN == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceUint64V(x.AUi64sliceN, e)
			} // end block: if x.AUi64sliceN slice == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"AMSU16N\"")
			} else {
				r.EncodeString(`AMSU16N`)
			}
			z.EncWriteMapElemValue()
			if x.AMSU16N == nil {
				r.EncodeNil()
			} else {
				h.encMapstringuint16((map[string]uint16)(x.AMSU16N), e)
			} // end block: if x.AMSU16N map == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"AMSU16E\"")
			} else {
				r.EncodeString(`AMSU16E`)
			}
			z.EncWriteMapElemValue()
			if x.AMSU16E == nil {
				r.EncodeNil()
			} else {
				h.encMapstringuint16((map[string]uint16)(x.AMSU16E), e)
			} // end block: if x.AMSU16E map == nil
			z.EncWriteMapEnd()
		}
	}
}

func (x *AnonInTestStruc) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil19780 {
		*(x) = AnonInTestStruc{}
	} else if yyct2 == codecSelferValueTypeMap19780 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray19780 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct19780)
	}
}

func (x *AnonInTestStruc) codecDecodeSelfFromMap(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if z.DecCheckBreak() {
				break
			}
		}
		z.DecReadMapElemKey()
		yys3 := z.StringView(r.DecodeStringAsBytes())
		z.DecReadMapElemValue()
		switch yys3 {
		case "AS":
			x.AS = (string)(string(r.DecodeStringAsBytes()))
		case "AI64":
			x.AI64 = (int64)(r.DecodeInt64())
		case "AI16":
			x.AI16 = (int16)(z.C.IntV(r.DecodeInt64(), 16))
		case "AUi64":
			x.AUi64 = (uint64)(r.DecodeUint64())
		case "ASslice":
			z.F.DecSliceStringX(&x.ASslice, d)
		case "AI64slice":
			z.F.DecSliceInt64X(&x.AI64slice, d)
		case "AUi64slice":
			z.F.DecSliceUint64X(&x.AUi64slice, d)
		case "AF64slice":
			z.F.DecSliceFloat64X(&x.AF64slice, d)
		case "AF32slice":
			z.F.DecSliceFloat32X(&x.AF32slice, d)
		case "AMSU16":
			h.decMapstringuint16((*map[string]uint16)(&x.AMSU16), d)
		case "AI64arr0":
			h.decArray0int64((*[0]int64)(&x.AI64arr0), d)
		case "AI64slice0":
			z.F.DecSliceInt64X(&x.AI64slice0, d)
		case "AUi64sliceN":
			z.F.DecSliceUint64X(&x.AUi64sliceN, d)
		case "AMSU16N":
			h.decMapstringuint16((*map[string]uint16)(&x.AMSU16N), d)
		case "AMSU16E":
			h.decMapstringuint16((*map[string]uint16)(&x.AMSU16E), d)
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
}

func (x *AnonInTestStruc) codecDecodeSelfFromArray(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj30 int
	var yyb30 bool
	var yyhl30 bool = l >= 0
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = z.DecCheckBreak()
	}
	if yyb30 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.AS = (string)(string(r.DecodeStringAsBytes()))
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = z.DecCheckBreak()
	}
	if yyb30 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.AI64 = (int64)(r.DecodeInt64())
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = z.DecCheckBreak()
	}
	if yyb30 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.AI16 = (int16)(z.C.IntV(r.DecodeInt64(), 16))
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = z.DecCheckBreak()
	}
	if yyb30 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.AUi64 = (uint64)(r.DecodeUint64())
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = z.DecCheckBreak()
	}
	if yyb30 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceStringX(&x.ASslice, d)
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = z.DecCheckBreak()
	}
	if yyb30 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceInt64X(&x.AI64slice, d)
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = z.DecCheckBreak()
	}
	if yyb30 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceUint64X(&x.AUi64slice, d)
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = z.DecCheckBreak()
	}
	if yyb30 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceFloat64X(&x.AF64slice, d)
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = z.DecCheckBreak()
	}
	if yyb30 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceFloat32X(&x.AF32slice, d)
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = z.DecCheckBreak()
	}
	if yyb30 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decMapstringuint16((*map[string]uint16)(&x.AMSU16), d)
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = z.DecCheckBreak()
	}
	if yyb30 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decArray0int64((*[0]int64)(&x.AI64arr0), d)
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = z.DecCheckBreak()
	}
	if yyb30 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceInt64X(&x.AI64slice0, d)
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = z.DecCheckBreak()
	}
	if yyb30 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceUint64X(&x.AUi64sliceN, d)
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = z.DecCheckBreak()
	}
	if yyb30 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decMapstringuint16((*map[string]uint16)(&x.AMSU16N), d)
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = z.DecCheckBreak()
	}
	if yyb30 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decMapstringuint16((*map[string]uint16)(&x.AMSU16E), d)
	for {
		yyj30++
		if yyhl30 {
			yyb30 = yyj30 > l
		} else {
			yyb30 = z.DecCheckBreak()
		}
		if yyb30 {
			break
		}
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj30-1, "")
	}
}

func (x *testSimpleFields) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yysep2 := !z.EncBinary()
		yy2arr2 := z.EncBasicHandle().StructToArray
		_, _ = yysep2, yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(17)
			z.EncWriteArrayElem()
			r.EncodeString(string(x.S))
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.I64))
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.I8))
			z.EncWriteArrayElem()
			r.EncodeUint(uint64(x.Ui64))
			z.EncWriteArrayElem()
			r.EncodeUint(uint64(x.Ui8))
			z.EncWriteArrayElem()
			r.EncodeFloat64(float64(x.F64))
			z.EncWriteArrayElem()
			r.EncodeFloat32(float32(x.F32))
			z.EncWriteArrayElem()
			r.EncodeBool(bool(x.B))
			z.EncWriteArrayElem()
			if x.Sslice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceStringV(x.Sslice, e)
			} // end block: if x.Sslice slice == nil
			z.EncWriteArrayElem()
			if x.I16slice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceInt16V(x.I16slice, e)
			} // end block: if x.I16slice slice == nil
			z.EncWriteArrayElem()
			if x.Ui64slice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceUint64V(x.Ui64slice, e)
			} // end block: if x.Ui64slice slice == nil
			z.EncWriteArrayElem()
			if x.Ui8slice == nil {
				r.EncodeNil()
			} else {
				r.EncodeStringBytesRaw([]byte(x.Ui8slice))
			} // end block: if x.Ui8slice slice == nil
			z.EncWriteArrayElem()
			if x.Bslice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceBoolV(x.Bslice, e)
			} // end block: if x.Bslice slice == nil
			z.EncWriteArrayElem()
			if x.Iptrslice == nil {
				r.EncodeNil()
			} else {
				h.encSlicePtrtoint64(([]*int64)(x.Iptrslice), e)
			} // end block: if x.Iptrslice slice == nil
			z.EncWriteArrayElem()
			x.WrapSliceInt64.CodecEncodeSelf(e)
			z.EncWriteArrayElem()
			x.WrapSliceString.CodecEncodeSelf(e)
			z.EncWriteArrayElem()
			if x.Msi64 == nil {
				r.EncodeNil()
			} else {
				z.F.EncMapStringInt64V(x.Msi64, e)
			} // end block: if x.Msi64 map == nil
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(17)
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"S\"")
			} else {
				r.EncodeString(`S`)
			}
			z.EncWriteMapElemValue()
			r.EncodeString(string(x.S))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"I64\"")
			} else {
				r.EncodeString(`I64`)
			}
			z.EncWriteMapElemValue()
			r.EncodeInt(int64(x.I64))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"I8\"")
			} else {
				r.EncodeString(`I8`)
			}
			z.EncWriteMapElemValue()
			r.EncodeInt(int64(x.I8))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"Ui64\"")
			} else {
				r.EncodeString(`Ui64`)
			}
			z.EncWriteMapElemValue()
			r.EncodeUint(uint64(x.Ui64))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"Ui8\"")
			} else {
				r.EncodeString(`Ui8`)
			}
			z.EncWriteMapElemValue()
			r.EncodeUint(uint64(x.Ui8))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"F64\"")
			} else {
				r.EncodeString(`F64`)
			}
			z.EncWriteMapElemValue()
			r.EncodeFloat64(float64(x.F64))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"F32\"")
			} else {
				r.EncodeString(`F32`)
			}
			z.EncWriteMapElemValue()
			r.EncodeFloat32(float32(x.F32))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"B\"")
			} else {
				r.EncodeString(`B`)
			}
			z.EncWriteMapElemValue()
			r.EncodeBool(bool(x.B))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"Sslice\"")
			} else {
				r.EncodeString(`Sslice`)
			}
			z.EncWriteMapElemValue()
			if x.Sslice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceStringV(x.Sslice, e)
			} // end block: if x.Sslice slice == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"I16slice\"")
			} else {
				r.EncodeString(`I16slice`)
			}
			z.EncWriteMapElemValue()
			if x.I16slice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceInt16V(x.I16slice, e)
			} // end block: if x.I16slice slice == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"Ui64slice\"")
			} else {
				r.EncodeString(`Ui64slice`)
			}
			z.EncWriteMapElemValue()
			if x.Ui64slice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceUint64V(x.Ui64slice, e)
			} // end block: if x.Ui64slice slice == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"Ui8slice\"")
			} else {
				r.EncodeString(`Ui8slice`)
			}
			z.EncWriteMapElemValue()
			if x.Ui8slice == nil {
				r.EncodeNil()
			} else {
				r.EncodeStringBytesRaw([]byte(x.Ui8slice))
			} // end block: if x.Ui8slice slice == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"Bslice\"")
			} else {
				r.EncodeString(`Bslice`)
			}
			z.EncWriteMapElemValue()
			if x.Bslice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceBoolV(x.Bslice, e)
			} // end block: if x.Bslice slice == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"Iptrslice\"")
			} else {
				r.EncodeString(`Iptrslice`)
			}
			z.EncWriteMapElemValue()
			if x.Iptrslice == nil {
				r.EncodeNil()
			} else {
				h.encSlicePtrtoint64(([]*int64)(x.Iptrslice), e)
			} // end block: if x.Iptrslice slice == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"WrapSliceInt64\"")
			} else {
				r.EncodeString(`WrapSliceInt64`)
			}
			z.EncWriteMapElemValue()
			x.WrapSliceInt64.CodecEncodeSelf(e)
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"WrapSliceString\"")
			} else {
				r.EncodeString(`WrapSliceString`)
			}
			z.EncWriteMapElemValue()
			x.WrapSliceString.CodecEncodeSelf(e)
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"Msi64\"")
			} else {
				r.EncodeString(`Msi64`)
			}
			z.EncWriteMapElemValue()
			if x.Msi64 == nil {
				r.EncodeNil()
			} else {
				z.F.EncMapStringInt64V(x.Msi64, e)
			} // end block: if x.Msi64 map == nil
			z.EncWriteMapEnd()
		}
	}
}

func (x *testSimpleFields) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil19780 {
		*(x) = testSimpleFields{}
	} else if yyct2 == codecSelferValueTypeMap19780 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray19780 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct19780)
	}
}

func (x *testSimpleFields) codecDecodeSelfFromMap(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if z.DecCheckBreak() {
				break
			}
		}
		z.DecReadMapElemKey()
		yys3 := z.StringView(r.DecodeStringAsBytes())
		z.DecReadMapElemValue()
		switch yys3 {
		case "S":
			x.S = (string)(string(r.DecodeStringAsBytes()))
		case "I64":
			x.I64 = (int64)(r.DecodeInt64())
		case "I8":
			x.I8 = (int8)(z.C.IntV(r.DecodeInt64(), 8))
		case "Ui64":
			x.Ui64 = (uint64)(r.DecodeUint64())
		case "Ui8":
			x.Ui8 = (uint8)(z.C.UintV(r.DecodeUint64(), 8))
		case "F64":
			x.F64 = (float64)(r.DecodeFloat64())
		case "F32":
			x.F32 = (float32)(z.DecDecodeFloat32())
		case "B":
			x.B = (bool)(r.DecodeBool())
		case "Sslice":
			z.F.DecSliceStringX(&x.Sslice, d)
		case "I16slice":
			z.F.DecSliceInt16X(&x.I16slice, d)
		case "Ui64slice":
			z.F.DecSliceUint64X(&x.Ui64slice, d)
		case "Ui8slice":
			x.Ui8slice = r.DecodeBytes(([]byte)(x.Ui8slice), false)
		case "Bslice":
			z.F.DecSliceBoolX(&x.Bslice, d)
		case "Iptrslice":
			h.decSlicePtrtoint64((*[]*int64)(&x.Iptrslice), d)
		case "WrapSliceInt64":
			x.WrapSliceInt64.CodecDecodeSelf(d)
		case "WrapSliceString":
			x.WrapSliceString.CodecDecodeSelf(d)
		case "Msi64":
			z.F.DecMapStringInt64X(&x.Msi64, d)
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
}

func (x *testSimpleFields) codecDecodeSelfFromArray(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj28 int
	var yyb28 bool
	var yyhl28 bool = l >= 0
	yyj28++
	if yyhl28 {
		yyb28 = yyj28 > l
	} else {
		yyb28 = z.DecCheckBreak()
	}
	if yyb28 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.S = (string)(string(r.DecodeStringAsBytes()))
	yyj28++
	if yyhl28 {
		yyb28 = yyj28 > l
	} else {
		yyb28 = z.DecCheckBreak()
	}
	if yyb28 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.I64 = (int64)(r.DecodeInt64())
	yyj28++
	if yyhl28 {
		yyb28 = yyj28 > l
	} else {
		yyb28 = z.DecCheckBreak()
	}
	if yyb28 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.I8 = (int8)(z.C.IntV(r.DecodeInt64(), 8))
	yyj28++
	if yyhl28 {
		yyb28 = yyj28 > l
	} else {
		yyb28 = z.DecCheckBreak()
	}
	if yyb28 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.Ui64 = (uint64)(r.DecodeUint64())
	yyj28++
	if yyhl28 {
		yyb28 = yyj28 > l
	} else {
		yyb28 = z.DecCheckBreak()
	}
	if yyb28 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.Ui8 = (uint8)(z.C.UintV(r.DecodeUint64(), 8))
	yyj28++
	if yyhl28 {
		yyb28 = yyj28 > l
	} else {
		yyb28 = z.DecCheckBreak()
	}
	if yyb28 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.F64 = (float64)(r.DecodeFloat64())
	yyj28++
	if yyhl28 {
		yyb28 = yyj28 > l
	} else {
		yyb28 = z.DecCheckBreak()
	}
	if yyb28 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.F32 = (float32)(z.DecDecodeFloat32())
	yyj28++
	if yyhl28 {
		yyb28 = yyj28 > l
	} else {
		yyb28 = z.DecCheckBreak()
	}
	if yyb28 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.B = (bool)(r.DecodeBool())
	yyj28++
	if yyhl28 {
		yyb28 = yyj28 > l
	} else {
		yyb28 = z.DecCheckBreak()
	}
	if yyb28 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceStringX(&x.Sslice, d)
	yyj28++
	if yyhl28 {
		yyb28 = yyj28 > l
	} else {
		yyb28 = z.DecCheckBreak()
	}
	if yyb28 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceInt16X(&x.I16slice, d)
	yyj28++
	if yyhl28 {
		yyb28 = yyj28 > l
	} else {
		yyb28 = z.DecCheckBreak()
	}
	if yyb28 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceUint64X(&x.Ui64slice, d)
	yyj28++
	if yyhl28 {
		yyb28 = yyj28 > l
	} else {
		yyb28 = z.DecCheckBreak()
	}
	if yyb28 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.Ui8slice = r.DecodeBytes(([]byte)(x.Ui8slice), false)
	yyj28++
	if yyhl28 {
		yyb28 = yyj28 > l
	} else {
		yyb28 = z.DecCheckBreak()
	}
	if yyb28 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceBoolX(&x.Bslice, d)
	yyj28++
	if yyhl28 {
		yyb28 = yyj28 > l
	} else {
		yyb28 = z.DecCheckBreak()
	}
	if yyb28 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decSlicePtrtoint64((*[]*int64)(&x.Iptrslice), d)
	yyj28++
	if yyhl28 {
		yyb28 = yyj28 > l
	} else {
		yyb28 = z.DecCheckBreak()
	}
	if yyb28 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.WrapSliceInt64.CodecDecodeSelf(d)
	yyj28++
	if yyhl28 {
		yyb28 = yyj28 > l
	} else {
		yyb28 = z.DecCheckBreak()
	}
	if yyb28 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.WrapSliceString.CodecDecodeSelf(d)
	yyj28++
	if yyhl28 {
		yyb28 = yyj28 > l
	} else {
		yyb28 = z.DecCheckBreak()
	}
	if yyb28 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecMapStringInt64X(&x.Msi64, d)
	for {
		yyj28++
		if yyhl28 {
			yyb28 = yyj28 > l
		} else {
			yyb28 = z.DecCheckBreak()
		}
		if yyb28 {
			break
		}
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj28-1, "")
	}
}

func (x *TestStrucCommon) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yysep2 := !z.EncBinary()
		yy2arr2 := z.EncBasicHandle().StructToArray
		_, _ = yysep2, yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		var yyn54 bool = x.Nint64 == nil
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(52)
			z.EncWriteArrayElem()
			r.EncodeString(string(x.S))
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.I64))
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.I32))
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.I16))
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.I8))
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.I64n))
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.I32n))
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.I16n))
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.I8n))
			z.EncWriteArrayElem()
			r.EncodeUint(uint64(x.Ui64))
			z.EncWriteArrayElem()
			r.EncodeUint(uint64(x.Ui32))
			z.EncWriteArrayElem()
			r.EncodeUint(uint64(x.Ui16))
			z.EncWriteArrayElem()
			r.EncodeUint(uint64(x.Ui8))
			z.EncWriteArrayElem()
			r.EncodeFloat64(float64(x.F64))
			z.EncWriteArrayElem()
			r.EncodeFloat32(float32(x.F32))
			z.EncWriteArrayElem()
			r.EncodeBool(bool(x.B))
			z.EncWriteArrayElem()
			r.EncodeUint(uint64(x.By))
			z.EncWriteArrayElem()
			if x.Sslice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceStringV(x.Sslice, e)
			} // end block: if x.Sslice slice == nil
			z.EncWriteArrayElem()
			if x.I64slice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceInt64V(x.I64slice, e)
			} // end block: if x.I64slice slice == nil
			z.EncWriteArrayElem()
			if x.I16slice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceInt16V(x.I16slice, e)
			} // end block: if x.I16slice slice == nil
			z.EncWriteArrayElem()
			if x.Ui64slice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceUint64V(x.Ui64slice, e)
			} // end block: if x.Ui64slice slice == nil
			z.EncWriteArrayElem()
			if x.Ui8slice == nil {
				r.EncodeNil()
			} else {
				r.EncodeStringBytesRaw([]byte(x.Ui8slice))
			} // end block: if x.Ui8slice slice == nil
			z.EncWriteArrayElem()
			if x.Bslice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceBoolV(x.Bslice, e)
			} // end block: if x.Bslice slice == nil
			z.EncWriteArrayElem()
			if x.Byslice == nil {
				r.EncodeNil()
			} else {
				r.EncodeStringBytesRaw([]byte(x.Byslice))
			} // end block: if x.Byslice slice == nil
			z.EncWriteArrayElem()
			if x.BytesSlice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceBytesV(x.BytesSlice, e)
			} // end block: if x.BytesSlice slice == nil
			z.EncWriteArrayElem()
			if x.Iptrslice == nil {
				r.EncodeNil()
			} else {
				h.encSlicePtrtoint64(([]*int64)(x.Iptrslice), e)
			} // end block: if x.Iptrslice slice == nil
			z.EncWriteArrayElem()
			x.WrapSliceInt64.CodecEncodeSelf(e)
			z.EncWriteArrayElem()
			x.WrapSliceString.CodecEncodeSelf(e)
			z.EncWriteArrayElem()
			if x.Msi64 == nil {
				r.EncodeNil()
			} else {
				z.F.EncMapStringInt64V(x.Msi64, e)
			} // end block: if x.Msi64 map == nil
			z.EncWriteArrayElem()
			if x.Msbytes == nil {
				r.EncodeNil()
			} else {
				z.F.EncMapStringBytesV(x.Msbytes, e)
			} // end block: if x.Msbytes map == nil
			z.EncWriteArrayElem()
			yy85 := &x.Simplef
			yy85.CodecEncodeSelf(e)
			z.EncWriteArrayElem()
			if x.SstrUi64T == nil {
				r.EncodeNil()
			} else {
				h.encSlicestringUint64T(([]stringUint64T)(x.SstrUi64T), e)
			} // end block: if x.SstrUi64T slice == nil
			z.EncWriteArrayElem()
			if x.MstrUi64T == nil {
				r.EncodeNil()
			} else {
				h.encMapstringPtrtostringUint64T((map[string]*stringUint64T)(x.MstrUi64T), e)
			} // end block: if x.MstrUi64T map == nil
			z.EncWriteArrayElem()
			r.EncodeString(string(x.AnonInTestStruc.AS))
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.AnonInTestStruc.AI64))
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.AnonInTestStruc.AI16))
			z.EncWriteArrayElem()
			r.EncodeUint(uint64(x.AnonInTestStruc.AUi64))
			z.EncWriteArrayElem()
			if x.AnonInTestStruc.ASslice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceStringV(x.AnonInTestStruc.ASslice, e)
			} // end block: if x.AnonInTestStruc.ASslice slice == nil
			z.EncWriteArrayElem()
			if x.AnonInTestStruc.AI64slice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceInt64V(x.AnonInTestStruc.AI64slice, e)
			} // end block: if x.AnonInTestStruc.AI64slice slice == nil
			z.EncWriteArrayElem()
			if x.AnonInTestStruc.AUi64slice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceUint64V(x.AnonInTestStruc.AUi64slice, e)
			} // end block: if x.AnonInTestStruc.AUi64slice slice == nil
			z.EncWriteArrayElem()
			if x.AnonInTestStruc.AF64slice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceFloat64V(x.AnonInTestStruc.AF64slice, e)
			} // end block: if x.AnonInTestStruc.AF64slice slice == nil
			z.EncWriteArrayElem()
			if x.AnonInTestStruc.AF32slice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceFloat32V(x.AnonInTestStruc.AF32slice, e)
			} // end block: if x.AnonInTestStruc.AF32slice slice == nil
			z.EncWriteArrayElem()
			if x.AnonInTestStruc.AMSU16 == nil {
				r.EncodeNil()
			} else {
				h.encMapstringuint16((map[string]uint16)(x.AnonInTestStruc.AMSU16), e)
			} // end block: if x.AnonInTestStruc.AMSU16 map == nil
			z.EncWriteArrayElem()
			yy99 := &x.AnonInTestStruc.AI64arr0
			h.encArray0int64((*[0]int64)(yy99), e)
			z.EncWriteArrayElem()
			if x.AnonInTestStruc.AI64slice0 == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceInt64V(x.AnonInTestStruc.AI64slice0, e)
			} // end block: if x.AnonInTestStruc.AI64slice0 slice == nil
			z.EncWriteArrayElem()
			if x.AnonInTestStruc.AUi64sliceN == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceUint64V(x.AnonInTestStruc.AUi64sliceN, e)
			} // end block: if x.AnonInTestStruc.AUi64sliceN slice == nil
			z.EncWriteArrayElem()
			if x.AnonInTestStruc.AMSU16N == nil {
				r.EncodeNil()
			} else {
				h.encMapstringuint16((map[string]uint16)(x.AnonInTestStruc.AMSU16N), e)
			} // end block: if x.AnonInTestStruc.AMSU16N map == nil
			z.EncWriteArrayElem()
			if x.AnonInTestStruc.AMSU16E == nil {
				r.EncodeNil()
			} else {
				h.encMapstringuint16((map[string]uint16)(x.AnonInTestStruc.AMSU16E), e)
			} // end block: if x.AnonInTestStruc.AMSU16E map == nil
			z.EncWriteArrayElem()
			yy105 := &x.NotAnon
			yy105.CodecEncodeSelf(e)
			z.EncWriteArrayElem()
			if x.Nmap == nil {
				r.EncodeNil()
			} else {
				z.F.EncMapStringBoolV(x.Nmap, e)
			} // end block: if x.Nmap map == nil
			z.EncWriteArrayElem()
			if x.Nslice == nil {
				r.EncodeNil()
			} else {
				r.EncodeStringBytesRaw([]byte(x.Nslice))
			} // end block: if x.Nslice slice == nil
			if yyn54 {
				z.EncWriteArrayElem()
				r.EncodeNil()
			} else {
				z.EncWriteArrayElem()
				yy109 := *x.Nint64
				r.EncodeInt(int64(yy109))
			}
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(52)
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"S\"")
			} else {
				r.EncodeString(`S`)
			}
			z.EncWriteMapElemValue()
			r.EncodeString(string(x.S))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"I64\"")
			} else {
				r.EncodeString(`I64`)
			}
			z.EncWriteMapElemValue()
			r.EncodeInt(int64(x.I64))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"I32\"")
			} else {
				r.EncodeString(`I32`)
			}
			z.EncWriteMapElemValue()
			r.EncodeInt(int64(x.I32))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"I16\"")
			} else {
				r.EncodeString(`I16`)
			}
			z.EncWriteMapElemValue()
			r.EncodeInt(int64(x.I16))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"I8\"")
			} else {
				r.EncodeString(`I8`)
			}
			z.EncWriteMapElemValue()
			r.EncodeInt(int64(x.I8))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"I64n\"")
			} else {
				r.EncodeString(`I64n`)
			}
			z.EncWriteMapElemValue()
			r.EncodeInt(int64(x.I64n))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"I32n\"")
			} else {
				r.EncodeString(`I32n`)
			}
			z.EncWriteMapElemValue()
			r.EncodeInt(int64(x.I32n))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"I16n\"")
			} else {
				r.EncodeString(`I16n`)
			}
			z.EncWriteMapElemValue()
			r.EncodeInt(int64(x.I16n))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"I8n\"")
			} else {
				r.EncodeString(`I8n`)
			}
			z.EncWriteMapElemValue()
			r.EncodeInt(int64(x.I8n))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"Ui64\"")
			} else {
				r.EncodeString(`Ui64`)
			}
			z.EncWriteMapElemValue()
			r.EncodeUint(uint64(x.Ui64))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"Ui32\"")
			} else {
				r.EncodeString(`Ui32`)
			}
			z.EncWriteMapElemValue()
			r.EncodeUint(uint64(x.Ui32))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"Ui16\"")
			} else {
				r.EncodeString(`Ui16`)
			}
			z.EncWriteMapElemValue()
			r.EncodeUint(uint64(x.Ui16))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"Ui8\"")
			} else {
				r.EncodeString(`Ui8`)
			}
			z.EncWriteMapElemValue()
			r.EncodeUint(uint64(x.Ui8))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"F64\"")
			} else {
				r.EncodeString(`F64`)
			}
			z.EncWriteMapElemValue()
			r.EncodeFloat64(float64(x.F64))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"F32\"")
			} else {
				r.EncodeString(`F32`)
			}
			z.EncWriteMapElemValue()
			r.EncodeFloat32(float32(x.F32))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"B\"")
			} else {
				r.EncodeString(`B`)
			}
			z.EncWriteMapElemValue()
			r.EncodeBool(bool(x.B))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"By\"")
			} else {
				r.EncodeString(`By`)
			}
			z.EncWriteMapElemValue()
			r.EncodeUint(uint64(x.By))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"Sslice\"")
			} else {
				r.EncodeString(`Sslice`)
			}
			z.EncWriteMapElemValue()
			if x.Sslice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceStringV(x.Sslice, e)
			} // end block: if x.Sslice slice == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"I64slice\"")
			} else {
				r.EncodeString(`I64slice`)
			}
			z.EncWriteMapElemValue()
			if x.I64slice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceInt64V(x.I64slice, e)
			} // end block: if x.I64slice slice == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"I16slice\"")
			} else {
				r.EncodeString(`I16slice`)
			}
			z.EncWriteMapElemValue()
			if x.I16slice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceInt16V(x.I16slice, e)
			} // end block: if x.I16slice slice == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"Ui64slice\"")
			} else {
				r.EncodeString(`Ui64slice`)
			}
			z.EncWriteMapElemValue()
			if x.Ui64slice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceUint64V(x.Ui64slice, e)
			} // end block: if x.Ui64slice slice == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"Ui8slice\"")
			} else {
				r.EncodeString(`Ui8slice`)
			}
			z.EncWriteMapElemValue()
			if x.Ui8slice == nil {
				r.EncodeNil()
			} else {
				r.EncodeStringBytesRaw([]byte(x.Ui8slice))
			} // end block: if x.Ui8slice slice == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"Bslice\"")
			} else {
				r.EncodeString(`Bslice`)
			}
			z.EncWriteMapElemValue()
			if x.Bslice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceBoolV(x.Bslice, e)
			} // end block: if x.Bslice slice == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"Byslice\"")
			} else {
				r.EncodeString(`Byslice`)
			}
			z.EncWriteMapElemValue()
			if x.Byslice == nil {
				r.EncodeNil()
			} else {
				r.EncodeStringBytesRaw([]byte(x.Byslice))
			} // end block: if x.Byslice slice == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"BytesSlice\"")
			} else {
				r.EncodeString(`BytesSlice`)
			}
			z.EncWriteMapElemValue()
			if x.BytesSlice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceBytesV(x.BytesSlice, e)
			} // end block: if x.BytesSlice slice == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"Iptrslice\"")
			} else {
				r.EncodeString(`Iptrslice`)
			}
			z.EncWriteMapElemValue()
			if x.Iptrslice == nil {
				r.EncodeNil()
			} else {
				h.encSlicePtrtoint64(([]*int64)(x.Iptrslice), e)
			} // end block: if x.Iptrslice slice == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"WrapSliceInt64\"")
			} else {
				r.EncodeString(`WrapSliceInt64`)
			}
			z.EncWriteMapElemValue()
			x.WrapSliceInt64.CodecEncodeSelf(e)
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"WrapSliceString\"")
			} else {
				r.EncodeString(`WrapSliceString`)
			}
			z.EncWriteMapElemValue()
			x.WrapSliceString.CodecEncodeSelf(e)
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"Msi64\"")
			} else {
				r.EncodeString(`Msi64`)
			}
			z.EncWriteMapElemValue()
			if x.Msi64 == nil {
				r.EncodeNil()
			} else {
				z.F.EncMapStringInt64V(x.Msi64, e)
			} // end block: if x.Msi64 map == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"Msbytes\"")
			} else {
				r.EncodeString(`Msbytes`)
			}
			z.EncWriteMapElemValue()
			if x.Msbytes == nil {
				r.EncodeNil()
			} else {
				z.F.EncMapStringBytesV(x.Msbytes, e)
			} // end block: if x.Msbytes map == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"Simplef\"")
			} else {
				r.EncodeString(`Simplef`)
			}
			z.EncWriteMapElemValue()
			yy141 := &x.Simplef
			yy141.CodecEncodeSelf(e)
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"SstrUi64T\"")
			} else {
				r.EncodeString(`SstrUi64T`)
			}
			z.EncWriteMapElemValue()
			if x.SstrUi64T == nil {
				r.EncodeNil()
			} else {
				h.encSlicestringUint64T(([]stringUint64T)(x.SstrUi64T), e)
			} // end block: if x.SstrUi64T slice == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"MstrUi64T\"")
			} else {
				r.EncodeString(`MstrUi64T`)
			}
			z.EncWriteMapElemValue()
			if x.MstrUi64T == nil {
				r.EncodeNil()
			} else {
				h.encMapstringPtrtostringUint64T((map[string]*stringUint64T)(x.MstrUi64T), e)
			} // end block: if x.MstrUi64T map == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"AS\"")
			} else {
				r.EncodeString(`AS`)
			}
			z.EncWriteMapElemValue()
			r.EncodeString(string(x.AnonInTestStruc.AS))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"AI64\"")
			} else {
				r.EncodeString(`AI64`)
			}
			z.EncWriteMapElemValue()
			r.EncodeInt(int64(x.AnonInTestStruc.AI64))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"AI16\"")
			} else {
				r.EncodeString(`AI16`)
			}
			z.EncWriteMapElemValue()
			r.EncodeInt(int64(x.AnonInTestStruc.AI16))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"AUi64\"")
			} else {
				r.EncodeString(`AUi64`)
			}
			z.EncWriteMapElemValue()
			r.EncodeUint(uint64(x.AnonInTestStruc.AUi64))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"ASslice\"")
			} else {
				r.EncodeString(`ASslice`)
			}
			z.EncWriteMapElemValue()
			if x.AnonInTestStruc.ASslice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceStringV(x.AnonInTestStruc.ASslice, e)
			} // end block: if x.AnonInTestStruc.ASslice slice == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"AI64slice\"")
			} else {
				r.EncodeString(`AI64slice`)
			}
			z.EncWriteMapElemValue()
			if x.AnonInTestStruc.AI64slice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceInt64V(x.AnonInTestStruc.AI64slice, e)
			} // end block: if x.AnonInTestStruc.AI64slice slice == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"AUi64slice\"")
			} else {
				r.EncodeString(`AUi64slice`)
			}
			z.EncWriteMapElemValue()
			if x.AnonInTestStruc.AUi64slice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceUint64V(x.AnonInTestStruc.AUi64slice, e)
			} // end block: if x.AnonInTestStruc.AUi64slice slice == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"AF64slice\"")
			} else {
				r.EncodeString(`AF64slice`)
			}
			z.EncWriteMapElemValue()
			if x.AnonInTestStruc.AF64slice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceFloat64V(x.AnonInTestStruc.AF64slice, e)
			} // end block: if x.AnonInTestStruc.AF64slice slice == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"AF32slice\"")
			} else {
				r.EncodeString(`AF32slice`)
			}
			z.EncWriteMapElemValue()
			if x.AnonInTestStruc.AF32slice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceFloat32V(x.AnonInTestStruc.AF32slice, e)
			} // end block: if x.AnonInTestStruc.AF32slice slice == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"AMSU16\"")
			} else {
				r.EncodeString(`AMSU16`)
			}
			z.EncWriteMapElemValue()
			if x.AnonInTestStruc.AMSU16 == nil {
				r.EncodeNil()
			} else {
				h.encMapstringuint16((map[string]uint16)(x.AnonInTestStruc.AMSU16), e)
			} // end block: if x.AnonInTestStruc.AMSU16 map == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"AI64arr0\"")
			} else {
				r.EncodeString(`AI64arr0`)
			}
			z.EncWriteMapElemValue()
			yy155 := &x.AnonInTestStruc.AI64arr0
			h.encArray0int64((*[0]int64)(yy155), e)
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"AI64slice0\"")
			} else {
				r.EncodeString(`AI64slice0`)
			}
			z.EncWriteMapElemValue()
			if x.AnonInTestStruc.AI64slice0 == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceInt64V(x.AnonInTestStruc.AI64slice0, e)
			} // end block: if x.AnonInTestStruc.AI64slice0 slice == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"AUi64sliceN\"")
			} else {
				r.EncodeString(`AUi64sliceN`)
			}
			z.EncWriteMapElemValue()
			if x.AnonInTestStruc.AUi64sliceN == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceUint64V(x.AnonInTestStruc.AUi64sliceN, e)
			} // end block: if x.AnonInTestStruc.AUi64sliceN slice == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"AMSU16N\"")
			} else {
				r.EncodeString(`AMSU16N`)
			}
			z.EncWriteMapElemValue()
			if x.AnonInTestStruc.AMSU16N == nil {
				r.EncodeNil()
			} else {
				h.encMapstringuint16((map[string]uint16)(x.AnonInTestStruc.AMSU16N), e)
			} // end block: if x.AnonInTestStruc.AMSU16N map == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"AMSU16E\"")
			} else {
				r.EncodeString(`AMSU16E`)
			}
			z.EncWriteMapElemValue()
			if x.AnonInTestStruc.AMSU16E == nil {
				r.EncodeNil()
			} else {
				h.encMapstringuint16((map[string]uint16)(x.AnonInTestStruc.AMSU16E), e)
			} // end block: if x.AnonInTestStruc.AMSU16E map == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"NotAnon\"")
			} else {
				r.EncodeString(`NotAnon`)
			}
			z.EncWriteMapElemValue()
			yy161 := &x.NotAnon
			yy161.CodecEncodeSelf(e)
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"Nmap\"")
			} else {
				r.EncodeString(`Nmap`)
			}
			z.EncWriteMapElemValue()
			if x.Nmap == nil {
				r.EncodeNil()
			} else {
				z.F.EncMapStringBoolV(x.Nmap, e)
			} // end block: if x.Nmap map == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"Nslice\"")
			} else {
				r.EncodeString(`Nslice`)
			}
			z.EncWriteMapElemValue()
			if x.Nslice == nil {
				r.EncodeNil()
			} else {
				r.EncodeStringBytesRaw([]byte(x.Nslice))
			} // end block: if x.Nslice slice == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"Nint64\"")
			} else {
				r.EncodeString(`Nint64`)
			}
			z.EncWriteMapElemValue()
			if yyn54 {
				r.EncodeNil()
			} else {
				yy165 := *x.Nint64
				r.EncodeInt(int64(yy165))
			}
			z.EncWriteMapEnd()
		}
	}
}

func (x *TestStrucCommon) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil19780 {
		*(x) = TestStrucCommon{}
	} else if yyct2 == codecSelferValueTypeMap19780 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray19780 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct19780)
	}
}

func (x *TestStrucCommon) codecDecodeSelfFromMap(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if z.DecCheckBreak() {
				break
			}
		}
		z.DecReadMapElemKey()
		yys3 := z.StringView(r.DecodeStringAsBytes())
		z.DecReadMapElemValue()
		switch yys3 {
		case "S":
			x.S = (string)(string(r.DecodeStringAsBytes()))
		case "I64":
			x.I64 = (int64)(r.DecodeInt64())
		case "I32":
			x.I32 = (int32)(z.C.IntV(r.DecodeInt64(), 32))
		case "I16":
			x.I16 = (int16)(z.C.IntV(r.DecodeInt64(), 16))
		case "I8":
			x.I8 = (int8)(z.C.IntV(r.DecodeInt64(), 8))
		case "I64n":
			x.I64n = (int64)(r.DecodeInt64())
		case "I32n":
			x.I32n = (int32)(z.C.IntV(r.DecodeInt64(), 32))
		case "I16n":
			x.I16n = (int16)(z.C.IntV(r.DecodeInt64(), 16))
		case "I8n":
			x.I8n = (int8)(z.C.IntV(r.DecodeInt64(), 8))
		case "Ui64":
			x.Ui64 = (uint64)(r.DecodeUint64())
		case "Ui32":
			x.Ui32 = (uint32)(z.C.UintV(r.DecodeUint64(), 32))
		case "Ui16":
			x.Ui16 = (uint16)(z.C.UintV(r.DecodeUint64(), 16))
		case "Ui8":
			x.Ui8 = (uint8)(z.C.UintV(r.DecodeUint64(), 8))
		case "F64":
			x.F64 = (float64)(r.DecodeFloat64())
		case "F32":
			x.F32 = (float32)(z.DecDecodeFloat32())
		case "B":
			x.B = (bool)(r.DecodeBool())
		case "By":
			x.By = (uint8)(z.C.UintV(r.DecodeUint64(), 8))
		case "Sslice":
			z.F.DecSliceStringX(&x.Sslice, d)
		case "I64slice":
			z.F.DecSliceInt64X(&x.I64slice, d)
		case "I16slice":
			z.F.DecSliceInt16X(&x.I16slice, d)
		case "Ui64slice":
			z.F.DecSliceUint64X(&x.Ui64slice, d)
		case "Ui8slice":
			x.Ui8slice = r.DecodeBytes(([]byte)(x.Ui8slice), false)
		case "Bslice":
			z.F.DecSliceBoolX(&x.Bslice, d)
		case "Byslice":
			x.Byslice = r.DecodeBytes(([]byte)(x.Byslice), false)
		case "BytesSlice":
			z.F.DecSliceBytesX(&x.BytesSlice, d)
		case "Iptrslice":
			h.decSlicePtrtoint64((*[]*int64)(&x.Iptrslice), d)
		case "WrapSliceInt64":
			x.WrapSliceInt64.CodecDecodeSelf(d)
		case "WrapSliceString":
			x.WrapSliceString.CodecDecodeSelf(d)
		case "Msi64":
			z.F.DecMapStringInt64X(&x.Msi64, d)
		case "Msbytes":
			z.F.DecMapStringBytesX(&x.Msbytes, d)
		case "Simplef":
			x.Simplef.CodecDecodeSelf(d)
		case "SstrUi64T":
			h.decSlicestringUint64T((*[]stringUint64T)(&x.SstrUi64T), d)
		case "MstrUi64T":
			h.decMapstringPtrtostringUint64T((*map[string]*stringUint64T)(&x.MstrUi64T), d)
		case "AS":
			x.AnonInTestStruc.AS = (string)(string(r.DecodeStringAsBytes()))
		case "AI64":
			x.AnonInTestStruc.AI64 = (int64)(r.DecodeInt64())
		case "AI16":
			x.AnonInTestStruc.AI16 = (int16)(z.C.IntV(r.DecodeInt64(), 16))
		case "AUi64":
			x.AnonInTestStruc.AUi64 = (uint64)(r.DecodeUint64())
		case "ASslice":
			z.F.DecSliceStringX(&x.AnonInTestStruc.ASslice, d)
		case "AI64slice":
			z.F.DecSliceInt64X(&x.AnonInTestStruc.AI64slice, d)
		case "AUi64slice":
			z.F.DecSliceUint64X(&x.AnonInTestStruc.AUi64slice, d)
		case "AF64slice":
			z.F.DecSliceFloat64X(&x.AnonInTestStruc.AF64slice, d)
		case "AF32slice":
			z.F.DecSliceFloat32X(&x.AnonInTestStruc.AF32slice, d)
		case "AMSU16":
			h.decMapstringuint16((*map[string]uint16)(&x.AnonInTestStruc.AMSU16), d)
		case "AI64arr0":
			h.decArray0int64((*[0]int64)(&x.AnonInTestStruc.AI64arr0), d)
		case "AI64slice0":
			z.F.DecSliceInt64X(&x.AnonInTestStruc.AI64slice0, d)
		case "AUi64sliceN":
			z.F.DecSliceUint64X(&x.AnonInTestStruc.AUi64sliceN, d)
		case "AMSU16N":
			h.decMapstringuint16((*map[string]uint16)(&x.AnonInTestStruc.AMSU16N), d)
		case "AMSU16E":
			h.decMapstringuint16((*map[string]uint16)(&x.AnonInTestStruc.AMSU16E), d)
		case "NotAnon":
			x.NotAnon.CodecDecodeSelf(d)
		case "Nmap":
			z.F.DecMapStringBoolX(&x.Nmap, d)
		case "Nslice":
			x.Nslice = r.DecodeBytes(([]byte)(x.Nslice), false)
		case "Nint64":
			if r.TryNil() {
				if x.Nint64 != nil { // remove the if-true
					x.Nint64 = nil
				}
			} else {
				if x.Nint64 == nil {
					x.Nint64 = new(int64)
				}
				*x.Nint64 = (int64)(r.DecodeInt64())
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
}

func (x *TestStrucCommon) codecDecodeSelfFromArray(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj83 int
	var yyb83 bool
	var yyhl83 bool = l >= 0
	yyj83++
	if yyhl83 {
		yyb83 = yyj83 > l
	} else {
		yyb83 = z.DecCheckBreak()
	}
	if yyb83 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.S = (string)(string(r.DecodeStringAsBytes()))
	yyj83++
	if yyhl83 {
		yyb83 = yyj83 > l
	} else {
		yyb83 = z.DecCheckBreak()
	}
	if yyb83 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.I64 = (int64)(r.DecodeInt64())
	yyj83++
	if yyhl83 {
		yyb83 = yyj83 > l
	} else {
		yyb83 = z.DecCheckBreak()
	}
	if yyb83 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.I32 = (int32)(z.C.IntV(r.DecodeInt64(), 32))
	yyj83++
	if yyhl83 {
		yyb83 = yyj83 > l
	} else {
		yyb83 = z.DecCheckBreak()
	}
	if yyb83 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.I16 = (int16)(z.C.IntV(r.DecodeInt64(), 16))
	yyj83++
	if yyhl83 {
		yyb83 = yyj83 > l
	} else {
		yyb83 = z.DecCheckBreak()
	}
	if yyb83 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.I8 = (int8)(z.C.IntV(r.DecodeInt64(), 8))
	yyj83++
	if yyhl83 {
		yyb83 = yyj83 > l
	} else {
		yyb83 = z.DecCheckBreak()
	}
	if yyb83 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.I64n = (int64)(r.DecodeInt64())
	yyj83++
	if yyhl83 {
		yyb83 = yyj83 > l
	} else {
		yyb83 = z.DecCheckBreak()
	}
	if yyb83 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.I32n = (int32)(z.C.IntV(r.DecodeInt64(), 32))
	yyj83++
	if yyhl83 {
		yyb83 = yyj83 > l
	} else {
		yyb83 = z.DecCheckBreak()
	}
	if yyb83 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.I16n = (int16)(z.C.IntV(r.DecodeInt64(), 16))
	yyj83++
	if yyhl83 {
		yyb83 = yyj83 > l
	} else {
		yyb83 = z.DecCheckBreak()
	}
	if yyb83 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.I8n = (int8)(z.C.IntV(r.DecodeInt64(), 8))
	yyj83++
	if yyhl83 {
		yyb83 = yyj83 > l
	} else {
		yyb83 = z.DecCheckBreak()
	}
	if yyb83 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.Ui64 = (uint64)(r.DecodeUint64())
	yyj83++
	if yyhl83 {
		yyb83 = yyj83 > l
	} else {
		yyb83 = z.DecCheckBreak()
	}
	if yyb83 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.Ui32 = (uint32)(z.C.UintV(r.DecodeUint64(), 32))
	yyj83++
	if yyhl83 {
		yyb83 = yyj83 > l
	} else {
		yyb83 = z.DecCheckBreak()
	}
	if yyb83 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.Ui16 = (uint16)(z.C.UintV(r.DecodeUint64(), 16))
	yyj83++
	if yyhl83 {
		yyb83 = yyj83 > l
	} else {
		yyb83 = z.DecCheckBreak()
	}
	if yyb83 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.Ui8 = (uint8)(z.C.UintV(r.DecodeUint64(), 8))
	yyj83++
	if yyhl83 {
		yyb83 = yyj83 > l
	} else {
		yyb83 = z.DecCheckBreak()
	}
	if yyb83 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.F64 = (float64)(r.DecodeFloat64())
	yyj83++
	if yyhl83 {
		yyb83 = yyj83 > l
	} else {
		yyb83 = z.DecCheckBreak()
	}
	if yyb83 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.F32 = (float32)(z.DecDecodeFloat32())
	yyj83++
	if yyhl83 {
		yyb83 = yyj83 > l
	} else {
		yyb83 = z.DecCheckBreak()
	}
	if yyb83 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.B = (bool)(r.DecodeBool())
	yyj83++
	if yyhl83 {
		yyb83 = yyj83 > l
	} else {
		yyb83 = z.DecCheckBreak()
	}
	if yyb83 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.By = (uint8)(z.C.UintV(r.DecodeUint64(), 8))
	yyj83++
	if yyhl83 {
		yyb83 = yyj83 > l
	} else {
		yyb83 = z.DecCheckBreak()
	}
	if yyb83 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceStringX(&x.Sslice, d)
	yyj83++
	if yyhl83 {
		yyb83 = yyj83 > l
	} else {
		yyb83 = z.DecCheckBreak()
	}
	if yyb83 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceInt64X(&x.I64slice, d)
	yyj83++
	if yyhl83 {
		yyb83 = yyj83 > l
	} else {
		yyb83 = z.DecCheckBreak()
	}
	if yyb83 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceInt16X(&x.I16slice, d)
	yyj83++
	if yyhl83 {
		yyb83 = yyj83 > l
	} else {
		yyb83 = z.DecCheckBreak()
	}
	if yyb83 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceUint64X(&x.Ui64slice, d)
	yyj83++
	if yyhl83 {
		yyb83 = yyj83 > l
	} else {
		yyb83 = z.DecCheckBreak()
	}
	if yyb83 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.Ui8slice = r.DecodeBytes(([]byte)(x.Ui8slice), false)
	yyj83++
	if yyhl83 {
		yyb83 = yyj83 > l
	} else {
		yyb83 = z.DecCheckBreak()
	}
	if yyb83 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceBoolX(&x.Bslice, d)
	yyj83++
	if yyhl83 {
		yyb83 = yyj83 > l
	} else {
		yyb83 = z.DecCheckBreak()
	}
	if yyb83 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.Byslice = r.DecodeBytes(([]byte)(x.Byslice), false)
	yyj83++
	if yyhl83 {
		yyb83 = yyj83 > l
	} else {
		yyb83 = z.DecCheckBreak()
	}
	if yyb83 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceBytesX(&x.BytesSlice, d)
	yyj83++
	if yyhl83 {
		yyb83 = yyj83 > l
	} else {
		yyb83 = z.DecCheckBreak()
	}
	if yyb83 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decSlicePtrtoint64((*[]*int64)(&x.Iptrslice), d)
	yyj83++
	if yyhl83 {
		yyb83 = yyj83 > l
	} else {
		yyb83 = z.DecCheckBreak()
	}
	if yyb83 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.WrapSliceInt64.CodecDecodeSelf(d)
	yyj83++
	if yyhl83 {
		yyb83 = yyj83 > l
	} else {
		yyb83 = z.DecCheckBreak()
	}
	if yyb83 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.WrapSliceString.CodecDecodeSelf(d)
	yyj83++
	if yyhl83 {
		yyb83 = yyj83 > l
	} else {
		yyb83 = z.DecCheckBreak()
	}
	if yyb83 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecMapStringInt64X(&x.Msi64, d)
	yyj83++
	if yyhl83 {
		yyb83 = yyj83 > l
	} else {
		yyb83 = z.DecCheckBreak()
	}
	if yyb83 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecMapStringBytesX(&x.Msbytes, d)
	yyj83++
	if yyhl83 {
		yyb83 = yyj83 > l
	} else {
		yyb83 = z.DecCheckBreak()
	}
	if yyb83 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.Simplef.CodecDecodeSelf(d)
	yyj83++
	if yyhl83 {
		yyb83 = yyj83 > l
	} else {
		yyb83 = z.DecCheckBreak()
	}
	if yyb83 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decSlicestringUint64T((*[]stringUint64T)(&x.SstrUi64T), d)
	yyj83++
	if yyhl83 {
		yyb83 = yyj83 > l
	} else {
		yyb83 = z.DecCheckBreak()
	}
	if yyb83 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decMapstringPtrtostringUint64T((*map[string]*stringUint64T)(&x.MstrUi64T), d)
	yyj83++
	if yyhl83 {
		yyb83 = yyj83 > l
	} else {
		yyb83 = z.DecCheckBreak()
	}
	if yyb83 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.AnonInTestStruc.AS = (string)(string(r.DecodeStringAsBytes()))
	yyj83++
	if yyhl83 {
		yyb83 = yyj83 > l
	} else {
		yyb83 = z.DecCheckBreak()
	}
	if yyb83 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.AnonInTestStruc.AI64 = (int64)(r.DecodeInt64())
	yyj83++
	if yyhl83 {
		yyb83 = yyj83 > l
	} else {
		yyb83 = z.DecCheckBreak()
	}
	if yyb83 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.AnonInTestStruc.AI16 = (int16)(z.C.IntV(r.DecodeInt64(), 16))
	yyj83++
	if yyhl83 {
		yyb83 = yyj83 > l
	} else {
		yyb83 = z.DecCheckBreak()
	}
	if yyb83 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.AnonInTestStruc.AUi64 = (uint64)(r.DecodeUint64())
	yyj83++
	if yyhl83 {
		yyb83 = yyj83 > l
	} else {
		yyb83 = z.DecCheckBreak()
	}
	if yyb83 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceStringX(&x.AnonInTestStruc.ASslice, d)
	yyj83++
	if yyhl83 {
		yyb83 = yyj83 > l
	} else {
		yyb83 = z.DecCheckBreak()
	}
	if yyb83 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceInt64X(&x.AnonInTestStruc.AI64slice, d)
	yyj83++
	if yyhl83 {
		yyb83 = yyj83 > l
	} else {
		yyb83 = z.DecCheckBreak()
	}
	if yyb83 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceUint64X(&x.AnonInTestStruc.AUi64slice, d)
	yyj83++
	if yyhl83 {
		yyb83 = yyj83 > l
	} else {
		yyb83 = z.DecCheckBreak()
	}
	if yyb83 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceFloat64X(&x.AnonInTestStruc.AF64slice, d)
	yyj83++
	if yyhl83 {
		yyb83 = yyj83 > l
	} else {
		yyb83 = z.DecCheckBreak()
	}
	if yyb83 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceFloat32X(&x.AnonInTestStruc.AF32slice, d)
	yyj83++
	if yyhl83 {
		yyb83 = yyj83 > l
	} else {
		yyb83 = z.DecCheckBreak()
	}
	if yyb83 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decMapstringuint16((*map[string]uint16)(&x.AnonInTestStruc.AMSU16), d)
	yyj83++
	if yyhl83 {
		yyb83 = yyj83 > l
	} else {
		yyb83 = z.DecCheckBreak()
	}
	if yyb83 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decArray0int64((*[0]int64)(&x.AnonInTestStruc.AI64arr0), d)
	yyj83++
	if yyhl83 {
		yyb83 = yyj83 > l
	} else {
		yyb83 = z.DecCheckBreak()
	}
	if yyb83 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceInt64X(&x.AnonInTestStruc.AI64slice0, d)
	yyj83++
	if yyhl83 {
		yyb83 = yyj83 > l
	} else {
		yyb83 = z.DecCheckBreak()
	}
	if yyb83 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceUint64X(&x.AnonInTestStruc.AUi64sliceN, d)
	yyj83++
	if yyhl83 {
		yyb83 = yyj83 > l
	} else {
		yyb83 = z.DecCheckBreak()
	}
	if yyb83 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decMapstringuint16((*map[string]uint16)(&x.AnonInTestStruc.AMSU16N), d)
	yyj83++
	if yyhl83 {
		yyb83 = yyj83 > l
	} else {
		yyb83 = z.DecCheckBreak()
	}
	if yyb83 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decMapstringuint16((*map[string]uint16)(&x.AnonInTestStruc.AMSU16E), d)
	yyj83++
	if yyhl83 {
		yyb83 = yyj83 > l
	} else {
		yyb83 = z.DecCheckBreak()
	}
	if yyb83 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.NotAnon.CodecDecodeSelf(d)
	yyj83++
	if yyhl83 {
		yyb83 = yyj83 > l
	} else {
		yyb83 = z.DecCheckBreak()
	}
	if yyb83 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecMapStringBoolX(&x.Nmap, d)
	yyj83++
	if yyhl83 {
		yyb83 = yyj83 > l
	} else {
		yyb83 = z.DecCheckBreak()
	}
	if yyb83 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.Nslice = r.DecodeBytes(([]byte)(x.Nslice), false)
	yyj83++
	if yyhl83 {
		yyb83 = yyj83 > l
	} else {
		yyb83 = z.DecCheckBreak()
	}
	if yyb83 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if r.TryNil() {
		if x.Nint64 != nil { // remove the if-true
			x.Nint64 = nil
		}
	} else {
		if x.Nint64 == nil {
			x.Nint64 = new(int64)
		}
		*x.Nint64 = (int64)(r.DecodeInt64())
	}
	for {
		yyj83++
		if yyhl83 {
			yyb83 = yyj83 > l
		} else {
			yyb83 = z.DecCheckBreak()
		}
		if yyb83 {
			break
		}
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj83-1, "")
	}
}

func (x *TestStruc) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yysep2 := !z.EncBinary()
		yy2arr2 := z.EncBasicHandle().StructToArray
		_, _ = yysep2, yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		var yyn54 bool = x.TestStrucCommon.Nint64 == nil
		var yyn58 bool = x.Nteststruc == nil
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(56)
			z.EncWriteArrayElem()
			r.EncodeString(string(x.TestStrucCommon.S))
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.TestStrucCommon.I64))
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.TestStrucCommon.I32))
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.TestStrucCommon.I16))
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.TestStrucCommon.I8))
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.TestStrucCommon.I64n))
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.TestStrucCommon.I32n))
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.TestStrucCommon.I16n))
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.TestStrucCommon.I8n))
			z.EncWriteArrayElem()
			r.EncodeUint(uint64(x.TestStrucCommon.Ui64))
			z.EncWriteArrayElem()
			r.EncodeUint(uint64(x.TestStrucCommon.Ui32))
			z.EncWriteArrayElem()
			r.EncodeUint(uint64(x.TestStrucCommon.Ui16))
			z.EncWriteArrayElem()
			r.EncodeUint(uint64(x.TestStrucCommon.Ui8))
			z.EncWriteArrayElem()
			r.EncodeFloat64(float64(x.TestStrucCommon.F64))
			z.EncWriteArrayElem()
			r.EncodeFloat32(float32(x.TestStrucCommon.F32))
			z.EncWriteArrayElem()
			r.EncodeBool(bool(x.TestStrucCommon.B))
			z.EncWriteArrayElem()
			r.EncodeUint(uint64(x.TestStrucCommon.By))
			z.EncWriteArrayElem()
			if x.TestStrucCommon.Sslice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceStringV(x.TestStrucCommon.Sslice, e)
			} // end block: if x.TestStrucCommon.Sslice slice == nil
			z.EncWriteArrayElem()
			if x.TestStrucCommon.I64slice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceInt64V(x.TestStrucCommon.I64slice, e)
			} // end block: if x.TestStrucCommon.I64slice slice == nil
			z.EncWriteArrayElem()
			if x.TestStrucCommon.I16slice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceInt16V(x.TestStrucCommon.I16slice, e)
			} // end block: if x.TestStrucCommon.I16slice slice == nil
			z.EncWriteArrayElem()
			if x.TestStrucCommon.Ui64slice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceUint64V(x.TestStrucCommon.Ui64slice, e)
			} // end block: if x.TestStrucCommon.Ui64slice slice == nil
			z.EncWriteArrayElem()
			if x.TestStrucCommon.Ui8slice == nil {
				r.EncodeNil()
			} else {
				r.EncodeStringBytesRaw([]byte(x.TestStrucCommon.Ui8slice))
			} // end block: if x.TestStrucCommon.Ui8slice slice == nil
			z.EncWriteArrayElem()
			if x.TestStrucCommon.Bslice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceBoolV(x.TestStrucCommon.Bslice, e)
			} // end block: if x.TestStrucCommon.Bslice slice == nil
			z.EncWriteArrayElem()
			if x.TestStrucCommon.Byslice == nil {
				r.EncodeNil()
			} else {
				r.EncodeStringBytesRaw([]byte(x.TestStrucCommon.Byslice))
			} // end block: if x.TestStrucCommon.Byslice slice == nil
			z.EncWriteArrayElem()
			if x.TestStrucCommon.BytesSlice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceBytesV(x.TestStrucCommon.BytesSlice, e)
			} // end block: if x.TestStrucCommon.BytesSlice slice == nil
			z.EncWriteArrayElem()
			if x.TestStrucCommon.Iptrslice == nil {
				r.EncodeNil()
			} else {
				h.encSlicePtrtoint64(([]*int64)(x.TestStrucCommon.Iptrslice), e)
			} // end block: if x.TestStrucCommon.Iptrslice slice == nil
			z.EncWriteArrayElem()
			x.TestStrucCommon.WrapSliceInt64.CodecEncodeSelf(e)
			z.EncWriteArrayElem()
			x.TestStrucCommon.WrapSliceString.CodecEncodeSelf(e)
			z.EncWriteArrayElem()
			if x.TestStrucCommon.Msi64 == nil {
				r.EncodeNil()
			} else {
				z.F.EncMapStringInt64V(x.TestStrucCommon.Msi64, e)
			} // end block: if x.TestStrucCommon.Msi64 map == nil
			z.EncWriteArrayElem()
			if x.TestStrucCommon.Msbytes == nil {
				r.EncodeNil()
			} else {
				z.F.EncMapStringBytesV(x.TestStrucCommon.Msbytes, e)
			} // end block: if x.TestStrucCommon.Msbytes map == nil
			z.EncWriteArrayElem()
			yy89 := &x.TestStrucCommon.Simplef
			yy89.CodecEncodeSelf(e)
			z.EncWriteArrayElem()
			if x.TestStrucCommon.SstrUi64T == nil {
				r.EncodeNil()
			} else {
				h.encSlicestringUint64T(([]stringUint64T)(x.TestStrucCommon.SstrUi64T), e)
			} // end block: if x.TestStrucCommon.SstrUi64T slice == nil
			z.EncWriteArrayElem()
			if x.TestStrucCommon.MstrUi64T == nil {
				r.EncodeNil()
			} else {
				h.encMapstringPtrtostringUint64T((map[string]*stringUint64T)(x.TestStrucCommon.MstrUi64T), e)
			} // end block: if x.TestStrucCommon.MstrUi64T map == nil
			z.EncWriteArrayElem()
			r.EncodeString(string(x.TestStrucCommon.AnonInTestStruc.AS))
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.TestStrucCommon.AnonInTestStruc.AI64))
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.TestStrucCommon.AnonInTestStruc.AI16))
			z.EncWriteArrayElem()
			r.EncodeUint(uint64(x.TestStrucCommon.AnonInTestStruc.AUi64))
			z.EncWriteArrayElem()
			if x.TestStrucCommon.AnonInTestStruc.ASslice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceStringV(x.TestStrucCommon.AnonInTestStruc.ASslice, e)
			} // end block: if x.TestStrucCommon.AnonInTestStruc.ASslice slice == nil
			z.EncWriteArrayElem()
			if x.TestStrucCommon.AnonInTestStruc.AI64slice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceInt64V(x.TestStrucCommon.AnonInTestStruc.AI64slice, e)
			} // end block: if x.TestStrucCommon.AnonInTestStruc.AI64slice slice == nil
			z.EncWriteArrayElem()
			if x.TestStrucCommon.AnonInTestStruc.AUi64slice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceUint64V(x.TestStrucCommon.AnonInTestStruc.AUi64slice, e)
			} // end block: if x.TestStrucCommon.AnonInTestStruc.AUi64slice slice == nil
			z.EncWriteArrayElem()
			if x.TestStrucCommon.AnonInTestStruc.AF64slice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceFloat64V(x.TestStrucCommon.AnonInTestStruc.AF64slice, e)
			} // end block: if x.TestStrucCommon.AnonInTestStruc.AF64slice slice == nil
			z.EncWriteArrayElem()
			if x.TestStrucCommon.AnonInTestStruc.AF32slice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceFloat32V(x.TestStrucCommon.AnonInTestStruc.AF32slice, e)
			} // end block: if x.TestStrucCommon.AnonInTestStruc.AF32slice slice == nil
			z.EncWriteArrayElem()
			if x.TestStrucCommon.AnonInTestStruc.AMSU16 == nil {
				r.EncodeNil()
			} else {
				h.encMapstringuint16((map[string]uint16)(x.TestStrucCommon.AnonInTestStruc.AMSU16), e)
			} // end block: if x.TestStrucCommon.AnonInTestStruc.AMSU16 map == nil
			z.EncWriteArrayElem()
			yy103 := &x.TestStrucCommon.AnonInTestStruc.AI64arr0
			h.encArray0int64((*[0]int64)(yy103), e)
			z.EncWriteArrayElem()
			if x.TestStrucCommon.AnonInTestStruc.AI64slice0 == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceInt64V(x.TestStrucCommon.AnonInTestStruc.AI64slice0, e)
			} // end block: if x.TestStrucCommon.AnonInTestStruc.AI64slice0 slice == nil
			z.EncWriteArrayElem()
			if x.TestStrucCommon.AnonInTestStruc.AUi64sliceN == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceUint64V(x.TestStrucCommon.AnonInTestStruc.AUi64sliceN, e)
			} // end block: if x.TestStrucCommon.AnonInTestStruc.AUi64sliceN slice == nil
			z.EncWriteArrayElem()
			if x.TestStrucCommon.AnonInTestStruc.AMSU16N == nil {
				r.EncodeNil()
			} else {
				h.encMapstringuint16((map[string]uint16)(x.TestStrucCommon.AnonInTestStruc.AMSU16N), e)
			} // end block: if x.TestStrucCommon.AnonInTestStruc.AMSU16N map == nil
			z.EncWriteArrayElem()
			if x.TestStrucCommon.AnonInTestStruc.AMSU16E == nil {
				r.EncodeNil()
			} else {
				h.encMapstringuint16((map[string]uint16)(x.TestStrucCommon.AnonInTestStruc.AMSU16E), e)
			} // end block: if x.TestStrucCommon.AnonInTestStruc.AMSU16E map == nil
			z.EncWriteArrayElem()
			yy109 := &x.TestStrucCommon.NotAnon
			yy109.CodecEncodeSelf(e)
			z.EncWriteArrayElem()
			if x.TestStrucCommon.Nmap == nil {
				r.EncodeNil()
			} else {
				z.F.EncMapStringBoolV(x.TestStrucCommon.Nmap, e)
			} // end block: if x.TestStrucCommon.Nmap map == nil
			z.EncWriteArrayElem()
			if x.TestStrucCommon.Nslice == nil {
				r.EncodeNil()
			} else {
				r.EncodeStringBytesRaw([]byte(x.TestStrucCommon.Nslice))
			} // end block: if x.TestStrucCommon.Nslice slice == nil
			if yyn54 {
				z.EncWriteArrayElem()
				r.EncodeNil()
			} else {
				z.EncWriteArrayElem()
				yy113 := *x.TestStrucCommon.Nint64
				r.EncodeInt(int64(yy113))
			}
			z.EncWriteArrayElem()
			if x.Mtsptr == nil {
				r.EncodeNil()
			} else {
				h.encMapstringPtrtoTestStruc((map[string]*TestStruc)(x.Mtsptr), e)
			} // end block: if x.Mtsptr map == nil
			z.EncWriteArrayElem()
			if x.Mts == nil {
				r.EncodeNil()
			} else {
				h.encMapstringTestStruc((map[string]TestStruc)(x.Mts), e)
			} // end block: if x.Mts map == nil
			z.EncWriteArrayElem()
			if x.Its == nil {
				r.EncodeNil()
			} else {
				h.encSlicePtrtoTestStruc(([]*TestStruc)(x.Its), e)
			} // end block: if x.Its slice == nil
			if yyn58 {
				z.EncWriteArrayElem()
				r.EncodeNil()
			} else {
				z.EncWriteArrayElem()
				x.Nteststruc.CodecEncodeSelf(e)
			}
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(56)
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"S\"")
			} else {
				r.EncodeString(`S`)
			}
			z.EncWriteMapElemValue()
			r.EncodeString(string(x.TestStrucCommon.S))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"I64\"")
			} else {
				r.EncodeString(`I64`)
			}
			z.EncWriteMapElemValue()
			r.EncodeInt(int64(x.TestStrucCommon.I64))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"I32\"")
			} else {
				r.EncodeString(`I32`)
			}
			z.EncWriteMapElemValue()
			r.EncodeInt(int64(x.TestStrucCommon.I32))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"I16\"")
			} else {
				r.EncodeString(`I16`)
			}
			z.EncWriteMapElemValue()
			r.EncodeInt(int64(x.TestStrucCommon.I16))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"I8\"")
			} else {
				r.EncodeString(`I8`)
			}
			z.EncWriteMapElemValue()
			r.EncodeInt(int64(x.TestStrucCommon.I8))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"I64n\"")
			} else {
				r.EncodeString(`I64n`)
			}
			z.EncWriteMapElemValue()
			r.EncodeInt(int64(x.TestStrucCommon.I64n))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"I32n\"")
			} else {
				r.EncodeString(`I32n`)
			}
			z.EncWriteMapElemValue()
			r.EncodeInt(int64(x.TestStrucCommon.I32n))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"I16n\"")
			} else {
				r.EncodeString(`I16n`)
			}
			z.EncWriteMapElemValue()
			r.EncodeInt(int64(x.TestStrucCommon.I16n))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"I8n\"")
			} else {
				r.EncodeString(`I8n`)
			}
			z.EncWriteMapElemValue()
			r.EncodeInt(int64(x.TestStrucCommon.I8n))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"Ui64\"")
			} else {
				r.EncodeString(`Ui64`)
			}
			z.EncWriteMapElemValue()
			r.EncodeUint(uint64(x.TestStrucCommon.Ui64))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"Ui32\"")
			} else {
				r.EncodeString(`Ui32`)
			}
			z.EncWriteMapElemValue()
			r.EncodeUint(uint64(x.TestStrucCommon.Ui32))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"Ui16\"")
			} else {
				r.EncodeString(`Ui16`)
			}
			z.EncWriteMapElemValue()
			r.EncodeUint(uint64(x.TestStrucCommon.Ui16))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"Ui8\"")
			} else {
				r.EncodeString(`Ui8`)
			}
			z.EncWriteMapElemValue()
			r.EncodeUint(uint64(x.TestStrucCommon.Ui8))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"F64\"")
			} else {
				r.EncodeString(`F64`)
			}
			z.EncWriteMapElemValue()
			r.EncodeFloat64(float64(x.TestStrucCommon.F64))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"F32\"")
			} else {
				r.EncodeString(`F32`)
			}
			z.EncWriteMapElemValue()
			r.EncodeFloat32(float32(x.TestStrucCommon.F32))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"B\"")
			} else {
				r.EncodeString(`B`)
			}
			z.EncWriteMapElemValue()
			r.EncodeBool(bool(x.TestStrucCommon.B))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"By\"")
			} else {
				r.EncodeString(`By`)
			}
			z.EncWriteMapElemValue()
			r.EncodeUint(uint64(x.TestStrucCommon.By))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"Sslice\"")
			} else {
				r.EncodeString(`Sslice`)
			}
			z.EncWriteMapElemValue()
			if x.TestStrucCommon.Sslice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceStringV(x.TestStrucCommon.Sslice, e)
			} // end block: if x.TestStrucCommon.Sslice slice == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"I64slice\"")
			} else {
				r.EncodeString(`I64slice`)
			}
			z.EncWriteMapElemValue()
			if x.TestStrucCommon.I64slice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceInt64V(x.TestStrucCommon.I64slice, e)
			} // end block: if x.TestStrucCommon.I64slice slice == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"I16slice\"")
			} else {
				r.EncodeString(`I16slice`)
			}
			z.EncWriteMapElemValue()
			if x.TestStrucCommon.I16slice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceInt16V(x.TestStrucCommon.I16slice, e)
			} // end block: if x.TestStrucCommon.I16slice slice == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"Ui64slice\"")
			} else {
				r.EncodeString(`Ui64slice`)
			}
			z.EncWriteMapElemValue()
			if x.TestStrucCommon.Ui64slice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceUint64V(x.TestStrucCommon.Ui64slice, e)
			} // end block: if x.TestStrucCommon.Ui64slice slice == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"Ui8slice\"")
			} else {
				r.EncodeString(`Ui8slice`)
			}
			z.EncWriteMapElemValue()
			if x.TestStrucCommon.Ui8slice == nil {
				r.EncodeNil()
			} else {
				r.EncodeStringBytesRaw([]byte(x.TestStrucCommon.Ui8slice))
			} // end block: if x.TestStrucCommon.Ui8slice slice == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"Bslice\"")
			} else {
				r.EncodeString(`Bslice`)
			}
			z.EncWriteMapElemValue()
			if x.TestStrucCommon.Bslice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceBoolV(x.TestStrucCommon.Bslice, e)
			} // end block: if x.TestStrucCommon.Bslice slice == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"Byslice\"")
			} else {
				r.EncodeString(`Byslice`)
			}
			z.EncWriteMapElemValue()
			if x.TestStrucCommon.Byslice == nil {
				r.EncodeNil()
			} else {
				r.EncodeStringBytesRaw([]byte(x.TestStrucCommon.Byslice))
			} // end block: if x.TestStrucCommon.Byslice slice == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"BytesSlice\"")
			} else {
				r.EncodeString(`BytesSlice`)
			}
			z.EncWriteMapElemValue()
			if x.TestStrucCommon.BytesSlice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceBytesV(x.TestStrucCommon.BytesSlice, e)
			} // end block: if x.TestStrucCommon.BytesSlice slice == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"Iptrslice\"")
			} else {
				r.EncodeString(`Iptrslice`)
			}
			z.EncWriteMapElemValue()
			if x.TestStrucCommon.Iptrslice == nil {
				r.EncodeNil()
			} else {
				h.encSlicePtrtoint64(([]*int64)(x.TestStrucCommon.Iptrslice), e)
			} // end block: if x.TestStrucCommon.Iptrslice slice == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"WrapSliceInt64\"")
			} else {
				r.EncodeString(`WrapSliceInt64`)
			}
			z.EncWriteMapElemValue()
			x.TestStrucCommon.WrapSliceInt64.CodecEncodeSelf(e)
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"WrapSliceString\"")
			} else {
				r.EncodeString(`WrapSliceString`)
			}
			z.EncWriteMapElemValue()
			x.TestStrucCommon.WrapSliceString.CodecEncodeSelf(e)
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"Msi64\"")
			} else {
				r.EncodeString(`Msi64`)
			}
			z.EncWriteMapElemValue()
			if x.TestStrucCommon.Msi64 == nil {
				r.EncodeNil()
			} else {
				z.F.EncMapStringInt64V(x.TestStrucCommon.Msi64, e)
			} // end block: if x.TestStrucCommon.Msi64 map == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"Msbytes\"")
			} else {
				r.EncodeString(`Msbytes`)
			}
			z.EncWriteMapElemValue()
			if x.TestStrucCommon.Msbytes == nil {
				r.EncodeNil()
			} else {
				z.F.EncMapStringBytesV(x.TestStrucCommon.Msbytes, e)
			} // end block: if x.TestStrucCommon.Msbytes map == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"Simplef\"")
			} else {
				r.EncodeString(`Simplef`)
			}
			z.EncWriteMapElemValue()
			yy149 := &x.TestStrucCommon.Simplef
			yy149.CodecEncodeSelf(e)
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"SstrUi64T\"")
			} else {
				r.EncodeString(`SstrUi64T`)
			}
			z.EncWriteMapElemValue()
			if x.TestStrucCommon.SstrUi64T == nil {
				r.EncodeNil()
			} else {
				h.encSlicestringUint64T(([]stringUint64T)(x.TestStrucCommon.SstrUi64T), e)
			} // end block: if x.TestStrucCommon.SstrUi64T slice == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"MstrUi64T\"")
			} else {
				r.EncodeString(`MstrUi64T`)
			}
			z.EncWriteMapElemValue()
			if x.TestStrucCommon.MstrUi64T == nil {
				r.EncodeNil()
			} else {
				h.encMapstringPtrtostringUint64T((map[string]*stringUint64T)(x.TestStrucCommon.MstrUi64T), e)
			} // end block: if x.TestStrucCommon.MstrUi64T map == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"AS\"")
			} else {
				r.EncodeString(`AS`)
			}
			z.EncWriteMapElemValue()
			r.EncodeString(string(x.TestStrucCommon.AnonInTestStruc.AS))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"AI64\"")
			} else {
				r.EncodeString(`AI64`)
			}
			z.EncWriteMapElemValue()
			r.EncodeInt(int64(x.TestStrucCommon.AnonInTestStruc.AI64))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"AI16\"")
			} else {
				r.EncodeString(`AI16`)
			}
			z.EncWriteMapElemValue()
			r.EncodeInt(int64(x.TestStrucCommon.AnonInTestStruc.AI16))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"AUi64\"")
			} else {
				r.EncodeString(`AUi64`)
			}
			z.EncWriteMapElemValue()
			r.EncodeUint(uint64(x.TestStrucCommon.AnonInTestStruc.AUi64))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"ASslice\"")
			} else {
				r.EncodeString(`ASslice`)
			}
			z.EncWriteMapElemValue()
			if x.TestStrucCommon.AnonInTestStruc.ASslice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceStringV(x.TestStrucCommon.AnonInTestStruc.ASslice, e)
			} // end block: if x.TestStrucCommon.AnonInTestStruc.ASslice slice == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"AI64slice\"")
			} else {
				r.EncodeString(`AI64slice`)
			}
			z.EncWriteMapElemValue()
			if x.TestStrucCommon.AnonInTestStruc.AI64slice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceInt64V(x.TestStrucCommon.AnonInTestStruc.AI64slice, e)
			} // end block: if x.TestStrucCommon.AnonInTestStruc.AI64slice slice == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"AUi64slice\"")
			} else {
				r.EncodeString(`AUi64slice`)
			}
			z.EncWriteMapElemValue()
			if x.TestStrucCommon.AnonInTestStruc.AUi64slice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceUint64V(x.TestStrucCommon.AnonInTestStruc.AUi64slice, e)
			} // end block: if x.TestStrucCommon.AnonInTestStruc.AUi64slice slice == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"AF64slice\"")
			} else {
				r.EncodeString(`AF64slice`)
			}
			z.EncWriteMapElemValue()
			if x.TestStrucCommon.AnonInTestStruc.AF64slice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceFloat64V(x.TestStrucCommon.AnonInTestStruc.AF64slice, e)
			} // end block: if x.TestStrucCommon.AnonInTestStruc.AF64slice slice == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"AF32slice\"")
			} else {
				r.EncodeString(`AF32slice`)
			}
			z.EncWriteMapElemValue()
			if x.TestStrucCommon.AnonInTestStruc.AF32slice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceFloat32V(x.TestStrucCommon.AnonInTestStruc.AF32slice, e)
			} // end block: if x.TestStrucCommon.AnonInTestStruc.AF32slice slice == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"AMSU16\"")
			} else {
				r.EncodeString(`AMSU16`)
			}
			z.EncWriteMapElemValue()
			if x.TestStrucCommon.AnonInTestStruc.AMSU16 == nil {
				r.EncodeNil()
			} else {
				h.encMapstringuint16((map[string]uint16)(x.TestStrucCommon.AnonInTestStruc.AMSU16), e)
			} // end block: if x.TestStrucCommon.AnonInTestStruc.AMSU16 map == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"AI64arr0\"")
			} else {
				r.EncodeString(`AI64arr0`)
			}
			z.EncWriteMapElemValue()
			yy163 := &x.TestStrucCommon.AnonInTestStruc.AI64arr0
			h.encArray0int64((*[0]int64)(yy163), e)
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"AI64slice0\"")
			} else {
				r.EncodeString(`AI64slice0`)
			}
			z.EncWriteMapElemValue()
			if x.TestStrucCommon.AnonInTestStruc.AI64slice0 == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceInt64V(x.TestStrucCommon.AnonInTestStruc.AI64slice0, e)
			} // end block: if x.TestStrucCommon.AnonInTestStruc.AI64slice0 slice == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"AUi64sliceN\"")
			} else {
				r.EncodeString(`AUi64sliceN`)
			}
			z.EncWriteMapElemValue()
			if x.TestStrucCommon.AnonInTestStruc.AUi64sliceN == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceUint64V(x.TestStrucCommon.AnonInTestStruc.AUi64sliceN, e)
			} // end block: if x.TestStrucCommon.AnonInTestStruc.AUi64sliceN slice == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"AMSU16N\"")
			} else {
				r.EncodeString(`AMSU16N`)
			}
			z.EncWriteMapElemValue()
			if x.TestStrucCommon.AnonInTestStruc.AMSU16N == nil {
				r.EncodeNil()
			} else {
				h.encMapstringuint16((map[string]uint16)(x.TestStrucCommon.AnonInTestStruc.AMSU16N), e)
			} // end block: if x.TestStrucCommon.AnonInTestStruc.AMSU16N map == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"AMSU16E\"")
			} else {
				r.EncodeString(`AMSU16E`)
			}
			z.EncWriteMapElemValue()
			if x.TestStrucCommon.AnonInTestStruc.AMSU16E == nil {
				r.EncodeNil()
			} else {
				h.encMapstringuint16((map[string]uint16)(x.TestStrucCommon.AnonInTestStruc.AMSU16E), e)
			} // end block: if x.TestStrucCommon.AnonInTestStruc.AMSU16E map == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"NotAnon\"")
			} else {
				r.EncodeString(`NotAnon`)
			}
			z.EncWriteMapElemValue()
			yy169 := &x.TestStrucCommon.NotAnon
			yy169.CodecEncodeSelf(e)
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"Nmap\"")
			} else {
				r.EncodeString(`Nmap`)
			}
			z.EncWriteMapElemValue()
			if x.TestStrucCommon.Nmap == nil {
				r.EncodeNil()
			} else {
				z.F.EncMapStringBoolV(x.TestStrucCommon.Nmap, e)
			} // end block: if x.TestStrucCommon.Nmap map == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"Nslice\"")
			} else {
				r.EncodeString(`Nslice`)
			}
			z.EncWriteMapElemValue()
			if x.TestStrucCommon.Nslice == nil {
				r.EncodeNil()
			} else {
				r.EncodeStringBytesRaw([]byte(x.TestStrucCommon.Nslice))
			} // end block: if x.TestStrucCommon.Nslice slice == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"Nint64\"")
			} else {
				r.EncodeString(`Nint64`)
			}
			z.EncWriteMapElemValue()
			if yyn54 {
				r.EncodeNil()
			} else {
				yy173 := *x.TestStrucCommon.Nint64
				r.EncodeInt(int64(yy173))
			}
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"Mtsptr\"")
			} else {
				r.EncodeString(`Mtsptr`)
			}
			z.EncWriteMapElemValue()
			if x.Mtsptr == nil {
				r.EncodeNil()
			} else {
				h.encMapstringPtrtoTestStruc((map[string]*TestStruc)(x.Mtsptr), e)
			} // end block: if x.Mtsptr map == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"Mts\"")
			} else {
				r.EncodeString(`Mts`)
			}
			z.EncWriteMapElemValue()
			if x.Mts == nil {
				r.EncodeNil()
			} else {
				h.encMapstringTestStruc((map[string]TestStruc)(x.Mts), e)
			} // end block: if x.Mts map == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"Its\"")
			} else {
				r.EncodeString(`Its`)
			}
			z.EncWriteMapElemValue()
			if x.Its == nil {
				r.EncodeNil()
			} else {
				h.encSlicePtrtoTestStruc(([]*TestStruc)(x.Its), e)
			} // end block: if x.Its slice == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"Nteststruc\"")
			} else {
				r.EncodeString(`Nteststruc`)
			}
			z.EncWriteMapElemValue()
			if yyn58 {
				r.EncodeNil()
			} else {
				x.Nteststruc.CodecEncodeSelf(e)
			}
			z.EncWriteMapEnd()
		}
	}
}

func (x *TestStruc) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil19780 {
		*(x) = TestStruc{}
	} else if yyct2 == codecSelferValueTypeMap19780 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray19780 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct19780)
	}
}

func (x *TestStruc) codecDecodeSelfFromMap(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if z.DecCheckBreak() {
				break
			}
		}
		z.DecReadMapElemKey()
		yys3 := z.StringView(r.DecodeStringAsBytes())
		z.DecReadMapElemValue()
		switch yys3 {
		case "S":
			x.TestStrucCommon.S = (string)(string(r.DecodeStringAsBytes()))
		case "I64":
			x.TestStrucCommon.I64 = (int64)(r.DecodeInt64())
		case "I32":
			x.TestStrucCommon.I32 = (int32)(z.C.IntV(r.DecodeInt64(), 32))
		case "I16":
			x.TestStrucCommon.I16 = (int16)(z.C.IntV(r.DecodeInt64(), 16))
		case "I8":
			x.TestStrucCommon.I8 = (int8)(z.C.IntV(r.DecodeInt64(), 8))
		case "I64n":
			x.TestStrucCommon.I64n = (int64)(r.DecodeInt64())
		case "I32n":
			x.TestStrucCommon.I32n = (int32)(z.C.IntV(r.DecodeInt64(), 32))
		case "I16n":
			x.TestStrucCommon.I16n = (int16)(z.C.IntV(r.DecodeInt64(), 16))
		case "I8n":
			x.TestStrucCommon.I8n = (int8)(z.C.IntV(r.DecodeInt64(), 8))
		case "Ui64":
			x.TestStrucCommon.Ui64 = (uint64)(r.DecodeUint64())
		case "Ui32":
			x.TestStrucCommon.Ui32 = (uint32)(z.C.UintV(r.DecodeUint64(), 32))
		case "Ui16":
			x.TestStrucCommon.Ui16 = (uint16)(z.C.UintV(r.DecodeUint64(), 16))
		case "Ui8":
			x.TestStrucCommon.Ui8 = (uint8)(z.C.UintV(r.DecodeUint64(), 8))
		case "F64":
			x.TestStrucCommon.F64 = (float64)(r.DecodeFloat64())
		case "F32":
			x.TestStrucCommon.F32 = (float32)(z.DecDecodeFloat32())
		case "B":
			x.TestStrucCommon.B = (bool)(r.DecodeBool())
		case "By":
			x.TestStrucCommon.By = (uint8)(z.C.UintV(r.DecodeUint64(), 8))
		case "Sslice":
			z.F.DecSliceStringX(&x.TestStrucCommon.Sslice, d)
		case "I64slice":
			z.F.DecSliceInt64X(&x.TestStrucCommon.I64slice, d)
		case "I16slice":
			z.F.DecSliceInt16X(&x.TestStrucCommon.I16slice, d)
		case "Ui64slice":
			z.F.DecSliceUint64X(&x.TestStrucCommon.Ui64slice, d)
		case "Ui8slice":
			x.TestStrucCommon.Ui8slice = r.DecodeBytes(([]byte)(x.TestStrucCommon.Ui8slice), false)
		case "Bslice":
			z.F.DecSliceBoolX(&x.TestStrucCommon.Bslice, d)
		case "Byslice":
			x.TestStrucCommon.Byslice = r.DecodeBytes(([]byte)(x.TestStrucCommon.Byslice), false)
		case "BytesSlice":
			z.F.DecSliceBytesX(&x.TestStrucCommon.BytesSlice, d)
		case "Iptrslice":
			h.decSlicePtrtoint64((*[]*int64)(&x.TestStrucCommon.Iptrslice), d)
		case "WrapSliceInt64":
			x.TestStrucCommon.WrapSliceInt64.CodecDecodeSelf(d)
		case "WrapSliceString":
			x.TestStrucCommon.WrapSliceString.CodecDecodeSelf(d)
		case "Msi64":
			z.F.DecMapStringInt64X(&x.TestStrucCommon.Msi64, d)
		case "Msbytes":
			z.F.DecMapStringBytesX(&x.TestStrucCommon.Msbytes, d)
		case "Simplef":
			x.TestStrucCommon.Simplef.CodecDecodeSelf(d)
		case "SstrUi64T":
			h.decSlicestringUint64T((*[]stringUint64T)(&x.TestStrucCommon.SstrUi64T), d)
		case "MstrUi64T":
			h.decMapstringPtrtostringUint64T((*map[string]*stringUint64T)(&x.TestStrucCommon.MstrUi64T), d)
		case "AS":
			x.TestStrucCommon.AnonInTestStruc.AS = (string)(string(r.DecodeStringAsBytes()))
		case "AI64":
			x.TestStrucCommon.AnonInTestStruc.AI64 = (int64)(r.DecodeInt64())
		case "AI16":
			x.TestStrucCommon.AnonInTestStruc.AI16 = (int16)(z.C.IntV(r.DecodeInt64(), 16))
		case "AUi64":
			x.TestStrucCommon.AnonInTestStruc.AUi64 = (uint64)(r.DecodeUint64())
		case "ASslice":
			z.F.DecSliceStringX(&x.TestStrucCommon.AnonInTestStruc.ASslice, d)
		case "AI64slice":
			z.F.DecSliceInt64X(&x.TestStrucCommon.AnonInTestStruc.AI64slice, d)
		case "AUi64slice":
			z.F.DecSliceUint64X(&x.TestStrucCommon.AnonInTestStruc.AUi64slice, d)
		case "AF64slice":
			z.F.DecSliceFloat64X(&x.TestStrucCommon.AnonInTestStruc.AF64slice, d)
		case "AF32slice":
			z.F.DecSliceFloat32X(&x.TestStrucCommon.AnonInTestStruc.AF32slice, d)
		case "AMSU16":
			h.decMapstringuint16((*map[string]uint16)(&x.TestStrucCommon.AnonInTestStruc.AMSU16), d)
		case "AI64arr0":
			h.decArray0int64((*[0]int64)(&x.TestStrucCommon.AnonInTestStruc.AI64arr0), d)
		case "AI64slice0":
			z.F.DecSliceInt64X(&x.TestStrucCommon.AnonInTestStruc.AI64slice0, d)
		case "AUi64sliceN":
			z.F.DecSliceUint64X(&x.TestStrucCommon.AnonInTestStruc.AUi64sliceN, d)
		case "AMSU16N":
			h.decMapstringuint16((*map[string]uint16)(&x.TestStrucCommon.AnonInTestStruc.AMSU16N), d)
		case "AMSU16E":
			h.decMapstringuint16((*map[string]uint16)(&x.TestStrucCommon.AnonInTestStruc.AMSU16E), d)
		case "NotAnon":
			x.TestStrucCommon.NotAnon.CodecDecodeSelf(d)
		case "Nmap":
			z.F.DecMapStringBoolX(&x.TestStrucCommon.Nmap, d)
		case "Nslice":
			x.TestStrucCommon.Nslice = r.DecodeBytes(([]byte)(x.TestStrucCommon.Nslice), false)
		case "Nint64":
			if r.TryNil() {
				if x.TestStrucCommon.Nint64 != nil { // remove the if-true
					x.TestStrucCommon.Nint64 = nil
				}
			} else {
				if x.TestStrucCommon.Nint64 == nil {
					x.TestStrucCommon.Nint64 = new(int64)
				}
				*x.TestStrucCommon.Nint64 = (int64)(r.DecodeInt64())
			}
		case "Mtsptr":
			h.decMapstringPtrtoTestStruc((*map[string]*TestStruc)(&x.Mtsptr), d)
		case "Mts":
			h.decMapstringTestStruc((*map[string]TestStruc)(&x.Mts), d)
		case "Its":
			h.decSlicePtrtoTestStruc((*[]*TestStruc)(&x.Its), d)
		case "Nteststruc":
			if r.TryNil() {
				if x.Nteststruc != nil { // remove the if-true
					x.Nteststruc = nil
				}
			} else {
				if x.Nteststruc == nil {
					x.Nteststruc = new(TestStruc)
				}
				x.Nteststruc.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
}

func (x *TestStruc) codecDecodeSelfFromArray(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj90 int
	var yyb90 bool
	var yyhl90 bool = l >= 0
	yyj90++
	if yyhl90 {
		yyb90 = yyj90 > l
	} else {
		yyb90 = z.DecCheckBreak()
	}
	if yyb90 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.S = (string)(string(r.DecodeStringAsBytes()))
	yyj90++
	if yyhl90 {
		yyb90 = yyj90 > l
	} else {
		yyb90 = z.DecCheckBreak()
	}
	if yyb90 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.I64 = (int64)(r.DecodeInt64())
	yyj90++
	if yyhl90 {
		yyb90 = yyj90 > l
	} else {
		yyb90 = z.DecCheckBreak()
	}
	if yyb90 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.I32 = (int32)(z.C.IntV(r.DecodeInt64(), 32))
	yyj90++
	if yyhl90 {
		yyb90 = yyj90 > l
	} else {
		yyb90 = z.DecCheckBreak()
	}
	if yyb90 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.I16 = (int16)(z.C.IntV(r.DecodeInt64(), 16))
	yyj90++
	if yyhl90 {
		yyb90 = yyj90 > l
	} else {
		yyb90 = z.DecCheckBreak()
	}
	if yyb90 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.I8 = (int8)(z.C.IntV(r.DecodeInt64(), 8))
	yyj90++
	if yyhl90 {
		yyb90 = yyj90 > l
	} else {
		yyb90 = z.DecCheckBreak()
	}
	if yyb90 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.I64n = (int64)(r.DecodeInt64())
	yyj90++
	if yyhl90 {
		yyb90 = yyj90 > l
	} else {
		yyb90 = z.DecCheckBreak()
	}
	if yyb90 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.I32n = (int32)(z.C.IntV(r.DecodeInt64(), 32))
	yyj90++
	if yyhl90 {
		yyb90 = yyj90 > l
	} else {
		yyb90 = z.DecCheckBreak()
	}
	if yyb90 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.I16n = (int16)(z.C.IntV(r.DecodeInt64(), 16))
	yyj90++
	if yyhl90 {
		yyb90 = yyj90 > l
	} else {
		yyb90 = z.DecCheckBreak()
	}
	if yyb90 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.I8n = (int8)(z.C.IntV(r.DecodeInt64(), 8))
	yyj90++
	if yyhl90 {
		yyb90 = yyj90 > l
	} else {
		yyb90 = z.DecCheckBreak()
	}
	if yyb90 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.Ui64 = (uint64)(r.DecodeUint64())
	yyj90++
	if yyhl90 {
		yyb90 = yyj90 > l
	} else {
		yyb90 = z.DecCheckBreak()
	}
	if yyb90 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.Ui32 = (uint32)(z.C.UintV(r.DecodeUint64(), 32))
	yyj90++
	if yyhl90 {
		yyb90 = yyj90 > l
	} else {
		yyb90 = z.DecCheckBreak()
	}
	if yyb90 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.Ui16 = (uint16)(z.C.UintV(r.DecodeUint64(), 16))
	yyj90++
	if yyhl90 {
		yyb90 = yyj90 > l
	} else {
		yyb90 = z.DecCheckBreak()
	}
	if yyb90 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.Ui8 = (uint8)(z.C.UintV(r.DecodeUint64(), 8))
	yyj90++
	if yyhl90 {
		yyb90 = yyj90 > l
	} else {
		yyb90 = z.DecCheckBreak()
	}
	if yyb90 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.F64 = (float64)(r.DecodeFloat64())
	yyj90++
	if yyhl90 {
		yyb90 = yyj90 > l
	} else {
		yyb90 = z.DecCheckBreak()
	}
	if yyb90 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.F32 = (float32)(z.DecDecodeFloat32())
	yyj90++
	if yyhl90 {
		yyb90 = yyj90 > l
	} else {
		yyb90 = z.DecCheckBreak()
	}
	if yyb90 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.B = (bool)(r.DecodeBool())
	yyj90++
	if yyhl90 {
		yyb90 = yyj90 > l
	} else {
		yyb90 = z.DecCheckBreak()
	}
	if yyb90 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.By = (uint8)(z.C.UintV(r.DecodeUint64(), 8))
	yyj90++
	if yyhl90 {
		yyb90 = yyj90 > l
	} else {
		yyb90 = z.DecCheckBreak()
	}
	if yyb90 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceStringX(&x.TestStrucCommon.Sslice, d)
	yyj90++
	if yyhl90 {
		yyb90 = yyj90 > l
	} else {
		yyb90 = z.DecCheckBreak()
	}
	if yyb90 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceInt64X(&x.TestStrucCommon.I64slice, d)
	yyj90++
	if yyhl90 {
		yyb90 = yyj90 > l
	} else {
		yyb90 = z.DecCheckBreak()
	}
	if yyb90 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceInt16X(&x.TestStrucCommon.I16slice, d)
	yyj90++
	if yyhl90 {
		yyb90 = yyj90 > l
	} else {
		yyb90 = z.DecCheckBreak()
	}
	if yyb90 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceUint64X(&x.TestStrucCommon.Ui64slice, d)
	yyj90++
	if yyhl90 {
		yyb90 = yyj90 > l
	} else {
		yyb90 = z.DecCheckBreak()
	}
	if yyb90 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.Ui8slice = r.DecodeBytes(([]byte)(x.TestStrucCommon.Ui8slice), false)
	yyj90++
	if yyhl90 {
		yyb90 = yyj90 > l
	} else {
		yyb90 = z.DecCheckBreak()
	}
	if yyb90 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceBoolX(&x.TestStrucCommon.Bslice, d)
	yyj90++
	if yyhl90 {
		yyb90 = yyj90 > l
	} else {
		yyb90 = z.DecCheckBreak()
	}
	if yyb90 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.Byslice = r.DecodeBytes(([]byte)(x.TestStrucCommon.Byslice), false)
	yyj90++
	if yyhl90 {
		yyb90 = yyj90 > l
	} else {
		yyb90 = z.DecCheckBreak()
	}
	if yyb90 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceBytesX(&x.TestStrucCommon.BytesSlice, d)
	yyj90++
	if yyhl90 {
		yyb90 = yyj90 > l
	} else {
		yyb90 = z.DecCheckBreak()
	}
	if yyb90 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decSlicePtrtoint64((*[]*int64)(&x.TestStrucCommon.Iptrslice), d)
	yyj90++
	if yyhl90 {
		yyb90 = yyj90 > l
	} else {
		yyb90 = z.DecCheckBreak()
	}
	if yyb90 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.WrapSliceInt64.CodecDecodeSelf(d)
	yyj90++
	if yyhl90 {
		yyb90 = yyj90 > l
	} else {
		yyb90 = z.DecCheckBreak()
	}
	if yyb90 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.WrapSliceString.CodecDecodeSelf(d)
	yyj90++
	if yyhl90 {
		yyb90 = yyj90 > l
	} else {
		yyb90 = z.DecCheckBreak()
	}
	if yyb90 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecMapStringInt64X(&x.TestStrucCommon.Msi64, d)
	yyj90++
	if yyhl90 {
		yyb90 = yyj90 > l
	} else {
		yyb90 = z.DecCheckBreak()
	}
	if yyb90 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecMapStringBytesX(&x.TestStrucCommon.Msbytes, d)
	yyj90++
	if yyhl90 {
		yyb90 = yyj90 > l
	} else {
		yyb90 = z.DecCheckBreak()
	}
	if yyb90 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.Simplef.CodecDecodeSelf(d)
	yyj90++
	if yyhl90 {
		yyb90 = yyj90 > l
	} else {
		yyb90 = z.DecCheckBreak()
	}
	if yyb90 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decSlicestringUint64T((*[]stringUint64T)(&x.TestStrucCommon.SstrUi64T), d)
	yyj90++
	if yyhl90 {
		yyb90 = yyj90 > l
	} else {
		yyb90 = z.DecCheckBreak()
	}
	if yyb90 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decMapstringPtrtostringUint64T((*map[string]*stringUint64T)(&x.TestStrucCommon.MstrUi64T), d)
	yyj90++
	if yyhl90 {
		yyb90 = yyj90 > l
	} else {
		yyb90 = z.DecCheckBreak()
	}
	if yyb90 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.AnonInTestStruc.AS = (string)(string(r.DecodeStringAsBytes()))
	yyj90++
	if yyhl90 {
		yyb90 = yyj90 > l
	} else {
		yyb90 = z.DecCheckBreak()
	}
	if yyb90 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.AnonInTestStruc.AI64 = (int64)(r.DecodeInt64())
	yyj90++
	if yyhl90 {
		yyb90 = yyj90 > l
	} else {
		yyb90 = z.DecCheckBreak()
	}
	if yyb90 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.AnonInTestStruc.AI16 = (int16)(z.C.IntV(r.DecodeInt64(), 16))
	yyj90++
	if yyhl90 {
		yyb90 = yyj90 > l
	} else {
		yyb90 = z.DecCheckBreak()
	}
	if yyb90 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.AnonInTestStruc.AUi64 = (uint64)(r.DecodeUint64())
	yyj90++
	if yyhl90 {
		yyb90 = yyj90 > l
	} else {
		yyb90 = z.DecCheckBreak()
	}
	if yyb90 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceStringX(&x.TestStrucCommon.AnonInTestStruc.ASslice, d)
	yyj90++
	if yyhl90 {
		yyb90 = yyj90 > l
	} else {
		yyb90 = z.DecCheckBreak()
	}
	if yyb90 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceInt64X(&x.TestStrucCommon.AnonInTestStruc.AI64slice, d)
	yyj90++
	if yyhl90 {
		yyb90 = yyj90 > l
	} else {
		yyb90 = z.DecCheckBreak()
	}
	if yyb90 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceUint64X(&x.TestStrucCommon.AnonInTestStruc.AUi64slice, d)
	yyj90++
	if yyhl90 {
		yyb90 = yyj90 > l
	} else {
		yyb90 = z.DecCheckBreak()
	}
	if yyb90 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceFloat64X(&x.TestStrucCommon.AnonInTestStruc.AF64slice, d)
	yyj90++
	if yyhl90 {
		yyb90 = yyj90 > l
	} else {
		yyb90 = z.DecCheckBreak()
	}
	if yyb90 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceFloat32X(&x.TestStrucCommon.AnonInTestStruc.AF32slice, d)
	yyj90++
	if yyhl90 {
		yyb90 = yyj90 > l
	} else {
		yyb90 = z.DecCheckBreak()
	}
	if yyb90 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decMapstringuint16((*map[string]uint16)(&x.TestStrucCommon.AnonInTestStruc.AMSU16), d)
	yyj90++
	if yyhl90 {
		yyb90 = yyj90 > l
	} else {
		yyb90 = z.DecCheckBreak()
	}
	if yyb90 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decArray0int64((*[0]int64)(&x.TestStrucCommon.AnonInTestStruc.AI64arr0), d)
	yyj90++
	if yyhl90 {
		yyb90 = yyj90 > l
	} else {
		yyb90 = z.DecCheckBreak()
	}
	if yyb90 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceInt64X(&x.TestStrucCommon.AnonInTestStruc.AI64slice0, d)
	yyj90++
	if yyhl90 {
		yyb90 = yyj90 > l
	} else {
		yyb90 = z.DecCheckBreak()
	}
	if yyb90 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceUint64X(&x.TestStrucCommon.AnonInTestStruc.AUi64sliceN, d)
	yyj90++
	if yyhl90 {
		yyb90 = yyj90 > l
	} else {
		yyb90 = z.DecCheckBreak()
	}
	if yyb90 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decMapstringuint16((*map[string]uint16)(&x.TestStrucCommon.AnonInTestStruc.AMSU16N), d)
	yyj90++
	if yyhl90 {
		yyb90 = yyj90 > l
	} else {
		yyb90 = z.DecCheckBreak()
	}
	if yyb90 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decMapstringuint16((*map[string]uint16)(&x.TestStrucCommon.AnonInTestStruc.AMSU16E), d)
	yyj90++
	if yyhl90 {
		yyb90 = yyj90 > l
	} else {
		yyb90 = z.DecCheckBreak()
	}
	if yyb90 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.NotAnon.CodecDecodeSelf(d)
	yyj90++
	if yyhl90 {
		yyb90 = yyj90 > l
	} else {
		yyb90 = z.DecCheckBreak()
	}
	if yyb90 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecMapStringBoolX(&x.TestStrucCommon.Nmap, d)
	yyj90++
	if yyhl90 {
		yyb90 = yyj90 > l
	} else {
		yyb90 = z.DecCheckBreak()
	}
	if yyb90 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.Nslice = r.DecodeBytes(([]byte)(x.TestStrucCommon.Nslice), false)
	yyj90++
	if yyhl90 {
		yyb90 = yyj90 > l
	} else {
		yyb90 = z.DecCheckBreak()
	}
	if yyb90 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if r.TryNil() {
		if x.TestStrucCommon.Nint64 != nil { // remove the if-true
			x.TestStrucCommon.Nint64 = nil
		}
	} else {
		if x.TestStrucCommon.Nint64 == nil {
			x.TestStrucCommon.Nint64 = new(int64)
		}
		*x.TestStrucCommon.Nint64 = (int64)(r.DecodeInt64())
	}
	yyj90++
	if yyhl90 {
		yyb90 = yyj90 > l
	} else {
		yyb90 = z.DecCheckBreak()
	}
	if yyb90 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decMapstringPtrtoTestStruc((*map[string]*TestStruc)(&x.Mtsptr), d)
	yyj90++
	if yyhl90 {
		yyb90 = yyj90 > l
	} else {
		yyb90 = z.DecCheckBreak()
	}
	if yyb90 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decMapstringTestStruc((*map[string]TestStruc)(&x.Mts), d)
	yyj90++
	if yyhl90 {
		yyb90 = yyj90 > l
	} else {
		yyb90 = z.DecCheckBreak()
	}
	if yyb90 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decSlicePtrtoTestStruc((*[]*TestStruc)(&x.Its), d)
	yyj90++
	if yyhl90 {
		yyb90 = yyj90 > l
	} else {
		yyb90 = z.DecCheckBreak()
	}
	if yyb90 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if r.TryNil() {
		if x.Nteststruc != nil { // remove the if-true
			x.Nteststruc = nil
		}
	} else {
		if x.Nteststruc == nil {
			x.Nteststruc = new(TestStruc)
		}
		x.Nteststruc.CodecDecodeSelf(d)
	}
	for {
		yyj90++
		if yyhl90 {
			yyb90 = yyj90 > l
		} else {
			yyb90 = z.DecCheckBreak()
		}
		if yyb90 {
			break
		}
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj90-1, "")
	}
}

func (x *codecgenA) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yysep2 := !z.EncBinary()
		yy2arr2 := z.EncBasicHandle().StructToArray
		_, _ = yysep2, yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(1)
			z.EncWriteArrayElem()
			if x.ZZ == nil {
				r.EncodeNil()
			} else {
				r.EncodeStringBytesRaw([]byte(x.ZZ))
			} // end block: if x.ZZ slice == nil
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(1)
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"ZZ\"")
			} else {
				r.EncodeString(`ZZ`)
			}
			z.EncWriteMapElemValue()
			if x.ZZ == nil {
				r.EncodeNil()
			} else {
				r.EncodeStringBytesRaw([]byte(x.ZZ))
			} // end block: if x.ZZ slice == nil
			z.EncWriteMapEnd()
		}
	}
}

func (x *codecgenA) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil19780 {
		*(x) = codecgenA{}
	} else if yyct2 == codecSelferValueTypeMap19780 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray19780 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct19780)
	}
}

func (x *codecgenA) codecDecodeSelfFromMap(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if z.DecCheckBreak() {
				break
			}
		}
		z.DecReadMapElemKey()
		yys3 := z.StringView(r.DecodeStringAsBytes())
		z.DecReadMapElemValue()
		switch yys3 {
		case "ZZ":
			x.ZZ = r.DecodeBytes(([]byte)(x.ZZ), false)
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
}

func (x *codecgenA) codecDecodeSelfFromArray(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj6 int
	var yyb6 bool
	var yyhl6 bool = l >= 0
	yyj6++
	if yyhl6 {
		yyb6 = yyj6 > l
	} else {
		yyb6 = z.DecCheckBreak()
	}
	if yyb6 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.ZZ = r.DecodeBytes(([]byte)(x.ZZ), false)
	for {
		yyj6++
		if yyhl6 {
			yyb6 = yyj6 > l
		} else {
			yyb6 = z.DecCheckBreak()
		}
		if yyb6 {
			break
		}
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj6-1, "")
	}
}

func (x *codecgenB) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yysep2 := !z.EncBinary()
		yy2arr2 := z.EncBasicHandle().StructToArray
		_, _ = yysep2, yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(1)
			z.EncWriteArrayElem()
			yy4 := &x.AA
			yy4.CodecEncodeSelf(e)
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(1)
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"AA\"")
			} else {
				r.EncodeString(`AA`)
			}
			z.EncWriteMapElemValue()
			yy6 := &x.AA
			yy6.CodecEncodeSelf(e)
			z.EncWriteMapEnd()
		}
	}
}

func (x *codecgenB) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil19780 {
		*(x) = codecgenB{}
	} else if yyct2 == codecSelferValueTypeMap19780 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray19780 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct19780)
	}
}

func (x *codecgenB) codecDecodeSelfFromMap(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if z.DecCheckBreak() {
				break
			}
		}
		z.DecReadMapElemKey()
		yys3 := z.StringView(r.DecodeStringAsBytes())
		z.DecReadMapElemValue()
		switch yys3 {
		case "AA":
			x.AA.CodecDecodeSelf(d)
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
}

func (x *codecgenB) codecDecodeSelfFromArray(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj5 int
	var yyb5 bool
	var yyhl5 bool = l >= 0
	yyj5++
	if yyhl5 {
		yyb5 = yyj5 > l
	} else {
		yyb5 = z.DecCheckBreak()
	}
	if yyb5 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.AA.CodecDecodeSelf(d)
	for {
		yyj5++
		if yyhl5 {
			yyb5 = yyj5 > l
		} else {
			yyb5 = z.DecCheckBreak()
		}
		if yyb5 {
			break
		}
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj5-1, "")
	}
}

func (x *codecgenC) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yysep2 := !z.EncBinary()
		yy2arr2 := z.EncBasicHandle().StructToArray
		_, _ = yysep2, yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		var yyq2 = [1]bool{     // should field at this index be written?
			false || codecSelfer19780False() || len(x.BB.AA.ZZ) != 0, // BB
		}
		_ = yyq2
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(1)
			z.EncWriteArrayElem()
			if yyq2[0] {
				yy4 := &x.BB
				yy4.CodecEncodeSelf(e)
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayEnd()
		} else {
			var yynn2 int
			for _, b := range yyq2 {
				if b {
					yynn2++
				}
			}
			z.EncWriteMapStart(yynn2)
			yynn2 = 0
			if yyq2[0] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"BB\"")
				} else {
					r.EncodeString(`BB`)
				}
				z.EncWriteMapElemValue()
				yy6 := &x.BB
				yy6.CodecEncodeSelf(e)
			}
			z.EncWriteMapEnd()
		}
	}
}

func (x *codecgenC) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil19780 {
		*(x) = codecgenC{}
	} else if yyct2 == codecSelferValueTypeMap19780 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray19780 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct19780)
	}
}

func (x *codecgenC) codecDecodeSelfFromMap(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if z.DecCheckBreak() {
				break
			}
		}
		z.DecReadMapElemKey()
		yys3 := z.StringView(r.DecodeStringAsBytes())
		z.DecReadMapElemValue()
		switch yys3 {
		case "BB":
			x.BB.CodecDecodeSelf(d)
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
}

func (x *codecgenC) codecDecodeSelfFromArray(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj5 int
	var yyb5 bool
	var yyhl5 bool = l >= 0
	yyj5++
	if yyhl5 {
		yyb5 = yyj5 > l
	} else {
		yyb5 = z.DecCheckBreak()
	}
	if yyb5 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.BB.CodecDecodeSelf(d)
	for {
		yyj5++
		if yyhl5 {
			yyb5 = yyj5 > l
		} else {
			yyb5 = z.DecCheckBreak()
		}
		if yyb5 {
			break
		}
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj5-1, "")
	}
}

func (x *TestCodecgenG) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yysep2 := !z.EncBinary()
		yy2arr2 := z.EncBasicHandle().StructToArray
		_, _ = yysep2, yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(1)
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.TestCodecgenG))
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(1)
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"TestCodecgenG\"")
			} else {
				r.EncodeString(`TestCodecgenG`)
			}
			z.EncWriteMapElemValue()
			r.EncodeInt(int64(x.TestCodecgenG))
			z.EncWriteMapEnd()
		}
	}
}

func (x *TestCodecgenG) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil19780 {
		*(x) = TestCodecgenG{}
	} else if yyct2 == codecSelferValueTypeMap19780 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray19780 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct19780)
	}
}

func (x *TestCodecgenG) codecDecodeSelfFromMap(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if z.DecCheckBreak() {
				break
			}
		}
		z.DecReadMapElemKey()
		yys3 := z.StringView(r.DecodeStringAsBytes())
		z.DecReadMapElemValue()
		switch yys3 {
		case "TestCodecgenG":
			x.TestCodecgenG = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize19780))
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
}

func (x *TestCodecgenG) codecDecodeSelfFromArray(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj5 int
	var yyb5 bool
	var yyhl5 bool = l >= 0
	yyj5++
	if yyhl5 {
		yyb5 = yyj5 > l
	} else {
		yyb5 = z.DecCheckBreak()
	}
	if yyb5 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestCodecgenG = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize19780))
	for {
		yyj5++
		if yyhl5 {
			yyb5 = yyj5 > l
		} else {
			yyb5 = z.DecCheckBreak()
		}
		if yyb5 {
			break
		}
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj5-1, "")
	}
}

func (x *codecgenH) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yysep2 := !z.EncBinary()
		yy2arr2 := z.EncBasicHandle().StructToArray
		_, _ = yysep2, yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(1)
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.TestCodecgenG.TestCodecgenG))
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(1)
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"TestCodecgenG\"")
			} else {
				r.EncodeString(`TestCodecgenG`)
			}
			z.EncWriteMapElemValue()
			r.EncodeInt(int64(x.TestCodecgenG.TestCodecgenG))
			z.EncWriteMapEnd()
		}
	}
}

func (x *codecgenH) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil19780 {
		*(x) = codecgenH{}
	} else if yyct2 == codecSelferValueTypeMap19780 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray19780 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct19780)
	}
}

func (x *codecgenH) codecDecodeSelfFromMap(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if z.DecCheckBreak() {
				break
			}
		}
		z.DecReadMapElemKey()
		yys3 := z.StringView(r.DecodeStringAsBytes())
		z.DecReadMapElemValue()
		switch yys3 {
		case "TestCodecgenG":
			x.TestCodecgenG.TestCodecgenG = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize19780))
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
}

func (x *codecgenH) codecDecodeSelfFromArray(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj5 int
	var yyb5 bool
	var yyhl5 bool = l >= 0
	yyj5++
	if yyhl5 {
		yyb5 = yyj5 > l
	} else {
		yyb5 = z.DecCheckBreak()
	}
	if yyb5 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestCodecgenG.TestCodecgenG = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize19780))
	for {
		yyj5++
		if yyhl5 {
			yyb5 = yyj5 > l
		} else {
			yyb5 = z.DecCheckBreak()
		}
		if yyb5 {
			break
		}
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj5-1, "")
	}
}

func (x *codecgenI) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yysep2 := !z.EncBinary()
		yy2arr2 := z.EncBasicHandle().StructToArray
		_, _ = yysep2, yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(1)
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.codecgenH.TestCodecgenG.TestCodecgenG))
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(1)
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"TestCodecgenG\"")
			} else {
				r.EncodeString(`TestCodecgenG`)
			}
			z.EncWriteMapElemValue()
			r.EncodeInt(int64(x.codecgenH.TestCodecgenG.TestCodecgenG))
			z.EncWriteMapEnd()
		}
	}
}

func (x *codecgenI) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil19780 {
		*(x) = codecgenI{}
	} else if yyct2 == codecSelferValueTypeMap19780 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray19780 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct19780)
	}
}

func (x *codecgenI) codecDecodeSelfFromMap(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if z.DecCheckBreak() {
				break
			}
		}
		z.DecReadMapElemKey()
		yys3 := z.StringView(r.DecodeStringAsBytes())
		z.DecReadMapElemValue()
		switch yys3 {
		case "TestCodecgenG":
			x.codecgenH.TestCodecgenG.TestCodecgenG = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize19780))
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
}

func (x *codecgenI) codecDecodeSelfFromArray(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj5 int
	var yyb5 bool
	var yyhl5 bool = l >= 0
	yyj5++
	if yyhl5 {
		yyb5 = yyj5 > l
	} else {
		yyb5 = z.DecCheckBreak()
	}
	if yyb5 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.codecgenH.TestCodecgenG.TestCodecgenG = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize19780))
	for {
		yyj5++
		if yyhl5 {
			yyb5 = yyj5 > l
		} else {
			yyb5 = z.DecCheckBreak()
		}
		if yyb5 {
			break
		}
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj5-1, "")
	}
}

func (x *codecgenK) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yysep2 := !z.EncBinary()
		yy2arr2 := z.EncBasicHandle().StructToArray
		_, _ = yysep2, yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(2)
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.X))
			z.EncWriteArrayElem()
			r.EncodeString(string(x.Y))
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(2)
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"X\"")
			} else {
				r.EncodeString(`X`)
			}
			z.EncWriteMapElemValue()
			r.EncodeInt(int64(x.X))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"Y\"")
			} else {
				r.EncodeString(`Y`)
			}
			z.EncWriteMapElemValue()
			r.EncodeString(string(x.Y))
			z.EncWriteMapEnd()
		}
	}
}

func (x *codecgenK) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil19780 {
		*(x) = codecgenK{}
	} else if yyct2 == codecSelferValueTypeMap19780 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray19780 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct19780)
	}
}

func (x *codecgenK) codecDecodeSelfFromMap(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if z.DecCheckBreak() {
				break
			}
		}
		z.DecReadMapElemKey()
		yys3 := z.StringView(r.DecodeStringAsBytes())
		z.DecReadMapElemValue()
		switch yys3 {
		case "X":
			x.X = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize19780))
		case "Y":
			x.Y = (string)(string(r.DecodeStringAsBytes()))
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
}

func (x *codecgenK) codecDecodeSelfFromArray(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj6 int
	var yyb6 bool
	var yyhl6 bool = l >= 0
	yyj6++
	if yyhl6 {
		yyb6 = yyj6 > l
	} else {
		yyb6 = z.DecCheckBreak()
	}
	if yyb6 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.X = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize19780))
	yyj6++
	if yyhl6 {
		yyb6 = yyj6 > l
	} else {
		yyb6 = z.DecCheckBreak()
	}
	if yyb6 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.Y = (string)(string(r.DecodeStringAsBytes()))
	for {
		yyj6++
		if yyhl6 {
			yyb6 = yyj6 > l
		} else {
			yyb6 = z.DecCheckBreak()
		}
		if yyb6 {
			break
		}
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj6-1, "")
	}
}

func (x *codecgenL) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yysep2 := !z.EncBinary()
		yy2arr2 := z.EncBasicHandle().StructToArray
		_, _ = yysep2, yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(2)
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.X))
			z.EncWriteArrayElem()
			r.EncodeUint(uint64(x.Y))
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(2)
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"X\"")
			} else {
				r.EncodeString(`X`)
			}
			z.EncWriteMapElemValue()
			r.EncodeInt(int64(x.X))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"Y\"")
			} else {
				r.EncodeString(`Y`)
			}
			z.EncWriteMapElemValue()
			r.EncodeUint(uint64(x.Y))
			z.EncWriteMapEnd()
		}
	}
}

func (x *codecgenL) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil19780 {
		*(x) = codecgenL{}
	} else if yyct2 == codecSelferValueTypeMap19780 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray19780 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct19780)
	}
}

func (x *codecgenL) codecDecodeSelfFromMap(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if z.DecCheckBreak() {
				break
			}
		}
		z.DecReadMapElemKey()
		yys3 := z.StringView(r.DecodeStringAsBytes())
		z.DecReadMapElemValue()
		switch yys3 {
		case "X":
			x.X = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize19780))
		case "Y":
			x.Y = (uint32)(z.C.UintV(r.DecodeUint64(), 32))
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
}

func (x *codecgenL) codecDecodeSelfFromArray(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj6 int
	var yyb6 bool
	var yyhl6 bool = l >= 0
	yyj6++
	if yyhl6 {
		yyb6 = yyj6 > l
	} else {
		yyb6 = z.DecCheckBreak()
	}
	if yyb6 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.X = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize19780))
	yyj6++
	if yyhl6 {
		yyb6 = yyj6 > l
	} else {
		yyb6 = z.DecCheckBreak()
	}
	if yyb6 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.Y = (uint32)(z.C.UintV(r.DecodeUint64(), 32))
	for {
		yyj6++
		if yyhl6 {
			yyb6 = yyj6 > l
		} else {
			yyb6 = z.DecCheckBreak()
		}
		if yyb6 {
			break
		}
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj6-1, "")
	}
}

func (x *codecgenM) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yysep2 := !z.EncBinary()
		yy2arr2 := z.EncBasicHandle().StructToArray
		_, _ = yysep2, yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(2)
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.codecgenK.X))
			z.EncWriteArrayElem()
			r.EncodeString(string(x.codecgenK.Y))
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(2)
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"X\"")
			} else {
				r.EncodeString(`X`)
			}
			z.EncWriteMapElemValue()
			r.EncodeInt(int64(x.codecgenK.X))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"Y\"")
			} else {
				r.EncodeString(`Y`)
			}
			z.EncWriteMapElemValue()
			r.EncodeString(string(x.codecgenK.Y))
			z.EncWriteMapEnd()
		}
	}
}

func (x *codecgenM) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil19780 {
		*(x) = codecgenM{}
	} else if yyct2 == codecSelferValueTypeMap19780 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray19780 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct19780)
	}
}

func (x *codecgenM) codecDecodeSelfFromMap(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if z.DecCheckBreak() {
				break
			}
		}
		z.DecReadMapElemKey()
		yys3 := z.StringView(r.DecodeStringAsBytes())
		z.DecReadMapElemValue()
		switch yys3 {
		case "X":
			x.codecgenK.X = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize19780))
		case "Y":
			x.codecgenK.Y = (string)(string(r.DecodeStringAsBytes()))
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
}

func (x *codecgenM) codecDecodeSelfFromArray(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj6 int
	var yyb6 bool
	var yyhl6 bool = l >= 0
	yyj6++
	if yyhl6 {
		yyb6 = yyj6 > l
	} else {
		yyb6 = z.DecCheckBreak()
	}
	if yyb6 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.codecgenK.X = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize19780))
	yyj6++
	if yyhl6 {
		yyb6 = yyj6 > l
	} else {
		yyb6 = z.DecCheckBreak()
	}
	if yyb6 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.codecgenK.Y = (string)(string(r.DecodeStringAsBytes()))
	for {
		yyj6++
		if yyhl6 {
			yyb6 = yyj6 > l
		} else {
			yyb6 = z.DecCheckBreak()
		}
		if yyb6 {
			break
		}
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj6-1, "")
	}
}

func (x *testStrucKeyTypeT0) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yysep2 := !z.EncBinary()
		yy2arr2 := z.EncBasicHandle().StructToArray
		_, _ = yysep2, yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(1)
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.F))
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(1)
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"F\"")
			} else {
				r.EncodeString(`F`)
			}
			z.EncWriteMapElemValue()
			r.EncodeInt(int64(x.F))
			z.EncWriteMapEnd()
		}
	}
}

func (x *testStrucKeyTypeT0) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil19780 {
		*(x) = testStrucKeyTypeT0{}
	} else if yyct2 == codecSelferValueTypeMap19780 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray19780 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct19780)
	}
}

func (x *testStrucKeyTypeT0) codecDecodeSelfFromMap(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if z.DecCheckBreak() {
				break
			}
		}
		z.DecReadMapElemKey()
		yys3 := z.StringView(r.DecodeStringAsBytes())
		z.DecReadMapElemValue()
		switch yys3 {
		case "F":
			x.F = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize19780))
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
}

func (x *testStrucKeyTypeT0) codecDecodeSelfFromArray(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj5 int
	var yyb5 bool
	var yyhl5 bool = l >= 0
	yyj5++
	if yyhl5 {
		yyb5 = yyj5 > l
	} else {
		yyb5 = z.DecCheckBreak()
	}
	if yyb5 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.F = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize19780))
	for {
		yyj5++
		if yyhl5 {
			yyb5 = yyj5 > l
		} else {
			yyb5 = z.DecCheckBreak()
		}
		if yyb5 {
			break
		}
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj5-1, "")
	}
}

func (x *testStrucKeyTypeT1) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yysep2 := !z.EncBinary()
		yy2arr2 := z.EncBasicHandle().StructToArray
		_, _ = yysep2, yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(1)
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.F))
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(1)
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"FFFF\"")
			} else {
				r.EncodeString(`FFFF`)
			}
			z.EncWriteMapElemValue()
			r.EncodeInt(int64(x.F))
			z.EncWriteMapEnd()
		}
	}
}

func (x *testStrucKeyTypeT1) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil19780 {
		*(x) = testStrucKeyTypeT1{}
	} else if yyct2 == codecSelferValueTypeMap19780 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray19780 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct19780)
	}
}

func (x *testStrucKeyTypeT1) codecDecodeSelfFromMap(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if z.DecCheckBreak() {
				break
			}
		}
		z.DecReadMapElemKey()
		yys3 := z.StringView(r.DecodeStringAsBytes())
		z.DecReadMapElemValue()
		switch yys3 {
		case "FFFF":
			x.F = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize19780))
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
}

func (x *testStrucKeyTypeT1) codecDecodeSelfFromArray(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj5 int
	var yyb5 bool
	var yyhl5 bool = l >= 0
	yyj5++
	if yyhl5 {
		yyb5 = yyj5 > l
	} else {
		yyb5 = z.DecCheckBreak()
	}
	if yyb5 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.F = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize19780))
	for {
		yyj5++
		if yyhl5 {
			yyb5 = yyj5 > l
		} else {
			yyb5 = z.DecCheckBreak()
		}
		if yyb5 {
			break
		}
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj5-1, "")
	}
}

func (x *testStrucKeyTypeT2) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yysep2 := !z.EncBinary()
		yy2arr2 := z.EncBasicHandle().StructToArray
		_, _ = yysep2, yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(1)
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.F))
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(1)
			z.EncWriteMapElemKey()
			r.EncodeInt(z.M.Int(strconv.ParseInt(`-1`, 10, 64)))
			z.EncWriteMapElemValue()
			r.EncodeInt(int64(x.F))
			z.EncWriteMapEnd()
		}
	}
}

func (x *testStrucKeyTypeT2) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil19780 {
		*(x) = testStrucKeyTypeT2{}
	} else if yyct2 == codecSelferValueTypeMap19780 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray19780 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct19780)
	}
}

func (x *testStrucKeyTypeT2) codecDecodeSelfFromMap(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if z.DecCheckBreak() {
				break
			}
		}
		z.DecReadMapElemKey()
		yys3 := z.StringView(strconv.AppendInt(z.DecScratchArrayBuffer()[:0], r.DecodeInt64(), 10))
		z.DecReadMapElemValue()
		switch yys3 {
		case "-1":
			x.F = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize19780))
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
}

func (x *testStrucKeyTypeT2) codecDecodeSelfFromArray(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj5 int
	var yyb5 bool
	var yyhl5 bool = l >= 0
	yyj5++
	if yyhl5 {
		yyb5 = yyj5 > l
	} else {
		yyb5 = z.DecCheckBreak()
	}
	if yyb5 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.F = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize19780))
	for {
		yyj5++
		if yyhl5 {
			yyb5 = yyj5 > l
		} else {
			yyb5 = z.DecCheckBreak()
		}
		if yyb5 {
			break
		}
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj5-1, "")
	}
}

func (x *testStrucKeyTypeT3) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yysep2 := !z.EncBinary()
		yy2arr2 := z.EncBasicHandle().StructToArray
		_, _ = yysep2, yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(1)
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.F))
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(1)
			z.EncWriteMapElemKey()
			r.EncodeUint(z.M.Uint(strconv.ParseUint(`1`, 10, 64)))
			z.EncWriteMapElemValue()
			r.EncodeInt(int64(x.F))
			z.EncWriteMapEnd()
		}
	}
}

func (x *testStrucKeyTypeT3) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil19780 {
		*(x) = testStrucKeyTypeT3{}
	} else if yyct2 == codecSelferValueTypeMap19780 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray19780 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct19780)
	}
}

func (x *testStrucKeyTypeT3) codecDecodeSelfFromMap(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if z.DecCheckBreak() {
				break
			}
		}
		z.DecReadMapElemKey()
		yys3 := z.StringView(strconv.AppendUint(z.DecScratchArrayBuffer()[:0], r.DecodeUint64(), 10))
		z.DecReadMapElemValue()
		switch yys3 {
		case "1":
			x.F = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize19780))
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
}

func (x *testStrucKeyTypeT3) codecDecodeSelfFromArray(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj5 int
	var yyb5 bool
	var yyhl5 bool = l >= 0
	yyj5++
	if yyhl5 {
		yyb5 = yyj5 > l
	} else {
		yyb5 = z.DecCheckBreak()
	}
	if yyb5 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.F = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize19780))
	for {
		yyj5++
		if yyhl5 {
			yyb5 = yyj5 > l
		} else {
			yyb5 = z.DecCheckBreak()
		}
		if yyb5 {
			break
		}
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj5-1, "")
	}
}

func (x *testStrucKeyTypeT4) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yysep2 := !z.EncBinary()
		yy2arr2 := z.EncBasicHandle().StructToArray
		_, _ = yysep2, yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(1)
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.F))
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(1)
			z.EncWriteMapElemKey()
			r.EncodeFloat64(z.M.Float(strconv.ParseFloat(`2.5`, 64)))
			z.EncWriteMapElemValue()
			r.EncodeInt(int64(x.F))
			z.EncWriteMapEnd()
		}
	}
}

func (x *testStrucKeyTypeT4) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil19780 {
		*(x) = testStrucKeyTypeT4{}
	} else if yyct2 == codecSelferValueTypeMap19780 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray19780 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct19780)
	}
}

func (x *testStrucKeyTypeT4) codecDecodeSelfFromMap(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if z.DecCheckBreak() {
				break
			}
		}
		z.DecReadMapElemKey()
		yys3 := z.StringView(strconv.AppendFloat(z.DecScratchArrayBuffer()[:0], r.DecodeFloat64(), 'f', -1, 64))
		z.DecReadMapElemValue()
		switch yys3 {
		case "2.5":
			x.F = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize19780))
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
}

func (x *testStrucKeyTypeT4) codecDecodeSelfFromArray(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj5 int
	var yyb5 bool
	var yyhl5 bool = l >= 0
	yyj5++
	if yyhl5 {
		yyb5 = yyj5 > l
	} else {
		yyb5 = z.DecCheckBreak()
	}
	if yyb5 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.F = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize19780))
	for {
		yyj5++
		if yyhl5 {
			yyb5 = yyj5 > l
		} else {
			yyb5 = z.DecCheckBreak()
		}
		if yyb5 {
			break
		}
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj5-1, "")
	}
}

func (x Bbool) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeBool(bool(x))
}

func (x *Bbool) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	*x = (Bbool)(r.DecodeBool())
}

func (x *Aarray) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		h.encAarray((*Aarray)(x), e)
	}
}

func (x *Aarray) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	h.decAarray((*Aarray)(x), d)
}

func (x Sstring) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeString(string(x))
}

func (x *Sstring) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	*x = (Sstring)(string(r.DecodeStringAsBytes()))
}

func (x *Sstructsmall) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yysep2 := !z.EncBinary()
		yy2arr2 := z.EncBasicHandle().StructToArray
		_, _ = yysep2, yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(1)
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.A))
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(1)
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"A\"")
			} else {
				r.EncodeString(`A`)
			}
			z.EncWriteMapElemValue()
			r.EncodeInt(int64(x.A))
			z.EncWriteMapEnd()
		}
	}
}

func (x *Sstructsmall) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil19780 {
		*(x) = Sstructsmall{}
	} else if yyct2 == codecSelferValueTypeMap19780 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray19780 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct19780)
	}
}

func (x *Sstructsmall) codecDecodeSelfFromMap(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if z.DecCheckBreak() {
				break
			}
		}
		z.DecReadMapElemKey()
		yys3 := z.StringView(r.DecodeStringAsBytes())
		z.DecReadMapElemValue()
		switch yys3 {
		case "A":
			x.A = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize19780))
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
}

func (x *Sstructsmall) codecDecodeSelfFromArray(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj5 int
	var yyb5 bool
	var yyhl5 bool = l >= 0
	yyj5++
	if yyhl5 {
		yyb5 = yyj5 > l
	} else {
		yyb5 = z.DecCheckBreak()
	}
	if yyb5 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.A = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize19780))
	for {
		yyj5++
		if yyhl5 {
			yyb5 = yyj5 > l
		} else {
			yyb5 = z.DecCheckBreak()
		}
		if yyb5 {
			break
		}
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj5-1, "")
	}
}

func (x *Sstructbig) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yysep2 := !z.EncBinary()
		yy2arr2 := z.EncBasicHandle().StructToArray
		_, _ = yysep2, yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		var yyn5 bool = x.Ssmallptr == nil
		var yyn6 bool = x.Ssmall == nil
		var yyn7 bool = x.Sptr == nil
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(5)
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.A))
			z.EncWriteArrayElem()
			r.EncodeBool(bool(x.B))
			if yyn5 {
				z.EncWriteArrayElem()
				r.EncodeNil()
			} else {
				z.EncWriteArrayElem()
				x.Ssmallptr.CodecEncodeSelf(e)
			}
			if yyn6 {
				z.EncWriteArrayElem()
				r.EncodeNil()
			} else {
				z.EncWriteArrayElem()
				x.Ssmall.CodecEncodeSelf(e)
			}
			if yyn7 {
				z.EncWriteArrayElem()
				r.EncodeNil()
			} else {
				z.EncWriteArrayElem()
				x.Sptr.CodecEncodeSelf(e)
			}
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(5)
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"A\"")
			} else {
				r.EncodeString(`A`)
			}
			z.EncWriteMapElemValue()
			r.EncodeInt(int64(x.A))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"B\"")
			} else {
				r.EncodeString(`B`)
			}
			z.EncWriteMapElemValue()
			r.EncodeBool(bool(x.B))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"Ssmallptr\"")
			} else {
				r.EncodeString(`Ssmallptr`)
			}
			z.EncWriteMapElemValue()
			if yyn5 {
				r.EncodeNil()
			} else {
				x.Ssmallptr.CodecEncodeSelf(e)
			}
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"Ssmall\"")
			} else {
				r.EncodeString(`Ssmall`)
			}
			z.EncWriteMapElemValue()
			if yyn6 {
				r.EncodeNil()
			} else {
				x.Ssmall.CodecEncodeSelf(e)
			}
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"Sptr\"")
			} else {
				r.EncodeString(`Sptr`)
			}
			z.EncWriteMapElemValue()
			if yyn7 {
				r.EncodeNil()
			} else {
				x.Sptr.CodecEncodeSelf(e)
			}
			z.EncWriteMapEnd()
		}
	}
}

func (x *Sstructbig) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil19780 {
		*(x) = Sstructbig{}
	} else if yyct2 == codecSelferValueTypeMap19780 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray19780 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct19780)
	}
}

func (x *Sstructbig) codecDecodeSelfFromMap(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if z.DecCheckBreak() {
				break
			}
		}
		z.DecReadMapElemKey()
		yys3 := z.StringView(r.DecodeStringAsBytes())
		z.DecReadMapElemValue()
		switch yys3 {
		case "A":
			x.A = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize19780))
		case "B":
			x.B = (bool)(r.DecodeBool())
		case "Ssmallptr":
			if r.TryNil() {
				if x.Ssmallptr != nil { // remove the if-true
					x.Ssmallptr = nil
				}
			} else {
				if x.Ssmallptr == nil {
					x.Ssmallptr = new(Sstructsmall)
				}
				x.Ssmallptr.CodecDecodeSelf(d)
			}
		case "Ssmall":
			if r.TryNil() {
				if x.Ssmall != nil { // remove the if-true
					x.Ssmall = nil
				}
			} else {
				if x.Ssmall == nil {
					x.Ssmall = new(Sstructsmall)
				}
				x.Ssmall.CodecDecodeSelf(d)
			}
		case "Sptr":
			if r.TryNil() {
				if x.Sptr != nil { // remove the if-true
					x.Sptr = nil
				}
			} else {
				if x.Sptr == nil {
					x.Sptr = new(Sstructbig)
				}
				x.Sptr.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
}

func (x *Sstructbig) codecDecodeSelfFromArray(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj9 int
	var yyb9 bool
	var yyhl9 bool = l >= 0
	yyj9++
	if yyhl9 {
		yyb9 = yyj9 > l
	} else {
		yyb9 = z.DecCheckBreak()
	}
	if yyb9 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.A = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize19780))
	yyj9++
	if yyhl9 {
		yyb9 = yyj9 > l
	} else {
		yyb9 = z.DecCheckBreak()
	}
	if yyb9 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.B = (bool)(r.DecodeBool())
	yyj9++
	if yyhl9 {
		yyb9 = yyj9 > l
	} else {
		yyb9 = z.DecCheckBreak()
	}
	if yyb9 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if r.TryNil() {
		if x.Ssmallptr != nil { // remove the if-true
			x.Ssmallptr = nil
		}
	} else {
		if x.Ssmallptr == nil {
			x.Ssmallptr = new(Sstructsmall)
		}
		x.Ssmallptr.CodecDecodeSelf(d)
	}
	yyj9++
	if yyhl9 {
		yyb9 = yyj9 > l
	} else {
		yyb9 = z.DecCheckBreak()
	}
	if yyb9 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if r.TryNil() {
		if x.Ssmall != nil { // remove the if-true
			x.Ssmall = nil
		}
	} else {
		if x.Ssmall == nil {
			x.Ssmall = new(Sstructsmall)
		}
		x.Ssmall.CodecDecodeSelf(d)
	}
	yyj9++
	if yyhl9 {
		yyb9 = yyj9 > l
	} else {
		yyb9 = z.DecCheckBreak()
	}
	if yyb9 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if r.TryNil() {
		if x.Sptr != nil { // remove the if-true
			x.Sptr = nil
		}
	} else {
		if x.Sptr == nil {
			x.Sptr = new(Sstructbig)
		}
		x.Sptr.CodecDecodeSelf(d)
	}
	for {
		yyj9++
		if yyhl9 {
			yyb9 = yyj9 > l
		} else {
			yyb9 = z.DecCheckBreak()
		}
		if yyb9 {
			break
		}
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj9-1, "")
	}
}

func (x *SstructbigMapBySlice) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yysep2 := !z.EncBinary()
		yy2arr2 := z.EncBasicHandle().StructToArray
		_, _ = yysep2, yy2arr2
		const yyr2 bool = true // struct tag has 'toArray'
		var yyn5 bool = x.Ssmallptr == nil
		var yyn6 bool = x.Ssmall == nil
		var yyn7 bool = x.Sptr == nil
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(5)
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.A))
			z.EncWriteArrayElem()
			r.EncodeBool(bool(x.B))
			if yyn5 {
				z.EncWriteArrayElem()
				r.EncodeNil()
			} else {
				z.EncWriteArrayElem()
				x.Ssmallptr.CodecEncodeSelf(e)
			}
			if yyn6 {
				z.EncWriteArrayElem()
				r.EncodeNil()
			} else {
				z.EncWriteArrayElem()
				x.Ssmall.CodecEncodeSelf(e)
			}
			if yyn7 {
				z.EncWriteArrayElem()
				r.EncodeNil()
			} else {
				z.EncWriteArrayElem()
				x.Sptr.CodecEncodeSelf(e)
			}
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(5)
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"A\"")
			} else {
				r.EncodeString(`A`)
			}
			z.EncWriteMapElemValue()
			r.EncodeInt(int64(x.A))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"B\"")
			} else {
				r.EncodeString(`B`)
			}
			z.EncWriteMapElemValue()
			r.EncodeBool(bool(x.B))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"Ssmallptr\"")
			} else {
				r.EncodeString(`Ssmallptr`)
			}
			z.EncWriteMapElemValue()
			if yyn5 {
				r.EncodeNil()
			} else {
				x.Ssmallptr.CodecEncodeSelf(e)
			}
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"Ssmall\"")
			} else {
				r.EncodeString(`Ssmall`)
			}
			z.EncWriteMapElemValue()
			if yyn6 {
				r.EncodeNil()
			} else {
				x.Ssmall.CodecEncodeSelf(e)
			}
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"Sptr\"")
			} else {
				r.EncodeString(`Sptr`)
			}
			z.EncWriteMapElemValue()
			if yyn7 {
				r.EncodeNil()
			} else {
				x.Sptr.CodecEncodeSelf(e)
			}
			z.EncWriteMapEnd()
		}
	}
}

func (x *SstructbigMapBySlice) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil19780 {
		*(x) = SstructbigMapBySlice{}
	} else if yyct2 == codecSelferValueTypeMap19780 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray19780 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct19780)
	}
}

func (x *SstructbigMapBySlice) codecDecodeSelfFromMap(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if z.DecCheckBreak() {
				break
			}
		}
		z.DecReadMapElemKey()
		yys3 := z.StringView(r.DecodeStringAsBytes())
		z.DecReadMapElemValue()
		switch yys3 {
		case "A":
			x.A = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize19780))
		case "B":
			x.B = (bool)(r.DecodeBool())
		case "Ssmallptr":
			if r.TryNil() {
				if x.Ssmallptr != nil { // remove the if-true
					x.Ssmallptr = nil
				}
			} else {
				if x.Ssmallptr == nil {
					x.Ssmallptr = new(Sstructsmall)
				}
				x.Ssmallptr.CodecDecodeSelf(d)
			}
		case "Ssmall":
			if r.TryNil() {
				if x.Ssmall != nil { // remove the if-true
					x.Ssmall = nil
				}
			} else {
				if x.Ssmall == nil {
					x.Ssmall = new(Sstructsmall)
				}
				x.Ssmall.CodecDecodeSelf(d)
			}
		case "Sptr":
			if r.TryNil() {
				if x.Sptr != nil { // remove the if-true
					x.Sptr = nil
				}
			} else {
				if x.Sptr == nil {
					x.Sptr = new(Sstructbig)
				}
				x.Sptr.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
}

func (x *SstructbigMapBySlice) codecDecodeSelfFromArray(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj9 int
	var yyb9 bool
	var yyhl9 bool = l >= 0
	yyj9++
	if yyhl9 {
		yyb9 = yyj9 > l
	} else {
		yyb9 = z.DecCheckBreak()
	}
	if yyb9 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.A = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize19780))
	yyj9++
	if yyhl9 {
		yyb9 = yyj9 > l
	} else {
		yyb9 = z.DecCheckBreak()
	}
	if yyb9 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.B = (bool)(r.DecodeBool())
	yyj9++
	if yyhl9 {
		yyb9 = yyj9 > l
	} else {
		yyb9 = z.DecCheckBreak()
	}
	if yyb9 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if r.TryNil() {
		if x.Ssmallptr != nil { // remove the if-true
			x.Ssmallptr = nil
		}
	} else {
		if x.Ssmallptr == nil {
			x.Ssmallptr = new(Sstructsmall)
		}
		x.Ssmallptr.CodecDecodeSelf(d)
	}
	yyj9++
	if yyhl9 {
		yyb9 = yyj9 > l
	} else {
		yyb9 = z.DecCheckBreak()
	}
	if yyb9 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if r.TryNil() {
		if x.Ssmall != nil { // remove the if-true
			x.Ssmall = nil
		}
	} else {
		if x.Ssmall == nil {
			x.Ssmall = new(Sstructsmall)
		}
		x.Ssmall.CodecDecodeSelf(d)
	}
	yyj9++
	if yyhl9 {
		yyb9 = yyj9 > l
	} else {
		yyb9 = z.DecCheckBreak()
	}
	if yyb9 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if r.TryNil() {
		if x.Sptr != nil { // remove the if-true
			x.Sptr = nil
		}
	} else {
		if x.Sptr == nil {
			x.Sptr = new(Sstructbig)
		}
		x.Sptr.CodecDecodeSelf(d)
	}
	for {
		yyj9++
		if yyhl9 {
			yyb9 = yyj9 > l
		} else {
			yyb9 = z.DecCheckBreak()
		}
		if yyb9 {
			break
		}
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj9-1, "")
	}
}

func (x *tLowerFirstLetter) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yysep2 := !z.EncBinary()
		yy2arr2 := z.EncBasicHandle().StructToArray
		_, _ = yysep2, yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(2)
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.I))
			z.EncWriteArrayElem()
			r.EncodeString(string(x.S))
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(2)
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"I\"")
			} else {
				r.EncodeString(`I`)
			}
			z.EncWriteMapElemValue()
			r.EncodeInt(int64(x.I))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"S\"")
			} else {
				r.EncodeString(`S`)
			}
			z.EncWriteMapElemValue()
			r.EncodeString(string(x.S))
			z.EncWriteMapEnd()
		}
	}
}

func (x *tLowerFirstLetter) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil19780 {
		*(x) = tLowerFirstLetter{}
	} else if yyct2 == codecSelferValueTypeMap19780 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray19780 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct19780)
	}
}

func (x *tLowerFirstLetter) codecDecodeSelfFromMap(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if z.DecCheckBreak() {
				break
			}
		}
		z.DecReadMapElemKey()
		yys3 := z.StringView(r.DecodeStringAsBytes())
		z.DecReadMapElemValue()
		switch yys3 {
		case "I":
			x.I = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize19780))
		case "S":
			x.S = (string)(string(r.DecodeStringAsBytes()))
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
}

func (x *tLowerFirstLetter) codecDecodeSelfFromArray(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj6 int
	var yyb6 bool
	var yyhl6 bool = l >= 0
	yyj6++
	if yyhl6 {
		yyb6 = yyj6 > l
	} else {
		yyb6 = z.DecCheckBreak()
	}
	if yyb6 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.I = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize19780))
	yyj6++
	if yyhl6 {
		yyb6 = yyj6 > l
	} else {
		yyb6 = z.DecCheckBreak()
	}
	if yyb6 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.S = (string)(string(r.DecodeStringAsBytes()))
	for {
		yyj6++
		if yyhl6 {
			yyb6 = yyj6 > l
		} else {
			yyb6 = z.DecCheckBreak()
		}
		if yyb6 {
			break
		}
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj6-1, "")
	}
}

func (x wrapInt64) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeInt(int64(x))
}

func (x *wrapInt64) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	*x = (wrapInt64)(r.DecodeInt64())
}

func (x wrapUint8) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeUint(uint64(x))
}

func (x *wrapUint8) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	*x = (wrapUint8)(z.C.UintV(r.DecodeUint64(), 8))
}

func (x wrapBytes) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		h.encwrapBytes((wrapBytes)(x), e)
	} // end block: if x slice == nil
}

func (x *wrapBytes) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	h.decwrapBytes((*wrapBytes)(x), d)
}

func (x *AnonInTestStrucIntf) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yysep2 := !z.EncBinary()
		yy2arr2 := z.EncBasicHandle().StructToArray
		_, _ = yysep2, yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		var yyn7 bool = x.Tptr == nil
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(5)
			z.EncWriteArrayElem()
			if x.Islice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceIntfV(x.Islice, e)
			} // end block: if x.Islice slice == nil
			z.EncWriteArrayElem()
			if x.Ms == nil {
				r.EncodeNil()
			} else {
				z.F.EncMapStringIntfV(x.Ms, e)
			} // end block: if x.Ms map == nil
			z.EncWriteArrayElem()
			z.EncFallback(x.Nintf)
			z.EncWriteArrayElem()
			if !z.EncBasicHandle().TimeNotBuiltin {
				r.EncodeTime(x.T)
			} else if yyxt11 := z.Extension(z.I2Rtid(x.T)); yyxt11 != nil {
				z.EncExtension(x.T, yyxt11)
			} else if z.EncBinary() {
				z.EncBinaryMarshal(x.T)
			} else if !z.EncBinary() && z.IsJSONHandle() {
				z.EncJSONMarshal(x.T)
			} else {
				z.EncFallback(x.T)
			}
			if yyn7 {
				z.EncWriteArrayElem()
				r.EncodeNil()
			} else {
				z.EncWriteArrayElem()
				yy12 := *x.Tptr
				if !z.EncBasicHandle().TimeNotBuiltin {
					r.EncodeTime(yy12)
				} else if yyxt13 := z.Extension(z.I2Rtid(yy12)); yyxt13 != nil {
					z.EncExtension(yy12, yyxt13)
				} else if z.EncBinary() {
					z.EncBinaryMarshal(yy12)
				} else if !z.EncBinary() && z.IsJSONHandle() {
					z.EncJSONMarshal(yy12)
				} else {
					z.EncFallback(yy12)
				}
			}
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(5)
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"Islice\"")
			} else {
				r.EncodeString(`Islice`)
			}
			z.EncWriteMapElemValue()
			if x.Islice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceIntfV(x.Islice, e)
			} // end block: if x.Islice slice == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"Ms\"")
			} else {
				r.EncodeString(`Ms`)
			}
			z.EncWriteMapElemValue()
			if x.Ms == nil {
				r.EncodeNil()
			} else {
				z.F.EncMapStringIntfV(x.Ms, e)
			} // end block: if x.Ms map == nil
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"Nintf\"")
			} else {
				r.EncodeString(`Nintf`)
			}
			z.EncWriteMapElemValue()
			z.EncFallback(x.Nintf)
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"T\"")
			} else {
				r.EncodeString(`T`)
			}
			z.EncWriteMapElemValue()
			if !z.EncBasicHandle().TimeNotBuiltin {
				r.EncodeTime(x.T)
			} else if yyxt17 := z.Extension(z.I2Rtid(x.T)); yyxt17 != nil {
				z.EncExtension(x.T, yyxt17)
			} else if z.EncBinary() {
				z.EncBinaryMarshal(x.T)
			} else if !z.EncBinary() && z.IsJSONHandle() {
				z.EncJSONMarshal(x.T)
			} else {
				z.EncFallback(x.T)
			}
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"Tptr\"")
			} else {
				r.EncodeString(`Tptr`)
			}
			z.EncWriteMapElemValue()
			if yyn7 {
				r.EncodeNil()
			} else {
				yy18 := *x.Tptr
				if !z.EncBasicHandle().TimeNotBuiltin {
					r.EncodeTime(yy18)
				} else if yyxt19 := z.Extension(z.I2Rtid(yy18)); yyxt19 != nil {
					z.EncExtension(yy18, yyxt19)
				} else if z.EncBinary() {
					z.EncBinaryMarshal(yy18)
				} else if !z.EncBinary() && z.IsJSONHandle() {
					z.EncJSONMarshal(yy18)
				} else {
					z.EncFallback(yy18)
				}
			}
			z.EncWriteMapEnd()
		}
	}
}

func (x *AnonInTestStrucIntf) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil19780 {
		*(x) = AnonInTestStrucIntf{}
	} else if yyct2 == codecSelferValueTypeMap19780 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray19780 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct19780)
	}
}

func (x *AnonInTestStrucIntf) codecDecodeSelfFromMap(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if z.DecCheckBreak() {
				break
			}
		}
		z.DecReadMapElemKey()
		yys3 := z.StringView(r.DecodeStringAsBytes())
		z.DecReadMapElemValue()
		switch yys3 {
		case "Islice":
			z.F.DecSliceIntfX(&x.Islice, d)
		case "Ms":
			z.F.DecMapStringIntfX(&x.Ms, d)
		case "Nintf":
			z.DecFallback(&x.Nintf, true)
		case "T":
			if !z.DecBasicHandle().TimeNotBuiltin {
				x.T = r.DecodeTime()
			} else if yyxt11 := z.Extension(z.I2Rtid(x.T)); yyxt11 != nil {
				z.DecExtension(x.T, yyxt11)
			} else if z.DecBinary() {
				z.DecBinaryUnmarshal(&x.T)
			} else if !z.DecBinary() && z.IsJSONHandle() {
				z.DecJSONUnmarshal(&x.T)
			} else {
				z.DecFallback(&x.T, false)
			}
		case "Tptr":
			if r.TryNil() {
				if x.Tptr != nil { // remove the if-true
					x.Tptr = nil
				}
			} else {
				if x.Tptr == nil {
					x.Tptr = new(time.Time)
				}
				if !z.DecBasicHandle().TimeNotBuiltin {
					*x.Tptr = r.DecodeTime()
				} else if yyxt13 := z.Extension(z.I2Rtid(x.Tptr)); yyxt13 != nil {
					z.DecExtension(x.Tptr, yyxt13)
				} else if z.DecBinary() {
					z.DecBinaryUnmarshal(x.Tptr)
				} else if !z.DecBinary() && z.IsJSONHandle() {
					z.DecJSONUnmarshal(x.Tptr)
				} else {
					z.DecFallback(x.Tptr, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
}

func (x *AnonInTestStrucIntf) codecDecodeSelfFromArray(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj14 int
	var yyb14 bool
	var yyhl14 bool = l >= 0
	yyj14++
	if yyhl14 {
		yyb14 = yyj14 > l
	} else {
		yyb14 = z.DecCheckBreak()
	}
	if yyb14 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceIntfX(&x.Islice, d)
	yyj14++
	if yyhl14 {
		yyb14 = yyj14 > l
	} else {
		yyb14 = z.DecCheckBreak()
	}
	if yyb14 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecMapStringIntfX(&x.Ms, d)
	yyj14++
	if yyhl14 {
		yyb14 = yyj14 > l
	} else {
		yyb14 = z.DecCheckBreak()
	}
	if yyb14 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.DecFallback(&x.Nintf, true)
	yyj14++
	if yyhl14 {
		yyb14 = yyj14 > l
	} else {
		yyb14 = z.DecCheckBreak()
	}
	if yyb14 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if !z.DecBasicHandle().TimeNotBuiltin {
		x.T = r.DecodeTime()
	} else if yyxt22 := z.Extension(z.I2Rtid(x.T)); yyxt22 != nil {
		z.DecExtension(x.T, yyxt22)
	} else if z.DecBinary() {
		z.DecBinaryUnmarshal(&x.T)
	} else if !z.DecBinary() && z.IsJSONHandle() {
		z.DecJSONUnmarshal(&x.T)
	} else {
		z.DecFallback(&x.T, false)
	}
	yyj14++
	if yyhl14 {
		yyb14 = yyj14 > l
	} else {
		yyb14 = z.DecCheckBreak()
	}
	if yyb14 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if r.TryNil() {
		if x.Tptr != nil { // remove the if-true
			x.Tptr = nil
		}
	} else {
		if x.Tptr == nil {
			x.Tptr = new(time.Time)
		}
		if !z.DecBasicHandle().TimeNotBuiltin {
			*x.Tptr = r.DecodeTime()
		} else if yyxt24 := z.Extension(z.I2Rtid(x.Tptr)); yyxt24 != nil {
			z.DecExtension(x.Tptr, yyxt24)
		} else if z.DecBinary() {
			z.DecBinaryUnmarshal(x.Tptr)
		} else if !z.DecBinary() && z.IsJSONHandle() {
			z.DecJSONUnmarshal(x.Tptr)
		} else {
			z.DecFallback(x.Tptr, false)
		}
	}
	for {
		yyj14++
		if yyhl14 {
			yyb14 = yyj14 > l
		} else {
			yyb14 = z.DecCheckBreak()
		}
		if yyb14 {
			break
		}
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj14-1, "")
	}
}

func (x *missingFielderT1) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yysep2 := !z.EncBinary()
		yy2arr2 := z.EncBasicHandle().StructToArray
		_, _ = yysep2, yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(2)
			z.EncWriteArrayElem()
			r.EncodeString(string(x.S))
			z.EncWriteArrayElem()
			r.EncodeBool(bool(x.B))
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(2)
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"S\"")
			} else {
				r.EncodeString(`S`)
			}
			z.EncWriteMapElemValue()
			r.EncodeString(string(x.S))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"B\"")
			} else {
				r.EncodeString(`B`)
			}
			z.EncWriteMapElemValue()
			r.EncodeBool(bool(x.B))
			z.EncWriteMapEnd()
		}
	}
}

func (x *missingFielderT1) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil19780 {
		*(x) = missingFielderT1{}
	} else if yyct2 == codecSelferValueTypeMap19780 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray19780 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct19780)
	}
}

func (x *missingFielderT1) codecDecodeSelfFromMap(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if z.DecCheckBreak() {
				break
			}
		}
		z.DecReadMapElemKey()
		yys3 := z.StringView(r.DecodeStringAsBytes())
		z.DecReadMapElemValue()
		switch yys3 {
		case "S":
			x.S = (string)(string(r.DecodeStringAsBytes()))
		case "B":
			x.B = (bool)(r.DecodeBool())
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
}

func (x *missingFielderT1) codecDecodeSelfFromArray(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj6 int
	var yyb6 bool
	var yyhl6 bool = l >= 0
	yyj6++
	if yyhl6 {
		yyb6 = yyj6 > l
	} else {
		yyb6 = z.DecCheckBreak()
	}
	if yyb6 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.S = (string)(string(r.DecodeStringAsBytes()))
	yyj6++
	if yyhl6 {
		yyb6 = yyj6 > l
	} else {
		yyb6 = z.DecCheckBreak()
	}
	if yyb6 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.B = (bool)(r.DecodeBool())
	for {
		yyj6++
		if yyhl6 {
			yyb6 = yyj6 > l
		} else {
			yyb6 = z.DecCheckBreak()
		}
		if yyb6 {
			break
		}
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj6-1, "")
	}
}

func (x *missingFielderT2) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yysep2 := !z.EncBinary()
		yy2arr2 := z.EncBasicHandle().StructToArray
		_, _ = yysep2, yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(4)
			z.EncWriteArrayElem()
			r.EncodeString(string(x.S))
			z.EncWriteArrayElem()
			r.EncodeBool(bool(x.B))
			z.EncWriteArrayElem()
			r.EncodeFloat64(float64(x.F))
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.I))
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(4)
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"S\"")
			} else {
				r.EncodeString(`S`)
			}
			z.EncWriteMapElemValue()
			r.EncodeString(string(x.S))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"B\"")
			} else {
				r.EncodeString(`B`)
			}
			z.EncWriteMapElemValue()
			r.EncodeBool(bool(x.B))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"F\"")
			} else {
				r.EncodeString(`F`)
			}
			z.EncWriteMapElemValue()
			r.EncodeFloat64(float64(x.F))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"I\"")
			} else {
				r.EncodeString(`I`)
			}
			z.EncWriteMapElemValue()
			r.EncodeInt(int64(x.I))
			z.EncWriteMapEnd()
		}
	}
}

func (x *missingFielderT2) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil19780 {
		*(x) = missingFielderT2{}
	} else if yyct2 == codecSelferValueTypeMap19780 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray19780 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct19780)
	}
}

func (x *missingFielderT2) codecDecodeSelfFromMap(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if z.DecCheckBreak() {
				break
			}
		}
		z.DecReadMapElemKey()
		yys3 := z.StringView(r.DecodeStringAsBytes())
		z.DecReadMapElemValue()
		switch yys3 {
		case "S":
			x.S = (string)(string(r.DecodeStringAsBytes()))
		case "B":
			x.B = (bool)(r.DecodeBool())
		case "F":
			x.F = (float64)(r.DecodeFloat64())
		case "I":
			x.I = (int64)(r.DecodeInt64())
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
}

func (x *missingFielderT2) codecDecodeSelfFromArray(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj8 int
	var yyb8 bool
	var yyhl8 bool = l >= 0
	yyj8++
	if yyhl8 {
		yyb8 = yyj8 > l
	} else {
		yyb8 = z.DecCheckBreak()
	}
	if yyb8 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.S = (string)(string(r.DecodeStringAsBytes()))
	yyj8++
	if yyhl8 {
		yyb8 = yyj8 > l
	} else {
		yyb8 = z.DecCheckBreak()
	}
	if yyb8 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.B = (bool)(r.DecodeBool())
	yyj8++
	if yyhl8 {
		yyb8 = yyj8 > l
	} else {
		yyb8 = z.DecCheckBreak()
	}
	if yyb8 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.F = (float64)(r.DecodeFloat64())
	yyj8++
	if yyhl8 {
		yyb8 = yyj8 > l
	} else {
		yyb8 = z.DecCheckBreak()
	}
	if yyb8 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.I = (int64)(r.DecodeInt64())
	for {
		yyj8++
		if yyhl8 {
			yyb8 = yyj8 > l
		} else {
			yyb8 = z.DecCheckBreak()
		}
		if yyb8 {
			break
		}
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj8-1, "")
	}
}

func (x *testSelfExtHelper) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yysep2 := !z.EncBinary()
		yy2arr2 := z.EncBasicHandle().StructToArray
		_, _ = yysep2, yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(3)
			z.EncWriteArrayElem()
			r.EncodeString(string(x.S))
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.I))
			z.EncWriteArrayElem()
			r.EncodeBool(bool(x.B))
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(3)
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"S\"")
			} else {
				r.EncodeString(`S`)
			}
			z.EncWriteMapElemValue()
			r.EncodeString(string(x.S))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"I\"")
			} else {
				r.EncodeString(`I`)
			}
			z.EncWriteMapElemValue()
			r.EncodeInt(int64(x.I))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"B\"")
			} else {
				r.EncodeString(`B`)
			}
			z.EncWriteMapElemValue()
			r.EncodeBool(bool(x.B))
			z.EncWriteMapEnd()
		}
	}
}

func (x *testSelfExtHelper) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil19780 {
		*(x) = testSelfExtHelper{}
	} else if yyct2 == codecSelferValueTypeMap19780 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray19780 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct19780)
	}
}

func (x *testSelfExtHelper) codecDecodeSelfFromMap(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if z.DecCheckBreak() {
				break
			}
		}
		z.DecReadMapElemKey()
		yys3 := z.StringView(r.DecodeStringAsBytes())
		z.DecReadMapElemValue()
		switch yys3 {
		case "S":
			x.S = (string)(string(r.DecodeStringAsBytes()))
		case "I":
			x.I = (int64)(r.DecodeInt64())
		case "B":
			x.B = (bool)(r.DecodeBool())
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
}

func (x *testSelfExtHelper) codecDecodeSelfFromArray(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj7 int
	var yyb7 bool
	var yyhl7 bool = l >= 0
	yyj7++
	if yyhl7 {
		yyb7 = yyj7 > l
	} else {
		yyb7 = z.DecCheckBreak()
	}
	if yyb7 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.S = (string)(string(r.DecodeStringAsBytes()))
	yyj7++
	if yyhl7 {
		yyb7 = yyj7 > l
	} else {
		yyb7 = z.DecCheckBreak()
	}
	if yyb7 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.I = (int64)(r.DecodeInt64())
	yyj7++
	if yyhl7 {
		yyb7 = yyj7 > l
	} else {
		yyb7 = z.DecCheckBreak()
	}
	if yyb7 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.B = (bool)(r.DecodeBool())
	for {
		yyj7++
		if yyhl7 {
			yyb7 = yyj7 > l
		} else {
			yyb7 = z.DecCheckBreak()
		}
		if yyb7 {
			break
		}
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj7-1, "")
	}
}

func (x *TestSelfExtImpl) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yysep2 := !z.EncBinary()
		yy2arr2 := z.EncBasicHandle().StructToArray
		_, _ = yysep2, yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(3)
			z.EncWriteArrayElem()
			r.EncodeString(string(x.testSelfExtHelper.S))
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.testSelfExtHelper.I))
			z.EncWriteArrayElem()
			r.EncodeBool(bool(x.testSelfExtHelper.B))
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(3)
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"S\"")
			} else {
				r.EncodeString(`S`)
			}
			z.EncWriteMapElemValue()
			r.EncodeString(string(x.testSelfExtHelper.S))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"I\"")
			} else {
				r.EncodeString(`I`)
			}
			z.EncWriteMapElemValue()
			r.EncodeInt(int64(x.testSelfExtHelper.I))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"B\"")
			} else {
				r.EncodeString(`B`)
			}
			z.EncWriteMapElemValue()
			r.EncodeBool(bool(x.testSelfExtHelper.B))
			z.EncWriteMapEnd()
		}
	}
}

func (x *TestSelfExtImpl) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil19780 {
		*(x) = TestSelfExtImpl{}
	} else if yyct2 == codecSelferValueTypeMap19780 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray19780 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct19780)
	}
}

func (x *TestSelfExtImpl) codecDecodeSelfFromMap(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if z.DecCheckBreak() {
				break
			}
		}
		z.DecReadMapElemKey()
		yys3 := z.StringView(r.DecodeStringAsBytes())
		z.DecReadMapElemValue()
		switch yys3 {
		case "S":
			x.testSelfExtHelper.S = (string)(string(r.DecodeStringAsBytes()))
		case "I":
			x.testSelfExtHelper.I = (int64)(r.DecodeInt64())
		case "B":
			x.testSelfExtHelper.B = (bool)(r.DecodeBool())
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
}

func (x *TestSelfExtImpl) codecDecodeSelfFromArray(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj7 int
	var yyb7 bool
	var yyhl7 bool = l >= 0
	yyj7++
	if yyhl7 {
		yyb7 = yyj7 > l
	} else {
		yyb7 = z.DecCheckBreak()
	}
	if yyb7 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.testSelfExtHelper.S = (string)(string(r.DecodeStringAsBytes()))
	yyj7++
	if yyhl7 {
		yyb7 = yyj7 > l
	} else {
		yyb7 = z.DecCheckBreak()
	}
	if yyb7 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.testSelfExtHelper.I = (int64)(r.DecodeInt64())
	yyj7++
	if yyhl7 {
		yyb7 = yyj7 > l
	} else {
		yyb7 = z.DecCheckBreak()
	}
	if yyb7 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.testSelfExtHelper.B = (bool)(r.DecodeBool())
	for {
		yyj7++
		if yyhl7 {
			yyb7 = yyj7 > l
		} else {
			yyb7 = z.DecCheckBreak()
		}
		if yyb7 {
			break
		}
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj7-1, "")
	}
}

func (x *TestSelfExtImpl2) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yysep2 := !z.EncBinary()
		yy2arr2 := z.EncBasicHandle().StructToArray
		_, _ = yysep2, yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(2)
			z.EncWriteArrayElem()
			r.EncodeString(string(x.M))
			z.EncWriteArrayElem()
			r.EncodeBool(bool(x.O))
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(2)
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"M\"")
			} else {
				r.EncodeString(`M`)
			}
			z.EncWriteMapElemValue()
			r.EncodeString(string(x.M))
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"O\"")
			} else {
				r.EncodeString(`O`)
			}
			z.EncWriteMapElemValue()
			r.EncodeBool(bool(x.O))
			z.EncWriteMapEnd()
		}
	}
}

func (x *TestSelfExtImpl2) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil19780 {
		*(x) = TestSelfExtImpl2{}
	} else if yyct2 == codecSelferValueTypeMap19780 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray19780 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct19780)
	}
}

func (x *TestSelfExtImpl2) codecDecodeSelfFromMap(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if z.DecCheckBreak() {
				break
			}
		}
		z.DecReadMapElemKey()
		yys3 := z.StringView(r.DecodeStringAsBytes())
		z.DecReadMapElemValue()
		switch yys3 {
		case "M":
			x.M = (string)(string(r.DecodeStringAsBytes()))
		case "O":
			x.O = (bool)(r.DecodeBool())
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
}

func (x *TestSelfExtImpl2) codecDecodeSelfFromArray(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj6 int
	var yyb6 bool
	var yyhl6 bool = l >= 0
	yyj6++
	if yyhl6 {
		yyb6 = yyj6 > l
	} else {
		yyb6 = z.DecCheckBreak()
	}
	if yyb6 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.M = (string)(string(r.DecodeStringAsBytes()))
	yyj6++
	if yyhl6 {
		yyb6 = yyj6 > l
	} else {
		yyb6 = z.DecCheckBreak()
	}
	if yyb6 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.O = (bool)(r.DecodeBool())
	for {
		yyj6++
		if yyhl6 {
			yyb6 = yyj6 > l
		} else {
			yyb6 = z.DecCheckBreak()
		}
		if yyb6 {
			break
		}
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj6-1, "")
	}
}

func (x *TestTwoNakedInterfaces) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yysep2 := !z.EncBinary()
		yy2arr2 := z.EncBasicHandle().StructToArray
		_, _ = yysep2, yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(2)
			z.EncWriteArrayElem()
			z.EncFallback(x.A)
			z.EncWriteArrayElem()
			z.EncFallback(x.B)
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(2)
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"A\"")
			} else {
				r.EncodeString(`A`)
			}
			z.EncWriteMapElemValue()
			z.EncFallback(x.A)
			z.EncWriteMapElemKey()
			if z.IsJSONHandle() {
				z.WriteStr("\"B\"")
			} else {
				r.EncodeString(`B`)
			}
			z.EncWriteMapElemValue()
			z.EncFallback(x.B)
			z.EncWriteMapEnd()
		}
	}
}

func (x *TestTwoNakedInterfaces) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil19780 {
		*(x) = TestTwoNakedInterfaces{}
	} else if yyct2 == codecSelferValueTypeMap19780 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray19780 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct19780)
	}
}

func (x *TestTwoNakedInterfaces) codecDecodeSelfFromMap(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if z.DecCheckBreak() {
				break
			}
		}
		z.DecReadMapElemKey()
		yys3 := z.StringView(r.DecodeStringAsBytes())
		z.DecReadMapElemValue()
		switch yys3 {
		case "A":
			z.DecFallback(&x.A, true)
		case "B":
			z.DecFallback(&x.B, true)
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
}

func (x *TestTwoNakedInterfaces) codecDecodeSelfFromArray(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj8 int
	var yyb8 bool
	var yyhl8 bool = l >= 0
	yyj8++
	if yyhl8 {
		yyb8 = yyj8 > l
	} else {
		yyb8 = z.DecCheckBreak()
	}
	if yyb8 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.DecFallback(&x.A, true)
	yyj8++
	if yyhl8 {
		yyb8 = yyj8 > l
	} else {
		yyb8 = z.DecCheckBreak()
	}
	if yyb8 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.DecFallback(&x.B, true)
	for {
		yyj8++
		if yyhl8 {
			yyb8 = yyj8 > l
		} else {
			yyb8 = z.DecCheckBreak()
		}
		if yyb8 {
			break
		}
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj8-1, "")
	}
}

func (x *TestStrucFlex) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yysep2 := !z.EncBinary()
		yy2arr2 := z.EncBasicHandle().StructToArray
		_, _ = yysep2, yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		var yyq2 = [77]bool{    // should field at this index be written?
			x.S != "",                   // S
			x.I64 != 0,                  // I64
			x.I32 != 0,                  // I32
			x.I16 != 0,                  // I16
			x.I8 != 0,                   // I8
			x.I64n != 0,                 // I64n
			x.I32n != 0,                 // I32n
			x.I16n != 0,                 // I16n
			x.I8n != 0,                  // I8n
			x.Ui64 != 0,                 // Ui64
			x.Ui32 != 0,                 // Ui32
			x.Ui16 != 0,                 // Ui16
			x.Ui8 != 0,                  // Ui8
			x.F64 != 0,                  // F64
			x.F32 != 0,                  // F32
			x.B,                         // B
			x.By != 0,                   // By
			len(x.Sslice) != 0,          // Sslice
			len(x.I64slice) != 0,        // I64slice
			len(x.I16slice) != 0,        // I16slice
			len(x.Ui64slice) != 0,       // Ui64slice
			len(x.Ui8slice) != 0,        // Ui8slice
			len(x.Bslice) != 0,          // Bslice
			len(x.Byslice) != 0,         // Byslice
			len(x.BytesSlice) != 0,      // BytesSlice
			len(x.Iptrslice) != 0,       // Iptrslice
			len(x.WrapSliceInt64) != 0,  // WrapSliceInt64
			len(x.WrapSliceString) != 0, // WrapSliceString
			len(x.Msi64) != 0,           // Msi64
			len(x.Msbytes) != 0,         // Msbytes
			false || x.Simplef.S != "" || x.Simplef.I64 != 0 || x.Simplef.I8 != 0 || x.Simplef.Ui64 != 0 || x.Simplef.Ui8 != 0 || x.Simplef.F64 != 0 || x.Simplef.F32 != 0 || x.Simplef.B || len(x.Simplef.Sslice) != 0 || len(x.Simplef.I16slice) != 0 || len(x.Simplef.Ui64slice) != 0 || len(x.Simplef.Ui8slice) != 0 || len(x.Simplef.Bslice) != 0 || len(x.Simplef.Iptrslice) != 0 || len(x.Simplef.WrapSliceInt64) != 0 || len(x.Simplef.WrapSliceString) != 0 || len(x.Simplef.Msi64) != 0, // Simplef
			len(x.SstrUi64T) != 0,   // SstrUi64T
			len(x.MstrUi64T) != 0,   // MstrUi64T
			x.AS != "",              // AS
			x.AI64 != 0,             // AI64
			x.AI16 != 0,             // AI16
			x.AUi64 != 0,            // AUi64
			len(x.ASslice) != 0,     // ASslice
			len(x.AI64slice) != 0,   // AI64slice
			len(x.AUi64slice) != 0,  // AUi64slice
			len(x.AF64slice) != 0,   // AF64slice
			len(x.AF32slice) != 0,   // AF32slice
			len(x.AMSU16) != 0,      // AMSU16
			len(x.AI64arr0) != 0,    // AI64arr0
			len(x.AI64slice0) != 0,  // AI64slice0
			len(x.AUi64sliceN) != 0, // AUi64sliceN
			len(x.AMSU16N) != 0,     // AMSU16N
			len(x.AMSU16E) != 0,     // AMSU16E
			false || x.NotAnon.AS != "" || x.NotAnon.AI64 != 0 || x.NotAnon.AI16 != 0 || x.NotAnon.AUi64 != 0 || len(x.NotAnon.ASslice) != 0 || len(x.NotAnon.AI64slice) != 0 || len(x.NotAnon.AUi64slice) != 0 || len(x.NotAnon.AF64slice) != 0 || len(x.NotAnon.AF32slice) != 0 || len(x.NotAnon.AMSU16) != 0 || len(x.NotAnon.AI64arr0) != 0 || len(x.NotAnon.AI64slice0) != 0 || len(x.NotAnon.AUi64sliceN) != 0 || len(x.NotAnon.AMSU16N) != 0 || len(x.NotAnon.AMSU16E) != 0, // NotAnon
			len(x.Nmap) != 0,           // Nmap
			len(x.Nslice) != 0,         // Nslice
			x.Nint64 != nil,            // Nint64
			len(x.Chstr) != 0,          // Chstr
			len(x.Mis) != 0,            // Mis
			len(x.Mbu64) != 0,          // Mbu64
			len(x.Miwu64s) != 0,        // Miwu64s
			len(x.Mfwss) != 0,          // Mfwss
			len(x.Mf32wss) != 0,        // Mf32wss
			len(x.Mui2wss) != 0,        // Mui2wss
			len(x.Msu2wss) != 0,        // Msu2wss
			x.Ci64 != 0,                // Ci64
			len(x.Swrapbytes) != 0,     // Swrapbytes
			len(x.Swrapuint8) != 0,     // Swrapuint8
			len(x.ArrStrUi64T) != 0,    // ArrStrUi64T
			len(x.Ui64array) != 0,      // Ui64array
			len(x.Ui64slicearray) != 0, // Ui64slicearray
			len(x.SintfAarray) != 0,    // SintfAarray
			len(x.MstrUi64TSelf) != 0,  // MstrUi64TSelf
			x.AnonInTestStrucIntf != nil && len(x.Islice) != 0, // Islice
			x.AnonInTestStrucIntf != nil && len(x.Ms) != 0,     // Ms
			x.AnonInTestStrucIntf != nil && x.Nintf != nil,     // Nintf
			x.AnonInTestStrucIntf != nil && !(x.T.IsZero()),    // T
			x.AnonInTestStrucIntf != nil && x.Tptr != nil,      // Tptr
			len(x.Mtsptr) != 0,  // Mtsptr
			len(x.Mts) != 0,     // Mts
			len(x.Its) != 0,     // Its
			x.Nteststruc != nil, // Nteststruc
		}
		_ = yyq2
		var yyn54 bool = x.TestStrucCommon.Nint64 == nil
		var yyn71 bool = x.AnonInTestStrucIntf == nil
		var yyn72 bool = x.AnonInTestStrucIntf == nil
		var yyn73 bool = x.AnonInTestStrucIntf == nil
		var yyn74 bool = x.AnonInTestStrucIntf == nil
		var yyn75 bool = x.AnonInTestStrucIntf == nil || x.AnonInTestStrucIntf.Tptr == nil
		var yyn79 bool = x.Nteststruc == nil
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(77)
			z.EncWriteArrayElem()
			if yyq2[0] {
				r.EncodeString(string(x.TestStrucCommon.S))
			} else {
				r.EncodeString("")
			}
			z.EncWriteArrayElem()
			if yyq2[1] {
				r.EncodeInt(int64(x.TestStrucCommon.I64))
			} else {
				r.EncodeInt(0)
			}
			z.EncWriteArrayElem()
			if yyq2[2] {
				r.EncodeInt(int64(x.TestStrucCommon.I32))
			} else {
				r.EncodeInt(0)
			}
			z.EncWriteArrayElem()
			if yyq2[3] {
				r.EncodeInt(int64(x.TestStrucCommon.I16))
			} else {
				r.EncodeInt(0)
			}
			z.EncWriteArrayElem()
			if yyq2[4] {
				r.EncodeInt(int64(x.TestStrucCommon.I8))
			} else {
				r.EncodeInt(0)
			}
			z.EncWriteArrayElem()
			if yyq2[5] {
				r.EncodeInt(int64(x.TestStrucCommon.I64n))
			} else {
				r.EncodeInt(0)
			}
			z.EncWriteArrayElem()
			if yyq2[6] {
				r.EncodeInt(int64(x.TestStrucCommon.I32n))
			} else {
				r.EncodeInt(0)
			}
			z.EncWriteArrayElem()
			if yyq2[7] {
				r.EncodeInt(int64(x.TestStrucCommon.I16n))
			} else {
				r.EncodeInt(0)
			}
			z.EncWriteArrayElem()
			if yyq2[8] {
				r.EncodeInt(int64(x.TestStrucCommon.I8n))
			} else {
				r.EncodeInt(0)
			}
			z.EncWriteArrayElem()
			if yyq2[9] {
				r.EncodeUint(uint64(x.TestStrucCommon.Ui64))
			} else {
				r.EncodeUint(0)
			}
			z.EncWriteArrayElem()
			if yyq2[10] {
				r.EncodeUint(uint64(x.TestStrucCommon.Ui32))
			} else {
				r.EncodeUint(0)
			}
			z.EncWriteArrayElem()
			if yyq2[11] {
				r.EncodeUint(uint64(x.TestStrucCommon.Ui16))
			} else {
				r.EncodeUint(0)
			}
			z.EncWriteArrayElem()
			if yyq2[12] {
				r.EncodeUint(uint64(x.TestStrucCommon.Ui8))
			} else {
				r.EncodeUint(0)
			}
			z.EncWriteArrayElem()
			if yyq2[13] {
				r.EncodeFloat64(float64(x.TestStrucCommon.F64))
			} else {
				r.EncodeFloat64(0)
			}
			z.EncWriteArrayElem()
			if yyq2[14] {
				r.EncodeFloat32(float32(x.TestStrucCommon.F32))
			} else {
				r.EncodeFloat32(0)
			}
			z.EncWriteArrayElem()
			if yyq2[15] {
				r.EncodeBool(bool(x.TestStrucCommon.B))
			} else {
				r.EncodeBool(false)
			}
			z.EncWriteArrayElem()
			if yyq2[16] {
				r.EncodeUint(uint64(x.TestStrucCommon.By))
			} else {
				r.EncodeUint(0)
			}
			z.EncWriteArrayElem()
			if yyq2[17] {
				if x.TestStrucCommon.Sslice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceStringV(x.TestStrucCommon.Sslice, e)
				} // end block: if x.TestStrucCommon.Sslice slice == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[18] {
				if x.TestStrucCommon.I64slice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceInt64V(x.TestStrucCommon.I64slice, e)
				} // end block: if x.TestStrucCommon.I64slice slice == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[19] {
				if x.TestStrucCommon.I16slice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceInt16V(x.TestStrucCommon.I16slice, e)
				} // end block: if x.TestStrucCommon.I16slice slice == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[20] {
				if x.TestStrucCommon.Ui64slice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceUint64V(x.TestStrucCommon.Ui64slice, e)
				} // end block: if x.TestStrucCommon.Ui64slice slice == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[21] {
				if x.TestStrucCommon.Ui8slice == nil {
					r.EncodeNil()
				} else {
					r.EncodeStringBytesRaw([]byte(x.TestStrucCommon.Ui8slice))
				} // end block: if x.TestStrucCommon.Ui8slice slice == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[22] {
				if x.TestStrucCommon.Bslice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceBoolV(x.TestStrucCommon.Bslice, e)
				} // end block: if x.TestStrucCommon.Bslice slice == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[23] {
				if x.TestStrucCommon.Byslice == nil {
					r.EncodeNil()
				} else {
					r.EncodeStringBytesRaw([]byte(x.TestStrucCommon.Byslice))
				} // end block: if x.TestStrucCommon.Byslice slice == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[24] {
				if x.TestStrucCommon.BytesSlice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceBytesV(x.TestStrucCommon.BytesSlice, e)
				} // end block: if x.TestStrucCommon.BytesSlice slice == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[25] {
				if x.TestStrucCommon.Iptrslice == nil {
					r.EncodeNil()
				} else {
					h.encSlicePtrtoint64(([]*int64)(x.TestStrucCommon.Iptrslice), e)
				} // end block: if x.TestStrucCommon.Iptrslice slice == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[26] {
				x.TestStrucCommon.WrapSliceInt64.CodecEncodeSelf(e)
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[27] {
				x.TestStrucCommon.WrapSliceString.CodecEncodeSelf(e)
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[28] {
				if x.TestStrucCommon.Msi64 == nil {
					r.EncodeNil()
				} else {
					z.F.EncMapStringInt64V(x.TestStrucCommon.Msi64, e)
				} // end block: if x.TestStrucCommon.Msi64 map == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[29] {
				if x.TestStrucCommon.Msbytes == nil {
					r.EncodeNil()
				} else {
					z.F.EncMapStringBytesV(x.TestStrucCommon.Msbytes, e)
				} // end block: if x.TestStrucCommon.Msbytes map == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[30] {
				yy110 := &x.TestStrucCommon.Simplef
				yy110.CodecEncodeSelf(e)
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[31] {
				if x.TestStrucCommon.SstrUi64T == nil {
					r.EncodeNil()
				} else {
					h.encSlicestringUint64T(([]stringUint64T)(x.TestStrucCommon.SstrUi64T), e)
				} // end block: if x.TestStrucCommon.SstrUi64T slice == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[32] {
				if x.TestStrucCommon.MstrUi64T == nil {
					r.EncodeNil()
				} else {
					h.encMapstringPtrtostringUint64T((map[string]*stringUint64T)(x.TestStrucCommon.MstrUi64T), e)
				} // end block: if x.TestStrucCommon.MstrUi64T map == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[33] {
				r.EncodeString(string(x.TestStrucCommon.AnonInTestStruc.AS))
			} else {
				r.EncodeString("")
			}
			z.EncWriteArrayElem()
			if yyq2[34] {
				r.EncodeInt(int64(x.TestStrucCommon.AnonInTestStruc.AI64))
			} else {
				r.EncodeInt(0)
			}
			z.EncWriteArrayElem()
			if yyq2[35] {
				r.EncodeInt(int64(x.TestStrucCommon.AnonInTestStruc.AI16))
			} else {
				r.EncodeInt(0)
			}
			z.EncWriteArrayElem()
			if yyq2[36] {
				r.EncodeUint(uint64(x.TestStrucCommon.AnonInTestStruc.AUi64))
			} else {
				r.EncodeUint(0)
			}
			z.EncWriteArrayElem()
			if yyq2[37] {
				if x.TestStrucCommon.AnonInTestStruc.ASslice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceStringV(x.TestStrucCommon.AnonInTestStruc.ASslice, e)
				} // end block: if x.TestStrucCommon.AnonInTestStruc.ASslice slice == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[38] {
				if x.TestStrucCommon.AnonInTestStruc.AI64slice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceInt64V(x.TestStrucCommon.AnonInTestStruc.AI64slice, e)
				} // end block: if x.TestStrucCommon.AnonInTestStruc.AI64slice slice == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[39] {
				if x.TestStrucCommon.AnonInTestStruc.AUi64slice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceUint64V(x.TestStrucCommon.AnonInTestStruc.AUi64slice, e)
				} // end block: if x.TestStrucCommon.AnonInTestStruc.AUi64slice slice == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[40] {
				if x.TestStrucCommon.AnonInTestStruc.AF64slice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceFloat64V(x.TestStrucCommon.AnonInTestStruc.AF64slice, e)
				} // end block: if x.TestStrucCommon.AnonInTestStruc.AF64slice slice == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[41] {
				if x.TestStrucCommon.AnonInTestStruc.AF32slice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceFloat32V(x.TestStrucCommon.AnonInTestStruc.AF32slice, e)
				} // end block: if x.TestStrucCommon.AnonInTestStruc.AF32slice slice == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[42] {
				if x.TestStrucCommon.AnonInTestStruc.AMSU16 == nil {
					r.EncodeNil()
				} else {
					h.encMapstringuint16((map[string]uint16)(x.TestStrucCommon.AnonInTestStruc.AMSU16), e)
				} // end block: if x.TestStrucCommon.AnonInTestStruc.AMSU16 map == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[43] {
				yy124 := &x.TestStrucCommon.AnonInTestStruc.AI64arr0
				h.encArray0int64((*[0]int64)(yy124), e)
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[44] {
				if x.TestStrucCommon.AnonInTestStruc.AI64slice0 == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceInt64V(x.TestStrucCommon.AnonInTestStruc.AI64slice0, e)
				} // end block: if x.TestStrucCommon.AnonInTestStruc.AI64slice0 slice == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[45] {
				if x.TestStrucCommon.AnonInTestStruc.AUi64sliceN == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceUint64V(x.TestStrucCommon.AnonInTestStruc.AUi64sliceN, e)
				} // end block: if x.TestStrucCommon.AnonInTestStruc.AUi64sliceN slice == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[46] {
				if x.TestStrucCommon.AnonInTestStruc.AMSU16N == nil {
					r.EncodeNil()
				} else {
					h.encMapstringuint16((map[string]uint16)(x.TestStrucCommon.AnonInTestStruc.AMSU16N), e)
				} // end block: if x.TestStrucCommon.AnonInTestStruc.AMSU16N map == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[47] {
				if x.TestStrucCommon.AnonInTestStruc.AMSU16E == nil {
					r.EncodeNil()
				} else {
					h.encMapstringuint16((map[string]uint16)(x.TestStrucCommon.AnonInTestStruc.AMSU16E), e)
				} // end block: if x.TestStrucCommon.AnonInTestStruc.AMSU16E map == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[48] {
				yy130 := &x.TestStrucCommon.NotAnon
				yy130.CodecEncodeSelf(e)
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[49] {
				if x.TestStrucCommon.Nmap == nil {
					r.EncodeNil()
				} else {
					z.F.EncMapStringBoolV(x.TestStrucCommon.Nmap, e)
				} // end block: if x.TestStrucCommon.Nmap map == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[50] {
				if x.TestStrucCommon.Nslice == nil {
					r.EncodeNil()
				} else {
					r.EncodeStringBytesRaw([]byte(x.TestStrucCommon.Nslice))
				} // end block: if x.TestStrucCommon.Nslice slice == nil
			} else {
				r.EncodeNil()
			}
			if yyn54 {
				z.EncWriteArrayElem()
				r.EncodeNil()
			} else {
				z.EncWriteArrayElem()
				if yyq2[51] {
					yy134 := *x.TestStrucCommon.Nint64
					r.EncodeInt(int64(yy134))
				} else {
					r.EncodeNil()
				}
			}
			z.EncWriteArrayElem()
			if yyq2[52] {
				h.encChanstring((chan string)(x.Chstr), e)
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[53] {
				if x.Mis == nil {
					r.EncodeNil()
				} else {
					z.F.EncMapIntStringV(x.Mis, e)
				} // end block: if x.Mis map == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[54] {
				if x.Mbu64 == nil {
					r.EncodeNil()
				} else {
					h.encMapboolc3RydWN0IHt9((map[bool]struct{})(x.Mbu64), e)
				} // end block: if x.Mbu64 map == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[55] {
				if x.Miwu64s == nil {
					r.EncodeNil()
				} else {
					h.encMapintwrapUint64Slice((map[int]wrapUint64Slice)(x.Miwu64s), e)
				} // end block: if x.Miwu64s map == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[56] {
				if x.Mfwss == nil {
					r.EncodeNil()
				} else {
					h.encMapfloat64wrapStringSlice((map[float64]wrapStringSlice)(x.Mfwss), e)
				} // end block: if x.Mfwss map == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[57] {
				if x.Mf32wss == nil {
					r.EncodeNil()
				} else {
					h.encMapfloat32wrapStringSlice((map[float32]wrapStringSlice)(x.Mf32wss), e)
				} // end block: if x.Mf32wss map == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[58] {
				if x.Mui2wss == nil {
					r.EncodeNil()
				} else {
					h.encMapuint64wrapStringSlice((map[uint64]wrapStringSlice)(x.Mui2wss), e)
				} // end block: if x.Mui2wss map == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[59] {
				if x.Msu2wss == nil {
					r.EncodeNil()
				} else {
					h.encMapstringUint64TwrapStringSlice((map[stringUint64T]wrapStringSlice)(x.Msu2wss), e)
				} // end block: if x.Msu2wss map == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[60] {
				x.Ci64.CodecEncodeSelf(e)
			} else {
				r.EncodeInt(0)
			}
			z.EncWriteArrayElem()
			if yyq2[61] {
				if x.Swrapbytes == nil {
					r.EncodeNil()
				} else {
					h.encSlicewrapBytes(([]wrapBytes)(x.Swrapbytes), e)
				} // end block: if x.Swrapbytes slice == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[62] {
				if x.Swrapuint8 == nil {
					r.EncodeNil()
				} else {
					h.encSlicewrapUint8(([]wrapUint8)(x.Swrapuint8), e)
				} // end block: if x.Swrapuint8 slice == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[63] {
				yy147 := &x.ArrStrUi64T
				h.encArray4stringUint64T((*[4]stringUint64T)(yy147), e)
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[64] {
				yy149 := &x.Ui64array
				h.encArray4uint64((*[4]uint64)(yy149), e)
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[65] {
				if x.Ui64slicearray == nil {
					r.EncodeNil()
				} else {
					h.encSlicePtrtoArray4uint64(([]*[4]uint64)(x.Ui64slicearray), e)
				} // end block: if x.Ui64slicearray slice == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[66] {
				if x.SintfAarray == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceIntfV(x.SintfAarray, e)
				} // end block: if x.SintfAarray slice == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[67] {
				if x.MstrUi64TSelf == nil {
					r.EncodeNil()
				} else {
					h.encMapstringUint64TPtrtostringUint64T((map[stringUint64T]*stringUint64T)(x.MstrUi64TSelf), e)
				} // end block: if x.MstrUi64TSelf map == nil
			} else {
				r.EncodeNil()
			}
			if yyn71 {
				z.EncWriteArrayElem()
				r.EncodeNil()
			} else {
				z.EncWriteArrayElem()
				if yyq2[68] {
					if x.AnonInTestStrucIntf.Islice == nil {
						r.EncodeNil()
					} else {
						z.F.EncSliceIntfV(x.AnonInTestStrucIntf.Islice, e)
					} // end block: if x.AnonInTestStrucIntf.Islice slice == nil
				} else {
					r.EncodeNil()
				}
			}
			if yyn72 {
				z.EncWriteArrayElem()
				r.EncodeNil()
			} else {
				z.EncWriteArrayElem()
				if yyq2[69] {
					if x.AnonInTestStrucIntf.Ms == nil {
						r.EncodeNil()
					} else {
						z.F.EncMapStringIntfV(x.AnonInTestStrucIntf.Ms, e)
					} // end block: if x.AnonInTestStrucIntf.Ms map == nil
				} else {
					r.EncodeNil()
				}
			}
			if yyn73 {
				z.EncWriteArrayElem()
				r.EncodeNil()
			} else {
				z.EncWriteArrayElem()
				if yyq2[70] {
					z.EncFallback(x.AnonInTestStrucIntf.Nintf)
				} else {
					r.EncodeNil()
				}
			}
			if yyn74 {
				z.EncWriteArrayElem()
				r.EncodeNil()
			} else {
				z.EncWriteArrayElem()
				if yyq2[71] {
					if !z.EncBasicHandle().TimeNotBuiltin {
						r.EncodeTime(x.AnonInTestStrucIntf.T)
					} else if yyxt157 := z.Extension(z.I2Rtid(x.AnonInTestStrucIntf.T)); yyxt157 != nil {
						z.EncExtension(x.AnonInTestStrucIntf.T, yyxt157)
					} else if z.EncBinary() {
						z.EncBinaryMarshal(x.AnonInTestStrucIntf.T)
					} else if !z.EncBinary() && z.IsJSONHandle() {
						z.EncJSONMarshal(x.AnonInTestStrucIntf.T)
					} else {
						z.EncFallback(x.AnonInTestStrucIntf.T)
					}
				} else {
					r.EncodeNil()
				}
			}
			if yyn75 {
				z.EncWriteArrayElem()
				r.EncodeNil()
			} else {
				z.EncWriteArrayElem()
				if yyq2[72] {
					yy158 := *x.AnonInTestStrucIntf.Tptr
					if !z.EncBasicHandle().TimeNotBuiltin {
						r.EncodeTime(yy158)
					} else if yyxt159 := z.Extension(z.I2Rtid(yy158)); yyxt159 != nil {
						z.EncExtension(yy158, yyxt159)
					} else if z.EncBinary() {
						z.EncBinaryMarshal(yy158)
					} else if !z.EncBinary() && z.IsJSONHandle() {
						z.EncJSONMarshal(yy158)
					} else {
						z.EncFallback(yy158)
					}
				} else {
					r.EncodeNil()
				}
			}
			z.EncWriteArrayElem()
			if yyq2[73] {
				if x.Mtsptr == nil {
					r.EncodeNil()
				} else {
					h.encMapstringPtrtoTestStrucFlex((map[string]*TestStrucFlex)(x.Mtsptr), e)
				} // end block: if x.Mtsptr map == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[74] {
				if x.Mts == nil {
					r.EncodeNil()
				} else {
					h.encMapstringTestStrucFlex((map[string]TestStrucFlex)(x.Mts), e)
				} // end block: if x.Mts map == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[75] {
				if x.Its == nil {
					r.EncodeNil()
				} else {
					h.encSlicePtrtoTestStrucFlex(([]*TestStrucFlex)(x.Its), e)
				} // end block: if x.Its slice == nil
			} else {
				r.EncodeNil()
			}
			if yyn79 {
				z.EncWriteArrayElem()
				r.EncodeNil()
			} else {
				z.EncWriteArrayElem()
				if yyq2[76] {
					x.Nteststruc.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			}
			z.EncWriteArrayEnd()
		} else {
			var yynn2 int
			for _, b := range yyq2 {
				if b {
					yynn2++
				}
			}
			z.EncWriteMapStart(yynn2)
			yynn2 = 0
			if yyq2[0] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"S\"")
				} else {
					r.EncodeString(`S`)
				}
				z.EncWriteMapElemValue()
				r.EncodeString(string(x.TestStrucCommon.S))
			}
			if yyq2[1] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"I64\"")
				} else {
					r.EncodeString(`I64`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.TestStrucCommon.I64))
			}
			if yyq2[2] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"I32\"")
				} else {
					r.EncodeString(`I32`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.TestStrucCommon.I32))
			}
			if yyq2[3] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"I16\"")
				} else {
					r.EncodeString(`I16`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.TestStrucCommon.I16))
			}
			if yyq2[4] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"I8\"")
				} else {
					r.EncodeString(`I8`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.TestStrucCommon.I8))
			}
			if yyq2[5] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"I64n\"")
				} else {
					r.EncodeString(`I64n`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.TestStrucCommon.I64n))
			}
			if yyq2[6] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"I32n\"")
				} else {
					r.EncodeString(`I32n`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.TestStrucCommon.I32n))
			}
			if yyq2[7] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"I16n\"")
				} else {
					r.EncodeString(`I16n`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.TestStrucCommon.I16n))
			}
			if yyq2[8] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"I8n\"")
				} else {
					r.EncodeString(`I8n`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.TestStrucCommon.I8n))
			}
			if yyq2[9] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"Ui64\"")
				} else {
					r.EncodeString(`Ui64`)
				}
				z.EncWriteMapElemValue()
				r.EncodeUint(uint64(x.TestStrucCommon.Ui64))
			}
			if yyq2[10] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"Ui32\"")
				} else {
					r.EncodeString(`Ui32`)
				}
				z.EncWriteMapElemValue()
				r.EncodeUint(uint64(x.TestStrucCommon.Ui32))
			}
			if yyq2[11] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"Ui16\"")
				} else {
					r.EncodeString(`Ui16`)
				}
				z.EncWriteMapElemValue()
				r.EncodeUint(uint64(x.TestStrucCommon.Ui16))
			}
			if yyq2[12] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"Ui8\"")
				} else {
					r.EncodeString(`Ui8`)
				}
				z.EncWriteMapElemValue()
				r.EncodeUint(uint64(x.TestStrucCommon.Ui8))
			}
			if yyq2[13] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"F64\"")
				} else {
					r.EncodeString(`F64`)
				}
				z.EncWriteMapElemValue()
				r.EncodeFloat64(float64(x.TestStrucCommon.F64))
			}
			if yyq2[14] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"F32\"")
				} else {
					r.EncodeString(`F32`)
				}
				z.EncWriteMapElemValue()
				r.EncodeFloat32(float32(x.TestStrucCommon.F32))
			}
			if yyq2[15] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"B\"")
				} else {
					r.EncodeString(`B`)
				}
				z.EncWriteMapElemValue()
				r.EncodeBool(bool(x.TestStrucCommon.B))
			}
			if yyq2[16] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"By\"")
				} else {
					r.EncodeString(`By`)
				}
				z.EncWriteMapElemValue()
				r.EncodeUint(uint64(x.TestStrucCommon.By))
			}
			if yyq2[17] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"Sslice\"")
				} else {
					r.EncodeString(`Sslice`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.Sslice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceStringV(x.TestStrucCommon.Sslice, e)
				} // end block: if x.TestStrucCommon.Sslice slice == nil
			}
			if yyq2[18] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"I64slice\"")
				} else {
					r.EncodeString(`I64slice`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.I64slice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceInt64V(x.TestStrucCommon.I64slice, e)
				} // end block: if x.TestStrucCommon.I64slice slice == nil
			}
			if yyq2[19] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"I16slice\"")
				} else {
					r.EncodeString(`I16slice`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.I16slice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceInt16V(x.TestStrucCommon.I16slice, e)
				} // end block: if x.TestStrucCommon.I16slice slice == nil
			}
			if yyq2[20] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"Ui64slice\"")
				} else {
					r.EncodeString(`Ui64slice`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.Ui64slice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceUint64V(x.TestStrucCommon.Ui64slice, e)
				} // end block: if x.TestStrucCommon.Ui64slice slice == nil
			}
			if yyq2[21] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"Ui8slice\"")
				} else {
					r.EncodeString(`Ui8slice`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.Ui8slice == nil {
					r.EncodeNil()
				} else {
					r.EncodeStringBytesRaw([]byte(x.TestStrucCommon.Ui8slice))
				} // end block: if x.TestStrucCommon.Ui8slice slice == nil
			}
			if yyq2[22] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"Bslice\"")
				} else {
					r.EncodeString(`Bslice`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.Bslice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceBoolV(x.TestStrucCommon.Bslice, e)
				} // end block: if x.TestStrucCommon.Bslice slice == nil
			}
			if yyq2[23] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"Byslice\"")
				} else {
					r.EncodeString(`Byslice`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.Byslice == nil {
					r.EncodeNil()
				} else {
					r.EncodeStringBytesRaw([]byte(x.TestStrucCommon.Byslice))
				} // end block: if x.TestStrucCommon.Byslice slice == nil
			}
			if yyq2[24] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"BytesSlice\"")
				} else {
					r.EncodeString(`BytesSlice`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.BytesSlice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceBytesV(x.TestStrucCommon.BytesSlice, e)
				} // end block: if x.TestStrucCommon.BytesSlice slice == nil
			}
			if yyq2[25] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"Iptrslice\"")
				} else {
					r.EncodeString(`Iptrslice`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.Iptrslice == nil {
					r.EncodeNil()
				} else {
					h.encSlicePtrtoint64(([]*int64)(x.TestStrucCommon.Iptrslice), e)
				} // end block: if x.TestStrucCommon.Iptrslice slice == nil
			}
			if yyq2[26] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"WrapSliceInt64\"")
				} else {
					r.EncodeString(`WrapSliceInt64`)
				}
				z.EncWriteMapElemValue()
				x.TestStrucCommon.WrapSliceInt64.CodecEncodeSelf(e)
			}
			if yyq2[27] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"WrapSliceString\"")
				} else {
					r.EncodeString(`WrapSliceString`)
				}
				z.EncWriteMapElemValue()
				x.TestStrucCommon.WrapSliceString.CodecEncodeSelf(e)
			}
			if yyq2[28] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"Msi64\"")
				} else {
					r.EncodeString(`Msi64`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.Msi64 == nil {
					r.EncodeNil()
				} else {
					z.F.EncMapStringInt64V(x.TestStrucCommon.Msi64, e)
				} // end block: if x.TestStrucCommon.Msi64 map == nil
			}
			if yyq2[29] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"Msbytes\"")
				} else {
					r.EncodeString(`Msbytes`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.Msbytes == nil {
					r.EncodeNil()
				} else {
					z.F.EncMapStringBytesV(x.TestStrucCommon.Msbytes, e)
				} // end block: if x.TestStrucCommon.Msbytes map == nil
			}
			if yyq2[30] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"Simplef\"")
				} else {
					r.EncodeString(`Simplef`)
				}
				z.EncWriteMapElemValue()
				yy194 := &x.TestStrucCommon.Simplef
				yy194.CodecEncodeSelf(e)
			}
			if yyq2[31] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"SstrUi64T\"")
				} else {
					r.EncodeString(`SstrUi64T`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.SstrUi64T == nil {
					r.EncodeNil()
				} else {
					h.encSlicestringUint64T(([]stringUint64T)(x.TestStrucCommon.SstrUi64T), e)
				} // end block: if x.TestStrucCommon.SstrUi64T slice == nil
			}
			if yyq2[32] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"MstrUi64T\"")
				} else {
					r.EncodeString(`MstrUi64T`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.MstrUi64T == nil {
					r.EncodeNil()
				} else {
					h.encMapstringPtrtostringUint64T((map[string]*stringUint64T)(x.TestStrucCommon.MstrUi64T), e)
				} // end block: if x.TestStrucCommon.MstrUi64T map == nil
			}
			if yyq2[33] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"AS\"")
				} else {
					r.EncodeString(`AS`)
				}
				z.EncWriteMapElemValue()
				r.EncodeString(string(x.TestStrucCommon.AnonInTestStruc.AS))
			}
			if yyq2[34] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"AI64\"")
				} else {
					r.EncodeString(`AI64`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.TestStrucCommon.AnonInTestStruc.AI64))
			}
			if yyq2[35] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"AI16\"")
				} else {
					r.EncodeString(`AI16`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.TestStrucCommon.AnonInTestStruc.AI16))
			}
			if yyq2[36] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"AUi64\"")
				} else {
					r.EncodeString(`AUi64`)
				}
				z.EncWriteMapElemValue()
				r.EncodeUint(uint64(x.TestStrucCommon.AnonInTestStruc.AUi64))
			}
			if yyq2[37] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"ASslice\"")
				} else {
					r.EncodeString(`ASslice`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.AnonInTestStruc.ASslice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceStringV(x.TestStrucCommon.AnonInTestStruc.ASslice, e)
				} // end block: if x.TestStrucCommon.AnonInTestStruc.ASslice slice == nil
			}
			if yyq2[38] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"AI64slice\"")
				} else {
					r.EncodeString(`AI64slice`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.AnonInTestStruc.AI64slice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceInt64V(x.TestStrucCommon.AnonInTestStruc.AI64slice, e)
				} // end block: if x.TestStrucCommon.AnonInTestStruc.AI64slice slice == nil
			}
			if yyq2[39] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"AUi64slice\"")
				} else {
					r.EncodeString(`AUi64slice`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.AnonInTestStruc.AUi64slice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceUint64V(x.TestStrucCommon.AnonInTestStruc.AUi64slice, e)
				} // end block: if x.TestStrucCommon.AnonInTestStruc.AUi64slice slice == nil
			}
			if yyq2[40] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"AF64slice\"")
				} else {
					r.EncodeString(`AF64slice`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.AnonInTestStruc.AF64slice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceFloat64V(x.TestStrucCommon.AnonInTestStruc.AF64slice, e)
				} // end block: if x.TestStrucCommon.AnonInTestStruc.AF64slice slice == nil
			}
			if yyq2[41] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"AF32slice\"")
				} else {
					r.EncodeString(`AF32slice`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.AnonInTestStruc.AF32slice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceFloat32V(x.TestStrucCommon.AnonInTestStruc.AF32slice, e)
				} // end block: if x.TestStrucCommon.AnonInTestStruc.AF32slice slice == nil
			}
			if yyq2[42] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"AMSU16\"")
				} else {
					r.EncodeString(`AMSU16`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.AnonInTestStruc.AMSU16 == nil {
					r.EncodeNil()
				} else {
					h.encMapstringuint16((map[string]uint16)(x.TestStrucCommon.AnonInTestStruc.AMSU16), e)
				} // end block: if x.TestStrucCommon.AnonInTestStruc.AMSU16 map == nil
			}
			if yyq2[43] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"AI64arr0\"")
				} else {
					r.EncodeString(`AI64arr0`)
				}
				z.EncWriteMapElemValue()
				yy208 := &x.TestStrucCommon.AnonInTestStruc.AI64arr0
				h.encArray0int64((*[0]int64)(yy208), e)
			}
			if yyq2[44] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"AI64slice0\"")
				} else {
					r.EncodeString(`AI64slice0`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.AnonInTestStruc.AI64slice0 == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceInt64V(x.TestStrucCommon.AnonInTestStruc.AI64slice0, e)
				} // end block: if x.TestStrucCommon.AnonInTestStruc.AI64slice0 slice == nil
			}
			if yyq2[45] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"AUi64sliceN\"")
				} else {
					r.EncodeString(`AUi64sliceN`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.AnonInTestStruc.AUi64sliceN == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceUint64V(x.TestStrucCommon.AnonInTestStruc.AUi64sliceN, e)
				} // end block: if x.TestStrucCommon.AnonInTestStruc.AUi64sliceN slice == nil
			}
			if yyq2[46] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"AMSU16N\"")
				} else {
					r.EncodeString(`AMSU16N`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.AnonInTestStruc.AMSU16N == nil {
					r.EncodeNil()
				} else {
					h.encMapstringuint16((map[string]uint16)(x.TestStrucCommon.AnonInTestStruc.AMSU16N), e)
				} // end block: if x.TestStrucCommon.AnonInTestStruc.AMSU16N map == nil
			}
			if yyq2[47] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"AMSU16E\"")
				} else {
					r.EncodeString(`AMSU16E`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.AnonInTestStruc.AMSU16E == nil {
					r.EncodeNil()
				} else {
					h.encMapstringuint16((map[string]uint16)(x.TestStrucCommon.AnonInTestStruc.AMSU16E), e)
				} // end block: if x.TestStrucCommon.AnonInTestStruc.AMSU16E map == nil
			}
			if yyq2[48] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"NotAnon\"")
				} else {
					r.EncodeString(`NotAnon`)
				}
				z.EncWriteMapElemValue()
				yy214 := &x.TestStrucCommon.NotAnon
				yy214.CodecEncodeSelf(e)
			}
			if yyq2[49] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"Nmap\"")
				} else {
					r.EncodeString(`Nmap`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.Nmap == nil {
					r.EncodeNil()
				} else {
					z.F.EncMapStringBoolV(x.TestStrucCommon.Nmap, e)
				} // end block: if x.TestStrucCommon.Nmap map == nil
			}
			if yyq2[50] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"Nslice\"")
				} else {
					r.EncodeString(`Nslice`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.Nslice == nil {
					r.EncodeNil()
				} else {
					r.EncodeStringBytesRaw([]byte(x.TestStrucCommon.Nslice))
				} // end block: if x.TestStrucCommon.Nslice slice == nil
			}
			if yyq2[51] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"Nint64\"")
				} else {
					r.EncodeString(`Nint64`)
				}
				z.EncWriteMapElemValue()
				if yyn54 {
					r.EncodeNil()
				} else {
					yy218 := *x.TestStrucCommon.Nint64
					r.EncodeInt(int64(yy218))
				}
			}
			if yyq2[52] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"Chstr\"")
				} else {
					r.EncodeString(`Chstr`)
				}
				z.EncWriteMapElemValue()
				h.encChanstring((chan string)(x.Chstr), e)
			}
			if yyq2[53] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"Mis\"")
				} else {
					r.EncodeString(`Mis`)
				}
				z.EncWriteMapElemValue()
				if x.Mis == nil {
					r.EncodeNil()
				} else {
					z.F.EncMapIntStringV(x.Mis, e)
				} // end block: if x.Mis map == nil
			}
			if yyq2[54] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"Mbu64\"")
				} else {
					r.EncodeString(`Mbu64`)
				}
				z.EncWriteMapElemValue()
				if x.Mbu64 == nil {
					r.EncodeNil()
				} else {
					h.encMapboolc3RydWN0IHt9((map[bool]struct{})(x.Mbu64), e)
				} // end block: if x.Mbu64 map == nil
			}
			if yyq2[55] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"Miwu64s\"")
				} else {
					r.EncodeString(`Miwu64s`)
				}
				z.EncWriteMapElemValue()
				if x.Miwu64s == nil {
					r.EncodeNil()
				} else {
					h.encMapintwrapUint64Slice((map[int]wrapUint64Slice)(x.Miwu64s), e)
				} // end block: if x.Miwu64s map == nil
			}
			if yyq2[56] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"Mfwss\"")
				} else {
					r.EncodeString(`Mfwss`)
				}
				z.EncWriteMapElemValue()
				if x.Mfwss == nil {
					r.EncodeNil()
				} else {
					h.encMapfloat64wrapStringSlice((map[float64]wrapStringSlice)(x.Mfwss), e)
				} // end block: if x.Mfwss map == nil
			}
			if yyq2[57] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"Mf32wss\"")
				} else {
					r.EncodeString(`Mf32wss`)
				}
				z.EncWriteMapElemValue()
				if x.Mf32wss == nil {
					r.EncodeNil()
				} else {
					h.encMapfloat32wrapStringSlice((map[float32]wrapStringSlice)(x.Mf32wss), e)
				} // end block: if x.Mf32wss map == nil
			}
			if yyq2[58] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"Mui2wss\"")
				} else {
					r.EncodeString(`Mui2wss`)
				}
				z.EncWriteMapElemValue()
				if x.Mui2wss == nil {
					r.EncodeNil()
				} else {
					h.encMapuint64wrapStringSlice((map[uint64]wrapStringSlice)(x.Mui2wss), e)
				} // end block: if x.Mui2wss map == nil
			}
			if yyq2[59] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"Msu2wss\"")
				} else {
					r.EncodeString(`Msu2wss`)
				}
				z.EncWriteMapElemValue()
				if x.Msu2wss == nil {
					r.EncodeNil()
				} else {
					h.encMapstringUint64TwrapStringSlice((map[stringUint64T]wrapStringSlice)(x.Msu2wss), e)
				} // end block: if x.Msu2wss map == nil
			}
			if yyq2[60] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"Ci64\"")
				} else {
					r.EncodeString(`Ci64`)
				}
				z.EncWriteMapElemValue()
				x.Ci64.CodecEncodeSelf(e)
			}
			if yyq2[61] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"Swrapbytes\"")
				} else {
					r.EncodeString(`Swrapbytes`)
				}
				z.EncWriteMapElemValue()
				if x.Swrapbytes == nil {
					r.EncodeNil()
				} else {
					h.encSlicewrapBytes(([]wrapBytes)(x.Swrapbytes), e)
				} // end block: if x.Swrapbytes slice == nil
			}
			if yyq2[62] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"Swrapuint8\"")
				} else {
					r.EncodeString(`Swrapuint8`)
				}
				z.EncWriteMapElemValue()
				if x.Swrapuint8 == nil {
					r.EncodeNil()
				} else {
					h.encSlicewrapUint8(([]wrapUint8)(x.Swrapuint8), e)
				} // end block: if x.Swrapuint8 slice == nil
			}
			if yyq2[63] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"ArrStrUi64T\"")
				} else {
					r.EncodeString(`ArrStrUi64T`)
				}
				z.EncWriteMapElemValue()
				yy231 := &x.ArrStrUi64T
				h.encArray4stringUint64T((*[4]stringUint64T)(yy231), e)
			}
			if yyq2[64] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"Ui64array\"")
				} else {
					r.EncodeString(`Ui64array`)
				}
				z.EncWriteMapElemValue()
				yy233 := &x.Ui64array
				h.encArray4uint64((*[4]uint64)(yy233), e)
			}
			if yyq2[65] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"Ui64slicearray\"")
				} else {
					r.EncodeString(`Ui64slicearray`)
				}
				z.EncWriteMapElemValue()
				if x.Ui64slicearray == nil {
					r.EncodeNil()
				} else {
					h.encSlicePtrtoArray4uint64(([]*[4]uint64)(x.Ui64slicearray), e)
				} // end block: if x.Ui64slicearray slice == nil
			}
			if yyq2[66] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"SintfAarray\"")
				} else {
					r.EncodeString(`SintfAarray`)
				}
				z.EncWriteMapElemValue()
				if x.SintfAarray == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceIntfV(x.SintfAarray, e)
				} // end block: if x.SintfAarray slice == nil
			}
			if yyq2[67] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"MstrUi64TSelf\"")
				} else {
					r.EncodeString(`MstrUi64TSelf`)
				}
				z.EncWriteMapElemValue()
				if x.MstrUi64TSelf == nil {
					r.EncodeNil()
				} else {
					h.encMapstringUint64TPtrtostringUint64T((map[stringUint64T]*stringUint64T)(x.MstrUi64TSelf), e)
				} // end block: if x.MstrUi64TSelf map == nil
			}
			if yyq2[68] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"Islice\"")
				} else {
					r.EncodeString(`Islice`)
				}
				z.EncWriteMapElemValue()
				if yyn71 {
					r.EncodeNil()
				} else {
					if x.AnonInTestStrucIntf.Islice == nil {
						r.EncodeNil()
					} else {
						z.F.EncSliceIntfV(x.AnonInTestStrucIntf.Islice, e)
					} // end block: if x.AnonInTestStrucIntf.Islice slice == nil
				}
			}
			if yyq2[69] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"Ms\"")
				} else {
					r.EncodeString(`Ms`)
				}
				z.EncWriteMapElemValue()
				if yyn72 {
					r.EncodeNil()
				} else {
					if x.AnonInTestStrucIntf.Ms == nil {
						r.EncodeNil()
					} else {
						z.F.EncMapStringIntfV(x.AnonInTestStrucIntf.Ms, e)
					} // end block: if x.AnonInTestStrucIntf.Ms map == nil
				}
			}
			if yyq2[70] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"Nintf\"")
				} else {
					r.EncodeString(`Nintf`)
				}
				z.EncWriteMapElemValue()
				if yyn73 {
					r.EncodeNil()
				} else {
					z.EncFallback(x.AnonInTestStrucIntf.Nintf)
				}
			}
			if yyq2[71] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"T\"")
				} else {
					r.EncodeString(`T`)
				}
				z.EncWriteMapElemValue()
				if yyn74 {
					r.EncodeNil()
				} else {
					if !z.EncBasicHandle().TimeNotBuiltin {
						r.EncodeTime(x.AnonInTestStrucIntf.T)
					} else if yyxt241 := z.Extension(z.I2Rtid(x.AnonInTestStrucIntf.T)); yyxt241 != nil {
						z.EncExtension(x.AnonInTestStrucIntf.T, yyxt241)
					} else if z.EncBinary() {
						z.EncBinaryMarshal(x.AnonInTestStrucIntf.T)
					} else if !z.EncBinary() && z.IsJSONHandle() {
						z.EncJSONMarshal(x.AnonInTestStrucIntf.T)
					} else {
						z.EncFallback(x.AnonInTestStrucIntf.T)
					}
				}
			}
			if yyq2[72] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"Tptr\"")
				} else {
					r.EncodeString(`Tptr`)
				}
				z.EncWriteMapElemValue()
				if yyn75 {
					r.EncodeNil()
				} else {
					yy242 := *x.AnonInTestStrucIntf.Tptr
					if !z.EncBasicHandle().TimeNotBuiltin {
						r.EncodeTime(yy242)
					} else if yyxt243 := z.Extension(z.I2Rtid(yy242)); yyxt243 != nil {
						z.EncExtension(yy242, yyxt243)
					} else if z.EncBinary() {
						z.EncBinaryMarshal(yy242)
					} else if !z.EncBinary() && z.IsJSONHandle() {
						z.EncJSONMarshal(yy242)
					} else {
						z.EncFallback(yy242)
					}
				}
			}
			if yyq2[73] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"Mtsptr\"")
				} else {
					r.EncodeString(`Mtsptr`)
				}
				z.EncWriteMapElemValue()
				if x.Mtsptr == nil {
					r.EncodeNil()
				} else {
					h.encMapstringPtrtoTestStrucFlex((map[string]*TestStrucFlex)(x.Mtsptr), e)
				} // end block: if x.Mtsptr map == nil
			}
			if yyq2[74] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"Mts\"")
				} else {
					r.EncodeString(`Mts`)
				}
				z.EncWriteMapElemValue()
				if x.Mts == nil {
					r.EncodeNil()
				} else {
					h.encMapstringTestStrucFlex((map[string]TestStrucFlex)(x.Mts), e)
				} // end block: if x.Mts map == nil
			}
			if yyq2[75] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"Its\"")
				} else {
					r.EncodeString(`Its`)
				}
				z.EncWriteMapElemValue()
				if x.Its == nil {
					r.EncodeNil()
				} else {
					h.encSlicePtrtoTestStrucFlex(([]*TestStrucFlex)(x.Its), e)
				} // end block: if x.Its slice == nil
			}
			if yyq2[76] {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.WriteStr("\"Nteststruc\"")
				} else {
					r.EncodeString(`Nteststruc`)
				}
				z.EncWriteMapElemValue()
				if yyn79 {
					r.EncodeNil()
				} else {
					x.Nteststruc.CodecEncodeSelf(e)
				}
			}
			z.EncWriteMapEnd()
		}
	}
}

func (x *TestStrucFlex) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil19780 {
		*(x) = TestStrucFlex{}
	} else if yyct2 == codecSelferValueTypeMap19780 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray19780 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct19780)
	}
}

func (x *TestStrucFlex) codecDecodeSelfFromMap(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if z.DecCheckBreak() {
				break
			}
		}
		z.DecReadMapElemKey()
		yys3 := z.StringView(r.DecodeStringAsBytes())
		z.DecReadMapElemValue()
		switch yys3 {
		case "S":
			x.TestStrucCommon.S = (string)(string(r.DecodeStringAsBytes()))
		case "I64":
			x.TestStrucCommon.I64 = (int64)(r.DecodeInt64())
		case "I32":
			x.TestStrucCommon.I32 = (int32)(z.C.IntV(r.DecodeInt64(), 32))
		case "I16":
			x.TestStrucCommon.I16 = (int16)(z.C.IntV(r.DecodeInt64(), 16))
		case "I8":
			x.TestStrucCommon.I8 = (int8)(z.C.IntV(r.DecodeInt64(), 8))
		case "I64n":
			x.TestStrucCommon.I64n = (int64)(r.DecodeInt64())
		case "I32n":
			x.TestStrucCommon.I32n = (int32)(z.C.IntV(r.DecodeInt64(), 32))
		case "I16n":
			x.TestStrucCommon.I16n = (int16)(z.C.IntV(r.DecodeInt64(), 16))
		case "I8n":
			x.TestStrucCommon.I8n = (int8)(z.C.IntV(r.DecodeInt64(), 8))
		case "Ui64":
			x.TestStrucCommon.Ui64 = (uint64)(r.DecodeUint64())
		case "Ui32":
			x.TestStrucCommon.Ui32 = (uint32)(z.C.UintV(r.DecodeUint64(), 32))
		case "Ui16":
			x.TestStrucCommon.Ui16 = (uint16)(z.C.UintV(r.DecodeUint64(), 16))
		case "Ui8":
			x.TestStrucCommon.Ui8 = (uint8)(z.C.UintV(r.DecodeUint64(), 8))
		case "F64":
			x.TestStrucCommon.F64 = (float64)(r.DecodeFloat64())
		case "F32":
			x.TestStrucCommon.F32 = (float32)(z.DecDecodeFloat32())
		case "B":
			x.TestStrucCommon.B = (bool)(r.DecodeBool())
		case "By":
			x.TestStrucCommon.By = (uint8)(z.C.UintV(r.DecodeUint64(), 8))
		case "Sslice":
			z.F.DecSliceStringX(&x.TestStrucCommon.Sslice, d)
		case "I64slice":
			z.F.DecSliceInt64X(&x.TestStrucCommon.I64slice, d)
		case "I16slice":
			z.F.DecSliceInt16X(&x.TestStrucCommon.I16slice, d)
		case "Ui64slice":
			z.F.DecSliceUint64X(&x.TestStrucCommon.Ui64slice, d)
		case "Ui8slice":
			x.TestStrucCommon.Ui8slice = r.DecodeBytes(([]byte)(x.TestStrucCommon.Ui8slice), false)
		case "Bslice":
			z.F.DecSliceBoolX(&x.TestStrucCommon.Bslice, d)
		case "Byslice":
			x.TestStrucCommon.Byslice = r.DecodeBytes(([]byte)(x.TestStrucCommon.Byslice), false)
		case "BytesSlice":
			z.F.DecSliceBytesX(&x.TestStrucCommon.BytesSlice, d)
		case "Iptrslice":
			h.decSlicePtrtoint64((*[]*int64)(&x.TestStrucCommon.Iptrslice), d)
		case "WrapSliceInt64":
			x.TestStrucCommon.WrapSliceInt64.CodecDecodeSelf(d)
		case "WrapSliceString":
			x.TestStrucCommon.WrapSliceString.CodecDecodeSelf(d)
		case "Msi64":
			z.F.DecMapStringInt64X(&x.TestStrucCommon.Msi64, d)
		case "Msbytes":
			z.F.DecMapStringBytesX(&x.TestStrucCommon.Msbytes, d)
		case "Simplef":
			x.TestStrucCommon.Simplef.CodecDecodeSelf(d)
		case "SstrUi64T":
			h.decSlicestringUint64T((*[]stringUint64T)(&x.TestStrucCommon.SstrUi64T), d)
		case "MstrUi64T":
			h.decMapstringPtrtostringUint64T((*map[string]*stringUint64T)(&x.TestStrucCommon.MstrUi64T), d)
		case "AS":
			x.TestStrucCommon.AnonInTestStruc.AS = (string)(string(r.DecodeStringAsBytes()))
		case "AI64":
			x.TestStrucCommon.AnonInTestStruc.AI64 = (int64)(r.DecodeInt64())
		case "AI16":
			x.TestStrucCommon.AnonInTestStruc.AI16 = (int16)(z.C.IntV(r.DecodeInt64(), 16))
		case "AUi64":
			x.TestStrucCommon.AnonInTestStruc.AUi64 = (uint64)(r.DecodeUint64())
		case "ASslice":
			z.F.DecSliceStringX(&x.TestStrucCommon.AnonInTestStruc.ASslice, d)
		case "AI64slice":
			z.F.DecSliceInt64X(&x.TestStrucCommon.AnonInTestStruc.AI64slice, d)
		case "AUi64slice":
			z.F.DecSliceUint64X(&x.TestStrucCommon.AnonInTestStruc.AUi64slice, d)
		case "AF64slice":
			z.F.DecSliceFloat64X(&x.TestStrucCommon.AnonInTestStruc.AF64slice, d)
		case "AF32slice":
			z.F.DecSliceFloat32X(&x.TestStrucCommon.AnonInTestStruc.AF32slice, d)
		case "AMSU16":
			h.decMapstringuint16((*map[string]uint16)(&x.TestStrucCommon.AnonInTestStruc.AMSU16), d)
		case "AI64arr0":
			h.decArray0int64((*[0]int64)(&x.TestStrucCommon.AnonInTestStruc.AI64arr0), d)
		case "AI64slice0":
			z.F.DecSliceInt64X(&x.TestStrucCommon.AnonInTestStruc.AI64slice0, d)
		case "AUi64sliceN":
			z.F.DecSliceUint64X(&x.TestStrucCommon.AnonInTestStruc.AUi64sliceN, d)
		case "AMSU16N":
			h.decMapstringuint16((*map[string]uint16)(&x.TestStrucCommon.AnonInTestStruc.AMSU16N), d)
		case "AMSU16E":
			h.decMapstringuint16((*map[string]uint16)(&x.TestStrucCommon.AnonInTestStruc.AMSU16E), d)
		case "NotAnon":
			x.TestStrucCommon.NotAnon.CodecDecodeSelf(d)
		case "Nmap":
			z.F.DecMapStringBoolX(&x.TestStrucCommon.Nmap, d)
		case "Nslice":
			x.TestStrucCommon.Nslice = r.DecodeBytes(([]byte)(x.TestStrucCommon.Nslice), false)
		case "Nint64":
			if r.TryNil() {
				if x.TestStrucCommon.Nint64 != nil { // remove the if-true
					x.TestStrucCommon.Nint64 = nil
				}
			} else {
				if x.TestStrucCommon.Nint64 == nil {
					x.TestStrucCommon.Nint64 = new(int64)
				}
				*x.TestStrucCommon.Nint64 = (int64)(r.DecodeInt64())
			}
		case "Chstr":
			h.decChanstring((*chan string)(&x.Chstr), d)
		case "Mis":
			z.F.DecMapIntStringX(&x.Mis, d)
		case "Mbu64":
			h.decMapboolc3RydWN0IHt9((*map[bool]struct{})(&x.Mbu64), d)
		case "Miwu64s":
			h.decMapintwrapUint64Slice((*map[int]wrapUint64Slice)(&x.Miwu64s), d)
		case "Mfwss":
			h.decMapfloat64wrapStringSlice((*map[float64]wrapStringSlice)(&x.Mfwss), d)
		case "Mf32wss":
			h.decMapfloat32wrapStringSlice((*map[float32]wrapStringSlice)(&x.Mf32wss), d)
		case "Mui2wss":
			h.decMapuint64wrapStringSlice((*map[uint64]wrapStringSlice)(&x.Mui2wss), d)
		case "Msu2wss":
			h.decMapstringUint64TwrapStringSlice((*map[stringUint64T]wrapStringSlice)(&x.Msu2wss), d)
		case "Ci64":
			x.Ci64.CodecDecodeSelf(d)
		case "Swrapbytes":
			h.decSlicewrapBytes((*[]wrapBytes)(&x.Swrapbytes), d)
		case "Swrapuint8":
			h.decSlicewrapUint8((*[]wrapUint8)(&x.Swrapuint8), d)
		case "ArrStrUi64T":
			h.decArray4stringUint64T((*[4]stringUint64T)(&x.ArrStrUi64T), d)
		case "Ui64array":
			h.decArray4uint64((*[4]uint64)(&x.Ui64array), d)
		case "Ui64slicearray":
			h.decSlicePtrtoArray4uint64((*[]*[4]uint64)(&x.Ui64slicearray), d)
		case "SintfAarray":
			z.F.DecSliceIntfX(&x.SintfAarray, d)
		case "MstrUi64TSelf":
			h.decMapstringUint64TPtrtostringUint64T((*map[stringUint64T]*stringUint64T)(&x.MstrUi64TSelf), d)
		case "Islice":
			if r.TryNil() {
				if x.AnonInTestStrucIntf != nil { // remove the if-true
					x.AnonInTestStrucIntf.Islice = nil
				}
			} else {
				if x.AnonInTestStrucIntf == nil {
					x.AnonInTestStrucIntf = new(AnonInTestStrucIntf)
				}
				z.F.DecSliceIntfX(&x.AnonInTestStrucIntf.Islice, d)
			}
		case "Ms":
			if r.TryNil() {
				if x.AnonInTestStrucIntf != nil { // remove the if-true
					x.AnonInTestStrucIntf.Ms = nil
				}
			} else {
				if x.AnonInTestStrucIntf == nil {
					x.AnonInTestStrucIntf = new(AnonInTestStrucIntf)
				}
				z.F.DecMapStringIntfX(&x.AnonInTestStrucIntf.Ms, d)
			}
		case "Nintf":
			if r.TryNil() {
				if x.AnonInTestStrucIntf != nil { // remove the if-true
					x.AnonInTestStrucIntf.Nintf = nil
				}
			} else {
				if x.AnonInTestStrucIntf == nil {
					x.AnonInTestStrucIntf = new(AnonInTestStrucIntf)
				}
				z.DecFallback(&x.AnonInTestStrucIntf.Nintf, true)
			}
		case "T":
			if r.TryNil() {
				if x.AnonInTestStrucIntf != nil { // remove the if-true
					x.AnonInTestStrucIntf.T = time.Time{}
				}
			} else {
				if x.AnonInTestStrucIntf == nil {
					x.AnonInTestStrucIntf = new(AnonInTestStrucIntf)
				}
				if !z.DecBasicHandle().TimeNotBuiltin {
					x.AnonInTestStrucIntf.T = r.DecodeTime()
				} else if yyxt121 := z.Extension(z.I2Rtid(x.AnonInTestStrucIntf.T)); yyxt121 != nil {
					z.DecExtension(x.AnonInTestStrucIntf.T, yyxt121)
				} else if z.DecBinary() {
					z.DecBinaryUnmarshal(&x.AnonInTestStrucIntf.T)
				} else if !z.DecBinary() && z.IsJSONHandle() {
					z.DecJSONUnmarshal(&x.AnonInTestStrucIntf.T)
				} else {
					z.DecFallback(&x.AnonInTestStrucIntf.T, false)
				}
			}
		case "Tptr":
			if r.TryNil() {
				if x.AnonInTestStrucIntf != nil && x.AnonInTestStrucIntf.Tptr != nil { // remove the if-true
					x.AnonInTestStrucIntf.Tptr = nil
				}
			} else {
				if x.AnonInTestStrucIntf == nil {
					x.AnonInTestStrucIntf = new(AnonInTestStrucIntf)
				}
				if x.AnonInTestStrucIntf.Tptr == nil {
					x.AnonInTestStrucIntf.Tptr = new(time.Time)
				}
				if !z.DecBasicHandle().TimeNotBuiltin {
					*x.AnonInTestStrucIntf.Tptr = r.DecodeTime()
				} else if yyxt123 := z.Extension(z.I2Rtid(x.AnonInTestStrucIntf.Tptr)); yyxt123 != nil {
					z.DecExtension(x.AnonInTestStrucIntf.Tptr, yyxt123)
				} else if z.DecBinary() {
					z.DecBinaryUnmarshal(x.AnonInTestStrucIntf.Tptr)
				} else if !z.DecBinary() && z.IsJSONHandle() {
					z.DecJSONUnmarshal(x.AnonInTestStrucIntf.Tptr)
				} else {
					z.DecFallback(x.AnonInTestStrucIntf.Tptr, false)
				}
			}
		case "Mtsptr":
			h.decMapstringPtrtoTestStrucFlex((*map[string]*TestStrucFlex)(&x.Mtsptr), d)
		case "Mts":
			h.decMapstringTestStrucFlex((*map[string]TestStrucFlex)(&x.Mts), d)
		case "Its":
			h.decSlicePtrtoTestStrucFlex((*[]*TestStrucFlex)(&x.Its), d)
		case "Nteststruc":
			if r.TryNil() {
				if x.Nteststruc != nil { // remove the if-true
					x.Nteststruc = nil
				}
			} else {
				if x.Nteststruc == nil {
					x.Nteststruc = new(TestStrucFlex)
				}
				x.Nteststruc.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
}

func (x *TestStrucFlex) codecDecodeSelfFromArray(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj131 int
	var yyb131 bool
	var yyhl131 bool = l >= 0
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.S = (string)(string(r.DecodeStringAsBytes()))
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.I64 = (int64)(r.DecodeInt64())
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.I32 = (int32)(z.C.IntV(r.DecodeInt64(), 32))
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.I16 = (int16)(z.C.IntV(r.DecodeInt64(), 16))
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.I8 = (int8)(z.C.IntV(r.DecodeInt64(), 8))
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.I64n = (int64)(r.DecodeInt64())
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.I32n = (int32)(z.C.IntV(r.DecodeInt64(), 32))
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.I16n = (int16)(z.C.IntV(r.DecodeInt64(), 16))
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.I8n = (int8)(z.C.IntV(r.DecodeInt64(), 8))
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.Ui64 = (uint64)(r.DecodeUint64())
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.Ui32 = (uint32)(z.C.UintV(r.DecodeUint64(), 32))
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.Ui16 = (uint16)(z.C.UintV(r.DecodeUint64(), 16))
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.Ui8 = (uint8)(z.C.UintV(r.DecodeUint64(), 8))
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.F64 = (float64)(r.DecodeFloat64())
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.F32 = (float32)(z.DecDecodeFloat32())
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.B = (bool)(r.DecodeBool())
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.By = (uint8)(z.C.UintV(r.DecodeUint64(), 8))
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceStringX(&x.TestStrucCommon.Sslice, d)
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceInt64X(&x.TestStrucCommon.I64slice, d)
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceInt16X(&x.TestStrucCommon.I16slice, d)
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceUint64X(&x.TestStrucCommon.Ui64slice, d)
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.Ui8slice = r.DecodeBytes(([]byte)(x.TestStrucCommon.Ui8slice), false)
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceBoolX(&x.TestStrucCommon.Bslice, d)
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.Byslice = r.DecodeBytes(([]byte)(x.TestStrucCommon.Byslice), false)
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceBytesX(&x.TestStrucCommon.BytesSlice, d)
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decSlicePtrtoint64((*[]*int64)(&x.TestStrucCommon.Iptrslice), d)
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.WrapSliceInt64.CodecDecodeSelf(d)
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.WrapSliceString.CodecDecodeSelf(d)
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecMapStringInt64X(&x.TestStrucCommon.Msi64, d)
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecMapStringBytesX(&x.TestStrucCommon.Msbytes, d)
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.Simplef.CodecDecodeSelf(d)
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decSlicestringUint64T((*[]stringUint64T)(&x.TestStrucCommon.SstrUi64T), d)
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decMapstringPtrtostringUint64T((*map[string]*stringUint64T)(&x.TestStrucCommon.MstrUi64T), d)
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.AnonInTestStruc.AS = (string)(string(r.DecodeStringAsBytes()))
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.AnonInTestStruc.AI64 = (int64)(r.DecodeInt64())
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.AnonInTestStruc.AI16 = (int16)(z.C.IntV(r.DecodeInt64(), 16))
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.AnonInTestStruc.AUi64 = (uint64)(r.DecodeUint64())
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceStringX(&x.TestStrucCommon.AnonInTestStruc.ASslice, d)
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceInt64X(&x.TestStrucCommon.AnonInTestStruc.AI64slice, d)
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceUint64X(&x.TestStrucCommon.AnonInTestStruc.AUi64slice, d)
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceFloat64X(&x.TestStrucCommon.AnonInTestStruc.AF64slice, d)
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceFloat32X(&x.TestStrucCommon.AnonInTestStruc.AF32slice, d)
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decMapstringuint16((*map[string]uint16)(&x.TestStrucCommon.AnonInTestStruc.AMSU16), d)
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decArray0int64((*[0]int64)(&x.TestStrucCommon.AnonInTestStruc.AI64arr0), d)
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceInt64X(&x.TestStrucCommon.AnonInTestStruc.AI64slice0, d)
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceUint64X(&x.TestStrucCommon.AnonInTestStruc.AUi64sliceN, d)
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decMapstringuint16((*map[string]uint16)(&x.TestStrucCommon.AnonInTestStruc.AMSU16N), d)
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decMapstringuint16((*map[string]uint16)(&x.TestStrucCommon.AnonInTestStruc.AMSU16E), d)
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.NotAnon.CodecDecodeSelf(d)
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecMapStringBoolX(&x.TestStrucCommon.Nmap, d)
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.Nslice = r.DecodeBytes(([]byte)(x.TestStrucCommon.Nslice), false)
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if r.TryNil() {
		if x.TestStrucCommon.Nint64 != nil { // remove the if-true
			x.TestStrucCommon.Nint64 = nil
		}
	} else {
		if x.TestStrucCommon.Nint64 == nil {
			x.TestStrucCommon.Nint64 = new(int64)
		}
		*x.TestStrucCommon.Nint64 = (int64)(r.DecodeInt64())
	}
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decChanstring((*chan string)(&x.Chstr), d)
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecMapIntStringX(&x.Mis, d)
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decMapboolc3RydWN0IHt9((*map[bool]struct{})(&x.Mbu64), d)
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decMapintwrapUint64Slice((*map[int]wrapUint64Slice)(&x.Miwu64s), d)
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decMapfloat64wrapStringSlice((*map[float64]wrapStringSlice)(&x.Mfwss), d)
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decMapfloat32wrapStringSlice((*map[float32]wrapStringSlice)(&x.Mf32wss), d)
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decMapuint64wrapStringSlice((*map[uint64]wrapStringSlice)(&x.Mui2wss), d)
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decMapstringUint64TwrapStringSlice((*map[stringUint64T]wrapStringSlice)(&x.Msu2wss), d)
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.Ci64.CodecDecodeSelf(d)
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decSlicewrapBytes((*[]wrapBytes)(&x.Swrapbytes), d)
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decSlicewrapUint8((*[]wrapUint8)(&x.Swrapuint8), d)
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decArray4stringUint64T((*[4]stringUint64T)(&x.ArrStrUi64T), d)
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decArray4uint64((*[4]uint64)(&x.Ui64array), d)
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decSlicePtrtoArray4uint64((*[]*[4]uint64)(&x.Ui64slicearray), d)
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceIntfX(&x.SintfAarray, d)
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decMapstringUint64TPtrtostringUint64T((*map[stringUint64T]*stringUint64T)(&x.MstrUi64TSelf), d)
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if r.TryNil() {
		if x.AnonInTestStrucIntf != nil { // remove the if-true
			x.AnonInTestStrucIntf.Islice = nil
		}
	} else {
		if x.AnonInTestStrucIntf == nil {
			x.AnonInTestStrucIntf = new(AnonInTestStrucIntf)
		}
		z.F.DecSliceIntfX(&x.AnonInTestStrucIntf.Islice, d)
	}
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if r.TryNil() {
		if x.AnonInTestStrucIntf != nil { // remove the if-true
			x.AnonInTestStrucIntf.Ms = nil
		}
	} else {
		if x.AnonInTestStrucIntf == nil {
			x.AnonInTestStrucIntf = new(AnonInTestStrucIntf)
		}
		z.F.DecMapStringIntfX(&x.AnonInTestStrucIntf.Ms, d)
	}
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if r.TryNil() {
		if x.AnonInTestStrucIntf != nil { // remove the if-true
			x.AnonInTestStrucIntf.Nintf = nil
		}
	} else {
		if x.AnonInTestStrucIntf == nil {
			x.AnonInTestStrucIntf = new(AnonInTestStrucIntf)
		}
		z.DecFallback(&x.AnonInTestStrucIntf.Nintf, true)
	}
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if r.TryNil() {
		if x.AnonInTestStrucIntf != nil { // remove the if-true
			x.AnonInTestStrucIntf.T = time.Time{}
		}
	} else {
		if x.AnonInTestStrucIntf == nil {
			x.AnonInTestStrucIntf = new(AnonInTestStrucIntf)
		}
		if !z.DecBasicHandle().TimeNotBuiltin {
			x.AnonInTestStrucIntf.T = r.DecodeTime()
		} else if yyxt249 := z.Extension(z.I2Rtid(x.AnonInTestStrucIntf.T)); yyxt249 != nil {
			z.DecExtension(x.AnonInTestStrucIntf.T, yyxt249)
		} else if z.DecBinary() {
			z.DecBinaryUnmarshal(&x.AnonInTestStrucIntf.T)
		} else if !z.DecBinary() && z.IsJSONHandle() {
			z.DecJSONUnmarshal(&x.AnonInTestStrucIntf.T)
		} else {
			z.DecFallback(&x.AnonInTestStrucIntf.T, false)
		}
	}
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if r.TryNil() {
		if x.AnonInTestStrucIntf != nil && x.AnonInTestStrucIntf.Tptr != nil { // remove the if-true
			x.AnonInTestStrucIntf.Tptr = nil
		}
	} else {
		if x.AnonInTestStrucIntf == nil {
			x.AnonInTestStrucIntf = new(AnonInTestStrucIntf)
		}
		if x.AnonInTestStrucIntf.Tptr == nil {
			x.AnonInTestStrucIntf.Tptr = new(time.Time)
		}
		if !z.DecBasicHandle().TimeNotBuiltin {
			*x.AnonInTestStrucIntf.Tptr = r.DecodeTime()
		} else if yyxt251 := z.Extension(z.I2Rtid(x.AnonInTestStrucIntf.Tptr)); yyxt251 != nil {
			z.DecExtension(x.AnonInTestStrucIntf.Tptr, yyxt251)
		} else if z.DecBinary() {
			z.DecBinaryUnmarshal(x.AnonInTestStrucIntf.Tptr)
		} else if !z.DecBinary() && z.IsJSONHandle() {
			z.DecJSONUnmarshal(x.AnonInTestStrucIntf.Tptr)
		} else {
			z.DecFallback(x.AnonInTestStrucIntf.Tptr, false)
		}
	}
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decMapstringPtrtoTestStrucFlex((*map[string]*TestStrucFlex)(&x.Mtsptr), d)
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decMapstringTestStrucFlex((*map[string]TestStrucFlex)(&x.Mts), d)
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decSlicePtrtoTestStrucFlex((*[]*TestStrucFlex)(&x.Its), d)
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = z.DecCheckBreak()
	}
	if yyb131 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if r.TryNil() {
		if x.Nteststruc != nil { // remove the if-true
			x.Nteststruc = nil
		}
	} else {
		if x.Nteststruc == nil {
			x.Nteststruc = new(TestStrucFlex)
		}
		x.Nteststruc.CodecDecodeSelf(d)
	}
	for {
		yyj131++
		if yyhl131 {
			yyb131 = yyj131 > l
		} else {
			yyb131 = z.DecCheckBreak()
		}
		if yyb131 {
			break
		}
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj131-1, "")
	}
}

func (x codecSelfer19780) encwrapSliceUint64(v wrapSliceUint64, e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
		return
	}
	z.EncWriteArrayStart(len(v))
	for _, yyv1 := range v {
		z.EncWriteArrayElem()
		r.EncodeUint(uint64(yyv1))
	}
	z.EncWriteArrayEnd()
}

func (x codecSelfer19780) decwrapSliceUint64(v *wrapSliceUint64, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1 := *v
	yyh1, yyl1 := z.DecSliceHelperStart()
	var yyc1 bool
	_ = yyc1
	if yyh1.IsNil {
		if yyv1 != nil {
			yyv1 = nil
			yyc1 = true
		}
	} else if yyl1 == 0 {
		if yyv1 == nil {
			yyv1 = []uint64{}
			yyc1 = true
		} else if len(yyv1) != 0 {
			yyv1 = yyv1[:0]
			yyc1 = true
		}
	} else {
		yyhl1 := yyl1 > 0
		var yyrl1 int
		_ = yyrl1
		if yyhl1 {
			if yyl1 > cap(yyv1) {
				yyrl1 = z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 8)
				if yyrl1 <= cap(yyv1) {
					yyv1 = yyv1[:yyrl1]
				} else {
					yyv1 = make([]uint64, yyrl1)
				}
				yyc1 = true
			} else if yyl1 != len(yyv1) {
				yyv1 = yyv1[:yyl1]
				yyc1 = true
			}
		}
		var yyj1 int
		for yyj1 = 0; (yyhl1 && yyj1 < yyl1) || !(yyhl1 || z.DecCheckBreak()); yyj1++ { // bounds-check-elimination
			if yyj1 == 0 && yyv1 == nil {
				if yyhl1 {
					yyrl1 = z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 8)
				} else {
					yyrl1 = 8
				}
				yyv1 = make([]uint64, yyrl1)
				yyc1 = true
			}
			yyh1.ElemContainerState(yyj1)
			var yydb1 bool
			if yyj1 >= len(yyv1) {
				yyv1 = append(yyv1, 0)
				yyc1 = true
			}
			if yydb1 {
				z.DecSwallow()
			} else {
				yyv1[yyj1] = (uint64)(r.DecodeUint64())
			}
		}
		if yyj1 < len(yyv1) {
			yyv1 = yyv1[:yyj1]
			yyc1 = true
		} else if yyj1 == 0 && yyv1 == nil {
			yyv1 = make([]uint64, 0)
			yyc1 = true
		}
	}
	yyh1.End()
	if yyc1 {
		*v = yyv1
	}
}

func (x codecSelfer19780) encwrapSliceString(v wrapSliceString, e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
		return
	}
	z.EncWriteArrayStart(len(v))
	for _, yyv1 := range v {
		z.EncWriteArrayElem()
		r.EncodeString(string(yyv1))
	}
	z.EncWriteArrayEnd()
}

func (x codecSelfer19780) decwrapSliceString(v *wrapSliceString, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1 := *v
	yyh1, yyl1 := z.DecSliceHelperStart()
	var yyc1 bool
	_ = yyc1
	if yyh1.IsNil {
		if yyv1 != nil {
			yyv1 = nil
			yyc1 = true
		}
	} else if yyl1 == 0 {
		if yyv1 == nil {
			yyv1 = []string{}
			yyc1 = true
		} else if len(yyv1) != 0 {
			yyv1 = yyv1[:0]
			yyc1 = true
		}
	} else {
		yyhl1 := yyl1 > 0
		var yyrl1 int
		_ = yyrl1
		if yyhl1 {
			if yyl1 > cap(yyv1) {
				yyrl1 = z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 16)
				if yyrl1 <= cap(yyv1) {
					yyv1 = yyv1[:yyrl1]
				} else {
					yyv1 = make([]string, yyrl1)
				}
				yyc1 = true
			} else if yyl1 != len(yyv1) {
				yyv1 = yyv1[:yyl1]
				yyc1 = true
			}
		}
		var yyj1 int
		for yyj1 = 0; (yyhl1 && yyj1 < yyl1) || !(yyhl1 || z.DecCheckBreak()); yyj1++ { // bounds-check-elimination
			if yyj1 == 0 && yyv1 == nil {
				if yyhl1 {
					yyrl1 = z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 16)
				} else {
					yyrl1 = 8
				}
				yyv1 = make([]string, yyrl1)
				yyc1 = true
			}
			yyh1.ElemContainerState(yyj1)
			var yydb1 bool
			if yyj1 >= len(yyv1) {
				yyv1 = append(yyv1, "")
				yyc1 = true
			}
			if yydb1 {
				z.DecSwallow()
			} else {
				yyv1[yyj1] = (string)(string(r.DecodeStringAsBytes()))
			}
		}
		if yyj1 < len(yyv1) {
			yyv1 = yyv1[:yyj1]
			yyc1 = true
		} else if yyj1 == 0 && yyv1 == nil {
			yyv1 = make([]string, 0)
			yyc1 = true
		}
	}
	yyh1.End()
	if yyc1 {
		*v = yyv1
	}
}

func (x codecSelfer19780) encwrapUint64Slice(v wrapUint64Slice, e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
		return
	}
	z.EncWriteArrayStart(len(v))
	for _, yyv1 := range v {
		z.EncWriteArrayElem()
		yyv1.CodecEncodeSelf(e)
	}
	z.EncWriteArrayEnd()
}

func (x codecSelfer19780) decwrapUint64Slice(v *wrapUint64Slice, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1 := *v
	yyh1, yyl1 := z.DecSliceHelperStart()
	var yyc1 bool
	_ = yyc1
	if yyh1.IsNil {
		if yyv1 != nil {
			yyv1 = nil
			yyc1 = true
		}
	} else if yyl1 == 0 {
		if yyv1 == nil {
			yyv1 = []wrapUint64{}
			yyc1 = true
		} else if len(yyv1) != 0 {
			yyv1 = yyv1[:0]
			yyc1 = true
		}
	} else {
		yyhl1 := yyl1 > 0
		var yyrl1 int
		_ = yyrl1
		if yyhl1 {
			if yyl1 > cap(yyv1) {
				yyrl1 = z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 8)
				if yyrl1 <= cap(yyv1) {
					yyv1 = yyv1[:yyrl1]
				} else {
					yyv1 = make([]wrapUint64, yyrl1)
				}
				yyc1 = true
			} else if yyl1 != len(yyv1) {
				yyv1 = yyv1[:yyl1]
				yyc1 = true
			}
		}
		var yyj1 int
		for yyj1 = 0; (yyhl1 && yyj1 < yyl1) || !(yyhl1 || z.DecCheckBreak()); yyj1++ { // bounds-check-elimination
			if yyj1 == 0 && yyv1 == nil {
				if yyhl1 {
					yyrl1 = z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 8)
				} else {
					yyrl1 = 8
				}
				yyv1 = make([]wrapUint64, yyrl1)
				yyc1 = true
			}
			yyh1.ElemContainerState(yyj1)
			var yydb1 bool
			if yyj1 >= len(yyv1) {
				yyv1 = append(yyv1, 0)
				yyc1 = true
			}
			if yydb1 {
				z.DecSwallow()
			} else {
				yyv1[yyj1].CodecDecodeSelf(d)
			}
		}
		if yyj1 < len(yyv1) {
			yyv1 = yyv1[:yyj1]
			yyc1 = true
		} else if yyj1 == 0 && yyv1 == nil {
			yyv1 = make([]wrapUint64, 0)
			yyc1 = true
		}
	}
	yyh1.End()
	if yyc1 {
		*v = yyv1
	}
}

func (x codecSelfer19780) encwrapStringSlice(v wrapStringSlice, e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
		return
	}
	z.EncWriteArrayStart(len(v))
	for _, yyv1 := range v {
		z.EncWriteArrayElem()
		yyv1.CodecEncodeSelf(e)
	}
	z.EncWriteArrayEnd()
}

func (x codecSelfer19780) decwrapStringSlice(v *wrapStringSlice, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1 := *v
	yyh1, yyl1 := z.DecSliceHelperStart()
	var yyc1 bool
	_ = yyc1
	if yyh1.IsNil {
		if yyv1 != nil {
			yyv1 = nil
			yyc1 = true
		}
	} else if yyl1 == 0 {
		if yyv1 == nil {
			yyv1 = []wrapString{}
			yyc1 = true
		} else if len(yyv1) != 0 {
			yyv1 = yyv1[:0]
			yyc1 = true
		}
	} else {
		yyhl1 := yyl1 > 0
		var yyrl1 int
		_ = yyrl1
		if yyhl1 {
			if yyl1 > cap(yyv1) {
				yyrl1 = z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 16)
				if yyrl1 <= cap(yyv1) {
					yyv1 = yyv1[:yyrl1]
				} else {
					yyv1 = make([]wrapString, yyrl1)
				}
				yyc1 = true
			} else if yyl1 != len(yyv1) {
				yyv1 = yyv1[:yyl1]
				yyc1 = true
			}
		}
		var yyj1 int
		for yyj1 = 0; (yyhl1 && yyj1 < yyl1) || !(yyhl1 || z.DecCheckBreak()); yyj1++ { // bounds-check-elimination
			if yyj1 == 0 && yyv1 == nil {
				if yyhl1 {
					yyrl1 = z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 16)
				} else {
					yyrl1 = 8
				}
				yyv1 = make([]wrapString, yyrl1)
				yyc1 = true
			}
			yyh1.ElemContainerState(yyj1)
			var yydb1 bool
			if yyj1 >= len(yyv1) {
				yyv1 = append(yyv1, "")
				yyc1 = true
			}
			if yydb1 {
				z.DecSwallow()
			} else {
				yyv1[yyj1].CodecDecodeSelf(d)
			}
		}
		if yyj1 < len(yyv1) {
			yyv1 = yyv1[:yyj1]
			yyc1 = true
		} else if yyj1 == 0 && yyv1 == nil {
			yyv1 = make([]wrapString, 0)
			yyc1 = true
		}
	}
	yyh1.End()
	if yyc1 {
		*v = yyv1
	}
}

func (x codecSelfer19780) encMapstringuint16(v map[string]uint16, e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
		return
	}
	z.EncWriteMapStart(len(v))
	for yyk1, yyv1 := range v {
		z.EncWriteMapElemKey()
		r.EncodeString(string(yyk1))
		z.EncWriteMapElemValue()
		r.EncodeUint(uint64(yyv1))
	}
	z.EncWriteMapEnd()
}

func (x codecSelfer19780) decMapstringuint16(v *map[string]uint16, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1 := *v
	yyl1 := z.DecReadMapStart()
	if yyl1 == codecSelferDecContainerLenNil19780 {
		*v = nil
	} else {
		if yyv1 == nil {
			yyrl1 := z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 18)
			yyv1 = make(map[string]uint16, yyrl1)
			*v = yyv1
		}
		var yymk1 string
		var yymv1 uint16
		var yymg1, yymdn1 bool
		if z.DecBasicHandle().MapValueReset {
		}
		if yyl1 != 0 {
			yyhl1 := yyl1 > 0
			for yyj1 := 0; (yyhl1 && yyj1 < yyl1) || !(yyhl1 || z.DecCheckBreak()); yyj1++ {
				z.DecReadMapElemKey()
				yymk1 = (string)(string(r.DecodeStringAsBytes()))
				if yymg1 {
					yymv1 = yyv1[yymk1]
				}
				z.DecReadMapElemValue()
				yymdn1 = false
				yymv1 = (uint16)(z.C.UintV(r.DecodeUint64(), 16))
				if yymdn1 {
					if z.DecBasicHandle().DeleteOnNilMapValue {
						delete(yyv1, yymk1)
					} else {
						yyv1[yymk1] = 0
					}
				} else if yyv1 != nil {
					yyv1[yymk1] = yymv1
				}
			}
		} // else len==0: TODO: Should we clear map entries?
		z.DecReadMapEnd()
	}
}

func (x codecSelfer19780) encArray0int64(v *[0]int64, e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
		return
	}
	z.EncWriteArrayStart(len(v))
	for _, yyv1 := range v {
		z.EncWriteArrayElem()
		r.EncodeInt(int64(yyv1))
	}
	z.EncWriteArrayEnd()
}

func (x codecSelfer19780) decArray0int64(v *[0]int64, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1 := v
	yyh1, yyl1 := z.DecSliceHelperStart()
	if yyl1 == 0 {
	} else {
		yyhl1 := yyl1 > 0
		var yyrl1 int
		_ = yyrl1
		var yyj1 int
		for yyj1 = 0; (yyhl1 && yyj1 < yyl1) || !(yyhl1 || z.DecCheckBreak()); yyj1++ { // bounds-check-elimination
			yyh1.ElemContainerState(yyj1)
			var yydb1 bool
			if yyj1 >= len(yyv1) {
				z.DecArrayCannotExpand(len(v), yyj1+1)
				yydb1 = true
			}
			if yydb1 {
				z.DecSwallow()
			} else {
				yyv1[yyj1] = (int64)(r.DecodeInt64())
			}
		}
	}
	yyh1.End()
}

func (x codecSelfer19780) encSlicePtrtoint64(v []*int64, e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
		return
	}
	z.EncWriteArrayStart(len(v))
	for _, yyv1 := range v {
		z.EncWriteArrayElem()
		if yyv1 == nil {
			r.EncodeNil()
		} else {
			yy2 := *yyv1
			r.EncodeInt(int64(yy2))
		}
	}
	z.EncWriteArrayEnd()
}

func (x codecSelfer19780) decSlicePtrtoint64(v *[]*int64, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1 := *v
	yyh1, yyl1 := z.DecSliceHelperStart()
	var yyc1 bool
	_ = yyc1
	if yyh1.IsNil {
		if yyv1 != nil {
			yyv1 = nil
			yyc1 = true
		}
	} else if yyl1 == 0 {
		if yyv1 == nil {
			yyv1 = []*int64{}
			yyc1 = true
		} else if len(yyv1) != 0 {
			yyv1 = yyv1[:0]
			yyc1 = true
		}
	} else {
		yyhl1 := yyl1 > 0
		var yyrl1 int
		_ = yyrl1
		if yyhl1 {
			if yyl1 > cap(yyv1) {
				yyrl1 = z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 8)
				if yyrl1 <= cap(yyv1) {
					yyv1 = yyv1[:yyrl1]
				} else {
					yyv1 = make([]*int64, yyrl1)
				}
				yyc1 = true
			} else if yyl1 != len(yyv1) {
				yyv1 = yyv1[:yyl1]
				yyc1 = true
			}
		}
		var yyj1 int
		for yyj1 = 0; (yyhl1 && yyj1 < yyl1) || !(yyhl1 || z.DecCheckBreak()); yyj1++ { // bounds-check-elimination
			if yyj1 == 0 && yyv1 == nil {
				if yyhl1 {
					yyrl1 = z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 8)
				} else {
					yyrl1 = 8
				}
				yyv1 = make([]*int64, yyrl1)
				yyc1 = true
			}
			yyh1.ElemContainerState(yyj1)
			var yydb1 bool
			if yyj1 >= len(yyv1) {
				yyv1 = append(yyv1, nil)
				yyc1 = true
			}
			if yydb1 {
				z.DecSwallow()
			} else {
				if r.TryNil() {
					yyv1[yyj1] = nil
				} else {
					if yyv1[yyj1] == nil {
						yyv1[yyj1] = new(int64)
					}
					*yyv1[yyj1] = (int64)(r.DecodeInt64())
				}
			}
		}
		if yyj1 < len(yyv1) {
			yyv1 = yyv1[:yyj1]
			yyc1 = true
		} else if yyj1 == 0 && yyv1 == nil {
			yyv1 = make([]*int64, 0)
			yyc1 = true
		}
	}
	yyh1.End()
	if yyc1 {
		*v = yyv1
	}
}

func (x codecSelfer19780) encSlicestringUint64T(v []stringUint64T, e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
		return
	}
	z.EncWriteArrayStart(len(v))
	for _, yyv1 := range v {
		z.EncWriteArrayElem()
		yy2 := &yyv1
		yy2.CodecEncodeSelf(e)
	}
	z.EncWriteArrayEnd()
}

func (x codecSelfer19780) decSlicestringUint64T(v *[]stringUint64T, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1 := *v
	yyh1, yyl1 := z.DecSliceHelperStart()
	var yyc1 bool
	_ = yyc1
	if yyh1.IsNil {
		if yyv1 != nil {
			yyv1 = nil
			yyc1 = true
		}
	} else if yyl1 == 0 {
		if yyv1 == nil {
			yyv1 = []stringUint64T{}
			yyc1 = true
		} else if len(yyv1) != 0 {
			yyv1 = yyv1[:0]
			yyc1 = true
		}
	} else {
		yyhl1 := yyl1 > 0
		var yyrl1 int
		_ = yyrl1
		if yyhl1 {
			if yyl1 > cap(yyv1) {
				yyrl1 = z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 24)
				if yyrl1 <= cap(yyv1) {
					yyv1 = yyv1[:yyrl1]
				} else {
					yyv1 = make([]stringUint64T, yyrl1)
				}
				yyc1 = true
			} else if yyl1 != len(yyv1) {
				yyv1 = yyv1[:yyl1]
				yyc1 = true
			}
		}
		var yyj1 int
		for yyj1 = 0; (yyhl1 && yyj1 < yyl1) || !(yyhl1 || z.DecCheckBreak()); yyj1++ { // bounds-check-elimination
			if yyj1 == 0 && yyv1 == nil {
				if yyhl1 {
					yyrl1 = z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 24)
				} else {
					yyrl1 = 8
				}
				yyv1 = make([]stringUint64T, yyrl1)
				yyc1 = true
			}
			yyh1.ElemContainerState(yyj1)
			var yydb1 bool
			if yyj1 >= len(yyv1) {
				yyv1 = append(yyv1, stringUint64T{})
				yyc1 = true
			}
			if yydb1 {
				z.DecSwallow()
			} else {
				yyv1[yyj1].CodecDecodeSelf(d)
			}
		}
		if yyj1 < len(yyv1) {
			yyv1 = yyv1[:yyj1]
			yyc1 = true
		} else if yyj1 == 0 && yyv1 == nil {
			yyv1 = make([]stringUint64T, 0)
			yyc1 = true
		}
	}
	yyh1.End()
	if yyc1 {
		*v = yyv1
	}
}

func (x codecSelfer19780) encMapstringPtrtostringUint64T(v map[string]*stringUint64T, e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
		return
	}
	z.EncWriteMapStart(len(v))
	for yyk1, yyv1 := range v {
		z.EncWriteMapElemKey()
		r.EncodeString(string(yyk1))
		z.EncWriteMapElemValue()
		if yyv1 == nil {
			r.EncodeNil()
		} else {
			yyv1.CodecEncodeSelf(e)
		}
	}
	z.EncWriteMapEnd()
}

func (x codecSelfer19780) decMapstringPtrtostringUint64T(v *map[string]*stringUint64T, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1 := *v
	yyl1 := z.DecReadMapStart()
	if yyl1 == codecSelferDecContainerLenNil19780 {
		*v = nil
	} else {
		if yyv1 == nil {
			yyrl1 := z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 24)
			yyv1 = make(map[string]*stringUint64T, yyrl1)
			*v = yyv1
		}
		var yymk1 string
		var yymv1 *stringUint64T
		var yymg1, yymdn1, yyms1, yymok1 bool
		if z.DecBasicHandle().MapValueReset {
			yymg1 = true
		}
		if yyl1 != 0 {
			yyhl1 := yyl1 > 0
			for yyj1 := 0; (yyhl1 && yyj1 < yyl1) || !(yyhl1 || z.DecCheckBreak()); yyj1++ {
				z.DecReadMapElemKey()
				yymk1 = (string)(string(r.DecodeStringAsBytes()))
				yyms1 = true
				if yymg1 {
					yymv1, yymok1 = yyv1[yymk1]
					if yymok1 {
						yyms1 = false
					}
				} else {
					yymv1 = nil
				}
				z.DecReadMapElemValue()
				yymdn1 = false
				if r.TryNil() {
					yymdn1 = true
				} else {
					if yymv1 == nil {
						yymv1 = new(stringUint64T)
					}
					yymv1.CodecDecodeSelf(d)
				}
				if yymdn1 {
					if z.DecBasicHandle().DeleteOnNilMapValue {
						delete(yyv1, yymk1)
					} else {
						yyv1[yymk1] = nil
					}
				} else if yyms1 && yyv1 != nil {
					yyv1[yymk1] = yymv1
				}
			}
		} // else len==0: TODO: Should we clear map entries?
		z.DecReadMapEnd()
	}
}

func (x codecSelfer19780) encMapstringPtrtoTestStruc(v map[string]*TestStruc, e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
		return
	}
	z.EncWriteMapStart(len(v))
	for yyk1, yyv1 := range v {
		z.EncWriteMapElemKey()
		r.EncodeString(string(yyk1))
		z.EncWriteMapElemValue()
		if yyv1 == nil {
			r.EncodeNil()
		} else {
			yyv1.CodecEncodeSelf(e)
		}
	}
	z.EncWriteMapEnd()
}

func (x codecSelfer19780) decMapstringPtrtoTestStruc(v *map[string]*TestStruc, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1 := *v
	yyl1 := z.DecReadMapStart()
	if yyl1 == codecSelferDecContainerLenNil19780 {
		*v = nil
	} else {
		if yyv1 == nil {
			yyrl1 := z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 24)
			yyv1 = make(map[string]*TestStruc, yyrl1)
			*v = yyv1
		}
		var yymk1 string
		var yymv1 *TestStruc
		var yymg1, yymdn1, yyms1, yymok1 bool
		if z.DecBasicHandle().MapValueReset {
			yymg1 = true
		}
		if yyl1 != 0 {
			yyhl1 := yyl1 > 0
			for yyj1 := 0; (yyhl1 && yyj1 < yyl1) || !(yyhl1 || z.DecCheckBreak()); yyj1++ {
				z.DecReadMapElemKey()
				yymk1 = (string)(string(r.DecodeStringAsBytes()))
				yyms1 = true
				if yymg1 {
					yymv1, yymok1 = yyv1[yymk1]
					if yymok1 {
						yyms1 = false
					}
				} else {
					yymv1 = nil
				}
				z.DecReadMapElemValue()
				yymdn1 = false
				if r.TryNil() {
					yymdn1 = true
				} else {
					if yymv1 == nil {
						yymv1 = new(TestStruc)
					}
					yymv1.CodecDecodeSelf(d)
				}
				if yymdn1 {
					if z.DecBasicHandle().DeleteOnNilMapValue {
						delete(yyv1, yymk1)
					} else {
						yyv1[yymk1] = nil
					}
				} else if yyms1 && yyv1 != nil {
					yyv1[yymk1] = yymv1
				}
			}
		} // else len==0: TODO: Should we clear map entries?
		z.DecReadMapEnd()
	}
}

func (x codecSelfer19780) encMapstringTestStruc(v map[string]TestStruc, e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
		return
	}
	z.EncWriteMapStart(len(v))
	for yyk1, yyv1 := range v {
		z.EncWriteMapElemKey()
		r.EncodeString(string(yyk1))
		z.EncWriteMapElemValue()
		yy3 := &yyv1
		yy3.CodecEncodeSelf(e)
	}
	z.EncWriteMapEnd()
}

func (x codecSelfer19780) decMapstringTestStruc(v *map[string]TestStruc, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1 := *v
	yyl1 := z.DecReadMapStart()
	if yyl1 == codecSelferDecContainerLenNil19780 {
		*v = nil
	} else {
		if yyv1 == nil {
			yyrl1 := z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 1224)
			yyv1 = make(map[string]TestStruc, yyrl1)
			*v = yyv1
		}
		var yymk1 string
		var yymv1 TestStruc
		var yymg1, yymdn1 bool
		if z.DecBasicHandle().MapValueReset {
			yymg1 = true
		}
		if yyl1 != 0 {
			yyhl1 := yyl1 > 0
			for yyj1 := 0; (yyhl1 && yyj1 < yyl1) || !(yyhl1 || z.DecCheckBreak()); yyj1++ {
				z.DecReadMapElemKey()
				yymk1 = (string)(string(r.DecodeStringAsBytes()))
				if yymg1 {
					yymv1 = yyv1[yymk1]
				} else {
					yymv1 = TestStruc{}
				}
				z.DecReadMapElemValue()
				yymdn1 = false
				yymv1.CodecDecodeSelf(d)
				if yymdn1 {
					if z.DecBasicHandle().DeleteOnNilMapValue {
						delete(yyv1, yymk1)
					} else {
						yyv1[yymk1] = TestStruc{}
					}
				} else if yyv1 != nil {
					yyv1[yymk1] = yymv1
				}
			}
		} // else len==0: TODO: Should we clear map entries?
		z.DecReadMapEnd()
	}
}

func (x codecSelfer19780) encSlicePtrtoTestStruc(v []*TestStruc, e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
		return
	}
	z.EncWriteArrayStart(len(v))
	for _, yyv1 := range v {
		z.EncWriteArrayElem()
		if yyv1 == nil {
			r.EncodeNil()
		} else {
			yyv1.CodecEncodeSelf(e)
		}
	}
	z.EncWriteArrayEnd()
}

func (x codecSelfer19780) decSlicePtrtoTestStruc(v *[]*TestStruc, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1 := *v
	yyh1, yyl1 := z.DecSliceHelperStart()
	var yyc1 bool
	_ = yyc1
	if yyh1.IsNil {
		if yyv1 != nil {
			yyv1 = nil
			yyc1 = true
		}
	} else if yyl1 == 0 {
		if yyv1 == nil {
			yyv1 = []*TestStruc{}
			yyc1 = true
		} else if len(yyv1) != 0 {
			yyv1 = yyv1[:0]
			yyc1 = true
		}
	} else {
		yyhl1 := yyl1 > 0
		var yyrl1 int
		_ = yyrl1
		if yyhl1 {
			if yyl1 > cap(yyv1) {
				yyrl1 = z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 8)
				if yyrl1 <= cap(yyv1) {
					yyv1 = yyv1[:yyrl1]
				} else {
					yyv1 = make([]*TestStruc, yyrl1)
				}
				yyc1 = true
			} else if yyl1 != len(yyv1) {
				yyv1 = yyv1[:yyl1]
				yyc1 = true
			}
		}
		var yyj1 int
		for yyj1 = 0; (yyhl1 && yyj1 < yyl1) || !(yyhl1 || z.DecCheckBreak()); yyj1++ { // bounds-check-elimination
			if yyj1 == 0 && yyv1 == nil {
				if yyhl1 {
					yyrl1 = z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 8)
				} else {
					yyrl1 = 8
				}
				yyv1 = make([]*TestStruc, yyrl1)
				yyc1 = true
			}
			yyh1.ElemContainerState(yyj1)
			var yydb1 bool
			if yyj1 >= len(yyv1) {
				yyv1 = append(yyv1, nil)
				yyc1 = true
			}
			if yydb1 {
				z.DecSwallow()
			} else {
				if r.TryNil() {
					yyv1[yyj1] = nil
				} else {
					if yyv1[yyj1] == nil {
						yyv1[yyj1] = new(TestStruc)
					}
					yyv1[yyj1].CodecDecodeSelf(d)
				}
			}
		}
		if yyj1 < len(yyv1) {
			yyv1 = yyv1[:yyj1]
			yyc1 = true
		} else if yyj1 == 0 && yyv1 == nil {
			yyv1 = make([]*TestStruc, 0)
			yyc1 = true
		}
	}
	yyh1.End()
	if yyc1 {
		*v = yyv1
	}
}

func (x codecSelfer19780) encAarray(v *Aarray, e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
		return
	}
	z.EncWriteArrayStart(len(v))
	for _, yyv1 := range v {
		z.EncWriteArrayElem()
		r.EncodeString(string(yyv1))
	}
	z.EncWriteArrayEnd()
}

func (x codecSelfer19780) decAarray(v *Aarray, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1 := v
	yyh1, yyl1 := z.DecSliceHelperStart()
	if yyl1 == 0 {
	} else {
		yyhl1 := yyl1 > 0
		var yyrl1 int
		_ = yyrl1
		var yyj1 int
		for yyj1 = 0; (yyhl1 && yyj1 < yyl1) || !(yyhl1 || z.DecCheckBreak()); yyj1++ { // bounds-check-elimination
			yyh1.ElemContainerState(yyj1)
			var yydb1 bool
			if yyj1 >= len(yyv1) {
				z.DecArrayCannotExpand(len(v), yyj1+1)
				yydb1 = true
			}
			if yydb1 {
				z.DecSwallow()
			} else {
				yyv1[yyj1] = (string)(string(r.DecodeStringAsBytes()))
			}
		}
	}
	yyh1.End()
}

func (x codecSelfer19780) encwrapBytes(v wrapBytes, e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
		return
	}
	r.EncodeStringBytesRaw([]byte(v))
}

func (x codecSelfer19780) decwrapBytes(v *wrapBytes, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r
	*v = r.DecodeBytes(*((*[]byte)(v)), false)
}

func (x codecSelfer19780) encChanstring(v chan string, e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
		return
	}
	if v == nil {
		r.EncodeNil()
	} else {
		var sch1 []string

	Lsch1:
		switch timeout1 := z.EncBasicHandle().ChanRecvTimeout; {
		case timeout1 == 0: // only consume available
			for {
				select {
				case b1 := <-v:
					sch1 = append(sch1, b1)
				default:
					break Lsch1
				}
			}
		case timeout1 > 0: // consume until timeout
			tt1 := time.NewTimer(timeout1)
			for {
				select {
				case b1 := <-v:
					sch1 = append(sch1, b1)
				case <-tt1.C:
					// close(tt.C)
					break Lsch1
				}
			}
		default: // consume until close
			for b1 := range v {
				sch1 = append(sch1, b1)
			}
		}
		z.EncWriteArrayStart(len(sch1))
		for _, yyv1 := range sch1 {
			z.EncWriteArrayElem()
			r.EncodeString(string(yyv1))
		}
		z.EncWriteArrayEnd()
	}
}

func (x codecSelfer19780) decChanstring(v *chan string, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1 := *v
	yyh1, yyl1 := z.DecSliceHelperStart()
	var yyc1 bool
	_ = yyc1
	if yyh1.IsNil {
		if yyv1 != nil {
			yyv1 = nil
			yyc1 = true
		}
	} else if yyl1 == 0 {
		if yyv1 == nil {
			yyv1 = make(chan string, 0)
			yyc1 = true
		}
	} else {
		yyhl1 := yyl1 > 0
		var yyrl1 int
		_ = yyrl1
		var yyj1 int
		for yyj1 = 0; (yyhl1 && yyj1 < yyl1) || !(yyhl1 || z.DecCheckBreak()); yyj1++ { // bounds-check-elimination
			if yyj1 == 0 && yyv1 == nil {
				if yyhl1 {
					yyrl1 = z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 16)
				} else {
					yyrl1 = 64
				}
				yyv1 = make(chan string, yyrl1)
				yyc1 = true
			}
			yyh1.ElemContainerState(yyj1)
			var yyvcx1 string
			yyvcx1 = (string)(string(r.DecodeStringAsBytes()))
			yyv1 <- yyvcx1
		}
	}
	yyh1.End()
	if yyc1 {
		*v = yyv1
	}
}

func (x codecSelfer19780) encMapboolc3RydWN0IHt9(v map[bool]struct{}, e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
		return
	}
	z.EncWriteMapStart(len(v))
	for yyk1, yyv1 := range v {
		z.EncWriteMapElemKey()
		r.EncodeBool(bool(yyk1))
		z.EncWriteMapElemValue()
		yy3 := &yyv1
		z.EncFallback(yy3)
	}
	z.EncWriteMapEnd()
}

func (x codecSelfer19780) decMapboolc3RydWN0IHt9(v *map[bool]struct{}, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1 := *v
	yyl1 := z.DecReadMapStart()
	if yyl1 == codecSelferDecContainerLenNil19780 {
		*v = nil
	} else {
		if yyv1 == nil {
			yyrl1 := z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 1)
			yyv1 = make(map[bool]struct{}, yyrl1)
			*v = yyv1
		}
		var yymk1 bool
		var yymv1 struct{}
		var yymg1, yymdn1 bool
		if z.DecBasicHandle().MapValueReset {
			yymg1 = true
		}
		if yyl1 != 0 {
			yyhl1 := yyl1 > 0
			for yyj1 := 0; (yyhl1 && yyj1 < yyl1) || !(yyhl1 || z.DecCheckBreak()); yyj1++ {
				z.DecReadMapElemKey()
				yymk1 = (bool)(r.DecodeBool())
				if yymg1 {
					yymv1 = yyv1[yymk1]
				} else {
					yymv1 = struct{}{}
				}
				z.DecReadMapElemValue()
				yymdn1 = false
				z.DecFallback(&yymv1, false)
				if yymdn1 {
					if z.DecBasicHandle().DeleteOnNilMapValue {
						delete(yyv1, yymk1)
					} else {
						yyv1[yymk1] = struct{}{}
					}
				} else if yyv1 != nil {
					yyv1[yymk1] = yymv1
				}
			}
		} // else len==0: TODO: Should we clear map entries?
		z.DecReadMapEnd()
	}
}

func (x codecSelfer19780) encMapintwrapUint64Slice(v map[int]wrapUint64Slice, e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
		return
	}
	z.EncWriteMapStart(len(v))
	for yyk1, yyv1 := range v {
		z.EncWriteMapElemKey()
		r.EncodeInt(int64(yyk1))
		z.EncWriteMapElemValue()
		yyv1.CodecEncodeSelf(e)
	}
	z.EncWriteMapEnd()
}

func (x codecSelfer19780) decMapintwrapUint64Slice(v *map[int]wrapUint64Slice, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1 := *v
	yyl1 := z.DecReadMapStart()
	if yyl1 == codecSelferDecContainerLenNil19780 {
		*v = nil
	} else {
		if yyv1 == nil {
			yyrl1 := z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 32)
			yyv1 = make(map[int]wrapUint64Slice, yyrl1)
			*v = yyv1
		}
		var yymk1 int
		var yymv1 wrapUint64Slice
		var yymg1, yymdn1 bool
		if z.DecBasicHandle().MapValueReset {
			yymg1 = true
		}
		if yyl1 != 0 {
			yyhl1 := yyl1 > 0
			for yyj1 := 0; (yyhl1 && yyj1 < yyl1) || !(yyhl1 || z.DecCheckBreak()); yyj1++ {
				z.DecReadMapElemKey()
				yymk1 = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize19780))
				if yymg1 {
					yymv1 = yyv1[yymk1]
				} else {
					yymv1 = nil
				}
				z.DecReadMapElemValue()
				yymdn1 = false
				yymv1.CodecDecodeSelf(d)
				if yymdn1 {
					if z.DecBasicHandle().DeleteOnNilMapValue {
						delete(yyv1, yymk1)
					} else {
						yyv1[yymk1] = nil
					}
				} else if yyv1 != nil {
					yyv1[yymk1] = yymv1
				}
			}
		} // else len==0: TODO: Should we clear map entries?
		z.DecReadMapEnd()
	}
}

func (x codecSelfer19780) encMapfloat64wrapStringSlice(v map[float64]wrapStringSlice, e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
		return
	}
	z.EncWriteMapStart(len(v))
	for yyk1, yyv1 := range v {
		z.EncWriteMapElemKey()
		r.EncodeFloat64(float64(yyk1))
		z.EncWriteMapElemValue()
		yyv1.CodecEncodeSelf(e)
	}
	z.EncWriteMapEnd()
}

func (x codecSelfer19780) decMapfloat64wrapStringSlice(v *map[float64]wrapStringSlice, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1 := *v
	yyl1 := z.DecReadMapStart()
	if yyl1 == codecSelferDecContainerLenNil19780 {
		*v = nil
	} else {
		if yyv1 == nil {
			yyrl1 := z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 32)
			yyv1 = make(map[float64]wrapStringSlice, yyrl1)
			*v = yyv1
		}
		var yymk1 float64
		var yymv1 wrapStringSlice
		var yymg1, yymdn1 bool
		if z.DecBasicHandle().MapValueReset {
			yymg1 = true
		}
		if yyl1 != 0 {
			yyhl1 := yyl1 > 0
			for yyj1 := 0; (yyhl1 && yyj1 < yyl1) || !(yyhl1 || z.DecCheckBreak()); yyj1++ {
				z.DecReadMapElemKey()
				yymk1 = (float64)(r.DecodeFloat64())
				if yymg1 {
					yymv1 = yyv1[yymk1]
				} else {
					yymv1 = nil
				}
				z.DecReadMapElemValue()
				yymdn1 = false
				yymv1.CodecDecodeSelf(d)
				if yymdn1 {
					if z.DecBasicHandle().DeleteOnNilMapValue {
						delete(yyv1, yymk1)
					} else {
						yyv1[yymk1] = nil
					}
				} else if yyv1 != nil {
					yyv1[yymk1] = yymv1
				}
			}
		} // else len==0: TODO: Should we clear map entries?
		z.DecReadMapEnd()
	}
}

func (x codecSelfer19780) encMapfloat32wrapStringSlice(v map[float32]wrapStringSlice, e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
		return
	}
	z.EncWriteMapStart(len(v))
	for yyk1, yyv1 := range v {
		z.EncWriteMapElemKey()
		r.EncodeFloat32(float32(yyk1))
		z.EncWriteMapElemValue()
		yyv1.CodecEncodeSelf(e)
	}
	z.EncWriteMapEnd()
}

func (x codecSelfer19780) decMapfloat32wrapStringSlice(v *map[float32]wrapStringSlice, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1 := *v
	yyl1 := z.DecReadMapStart()
	if yyl1 == codecSelferDecContainerLenNil19780 {
		*v = nil
	} else {
		if yyv1 == nil {
			yyrl1 := z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 28)
			yyv1 = make(map[float32]wrapStringSlice, yyrl1)
			*v = yyv1
		}
		var yymk1 float32
		var yymv1 wrapStringSlice
		var yymg1, yymdn1 bool
		if z.DecBasicHandle().MapValueReset {
			yymg1 = true
		}
		if yyl1 != 0 {
			yyhl1 := yyl1 > 0
			for yyj1 := 0; (yyhl1 && yyj1 < yyl1) || !(yyhl1 || z.DecCheckBreak()); yyj1++ {
				z.DecReadMapElemKey()
				yymk1 = (float32)(z.DecDecodeFloat32())
				if yymg1 {
					yymv1 = yyv1[yymk1]
				} else {
					yymv1 = nil
				}
				z.DecReadMapElemValue()
				yymdn1 = false
				yymv1.CodecDecodeSelf(d)
				if yymdn1 {
					if z.DecBasicHandle().DeleteOnNilMapValue {
						delete(yyv1, yymk1)
					} else {
						yyv1[yymk1] = nil
					}
				} else if yyv1 != nil {
					yyv1[yymk1] = yymv1
				}
			}
		} // else len==0: TODO: Should we clear map entries?
		z.DecReadMapEnd()
	}
}

func (x codecSelfer19780) encMapuint64wrapStringSlice(v map[uint64]wrapStringSlice, e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
		return
	}
	z.EncWriteMapStart(len(v))
	for yyk1, yyv1 := range v {
		z.EncWriteMapElemKey()
		r.EncodeUint(uint64(yyk1))
		z.EncWriteMapElemValue()
		yyv1.CodecEncodeSelf(e)
	}
	z.EncWriteMapEnd()
}

func (x codecSelfer19780) decMapuint64wrapStringSlice(v *map[uint64]wrapStringSlice, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1 := *v
	yyl1 := z.DecReadMapStart()
	if yyl1 == codecSelferDecContainerLenNil19780 {
		*v = nil
	} else {
		if yyv1 == nil {
			yyrl1 := z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 32)
			yyv1 = make(map[uint64]wrapStringSlice, yyrl1)
			*v = yyv1
		}
		var yymk1 uint64
		var yymv1 wrapStringSlice
		var yymg1, yymdn1 bool
		if z.DecBasicHandle().MapValueReset {
			yymg1 = true
		}
		if yyl1 != 0 {
			yyhl1 := yyl1 > 0
			for yyj1 := 0; (yyhl1 && yyj1 < yyl1) || !(yyhl1 || z.DecCheckBreak()); yyj1++ {
				z.DecReadMapElemKey()
				yymk1 = (uint64)(r.DecodeUint64())
				if yymg1 {
					yymv1 = yyv1[yymk1]
				} else {
					yymv1 = nil
				}
				z.DecReadMapElemValue()
				yymdn1 = false
				yymv1.CodecDecodeSelf(d)
				if yymdn1 {
					if z.DecBasicHandle().DeleteOnNilMapValue {
						delete(yyv1, yymk1)
					} else {
						yyv1[yymk1] = nil
					}
				} else if yyv1 != nil {
					yyv1[yymk1] = yymv1
				}
			}
		} // else len==0: TODO: Should we clear map entries?
		z.DecReadMapEnd()
	}
}

func (x codecSelfer19780) encMapstringUint64TwrapStringSlice(v map[stringUint64T]wrapStringSlice, e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
		return
	}
	z.EncWriteMapStart(len(v))
	for yyk1, yyv1 := range v {
		z.EncWriteMapElemKey()
		yy2 := &yyk1
		yy2.CodecEncodeSelf(e)
		z.EncWriteMapElemValue()
		yyv1.CodecEncodeSelf(e)
	}
	z.EncWriteMapEnd()
}

func (x codecSelfer19780) decMapstringUint64TwrapStringSlice(v *map[stringUint64T]wrapStringSlice, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1 := *v
	yyl1 := z.DecReadMapStart()
	if yyl1 == codecSelferDecContainerLenNil19780 {
		*v = nil
	} else {
		if yyv1 == nil {
			yyrl1 := z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 48)
			yyv1 = make(map[stringUint64T]wrapStringSlice, yyrl1)
			*v = yyv1
		}
		var yymk1 stringUint64T
		var yymv1 wrapStringSlice
		var yymg1, yymdn1 bool
		if z.DecBasicHandle().MapValueReset {
			yymg1 = true
		}
		if yyl1 != 0 {
			yyhl1 := yyl1 > 0
			for yyj1 := 0; (yyhl1 && yyj1 < yyl1) || !(yyhl1 || z.DecCheckBreak()); yyj1++ {
				z.DecReadMapElemKey()
				yymk1.CodecDecodeSelf(d)
				if yymg1 {
					yymv1 = yyv1[yymk1]
				} else {
					yymv1 = nil
				}
				z.DecReadMapElemValue()
				yymdn1 = false
				yymv1.CodecDecodeSelf(d)
				if yymdn1 {
					if z.DecBasicHandle().DeleteOnNilMapValue {
						delete(yyv1, yymk1)
					} else {
						yyv1[yymk1] = nil
					}
				} else if yyv1 != nil {
					yyv1[yymk1] = yymv1
				}
			}
		} // else len==0: TODO: Should we clear map entries?
		z.DecReadMapEnd()
	}
}

func (x codecSelfer19780) encSlicewrapBytes(v []wrapBytes, e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
		return
	}
	z.EncWriteArrayStart(len(v))
	for _, yyv1 := range v {
		z.EncWriteArrayElem()
		yyv1.CodecEncodeSelf(e)
	}
	z.EncWriteArrayEnd()
}

func (x codecSelfer19780) decSlicewrapBytes(v *[]wrapBytes, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1 := *v
	yyh1, yyl1 := z.DecSliceHelperStart()
	var yyc1 bool
	_ = yyc1
	if yyh1.IsNil {
		if yyv1 != nil {
			yyv1 = nil
			yyc1 = true
		}
	} else if yyl1 == 0 {
		if yyv1 == nil {
			yyv1 = []wrapBytes{}
			yyc1 = true
		} else if len(yyv1) != 0 {
			yyv1 = yyv1[:0]
			yyc1 = true
		}
	} else {
		yyhl1 := yyl1 > 0
		var yyrl1 int
		_ = yyrl1
		if yyhl1 {
			if yyl1 > cap(yyv1) {
				yyrl1 = z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 24)
				if yyrl1 <= cap(yyv1) {
					yyv1 = yyv1[:yyrl1]
				} else {
					yyv1 = make([]wrapBytes, yyrl1)
				}
				yyc1 = true
			} else if yyl1 != len(yyv1) {
				yyv1 = yyv1[:yyl1]
				yyc1 = true
			}
		}
		var yyj1 int
		for yyj1 = 0; (yyhl1 && yyj1 < yyl1) || !(yyhl1 || z.DecCheckBreak()); yyj1++ { // bounds-check-elimination
			if yyj1 == 0 && yyv1 == nil {
				if yyhl1 {
					yyrl1 = z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 24)
				} else {
					yyrl1 = 8
				}
				yyv1 = make([]wrapBytes, yyrl1)
				yyc1 = true
			}
			yyh1.ElemContainerState(yyj1)
			var yydb1 bool
			if yyj1 >= len(yyv1) {
				yyv1 = append(yyv1, nil)
				yyc1 = true
			}
			if yydb1 {
				z.DecSwallow()
			} else {
				yyv1[yyj1].CodecDecodeSelf(d)
			}
		}
		if yyj1 < len(yyv1) {
			yyv1 = yyv1[:yyj1]
			yyc1 = true
		} else if yyj1 == 0 && yyv1 == nil {
			yyv1 = make([]wrapBytes, 0)
			yyc1 = true
		}
	}
	yyh1.End()
	if yyc1 {
		*v = yyv1
	}
}

func (x codecSelfer19780) encSlicewrapUint8(v []wrapUint8, e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
		return
	}
	z.EncWriteArrayStart(len(v))
	for _, yyv1 := range v {
		z.EncWriteArrayElem()
		yyv1.CodecEncodeSelf(e)
	}
	z.EncWriteArrayEnd()
}

func (x codecSelfer19780) decSlicewrapUint8(v *[]wrapUint8, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1 := *v
	yyh1, yyl1 := z.DecSliceHelperStart()
	var yyc1 bool
	_ = yyc1
	if yyh1.IsNil {
		if yyv1 != nil {
			yyv1 = nil
			yyc1 = true
		}
	} else if yyl1 == 0 {
		if yyv1 == nil {
			yyv1 = []wrapUint8{}
			yyc1 = true
		} else if len(yyv1) != 0 {
			yyv1 = yyv1[:0]
			yyc1 = true
		}
	} else {
		yyhl1 := yyl1 > 0
		var yyrl1 int
		_ = yyrl1
		if yyhl1 {
			if yyl1 > cap(yyv1) {
				yyrl1 = z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 1)
				if yyrl1 <= cap(yyv1) {
					yyv1 = yyv1[:yyrl1]
				} else {
					yyv1 = make([]wrapUint8, yyrl1)
				}
				yyc1 = true
			} else if yyl1 != len(yyv1) {
				yyv1 = yyv1[:yyl1]
				yyc1 = true
			}
		}
		var yyj1 int
		for yyj1 = 0; (yyhl1 && yyj1 < yyl1) || !(yyhl1 || z.DecCheckBreak()); yyj1++ { // bounds-check-elimination
			if yyj1 == 0 && yyv1 == nil {
				if yyhl1 {
					yyrl1 = z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 1)
				} else {
					yyrl1 = 8
				}
				yyv1 = make([]wrapUint8, yyrl1)
				yyc1 = true
			}
			yyh1.ElemContainerState(yyj1)
			var yydb1 bool
			if yyj1 >= len(yyv1) {
				yyv1 = append(yyv1, 0)
				yyc1 = true
			}
			if yydb1 {
				z.DecSwallow()
			} else {
				yyv1[yyj1].CodecDecodeSelf(d)
			}
		}
		if yyj1 < len(yyv1) {
			yyv1 = yyv1[:yyj1]
			yyc1 = true
		} else if yyj1 == 0 && yyv1 == nil {
			yyv1 = make([]wrapUint8, 0)
			yyc1 = true
		}
	}
	yyh1.End()
	if yyc1 {
		*v = yyv1
	}
}

func (x codecSelfer19780) encArray4stringUint64T(v *[4]stringUint64T, e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
		return
	}
	z.EncWriteArrayStart(len(v))
	for _, yyv1 := range v {
		z.EncWriteArrayElem()
		yy2 := &yyv1
		yy2.CodecEncodeSelf(e)
	}
	z.EncWriteArrayEnd()
}

func (x codecSelfer19780) decArray4stringUint64T(v *[4]stringUint64T, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1 := v
	yyh1, yyl1 := z.DecSliceHelperStart()
	if yyl1 == 0 {
	} else {
		yyhl1 := yyl1 > 0
		var yyrl1 int
		_ = yyrl1
		var yyj1 int
		for yyj1 = 0; (yyhl1 && yyj1 < yyl1) || !(yyhl1 || z.DecCheckBreak()); yyj1++ { // bounds-check-elimination
			yyh1.ElemContainerState(yyj1)
			var yydb1 bool
			if yyj1 >= len(yyv1) {
				z.DecArrayCannotExpand(len(v), yyj1+1)
				yydb1 = true
			}
			if yydb1 {
				z.DecSwallow()
			} else {
				yyv1[yyj1].CodecDecodeSelf(d)
			}
		}
	}
	yyh1.End()
}

func (x codecSelfer19780) encArray4uint64(v *[4]uint64, e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
		return
	}
	z.EncWriteArrayStart(len(v))
	for _, yyv1 := range v {
		z.EncWriteArrayElem()
		r.EncodeUint(uint64(yyv1))
	}
	z.EncWriteArrayEnd()
}

func (x codecSelfer19780) decArray4uint64(v *[4]uint64, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1 := v
	yyh1, yyl1 := z.DecSliceHelperStart()
	if yyl1 == 0 {
	} else {
		yyhl1 := yyl1 > 0
		var yyrl1 int
		_ = yyrl1
		var yyj1 int
		for yyj1 = 0; (yyhl1 && yyj1 < yyl1) || !(yyhl1 || z.DecCheckBreak()); yyj1++ { // bounds-check-elimination
			yyh1.ElemContainerState(yyj1)
			var yydb1 bool
			if yyj1 >= len(yyv1) {
				z.DecArrayCannotExpand(len(v), yyj1+1)
				yydb1 = true
			}
			if yydb1 {
				z.DecSwallow()
			} else {
				yyv1[yyj1] = (uint64)(r.DecodeUint64())
			}
		}
	}
	yyh1.End()
}

func (x codecSelfer19780) encSlicePtrtoArray4uint64(v []*[4]uint64, e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
		return
	}
	z.EncWriteArrayStart(len(v))
	for _, yyv1 := range v {
		z.EncWriteArrayElem()
		if yyv1 == nil {
			r.EncodeNil()
		} else {
			h.encArray4uint64((*[4]uint64)(yyv1), e)
		}
	}
	z.EncWriteArrayEnd()
}

func (x codecSelfer19780) decSlicePtrtoArray4uint64(v *[]*[4]uint64, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1 := *v
	yyh1, yyl1 := z.DecSliceHelperStart()
	var yyc1 bool
	_ = yyc1
	if yyh1.IsNil {
		if yyv1 != nil {
			yyv1 = nil
			yyc1 = true
		}
	} else if yyl1 == 0 {
		if yyv1 == nil {
			yyv1 = []*[4]uint64{}
			yyc1 = true
		} else if len(yyv1) != 0 {
			yyv1 = yyv1[:0]
			yyc1 = true
		}
	} else {
		yyhl1 := yyl1 > 0
		var yyrl1 int
		_ = yyrl1
		if yyhl1 {
			if yyl1 > cap(yyv1) {
				yyrl1 = z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 8)
				if yyrl1 <= cap(yyv1) {
					yyv1 = yyv1[:yyrl1]
				} else {
					yyv1 = make([]*[4]uint64, yyrl1)
				}
				yyc1 = true
			} else if yyl1 != len(yyv1) {
				yyv1 = yyv1[:yyl1]
				yyc1 = true
			}
		}
		var yyj1 int
		for yyj1 = 0; (yyhl1 && yyj1 < yyl1) || !(yyhl1 || z.DecCheckBreak()); yyj1++ { // bounds-check-elimination
			if yyj1 == 0 && yyv1 == nil {
				if yyhl1 {
					yyrl1 = z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 8)
				} else {
					yyrl1 = 8
				}
				yyv1 = make([]*[4]uint64, yyrl1)
				yyc1 = true
			}
			yyh1.ElemContainerState(yyj1)
			var yydb1 bool
			if yyj1 >= len(yyv1) {
				yyv1 = append(yyv1, nil)
				yyc1 = true
			}
			if yydb1 {
				z.DecSwallow()
			} else {
				if r.TryNil() {
					yyv1[yyj1] = nil
				} else {
					if yyv1[yyj1] == nil {
						yyv1[yyj1] = new([4]uint64)
					}
					h.decArray4uint64((*[4]uint64)(yyv1[yyj1]), d)
				}
			}
		}
		if yyj1 < len(yyv1) {
			yyv1 = yyv1[:yyj1]
			yyc1 = true
		} else if yyj1 == 0 && yyv1 == nil {
			yyv1 = make([]*[4]uint64, 0)
			yyc1 = true
		}
	}
	yyh1.End()
	if yyc1 {
		*v = yyv1
	}
}

func (x codecSelfer19780) encMapstringUint64TPtrtostringUint64T(v map[stringUint64T]*stringUint64T, e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
		return
	}
	z.EncWriteMapStart(len(v))
	for yyk1, yyv1 := range v {
		z.EncWriteMapElemKey()
		yy2 := &yyk1
		yy2.CodecEncodeSelf(e)
		z.EncWriteMapElemValue()
		if yyv1 == nil {
			r.EncodeNil()
		} else {
			yyv1.CodecEncodeSelf(e)
		}
	}
	z.EncWriteMapEnd()
}

func (x codecSelfer19780) decMapstringUint64TPtrtostringUint64T(v *map[stringUint64T]*stringUint64T, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1 := *v
	yyl1 := z.DecReadMapStart()
	if yyl1 == codecSelferDecContainerLenNil19780 {
		*v = nil
	} else {
		if yyv1 == nil {
			yyrl1 := z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 32)
			yyv1 = make(map[stringUint64T]*stringUint64T, yyrl1)
			*v = yyv1
		}
		var yymk1 stringUint64T
		var yymv1 *stringUint64T
		var yymg1, yymdn1, yyms1, yymok1 bool
		if z.DecBasicHandle().MapValueReset {
			yymg1 = true
		}
		if yyl1 != 0 {
			yyhl1 := yyl1 > 0
			for yyj1 := 0; (yyhl1 && yyj1 < yyl1) || !(yyhl1 || z.DecCheckBreak()); yyj1++ {
				z.DecReadMapElemKey()
				yymk1.CodecDecodeSelf(d)
				yyms1 = true
				if yymg1 {
					yymv1, yymok1 = yyv1[yymk1]
					if yymok1 {
						yyms1 = false
					}
				} else {
					yymv1 = nil
				}
				z.DecReadMapElemValue()
				yymdn1 = false
				if r.TryNil() {
					yymdn1 = true
				} else {
					if yymv1 == nil {
						yymv1 = new(stringUint64T)
					}
					yymv1.CodecDecodeSelf(d)
				}
				if yymdn1 {
					if z.DecBasicHandle().DeleteOnNilMapValue {
						delete(yyv1, yymk1)
					} else {
						yyv1[yymk1] = nil
					}
				} else if yyms1 && yyv1 != nil {
					yyv1[yymk1] = yymv1
				}
			}
		} // else len==0: TODO: Should we clear map entries?
		z.DecReadMapEnd()
	}
}

func (x codecSelfer19780) encMapstringPtrtoTestStrucFlex(v map[string]*TestStrucFlex, e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
		return
	}
	z.EncWriteMapStart(len(v))
	for yyk1, yyv1 := range v {
		z.EncWriteMapElemKey()
		r.EncodeString(string(yyk1))
		z.EncWriteMapElemValue()
		if yyv1 == nil {
			r.EncodeNil()
		} else {
			yyv1.CodecEncodeSelf(e)
		}
	}
	z.EncWriteMapEnd()
}

func (x codecSelfer19780) decMapstringPtrtoTestStrucFlex(v *map[string]*TestStrucFlex, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1 := *v
	yyl1 := z.DecReadMapStart()
	if yyl1 == codecSelferDecContainerLenNil19780 {
		*v = nil
	} else {
		if yyv1 == nil {
			yyrl1 := z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 24)
			yyv1 = make(map[string]*TestStrucFlex, yyrl1)
			*v = yyv1
		}
		var yymk1 string
		var yymv1 *TestStrucFlex
		var yymg1, yymdn1, yyms1, yymok1 bool
		if z.DecBasicHandle().MapValueReset {
			yymg1 = true
		}
		if yyl1 != 0 {
			yyhl1 := yyl1 > 0
			for yyj1 := 0; (yyhl1 && yyj1 < yyl1) || !(yyhl1 || z.DecCheckBreak()); yyj1++ {
				z.DecReadMapElemKey()
				yymk1 = (string)(string(r.DecodeStringAsBytes()))
				yyms1 = true
				if yymg1 {
					yymv1, yymok1 = yyv1[yymk1]
					if yymok1 {
						yyms1 = false
					}
				} else {
					yymv1 = nil
				}
				z.DecReadMapElemValue()
				yymdn1 = false
				if r.TryNil() {
					yymdn1 = true
				} else {
					if yymv1 == nil {
						yymv1 = new(TestStrucFlex)
					}
					yymv1.CodecDecodeSelf(d)
				}
				if yymdn1 {
					if z.DecBasicHandle().DeleteOnNilMapValue {
						delete(yyv1, yymk1)
					} else {
						yyv1[yymk1] = nil
					}
				} else if yyms1 && yyv1 != nil {
					yyv1[yymk1] = yymv1
				}
			}
		} // else len==0: TODO: Should we clear map entries?
		z.DecReadMapEnd()
	}
}

func (x codecSelfer19780) encMapstringTestStrucFlex(v map[string]TestStrucFlex, e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
		return
	}
	z.EncWriteMapStart(len(v))
	for yyk1, yyv1 := range v {
		z.EncWriteMapElemKey()
		r.EncodeString(string(yyk1))
		z.EncWriteMapElemValue()
		yy3 := &yyv1
		yy3.CodecEncodeSelf(e)
	}
	z.EncWriteMapEnd()
}

func (x codecSelfer19780) decMapstringTestStrucFlex(v *map[string]TestStrucFlex, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1 := *v
	yyl1 := z.DecReadMapStart()
	if yyl1 == codecSelferDecContainerLenNil19780 {
		*v = nil
	} else {
		if yyv1 == nil {
			yyrl1 := z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 1536)
			yyv1 = make(map[string]TestStrucFlex, yyrl1)
			*v = yyv1
		}
		var yymk1 string
		var yymv1 TestStrucFlex
		var yymg1, yymdn1 bool
		if z.DecBasicHandle().MapValueReset {
			yymg1 = true
		}
		if yyl1 != 0 {
			yyhl1 := yyl1 > 0
			for yyj1 := 0; (yyhl1 && yyj1 < yyl1) || !(yyhl1 || z.DecCheckBreak()); yyj1++ {
				z.DecReadMapElemKey()
				yymk1 = (string)(string(r.DecodeStringAsBytes()))
				if yymg1 {
					yymv1 = yyv1[yymk1]
				} else {
					yymv1 = TestStrucFlex{}
				}
				z.DecReadMapElemValue()
				yymdn1 = false
				yymv1.CodecDecodeSelf(d)
				if yymdn1 {
					if z.DecBasicHandle().DeleteOnNilMapValue {
						delete(yyv1, yymk1)
					} else {
						yyv1[yymk1] = TestStrucFlex{}
					}
				} else if yyv1 != nil {
					yyv1[yymk1] = yymv1
				}
			}
		} // else len==0: TODO: Should we clear map entries?
		z.DecReadMapEnd()
	}
}

func (x codecSelfer19780) encSlicePtrtoTestStrucFlex(v []*TestStrucFlex, e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelperEncoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
		return
	}
	z.EncWriteArrayStart(len(v))
	for _, yyv1 := range v {
		z.EncWriteArrayElem()
		if yyv1 == nil {
			r.EncodeNil()
		} else {
			yyv1.CodecEncodeSelf(e)
		}
	}
	z.EncWriteArrayEnd()
}

func (x codecSelfer19780) decSlicePtrtoTestStrucFlex(v *[]*TestStrucFlex, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1 := *v
	yyh1, yyl1 := z.DecSliceHelperStart()
	var yyc1 bool
	_ = yyc1
	if yyh1.IsNil {
		if yyv1 != nil {
			yyv1 = nil
			yyc1 = true
		}
	} else if yyl1 == 0 {
		if yyv1 == nil {
			yyv1 = []*TestStrucFlex{}
			yyc1 = true
		} else if len(yyv1) != 0 {
			yyv1 = yyv1[:0]
			yyc1 = true
		}
	} else {
		yyhl1 := yyl1 > 0
		var yyrl1 int
		_ = yyrl1
		if yyhl1 {
			if yyl1 > cap(yyv1) {
				yyrl1 = z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 8)
				if yyrl1 <= cap(yyv1) {
					yyv1 = yyv1[:yyrl1]
				} else {
					yyv1 = make([]*TestStrucFlex, yyrl1)
				}
				yyc1 = true
			} else if yyl1 != len(yyv1) {
				yyv1 = yyv1[:yyl1]
				yyc1 = true
			}
		}
		var yyj1 int
		for yyj1 = 0; (yyhl1 && yyj1 < yyl1) || !(yyhl1 || z.DecCheckBreak()); yyj1++ { // bounds-check-elimination
			if yyj1 == 0 && yyv1 == nil {
				if yyhl1 {
					yyrl1 = z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 8)
				} else {
					yyrl1 = 8
				}
				yyv1 = make([]*TestStrucFlex, yyrl1)
				yyc1 = true
			}
			yyh1.ElemContainerState(yyj1)
			var yydb1 bool
			if yyj1 >= len(yyv1) {
				yyv1 = append(yyv1, nil)
				yyc1 = true
			}
			if yydb1 {
				z.DecSwallow()
			} else {
				if r.TryNil() {
					yyv1[yyj1] = nil
				} else {
					if yyv1[yyj1] == nil {
						yyv1[yyj1] = new(TestStrucFlex)
					}
					yyv1[yyj1].CodecDecodeSelf(d)
				}
			}
		}
		if yyj1 < len(yyv1) {
			yyv1 = yyv1[:yyj1]
			yyc1 = true
		} else if yyj1 == 0 && yyv1 == nil {
			yyv1 = make([]*TestStrucFlex, 0)
			yyc1 = true
		}
	}
	yyh1.End()
	if yyc1 {
		*v = yyv1
	}
}
