/*
 * Decompiled with CFR 0.152.
 */
package sbt;

import sbt.Help;
import sbt.Help$;
import sbt.Level$;
import sbt.complete.HistoryCommands$;
import scala.Enumeration;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;

public final class BasicCommandStrings$ {
    public static final BasicCommandStrings$ MODULE$;
    private final String HelpCommand;
    private final String CompletionsCommand;
    private final String Exit;
    private final String Quit;
    private final String TemplateCommand;
    private final String TerminateAction;
    private final String OldEarlyCommand;
    private final String EarlyCommand;
    private final Tuple2<String, String> EarlyCommandBrief;
    private final String EarlyCommandDetailed;
    private final String AddPluginSbtFileCommand;
    private final String AliasCommand;
    private final String ContinuousExecutePrefix;

    static {
        new BasicCommandStrings$();
    }

    public String HelpCommand() {
        return this.HelpCommand;
    }

    public String CompletionsCommand() {
        return this.CompletionsCommand;
    }

    public String Exit() {
        return this.Exit;
    }

    public String Quit() {
        return this.Quit;
    }

    public String TemplateCommand() {
        return this.TemplateCommand;
    }

    public String TerminateAction() {
        return this.TerminateAction;
    }

    public Tuple2<String, String> helpBrief() {
        return new Tuple2((Object)this.HelpCommand(), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Displays this help message or prints detailed help on requested commands (run '", " <command>')."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.HelpCommand()})));
    }

    public String helpDetailed() {
        return new StringBuilder().append((Object)this.HelpCommand()).append((Object)"\n\n\tPrints a help summary.\n\n").append((Object)this.HelpCommand()).append((Object)" <command>\n\n\tPrints detailed help for command <command>.\n\n").append((Object)this.HelpCommand()).append((Object)" <regular expression>\n\n\tSearches the help according to the provided regular expression.\n").toString();
    }

    public String CompletionsDetailed() {
        return "Displays a list of completions for the given argument string (run 'completions <string>').";
    }

    public Tuple2<String, String> CompletionsBrief() {
        return new Tuple2((Object)this.CompletionsCommand(), (Object)this.CompletionsDetailed());
    }

    public Tuple2<String, String> templateBrief() {
        return new Tuple2((Object)this.TemplateCommand(), (Object)"Creates a new sbt build.");
    }

    public String templateDetailed() {
        return new StringBuilder().append((Object)this.TemplateCommand()).append((Object)" [--options] <template>\n  Create a new sbt build based on the given template.").toString();
    }

    public Tuple2<String, String> HistoryHelpBrief() {
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)HistoryCommands$.MODULE$.Start()), (Object)"History command help.  Lists and describes all history commands.");
    }

    public Help historyHelp() {
        Tuple2<String, String> tuple2 = this.HistoryHelpBrief();
        return Help$.MODULE$.apply((Seq<Tuple2<String, String>>)Nil$.MODULE$, (Map<String, String>)((TraversableOnce)HistoryCommands$.MODULE$.descriptions().$plus$colon(tuple2, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms()), (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{HistoryCommands$.MODULE$.Start()}))));
    }

    public String exitBrief() {
        return "Terminates the build.";
    }

    public Help logLevelHelp() {
        Seq levels = Level$.MODULE$.values().toSeq();
        String levelList = levels.mkString(", ");
        Tuple2 brief = new Tuple2((Object)"<log-level>", (Object)new StringBuilder().append((Object)"Sets the logging level to 'log-level'.  Valid levels: ").append((Object)levelList).toString());
        Map detailed = ((TraversableOnce)levels.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(Enumeration.Value l) {
                return new Tuple2((Object)l.toString(), (Object)BasicCommandStrings$.MODULE$.sbt$BasicCommandStrings$$logLevelDetail(l));
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
        return Help$.MODULE$.apply((Tuple2<String, String>)brief, (Map<String, String>)detailed);
    }

    public String sbt$BasicCommandStrings$$logLevelDetail(Enumeration.Value level) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "\n\n\tSets the global logging level to ", ".\n\tThis will be used as the default level for logging from commands, settings, and tasks.\n\tAny explicit `logLevel` configuration in a project overrides this setting.\n\n-", "\n\n\tSets the global logging level as described above, but does so before any other commands are executed on startup, including project loading.\n\tThis is useful as a startup option:\n\t\t* it takes effect before any logging occurs\n\t\t* if no other commands are passed, interactive mode is still entered\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{level, level, level}));
    }

    public String runEarly(String command2) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.EarlyCommand(), command2}));
    }

    public boolean isEarlyCommand(String s) {
        Seq levelShortOptions = (Seq)Level$.MODULE$.values().toSeq().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Enumeration.Value x$2) {
                return new StringBuilder().append((Object)"-").append((Object)x$2).toString();
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq levelLongOptions = (Seq)Level$.MODULE$.values().toSeq().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Enumeration.Value x$3) {
                return new StringBuilder().append((Object)"--").append((Object)x$3).toString();
            }
        }, Seq$.MODULE$.canBuildFrom());
        return s.startsWith(new StringBuilder().append((Object)this.EarlyCommand()).append((Object)"(").toString()) && s.endsWith(")") || levelShortOptions.contains((Object)s) || levelLongOptions.contains((Object)s) || s.startsWith(new StringBuilder().append((Object)"-").append((Object)this.AddPluginSbtFileCommand()).toString()) || s.startsWith(new StringBuilder().append((Object)"--").append((Object)this.AddPluginSbtFileCommand()).toString());
    }

    public String OldEarlyCommand() {
        return this.OldEarlyCommand;
    }

    public String EarlyCommand() {
        return this.EarlyCommand;
    }

    public Tuple2<String, String> EarlyCommandBrief() {
        return this.EarlyCommandBrief;
    }

    public String EarlyCommandDetailed() {
        return this.EarlyCommandDetailed;
    }

    public Help addPluginSbtFileHelp() {
        Tuple2 brief = new Tuple2((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--", "=<file>"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.AddPluginSbtFileCommand()})), (Object)"Adds the given *.sbt file to the plugin build.");
        return Help$.MODULE$.apply((Tuple2<String, String>)brief, Help$.MODULE$.apply$default$2());
    }

    public String AddPluginSbtFileCommand() {
        return this.AddPluginSbtFileCommand;
    }

    public String ReadCommand() {
        return "<";
    }

    public String ReadFiles() {
        return " file1 file2 ...";
    }

    public String ReadDetailed() {
        return new StringBuilder().append((Object)this.ReadCommand()).append((Object)this.ReadFiles()).append((Object)"\n\n\tReads the lines from the given files and inserts them as commands.\n\tAll empty lines and lines that start with '#' are ignored.\n\tIf a file does not exist or is not readable, this command fails.\n\n\tAll the lines from all the files are read before any of the commands\n\t  are executed. Thus, if any file is not readable, none of commands\n\t  from any of the files (even the existing ones) will be run.\n\n\tYou probably need to escape this command if entering it at your shell.").toString();
    }

    public String ApplyCommand() {
        return "apply";
    }

    public String ApplyDetailed() {
        return new StringBuilder().append((Object)this.ApplyCommand()).append((Object)" [-cp|-classpath <classpath>] <module-name>*\n\tTransforms the current State by calling <module-name>.apply(currentState) for each listed module name.\n\tHere, currentState is of type sbt.State.\n   If a classpath is provided, modules are loaded from a new class loader for this classpath.\n").toString();
    }

    public String RebootCommand() {
        return "reboot";
    }

    public String RebootDetailed() {
        return new StringBuilder().append((Object)this.RebootCommand()).append((Object)" [full]\n\n\tThis command is equivalent to exiting sbt, restarting, and running the\n\t  remaining commands with the exception that the JVM is not shut down.\n\n\tIf 'full' is specified, the boot directory (`~/.sbt/boot` by default)\n\t  is deleted before restarting.  This forces an update of sbt and Scala\n\t  and is useful when working with development versions of sbt or Scala.").toString();
    }

    public String Multi() {
        return ";";
    }

    public Tuple2<String, String> MultiBrief() {
        return new Tuple2((Object)new StringBuilder().append((Object)this.Multi()).append((Object)" <command> (").append((Object)this.Multi()).append((Object)" <command>)*").toString(), (Object)"Runs the provided semicolon-separated commands.");
    }

    public String MultiDetailed() {
        return new StringBuilder().append((Object)this.Multi()).append((Object)" command1 ").append((Object)this.Multi()).append((Object)" command2 ...\n\n\tRuns the specified commands.").toString();
    }

    public String AppendCommand() {
        return "append";
    }

    public String AppendLastDetailed() {
        return new StringBuilder().append((Object)this.AppendCommand()).append((Object)" <command>\n\tAppends 'command' to list of commands to run.\n").toString();
    }

    public String AliasCommand() {
        return this.AliasCommand;
    }

    public String AliasDetailed() {
        return new StringBuilder().append((Object)this.AliasCommand()).append((Object)"\n\n\tPrints a list of defined aliases.\n\n").append((Object)this.AliasCommand()).append((Object)" name\n\n\tPrints the alias defined for `name`.\n\n").append((Object)this.AliasCommand()).append((Object)" name=value\n\n\tSets the alias `name` to `value`, replacing any existing alias with that name.\n\tWhenever `name` is entered, the corresponding `value` is run.\n\tIf any argument is provided to `name`, it is appended as argument to `value`.\n\n").append((Object)this.AliasCommand()).append((Object)" name=\n\n\tRemoves the alias for `name`.").toString();
    }

    public String Shell() {
        return "shell";
    }

    public String ShellDetailed() {
        return "Provides an interactive prompt from which commands can be run.";
    }

    public String StashOnFailure() {
        return "sbtStashOnFailure";
    }

    public String PopOnFailure() {
        return "sbtPopOnFailure";
    }

    public String FailureWall() {
        return "resumeFromFailure";
    }

    public String ClearOnFailure() {
        return "sbtClearOnFailure";
    }

    public String OnFailure() {
        return "onFailure";
    }

    public String OnFailureDetailed() {
        return new StringBuilder().append((Object)this.OnFailure()).append((Object)" command\n\n\tRegisters 'command' to run when a command fails to complete normally.\n\n\tOnly one failure command may be registered at a time, so this command\n\t  replaces the previous command if there is one.\n\n\tThe failure command resets when it runs once, so it must be added\n\t  again if desired.").toString();
    }

    public String IfLast() {
        return "iflast";
    }

    public String IfLastCommon() {
        return "If there are no more commands after this one, 'command' is run.";
    }

    public String IfLastDetailed() {
        return new StringBuilder().append((Object)this.IfLast()).append((Object)" <command>\n\n\t").append((Object)this.IfLastCommon()).toString();
    }

    public String ContinuousExecutePrefix() {
        return this.ContinuousExecutePrefix;
    }

    public String continuousDetail() {
        return "Executes the specified command whenever source files change.";
    }

    public Tuple2<String, String> continuousBriefHelp() {
        return new Tuple2((Object)new StringBuilder().append((Object)this.ContinuousExecutePrefix()).append((Object)" <command>").toString(), (Object)this.continuousDetail());
    }

    private BasicCommandStrings$() {
        MODULE$ = this;
        this.HelpCommand = "help";
        this.CompletionsCommand = "completions";
        this.Exit = "exit";
        this.Quit = "quit";
        this.TemplateCommand = "new";
        this.TerminateAction = this.Exit();
        this.OldEarlyCommand = "--";
        this.EarlyCommand = "early";
        this.EarlyCommandBrief = new Tuple2((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(<command>)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.EarlyCommand()})), (Object)"Schedules a command to run before other commands on startup.");
        this.EarlyCommandDetailed = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(<command>)\n\n\tSchedules an early command, which will be run before other commands on the command line.\n\tThe order is preserved between all early commands, so `sbt \"early(a)\" \"early(b)\"` executes `a` and `b` in order.\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.EarlyCommand()}));
        this.AddPluginSbtFileCommand = "addPluginSbtFile";
        this.AliasCommand = "alias";
        this.ContinuousExecutePrefix = "~";
    }
}

