/*
 * Decompiled with CFR 0.152.
 */
package sbt;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import sbt.ErrorHandling$;
import sbt.IO$;
import sbt.OpenFile;
import sbt.OpenFile$class;
import sbt.Using;
import sbt.Using$;
import sbt.WrapUsing;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;

public final class Using$ {
    public static final Using$ MODULE$;

    static {
        new Using$();
    }

    public <Source, T extends Closeable> Using<Source, T> wrap(Function1<Source, T> openF, Manifest<Source> srcMf, Manifest<T> targetMf) {
        return this.wrap(openF, this.closeCloseable(), srcMf, targetMf);
    }

    public <Source, T> Using<Source, T> wrap(Function1<Source, T> openF, Function1<T, BoxedUnit> closeF, Manifest<Source> srcMf, Manifest<T> targetMf) {
        return new WrapUsing<Source, T>(openF, closeF, srcMf, targetMf){
            private final Function1 openF$3;
            private final Function1 closeF$3;

            public T openImpl(Source source) {
                return (T)this.openF$3.apply(source);
            }

            public void close(T t) {
                this.closeF$3.apply(t);
            }
            {
                this.openF$3 = openF$3;
                this.closeF$3 = closeF$3;
                super(srcMf$1, targetMf$1);
            }
        };
    }

    public <Source, T extends Closeable> Using<Source, T> resource(Function1<Source, T> openF) {
        return this.resource(openF, this.closeCloseable());
    }

    public <Source, T> Using<Source, T> resource(Function1<Source, T> openF, Function1<T, BoxedUnit> closeF) {
        return new Using<Source, T>(openF, closeF){
            private final Function1 openF$2;
            private final Function1 closeF$2;

            public T open(Source s) {
                return (T)this.openF$2.apply(s);
            }

            public void close(T s) {
                this.closeF$2.apply(s);
            }
            {
                this.openF$2 = openF$2;
                this.closeF$2 = closeF$2;
            }
        };
    }

    public <T extends Closeable> OpenFile<T> file(Function1<File, T> openF) {
        return this.file(openF, this.closeCloseable());
    }

    public <T> OpenFile<T> file(Function1<File, T> openF, Function1<T, BoxedUnit> closeF) {
        return new OpenFile<T>(openF, closeF){
            private final Function1 openF$1;
            private final Function1 closeF$1;

            public final T open(File file) {
                return (T)OpenFile$class.open(this, file);
            }

            public T openImpl(File file) {
                return (T)this.openF$1.apply((Object)file);
            }

            public void close(T t) {
                this.closeF$1.apply(t);
            }
            {
                this.openF$1 = openF$1;
                this.closeF$1 = closeF$1;
                OpenFile$class.$init$(this);
            }
        };
    }

    private <T extends Closeable> Function1<T, BoxedUnit> closeCloseable() {
        return new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(T x$1) {
                x$1.close();
            }
        };
    }

    public Using<OutputStream, BufferedOutputStream> bufferedOutputStream() {
        return this.wrap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BufferedOutputStream apply(OutputStream out) {
                return new BufferedOutputStream(out);
            }
        }, (Manifest)ManifestFactory$.MODULE$.classType(OutputStream.class), (Manifest)ManifestFactory$.MODULE$.classType(BufferedOutputStream.class));
    }

    public Using<InputStream, BufferedInputStream> bufferedInputStream() {
        return this.wrap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BufferedInputStream apply(InputStream in) {
                return new BufferedInputStream(in);
            }
        }, (Manifest)ManifestFactory$.MODULE$.classType(InputStream.class), (Manifest)ManifestFactory$.MODULE$.classType(BufferedInputStream.class));
    }

    public OpenFile<BufferedOutputStream> fileOutputStream(boolean append) {
        return this.file((Function1)new Serializable(append){
            public static final long serialVersionUID = 0L;
            private final boolean append$1;

            public final BufferedOutputStream apply(File f) {
                return new BufferedOutputStream(new FileOutputStream(f, this.append$1));
            }
            {
                this.append$1 = append$1;
            }
        });
    }

    public boolean fileOutputStream$default$1() {
        return false;
    }

    public OpenFile<BufferedInputStream> fileInputStream() {
        return this.file((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BufferedInputStream apply(File f) {
                return new BufferedInputStream(new FileInputStream(f));
            }
        });
    }

    public Using<URL, BufferedInputStream> urlInputStream() {
        return this.resource((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BufferedInputStream apply(URL u) {
                return (BufferedInputStream)ErrorHandling$.MODULE$.translate((Function0)new Serializable(this, u){
                    public static final long serialVersionUID = 0L;
                    private final URL u$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Error opening ").append((Object)this.u$1).append((Object)": ").toString();
                    }
                    {
                        this.u$1 = u$1;
                    }
                }, (Function0)new Serializable(this, u){
                    public static final long serialVersionUID = 0L;
                    private final URL u$1;

                    public final BufferedInputStream apply() {
                        return new BufferedInputStream(this.u$1.openStream());
                    }
                    {
                        this.u$1 = u$1;
                    }
                });
            }
        });
    }

    public OpenFile<FileChannel> fileOutputChannel() {
        return this.file((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final FileChannel apply(File f) {
                return new FileOutputStream(f).getChannel();
            }
        });
    }

    public OpenFile<FileChannel> fileInputChannel() {
        return this.file((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final FileChannel apply(File f) {
                return new FileInputStream(f).getChannel();
            }
        });
    }

    public OpenFile<BufferedWriter> fileWriter(Charset charset, boolean append) {
        return this.file((Function1)new Serializable(charset, append){
            public static final long serialVersionUID = 0L;
            private final Charset charset$1;
            private final boolean append$2;

            public final BufferedWriter apply(File f) {
                return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f, this.append$2), this.charset$1));
            }
            {
                this.charset$1 = charset$1;
                this.append$2 = append$2;
            }
        });
    }

    public Charset fileWriter$default$1() {
        return IO$.MODULE$.utf8();
    }

    public boolean fileWriter$default$2() {
        return false;
    }

    public OpenFile<BufferedReader> fileReader(Charset charset) {
        return this.file((Function1)new Serializable(charset){
            public static final long serialVersionUID = 0L;
            private final Charset charset$2;

            public final BufferedReader apply(File f) {
                return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), this.charset$2));
            }
            {
                this.charset$2 = charset$2;
            }
        });
    }

    public Using<URL, BufferedReader> urlReader(Charset charset) {
        return this.resource((Function1)new Serializable(charset){
            public static final long serialVersionUID = 0L;
            private final Charset charset$3;

            public final BufferedReader apply(URL u) {
                return new BufferedReader(new InputStreamReader(u.openStream(), this.charset$3));
            }
            {
                this.charset$3 = charset$3;
            }
        });
    }

    public OpenFile<JarFile> jarFile(boolean verify) {
        return this.file((Function1)new Serializable(verify){
            public static final long serialVersionUID = 0L;
            private final boolean verify$1;

            public final JarFile apply(File f) {
                return new JarFile(f, this.verify$1);
            }
            {
                this.verify$1 = verify$1;
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(JarFile x$2) {
                x$2.close();
            }
        });
    }

    public OpenFile<ZipFile> zipFile() {
        return this.file((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ZipFile apply(File f) {
                return new ZipFile(f);
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(ZipFile x$3) {
                x$3.close();
            }
        });
    }

    public Using<Tuple2<InputStream, Charset>, InputStreamReader> streamReader() {
        return this.wrap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final InputStreamReader apply(Tuple2<InputStream, Charset> x$4) {
                Tuple2<InputStream, Charset> tuple2 = x$4;
                if (tuple2 != null) {
                    InputStream in = (InputStream)tuple2._1();
                    Charset charset = (Charset)tuple2._2();
                    InputStreamReader inputStreamReader = new InputStreamReader(in, charset);
                    return inputStreamReader;
                }
                throw new MatchError(tuple2);
            }
        }, (Manifest)ManifestFactory$.MODULE$.classType(Tuple2.class, ManifestFactory$.MODULE$.classType(InputStream.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[]{ManifestFactory$.MODULE$.classType(Charset.class)})), (Manifest)ManifestFactory$.MODULE$.classType(InputStreamReader.class));
    }

    public Using<InputStream, GZIPInputStream> gzipInputStream() {
        return this.wrap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final GZIPInputStream apply(InputStream in) {
                return new GZIPInputStream(in, 8192);
            }
        }, (Manifest)ManifestFactory$.MODULE$.classType(InputStream.class), (Manifest)ManifestFactory$.MODULE$.classType(GZIPInputStream.class));
    }

    public Using<InputStream, ZipInputStream> zipInputStream() {
        return this.wrap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ZipInputStream apply(InputStream in) {
                return new ZipInputStream(in);
            }
        }, (Manifest)ManifestFactory$.MODULE$.classType(InputStream.class), (Manifest)ManifestFactory$.MODULE$.classType(ZipInputStream.class));
    }

    public Using<OutputStream, ZipOutputStream> zipOutputStream() {
        return this.wrap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ZipOutputStream apply(OutputStream out) {
                return new ZipOutputStream(out);
            }
        }, (Manifest)ManifestFactory$.MODULE$.classType(OutputStream.class), (Manifest)ManifestFactory$.MODULE$.classType(ZipOutputStream.class));
    }

    public Using<OutputStream, GZIPOutputStream> gzipOutputStream() {
        return this.wrap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final GZIPOutputStream apply(OutputStream out) {
                return new GZIPOutputStream(out, 8192);
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(GZIPOutputStream x$5) {
                x$5.finish();
            }
        }, (Manifest)ManifestFactory$.MODULE$.classType(OutputStream.class), (Manifest)ManifestFactory$.MODULE$.classType(GZIPOutputStream.class));
    }

    public Using<OutputStream, JarOutputStream> jarOutputStream() {
        return this.wrap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JarOutputStream apply(OutputStream out) {
                return new JarOutputStream(out);
            }
        }, (Manifest)ManifestFactory$.MODULE$.classType(OutputStream.class), (Manifest)ManifestFactory$.MODULE$.classType(JarOutputStream.class));
    }

    public Using<InputStream, JarInputStream> jarInputStream() {
        return this.wrap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JarInputStream apply(InputStream in) {
                return new JarInputStream(in);
            }
        }, (Manifest)ManifestFactory$.MODULE$.classType(InputStream.class), (Manifest)ManifestFactory$.MODULE$.classType(JarInputStream.class));
    }

    public Using<ZipEntry, InputStream> zipEntry(ZipFile zip) {
        return this.resource((Function1)new Serializable(zip){
            public static final long serialVersionUID = 0L;
            public final ZipFile zip$1;

            public final InputStream apply(ZipEntry entry) {
                return (InputStream)ErrorHandling$.MODULE$.translate((Function0)new Serializable(this, entry){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.zipEntry.1 $outer;
                    private final ZipEntry entry$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Error opening ").append((Object)this.entry$1.getName()).append((Object)" in ").append((Object)this.$outer.zip$1).append((Object)": ").toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.entry$1 = entry$1;
                    }
                }, (Function0)new Serializable(this, entry){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.zipEntry.1 $outer;
                    private final ZipEntry entry$1;

                    public final InputStream apply() {
                        return this.$outer.zip$1.getInputStream(this.entry$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.entry$1 = entry$1;
                    }
                });
            }
            {
                this.zip$1 = zip$1;
            }
        });
    }

    private Using$() {
        MODULE$ = this;
    }
}

