/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.repository.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.License;
import org.apache.maven.model.Model;
import org.apache.maven.model.Prerequisites;
import org.apache.maven.model.Relocation;
import org.apache.maven.model.Repository;
import org.apache.maven.model.building.DefaultModelBuilderFactory;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.FileModelSource;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.model.resolution.UnresolvableModelException;
import org.apache.maven.repository.internal.ArtifactDescriptorUtils;
import org.apache.maven.repository.internal.DefaultModelCache;
import org.apache.maven.repository.internal.DefaultModelResolver;
import org.apache.maven.repository.internal.RelocatedArtifact;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.aether.RepositoryEvent;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactType;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.artifact.DefaultArtifactType;
import org.eclipse.aether.graph.Exclusion;
import org.eclipse.aether.impl.ArtifactDescriptorReader;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.impl.RepositoryEventDispatcher;
import org.eclipse.aether.impl.VersionRangeResolver;
import org.eclipse.aether.impl.VersionResolver;
import org.eclipse.aether.repository.WorkspaceRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorPolicy;
import org.eclipse.aether.resolution.ArtifactDescriptorPolicyRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.VersionRequest;
import org.eclipse.aether.resolution.VersionResolutionException;
import org.eclipse.aether.resolution.VersionResult;
import org.eclipse.aether.spi.locator.Service;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.eclipse.aether.spi.log.Logger;
import org.eclipse.aether.spi.log.LoggerFactory;
import org.eclipse.aether.spi.log.NullLoggerFactory;
import org.eclipse.aether.transfer.ArtifactNotFoundException;
import sbt.mavenint.PomExtraDependencyAttributes;
import sbt.mavenint.SbtPomExtraProperties;

@Named
@Component(role=ArtifactDescriptorReader.class)
public class SbtArtifactDescriptorReader
implements ArtifactDescriptorReader,
Service {
    @Requirement(role=LoggerFactory.class)
    private Logger logger = NullLoggerFactory.LOGGER;
    @Requirement
    private RemoteRepositoryManager remoteRepositoryManager;
    @Requirement
    private VersionResolver versionResolver;
    @Requirement
    private VersionRangeResolver versionRangeResolver;
    @Requirement
    private ArtifactResolver artifactResolver;
    @Requirement
    private RepositoryEventDispatcher repositoryEventDispatcher;
    @Requirement
    private ModelBuilder modelBuilder;

    public SbtArtifactDescriptorReader() {
    }

    @Inject
    SbtArtifactDescriptorReader(RemoteRepositoryManager remoteRepositoryManager, VersionResolver versionResolver, ArtifactResolver artifactResolver, ModelBuilder modelBuilder, RepositoryEventDispatcher repositoryEventDispatcher, LoggerFactory loggerFactory) {
        this.setRemoteRepositoryManager(remoteRepositoryManager);
        this.setVersionResolver(versionResolver);
        this.setArtifactResolver(artifactResolver);
        this.setModelBuilder(modelBuilder);
        this.setLoggerFactory(loggerFactory);
        this.setRepositoryEventDispatcher(repositoryEventDispatcher);
    }

    public void initService(ServiceLocator serviceLocator) {
        this.setLoggerFactory((LoggerFactory)serviceLocator.getService(LoggerFactory.class));
        this.setRemoteRepositoryManager((RemoteRepositoryManager)serviceLocator.getService(RemoteRepositoryManager.class));
        this.setVersionResolver((VersionResolver)serviceLocator.getService(VersionResolver.class));
        this.setArtifactResolver((ArtifactResolver)serviceLocator.getService(ArtifactResolver.class));
        this.setRepositoryEventDispatcher((RepositoryEventDispatcher)serviceLocator.getService(RepositoryEventDispatcher.class));
        this.setVersionRangeResolver((VersionRangeResolver)serviceLocator.getService(VersionRangeResolver.class));
        this.modelBuilder = (ModelBuilder)serviceLocator.getService(ModelBuilder.class);
        if (this.modelBuilder == null) {
            this.setModelBuilder((ModelBuilder)new DefaultModelBuilderFactory().newInstance());
        }
    }

    public SbtArtifactDescriptorReader setLoggerFactory(LoggerFactory loggerFactory) {
        this.logger = NullLoggerFactory.getSafeLogger((LoggerFactory)loggerFactory, this.getClass());
        return this;
    }

    void setLogger(LoggerFactory loggerFactory) {
        this.setLoggerFactory(loggerFactory);
    }

    public SbtArtifactDescriptorReader setRemoteRepositoryManager(RemoteRepositoryManager remoteRepositoryManager) {
        if (remoteRepositoryManager == null) {
            throw new IllegalArgumentException("remote repository manager has not been specified");
        }
        this.remoteRepositoryManager = remoteRepositoryManager;
        return this;
    }

    public SbtArtifactDescriptorReader setVersionResolver(VersionResolver versionResolver) {
        if (versionResolver == null) {
            throw new IllegalArgumentException("version resolver has not been specified");
        }
        this.versionResolver = versionResolver;
        return this;
    }

    public SbtArtifactDescriptorReader setArtifactResolver(ArtifactResolver artifactResolver) {
        if (artifactResolver == null) {
            throw new IllegalArgumentException("artifact resolver has not been specified");
        }
        this.artifactResolver = artifactResolver;
        return this;
    }

    public SbtArtifactDescriptorReader setRepositoryEventDispatcher(RepositoryEventDispatcher repositoryEventDispatcher) {
        if (repositoryEventDispatcher == null) {
            throw new IllegalArgumentException("repository event dispatcher has not been specified");
        }
        this.repositoryEventDispatcher = repositoryEventDispatcher;
        return this;
    }

    public SbtArtifactDescriptorReader setModelBuilder(ModelBuilder modelBuilder) {
        if (modelBuilder == null) {
            throw new IllegalArgumentException("model builder has not been specified");
        }
        this.modelBuilder = modelBuilder;
        return this;
    }

    public ArtifactDescriptorResult readArtifactDescriptor(RepositorySystemSession repositorySystemSession, ArtifactDescriptorRequest artifactDescriptorRequest) throws ArtifactDescriptorException {
        ArtifactDescriptorResult artifactDescriptorResult = new ArtifactDescriptorResult(artifactDescriptorRequest);
        Model model = this.loadPom(repositorySystemSession, artifactDescriptorRequest, artifactDescriptorResult);
        if (model != null) {
            Object object;
            Prerequisites prerequisites2;
            Object object22;
            ArtifactTypeRegistry artifactTypeRegistry = repositorySystemSession.getArtifactTypeRegistry();
            for (Object object22 : model.getRepositories()) {
                artifactDescriptorResult.addRepository(ArtifactDescriptorUtils.toRemoteRepository((Repository)object22));
            }
            for (Object object22 : model.getDependencies()) {
                artifactDescriptorResult.addDependency(this.convert((Dependency)object22, artifactTypeRegistry));
            }
            DependencyManagement dependencyManagement = model.getDependencyManagement();
            if (dependencyManagement != null) {
                for (Prerequisites prerequisites2 : dependencyManagement.getDependencies()) {
                    artifactDescriptorResult.addManagedDependency(this.convert((Dependency)prerequisites2, artifactTypeRegistry));
                }
            }
            object22 = new LinkedHashMap();
            prerequisites2 = model.getPrerequisites();
            if (prerequisites2 != null) {
                object22.put("prerequisites.maven", prerequisites2.getMaven());
            }
            List list = model.getLicenses();
            object22.put("license.count", list.size());
            for (int i = 0; i < list.size(); ++i) {
                object = (License)list.get(i);
                object22.put(SbtPomExtraProperties.makeLicenseName((int)i), object.getName());
                object22.put(SbtPomExtraProperties.makeLicenseUrl((int)i), object.getUrl());
                object22.put("license." + i + ".comments", object.getComments());
                object22.put("license." + i + ".distribution", object.getDistribution());
            }
            String string = model.getPackaging() == null ? "jar" : model.getPackaging();
            object22.put("sbt.pom.packaging", string);
            object = model.getProperties();
            if (((Properties)object).containsKey("sbtVersion")) {
                String string2 = ((Properties)object).getProperty("sbtVersion");
                object22.put("sbt.pom.sbtversion", string2);
            }
            if (((Properties)object).containsKey("scalaVersion")) {
                object22.put("sbt.pom.scalaversion", ((Properties)object).getProperty("scalaVersion"));
            }
            PomExtraDependencyAttributes.transferDependencyExtraAttributes((Properties)model.getProperties(), (Map)object22);
            artifactDescriptorResult.setProperties((Map)object22);
            this.setArtifactProperties(artifactDescriptorResult, model);
        }
        return artifactDescriptorResult;
    }

    public static Artifact toPomArtifact(Artifact artifact) {
        Artifact artifact2 = artifact;
        if (artifact.getClassifier().length() > 0 || !"pom".equals(artifact.getExtension())) {
            artifact2 = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), "pom", artifact.getVersion()).setProperties(artifact.getProperties());
        }
        return artifact2;
    }

    private Model loadPom(RepositorySystemSession repositorySystemSession, ArtifactDescriptorRequest artifactDescriptorRequest, ArtifactDescriptorResult artifactDescriptorResult) throws ArtifactDescriptorException {
        VersionResult versionResult;
        RequestTrace requestTrace = RequestTrace.newChild((RequestTrace)artifactDescriptorRequest.getTrace(), (Object)artifactDescriptorRequest);
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        Artifact artifact = artifactDescriptorRequest.getArtifact();
        while (true) {
            DefaultModelBuildingRequest defaultModelBuildingRequest;
            VersionRequest versionRequest;
            Artifact artifact2 = SbtArtifactDescriptorReader.toPomArtifact(artifact);
            try {
                versionRequest = new VersionRequest(artifact, artifactDescriptorRequest.getRepositories(), artifactDescriptorRequest.getRequestContext());
                versionRequest.setTrace(requestTrace);
                versionResult = this.versionResolver.resolveVersion(repositorySystemSession, versionRequest);
                artifact = artifact.setVersion(versionResult.getVersion());
                versionRequest = new VersionRequest(artifact2, artifactDescriptorRequest.getRepositories(), artifactDescriptorRequest.getRequestContext());
                versionRequest.setTrace(requestTrace);
                versionResult = this.versionResolver.resolveVersion(repositorySystemSession, versionRequest);
                artifact2 = artifact2.setVersion(versionResult.getVersion());
            }
            catch (VersionResolutionException versionResolutionException) {
                artifactDescriptorResult.addException((Exception)((Object)versionResolutionException));
                throw new ArtifactDescriptorException(artifactDescriptorResult);
            }
            if (!linkedHashSet.add(artifact.getGroupId() + ':' + artifact.getArtifactId() + ':' + artifact.getBaseVersion())) {
                versionRequest = new RepositoryException("Artifact relocations form a cycle: " + linkedHashSet);
                this.invalidDescriptor(repositorySystemSession, requestTrace, artifact, (Exception)versionRequest);
                if ((this.getPolicy(repositorySystemSession, artifact, artifactDescriptorRequest) & 2) != 0) {
                    return null;
                }
                artifactDescriptorResult.addException((Exception)versionRequest);
                throw new ArtifactDescriptorException(artifactDescriptorResult);
            }
            try {
                versionResult = new ArtifactRequest(artifact2, artifactDescriptorRequest.getRepositories(), artifactDescriptorRequest.getRequestContext());
                versionResult.setTrace(requestTrace);
                versionRequest = this.artifactResolver.resolveArtifact(repositorySystemSession, (ArtifactRequest)versionResult);
                artifact2 = versionRequest.getArtifact();
                artifactDescriptorResult.setRepository(versionRequest.getRepository());
            }
            catch (ArtifactResolutionException artifactResolutionException) {
                if (artifactResolutionException.getCause() instanceof ArtifactNotFoundException) {
                    this.missingDescriptor(repositorySystemSession, requestTrace, artifact, (Exception)artifactResolutionException.getCause());
                    if ((this.getPolicy(repositorySystemSession, artifact, artifactDescriptorRequest) & 1) != 0) {
                        return null;
                    }
                }
                artifactDescriptorResult.addException((Exception)((Object)artifactResolutionException));
                throw new ArtifactDescriptorException(artifactDescriptorResult);
            }
            try {
                defaultModelBuildingRequest = new DefaultModelBuildingRequest();
                defaultModelBuildingRequest.setValidationLevel(0);
                defaultModelBuildingRequest.setProcessPlugins(false);
                defaultModelBuildingRequest.setTwoPhaseBuilding(false);
                defaultModelBuildingRequest.setSystemProperties(this.toProperties(repositorySystemSession.getUserProperties(), repositorySystemSession.getSystemProperties()));
                defaultModelBuildingRequest.setModelCache(DefaultModelCache.newInstance((RepositorySystemSession)repositorySystemSession));
                defaultModelBuildingRequest.setModelResolver((ModelResolver)new DefaultModelResolver(repositorySystemSession, requestTrace.newChild((Object)defaultModelBuildingRequest), artifactDescriptorRequest.getRequestContext(), this.artifactResolver, this.versionRangeResolver, this.remoteRepositoryManager, artifactDescriptorRequest.getRepositories()));
                if (versionRequest.getRepository() instanceof WorkspaceRepository) {
                    defaultModelBuildingRequest.setPomFile(artifact2.getFile());
                } else {
                    defaultModelBuildingRequest.setModelSource((ModelSource)new FileModelSource(artifact2.getFile()));
                }
                versionResult = this.modelBuilder.build((ModelBuildingRequest)defaultModelBuildingRequest).getEffectiveModel();
            }
            catch (ModelBuildingException modelBuildingException) {
                for (ModelProblem modelProblem : modelBuildingException.getProblems()) {
                    if (!(modelProblem.getException() instanceof UnresolvableModelException)) continue;
                    artifactDescriptorResult.addException(modelProblem.getException());
                    throw new ArtifactDescriptorException(artifactDescriptorResult);
                }
                this.invalidDescriptor(repositorySystemSession, requestTrace, artifact, (Exception)((Object)modelBuildingException));
                if ((this.getPolicy(repositorySystemSession, artifact, artifactDescriptorRequest) & 2) != 0) {
                    return null;
                }
                artifactDescriptorResult.addException((Exception)((Object)modelBuildingException));
                throw new ArtifactDescriptorException(artifactDescriptorResult);
            }
            defaultModelBuildingRequest = this.getRelocation((Model)versionResult);
            if (defaultModelBuildingRequest == null) break;
            artifactDescriptorResult.addRelocation(artifact);
            artifact = new RelocatedArtifact(artifact, defaultModelBuildingRequest.getGroupId(), defaultModelBuildingRequest.getArtifactId(), defaultModelBuildingRequest.getVersion());
            artifactDescriptorResult.setArtifact(artifact);
        }
        return versionResult;
    }

    private Properties toProperties(Map<String, String> map, Map<String, String> map2) {
        Properties properties = new Properties();
        if (map2 != null) {
            properties.putAll(map2);
        }
        if (map != null) {
            properties.putAll(map);
        }
        return properties;
    }

    private Relocation getRelocation(Model model) {
        Relocation relocation = null;
        DistributionManagement distributionManagement = model.getDistributionManagement();
        if (distributionManagement != null) {
            relocation = distributionManagement.getRelocation();
        }
        return relocation;
    }

    private void setArtifactProperties(ArtifactDescriptorResult artifactDescriptorResult, Model model) {
        String string = null;
        DistributionManagement distributionManagement = model.getDistributionManagement();
        if (distributionManagement != null) {
            string = distributionManagement.getDownloadUrl();
        }
        if (string != null && string.length() > 0) {
            Artifact artifact = artifactDescriptorResult.getArtifact();
            HashMap<String, String> hashMap = new HashMap<String, String>(artifact.getProperties());
            hashMap.put("downloadUrl", string);
            artifactDescriptorResult.setArtifact(artifact.setProperties(hashMap));
        }
    }

    private org.eclipse.aether.graph.Dependency convert(Dependency dependency, ArtifactTypeRegistry artifactTypeRegistry) {
        ArtifactType artifactType = artifactTypeRegistry.get(dependency.getType());
        if (artifactType == null) {
            artifactType = new DefaultArtifactType(dependency.getType());
        }
        boolean bl = dependency.getSystemPath() != null && dependency.getSystemPath().length() > 0;
        Map<String, String> map = null;
        if (bl) {
            map = Collections.singletonMap("localPath", dependency.getSystemPath());
        }
        DefaultArtifact defaultArtifact = new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getClassifier(), null, dependency.getVersion(), map, artifactType);
        ArrayList<Exclusion> arrayList = new ArrayList<Exclusion>(dependency.getExclusions().size());
        for (org.apache.maven.model.Exclusion exclusion : dependency.getExclusions()) {
            arrayList.add(this.convert(exclusion));
        }
        org.eclipse.aether.graph.Dependency dependency2 = new org.eclipse.aether.graph.Dependency((Artifact)defaultArtifact, dependency.getScope(), Boolean.valueOf(dependency.isOptional()), arrayList);
        return dependency2;
    }

    private Exclusion convert(org.apache.maven.model.Exclusion exclusion) {
        return new Exclusion(exclusion.getGroupId(), exclusion.getArtifactId(), "*", "*");
    }

    private void missingDescriptor(RepositorySystemSession repositorySystemSession, RequestTrace requestTrace, Artifact artifact, Exception exception) {
        RepositoryEvent.Builder builder = new RepositoryEvent.Builder(repositorySystemSession, RepositoryEvent.EventType.ARTIFACT_DESCRIPTOR_MISSING);
        builder.setTrace(requestTrace);
        builder.setArtifact(artifact);
        builder.setException(exception);
        this.repositoryEventDispatcher.dispatch(builder.build());
    }

    private void invalidDescriptor(RepositorySystemSession repositorySystemSession, RequestTrace requestTrace, Artifact artifact, Exception exception) {
        RepositoryEvent.Builder builder = new RepositoryEvent.Builder(repositorySystemSession, RepositoryEvent.EventType.ARTIFACT_DESCRIPTOR_INVALID);
        builder.setTrace(requestTrace);
        builder.setArtifact(artifact);
        builder.setException(exception);
        this.repositoryEventDispatcher.dispatch(builder.build());
    }

    private int getPolicy(RepositorySystemSession repositorySystemSession, Artifact artifact, ArtifactDescriptorRequest artifactDescriptorRequest) {
        ArtifactDescriptorPolicy artifactDescriptorPolicy = repositorySystemSession.getArtifactDescriptorPolicy();
        if (artifactDescriptorPolicy == null) {
            return 0;
        }
        return artifactDescriptorPolicy.getPolicy(repositorySystemSession, new ArtifactDescriptorPolicyRequest(artifact, artifactDescriptorRequest.getRequestContext()));
    }

    public void setVersionRangeResolver(VersionRangeResolver versionRangeResolver) {
        this.versionRangeResolver = versionRangeResolver;
    }
}

