/* gzfile.h
 *
 * gzip file wrapper header
 * By Jon Rifkin <jon.rifkin@uconn.edu>
 * Copyright 2005 Jonathan Rifkin
 *
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/*
------------------------------------------------------------------------
Includes
------------------------------------------------------------------------
*/
#include <zlib.h>


/*
------------------------------------------------------------------------
Defines
------------------------------------------------------------------------
*/
#define G_STDIN 0
#define G_PLAIN 1
#define G_GZIP  2
#define G_BUFLEN 65536

/*
------------------------------------------------------------------------
Type Definitions
------------------------------------------------------------------------
*/
/*  This structure holds the generalized file type.  These files can
 *  be either plain text or gzippe files.  The structure holds a 
 *  pointer to the file and a flag which indicates the file type  */
typedef struct {
	void *fp;
	int  filetype;
	char *buf;
	char *cursor;
	char *limit;
	int  len;
} gfile_t;


/*
------------------------------------------------------------------------
Function Protypes
------------------------------------------------------------------------
*/
void gopen (gfile_t *gp, char *, char *);
int  gclose(gfile_t *gp);
char *ggets (char *, int, gfile_t *gp);
