/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.builder;

import java.util.ArrayList;
import java.util.List;
import org.jruby.ast.Colon3Node;
import org.jruby.ast.DefNode;
import org.jruby.ast.HashNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.InstVarNode;
import org.jruby.ast.Node;
import org.jruby.ast.RescueBodyNode;
import org.jruby.ast.WhenNode;
import org.jruby.ast.visitor.AbstractNodeVisitor;
import org.jruby.ir.IRManager;
import org.jruby.ir.IRMethod;
import org.jruby.ir.builder.IRBuilder;
import org.jruby.ir.builder.LazyMethodDefinition;

public class LazyMethodDefinitionAST
implements LazyMethodDefinition<Node, DefNode, WhenNode, RescueBodyNode, Colon3Node, HashNode> {
    private final DefNode node;

    public LazyMethodDefinitionAST(DefNode node) {
        this.node = node;
    }

    @Override
    public int getEndLine() {
        return this.node.getEndLine();
    }

    @Override
    public List<String> getMethodData() {
        final ArrayList<String> ivarNames = new ArrayList<String>();
        this.node.getBodyNode().accept(new AbstractNodeVisitor<Object>(){

            @Override
            protected Object defaultVisit(Node node) {
                if (node == null) {
                    return null;
                }
                if (node instanceof InstVarNode) {
                    ivarNames.add(((InstVarNode)node).getName().idString());
                } else if (node instanceof InstAsgnNode) {
                    ivarNames.add(((InstAsgnNode)node).getName().idString());
                }
                node.childNodes().forEach(this::defaultVisit);
                return null;
            }
        });
        return ivarNames;
    }

    @Override
    public DefNode getMethod() {
        return this.node;
    }

    @Override
    public Node getMethodBody() {
        return this.node.getBodyNode();
    }

    @Override
    public IRBuilder<Node, DefNode, WhenNode, RescueBodyNode, Colon3Node, HashNode> getBuilder(IRManager manager, IRMethod methodScope) {
        return manager.getBuilderFactory().newIRBuilder(manager, methodScope, null, null);
    }
}

