#
# The settings in ~/.taskrc...
#
# $Id: rc.tcl,v 1.8 2011/02/01 02:16:13 rader Exp $
#

###############################################################################

proc ReadRcs { } { 
  global env system_vittkrc task task_args cur_task_cmd

  # ~/.taskrc default.command
  set FD [open "|$task $task_args show default.command"];
  while { [FilteredGets $FD colorl l] >= 0 } {
    if [regexp {^default.command +(.*)} $l junk cmd] {
      set cur_task_cmd $cmd
      break
    }
  }
  catch { close $FD }

  # PREFIX/vittkrc
  ReadVittkrc $system_vittkrc

  # ~/.vittkrc...
  set pwdir $env(HOME)
  ReadVittkrc "$pwdir/.vittkrc"

}

###############################################################################

proc ReadVittkrc { f } {
  global env rc debug task_args
  global font color_fg color_bg color_fg_header color_fg_footer selection_bg
  global selection_fg_brightness line_padding cur_task_cmd task_args

  if { $debug } { puts "ReadVittkrc: file=$f" }
  
  if { [file exists $f] } { 
    set FD [open "$f" "r"]
    while { [gets $FD l] >= 0 } {

      set ol $l
      regsub -all {^[ ]*\#.*} $l {} l; regsub -all {^ +} $l "" l; regsub -all { +$} $l "" l
      if { $l == "" } { continue }
      if { ! [regexp {(.*)=(.*)} $l junk lhs rhs] } { 
        puts "Malformed entry in $f: '$ol'" 
        exit
      }

      set rc($lhs) $rhs;

      # non-fkey global var settings...
      if { $lhs == "color.background" } { set color_bg $rhs }
      if { $lhs == "color.foreground" } { set color_fg $rhs }
      if { $lhs == "color.header.foreground" } { set color_fg_header $rhs }
      if { $lhs == "color.footer.foreground" } { set color_fg_footer $rhs }
      if { $lhs == "color.selection.background" } { set selection_bg $rhs }
      if { $lhs == "color.selection.foreground.brightness" } { 
        set f [expr $rhs * 256 / 100]
        set i [format "%d" $f]
        set selection_fg_brightness $i
      }
      if { $lhs == "font" } { set font $rhs }
      if { $lhs == "line.padding" } { set line_padding $rhs }
      if { $lhs == "report" } { set cur_task_cmd $rhs }
      if { $lhs == "taskrc" } { set task_args "rc:$rhs $task_args" }

    }
    close $FD
  }
}

