/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.aspectj.asm.IHierarchy;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IMessageHandler;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.bridge.Message;
import org.aspectj.bridge.MessageUtil;
import org.aspectj.weaver.Advice;
import org.aspectj.weaver.AdviceKind;
import org.aspectj.weaver.AjAttribute;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.ConcreteTypeMunger;
import org.aspectj.weaver.CrosscuttingMembersSet;
import org.aspectj.weaver.Dump;
import org.aspectj.weaver.ICrossReferenceHandler;
import org.aspectj.weaver.IHasSourceLocation;
import org.aspectj.weaver.Lint;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedPointcutDefinition;
import org.aspectj.weaver.ResolvedTypeMunger;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.WeaverMessages;
import org.aspectj.weaver.patterns.DeclarePrecedence;
import org.aspectj.weaver.patterns.PerClause;
import org.aspectj.weaver.patterns.Pointcut;

public abstract class World
implements Dump.INode {
    protected IMessageHandler messageHandler = IMessageHandler.SYSTEM_ERR;
    protected ICrossReferenceHandler xrefHandler = null;
    protected TypeMap typeMap = new TypeMap();
    protected CrosscuttingMembersSet crosscuttingMembersSet = new CrosscuttingMembersSet(this);
    protected IHierarchy model = null;
    protected Lint lint = new Lint(this);
    protected boolean XnoInline;
    protected boolean XlazyTjp;
    public boolean behaveInJava5Way = false;
    private List dumpState_cantFindTypeExceptions = null;

    protected World() {
        Dump.registerNode(this.getClass(), this);
        this.typeMap.put("B", ResolvedTypeX.BYTE);
        this.typeMap.put("S", ResolvedTypeX.SHORT);
        this.typeMap.put("I", ResolvedTypeX.INT);
        this.typeMap.put("J", ResolvedTypeX.LONG);
        this.typeMap.put("F", ResolvedTypeX.FLOAT);
        this.typeMap.put("D", ResolvedTypeX.DOUBLE);
        this.typeMap.put("C", ResolvedTypeX.CHAR);
        this.typeMap.put("Z", ResolvedTypeX.BOOLEAN);
        this.typeMap.put("V", ResolvedTypeX.VOID);
    }

    public void accept(Dump.IVisitor visitor) {
        visitor.visitString("Shadow mungers:");
        visitor.visitList(this.crosscuttingMembersSet.getShadowMungers());
        visitor.visitString("Type mungers:");
        visitor.visitList(this.crosscuttingMembersSet.getTypeMungers());
        if (this.dumpState_cantFindTypeExceptions != null) {
            visitor.visitString("Cant find type problems:");
            visitor.visitList(this.dumpState_cantFindTypeExceptions);
            this.dumpState_cantFindTypeExceptions = null;
        }
    }

    public ResolvedTypeX[] resolve(TypeX[] types) {
        int len = types.length;
        ResolvedTypeX[] ret = new ResolvedTypeX[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = this.resolve(types[i]);
        }
        return ret;
    }

    public ResolvedTypeX resolve(TypeX ty, ISourceLocation isl) {
        ResolvedTypeX ret = this.resolve(ty, true);
        if (ty == ResolvedTypeX.MISSING) {
            IMessage msg = null;
            msg = isl != null ? MessageUtil.error(WeaverMessages.format("cantFindType", ty.getName()), isl) : MessageUtil.error(WeaverMessages.format("cantFindType", ty.getName()));
            this.messageHandler.handleMessage(msg);
        }
        return ret;
    }

    public ResolvedTypeX resolve(TypeX ty) {
        return this.resolve(ty, false);
    }

    public ResolvedTypeX getCoreType(TypeX tx) {
        ResolvedTypeX coreTy = this.resolve(tx, true);
        if (coreTy == ResolvedTypeX.MISSING) {
            MessageUtil.error(this.messageHandler, WeaverMessages.format("cantFindCoreType", tx.getName()));
        }
        return coreTy;
    }

    public ResolvedTypeX resolve(TypeX ty, boolean allowMissing) {
        String signature = ty.getSignature();
        ResolvedTypeX ret = this.typeMap.get(signature);
        if (ret != null) {
            ret.world = this;
            return ret;
        }
        if (ty.isArray()) {
            ret = new ResolvedTypeX.Array(signature, this, this.resolve(ty.getComponentType(), allowMissing));
        } else {
            ret = this.resolveObjectType(ty);
            if (!allowMissing && ret == ResolvedTypeX.MISSING) {
                MessageUtil.error(this.messageHandler, WeaverMessages.format("cantFindType", ty.getName()));
                if (this.dumpState_cantFindTypeExceptions == null) {
                    this.dumpState_cantFindTypeExceptions = new ArrayList();
                }
                this.dumpState_cantFindTypeExceptions.add(new RuntimeException("Can't find type " + ty.getName()));
            }
        }
        if (ty.isParameterized()) {
            for (int i = 0; i < ty.typeParameters.length; ++i) {
                ty.typeParameters[i] = this.resolve(ty.typeParameters[i], allowMissing);
            }
        }
        this.typeMap.put(signature, ret);
        return ret;
    }

    public ResolvedTypeX resolve(String name) {
        return this.resolve(TypeX.forName(name));
    }

    protected final ResolvedTypeX resolveObjectType(TypeX ty) {
        ResolvedTypeX.Name name;
        ResolvedTypeX.ConcreteName concreteName;
        String signature = ty.getSignature();
        if (signature.indexOf("<") != -1) {
            signature = signature.substring(0, signature.indexOf("<"));
        }
        if ((concreteName = this.resolveObjectType(name = new ResolvedTypeX.Name(signature, this))) == null) {
            return ResolvedTypeX.MISSING;
        }
        name.setDelegate(concreteName);
        return name;
    }

    protected abstract ResolvedTypeX.ConcreteName resolveObjectType(ResolvedTypeX.Name var1);

    protected final boolean isCoerceableFrom(TypeX type, TypeX other) {
        return this.resolve(type).isCoerceableFrom(other);
    }

    protected final boolean isAssignableFrom(TypeX type, TypeX other) {
        return this.resolve(type).isAssignableFrom(this.resolve(other));
    }

    public boolean needsNoConversionFrom(TypeX type, TypeX other) {
        return this.resolve(type).needsNoConversionFrom(other);
    }

    protected final boolean isInterface(TypeX type) {
        return this.resolve(type).isInterface();
    }

    protected final ResolvedTypeX getSuperclass(TypeX type) {
        return this.resolve(type).getSuperclass();
    }

    protected final TypeX[] getDeclaredInterfaces(TypeX type) {
        return this.resolve(type).getDeclaredInterfaces();
    }

    protected final int getModifiers(TypeX type) {
        return this.resolve(type).getModifiers();
    }

    protected final ResolvedMember[] getDeclaredFields(TypeX type) {
        return this.resolve(type).getDeclaredFields();
    }

    protected final ResolvedMember[] getDeclaredMethods(TypeX type) {
        return this.resolve(type).getDeclaredMethods();
    }

    protected final ResolvedMember[] getDeclaredPointcuts(TypeX type) {
        return this.resolve(type).getDeclaredPointcuts();
    }

    public ResolvedMember resolve(Member member) {
        ResolvedTypeX declaring = member.getDeclaringType().resolve(this);
        ResolvedMember ret = member.getKind() == Member.FIELD ? declaring.lookupField(member) : declaring.lookupMethod(member);
        if (ret != null) {
            return ret;
        }
        return declaring.lookupSyntheticMember(member);
    }

    protected int getModifiers(Member member) {
        ResolvedMember r = this.resolve(member);
        if (r == null) {
            throw new BCException("bad resolve of " + member);
        }
        return r.getModifiers();
    }

    protected String[] getParameterNames(Member member) {
        return this.resolve(member).getParameterNames();
    }

    protected TypeX[] getExceptions(Member member) {
        return this.resolve(member).getExceptions();
    }

    public ResolvedPointcutDefinition findPointcut(TypeX typeX, String name) {
        throw new RuntimeException("not implemented yet");
    }

    public abstract Advice concreteAdvice(AjAttribute.AdviceAttribute var1, Pointcut var2, Member var3);

    public final Advice concreteAdvice(AdviceKind kind, Pointcut p, Member signature, int extraParameterFlags, IHasSourceLocation loc) {
        AjAttribute.AdviceAttribute attribute = new AjAttribute.AdviceAttribute(kind, p, extraParameterFlags, loc.getStart(), loc.getEnd(), loc.getSourceContext());
        return this.concreteAdvice(attribute, p, signature);
    }

    public ConcreteTypeMunger makeCflowStackFieldAdder(ResolvedMember cflowField) {
        throw new RuntimeException("unimplemented");
    }

    public ConcreteTypeMunger makeCflowCounterFieldAdder(ResolvedMember cflowField) {
        throw new RuntimeException("unimplemented");
    }

    public ConcreteTypeMunger makePerClauseAspect(ResolvedTypeX aspect, PerClause.Kind kind) {
        throw new RuntimeException("unimplemented");
    }

    public abstract ConcreteTypeMunger concreteTypeMunger(ResolvedTypeMunger var1, ResolvedTypeX var2);

    public IMessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    public void setMessageHandler(IMessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

    public void setXRefHandler(ICrossReferenceHandler xrefHandler) {
        this.xrefHandler = xrefHandler;
    }

    public void showMessage(IMessage.Kind kind, String message, ISourceLocation loc1, ISourceLocation loc2) {
        if (loc1 != null) {
            this.messageHandler.handleMessage(new Message(message, kind, null, loc1));
            if (loc2 != null) {
                this.messageHandler.handleMessage(new Message(message, kind, null, loc2));
            }
        } else {
            this.messageHandler.handleMessage(new Message(message, kind, null, loc2));
        }
    }

    public int compareByDominates(ResolvedTypeX aspect1, ResolvedTypeX aspect2) {
        int order = 0;
        DeclarePrecedence orderer = null;
        Iterator i = this.crosscuttingMembersSet.getDeclareDominates().iterator();
        while (i.hasNext()) {
            DeclarePrecedence d = (DeclarePrecedence)i.next();
            int thisOrder = d.compare(aspect1, aspect2);
            if (thisOrder == 0) continue;
            if (orderer == null) {
                orderer = d;
            }
            if (order != 0 && order != thisOrder) {
                ISourceLocation[] isls = new ISourceLocation[]{orderer.getSourceLocation(), d.getSourceLocation()};
                Message m = new Message("conflicting declare precedence orderings for aspects: " + aspect1.getName() + " and " + aspect2.getName(), null, true, isls);
                this.messageHandler.handleMessage(m);
                continue;
            }
            order = thisOrder;
        }
        return order;
    }

    public int comparePrecedence(ResolvedTypeX aspect1, ResolvedTypeX aspect2) {
        if (aspect1.equals(aspect2)) {
            return 0;
        }
        int ret = this.compareByDominates(aspect1, aspect2);
        if (ret != 0) {
            return ret;
        }
        if (aspect1.isAssignableFrom(aspect2)) {
            return -1;
        }
        if (aspect2.isAssignableFrom(aspect1)) {
            return 1;
        }
        return 0;
    }

    public List getDeclareParents() {
        return this.crosscuttingMembersSet.getDeclareParents();
    }

    public List getDeclareAnnotationOnTypes() {
        return this.crosscuttingMembersSet.getDeclareAnnotationOnTypes();
    }

    public List getDeclareAnnotationOnFields() {
        return this.crosscuttingMembersSet.getDeclareAnnotationOnFields();
    }

    public List getDeclareAnnotationOnMethods() {
        return this.crosscuttingMembersSet.getDeclareAnnotationOnMethods();
    }

    public List getDeclareSoft() {
        return this.crosscuttingMembersSet.getDeclareSofts();
    }

    public CrosscuttingMembersSet getCrosscuttingMembersSet() {
        return this.crosscuttingMembersSet;
    }

    public IHierarchy getModel() {
        return this.model;
    }

    public void setModel(IHierarchy model) {
        this.model = model;
    }

    public Lint getLint() {
        return this.lint;
    }

    public void setLint(Lint lint) {
        this.lint = lint;
    }

    public boolean isXnoInline() {
        return this.XnoInline;
    }

    public void setXnoInline(boolean xnoInline) {
        this.XnoInline = xnoInline;
    }

    public boolean isXlazyTjp() {
        return this.XlazyTjp;
    }

    public void setXlazyTjp(boolean b) {
        this.XlazyTjp = b;
    }

    public ResolvedTypeX.Name lookupOrCreateName(TypeX ty) {
        String signature = ty.getSignature();
        ResolvedTypeX.Name ret = (ResolvedTypeX.Name)this.typeMap.get(signature);
        if (ret == null) {
            ret = new ResolvedTypeX.Name(signature, this);
            this.typeMap.put(signature, ret);
        }
        return ret;
    }

    public void setBehaveInJava5Way(boolean b) {
        this.behaveInJava5Way = b;
    }

    protected static class TypeMap {
        private Map tMap = new HashMap();
        private Map expendableMap = new WeakHashMap();

        protected TypeMap() {
        }

        public ResolvedTypeX put(String key, ResolvedTypeX type) {
            if (this.isExpendable(type)) {
                return this.expendableMap.put(key, type);
            }
            return this.tMap.put(key, type);
        }

        public ResolvedTypeX get(String key) {
            ResolvedTypeX ret = (ResolvedTypeX)this.tMap.get(key);
            if (ret == null) {
                ret = (ResolvedTypeX)this.expendableMap.get(key);
            }
            return ret;
        }

        public ResolvedTypeX remove(String key) {
            ResolvedTypeX ret = (ResolvedTypeX)this.tMap.remove(key);
            if (ret == null) {
                ret = (ResolvedTypeX)this.expendableMap.remove(key);
            }
            return ret;
        }

        private boolean isExpendable(ResolvedTypeX type) {
            return type != null && !type.isExposedToWeaver() && !type.isPrimitive();
        }
    }
}

