/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.core.dom;

import java.util.List;
import java.util.ListIterator;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.core.compiler.InvalidInputException;
import org.aspectj.org.eclipse.jdt.core.dom.AST;
import org.aspectj.org.eclipse.jdt.core.dom.ASTNode;
import org.aspectj.org.eclipse.jdt.core.dom.Javadoc;
import org.aspectj.org.eclipse.jdt.core.dom.MemberRef;
import org.aspectj.org.eclipse.jdt.core.dom.MethodRef;
import org.aspectj.org.eclipse.jdt.core.dom.MethodRefParameter;
import org.aspectj.org.eclipse.jdt.core.dom.Name;
import org.aspectj.org.eclipse.jdt.core.dom.PrimitiveType;
import org.aspectj.org.eclipse.jdt.core.dom.QualifiedName;
import org.aspectj.org.eclipse.jdt.core.dom.SimpleName;
import org.aspectj.org.eclipse.jdt.core.dom.TagElement;
import org.aspectj.org.eclipse.jdt.core.dom.TextElement;
import org.aspectj.org.eclipse.jdt.core.dom.Type;
import org.aspectj.org.eclipse.jdt.internal.compiler.parser.AbstractCommentParser;
import org.aspectj.org.eclipse.jdt.internal.compiler.parser.Scanner;

class DocCommentParser
extends AbstractCommentParser {
    private Javadoc docComment;
    private AST ast;

    DocCommentParser(AST ast, Scanner scanner, boolean check) {
        super(null);
        this.ast = ast;
        this.scanner = scanner;
        this.jdk15 = this.ast.apiLevel() >= 3;
        this.checkDocComment = check;
        this.kind = 2;
    }

    public Javadoc parse(int[] positions) {
        return this.parse(positions[0], positions[1] - positions[0]);
    }

    public Javadoc parse(int start, int length) {
        this.source = this.scanner.source;
        this.lineEnds = this.scanner.lineEnds;
        this.docComment = this.ast.newJavadoc();
        if (this.checkDocComment) {
            this.commentParse(start, start + length - 1);
        }
        this.docComment.setSourceRange(start, length);
        if (this.ast.apiLevel == 2) {
            this.setComment(start, length);
        }
        return this.docComment;
    }

    private void setComment(int start, int length) {
        this.docComment.setComment(new String(this.source, start, length));
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("javadoc: ").append(this.docComment).append("\n");
        buffer.append(super.toString());
        return buffer.toString();
    }

    protected Object createArgumentReference(char[] name, int dim, Object typeRef, long[] dimPositions, long argNamePos) throws InvalidInputException {
        try {
            MethodRefParameter argument = this.ast.newMethodRefParameter();
            ASTNode node = (ASTNode)typeRef;
            int argStart = node.getStartPosition();
            int argEnd = node.getStartPosition() + node.getLength() - 1;
            if (dim > 0) {
                argEnd = (int)dimPositions[dim - 1];
            }
            if (argNamePos >= 0L) {
                argEnd = (int)argNamePos;
            }
            if (name.length != 0) {
                SimpleName argName = this.ast.newSimpleName(new String(name));
                argument.setName(argName);
                int argNameStart = (int)(argNamePos >>> 32);
                argName.setSourceRange(argNameStart, argEnd - argNameStart + 1);
            }
            Type argType = null;
            if (node.getNodeType() == 39) {
                argType = (PrimitiveType)node;
            } else {
                Name argTypeName = (Name)node;
                argType = this.ast.newSimpleType(argTypeName);
                argType.setSourceRange(argStart, node.getLength());
            }
            if (dim > 0) {
                int i = 0;
                while (i < dim) {
                    argType = this.ast.newArrayType(argType);
                    argType.setSourceRange(argStart, (int)dimPositions[i] - argStart + 1);
                    ++i;
                }
            }
            argument.setType(argType);
            argument.setSourceRange(argStart, argEnd - argStart + 1);
            return argument;
        }
        catch (ClassCastException ex) {
            throw new InvalidInputException();
        }
    }

    protected Object createFieldReference(Object receiver) throws InvalidInputException {
        try {
            MemberRef fieldRef = this.ast.newMemberRef();
            SimpleName fieldName = this.ast.newSimpleName(new String(this.identifierStack[0]));
            fieldRef.setName(fieldName);
            int start = (int)(this.identifierPositionStack[0] >>> 32);
            int end = (int)this.identifierPositionStack[0];
            fieldName.setSourceRange(start, end - start + 1);
            if (receiver == null) {
                start = this.memberStart;
                fieldRef.setSourceRange(start, end - start + 1);
            } else {
                Name typeRef = (Name)receiver;
                fieldRef.setQualifier(typeRef);
                start = typeRef.getStartPosition();
                end = fieldName.getStartPosition() + fieldName.getLength() - 1;
                fieldRef.setSourceRange(start, end - start + 1);
            }
            return fieldRef;
        }
        catch (ClassCastException ex) {
            throw new InvalidInputException();
        }
    }

    protected Object createMethodReference(Object receiver, List arguments) throws InvalidInputException {
        try {
            MethodRef methodRef = this.ast.newMethodRef();
            SimpleName methodName = this.ast.newSimpleName(new String(this.identifierStack[0]));
            methodRef.setName(methodName);
            int start = (int)(this.identifierPositionStack[0] >>> 32);
            int end = (int)this.identifierPositionStack[0];
            methodName.setSourceRange(start, end - start + 1);
            if (receiver == null) {
                start = this.memberStart;
                methodRef.setSourceRange(start, end - start + 1);
            } else {
                Name typeRef = (Name)receiver;
                methodRef.setQualifier(typeRef);
                start = typeRef.getStartPosition();
            }
            if (arguments != null) {
                ListIterator parameters = arguments.listIterator();
                while (parameters.hasNext()) {
                    MethodRefParameter param = (MethodRefParameter)parameters.next();
                    methodRef.parameters().add(param);
                }
            }
            methodRef.setSourceRange(start, this.scanner.getCurrentTokenEndPosition() - start + 1);
            return methodRef;
        }
        catch (ClassCastException ex) {
            throw new InvalidInputException();
        }
    }

    protected void createTag() {
        TagElement tagElement = this.ast.newTagElement();
        int start = this.tagSourceStart;
        String tagName = new String(this.source, start, this.tagSourceEnd - start + 1);
        switch (tagName.charAt(0)) {
            case 'a': {
                if (!tagName.equals("@author")) break;
                tagName = "@author";
                break;
            }
            case 'd': {
                if (!tagName.equals("@docRoot")) break;
                tagName = "@docRoot";
                break;
            }
            case 'r': {
                if (!tagName.equals("@return")) break;
                tagName = "@return";
                break;
            }
            case 's': {
                if (tagName.equals("@serial")) {
                    tagName = "@serial";
                    break;
                }
                if (tagName.equals("@serialData")) {
                    tagName = "@serialData";
                    break;
                }
                if (!tagName.equals("@serialField")) break;
                tagName = "@serialField";
                break;
            }
            case 'v': {
                if (!tagName.equals("@version")) break;
                tagName = "@version";
            }
        }
        tagElement.setTagName(tagName);
        if (this.inlineTagStarted) {
            start = this.inlineTagStart;
            TagElement previousTag = null;
            if (this.astPtr == -1) {
                previousTag = this.ast.newTagElement();
                previousTag.setSourceRange(start, this.tagSourceEnd - start + 1);
                this.pushOnAstStack(previousTag, true);
            } else {
                previousTag = (TagElement)this.astStack[this.astPtr];
            }
            int previousStart = previousTag.getStartPosition();
            previousTag.fragments().add(tagElement);
            previousTag.setSourceRange(previousStart, this.tagSourceEnd - previousStart + 1);
        } else {
            this.pushOnAstStack(tagElement, true);
        }
        tagElement.setSourceRange(start, this.tagSourceEnd - start + 1);
    }

    protected Object createTypeReference(int primitiveToken) {
        int size = this.identifierLengthStack[this.identifierLengthPtr--];
        String[] identifiers = new String[size];
        int pos = this.identifierPtr - size + 1;
        int i = 0;
        while (i < size) {
            identifiers[i] = new String(this.identifierStack[pos + i]);
            ++i;
        }
        ASTNode typeRef = null;
        if (primitiveToken == -1) {
            typeRef = this.ast.newName(identifiers);
        } else {
            switch (primitiveToken) {
                case 47: {
                    typeRef = this.ast.newPrimitiveType(PrimitiveType.VOID);
                    break;
                }
                case 39: {
                    typeRef = this.ast.newPrimitiveType(PrimitiveType.BOOLEAN);
                    break;
                }
                case 40: {
                    typeRef = this.ast.newPrimitiveType(PrimitiveType.BYTE);
                    break;
                }
                case 41: {
                    typeRef = this.ast.newPrimitiveType(PrimitiveType.CHAR);
                    break;
                }
                case 42: {
                    typeRef = this.ast.newPrimitiveType(PrimitiveType.DOUBLE);
                    break;
                }
                case 43: {
                    typeRef = this.ast.newPrimitiveType(PrimitiveType.FLOAT);
                    break;
                }
                case 44: {
                    typeRef = this.ast.newPrimitiveType(PrimitiveType.INT);
                    break;
                }
                case 45: {
                    typeRef = this.ast.newPrimitiveType(PrimitiveType.LONG);
                    break;
                }
                case 46: {
                    typeRef = this.ast.newPrimitiveType(PrimitiveType.SHORT);
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        int start = (int)(this.identifierPositionStack[pos] >>> 32);
        if (size > 1) {
            ASTNode name = typeRef;
            int i2 = this.identifierPtr;
            while (i2 > pos) {
                int s = (int)(this.identifierPositionStack[i2] >>> 32);
                int e = (int)this.identifierPositionStack[i2];
                SimpleName simpleName = ((QualifiedName)name).getName();
                simpleName.setSourceRange(s, e - s + 1);
                name.setSourceRange(start, e - start + 1);
                name = ((QualifiedName)name).getQualifier();
                --i2;
            }
            int end = (int)this.identifierPositionStack[pos];
            name.setSourceRange(start, end - start + 1);
        } else {
            int end = (int)this.identifierPositionStack[pos];
            typeRef.setSourceRange(start, end - start + 1);
        }
        this.identifierPtr -= size;
        return typeRef;
    }

    protected boolean parseReturn() {
        this.createTag();
        return true;
    }

    protected boolean parseTag(int previousPosition) throws InvalidInputException {
        int token = this.readTokenAndConsume();
        this.tagSourceStart = this.scanner.getCurrentTokenStartPosition();
        this.tagSourceEnd = this.scanner.getCurrentTokenEndPosition();
        char[] tag = this.scanner.getCurrentIdentifierSource();
        int tk = token;
        int le = this.lineEnd;
        char pc = this.peekChar();
        block18: while (tk != 75) {
            this.tagSourceEnd = this.scanner.getCurrentTokenEndPosition();
            token = tk;
            switch (pc) {
                case '!': 
                case '\"': 
                case '#': 
                case '%': 
                case '&': 
                case '\'': 
                case '*': 
                case ':': 
                case '<': 
                case '>': 
                case '}': {
                    break block18;
                }
                default: {
                    if (pc == ' ' || Character.isWhitespace(pc)) break block18;
                    tk = this.readTokenAndConsume();
                    pc = this.peekChar();
                }
            }
        }
        int length = this.tagSourceEnd - this.tagSourceStart + 1;
        tag = new char[length];
        System.arraycopy(this.source, this.tagSourceStart, tag, 0, length);
        this.index = this.tagSourceEnd + 1;
        this.scanner.currentPosition = this.tagSourceEnd + 1;
        this.tagSourceStart = previousPosition;
        this.lineEnd = le;
        this.tagValue = 0;
        boolean valid = true;
        block3 : switch (token) {
            case 22: {
                switch (tag[0]) {
                    case 'd': {
                        if (CharOperation.equals(tag, AbstractCommentParser.TAG_DEPRECATED)) {
                            this.deprecated = true;
                            this.tagValue = 1;
                        } else {
                            this.tagValue = 11;
                        }
                        this.createTag();
                        break block3;
                    }
                    case 'i': {
                        if (CharOperation.equals(tag, AbstractCommentParser.TAG_INHERITDOC)) {
                            this.inherited = this.astPtr == -1;
                            this.tagValue = 9;
                        } else {
                            this.tagValue = 11;
                        }
                        this.createTag();
                        break block3;
                    }
                    case 'p': {
                        if (CharOperation.equals(tag, AbstractCommentParser.TAG_PARAM)) {
                            this.tagValue = 2;
                            valid = this.parseParam();
                            break block3;
                        }
                        this.tagValue = 11;
                        this.createTag();
                        break block3;
                    }
                    case 'e': {
                        if (CharOperation.equals(tag, AbstractCommentParser.TAG_EXCEPTION)) {
                            this.tagValue = 5;
                            valid = this.parseThrows();
                            break block3;
                        }
                        this.tagValue = 11;
                        this.createTag();
                        break block3;
                    }
                    case 's': {
                        if (CharOperation.equals(tag, AbstractCommentParser.TAG_SEE)) {
                            this.tagValue = 6;
                            if (this.inlineTagStarted) {
                                valid = false;
                                break block3;
                            }
                            valid = this.parseReference();
                            break block3;
                        }
                        this.tagValue = 11;
                        this.createTag();
                        break block3;
                    }
                    case 'l': {
                        if (CharOperation.equals(tag, AbstractCommentParser.TAG_LINK)) {
                            this.tagValue = 7;
                        } else if (CharOperation.equals(tag, AbstractCommentParser.TAG_LINKPLAIN)) {
                            this.tagValue = 8;
                        }
                        if (this.tagValue != 0) {
                            if (this.inlineTagStarted) {
                                valid = this.parseReference();
                                break block3;
                            }
                            valid = false;
                            break block3;
                        }
                        this.tagValue = 11;
                        this.createTag();
                        break block3;
                    }
                    case 'v': {
                        if (this.jdk15 && CharOperation.equals(tag, AbstractCommentParser.TAG_VALUE)) {
                            this.tagValue = 10;
                            if (this.inlineTagStarted) {
                                valid = this.parseReference();
                                break block3;
                            }
                            valid = false;
                            break block3;
                        }
                        this.tagValue = 11;
                        this.createTag();
                        break block3;
                    }
                }
                this.tagValue = 11;
                this.createTag();
                break;
            }
            case 85: {
                this.tagValue = 3;
                valid = this.parseReturn();
                break;
            }
            case 99: {
                this.tagValue = 4;
                valid = this.parseThrows();
                break;
            }
            case 13: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 100: 
            case 113: {
                this.tagValue = 11;
                this.createTag();
            }
        }
        this.textStart = this.index;
        return valid;
    }

    protected boolean pushParamName(boolean isTypeParam) {
        int idIndex = isTypeParam ? 1 : 0;
        SimpleName name = this.ast.newSimpleName(new String(this.identifierStack[idIndex]));
        int nameStart = (int)(this.identifierPositionStack[idIndex] >>> 32);
        int nameEnd = (int)(this.identifierPositionStack[idIndex] & 0xFFFFFFFFL);
        name.setSourceRange(nameStart, nameEnd - nameStart + 1);
        TagElement paramTag = this.ast.newTagElement();
        paramTag.setTagName("@param");
        if (isTypeParam) {
            TextElement text = this.ast.newTextElement();
            text.setText(new String(this.identifierStack[0]));
            int txtStart = (int)(this.identifierPositionStack[0] >>> 32);
            int txtEnd = (int)(this.identifierPositionStack[0] & 0xFFFFFFFFL);
            text.setSourceRange(txtStart, txtEnd - txtStart + 1);
            paramTag.fragments().add(text);
            paramTag.fragments().add(name);
            text = this.ast.newTextElement();
            text.setText(new String(this.identifierStack[2]));
            txtStart = (int)(this.identifierPositionStack[2] >>> 32);
            txtEnd = (int)(this.identifierPositionStack[2] & 0xFFFFFFFFL);
            text.setSourceRange(txtStart, txtEnd - txtStart + 1);
            paramTag.fragments().add(text);
            paramTag.setSourceRange(this.tagSourceStart, txtEnd - this.tagSourceStart + 1);
        } else {
            paramTag.setSourceRange(this.tagSourceStart, nameEnd - this.tagSourceStart + 1);
            paramTag.fragments().add(name);
        }
        this.pushOnAstStack(paramTag, true);
        return true;
    }

    protected boolean pushSeeRef(Object statement) {
        TagElement seeTag = this.ast.newTagElement();
        ASTNode node = (ASTNode)statement;
        seeTag.fragments().add(node);
        int end = node.getStartPosition() + node.getLength() - 1;
        if (this.inlineTagStarted) {
            seeTag.setSourceRange(this.inlineTagStart, end - this.inlineTagStart + 1);
            switch (this.tagValue) {
                case 7: {
                    seeTag.setTagName("@link");
                    break;
                }
                case 8: {
                    seeTag.setTagName("@linkplain");
                    break;
                }
                case 10: {
                    seeTag.setTagName("@value");
                }
            }
            TagElement previousTag = null;
            int previousStart = this.inlineTagStart;
            if (this.astPtr == -1) {
                previousTag = this.ast.newTagElement();
                this.pushOnAstStack(previousTag, true);
            } else {
                previousTag = (TagElement)this.astStack[this.astPtr];
                previousStart = previousTag.getStartPosition();
            }
            previousTag.fragments().add(seeTag);
            previousTag.setSourceRange(previousStart, end - previousStart + 1);
        } else {
            seeTag.setTagName("@see");
            seeTag.setSourceRange(this.tagSourceStart, end - this.tagSourceStart + 1);
            this.pushOnAstStack(seeTag, true);
        }
        return true;
    }

    protected void pushText(int start, int end) {
        TextElement text = this.ast.newTextElement();
        text.setText(new String(this.source, start, end - start));
        text.setSourceRange(start, end - start);
        TagElement previousTag = null;
        int previousStart = start;
        if (this.astPtr == -1) {
            previousTag = this.ast.newTagElement();
            previousTag.setSourceRange(start, end - start);
            this.pushOnAstStack(previousTag, true);
        } else {
            previousTag = (TagElement)this.astStack[this.astPtr];
            previousStart = previousTag.getStartPosition();
        }
        if (this.inlineTagStarted) {
            if (previousTag.fragments().size() == 0) {
                TagElement inlineTag = this.ast.newTagElement();
                previousTag.fragments().add(inlineTag);
                previousTag = inlineTag;
            } else {
                ASTNode inlineTag = (ASTNode)previousTag.fragments().get(previousTag.fragments().size() - 1);
                if (inlineTag.getNodeType() == 65) {
                    previousTag = (TagElement)inlineTag;
                    previousStart = previousTag.getStartPosition();
                }
            }
        }
        previousTag.fragments().add(text);
        previousTag.setSourceRange(previousStart, end - previousStart);
        this.textStart = -1;
    }

    protected void refreshInlineTagPosition(int previousPosition) {
        if (this.astPtr != -1) {
            TagElement previousTag = (TagElement)this.astStack[this.astPtr];
            if (this.inlineTagStarted) {
                ASTNode inlineTag;
                int previousStart = previousTag.getStartPosition();
                previousTag.setSourceRange(previousStart, previousPosition - previousStart + 1);
                if (previousTag.fragments().size() > 0 && (inlineTag = (ASTNode)previousTag.fragments().get(previousTag.fragments().size() - 1)).getNodeType() == 65) {
                    int inlineStart = inlineTag.getStartPosition();
                    inlineTag.setSourceRange(inlineStart, previousPosition - inlineStart + 1);
                }
            }
        }
    }

    protected boolean pushThrowName(Object typeRef) {
        TagElement throwsTag = this.ast.newTagElement();
        switch (this.tagValue) {
            case 4: {
                throwsTag.setTagName("@throws");
                break;
            }
            case 5: {
                throwsTag.setTagName("@exception");
            }
        }
        throwsTag.setSourceRange(this.tagSourceStart, this.scanner.getCurrentTokenEndPosition() - this.tagSourceStart + 1);
        throwsTag.fragments().add(typeRef);
        this.pushOnAstStack(throwsTag, true);
        return true;
    }

    protected void updateDocComment() {
        int idx = 0;
        while (idx <= this.astPtr) {
            this.docComment.tags().add(this.astStack[idx]);
            ++idx;
        }
    }
}

