/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.compiler.lookup;

import java.util.ArrayList;
import java.util.List;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseFactory;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseSourceLocation;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IMessageHandler;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.bridge.Message;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ImportBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.weaver.IHasPosition;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.World;
import org.aspectj.weaver.patterns.FormalBinding;
import org.aspectj.weaver.patterns.IScope;
import org.aspectj.weaver.patterns.WildTypePattern;

public class EclipseScope
implements IScope {
    private Scope scope;
    private EclipseFactory world;
    private ResolvedTypeX enclosingType;
    private FormalBinding[] bindings;
    private String[] importedPrefixes = null;
    private String[] importedNames = null;

    public EclipseScope(FormalBinding[] bindings, Scope scope) {
        this.bindings = bindings;
        this.scope = scope;
        this.world = EclipseFactory.fromScopeLookupEnvironment(scope);
        this.enclosingType = this.world.fromEclipse(scope.enclosingSourceType());
    }

    public TypeX lookupType(String name, IHasPosition location) {
        char[][] splitName = WildTypePattern.splitNames(name);
        TypeBinding b = this.scope.getType(splitName, splitName.length);
        if (!b.isValidBinding()) {
            return ResolvedTypeX.MISSING;
        }
        return EclipseFactory.fromBinding(b);
    }

    private void computeImports() {
        if (this.importedNames != null) {
            return;
        }
        ArrayList<String> importedNamesList = new ArrayList<String>();
        ArrayList<String> importedPrefixesList = new ArrayList<String>();
        Scope currentScope = this.scope;
        while (!(currentScope instanceof CompilationUnitScope)) {
            if (currentScope == null) {
                throw new RuntimeException("unimplemented");
            }
            if (currentScope instanceof ClassScope) {
                this.addClassAndParentsToPrefixes(((ClassScope)currentScope).referenceType().binding, importedPrefixesList);
            }
            currentScope = currentScope.parent;
        }
        CompilationUnitScope cuScope = (CompilationUnitScope)currentScope;
        String packageName = new String(CharOperation.concatWith(cuScope.currentPackageName, '.'));
        if (packageName.length() > 0) {
            importedPrefixesList.add(packageName + ".");
        }
        ImportBinding[] imports = cuScope.imports;
        for (int i = 0; i < imports.length; ++i) {
            ImportBinding importBinding = imports[i];
            String importName = new String(CharOperation.concatWith(importBinding.compoundName, '.'));
            if (importBinding.onDemand) {
                importedPrefixesList.add(importName + ".");
                continue;
            }
            importedNamesList.add(importName);
        }
        SourceTypeBinding[] topTypes = cuScope.topLevelTypes;
        for (int i = 0; i < topTypes.length; ++i) {
            importedNamesList.add(EclipseFactory.fromBinding(topTypes[i]).getName());
        }
        this.importedNames = importedNamesList.toArray(new String[importedNamesList.size()]);
        this.importedPrefixes = importedPrefixesList.toArray(new String[importedPrefixesList.size()]);
    }

    private void addClassAndParentsToPrefixes(ReferenceBinding binding, List importedPrefixesList) {
        if (binding == null) {
            return;
        }
        importedPrefixesList.add(EclipseFactory.fromBinding(binding).getName() + "$");
        this.addClassAndParentsToPrefixes(binding.superclass(), importedPrefixesList);
        ReferenceBinding[] superinterfaces = binding.superInterfaces();
        if (superinterfaces != null) {
            for (int i = 0; i < superinterfaces.length; ++i) {
                this.addClassAndParentsToPrefixes(superinterfaces[i], importedPrefixesList);
            }
        }
    }

    public String[] getImportedNames() {
        this.computeImports();
        return this.importedNames;
    }

    public String[] getImportedPrefixes() {
        this.computeImports();
        return this.importedPrefixes;
    }

    public FormalBinding lookupFormal(String name) {
        int len = this.bindings.length;
        for (int i = 0; i < len; ++i) {
            if (!this.bindings[i].getName().equals(name)) continue;
            return this.bindings[i];
        }
        return null;
    }

    public FormalBinding getFormal(int i) {
        return this.bindings[i];
    }

    public int getFormalCount() {
        return this.bindings.length;
    }

    public ISourceLocation makeSourceLocation(IHasPosition location) {
        return new EclipseSourceLocation(this.scope.problemReporter().referenceContext.compilationResult(), location.getStart(), location.getEnd());
    }

    public IMessageHandler getMessageHandler() {
        return this.world.getWorld().getMessageHandler();
    }

    public void message(IMessage.Kind kind, IHasPosition location1, IHasPosition location2, String message) {
        this.message(kind, location1, message);
        this.message(kind, location2, message);
    }

    public void message(IMessage.Kind kind, IHasPosition location, String message) {
        this.getMessageHandler().handleMessage(new Message(message, kind, null, this.makeSourceLocation(location)));
    }

    public World getWorld() {
        return this.world.getWorld();
    }

    public ResolvedTypeX getEnclosingType() {
        return this.enclosingType;
    }
}

