/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT.boardview3d;

import java.util.Enumeration;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import megamek.client.ui.AWT.boardview3d.ArtilleryAttackModel;
import megamek.client.ui.AWT.boardview3d.AttackModel;
import megamek.client.ui.AWT.boardview3d.TileTextureManager;
import megamek.client.ui.AWT.boardview3d.ViewTransform;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.IGame;
import megamek.common.Mounted;
import megamek.common.Player;
import megamek.common.Targetable;
import megamek.common.WeaponType;
import megamek.common.actions.ArtilleryAttackAction;
import megamek.common.actions.AttackAction;
import megamek.common.actions.EntityAction;
import megamek.common.actions.PhysicalAttackAction;

class AttackGroup
extends BranchGroup {
    IGame game;
    ViewTransform currentView;
    TileTextureManager tileManager;
    Entity selectedEntity;
    Mounted selectedWeapon;

    public AttackGroup(IGame iGame, TileTextureManager tileTextureManager, ViewTransform viewTransform) {
        this.game = iGame;
        this.currentView = viewTransform;
        this.tileManager = tileTextureManager;
        this.setCapability(14);
        this.setCapability(13);
        this.setPickable(false);
    }

    public void add(AttackAction attackAction) {
        if (attackAction instanceof ArtilleryAttackAction) {
            this.add((ArtilleryAttackAction)attackAction);
            return;
        }
        Entity entity = this.game.getEntity(attackAction.getEntityId());
        Targetable targetable = this.game.getTarget(attackAction.getTargetType(), attackAction.getTargetId());
        if (entity == null || targetable == null || targetable.getTargetType() == 11 || targetable.getPosition() == null || entity.getPosition() == null || !this.game.getBoard().contains(entity.getPosition()) || !this.game.getBoard().contains(targetable.getPosition())) {
            return;
        }
        AttackModel attackModel = null;
        attackModel = new AttackModel(attackAction, entity, targetable, this.game);
        attackModel.add(attackAction, this.currentView);
        this.addChild((Node)attackModel);
    }

    public void add(ArtilleryAttackAction artilleryAttackAction) {
        this.addChild((Node)new ArtilleryAttackModel(2, artilleryAttackAction, this.game, this.tileManager));
    }

    public void remove(Entity entity) {
        Enumeration enumeration = this.getAllChildren();
        while (enumeration.hasMoreElements()) {
            BranchGroup branchGroup = (BranchGroup)enumeration.nextElement();
            AttackAction attackAction = (AttackAction)branchGroup.getUserData();
            if (attackAction == null || attackAction.getEntityId() != entity.getId()) continue;
            branchGroup.detach();
        }
    }

    public void clear() {
        Enumeration enumeration = this.getAllChildren();
        while (enumeration.hasMoreElements()) {
            ((BranchGroup)enumeration.nextElement()).detach();
        }
    }

    public void update() {
        Object object;
        this.clear();
        for (EntityAction object2 : this.game.getActionsVector()) {
            if (!(object2 instanceof AttackAction)) continue;
            this.add((AttackAction)object2);
        }
        for (AttackAction attackAction : this.game.getChargesVector()) {
            if (!(attackAction instanceof PhysicalAttackAction)) continue;
            this.add(attackAction);
        }
        if (this.selectedWeapon != null && this.selectedEntity != null) {
            object = this.game.getBoard();
            Coords coords = new Coords();
            coords.y = 0;
            while (coords.y < object.getHeight()) {
                coords.x = 0;
                while (coords.x < object.getWidth()) {
                    if (this.selectedEntity.getOwner().getArtyAutoHitHexes().contains(coords)) {
                        this.addChild((Node)new ArtilleryAttackModel(0, coords, this.game, this.tileManager));
                    } else if (this.selectedEntity.aTracker.getModifier(this.selectedWeapon, coords) != 0) {
                        this.addChild((Node)new ArtilleryAttackModel(1, coords, this.game, this.tileManager));
                    }
                    ++coords.x;
                }
                ++coords.y;
            }
        }
        object = this.game.getArtilleryAttacks();
        while (object.hasMoreElements()) {
            this.add((ArtilleryAttackAction)object.nextElement());
        }
    }

    void setView(ViewTransform viewTransform) {
        this.currentView = viewTransform;
        this.update();
    }

    void setSelected(Entity entity, Mounted mounted, Player player) {
        if (!(mounted != null && entity != null && entity.getOwner().equals(player) && entity.getEquipmentNum(mounted) != -1 && mounted.getType() instanceof WeaponType && mounted.getType().hasFlag(32768L))) {
            mounted = null;
            entity = null;
        }
        if (entity == null != (this.selectedEntity == null) || entity != null && entity.getId() != this.selectedEntity.getId() || mounted != this.selectedWeapon) {
            this.selectedEntity = entity;
            this.selectedWeapon = mounted;
            this.update();
        }
    }
}

